import{s as tl,o as al,n as Sa}from"../chunks/scheduler.c57aa7ef.js";import{S as sl,i as ll,g as i,s as l,r as p,A as nl,h as o,f as a,c as n,j as Os,u as d,x as r,k as el,y as il,a as s,v as m,d as f,t as h,w as c}from"../chunks/index.394f8801.js";import{T as Qa}from"../chunks/Tip.23dfb1a9.js";import{C as w}from"../chunks/CodeBlock.b5488637.js";import{H as y,E as ol}from"../chunks/index.70157020.js";function rl(M){let u,b='Starting from PEFT verion v0.12.0, PEFT automatically promotes the dtype of adapter weights from <code>torch.float16</code> and <code>torch.bfloat16</code> to <code>torch.float32</code> where appropriate. To <em>prevent</em> this behavior, you can pass <code>autocast_adapter_dtype=False</code> to <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">~get_peft_model()</a>, to <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.from_pretrained">from_pretrained()</a>, and to <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>.';return{c(){u=i("p"),u.innerHTML=b},l(g){u=o(g,"P",{"data-svelte-h":!0}),r(u)!=="svelte-y2m5zt"&&(u.innerHTML=b)},m(g,T){s(g,u,T)},p:Sa,d(g){g&&a(u)}}}function pl(M){let u,b="As an example, when loading a model that is using the DeBERTa architecture for sequence classification, you’ll see a warning that the following weights are newly initialized: <code>[&#39;classifier.bias&#39;, &#39;classifier.weight&#39;, &#39;pooler.dense.bias&#39;, &#39;pooler.dense.weight&#39;]</code>. From this, it follows that the <code>classifier</code> and <code>pooler</code> layers should be added to: <code>modules_to_save=[&quot;classifier&quot;, &quot;pooler&quot;]</code>.";return{c(){u=i("p"),u.innerHTML=b},l(g){u=o(g,"P",{"data-svelte-h":!0}),r(u)!=="svelte-1r4u1vb"&&(u.innerHTML=b)},m(g,T){s(g,u,T)},p:Sa,d(g){g&&a(u)}}}function dl(M){let u,b="If this option works well across different use casese, it may become the default for adapter loading in the future.";return{c(){u=i("p"),u.textContent=b},l(g){u=o(g,"P",{"data-svelte-h":!0}),r(u)!=="svelte-vb00fv"&&(u.textContent=b)},m(g,T){s(g,u,T)},p:Sa,d(g){g&&a(u)}}}function ml(M){let u,b,g,T,x,rt,j,Aa="If you encounter any issue when using PEFT, please check the following list of common issues and their solutions.",pt,k,dt,J,Da="Examples often rely on the most recent package versions, so please ensure they’re up-to-date. In particular, check the following package versions:",mt,Z,Ka="<li><code>peft</code></li> <li><code>transformers</code></li> <li><code>accelerate</code></li> <li><code>torch</code></li>",ft,C,Oa="In general, you can update the package version by running this command inside your Python environment:",ht,U,ct,W,es="Installing PEFT from source is useful for keeping up with the latest developments:",ut,B,gt,L,yt,F,wt,G,ts='This error probably occurred because the model was loaded with <code>torch_dtype=torch.float16</code> and then used in an automatic mixed precision (AMP) context, e.g. by setting <code>fp16=True</code> in the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> class from 🤗 Transformers. The reason is that when using AMP, trainable weights should never use fp16. To make this work without loading the whole model in fp32, add the following to your code:',bt,I,Tt,H,as='Alternatively, you can use the <a href="/docs/peft/main/en/package_reference/peft_model#peft.cast_mixed_precision_params">cast_mixed_precision_params()</a> function to correctly cast the weights:',Mt,R,_t,_,$t,P,vt,E,ss="Most PEFT methods, like LoRA, work by adding trainable adapter weights. By default, those weights are stored in float32 dtype (fp32), i.e. at a relatively high precision. Therefore, even if the base model is loaded in float16 (fp16) or bfloat16 (bf16), the adapter weights are float32. When the adapter results are calculated during the forward pass, the input will typically be in the dtype of the base model, thus it will be upcast to float32 if necessary, then cast back to the original dtype.",xt,X,ls='If you prefer to have the adapter weights in the lower precision of the base model, i.e. in float16 or bfloat16, you can pass <code>autocast_adapter_dtype=False</code> when creating the model (<a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">~get_peft_model()</a>) or loading the model (<a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.from_pretrained">from_pretrained()</a>). There are some advantages and disadvantages to this:',jt,V,ns="Advantages of half precision adapter:",kt,Y,is="<li>computation slightly faster</li> <li>slightly less memory</li> <li>smaller file size of checkpoint (half the size)</li>",Jt,z,os="Disadvantages of half precision adapter:",Zt,q,rs="<li>slightly worse loss</li> <li>higher risk of overflow or underflow</li>",Ct,N,ps="Note that for most use cases, overall runtime and memory cost will be determined by the size of the base model and by the dataset, while the dtype of the PEFT adapter will only have a small impact.",Ut,Q,Wt,S,ds='There can be several reasons for getting a poor result from a loaded PEFT model which are listed below. If you’re still unable to troubleshoot the problem, see if anyone else had a similar <a href="https://github.com/huggingface/peft/issues" rel="nofollow">issue</a> on GitHub, and if you can’t find any, open a new issue.',Bt,A,ms="When opening an issue, it helps a lot if you provide a minimal code example that reproduces the issue. Also, please report if the loaded model performs at the same level as the model did before fine-tuning, if it performs at a random level, or if it is only slightly worse than expected. This information helps us identify the problem more quickly.",Lt,D,Ft,K,fs="If your model outputs are not exactly the same as previous runs, there could be an issue with random elements. For example:",Gt,O,hs='<li>please ensure it is in <code>.eval()</code> mode, which is important, for instance, if the model uses dropout</li> <li>if you use <a href="https://huggingface.co/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate" rel="nofollow">generate</a> on a language model, there could be random sampling, so obtaining the same result requires setting a random seed</li> <li>if you used quantization and merged the weights, small deviations are expected due to rounding errors</li>',It,ee,Ht,te,cs='Please ensure that you load the model correctly. A common error is trying to load a <em>trained</em> model with <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> which is incorrect. Instead, the loading code should look like this:',Rt,ae,Pt,se,Et,le,us="For some tasks, it is important to correctly configure <code>modules_to_save</code> in the config to account for randomly initialized layers.",Xt,ne,gs="As an example, this is necessary if you use LoRA to fine-tune a language model for sequence classification because 🤗 Transformers adds a randomly initialized classification head on top of the model. If you do not add this layer to <code>modules_to_save</code>, the classification head won’t be saved. The next time you load the model, you’ll get a <em>different</em> randomly initialized classification head, resulting in completely different results.",Vt,ie,ys="PEFT tries to correctly guess the <code>modules_to_save</code> if you provide the <code>task_type</code> argument in the config. This should work for transformers models that follow the standard naming scheme. It is always a good idea to double check though because we can’t guarantee all models follow the naming scheme.",Yt,oe,ws="When you load a transformers model that has randomly initialized layers, you should see a warning along the lines of:",zt,re,qt,pe,bs="The mentioned layers should be added to <code>modules_to_save</code> in the config to avoid the described problem.",Nt,$,Qt,de,St,me,Ts="For many language fine-tuning tasks, extending the model’s vocabulary is necessary since new tokens are being introduced. This requires extending the embedding layer to account for the new tokens and also storing the embedding layer in addition to the adapter weights when saving the adapter.",At,fe,Ms="Save the embedding layer by adding it to the <code>target_modules</code> of the config. The embedding layer name must follow the standard naming scheme from Transformers. For example, the Mistral config could look like this:",Dt,he,Kt,ce,_s='Once added to <code>target_modules</code>, PEFT automatically stores the embedding layer when saving the adapter if the model has the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.get_input_embeddings" rel="nofollow">get_input_embeddings</a> and <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.get_output_embeddings" rel="nofollow">get_output_embeddings</a>. This is generally the case for Transformers models.',Ot,ue,$s="If the model’s embedding layer doesn’t follow the Transformer’s naming scheme, you can still save it by manually passing <code>save_embedding_layers=True</code> when saving the adapter:",ea,ge,ta,ye,vs="For inference, load the base model first and resize it the same way you did before you trained the model. After you’ve resized the base model, you can load the PEFT checkpoint.",aa,we,xs='For a complete example, please check out <a href="https://github.com/huggingface/peft/blob/main/examples/causal_language_modeling/peft_lora_clm_with_additional_tokens.ipynb" rel="nofollow">this notebook</a>.',sa,be,la,Te,js="When you load your PEFT model which has been trained on a task (for example, classification), you may get a warning like:",na,Me,ks="<p>Some weights of LlamaForSequenceClassification were not initialized from the model checkpoint at meta-llama/Llama-3.2-1B and are newly initialized: [‘score.weight’]. You should probably TRAIN this model on a down-stream task to be able to use it for predictions and inference.</p>",ia,_e,Js="Although this looks scary, it is most likely nothing to worry about. This warning comes from Transformers, and it isn’t a PEFT specific warning. It lets you know that a randomly initialized classification head (<code>score</code>) is attached to the base model, and the head must be trained to produce sensible predictions.",oa,$e,Zs="When you get this warning <em>before</em> training the model, PEFT automatically takes care of making the classification head trainable if you correctly passed the <code>task_type</code> argument to the PEFT config.",ra,ve,pa,xe,Cs="If your classification head does not follow the usual naming conventions from Transformers (which is rare), you have to explicitly tell PEFT the name of the head in <code>modules_to_save</code>.",da,je,ma,ke,Us="To check the name of the classification head, print the model and it should be the last module.",fa,Je,Ws="If you get this warning from your inference code, i.e. <em>after</em> training the model, when you load the PEFT model, you always have to load the Transformers model first. Since Transformers does not know that you will load PEFT weights afterwards, it still gives the warning.",ha,Ze,Bs="As always, it is best practice to ensure the model works correctly for inference by running some validation on it.",ca,Ce,ua,Ue,Ls='Sometimes a PEFT model can end up in a bad state, especially when handling multiple adapters. There can be some confusion around what adapters exist, which one is active, which one is merged, etc. To help investigate this issue, call the <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.get_layer_status">get_layer_status()</a> and the <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.get_model_status">get_model_status()</a> methods.',ga,We,Fs='The <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.get_layer_status">get_layer_status()</a> method gives you a detailed overview of each targeted layer’s active, merged, and available adapters.',ya,Be,wa,Le,Gs="In the model state output, you should look out for entries that say <code>&quot;irregular&quot;</code>. This means PEFT detected an inconsistent state in the model. For instance, if <code>merged_adapters=&quot;irregular&quot;</code>, it means that for at least one adapter, it was merged on some target modules but not on others. The inference results will most likely be incorrect as a result.",ba,Fe,Is="The best way to resolve this issue is to reload the whole model and adapter checkpoint(s). Ensure that you don’t perform any incorrect operations on the model, e.g. manually merging adapters on some modules but not others.",Ta,Ge,Hs="Convert the layer status into a pandas <code>DataFrame</code> for an easier visual inspection.",Ma,Ie,_a,He,Rs='It is possible to get this information for non-PEFT models if they are using PEFT layers under the hood, but some information like the <code>base_model_type</code> or the <code>peft_types</code> cannot be determined in that case. As an example, you can call this on a <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">diffusers</a> model like so:',$a,Re,va,Pe,xa,Ee,ja,Xe,Ps='Loading adapters like LoRA weights should generally be fast compared to loading the base model. However, there can be use cases where the adapter weights are quite large or where users need to load a large number of adapters — the loading time can add up in this case. The reason for this is that the adapter weights are first initialized and then overridden by the loaded weights, which is wasteful. To speed up the loading time, you can pass the <code>low_cpu_mem_usage=True</code> argument to <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.from_pretrained">from_pretrained()</a> and <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>.',ka,v,Ja,Ve,Za,Ye,Ca,ze,Es="When loading a trained PEFT model where the base model uses batch norm (e.g. <code>torch.nn.BatchNorm1d</code> or <code>torch.nn.BatchNorm2d</code>), you may find that you cannot reproduce the exact same outputs. This is because the batch norm layers keep track of running stats during training, but these stats are not part of the PEFT checkpoint. Therefore, when you load the PEFT model, the running stats of the base model will be used (i.e. from before training with PEFT).",Ua,qe,Xs="Depending on your use case, this may not be a big deal. If, however, you need your outputs to be 100% reproducible, you can achieve this by adding the batch norm layers to <code>modules_to_save</code>. Below is an example of this using resnet and LoRA. Notice that we set <code>modules_to_save=[&quot;classifier&quot;, &quot;normalization&quot;]</code>. We need the <code>&quot;classifier&quot;</code> argument because our task is image classification, and we add the <code>&quot;normalization&quot;</code> argument to ensure that the batch norm layers are saved in the PEFT checkpoint.",Wa,Ne,Ba,Qe,Vs="Depending on the type of model you use, the batch norm layers could have different names than <code>&quot;normalization&quot;</code>, so please ensure that the name matches your model architecture.",La,Se,Fa,Ae,Ga,De,Ys="When you encounter an error like the one shown below, it means the adapter you’re trying to load was trained with a more recent version of PEFT than the version you have installed on your system.",Ia,Ke,Ha,Oe,zs="The best way to resolve this issue is to install the latest PEFT version:",Ra,et,Pa,tt,qs="If the adapter was trained from a source install of PEFT (an unreleased version of PEFT), then you also need to install PEFT from source.",Ea,at,Xa,st,Ns="If it is not possible for you to upgrade PEFT, there is a workaround you can try.",Va,lt,Qs="Assume the error message says that the unknown keyword argument is named <code>foobar</code>. Search inside the <code>adapter_config.json</code> of this PEFT adapter for the <code>foobar</code> entry and delete it from the file. Then save the file and try loading the model again.",Ya,nt,Ss="This solution works most of the time. As long as it is the default value for <code>foobar</code>, it can be ignored. However, when it is set to some other value, you will get incorrect results. Upgrading PEFT is the recommended solution.",za,it,qa,ot,Na;return x=new y({props:{title:"Troubleshooting",local:"troubleshooting",headingTag:"h1"}}),k=new y({props:{title:"Examples don’t work",local:"examples-dont-work",headingTag:"h2"}}),U=new w({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwLVUlMjAlM0NwYWNrYWdlX25hbWUlM0U=",highlighted:"python -m pip install -U &lt;package_name&gt;",wrap:!1}}),B=new w({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwZ2l0JTJCaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZwZWZ0",highlighted:"python -m pip install git+https://github.com/huggingface/peft",wrap:!1}}),L=new y({props:{title:"Dtype-related issues",local:"dtype-related-issues",headingTag:"h2"}}),F=new y({props:{title:"ValueError: Attempting to unscale FP16 gradients",local:"valueerror-attempting-to-unscale-fp16-gradients",headingTag:"h3"}}),I=new w({props:{code:"cGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKC4uLiklMEElMEElMjMlMjBhZGQlMjB0aGlzJTNBJTBBZm9yJTIwcGFyYW0lMjBpbiUyMG1vZGVsLnBhcmFtZXRlcnMoKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwcGFyYW0ucmVxdWlyZXNfZ3JhZCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhcmFtLmRhdGElMjAlM0QlMjBwYXJhbS5kYXRhLmZsb2F0KCklMEElMEElMjMlMjBwcm9jZWVkJTIwYXMlMjB1c3VhbCUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKG1vZGVsJTNEcGVmdF9tb2RlbCUyQyUyMGZwMTYlM0RUcnVlJTJDJTIwLi4uKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`peft_model = get_peft_model(...)

<span class="hljs-comment"># add this:</span>
<span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.parameters():
    <span class="hljs-keyword">if</span> param.requires_grad:
        param.data = param.data.<span class="hljs-built_in">float</span>()

<span class="hljs-comment"># proceed as usual</span>
trainer = Trainer(model=peft_model, fp16=<span class="hljs-literal">True</span>, ...)
trainer.train()`,wrap:!1}}),R=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBjYXN0X21peGVkX3ByZWNpc2lvbl9wYXJhbXMlMEElMEFwZWZ0X21vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwoLi4uKSUwQWNhc3RfbWl4ZWRfcHJlY2lzaW9uX3BhcmFtcyhwZWZ0X21vZGVsJTJDJTIwZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUwQSUyMyUyMHByb2NlZWQlMjBhcyUyMHVzdWFsJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIobW9kZWwlM0RwZWZ0X21vZGVsJTJDJTIwZnAxNiUzRFRydWUlMkMlMjAuLi4pJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> cast_mixed_precision_params

peft_model = get_peft_model(...)
cast_mixed_precision_params(peft_model, dtype=torch.float16)

<span class="hljs-comment"># proceed as usual</span>
trainer = Trainer(model=peft_model, fp16=<span class="hljs-literal">True</span>, ...)
trainer.train()`,wrap:!1}}),_=new Qa({props:{$$slots:{default:[rl]},$$scope:{ctx:M}}}),P=new y({props:{title:"Selecting the dtype of the adapter",local:"selecting-the-dtype-of-the-adapter",headingTag:"h3"}}),Q=new y({props:{title:"Bad results from a loaded PEFT model",local:"bad-results-from-a-loaded-peft-model",headingTag:"h2"}}),D=new y({props:{title:"Random deviations",local:"random-deviations",headingTag:"h3"}}),ee=new y({props:{title:"Incorrectly loaded model",local:"incorrectly-loaded-model",headingTag:"h3"}}),ae=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMkMlMjBQZWZ0Q29uZmlnJTBBJTBBYmFzZV9tb2RlbCUyMCUzRCUyMC4uLiUyMCUyMCUyMyUyMHRvJTIwbG9hZCUyMHRoZSUyMGJhc2UlMjBtb2RlbCUyQyUyMHVzZSUyMHRoZSUyMHNhbWUlMjBjb2RlJTIwYXMlMjB3aGVuJTIweW91JTIwdHJhaW5lZCUyMGl0JTBBY29uZmlnJTIwJTNEJTIwUGVmdENvbmZpZy5mcm9tX3ByZXRyYWluZWQocGVmdF9tb2RlbF9pZCklMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel, PeftConfig

base_model = ...  <span class="hljs-comment"># to load the base model, use the same code as when you trained it</span>
config = PeftConfig.from_pretrained(peft_model_id)
peft_model = PeftModel.from_pretrained(base_model, peft_model_id)`,wrap:!1}}),se=new y({props:{title:"Randomly initialized layers",local:"randomly-initialized-layers",headingTag:"h3"}}),re=new w({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMCUzQ01PREVMJTNFJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwJTNDSUQlM0UlMjBhbmQlMjBhcmUlMjBuZXdseSUyMGluaXRpYWxpemVkJTNBJTIwJTVCJTNDTEFZRVJfTkFNRVMlM0UlNUQuJTBBWW91JTIwc2hvdWxkJTIwcHJvYmFibHklMjBUUkFJTiUyMHRoaXMlMjBtb2RlbCUyMG9uJTIwYSUyMGRvd24tc3RyZWFtJTIwdGFzayUyMHRvJTIwYmUlMjBhYmxlJTIwdG8lMjB1c2UlMjBpdCUyMGZvciUyMHByZWRpY3Rpb25zJTIwYW5kJTIwaW5mZXJlbmNlLg==",highlighted:`<span class="hljs-keyword">Some</span> weights <span class="hljs-keyword">of</span> &lt;MODEL&gt; were <span class="hljs-keyword">not</span> initialized <span class="hljs-keyword">from</span> the model <span class="hljs-keyword">checkpoint</span> at &lt;ID&gt; <span class="hljs-keyword">and</span> are newly initialized: [&lt;LAYER_NAMES&gt;].
You should probably TRAIN this model <span class="hljs-keyword">on</span> a down-stream task <span class="hljs-keyword">to</span> be able <span class="hljs-keyword">to</span> use it <span class="hljs-keyword">for</span> predictions <span class="hljs-keyword">and</span> inference.`,wrap:!1}}),$=new Qa({props:{$$slots:{default:[pl]},$$scope:{ctx:M}}}),de=new y({props:{title:"Extending the vocabulary",local:"extending-the-vocabulary",headingTag:"h3"}}),he=new w({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyguLi4lMkMlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMmVtYmVkX3Rva2VucyUyMiUyQyUyMCUyMmxtX2hlYWQlMjIlMkMlMjAlMjJxX3Byb2olMjIlMkMlMjAlMjJ2X3Byb2olMjIlNUQp",highlighted:'config = LoraConfig(..., target_modules=[<span class="hljs-string">&quot;embed_tokens&quot;</span>, <span class="hljs-string">&quot;lm_head&quot;</span>, <span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>])',wrap:!1}}),ge=new w({props:{code:"bW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbCguLi4pJTBBJTIzJTIwdHJhaW4lMjB0aGUlMjBtb2RlbCUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJteV9hZGFwdGVyJTIyJTJDJTIwc2F2ZV9lbWJlZGRpbmdfbGF5ZXJzJTNEVHJ1ZSk=",highlighted:`model = get_peft_model(...)
<span class="hljs-comment"># train the model</span>
model.save_pretrained(<span class="hljs-string">&quot;my_adapter&quot;</span>, save_embedding_layers=<span class="hljs-literal">True</span>)`,wrap:!1}}),be=new y({props:{title:"Getting a warning about “weights not being initialized from the model checkpoint”",local:"getting-a-warning-about-weights-not-being-initialized-from-the-model-checkpoint",headingTag:"h3"}}),ve=new w({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwVGFza1R5cGUlMEElMEFsb3JhX2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcoLi4uJTJDJTIwdGFza190eXBlJTNEVGFza1R5cGUuU0VRX0NMUyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, TaskType

lora_config = LoraConfig(..., task_type=TaskType.SEQ_CLS)`,wrap:!1}}),je=new w({props:{code:"bG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiUyQyUyMG1vZHVsZXNfdG9fc2F2ZSUzRCU1QiUyMm5hbWUtb2YtY2xhc3NpZmljYXRpb24taGVhZCUyMiU1RCk=",highlighted:'lora_config = LoraConfig(..., modules_to_save=[<span class="hljs-string">&quot;name-of-classification-head&quot;</span>])',wrap:!1}}),Ce=new y({props:{title:"Check layer and model status",local:"check-layer-and-model-status",headingTag:"h3"}}),Be=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwZ2V0X3BlZnRfbW9kZWwlMkMlMjBMb3JhQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJnb29nbGUlMkZmbGFuLXQ1LXNtYWxsJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBMb3JhQ29uZmlnKCkpJTBBJTBBbW9kZWwuZ2V0X2xheWVyX3N0YXR1cygpJTBBJTBBbW9kZWwuZ2V0X21vZGVsX3N0YXR1cygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model, LoraConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;google/flan-t5-small&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = get_peft_model(model, LoraConfig())

<span class="hljs-meta">&gt;&gt;&gt; </span>model.get_layer_status()
[TunerLayerStatus(name=<span class="hljs-string">&#x27;model.encoder.block.0.layer.0.SelfAttention.q&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-literal">True</span>},
                  available_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>]),
 TunerLayerStatus(name=<span class="hljs-string">&#x27;model.encoder.block.0.layer.0.SelfAttention.v&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-literal">True</span>},
                  available_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>]),
...]

<span class="hljs-meta">&gt;&gt;&gt; </span>model.get_model_status()
TunerModelStatus(
    base_model_type=<span class="hljs-string">&#x27;T5Model&#x27;</span>,
    adapter_model_type=<span class="hljs-string">&#x27;LoraModel&#x27;</span>,
    peft_types={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-string">&#x27;LORA&#x27;</span>},
    trainable_params=<span class="hljs-number">344064</span>,
    total_params=<span class="hljs-number">60855680</span>,
    num_adapter_layers=<span class="hljs-number">48</span>,
    enabled=<span class="hljs-literal">True</span>,
    active_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
    merged_adapters=[],
    requires_grad={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-literal">True</span>},
    available_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
)`,wrap:!1}}),Ie=new w({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwYXNkaWN0JTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQWRmJTIwJTNEJTIwcGQuRGF0YUZyYW1lKGFzZGljdChsYXllciklMjBmb3IlMjBsYXllciUyMGluJTIwbW9kZWwuZ2V0X2xheWVyX3N0YXR1cygpKQ==",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> asdict
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

df = pd.DataFrame(asdict(layer) <span class="hljs-keyword">for</span> layer <span class="hljs-keyword">in</span> model.get_layer_status())`,wrap:!1}}),Re=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMGdldF9tb2RlbF9zdGF0dXMlMkMlMjBnZXRfbGF5ZXJfc3RhdHVzJTBBJTBBcGF0aCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBbG9yYV9pZCUyMCUzRCUyMCUyMnRha3VtYTEwNCUyRmxvcmEtdGVzdC10ZXh0LWVuY29kZXItbG9yYS10YXJnZXQlMjIlMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHBhdGglMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZS5sb2FkX2xvcmFfd2VpZ2h0cyhsb3JhX2lkJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYWRhcHRlci0xJTIyKSUwQXBpcGUubG9hZF9sb3JhX3dlaWdodHMobG9yYV9pZCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmFkYXB0ZXItMiUyMiklMEFwaXBlLnNldF9sb3JhX2RldmljZSglNUIlMjJhZGFwdGVyLTIlMjIlNUQlMkMlMjAlMjJjdWRhJTIyKSUwQWdldF9sYXllcl9zdGF0dXMocGlwZS50ZXh0X2VuY29kZXIpJTBBJTBBZ2V0X21vZGVsX3N0YXR1cyhwaXBlLnVuZXQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_model_status, get_layer_status

<span class="hljs-meta">&gt;&gt;&gt; </span>path = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>lora_id = <span class="hljs-string">&quot;takuma104/lora-test-text-encoder-lora-target&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(path, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.load_lora_weights(lora_id, adapter_name=<span class="hljs-string">&quot;adapter-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.load_lora_weights(lora_id, adapter_name=<span class="hljs-string">&quot;adapter-2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.set_lora_device([<span class="hljs-string">&quot;adapter-2&quot;</span>], <span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>get_layer_status(pipe.text_encoder)
[TunerLayerStatus(name=<span class="hljs-string">&#x27;text_model.encoder.layers.0.self_attn.k_proj&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;adapter-2&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>: <span class="hljs-literal">True</span>},
                  available_adapters=[<span class="hljs-string">&#x27;adapter-1&#x27;</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>],
                  devices={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: [<span class="hljs-string">&#x27;cpu&#x27;</span>], <span class="hljs-string">&#x27;adapter-2&#x27;</span>: [<span class="hljs-string">&#x27;cuda&#x27;</span>]}),
 TunerLayerStatus(name=<span class="hljs-string">&#x27;text_model.encoder.layers.0.self_attn.v_proj&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;adapter-2&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>: <span class="hljs-literal">True</span>},
                  devices={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: [<span class="hljs-string">&#x27;cpu&#x27;</span>], <span class="hljs-string">&#x27;adapter-2&#x27;</span>: [<span class="hljs-string">&#x27;cuda&#x27;</span>]}),
...]

<span class="hljs-meta">&gt;&gt;&gt; </span>get_model_status(pipe.unet)
TunerModelStatus(
    base_model_type=<span class="hljs-string">&#x27;other&#x27;</span>,
    adapter_model_type=<span class="hljs-string">&#x27;None&#x27;</span>,
    peft_types={},
    trainable_params=<span class="hljs-number">797184</span>,
    total_params=<span class="hljs-number">861115332</span>,
    num_adapter_layers=<span class="hljs-number">128</span>,
    enabled=<span class="hljs-literal">True</span>,
    active_adapters=[<span class="hljs-string">&#x27;adapter-2&#x27;</span>],
    merged_adapters=[],
    requires_grad={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>: <span class="hljs-literal">True</span>},
    available_adapters=[<span class="hljs-string">&#x27;adapter-1&#x27;</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>],
    devices={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: [<span class="hljs-string">&#x27;cpu&#x27;</span>], <span class="hljs-string">&#x27;adapter-2&#x27;</span>: [<span class="hljs-string">&#x27;cuda&#x27;</span>]},
)`,wrap:!1}}),Pe=new y({props:{title:"Speed",local:"speed",headingTag:"h2"}}),Ee=new y({props:{title:"Loading adapter weights is slow",local:"loading-adapter-weights-is-slow",headingTag:"h3"}}),v=new Qa({props:{$$slots:{default:[dl]},$$scope:{ctx:M}}}),Ve=new y({props:{title:"Reproducibility",local:"reproducibility",headingTag:"h2"}}),Ye=new y({props:{title:"Models using batch norm",local:"models-using-batch-norm",headingTag:"h3"}}),Ne=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMExvcmFDb25maWclMkMlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybWljcm9zb2Z0JTJGcmVzbmV0LTE4JTIyJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKHNlbGYubW9kZWxfaWQpJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMmNvbnZvbHV0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kdWxlc190b19zYXZlJTNEJTVCJTIyY2xhc3NpZmllciUyMiUyQyUyMCUyMm5vcm1hbGl6YXRpb24lMjIlNUQlMkMlMEEpJTJD",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

model_id = <span class="hljs-string">&quot;microsoft/resnet-18&quot;</span>
base_model = AutoModelForImageClassification.from_pretrained(self.model_id)
config = LoraConfig(
    target_modules=[<span class="hljs-string">&quot;convolution&quot;</span>],
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>, <span class="hljs-string">&quot;normalization&quot;</span>],
),`,wrap:!1}}),Se=new y({props:{title:"Version mismatch",local:"version-mismatch",headingTag:"h2"}}),Ae=new y({props:{title:"Error while loading the config because of an unexpected keyword argument",local:"error-while-loading-the-config-because-of-an-unexpected-keyword-argument",headingTag:"h3"}}),Ke=new w({props:{code:"VHlwZUVycm9yJTNBJTIwTG9yYUNvbmZpZy5fX2luaXRfXygpJTIwZ290JTIwYW4lMjB1bmV4cGVjdGVkJTIwa2V5d29yZCUyMGFyZ3VtZW50JTIwJTNDYXJndW1lbnQtbmFtZSUzRQ==",highlighted:'TypeError: LoraConfig.__init__() got an unexpected keyword <span class="hljs-variable language_">argument</span> &lt;<span class="hljs-variable language_">argument</span>-name&gt;',wrap:!1}}),et=new w({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwLVUlMjBQRUZU",highlighted:"python -m pip install -U PEFT",wrap:!1}}),at=new w({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwLVUlMjBnaXQlMkJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRnBlZnQuZ2l0",highlighted:"python -m pip install -U git+https://github.com/huggingface/peft.git",wrap:!1}}),it=new ol({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/troubleshooting.md"}}),{c(){u=i("meta"),b=l(),g=i("p"),T=l(),p(x.$$.fragment),rt=l(),j=i("p"),j.textContent=Aa,pt=l(),p(k.$$.fragment),dt=l(),J=i("p"),J.textContent=Da,mt=l(),Z=i("ul"),Z.innerHTML=Ka,ft=l(),C=i("p"),C.textContent=Oa,ht=l(),p(U.$$.fragment),ct=l(),W=i("p"),W.textContent=es,ut=l(),p(B.$$.fragment),gt=l(),p(L.$$.fragment),yt=l(),p(F.$$.fragment),wt=l(),G=i("p"),G.innerHTML=ts,bt=l(),p(I.$$.fragment),Tt=l(),H=i("p"),H.innerHTML=as,Mt=l(),p(R.$$.fragment),_t=l(),p(_.$$.fragment),$t=l(),p(P.$$.fragment),vt=l(),E=i("p"),E.textContent=ss,xt=l(),X=i("p"),X.innerHTML=ls,jt=l(),V=i("p"),V.textContent=ns,kt=l(),Y=i("ul"),Y.innerHTML=is,Jt=l(),z=i("p"),z.textContent=os,Zt=l(),q=i("ul"),q.innerHTML=rs,Ct=l(),N=i("p"),N.textContent=ps,Ut=l(),p(Q.$$.fragment),Wt=l(),S=i("p"),S.innerHTML=ds,Bt=l(),A=i("p"),A.textContent=ms,Lt=l(),p(D.$$.fragment),Ft=l(),K=i("p"),K.textContent=fs,Gt=l(),O=i("ol"),O.innerHTML=hs,It=l(),p(ee.$$.fragment),Ht=l(),te=i("p"),te.innerHTML=cs,Rt=l(),p(ae.$$.fragment),Pt=l(),p(se.$$.fragment),Et=l(),le=i("p"),le.innerHTML=us,Xt=l(),ne=i("p"),ne.innerHTML=gs,Vt=l(),ie=i("p"),ie.innerHTML=ys,Yt=l(),oe=i("p"),oe.textContent=ws,zt=l(),p(re.$$.fragment),qt=l(),pe=i("p"),pe.innerHTML=bs,Nt=l(),p($.$$.fragment),Qt=l(),p(de.$$.fragment),St=l(),me=i("p"),me.textContent=Ts,At=l(),fe=i("p"),fe.innerHTML=Ms,Dt=l(),p(he.$$.fragment),Kt=l(),ce=i("p"),ce.innerHTML=_s,Ot=l(),ue=i("p"),ue.innerHTML=$s,ea=l(),p(ge.$$.fragment),ta=l(),ye=i("p"),ye.textContent=vs,aa=l(),we=i("p"),we.innerHTML=xs,sa=l(),p(be.$$.fragment),la=l(),Te=i("p"),Te.textContent=js,na=l(),Me=i("blockquote"),Me.innerHTML=ks,ia=l(),_e=i("p"),_e.innerHTML=Js,oa=l(),$e=i("p"),$e.innerHTML=Zs,ra=l(),p(ve.$$.fragment),pa=l(),xe=i("p"),xe.innerHTML=Cs,da=l(),p(je.$$.fragment),ma=l(),ke=i("p"),ke.textContent=Us,fa=l(),Je=i("p"),Je.innerHTML=Ws,ha=l(),Ze=i("p"),Ze.textContent=Bs,ca=l(),p(Ce.$$.fragment),ua=l(),Ue=i("p"),Ue.innerHTML=Ls,ga=l(),We=i("p"),We.innerHTML=Fs,ya=l(),p(Be.$$.fragment),wa=l(),Le=i("p"),Le.innerHTML=Gs,ba=l(),Fe=i("p"),Fe.textContent=Is,Ta=l(),Ge=i("p"),Ge.innerHTML=Hs,Ma=l(),p(Ie.$$.fragment),_a=l(),He=i("p"),He.innerHTML=Rs,$a=l(),p(Re.$$.fragment),va=l(),p(Pe.$$.fragment),xa=l(),p(Ee.$$.fragment),ja=l(),Xe=i("p"),Xe.innerHTML=Ps,ka=l(),p(v.$$.fragment),Ja=l(),p(Ve.$$.fragment),Za=l(),p(Ye.$$.fragment),Ca=l(),ze=i("p"),ze.innerHTML=Es,Ua=l(),qe=i("p"),qe.innerHTML=Xs,Wa=l(),p(Ne.$$.fragment),Ba=l(),Qe=i("p"),Qe.innerHTML=Vs,La=l(),p(Se.$$.fragment),Fa=l(),p(Ae.$$.fragment),Ga=l(),De=i("p"),De.textContent=Ys,Ia=l(),p(Ke.$$.fragment),Ha=l(),Oe=i("p"),Oe.textContent=zs,Ra=l(),p(et.$$.fragment),Pa=l(),tt=i("p"),tt.textContent=qs,Ea=l(),p(at.$$.fragment),Xa=l(),st=i("p"),st.textContent=Ns,Va=l(),lt=i("p"),lt.innerHTML=Qs,Ya=l(),nt=i("p"),nt.innerHTML=Ss,za=l(),p(it.$$.fragment),qa=l(),ot=i("p"),this.h()},l(e){const t=nl("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(a),b=n(e),g=o(e,"P",{}),Os(g).forEach(a),T=n(e),d(x.$$.fragment,e),rt=n(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-wwms7a"&&(j.textContent=Aa),pt=n(e),d(k.$$.fragment,e),dt=n(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-18nlz3r"&&(J.textContent=Da),mt=n(e),Z=o(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-ccv654"&&(Z.innerHTML=Ka),ft=n(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1cuqjyb"&&(C.textContent=Oa),ht=n(e),d(U.$$.fragment,e),ct=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-h5ykrw"&&(W.textContent=es),ut=n(e),d(B.$$.fragment,e),gt=n(e),d(L.$$.fragment,e),yt=n(e),d(F.$$.fragment,e),wt=n(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-oa0e54"&&(G.innerHTML=ts),bt=n(e),d(I.$$.fragment,e),Tt=n(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-p7trz1"&&(H.innerHTML=as),Mt=n(e),d(R.$$.fragment,e),_t=n(e),d(_.$$.fragment,e),$t=n(e),d(P.$$.fragment,e),vt=n(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1w3ww7i"&&(E.textContent=ss),xt=n(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-wkpq53"&&(X.innerHTML=ls),jt=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-3n96y7"&&(V.textContent=ns),kt=n(e),Y=o(e,"UL",{"data-svelte-h":!0}),r(Y)!=="svelte-1ghjkcl"&&(Y.innerHTML=is),Jt=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1yqgo19"&&(z.textContent=os),Zt=n(e),q=o(e,"UL",{"data-svelte-h":!0}),r(q)!=="svelte-pdypmd"&&(q.innerHTML=rs),Ct=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1gmj2pd"&&(N.textContent=ps),Ut=n(e),d(Q.$$.fragment,e),Wt=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-ns8zue"&&(S.innerHTML=ds),Bt=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-lfc2ft"&&(A.textContent=ms),Lt=n(e),d(D.$$.fragment,e),Ft=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-16feh"&&(K.textContent=fs),Gt=n(e),O=o(e,"OL",{"data-svelte-h":!0}),r(O)!=="svelte-1fvhlks"&&(O.innerHTML=hs),It=n(e),d(ee.$$.fragment,e),Ht=n(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-q1qqrd"&&(te.innerHTML=cs),Rt=n(e),d(ae.$$.fragment,e),Pt=n(e),d(se.$$.fragment,e),Et=n(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-5heszj"&&(le.innerHTML=us),Xt=n(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-c4824l"&&(ne.innerHTML=gs),Vt=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1ou3c35"&&(ie.innerHTML=ys),Yt=n(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1g4txs2"&&(oe.textContent=ws),zt=n(e),d(re.$$.fragment,e),qt=n(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1fbeum6"&&(pe.innerHTML=bs),Nt=n(e),d($.$$.fragment,e),Qt=n(e),d(de.$$.fragment,e),St=n(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-15igmai"&&(me.textContent=Ts),At=n(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1cgzlph"&&(fe.innerHTML=Ms),Dt=n(e),d(he.$$.fragment,e),Kt=n(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-kwgcwv"&&(ce.innerHTML=_s),Ot=n(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-ucua6z"&&(ue.innerHTML=$s),ea=n(e),d(ge.$$.fragment,e),ta=n(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-nkv7o7"&&(ye.textContent=vs),aa=n(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-a0ibfa"&&(we.innerHTML=xs),sa=n(e),d(be.$$.fragment,e),la=n(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-q2uzbp"&&(Te.textContent=js),na=n(e),Me=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(Me)!=="svelte-ray7nl"&&(Me.innerHTML=ks),ia=n(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1cejahg"&&(_e.innerHTML=Js),oa=n(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-m24cow"&&($e.innerHTML=Zs),ra=n(e),d(ve.$$.fragment,e),pa=n(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1c6v178"&&(xe.innerHTML=Cs),da=n(e),d(je.$$.fragment,e),ma=n(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-f59lgd"&&(ke.textContent=Us),fa=n(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-k7fvy1"&&(Je.innerHTML=Ws),ha=n(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-16spx00"&&(Ze.textContent=Bs),ca=n(e),d(Ce.$$.fragment,e),ua=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1f0hxdh"&&(Ue.innerHTML=Ls),ga=n(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1ygf8mz"&&(We.innerHTML=Fs),ya=n(e),d(Be.$$.fragment,e),wa=n(e),Le=o(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1gb1r7d"&&(Le.innerHTML=Gs),ba=n(e),Fe=o(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-19sfzdf"&&(Fe.textContent=Is),Ta=n(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-18r4lni"&&(Ge.innerHTML=Hs),Ma=n(e),d(Ie.$$.fragment,e),_a=n(e),He=o(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-17rnlhh"&&(He.innerHTML=Rs),$a=n(e),d(Re.$$.fragment,e),va=n(e),d(Pe.$$.fragment,e),xa=n(e),d(Ee.$$.fragment,e),ja=n(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1hc62kc"&&(Xe.innerHTML=Ps),ka=n(e),d(v.$$.fragment,e),Ja=n(e),d(Ve.$$.fragment,e),Za=n(e),d(Ye.$$.fragment,e),Ca=n(e),ze=o(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-yt67c7"&&(ze.innerHTML=Es),Ua=n(e),qe=o(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-wblxho"&&(qe.innerHTML=Xs),Wa=n(e),d(Ne.$$.fragment,e),Ba=n(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-1e3stb1"&&(Qe.innerHTML=Vs),La=n(e),d(Se.$$.fragment,e),Fa=n(e),d(Ae.$$.fragment,e),Ga=n(e),De=o(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-5zz36e"&&(De.textContent=Ys),Ia=n(e),d(Ke.$$.fragment,e),Ha=n(e),Oe=o(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-1dqw1qx"&&(Oe.textContent=zs),Ra=n(e),d(et.$$.fragment,e),Pa=n(e),tt=o(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-1k207nl"&&(tt.textContent=qs),Ea=n(e),d(at.$$.fragment,e),Xa=n(e),st=o(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-1jt6x31"&&(st.textContent=Ns),Va=n(e),lt=o(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-1a81pzz"&&(lt.innerHTML=Qs),Ya=n(e),nt=o(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1wt4m5g"&&(nt.innerHTML=Ss),za=n(e),d(it.$$.fragment,e),qa=n(e),ot=o(e,"P",{}),Os(ot).forEach(a),this.h()},h(){el(u,"name","hf:doc:metadata"),el(u,"content",fl)},m(e,t){il(document.head,u),s(e,b,t),s(e,g,t),s(e,T,t),m(x,e,t),s(e,rt,t),s(e,j,t),s(e,pt,t),m(k,e,t),s(e,dt,t),s(e,J,t),s(e,mt,t),s(e,Z,t),s(e,ft,t),s(e,C,t),s(e,ht,t),m(U,e,t),s(e,ct,t),s(e,W,t),s(e,ut,t),m(B,e,t),s(e,gt,t),m(L,e,t),s(e,yt,t),m(F,e,t),s(e,wt,t),s(e,G,t),s(e,bt,t),m(I,e,t),s(e,Tt,t),s(e,H,t),s(e,Mt,t),m(R,e,t),s(e,_t,t),m(_,e,t),s(e,$t,t),m(P,e,t),s(e,vt,t),s(e,E,t),s(e,xt,t),s(e,X,t),s(e,jt,t),s(e,V,t),s(e,kt,t),s(e,Y,t),s(e,Jt,t),s(e,z,t),s(e,Zt,t),s(e,q,t),s(e,Ct,t),s(e,N,t),s(e,Ut,t),m(Q,e,t),s(e,Wt,t),s(e,S,t),s(e,Bt,t),s(e,A,t),s(e,Lt,t),m(D,e,t),s(e,Ft,t),s(e,K,t),s(e,Gt,t),s(e,O,t),s(e,It,t),m(ee,e,t),s(e,Ht,t),s(e,te,t),s(e,Rt,t),m(ae,e,t),s(e,Pt,t),m(se,e,t),s(e,Et,t),s(e,le,t),s(e,Xt,t),s(e,ne,t),s(e,Vt,t),s(e,ie,t),s(e,Yt,t),s(e,oe,t),s(e,zt,t),m(re,e,t),s(e,qt,t),s(e,pe,t),s(e,Nt,t),m($,e,t),s(e,Qt,t),m(de,e,t),s(e,St,t),s(e,me,t),s(e,At,t),s(e,fe,t),s(e,Dt,t),m(he,e,t),s(e,Kt,t),s(e,ce,t),s(e,Ot,t),s(e,ue,t),s(e,ea,t),m(ge,e,t),s(e,ta,t),s(e,ye,t),s(e,aa,t),s(e,we,t),s(e,sa,t),m(be,e,t),s(e,la,t),s(e,Te,t),s(e,na,t),s(e,Me,t),s(e,ia,t),s(e,_e,t),s(e,oa,t),s(e,$e,t),s(e,ra,t),m(ve,e,t),s(e,pa,t),s(e,xe,t),s(e,da,t),m(je,e,t),s(e,ma,t),s(e,ke,t),s(e,fa,t),s(e,Je,t),s(e,ha,t),s(e,Ze,t),s(e,ca,t),m(Ce,e,t),s(e,ua,t),s(e,Ue,t),s(e,ga,t),s(e,We,t),s(e,ya,t),m(Be,e,t),s(e,wa,t),s(e,Le,t),s(e,ba,t),s(e,Fe,t),s(e,Ta,t),s(e,Ge,t),s(e,Ma,t),m(Ie,e,t),s(e,_a,t),s(e,He,t),s(e,$a,t),m(Re,e,t),s(e,va,t),m(Pe,e,t),s(e,xa,t),m(Ee,e,t),s(e,ja,t),s(e,Xe,t),s(e,ka,t),m(v,e,t),s(e,Ja,t),m(Ve,e,t),s(e,Za,t),m(Ye,e,t),s(e,Ca,t),s(e,ze,t),s(e,Ua,t),s(e,qe,t),s(e,Wa,t),m(Ne,e,t),s(e,Ba,t),s(e,Qe,t),s(e,La,t),m(Se,e,t),s(e,Fa,t),m(Ae,e,t),s(e,Ga,t),s(e,De,t),s(e,Ia,t),m(Ke,e,t),s(e,Ha,t),s(e,Oe,t),s(e,Ra,t),m(et,e,t),s(e,Pa,t),s(e,tt,t),s(e,Ea,t),m(at,e,t),s(e,Xa,t),s(e,st,t),s(e,Va,t),s(e,lt,t),s(e,Ya,t),s(e,nt,t),s(e,za,t),m(it,e,t),s(e,qa,t),s(e,ot,t),Na=!0},p(e,[t]){const As={};t&2&&(As.$$scope={dirty:t,ctx:e}),_.$set(As);const Ds={};t&2&&(Ds.$$scope={dirty:t,ctx:e}),$.$set(Ds);const Ks={};t&2&&(Ks.$$scope={dirty:t,ctx:e}),v.$set(Ks)},i(e){Na||(f(x.$$.fragment,e),f(k.$$.fragment,e),f(U.$$.fragment,e),f(B.$$.fragment,e),f(L.$$.fragment,e),f(F.$$.fragment,e),f(I.$$.fragment,e),f(R.$$.fragment,e),f(_.$$.fragment,e),f(P.$$.fragment,e),f(Q.$$.fragment,e),f(D.$$.fragment,e),f(ee.$$.fragment,e),f(ae.$$.fragment,e),f(se.$$.fragment,e),f(re.$$.fragment,e),f($.$$.fragment,e),f(de.$$.fragment,e),f(he.$$.fragment,e),f(ge.$$.fragment,e),f(be.$$.fragment,e),f(ve.$$.fragment,e),f(je.$$.fragment,e),f(Ce.$$.fragment,e),f(Be.$$.fragment,e),f(Ie.$$.fragment,e),f(Re.$$.fragment,e),f(Pe.$$.fragment,e),f(Ee.$$.fragment,e),f(v.$$.fragment,e),f(Ve.$$.fragment,e),f(Ye.$$.fragment,e),f(Ne.$$.fragment,e),f(Se.$$.fragment,e),f(Ae.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(at.$$.fragment,e),f(it.$$.fragment,e),Na=!0)},o(e){h(x.$$.fragment,e),h(k.$$.fragment,e),h(U.$$.fragment,e),h(B.$$.fragment,e),h(L.$$.fragment,e),h(F.$$.fragment,e),h(I.$$.fragment,e),h(R.$$.fragment,e),h(_.$$.fragment,e),h(P.$$.fragment,e),h(Q.$$.fragment,e),h(D.$$.fragment,e),h(ee.$$.fragment,e),h(ae.$$.fragment,e),h(se.$$.fragment,e),h(re.$$.fragment,e),h($.$$.fragment,e),h(de.$$.fragment,e),h(he.$$.fragment,e),h(ge.$$.fragment,e),h(be.$$.fragment,e),h(ve.$$.fragment,e),h(je.$$.fragment,e),h(Ce.$$.fragment,e),h(Be.$$.fragment,e),h(Ie.$$.fragment,e),h(Re.$$.fragment,e),h(Pe.$$.fragment,e),h(Ee.$$.fragment,e),h(v.$$.fragment,e),h(Ve.$$.fragment,e),h(Ye.$$.fragment,e),h(Ne.$$.fragment,e),h(Se.$$.fragment,e),h(Ae.$$.fragment,e),h(Ke.$$.fragment,e),h(et.$$.fragment,e),h(at.$$.fragment,e),h(it.$$.fragment,e),Na=!1},d(e){e&&(a(b),a(g),a(T),a(rt),a(j),a(pt),a(dt),a(J),a(mt),a(Z),a(ft),a(C),a(ht),a(ct),a(W),a(ut),a(gt),a(yt),a(wt),a(G),a(bt),a(Tt),a(H),a(Mt),a(_t),a($t),a(vt),a(E),a(xt),a(X),a(jt),a(V),a(kt),a(Y),a(Jt),a(z),a(Zt),a(q),a(Ct),a(N),a(Ut),a(Wt),a(S),a(Bt),a(A),a(Lt),a(Ft),a(K),a(Gt),a(O),a(It),a(Ht),a(te),a(Rt),a(Pt),a(Et),a(le),a(Xt),a(ne),a(Vt),a(ie),a(Yt),a(oe),a(zt),a(qt),a(pe),a(Nt),a(Qt),a(St),a(me),a(At),a(fe),a(Dt),a(Kt),a(ce),a(Ot),a(ue),a(ea),a(ta),a(ye),a(aa),a(we),a(sa),a(la),a(Te),a(na),a(Me),a(ia),a(_e),a(oa),a($e),a(ra),a(pa),a(xe),a(da),a(ma),a(ke),a(fa),a(Je),a(ha),a(Ze),a(ca),a(ua),a(Ue),a(ga),a(We),a(ya),a(wa),a(Le),a(ba),a(Fe),a(Ta),a(Ge),a(Ma),a(_a),a(He),a($a),a(va),a(xa),a(ja),a(Xe),a(ka),a(Ja),a(Za),a(Ca),a(ze),a(Ua),a(qe),a(Wa),a(Ba),a(Qe),a(La),a(Fa),a(Ga),a(De),a(Ia),a(Ha),a(Oe),a(Ra),a(Pa),a(tt),a(Ea),a(Xa),a(st),a(Va),a(lt),a(Ya),a(nt),a(za),a(qa),a(ot)),a(u),c(x,e),c(k,e),c(U,e),c(B,e),c(L,e),c(F,e),c(I,e),c(R,e),c(_,e),c(P,e),c(Q,e),c(D,e),c(ee,e),c(ae,e),c(se,e),c(re,e),c($,e),c(de,e),c(he,e),c(ge,e),c(be,e),c(ve,e),c(je,e),c(Ce,e),c(Be,e),c(Ie,e),c(Re,e),c(Pe,e),c(Ee,e),c(v,e),c(Ve,e),c(Ye,e),c(Ne,e),c(Se,e),c(Ae,e),c(Ke,e),c(et,e),c(at,e),c(it,e)}}}const fl='{"title":"Troubleshooting","local":"troubleshooting","sections":[{"title":"Examples don’t work","local":"examples-dont-work","sections":[],"depth":2},{"title":"Dtype-related issues","local":"dtype-related-issues","sections":[{"title":"ValueError: Attempting to unscale FP16 gradients","local":"valueerror-attempting-to-unscale-fp16-gradients","sections":[],"depth":3},{"title":"Selecting the dtype of the adapter","local":"selecting-the-dtype-of-the-adapter","sections":[],"depth":3}],"depth":2},{"title":"Bad results from a loaded PEFT model","local":"bad-results-from-a-loaded-peft-model","sections":[{"title":"Random deviations","local":"random-deviations","sections":[],"depth":3},{"title":"Incorrectly loaded model","local":"incorrectly-loaded-model","sections":[],"depth":3},{"title":"Randomly initialized layers","local":"randomly-initialized-layers","sections":[],"depth":3},{"title":"Extending the vocabulary","local":"extending-the-vocabulary","sections":[],"depth":3},{"title":"Getting a warning about “weights not being initialized from the model checkpoint”","local":"getting-a-warning-about-weights-not-being-initialized-from-the-model-checkpoint","sections":[],"depth":3},{"title":"Check layer and model status","local":"check-layer-and-model-status","sections":[],"depth":3}],"depth":2},{"title":"Speed","local":"speed","sections":[{"title":"Loading adapter weights is slow","local":"loading-adapter-weights-is-slow","sections":[],"depth":3}],"depth":2},{"title":"Reproducibility","local":"reproducibility","sections":[{"title":"Models using batch norm","local":"models-using-batch-norm","sections":[],"depth":3}],"depth":2},{"title":"Version mismatch","local":"version-mismatch","sections":[{"title":"Error while loading the config because of an unexpected keyword argument","local":"error-while-loading-the-config-because-of-an-unexpected-keyword-argument","sections":[],"depth":3}],"depth":2}],"depth":1}';function hl(M){return al(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bl extends sl{constructor(u){super(),ll(this,u,hl,ml,tl,{})}}export{bl as component};
