import{s as _e,o as ke,n as yl}from"../chunks/scheduler.c57aa7ef.js";import{S as Ze,i as Be,g as h,s as p,r as c,A as We,h as w,f as t,c as o,j as ge,u as d,x as b,k as se,y as Ge,a as s,v as u,d as y,t as J,w as T}from"../chunks/index.394f8801.js";import{T as Ce}from"../chunks/Tip.23dfb1a9.js";import{C as g}from"../chunks/CodeBlock.b5488637.js";import{H as cl,E as $e}from"../chunks/index.70157020.js";import{H as Ve,a as ae}from"../chunks/HfOption.41e9cb41.js";function Xe(C){let a,j='Some familiarity with the general process of training a causal language model would be really helpful and allow you to focus on the soft prompting methods. If you’re new, we recommend taking a look at the <a href="https://huggingface.co/docs/transformers/tasks/language_modeling" rel="nofollow">Causal language modeling</a> guide first from the Transformers documentation. When you’re ready, come back and see how easy it is to drop PEFT in to your training!';return{c(){a=h("p"),a.innerHTML=j},l(M){a=w(M,"P",{"data-svelte-h":!0}),b(a)!=="svelte-f4q9mt"&&(a.innerHTML=j)},m(M,r){s(M,a,r)},p:yl,d(M){M&&t(a)}}}function Ne(C){let a,j='Call the <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.print_trainable_parameters">print_trainable_parameters()</a> method to compare the number of trainable parameters of <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> versus the number of parameters in the base model!';return{c(){a=h("p"),a.innerHTML=j},l(M){a=w(M,"P",{"data-svelte-h":!0}),b(a)!=="svelte-1f9ty5f"&&(a.innerHTML=j)},m(M,r){s(M,a,r)},p:yl,d(M){M&&t(a)}}}function Re(C){let a,j='<a href="../conceptual_guides/prompting#p-tuning">P-tuning</a> adds a trainable embedding tensor where the prompt tokens can be added anywhere in the input sequence. Create a <a href="/docs/peft/main/en/package_reference/p_tuning#peft.PromptEncoderConfig">PromptEncoderConfig</a> with the task type, the number of virtual tokens to add and learn, and the hidden size of the encoder for learning the prompt parameters.',M,r,m;return r=new g({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQcm9tcHRFbmNvZGVyQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFwZWZ0X2NvbmZpZyUyMCUzRCUyMFByb21wdEVuY29kZXJDb25maWcodGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTJDJTIwbnVtX3ZpcnR1YWxfdG9rZW5zJTNEMjAlMkMlMjBlbmNvZGVyX2hpZGRlbl9zaXplJTNEMTI4KSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwMzAwJTJDMjg4JTIwJTdDJTdDJTIwYWxsJTIwcGFyYW1zJTNBJTIwNTU5JTJDNTE0JTJDODgwJTIwJTdDJTdDJTIwdHJhaW5hYmxlJTI1JTNBJTIwMC4wNTM2NjkzNTAxMzQxNzMzOCUyMg==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PromptEncoderConfig, get_peft_model

peft_config = PromptEncoderConfig(task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>, num_virtual_tokens=<span class="hljs-number">20</span>, encoder_hidden_size=<span class="hljs-number">128</span>)
model = get_peft_model(model, peft_config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 300,288 || all params: 559,514,880 || trainable%: 0.05366935013417338&quot;</span>`,wrap:!1}}),{c(){a=h("p"),a.innerHTML=j,M=p(),c(r.$$.fragment)},l(i){a=w(i,"P",{"data-svelte-h":!0}),b(a)!=="svelte-1xwh8g2"&&(a.innerHTML=j),M=o(i),d(r.$$.fragment,i)},m(i,n){s(i,a,n),s(i,M,n),u(r,i,n),m=!0},p:yl,i(i){m||(y(r.$$.fragment,i),m=!0)},o(i){J(r.$$.fragment,i),m=!1},d(i){i&&(t(a),t(M)),T(r,i)}}}function ve(C){let a,j='<a href="../conceptual_guides/prompting#prefix-tuning">Prefix tuning</a> adds task-specific parameters in all of the model layers, which are optimized by a separate feed-forward network. Create a <a href="/docs/peft/main/en/package_reference/prefix_tuning#peft.PrefixTuningConfig">PrefixTuningConfig</a> with the task type and number of virtual tokens to add and learn.',M,r,m;return r=new g({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQcmVmaXhUdW5pbmdDb25maWclMkMlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQXBlZnRfY29uZmlnJTIwJTNEJTIwUHJlZml4VHVuaW5nQ29uZmlnKHRhc2tfdHlwZSUzRCUyMkNBVVNBTF9MTSUyMiUyQyUyMG51bV92aXJ0dWFsX3Rva2VucyUzRDIwKSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwOTgzJTJDMDQwJTIwJTdDJTdDJTIwYWxsJTIwcGFyYW1zJTNBJTIwNTYwJTJDMTk3JTJDNjMyJTIwJTdDJTdDJTIwdHJhaW5hYmxlJTI1JTNBJTIwMC4xNzU0ODA5Mjc0MTY3MDE0JTIy",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PrefixTuningConfig, get_peft_model

peft_config = PrefixTuningConfig(task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>, num_virtual_tokens=<span class="hljs-number">20</span>)
model = get_peft_model(model, peft_config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 983,040 || all params: 560,197,632 || trainable%: 0.1754809274167014&quot;</span>`,wrap:!1}}),{c(){a=h("p"),a.innerHTML=j,M=p(),c(r.$$.fragment)},l(i){a=w(i,"P",{"data-svelte-h":!0}),b(a)!=="svelte-sqvmle"&&(a.innerHTML=j),M=o(i),d(r.$$.fragment,i)},m(i,n){s(i,a,n),s(i,M,n),u(r,i,n),m=!0},p:yl,i(i){m||(y(r.$$.fragment,i),m=!0)},o(i){J(r.$$.fragment,i),m=!1},d(i){i&&(t(a),t(M)),T(r,i)}}}function ze(C){let a,j='<a href="../conceptual_guides/prompting#prompt-tuning">Prompt tuning</a> formulates all tasks as a <em>generation</em> task and it adds a task-specific prompt to the input which is updated independently. The <code>prompt_tuning_init_text</code> parameter specifies how to finetune the model (in this case, it is classifying whether tweets are complaints or not). For the best results, the <code>prompt_tuning_init_text</code> should have the same number of tokens that should be predicted. To do this, you can set <code>num_virtual_tokens</code> to the number of tokens of the <code>prompt_tuning_init_text</code>.',M,r,m='Create a <a href="/docs/peft/main/en/package_reference/prompt_tuning#peft.PromptTuningConfig">PromptTuningConfig</a> with the task type, the initial prompt tuning text to train the model with, the number of virtual tokens to add and learn, and a tokenizer.',i,n,U;return n=new g({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQcm9tcHRUdW5pbmdDb25maWclMkMlMjBQcm9tcHRUdW5pbmdJbml0JTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFwcm9tcHRfdHVuaW5nX2luaXRfdGV4dCUyMCUzRCUyMCUyMkNsYXNzaWZ5JTIwaWYlMjB0aGUlMjB0d2VldCUyMGlzJTIwYSUyMGNvbXBsYWludCUyMG9yJTIwbm8lMjBjb21wbGFpbnQuJTVDbiUyMiUwQXBlZnRfY29uZmlnJTIwJTNEJTIwUHJvbXB0VHVuaW5nQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRCUyMkNBVVNBTF9MTSUyMiUyQyUwQSUyMCUyMCUyMCUyMHByb21wdF90dW5pbmdfaW5pdCUzRFByb21wdFR1bmluZ0luaXQuVEVYVCUyQyUwQSUyMCUyMCUyMCUyMG51bV92aXJ0dWFsX3Rva2VucyUzRGxlbih0b2tlbml6ZXIocHJvbXB0X3R1bmluZ19pbml0X3RleHQpJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUyQyUwQSUyMCUyMCUyMCUyMHByb21wdF90dW5pbmdfaW5pdF90ZXh0JTNEcHJvbXB0X3R1bmluZ19pbml0X3RleHQlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfbmFtZV9vcl9wYXRoJTNEJTIyYmlnc2NpZW5jZSUyRmJsb29tei01NjBtJTIyJTJDJTBBKSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwOCUyQzE5MiUyMCU3QyU3QyUyMGFsbCUyMHBhcmFtcyUzQSUyMDU1OSUyQzIyMiUyQzc4NCUyMCU3QyU3QyUyMHRyYWluYWJsZSUyNSUzQSUyMDAuMDAxNDY0ODkwMjQzMDk4NTM1OCUyMg==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PromptTuningConfig, PromptTuningInit, get_peft_model

prompt_tuning_init_text = <span class="hljs-string">&quot;Classify if the tweet is a complaint or no complaint.\\n&quot;</span>
peft_config = PromptTuningConfig(
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
    prompt_tuning_init=PromptTuningInit.TEXT,
    num_virtual_tokens=<span class="hljs-built_in">len</span>(tokenizer(prompt_tuning_init_text)[<span class="hljs-string">&quot;input_ids&quot;</span>]),
    prompt_tuning_init_text=prompt_tuning_init_text,
    tokenizer_name_or_path=<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>,
)
model = get_peft_model(model, peft_config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 8,192 || all params: 559,222,784 || trainable%: 0.0014648902430985358&quot;</span>`,wrap:!1}}),{c(){a=h("p"),a.innerHTML=j,M=p(),r=h("p"),r.innerHTML=m,i=p(),c(n.$$.fragment)},l(f){a=w(f,"P",{"data-svelte-h":!0}),b(a)!=="svelte-1vtqt32"&&(a.innerHTML=j),M=o(f),r=w(f,"P",{"data-svelte-h":!0}),b(r)!=="svelte-sm7geg"&&(r.innerHTML=m),i=o(f),d(n.$$.fragment,f)},m(f,I){s(f,a,I),s(f,M,I),s(f,r,I),s(f,i,I),u(n,f,I),U=!0},p:yl,i(f){U||(y(n.$$.fragment,f),U=!0)},o(f){J(n.$$.fragment,f),U=!1},d(f){f&&(t(a),t(M),t(r),t(i)),T(n,f)}}}function Qe(C){let a,j,M,r,m,i;return a=new ae({props:{id:"configurations",option:"p-tuning",$$slots:{default:[Re]},$$scope:{ctx:C}}}),M=new ae({props:{id:"configurations",option:"prefix tuning",$$slots:{default:[ve]},$$scope:{ctx:C}}}),m=new ae({props:{id:"configurations",option:"prompt tuning",$$slots:{default:[ze]},$$scope:{ctx:C}}}),{c(){c(a.$$.fragment),j=p(),c(M.$$.fragment),r=p(),c(m.$$.fragment)},l(n){d(a.$$.fragment,n),j=o(n),d(M.$$.fragment,n),r=o(n),d(m.$$.fragment,n)},m(n,U){u(a,n,U),s(n,j,U),u(M,n,U),s(n,r,U),u(m,n,U),i=!0},p(n,U){const f={};U&2&&(f.$$scope={dirty:U,ctx:n}),a.$set(f);const I={};U&2&&(I.$$scope={dirty:U,ctx:n}),M.$set(I);const dl={};U&2&&(dl.$$scope={dirty:U,ctx:n}),m.$set(dl)},i(n){i||(y(a.$$.fragment,n),y(M.$$.fragment,n),y(m.$$.fragment,n),i=!0)},o(n){J(a.$$.fragment,n),J(M.$$.fragment,n),J(m.$$.fragment,n),i=!1},d(n){n&&(t(j),t(r)),T(a,n),T(M,n),T(m,n)}}}function Ee(C){let a,j,M,r,m,i,n,U="A prompt can describe a task or provide an example of a task you want the model to learn. Instead of manually creating these prompts, soft prompting methods add learnable parameters to the input embeddings that can be optimized for a specific task while keeping the pretrained model’s parameters frozen. This makes it both faster and easier to finetune large language models (LLMs) for new downstream tasks.",f,I,dl='The PEFT library supports several types of prompting methods (p-tuning, prefix tuning, prompt tuning) and you can learn more about how these methods work conceptually in the <a href="../conceptual_guides/prompting">Soft prompts</a> guide. If you’re interested in applying these methods to other tasks and use cases, take a look at our <a href="https://huggingface.co/spaces/PEFT/soft-prompting" rel="nofollow">notebook collection</a>!',Jl,W,ne="This guide will show you how to train a causal language model - with a soft prompting method - to <em>generate a classification</em> for whether a tweet is a complaint or not.",Tl,_,hl,G,pe="Before you begin, make sure you have all the necessary libraries installed.",wl,$,fl,V,bl,X,oe='For this guide, you’ll use the <code>twitter_complaints</code> subset of the <a href="https://huggingface.co/datasets/ought/raft" rel="nofollow">RAFT</a> dataset. The <code>twitter_complaints</code> subset contains tweets labeled as <code>complaint</code> and <code>no complaint</code> and you can check out the <a href="https://huggingface.co/datasets/ought/raft/viewer/twitter_complaints" rel="nofollow">dataset viewer</a> for a better idea of what the data looks like.',jl,N,ie='Use the <a href="https://huggingface.co/docs/datasets/main/en/package_reference/loading_methods#datasets.load_dataset" rel="nofollow">load_dataset</a> function to load the dataset and create a new <code>text_label</code> column so it is easier to understand what the <code>Label</code> values, <code>1</code> and <code>2</code> mean.',Ul,R,Il,v,Me="Load a tokenizer, define the padding token to use, and determine the maximum length of the tokenized label.",gl,z,Cl,Q,re="Create a preprocessing function that tokenizes the tweet text and labels, pad the inputs and labels in each batch, create an attention mask, and truncate sequences to the <code>max_length</code>. Then convert the <code>input_ids</code>, <code>attention_mask</code>, and <code>labels</code> to PyTorch tensors.",_l,E,kl,Y,me='Apply the preprocessing function to the entire dataset with the <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.map" rel="nofollow">map</a> function, and remove the unprocessed columns because the model won’t need them.',Zl,F,Bl,x,ce='Finally, create a training and evaluation <a href="https://pytorch.org/docs/stable/data.html#torch.utils.data.DataLoader" rel="nofollow"><code>DataLoader</code></a>. You can set <code>pin_memory=True</code> to speed up the data transfer to the GPU during training if the samples in your dataset are on a CPU.',Wl,A,Gl,H,$l,q,de='Now let’s load a pretrained model to use as the base model for the soft prompt method. This guide uses the <a href="https://huggingface.co/bigscience/bloomz-560m" rel="nofollow">bigscience/bloomz-560m</a> model, but you can use any causal language model you want.',Vl,S,Xl,L,Nl,P,ue='For any PEFT method, you’ll need to create a configuration which contains all the parameters that specify how the PEFT method should be applied. Once the configuration is setup, pass it to the <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function along with the base model to create a trainable <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',Rl,k,vl,Z,zl,D,Ql,K,ye="Set up an optimizer and learning rate scheduler.",El,O,Yl,ll,Je="Move the model to the GPU and create a training loop that reports the loss and perplexity for each epoch.",Fl,el,xl,tl,Al,sl,Te='Once training is complete, you can upload your model to the Hub with the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.push_to_hub" rel="nofollow">push_to_hub</a> method. You’ll need to login to your Hugging Face account first and enter your token when prompted.',Hl,al,ql,nl,he="If you check the model file size in the repository, you’ll see that it is a lot smaller than a full sized model!",Sl,B,we='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/PEFT-hub-screenshot.png"/> <figcaption class="text-center">For example, the adapter weights for a opt-350m model stored on the Hub are only ~6MB compared to the full model size which can be ~700MB.</figcaption>',Ll,pl,Pl,ol,fe="Let’s load the model for inference and test it out on a tweet!",Dl,il,Kl,Ml,be='Call the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate" rel="nofollow">generate</a> method to generate the predicted classification label.',Ol,rl,le,ml,ee,ul,te;return m=new cl({props:{title:"Prompt-based methods",local:"prompt-based-methods",headingTag:"h1"}}),_=new Ce({props:{$$slots:{default:[Xe]},$$scope:{ctx:C}}}),$=new g({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwcGVmdCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRz",highlighted:"pip install -q peft transformers datasets",wrap:!1}}),V=new cl({props:{title:"Dataset",local:"dataset",headingTag:"h2"}}),R=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyb3VnaHQlMkZyYWZ0JTIyJTJDJTIwJTIydHdpdHRlcl9jb21wbGFpbnRzJTIyKSUwQSUwQWNsYXNzZXMlMjAlM0QlMjAlNUJrLnJlcGxhY2UoJTIyXyUyMiUyQyUyMCUyMiUyMCUyMiklMjBmb3IlMjBrJTIwaW4lMjBkcyU1QiUyMnRyYWluJTIyJTVELmZlYXR1cmVzJTVCJTIyTGFiZWwlMjIlNUQubmFtZXMlNUQlMEFkcyUyMCUzRCUyMGRzLm1hcCglMEElMjAlMjAlMjAlMjBsYW1iZGElMjB4JTNBJTIwJTdCJTIydGV4dF9sYWJlbCUyMiUzQSUyMCU1QmNsYXNzZXMlNUJsYWJlbCU1RCUyMGZvciUyMGxhYmVsJTIwaW4lMjB4JTVCJTIyTGFiZWwlMjIlNUQlNUQlN0QlMkMlMEElMjAlMjAlMjAlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9wcm9jJTNEMSUyQyUwQSklMEFkcyU1QiUyMnRyYWluJTIyJTVEJTVCMCU1RCUwQSU3QiUyMlR3ZWV0JTIwdGV4dCUyMiUzQSUyMCUyMiU0MEhNUkNjdXN0b21lcnMlMjBObyUyMHRoaXMlMjBpcyUyMG15JTIwZmlyc3QlMjBqb2IlMjIlMkMlMjAlMjJJRCUyMiUzQSUyMDAlMkMlMjAlMjJMYWJlbCUyMiUzQSUyMDIlMkMlMjAlMjJ0ZXh0X2xhYmVsJTIyJTNBJTIwJTIybm8lMjBjb21wbGFpbnQlMjIlN0Q=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

ds = load_dataset(<span class="hljs-string">&quot;ought/raft&quot;</span>, <span class="hljs-string">&quot;twitter_complaints&quot;</span>)

classes = [k.replace(<span class="hljs-string">&quot;_&quot;</span>, <span class="hljs-string">&quot; &quot;</span>) <span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> ds[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;Label&quot;</span>].names]
ds = ds.<span class="hljs-built_in">map</span>(
    <span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;text_label&quot;</span>: [classes[label] <span class="hljs-keyword">for</span> label <span class="hljs-keyword">in</span> x[<span class="hljs-string">&quot;Label&quot;</span>]]},
    batched=<span class="hljs-literal">True</span>,
    num_proc=<span class="hljs-number">1</span>,
)
ds[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&quot;Tweet text&quot;</span>: <span class="hljs-string">&quot;@HMRCcustomers No this is my first job&quot;</span>, <span class="hljs-string">&quot;ID&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;Label&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;text_label&quot;</span>: <span class="hljs-string">&quot;no complaint&quot;</span>}`,wrap:!1}}),z=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBaWYlMjB0b2tlbml6ZXIucGFkX3Rva2VuX2lkJTIwaXMlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyLnBhZF90b2tlbl9pZCUyMCUzRCUyMHRva2VuaXplci5lb3NfdG9rZW5faWQlMEF0YXJnZXRfbWF4X2xlbmd0aCUyMCUzRCUyMG1heCglNUJsZW4odG9rZW5pemVyKGNsYXNzX2xhYmVsKSU1QiUyMmlucHV0X2lkcyUyMiU1RCklMjBmb3IlMjBjbGFzc19sYWJlbCUyMGluJTIwY2xhc3NlcyU1RCklMEFwcmludCh0YXJnZXRfbWF4X2xlbmd0aCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-keyword">if</span> tokenizer.pad_token_id <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
    tokenizer.pad_token_id = tokenizer.eos_token_id
target_max_length = <span class="hljs-built_in">max</span>([<span class="hljs-built_in">len</span>(tokenizer(class_label)[<span class="hljs-string">&quot;input_ids&quot;</span>]) <span class="hljs-keyword">for</span> class_label <span class="hljs-keyword">in</span> classes])
<span class="hljs-built_in">print</span>(target_max_length)`,wrap:!1}}),E=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFtYXhfbGVuZ3RoJTIwJTNEJTIwNjQlMEElMEFkZWYlMjBwcmVwcm9jZXNzX2Z1bmN0aW9uKGV4YW1wbGVzJTJDJTIwdGV4dF9jb2x1bW4lM0QlMjJUd2VldCUyMHRleHQlMjIlMkMlMjBsYWJlbF9jb2x1bW4lM0QlMjJ0ZXh0X2xhYmVsJTIyKSUzQSUwQSUyMCUyMCUyMCUyMGJhdGNoX3NpemUlMjAlM0QlMjBsZW4oZXhhbXBsZXMlNUJ0ZXh0X2NvbHVtbiU1RCklMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlNUJmJTIyJTdCdGV4dF9jb2x1bW4lN0QlMjAlM0ElMjAlN0J4JTdEJTIwTGFiZWwlMjAlM0ElMjAlMjIlMjBmb3IlMjB4JTIwaW4lMjBleGFtcGxlcyU1QnRleHRfY29sdW1uJTVEJTVEJTBBJTIwJTIwJTIwJTIwdGFyZ2V0cyUyMCUzRCUyMCU1QnN0cih4KSUyMGZvciUyMHglMjBpbiUyMGV4YW1wbGVzJTVCbGFiZWxfY29sdW1uJTVEJTVEJTBBJTIwJTIwJTIwJTIwbW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKGlucHV0cyklMEElMjAlMjAlMjAlMjBsYWJlbHMlMjAlM0QlMjB0b2tlbml6ZXIodGFyZ2V0cyklMEElMjAlMjAlMjAlMjBjbGFzc2VzJTIwJTNEJTIwJTVCay5yZXBsYWNlKCUyMl8lMjIlMkMlMjAlMjIlMjAlMjIpJTIwZm9yJTIwayUyMGluJTIwZHMlNUIlMjJ0cmFpbiUyMiU1RC5mZWF0dXJlcyU1QiUyMkxhYmVsJTIyJTVELm5hbWVzJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoYmF0Y2hfc2l6ZSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzYW1wbGVfaW5wdXRfaWRzJTIwJTNEJTIwbW9kZWxfaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTVCaSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxhYmVsX2lucHV0X2lkcyUyMCUzRCUyMGxhYmVscyU1QiUyMmlucHV0X2lkcyUyMiU1RCU1QmklNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9pbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlNUJpJTVEJTIwJTNEJTIwJTVCdG9rZW5pemVyLnBhZF90b2tlbl9pZCU1RCUyMColMjAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X2xlbmd0aCUyMC0lMjBsZW4oc2FtcGxlX2lucHV0X2lkcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTIwJTJCJTIwc2FtcGxlX2lucHV0X2lkcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsX2lucHV0cyU1QiUyMmF0dGVudGlvbl9tYXNrJTIyJTVEJTVCaSU1RCUyMCUzRCUyMCU1QjAlNUQlMjAqJTIwKG1heF9sZW5ndGglMjAtJTIwbGVuKHNhbXBsZV9pbnB1dF9pZHMpKSUyMCUyQiUyMG1vZGVsX2lucHV0cyU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmF0dGVudGlvbl9tYXNrJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTVCaSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxhYmVscyU1QiUyMmlucHV0X2lkcyUyMiU1RCU1QmklNUQlMjAlM0QlMjAlNUItMTAwJTVEJTIwKiUyMChtYXhfbGVuZ3RoJTIwLSUyMGxlbihsYWJlbF9pbnB1dF9pZHMpKSUyMCUyQiUyMGxhYmVsX2lucHV0X2lkcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsX2lucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCU1QmklNUQlMjAlM0QlMjB0b3JjaC50ZW5zb3IobW9kZWxfaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTVCaSU1RCU1QiUzQW1heF9sZW5ndGglNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfaW5wdXRzJTVCJTIyYXR0ZW50aW9uX21hc2slMjIlNUQlNUJpJTVEJTIwJTNEJTIwdG9yY2gudGVuc29yKG1vZGVsX2lucHV0cyU1QiUyMmF0dGVudGlvbl9tYXNrJTIyJTVEJTVCaSU1RCU1QiUzQW1heF9sZW5ndGglNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWxzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTVCaSU1RCUyMCUzRCUyMHRvcmNoLnRlbnNvcihsYWJlbHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlNUJpJTVEJTVCJTNBbWF4X2xlbmd0aCU1RCklMEElMjAlMjAlMjAlMjBtb2RlbF9pbnB1dHMlNUIlMjJsYWJlbHMlMjIlNUQlMjAlM0QlMjBsYWJlbHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBtb2RlbF9pbnB1dHM=",highlighted:`<span class="hljs-keyword">import</span> torch

max_length = <span class="hljs-number">64</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples, text_column=<span class="hljs-string">&quot;Tweet text&quot;</span>, label_column=<span class="hljs-string">&quot;text_label&quot;</span></span>):
    batch_size = <span class="hljs-built_in">len</span>(examples[text_column])
    inputs = [<span class="hljs-string">f&quot;<span class="hljs-subst">{text_column}</span> : <span class="hljs-subst">{x}</span> Label : &quot;</span> <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> examples[text_column]]
    targets = [<span class="hljs-built_in">str</span>(x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> examples[label_column]]
    model_inputs = tokenizer(inputs)
    labels = tokenizer(targets)
    classes = [k.replace(<span class="hljs-string">&quot;_&quot;</span>, <span class="hljs-string">&quot; &quot;</span>) <span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> ds[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;Label&quot;</span>].names]
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(batch_size):
        sample_input_ids = model_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][i]
        label_input_ids = labels[<span class="hljs-string">&quot;input_ids&quot;</span>][i]
        model_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][i] = [tokenizer.pad_token_id] * (
            max_length - <span class="hljs-built_in">len</span>(sample_input_ids)
        ) + sample_input_ids
        model_inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>][i] = [<span class="hljs-number">0</span>] * (max_length - <span class="hljs-built_in">len</span>(sample_input_ids)) + model_inputs[
            <span class="hljs-string">&quot;attention_mask&quot;</span>
        ][i]
        labels[<span class="hljs-string">&quot;input_ids&quot;</span>][i] = [-<span class="hljs-number">100</span>] * (max_length - <span class="hljs-built_in">len</span>(label_input_ids)) + label_input_ids
        model_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][i] = torch.tensor(model_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][i][:max_length])
        model_inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>][i] = torch.tensor(model_inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>][i][:max_length])
        labels[<span class="hljs-string">&quot;input_ids&quot;</span>][i] = torch.tensor(labels[<span class="hljs-string">&quot;input_ids&quot;</span>][i][:max_length])
    model_inputs[<span class="hljs-string">&quot;labels&quot;</span>] = labels[<span class="hljs-string">&quot;input_ids&quot;</span>]
    <span class="hljs-keyword">return</span> model_inputs`,wrap:!1}}),F=new g({props:{code:"cHJvY2Vzc2VkX2RzJTIwJTNEJTIwZHMubWFwKCUwQSUyMCUyMCUyMCUyMHByZXByb2Nlc3NfZnVuY3Rpb24lMkMlMEElMjAlMjAlMjAlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9wcm9jJTNEMSUyQyUwQSUyMCUyMCUyMCUyMHJlbW92ZV9jb2x1bW5zJTNEZHMlNUIlMjJ0cmFpbiUyMiU1RC5jb2x1bW5fbmFtZXMlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2Zyb21fY2FjaGVfZmlsZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwZGVzYyUzRCUyMlJ1bm5pbmclMjB0b2tlbml6ZXIlMjBvbiUyMGRhdGFzZXQlMjIlMkMlMEEp",highlighted:`processed_ds = ds.<span class="hljs-built_in">map</span>(
    preprocess_function,
    batched=<span class="hljs-literal">True</span>,
    num_proc=<span class="hljs-number">1</span>,
    remove_columns=ds[<span class="hljs-string">&quot;train&quot;</span>].column_names,
    load_from_cache_file=<span class="hljs-literal">False</span>,
    desc=<span class="hljs-string">&quot;Running tokenizer on dataset&quot;</span>,
)`,wrap:!1}}),A=new g({props:{code:"ZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGRlZmF1bHRfZGF0YV9jb2xsYXRvciUwQSUwQXRyYWluX2RzJTIwJTNEJTIwcHJvY2Vzc2VkX2RzJTVCJTIydHJhaW4lMjIlNUQlMEFldmFsX2RzJTIwJTNEJTIwcHJvY2Vzc2VkX2RzJTVCJTIydGVzdCUyMiU1RCUwQSUwQWJhdGNoX3NpemUlMjAlM0QlMjAxNiUwQSUwQXRyYWluX2RhdGFsb2FkZXIlMjAlM0QlMjBEYXRhTG9hZGVyKHRyYWluX2RzJTJDJTIwc2h1ZmZsZSUzRFRydWUlMkMlMjBjb2xsYXRlX2ZuJTNEZGVmYXVsdF9kYXRhX2NvbGxhdG9yJTJDJTIwYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUlMkMlMjBwaW5fbWVtb3J5JTNEVHJ1ZSklMEFldmFsX2RhdGFsb2FkZXIlMjAlM0QlMjBEYXRhTG9hZGVyKGV2YWxfZHMlMkMlMjBjb2xsYXRlX2ZuJTNEZGVmYXVsdF9kYXRhX2NvbGxhdG9yJTJDJTIwYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUlMkMlMjBwaW5fbWVtb3J5JTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> default_data_collator

train_ds = processed_ds[<span class="hljs-string">&quot;train&quot;</span>]
eval_ds = processed_ds[<span class="hljs-string">&quot;test&quot;</span>]

batch_size = <span class="hljs-number">16</span>

train_dataloader = DataLoader(train_ds, shuffle=<span class="hljs-literal">True</span>, collate_fn=default_data_collator, batch_size=batch_size, pin_memory=<span class="hljs-literal">True</span>)
eval_dataloader = DataLoader(eval_ds, collate_fn=default_data_collator, batch_size=batch_size, pin_memory=<span class="hljs-literal">True</span>)`,wrap:!1}}),H=new cl({props:{title:"Model",local:"model",headingTag:"h2"}}),S=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmlnc2NpZW5jZSUyRmJsb29tei01NjBtJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)`,wrap:!1}}),L=new cl({props:{title:"PEFT configuration and model",local:"peft-configuration-and-model",headingTag:"h3"}}),k=new Ce({props:{$$slots:{default:[Ne]},$$scope:{ctx:C}}}),Z=new Ve({props:{id:"configurations",options:["p-tuning","prefix tuning","prompt tuning"],$$slots:{default:[Qe]},$$scope:{ctx:C}}}),D=new cl({props:{title:"Training",local:"training",headingTag:"h3"}}),O=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGdldF9saW5lYXJfc2NoZWR1bGVfd2l0aF93YXJtdXAlMEElMEFsciUyMCUzRCUyMDNlLTIlMEFudW1fZXBvY2hzJTIwJTNEJTIwNTAlMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjB0b3JjaC5vcHRpbS5BZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRGxyKSUwQWxyX3NjaGVkdWxlciUyMCUzRCUyMGdldF9saW5lYXJfc2NoZWR1bGVfd2l0aF93YXJtdXAoJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVyJTNEb3B0aW1pemVyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3dhcm11cF9zdGVwcyUzRDAlMkMlMEElMjAlMjAlMjAlMjBudW1fdHJhaW5pbmdfc3RlcHMlM0QobGVuKHRyYWluX2RhdGFsb2FkZXIpJTIwKiUyMG51bV9lcG9jaHMpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> get_linear_schedule_with_warmup

lr = <span class="hljs-number">3e-2</span>
num_epochs = <span class="hljs-number">50</span>

optimizer = torch.optim.AdamW(model.parameters(), lr=lr)
lr_scheduler = get_linear_schedule_with_warmup(
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=(<span class="hljs-built_in">len</span>(train_dataloader) * num_epochs),
)`,wrap:!1}}),el=new g({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm

device = <span class="hljs-string">&quot;cuda&quot;</span>
model = model.to(device)

<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    model.train()
    total_loss = <span class="hljs-number">0</span>
    <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(train_dataloader)):
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        total_loss += loss.detach().<span class="hljs-built_in">float</span>()
        loss.backward()
        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()

    model.<span class="hljs-built_in">eval</span>()
    eval_loss = <span class="hljs-number">0</span>
    eval_preds = []
    <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(eval_dataloader)):
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        <span class="hljs-keyword">with</span> torch.no_grad():
            outputs = model(**batch)
        loss = outputs.loss
        eval_loss += loss.detach().<span class="hljs-built_in">float</span>()
        eval_preds.extend(
            tokenizer.batch_decode(torch.argmax(outputs.logits, -<span class="hljs-number">1</span>).detach().cpu().numpy(), skip_special_tokens=<span class="hljs-literal">True</span>)
        )

    eval_epoch_loss = eval_loss / <span class="hljs-built_in">len</span>(eval_dataloader)
    eval_ppl = torch.exp(eval_epoch_loss)
    train_epoch_loss = total_loss / <span class="hljs-built_in">len</span>(train_dataloader)
    train_ppl = torch.exp(train_epoch_loss)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{epoch=}</span>: <span class="hljs-subst">{train_ppl=}</span> <span class="hljs-subst">{train_epoch_loss=}</span> <span class="hljs-subst">{eval_ppl=}</span> <span class="hljs-subst">{eval_epoch_loss=}</span>&quot;</span>)`,wrap:!1}}),tl=new cl({props:{title:"Share your model",local:"share-your-model",headingTag:"h2"}}),al=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBYWNjb3VudCUyMCUzRCUyMCUzQ3lvdXItaGYtYWNjb3VudC1uYW1lJTNFJTBBcGVmdF9tb2RlbF9pZCUyMCUzRCUyMGYlMjIlN0JhY2NvdW50JTdEJTJGYmxvb216LTU2MC1tLXBlZnQtbWV0aG9kJTIyJTBBbW9kZWwucHVzaF90b19odWIocGVmdF9tb2RlbF9pZCk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

account = &lt;your-hf-account-name&gt;
peft_model_id = <span class="hljs-string">f&quot;<span class="hljs-subst">{account}</span>/bloomz-560-m-peft-method&quot;</span>
model.push_to_hub(peft_model_id)`,wrap:!1}}),pl=new cl({props:{title:"Inference",local:"inference",headingTag:"h2"}}),il=new g({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBBdXRvUGVmdE1vZGVsRm9yQ2F1c2FsTE0lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9QZWZ0TW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIycGVmdF9tb2RlbF9pZCUyMikudG8oJTIyY3VkYSUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaSUyMCUzRCUyMDE1JTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKGYnJTdCdGV4dF9jb2x1bW4lN0QlMjAlM0ElMjAlN0JkcyU1QiUyMnRlc3QlMjIlNUQlNUJpJTVEJTVCJTIyVHdlZXQlMjB0ZXh0JTIyJTVEJTdEJTIwTGFiZWwlMjAlM0ElMjAnJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwcmludChkcyU1QiUyMnRlc3QlMjIlNUQlNUJpJTVEJTVCJTIyVHdlZXQlMjB0ZXh0JTIyJTVEKSUwQSUyMiU0ME5ZVHN1cHBvcnQlMjBpJTIwaGF2ZSUyMGNvbXBsYWluZWQlMjBhJTIwZG96ZW4lMjB0aW1lcyUyMCUyNmFtcCUzQiUyMHlldCUyMG15JTIwcGFwZXJzJTIwYXJlJTIwc3RpbGwlMjB0aHJvd24lMjBGQVIlMjBmcm9tJTIwbXklMjBkb29yLiUyMFdoeSUyMGlzJTIwdGhpcyUyMHNvJTIwaGFyZCUyMHRvJTIwcmVzb2x2ZSUzRiUyMg==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> AutoPeftModelForCausalLM

model = AutoPeftModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;peft_model_id&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

i = <span class="hljs-number">15</span>
inputs = tokenizer(<span class="hljs-string">f&#x27;<span class="hljs-subst">{text_column}</span> : <span class="hljs-subst">{ds[<span class="hljs-string">&quot;test&quot;</span>][i][<span class="hljs-string">&quot;Tweet text&quot;</span>]}</span> Label : &#x27;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-built_in">print</span>(ds[<span class="hljs-string">&quot;test&quot;</span>][i][<span class="hljs-string">&quot;Tweet text&quot;</span>])
<span class="hljs-string">&quot;@NYTsupport i have complained a dozen times &amp;amp; yet my papers are still thrown FAR from my door. Why is this so hard to resolve?&quot;</span>`,wrap:!1}}),rl=new g({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRfaWRzJTNEaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCklMEElMjAlMjAlMjAlMjBwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMuZGV0YWNoKCkuY3B1KCkubnVtcHkoKSUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElMjIlNUInVHdlZXQlMjB0ZXh0JTIwJTNBJTIwJTQwTllUc3VwcG9ydCUyMGklMjBoYXZlJTIwY29tcGxhaW5lZCUyMGElMjBkb3plbiUyMHRpbWVzJTIwJTI2YW1wJTNCJTIweWV0JTIwbXklMjBwYXBlcnMlMjBhcmUlMjBzdGlsbCUyMHRocm93biUyMEZBUiUyMGZyb20lMjBteSUyMGRvb3IuJTIwV2h5JTIwaXMlMjB0aGlzJTIwc28lMjBoYXJkJTIwdG8lMjByZXNvbHZlJTNGJTIwTGFiZWwlMjAlM0ElMjBjb21wbGFpbnQnJTVEJTIy",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    inputs = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
    outputs = model.generate(input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">10</span>)
    <span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs.detach().cpu().numpy(), skip_special_tokens=<span class="hljs-literal">True</span>))
<span class="hljs-string">&quot;[&#x27;Tweet text : @NYTsupport i have complained a dozen times &amp;amp; yet my papers are still thrown FAR from my door. Why is this so hard to resolve? Label : complaint&#x27;]&quot;</span>`,wrap:!1}}),ml=new $e({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/task_guides/prompt_based_methods.md"}}),{c(){a=h("meta"),j=p(),M=h("p"),r=p(),c(m.$$.fragment),i=p(),n=h("p"),n.textContent=U,f=p(),I=h("p"),I.innerHTML=dl,Jl=p(),W=h("p"),W.innerHTML=ne,Tl=p(),c(_.$$.fragment),hl=p(),G=h("p"),G.textContent=pe,wl=p(),c($.$$.fragment),fl=p(),c(V.$$.fragment),bl=p(),X=h("p"),X.innerHTML=oe,jl=p(),N=h("p"),N.innerHTML=ie,Ul=p(),c(R.$$.fragment),Il=p(),v=h("p"),v.textContent=Me,gl=p(),c(z.$$.fragment),Cl=p(),Q=h("p"),Q.innerHTML=re,_l=p(),c(E.$$.fragment),kl=p(),Y=h("p"),Y.innerHTML=me,Zl=p(),c(F.$$.fragment),Bl=p(),x=h("p"),x.innerHTML=ce,Wl=p(),c(A.$$.fragment),Gl=p(),c(H.$$.fragment),$l=p(),q=h("p"),q.innerHTML=de,Vl=p(),c(S.$$.fragment),Xl=p(),c(L.$$.fragment),Nl=p(),P=h("p"),P.innerHTML=ue,Rl=p(),c(k.$$.fragment),vl=p(),c(Z.$$.fragment),zl=p(),c(D.$$.fragment),Ql=p(),K=h("p"),K.textContent=ye,El=p(),c(O.$$.fragment),Yl=p(),ll=h("p"),ll.textContent=Je,Fl=p(),c(el.$$.fragment),xl=p(),c(tl.$$.fragment),Al=p(),sl=h("p"),sl.innerHTML=Te,Hl=p(),c(al.$$.fragment),ql=p(),nl=h("p"),nl.textContent=he,Sl=p(),B=h("div"),B.innerHTML=we,Ll=p(),c(pl.$$.fragment),Pl=p(),ol=h("p"),ol.textContent=fe,Dl=p(),c(il.$$.fragment),Kl=p(),Ml=h("p"),Ml.innerHTML=be,Ol=p(),c(rl.$$.fragment),le=p(),c(ml.$$.fragment),ee=p(),ul=h("p"),this.h()},l(l){const e=We("svelte-u9bgzb",document.head);a=w(e,"META",{name:!0,content:!0}),e.forEach(t),j=o(l),M=w(l,"P",{}),ge(M).forEach(t),r=o(l),d(m.$$.fragment,l),i=o(l),n=w(l,"P",{"data-svelte-h":!0}),b(n)!=="svelte-1nma30k"&&(n.textContent=U),f=o(l),I=w(l,"P",{"data-svelte-h":!0}),b(I)!=="svelte-qxepz2"&&(I.innerHTML=dl),Jl=o(l),W=w(l,"P",{"data-svelte-h":!0}),b(W)!=="svelte-10gyoze"&&(W.innerHTML=ne),Tl=o(l),d(_.$$.fragment,l),hl=o(l),G=w(l,"P",{"data-svelte-h":!0}),b(G)!=="svelte-1rdzhb1"&&(G.textContent=pe),wl=o(l),d($.$$.fragment,l),fl=o(l),d(V.$$.fragment,l),bl=o(l),X=w(l,"P",{"data-svelte-h":!0}),b(X)!=="svelte-b49pm"&&(X.innerHTML=oe),jl=o(l),N=w(l,"P",{"data-svelte-h":!0}),b(N)!=="svelte-5j9yqq"&&(N.innerHTML=ie),Ul=o(l),d(R.$$.fragment,l),Il=o(l),v=w(l,"P",{"data-svelte-h":!0}),b(v)!=="svelte-gjlxro"&&(v.textContent=Me),gl=o(l),d(z.$$.fragment,l),Cl=o(l),Q=w(l,"P",{"data-svelte-h":!0}),b(Q)!=="svelte-s6tghk"&&(Q.innerHTML=re),_l=o(l),d(E.$$.fragment,l),kl=o(l),Y=w(l,"P",{"data-svelte-h":!0}),b(Y)!=="svelte-fdx4gc"&&(Y.innerHTML=me),Zl=o(l),d(F.$$.fragment,l),Bl=o(l),x=w(l,"P",{"data-svelte-h":!0}),b(x)!=="svelte-zejkx4"&&(x.innerHTML=ce),Wl=o(l),d(A.$$.fragment,l),Gl=o(l),d(H.$$.fragment,l),$l=o(l),q=w(l,"P",{"data-svelte-h":!0}),b(q)!=="svelte-bbm736"&&(q.innerHTML=de),Vl=o(l),d(S.$$.fragment,l),Xl=o(l),d(L.$$.fragment,l),Nl=o(l),P=w(l,"P",{"data-svelte-h":!0}),b(P)!=="svelte-y2bm59"&&(P.innerHTML=ue),Rl=o(l),d(k.$$.fragment,l),vl=o(l),d(Z.$$.fragment,l),zl=o(l),d(D.$$.fragment,l),Ql=o(l),K=w(l,"P",{"data-svelte-h":!0}),b(K)!=="svelte-tlkvop"&&(K.textContent=ye),El=o(l),d(O.$$.fragment,l),Yl=o(l),ll=w(l,"P",{"data-svelte-h":!0}),b(ll)!=="svelte-bqhytl"&&(ll.textContent=Je),Fl=o(l),d(el.$$.fragment,l),xl=o(l),d(tl.$$.fragment,l),Al=o(l),sl=w(l,"P",{"data-svelte-h":!0}),b(sl)!=="svelte-vaxac6"&&(sl.innerHTML=Te),Hl=o(l),d(al.$$.fragment,l),ql=o(l),nl=w(l,"P",{"data-svelte-h":!0}),b(nl)!=="svelte-b4rki0"&&(nl.textContent=he),Sl=o(l),B=w(l,"DIV",{class:!0,"data-svelte-h":!0}),b(B)!=="svelte-i5cvgh"&&(B.innerHTML=we),Ll=o(l),d(pl.$$.fragment,l),Pl=o(l),ol=w(l,"P",{"data-svelte-h":!0}),b(ol)!=="svelte-19ver11"&&(ol.textContent=fe),Dl=o(l),d(il.$$.fragment,l),Kl=o(l),Ml=w(l,"P",{"data-svelte-h":!0}),b(Ml)!=="svelte-1gths0y"&&(Ml.innerHTML=be),Ol=o(l),d(rl.$$.fragment,l),le=o(l),d(ml.$$.fragment,l),ee=o(l),ul=w(l,"P",{}),ge(ul).forEach(t),this.h()},h(){se(a,"name","hf:doc:metadata"),se(a,"content",Ye),se(B,"class","flex flex-col justify-center")},m(l,e){Ge(document.head,a),s(l,j,e),s(l,M,e),s(l,r,e),u(m,l,e),s(l,i,e),s(l,n,e),s(l,f,e),s(l,I,e),s(l,Jl,e),s(l,W,e),s(l,Tl,e),u(_,l,e),s(l,hl,e),s(l,G,e),s(l,wl,e),u($,l,e),s(l,fl,e),u(V,l,e),s(l,bl,e),s(l,X,e),s(l,jl,e),s(l,N,e),s(l,Ul,e),u(R,l,e),s(l,Il,e),s(l,v,e),s(l,gl,e),u(z,l,e),s(l,Cl,e),s(l,Q,e),s(l,_l,e),u(E,l,e),s(l,kl,e),s(l,Y,e),s(l,Zl,e),u(F,l,e),s(l,Bl,e),s(l,x,e),s(l,Wl,e),u(A,l,e),s(l,Gl,e),u(H,l,e),s(l,$l,e),s(l,q,e),s(l,Vl,e),u(S,l,e),s(l,Xl,e),u(L,l,e),s(l,Nl,e),s(l,P,e),s(l,Rl,e),u(k,l,e),s(l,vl,e),u(Z,l,e),s(l,zl,e),u(D,l,e),s(l,Ql,e),s(l,K,e),s(l,El,e),u(O,l,e),s(l,Yl,e),s(l,ll,e),s(l,Fl,e),u(el,l,e),s(l,xl,e),u(tl,l,e),s(l,Al,e),s(l,sl,e),s(l,Hl,e),u(al,l,e),s(l,ql,e),s(l,nl,e),s(l,Sl,e),s(l,B,e),s(l,Ll,e),u(pl,l,e),s(l,Pl,e),s(l,ol,e),s(l,Dl,e),u(il,l,e),s(l,Kl,e),s(l,Ml,e),s(l,Ol,e),u(rl,l,e),s(l,le,e),u(ml,l,e),s(l,ee,e),s(l,ul,e),te=!0},p(l,[e]){const je={};e&2&&(je.$$scope={dirty:e,ctx:l}),_.$set(je);const Ue={};e&2&&(Ue.$$scope={dirty:e,ctx:l}),k.$set(Ue);const Ie={};e&2&&(Ie.$$scope={dirty:e,ctx:l}),Z.$set(Ie)},i(l){te||(y(m.$$.fragment,l),y(_.$$.fragment,l),y($.$$.fragment,l),y(V.$$.fragment,l),y(R.$$.fragment,l),y(z.$$.fragment,l),y(E.$$.fragment,l),y(F.$$.fragment,l),y(A.$$.fragment,l),y(H.$$.fragment,l),y(S.$$.fragment,l),y(L.$$.fragment,l),y(k.$$.fragment,l),y(Z.$$.fragment,l),y(D.$$.fragment,l),y(O.$$.fragment,l),y(el.$$.fragment,l),y(tl.$$.fragment,l),y(al.$$.fragment,l),y(pl.$$.fragment,l),y(il.$$.fragment,l),y(rl.$$.fragment,l),y(ml.$$.fragment,l),te=!0)},o(l){J(m.$$.fragment,l),J(_.$$.fragment,l),J($.$$.fragment,l),J(V.$$.fragment,l),J(R.$$.fragment,l),J(z.$$.fragment,l),J(E.$$.fragment,l),J(F.$$.fragment,l),J(A.$$.fragment,l),J(H.$$.fragment,l),J(S.$$.fragment,l),J(L.$$.fragment,l),J(k.$$.fragment,l),J(Z.$$.fragment,l),J(D.$$.fragment,l),J(O.$$.fragment,l),J(el.$$.fragment,l),J(tl.$$.fragment,l),J(al.$$.fragment,l),J(pl.$$.fragment,l),J(il.$$.fragment,l),J(rl.$$.fragment,l),J(ml.$$.fragment,l),te=!1},d(l){l&&(t(j),t(M),t(r),t(i),t(n),t(f),t(I),t(Jl),t(W),t(Tl),t(hl),t(G),t(wl),t(fl),t(bl),t(X),t(jl),t(N),t(Ul),t(Il),t(v),t(gl),t(Cl),t(Q),t(_l),t(kl),t(Y),t(Zl),t(Bl),t(x),t(Wl),t(Gl),t($l),t(q),t(Vl),t(Xl),t(Nl),t(P),t(Rl),t(vl),t(zl),t(Ql),t(K),t(El),t(Yl),t(ll),t(Fl),t(xl),t(Al),t(sl),t(Hl),t(ql),t(nl),t(Sl),t(B),t(Ll),t(Pl),t(ol),t(Dl),t(Kl),t(Ml),t(Ol),t(le),t(ee),t(ul)),t(a),T(m,l),T(_,l),T($,l),T(V,l),T(R,l),T(z,l),T(E,l),T(F,l),T(A,l),T(H,l),T(S,l),T(L,l),T(k,l),T(Z,l),T(D,l),T(O,l),T(el,l),T(tl,l),T(al,l),T(pl,l),T(il,l),T(rl,l),T(ml,l)}}}const Ye='{"title":"Prompt-based methods","local":"prompt-based-methods","sections":[{"title":"Dataset","local":"dataset","sections":[],"depth":2},{"title":"Model","local":"model","sections":[{"title":"PEFT configuration and model","local":"peft-configuration-and-model","sections":[],"depth":3},{"title":"Training","local":"training","sections":[],"depth":3}],"depth":2},{"title":"Share your model","local":"share-your-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function Fe(C){return ke(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pe extends Ze{constructor(a){super(),Be(this,a,Fe,Ee,_e,{})}}export{Pe as component};
