import{s as Vt,z as Yt,o as Gt,n as ke}from"../chunks/scheduler.18a86fab.js";import{S as At,i as Qt,g as i,s as r,r as u,A as Ht,h as d,f as o,c as l,j as ue,u as f,x as h,k as R,y as m,a as n,v as g,d as b,t as _,w as y}from"../chunks/index.98837b22.js";import{T as qt}from"../chunks/Tip.77304350.js";import{D as xe}from"../chunks/Docstring.6758ea23.js";import{C as X}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as yt}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as Je}from"../chunks/Heading.7e7e0c5b.js";import{E as St}from"../chunks/index.f01015d9.js";function Ot(k){let s,T="Examples:",c,p,w;return p=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERhYkRldHJDb25maWclMkMlMjBEYWJEZXRyTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwREFCLURFVFIlMjBJREVBLVJlc2VhcmNoJTJGZGFiX2RldHItYmFzZSUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBEYWJEZXRyQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjAod2l0aCUyMHJhbmRvbSUyMHdlaWdodHMpJTIwZnJvbSUyMHRoZSUyMElERUEtUmVzZWFyY2glMkZkYWJfZGV0ci1iYXNlJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBEYWJEZXRyTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DabDetrConfig, DabDetrModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a DAB-DETR IDEA-Research/dab_detr-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = DabDetrConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the IDEA-Research/dab_detr-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DabDetrModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){s=i("p"),s.textContent=T,c=r(),u(p.$$.fragment)},l(a){s=d(a,"P",{"data-svelte-h":!0}),h(s)!=="svelte-kvfsh7"&&(s.textContent=T),c=l(a),f(p.$$.fragment,a)},m(a,M){n(a,s,M),n(a,c,M),g(p,a,M),w=!0},p:ke,i(a){w||(b(p.$$.fragment,a),w=!0)},o(a){_(p.$$.fragment,a),w=!1},d(a){a&&(o(s),o(c)),y(p,a)}}}function Pt(k){let s,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=i("p"),s.innerHTML=T},l(c){s=d(c,"P",{"data-svelte-h":!0}),h(s)!=="svelte-fincs2"&&(s.innerHTML=T)},m(c,p){n(c,s,p)},p:ke,d(c){c&&o(s)}}}function Lt(k){let s,T="Examples:",c,p,w;return p=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIySURFQS1SZXNlYXJjaCUyRmRhYl9kZXRyLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMklERUEtUmVzZWFyY2glMkZkYWJfZGV0ci1iYXNlJTIyKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUyMGZvciUyMHRoZSUyMG1vZGVsJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBmb3J3YXJkJTIwcGFzcyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEElMjMlMjB0aGUlMjBsYXN0JTIwaGlkZGVuJTIwc3RhdGVzJTIwYXJlJTIwdGhlJTIwZmluYWwlMjBxdWVyeSUyMGVtYmVkZGluZ3MlMjBvZiUyMHRoZSUyMFRyYW5zZm9ybWVyJTIwZGVjb2RlciUwQSUyMyUyMHRoZXNlJTIwYXJlJTIwb2YlMjBzaGFwZSUyMChiYXRjaF9zaXplJTJDJTIwbnVtX3F1ZXJpZXMlMkMlMjBoaWRkZW5fc2l6ZSklMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdChsYXN0X2hpZGRlbl9zdGF0ZXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;IDEA-Research/dab_detr-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;IDEA-Research/dab_detr-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the last hidden states are the final query embeddings of the Transformer decoder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># these are of shape (batch_size, num_queries, hidden_size)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">300</span>, <span class="hljs-number">256</span>]`,wrap:!1}}),{c(){s=i("p"),s.textContent=T,c=r(),u(p.$$.fragment)},l(a){s=d(a,"P",{"data-svelte-h":!0}),h(s)!=="svelte-kvfsh7"&&(s.textContent=T),c=l(a),f(p.$$.fragment,a)},m(a,M){n(a,s,M),n(a,c,M),g(p,a,M),w=!0},p:ke,i(a){w||(b(p.$$.fragment,a),w=!0)},o(a){_(p.$$.fragment,a),w=!1},d(a){a&&(o(s),o(c)),y(p,a)}}}function Kt(k){let s,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=i("p"),s.innerHTML=T},l(c){s=d(c,"P",{"data-svelte-h":!0}),h(s)!=="svelte-fincs2"&&(s.innerHTML=T)},m(c,p){n(c,s,p)},p:ke,d(c){c&&o(s)}}}function eo(k){let s,T="Examples:",c,p,w;return p=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbiUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIySURFQS1SZXNlYXJjaCUyRmRhYi1kZXRyLXJlc25ldC01MCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIySURFQS1SZXNlYXJjaCUyRmRhYi1kZXRyLXJlc25ldC01MCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBJTIzJTIwY29udmVydCUyMG91dHB1dHMlMjAoYm91bmRpbmclMjBib3hlcyUyMGFuZCUyMGNsYXNzJTIwbG9naXRzKSUyMHRvJTIwUGFzY2FsJTIwVk9DJTIwZm9ybWF0JTIwKHhtaW4lMkMlMjB5bWluJTJDJTIweG1heCUyQyUyMHltYXgpJTBBdGFyZ2V0X3NpemVzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QihpbWFnZS5oZWlnaHQlMkMlMjBpbWFnZS53aWR0aCklNUQpJTBBcmVzdWx0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvci5wb3N0X3Byb2Nlc3Nfb2JqZWN0X2RldGVjdGlvbihvdXRwdXRzJTJDJTIwdGhyZXNob2xkJTNEMC41JTJDJTIwdGFyZ2V0X3NpemVzJTNEdGFyZ2V0X3NpemVzKSU1QjAlNUQlMEFmb3IlMjBzY29yZSUyQyUyMGxhYmVsJTJDJTIwYm94JTIwaW4lMjB6aXAocmVzdWx0cyU1QiUyMnNjb3JlcyUyMiU1RCUyQyUyMHJlc3VsdHMlNUIlMjJsYWJlbHMlMjIlNUQlMkMlMjByZXN1bHRzJTVCJTIyYm94ZXMlMjIlNUQpJTNBJTBBJTIwJTIwJTIwJTIwYm94JTIwJTNEJTIwJTVCcm91bmQoaSUyQyUyMDIpJTIwZm9yJTIwaSUyMGluJTIwYm94LnRvbGlzdCgpJTVEJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMkRldGVjdGVkJTIwJTdCbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCbGFiZWwuaXRlbSgpJTVEJTdEJTIwd2l0aCUyMGNvbmZpZGVuY2UlMjAlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmJTIyJTdCcm91bmQoc2NvcmUuaXRlbSgpJTJDJTIwMyklN0QlMjBhdCUyMGxvY2F0aW9uJTIwJTdCYm94JTdEJTIyJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForObjectDetection
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;IDEA-Research/dab-detr-resnet-50&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;IDEA-Research/dab-detr-resnet-50&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">&gt;&gt;&gt; </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># convert outputs (bounding boxes and class logits) to Pascal VOC format (xmin, ymin, xmax, ymax)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.tensor([(image.height, image.width)])
<span class="hljs-meta">&gt;&gt;&gt; </span>results = image_processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.5</span>, target_sizes=target_sizes)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> score, label, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;labels&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;Detected <span class="hljs-subst">{model.config.id2label[label.item()]}</span> with confidence &quot;</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>
<span class="hljs-meta">... </span>    )
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.833</span> at location [<span class="hljs-number">38.31</span>, <span class="hljs-number">72.1</span>, <span class="hljs-number">177.63</span>, <span class="hljs-number">118.45</span>]
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.831</span> at location [<span class="hljs-number">9.2</span>, <span class="hljs-number">51.38</span>, <span class="hljs-number">321.13</span>, <span class="hljs-number">469.0</span>]
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.804</span> at location [<span class="hljs-number">340.3</span>, <span class="hljs-number">16.85</span>, <span class="hljs-number">642.93</span>, <span class="hljs-number">370.95</span>]
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.683</span> at location [<span class="hljs-number">334.48</span>, <span class="hljs-number">73.49</span>, <span class="hljs-number">366.37</span>, <span class="hljs-number">190.01</span>]
Detected couch <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.535</span> at location [<span class="hljs-number">0.52</span>, <span class="hljs-number">1.19</span>, <span class="hljs-number">640.35</span>, <span class="hljs-number">475.1</span>]`,wrap:!1}}),{c(){s=i("p"),s.textContent=T,c=r(),u(p.$$.fragment)},l(a){s=d(a,"P",{"data-svelte-h":!0}),h(s)!=="svelte-kvfsh7"&&(s.textContent=T),c=l(a),f(p.$$.fragment,a)},m(a,M){n(a,s,M),n(a,c,M),g(p,a,M),w=!0},p:ke,i(a){w||(b(p.$$.fragment,a),w=!0)},o(a){_(p.$$.fragment,a),w=!1},d(a){a&&(o(s),o(c)),y(p,a)}}}function to(k){let s,T,c,p,w,a,M,wt='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',Ue,q,Ce,V,Mt=`The DAB-DETR model was proposed in <a href="https://arxiv.org/abs/2201.12329" rel="nofollow">DAB-DETR: Dynamic Anchor Boxes are Better Queries for DETR</a> by Shilong Liu, Feng Li, Hao Zhang, Xiao Yang, Xianbiao Qi, Hang Su, Jun Zhu, Lei Zhang.
DAB-DETR is an enhanced variant of Conditional DETR. It utilizes dynamically updated anchor boxes to provide both a reference query point (x, y) and a reference anchor size (w, h), improving cross-attention computation. This new approach achieves 45.7% AP when trained for 50 epochs with a single ResNet-50 model as the backbone.`,$e,F,Tt,Ie,Y,jt="The abstract from the paper is the following:",Ze,G,Dt=`<em>We present in this paper a novel query formulation using dynamic anchor boxes
for DETR (DEtection TRansformer) and offer a deeper understanding of the role
of queries in DETR. This new formulation directly uses box coordinates as queries
in Transformer decoders and dynamically updates them layer-by-layer. Using box
coordinates not only helps using explicit positional priors to improve the query-to-feature similarity and eliminate the slow training convergence issue in DETR,
but also allows us to modulate the positional attention map using the box width
and height information. Such a design makes it clear that queries in DETR can be
implemented as performing soft ROI pooling layer-by-layer in a cascade manner.
As a result, it leads to the best performance on MS-COCO benchmark among
the DETR-like detection models under the same setting, e.g., AP 45.7% using
ResNet50-DC5 as backbone trained in 50 epochs. We also conducted extensive
experiments to confirm our analysis and verify the effectiveness of our methods.</em>`,Re,A,Jt=`This model was contributed by <a href="https://huggingface.co/davidhajdu" rel="nofollow">davidhajdu</a>.
The original code can be found <a href="https://github.com/IDEA-Research/DAB-DETR" rel="nofollow">here</a>.`,Fe,Q,Ee,H,vt="Use the code below to get started with the model.",ze,S,Ne,O,xt="This should output",We,P,Be,L,kt="There are three other ways to instantiate a DAB-DETR model (depending on what you prefer):",Xe,K,Ut="Option 1: Instantiate DAB-DETR with pre-trained weights for entire model",qe,ee,Ve,te,Ct="Option 2: Instantiate DAB-DETR with randomly initialized weights for Transformer, but pre-trained weights for backbone",Ye,oe,Ge,ne,$t="Option 3: Instantiate DAB-DETR with randomly initialized weights for backbone + Transformer",Ae,se,Qe,ae,He,J,re,ot,fe,It=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/dab-detr#transformers.DabDetrModel">DabDetrModel</a>. It is used to instantiate
a DAB-DETR model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the DAB-DETR
<a href="https://huggingface.co/IDEA-Research/dab_detr-base" rel="nofollow">IDEA-Research/dab_detr-base</a> architecture.`,nt,ge,Zt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,st,E,Se,le,Oe,j,ie,at,be,Rt=`The bare DAB-DETR Model (consisting of a backbone and encoder-decoder Transformer) outputting raw
hidden-states, intermediate hidden states, reference points, output coordinates without any specific head on top.`,rt,_e,Ft=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,lt,ye,Et=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,it,U,de,dt,we,zt='The <a href="/docs/transformers/main/en/model_doc/dab-detr#transformers.DabDetrModel">DabDetrModel</a> forward method, overrides the <code>__call__</code> special method.',ct,z,pt,N,Pe,ce,Le,D,pe,mt,Me,Nt=`DAB_DETR Model (consisting of a backbone and encoder-decoder Transformer) with object detection heads on
top, for tasks such as COCO detection.`,ht,Te,Wt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ut,je,Bt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ft,C,me,gt,De,Xt='The <a href="/docs/transformers/main/en/model_doc/dab-detr#transformers.DabDetrForObjectDetection">DabDetrForObjectDetection</a> forward method, overrides the <code>__call__</code> special method.',bt,W,_t,B,Ke,he,et,ve,tt;return w=new Je({props:{title:"DAB-DETR",local:"dab-detr",headingTag:"h1"}}),q=new Je({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Q=new Je({props:{title:"How to Get Started with the Model",local:"how-to-get-started-with-the-model",headingTag:"h2"}}),S=new X({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvTW9kZWxGb3JPYmplY3REZXRlY3Rpb24lMkMlMjBBdXRvSW1hZ2VQcm9jZXNzb3IlMEElMEF1cmwlMjAlM0QlMjAnaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyclMjAlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMklERUEtUmVzZWFyY2glMkZkYWItZGV0ci1yZXNuZXQtNTAlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JPYmplY3REZXRlY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUyMklERUEtUmVzZWFyY2glMkZkYWItZGV0ci1yZXNuZXQtNTAlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQXJlc3VsdHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX29iamVjdF9kZXRlY3Rpb24ob3V0cHV0cyUyQyUyMHRhcmdldF9zaXplcyUzRHRvcmNoLnRlbnNvciglNUJpbWFnZS5zaXplJTVCJTNBJTNBLTElNUQlNUQpJTJDJTIwdGhyZXNob2xkJTNEMC4zKSUwQSUwQWZvciUyMHJlc3VsdCUyMGluJTIwcmVzdWx0cyUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMHNjb3JlJTJDJTIwbGFiZWxfaWQlMkMlMjBib3glMjBpbiUyMHppcChyZXN1bHQlNUIlMjJzY29yZXMlMjIlNUQlMkMlMjByZXN1bHQlNUIlMjJsYWJlbHMlMjIlNUQlMkMlMjByZXN1bHQlNUIlMjJib3hlcyUyMiU1RCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzY29yZSUyQyUyMGxhYmVsJTIwJTNEJTIwc2NvcmUuaXRlbSgpJTJDJTIwbGFiZWxfaWQuaXRlbSgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYm94JTIwJTNEJTIwJTVCcm91bmQoaSUyQyUyMDIpJTIwZm9yJTIwaSUyMGluJTIwYm94LnRvbGlzdCgpJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiU3Qm1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QmxhYmVsJTVEJTdEJTNBJTIwJTdCc2NvcmUlM0EuMmYlN0QlMjAlN0Jib3glN0QlMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> requests

<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForObjectDetection, AutoImageProcessor

url = <span class="hljs-string">&#x27;http://images.cocodataset.org/val2017/000000039769.jpg&#x27;</span> 
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;IDEA-Research/dab-detr-resnet-50&quot;</span>)
model = AutoModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;IDEA-Research/dab-detr-resnet-50&quot;</span>)

inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model(**inputs)

results = image_processor.post_process_object_detection(outputs, target_sizes=torch.tensor([image.size[::-<span class="hljs-number">1</span>]]), threshold=<span class="hljs-number">0.3</span>)

<span class="hljs-keyword">for</span> result <span class="hljs-keyword">in</span> results:
    <span class="hljs-keyword">for</span> score, label_id, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(result[<span class="hljs-string">&quot;scores&quot;</span>], result[<span class="hljs-string">&quot;labels&quot;</span>], result[<span class="hljs-string">&quot;boxes&quot;</span>]):
        score, label = score.item(), label_id.item()
        box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{model.config.id2label[label]}</span>: <span class="hljs-subst">{score:<span class="hljs-number">.2</span>f}</span> <span class="hljs-subst">{box}</span>&quot;</span>)`,wrap:!1}}),P=new X({props:{code:"Y2F0JTNBJTIwMC44NyUyMCU1QjE0LjclMkMlMjA0OS4zOSUyQyUyMDMyMC41MiUyQyUyMDQ2OS4yOCU1RCUwQXJlbW90ZSUzQSUyMDAuODYlMjAlNUI0MS4wOCUyQyUyMDcyLjM3JTJDJTIwMTczLjM5JTJDJTIwMTE3LjIlNUQlMEFjYXQlM0ElMjAwLjg2JTIwJTVCMzQ0LjQ1JTJDJTIwMTkuNDMlMkMlMjA2MzkuODUlMkMlMjAzNjcuODYlNUQlMEFyZW1vdGUlM0ElMjAwLjYxJTIwJTVCMzM0LjI3JTJDJTIwNzUuOTMlMkMlMjAzNjcuOTIlMkMlMjAxODguODElNUQlMEFjb3VjaCUzQSUyMDAuNTklMjAlNUItMC4wNCUyQyUyMDEuMzQlMkMlMjA2MzkuOSUyQyUyMDQ3Ny4wOSU1RA==",highlighted:`<span class="hljs-attribute">cat</span>: <span class="hljs-number">0</span>.<span class="hljs-number">87</span><span class="hljs-meta"> [14.7, 49.39, 320.52, 469.28]</span>
<span class="hljs-attribute">remote</span>: <span class="hljs-number">0</span>.<span class="hljs-number">86</span><span class="hljs-meta"> [41.08, 72.37, 173.39, 117.2]</span>
<span class="hljs-attribute">cat</span>: <span class="hljs-number">0</span>.<span class="hljs-number">86</span><span class="hljs-meta"> [344.45, 19.43, 639.85, 367.86]</span>
<span class="hljs-attribute">remote</span>: <span class="hljs-number">0</span>.<span class="hljs-number">61</span><span class="hljs-meta"> [334.27, 75.93, 367.92, 188.81]</span>
<span class="hljs-attribute">couch</span>: <span class="hljs-number">0</span>.<span class="hljs-number">59</span><span class="hljs-meta"> [-0.04, 1.34, 639.9, 477.09]</span>`,wrap:!1}}),ee=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERhYkRldHJGb3JPYmplY3REZXRlY3Rpb24lMEElMEFtb2RlbCUyMCUzRCUyMERhYkRldHJGb3JPYmplY3REZXRlY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUyMklERUEtUmVzZWFyY2glMkZkYWItZGV0ci1yZXNuZXQtNTAlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DabDetrForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>model = DabDetrForObjectDetection.from_pretrained(<span class="hljs-string">&quot;IDEA-Research/dab-detr-resnet-50&quot;</span>)`,wrap:!1}}),oe=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERhYkRldHJDb25maWclMkMlMjBEYWJEZXRyRm9yT2JqZWN0RGV0ZWN0aW9uJTBBJTBBY29uZmlnJTIwJTNEJTIwRGFiRGV0ckNvbmZpZygpJTBBbW9kZWwlMjAlM0QlMjBEYWJEZXRyRm9yT2JqZWN0RGV0ZWN0aW9uKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DabDetrConfig, DabDetrForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>config = DabDetrConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DabDetrForObjectDetection(config)`,wrap:!1}}),se=new X({props:{code:"Y29uZmlnJTIwJTNEJTIwRGFiRGV0ckNvbmZpZyh1c2VfcHJldHJhaW5lZF9iYWNrYm9uZSUzREZhbHNlKSUwQW1vZGVsJTIwJTNEJTIwRGFiRGV0ckZvck9iamVjdERldGVjdGlvbihjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>config = DabDetrConfig(use_pretrained_backbone=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DabDetrForObjectDetection(config)`,wrap:!1}}),ae=new Je({props:{title:"DabDetrConfig",local:"transformers.DabDetrConfig",headingTag:"h2"}}),re=new xe({props:{name:"class transformers.DabDetrConfig",anchor:"transformers.DabDetrConfig",parameters:[{name:"use_timm_backbone",val:" = True"},{name:"backbone_config",val:" = None"},{name:"backbone",val:" = 'resnet50'"},{name:"use_pretrained_backbone",val:" = True"},{name:"backbone_kwargs",val:" = None"},{name:"num_queries",val:" = 300"},{name:"encoder_layers",val:" = 6"},{name:"encoder_ffn_dim",val:" = 2048"},{name:"encoder_attention_heads",val:" = 8"},{name:"decoder_layers",val:" = 6"},{name:"decoder_ffn_dim",val:" = 2048"},{name:"decoder_attention_heads",val:" = 8"},{name:"is_encoder_decoder",val:" = True"},{name:"activation_function",val:" = 'prelu'"},{name:"hidden_size",val:" = 256"},{name:"dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.0"},{name:"activation_dropout",val:" = 0.0"},{name:"init_std",val:" = 0.02"},{name:"init_xavier_std",val:" = 1.0"},{name:"auxiliary_loss",val:" = False"},{name:"dilation",val:" = False"},{name:"class_cost",val:" = 2"},{name:"bbox_cost",val:" = 5"},{name:"giou_cost",val:" = 2"},{name:"cls_loss_coefficient",val:" = 2"},{name:"bbox_loss_coefficient",val:" = 5"},{name:"giou_loss_coefficient",val:" = 2"},{name:"focal_alpha",val:" = 0.25"},{name:"temperature_height",val:" = 20"},{name:"temperature_width",val:" = 20"},{name:"query_dim",val:" = 4"},{name:"random_refpoints_xy",val:" = False"},{name:"keep_query_pos",val:" = False"},{name:"num_patterns",val:" = 0"},{name:"normalize_before",val:" = False"},{name:"sine_position_embedding_scale",val:" = None"},{name:"initializer_bias_prior_prob",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DabDetrConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to use the <code>timm</code> library for the backbone. If set to <code>False</code>, will use the <a href="/docs/transformers/main/en/main_classes/backbones#transformers.AutoBackbone">AutoBackbone</a>
API.`,name:"use_timm_backbone"},{anchor:"transformers.DabDetrConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code> or <code>dict</code>, <em>optional</em>) &#x2014;
The configuration of the backbone model. Only used in case <code>use_timm_backbone</code> is set to <code>False</code> in which
case it will default to <code>ResNetConfig()</code>.`,name:"backbone_config"},{anchor:"transformers.DabDetrConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;resnet50&quot;</code>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.DabDetrConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.DabDetrConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.DabDetrConfig.num_queries",description:`<strong>num_queries</strong> (<code>int</code>, <em>optional</em>, defaults to 300) &#x2014;
Number of object queries, i.e. detection slots. This is the maximal number of objects
<a href="/docs/transformers/main/en/model_doc/dab-detr#transformers.DabDetrModel">DabDetrModel</a> can detect in a single image. For COCO, we recommend 100 queries.`,name:"num_queries"},{anchor:"transformers.DabDetrConfig.encoder_layers",description:`<strong>encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of encoder layers.`,name:"encoder_layers"},{anchor:"transformers.DabDetrConfig.encoder_ffn_dim",description:`<strong>encoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in encoder.`,name:"encoder_ffn_dim"},{anchor:"transformers.DabDetrConfig.encoder_attention_heads",description:`<strong>encoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"encoder_attention_heads"},{anchor:"transformers.DabDetrConfig.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of decoder layers.`,name:"decoder_layers"},{anchor:"transformers.DabDetrConfig.decoder_ffn_dim",description:`<strong>decoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"decoder_ffn_dim"},{anchor:"transformers.DabDetrConfig.decoder_attention_heads",description:`<strong>decoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"decoder_attention_heads"},{anchor:"transformers.DabDetrConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Indicates whether the transformer model architecture is an encoder-decoder or not.`,name:"is_encoder_decoder"},{anchor:"transformers.DabDetrConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;prelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.DabDetrConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
This parameter is a general dimension parameter, defining dimensions for components such as the encoder layer and projection parameters in the decoder layer, among others.`,name:"hidden_size"},{anchor:"transformers.DabDetrConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"dropout"},{anchor:"transformers.DabDetrConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.DabDetrConfig.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.DabDetrConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"init_std"},{anchor:"transformers.DabDetrConfig.init_xavier_std",description:`<strong>init_xavier_std</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The scaling factor used for the Xavier initialization gain in the HM Attention map module.`,name:"init_xavier_std"},{anchor:"transformers.DabDetrConfig.auxiliary_loss",description:`<strong>auxiliary_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether auxiliary decoding losses (loss at each decoder layer) are to be used.`,name:"auxiliary_loss"},{anchor:"transformers.DabDetrConfig.dilation",description:`<strong>dilation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to replace stride with dilation in the last convolutional block (DC5). Only supported when <code>use_timm_backbone</code> = <code>True</code>.`,name:"dilation"},{anchor:"transformers.DabDetrConfig.class_cost",description:`<strong>class_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the classification error in the Hungarian matching cost.`,name:"class_cost"},{anchor:"transformers.DabDetrConfig.bbox_cost",description:`<strong>bbox_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 5) &#x2014;
Relative weight of the L1 error of the bounding box coordinates in the Hungarian matching cost.`,name:"bbox_cost"},{anchor:"transformers.DabDetrConfig.giou_cost",description:`<strong>giou_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the generalized IoU loss of the bounding box in the Hungarian matching cost.`,name:"giou_cost"},{anchor:"transformers.DabDetrConfig.cls_loss_coefficient",description:`<strong>cls_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the classification loss in the object detection loss function.`,name:"cls_loss_coefficient"},{anchor:"transformers.DabDetrConfig.bbox_loss_coefficient",description:`<strong>bbox_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 5) &#x2014;
Relative weight of the L1 bounding box loss in the object detection loss.`,name:"bbox_loss_coefficient"},{anchor:"transformers.DabDetrConfig.giou_loss_coefficient",description:`<strong>giou_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the generalized IoU loss in the object detection loss.`,name:"giou_loss_coefficient"},{anchor:"transformers.DabDetrConfig.focal_alpha",description:`<strong>focal_alpha</strong> (<code>float</code>, <em>optional</em>, defaults to 0.25) &#x2014;
Alpha parameter in the focal loss.`,name:"focal_alpha"},{anchor:"transformers.DabDetrConfig.temperature_height",description:`<strong>temperature_height</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
Temperature parameter to tune the flatness of positional attention (HEIGHT)`,name:"temperature_height"},{anchor:"transformers.DabDetrConfig.temperature_width",description:`<strong>temperature_width</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
Temperature parameter to tune the flatness of positional attention (WIDTH)`,name:"temperature_width"},{anchor:"transformers.DabDetrConfig.query_dim",description:`<strong>query_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Query dimension parameter represents the size of the output vector.`,name:"query_dim"},{anchor:"transformers.DabDetrConfig.random_refpoints_xy",description:`<strong>random_refpoints_xy</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to fix the x and y coordinates of the anchor boxes with random initialization.`,name:"random_refpoints_xy"},{anchor:"transformers.DabDetrConfig.keep_query_pos",description:`<strong>keep_query_pos</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to concatenate the projected positional embedding from the object query into the original query (key) in every decoder layer.`,name:"keep_query_pos"},{anchor:"transformers.DabDetrConfig.num_patterns",description:`<strong>num_patterns</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Number of pattern embeddings.`,name:"num_patterns"},{anchor:"transformers.DabDetrConfig.normalize_before",description:`<strong>normalize_before</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether we use a normalization layer in the Encoder or not.`,name:"normalize_before"},{anchor:"transformers.DabDetrConfig.sine_position_embedding_scale",description:`<strong>sine_position_embedding_scale</strong> (<code>float</code>, <em>optional</em>, defaults to &#x2018;None&#x2019;) &#x2014;
Scaling factor applied to the normalized positional encodings.`,name:"sine_position_embedding_scale"},{anchor:"transformers.DabDetrConfig.initializer_bias_prior_prob",description:`<strong>initializer_bias_prior_prob</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The prior probability used by the bias initializer to initialize biases for <code>enc_score_head</code> and <code>class_embed</code>.
If <code>None</code>, <code>prior_prob</code> computed as <code>prior_prob = 1 / (num_labels + 1)</code> while initializing model weights.`,name:"initializer_bias_prior_prob"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/dab_detr/configuration_dab_detr.py#L26"}}),E=new yt({props:{anchor:"transformers.DabDetrConfig.example",$$slots:{default:[Ot]},$$scope:{ctx:k}}}),le=new Je({props:{title:"DabDetrModel",local:"transformers.DabDetrModel",headingTag:"h2"}}),ie=new xe({props:{name:"class transformers.DabDetrModel",anchor:"transformers.DabDetrModel",parameters:[{name:"config",val:": DabDetrConfig"}],parametersDescription:[{anchor:"transformers.DabDetrModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/dab-detr#transformers.DabDetrConfig">DabDetrConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/dab_detr/modeling_dab_detr.py#L1276"}}),de=new xe({props:{name:"forward",anchor:"transformers.DabDetrModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"pixel_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.DabDetrModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it.</p>
<p>Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/vilt#transformers.ViltFeatureExtractor.__call__">DetrImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.DabDetrModel.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.DabDetrModel.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries)</code>, <em>optional</em>) &#x2014;
Not used by default. Can be used to mask object queries.`,name:"decoder_attention_mask"},{anchor:"transformers.DabDetrModel.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.DabDetrModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing the flattened feature map (output of the backbone + projection layer), you
can choose to directly pass a flattened representation of an image.`,name:"inputs_embeds"},{anchor:"transformers.DabDetrModel.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of initializing the queries with a tensor of zeros, you can choose to directly pass an
embedded representation.`,name:"decoder_inputs_embeds"},{anchor:"transformers.DabDetrModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DabDetrModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DabDetrModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/dab_detr/modeling_dab_detr.py#L1341",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.dab_detr.modeling_dab_detr.DabDetrModelOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/dab-detr#transformers.DabDetrConfig"
>DabDetrConfig</a>) and inputs.</p>
<ul>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the decoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the encoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
<li><strong>intermediate_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(config.decoder_layers, batch_size, sequence_length, hidden_size)</code>, <em>optional</em>, returned when <code>config.auxiliary_loss=True</code>) — Intermediate decoder activations, i.e. the output of each decoder layer, each of them gone through a
layernorm.</li>
<li><strong>reference_points</strong> (<code>torch.FloatTensor</code> of shape <code>(config.decoder_layers, batch_size, num_queries, 2 (anchor points))</code>) — Reference points (reference points of each layer of the decoder).</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.dab_detr.modeling_dab_detr.DabDetrModelOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),z=new qt({props:{$$slots:{default:[Pt]},$$scope:{ctx:k}}}),N=new yt({props:{anchor:"transformers.DabDetrModel.forward.example",$$slots:{default:[Lt]},$$scope:{ctx:k}}}),ce=new Je({props:{title:"DabDetrForObjectDetection",local:"transformers.DabDetrForObjectDetection",headingTag:"h2"}}),pe=new xe({props:{name:"class transformers.DabDetrForObjectDetection",anchor:"transformers.DabDetrForObjectDetection",parameters:[{name:"config",val:": DabDetrConfig"}],parametersDescription:[{anchor:"transformers.DabDetrForObjectDetection.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/dab-detr#transformers.DabDetrConfig">DabDetrConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/dab_detr/modeling_dab_detr.py#L1546"}}),me=new xe({props:{name:"forward",anchor:"transformers.DabDetrForObjectDetection.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"pixel_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[typing.List[dict]] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.DabDetrForObjectDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it.</p>
<p>Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/vilt#transformers.ViltFeatureExtractor.__call__">DetrImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.DabDetrForObjectDetection.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.DabDetrForObjectDetection.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries)</code>, <em>optional</em>) &#x2014;
Not used by default. Can be used to mask object queries.`,name:"decoder_attention_mask"},{anchor:"transformers.DabDetrForObjectDetection.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.DabDetrForObjectDetection.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing the flattened feature map (output of the backbone + projection layer), you
can choose to directly pass a flattened representation of an image.`,name:"inputs_embeds"},{anchor:"transformers.DabDetrForObjectDetection.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of initializing the queries with a tensor of zeros, you can choose to directly pass an
embedded representation.`,name:"decoder_inputs_embeds"},{anchor:"transformers.DabDetrForObjectDetection.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DabDetrForObjectDetection.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DabDetrForObjectDetection.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.DabDetrForObjectDetection.forward.labels",description:`<strong>labels</strong> (<code>List[Dict]</code> of len <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the bipartite matching loss. List of dicts, each dictionary containing at least the
following 2 keys: &#x2018;class_labels&#x2019; and &#x2018;boxes&#x2019; (the class labels and bounding boxes of an image in the batch
respectively). The class labels themselves should be a <code>torch.LongTensor</code> of len <code>(number of bounding boxes in the image,)</code> and the boxes a <code>torch.FloatTensor</code> of shape <code>(number of bounding boxes in the image, 4)</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/dab_detr/modeling_dab_detr.py#L1590",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.dab_detr.modeling_dab_detr.DabDetrObjectDetectionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/dab-detr#transformers.DabDetrConfig"
>DabDetrConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> are provided)) — Total loss as a linear combination of a negative log-likehood (cross-entropy) for class prediction and a
bounding box loss. The latter is defined as a linear combination of the L1 loss and the generalized
scale-invariant IoU loss.</li>
<li><strong>loss_dict</strong> (<code>Dict</code>, <em>optional</em>) — A dictionary containing the individual losses. Useful for logging.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes + 1)</code>) — Classification logits (including no-object) for all queries.</li>
<li><strong>pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual image in the batch (disregarding
possible padding). You can use <code>~DabDetrImageProcessor.post_process_object_detection</code> to retrieve the
unnormalized bounding boxes.</li>
<li><strong>auxiliary_outputs</strong> (<code>list[Dict]</code>, <em>optional</em>) — Optional, only returned when auxiliary losses are activated (i.e. <code>config.auxiliary_loss</code> is set to <code>True</code>)
and labels are provided. It is a list of dictionaries containing the two above keys (<code>logits</code> and
<code>pred_boxes</code>) for each decoder layer.</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the decoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the encoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.dab_detr.modeling_dab_detr.DabDetrObjectDetectionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),W=new qt({props:{$$slots:{default:[Kt]},$$scope:{ctx:k}}}),B=new yt({props:{anchor:"transformers.DabDetrForObjectDetection.forward.example",$$slots:{default:[eo]},$$scope:{ctx:k}}}),he=new St({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/dab-detr.md"}}),{c(){s=i("meta"),T=r(),c=i("p"),p=r(),u(w.$$.fragment),a=r(),M=i("div"),M.innerHTML=wt,Ue=r(),u(q.$$.fragment),Ce=r(),V=i("p"),V.innerHTML=Mt,$e=r(),F=i("img"),Ie=r(),Y=i("p"),Y.textContent=jt,Ze=r(),G=i("p"),G.innerHTML=Dt,Re=r(),A=i("p"),A.innerHTML=Jt,Fe=r(),u(Q.$$.fragment),Ee=r(),H=i("p"),H.textContent=vt,ze=r(),u(S.$$.fragment),Ne=r(),O=i("p"),O.textContent=xt,We=r(),u(P.$$.fragment),Be=r(),L=i("p"),L.textContent=kt,Xe=r(),K=i("p"),K.textContent=Ut,qe=r(),u(ee.$$.fragment),Ve=r(),te=i("p"),te.textContent=Ct,Ye=r(),u(oe.$$.fragment),Ge=r(),ne=i("p"),ne.textContent=$t,Ae=r(),u(se.$$.fragment),Qe=r(),u(ae.$$.fragment),He=r(),J=i("div"),u(re.$$.fragment),ot=r(),fe=i("p"),fe.innerHTML=It,nt=r(),ge=i("p"),ge.innerHTML=Zt,st=r(),u(E.$$.fragment),Se=r(),u(le.$$.fragment),Oe=r(),j=i("div"),u(ie.$$.fragment),at=r(),be=i("p"),be.textContent=Rt,rt=r(),_e=i("p"),_e.innerHTML=Ft,lt=r(),ye=i("p"),ye.innerHTML=Et,it=r(),U=i("div"),u(de.$$.fragment),dt=r(),we=i("p"),we.innerHTML=zt,ct=r(),u(z.$$.fragment),pt=r(),u(N.$$.fragment),Pe=r(),u(ce.$$.fragment),Le=r(),D=i("div"),u(pe.$$.fragment),mt=r(),Me=i("p"),Me.textContent=Nt,ht=r(),Te=i("p"),Te.innerHTML=Wt,ut=r(),je=i("p"),je.innerHTML=Bt,ft=r(),C=i("div"),u(me.$$.fragment),gt=r(),De=i("p"),De.innerHTML=Xt,bt=r(),u(W.$$.fragment),_t=r(),u(B.$$.fragment),Ke=r(),u(he.$$.fragment),et=r(),ve=i("p"),this.h()},l(e){const t=Ht("svelte-u9bgzb",document.head);s=d(t,"META",{name:!0,content:!0}),t.forEach(o),T=l(e),c=d(e,"P",{}),ue(c).forEach(o),p=l(e),f(w.$$.fragment,e),a=l(e),M=d(e,"DIV",{class:!0,"data-svelte-h":!0}),h(M)!=="svelte-13t8s2t"&&(M.innerHTML=wt),Ue=l(e),f(q.$$.fragment,e),Ce=l(e),V=d(e,"P",{"data-svelte-h":!0}),h(V)!=="svelte-9auo1u"&&(V.innerHTML=Mt),$e=l(e),F=d(e,"IMG",{src:!0,alt:!0,width:!0}),Ie=l(e),Y=d(e,"P",{"data-svelte-h":!0}),h(Y)!=="svelte-vfdo9a"&&(Y.textContent=jt),Ze=l(e),G=d(e,"P",{"data-svelte-h":!0}),h(G)!=="svelte-ct3tl8"&&(G.innerHTML=Dt),Re=l(e),A=d(e,"P",{"data-svelte-h":!0}),h(A)!=="svelte-yd6iz"&&(A.innerHTML=Jt),Fe=l(e),f(Q.$$.fragment,e),Ee=l(e),H=d(e,"P",{"data-svelte-h":!0}),h(H)!=="svelte-15ft1fk"&&(H.textContent=vt),ze=l(e),f(S.$$.fragment,e),Ne=l(e),O=d(e,"P",{"data-svelte-h":!0}),h(O)!=="svelte-192r0ao"&&(O.textContent=xt),We=l(e),f(P.$$.fragment,e),Be=l(e),L=d(e,"P",{"data-svelte-h":!0}),h(L)!=="svelte-1bp0kxx"&&(L.textContent=kt),Xe=l(e),K=d(e,"P",{"data-svelte-h":!0}),h(K)!=="svelte-1m4ojtg"&&(K.textContent=Ut),qe=l(e),f(ee.$$.fragment,e),Ve=l(e),te=d(e,"P",{"data-svelte-h":!0}),h(te)!=="svelte-fa3upe"&&(te.textContent=Ct),Ye=l(e),f(oe.$$.fragment,e),Ge=l(e),ne=d(e,"P",{"data-svelte-h":!0}),h(ne)!=="svelte-1m4gpgg"&&(ne.textContent=$t),Ae=l(e),f(se.$$.fragment,e),Qe=l(e),f(ae.$$.fragment,e),He=l(e),J=d(e,"DIV",{class:!0});var $=ue(J);f(re.$$.fragment,$),ot=l($),fe=d($,"P",{"data-svelte-h":!0}),h(fe)!=="svelte-e9hd6g"&&(fe.innerHTML=It),nt=l($),ge=d($,"P",{"data-svelte-h":!0}),h(ge)!=="svelte-o55m63"&&(ge.innerHTML=Zt),st=l($),f(E.$$.fragment,$),$.forEach(o),Se=l(e),f(le.$$.fragment,e),Oe=l(e),j=d(e,"DIV",{class:!0});var v=ue(j);f(ie.$$.fragment,v),at=l(v),be=d(v,"P",{"data-svelte-h":!0}),h(be)!=="svelte-19gfwdg"&&(be.textContent=Rt),rt=l(v),_e=d(v,"P",{"data-svelte-h":!0}),h(_e)!=="svelte-6pahdo"&&(_e.innerHTML=Ft),lt=l(v),ye=d(v,"P",{"data-svelte-h":!0}),h(ye)!=="svelte-hswkmf"&&(ye.innerHTML=Et),it=l(v),U=d(v,"DIV",{class:!0});var I=ue(U);f(de.$$.fragment,I),dt=l(I),we=d(I,"P",{"data-svelte-h":!0}),h(we)!=="svelte-1kbhf0"&&(we.innerHTML=zt),ct=l(I),f(z.$$.fragment,I),pt=l(I),f(N.$$.fragment,I),I.forEach(o),v.forEach(o),Pe=l(e),f(ce.$$.fragment,e),Le=l(e),D=d(e,"DIV",{class:!0});var x=ue(D);f(pe.$$.fragment,x),mt=l(x),Me=d(x,"P",{"data-svelte-h":!0}),h(Me)!=="svelte-13cvp2k"&&(Me.textContent=Nt),ht=l(x),Te=d(x,"P",{"data-svelte-h":!0}),h(Te)!=="svelte-6pahdo"&&(Te.innerHTML=Wt),ut=l(x),je=d(x,"P",{"data-svelte-h":!0}),h(je)!=="svelte-hswkmf"&&(je.innerHTML=Bt),ft=l(x),C=d(x,"DIV",{class:!0});var Z=ue(C);f(me.$$.fragment,Z),gt=l(Z),De=d(Z,"P",{"data-svelte-h":!0}),h(De)!=="svelte-1uj33qu"&&(De.innerHTML=Xt),bt=l(Z),f(W.$$.fragment,Z),_t=l(Z),f(B.$$.fragment,Z),Z.forEach(o),x.forEach(o),Ke=l(e),f(he.$$.fragment,e),et=l(e),ve=d(e,"P",{}),ue(ve).forEach(o),this.h()},h(){R(s,"name","hf:doc:metadata"),R(s,"content",oo),R(M,"class","flex flex-wrap space-x-1"),Yt(F.src,Tt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/dab_detr_convergence_plot.png")||R(F,"src",Tt),R(F,"alt","drawing"),R(F,"width","600"),R(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),R(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),R(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),R(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),R(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){m(document.head,s),n(e,T,t),n(e,c,t),n(e,p,t),g(w,e,t),n(e,a,t),n(e,M,t),n(e,Ue,t),g(q,e,t),n(e,Ce,t),n(e,V,t),n(e,$e,t),n(e,F,t),n(e,Ie,t),n(e,Y,t),n(e,Ze,t),n(e,G,t),n(e,Re,t),n(e,A,t),n(e,Fe,t),g(Q,e,t),n(e,Ee,t),n(e,H,t),n(e,ze,t),g(S,e,t),n(e,Ne,t),n(e,O,t),n(e,We,t),g(P,e,t),n(e,Be,t),n(e,L,t),n(e,Xe,t),n(e,K,t),n(e,qe,t),g(ee,e,t),n(e,Ve,t),n(e,te,t),n(e,Ye,t),g(oe,e,t),n(e,Ge,t),n(e,ne,t),n(e,Ae,t),g(se,e,t),n(e,Qe,t),g(ae,e,t),n(e,He,t),n(e,J,t),g(re,J,null),m(J,ot),m(J,fe),m(J,nt),m(J,ge),m(J,st),g(E,J,null),n(e,Se,t),g(le,e,t),n(e,Oe,t),n(e,j,t),g(ie,j,null),m(j,at),m(j,be),m(j,rt),m(j,_e),m(j,lt),m(j,ye),m(j,it),m(j,U),g(de,U,null),m(U,dt),m(U,we),m(U,ct),g(z,U,null),m(U,pt),g(N,U,null),n(e,Pe,t),g(ce,e,t),n(e,Le,t),n(e,D,t),g(pe,D,null),m(D,mt),m(D,Me),m(D,ht),m(D,Te),m(D,ut),m(D,je),m(D,ft),m(D,C),g(me,C,null),m(C,gt),m(C,De),m(C,bt),g(W,C,null),m(C,_t),g(B,C,null),n(e,Ke,t),g(he,e,t),n(e,et,t),n(e,ve,t),tt=!0},p(e,[t]){const $={};t&2&&($.$$scope={dirty:t,ctx:e}),E.$set($);const v={};t&2&&(v.$$scope={dirty:t,ctx:e}),z.$set(v);const I={};t&2&&(I.$$scope={dirty:t,ctx:e}),N.$set(I);const x={};t&2&&(x.$$scope={dirty:t,ctx:e}),W.$set(x);const Z={};t&2&&(Z.$$scope={dirty:t,ctx:e}),B.$set(Z)},i(e){tt||(b(w.$$.fragment,e),b(q.$$.fragment,e),b(Q.$$.fragment,e),b(S.$$.fragment,e),b(P.$$.fragment,e),b(ee.$$.fragment,e),b(oe.$$.fragment,e),b(se.$$.fragment,e),b(ae.$$.fragment,e),b(re.$$.fragment,e),b(E.$$.fragment,e),b(le.$$.fragment,e),b(ie.$$.fragment,e),b(de.$$.fragment,e),b(z.$$.fragment,e),b(N.$$.fragment,e),b(ce.$$.fragment,e),b(pe.$$.fragment,e),b(me.$$.fragment,e),b(W.$$.fragment,e),b(B.$$.fragment,e),b(he.$$.fragment,e),tt=!0)},o(e){_(w.$$.fragment,e),_(q.$$.fragment,e),_(Q.$$.fragment,e),_(S.$$.fragment,e),_(P.$$.fragment,e),_(ee.$$.fragment,e),_(oe.$$.fragment,e),_(se.$$.fragment,e),_(ae.$$.fragment,e),_(re.$$.fragment,e),_(E.$$.fragment,e),_(le.$$.fragment,e),_(ie.$$.fragment,e),_(de.$$.fragment,e),_(z.$$.fragment,e),_(N.$$.fragment,e),_(ce.$$.fragment,e),_(pe.$$.fragment,e),_(me.$$.fragment,e),_(W.$$.fragment,e),_(B.$$.fragment,e),_(he.$$.fragment,e),tt=!1},d(e){e&&(o(T),o(c),o(p),o(a),o(M),o(Ue),o(Ce),o(V),o($e),o(F),o(Ie),o(Y),o(Ze),o(G),o(Re),o(A),o(Fe),o(Ee),o(H),o(ze),o(Ne),o(O),o(We),o(Be),o(L),o(Xe),o(K),o(qe),o(Ve),o(te),o(Ye),o(Ge),o(ne),o(Ae),o(Qe),o(He),o(J),o(Se),o(Oe),o(j),o(Pe),o(Le),o(D),o(Ke),o(et),o(ve)),o(s),y(w,e),y(q,e),y(Q,e),y(S,e),y(P,e),y(ee,e),y(oe,e),y(se,e),y(ae,e),y(re),y(E),y(le,e),y(ie),y(de),y(z),y(N),y(ce,e),y(pe),y(me),y(W),y(B),y(he,e)}}}const oo='{"title":"DAB-DETR","local":"dab-detr","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"How to Get Started with the Model","local":"how-to-get-started-with-the-model","sections":[],"depth":2},{"title":"DabDetrConfig","local":"transformers.DabDetrConfig","sections":[],"depth":2},{"title":"DabDetrModel","local":"transformers.DabDetrModel","sections":[],"depth":2},{"title":"DabDetrForObjectDetection","local":"transformers.DabDetrForObjectDetection","sections":[],"depth":2}],"depth":1}';function no(k){return Gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ho extends At{constructor(s){super(),Qt(this,s,no,to,Vt,{})}}export{ho as component};
