import{s as vt,z as Ct,o as kt,n as ye}from"../chunks/scheduler.18a86fab.js";import{S as Ut,i as xt,g as d,s as r,r as h,A as Zt,h as p,f as o,c as i,j as de,u as f,x as M,k as W,y as m,a as s,v as u,d as g,t as _,w as b}from"../chunks/index.98837b22.js";import{T as it}from"../chunks/Tip.77304350.js";import{D as Me}from"../chunks/Docstring.6758ea23.js";import{C as Se}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as lt}from"../chunks/ExampleCodeBlock.0c42463f.js";import{P as Wt}from"../chunks/PipelineTag.7749150e.js";import{H as pe}from"../chunks/Heading.7e7e0c5b.js";import{E as Ft}from"../chunks/index.f01015d9.js";function Et(I){let a,y="Example:",l,c,w;return c=new Se({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMElKZXBhQ29uZmlnJTJDJTIwSUplcGFNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBJSkVQQSUyMGlqZXBhLWJhc2UtcGF0Y2gxNi0yMjQlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwSUplcGFDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwaWplcGEtYmFzZS1wYXRjaDE2LTIyNCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwSUplcGFNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> IJepaConfig, IJepaModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a IJEPA ijepa-base-patch16-224 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = IJepaConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the ijepa-base-patch16-224 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = IJepaModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){a=d("p"),a.textContent=y,l=r(),h(c.$$.fragment)},l(n){a=p(n,"P",{"data-svelte-h":!0}),M(a)!=="svelte-11lpom8"&&(a.textContent=y),l=i(n),f(c.$$.fragment,n)},m(n,J){s(n,a,J),s(n,l,J),u(c,n,J),w=!0},p:ye,i(n){w||(g(c.$$.fragment,n),w=!0)},o(n){_(c.$$.fragment,n),w=!1},d(n){n&&(o(a),o(l)),b(c,n)}}}function zt(I){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=d("p"),a.innerHTML=y},l(l){a=p(l,"P",{"data-svelte-h":!0}),M(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(l,c){s(l,a,c)},p:ye,d(l){l&&o(a)}}}function Bt(I){let a,y="Example:",l,c,w;return c=new Se({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMElKZXBhTW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaHVnZ2luZ2ZhY2UlMkZjYXRzLWltYWdlJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQWltYWdlJTIwJTNEJTIwZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlNUIlMjJpbWFnZSUyMiU1RCU1QjAlNUQlMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGaWplcGFfdml0aDE0XzFrJTIyKSUwQW1vZGVsJTIwJTNEJTIwSUplcGFNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZpamVwYV92aXRoMTRfMWslMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGUlMEFsaXN0KGxhc3RfaGlkZGVuX3N0YXRlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, IJepaModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/ijepa_vith14_1k&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = IJepaModel.from_pretrained(<span class="hljs-string">&quot;facebook/ijepa_vith14_1k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">256</span>, <span class="hljs-number">1280</span>]`,wrap:!1}}),{c(){a=d("p"),a.textContent=y,l=r(),h(c.$$.fragment)},l(n){a=p(n,"P",{"data-svelte-h":!0}),M(a)!=="svelte-11lpom8"&&(a.textContent=y),l=i(n),f(c.$$.fragment,n)},m(n,J){s(n,a,J),s(n,l,J),u(c,n,J),w=!0},p:ye,i(n){w||(g(c.$$.fragment,n),w=!0)},o(n){_(c.$$.fragment,n),w=!1},d(n){n&&(o(a),o(l)),b(c,n)}}}function Nt(I){let a,y=`Note that it’s possible to fine-tune IJepa on higher resolution images than the ones it has been trained on, by
setting <code>interpolate_pos_encoding</code> to <code>True</code> in the forward of the model. This will interpolate the pre-trained
position embeddings to the higher resolution.`;return{c(){a=d("p"),a.innerHTML=y},l(l){a=p(l,"P",{"data-svelte-h":!0}),M(a)!=="svelte-lhh59f"&&(a.innerHTML=y)},m(l,c){s(l,a,c)},p:ye,d(l){l&&o(a)}}}function Gt(I){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=d("p"),a.innerHTML=y},l(l){a=p(l,"P",{"data-svelte-h":!0}),M(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(l,c){s(l,a,c)},p:ye,d(l){l&&o(a)}}}function Rt(I){let a,y="Example:",l,c,w;return c=new Se({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMElKZXBhRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJodWdnaW5nZmFjZSUyRmNhdHMtaW1hZ2UlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBaW1hZ2UlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCU1QiUyMmltYWdlJTIyJTVEJTVCMCU1RCUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZpamVwYV92aXRoMTRfMWslMjIpJTBBbW9kZWwlMjAlM0QlMjBJSmVwYUZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGaWplcGFfdml0aDE0XzFrJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEElMjMlMjBtb2RlbCUyMHByZWRpY3RzJTIwb25lJTIwb2YlMjB0aGUlMjAxMDAwJTIwSW1hZ2VOZXQlMjBjbGFzc2VzJTBBcHJlZGljdGVkX2xhYmVsJTIwJTNEJTIwbG9naXRzLmFyZ21heCgtMSkuaXRlbSgpJTBBcHJpbnQobW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2xhYmVsJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, IJepaForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/ijepa_vith14_1k&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = IJepaForImageClassification.from_pretrained(<span class="hljs-string">&quot;facebook/ijepa_vith14_1k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
Egyptian cat`,wrap:!1}}),{c(){a=d("p"),a.textContent=y,l=r(),h(c.$$.fragment)},l(n){a=p(n,"P",{"data-svelte-h":!0}),M(a)!=="svelte-11lpom8"&&(a.textContent=y),l=i(n),f(c.$$.fragment,n)},m(n,J){s(n,a,J),s(n,l,J),u(c,n,J),w=!0},p:ye,i(n){w||(g(c.$$.fragment,n),w=!0)},o(n){_(c.$$.fragment,n),w=!1},d(n){n&&(o(a),o(l)),b(c,n)}}}function Vt(I){let a,y,l,c,w,n,J,ct='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',Je,X,Te,P,dt=`The I-JEPA model was proposed in <a href="https://arxiv.org/abs/2301.08243" rel="nofollow">Image-based Joint-Embedding Predictive Architecture</a> by Mahmoud Assran, Quentin Duval, Ishan Misra, Piotr Bojanowski, Pascal Vincent, Michael Rabbat, Yann LeCun, Nicolas Ballas.
I-JEPA is a self-supervised learning method that predicts the representations of one part of an image based on other parts of the same image. This approach focuses on learning semantic features without relying on pre-defined invariances from hand-crafted data transformations, which can bias specific tasks, or on filling in pixel-level details, which often leads to less meaningful representations.`,Ie,Q,pt="The abstract from the paper is the following:",$e,S,mt="This paper demonstrates an approach for learning highly semantic image representations without relying on hand-crafted data-augmentations. We introduce the Image- based Joint-Embedding Predictive Architecture (I-JEPA), a non-generative approach for self-supervised learning from images. The idea behind I-JEPA is simple: from a single context block, predict the representations of various target blocks in the same image. A core design choice to guide I-JEPA towards producing semantic representations is the masking strategy; specifically, it is crucial to (a) sample tar- get blocks with sufficiently large scale (semantic), and to (b) use a sufficiently informative (spatially distributed) context block. Empirically, when combined with Vision Transform- ers, we find I-JEPA to be highly scalable. For instance, we train a ViT-Huge/14 on ImageNet using 16 A100 GPUs in under 72 hours to achieve strong downstream performance across a wide range of tasks, from linear classification to object counting and depth prediction.",je,E,ht,ve,H,ft='I-JEPA architecture. Taken from the <a href="https://arxiv.org/abs/2301.08243">original paper.</a>',Ce,Y,ut=`This model was contributed by <a href="https://huggingface.co/jmtzt" rel="nofollow">jmtzt</a>.
The original code can be found <a href="https://github.com/facebookresearch/ijepa" rel="nofollow">here</a>.`,ke,A,Ue,q,gt="Here is how to use this model for image feature extraction:",xe,L,Ze,D,We,O,_t="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with I-JEPA.",Fe,K,Ee,ee,bt='<li><a href="/docs/transformers/main/en/model_doc/ijepa#transformers.IJepaForImageClassification">IJepaForImageClassification</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/image-classification" rel="nofollow">example script</a> and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/image_classification.ipynb" rel="nofollow">notebook</a>.</li> <li>See also: <a href="../tasks/image_classification">Image classification task guide</a></li>',ze,te,Be,$,oe,He,me,yt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/ijepa#transformers.IJepaModel">IJepaModel</a>. It is used to instantiate an IJEPA
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the I-JEPA
<a href="https://huggingface.co/facebook/ijepa_vith14_1k" rel="nofollow">facebook/ijepa_vith14_1k</a> architecture.`,Ye,he,wt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ae,z,Ne,ae,Ge,k,ne,qe,fe,Mt=`The bare IJepa Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Le,v,se,De,ue,Jt='The <a href="/docs/transformers/main/en/model_doc/ijepa#transformers.IJepaModel">IJepaModel</a> forward method, overrides the <code>__call__</code> special method.',Oe,B,Ke,N,Re,re,Ve,T,ie,et,ge,Tt=`IJepa Model transformer with an image classification head on top (a linear layer on top of the final hidden states)
e.g. for ImageNet.`,tt,G,ot,_e,It=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,at,C,le,nt,be,$t='The <a href="/docs/transformers/main/en/model_doc/ijepa#transformers.IJepaForImageClassification">IJepaForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',st,R,rt,V,Xe,ce,Pe,we,Qe;return w=new pe({props:{title:"I-JEPA",local:"i-jepa",headingTag:"h1"}}),X=new pe({props:{title:"Overview",local:"overview",headingTag:"h2"}}),A=new pe({props:{title:"How to use",local:"how-to-use",headingTag:"h2"}}),L=new Se({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjB0b3JjaC5ubi5mdW5jdGlvbmFsJTIwaW1wb3J0JTIwY29zaW5lX3NpbWlsYXJpdHklMEElMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTJDJTIwQXV0b1Byb2Nlc3NvciUwQSUwQXVybF8xJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQXVybF8yJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMjE5NTc4LmpwZyUyMiUwQWltYWdlXzElMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmxfMSUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbWFnZV8yJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsXzIlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJmYWNlYm9vayUyRmlqZXBhX3ZpdGgxNF8xayUyMiUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMEElNDB0b3JjaC5ub19ncmFkKCklMEFkZWYlMjBpbmZlcihpbWFnZSklM0ElMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlLm1lYW4oZGltJTNEMSklMEElMEElMEFlbWJlZF8xJTIwJTNEJTIwaW5mZXIoaW1hZ2VfMSklMEFlbWJlZF8yJTIwJTNEJTIwaW5mZXIoaW1hZ2VfMiklMEElMEFzaW1pbGFyaXR5JTIwJTNEJTIwY29zaW5lX3NpbWlsYXJpdHkoZW1iZWRfMSUyQyUyMGVtYmVkXzIpJTBBcHJpbnQoc2ltaWxhcml0eSk=",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> torch.nn.functional <span class="hljs-keyword">import</span> cosine_similarity

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel, AutoProcessor

url_1 = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
url_2 = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000219578.jpg&quot;</span>
image_1 = Image.<span class="hljs-built_in">open</span>(requests.get(url_1, stream=<span class="hljs-literal">True</span>).raw)
image_2 = Image.<span class="hljs-built_in">open</span>(requests.get(url_2, stream=<span class="hljs-literal">True</span>).raw)

model_id = <span class="hljs-string">&quot;facebook/ijepa_vith14_1k&quot;</span>
processor = AutoProcessor.from_pretrained(model_id)
model = AutoModel.from_pretrained(model_id)

<span class="hljs-meta">@torch.no_grad()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">infer</span>(<span class="hljs-params">image</span>):
    inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    outputs = model(**inputs)
    <span class="hljs-keyword">return</span> outputs.last_hidden_state.mean(dim=<span class="hljs-number">1</span>)


embed_1 = infer(image_1)
embed_2 = infer(image_2)

similarity = cosine_similarity(embed_1, embed_2)
<span class="hljs-built_in">print</span>(similarity)`,wrap:!1}}),D=new pe({props:{title:"Resources",local:"resources",headingTag:"h2"}}),K=new Wt({props:{pipeline:"image-classification"}}),te=new pe({props:{title:"IJepaConfig",local:"transformers.IJepaConfig",headingTag:"h2"}}),oe=new Me({props:{name:"class transformers.IJepaConfig",anchor:"transformers.IJepaConfig",parameters:[{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"image_size",val:" = 224"},{name:"patch_size",val:" = 16"},{name:"num_channels",val:" = 3"},{name:"qkv_bias",val:" = True"},{name:"pooler_output_size",val:" = None"},{name:"pooler_act",val:" = 'tanh'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.IJepaConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.IJepaConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.IJepaConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.IJepaConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.IJepaConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.IJepaConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.IJepaConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.IJepaConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.IJepaConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.IJepaConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.IJepaConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.IJepaConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.IJepaConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a bias to the queries, keys and values.`,name:"qkv_bias"},{anchor:"transformers.IJepaConfig.pooler_output_size",description:`<strong>pooler_output_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Dimensionality of the pooler layer. If None, defaults to <code>hidden_size</code>.`,name:"pooler_output_size"},{anchor:"transformers.IJepaConfig.pooler_act",description:`<strong>pooler_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;tanh&quot;</code>) &#x2014;
The activation function to be used by the pooler. Keys of ACT2FN are supported for Flax and
Pytorch, and elements of <a href="https://www.tensorflow.org/api_docs/python/tf/keras/activations" rel="nofollow">https://www.tensorflow.org/api_docs/python/tf/keras/activations</a> are
supported for Tensorflow.`,name:"pooler_act"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/ijepa/configuration_ijepa.py#L20"}}),z=new lt({props:{anchor:"transformers.IJepaConfig.example",$$slots:{default:[Et]},$$scope:{ctx:I}}}),ae=new pe({props:{title:"IJepaModel",local:"transformers.IJepaModel",headingTag:"h2"}}),ne=new Me({props:{name:"class transformers.IJepaModel",anchor:"transformers.IJepaModel",parameters:[{name:"config",val:": IJepaConfig"},{name:"add_pooling_layer",val:": bool = False"},{name:"use_mask_token",val:": bool = False"}],parametersDescription:[{anchor:"transformers.IJepaModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/ijepa#transformers.IJepaConfig">IJepaConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/ijepa/modeling_ijepa.py#L521"}}),se=new Me({props:{name:"forward",anchor:"transformers.IJepaModel.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"bool_masked_pos",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.IJepaModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <code>IJepaImageProcessor.__call__</code>
for details.`,name:"pixel_values"},{anchor:"transformers.IJepaModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.IJepaModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.IJepaModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.IJepaModel.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.IJepaModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.IJepaModel.forward.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, num_patches)</code>, <em>optional</em>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0).`,name:"bool_masked_pos"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/ijepa/modeling_ijepa.py#L549",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/ijepa#transformers.IJepaConfig"
>IJepaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),B=new it({props:{$$slots:{default:[zt]},$$scope:{ctx:I}}}),N=new lt({props:{anchor:"transformers.IJepaModel.forward.example",$$slots:{default:[Bt]},$$scope:{ctx:I}}}),re=new pe({props:{title:"IJepaForImageClassification",local:"transformers.IJepaForImageClassification",headingTag:"h2"}}),ie=new Me({props:{name:"class transformers.IJepaForImageClassification",anchor:"transformers.IJepaForImageClassification",parameters:[{name:"config",val:": IJepaConfig"}],parametersDescription:[{anchor:"transformers.IJepaForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/ijepa#transformers.IJepaConfig">IJepaConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/ijepa/modeling_ijepa.py#L623"}}),G=new it({props:{$$slots:{default:[Nt]},$$scope:{ctx:I}}}),le=new Me({props:{name:"forward",anchor:"transformers.IJepaForImageClassification.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.IJepaForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <code>IJepaImageProcessor.__call__</code>
for details.`,name:"pixel_values"},{anchor:"transformers.IJepaForImageClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.IJepaForImageClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.IJepaForImageClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.IJepaForImageClassification.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.IJepaForImageClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.IJepaForImageClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/ijepa/modeling_ijepa.py#L651",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/ijepa#transformers.IJepaConfig"
>IJepaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states
(also called feature maps) of the model at the output of each stage.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),R=new it({props:{$$slots:{default:[Gt]},$$scope:{ctx:I}}}),V=new lt({props:{anchor:"transformers.IJepaForImageClassification.forward.example",$$slots:{default:[Rt]},$$scope:{ctx:I}}}),ce=new Ft({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/ijepa.md"}}),{c(){a=d("meta"),y=r(),l=d("p"),c=r(),h(w.$$.fragment),n=r(),J=d("div"),J.innerHTML=ct,Je=r(),h(X.$$.fragment),Te=r(),P=d("p"),P.innerHTML=dt,Ie=r(),Q=d("p"),Q.textContent=pt,$e=r(),S=d("p"),S.textContent=mt,je=r(),E=d("img"),ve=r(),H=d("small"),H.innerHTML=ft,Ce=r(),Y=d("p"),Y.innerHTML=ut,ke=r(),h(A.$$.fragment),Ue=r(),q=d("p"),q.textContent=gt,xe=r(),h(L.$$.fragment),Ze=r(),h(D.$$.fragment),We=r(),O=d("p"),O.textContent=_t,Fe=r(),h(K.$$.fragment),Ee=r(),ee=d("ul"),ee.innerHTML=bt,ze=r(),h(te.$$.fragment),Be=r(),$=d("div"),h(oe.$$.fragment),He=r(),me=d("p"),me.innerHTML=yt,Ye=r(),he=d("p"),he.innerHTML=wt,Ae=r(),h(z.$$.fragment),Ne=r(),h(ae.$$.fragment),Ge=r(),k=d("div"),h(ne.$$.fragment),qe=r(),fe=d("p"),fe.innerHTML=Mt,Le=r(),v=d("div"),h(se.$$.fragment),De=r(),ue=d("p"),ue.innerHTML=Jt,Oe=r(),h(B.$$.fragment),Ke=r(),h(N.$$.fragment),Re=r(),h(re.$$.fragment),Ve=r(),T=d("div"),h(ie.$$.fragment),et=r(),ge=d("p"),ge.textContent=Tt,tt=r(),h(G.$$.fragment),ot=r(),_e=d("p"),_e.innerHTML=It,at=r(),C=d("div"),h(le.$$.fragment),nt=r(),be=d("p"),be.innerHTML=$t,st=r(),h(R.$$.fragment),rt=r(),h(V.$$.fragment),Xe=r(),h(ce.$$.fragment),Pe=r(),we=d("p"),this.h()},l(e){const t=Zt("svelte-u9bgzb",document.head);a=p(t,"META",{name:!0,content:!0}),t.forEach(o),y=i(e),l=p(e,"P",{}),de(l).forEach(o),c=i(e),f(w.$$.fragment,e),n=i(e),J=p(e,"DIV",{class:!0,"data-svelte-h":!0}),M(J)!=="svelte-b95w5j"&&(J.innerHTML=ct),Je=i(e),f(X.$$.fragment,e),Te=i(e),P=p(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-1bycs9t"&&(P.innerHTML=dt),Ie=i(e),Q=p(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-vfdo9a"&&(Q.textContent=pt),$e=i(e),S=p(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-1urhz7d"&&(S.textContent=mt),je=i(e),E=p(e,"IMG",{src:!0,alt:!0,width:!0}),ve=i(e),H=p(e,"SMALL",{"data-svelte-h":!0}),M(H)!=="svelte-pcs53f"&&(H.innerHTML=ft),Ce=i(e),Y=p(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-1rsx8jp"&&(Y.innerHTML=ut),ke=i(e),f(A.$$.fragment,e),Ue=i(e),q=p(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-6hgymu"&&(q.textContent=gt),xe=i(e),f(L.$$.fragment,e),Ze=i(e),f(D.$$.fragment,e),We=i(e),O=p(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-1mr8fcj"&&(O.textContent=_t),Fe=i(e),f(K.$$.fragment,e),Ee=i(e),ee=p(e,"UL",{"data-svelte-h":!0}),M(ee)!=="svelte-1ukrali"&&(ee.innerHTML=bt),ze=i(e),f(te.$$.fragment,e),Be=i(e),$=p(e,"DIV",{class:!0});var U=de($);f(oe.$$.fragment,U),He=i(U),me=p(U,"P",{"data-svelte-h":!0}),M(me)!=="svelte-d8odtj"&&(me.innerHTML=yt),Ye=i(U),he=p(U,"P",{"data-svelte-h":!0}),M(he)!=="svelte-o55m63"&&(he.innerHTML=wt),Ae=i(U),f(z.$$.fragment,U),U.forEach(o),Ne=i(e),f(ae.$$.fragment,e),Ge=i(e),k=p(e,"DIV",{class:!0});var F=de(k);f(ne.$$.fragment,F),qe=i(F),fe=p(F,"P",{"data-svelte-h":!0}),M(fe)!=="svelte-9hqxou"&&(fe.innerHTML=Mt),Le=i(F),v=p(F,"DIV",{class:!0});var x=de(v);f(se.$$.fragment,x),De=i(x),ue=p(x,"P",{"data-svelte-h":!0}),M(ue)!=="svelte-1j2g6ne"&&(ue.innerHTML=Jt),Oe=i(x),f(B.$$.fragment,x),Ke=i(x),f(N.$$.fragment,x),x.forEach(o),F.forEach(o),Re=i(e),f(re.$$.fragment,e),Ve=i(e),T=p(e,"DIV",{class:!0});var j=de(T);f(ie.$$.fragment,j),et=i(j),ge=p(j,"P",{"data-svelte-h":!0}),M(ge)!=="svelte-1htoj90"&&(ge.textContent=Tt),tt=i(j),f(G.$$.fragment,j),ot=i(j),_e=p(j,"P",{"data-svelte-h":!0}),M(_e)!=="svelte-1gjh92c"&&(_e.innerHTML=It),at=i(j),C=p(j,"DIV",{class:!0});var Z=de(C);f(le.$$.fragment,Z),nt=i(Z),be=p(Z,"P",{"data-svelte-h":!0}),M(be)!=="svelte-tqpz4e"&&(be.innerHTML=$t),st=i(Z),f(R.$$.fragment,Z),rt=i(Z),f(V.$$.fragment,Z),Z.forEach(o),j.forEach(o),Xe=i(e),f(ce.$$.fragment,e),Pe=i(e),we=p(e,"P",{}),de(we).forEach(o),this.h()},h(){W(a,"name","hf:doc:metadata"),W(a,"content",Xt),W(J,"class","flex flex-wrap space-x-1"),Ct(E.src,ht="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/ijepa_architecture.jpg")||W(E,"src",ht),W(E,"alt","drawing"),W(E,"width","600"),W($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){m(document.head,a),s(e,y,t),s(e,l,t),s(e,c,t),u(w,e,t),s(e,n,t),s(e,J,t),s(e,Je,t),u(X,e,t),s(e,Te,t),s(e,P,t),s(e,Ie,t),s(e,Q,t),s(e,$e,t),s(e,S,t),s(e,je,t),s(e,E,t),s(e,ve,t),s(e,H,t),s(e,Ce,t),s(e,Y,t),s(e,ke,t),u(A,e,t),s(e,Ue,t),s(e,q,t),s(e,xe,t),u(L,e,t),s(e,Ze,t),u(D,e,t),s(e,We,t),s(e,O,t),s(e,Fe,t),u(K,e,t),s(e,Ee,t),s(e,ee,t),s(e,ze,t),u(te,e,t),s(e,Be,t),s(e,$,t),u(oe,$,null),m($,He),m($,me),m($,Ye),m($,he),m($,Ae),u(z,$,null),s(e,Ne,t),u(ae,e,t),s(e,Ge,t),s(e,k,t),u(ne,k,null),m(k,qe),m(k,fe),m(k,Le),m(k,v),u(se,v,null),m(v,De),m(v,ue),m(v,Oe),u(B,v,null),m(v,Ke),u(N,v,null),s(e,Re,t),u(re,e,t),s(e,Ve,t),s(e,T,t),u(ie,T,null),m(T,et),m(T,ge),m(T,tt),u(G,T,null),m(T,ot),m(T,_e),m(T,at),m(T,C),u(le,C,null),m(C,nt),m(C,be),m(C,st),u(R,C,null),m(C,rt),u(V,C,null),s(e,Xe,t),u(ce,e,t),s(e,Pe,t),s(e,we,t),Qe=!0},p(e,[t]){const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),z.$set(U);const F={};t&2&&(F.$$scope={dirty:t,ctx:e}),B.$set(F);const x={};t&2&&(x.$$scope={dirty:t,ctx:e}),N.$set(x);const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),G.$set(j);const Z={};t&2&&(Z.$$scope={dirty:t,ctx:e}),R.$set(Z);const jt={};t&2&&(jt.$$scope={dirty:t,ctx:e}),V.$set(jt)},i(e){Qe||(g(w.$$.fragment,e),g(X.$$.fragment,e),g(A.$$.fragment,e),g(L.$$.fragment,e),g(D.$$.fragment,e),g(K.$$.fragment,e),g(te.$$.fragment,e),g(oe.$$.fragment,e),g(z.$$.fragment,e),g(ae.$$.fragment,e),g(ne.$$.fragment,e),g(se.$$.fragment,e),g(B.$$.fragment,e),g(N.$$.fragment,e),g(re.$$.fragment,e),g(ie.$$.fragment,e),g(G.$$.fragment,e),g(le.$$.fragment,e),g(R.$$.fragment,e),g(V.$$.fragment,e),g(ce.$$.fragment,e),Qe=!0)},o(e){_(w.$$.fragment,e),_(X.$$.fragment,e),_(A.$$.fragment,e),_(L.$$.fragment,e),_(D.$$.fragment,e),_(K.$$.fragment,e),_(te.$$.fragment,e),_(oe.$$.fragment,e),_(z.$$.fragment,e),_(ae.$$.fragment,e),_(ne.$$.fragment,e),_(se.$$.fragment,e),_(B.$$.fragment,e),_(N.$$.fragment,e),_(re.$$.fragment,e),_(ie.$$.fragment,e),_(G.$$.fragment,e),_(le.$$.fragment,e),_(R.$$.fragment,e),_(V.$$.fragment,e),_(ce.$$.fragment,e),Qe=!1},d(e){e&&(o(y),o(l),o(c),o(n),o(J),o(Je),o(Te),o(P),o(Ie),o(Q),o($e),o(S),o(je),o(E),o(ve),o(H),o(Ce),o(Y),o(ke),o(Ue),o(q),o(xe),o(Ze),o(We),o(O),o(Fe),o(Ee),o(ee),o(ze),o(Be),o($),o(Ne),o(Ge),o(k),o(Re),o(Ve),o(T),o(Xe),o(Pe),o(we)),o(a),b(w,e),b(X,e),b(A,e),b(L,e),b(D,e),b(K,e),b(te,e),b(oe),b(z),b(ae,e),b(ne),b(se),b(B),b(N),b(re,e),b(ie),b(G),b(le),b(R),b(V),b(ce,e)}}}const Xt='{"title":"I-JEPA","local":"i-jepa","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"How to use","local":"how-to-use","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"IJepaConfig","local":"transformers.IJepaConfig","sections":[],"depth":2},{"title":"IJepaModel","local":"transformers.IJepaModel","sections":[],"depth":2},{"title":"IJepaForImageClassification","local":"transformers.IJepaForImageClassification","sections":[],"depth":2}],"depth":1}';function Pt(I){return kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Kt extends Ut{constructor(a){super(),xt(this,a,Pt,Vt,vt,{})}}export{Kt as component};
