import{s as ss,o as rs,n as Fe}from"../chunks/scheduler.18a86fab.js";import{S as as,i as is,g as a,s as o,r as h,A as ls,h as i,f as s,c as n,j as C,u as f,x as m,k as M,y as t,a as c,v as g,d as b,t as _,w as x}from"../chunks/index.98837b22.js";import{T as ns}from"../chunks/Tip.77304350.js";import{D as V}from"../chunks/Docstring.6758ea23.js";import{C as Ut}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as Pt}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H}from"../chunks/Heading.7e7e0c5b.js";import{E as ds}from"../chunks/index.f01015d9.js";function cs(U){let l,v=`This model is in maintenance mode only, we don’t accept any new PRs changing its code.
If you run into any issues running this model, please reinstall the last version that supported this model: v4.40.2.
You can do so by running the following command: <code>pip install -U transformers==4.40.2</code>.`;return{c(){l=a("p"),l.innerHTML=v},l(p){l=i(p,"P",{"data-svelte-h":!0}),m(l)!=="svelte-1sq0hrb"&&(l.innerHTML=v)},m(p,u){c(p,l,u)},p:Fe,d(p){p&&s(l)}}}function ms(U){let l,v="Example:",p,u,k;return u=new Ut({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEp1a2Vib3hNb2RlbCUyQyUyMEp1a2Vib3hDb25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwSnVrZWJveCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwSnVrZWJveENvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMEp1a2Vib3hNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> JukeboxModel, JukeboxConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Jukebox configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = JukeboxConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = JukeboxModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){l=a("p"),l.textContent=v,p=o(),h(u.$$.fragment)},l(d){l=i(d,"P",{"data-svelte-h":!0}),m(l)!=="svelte-11lpom8"&&(l.textContent=v),p=n(d),f(u.$$.fragment,d)},m(d,$){c(d,l,$),c(d,p,$),g(u,d,$),k=!0},p:Fe,i(d){k||(b(u.$$.fragment,d),k=!0)},o(d){_(u.$$.fragment,d),k=!1},d(d){d&&(s(l),s(p)),x(u,d)}}}function ps(U){let l,v;return l=new Ut({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEp1a2Vib3hUb2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBKdWtlYm94VG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZqdWtlYm94LTFiLWx5cmljcyUyMiklMEF0b2tlbml6ZXIoJTIyQWxhbiUyMEphY2tzb24lMjIlMkMlMjAlMjJDb3VudHJ5JTIwUm9jayUyMiUyQyUyMCUyMm9sZCUyMHRvd24lMjByb2FkJTIyKSU1QiUyMmlucHV0X2lkcyUyMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> JukeboxTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = JukeboxTokenizer.from_pretrained(<span class="hljs-string">&quot;openai/jukebox-1b-lyrics&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer(<span class="hljs-string">&quot;Alan Jackson&quot;</span>, <span class="hljs-string">&quot;Country Rock&quot;</span>, <span class="hljs-string">&quot;old town road&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]
[tensor([[   <span class="hljs-number">0</span>,    <span class="hljs-number">0</span>,    <span class="hljs-number">0</span>, <span class="hljs-number">6785</span>,  <span class="hljs-number">546</span>,   <span class="hljs-number">41</span>,   <span class="hljs-number">38</span>,   <span class="hljs-number">30</span>,   <span class="hljs-number">76</span>,   <span class="hljs-number">46</span>,   <span class="hljs-number">41</span>,   <span class="hljs-number">49</span>,
           <span class="hljs-number">40</span>,   <span class="hljs-number">76</span>,   <span class="hljs-number">44</span>,   <span class="hljs-number">41</span>,   <span class="hljs-number">27</span>,   <span class="hljs-number">30</span>]]), tensor([[  <span class="hljs-number">0</span>,   <span class="hljs-number">0</span>,   <span class="hljs-number">0</span>, <span class="hljs-number">145</span>,   <span class="hljs-number">0</span>]]), tensor([[  <span class="hljs-number">0</span>,   <span class="hljs-number">0</span>,   <span class="hljs-number">0</span>, <span class="hljs-number">145</span>,   <span class="hljs-number">0</span>]])]`,wrap:!1}}),{c(){h(l.$$.fragment)},l(p){f(l.$$.fragment,p)},m(p,u){g(l,p,u),v=!0},p:Fe,i(p){v||(b(l.$$.fragment,p),v=!0)},o(p){_(l.$$.fragment,p),v=!1},d(p){x(l,p)}}}function us(U){let l,v="If nothing is provided, the genres and the artist will either be selected randomly or set to None";return{c(){l=a("p"),l.textContent=v},l(p){l=i(p,"P",{"data-svelte-h":!0}),m(l)!=="svelte-jodoey"&&(l.textContent=v)},m(p,u){c(p,l,u)},p:Fe,d(p){p&&s(l)}}}function hs(U){let l,v="Example:",p,u,k;return u=new Ut({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBKdWtlYm94TW9kZWwlMkMlMjBzZXRfc2VlZCUwQSUwQW1vZGVsJTIwJTNEJTIwSnVrZWJveE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZqdWtlYm94LTFiLWx5cmljcyUyMiUyQyUyMG1pbl9kdXJhdGlvbiUzRDApLmV2YWwoKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haSUyRmp1a2Vib3gtMWItbHlyaWNzJTIyKSUwQSUwQWx5cmljcyUyMCUzRCUyMCUyMkhleSUyQyUyMGFyZSUyMHlvdSUyMGF3YWtlJTNGJTIwQ2FuJTIweW91JTIwdGFsayUyMHRvJTIwbWUlM0YlMjIlMEFhcnRpc3QlMjAlM0QlMjAlMjJaYWMlMjBCcm93biUyMEJhbmQlMjIlMEFnZW5yZSUyMCUzRCUyMCUyMkNvdW50cnklMjIlMEFtZXRhcyUyMCUzRCUyMHRva2VuaXplcihhcnRpc3QlM0RhcnRpc3QlMkMlMjBnZW5yZXMlM0RnZW5yZSUyQyUyMGx5cmljcyUzRGx5cmljcyklMEFzZXRfc2VlZCgwKSUwQW11c2ljX3Rva2VucyUyMCUzRCUyMG1vZGVsLmFuY2VzdHJhbF9zYW1wbGUobWV0YXMuaW5wdXRfaWRzJTJDJTIwc2FtcGxlX2xlbmd0aCUzRDQwMCklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWwuZGVjb2RlKG11c2ljX3Rva2VucyklNUIlM0ElMkMlMjAlM0ExMCU1RC5zcXVlZXplKC0xKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, JukeboxModel, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>model = JukeboxModel.from_pretrained(<span class="hljs-string">&quot;openai/jukebox-1b-lyrics&quot;</span>, min_duration=<span class="hljs-number">0</span>).<span class="hljs-built_in">eval</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai/jukebox-1b-lyrics&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>lyrics = <span class="hljs-string">&quot;Hey, are you awake? Can you talk to me?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>artist = <span class="hljs-string">&quot;Zac Brown Band&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>genre = <span class="hljs-string">&quot;Country&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>metas = tokenizer(artist=artist, genres=genre, lyrics=lyrics)
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>music_tokens = model.ancestral_sample(metas.input_ids, sample_length=<span class="hljs-number">400</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    model.decode(music_tokens)[:, :<span class="hljs-number">10</span>].squeeze(-<span class="hljs-number">1</span>)
tensor([[-<span class="hljs-number">0.0219</span>, -<span class="hljs-number">0.0679</span>, -<span class="hljs-number">0.1050</span>, -<span class="hljs-number">0.1203</span>, -<span class="hljs-number">0.1271</span>, -<span class="hljs-number">0.0936</span>, -<span class="hljs-number">0.0396</span>, -<span class="hljs-number">0.0405</span>,
    -<span class="hljs-number">0.0818</span>, -<span class="hljs-number">0.0697</span>]])`,wrap:!1}}),{c(){l=a("p"),l.textContent=v,p=o(),h(u.$$.fragment)},l(d){l=i(d,"P",{"data-svelte-h":!0}),m(l)!=="svelte-11lpom8"&&(l.textContent=v),p=n(d),f(u.$$.fragment,d)},m(d,$){c(d,l,$),c(d,p,$),g(u,d,$),k=!0},p:Fe,i(d){k||(b(u.$$.fragment,d),k=!0)},o(d){_(u.$$.fragment,d),k=!1},d(d){d&&(s(l),s(p)),x(u,d)}}}function fs(U){let l,v="Example:",p,u,k;return u=new Ut({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBKdWtlYm94TW9kZWwlMkMlMjBzZXRfc2VlZCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbWV0YXMlMjAlM0QlMjBkaWN0KGFydGlzdCUzRCUyMlphYyUyMEJyb3duJTIwQmFuZCUyMiUyQyUyMGdlbnJlcyUzRCUyMkNvdW50cnklMjIlMkMlMjBseXJpY3MlM0QlMjJJJTIwbWV0JTIwYSUyMHRyYXZlbGxlciUyMGZyb20lMjBhbiUyMGFudGlxdWUlMjBsYW5kJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haSUyRmp1a2Vib3gtMWItbHlyaWNzJTIyKSUwQW1vZGVsJTIwJTNEJTIwSnVrZWJveE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZqdWtlYm94LTFiLWx5cmljcyUyMiUyQyUyMG1pbl9kdXJhdGlvbiUzRDApLmV2YWwoKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRva2VuaXplcigqKm1ldGFzKSU1QiUyMmlucHV0X2lkcyUyMiU1RCUwQXNldF9zZWVkKDApJTBBenMlMjAlM0QlMjAlNUJ0b3JjaC56ZXJvcygxJTJDJTIwMCUyQyUyMGR0eXBlJTNEdG9yY2gubG9uZyklMjBmb3IlMjBfJTIwaW4lMjByYW5nZSgzKSU1RCUwQXpzJTIwJTNEJTIwbW9kZWwuX3NhbXBsZSh6cyUyQyUyMGxhYmVscyUyQyUyMCU1QjAlNUQlMkMlMjBzYW1wbGVfbGVuZ3RoJTNENDAlMjAqJTIwbW9kZWwucHJpb3JzJTVCMCU1RC5yYXdfdG9fdG9rZW5zJTJDJTIwc2F2ZV9yZXN1bHRzJTNERmFsc2UpJTBBenMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, JukeboxModel, set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>metas = <span class="hljs-built_in">dict</span>(artist=<span class="hljs-string">&quot;Zac Brown Band&quot;</span>, genres=<span class="hljs-string">&quot;Country&quot;</span>, lyrics=<span class="hljs-string">&quot;I met a traveller from an antique land&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai/jukebox-1b-lyrics&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = JukeboxModel.from_pretrained(<span class="hljs-string">&quot;openai/jukebox-1b-lyrics&quot;</span>, min_duration=<span class="hljs-number">0</span>).<span class="hljs-built_in">eval</span>()

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(**metas)[<span class="hljs-string">&quot;input_ids&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>zs = [torch.zeros(<span class="hljs-number">1</span>, <span class="hljs-number">0</span>, dtype=torch.long) <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>)]
<span class="hljs-meta">&gt;&gt;&gt; </span>zs = model._sample(zs, labels, [<span class="hljs-number">0</span>], sample_length=<span class="hljs-number">40</span> * model.priors[<span class="hljs-number">0</span>].raw_to_tokens, save_results=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>zs[<span class="hljs-number">0</span>]
tensor([[<span class="hljs-number">1853</span>, <span class="hljs-number">1369</span>, <span class="hljs-number">1150</span>, <span class="hljs-number">1869</span>, <span class="hljs-number">1379</span>, <span class="hljs-number">1789</span>,  <span class="hljs-number">519</span>,  <span class="hljs-number">710</span>, <span class="hljs-number">1306</span>, <span class="hljs-number">1100</span>, <span class="hljs-number">1229</span>,  <span class="hljs-number">519</span>,
      <span class="hljs-number">353</span>, <span class="hljs-number">1306</span>, <span class="hljs-number">1379</span>, <span class="hljs-number">1053</span>,  <span class="hljs-number">519</span>,  <span class="hljs-number">653</span>, <span class="hljs-number">1631</span>, <span class="hljs-number">1467</span>, <span class="hljs-number">1229</span>, <span class="hljs-number">1229</span>,   <span class="hljs-number">10</span>, <span class="hljs-number">1647</span>,
     <span class="hljs-number">1254</span>, <span class="hljs-number">1229</span>, <span class="hljs-number">1306</span>, <span class="hljs-number">1528</span>, <span class="hljs-number">1789</span>,  <span class="hljs-number">216</span>, <span class="hljs-number">1631</span>, <span class="hljs-number">1434</span>,  <span class="hljs-number">653</span>,  <span class="hljs-number">475</span>, <span class="hljs-number">1150</span>, <span class="hljs-number">1528</span>,
     <span class="hljs-number">1804</span>,  <span class="hljs-number">541</span>, <span class="hljs-number">1804</span>, <span class="hljs-number">1434</span>]])`,wrap:!1}}),{c(){l=a("p"),l.textContent=v,p=o(),h(u.$$.fragment)},l(d){l=i(d,"P",{"data-svelte-h":!0}),m(l)!=="svelte-11lpom8"&&(l.textContent=v),p=n(d),f(u.$$.fragment,d)},m(d,$){c(d,l,$),c(d,p,$),g(u,d,$),k=!0},p:Fe,i(d){k||(b(u.$$.fragment,d),k=!0)},o(d){_(u.$$.fragment,d),k=!1},d(d){d&&(s(l),s(p)),x(u,d)}}}function gs(U){let l,v="Example:",p,u,k;return u=new Ut({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEp1a2Vib3hWUVZBRSUyQyUyMHNldF9zZWVkJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbCUyMCUzRCUyMEp1a2Vib3hWUVZBRS5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGanVrZWJveC0xYi1seXJpY3MlMjIpLmV2YWwoKSUwQXNldF9zZWVkKDApJTBBenMlMjAlM0QlMjAlNUJ0b3JjaC5yYW5kaW50KDEwMCUyQyUyMCg0JTJDJTIwMSkpJTVEJTBBbW9kZWwuZGVjb2RlKHpzKS5zaGFwZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> JukeboxVQVAE, set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = JukeboxVQVAE.from_pretrained(<span class="hljs-string">&quot;openai/jukebox-1b-lyrics&quot;</span>).<span class="hljs-built_in">eval</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>zs = [torch.randint(<span class="hljs-number">100</span>, (<span class="hljs-number">4</span>, <span class="hljs-number">1</span>))]
<span class="hljs-meta">&gt;&gt;&gt; </span>model.decode(zs).shape
torch.Size([<span class="hljs-number">4</span>, <span class="hljs-number">8</span>, <span class="hljs-number">1</span>])`,wrap:!1}}),{c(){l=a("p"),l.textContent=v,p=o(),h(u.$$.fragment)},l(d){l=i(d,"P",{"data-svelte-h":!0}),m(l)!=="svelte-11lpom8"&&(l.textContent=v),p=n(d),f(u.$$.fragment,d)},m(d,$){c(d,l,$),c(d,p,$),g(u,d,$),k=!0},p:Fe,i(d){k||(b(u.$$.fragment,d),k=!0)},o(d){_(u.$$.fragment,d),k=!1},d(d){d&&(s(l),s(p)),x(u,d)}}}function bs(U){let l,v,p,u,k,d,$,hn='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',Et,R,Lt,le,zt,de,fn=`The Jukebox model was proposed in <a href="https://arxiv.org/pdf/2005.00341.pdf" rel="nofollow">Jukebox: A generative model for music</a>
by Prafulla Dhariwal, Heewoo Jun, Christine Payne, Jong Wook Kim, Alec Radford,
Ilya Sutskever. It introduces a generative music model which can produce minute long samples that can be conditioned on
an artist, genres and lyrics.`,At,ce,gn="The abstract from the paper is the following:",Wt,me,bn="<em>We introduce Jukebox, a model that generates music with singing in the raw audio domain. We tackle the long context of raw audio using a multiscale VQ-VAE to compress it to discrete codes, and modeling those using autoregressive Transformers. We show that the combined model at scale can generate high-fidelity and diverse songs with coherence up to multiple minutes. We can condition on artist and genre to steer the musical and vocal style, and on unaligned lyrics to make the singing more controllable. We are releasing thousands of non cherry-picked samples, along with model weights and code.</em>",Qt,pe,_n=`As shown on the following figure, Jukebox is made of 3 <code>priors</code> which are decoder only models. They follow the architecture described in <a href="https://arxiv.org/abs/1904.10509" rel="nofollow">Generating Long Sequences with Sparse Transformers</a>, modified to support longer context length.
First, a autoencoder is used to encode the text lyrics. Next, the first (also called <code>top_prior</code>) prior attends to the last hidden states extracted from the lyrics encoder. The priors are linked to the previous priors respectively via an <code>AudioConditioner</code> module. The<code>AudioConditioner</code> upsamples the outputs of the previous prior to raw tokens at a certain audio frame per second resolution.
The metadata such as <em>artist, genre and timing</em> are passed to each prior, in the form of a start token and positional embedding for the timing data.  The hidden states are mapped to the closest codebook vector from the VQVAE in order to convert them to raw audio.`,It,ue,xn='<img src="https://gist.githubusercontent.com/ArthurZucker/92c1acaae62ebf1b6a951710bdd8b6af/raw/c9c517bf4eff61393f6c7dec9366ef02bdd059a3/jukebox.svg" alt="JukeboxModel"/>',qt,he,vn=`This model was contributed by <a href="https://huggingface.co/ArthurZ" rel="nofollow">Arthur Zucker</a>.
The original code can be found <a href="https://github.com/openai/jukebox" rel="nofollow">here</a>.`,Ht,fe,Zt,ge,kn="<li>This model only supports inference. This is for a few reasons, mostly because it requires a crazy amount of memory to train. Feel free to open a PR and add what’s missing to have a full integration with the hugging face trainer!</li> <li>This model is very slow, and takes 8h to generate a minute long audio using the 5b top prior on a V100 GPU. In order automaticallay handle the device on which the model should execute, use <code>accelerate</code>.</li> <li>Contrary to the paper, the order of the priors goes from <code>0</code> to <code>1</code> as it felt more intuitive : we sample starting from <code>0</code>.</li> <li>Primed sampling (conditioning the sampling on raw audio) requires more memory than ancestral sampling and should be used with <code>fp16</code> set to <code>True</code>.</li>",Dt,be,yn=`This model was contributed by <a href="https://huggingface.co/ArthurZ" rel="nofollow">Arthur Zucker</a>.
The original code can be found <a href="https://github.com/openai/jukebox" rel="nofollow">here</a>.`,Rt,_e,Gt,P,xe,fo,Se,wn='This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/jukebox#transformers.JukeboxModel">JukeboxModel</a>.',go,Be,$n=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information. Instantiating a configuration with the defaults will
yield a similar configuration to that of
<a href="https://huggingface.co/openai/jukebox-1b-lyrics" rel="nofollow">openai/jukebox-1b-lyrics</a> architecture.`,bo,Xe,Jn=`The downsampling and stride are used to determine downsampling of the input sequence. For example, downsampling =
(5,3), and strides = (2, 2) will downsample the audio by 2^5 = 32 to get the first level of codes, and 2**8 = 256
to get the second level codes. This is mostly true for training the top level prior and the upsamplers.`,_o,G,xo,N,ve,vo,Ye,Mn=`Instantiate a <a href="/docs/transformers/main/en/model_doc/jukebox#transformers.JukeboxConfig">JukeboxConfig</a> (or a derived class) from clip text model configuration and clip vision model
configuration.`,Nt,ke,Ft,W,ye,ko,Ke,jn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/jukebox#transformers.JukeboxPrior">JukeboxPrior</a>. It is used to instantiate a
<code>JukeboxPrior</code> according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the top level prior from the
[openai/jukebox-1b-lyrics](<a href="https://huggingface.co/openai/jukebox" rel="nofollow">https://huggingface.co/openai/jukebox</a>
-1b-lyrics) architecture.`,yo,Oe,Cn=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,St,we,Bt,Q,$e,wo,et,Tn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/jukebox#transformers.JukeboxVQVAE">JukeboxVQVAE</a>. It is used to instantiate a
<code>JukeboxVQVAE</code> according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the VQVAE from
<a href="https://huggingface.co/openai/jukebox-1b-lyrics" rel="nofollow">openai/jukebox-1b-lyrics</a> architecture.`,$o,tt,Vn=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Xt,Je,Yt,y,Me,Jo,ot,Pn="Constructs a Jukebox tokenizer. Jukebox can be conditioned on 3 different inputs :",Mo,nt,Un=`<li>Artists, unique ids are associated to each artist from the provided dictionary.</li> <li>Genres, unique ids are associated to each genre from the provided dictionary.</li> <li>Lyrics, character based tokenization. Must be initialized with the list of characters that are inside the
vocabulary.</li>`,jo,st,En=`This tokenizer does not require training. It should be able to process a different number of inputs:
as the conditioning of the model can be done on the three different queries. If None is provided, defaults values will be used.:`,Co,rt,Ln="Depending on the number of genres on which the model should be conditioned (<code>n_genres</code>).",To,F,Vo,at,zn=`You can get around that behavior by passing <code>add_prefix_space=True</code> when instantiating this tokenizer or when you
call it on some text, but since the model was not pretrained this way, it might yield a decrease in performance.`,Po,S,Uo,it,An=`This tokenizer inherits from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to:
this superclass for more information regarding those methods.`,Eo,lt,Wn="However the code does not allow that and only supports composing from various genres.",Lo,B,je,zo,dt,Qn="Saves the tokenizer’s vocabulary dictionary to the provided save_directory.",Kt,Ce,Ot,J,Te,Ao,ct,In=`The bare JUKEBOX Model used for music generation. 4 sampling techniques are supported : <code>primed_sample</code>, <code>upsample</code>,
<code>continue_sample</code> and <code>ancestral_sample</code>. It does not have a <code>forward</code> method as the training is not end to end. If
you want to fine-tune the model, it is recommended to use the <code>JukeboxPrior</code> class and train each prior
individually.`,Wo,mt,qn=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Qo,pt,Hn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Io,I,Ve,qo,ut,Zn="Generates music tokens based on the provided <code>labels. Will start at the desired prior level and automatically upsample the sequence. If you want to create the audio, you should call </code>model.decode(tokens)`, which will use\nthe VQ-VAE decoder to convert the music tokens to raw audio.",Ho,X,Zo,Y,Pe,Do,ht,Dn=`Generate a raw audio conditioned on the provided <code>raw_audio</code> which is used as conditioning at each of the
generation levels. The audio is encoded to music tokens using the 3 levels of the VQ-VAE. These tokens are
used: as conditioning for each level, which means that no ancestral sampling is required.`,Ro,K,Ue,Go,ft,Rn="Generates a continuation of the previously generated tokens.",No,O,Ee,Fo,gt,Gn="Upsamples a sequence of music tokens using the prior at level <code>level</code>.",So,A,Le,Bo,bt,Nn=`Core sampling function used to generate music tokens. Iterates over the provided list of levels, while saving
the generated raw audio at each step.`,Xo,_t,Fn="Returns: torch.Tensor",Yo,ee,eo,ze,to,z,Ae,Ko,xt,Sn=`The JukeboxPrior class, which is a wrapper around the various conditioning and the transformer. JukeboxPrior can be
seen as language models trained on music. They model the next <code>music token</code> prediction task. If a (lyric) <code>encoderù is defined, it also models the </code>next character\` prediction on the lyrics. Can be conditioned on timing, artist,
genre, lyrics and codes from lower-levels Priors.`,Oo,te,We,en,vt,Bn="Ancestral/Prime sampling a window of tokens using the provided conditioning and metadatas.",tn,oe,Qe,on,kt,Xn=`Encode the hidden states using the <code>vqvae</code> encoder, and then predicts the next token in the <code>forward_tokens</code>
function. The loss is the sum of the <code>encoder</code> loss and the <code>decoder</code> loss.`,oo,Ie,no,T,qe,nn,yt,Yn=`The Hierarchical VQ-VAE model used in Jukebox. This model follows the Hierarchical VQVAE paper from <a href="https://arxiv.org/abs/2002.08111" rel="nofollow">Will Williams, Sam
Ringer, Tom Ash, John Hughes, David MacLeod, Jamie Dougherty</a>.`,sn,wt,Kn=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,rn,$t,On=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,an,q,He,ln,Jt,es=`Forward pass of the VQ-VAE, encodes the <code>raw_audio</code> to latent states, which are then decoded for each level.
The commit loss, which ensure that the encoder’s computed embeddings are close to the codebook vectors, is
computed.`,dn,ne,cn,se,Ze,mn,Mt,ts="Transforms the <code>input_audio</code> to a discrete representation made out of <code>music_tokens</code>.",pn,re,De,un,jt,os="Transforms the input <code>music_tokens</code> to their <code>raw_audio</code> representation.",so,Re,ro,Vt,ao;return k=new H({props:{title:"Jukebox",local:"jukebox",headingTag:"h1"}}),R=new ns({props:{warning:!0,$$slots:{default:[cs]},$$scope:{ctx:U}}}),le=new H({props:{title:"Overview",local:"overview",headingTag:"h2"}}),fe=new H({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),_e=new H({props:{title:"JukeboxConfig",local:"transformers.JukeboxConfig",headingTag:"h2"}}),xe=new V({props:{name:"class transformers.JukeboxConfig",anchor:"transformers.JukeboxConfig",parameters:[{name:"vqvae_config",val:" = None"},{name:"prior_config_list",val:" = None"},{name:"nb_priors",val:" = 3"},{name:"sampling_rate",val:" = 44100"},{name:"timing_dims",val:" = 64"},{name:"min_duration",val:" = 0"},{name:"max_duration",val:" = 600.0"},{name:"max_nb_genres",val:" = 5"},{name:"metadata_conditioning",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.JukeboxConfig.vqvae_config",description:`<strong>vqvae_config</strong> (<code>JukeboxVQVAEConfig</code>, <em>optional</em>) &#x2014;
Configuration for the <code>JukeboxVQVAE</code> model.`,name:"vqvae_config"},{anchor:"transformers.JukeboxConfig.prior_config_list",description:`<strong>prior_config_list</strong> (<code>List[JukeboxPriorConfig]</code>, <em>optional</em>) &#x2014;
List of the configs for each of the <code>JukeboxPrior</code> of the model. The original architecture uses 3 priors.`,name:"prior_config_list"},{anchor:"transformers.JukeboxConfig.nb_priors",description:`<strong>nb_priors</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of prior models that will sequentially sample tokens. Each prior is conditional auto regressive
(decoder) model, apart from the top prior, which can include a lyric encoder. The available models were
trained using a top prior and 2 upsampler priors.`,name:"nb_priors"},{anchor:"transformers.JukeboxConfig.sampling_rate",description:`<strong>sampling_rate</strong> (<code>int</code>, <em>optional</em>, defaults to 44100) &#x2014;
Sampling rate of the raw audio.`,name:"sampling_rate"},{anchor:"transformers.JukeboxConfig.timing_dims",description:`<strong>timing_dims</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Dimensions of the JukeboxRangeEmbedding layer which is equivalent to traditional positional embedding
layer. The timing embedding layer converts the absolute and relative position in the currently sampled
audio to a tensor of length <code>timing_dims</code> that will be added to the music tokens.`,name:"timing_dims"},{anchor:"transformers.JukeboxConfig.min_duration",description:`<strong>min_duration</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Minimum duration of the audios to generate`,name:"min_duration"},{anchor:"transformers.JukeboxConfig.max_duration",description:`<strong>max_duration</strong> (<code>float</code>, <em>optional</em>, defaults to 600.0) &#x2014;
Maximum duration of the audios to generate`,name:"max_duration"},{anchor:"transformers.JukeboxConfig.max_nb_genres",description:`<strong>max_nb_genres</strong> (<code>int</code>, <em>optional</em>, defaults to 5) &#x2014;
Maximum number of genres that can be used to condition a single sample.`,name:"max_nb_genres"},{anchor:"transformers.JukeboxConfig.metadata_conditioning",description:`<strong>metadata_conditioning</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to use metadata conditioning, corresponding to the artist, the genre and the min/maximum
duration.`,name:"metadata_conditioning"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/jukebox/configuration_jukebox.py#L491"}}),G=new Pt({props:{anchor:"transformers.JukeboxConfig.example",$$slots:{default:[ms]},$$scope:{ctx:U}}}),ve=new V({props:{name:"from_configs",anchor:"transformers.JukeboxConfig.from_configs",parameters:[{name:"prior_configs",val:": typing.List[transformers.models.deprecated.jukebox.configuration_jukebox.JukeboxPriorConfig]"},{name:"vqvae_config",val:": JukeboxVQVAEConfig"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/jukebox/configuration_jukebox.py#L594",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/jukebox#transformers.JukeboxConfig"
>JukeboxConfig</a></p>
`}}),ke=new H({props:{title:"JukeboxPriorConfig",local:"transformers.JukeboxPriorConfig",headingTag:"h2"}}),ye=new V({props:{name:"class transformers.JukeboxPriorConfig",anchor:"transformers.JukeboxPriorConfig",parameters:[{name:"act_fn",val:" = 'quick_gelu'"},{name:"level",val:" = 0"},{name:"alignment_head",val:" = 2"},{name:"alignment_layer",val:" = 68"},{name:"attention_multiplier",val:" = 0.25"},{name:"attention_pattern",val:" = 'enc_dec_with_lyrics'"},{name:"attn_dropout",val:" = 0"},{name:"attn_res_scale",val:" = False"},{name:"blocks",val:" = 64"},{name:"conv_res_scale",val:" = None"},{name:"num_layers",val:" = 72"},{name:"emb_dropout",val:" = 0"},{name:"encoder_config",val:" = None"},{name:"encoder_loss_fraction",val:" = 0.4"},{name:"hidden_size",val:" = 2048"},{name:"init_scale",val:" = 0.2"},{name:"is_encoder_decoder",val:" = True"},{name:"lyric_vocab_size",val:" = 80"},{name:"mask",val:" = False"},{name:"max_duration",val:" = 600"},{name:"max_nb_genres",val:" = 1"},{name:"merged_decoder",val:" = True"},{name:"metadata_conditioning",val:" = True"},{name:"metadata_dims",val:" = [604, 7898]"},{name:"min_duration",val:" = 0"},{name:"mlp_multiplier",val:" = 1.0"},{name:"music_vocab_size",val:" = 2048"},{name:"n_ctx",val:" = 6144"},{name:"n_heads",val:" = 2"},{name:"nb_relevant_lyric_tokens",val:" = 384"},{name:"res_conv_depth",val:" = 3"},{name:"res_conv_width",val:" = 128"},{name:"res_convolution_multiplier",val:" = 1"},{name:"res_dilation_cycle",val:" = None"},{name:"res_dilation_growth_rate",val:" = 1"},{name:"res_downs_t",val:" = [3, 2, 2]"},{name:"res_strides_t",val:" = [2, 2, 2]"},{name:"resid_dropout",val:" = 0"},{name:"sampling_rate",val:" = 44100"},{name:"spread",val:" = None"},{name:"timing_dims",val:" = 64"},{name:"zero_out",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.JukeboxPriorConfig.act_fn",description:`<strong>act_fn</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;quick_gelu&quot;</code>) &#x2014;
Activation function.`,name:"act_fn"},{anchor:"transformers.JukeboxPriorConfig.alignment_head",description:`<strong>alignment_head</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Head that is responsible of the alignment between lyrics and music. Only used to compute the lyric to audio
alignment`,name:"alignment_head"},{anchor:"transformers.JukeboxPriorConfig.alignment_layer",description:`<strong>alignment_layer</strong> (<code>int</code>, <em>optional</em>, defaults to 68) &#x2014;
Index of the layer that is responsible of the alignment between lyrics and music. Only used to compute the
lyric to audio alignment`,name:"alignment_layer"},{anchor:"transformers.JukeboxPriorConfig.attention_multiplier",description:`<strong>attention_multiplier</strong> (<code>float</code>, <em>optional</em>, defaults to 0.25) &#x2014;
Multiplier coefficient used to define the hidden dimension of the attention layers. 0.25 means that
0.25*width of the model will be used.`,name:"attention_multiplier"},{anchor:"transformers.JukeboxPriorConfig.attention_pattern",description:`<strong>attention_pattern</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;enc_dec_with_lyrics&quot;</code>) &#x2014;
Which attention pattern to use for the decoder/`,name:"attention_pattern"},{anchor:"transformers.JukeboxPriorConfig.attn_dropout",description:`<strong>attn_dropout</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Dropout probability for the post-attention layer dropout in the decoder.`,name:"attn_dropout"},{anchor:"transformers.JukeboxPriorConfig.attn_res_scale",description:`<strong>attn_res_scale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to scale the residuals in the attention conditioner block.`,name:"attn_res_scale"},{anchor:"transformers.JukeboxPriorConfig.blocks",description:`<strong>blocks</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of blocks used in the <code>block_attn</code>. A sequence of length seq_len is factored as <code>[blocks, seq_len // blocks]</code> in the <code>JukeboxAttention</code> layer.`,name:"blocks"},{anchor:"transformers.JukeboxPriorConfig.conv_res_scale",description:`<strong>conv_res_scale</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Whether or not to scale the residuals in the conditioner block. Since the top level prior does not have a
conditioner, the default value is to None and should not be modified.`,name:"conv_res_scale"},{anchor:"transformers.JukeboxPriorConfig.num_layers",description:`<strong>num_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 72) &#x2014;
Number of layers of the transformer architecture.`,name:"num_layers"},{anchor:"transformers.JukeboxPriorConfig.emb_dropout",description:`<strong>emb_dropout</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Embedding dropout used in the lyric decoder.`,name:"emb_dropout"},{anchor:"transformers.JukeboxPriorConfig.encoder_config",description:`<strong>encoder_config</strong> (<code>JukeboxPriorConfig</code>, <em>optional</em>)  &#x2014;
Configuration of the encoder which models the prior on the lyrics.`,name:"encoder_config"},{anchor:"transformers.JukeboxPriorConfig.encoder_loss_fraction",description:`<strong>encoder_loss_fraction</strong> (<code>float</code>, <em>optional</em>, defaults to 0.4) &#x2014;
Multiplication factor used in front of the lyric encoder loss.`,name:"encoder_loss_fraction"},{anchor:"transformers.JukeboxPriorConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Hidden dimension of the attention layers.`,name:"hidden_size"},{anchor:"transformers.JukeboxPriorConfig.init_scale",description:`<strong>init_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.2) &#x2014;
Initialization scales for the prior modules.`,name:"init_scale"},{anchor:"transformers.JukeboxPriorConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the prior is an encoder-decoder model. In case it is not, and <code>nb_relevant_lyric_tokens</code> is
greater than 0, the <code>encoder</code> args should be specified for the lyric encoding.`,name:"is_encoder_decoder"},{anchor:"transformers.JukeboxPriorConfig.mask",description:`<strong>mask</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to mask the previous positions in the attention.`,name:"mask"},{anchor:"transformers.JukeboxPriorConfig.max_duration",description:`<strong>max_duration</strong> (<code>int</code>, <em>optional</em>, defaults to 600) &#x2014;
Maximum supported duration of the generated song in seconds.`,name:"max_duration"},{anchor:"transformers.JukeboxPriorConfig.max_nb_genres",description:`<strong>max_nb_genres</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Maximum number of genres that can be used to condition the model.`,name:"max_nb_genres"},{anchor:"transformers.JukeboxPriorConfig.merged_decoder",description:`<strong>merged_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the decoder and the encoder inputs are merged. This is used for the separated
encoder-decoder architecture`,name:"merged_decoder"},{anchor:"transformers.JukeboxPriorConfig.metadata_conditioning",description:`<strong>metadata_conditioning</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True)</code> &#x2014;
Whether or not to condition on the artist and genre metadata.`,name:"metadata_conditioning"},{anchor:"transformers.JukeboxPriorConfig.metadata_dims",description:`<strong>metadata_dims</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[604, 7898]</code>) &#x2014;
Number of genres and the number of artists that were used to train the embedding layers of the prior
models.`,name:"metadata_dims"},{anchor:"transformers.JukeboxPriorConfig.min_duration",description:`<strong>min_duration</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Minimum duration of the generated audio on which the model was trained.`,name:"min_duration"},{anchor:"transformers.JukeboxPriorConfig.mlp_multiplier",description:`<strong>mlp_multiplier</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Multiplier coefficient used to define the hidden dimension of the MLP layers. 0.25 means that 0.25*width of
the model will be used.`,name:"mlp_multiplier"},{anchor:"transformers.JukeboxPriorConfig.music_vocab_size",description:`<strong>music_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Number of different music tokens. Should be similar to the <code>JukeboxVQVAEConfig.nb_discrete_codes</code>.`,name:"music_vocab_size"},{anchor:"transformers.JukeboxPriorConfig.n_ctx",description:`<strong>n_ctx</strong> (<code>int</code>, <em>optional</em>, defaults to 6144) &#x2014;
Number of context tokens for each prior. The context tokens are the music tokens that are attended to when
generating music tokens.`,name:"n_ctx"},{anchor:"transformers.JukeboxPriorConfig.n_heads",description:`<strong>n_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Number of attention heads.`,name:"n_heads"},{anchor:"transformers.JukeboxPriorConfig.nb_relevant_lyric_tokens",description:`<strong>nb_relevant_lyric_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to 384) &#x2014;
Number of lyric tokens that are used when sampling a single window of length <code>n_ctx</code>`,name:"nb_relevant_lyric_tokens"},{anchor:"transformers.JukeboxPriorConfig.res_conv_depth",description:`<strong>res_conv_depth</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Depth of the <code>JukeboxDecoderConvBock</code> used to upsample the previously sampled audio in the
<code>JukeboxMusicTokenConditioner</code>.`,name:"res_conv_depth"},{anchor:"transformers.JukeboxPriorConfig.res_conv_width",description:`<strong>res_conv_width</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Width of the <code>JukeboxDecoderConvBock</code> used to upsample the previously sampled audio in the
<code>JukeboxMusicTokenConditioner</code>.`,name:"res_conv_width"},{anchor:"transformers.JukeboxPriorConfig.res_convolution_multiplier",description:`<strong>res_convolution_multiplier</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Multiplier used to scale the <code>hidden_dim</code> of the <code>JukeboxResConv1DBlock</code>.`,name:"res_convolution_multiplier"},{anchor:"transformers.JukeboxPriorConfig.res_dilation_cycle",description:`<strong>res_dilation_cycle</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Dilation cycle used to define the <code>JukeboxMusicTokenConditioner</code>. Usually similar to the ones used in the
corresponding level of the VQVAE. The first prior does not use it as it is not conditioned on upper level
tokens.`,name:"res_dilation_cycle"},{anchor:"transformers.JukeboxPriorConfig.res_dilation_growth_rate",description:`<strong>res_dilation_growth_rate</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Dilation grow rate used between each convolutionnal block of the <code>JukeboxMusicTokenConditioner</code>`,name:"res_dilation_growth_rate"},{anchor:"transformers.JukeboxPriorConfig.res_downs_t",description:`<strong>res_downs_t</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[3, 2, 2]</code>) &#x2014;
Downsampling rates used in the audio conditioning network`,name:"res_downs_t"},{anchor:"transformers.JukeboxPriorConfig.res_strides_t",description:`<strong>res_strides_t</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[2, 2, 2]</code>) &#x2014;
Striding used in the audio conditioning network`,name:"res_strides_t"},{anchor:"transformers.JukeboxPriorConfig.resid_dropout",description:`<strong>resid_dropout</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Residual dropout used in the attention pattern.`,name:"resid_dropout"},{anchor:"transformers.JukeboxPriorConfig.sampling_rate",description:`<strong>sampling_rate</strong> (<code>int</code>, <em>optional</em>, defaults to 44100) &#x2014;
Sampling rate used for training.`,name:"sampling_rate"},{anchor:"transformers.JukeboxPriorConfig.spread",description:`<strong>spread</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Spread used in the <code>summary_spread_attention</code> pattern`,name:"spread"},{anchor:"transformers.JukeboxPriorConfig.timing_dims",description:`<strong>timing_dims</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Dimension of the timing embedding.`,name:"timing_dims"},{anchor:"transformers.JukeboxPriorConfig.zero_out",description:`<strong>zero_out</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to zero out convolution weights when initializing.`,name:"zero_out"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/jukebox/configuration_jukebox.py#L139"}}),we=new H({props:{title:"JukeboxVQVAEConfig",local:"transformers.JukeboxVQVAEConfig",headingTag:"h2"}}),$e=new V({props:{name:"class transformers.JukeboxVQVAEConfig",anchor:"transformers.JukeboxVQVAEConfig",parameters:[{name:"act_fn",val:" = 'relu'"},{name:"nb_discrete_codes",val:" = 2048"},{name:"commit",val:" = 0.02"},{name:"conv_input_shape",val:" = 1"},{name:"conv_res_scale",val:" = False"},{name:"embed_dim",val:" = 64"},{name:"hop_fraction",val:" = [0.125, 0.5, 0.5]"},{name:"levels",val:" = 3"},{name:"lmu",val:" = 0.99"},{name:"multipliers",val:" = [2, 1, 1]"},{name:"res_conv_depth",val:" = 4"},{name:"res_conv_width",val:" = 32"},{name:"res_convolution_multiplier",val:" = 1"},{name:"res_dilation_cycle",val:" = None"},{name:"res_dilation_growth_rate",val:" = 3"},{name:"res_downs_t",val:" = [3, 2, 2]"},{name:"res_strides_t",val:" = [2, 2, 2]"},{name:"sample_length",val:" = 1058304"},{name:"init_scale",val:" = 0.2"},{name:"zero_out",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.JukeboxVQVAEConfig.act_fn",description:`<strong>act_fn</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
Activation function of the model.`,name:"act_fn"},{anchor:"transformers.JukeboxVQVAEConfig.nb_discrete_codes",description:`<strong>nb_discrete_codes</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Number of codes of the VQVAE.`,name:"nb_discrete_codes"},{anchor:"transformers.JukeboxVQVAEConfig.commit",description:`<strong>commit</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
Commit loss multiplier.`,name:"commit"},{anchor:"transformers.JukeboxVQVAEConfig.conv_input_shape",description:`<strong>conv_input_shape</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of audio channels.`,name:"conv_input_shape"},{anchor:"transformers.JukeboxVQVAEConfig.conv_res_scale",description:`<strong>conv_res_scale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to scale the residuals of the <code>JukeboxResConv1DBlock</code>.`,name:"conv_res_scale"},{anchor:"transformers.JukeboxVQVAEConfig.embed_dim",description:`<strong>embed_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Embedding dimension of the codebook vectors.`,name:"embed_dim"},{anchor:"transformers.JukeboxVQVAEConfig.hop_fraction",description:`<strong>hop_fraction</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[0.125, 0.5, 0.5]</code>) &#x2014;
Fraction of non-intersecting window used when continuing the sampling process.`,name:"hop_fraction"},{anchor:"transformers.JukeboxVQVAEConfig.levels",description:`<strong>levels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of hierarchical levels that used in the VQVAE.`,name:"levels"},{anchor:"transformers.JukeboxVQVAEConfig.lmu",description:`<strong>lmu</strong> (<code>float</code>, <em>optional</em>, defaults to 0.99) &#x2014;
Used in the codebook update, exponential moving average coefficient. For more detail refer to Appendix A.1
of the original <a href="https://arxiv.org/pdf/1711.00937v2.pdf" rel="nofollow">VQVAE paper</a>`,name:"lmu"},{anchor:"transformers.JukeboxVQVAEConfig.multipliers",description:`<strong>multipliers</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[2, 1, 1]</code>) &#x2014;
Depth and width multipliers used for each level. Used on the <code>res_conv_width</code> and <code>res_conv_depth</code>`,name:"multipliers"},{anchor:"transformers.JukeboxVQVAEConfig.res_conv_depth",description:`<strong>res_conv_depth</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Depth of the encoder and decoder block. If no <code>multipliers</code> are used, this is the same for each level.`,name:"res_conv_depth"},{anchor:"transformers.JukeboxVQVAEConfig.res_conv_width",description:`<strong>res_conv_width</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Width of the encoder and decoder block. If no <code>multipliers</code> are used, this is the same for each level.`,name:"res_conv_width"},{anchor:"transformers.JukeboxVQVAEConfig.res_convolution_multiplier",description:`<strong>res_convolution_multiplier</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Scaling factor of the hidden dimension used in the <code>JukeboxResConv1DBlock</code>.`,name:"res_convolution_multiplier"},{anchor:"transformers.JukeboxVQVAEConfig.res_dilation_cycle",description:`<strong>res_dilation_cycle</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Dilation cycle value used in the <code>JukeboxResnet</code>. If an int is used, each new Conv1 block will have a depth
reduced by a power of <code>res_dilation_cycle</code>.`,name:"res_dilation_cycle"},{anchor:"transformers.JukeboxVQVAEConfig.res_dilation_growth_rate",description:`<strong>res_dilation_growth_rate</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Resnet dilation growth rate used in the VQVAE (dilation_growth_rate ** depth)`,name:"res_dilation_growth_rate"},{anchor:"transformers.JukeboxVQVAEConfig.res_downs_t",description:`<strong>res_downs_t</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[3, 2, 2]</code>) &#x2014;
Downsampling rate for each level of the hierarchical VQ-VAE.`,name:"res_downs_t"},{anchor:"transformers.JukeboxVQVAEConfig.res_strides_t",description:`<strong>res_strides_t</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[2, 2, 2]</code>) &#x2014;
Stride used for each level of the hierarchical VQ-VAE.`,name:"res_strides_t"},{anchor:"transformers.JukeboxVQVAEConfig.sample_length",description:`<strong>sample_length</strong> (<code>int</code>, <em>optional</em>, defaults to 1058304) &#x2014;
Provides the max input shape of the VQVAE. Is used to compute the input shape of each level.`,name:"sample_length"},{anchor:"transformers.JukeboxVQVAEConfig.init_scale",description:`<strong>init_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.2) &#x2014;
Initialization scale.`,name:"init_scale"},{anchor:"transformers.JukeboxVQVAEConfig.zero_out",description:`<strong>zero_out</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to zero out convolution weights when initializing.`,name:"zero_out"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/jukebox/configuration_jukebox.py#L368"}}),Je=new H({props:{title:"JukeboxTokenizer",local:"transformers.JukeboxTokenizer",headingTag:"h2"}}),Me=new V({props:{name:"class transformers.JukeboxTokenizer",anchor:"transformers.JukeboxTokenizer",parameters:[{name:"artists_file",val:""},{name:"genres_file",val:""},{name:"lyrics_file",val:""},{name:"version",val:" = ['v3', 'v2', 'v2']"},{name:"max_n_lyric_tokens",val:" = 512"},{name:"n_genres",val:" = 5"},{name:"unk_token",val:" = '<|endoftext|>'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.JukeboxTokenizer.artists_file",description:`<strong>artists_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file which contains a mapping between artists and ids. The default file supports
both &#x201C;v2&#x201D; and &#x201C;v3&#x201D;`,name:"artists_file"},{anchor:"transformers.JukeboxTokenizer.genres_file",description:`<strong>genres_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file which contain a mapping between genres and ids.`,name:"genres_file"},{anchor:"transformers.JukeboxTokenizer.lyrics_file",description:`<strong>lyrics_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file which contains the accepted characters for the lyrics tokenization.`,name:"lyrics_file"},{anchor:"transformers.JukeboxTokenizer.version",description:`<strong>version</strong> (<code>List[str]</code>, <code>optional</code>, default to <code>[&quot;v3&quot;, &quot;v2&quot;, &quot;v2&quot;]</code>)  &#x2014;
List of the tokenizer versions. The <code>5b-lyrics</code>&#x2019;s top level prior model was trained using <code>v3</code> instead of
<code>v2</code>.`,name:"version"},{anchor:"transformers.JukeboxTokenizer.n_genres",description:`<strong>n_genres</strong> (<code>int</code>, <code>optional</code>, defaults to 1) &#x2014;
Maximum number of genres to use for composition.`,name:"n_genres"},{anchor:"transformers.JukeboxTokenizer.max_n_lyric_tokens",description:`<strong>max_n_lyric_tokens</strong> (<code>int</code>, <code>optional</code>, defaults to 512) &#x2014;
Maximum number of lyric tokens to keep.`,name:"max_n_lyric_tokens"},{anchor:"transformers.JukeboxTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;|endoftext|&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/jukebox/tokenization_jukebox.py#L42"}}),F=new Pt({props:{anchor:"transformers.JukeboxTokenizer.example",$$slots:{default:[ps]},$$scope:{ctx:U}}}),S=new ns({props:{$$slots:{default:[us]},$$scope:{ctx:U}}}),je=new V({props:{name:"save_vocabulary",anchor:"transformers.JukeboxTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"transformers.JukeboxTokenizer.save_vocabulary.save_directory",description:`<strong>save_directory</strong> (<code>str</code>) &#x2014;
A path to the directory where to saved. It will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"transformers.JukeboxTokenizer.save_vocabulary.filename_prefix",description:`<strong>filename_prefix</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
A prefix to add to the names of the files saved by the tokenizer.`,name:"filename_prefix"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/jukebox/tokenization_jukebox.py#L353"}}),Ce=new H({props:{title:"JukeboxModel",local:"transformers.JukeboxModel",headingTag:"h2"}}),Te=new V({props:{name:"class transformers.JukeboxModel",anchor:"transformers.JukeboxModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.JukeboxModel.config",description:`<strong>config</strong> (<code>JukeboxConfig</code>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/jukebox/modeling_jukebox.py#L2289"}}),Ve=new V({props:{name:"ancestral_sample",anchor:"transformers.JukeboxModel.ancestral_sample",parameters:[{name:"labels",val:""},{name:"n_samples",val:" = 1"},{name:"**sampling_kwargs",val:""}],parametersDescription:[{anchor:"transformers.JukeboxModel.ancestral_sample.labels",description:`<strong>labels</strong> (<code>List[torch.LongTensor]</code>)  &#x2014;
List of length <code>n_sample</code>, and shape <code>(self.levels, 4 + self.config.max_nb_genre + lyric_sequence_length)</code> metadata such as <code>artist_id</code>, <code>genre_id</code> and the full list of lyric tokens
which are used to condition the generation.`,name:"labels"},{anchor:"transformers.JukeboxModel.ancestral_sample.n_samples",description:`<strong>n_samples</strong> (<code>int</code>, <em>optional</em>, default to 1)  &#x2014;
Number of samples to be generated in parallel.`,name:"n_samples"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/jukebox/modeling_jukebox.py#L2571"}}),X=new Pt({props:{anchor:"transformers.JukeboxModel.ancestral_sample.example",$$slots:{default:[hs]},$$scope:{ctx:U}}}),Pe=new V({props:{name:"primed_sample",anchor:"transformers.JukeboxModel.primed_sample",parameters:[{name:"raw_audio",val:""},{name:"labels",val:""},{name:"**sampling_kwargs",val:""}],parametersDescription:[{anchor:"transformers.JukeboxModel.primed_sample.raw_audio",description:`<strong>raw_audio</strong> (<code>List[torch.Tensor]</code> of length <code>n_samples</code> )  &#x2014;
A list of raw audio that will be used as conditioning information for each samples that will be
generated.`,name:"raw_audio"},{anchor:"transformers.JukeboxModel.primed_sample.labels",description:`<strong>labels</strong> (<code>List[torch.LongTensor]</code> of length <code>n_sample</code>, and shape <code>(self.levels, self.config.max_nb_genre + lyric_sequence_length)</code>  &#x2014;
List of metadata such as <code>artist_id</code>, <code>genre_id</code> and the full list of lyric tokens which are used to
condition the generation.`,name:"labels"},{anchor:"transformers.JukeboxModel.primed_sample.sampling_kwargs",description:`<strong>sampling_kwargs</strong> (<code>Dict[Any]</code>) &#x2014;
Various additional sampling arguments that are used by the <code>_sample</code> function. A detail list of the
arguments can bee seen in the <code>_sample</code> function documentation.`,name:"sampling_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/jukebox/modeling_jukebox.py#L2647"}}),Ue=new V({props:{name:"continue_sample",anchor:"transformers.JukeboxModel.continue_sample",parameters:[{name:"music_tokens",val:""},{name:"labels",val:""},{name:"**sampling_kwargs",val:""}],parametersDescription:[{anchor:"transformers.JukeboxModel.continue_sample.music_tokens",description:`<strong>music_tokens</strong> (<code>List[torch.LongTensor]</code> of length <code>self.levels</code> )  &#x2014;
A sequence of music tokens which will be used as context to continue the sampling process. Should have
<code>self.levels</code> tensors, each corresponding to the generation at a certain level.`,name:"music_tokens"},{anchor:"transformers.JukeboxModel.continue_sample.labels",description:`<strong>labels</strong> (<code>List[torch.LongTensor]</code> of length <code>n_sample</code>, and shape <code>(self.levels, self.config.max_nb_genre + lyric_sequence_length)</code>  &#x2014;
List of metadata such as <code>artist_id</code>, <code>genre_id</code> and the full list of lyric tokens which are used to
condition the generation.`,name:"labels"},{anchor:"transformers.JukeboxModel.continue_sample.sampling_kwargs",description:`<strong>sampling_kwargs</strong> (<code>Dict[Any]</code>) &#x2014;
Various additional sampling arguments that are used by the <code>_sample</code> function. A detail list of the
arguments can bee seen in the <code>_sample</code> function documentation.`,name:"sampling_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/jukebox/modeling_jukebox.py#L2617"}}),Ee=new V({props:{name:"upsample",anchor:"transformers.JukeboxModel.upsample",parameters:[{name:"music_tokens",val:""},{name:"labels",val:""},{name:"**sampling_kwargs",val:""}],parametersDescription:[{anchor:"transformers.JukeboxModel.upsample.music_tokens",description:`<strong>music_tokens</strong> (<code>List[torch.LongTensor]</code> of length <code>self.levels</code> )  &#x2014;
A sequence of music tokens which will be used as context to continue the sampling process. Should have
<code>self.levels</code> tensors, each corresponding to the generation at a certain level.`,name:"music_tokens"},{anchor:"transformers.JukeboxModel.upsample.labels",description:`<strong>labels</strong> (<code>List[torch.LongTensor]</code> of length <code>n_sample</code>, and shape <code>(self.levels, self.config.max_nb_genre + lyric_sequence_length)</code>  &#x2014;
List of metadata such as <code>artist_id</code>, <code>genre_id</code> and the full list of lyric tokens which are used to
condition the generation.`,name:"labels"},{anchor:"transformers.JukeboxModel.upsample.sampling_kwargs",description:`<strong>sampling_kwargs</strong> (<code>Dict[Any]</code>) &#x2014;
Various additional sampling arguments that are used by the <code>_sample</code> function. A detail list of the
arguments can bee seen in the <code>_sample</code> function documentation.`,name:"sampling_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/jukebox/modeling_jukebox.py#L2632"}}),Le=new V({props:{name:"_sample",anchor:"transformers.JukeboxModel._sample",parameters:[{name:"music_tokens",val:""},{name:"labels",val:""},{name:"sample_levels",val:""},{name:"metas",val:" = None"},{name:"chunk_size",val:" = 32"},{name:"sampling_temperature",val:" = 0.98"},{name:"lower_batch_size",val:" = 16"},{name:"max_batch_size",val:" = 16"},{name:"sample_length_in_seconds",val:" = 24"},{name:"compute_alignments",val:" = False"},{name:"sample_tokens",val:" = None"},{name:"offset",val:" = 0"},{name:"save_results",val:" = True"},{name:"sample_length",val:" = None"}],parametersDescription:[{anchor:"transformers.JukeboxModel._sample.music_tokens",description:`<strong>music_tokens</strong> (<code>List[torch.LongTensor]</code>) &#x2014;
A sequence of music tokens of length <code>self.levels</code> which will be used as context to continue the
sampling process. Should have <code>self.levels</code> tensors, each corresponding to the generation at a certain
level.`,name:"music_tokens"},{anchor:"transformers.JukeboxModel._sample.labels",description:`<strong>labels</strong> (<code>List[torch.LongTensor]</code>) &#x2014;
List of length <code>n_sample</code>, and shape <code>(self.levels, 4 + self.config.max_nb_genre + lyric_sequence_length)</code> metadata such as <code>artist_id</code>, <code>genre_id</code> and the full list of lyric tokens
which are used to condition the generation.`,name:"labels"},{anchor:"transformers.JukeboxModel._sample.sample_levels",description:`<strong>sample_levels</strong> (<code>List[int]</code>) &#x2014;
List of the desired levels at which the sampling will be done. A level is equivalent to the index of
the prior in the list of priors`,name:"sample_levels"},{anchor:"transformers.JukeboxModel._sample.metas",description:`<strong>metas</strong> (<code>List[Any]</code>, <em>optional</em>) &#x2014;
Metadatas used to generate the <code>labels</code>`,name:"metas"},{anchor:"transformers.JukeboxModel._sample.chunk_size",description:`<strong>chunk_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Size of a chunk of audio, used to fill up the memory in chunks to prevent OOM errors. Bigger chunks
means faster memory filling but more consumption.`,name:"chunk_size"},{anchor:"transformers.JukeboxModel._sample.sampling_temperature",description:`<strong>sampling_temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 0.98) &#x2014;
Temperature used to adjust the randomness of the sampling.`,name:"sampling_temperature"},{anchor:"transformers.JukeboxModel._sample.lower_batch_size",description:`<strong>lower_batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Maximum batch size for the lower level priors`,name:"lower_batch_size"},{anchor:"transformers.JukeboxModel._sample.max_batch_size",description:`<strong>max_batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Maximum batch size for the top level priors`,name:"max_batch_size"},{anchor:"transformers.JukeboxModel._sample.sample_length_in_seconds",description:`<strong>sample_length_in_seconds</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
Desired length of the generation in seconds`,name:"sample_length_in_seconds"},{anchor:"transformers.JukeboxModel._sample.compute_alignments",description:`<strong>compute_alignments</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to compute the alignment between the lyrics and the audio using the top_prior`,name:"compute_alignments"},{anchor:"transformers.JukeboxModel._sample.sample_tokens",description:`<strong>sample_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Precise number of tokens that should be sampled at each level. This is mostly useful for running dummy
experiments`,name:"sample_tokens"},{anchor:"transformers.JukeboxModel._sample.offset",description:`<strong>offset</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Audio offset used as conditioning, corresponds to the starting sample in the music. If the offset is
greater than 0, the lyrics will be shifted take that intoaccount`,name:"offset"},{anchor:"transformers.JukeboxModel._sample.save_results",description:`<strong>save_results</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to save the intermediate results. If <code>True</code>, will generate a folder named with the start
time.`,name:"save_results"},{anchor:"transformers.JukeboxModel._sample.sample_length",description:`<strong>sample_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Desired length of the generation in samples.`,name:"sample_length"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/jukebox/modeling_jukebox.py#L2432"}}),ee=new Pt({props:{anchor:"transformers.JukeboxModel._sample.example",$$slots:{default:[fs]},$$scope:{ctx:U}}}),ze=new H({props:{title:"JukeboxPrior",local:"transformers.JukeboxPrior",headingTag:"h2"}}),Ae=new V({props:{name:"class transformers.JukeboxPrior",anchor:"transformers.JukeboxPrior",parameters:[{name:"config",val:": JukeboxPriorConfig"},{name:"level",val:" = None"},{name:"nb_priors",val:" = 3"},{name:"vqvae_encoder",val:" = None"},{name:"vqvae_decoder",val:" = None"}],parametersDescription:[{anchor:"transformers.JukeboxPrior.config",description:`<strong>config</strong> (<code>JukeboxPriorConfig</code>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.JukeboxPrior.level",description:`<strong>level</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Current level of the Prior. Should be in range <code>[0,nb_priors]</code>.`,name:"level"},{anchor:"transformers.JukeboxPrior.nb_priors",description:`<strong>nb_priors</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Total number of priors.`,name:"nb_priors"},{anchor:"transformers.JukeboxPrior.vqvae_encoder",description:`<strong>vqvae_encoder</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Encoding method of the VQVAE encoder used in the forward pass of the model. Passing functions instead of
the vqvae module to avoid getting the parameters.`,name:"vqvae_encoder"},{anchor:"transformers.JukeboxPrior.vqvae_decoder",description:`<strong>vqvae_decoder</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Decoding method of the VQVAE decoder used in the forward pass of the model. Passing functions instead of
the vqvae module to avoid getting the parameters.`,name:"vqvae_decoder"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/jukebox/modeling_jukebox.py#L1767"}}),We=new V({props:{name:"sample",anchor:"transformers.JukeboxPrior.sample",parameters:[{name:"n_samples",val:""},{name:"music_tokens",val:" = None"},{name:"music_tokens_conds",val:" = None"},{name:"metadata",val:" = None"},{name:"temp",val:" = 1.0"},{name:"top_k",val:" = 0"},{name:"top_p",val:" = 0.0"},{name:"chunk_size",val:" = None"},{name:"sample_tokens",val:" = None"}],parametersDescription:[{anchor:"transformers.JukeboxPrior.sample.n_samples",description:`<strong>n_samples</strong> (<code>int</code>) &#x2014;
Number of samples to generate.`,name:"n_samples"},{anchor:"transformers.JukeboxPrior.sample.music_tokens",description:`<strong>music_tokens</strong> (<code>List[torch.LongTensor]</code>, <em>optional</em>) &#x2014;
Previously generated tokens at the current level. Used as context for the generation.`,name:"music_tokens"},{anchor:"transformers.JukeboxPrior.sample.music_tokens_conds",description:`<strong>music_tokens_conds</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Upper-level music tokens generated by the previous prior model. Is <code>None</code> if the generation is not
conditioned on the upper-level tokens.`,name:"music_tokens_conds"},{anchor:"transformers.JukeboxPrior.sample.metadata",description:`<strong>metadata</strong> (<code>List[torch.LongTensor]</code>, <em>optional</em>) &#x2014;
List containing the metadata tensor with the artist, genre and the lyric tokens.`,name:"metadata"},{anchor:"transformers.JukeboxPrior.sample.temp",description:`<strong>temp</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Sampling temperature.`,name:"temp"},{anchor:"transformers.JukeboxPrior.sample.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Top k probabilities used for filtering.`,name:"top_k"},{anchor:"transformers.JukeboxPrior.sample.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Top p probabilities used for filtering.`,name:"top_p"},{anchor:"transformers.JukeboxPrior.sample.chunk_size",description:`<strong>chunk_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Size of the chunks used to prepare the cache of the transformer.`,name:"chunk_size"},{anchor:"transformers.JukeboxPrior.sample.sample_tokens",description:`<strong>sample_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of tokens to sample.`,name:"sample_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/jukebox/modeling_jukebox.py#L2057"}}),Qe=new V({props:{name:"forward",anchor:"transformers.JukeboxPrior.forward",parameters:[{name:"hidden_states",val:": Tensor"},{name:"metadata",val:": typing.Optional[typing.List[torch.LongTensor]]"},{name:"decode",val:": typing.Optional[bool] = False"},{name:"get_preds",val:": typing.Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.JukeboxPrior.forward.hidden_states",description:`<strong>hidden_states</strong> (<code>torch.Tensor</code>) &#x2014;
Hidden states which should be raw audio`,name:"hidden_states"},{anchor:"transformers.JukeboxPrior.forward.metadata",description:`<strong>metadata</strong> (<code>List[torch.LongTensor]</code>, <em>optional</em>) &#x2014;
List containing the metadata conditioning tensor with the lyric and the metadata tokens.`,name:"metadata"},{anchor:"transformers.JukeboxPrior.forward.decode",description:`<strong>decode</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to decode the encoded to tokens.`,name:"decode"},{anchor:"transformers.JukeboxPrior.forward.get_preds",description:`<strong>get_preds</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the actual predictions of the model.`,name:"get_preds"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/jukebox/modeling_jukebox.py#L2225"}}),Ie=new H({props:{title:"JukeboxVQVAE",local:"transformers.JukeboxVQVAE",headingTag:"h2"}}),qe=new V({props:{name:"class transformers.JukeboxVQVAE",anchor:"transformers.JukeboxVQVAE",parameters:[{name:"config",val:": JukeboxVQVAEConfig"}],parametersDescription:[{anchor:"transformers.JukeboxVQVAE.config",description:`<strong>config</strong> (<code>JukeboxConfig</code>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/jukebox/modeling_jukebox.py#L593"}}),He=new V({props:{name:"forward",anchor:"transformers.JukeboxVQVAE.forward",parameters:[{name:"raw_audio",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.JukeboxVQVAE.forward.raw_audio",description:`<strong>raw_audio</strong> (<code>torch.FloatTensor</code>) &#x2014;
Audio input which will be encoded and decoded.`,name:"raw_audio"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/jukebox/modeling_jukebox.py#L737",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple[torch.Tensor, torch.Tensor]</code></p>
`}}),ne=new Pt({props:{anchor:"transformers.JukeboxVQVAE.forward.example",$$slots:{default:[gs]},$$scope:{ctx:U}}}),Ze=new V({props:{name:"encode",anchor:"transformers.JukeboxVQVAE.encode",parameters:[{name:"input_audio",val:""},{name:"start_level",val:" = 0"},{name:"end_level",val:" = None"},{name:"bs_chunks",val:" = 1"}],parametersDescription:[{anchor:"transformers.JukeboxVQVAE.encode.input_audio",description:`<strong>input_audio</strong> (<code>torch.Tensor</code>) &#x2014;
Raw audio which will be encoded to its discrete representation using the codebook. The closest <code>code</code>
form the codebook will be computed for each sequence of samples.`,name:"input_audio"},{anchor:"transformers.JukeboxVQVAE.encode.start_level",description:`<strong>start_level</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Level at which the encoding process will start. Default to 0.`,name:"start_level"},{anchor:"transformers.JukeboxVQVAE.encode.end_level",description:`<strong>end_level</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Level at which the encoding process will start. Default to None.`,name:"end_level"},{anchor:"transformers.JukeboxVQVAE.encode.bs_chunks",description:`<strong>bs_chunks</strong> (int, <em>optional</em>, defaults to 1) &#x2014;
Number of chunks of raw audio to process at the same time.`,name:"bs_chunks"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/jukebox/modeling_jukebox.py#L707"}}),De=new V({props:{name:"decode",anchor:"transformers.JukeboxVQVAE.decode",parameters:[{name:"music_tokens",val:""},{name:"start_level",val:" = 0"},{name:"end_level",val:" = None"},{name:"bs_chunks",val:" = 1"}],parametersDescription:[{anchor:"transformers.JukeboxVQVAE.decode.music_tokens",description:`<strong>music_tokens</strong> (<code>torch.LongTensor</code>) &#x2014;
Tensor of music tokens which will be decoded to raw audio by using the codebook. Each music token
should be an index to a corresponding <code>code</code> vector in the codebook.`,name:"music_tokens"},{anchor:"transformers.JukeboxVQVAE.decode.start_level",description:`<strong>start_level</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Level at which the decoding process will start. Default to 0.`,name:"start_level"},{anchor:"transformers.JukeboxVQVAE.decode.end_level",description:`<strong>end_level</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Level at which the decoding process will start. Default to None.`,name:"end_level"},{anchor:"transformers.JukeboxVQVAE.decode.bs_chunks",description:`<strong>bs_chunks</strong> (int, <em>optional</em>) &#x2014;
Number of chunks to process at the same time.`,name:"bs_chunks"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/jukebox/modeling_jukebox.py#L671"}}),Re=new ds({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/jukebox.md"}}),{c(){l=a("meta"),v=o(),p=a("p"),u=o(),h(k.$$.fragment),d=o(),$=a("div"),$.innerHTML=hn,Et=o(),h(R.$$.fragment),Lt=o(),h(le.$$.fragment),zt=o(),de=a("p"),de.innerHTML=fn,At=o(),ce=a("p"),ce.textContent=gn,Wt=o(),me=a("p"),me.innerHTML=bn,Qt=o(),pe=a("p"),pe.innerHTML=_n,It=o(),ue=a("p"),ue.innerHTML=xn,qt=o(),he=a("p"),he.innerHTML=vn,Ht=o(),h(fe.$$.fragment),Zt=o(),ge=a("ul"),ge.innerHTML=kn,Dt=o(),be=a("p"),be.innerHTML=yn,Rt=o(),h(_e.$$.fragment),Gt=o(),P=a("div"),h(xe.$$.fragment),fo=o(),Se=a("p"),Se.innerHTML=wn,go=o(),Be=a("p"),Be.innerHTML=$n,bo=o(),Xe=a("p"),Xe.textContent=Jn,_o=o(),h(G.$$.fragment),xo=o(),N=a("div"),h(ve.$$.fragment),vo=o(),Ye=a("p"),Ye.innerHTML=Mn,Nt=o(),h(ke.$$.fragment),Ft=o(),W=a("div"),h(ye.$$.fragment),ko=o(),Ke=a("p"),Ke.innerHTML=jn,yo=o(),Oe=a("p"),Oe.innerHTML=Cn,St=o(),h(we.$$.fragment),Bt=o(),Q=a("div"),h($e.$$.fragment),wo=o(),et=a("p"),et.innerHTML=Tn,$o=o(),tt=a("p"),tt.innerHTML=Vn,Xt=o(),h(Je.$$.fragment),Yt=o(),y=a("div"),h(Me.$$.fragment),Jo=o(),ot=a("p"),ot.textContent=Pn,Mo=o(),nt=a("ul"),nt.innerHTML=Un,jo=o(),st=a("p"),st.textContent=En,Co=o(),rt=a("p"),rt.innerHTML=Ln,To=o(),h(F.$$.fragment),Vo=o(),at=a("p"),at.innerHTML=zn,Po=o(),h(S.$$.fragment),Uo=o(),it=a("p"),it.innerHTML=An,Eo=o(),lt=a("p"),lt.textContent=Wn,Lo=o(),B=a("div"),h(je.$$.fragment),zo=o(),dt=a("p"),dt.textContent=Qn,Kt=o(),h(Ce.$$.fragment),Ot=o(),J=a("div"),h(Te.$$.fragment),Ao=o(),ct=a("p"),ct.innerHTML=In,Wo=o(),mt=a("p"),mt.innerHTML=qn,Qo=o(),pt=a("p"),pt.innerHTML=Hn,Io=o(),I=a("div"),h(Ve.$$.fragment),qo=o(),ut=a("p"),ut.innerHTML=Zn,Ho=o(),h(X.$$.fragment),Zo=o(),Y=a("div"),h(Pe.$$.fragment),Do=o(),ht=a("p"),ht.innerHTML=Dn,Ro=o(),K=a("div"),h(Ue.$$.fragment),Go=o(),ft=a("p"),ft.textContent=Rn,No=o(),O=a("div"),h(Ee.$$.fragment),Fo=o(),gt=a("p"),gt.innerHTML=Gn,So=o(),A=a("div"),h(Le.$$.fragment),Bo=o(),bt=a("p"),bt.textContent=Nn,Xo=o(),_t=a("p"),_t.textContent=Fn,Yo=o(),h(ee.$$.fragment),eo=o(),h(ze.$$.fragment),to=o(),z=a("div"),h(Ae.$$.fragment),Ko=o(),xt=a("p"),xt.innerHTML=Sn,Oo=o(),te=a("div"),h(We.$$.fragment),en=o(),vt=a("p"),vt.textContent=Bn,tn=o(),oe=a("div"),h(Qe.$$.fragment),on=o(),kt=a("p"),kt.innerHTML=Xn,oo=o(),h(Ie.$$.fragment),no=o(),T=a("div"),h(qe.$$.fragment),nn=o(),yt=a("p"),yt.innerHTML=Yn,sn=o(),wt=a("p"),wt.innerHTML=Kn,rn=o(),$t=a("p"),$t.innerHTML=On,an=o(),q=a("div"),h(He.$$.fragment),ln=o(),Jt=a("p"),Jt.innerHTML=es,dn=o(),h(ne.$$.fragment),cn=o(),se=a("div"),h(Ze.$$.fragment),mn=o(),Mt=a("p"),Mt.innerHTML=ts,pn=o(),re=a("div"),h(De.$$.fragment),un=o(),jt=a("p"),jt.innerHTML=os,so=o(),h(Re.$$.fragment),ro=o(),Vt=a("p"),this.h()},l(e){const r=ls("svelte-u9bgzb",document.head);l=i(r,"META",{name:!0,content:!0}),r.forEach(s),v=n(e),p=i(e,"P",{}),C(p).forEach(s),u=n(e),f(k.$$.fragment,e),d=n(e),$=i(e,"DIV",{class:!0,"data-svelte-h":!0}),m($)!=="svelte-13t8s2t"&&($.innerHTML=hn),Et=n(e),f(R.$$.fragment,e),Lt=n(e),f(le.$$.fragment,e),zt=n(e),de=i(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-1ax856a"&&(de.innerHTML=fn),At=n(e),ce=i(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-vfdo9a"&&(ce.textContent=gn),Wt=n(e),me=i(e,"P",{"data-svelte-h":!0}),m(me)!=="svelte-nitrj1"&&(me.innerHTML=bn),Qt=n(e),pe=i(e,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-1h7tnqm"&&(pe.innerHTML=_n),It=n(e),ue=i(e,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-10w2oqd"&&(ue.innerHTML=xn),qt=n(e),he=i(e,"P",{"data-svelte-h":!0}),m(he)!=="svelte-i0ky6l"&&(he.innerHTML=vn),Ht=n(e),f(fe.$$.fragment,e),Zt=n(e),ge=i(e,"UL",{"data-svelte-h":!0}),m(ge)!=="svelte-11sn5gf"&&(ge.innerHTML=kn),Dt=n(e),be=i(e,"P",{"data-svelte-h":!0}),m(be)!=="svelte-i0ky6l"&&(be.innerHTML=yn),Rt=n(e),f(_e.$$.fragment,e),Gt=n(e),P=i(e,"DIV",{class:!0});var E=C(P);f(xe.$$.fragment,E),fo=n(E),Se=i(E,"P",{"data-svelte-h":!0}),m(Se)!=="svelte-3ytapv"&&(Se.innerHTML=wn),go=n(E),Be=i(E,"P",{"data-svelte-h":!0}),m(Be)!=="svelte-12phlgw"&&(Be.innerHTML=$n),bo=n(E),Xe=i(E,"P",{"data-svelte-h":!0}),m(Xe)!=="svelte-1ge4jf0"&&(Xe.textContent=Jn),_o=n(E),f(G.$$.fragment,E),xo=n(E),N=i(E,"DIV",{class:!0});var Ge=C(N);f(ve.$$.fragment,Ge),vo=n(Ge),Ye=i(Ge,"P",{"data-svelte-h":!0}),m(Ye)!=="svelte-15pdce8"&&(Ye.innerHTML=Mn),Ge.forEach(s),E.forEach(s),Nt=n(e),f(ke.$$.fragment,e),Ft=n(e),W=i(e,"DIV",{class:!0});var Z=C(W);f(ye.$$.fragment,Z),ko=n(Z),Ke=i(Z,"P",{"data-svelte-h":!0}),m(Ke)!=="svelte-1tjgyg5"&&(Ke.innerHTML=jn),yo=n(Z),Oe=i(Z,"P",{"data-svelte-h":!0}),m(Oe)!=="svelte-o55m63"&&(Oe.innerHTML=Cn),Z.forEach(s),St=n(e),f(we.$$.fragment,e),Bt=n(e),Q=i(e,"DIV",{class:!0});var D=C(Q);f($e.$$.fragment,D),wo=n(D),et=i(D,"P",{"data-svelte-h":!0}),m(et)!=="svelte-d623el"&&(et.innerHTML=Tn),$o=n(D),tt=i(D,"P",{"data-svelte-h":!0}),m(tt)!=="svelte-o55m63"&&(tt.innerHTML=Vn),D.forEach(s),Xt=n(e),f(Je.$$.fragment,e),Yt=n(e),y=i(e,"DIV",{class:!0});var w=C(y);f(Me.$$.fragment,w),Jo=n(w),ot=i(w,"P",{"data-svelte-h":!0}),m(ot)!=="svelte-g45kr3"&&(ot.textContent=Pn),Mo=n(w),nt=i(w,"UL",{"data-svelte-h":!0}),m(nt)!=="svelte-1275agq"&&(nt.innerHTML=Un),jo=n(w),st=i(w,"P",{"data-svelte-h":!0}),m(st)!=="svelte-1ohtqdr"&&(st.textContent=En),Co=n(w),rt=i(w,"P",{"data-svelte-h":!0}),m(rt)!=="svelte-1p2f8vn"&&(rt.innerHTML=Ln),To=n(w),f(F.$$.fragment,w),Vo=n(w),at=i(w,"P",{"data-svelte-h":!0}),m(at)!=="svelte-1jfcabo"&&(at.innerHTML=zn),Po=n(w),f(S.$$.fragment,w),Uo=n(w),it=i(w,"P",{"data-svelte-h":!0}),m(it)!=="svelte-fif1b6"&&(it.innerHTML=An),Eo=n(w),lt=i(w,"P",{"data-svelte-h":!0}),m(lt)!=="svelte-ocbpqr"&&(lt.textContent=Wn),Lo=n(w),B=i(w,"DIV",{class:!0});var Ne=C(B);f(je.$$.fragment,Ne),zo=n(Ne),dt=i(Ne,"P",{"data-svelte-h":!0}),m(dt)!=="svelte-1ht6cxs"&&(dt.textContent=Qn),Ne.forEach(s),w.forEach(s),Kt=n(e),f(Ce.$$.fragment,e),Ot=n(e),J=i(e,"DIV",{class:!0});var j=C(J);f(Te.$$.fragment,j),Ao=n(j),ct=i(j,"P",{"data-svelte-h":!0}),m(ct)!=="svelte-1fljc29"&&(ct.innerHTML=In),Wo=n(j),mt=i(j,"P",{"data-svelte-h":!0}),m(mt)!=="svelte-6pahdo"&&(mt.innerHTML=qn),Qo=n(j),pt=i(j,"P",{"data-svelte-h":!0}),m(pt)!=="svelte-hswkmf"&&(pt.innerHTML=Hn),Io=n(j),I=i(j,"DIV",{class:!0});var Ct=C(I);f(Ve.$$.fragment,Ct),qo=n(Ct),ut=i(Ct,"P",{"data-svelte-h":!0}),m(ut)!=="svelte-1ah1sdk"&&(ut.innerHTML=Zn),Ho=n(Ct),f(X.$$.fragment,Ct),Ct.forEach(s),Zo=n(j),Y=i(j,"DIV",{class:!0});var io=C(Y);f(Pe.$$.fragment,io),Do=n(io),ht=i(io,"P",{"data-svelte-h":!0}),m(ht)!=="svelte-awu8ei"&&(ht.innerHTML=Dn),io.forEach(s),Ro=n(j),K=i(j,"DIV",{class:!0});var lo=C(K);f(Ue.$$.fragment,lo),Go=n(lo),ft=i(lo,"P",{"data-svelte-h":!0}),m(ft)!=="svelte-130urlt"&&(ft.textContent=Rn),lo.forEach(s),No=n(j),O=i(j,"DIV",{class:!0});var co=C(O);f(Ee.$$.fragment,co),Fo=n(co),gt=i(co,"P",{"data-svelte-h":!0}),m(gt)!=="svelte-19aywgj"&&(gt.innerHTML=Gn),co.forEach(s),So=n(j),A=i(j,"DIV",{class:!0});var ae=C(A);f(Le.$$.fragment,ae),Bo=n(ae),bt=i(ae,"P",{"data-svelte-h":!0}),m(bt)!=="svelte-1nmq94k"&&(bt.textContent=Nn),Xo=n(ae),_t=i(ae,"P",{"data-svelte-h":!0}),m(_t)!=="svelte-1c3z8g4"&&(_t.textContent=Fn),Yo=n(ae),f(ee.$$.fragment,ae),ae.forEach(s),j.forEach(s),eo=n(e),f(ze.$$.fragment,e),to=n(e),z=i(e,"DIV",{class:!0});var ie=C(z);f(Ae.$$.fragment,ie),Ko=n(ie),xt=i(ie,"P",{"data-svelte-h":!0}),m(xt)!=="svelte-1xn3sow"&&(xt.innerHTML=Sn),Oo=n(ie),te=i(ie,"DIV",{class:!0});var mo=C(te);f(We.$$.fragment,mo),en=n(mo),vt=i(mo,"P",{"data-svelte-h":!0}),m(vt)!=="svelte-1tv9c3k"&&(vt.textContent=Bn),mo.forEach(s),tn=n(ie),oe=i(ie,"DIV",{class:!0});var po=C(oe);f(Qe.$$.fragment,po),on=n(po),kt=i(po,"P",{"data-svelte-h":!0}),m(kt)!=="svelte-6kqsha"&&(kt.innerHTML=Xn),po.forEach(s),ie.forEach(s),oo=n(e),f(Ie.$$.fragment,e),no=n(e),T=i(e,"DIV",{class:!0});var L=C(T);f(qe.$$.fragment,L),nn=n(L),yt=i(L,"P",{"data-svelte-h":!0}),m(yt)!=="svelte-ltbxkh"&&(yt.innerHTML=Yn),sn=n(L),wt=i(L,"P",{"data-svelte-h":!0}),m(wt)!=="svelte-6pahdo"&&(wt.innerHTML=Kn),rn=n(L),$t=i(L,"P",{"data-svelte-h":!0}),m($t)!=="svelte-hswkmf"&&($t.innerHTML=On),an=n(L),q=i(L,"DIV",{class:!0});var Tt=C(q);f(He.$$.fragment,Tt),ln=n(Tt),Jt=i(Tt,"P",{"data-svelte-h":!0}),m(Jt)!=="svelte-1bropk3"&&(Jt.innerHTML=es),dn=n(Tt),f(ne.$$.fragment,Tt),Tt.forEach(s),cn=n(L),se=i(L,"DIV",{class:!0});var uo=C(se);f(Ze.$$.fragment,uo),mn=n(uo),Mt=i(uo,"P",{"data-svelte-h":!0}),m(Mt)!=="svelte-14si36p"&&(Mt.innerHTML=ts),uo.forEach(s),pn=n(L),re=i(L,"DIV",{class:!0});var ho=C(re);f(De.$$.fragment,ho),un=n(ho),jt=i(ho,"P",{"data-svelte-h":!0}),m(jt)!=="svelte-dyifa7"&&(jt.innerHTML=os),ho.forEach(s),L.forEach(s),so=n(e),f(Re.$$.fragment,e),ro=n(e),Vt=i(e,"P",{}),C(Vt).forEach(s),this.h()},h(){M(l,"name","hf:doc:metadata"),M(l,"content",_s),M($,"class","flex flex-wrap space-x-1"),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){t(document.head,l),c(e,v,r),c(e,p,r),c(e,u,r),g(k,e,r),c(e,d,r),c(e,$,r),c(e,Et,r),g(R,e,r),c(e,Lt,r),g(le,e,r),c(e,zt,r),c(e,de,r),c(e,At,r),c(e,ce,r),c(e,Wt,r),c(e,me,r),c(e,Qt,r),c(e,pe,r),c(e,It,r),c(e,ue,r),c(e,qt,r),c(e,he,r),c(e,Ht,r),g(fe,e,r),c(e,Zt,r),c(e,ge,r),c(e,Dt,r),c(e,be,r),c(e,Rt,r),g(_e,e,r),c(e,Gt,r),c(e,P,r),g(xe,P,null),t(P,fo),t(P,Se),t(P,go),t(P,Be),t(P,bo),t(P,Xe),t(P,_o),g(G,P,null),t(P,xo),t(P,N),g(ve,N,null),t(N,vo),t(N,Ye),c(e,Nt,r),g(ke,e,r),c(e,Ft,r),c(e,W,r),g(ye,W,null),t(W,ko),t(W,Ke),t(W,yo),t(W,Oe),c(e,St,r),g(we,e,r),c(e,Bt,r),c(e,Q,r),g($e,Q,null),t(Q,wo),t(Q,et),t(Q,$o),t(Q,tt),c(e,Xt,r),g(Je,e,r),c(e,Yt,r),c(e,y,r),g(Me,y,null),t(y,Jo),t(y,ot),t(y,Mo),t(y,nt),t(y,jo),t(y,st),t(y,Co),t(y,rt),t(y,To),g(F,y,null),t(y,Vo),t(y,at),t(y,Po),g(S,y,null),t(y,Uo),t(y,it),t(y,Eo),t(y,lt),t(y,Lo),t(y,B),g(je,B,null),t(B,zo),t(B,dt),c(e,Kt,r),g(Ce,e,r),c(e,Ot,r),c(e,J,r),g(Te,J,null),t(J,Ao),t(J,ct),t(J,Wo),t(J,mt),t(J,Qo),t(J,pt),t(J,Io),t(J,I),g(Ve,I,null),t(I,qo),t(I,ut),t(I,Ho),g(X,I,null),t(J,Zo),t(J,Y),g(Pe,Y,null),t(Y,Do),t(Y,ht),t(J,Ro),t(J,K),g(Ue,K,null),t(K,Go),t(K,ft),t(J,No),t(J,O),g(Ee,O,null),t(O,Fo),t(O,gt),t(J,So),t(J,A),g(Le,A,null),t(A,Bo),t(A,bt),t(A,Xo),t(A,_t),t(A,Yo),g(ee,A,null),c(e,eo,r),g(ze,e,r),c(e,to,r),c(e,z,r),g(Ae,z,null),t(z,Ko),t(z,xt),t(z,Oo),t(z,te),g(We,te,null),t(te,en),t(te,vt),t(z,tn),t(z,oe),g(Qe,oe,null),t(oe,on),t(oe,kt),c(e,oo,r),g(Ie,e,r),c(e,no,r),c(e,T,r),g(qe,T,null),t(T,nn),t(T,yt),t(T,sn),t(T,wt),t(T,rn),t(T,$t),t(T,an),t(T,q),g(He,q,null),t(q,ln),t(q,Jt),t(q,dn),g(ne,q,null),t(T,cn),t(T,se),g(Ze,se,null),t(se,mn),t(se,Mt),t(T,pn),t(T,re),g(De,re,null),t(re,un),t(re,jt),c(e,so,r),g(Re,e,r),c(e,ro,r),c(e,Vt,r),ao=!0},p(e,[r]){const E={};r&2&&(E.$$scope={dirty:r,ctx:e}),R.$set(E);const Ge={};r&2&&(Ge.$$scope={dirty:r,ctx:e}),G.$set(Ge);const Z={};r&2&&(Z.$$scope={dirty:r,ctx:e}),F.$set(Z);const D={};r&2&&(D.$$scope={dirty:r,ctx:e}),S.$set(D);const w={};r&2&&(w.$$scope={dirty:r,ctx:e}),X.$set(w);const Ne={};r&2&&(Ne.$$scope={dirty:r,ctx:e}),ee.$set(Ne);const j={};r&2&&(j.$$scope={dirty:r,ctx:e}),ne.$set(j)},i(e){ao||(b(k.$$.fragment,e),b(R.$$.fragment,e),b(le.$$.fragment,e),b(fe.$$.fragment,e),b(_e.$$.fragment,e),b(xe.$$.fragment,e),b(G.$$.fragment,e),b(ve.$$.fragment,e),b(ke.$$.fragment,e),b(ye.$$.fragment,e),b(we.$$.fragment,e),b($e.$$.fragment,e),b(Je.$$.fragment,e),b(Me.$$.fragment,e),b(F.$$.fragment,e),b(S.$$.fragment,e),b(je.$$.fragment,e),b(Ce.$$.fragment,e),b(Te.$$.fragment,e),b(Ve.$$.fragment,e),b(X.$$.fragment,e),b(Pe.$$.fragment,e),b(Ue.$$.fragment,e),b(Ee.$$.fragment,e),b(Le.$$.fragment,e),b(ee.$$.fragment,e),b(ze.$$.fragment,e),b(Ae.$$.fragment,e),b(We.$$.fragment,e),b(Qe.$$.fragment,e),b(Ie.$$.fragment,e),b(qe.$$.fragment,e),b(He.$$.fragment,e),b(ne.$$.fragment,e),b(Ze.$$.fragment,e),b(De.$$.fragment,e),b(Re.$$.fragment,e),ao=!0)},o(e){_(k.$$.fragment,e),_(R.$$.fragment,e),_(le.$$.fragment,e),_(fe.$$.fragment,e),_(_e.$$.fragment,e),_(xe.$$.fragment,e),_(G.$$.fragment,e),_(ve.$$.fragment,e),_(ke.$$.fragment,e),_(ye.$$.fragment,e),_(we.$$.fragment,e),_($e.$$.fragment,e),_(Je.$$.fragment,e),_(Me.$$.fragment,e),_(F.$$.fragment,e),_(S.$$.fragment,e),_(je.$$.fragment,e),_(Ce.$$.fragment,e),_(Te.$$.fragment,e),_(Ve.$$.fragment,e),_(X.$$.fragment,e),_(Pe.$$.fragment,e),_(Ue.$$.fragment,e),_(Ee.$$.fragment,e),_(Le.$$.fragment,e),_(ee.$$.fragment,e),_(ze.$$.fragment,e),_(Ae.$$.fragment,e),_(We.$$.fragment,e),_(Qe.$$.fragment,e),_(Ie.$$.fragment,e),_(qe.$$.fragment,e),_(He.$$.fragment,e),_(ne.$$.fragment,e),_(Ze.$$.fragment,e),_(De.$$.fragment,e),_(Re.$$.fragment,e),ao=!1},d(e){e&&(s(v),s(p),s(u),s(d),s($),s(Et),s(Lt),s(zt),s(de),s(At),s(ce),s(Wt),s(me),s(Qt),s(pe),s(It),s(ue),s(qt),s(he),s(Ht),s(Zt),s(ge),s(Dt),s(be),s(Rt),s(Gt),s(P),s(Nt),s(Ft),s(W),s(St),s(Bt),s(Q),s(Xt),s(Yt),s(y),s(Kt),s(Ot),s(J),s(eo),s(to),s(z),s(oo),s(no),s(T),s(so),s(ro),s(Vt)),s(l),x(k,e),x(R,e),x(le,e),x(fe,e),x(_e,e),x(xe),x(G),x(ve),x(ke,e),x(ye),x(we,e),x($e),x(Je,e),x(Me),x(F),x(S),x(je),x(Ce,e),x(Te),x(Ve),x(X),x(Pe),x(Ue),x(Ee),x(Le),x(ee),x(ze,e),x(Ae),x(We),x(Qe),x(Ie,e),x(qe),x(He),x(ne),x(Ze),x(De),x(Re,e)}}}const _s='{"title":"Jukebox","local":"jukebox","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"JukeboxConfig","local":"transformers.JukeboxConfig","sections":[],"depth":2},{"title":"JukeboxPriorConfig","local":"transformers.JukeboxPriorConfig","sections":[],"depth":2},{"title":"JukeboxVQVAEConfig","local":"transformers.JukeboxVQVAEConfig","sections":[],"depth":2},{"title":"JukeboxTokenizer","local":"transformers.JukeboxTokenizer","sections":[],"depth":2},{"title":"JukeboxModel","local":"transformers.JukeboxModel","sections":[],"depth":2},{"title":"JukeboxPrior","local":"transformers.JukeboxPrior","sections":[],"depth":2},{"title":"JukeboxVQVAE","local":"transformers.JukeboxVQVAE","sections":[],"depth":2}],"depth":1}';function xs(U){return rs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Cs extends as{constructor(l){super(),is(this,l,xs,bs,ss,{})}}export{Cs as component};
