import{s as xs,o as Us,n as $s}from"../chunks/scheduler.18a86fab.js";import{S as zs,i as qs,g as o,s as a,r as d,m as vs,A as Ns,h as r,f as n,c as l,j as C,u as m,x as p,n as Js,k as I,l as Gs,y as i,a as s,v as g,d as u,t as h,w as f}from"../chunks/index.98837b22.js";import{D as Fe}from"../chunks/Docstring.6758ea23.js";import{C as Z}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as js}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as $}from"../chunks/Heading.7e7e0c5b.js";import{E as Is}from"../chunks/index.f01015d9.js";function Zs(Ve){let b,z="Examples:",v,y,M;return y=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME5sbGJUb2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBObGxiVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm5sbGItMjAwLWRpc3RpbGxlZC02MDBNJTIyJTJDJTIwc3JjX2xhbmclM0QlMjJlbmdfTGF0biUyMiUyQyUyMHRndF9sYW5nJTNEJTIyZnJhX0xhdG4lMjIlMEEpJTBBZXhhbXBsZV9lbmdsaXNoX3BocmFzZSUyMCUzRCUyMCUyMiUyMFVOJTIwQ2hpZWYlMjBTYXlzJTIwVGhlcmUlMjBJcyUyME5vJTIwTWlsaXRhcnklMjBTb2x1dGlvbiUyMGluJTIwU3lyaWElMjIlMEFleHBlY3RlZF90cmFuc2xhdGlvbl9mcmVuY2glMjAlM0QlMjAlMjJMZSUyMGNoZWYlMjBkZSUyMGwnT05VJTIwYWZmaXJtZSUyMHF1J2lsJTIwbid5JTIwYSUyMHBhcyUyMGRlJTIwc29sdXRpb24lMjBtaWxpdGFpcmUlMjBlbiUyMFN5cmllLiUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihleGFtcGxlX2VuZ2xpc2hfcGhyYXNlJTJDJTIwdGV4dF90YXJnZXQlM0RleHBlY3RlZF90cmFuc2xhdGlvbl9mcmVuY2glMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> NllbTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = NllbTokenizer.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;facebook/nllb-200-distilled-600M&quot;</span>, src_lang=<span class="hljs-string">&quot;eng_Latn&quot;</span>, tgt_lang=<span class="hljs-string">&quot;fra_Latn&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>example_english_phrase = <span class="hljs-string">&quot; UN Chief Says There Is No Military Solution in Syria&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>expected_translation_french = <span class="hljs-string">&quot;Le chef de l&#x27;ONU affirme qu&#x27;il n&#x27;y a pas de solution militaire en Syrie.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(example_english_phrase, text_target=expected_translation_french, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),{c(){b=o("p"),b.textContent=z,v=a(),d(y.$$.fragment)},l(c){b=r(c,"P",{"data-svelte-h":!0}),p(b)!=="svelte-kvfsh7"&&(b.textContent=z),v=l(c),m(y.$$.fragment,c)},m(c,w){s(c,b,w),s(c,v,w),g(y,c,w),M=!0},p:$s,i(c){M||(u(y.$$.fragment,c),M=!0)},o(c){h(y.$$.fragment,c),M=!1},d(c){c&&(n(b),n(v)),f(y,c)}}}function Cs(Ve){let b,z="Examples:",v,y,M;return y=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME5sbGJUb2tlbml6ZXJGYXN0JTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwTmxsYlRva2VuaXplckZhc3QuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGbmxsYi0yMDAtZGlzdGlsbGVkLTYwME0lMjIlMkMlMjBzcmNfbGFuZyUzRCUyMmVuZ19MYXRuJTIyJTJDJTIwdGd0X2xhbmclM0QlMjJmcmFfTGF0biUyMiUwQSklMEFleGFtcGxlX2VuZ2xpc2hfcGhyYXNlJTIwJTNEJTIwJTIyJTIwVU4lMjBDaGllZiUyMFNheXMlMjBUaGVyZSUyMElzJTIwTm8lMjBNaWxpdGFyeSUyMFNvbHV0aW9uJTIwaW4lMjBTeXJpYSUyMiUwQWV4cGVjdGVkX3RyYW5zbGF0aW9uX2ZyZW5jaCUyMCUzRCUyMCUyMkxlJTIwY2hlZiUyMGRlJTIwbCdPTlUlMjBhZmZpcm1lJTIwcXUnaWwlMjBuJ3klMjBhJTIwcGFzJTIwZGUlMjBzb2x1dGlvbiUyMG1pbGl0YWlyZSUyMGVuJTIwU3lyaWUuJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKGV4YW1wbGVfZW5nbGlzaF9waHJhc2UlMkMlMjB0ZXh0X3RhcmdldCUzRGV4cGVjdGVkX3RyYW5zbGF0aW9uX2ZyZW5jaCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> NllbTokenizerFast

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = NllbTokenizerFast.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;facebook/nllb-200-distilled-600M&quot;</span>, src_lang=<span class="hljs-string">&quot;eng_Latn&quot;</span>, tgt_lang=<span class="hljs-string">&quot;fra_Latn&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>example_english_phrase = <span class="hljs-string">&quot; UN Chief Says There Is No Military Solution in Syria&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>expected_translation_french = <span class="hljs-string">&quot;Le chef de l&#x27;ONU affirme qu&#x27;il n&#x27;y a pas de solution militaire en Syrie.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(example_english_phrase, text_target=expected_translation_french, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),{c(){b=o("p"),b.textContent=z,v=a(),d(y.$$.fragment)},l(c){b=r(c,"P",{"data-svelte-h":!0}),p(b)!=="svelte-kvfsh7"&&(b.textContent=z),v=l(c),m(y.$$.fragment,c)},m(c,w){s(c,b,w),s(c,v,w),g(y,c,w),M=!0},p:$s,i(c){M||(u(y.$$.fragment,c),M=!0)},o(c){h(y.$$.fragment,c),M=!1},d(c){c&&(n(b),n(v)),f(y,c)}}}function Ls(Ve){let b,z,v,y,M,c,w,Gn='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',pt,V,ct,B,In=`<strong>DISCLAIMER:</strong> The default behaviour for the tokenizer was fixed and thus changed in April 2023.
The previous version adds <code>[self.eos_token_id, self.cur_lang_code]</code> at the end of the token sequence for both target and source tokenization. This is wrong as the NLLB paper mentions (page 48, 6.1.1. Model Architecture) :`,dt,X,Zn=`<em>Note that we prefix the source sequence with the source language, as opposed to the target
language as previously done in several works (Arivazhagan et al., 2019; Johnson et al.,
2017). This is primarily because we prioritize optimizing zero-shot performance of our
model on any pair of 200 languages at a minor cost to supervised performance.</em>`,mt,H,Cn="Previous behaviour:",gt,E,ut,S,Ln="New behaviour",ht,A,ft,Y,Rn="Enabling the old behaviour can be done as follows:",bt,D,kt,P,Wn='For more details, feel free to check the linked <a href="https://github.com/huggingface/transformers/pull/22313" rel="nofollow">PR</a> and <a href="https://github.com/huggingface/transformers/issues/19943" rel="nofollow">Issue</a>.',yt,Q,_t,K,Fn=`The NLLB model was presented in <a href="https://arxiv.org/abs/2207.04672" rel="nofollow">No Language Left Behind: Scaling Human-Centered Machine Translation</a> by Marta R. Costa-jussà, James Cross, Onur Çelebi,
Maha Elbayad, Kenneth Heafield, Kevin Heffernan, Elahe Kalbassi, Janice Lam, Daniel Licht, Jean Maillard, Anna Sun, Skyler Wang, Guillaume Wenzek, Al Youngblood, Bapi Akula,
Loic Barrault, Gabriel Mejia Gonzalez, Prangthip Hansanti, John Hoffman, Semarley Jarrett, Kaushik Ram Sadagopan, Dirk Rowe, Shannon Spruit, Chau Tran, Pierre Andrews,
Necip Fazil Ayan, Shruti Bhosale, Sergey Edunov, Angela Fan, Cynthia Gao, Vedanuj Goswami, Francisco Guzmán, Philipp Koehn, Alexandre Mourachko, Christophe Ropers,
Safiyyah Saleem, Holger Schwenk, and Jeff Wang.`,Mt,O,Vn="The abstract of the paper is the following:",Tt,ee,Bn=`<em>Driven by the goal of eradicating language barriers on a global scale, machine translation has solidified itself as a key focus of artificial intelligence research today.
However, such efforts have coalesced around a small subset of languages, leaving behind the vast majority of mostly low-resource languages. What does it take to break the
200 language barrier while ensuring safe, high quality results, all while keeping ethical considerations in mind? In No Language Left Behind, we took on this challenge by
first contextualizing the need for low-resource language translation support through exploratory interviews with native speakers. Then, we created datasets and models aimed
at narrowing the performance gap between low and high-resource languages. More specifically, we developed a conditional compute model based on Sparsely Gated Mixture of
Experts that is trained on data obtained with novel and effective data mining techniques tailored for low-resource languages. We propose multiple architectural and training
improvements to counteract overfitting while training on thousands of tasks. Critically, we evaluated the performance of over 40,000 different translation directions using
a human-translated benchmark, Flores-200, and combined human evaluation with a novel toxicity benchmark covering all languages in Flores-200 to assess translation safety.
Our model achieves an improvement of 44% BLEU relative to the previous state-of-the-art, laying important groundwork towards realizing a universal translation system.</em>`,wt,te,Xn="This implementation contains the dense models available on release.",vt,ne,Hn='<strong>The sparse model NLLB-MoE (Mixture of Expert) is now available! More details <a href="nllb-moe">here</a></strong>',Jt,se,En='This model was contributed by <a href="https://huggingface.co/lysandre" rel="nofollow">Lysandre</a>. The authors’ code can be found <a href="https://github.com/facebookresearch/fairseq/tree/nllb" rel="nofollow">here</a>.',jt,ae,$t,le,Sn=`While generating the target text set the <code>forced_bos_token_id</code> to the target language id. The following
example shows how to translate English to French using the <em>facebook/nllb-200-distilled-600M</em> model.`,xt,oe,An=`Note that we’re using the BCP-47 code for French <code>fra_Latn</code>. See <a href="https://github.com/facebookresearch/flores/blob/main/flores200/README.md#languages-in-flores-200" rel="nofollow">here</a>
for the list of all BCP-47 in the Flores 200 dataset.`,Ut,re,zt,ie,qt,pe,Yn=`English (<code>eng_Latn</code>) is set as the default language from which to translate. In order to specify that you’d like to translate from a different language,
you should specify the BCP-47 code in the <code>src_lang</code> keyword argument of the tokenizer initialization.`,Nt,ce,Dn="See example below for a translation from romanian to german:",Gt,de,It,me,Zt,ge,Pn='<li><a href="../tasks/translation">Translation task guide</a></li> <li><a href="../tasks/summarization">Summarization task guide</a></li>',Ct,ue,Lt,T,he,rn,Be,Qn="Construct an NLLB tokenizer.",pn,Xe,Kn=`Adapted from <a href="/docs/transformers/main/en/model_doc/roberta#transformers.RobertaTokenizer">RobertaTokenizer</a> and <a href="/docs/transformers/main/en/model_doc/xlnet#transformers.XLNetTokenizer">XLNetTokenizer</a>. Based on
<a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a>.`,cn,He,On="The tokenization method is <code>&lt;tokens&gt; &lt;eos&gt; &lt;language code&gt;</code> for source language documents, and `&lt;language code&gt;",dn,L,mn,x,fe,gn,Ee,es=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. An NLLB sequence has the following format, where <code>X</code> represents the sequence:`,un,Se,ts="<li><code>input_ids</code> (for encoder) <code>X [eos, src_lang_code]</code></li> <li><code>decoder_input_ids</code>: (for decoder) <code>X [eos, tgt_lang_code]</code></li>",hn,Ae,ns=`BOS is never used. Pairs of sequences are not the expected use case, but they will be handled without a
separator.`,Rt,be,Wt,k,ke,fn,Ye,ss=`Construct a “fast” NLLB tokenizer (backed by HuggingFace’s <em>tokenizers</em> library). Based on
<a href="https://huggingface.co/docs/tokenizers/python/latest/components.html?highlight=BPE#models" rel="nofollow">BPE</a>.`,bn,De,as=`This tokenizer inherits from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,kn,Pe,ls="The tokenization method is <code>&lt;tokens&gt; &lt;eos&gt; &lt;language code&gt;</code> for source language documents, and `&lt;language code&gt;",yn,R,_n,j,ye,Mn,Qe,os=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. The special tokens depend on calling set_lang.`,Tn,Ke,rs="An NLLB sequence has the following format, where <code>X</code> represents the sequence:",wn,Oe,is="<li><code>input_ids</code> (for encoder) <code>X [eos, src_lang_code]</code></li> <li><code>decoder_input_ids</code>: (for decoder) <code>X [eos, tgt_lang_code]</code></li>",vn,et,ps=`BOS is never used. Pairs of sequences are not the expected use case, but they will be handled without a
separator.`,Jn,W,_e,jn,tt,cs=`Create a mask from the two sequences passed to be used in a sequence-pair classification task. nllb does not
make use of token type ids, therefore a list of zeros is returned.`,$n,q,Me,xn,nt,ds="Reset the special tokens to the source lang setting.",Un,st,ms="<li>In legacy mode: No prefix and suffix=[eos, src_lang_code].</li> <li>In default mode: Prefix=[src_lang_code], suffix = [eos]</li>",zn,N,Te,qn,at,gs="Reset the special tokens to the target lang setting.",Nn,lt,us="<li>In legacy mode: No prefix and suffix=[eos, tgt_lang_code].</li> <li>In default mode: Prefix=[tgt_lang_code], suffix = [eos]</li>",Ft,we,Vt,ve,hs="Flash Attention 2 is a faster, optimized version of the attention scores computation which relies on <code>cuda</code> kernels.",Bt,Je,Xt,je,fs='First, check whether your hardware is compatible with Flash Attention 2. The latest list of compatible hardware can be found in the <a href="https://github.com/Dao-AILab/flash-attention#installation-and-features" rel="nofollow">official documentation</a>.',Ht,$e,bs='Next, <a href="https://github.com/Dao-AILab/flash-attention#installation-and-features" rel="nofollow">install</a> the latest version of Flash Attention 2:',Et,xe,St,Ue,At,ze,ks='To load a model using Flash Attention 2, we can pass the argument <code>attn_implementation=&quot;flash_attention_2&quot;</code> to <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained" rel="nofollow"><code>.from_pretrained</code></a>. You can use either <code>torch.float16</code> or <code>torch.bfloat16</code> precision.',Yt,qe,Dt,Ne,Pt,Ge,ys="Below is an expected speedup diagram that compares pure inference time between the native implementation and the Flash Attention 2.",Qt,F,_s='<img src="https://huggingface.co/datasets/visheratin/documentation-images/resolve/main/nllb-speedup.webp"/>',Kt,Ie,Ot,Ze,Ms=`PyTorch includes a native scaled dot-product attention (SDPA) operator as part of <code>torch.nn.functional</code>. This function
encompasses several implementations that can be applied depending on the inputs and the hardware in use. See the
<a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">official documentation</a>
or the <a href="https://huggingface.co/docs/transformers/main/en/perf_infer_gpu_one#pytorch-scaled-dot-product-attention" rel="nofollow">GPU Inference</a>
page for more information.`,en,Ce,Ts=`SDPA is used by default for <code>torch&gt;=2.1.1</code> when an implementation is available, but you may also set
<code>attn_implementation=&quot;sdpa&quot;</code> in <code>from_pretrained()</code> to explicitly request SDPA to be used.`,tn,Le,nn,Re,ws="For the best speedups, we recommend loading the model in half-precision (e.g. <code>torch.float16</code> or <code>torch.bfloat16</code>).",sn,We,an,it,ln;return M=new $({props:{title:"NLLB",local:"nllb",headingTag:"h1"}}),V=new $({props:{title:"Updated tokenizer behavior",local:"transformers.NllbTokenizer",headingTag:"h2"}}),E=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME5sbGJUb2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBObGxiVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm5sbGItMjAwLWRpc3RpbGxlZC02MDBNJTIyKSUwQXRva2VuaXplciglMjJIb3clMjB3YXMlMjB5b3VyJTIwZGF5JTNGJTIyKS5pbnB1dF9pZHMlMEElMEElMjMlMjAyJTNBJTIwJyUzQyUyRnMlM0UnJTBBJTIzJTIwMjU2MDQ3JTIwJTNBJTIwJ2VuZ19MYXRuJw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> NllbTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = NllbTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/nllb-200-distilled-600M&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer(<span class="hljs-string">&quot;How was your day?&quot;</span>).input_ids
[<span class="hljs-number">13374</span>, <span class="hljs-number">1398</span>, <span class="hljs-number">4260</span>, <span class="hljs-number">4039</span>, <span class="hljs-number">248130</span>, <span class="hljs-number">2</span>, <span class="hljs-number">256047</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 2: &#x27;&lt;/s&gt;&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 256047 : &#x27;eng_Latn&#x27;</span>`,wrap:!1}}),A=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME5sbGJUb2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBObGxiVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm5sbGItMjAwLWRpc3RpbGxlZC02MDBNJTIyKSUwQXRva2VuaXplciglMjJIb3clMjB3YXMlMjB5b3VyJTIwZGF5JTNGJTIyKS5pbnB1dF9pZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> NllbTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = NllbTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/nllb-200-distilled-600M&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer(<span class="hljs-string">&quot;How was your day?&quot;</span>).input_ids
[<span class="hljs-number">256047</span>, <span class="hljs-number">13374</span>, <span class="hljs-number">1398</span>, <span class="hljs-number">4260</span>, <span class="hljs-number">4039</span>, <span class="hljs-number">248130</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),D=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME5sbGJUb2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBObGxiVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm5sbGItMjAwLWRpc3RpbGxlZC02MDBNJTIyJTJDJTIwbGVnYWN5X2JlaGF2aW91ciUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> NllbTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = NllbTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/nllb-200-distilled-600M&quot;</span>, legacy_behaviour=<span class="hljs-literal">True</span>)`,wrap:!1}}),Q=new $({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ae=new $({props:{title:"Generating with NLLB",local:"generating-with-nllb",headingTag:"h2"}}),re=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTSUyQyUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm5sbGItMjAwLWRpc3RpbGxlZC02MDBNJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm5sbGItMjAwLWRpc3RpbGxlZC02MDBNJTIyKSUwQSUwQWFydGljbGUlMjAlM0QlMjAlMjJVTiUyMENoaWVmJTIwc2F5cyUyMHRoZXJlJTIwaXMlMjBubyUyMG1pbGl0YXJ5JTIwc29sdXRpb24lMjBpbiUyMFN5cmlhJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKGFydGljbGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXRyYW5zbGF0ZWRfdG9rZW5zJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwKippbnB1dHMlMkMlMjBmb3JjZWRfYm9zX3Rva2VuX2lkJTNEdG9rZW5pemVyLmNvbnZlcnRfdG9rZW5zX3RvX2lkcyglMjJmcmFfTGF0biUyMiklMkMlMjBtYXhfbGVuZ3RoJTNEMzAlMEEpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZSh0cmFuc2xhdGVkX3Rva2VucyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSeq2SeqLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/nllb-200-distilled-600M&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;facebook/nllb-200-distilled-600M&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>article = <span class="hljs-string">&quot;UN Chief says there is no military solution in Syria&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(article, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>translated_tokens = model.generate(
<span class="hljs-meta">... </span>    **inputs, forced_bos_token_id=tokenizer.convert_tokens_to_ids(<span class="hljs-string">&quot;fra_Latn&quot;</span>), max_length=<span class="hljs-number">30</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(translated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
Le chef de l<span class="hljs-string">&#x27;ONU dit qu&#x27;</span>il n<span class="hljs-string">&#x27;y a pas de solution militaire en Syrie</span>`,wrap:!1}}),ie=new $({props:{title:"Generating from any other language than English",local:"generating-from-any-other-language-than-english",headingTag:"h3"}}),de=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTSUyQyUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm5sbGItMjAwLWRpc3RpbGxlZC02MDBNJTIyJTJDJTIwdG9rZW4lM0RUcnVlJTJDJTIwc3JjX2xhbmclM0QlMjJyb25fTGF0biUyMiUwQSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZubGxiLTIwMC1kaXN0aWxsZWQtNjAwTSUyMiUyQyUyMHRva2VuJTNEVHJ1ZSklMEElMEFhcnRpY2xlJTIwJTNEJTIwJTIyJUM1JTlFZWZ1bCUyME9OVSUyMHNwdW5lJTIwYyVDNCU4MyUyMG51JTIwZXhpc3QlQzQlODMlMjBvJTIwc29sdSVDNSVBM2llJTIwbWlsaXRhciVDNCU4MyUyMCVDMyVBRW4lMjBTaXJpYSUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihhcnRpY2xlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF0cmFuc2xhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCUwQSUyMCUyMCUyMCUyMCoqaW5wdXRzJTJDJTIwZm9yY2VkX2Jvc190b2tlbl9pZCUzRHRva2VuaXplci5jb252ZXJ0X3Rva2Vuc190b19pZHMoJTIyZGV1X0xhdG4lMjIpJTJDJTIwbWF4X2xlbmd0aCUzRDMwJTBBKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUodHJhbnNsYXRlZF90b2tlbnMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSeq2SeqLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;facebook/nllb-200-distilled-600M&quot;</span>, token=<span class="hljs-literal">True</span>, src_lang=<span class="hljs-string">&quot;ron_Latn&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;facebook/nllb-200-distilled-600M&quot;</span>, token=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>article = <span class="hljs-string">&quot;Şeful ONU spune că nu există o soluţie militară în Siria&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(article, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>translated_tokens = model.generate(
<span class="hljs-meta">... </span>    **inputs, forced_bos_token_id=tokenizer.convert_tokens_to_ids(<span class="hljs-string">&quot;deu_Latn&quot;</span>), max_length=<span class="hljs-number">30</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(translated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
UN-Chef sagt, es gibt keine militärische Lösung <span class="hljs-keyword">in</span> Syrien`,wrap:!1}}),me=new $({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ue=new $({props:{title:"NllbTokenizer",local:"nllbtokenizer",headingTag:"h2"}}),he=new Fe({props:{name:"class transformers.NllbTokenizer",anchor:"transformers.NllbTokenizer",parameters:[{name:"vocab_file",val:""},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"sep_token",val:" = '</s>'"},{name:"cls_token",val:" = '<s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"pad_token",val:" = '<pad>'"},{name:"mask_token",val:" = '<mask>'"},{name:"tokenizer_file",val:" = None"},{name:"src_lang",val:" = None"},{name:"tgt_lang",val:" = None"},{name:"sp_model_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"additional_special_tokens",val:" = None"},{name:"legacy_behaviour",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.NllbTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.NllbTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the beginning of
sequence. The token used is the <code>cls_token</code>.</p>

					</div>`,name:"bos_token"},{anchor:"transformers.NllbTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.NllbTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.NllbTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.NllbTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.NllbTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.NllbTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;mask&gt;&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"},{anchor:"transformers.NllbTokenizer.tokenizer_file",description:`<strong>tokenizer_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The path to a tokenizer file to use instead of the vocab file.`,name:"tokenizer_file"},{anchor:"transformers.NllbTokenizer.src_lang",description:`<strong>src_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The language to use as source language for translation.`,name:"src_lang"},{anchor:"transformers.NllbTokenizer.tgt_lang",description:`<strong>tgt_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The language to use as target language for translation.`,name:"tgt_lang"},{anchor:"transformers.NllbTokenizer.sp_model_kwargs",description:`<strong>sp_model_kwargs</strong> (<code>Dict[str, str]</code>) &#x2014;
Additional keyword arguments to pass to the model initialization.`,name:"sp_model_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/nllb/tokenization_nllb.py#L37"}}),L=new js({props:{anchor:"transformers.NllbTokenizer.example",$$slots:{default:[Zs]},$$scope:{ctx:Ve}}}),fe=new Fe({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.NllbTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.NllbTokenizer.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.NllbTokenizer.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/nllb/tokenization_nllb.py#L245",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),be=new $({props:{title:"NllbTokenizerFast",local:"nllbtokenizerfast",headingTag:"h2"}}),ke=new Fe({props:{name:"class transformers.NllbTokenizerFast",anchor:"transformers.NllbTokenizerFast",parameters:[{name:"vocab_file",val:" = None"},{name:"tokenizer_file",val:" = None"},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"sep_token",val:" = '</s>'"},{name:"cls_token",val:" = '<s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"pad_token",val:" = '<pad>'"},{name:"mask_token",val:" = '<mask>'"},{name:"src_lang",val:" = None"},{name:"tgt_lang",val:" = None"},{name:"additional_special_tokens",val:" = None"},{name:"legacy_behaviour",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.NllbTokenizerFast.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.NllbTokenizerFast.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the beginning of
sequence. The token used is the <code>cls_token</code>.</p>

					</div>`,name:"bos_token"},{anchor:"transformers.NllbTokenizerFast.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.NllbTokenizerFast.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.NllbTokenizerFast.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.NllbTokenizerFast.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.NllbTokenizerFast.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.NllbTokenizerFast.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;mask&gt;&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"},{anchor:"transformers.NllbTokenizerFast.tokenizer_file",description:`<strong>tokenizer_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The path to a tokenizer file to use instead of the vocab file.`,name:"tokenizer_file"},{anchor:"transformers.NllbTokenizerFast.src_lang",description:`<strong>src_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The language to use as source language for translation.`,name:"src_lang"},{anchor:"transformers.NllbTokenizerFast.tgt_lang",description:`<strong>tgt_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The language to use as target language for translation.`,name:"tgt_lang"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/nllb/tokenization_nllb_fast.py#L42"}}),R=new js({props:{anchor:"transformers.NllbTokenizerFast.example",$$slots:{default:[Cs]},$$scope:{ctx:Ve}}}),ye=new Fe({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.NllbTokenizerFast.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.NllbTokenizerFast.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.NllbTokenizerFast.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/nllb/tokenization_nllb_fast.py#L182",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),_e=new Fe({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.NllbTokenizerFast.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.NllbTokenizerFast.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.NllbTokenizerFast.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/nllb/tokenization_nllb_fast.py#L211",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of zeros.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),Me=new Fe({props:{name:"set_src_lang_special_tokens",anchor:"transformers.NllbTokenizerFast.set_src_lang_special_tokens",parameters:[{name:"src_lang",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/nllb/tokenization_nllb_fast.py#L266"}}),Te=new Fe({props:{name:"set_tgt_lang_special_tokens",anchor:"transformers.NllbTokenizerFast.set_tgt_lang_special_tokens",parameters:[{name:"lang",val:": str"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/nllb/tokenization_nllb_fast.py#L289"}}),we=new $({props:{title:"Using Flash Attention 2",local:"using-flash-attention-2",headingTag:"h2"}}),Je=new $({props:{title:"Installation",local:"installation",headingTag:"h3"}}),xe=new Z({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0biUyMC0tbm8tYnVpbGQtaXNvbGF0aW9u",highlighted:"pip install -U flash-attn --no-build-isolation",wrap:!1}}),Ue=new $({props:{title:"Usage",local:"usage",headingTag:"h3"}}),qe=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm5sbGItMjAwLWRpc3RpbGxlZC02MDBNJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyKS50byglMjJjdWRhJTIyKS5ldmFsKCklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm5sbGItMjAwLWRpc3RpbGxlZC02MDBNJTIyKSUwQSUwQWFydGljbGUlMjAlM0QlMjAlMjIlQzUlOUVlZnVsJTIwT05VJTIwc3B1bmUlMjBjJUM0JTgzJTIwbnUlMjBleGlzdCVDNCU4MyUyMG8lMjBzb2x1JUM1JUEzaWUlMjBtaWxpdGFyJUM0JTgzJTIwJUMzJUFFbiUyMFNpcmlhJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKGFydGljbGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQSUwQXRyYW5zbGF0ZWRfdG9rZW5zJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwKippbnB1dHMlMkMlMjBmb3JjZWRfYm9zX3Rva2VuX2lkJTNEdG9rZW5pemVyLmNvbnZlcnRfdG9rZW5zX3RvX2lkcyglMjJkZXVfTGF0biUyMiklMkMlMjBtYXhfbGVuZ3RoJTNEMzAlMEEpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZSh0cmFuc2xhdGVkX3Rva2VucyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSeq2SeqLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;facebook/nllb-200-distilled-600M&quot;</span>, torch_dtype=torch.float16, attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>).<span class="hljs-built_in">eval</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/nllb-200-distilled-600M&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>article = <span class="hljs-string">&quot;Şeful ONU spune că nu există o soluţie militară în Siria&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(article, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>translated_tokens = model.generate(
<span class="hljs-meta">... </span>    **inputs, forced_bos_token_id=tokenizer.convert_tokens_to_ids(<span class="hljs-string">&quot;deu_Latn&quot;</span>), max_length=<span class="hljs-number">30</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(translated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;UN-Chef sagt, es gibt keine militärische Lösung in Syrien&quot;</span>`,wrap:!1}}),Ne=new $({props:{title:"Expected speedups",local:"expected-speedups",headingTag:"h3"}}),Ie=new $({props:{title:"Using Scaled Dot Product Attention (SDPA)",local:"using-scaled-dot-product-attention-sdpa",headingTag:"h2"}}),Le=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm5sbGItMjAwLWRpc3RpbGxlZC02MDBNJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMnNkcGElMjIpJTBBLi4u",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSeq2SeqLM
model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;facebook/nllb-200-distilled-600M&quot;</span>, torch_dtype=torch.float16, attn_implementation=<span class="hljs-string">&quot;sdpa&quot;</span>)
...`,wrap:!1}}),We=new Is({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/nllb.md"}}),{c(){b=o("meta"),z=a(),v=o("p"),y=a(),d(M.$$.fragment),c=a(),w=o("div"),w.innerHTML=Gn,pt=a(),d(V.$$.fragment),ct=a(),B=o("p"),B.innerHTML=In,dt=a(),X=o("p"),X.innerHTML=Zn,mt=a(),H=o("p"),H.textContent=Cn,gt=a(),d(E.$$.fragment),ut=a(),S=o("p"),S.textContent=Ln,ht=a(),d(A.$$.fragment),ft=a(),Y=o("p"),Y.textContent=Rn,bt=a(),d(D.$$.fragment),kt=a(),P=o("p"),P.innerHTML=Wn,yt=a(),d(Q.$$.fragment),_t=a(),K=o("p"),K.innerHTML=Fn,Mt=a(),O=o("p"),O.textContent=Vn,Tt=a(),ee=o("p"),ee.innerHTML=Bn,wt=a(),te=o("p"),te.textContent=Xn,vt=a(),ne=o("p"),ne.innerHTML=Hn,Jt=a(),se=o("p"),se.innerHTML=En,jt=a(),d(ae.$$.fragment),$t=a(),le=o("p"),le.innerHTML=Sn,xt=a(),oe=o("p"),oe.innerHTML=An,Ut=a(),d(re.$$.fragment),zt=a(),d(ie.$$.fragment),qt=a(),pe=o("p"),pe.innerHTML=Yn,Nt=a(),ce=o("p"),ce.textContent=Dn,Gt=a(),d(de.$$.fragment),It=a(),d(me.$$.fragment),Zt=a(),ge=o("ul"),ge.innerHTML=Pn,Ct=a(),d(ue.$$.fragment),Lt=a(),T=o("div"),d(he.$$.fragment),rn=a(),Be=o("p"),Be.textContent=Qn,pn=a(),Xe=o("p"),Xe.innerHTML=Kn,cn=a(),He=o("p"),He.innerHTML=On,dn=vs(`
<tokens> <eos>\` for target language documents.
`),d(L.$$.fragment),mn=a(),x=o("div"),d(fe.$$.fragment),gn=a(),Ee=o("p"),Ee.innerHTML=es,un=a(),Se=o("ul"),Se.innerHTML=ts,hn=a(),Ae=o("p"),Ae.textContent=ns,Rt=a(),d(be.$$.fragment),Wt=a(),k=o("div"),d(ke.$$.fragment),fn=a(),Ye=o("p"),Ye.innerHTML=ss,bn=a(),De=o("p"),De.innerHTML=as,kn=a(),Pe=o("p"),Pe.innerHTML=ls,yn=vs(`
<tokens> <eos>\` for target language documents.
`),d(R.$$.fragment),_n=a(),j=o("div"),d(ye.$$.fragment),Mn=a(),Qe=o("p"),Qe.textContent=os,Tn=a(),Ke=o("p"),Ke.innerHTML=rs,wn=a(),Oe=o("ul"),Oe.innerHTML=is,vn=a(),et=o("p"),et.textContent=ps,Jn=a(),W=o("div"),d(_e.$$.fragment),jn=a(),tt=o("p"),tt.textContent=cs,$n=a(),q=o("div"),d(Me.$$.fragment),xn=a(),nt=o("p"),nt.textContent=ds,Un=a(),st=o("ul"),st.innerHTML=ms,zn=a(),N=o("div"),d(Te.$$.fragment),qn=a(),at=o("p"),at.textContent=gs,Nn=a(),lt=o("ul"),lt.innerHTML=us,Ft=a(),d(we.$$.fragment),Vt=a(),ve=o("p"),ve.innerHTML=hs,Bt=a(),d(Je.$$.fragment),Xt=a(),je=o("p"),je.innerHTML=fs,Ht=a(),$e=o("p"),$e.innerHTML=bs,Et=a(),d(xe.$$.fragment),St=a(),d(Ue.$$.fragment),At=a(),ze=o("p"),ze.innerHTML=ks,Yt=a(),d(qe.$$.fragment),Dt=a(),d(Ne.$$.fragment),Pt=a(),Ge=o("p"),Ge.textContent=ys,Qt=a(),F=o("div"),F.innerHTML=_s,Kt=a(),d(Ie.$$.fragment),Ot=a(),Ze=o("p"),Ze.innerHTML=Ms,en=a(),Ce=o("p"),Ce.innerHTML=Ts,tn=a(),d(Le.$$.fragment),nn=a(),Re=o("p"),Re.innerHTML=ws,sn=a(),d(We.$$.fragment),an=a(),it=o("p"),this.h()},l(e){const t=Ns("svelte-u9bgzb",document.head);b=r(t,"META",{name:!0,content:!0}),t.forEach(n),z=l(e),v=r(e,"P",{}),C(v).forEach(n),y=l(e),m(M.$$.fragment,e),c=l(e),w=r(e,"DIV",{class:!0,"data-svelte-h":!0}),p(w)!=="svelte-b95w5j"&&(w.innerHTML=Gn),pt=l(e),m(V.$$.fragment,e),ct=l(e),B=r(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1bqcebz"&&(B.innerHTML=In),dt=l(e),X=r(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-vrv0c7"&&(X.innerHTML=Zn),mt=l(e),H=r(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-vmuleo"&&(H.textContent=Cn),gt=l(e),m(E.$$.fragment,e),ut=l(e),S=r(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1qx2sah"&&(S.textContent=Ln),ht=l(e),m(A.$$.fragment,e),ft=l(e),Y=r(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-obd9iw"&&(Y.textContent=Rn),bt=l(e),m(D.$$.fragment,e),kt=l(e),P=r(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-ib1bh"&&(P.innerHTML=Wn),yt=l(e),m(Q.$$.fragment,e),_t=l(e),K=r(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-12x4cpm"&&(K.innerHTML=Fn),Mt=l(e),O=r(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-wu27l3"&&(O.textContent=Vn),Tt=l(e),ee=r(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1j7uypk"&&(ee.innerHTML=Bn),wt=l(e),te=r(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1ayd4bm"&&(te.textContent=Xn),vt=l(e),ne=r(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-qp2ubt"&&(ne.innerHTML=Hn),Jt=l(e),se=r(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-ywl52z"&&(se.innerHTML=En),jt=l(e),m(ae.$$.fragment,e),$t=l(e),le=r(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-gz9jek"&&(le.innerHTML=Sn),xt=l(e),oe=r(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-c2ujwv"&&(oe.innerHTML=An),Ut=l(e),m(re.$$.fragment,e),zt=l(e),m(ie.$$.fragment,e),qt=l(e),pe=r(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-ets0jr"&&(pe.innerHTML=Yn),Nt=l(e),ce=r(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-14hvt1f"&&(ce.textContent=Dn),Gt=l(e),m(de.$$.fragment,e),It=l(e),m(me.$$.fragment,e),Zt=l(e),ge=r(e,"UL",{"data-svelte-h":!0}),p(ge)!=="svelte-6ej6p2"&&(ge.innerHTML=Pn),Ct=l(e),m(ue.$$.fragment,e),Lt=l(e),T=r(e,"DIV",{class:!0});var J=C(T);m(he.$$.fragment,J),rn=l(J),Be=r(J,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-7mmiyn"&&(Be.textContent=Qn),pn=l(J),Xe=r(J,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-1serjol"&&(Xe.innerHTML=Kn),cn=l(J),He=r(J,"P",{"data-svelte-h":!0}),p(He)!=="svelte-1i8rh37"&&(He.innerHTML=On),dn=Js(J,`
<tokens> <eos>\` for target language documents.
`),m(L.$$.fragment,J),mn=l(J),x=r(J,"DIV",{class:!0});var U=C(x);m(fe.$$.fragment,U),gn=l(U),Ee=r(U,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-nkpot4"&&(Ee.innerHTML=es),un=l(U),Se=r(U,"UL",{"data-svelte-h":!0}),p(Se)!=="svelte-mlrsks"&&(Se.innerHTML=ts),hn=l(U),Ae=r(U,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-46aam0"&&(Ae.textContent=ns),U.forEach(n),J.forEach(n),Rt=l(e),m(be.$$.fragment,e),Wt=l(e),k=r(e,"DIV",{class:!0});var _=C(k);m(ke.$$.fragment,_),fn=l(_),Ye=r(_,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-g5z8ln"&&(Ye.innerHTML=ss),bn=l(_),De=r(_,"P",{"data-svelte-h":!0}),p(De)!=="svelte-fh0aq"&&(De.innerHTML=as),kn=l(_),Pe=r(_,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-1i8rh37"&&(Pe.innerHTML=ls),yn=Js(_,`
<tokens> <eos>\` for target language documents.
`),m(R.$$.fragment,_),_n=l(_),j=r(_,"DIV",{class:!0});var G=C(j);m(ye.$$.fragment,G),Mn=l(G),Qe=r(G,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-1vll0v2"&&(Qe.textContent=os),Tn=l(G),Ke=r(G,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-90np8u"&&(Ke.innerHTML=rs),wn=l(G),Oe=r(G,"UL",{"data-svelte-h":!0}),p(Oe)!=="svelte-mlrsks"&&(Oe.innerHTML=is),vn=l(G),et=r(G,"P",{"data-svelte-h":!0}),p(et)!=="svelte-46aam0"&&(et.textContent=ps),G.forEach(n),Jn=l(_),W=r(_,"DIV",{class:!0});var on=C(W);m(_e.$$.fragment,on),jn=l(on),tt=r(on,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-1bcwf97"&&(tt.textContent=cs),on.forEach(n),$n=l(_),q=r(_,"DIV",{class:!0});var ot=C(q);m(Me.$$.fragment,ot),xn=l(ot),nt=r(ot,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-1euodjq"&&(nt.textContent=ds),Un=l(ot),st=r(ot,"UL",{"data-svelte-h":!0}),p(st)!=="svelte-rrgzfj"&&(st.innerHTML=ms),ot.forEach(n),zn=l(_),N=r(_,"DIV",{class:!0});var rt=C(N);m(Te.$$.fragment,rt),qn=l(rt),at=r(rt,"P",{"data-svelte-h":!0}),p(at)!=="svelte-1i6tlcm"&&(at.textContent=gs),Nn=l(rt),lt=r(rt,"UL",{"data-svelte-h":!0}),p(lt)!=="svelte-1durotj"&&(lt.innerHTML=us),rt.forEach(n),_.forEach(n),Ft=l(e),m(we.$$.fragment,e),Vt=l(e),ve=r(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-1oyivwb"&&(ve.innerHTML=hs),Bt=l(e),m(Je.$$.fragment,e),Xt=l(e),je=r(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-3ltiwn"&&(je.innerHTML=fs),Ht=l(e),$e=r(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-1pp3dkd"&&($e.innerHTML=bs),Et=l(e),m(xe.$$.fragment,e),St=l(e),m(Ue.$$.fragment,e),At=l(e),ze=r(e,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-1djrqq6"&&(ze.innerHTML=ks),Yt=l(e),m(qe.$$.fragment,e),Dt=l(e),m(Ne.$$.fragment,e),Pt=l(e),Ge=r(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-bjnkty"&&(Ge.textContent=ys),Qt=l(e),F=r(e,"DIV",{style:!0,"data-svelte-h":!0}),p(F)!=="svelte-1obt1wq"&&(F.innerHTML=_s),Kt=l(e),m(Ie.$$.fragment,e),Ot=l(e),Ze=r(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1cid2pe"&&(Ze.innerHTML=Ms),en=l(e),Ce=r(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-1x11lxg"&&(Ce.innerHTML=Ts),tn=l(e),m(Le.$$.fragment,e),nn=l(e),Re=r(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-djb2w0"&&(Re.innerHTML=ws),sn=l(e),m(We.$$.fragment,e),an=l(e),it=r(e,"P",{}),C(it).forEach(n),this.h()},h(){I(b,"name","hf:doc:metadata"),I(b,"content",Rs),I(w,"class","flex flex-wrap space-x-1"),I(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Gs(F,"text-align","center")},m(e,t){i(document.head,b),s(e,z,t),s(e,v,t),s(e,y,t),g(M,e,t),s(e,c,t),s(e,w,t),s(e,pt,t),g(V,e,t),s(e,ct,t),s(e,B,t),s(e,dt,t),s(e,X,t),s(e,mt,t),s(e,H,t),s(e,gt,t),g(E,e,t),s(e,ut,t),s(e,S,t),s(e,ht,t),g(A,e,t),s(e,ft,t),s(e,Y,t),s(e,bt,t),g(D,e,t),s(e,kt,t),s(e,P,t),s(e,yt,t),g(Q,e,t),s(e,_t,t),s(e,K,t),s(e,Mt,t),s(e,O,t),s(e,Tt,t),s(e,ee,t),s(e,wt,t),s(e,te,t),s(e,vt,t),s(e,ne,t),s(e,Jt,t),s(e,se,t),s(e,jt,t),g(ae,e,t),s(e,$t,t),s(e,le,t),s(e,xt,t),s(e,oe,t),s(e,Ut,t),g(re,e,t),s(e,zt,t),g(ie,e,t),s(e,qt,t),s(e,pe,t),s(e,Nt,t),s(e,ce,t),s(e,Gt,t),g(de,e,t),s(e,It,t),g(me,e,t),s(e,Zt,t),s(e,ge,t),s(e,Ct,t),g(ue,e,t),s(e,Lt,t),s(e,T,t),g(he,T,null),i(T,rn),i(T,Be),i(T,pn),i(T,Xe),i(T,cn),i(T,He),i(T,dn),g(L,T,null),i(T,mn),i(T,x),g(fe,x,null),i(x,gn),i(x,Ee),i(x,un),i(x,Se),i(x,hn),i(x,Ae),s(e,Rt,t),g(be,e,t),s(e,Wt,t),s(e,k,t),g(ke,k,null),i(k,fn),i(k,Ye),i(k,bn),i(k,De),i(k,kn),i(k,Pe),i(k,yn),g(R,k,null),i(k,_n),i(k,j),g(ye,j,null),i(j,Mn),i(j,Qe),i(j,Tn),i(j,Ke),i(j,wn),i(j,Oe),i(j,vn),i(j,et),i(k,Jn),i(k,W),g(_e,W,null),i(W,jn),i(W,tt),i(k,$n),i(k,q),g(Me,q,null),i(q,xn),i(q,nt),i(q,Un),i(q,st),i(k,zn),i(k,N),g(Te,N,null),i(N,qn),i(N,at),i(N,Nn),i(N,lt),s(e,Ft,t),g(we,e,t),s(e,Vt,t),s(e,ve,t),s(e,Bt,t),g(Je,e,t),s(e,Xt,t),s(e,je,t),s(e,Ht,t),s(e,$e,t),s(e,Et,t),g(xe,e,t),s(e,St,t),g(Ue,e,t),s(e,At,t),s(e,ze,t),s(e,Yt,t),g(qe,e,t),s(e,Dt,t),g(Ne,e,t),s(e,Pt,t),s(e,Ge,t),s(e,Qt,t),s(e,F,t),s(e,Kt,t),g(Ie,e,t),s(e,Ot,t),s(e,Ze,t),s(e,en,t),s(e,Ce,t),s(e,tn,t),g(Le,e,t),s(e,nn,t),s(e,Re,t),s(e,sn,t),g(We,e,t),s(e,an,t),s(e,it,t),ln=!0},p(e,[t]){const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),L.$set(J);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),R.$set(U)},i(e){ln||(u(M.$$.fragment,e),u(V.$$.fragment,e),u(E.$$.fragment,e),u(A.$$.fragment,e),u(D.$$.fragment,e),u(Q.$$.fragment,e),u(ae.$$.fragment,e),u(re.$$.fragment,e),u(ie.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(ue.$$.fragment,e),u(he.$$.fragment,e),u(L.$$.fragment,e),u(fe.$$.fragment,e),u(be.$$.fragment,e),u(ke.$$.fragment,e),u(R.$$.fragment,e),u(ye.$$.fragment,e),u(_e.$$.fragment,e),u(Me.$$.fragment,e),u(Te.$$.fragment,e),u(we.$$.fragment,e),u(Je.$$.fragment,e),u(xe.$$.fragment,e),u(Ue.$$.fragment,e),u(qe.$$.fragment,e),u(Ne.$$.fragment,e),u(Ie.$$.fragment,e),u(Le.$$.fragment,e),u(We.$$.fragment,e),ln=!0)},o(e){h(M.$$.fragment,e),h(V.$$.fragment,e),h(E.$$.fragment,e),h(A.$$.fragment,e),h(D.$$.fragment,e),h(Q.$$.fragment,e),h(ae.$$.fragment,e),h(re.$$.fragment,e),h(ie.$$.fragment,e),h(de.$$.fragment,e),h(me.$$.fragment,e),h(ue.$$.fragment,e),h(he.$$.fragment,e),h(L.$$.fragment,e),h(fe.$$.fragment,e),h(be.$$.fragment,e),h(ke.$$.fragment,e),h(R.$$.fragment,e),h(ye.$$.fragment,e),h(_e.$$.fragment,e),h(Me.$$.fragment,e),h(Te.$$.fragment,e),h(we.$$.fragment,e),h(Je.$$.fragment,e),h(xe.$$.fragment,e),h(Ue.$$.fragment,e),h(qe.$$.fragment,e),h(Ne.$$.fragment,e),h(Ie.$$.fragment,e),h(Le.$$.fragment,e),h(We.$$.fragment,e),ln=!1},d(e){e&&(n(z),n(v),n(y),n(c),n(w),n(pt),n(ct),n(B),n(dt),n(X),n(mt),n(H),n(gt),n(ut),n(S),n(ht),n(ft),n(Y),n(bt),n(kt),n(P),n(yt),n(_t),n(K),n(Mt),n(O),n(Tt),n(ee),n(wt),n(te),n(vt),n(ne),n(Jt),n(se),n(jt),n($t),n(le),n(xt),n(oe),n(Ut),n(zt),n(qt),n(pe),n(Nt),n(ce),n(Gt),n(It),n(Zt),n(ge),n(Ct),n(Lt),n(T),n(Rt),n(Wt),n(k),n(Ft),n(Vt),n(ve),n(Bt),n(Xt),n(je),n(Ht),n($e),n(Et),n(St),n(At),n(ze),n(Yt),n(Dt),n(Pt),n(Ge),n(Qt),n(F),n(Kt),n(Ot),n(Ze),n(en),n(Ce),n(tn),n(nn),n(Re),n(sn),n(an),n(it)),n(b),f(M,e),f(V,e),f(E,e),f(A,e),f(D,e),f(Q,e),f(ae,e),f(re,e),f(ie,e),f(de,e),f(me,e),f(ue,e),f(he),f(L),f(fe),f(be,e),f(ke),f(R),f(ye),f(_e),f(Me),f(Te),f(we,e),f(Je,e),f(xe,e),f(Ue,e),f(qe,e),f(Ne,e),f(Ie,e),f(Le,e),f(We,e)}}}const Rs='{"title":"NLLB","local":"nllb","sections":[{"title":"Updated tokenizer behavior","local":"transformers.NllbTokenizer","sections":[],"depth":2},{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Generating with NLLB","local":"generating-with-nllb","sections":[{"title":"Generating from any other language than English","local":"generating-from-any-other-language-than-english","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"NllbTokenizer","local":"nllbtokenizer","sections":[],"depth":2},{"title":"NllbTokenizerFast","local":"nllbtokenizerfast","sections":[],"depth":2},{"title":"Using Flash Attention 2","local":"using-flash-attention-2","sections":[{"title":"Installation","local":"installation","sections":[],"depth":3},{"title":"Usage","local":"usage","sections":[],"depth":3},{"title":"Expected speedups","local":"expected-speedups","sections":[],"depth":3}],"depth":2},{"title":"Using Scaled Dot Product Attention (SDPA)","local":"using-scaled-dot-product-attention-sdpa","sections":[],"depth":2}],"depth":1}';function Ws(Ve){return Us(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class As extends zs{constructor(b){super(),qs(this,b,Ws,Ls,xs,{})}}export{As as component};
