import{s as Yt,o as Qt,n as Ze}from"../chunks/scheduler.18a86fab.js";import{S as Pt,i as Lt,g as d,s as l,r as h,A as Ht,h as c,f as s,c as r,j as k,u as f,x as T,k as G,y as m,a,v as g,d as u,t as M,w as y}from"../chunks/index.98837b22.js";import{T as jt}from"../chunks/Tip.77304350.js";import{D as _e}from"../chunks/Docstring.6758ea23.js";import{C as at}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as vt}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as z}from"../chunks/Heading.7e7e0c5b.js";import{E as Dt}from"../chunks/index.f01015d9.js";function qt(v){let n,_="Example:",i,p,b;return p=new at({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpdml0Q29uZmlnJTJDJTIwVml2aXRNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBWaVZpVCUyMGdvb2dsZSUyRnZpdml0LWItMTZ4Mi1raW5ldGljczQwMCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBWaXZpdENvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBnb29nbGUlMkZ2aXZpdC1iLTE2eDIta2luZXRpY3M0MDAlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFZpdml0TW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VivitConfig, VivitModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a ViViT google/vivit-b-16x2-kinetics400 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = VivitConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the google/vivit-b-16x2-kinetics400 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VivitModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){n=d("p"),n.textContent=_,i=l(),h(p.$$.fragment)},l(o){n=c(o,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11lpom8"&&(n.textContent=_),i=r(o),f(p.$$.fragment,o)},m(o,w){a(o,n,w),a(o,i,w),g(p,o,w),b=!0},p:Ze,i(o){b||(u(p.$$.fragment,o),b=!0)},o(o){M(p.$$.fragment,o),b=!1},d(o){o&&(s(n),s(i)),y(p,o)}}}function Kt(v){let n,_=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=_},l(i){n=c(i,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=_)},m(i,p){a(i,n,p)},p:Ze,d(i){i&&s(n)}}}function Ot(v){let n,_="Examples:",i,p,b;return p=new at({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> av
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VivitImageProcessor, VivitModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

<span class="hljs-meta">&gt;&gt;&gt; </span>np.random.seed(<span class="hljs-number">0</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">read_video_pyav</span>(<span class="hljs-params">container, indices</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Decode the video with PyAV decoder.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        container (\`av.container.input.InputContainer\`): PyAV container.
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of frame indices to decode.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        result (np.ndarray): np array of decoded frames of shape (num_frames, height, width, 3).
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    frames = []
<span class="hljs-meta">... </span>    container.seek(<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>    start_index = indices[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    end_index = indices[-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, frame <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(container.decode(video=<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt; end_index:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">break</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt;= start_index <span class="hljs-keyword">and</span> i <span class="hljs-keyword">in</span> indices:
<span class="hljs-meta">... </span>            frames.append(frame)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> np.stack([x.to_ndarray(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;rgb24&quot;</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> frames])


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">sample_frame_indices</span>(<span class="hljs-params">clip_len, frame_sample_rate, seg_len</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Sample a given number of frame indices from the video.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        clip_len (\`int\`): Total number of frames to sample.
<span class="hljs-meta">... </span>        frame_sample_rate (\`int\`): Sample every n-th frame.
<span class="hljs-meta">... </span>        seg_len (\`int\`): Maximum allowed index of sample&#x27;s last frame.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of sampled frame indices
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    converted_len = <span class="hljs-built_in">int</span>(clip_len * frame_sample_rate)
<span class="hljs-meta">... </span>    end_idx = np.random.randint(converted_len, seg_len)
<span class="hljs-meta">... </span>    start_idx = end_idx - converted_len
<span class="hljs-meta">... </span>    indices = np.linspace(start_idx, end_idx, num=clip_len)
<span class="hljs-meta">... </span>    indices = np.clip(indices, start_idx, end_idx - <span class="hljs-number">1</span>).astype(np.int64)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> indices


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># video clip consists of 300 frames (10 seconds at 30 FPS)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>file_path = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;nielsr/video-demo&quot;</span>, filename=<span class="hljs-string">&quot;eating_spaghetti.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>container = av.<span class="hljs-built_in">open</span>(file_path)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sample 32 frames</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>indices = sample_frame_indices(clip_len=<span class="hljs-number">32</span>, frame_sample_rate=<span class="hljs-number">1</span>, seg_len=container.streams.video[<span class="hljs-number">0</span>].frames)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = read_video_pyav(container=container, indices=indices)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = VivitImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vivit-b-16x2-kinetics400&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VivitModel.from_pretrained(<span class="hljs-string">&quot;google/vivit-b-16x2-kinetics400&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare video for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(<span class="hljs-built_in">list</span>(video), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">3137</span>, <span class="hljs-number">768</span>]`,wrap:!1}}),{c(){n=d("p"),n.textContent=_,i=l(),h(p.$$.fragment)},l(o){n=c(o,"P",{"data-svelte-h":!0}),T(n)!=="svelte-kvfsh7"&&(n.textContent=_),i=r(o),f(p.$$.fragment,o)},m(o,w){a(o,n,w),a(o,i,w),g(p,o,w),b=!0},p:Ze,i(o){b||(u(p.$$.fragment,o),b=!0)},o(o){M(p.$$.fragment,o),b=!1},d(o){o&&(s(n),s(i)),y(p,o)}}}function es(v){let n,_=`Note that it’s possible to fine-tune ViT on higher resolution images than the ones it has been trained on, by
setting <code>interpolate_pos_encoding</code> to <code>True</code> in the forward of the model. This will interpolate the pre-trained
position embeddings to the higher resolution.`;return{c(){n=d("p"),n.innerHTML=_},l(i){n=c(i,"P",{"data-svelte-h":!0}),T(n)!=="svelte-111lhr1"&&(n.innerHTML=_)},m(i,p){a(i,n,p)},p:Ze,d(i){i&&s(n)}}}function ts(v){let n,_=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=_},l(i){n=c(i,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=_)},m(i,p){a(i,n,p)},p:Ze,d(i){i&&s(n)}}}function ss(v){let n,_="Examples:",i,p,b;return p=new at({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> av
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VivitImageProcessor, VivitForVideoClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

<span class="hljs-meta">&gt;&gt;&gt; </span>np.random.seed(<span class="hljs-number">0</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">read_video_pyav</span>(<span class="hljs-params">container, indices</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Decode the video with PyAV decoder.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        container (\`av.container.input.InputContainer\`): PyAV container.
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of frame indices to decode.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        result (np.ndarray): np array of decoded frames of shape (num_frames, height, width, 3).
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    frames = []
<span class="hljs-meta">... </span>    container.seek(<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>    start_index = indices[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    end_index = indices[-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, frame <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(container.decode(video=<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt; end_index:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">break</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt;= start_index <span class="hljs-keyword">and</span> i <span class="hljs-keyword">in</span> indices:
<span class="hljs-meta">... </span>            frames.append(frame)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> np.stack([x.to_ndarray(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;rgb24&quot;</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> frames])


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">sample_frame_indices</span>(<span class="hljs-params">clip_len, frame_sample_rate, seg_len</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Sample a given number of frame indices from the video.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        clip_len (\`int\`): Total number of frames to sample.
<span class="hljs-meta">... </span>        frame_sample_rate (\`int\`): Sample every n-th frame.
<span class="hljs-meta">... </span>        seg_len (\`int\`): Maximum allowed index of sample&#x27;s last frame.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of sampled frame indices
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    converted_len = <span class="hljs-built_in">int</span>(clip_len * frame_sample_rate)
<span class="hljs-meta">... </span>    end_idx = np.random.randint(converted_len, seg_len)
<span class="hljs-meta">... </span>    start_idx = end_idx - converted_len
<span class="hljs-meta">... </span>    indices = np.linspace(start_idx, end_idx, num=clip_len)
<span class="hljs-meta">... </span>    indices = np.clip(indices, start_idx, end_idx - <span class="hljs-number">1</span>).astype(np.int64)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> indices


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># video clip consists of 300 frames (10 seconds at 30 FPS)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>file_path = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;nielsr/video-demo&quot;</span>, filename=<span class="hljs-string">&quot;eating_spaghetti.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>container = av.<span class="hljs-built_in">open</span>(file_path)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sample 32 frames</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>indices = sample_frame_indices(clip_len=<span class="hljs-number">32</span>, frame_sample_rate=<span class="hljs-number">4</span>, seg_len=container.streams.video[<span class="hljs-number">0</span>].frames)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = read_video_pyav(container=container, indices=indices)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = VivitImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vivit-b-16x2-kinetics400&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VivitForVideoClassification.from_pretrained(<span class="hljs-string">&quot;google/vivit-b-16x2-kinetics400&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(<span class="hljs-built_in">list</span>(video), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    logits = outputs.logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 400 Kinetics-400 classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
LABEL_116`,wrap:!1}}),{c(){n=d("p"),n.textContent=_,i=l(),h(p.$$.fragment)},l(o){n=c(o,"P",{"data-svelte-h":!0}),T(n)!=="svelte-kvfsh7"&&(n.textContent=_),i=r(o),f(p.$$.fragment,o)},m(o,w){a(o,n,w),a(o,i,w),g(p,o,w),b=!0},p:Ze,i(o){b||(u(p.$$.fragment,o),b=!0)},o(o){M(p.$$.fragment,o),b=!1},d(o){o&&(s(n),s(i)),y(p,o)}}}function ns(v){let n,_,i,p,b,o,w,Jt='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',We,Q,Ge,P,Ut=`The Vivit model was proposed in <a href="https://arxiv.org/abs/2103.15691" rel="nofollow">ViViT: A Video Vision Transformer</a> by Anurag Arnab, Mostafa Dehghani, Georg Heigold, Chen Sun, Mario Lučić, Cordelia Schmid.
The paper proposes one of the first successful pure-transformer based set of models for video understanding.`,xe,L,It="The abstract from the paper is the following:",$e,H,Ct="<em>We present pure-transformer based models for video classification, drawing upon the recent success of such models in image classification. Our model extracts spatio-temporal tokens from the input video, which are then encoded by a series of transformer layers. In order to handle the long sequences of tokens encountered in video, we propose several, efficient variants of our model which factorise the spatial- and temporal-dimensions of the input. Although transformer-based models are known to only be effective when large training datasets are available, we show how we can effectively regularise the model during training and leverage pretrained image models to be able to train on comparatively small datasets. We conduct thorough ablation studies, and achieve state-of-the-art results on multiple video classification benchmarks including Kinetics 400 and 600, Epic Kitchens, Something-Something v2 and Moments in Time, outperforming prior methods based on deep 3D convolutional networks.</em>",ke,D,Vt='This model was contributed by <a href="https://huggingface.co/jegormeister" rel="nofollow">jegormeister</a>. The original code (written in JAX) can be found <a href="https://github.com/google-research/scenic/tree/main/scenic/projects/vivit" rel="nofollow">here</a>.',ze,q,Re,K,Zt=`PyTorch includes a native scaled dot-product attention (SDPA) operator as part of <code>torch.nn.functional</code>. This function
encompasses several implementations that can be applied depending on the inputs and the hardware in use. See the
<a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">official documentation</a>
or the <a href="https://huggingface.co/docs/transformers/main/en/perf_infer_gpu_one#pytorch-scaled-dot-product-attention" rel="nofollow">GPU Inference</a>
page for more information.`,Ae,O,Bt=`SDPA is used by default for <code>torch&gt;=2.1.1</code> when an implementation is available, but you may also set
<code>attn_implementation=&quot;sdpa&quot;</code> in <code>from_pretrained()</code> to explicitly request SDPA to be used.`,Ne,ee,Fe,te,Wt="For the best speedups, we recommend loading the model in half-precision (e.g. <code>torch.float16</code> or <code>torch.bfloat16</code>).",Ee,se,Gt="On a local benchmark (A100-40GB, PyTorch 2.3.0, OS Ubuntu 22.04) with <code>float32</code> and <code>google/vivit-b-16x2-kinetics400</code> model, we saw the following speedups during inference.",Xe,ne,Se,ae,xt='<thead><tr><th align="right">num_training_steps</th> <th align="right">batch_size</th> <th align="right">is cuda</th> <th align="right">Speedup (%)</th> <th align="right">Eager peak mem (MB)</th> <th align="right">sdpa peak mem (MB)</th> <th align="right">Mem saving (%)</th></tr></thead> <tbody><tr><td align="right">100</td> <td align="right">1</td> <td align="right">True</td> <td align="right">7.122</td> <td align="right">2575.28</td> <td align="right">5932.54</td> <td align="right">130.364</td></tr></tbody>',Ye,oe,Qe,le,$t="<thead><tr><th>num_batches</th> <th>batch_size</th> <th>is cuda</th> <th>is half</th> <th>Speedup (%)</th> <th>Mem eager (MB)</th> <th>Mem BT (MB)</th> <th>Mem saved (%)</th></tr></thead> <tbody><tr><td>20</td> <td>1</td> <td>True</td> <td>False</td> <td>15.422</td> <td>715.807</td> <td>317.079</td> <td>125.75</td></tr> <tr><td>20</td> <td>2</td> <td>True</td> <td>False</td> <td>17.146</td> <td>1234.75</td> <td>447.175</td> <td>176.122</td></tr> <tr><td>20</td> <td>4</td> <td>True</td> <td>False</td> <td>18.093</td> <td>2275.82</td> <td>709.864</td> <td>220.6</td></tr> <tr><td>20</td> <td>8</td> <td>True</td> <td>False</td> <td>19.284</td> <td>4358.19</td> <td>1233.24</td> <td>253.393</td></tr></tbody>",Pe,re,Le,J,ie,ot,be,kt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/vivit#transformers.VivitModel">VivitModel</a>. It is used to instantiate a ViViT
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the ViViT
<a href="https://huggingface.co/google/vivit-b-16x2-kinetics400" rel="nofollow">google/vivit-b-16x2-kinetics400</a> architecture.`,lt,we,zt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,rt,R,He,de,De,V,ce,it,je,Rt="Constructs a Vivit image processor.",dt,A,pe,ct,ve,At="Preprocess an image or batch of images.",qe,me,Ke,Z,he,pt,Je,Nt=`The bare ViViT Transformer model outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,mt,I,fe,ht,Ue,Ft='The <a href="/docs/transformers/main/en/model_doc/vivit#transformers.VivitModel">VivitModel</a> forward method, overrides the <code>__call__</code> special method.',ft,N,gt,F,Oe,ge,et,j,ue,ut,Ie,Et=`ViViT Transformer model with a video classification head on top (a linear layer on top of the final hidden state of the
[CLS] token) e.g. for Kinetics-400.`,Mt,E,yt,Ce,Xt=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Tt,C,Me,_t,Ve,St='The <a href="/docs/transformers/main/en/model_doc/vivit#transformers.VivitForVideoClassification">VivitForVideoClassification</a> forward method, overrides the <code>__call__</code> special method.',bt,X,wt,S,tt,ye,st,Be,nt;return b=new z({props:{title:"Video Vision Transformer (ViViT)",local:"video-vision-transformer-vivit",headingTag:"h1"}}),Q=new z({props:{title:"Overview",local:"overview",headingTag:"h2"}}),q=new z({props:{title:"Using Scaled Dot Product Attention (SDPA)",local:"using-scaled-dot-product-attention-sdpa",headingTag:"h3"}}),ee=new at({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpdml0TW9kZWwlMEFtb2RlbCUyMCUzRCUyMFZpdml0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnZpdml0LWItMTZ4Mi1raW5ldGljczQwMCUyMiUyQyUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJzZHBhJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQS4uLg==",highlighted:`from transformers import VivitModel
model = <span class="hljs-module-access"><span class="hljs-module"><span class="hljs-identifier">VivitModel</span>.</span></span>from<span class="hljs-constructor">_pretrained(<span class="hljs-string">&quot;google/vivit-b-16x2-kinetics400&quot;</span>, <span class="hljs-params">attn_implementation</span>=<span class="hljs-string">&quot;sdpa&quot;</span>, <span class="hljs-params">torch_dtype</span>=<span class="hljs-params">torch</span>.<span class="hljs-params">float16</span>)</span>
...`,wrap:!1}}),ne=new z({props:{title:"Training",local:"training",headingTag:"h3"}}),oe=new z({props:{title:"Inference",local:"inference",headingTag:"h3"}}),re=new z({props:{title:"VivitConfig",local:"transformers.VivitConfig",headingTag:"h2"}}),ie=new _e({props:{name:"class transformers.VivitConfig",anchor:"transformers.VivitConfig",parameters:[{name:"image_size",val:" = 224"},{name:"num_frames",val:" = 32"},{name:"tubelet_size",val:" = [2, 16, 16]"},{name:"num_channels",val:" = 3"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu_fast'"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-06"},{name:"qkv_bias",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VivitConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.VivitConfig.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The number of frames in each video.`,name:"num_frames"},{anchor:"transformers.VivitConfig.tubelet_size",description:`<strong>tubelet_size</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[2, 16, 16]</code>) &#x2014;
The size (resolution) of each tubelet.`,name:"tubelet_size"},{anchor:"transformers.VivitConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.VivitConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.VivitConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.VivitConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.VivitConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.VivitConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu_fast&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code>, <code>&quot;gelu_fast&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.VivitConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.VivitConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.VivitConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.VivitConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-06) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.VivitConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a bias to the queries, keys and values.`,name:"qkv_bias"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vivit/configuration_vivit.py#L24"}}),R=new vt({props:{anchor:"transformers.VivitConfig.example",$$slots:{default:[qt]},$$scope:{ctx:v}}}),de=new z({props:{title:"VivitImageProcessor",local:"transformers.VivitImageProcessor",headingTag:"h2"}}),ce=new _e({props:{name:"class transformers.VivitImageProcessor",anchor:"transformers.VivitImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00784313725490196"},{name:"offset",val:": bool = True"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VivitImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by the
<code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.VivitImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 256}</code>):
Size of the output image after resizing. The shortest edge of the image will be resized to
<code>size[&quot;shortest_edge&quot;]</code> while maintaining the aspect ratio of the original image. Can be overridden by
<code>size</code> in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.VivitImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by the <code>resample</code> parameter in the
<code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.VivitImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by the <code>do_center_crop</code>
parameter in the <code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.VivitImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 224, &quot;width&quot;: 224}</code>):
Size of the image after applying the center crop. Can be overridden by the <code>crop_size</code> parameter in the
<code>preprocess</code> method.`,name:"crop_size"},{anchor:"transformers.VivitImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.VivitImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/127.5</code>) &#x2014;
Defines the scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter
in the <code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.VivitImageProcessor.offset",description:`<strong>offset</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to scale the image in both negative and positive directions. Can be overridden by the <code>offset</code> in
the <code>preprocess</code> method.`,name:"offset"},{anchor:"transformers.VivitImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.VivitImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.VivitImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vivit/image_processing_vivit.py#L66"}}),pe=new _e({props:{name:"preprocess",anchor:"transformers.VivitImageProcessor.preprocess",parameters:[{name:"videos",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = None"},{name:"do_center_crop",val:": typing.Optional[bool] = None"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"offset",val:": typing.Optional[bool] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.VivitImageProcessor.preprocess.videos",description:`<strong>videos</strong> (<code>ImageInput</code>) &#x2014;
Video frames to preprocess. Expects a single or batch of video frames with pixel values ranging from 0
to 255. If passing in frames with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"videos"},{anchor:"transformers.VivitImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.VivitImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after applying resize.`,name:"size"},{anchor:"transformers.VivitImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>, Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.VivitImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_centre_crop</code>) &#x2014;
Whether to centre crop the image.`,name:"do_center_crop"},{anchor:"transformers.VivitImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the image after applying the centre crop.`,name:"crop_size"},{anchor:"transformers.VivitImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between <code>[-1 - 1]</code> if <code>offset</code> is <code>True</code>, <code>[0, 1]</code> otherwise.`,name:"do_rescale"},{anchor:"transformers.VivitImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.VivitImageProcessor.preprocess.offset",description:`<strong>offset</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.offset</code>) &#x2014;
Whether to scale the image in both negative and positive directions.`,name:"offset"},{anchor:"transformers.VivitImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.VivitImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.VivitImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.VivitImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.VivitImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the inferred channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.VivitImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vivit/image_processing_vivit.py#L289"}}),me=new z({props:{title:"VivitModel",local:"transformers.VivitModel",headingTag:"h2"}}),he=new _e({props:{name:"class transformers.VivitModel",anchor:"transformers.VivitModel",parameters:[{name:"config",val:""},{name:"add_pooling_layer",val:" = True"}],parametersDescription:[{anchor:"transformers.VivitModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/vivit#transformers.VivitConfig">VivitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vivit/modeling_vivit.py#L529"}}),fe=new _e({props:{name:"forward",anchor:"transformers.VivitModel.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.VivitModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/vivit#transformers.VivitImageProcessor">VivitImageProcessor</a>. See
<a href="/docs/transformers/main/en/model_doc/vivit#transformers.VivitImageProcessor.preprocess">VivitImageProcessor.preprocess()</a> for details.`,name:"pixel_values"},{anchor:"transformers.VivitModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.VivitModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.VivitModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.VivitModel.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.VivitModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vivit/modeling_vivit.py#L561",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/vivit#transformers.VivitConfig"
>VivitConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),N=new jt({props:{$$slots:{default:[Kt]},$$scope:{ctx:v}}}),F=new vt({props:{anchor:"transformers.VivitModel.forward.example",$$slots:{default:[Ot]},$$scope:{ctx:v}}}),ge=new z({props:{title:"VivitForVideoClassification",local:"transformers.VivitForVideoClassification",headingTag:"h2"}}),ue=new _e({props:{name:"class transformers.VivitForVideoClassification",anchor:"transformers.VivitForVideoClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.VivitForVideoClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/vivit#transformers.VivitConfig">VivitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vivit/modeling_vivit.py#L683"}}),E=new jt({props:{$$slots:{default:[es]},$$scope:{ctx:v}}}),Me=new _e({props:{name:"forward",anchor:"transformers.VivitForVideoClassification.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.VivitForVideoClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/vivit#transformers.VivitImageProcessor">VivitImageProcessor</a>. See
<a href="/docs/transformers/main/en/model_doc/vivit#transformers.VivitImageProcessor.preprocess">VivitImageProcessor.preprocess()</a> for details.`,name:"pixel_values"},{anchor:"transformers.VivitForVideoClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.VivitForVideoClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.VivitForVideoClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.VivitForVideoClassification.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.VivitForVideoClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.VivitForVideoClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vivit/modeling_vivit.py#L711",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/vivit#transformers.VivitConfig"
>VivitConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states
(also called feature maps) of the model at the output of each stage.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),X=new jt({props:{$$slots:{default:[ts]},$$scope:{ctx:v}}}),S=new vt({props:{anchor:"transformers.VivitForVideoClassification.forward.example",$$slots:{default:[ss]},$$scope:{ctx:v}}}),ye=new Dt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/vivit.md"}}),{c(){n=d("meta"),_=l(),i=d("p"),p=l(),h(b.$$.fragment),o=l(),w=d("div"),w.innerHTML=Jt,We=l(),h(Q.$$.fragment),Ge=l(),P=d("p"),P.innerHTML=Ut,xe=l(),L=d("p"),L.textContent=It,$e=l(),H=d("p"),H.innerHTML=Ct,ke=l(),D=d("p"),D.innerHTML=Vt,ze=l(),h(q.$$.fragment),Re=l(),K=d("p"),K.innerHTML=Zt,Ae=l(),O=d("p"),O.innerHTML=Bt,Ne=l(),h(ee.$$.fragment),Fe=l(),te=d("p"),te.innerHTML=Wt,Ee=l(),se=d("p"),se.innerHTML=Gt,Xe=l(),h(ne.$$.fragment),Se=l(),ae=d("table"),ae.innerHTML=xt,Ye=l(),h(oe.$$.fragment),Qe=l(),le=d("table"),le.innerHTML=$t,Pe=l(),h(re.$$.fragment),Le=l(),J=d("div"),h(ie.$$.fragment),ot=l(),be=d("p"),be.innerHTML=kt,lt=l(),we=d("p"),we.innerHTML=zt,rt=l(),h(R.$$.fragment),He=l(),h(de.$$.fragment),De=l(),V=d("div"),h(ce.$$.fragment),it=l(),je=d("p"),je.textContent=Rt,dt=l(),A=d("div"),h(pe.$$.fragment),ct=l(),ve=d("p"),ve.textContent=At,qe=l(),h(me.$$.fragment),Ke=l(),Z=d("div"),h(he.$$.fragment),pt=l(),Je=d("p"),Je.innerHTML=Nt,mt=l(),I=d("div"),h(fe.$$.fragment),ht=l(),Ue=d("p"),Ue.innerHTML=Ft,ft=l(),h(N.$$.fragment),gt=l(),h(F.$$.fragment),Oe=l(),h(ge.$$.fragment),et=l(),j=d("div"),h(ue.$$.fragment),ut=l(),Ie=d("p"),Ie.textContent=Et,Mt=l(),h(E.$$.fragment),yt=l(),Ce=d("p"),Ce.innerHTML=Xt,Tt=l(),C=d("div"),h(Me.$$.fragment),_t=l(),Ve=d("p"),Ve.innerHTML=St,bt=l(),h(X.$$.fragment),wt=l(),h(S.$$.fragment),tt=l(),h(ye.$$.fragment),st=l(),Be=d("p"),this.h()},l(e){const t=Ht("svelte-u9bgzb",document.head);n=c(t,"META",{name:!0,content:!0}),t.forEach(s),_=r(e),i=c(e,"P",{}),k(i).forEach(s),p=r(e),f(b.$$.fragment,e),o=r(e),w=c(e,"DIV",{class:!0,"data-svelte-h":!0}),T(w)!=="svelte-b95w5j"&&(w.innerHTML=Jt),We=r(e),f(Q.$$.fragment,e),Ge=r(e),P=c(e,"P",{"data-svelte-h":!0}),T(P)!=="svelte-1dq9qfe"&&(P.innerHTML=Ut),xe=r(e),L=c(e,"P",{"data-svelte-h":!0}),T(L)!=="svelte-vfdo9a"&&(L.textContent=It),$e=r(e),H=c(e,"P",{"data-svelte-h":!0}),T(H)!=="svelte-1lz2sl9"&&(H.innerHTML=Ct),ke=r(e),D=c(e,"P",{"data-svelte-h":!0}),T(D)!=="svelte-jnd3xg"&&(D.innerHTML=Vt),ze=r(e),f(q.$$.fragment,e),Re=r(e),K=c(e,"P",{"data-svelte-h":!0}),T(K)!=="svelte-1cid2pe"&&(K.innerHTML=Zt),Ae=r(e),O=c(e,"P",{"data-svelte-h":!0}),T(O)!=="svelte-1x11lxg"&&(O.innerHTML=Bt),Ne=r(e),f(ee.$$.fragment,e),Fe=r(e),te=c(e,"P",{"data-svelte-h":!0}),T(te)!=="svelte-djb2w0"&&(te.innerHTML=Wt),Ee=r(e),se=c(e,"P",{"data-svelte-h":!0}),T(se)!=="svelte-51m2p5"&&(se.innerHTML=Gt),Xe=r(e),f(ne.$$.fragment,e),Se=r(e),ae=c(e,"TABLE",{"data-svelte-h":!0}),T(ae)!=="svelte-v3fx1h"&&(ae.innerHTML=xt),Ye=r(e),f(oe.$$.fragment,e),Qe=r(e),le=c(e,"TABLE",{"data-svelte-h":!0}),T(le)!=="svelte-1ia57i7"&&(le.innerHTML=$t),Pe=r(e),f(re.$$.fragment,e),Le=r(e),J=c(e,"DIV",{class:!0});var B=k(J);f(ie.$$.fragment,B),ot=r(B),be=c(B,"P",{"data-svelte-h":!0}),T(be)!=="svelte-mpth5h"&&(be.innerHTML=kt),lt=r(B),we=c(B,"P",{"data-svelte-h":!0}),T(we)!=="svelte-o55m63"&&(we.innerHTML=zt),rt=r(B),f(R.$$.fragment,B),B.forEach(s),He=r(e),f(de.$$.fragment,e),De=r(e),V=c(e,"DIV",{class:!0});var x=k(V);f(ce.$$.fragment,x),it=r(x),je=c(x,"P",{"data-svelte-h":!0}),T(je)!=="svelte-imia5q"&&(je.textContent=Rt),dt=r(x),A=c(x,"DIV",{class:!0});var Te=k(A);f(pe.$$.fragment,Te),ct=r(Te),ve=c(Te,"P",{"data-svelte-h":!0}),T(ve)!=="svelte-1x3yxsa"&&(ve.textContent=At),Te.forEach(s),x.forEach(s),qe=r(e),f(me.$$.fragment,e),Ke=r(e),Z=c(e,"DIV",{class:!0});var $=k(Z);f(he.$$.fragment,$),pt=r($),Je=c($,"P",{"data-svelte-h":!0}),T(Je)!=="svelte-6a15m9"&&(Je.innerHTML=Nt),mt=r($),I=c($,"DIV",{class:!0});var W=k(I);f(fe.$$.fragment,W),ht=r(W),Ue=c(W,"P",{"data-svelte-h":!0}),T(Ue)!=="svelte-lvjixl"&&(Ue.innerHTML=Ft),ft=r(W),f(N.$$.fragment,W),gt=r(W),f(F.$$.fragment,W),W.forEach(s),$.forEach(s),Oe=r(e),f(ge.$$.fragment,e),et=r(e),j=c(e,"DIV",{class:!0});var U=k(j);f(ue.$$.fragment,U),ut=r(U),Ie=c(U,"P",{"data-svelte-h":!0}),T(Ie)!=="svelte-1vvfjf6"&&(Ie.textContent=Et),Mt=r(U),f(E.$$.fragment,U),yt=r(U),Ce=c(U,"P",{"data-svelte-h":!0}),T(Ce)!=="svelte-1gjh92c"&&(Ce.innerHTML=Xt),Tt=r(U),C=c(U,"DIV",{class:!0});var Y=k(C);f(Me.$$.fragment,Y),_t=r(Y),Ve=c(Y,"P",{"data-svelte-h":!0}),T(Ve)!=="svelte-gnp77j"&&(Ve.innerHTML=St),bt=r(Y),f(X.$$.fragment,Y),wt=r(Y),f(S.$$.fragment,Y),Y.forEach(s),U.forEach(s),tt=r(e),f(ye.$$.fragment,e),st=r(e),Be=c(e,"P",{}),k(Be).forEach(s),this.h()},h(){G(n,"name","hf:doc:metadata"),G(n,"content",as),G(w,"class","flex flex-wrap space-x-1"),G(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),G(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){m(document.head,n),a(e,_,t),a(e,i,t),a(e,p,t),g(b,e,t),a(e,o,t),a(e,w,t),a(e,We,t),g(Q,e,t),a(e,Ge,t),a(e,P,t),a(e,xe,t),a(e,L,t),a(e,$e,t),a(e,H,t),a(e,ke,t),a(e,D,t),a(e,ze,t),g(q,e,t),a(e,Re,t),a(e,K,t),a(e,Ae,t),a(e,O,t),a(e,Ne,t),g(ee,e,t),a(e,Fe,t),a(e,te,t),a(e,Ee,t),a(e,se,t),a(e,Xe,t),g(ne,e,t),a(e,Se,t),a(e,ae,t),a(e,Ye,t),g(oe,e,t),a(e,Qe,t),a(e,le,t),a(e,Pe,t),g(re,e,t),a(e,Le,t),a(e,J,t),g(ie,J,null),m(J,ot),m(J,be),m(J,lt),m(J,we),m(J,rt),g(R,J,null),a(e,He,t),g(de,e,t),a(e,De,t),a(e,V,t),g(ce,V,null),m(V,it),m(V,je),m(V,dt),m(V,A),g(pe,A,null),m(A,ct),m(A,ve),a(e,qe,t),g(me,e,t),a(e,Ke,t),a(e,Z,t),g(he,Z,null),m(Z,pt),m(Z,Je),m(Z,mt),m(Z,I),g(fe,I,null),m(I,ht),m(I,Ue),m(I,ft),g(N,I,null),m(I,gt),g(F,I,null),a(e,Oe,t),g(ge,e,t),a(e,et,t),a(e,j,t),g(ue,j,null),m(j,ut),m(j,Ie),m(j,Mt),g(E,j,null),m(j,yt),m(j,Ce),m(j,Tt),m(j,C),g(Me,C,null),m(C,_t),m(C,Ve),m(C,bt),g(X,C,null),m(C,wt),g(S,C,null),a(e,tt,t),g(ye,e,t),a(e,st,t),a(e,Be,t),nt=!0},p(e,[t]){const B={};t&2&&(B.$$scope={dirty:t,ctx:e}),R.$set(B);const x={};t&2&&(x.$$scope={dirty:t,ctx:e}),N.$set(x);const Te={};t&2&&(Te.$$scope={dirty:t,ctx:e}),F.$set(Te);const $={};t&2&&($.$$scope={dirty:t,ctx:e}),E.$set($);const W={};t&2&&(W.$$scope={dirty:t,ctx:e}),X.$set(W);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),S.$set(U)},i(e){nt||(u(b.$$.fragment,e),u(Q.$$.fragment,e),u(q.$$.fragment,e),u(ee.$$.fragment,e),u(ne.$$.fragment,e),u(oe.$$.fragment,e),u(re.$$.fragment,e),u(ie.$$.fragment,e),u(R.$$.fragment,e),u(de.$$.fragment,e),u(ce.$$.fragment,e),u(pe.$$.fragment,e),u(me.$$.fragment,e),u(he.$$.fragment,e),u(fe.$$.fragment,e),u(N.$$.fragment,e),u(F.$$.fragment,e),u(ge.$$.fragment,e),u(ue.$$.fragment,e),u(E.$$.fragment,e),u(Me.$$.fragment,e),u(X.$$.fragment,e),u(S.$$.fragment,e),u(ye.$$.fragment,e),nt=!0)},o(e){M(b.$$.fragment,e),M(Q.$$.fragment,e),M(q.$$.fragment,e),M(ee.$$.fragment,e),M(ne.$$.fragment,e),M(oe.$$.fragment,e),M(re.$$.fragment,e),M(ie.$$.fragment,e),M(R.$$.fragment,e),M(de.$$.fragment,e),M(ce.$$.fragment,e),M(pe.$$.fragment,e),M(me.$$.fragment,e),M(he.$$.fragment,e),M(fe.$$.fragment,e),M(N.$$.fragment,e),M(F.$$.fragment,e),M(ge.$$.fragment,e),M(ue.$$.fragment,e),M(E.$$.fragment,e),M(Me.$$.fragment,e),M(X.$$.fragment,e),M(S.$$.fragment,e),M(ye.$$.fragment,e),nt=!1},d(e){e&&(s(_),s(i),s(p),s(o),s(w),s(We),s(Ge),s(P),s(xe),s(L),s($e),s(H),s(ke),s(D),s(ze),s(Re),s(K),s(Ae),s(O),s(Ne),s(Fe),s(te),s(Ee),s(se),s(Xe),s(Se),s(ae),s(Ye),s(Qe),s(le),s(Pe),s(Le),s(J),s(He),s(De),s(V),s(qe),s(Ke),s(Z),s(Oe),s(et),s(j),s(tt),s(st),s(Be)),s(n),y(b,e),y(Q,e),y(q,e),y(ee,e),y(ne,e),y(oe,e),y(re,e),y(ie),y(R),y(de,e),y(ce),y(pe),y(me,e),y(he),y(fe),y(N),y(F),y(ge,e),y(ue),y(E),y(Me),y(X),y(S),y(ye,e)}}}const as='{"title":"Video Vision Transformer (ViViT)","local":"video-vision-transformer-vivit","sections":[{"title":"Overview","local":"overview","sections":[{"title":"Using Scaled Dot Product Attention (SDPA)","local":"using-scaled-dot-product-attention-sdpa","sections":[],"depth":3},{"title":"Training","local":"training","sections":[],"depth":3},{"title":"Inference","local":"inference","sections":[],"depth":3}],"depth":2},{"title":"VivitConfig","local":"transformers.VivitConfig","sections":[],"depth":2},{"title":"VivitImageProcessor","local":"transformers.VivitImageProcessor","sections":[],"depth":2},{"title":"VivitModel","local":"transformers.VivitModel","sections":[],"depth":2},{"title":"VivitForVideoClassification","local":"transformers.VivitForVideoClassification","sections":[],"depth":2}],"depth":1}';function os(v){return Qt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fs extends Pt{constructor(n){super(),Lt(this,n,os,ns,Yt,{})}}export{fs as component};
