import{s as is,n as rs,o as ps}from"../chunks/scheduler.18a86fab.js";import{S as os,i as ws,g as i,s as l,r as o,A as cs,h as r,f as t,c as a,j as ls,u as w,x as p,k as as,y as ys,a as n,v as c,d as y,t as J,w as M}from"../chunks/index.98837b22.js";import{C as D}from"../chunks/CodeBlock.8d0c2e8a.js";import{H as L}from"../chunks/Heading.7e7e0c5b.js";import{E as Js}from"../chunks/index.f01015d9.js";function Ms(He){let T,ee,K,se,u,te,h,Ge='A web server is a system that waits for requests and serves them as they come in. This means you can use <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a> as an inference engine on a web server, since you can use an iterator (similar to how you would <a href="./pipeline_tutorial#large-datasets">iterate over a dataset</a>) to handle each incoming request.',ne,m,Xe='Designing a web server with <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a> is unique though because they’re fundamentally different. Web servers are multiplexed (multithreaded, async, etc.) to handle multiple requests concurrently. <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a> and its underlying model on the other hand are not designed for parallelism because they take a lot of memory. It’s best to give a <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a> all the available resources when they’re running or for a compute intensive job.',le,U,ze='This guide shows how to work around this difference by using a web server to handle the lighter load of receiving and sending requests, and having a single thread to handle the heavier load of running <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a>.',ae,d,ie,f,Ee='<a href="https://www.starlette.io/" rel="nofollow">Starlette</a> is a lightweight framework for building web servers. You can use any other framework you’d like, but you may have to make some changes to the code below.',re,I,_e='Before you begin, make sure Starlette and <a href="http://www.uvicorn.org/" rel="nofollow">uvicorn</a> are installed.',pe,j,oe,C,Ve="Now you can create a simple web server in a <code>server.py</code> file. The key is to only load the model <strong>once</strong> to prevent unnecessary copies of it from consuming memory.",we,b,We="Create a pipeline to fill in the masked token, <code>[MASK]</code>.",ce,g,ye,B,Ye="Start the server with the following command.",Je,v,Me,x,Re="Query the server with a POST request.",Te,k,ue,$,Ae="This should return the output below.",he,Q,me,S,Ue,N,Pe='The server’s queuing mechanism can be used for some interesting applications such as dynamic batching. Dynamic batching accumulates several requests first before processing them with <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a>.',de,Z,Fe="The example below is written in pseudocode for readability rather than performance, in particular, you’ll notice that:",fe,q,Le="<li><p>There is no batch size limit.</p></li> <li><p>The timeout is reset on every queue fetch, so you could end up waiting much longer than the <code>timeout</code> value before processing a request. This would also delay the first inference request by that amount of time. The web server always waits 1ms even if the queue is empty, which is inefficient, because that time can be used to start inference. It could make sense though if batching is essential to your use case.</p> <p>It would be better to have a single 1ms deadline, instead of resetting it on every fetch, as shown below.</p></li>",Ie,H,je,G,Ce,X,De="There are many things that can go wrong in production. You could run out-of-memory, out of space, fail to load a model, have an incorrect model configuration, have an incorrect query, and so much more.",be,z,Ke="Adding <code>try...except</code> statements is helpful for returning these errors to the user for debugging. Keep in mind this could be a security risk if you shouldn’t be revealing certain information.",ge,E,Be,_,Oe="Try to return a 503 or 504 error when the server is overloaded instead of forcing a user to wait indefinitely.",ve,V,es="It is relatively simple to implement these error types since it’s only a single queue. Take a look at the queue size to determine when to start returning errors before your server fails under load.",xe,W,ke,Y,ss="PyTorch is not async aware, so computation will block the main thread from running.",$e,R,ts="For this reason, it’s better to run PyTorch on its own separate thread or process. When inference of a single request is especially long (more than 1s), it’s even more important because it means every query during inference must wait 1s before even receiving an error.",Qe,A,Se,P,ns='Dynamic batching can be very effective when used in the correct setting, but it’s not necessary when you’re only passing 1 request at a time (see <a href="./pipeline_tutorial#batch-inference">batch inference</a> for more details).',Ne,F,Ze,O,qe;return u=new L({props:{title:"Web server inference",local:"web-server-inference",headingTag:"h1"}}),d=new L({props:{title:"Create a server",local:"create-a-server",headingTag:"h2"}}),j=new D({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzdGFybGV0dGUlMjB1dmljb3Ju",highlighted:"!pip install starlette uvicorn",wrap:!1}}),g=new D({props:{code:"ZnJvbSUyMHN0YXJsZXR0ZS5hcHBsaWNhdGlvbnMlMjBpbXBvcnQlMjBTdGFybGV0dGUlMEFmcm9tJTIwc3RhcmxldHRlLnJlc3BvbnNlcyUyMGltcG9ydCUyMEpTT05SZXNwb25zZSUwQWZyb20lMjBzdGFybGV0dGUucm91dGluZyUyMGltcG9ydCUyMFJvdXRlJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwYXN5bmNpbyUwQSUwQWFzeW5jJTIwZGVmJTIwaG9tZXBhZ2UocmVxdWVzdCklM0ElMEElMjAlMjAlMjAlMjBwYXlsb2FkJTIwJTNEJTIwYXdhaXQlMjByZXF1ZXN0LmJvZHkoKSUwQSUyMCUyMCUyMCUyMHN0cmluZyUyMCUzRCUyMHBheWxvYWQuZGVjb2RlKCUyMnV0Zi04JTIyKSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlX3ElMjAlM0QlMjBhc3luY2lvLlF1ZXVlKCklMEElMjAlMjAlMjAlMjBhd2FpdCUyMHJlcXVlc3QuYXBwLm1vZGVsX3F1ZXVlLnB1dCgoc3RyaW5nJTJDJTIwcmVzcG9uc2VfcSkpJTBBJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjByZXNwb25zZV9xLmdldCgpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwSlNPTlJlc3BvbnNlKG91dHB1dCklMEElMEFhc3luYyUyMGRlZiUyMHNlcnZlcl9sb29wKHEpJTNBJTBBJTIwJTIwJTIwJTIwcGlwZSUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJmaWxsLW1hc2slMjIlMkNtb2RlbCUzRCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBJTIwJTIwJTIwJTIwd2hpbGUlMjBUcnVlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKHN0cmluZyUyQyUyMHJlc3BvbnNlX3EpJTIwJTNEJTIwYXdhaXQlMjBxLmdldCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwcGlwZShzdHJpbmcpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXdhaXQlMjByZXNwb25zZV9xLnB1dChvdXQpJTBBJTBBYXBwJTIwJTNEJTIwU3RhcmxldHRlKCUwQSUyMCUyMCUyMCUyMHJvdXRlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFJvdXRlKCUyMiUyRiUyMiUyQyUyMGhvbWVwYWdlJTJDJTIwbWV0aG9kcyUzRCU1QiUyMlBPU1QlMjIlNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBKSUwQSUwQSU0MGFwcC5vbl9ldmVudCglMjJzdGFydHVwJTIyKSUwQWFzeW5jJTIwZGVmJTIwc3RhcnR1cF9ldmVudCgpJTNBJTBBJTIwJTIwJTIwJTIwcSUyMCUzRCUyMGFzeW5jaW8uUXVldWUoKSUwQSUyMCUyMCUyMCUyMGFwcC5tb2RlbF9xdWV1ZSUyMCUzRCUyMHElMEElMjAlMjAlMjAlMjBhc3luY2lvLmNyZWF0ZV90YXNrKHNlcnZlcl9sb29wKHEpKQ==",highlighted:`<span class="hljs-keyword">from</span> starlette.applications <span class="hljs-keyword">import</span> Starlette
<span class="hljs-keyword">from</span> starlette.responses <span class="hljs-keyword">import</span> JSONResponse
<span class="hljs-keyword">from</span> starlette.routing <span class="hljs-keyword">import</span> Route
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> asyncio

<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">homepage</span>(<span class="hljs-params">request</span>):
    payload = <span class="hljs-keyword">await</span> request.body()
    string = payload.decode(<span class="hljs-string">&quot;utf-8&quot;</span>)
    response_q = asyncio.Queue()
    <span class="hljs-keyword">await</span> request.app.model_queue.put((string, response_q))
    output = <span class="hljs-keyword">await</span> response_q.get()
    <span class="hljs-keyword">return</span> JSONResponse(output)

<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">server_loop</span>(<span class="hljs-params">q</span>):
    pipe = pipeline(task=<span class="hljs-string">&quot;fill-mask&quot;</span>,model=<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)
    <span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
        (string, response_q) = <span class="hljs-keyword">await</span> q.get()
        out = pipe(string)
        <span class="hljs-keyword">await</span> response_q.put(out)

app = Starlette(
    routes=[
        Route(<span class="hljs-string">&quot;/&quot;</span>, homepage, methods=[<span class="hljs-string">&quot;POST&quot;</span>]),
    ],
)

<span class="hljs-meta">@app.on_event(<span class="hljs-params"><span class="hljs-string">&quot;startup&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">startup_event</span>():
    q = asyncio.Queue()
    app.model_queue = q
    asyncio.create_task(server_loop(q))`,wrap:!1}}),v=new D({props:{code:"dXZpY29ybiUyMHNlcnZlciUzQWFwcA==",highlighted:"uvicorn server:app",wrap:!1}}),k=new D({props:{code:"Y3VybCUyMC1YJTIwUE9TVCUyMC1kJTIwJTIyUGFyaXMlMjBpcyUyMHRoZSUyMCU1Qk1BU0slNUQlMjBvZiUyMEZyYW5jZS4lMjIlMjBodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBODAwMCUyRg==",highlighted:'curl -X POST -d <span class="hljs-string">&quot;Paris is the [MASK] of France.&quot;</span> http://localhost:8000/',wrap:!1}}),Q=new D({props:{code:"JTVCJTdCJ3Njb3JlJyUzQSUyMDAuOTk2OTMzMjIxODE3MDE2NiUyQyUwQSUyMCUyMCd0b2tlbiclM0ElMjAzMDA3JTJDJTBBJTIwJTIwJ3Rva2VuX3N0ciclM0ElMjAnY2FwaXRhbCclMkMlMEElMjAlMjAnc2VxdWVuY2UnJTNBJTIwJ3BhcmlzJTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBmcmFuY2UuJyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjAwLjAwMDU5MTQ4NDk0NjE5ODc2MTUlMkMlMEElMjAlMjAndG9rZW4nJTNBJTIwMjU0MCUyQyUwQSUyMCUyMCd0b2tlbl9zdHInJTNBJTIwJ2hlYXJ0JyUyQyUwQSUyMCUyMCdzZXF1ZW5jZSclM0ElMjAncGFyaXMlMjBpcyUyMHRoZSUyMGhlYXJ0JTIwb2YlMjBmcmFuY2UuJyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjAwLjAwMDQzNzg3MzE4MjgxODI5MzU3JTJDJTBBJTIwJTIwJ3Rva2VuJyUzQSUyMDI0MTUlMkMlMEElMjAlMjAndG9rZW5fc3RyJyUzQSUyMCdjZW50ZXInJTJDJTBBJTIwJTIwJ3NlcXVlbmNlJyUzQSUyMCdwYXJpcyUyMGlzJTIwdGhlJTIwY2VudGVyJTIwb2YlMjBmcmFuY2UuJyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjAwLjAwMDMzNzgzNDAwNDMxMjc1MzclMkMlMEElMjAlMjAndG9rZW4nJTNBJTIwMjgwMyUyQyUwQSUyMCUyMCd0b2tlbl9zdHInJTNBJTIwJ2NlbnRyZSclMkMlMEElMjAlMjAnc2VxdWVuY2UnJTNBJTIwJ3BhcmlzJTIwaXMlMjB0aGUlMjBjZW50cmUlMjBvZiUyMGZyYW5jZS4nJTdEJTJDJTBBJTIwJTdCJ3Njb3JlJyUzQSUyMDAuMDAwMjY5OTU5MTI3NzYzMjg2MjMlMkMlMEElMjAlMjAndG9rZW4nJTNBJTIwMjEwMyUyQyUwQSUyMCUyMCd0b2tlbl9zdHInJTNBJTIwJ2NpdHknJTJDJTBBJTIwJTIwJ3NlcXVlbmNlJyUzQSUyMCdwYXJpcyUyMGlzJTIwdGhlJTIwY2l0eSUyMG9mJTIwZnJhbmNlLiclN0QlNUQ=",highlighted:`[{<span class="hljs-string">&#x27;score&#x27;</span>: 0.9969332218170166,
  <span class="hljs-string">&#x27;token&#x27;</span>: 3007,
  <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;capital&#x27;</span>,
  <span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;paris is the capital of france.&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: 0.0005914849461987615,
  <span class="hljs-string">&#x27;token&#x27;</span>: 2540,
  <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;heart&#x27;</span>,
  <span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;paris is the heart of france.&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: 0.00043787318281829357,
  <span class="hljs-string">&#x27;token&#x27;</span>: 2415,
  <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;center&#x27;</span>,
  <span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;paris is the center of france.&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: 0.0003378340043127537,
  <span class="hljs-string">&#x27;token&#x27;</span>: 2803,
  <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;centre&#x27;</span>,
  <span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;paris is the centre of france.&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: 0.00026995912776328623,
  <span class="hljs-string">&#x27;token&#x27;</span>: 2103,
  <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;city&#x27;</span>,
  <span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;paris is the city of france.&#x27;</span>}]`,wrap:!1}}),S=new L({props:{title:"Queuing requests",local:"queuing-requests",headingTag:"h2"}}),H=new D({props:{code:"YXN5bmMlMjBkZWYlMjBzZXJ2ZXJfbG9vcChxKSUzQSUwQSUyMCUyMCUyMCUyMHBpcGUlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyZmlsbC1tYXNrJTIyJTJDJTIwbW9kZWwlM0QlMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS11bmNhc2VkJTIyKSUwQSUyMCUyMCUyMCUyMHdoaWxlJTIwVHJ1ZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMChzdHJpbmclMkMlMjBycSklMjAlM0QlMjBhd2FpdCUyMHEuZ2V0KCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdHJpbmdzJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcXVldWVzJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RyaW5ncy5hcHBlbmQoc3RyaW5nKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHF1ZXVlcy5hcHBlbmQocnEpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2hpbGUlMjBUcnVlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJ5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKHN0cmluZyUyQyUyMHJxKSUyMCUzRCUyMGF3YWl0JTIwYXN5bmNpby53YWl0X2ZvcihxLmdldCgpJTJDJTIwdGltZW91dCUzRDEpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXhjZXB0JTIwYXN5bmNpby5leGNlcHRpb25zLlRpbWVvdXRFcnJvciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RyaW5ncy5hcHBlbmQoc3RyaW5nKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHF1ZXVlcy5hcHBlbmQocnEpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cyUyMCUzRCUyMHBpcGUoc3RyaW5ncyUyQyUyMGJhdGNoX3NpemUlM0RsZW4oc3RyaW5ncykpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwcnElMkMlMjBvdXQlMjBpbiUyMHppcChxdWV1ZXMlMkMlMjBvdXRzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF3YWl0JTIwcnEucHV0KG91dCk=",highlighted:`<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">server_loop</span>(<span class="hljs-params">q</span>):
    pipe = pipeline(task=<span class="hljs-string">&quot;fill-mask&quot;</span>, model=<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)
    <span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
        (string, rq) = <span class="hljs-keyword">await</span> q.get()
        strings = []
        queues = []
        strings.append(string)
        queues.append(rq)
        <span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
            <span class="hljs-keyword">try</span>:
                (string, rq) = <span class="hljs-keyword">await</span> asyncio.wait_for(q.get(), timeout=<span class="hljs-number">1</span>)
            <span class="hljs-keyword">except</span> asyncio.exceptions.TimeoutError:
                <span class="hljs-keyword">break</span>
            strings.append(string)
            queues.append(rq)
        outs = pipe(strings, batch_size=<span class="hljs-built_in">len</span>(strings))
        <span class="hljs-keyword">for</span> rq, out <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(queues, outs):
            <span class="hljs-keyword">await</span> rq.put(out)`,wrap:!1}}),G=new L({props:{title:"Error checking",local:"error-checking",headingTag:"h2"}}),E=new L({props:{title:"Circuit breaking",local:"circuit-breaking",headingTag:"h2"}}),W=new L({props:{title:"Block the main thread",local:"block-the-main-thread",headingTag:"h2"}}),A=new L({props:{title:"Dynamic batching",local:"dynamic-batching",headingTag:"h2"}}),F=new Js({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/pipeline_webserver.md"}}),{c(){T=i("meta"),ee=l(),K=i("p"),se=l(),o(u.$$.fragment),te=l(),h=i("p"),h.innerHTML=Ge,ne=l(),m=i("p"),m.innerHTML=Xe,le=l(),U=i("p"),U.innerHTML=ze,ae=l(),o(d.$$.fragment),ie=l(),f=i("p"),f.innerHTML=Ee,re=l(),I=i("p"),I.innerHTML=_e,pe=l(),o(j.$$.fragment),oe=l(),C=i("p"),C.innerHTML=Ve,we=l(),b=i("p"),b.innerHTML=We,ce=l(),o(g.$$.fragment),ye=l(),B=i("p"),B.textContent=Ye,Je=l(),o(v.$$.fragment),Me=l(),x=i("p"),x.textContent=Re,Te=l(),o(k.$$.fragment),ue=l(),$=i("p"),$.textContent=Ae,he=l(),o(Q.$$.fragment),me=l(),o(S.$$.fragment),Ue=l(),N=i("p"),N.innerHTML=Pe,de=l(),Z=i("p"),Z.textContent=Fe,fe=l(),q=i("ol"),q.innerHTML=Le,Ie=l(),o(H.$$.fragment),je=l(),o(G.$$.fragment),Ce=l(),X=i("p"),X.textContent=De,be=l(),z=i("p"),z.innerHTML=Ke,ge=l(),o(E.$$.fragment),Be=l(),_=i("p"),_.textContent=Oe,ve=l(),V=i("p"),V.textContent=es,xe=l(),o(W.$$.fragment),ke=l(),Y=i("p"),Y.textContent=ss,$e=l(),R=i("p"),R.textContent=ts,Qe=l(),o(A.$$.fragment),Se=l(),P=i("p"),P.innerHTML=ns,Ne=l(),o(F.$$.fragment),Ze=l(),O=i("p"),this.h()},l(e){const s=cs("svelte-u9bgzb",document.head);T=r(s,"META",{name:!0,content:!0}),s.forEach(t),ee=a(e),K=r(e,"P",{}),ls(K).forEach(t),se=a(e),w(u.$$.fragment,e),te=a(e),h=r(e,"P",{"data-svelte-h":!0}),p(h)!=="svelte-1q9kufa"&&(h.innerHTML=Ge),ne=a(e),m=r(e,"P",{"data-svelte-h":!0}),p(m)!=="svelte-1bi3g9p"&&(m.innerHTML=Xe),le=a(e),U=r(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-11ey1v3"&&(U.innerHTML=ze),ae=a(e),w(d.$$.fragment,e),ie=a(e),f=r(e,"P",{"data-svelte-h":!0}),p(f)!=="svelte-75xf7k"&&(f.innerHTML=Ee),re=a(e),I=r(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-vc63tw"&&(I.innerHTML=_e),pe=a(e),w(j.$$.fragment,e),oe=a(e),C=r(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-hg1gr3"&&(C.innerHTML=Ve),we=a(e),b=r(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-1rmfx7s"&&(b.innerHTML=We),ce=a(e),w(g.$$.fragment,e),ye=a(e),B=r(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-khywk9"&&(B.textContent=Ye),Je=a(e),w(v.$$.fragment,e),Me=a(e),x=r(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-wy3f7i"&&(x.textContent=Re),Te=a(e),w(k.$$.fragment,e),ue=a(e),$=r(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-xfbaai"&&($.textContent=Ae),he=a(e),w(Q.$$.fragment,e),me=a(e),w(S.$$.fragment,e),Ue=a(e),N=r(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-i2rj31"&&(N.innerHTML=Pe),de=a(e),Z=r(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-o8k0wa"&&(Z.textContent=Fe),fe=a(e),q=r(e,"OL",{"data-svelte-h":!0}),p(q)!=="svelte-191ula1"&&(q.innerHTML=Le),Ie=a(e),w(H.$$.fragment,e),je=a(e),w(G.$$.fragment,e),Ce=a(e),X=r(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-np02fr"&&(X.textContent=De),be=a(e),z=r(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-18bu5an"&&(z.innerHTML=Ke),ge=a(e),w(E.$$.fragment,e),Be=a(e),_=r(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-q5t78j"&&(_.textContent=Oe),ve=a(e),V=r(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-b9g89k"&&(V.textContent=es),xe=a(e),w(W.$$.fragment,e),ke=a(e),Y=r(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-vk268r"&&(Y.textContent=ss),$e=a(e),R=r(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1am6qf5"&&(R.textContent=ts),Qe=a(e),w(A.$$.fragment,e),Se=a(e),P=r(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-19c4yu0"&&(P.innerHTML=ns),Ne=a(e),w(F.$$.fragment,e),Ze=a(e),O=r(e,"P",{}),ls(O).forEach(t),this.h()},h(){as(T,"name","hf:doc:metadata"),as(T,"content",Ts)},m(e,s){ys(document.head,T),n(e,ee,s),n(e,K,s),n(e,se,s),c(u,e,s),n(e,te,s),n(e,h,s),n(e,ne,s),n(e,m,s),n(e,le,s),n(e,U,s),n(e,ae,s),c(d,e,s),n(e,ie,s),n(e,f,s),n(e,re,s),n(e,I,s),n(e,pe,s),c(j,e,s),n(e,oe,s),n(e,C,s),n(e,we,s),n(e,b,s),n(e,ce,s),c(g,e,s),n(e,ye,s),n(e,B,s),n(e,Je,s),c(v,e,s),n(e,Me,s),n(e,x,s),n(e,Te,s),c(k,e,s),n(e,ue,s),n(e,$,s),n(e,he,s),c(Q,e,s),n(e,me,s),c(S,e,s),n(e,Ue,s),n(e,N,s),n(e,de,s),n(e,Z,s),n(e,fe,s),n(e,q,s),n(e,Ie,s),c(H,e,s),n(e,je,s),c(G,e,s),n(e,Ce,s),n(e,X,s),n(e,be,s),n(e,z,s),n(e,ge,s),c(E,e,s),n(e,Be,s),n(e,_,s),n(e,ve,s),n(e,V,s),n(e,xe,s),c(W,e,s),n(e,ke,s),n(e,Y,s),n(e,$e,s),n(e,R,s),n(e,Qe,s),c(A,e,s),n(e,Se,s),n(e,P,s),n(e,Ne,s),c(F,e,s),n(e,Ze,s),n(e,O,s),qe=!0},p:rs,i(e){qe||(y(u.$$.fragment,e),y(d.$$.fragment,e),y(j.$$.fragment,e),y(g.$$.fragment,e),y(v.$$.fragment,e),y(k.$$.fragment,e),y(Q.$$.fragment,e),y(S.$$.fragment,e),y(H.$$.fragment,e),y(G.$$.fragment,e),y(E.$$.fragment,e),y(W.$$.fragment,e),y(A.$$.fragment,e),y(F.$$.fragment,e),qe=!0)},o(e){J(u.$$.fragment,e),J(d.$$.fragment,e),J(j.$$.fragment,e),J(g.$$.fragment,e),J(v.$$.fragment,e),J(k.$$.fragment,e),J(Q.$$.fragment,e),J(S.$$.fragment,e),J(H.$$.fragment,e),J(G.$$.fragment,e),J(E.$$.fragment,e),J(W.$$.fragment,e),J(A.$$.fragment,e),J(F.$$.fragment,e),qe=!1},d(e){e&&(t(ee),t(K),t(se),t(te),t(h),t(ne),t(m),t(le),t(U),t(ae),t(ie),t(f),t(re),t(I),t(pe),t(oe),t(C),t(we),t(b),t(ce),t(ye),t(B),t(Je),t(Me),t(x),t(Te),t(ue),t($),t(he),t(me),t(Ue),t(N),t(de),t(Z),t(fe),t(q),t(Ie),t(je),t(Ce),t(X),t(be),t(z),t(ge),t(Be),t(_),t(ve),t(V),t(xe),t(ke),t(Y),t($e),t(R),t(Qe),t(Se),t(P),t(Ne),t(Ze),t(O)),t(T),M(u,e),M(d,e),M(j,e),M(g,e),M(v,e),M(k,e),M(Q,e),M(S,e),M(H,e),M(G,e),M(E,e),M(W,e),M(A,e),M(F,e)}}}const Ts='{"title":"Web server inference","local":"web-server-inference","sections":[{"title":"Create a server","local":"create-a-server","sections":[],"depth":2},{"title":"Queuing requests","local":"queuing-requests","sections":[],"depth":2},{"title":"Error checking","local":"error-checking","sections":[],"depth":2},{"title":"Circuit breaking","local":"circuit-breaking","sections":[],"depth":2},{"title":"Block the main thread","local":"block-the-main-thread","sections":[],"depth":2},{"title":"Dynamic batching","local":"dynamic-batching","sections":[],"depth":2}],"depth":1}';function us(He){return ps(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Is extends os{constructor(T){super(),ws(this,T,us,Ms,is,{})}}export{Is as component};
