import{s as Fe,n as Le,o as qe}from"../chunks/scheduler.18a86fab.js";import{S as Ae,i as Pe,g as i,s as a,r as p,A as De,h as o,f as s,c as n,j as Ye,u as m,x as d,k as ze,y as Ke,a as l,v as r,d as c,t as u,w as f}from"../chunks/index.98837b22.js";import{C as h}from"../chunks/CodeBlock.8d0c2e8a.js";import{D as Oe}from"../chunks/DocNotebookDropdown.a04a6b2a.js";import{H as ke}from"../chunks/Heading.7e7e0c5b.js";import{E as et}from"../chunks/index.f01015d9.js";function tt(We){let g,A,L,P,y,D,b,K,J,ve="Image feature extraction is the task of extracting semantically meaningful features given an image. This has many use cases, including image similarity and image retrieval. Moreover, most computer vision models can be used for image feature extraction, where one can remove the task-specific head (image classification, object detection etc) and get the features. These features are very useful on a higher level: edge detection, corner detection and so on. They may also contain information about the real world (e.g. what a cat looks like) depending on how deep the model is. Therefore, these outputs can be used to train new classifiers on a specific dataset.",O,w,_e="In this guide, you will:",ee,M,Ce="<li>Learn to build a simple image similarity system on top of the <code>image-feature-extraction</code> pipeline.</li> <li>Accomplish the same task with bare model inference.</li>",te,T,se,U,Ve="We have two images of cats sitting on top of fish nets, one of them is generated.",le,j,ae,$,xe='Let’s see the pipeline in action. First, initialize the pipeline. If you don’t pass any model to it, the pipeline will be automatically initialized with <a href="google/vit-base-patch16-224">google/vit-base-patch16-224</a>. If you’d like to calculate similarity, set <code>pool</code> to True.',ne,I,ie,Z,Be="To infer with <code>pipe</code> pass both images to it.",oe,k,pe,W,Re="The output contains pooled embeddings of those two images.",me,v,re,_,Ge="To get the similarity score, we need to pass them to a similarity function.",ce,C,ue,V,Qe="If you want to get the last hidden states before pooling, avoid passing any value for the <code>pool</code> parameter, as it is set to <code>False</code> by default. These hidden states are useful for training new classifiers or models based on the features from the model.",fe,x,de,B,He="Since the outputs are unpooled, we get the last hidden states where the first dimension is the batch size, and the last two are the embedding shape.",he,R,ge,G,ye,Q,Ne="We can also use <code>AutoModel</code> class of transformers to get the features. <code>AutoModel</code> loads any transformers model with no task-specific head, and we can use this to get the features.",be,H,Je,N,Ee="Let’s write a simple function for inference. We will pass the inputs to the <code>processor</code> first and pass its outputs to the <code>model</code>.",we,E,Me,S,Se="We can pass the images directly to this function and get the embeddings.",Te,X,Ue,Y,Xe="We can get the similarity again over the embeddings.",je,z,$e,F,Ie,q,Ze;return y=new ke({props:{title:"Image Feature Extraction",local:"image-feature-extraction",headingTag:"h1"}}),b=new Oe({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/image_feature_extraction.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/image_feature_extraction.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/image_feature_extraction.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/image_feature_extraction.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/image_feature_extraction.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/image_feature_extraction.ipynb"}]}}),T=new ke({props:{title:"Image Similarity using image-feature-extraction Pipeline",local:"image-similarity-using-image-feature-extraction-pipeline",headingTag:"h2"}}),j=new h({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEFpbWdfdXJscyUyMCUzRCUyMCU1QiUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmNhdHMucG5nJTIyJTJDJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGY2F0cy5qcGVnJTIyJTVEJTBBaW1hZ2VfcmVhbCUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KGltZ191cmxzJTVCMCU1RCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdykuY29udmVydCglMjJSR0IlMjIpJTBBaW1hZ2VfZ2VuJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQoaW1nX3VybHMlNUIxJTVEJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KS5jb252ZXJ0KCUyMlJHQiUyMik=",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

img_urls = [<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/cats.png&quot;</span>, <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/cats.jpeg&quot;</span>]
image_real = Image.<span class="hljs-built_in">open</span>(requests.get(img_urls[<span class="hljs-number">0</span>], stream=<span class="hljs-literal">True</span>).raw).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
image_gen = Image.<span class="hljs-built_in">open</span>(requests.get(img_urls[<span class="hljs-number">1</span>], stream=<span class="hljs-literal">True</span>).raw).convert(<span class="hljs-string">&quot;RGB&quot;</span>)`,wrap:!1}}),I=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEFmcm9tJTIwYWNjZWxlcmF0ZS50ZXN0X3V0aWxzLnRlc3RpbmclMjBpbXBvcnQlMjBnZXRfYmFja2VuZCUwQSUyMyUyMGF1dG9tYXRpY2FsbHklMjBkZXRlY3RzJTIwdGhlJTIwdW5kZXJseWluZyUyMGRldmljZSUyMHR5cGUlMjAoQ1VEQSUyQyUyMENQVSUyQyUyMFhQVSUyQyUyME1QUyUyQyUyMGV0Yy4pJTBBREVWSUNFJTJDJTIwXyUyQyUyMF8lMjAlM0QlMjBnZXRfYmFja2VuZCgpJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJpbWFnZS1mZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMjBtb2RlbF9uYW1lJTNEJTIyZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0zODQlMjIlMkMlMjBkZXZpY2UlM0RERVZJQ0UlMkMlMjBwb29sJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> accelerate.test_utils.testing <span class="hljs-keyword">import</span> get_backend
<span class="hljs-comment"># automatically detects the underlying device type (CUDA, CPU, XPU, MPS, etc.)</span>
DEVICE, _, _ = get_backend()
pipe = pipeline(task=<span class="hljs-string">&quot;image-feature-extraction&quot;</span>, model_name=<span class="hljs-string">&quot;google/vit-base-patch16-384&quot;</span>, device=DEVICE, pool=<span class="hljs-literal">True</span>)`,wrap:!1}}),k=new h({props:{code:"b3V0cHV0cyUyMCUzRCUyMHBpcGUoJTVCaW1hZ2VfcmVhbCUyQyUyMGltYWdlX2dlbiU1RCk=",highlighted:"outputs = pipe([image_real, image_gen])",wrap:!1}}),v=new h({props:{code:"JTIzJTIwZ2V0JTIwdGhlJTIwbGVuZ3RoJTIwb2YlMjBhJTIwc2luZ2xlJTIwb3V0cHV0JTBBcHJpbnQobGVuKG91dHB1dHMlNUIwJTVEJTVCMCU1RCkpJTBBJTIzJTIwc2hvdyUyMG91dHB1dHMlMEFwcmludChvdXRwdXRzKSUwQSUwQSUyMyUyMDc2OCUwQSUyMyUyMCU1QiU1QiU1Qi0wLjAzOTA5MjM2OTM3NzYxMzA3JTJDJTIwMC40MzM4MTY3MDExNzM3ODIzNSUyQyUyMC0wLjA2OTEzMjU1OTAwMTQ0NTc3JTJD",highlighted:`<span class="hljs-comment"># get the length of a single output</span>
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(outputs[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>]))
<span class="hljs-comment"># show outputs</span>
<span class="hljs-built_in">print</span>(outputs)

<span class="hljs-comment"># 768</span>
<span class="hljs-comment"># [[[-0.03909236937761307, 0.43381670117378235, -0.06913255900144577,</span>`,wrap:!1}}),C=new h({props:{code:"ZnJvbSUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwlMjBpbXBvcnQlMjBjb3NpbmVfc2ltaWxhcml0eSUwQSUwQXNpbWlsYXJpdHlfc2NvcmUlMjAlM0QlMjBjb3NpbmVfc2ltaWxhcml0eSh0b3JjaC5UZW5zb3Iob3V0cHV0cyU1QjAlNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2guVGVuc29yKG91dHB1dHMlNUIxJTVEKSUyQyUyMGRpbSUzRDEpJTBBJTBBcHJpbnQoc2ltaWxhcml0eV9zY29yZSklMEElMEElMjMlMjB0ZW5zb3IoJTVCMC42MDQzJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> torch.nn.functional <span class="hljs-keyword">import</span> cosine_similarity

similarity_score = cosine_similarity(torch.Tensor(outputs[<span class="hljs-number">0</span>]),
                                     torch.Tensor(outputs[<span class="hljs-number">1</span>]), dim=<span class="hljs-number">1</span>)

<span class="hljs-built_in">print</span>(similarity_score)

<span class="hljs-comment"># tensor([0.6043])</span>`,wrap:!1}}),x=new h({props:{code:"cGlwZSUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJpbWFnZS1mZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMjBtb2RlbF9uYW1lJTNEJTIyZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQlMjIlMkMlMjBkZXZpY2UlM0RERVZJQ0UpJTBBb3V0cHV0cyUyMCUzRCUyMHBpcGUoaW1hZ2VfcmVhbCk=",highlighted:`pipe = pipeline(task=<span class="hljs-string">&quot;image-feature-extraction&quot;</span>, model_name=<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>, device=DEVICE)
outputs = pipe(image_real)`,wrap:!1}}),R=new h({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBcHJpbnQobnAuYXJyYXkob3V0cHV0cykuc2hhcGUpJTBBJTIzJTIwKDElMkMlMjAxOTclMkMlMjA3Njgp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-built_in">print</span>(np.array(outputs).shape)
<span class="hljs-comment"># (1, 197, 768)</span>`,wrap:!1}}),G=new ke({props:{title:"Getting Features and Similarities using AutoModel",local:"getting-features-and-similarities-using-automodel",headingTag:"h2"}}),H=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKS50byhERVZJQ0Up",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModel

processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)
model = AutoModel.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>).to(DEVICE)`,wrap:!1}}),E=new h({props:{code:"ZGVmJTIwaW5mZXIoaW1hZ2UpJTNBJTBBJTIwJTIwaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oREVWSUNFKSUwQSUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMjAlMjByZXR1cm4lMjBvdXRwdXRzLnBvb2xlcl9vdXRwdXQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">infer</span>(<span class="hljs-params">image</span>):
  inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(DEVICE)
  outputs = model(**inputs)
  <span class="hljs-keyword">return</span> outputs.pooler_output`,wrap:!1}}),X=new h({props:{code:"ZW1iZWRfcmVhbCUyMCUzRCUyMGluZmVyKGltYWdlX3JlYWwpJTBBZW1iZWRfZ2VuJTIwJTNEJTIwaW5mZXIoaW1hZ2VfZ2VuKQ==",highlighted:`embed_real = infer(image_real)
embed_gen = infer(image_gen)`,wrap:!1}}),z=new h({props:{code:"ZnJvbSUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwlMjBpbXBvcnQlMjBjb3NpbmVfc2ltaWxhcml0eSUwQSUwQXNpbWlsYXJpdHlfc2NvcmUlMjAlM0QlMjBjb3NpbmVfc2ltaWxhcml0eShlbWJlZF9yZWFsJTJDJTIwZW1iZWRfZ2VuJTJDJTIwZGltJTNEMSklMEFwcmludChzaW1pbGFyaXR5X3Njb3JlKSUwQSUwQSUyMyUyMHRlbnNvciglNUIwLjYwNjElNUQlMkMlMjBkZXZpY2UlM0QnY3VkYSUzQTAnJTJDJTIwZ3JhZF9mbiUzRCUzQ1N1bUJhY2t3YXJkMSUzRSk=",highlighted:`<span class="hljs-keyword">from</span> torch.nn.functional <span class="hljs-keyword">import</span> cosine_similarity

similarity_score = cosine_similarity(embed_real, embed_gen, dim=<span class="hljs-number">1</span>)
<span class="hljs-built_in">print</span>(similarity_score)

<span class="hljs-comment"># tensor([0.6061], device=&#x27;cuda:0&#x27;, grad_fn=&lt;SumBackward1&gt;)</span>`,wrap:!1}}),F=new et({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/image_feature_extraction.md"}}),{c(){g=i("meta"),A=a(),L=i("p"),P=a(),p(y.$$.fragment),D=a(),p(b.$$.fragment),K=a(),J=i("p"),J.textContent=ve,O=a(),w=i("p"),w.textContent=_e,ee=a(),M=i("ul"),M.innerHTML=Ce,te=a(),p(T.$$.fragment),se=a(),U=i("p"),U.textContent=Ve,le=a(),p(j.$$.fragment),ae=a(),$=i("p"),$.innerHTML=xe,ne=a(),p(I.$$.fragment),ie=a(),Z=i("p"),Z.innerHTML=Be,oe=a(),p(k.$$.fragment),pe=a(),W=i("p"),W.textContent=Re,me=a(),p(v.$$.fragment),re=a(),_=i("p"),_.textContent=Ge,ce=a(),p(C.$$.fragment),ue=a(),V=i("p"),V.innerHTML=Qe,fe=a(),p(x.$$.fragment),de=a(),B=i("p"),B.textContent=He,he=a(),p(R.$$.fragment),ge=a(),p(G.$$.fragment),ye=a(),Q=i("p"),Q.innerHTML=Ne,be=a(),p(H.$$.fragment),Je=a(),N=i("p"),N.innerHTML=Ee,we=a(),p(E.$$.fragment),Me=a(),S=i("p"),S.textContent=Se,Te=a(),p(X.$$.fragment),Ue=a(),Y=i("p"),Y.textContent=Xe,je=a(),p(z.$$.fragment),$e=a(),p(F.$$.fragment),Ie=a(),q=i("p"),this.h()},l(e){const t=De("svelte-u9bgzb",document.head);g=o(t,"META",{name:!0,content:!0}),t.forEach(s),A=n(e),L=o(e,"P",{}),Ye(L).forEach(s),P=n(e),m(y.$$.fragment,e),D=n(e),m(b.$$.fragment,e),K=n(e),J=o(e,"P",{"data-svelte-h":!0}),d(J)!=="svelte-htpxsg"&&(J.textContent=ve),O=n(e),w=o(e,"P",{"data-svelte-h":!0}),d(w)!=="svelte-dkb44i"&&(w.textContent=_e),ee=n(e),M=o(e,"UL",{"data-svelte-h":!0}),d(M)!=="svelte-o9mygf"&&(M.innerHTML=Ce),te=n(e),m(T.$$.fragment,e),se=n(e),U=o(e,"P",{"data-svelte-h":!0}),d(U)!=="svelte-1y1lzmz"&&(U.textContent=Ve),le=n(e),m(j.$$.fragment,e),ae=n(e),$=o(e,"P",{"data-svelte-h":!0}),d($)!=="svelte-ufkt7t"&&($.innerHTML=xe),ne=n(e),m(I.$$.fragment,e),ie=n(e),Z=o(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-1wqrlcg"&&(Z.innerHTML=Be),oe=n(e),m(k.$$.fragment,e),pe=n(e),W=o(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-ejn9fo"&&(W.textContent=Re),me=n(e),m(v.$$.fragment,e),re=n(e),_=o(e,"P",{"data-svelte-h":!0}),d(_)!=="svelte-7ov6zk"&&(_.textContent=Ge),ce=n(e),m(C.$$.fragment,e),ue=n(e),V=o(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-1t8cfg9"&&(V.innerHTML=Qe),fe=n(e),m(x.$$.fragment,e),de=n(e),B=o(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-u3d9d7"&&(B.textContent=He),he=n(e),m(R.$$.fragment,e),ge=n(e),m(G.$$.fragment,e),ye=n(e),Q=o(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-18d7a3m"&&(Q.innerHTML=Ne),be=n(e),m(H.$$.fragment,e),Je=n(e),N=o(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-1mcm377"&&(N.innerHTML=Ee),we=n(e),m(E.$$.fragment,e),Me=n(e),S=o(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-1ej6c6d"&&(S.textContent=Se),Te=n(e),m(X.$$.fragment,e),Ue=n(e),Y=o(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-1t2j36n"&&(Y.textContent=Xe),je=n(e),m(z.$$.fragment,e),$e=n(e),m(F.$$.fragment,e),Ie=n(e),q=o(e,"P",{}),Ye(q).forEach(s),this.h()},h(){ze(g,"name","hf:doc:metadata"),ze(g,"content",st)},m(e,t){Ke(document.head,g),l(e,A,t),l(e,L,t),l(e,P,t),r(y,e,t),l(e,D,t),r(b,e,t),l(e,K,t),l(e,J,t),l(e,O,t),l(e,w,t),l(e,ee,t),l(e,M,t),l(e,te,t),r(T,e,t),l(e,se,t),l(e,U,t),l(e,le,t),r(j,e,t),l(e,ae,t),l(e,$,t),l(e,ne,t),r(I,e,t),l(e,ie,t),l(e,Z,t),l(e,oe,t),r(k,e,t),l(e,pe,t),l(e,W,t),l(e,me,t),r(v,e,t),l(e,re,t),l(e,_,t),l(e,ce,t),r(C,e,t),l(e,ue,t),l(e,V,t),l(e,fe,t),r(x,e,t),l(e,de,t),l(e,B,t),l(e,he,t),r(R,e,t),l(e,ge,t),r(G,e,t),l(e,ye,t),l(e,Q,t),l(e,be,t),r(H,e,t),l(e,Je,t),l(e,N,t),l(e,we,t),r(E,e,t),l(e,Me,t),l(e,S,t),l(e,Te,t),r(X,e,t),l(e,Ue,t),l(e,Y,t),l(e,je,t),r(z,e,t),l(e,$e,t),r(F,e,t),l(e,Ie,t),l(e,q,t),Ze=!0},p:Le,i(e){Ze||(c(y.$$.fragment,e),c(b.$$.fragment,e),c(T.$$.fragment,e),c(j.$$.fragment,e),c(I.$$.fragment,e),c(k.$$.fragment,e),c(v.$$.fragment,e),c(C.$$.fragment,e),c(x.$$.fragment,e),c(R.$$.fragment,e),c(G.$$.fragment,e),c(H.$$.fragment,e),c(E.$$.fragment,e),c(X.$$.fragment,e),c(z.$$.fragment,e),c(F.$$.fragment,e),Ze=!0)},o(e){u(y.$$.fragment,e),u(b.$$.fragment,e),u(T.$$.fragment,e),u(j.$$.fragment,e),u(I.$$.fragment,e),u(k.$$.fragment,e),u(v.$$.fragment,e),u(C.$$.fragment,e),u(x.$$.fragment,e),u(R.$$.fragment,e),u(G.$$.fragment,e),u(H.$$.fragment,e),u(E.$$.fragment,e),u(X.$$.fragment,e),u(z.$$.fragment,e),u(F.$$.fragment,e),Ze=!1},d(e){e&&(s(A),s(L),s(P),s(D),s(K),s(J),s(O),s(w),s(ee),s(M),s(te),s(se),s(U),s(le),s(ae),s($),s(ne),s(ie),s(Z),s(oe),s(pe),s(W),s(me),s(re),s(_),s(ce),s(ue),s(V),s(fe),s(de),s(B),s(he),s(ge),s(ye),s(Q),s(be),s(Je),s(N),s(we),s(Me),s(S),s(Te),s(Ue),s(Y),s(je),s($e),s(Ie),s(q)),s(g),f(y,e),f(b,e),f(T,e),f(j,e),f(I,e),f(k,e),f(v,e),f(C,e),f(x,e),f(R,e),f(G,e),f(H,e),f(E,e),f(X,e),f(z,e),f(F,e)}}}const st='{"title":"Image Feature Extraction","local":"image-feature-extraction","sections":[{"title":"Image Similarity using image-feature-extraction Pipeline","local":"image-similarity-using-image-feature-extraction-pipeline","sections":[],"depth":2},{"title":"Getting Features and Similarities using AutoModel","local":"getting-features-and-similarities-using-automodel","sections":[],"depth":2}],"depth":1}';function lt(We){return qe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rt extends Ae{constructor(g){super(),Pe(this,g,lt,tt,Fe,{})}}export{rt as component};
