import{s as Ht,n as St,o as zt}from"../chunks/scheduler.18a86fab.js";import{S as Yt,i as Ft,g as M,s as a,r as p,A as Lt,h as i,f as e,c as n,j as $t,u as j,x as o,k as rt,y as Pt,a as s,v as y,d as r,t as U,w as m}from"../chunks/index.98837b22.js";import{C as J}from"../chunks/CodeBlock.8d0c2e8a.js";import{D as Dt}from"../chunks/DocNotebookDropdown.a04a6b2a.js";import{H as Ut}from"../chunks/Heading.7e7e0c5b.js";import{E as Kt}from"../chunks/index.f01015d9.js";function Ot(mt){let u,ml,rl,Jl,h,ul,w,cl,d,Jt="Image-text-to-text models, also known as vision language models (VLMs), are language models that take an image input. These models can tackle various tasks, from visual question answering to image segmentation. This task shares many similarities with image-to-text, but with some overlapping use cases like image captioning. Image-to-text models only take image inputs and often accomplish a specific task, whereas VLMs take open-ended text and image inputs and are more generalist models.",Tl,g,ut="In this guide, we provide a brief overview of VLMs and show how to use them with Transformers for inference.",hl,I,ct="To begin with, there are multiple types of VLMs:",wl,A,Tt="<li>base models used for fine-tuning</li> <li>chat fine-tuned models for conversation</li> <li>instruction fine-tuned models</li>",dl,C,ht="This guide focuses on inference with an instruction-tuned model.",gl,b,wt="Let’s begin installing the dependencies.",Il,f,Al,Z,dt="Let’s initialize the model and the processor.",Cl,B,bl,x,gt='This model has a <a href="./chat_templating">chat template</a> that helps user parse chat outputs. Moreover, the model can also accept multiple images as input in a single conversation or message. We will now prepare the inputs.',fl,W,It="The image inputs look like the following.",Zl,c,At='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/cats.png" alt="Two cats sitting on a net"/>',Bl,T,Ct='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee.jpg" alt="A bee on a pink flower"/>',xl,q,Wl,E,bt="Below is an example of the chat template. We can feed conversation turns and the last message as an input by appending it at the end of the template.",ql,Q,El,G,ft='We will now call the processors’ <a href="/docs/transformers/main/en/main_classes/processors#transformers.ProcessorMixin.apply_chat_template">apply_chat_template()</a> method to preprocess its output along with the image inputs.',Ql,R,Gl,V,Zt="We can now pass the preprocessed inputs to the model.",Rl,N,Vl,k,Nl,v,Bt='The fastest way to get started is to use the <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a> API. Specify the <code>&quot;image-text-to-text&quot;</code> task and the model you want to use.',kl,X,vl,_,xt="The example below uses chat templates to format the text inputs.",Xl,$,_l,H,Wt='Pass the chat template formatted text and image to <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a> and set <code>return_full_text=False</code> to remove the input from the generated output.',$l,S,Hl,z,qt="If you prefer, you can also load the images separately and pass them to the pipeline like so:",Sl,Y,zl,F,Et="The images will still be included in the <code>&quot;input_text&quot;</code> field of the output:",Yl,L,Fl,P,Qt='We can use <a href="./generation_strategies#streaming">text streaming</a> for a better generation experience. Transformers supports streaming with the <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TextStreamer">TextStreamer</a> or <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TextIteratorStreamer">TextIteratorStreamer</a> classes. We will use the <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TextIteratorStreamer">TextIteratorStreamer</a> with IDEFICS-8B.',Ll,D,Gt='Assume we have an application that keeps chat history and takes in the new user input. We will preprocess the inputs as usual and initialize <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TextIteratorStreamer">TextIteratorStreamer</a> to handle the generation in a separate thread. This allows you to stream the generated text tokens in real-time. Any generation arguments can be passed to <a href="/docs/transformers/main/en/internal/generation_utils#transformers.TextIteratorStreamer">TextIteratorStreamer</a>.',Pl,K,Dl,O,Rt="Now let’s call the <code>model_inference</code> function we created and stream the values.",Kl,ll,Ol,tl,lt,el,Vt='VLMs are often large and need to be optimized to fit on smaller hardware. Transformers supports many model quantization libraries, and here we will only show int8 quantization with <a href="./quantization/quanto#quanto">Quanto</a>. int8 quantization offers memory improvements up to 75 percent (if all weights are quantized). However it is no free lunch, since 8-bit is not a CUDA-native precision, the weights are quantized back and forth on the fly, which adds up to latency.',tt,sl,Nt="First, install dependencies.",et,al,st,nl,kt='To quantize a model during loading, we need to first create <a href="/docs/transformers/main/en/main_classes/quantization#transformers.QuantoConfig">QuantoConfig</a>. Then load the model as usual, but pass <code>quantization_config</code> during model initialization.',at,Ml,nt,il,vt="And that’s it, we can use the model the same way with no changes.",Mt,ol,it,pl,Xt="Here are some more resources for the image-text-to-text task.",ot,jl,_t='<li><a href="https://huggingface.co/tasks/image-text-to-text" rel="nofollow">Image-text-to-text task page</a> covers model types, use cases, datasets, and more.</li> <li><a href="https://huggingface.co/blog/vlms" rel="nofollow">Vision Language Models Explained</a> is a blog post that covers everything about vision language models and supervised fine-tuning using <a href="https://huggingface.co/docs/trl/en/index" rel="nofollow">TRL</a>.</li>',pt,yl,jt,Ul,yt;return h=new Ut({props:{title:"Image-text-to-text",local:"image-text-to-text",headingTag:"h1"}}),w=new Dt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/image_text_to_text.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/image_text_to_text.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/image_text_to_text.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/image_text_to_text.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/image_text_to_text.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/image_text_to_text.ipynb"}]}}),f=new J({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZSUyMGZsYXNoX2F0dG4=",highlighted:"pip install -q transformers accelerate flash_attn",wrap:!1}}),B=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRldmljZSUyMCUzRCUyMHRvcmNoLmRldmljZSglMjJjdWRhJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VUZXh0VG9UZXh0LmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJIdWdnaW5nRmFjZU00JTJGaWRlZmljczItOGIlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyJTJDJTBBKS50byhkZXZpY2UpJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIySHVnZ2luZ0ZhY2VNNCUyRmlkZWZpY3MyLThiJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForImageTextToText
<span class="hljs-keyword">import</span> torch

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>)
model = AutoModelForImageTextToText.from_pretrained(
    <span class="hljs-string">&quot;HuggingFaceM4/idefics2-8b&quot;</span>,
    torch_dtype=torch.bfloat16,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
).to(device)

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;HuggingFaceM4/idefics2-8b&quot;</span>)`,wrap:!1}}),q=new J({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEFpbWdfdXJscyUyMCUzRCU1QiUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmNhdHMucG5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGYmVlLmpwZyUyMiU1RCUwQWltYWdlcyUyMCUzRCUyMCU1QkltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KGltZ191cmxzJTVCMCU1RCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldChpbWdfdXJscyU1QjElNUQlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTVE",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

img_urls =[<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/cats.png&quot;</span>,
           <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee.jpg&quot;</span>]
images = [Image.<span class="hljs-built_in">open</span>(requests.get(img_urls[<span class="hljs-number">0</span>], stream=<span class="hljs-literal">True</span>).raw),
          Image.<span class="hljs-built_in">open</span>(requests.get(img_urls[<span class="hljs-number">1</span>], stream=<span class="hljs-literal">True</span>).raw)]`,wrap:!1}}),Q=new J({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJXaGF0JTIwZG8lMjB3ZSUyMHNlZSUyMGluJTIwdGhpcyUyMGltYWdlJTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJJbiUyMHRoaXMlMjBpbWFnZSUyMHdlJTIwY2FuJTIwc2VlJTIwdHdvJTIwY2F0cyUyMG9uJTIwdGhlJTIwbmV0cy4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJBbmQlMjBob3clMjBhYm91dCUyMHRoaXMlMjBpbWFnZSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSU1RA==",highlighted:`messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What do we see in this image?&quot;</span>},
        ]
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;In this image we can see two cats on the nets.&quot;</span>},
        ]
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;And how about this image?&quot;</span>},
        ]
    },
]`,wrap:!1}}),R=new J({props:{code:"cHJvbXB0JTIwJTNEJTIwcHJvY2Vzc29yLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlKSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEcHJvbXB0JTJDJTIwaW1hZ2VzJTNEJTVCaW1hZ2VzJTVCMCU1RCUyQyUyMGltYWdlcyU1QjElNUQlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhkZXZpY2Up",highlighted:`prompt = processor.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>)
inputs = processor(text=prompt, images=[images[<span class="hljs-number">0</span>], images[<span class="hljs-number">1</span>]], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)`,wrap:!1}}),N=new J({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNENTAwKSUwQWdlbmVyYXRlZF90ZXh0cyUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQSUwQXByaW50KGdlbmVyYXRlZF90ZXh0cyklMEElMjMlMjMlMjAlNUInVXNlciUzQSUyMFdoYXQlMjBkbyUyMHdlJTIwc2VlJTIwaW4lMjB0aGlzJTIwaW1hZ2UlM0YlMjAlNUNuQXNzaXN0YW50JTNBJTIwSW4lMjB0aGlzJTIwaW1hZ2UlMjB3ZSUyMGNhbiUyMHNlZSUyMHR3byUyMGNhdHMlMjBvbiUyMHRoZSUyMG5ldHMuJTIwJTVDblVzZXIlM0ElMjBBbmQlMjBob3clMjBhYm91dCUyMHRoaXMlMjBpbWFnZSUzRiUyMCU1Q25Bc3Npc3RhbnQlM0ElMjBJbiUyMHRoaXMlMjBpbWFnZSUyMHdlJTIwY2FuJTIwc2VlJTIwZmxvd2VycyUyQyUyMHBsYW50cyUyMGFuZCUyMGluc2VjdC4nJTVE",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">500</span>)
generated_texts = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-built_in">print</span>(generated_texts)
<span class="hljs-comment">## [&#x27;User: What do we see in this image? \\nAssistant: In this image we can see two cats on the nets. \\nUser: And how about this image? \\nAssistant: In this image we can see flowers, plants and insect.&#x27;]</span>`,wrap:!1}}),k=new Ut({props:{title:"Pipeline",local:"pipeline",headingTag:"h2"}}),X=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmltYWdlLXRleHQtdG8tdGV4dCUyMiUyQyUyMG1vZGVsJTNEJTIybGxhdmEtaGYlMkZsbGF2YS1pbnRlcmxlYXZlLXF3ZW4tMC41Yi1oZiUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
pipe = pipeline(<span class="hljs-string">&quot;image-text-to-text&quot;</span>, model=<span class="hljs-string">&quot;llava-hf/llava-interleave-qwen-0.5b-hf&quot;</span>)`,wrap:!1}}),$=new J({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbWFnZSUyMiUzQSUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmJlZS5qcGclMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJEZXNjcmliZSUyMHRoaXMlMjBpbWFnZS4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMlRoZXJlJ3MlMjBhJTIwcGluayUyMGZsb3dlciUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCU1RA==",highlighted:`messages = [
     {
         <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
         <span class="hljs-string">&quot;content&quot;</span>: [
             {
                 <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>,
                 <span class="hljs-string">&quot;image&quot;</span>: <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee.jpg&quot;</span>,
             },
             {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Describe this image.&quot;</span>},
         ],
     },
     {
         <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
         <span class="hljs-string">&quot;content&quot;</span>: [
             {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;There&#x27;s a pink flower&quot;</span>},
         ],
     },
 ]`,wrap:!1}}),S=new J({props:{code:"b3V0cHV0cyUyMCUzRCUyMHBpcGUodGV4dCUzRG1lc3NhZ2VzJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCUyQyUyMHJldHVybl9mdWxsX3RleHQlM0RGYWxzZSklMEFvdXRwdXRzJTVCMCU1RCU1QiUyMmdlbmVyYXRlZF90ZXh0JTIyJTVEJTBBJTIzJTIwJTIwd2l0aCUyMGElMjB5ZWxsb3clMjBjZW50ZXIlMjBpbiUyMHRoZSUyMGZvcmVncm91bmQuJTIwVGhlJTIwZmxvd2VyJTIwaXMlMjBzdXJyb3VuZGVkJTIwYnklMjByZWQlMjBhbmQlMjB3aGl0ZSUyMGZsb3dlcnMlMjB3aXRoJTIwZ3JlZW4lMjBzdGVtcw==",highlighted:`outputs = pipe(text=messages, max_new_tokens=<span class="hljs-number">20</span>, return_full_text=<span class="hljs-literal">False</span>)
outputs[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>]
<span class="hljs-comment">#  with a yellow center in the foreground. The flower is surrounded by red and white flowers with green stems</span>`,wrap:!1}}),Y=new J({props:{code:"cGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmltYWdlLXRleHQtdG8tdGV4dCUyMiUyQyUyMG1vZGVsJTNEJTIySHVnZ2luZ0ZhY2VUQiUyRlNtb2xWTE0tMjU2TS1JbnN0cnVjdCUyMiklMEElMEFpbWdfdXJscyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmNhdHMucG5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGYmVlLmpwZyUyMiUyQyUwQSU1RCUwQWltYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KGltZ191cmxzJTVCMCU1RCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMkMlMEElMjAlMjAlMjAlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldChpbWdfdXJscyU1QjElNUQlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTJDJTBBJTVEJTBBJTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJXaGF0JTIwZG8lMjB5b3UlMjBzZWUlMjBpbiUyMHRoZXNlJTIwaW1hZ2VzJTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTVEJTBBb3V0cHV0cyUyMCUzRCUyMHBpcGUodGV4dCUzRG1lc3NhZ2VzJTJDJTIwaW1hZ2VzJTNEaW1hZ2VzJTJDJTIwbWF4X25ld190b2tlbnMlM0Q1MCUyQyUyMHJldHVybl9mdWxsX3RleHQlM0RGYWxzZSklMEFvdXRwdXRzJTVCMCU1RCU1QiUyMmdlbmVyYXRlZF90ZXh0JTIyJTVEJTBBJTIyJTIwSW4lMjB0aGUlMjBmaXJzdCUyMGltYWdlJTJDJTIwdGhlcmUlMjBhcmUlMjB0d28lMjBjYXRzJTIwc2l0dGluZyUyMG9uJTIwYSUyMHBsYW50LiUyMEluJTIwdGhlJTIwc2Vjb25kJTIwaW1hZ2UlMkMlMjB0aGVyZSUyMGFyZSUyMGZsb3dlcnMlMjB3aXRoJTIwYSUyMHBpbmtpc2glMjBodWUuJTIy",highlighted:`pipe = pipeline(<span class="hljs-string">&quot;image-text-to-text&quot;</span>, model=<span class="hljs-string">&quot;HuggingFaceTB/SmolVLM-256M-Instruct&quot;</span>)

img_urls = [
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/cats.png&quot;</span>,
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee.jpg&quot;</span>,
]
images = [
    Image.<span class="hljs-built_in">open</span>(requests.get(img_urls[<span class="hljs-number">0</span>], stream=<span class="hljs-literal">True</span>).raw),
    Image.<span class="hljs-built_in">open</span>(requests.get(img_urls[<span class="hljs-number">1</span>], stream=<span class="hljs-literal">True</span>).raw),
]

messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What do you see in these images?&quot;</span>},
        ],
    }
]
outputs = pipe(text=messages, images=images, max_new_tokens=<span class="hljs-number">50</span>, return_full_text=<span class="hljs-literal">False</span>)
outputs[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>]
<span class="hljs-string">&quot; In the first image, there are two cats sitting on a plant. In the second image, there are flowers with a pinkish hue.&quot;</span>`,wrap:!1}}),L=new J({props:{code:"b3V0cHV0cyU1QjAlNUQlNUInaW5wdXRfdGV4dCclNUQlMEElMjIlMjIlMjIlMEElNUIlN0Incm9sZSclM0ElMjAndXNlciclMkMlMEElMjAlMjAnY29udGVudCclM0ElMjAlNUIlN0IndHlwZSclM0ElMjAnaW1hZ2UnJTJDJTBBJTIwJTIwJTIwJTIwJ2ltYWdlJyUzQSUyMCUzQ1BJTC5QbmdJbWFnZVBsdWdpbi5QbmdJbWFnZUZpbGUlMjBpbWFnZSUyMG1vZGUlM0RSR0JBJTIwc2l6ZSUzRDYyMng0MTIlM0UlN0QlMkMlMEElMjAlMjAlMjAlN0IndHlwZSclM0ElMjAnaW1hZ2UnJTJDJTBBJTIwJTIwJTIwJTIwJ2ltYWdlJyUzQSUyMCUzQ1BJTC5KcGVnSW1hZ2VQbHVnaW4uSnBlZ0ltYWdlRmlsZSUyMGltYWdlJTIwbW9kZSUzRFJHQiUyMHNpemUlM0Q1MTg0eDM0NTYlM0UlN0QlMkMlMEElMjAlMjAlMjAlN0IndHlwZSclM0ElMjAndGV4dCclMkMlMjAndGV4dCclM0ElMjAnV2hhdCUyMGRvJTIweW91JTIwc2VlJTIwaW4lMjB0aGVzZSUyMGltYWdlcyUzRiclN0QlNUQlN0QlNUQlMjMlMjMlMjBTdHJlYW1pbmclMEElMjIlMjIlMjI=",highlighted:`outputs[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;input_text&#x27;</span>]
<span class="hljs-string">&quot;&quot;&quot;
[{&#x27;role&#x27;: &#x27;user&#x27;,
  &#x27;content&#x27;: [{&#x27;type&#x27;: &#x27;image&#x27;,
    &#x27;image&#x27;: &lt;PIL.PngImagePlugin.PngImageFile image mode=RGBA size=622x412&gt;},
   {&#x27;type&#x27;: &#x27;image&#x27;,
    &#x27;image&#x27;: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=5184x3456&gt;},
   {&#x27;type&#x27;: &#x27;text&#x27;, &#x27;text&#x27;: &#x27;What do you see in these images?&#x27;}]}]## Streaming
&quot;&quot;&quot;</span>`,wrap:!1}}),K=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TextIteratorStreamer
<span class="hljs-keyword">from</span> threading <span class="hljs-keyword">import</span> Thread

<span class="hljs-keyword">def</span> <span class="hljs-title function_">model_inference</span>(<span class="hljs-params">
    user_prompt,
    chat_history,
    max_new_tokens,
    images
</span>):
    user_prompt = {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: user_prompt},
        ]
    }
    chat_history.append(user_prompt)
    streamer = TextIteratorStreamer(
        processor.tokenizer,
        skip_prompt=<span class="hljs-literal">True</span>,
        timeout=<span class="hljs-number">5.0</span>,
    )

    generation_args = {
        <span class="hljs-string">&quot;max_new_tokens&quot;</span>: max_new_tokens,
        <span class="hljs-string">&quot;streamer&quot;</span>: streamer,
        <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">False</span>
    }

    <span class="hljs-comment"># add_generation_prompt=True makes model generate bot response</span>
    prompt = processor.apply_chat_template(chat_history, add_generation_prompt=<span class="hljs-literal">True</span>)
    inputs = processor(
        text=prompt,
        images=images,
        return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
    ).to(device)
    generation_args.update(inputs)

    thread = Thread(
        target=model.generate,
        kwargs=generation_args,
    )
    thread.start()

    acc_text = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">for</span> text_token <span class="hljs-keyword">in</span> streamer:
        time.sleep(<span class="hljs-number">0.04</span>)
        acc_text += text_token
        <span class="hljs-keyword">if</span> acc_text.endswith(<span class="hljs-string">&quot;&lt;end_of_utterance&gt;&quot;</span>):
            acc_text = acc_text[:-<span class="hljs-number">18</span>]
        <span class="hljs-keyword">yield</span> acc_text

    thread.join()`,wrap:!1}}),ll=new J({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwbW9kZWxfaW5mZXJlbmNlKCUwQSUyMCUyMCUyMCUyMHVzZXJfcHJvbXB0JTNEJTIyQW5kJTIwd2hhdCUyMGlzJTIwaW4lMjB0aGlzJTIwaW1hZ2UlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjBjaGF0X2hpc3RvcnklM0RtZXNzYWdlcyU1QiUzQTIlNUQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMGltYWdlcyUzRGltYWdlcyUwQSklMEElMEFmb3IlMjB2YWx1ZSUyMGluJTIwZ2VuZXJhdG9yJTNBJTBBJTIwJTIwcHJpbnQodmFsdWUpJTBBJTBBJTIzJTIwSW4lMEElMjMlMjBJbiUyMHRoaXMlMEElMjMlMjBJbiUyMHRoaXMlMjBpbWFnZSUyMC4uLg==",highlighted:`generator = model_inference(
    user_prompt=<span class="hljs-string">&quot;And what is in this image?&quot;</span>,
    chat_history=messages[:<span class="hljs-number">2</span>],
    max_new_tokens=<span class="hljs-number">100</span>,
    images=images
)

<span class="hljs-keyword">for</span> value <span class="hljs-keyword">in</span> generator:
  <span class="hljs-built_in">print</span>(value)

<span class="hljs-comment"># In</span>
<span class="hljs-comment"># In this</span>
<span class="hljs-comment"># In this image ...</span>`,wrap:!1}}),tl=new Ut({props:{title:"Fit models in smaller hardware",local:"fit-models-in-smaller-hardware",headingTag:"h2"}}),al=new J({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwcXVhbnRvJTIwYml0c2FuZGJ5dGVz",highlighted:"pip install -U quanto bitsandbytes",wrap:!1}}),Ml=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlVGV4dFRvVGV4dCUyQyUyMFF1YW50b0NvbmZpZyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIySHVnZ2luZ0ZhY2VNNCUyRmlkZWZpY3MyLThiJTIyJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMFF1YW50b0NvbmZpZyh3ZWlnaHRzJTNEJTIyaW50OCUyMiklMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageTextToText, QuantoConfig

model_id = <span class="hljs-string">&quot;HuggingFaceM4/idefics2-8b&quot;</span>
quantization_config = QuantoConfig(weights=<span class="hljs-string">&quot;int8&quot;</span>)
quantized_model = AutoModelForImageTextToText.from_pretrained(
    model_id, device_map=<span class="hljs-string">&quot;cuda&quot;</span>, quantization_config=quantization_config
)`,wrap:!1}}),ol=new Ut({props:{title:"Further Reading",local:"further-reading",headingTag:"h2"}}),yl=new Kt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/image_text_to_text.md"}}),{c(){u=M("meta"),ml=a(),rl=M("p"),Jl=a(),p(h.$$.fragment),ul=a(),p(w.$$.fragment),cl=a(),d=M("p"),d.textContent=Jt,Tl=a(),g=M("p"),g.textContent=ut,hl=a(),I=M("p"),I.textContent=ct,wl=a(),A=M("ul"),A.innerHTML=Tt,dl=a(),C=M("p"),C.textContent=ht,gl=a(),b=M("p"),b.textContent=wt,Il=a(),p(f.$$.fragment),Al=a(),Z=M("p"),Z.textContent=dt,Cl=a(),p(B.$$.fragment),bl=a(),x=M("p"),x.innerHTML=gt,fl=a(),W=M("p"),W.textContent=It,Zl=a(),c=M("div"),c.innerHTML=At,Bl=a(),T=M("div"),T.innerHTML=Ct,xl=a(),p(q.$$.fragment),Wl=a(),E=M("p"),E.textContent=bt,ql=a(),p(Q.$$.fragment),El=a(),G=M("p"),G.innerHTML=ft,Ql=a(),p(R.$$.fragment),Gl=a(),V=M("p"),V.textContent=Zt,Rl=a(),p(N.$$.fragment),Vl=a(),p(k.$$.fragment),Nl=a(),v=M("p"),v.innerHTML=Bt,kl=a(),p(X.$$.fragment),vl=a(),_=M("p"),_.textContent=xt,Xl=a(),p($.$$.fragment),_l=a(),H=M("p"),H.innerHTML=Wt,$l=a(),p(S.$$.fragment),Hl=a(),z=M("p"),z.textContent=qt,Sl=a(),p(Y.$$.fragment),zl=a(),F=M("p"),F.innerHTML=Et,Yl=a(),p(L.$$.fragment),Fl=a(),P=M("p"),P.innerHTML=Qt,Ll=a(),D=M("p"),D.innerHTML=Gt,Pl=a(),p(K.$$.fragment),Dl=a(),O=M("p"),O.innerHTML=Rt,Kl=a(),p(ll.$$.fragment),Ol=a(),p(tl.$$.fragment),lt=a(),el=M("p"),el.innerHTML=Vt,tt=a(),sl=M("p"),sl.textContent=Nt,et=a(),p(al.$$.fragment),st=a(),nl=M("p"),nl.innerHTML=kt,at=a(),p(Ml.$$.fragment),nt=a(),il=M("p"),il.textContent=vt,Mt=a(),p(ol.$$.fragment),it=a(),pl=M("p"),pl.textContent=Xt,ot=a(),jl=M("ul"),jl.innerHTML=_t,pt=a(),p(yl.$$.fragment),jt=a(),Ul=M("p"),this.h()},l(l){const t=Lt("svelte-u9bgzb",document.head);u=i(t,"META",{name:!0,content:!0}),t.forEach(e),ml=n(l),rl=i(l,"P",{}),$t(rl).forEach(e),Jl=n(l),j(h.$$.fragment,l),ul=n(l),j(w.$$.fragment,l),cl=n(l),d=i(l,"P",{"data-svelte-h":!0}),o(d)!=="svelte-16zti1"&&(d.textContent=Jt),Tl=n(l),g=i(l,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1fk5u1j"&&(g.textContent=ut),hl=n(l),I=i(l,"P",{"data-svelte-h":!0}),o(I)!=="svelte-ql8pa"&&(I.textContent=ct),wl=n(l),A=i(l,"UL",{"data-svelte-h":!0}),o(A)!=="svelte-1vpzkb0"&&(A.innerHTML=Tt),dl=n(l),C=i(l,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1m8dinx"&&(C.textContent=ht),gl=n(l),b=i(l,"P",{"data-svelte-h":!0}),o(b)!=="svelte-5jp6fp"&&(b.textContent=wt),Il=n(l),j(f.$$.fragment,l),Al=n(l),Z=i(l,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1rw69r9"&&(Z.textContent=dt),Cl=n(l),j(B.$$.fragment,l),bl=n(l),x=i(l,"P",{"data-svelte-h":!0}),o(x)!=="svelte-sa4wix"&&(x.innerHTML=gt),fl=n(l),W=i(l,"P",{"data-svelte-h":!0}),o(W)!=="svelte-5oehs9"&&(W.textContent=It),Zl=n(l),c=i(l,"DIV",{class:!0,"data-svelte-h":!0}),o(c)!=="svelte-z5b734"&&(c.innerHTML=At),Bl=n(l),T=i(l,"DIV",{class:!0,"data-svelte-h":!0}),o(T)!=="svelte-vw53ct"&&(T.innerHTML=Ct),xl=n(l),j(q.$$.fragment,l),Wl=n(l),E=i(l,"P",{"data-svelte-h":!0}),o(E)!=="svelte-it4u80"&&(E.textContent=bt),ql=n(l),j(Q.$$.fragment,l),El=n(l),G=i(l,"P",{"data-svelte-h":!0}),o(G)!=="svelte-dclbpo"&&(G.innerHTML=ft),Ql=n(l),j(R.$$.fragment,l),Gl=n(l),V=i(l,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1c12q4j"&&(V.textContent=Zt),Rl=n(l),j(N.$$.fragment,l),Vl=n(l),j(k.$$.fragment,l),Nl=n(l),v=i(l,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1wgz4d8"&&(v.innerHTML=Bt),kl=n(l),j(X.$$.fragment,l),vl=n(l),_=i(l,"P",{"data-svelte-h":!0}),o(_)!=="svelte-qman2s"&&(_.textContent=xt),Xl=n(l),j($.$$.fragment,l),_l=n(l),H=i(l,"P",{"data-svelte-h":!0}),o(H)!=="svelte-hph3ip"&&(H.innerHTML=Wt),$l=n(l),j(S.$$.fragment,l),Hl=n(l),z=i(l,"P",{"data-svelte-h":!0}),o(z)!=="svelte-3gweto"&&(z.textContent=qt),Sl=n(l),j(Y.$$.fragment,l),zl=n(l),F=i(l,"P",{"data-svelte-h":!0}),o(F)!=="svelte-6j8b22"&&(F.innerHTML=Et),Yl=n(l),j(L.$$.fragment,l),Fl=n(l),P=i(l,"P",{"data-svelte-h":!0}),o(P)!=="svelte-ycqsyr"&&(P.innerHTML=Qt),Ll=n(l),D=i(l,"P",{"data-svelte-h":!0}),o(D)!=="svelte-opb7dg"&&(D.innerHTML=Gt),Pl=n(l),j(K.$$.fragment,l),Dl=n(l),O=i(l,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1or0ggk"&&(O.innerHTML=Rt),Kl=n(l),j(ll.$$.fragment,l),Ol=n(l),j(tl.$$.fragment,l),lt=n(l),el=i(l,"P",{"data-svelte-h":!0}),o(el)!=="svelte-1qxdmp"&&(el.innerHTML=Vt),tt=n(l),sl=i(l,"P",{"data-svelte-h":!0}),o(sl)!=="svelte-1kehp8k"&&(sl.textContent=Nt),et=n(l),j(al.$$.fragment,l),st=n(l),nl=i(l,"P",{"data-svelte-h":!0}),o(nl)!=="svelte-hu48ru"&&(nl.innerHTML=kt),at=n(l),j(Ml.$$.fragment,l),nt=n(l),il=i(l,"P",{"data-svelte-h":!0}),o(il)!=="svelte-1174nfw"&&(il.textContent=vt),Mt=n(l),j(ol.$$.fragment,l),it=n(l),pl=i(l,"P",{"data-svelte-h":!0}),o(pl)!=="svelte-n9r3vs"&&(pl.textContent=Xt),ot=n(l),jl=i(l,"UL",{"data-svelte-h":!0}),o(jl)!=="svelte-30a4e"&&(jl.innerHTML=_t),pt=n(l),j(yl.$$.fragment,l),jt=n(l),Ul=i(l,"P",{}),$t(Ul).forEach(e),this.h()},h(){rt(u,"name","hf:doc:metadata"),rt(u,"content",le),rt(c,"class","flex justify-center"),rt(T,"class","flex justify-center")},m(l,t){Pt(document.head,u),s(l,ml,t),s(l,rl,t),s(l,Jl,t),y(h,l,t),s(l,ul,t),y(w,l,t),s(l,cl,t),s(l,d,t),s(l,Tl,t),s(l,g,t),s(l,hl,t),s(l,I,t),s(l,wl,t),s(l,A,t),s(l,dl,t),s(l,C,t),s(l,gl,t),s(l,b,t),s(l,Il,t),y(f,l,t),s(l,Al,t),s(l,Z,t),s(l,Cl,t),y(B,l,t),s(l,bl,t),s(l,x,t),s(l,fl,t),s(l,W,t),s(l,Zl,t),s(l,c,t),s(l,Bl,t),s(l,T,t),s(l,xl,t),y(q,l,t),s(l,Wl,t),s(l,E,t),s(l,ql,t),y(Q,l,t),s(l,El,t),s(l,G,t),s(l,Ql,t),y(R,l,t),s(l,Gl,t),s(l,V,t),s(l,Rl,t),y(N,l,t),s(l,Vl,t),y(k,l,t),s(l,Nl,t),s(l,v,t),s(l,kl,t),y(X,l,t),s(l,vl,t),s(l,_,t),s(l,Xl,t),y($,l,t),s(l,_l,t),s(l,H,t),s(l,$l,t),y(S,l,t),s(l,Hl,t),s(l,z,t),s(l,Sl,t),y(Y,l,t),s(l,zl,t),s(l,F,t),s(l,Yl,t),y(L,l,t),s(l,Fl,t),s(l,P,t),s(l,Ll,t),s(l,D,t),s(l,Pl,t),y(K,l,t),s(l,Dl,t),s(l,O,t),s(l,Kl,t),y(ll,l,t),s(l,Ol,t),y(tl,l,t),s(l,lt,t),s(l,el,t),s(l,tt,t),s(l,sl,t),s(l,et,t),y(al,l,t),s(l,st,t),s(l,nl,t),s(l,at,t),y(Ml,l,t),s(l,nt,t),s(l,il,t),s(l,Mt,t),y(ol,l,t),s(l,it,t),s(l,pl,t),s(l,ot,t),s(l,jl,t),s(l,pt,t),y(yl,l,t),s(l,jt,t),s(l,Ul,t),yt=!0},p:St,i(l){yt||(r(h.$$.fragment,l),r(w.$$.fragment,l),r(f.$$.fragment,l),r(B.$$.fragment,l),r(q.$$.fragment,l),r(Q.$$.fragment,l),r(R.$$.fragment,l),r(N.$$.fragment,l),r(k.$$.fragment,l),r(X.$$.fragment,l),r($.$$.fragment,l),r(S.$$.fragment,l),r(Y.$$.fragment,l),r(L.$$.fragment,l),r(K.$$.fragment,l),r(ll.$$.fragment,l),r(tl.$$.fragment,l),r(al.$$.fragment,l),r(Ml.$$.fragment,l),r(ol.$$.fragment,l),r(yl.$$.fragment,l),yt=!0)},o(l){U(h.$$.fragment,l),U(w.$$.fragment,l),U(f.$$.fragment,l),U(B.$$.fragment,l),U(q.$$.fragment,l),U(Q.$$.fragment,l),U(R.$$.fragment,l),U(N.$$.fragment,l),U(k.$$.fragment,l),U(X.$$.fragment,l),U($.$$.fragment,l),U(S.$$.fragment,l),U(Y.$$.fragment,l),U(L.$$.fragment,l),U(K.$$.fragment,l),U(ll.$$.fragment,l),U(tl.$$.fragment,l),U(al.$$.fragment,l),U(Ml.$$.fragment,l),U(ol.$$.fragment,l),U(yl.$$.fragment,l),yt=!1},d(l){l&&(e(ml),e(rl),e(Jl),e(ul),e(cl),e(d),e(Tl),e(g),e(hl),e(I),e(wl),e(A),e(dl),e(C),e(gl),e(b),e(Il),e(Al),e(Z),e(Cl),e(bl),e(x),e(fl),e(W),e(Zl),e(c),e(Bl),e(T),e(xl),e(Wl),e(E),e(ql),e(El),e(G),e(Ql),e(Gl),e(V),e(Rl),e(Vl),e(Nl),e(v),e(kl),e(vl),e(_),e(Xl),e(_l),e(H),e($l),e(Hl),e(z),e(Sl),e(zl),e(F),e(Yl),e(Fl),e(P),e(Ll),e(D),e(Pl),e(Dl),e(O),e(Kl),e(Ol),e(lt),e(el),e(tt),e(sl),e(et),e(st),e(nl),e(at),e(nt),e(il),e(Mt),e(it),e(pl),e(ot),e(jl),e(pt),e(jt),e(Ul)),e(u),m(h,l),m(w,l),m(f,l),m(B,l),m(q,l),m(Q,l),m(R,l),m(N,l),m(k,l),m(X,l),m($,l),m(S,l),m(Y,l),m(L,l),m(K,l),m(ll,l),m(tl,l),m(al,l),m(Ml,l),m(ol,l),m(yl,l)}}}const le='{"title":"Image-text-to-text","local":"image-text-to-text","sections":[{"title":"Pipeline","local":"pipeline","sections":[],"depth":2},{"title":"Fit models in smaller hardware","local":"fit-models-in-smaller-hardware","sections":[],"depth":2},{"title":"Further Reading","local":"further-reading","sections":[],"depth":2}],"depth":1}';function te(mt){return zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class oe extends Yt{constructor(u){super(),Ft(this,u,te,Ot,Ht,{})}}export{oe as component};
