import{s as $e,n as Se,o as Ye}from"../chunks/scheduler.18a86fab.js";import{S as Fe,i as Ae,g as o,s as a,r,A as Le,h as i,f as l,c as n,j as Ee,u as M,x as p,k as ve,y as qe,a as s,v as d,d as c,t as y,w as h}from"../chunks/index.98837b22.js";import{C as $}from"../chunks/CodeBlock.8d0c2e8a.js";import{D as Pe}from"../chunks/DocNotebookDropdown.a04a6b2a.js";import{H as De}from"../chunks/Heading.7e7e0c5b.js";import{E as Ke}from"../chunks/index.f01015d9.js";function Oe(be){let m,F,S,A,J,L,U,q,f,je="Video-text-to-text models, also known as video language models or vision language models with video input, are language models that take a video input. These models can tackle various tasks, from video question answering to video captioning.",P,T,ge='These models have nearly the same architecture as <a href="../image_text_to_text.md">image-text-to-text</a> models except for some changes to accept video data, since video data is essentially image frames with temporal dependencies. Some image-text-to-text models take in multiple images, but this alone is inadequate for a model to accept videos. Moreover, video-text-to-text models are often trained with all vision modalities. Each example might have videos, multiple videos, images and multiple images. Some of these models can also take interleaved inputs. For example, you can refer to a specific video inside a string of text by adding a video token in text like “What is happening in this video? <code>&lt;video&gt;</code>“.',D,v,Ce="In this guide, we provide a brief overview of video LMs and show how to use them with Transformers for inference.",K,b,Ze="To begin with, there are multiple types of video LMs:",O,j,Ie="<li>base models used for fine-tuning</li> <li>chat fine-tuned models for conversation</li> <li>instruction fine-tuned models</li>",ee,g,_e='This guide focuses on inference with an instruction-tuned model, <a href="https://huggingface.co/llava-hf/llava-interleave-qwen-7b-hf" rel="nofollow">llava-hf/llava-interleave-qwen-7b-hf</a> which can take in interleaved data. Alternatively, you can try <a href="https://huggingface.co/llava-hf/llava-interleave-qwen-0.5b-hf" rel="nofollow">llava-interleave-qwen-0.5b-hf</a> if your hardware doesn’t allow running a 7B model.',te,C,ke="Let’s begin installing the dependencies.",le,Z,se,I,Be="Let’s initialize the model and the processor.",ae,_,ne,k,xe="Some models directly consume the <code>&lt;video&gt;</code> token, and others accept <code>&lt;image&gt;</code> tokens equal to the number of sampled frames. This model handles videos in the latter fashion. We will write a simple utility to handle image tokens, and another utility to get a video from a url and sample frames from it.",oe,B,ie,x,Ge="Let’s get our inputs. We will sample frames and concatenate them.",pe,G,me,W,We="Both videos have cats.",re,u,Qe='<div class="video-container"><video width="400" controls=""><source src="https://huggingface.co/spaces/merve/llava-interleave/resolve/main/cats_1.mp4" type="video/mp4"/></video></div>',Me,w,Xe='<video width="400" controls=""><source src="https://huggingface.co/spaces/merve/llava-interleave/resolve/main/cats_2.mp4" type="video/mp4"/></video>',de,Q,He="Now we can preprocess the inputs.",ce,X,ze="This model has a prompt template that looks like following. First, we’ll put all the sampled frames into one list. Since we have eight frames in each video, we will insert 12 <code>&lt;image&gt;</code> tokens to our prompt. Add <code>assistant</code> at the end of the prompt to trigger the model to give answers. Then we can preprocess.",ye,H,he,z,Re='We can now call <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> for inference. The model outputs the question in our input and answer, so we only take the text after the prompt and <code>assistant</code> part from the model output.',ue,R,we,V,Ve="And voila!",Je,N,Ne='To learn more about chat templates and token streaming for video-text-to-text models, refer to the <a href="../tasks/image_text_to_text">image-text-to-text</a> task guide because these models work similarly.',Ue,E,fe,Y,Te;return J=new De({props:{title:"Video-text-to-text",local:"video-text-to-text",headingTag:"h1"}}),U=new Pe({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/video_text_to_text.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/video_text_to_text.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/video_text_to_text.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/video_text_to_text.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/video_text_to_text.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/video_text_to_text.ipynb"}]}}),Z=new $({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZSUyMGZsYXNoX2F0dG4lMjA=",highlighted:"pip install -q transformers accelerate flash_attn ",wrap:!1}}),_=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYXZhUHJvY2Vzc29yJTJDJTIwTGxhdmFGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEFpbXBvcnQlMjB0b3JjaCUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybGxhdmEtaGYlMkZsbGF2YS1pbnRlcmxlYXZlLXF3ZW4tMC41Yi1oZiUyMiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMExsYXZhUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMEFtb2RlbCUyMCUzRCUyMExsYXZhRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFtb2RlbC50byglMjJjdWRhJTIyKSUyMCUyMyUyMGNhbiUyMGFsc28lMjBiZSUyMHhwdSUyQyUyMG1wcyUyQyUyMG5wdSUyMGV0Yy4lMjBkZXBlbmRpbmclMjBvbiUyMHlvdXIlMjBoYXJkd2FyZSUyMGFjY2VsZXJhdG9y",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaProcessor, LlavaForConditionalGeneration
<span class="hljs-keyword">import</span> torch
model_id = <span class="hljs-string">&quot;llava-hf/llava-interleave-qwen-0.5b-hf&quot;</span>

processor = LlavaProcessor.from_pretrained(model_id)

model = LlavaForConditionalGeneration.from_pretrained(model_id, torch_dtype=torch.float16)
model.to(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-comment"># can also be xpu, mps, npu etc. depending on your hardware accelerator</span>`,wrap:!1}}),B=new $({props:{code:"aW1wb3J0JTIwdXVpZCUwQWltcG9ydCUyMHJlcXVlc3RzJTBBaW1wb3J0JTIwY3YyJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBJTBBZGVmJTIwcmVwbGFjZV92aWRlb193aXRoX2ltYWdlcyh0ZXh0JTJDJTIwZnJhbWVzKSUzQSUwQSUyMCUyMHJldHVybiUyMHRleHQucmVwbGFjZSglMjIlM0N2aWRlbyUzRSUyMiUyQyUyMCUyMiUzQ2ltYWdlJTNFJTIyJTIwKiUyMGZyYW1lcyklMEElMEFkZWYlMjBzYW1wbGVfZnJhbWVzKHVybCUyQyUyMG51bV9mcmFtZXMpJTNBJTBBJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQSUyMCUyMCUyMCUyMHBhdGhfaWQlMjAlM0QlMjBzdHIodXVpZC51dWlkNCgpKSUwQSUwQSUyMCUyMCUyMCUyMHBhdGglMjAlM0QlMjBmJTIyLiUyRiU3QnBhdGhfaWQlN0QubXA0JTIyJTIwJTBBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMG9wZW4ocGF0aCUyQyUyMCUyMndiJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMGYud3JpdGUocmVzcG9uc2UuY29udGVudCklMEElMEElMjAlMjAlMjAlMjB2aWRlbyUyMCUzRCUyMGN2Mi5WaWRlb0NhcHR1cmUocGF0aCklMEElMjAlMjAlMjAlMjB0b3RhbF9mcmFtZXMlMjAlM0QlMjBpbnQodmlkZW8uZ2V0KGN2Mi5DQVBfUFJPUF9GUkFNRV9DT1VOVCkpJTBBJTIwJTIwJTIwJTIwaW50ZXJ2YWwlMjAlM0QlMjB0b3RhbF9mcmFtZXMlMjAlMkYlMkYlMjBudW1fZnJhbWVzJTBBJTIwJTIwJTIwJTIwZnJhbWVzJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UodG90YWxfZnJhbWVzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldCUyQyUyMGZyYW1lJTIwJTNEJTIwdmlkZW8ucmVhZCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlsX2ltZyUyMCUzRCUyMEltYWdlLmZyb21hcnJheShjdjIuY3Z0Q29sb3IoZnJhbWUlMkMlMjBjdjIuQ09MT1JfQkdSMlJHQikpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBub3QlMjByZXQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb250aW51ZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwaSUyMCUyNSUyMGludGVydmFsJTIwJTNEJTNEJTIwMCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZyYW1lcy5hcHBlbmQocGlsX2ltZyklMEElMjAlMjAlMjAlMjB2aWRlby5yZWxlYXNlKCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBmcmFtZXMlNUIlM0FudW1fZnJhbWVzJTVE",highlighted:`<span class="hljs-keyword">import</span> uuid
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">def</span> <span class="hljs-title function_">replace_video_with_images</span>(<span class="hljs-params">text, frames</span>):
  <span class="hljs-keyword">return</span> text.replace(<span class="hljs-string">&quot;&lt;video&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;image&gt;&quot;</span> * frames)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">sample_frames</span>(<span class="hljs-params">url, num_frames</span>):

    response = requests.get(url)
    path_id = <span class="hljs-built_in">str</span>(uuid.uuid4())

    path = <span class="hljs-string">f&quot;./<span class="hljs-subst">{path_id}</span>.mp4&quot;</span> 

    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(path, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
      f.write(response.content)

    video = cv2.VideoCapture(path)
    total_frames = <span class="hljs-built_in">int</span>(video.get(cv2.CAP_PROP_FRAME_COUNT))
    interval = total_frames // num_frames
    frames = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(total_frames):
        ret, frame = video.read()
        pil_img = Image.fromarray(cv2.cvtColor(frame, cv2.COLOR_BGR2RGB))
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> ret:
            <span class="hljs-keyword">continue</span>
        <span class="hljs-keyword">if</span> i % interval == <span class="hljs-number">0</span>:
            frames.append(pil_img)
    video.release()
    <span class="hljs-keyword">return</span> frames[:num_frames]`,wrap:!1}}),G=new $({props:{code:"dmlkZW9fMSUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzcGFjZXMlMkZtZXJ2ZSUyRmxsYXZhLWludGVybGVhdmUlMkZyZXNvbHZlJTJGbWFpbiUyRmNhdHNfMS5tcDQlMjIlMEF2aWRlb18yJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnNwYWNlcyUyRm1lcnZlJTJGbGxhdmEtaW50ZXJsZWF2ZSUyRnJlc29sdmUlMkZtYWluJTJGY2F0c18yLm1wNCUyMiUwQSUwQXZpZGVvXzElMjAlM0QlMjBzYW1wbGVfZnJhbWVzKHZpZGVvXzElMkMlMjA2KSUwQXZpZGVvXzIlMjAlM0QlMjBzYW1wbGVfZnJhbWVzKHZpZGVvXzIlMkMlMjA2KSUwQSUwQXZpZGVvcyUyMCUzRCUyMHZpZGVvXzElMjAlMkIlMjB2aWRlb18yJTBBJTBBdmlkZW9zJTBBJTBBJTIzJTIwJTVCJTNDUElMLkltYWdlLkltYWdlJTIwaW1hZ2UlMjBtb2RlJTNEUkdCJTIwc2l6ZSUzRDE5MjB4MTA4MCUzRSUyQyUwQSUyMyUyMCUzQ1BJTC5JbWFnZS5JbWFnZSUyMGltYWdlJTIwbW9kZSUzRFJHQiUyMHNpemUlM0QxOTIweDEwODAlM0UlMkMlMEElMjMlMjAlM0NQSUwuSW1hZ2UuSW1hZ2UlMjBpbWFnZSUyMG1vZGUlM0RSR0IlMjBzaXplJTNEMTkyMHgxMDgwJTNFJTJDJTIwLi4uJTVE",highlighted:`video_1 = <span class="hljs-string">&quot;https://huggingface.co/spaces/merve/llava-interleave/resolve/main/cats_1.mp4&quot;</span>
video_2 = <span class="hljs-string">&quot;https://huggingface.co/spaces/merve/llava-interleave/resolve/main/cats_2.mp4&quot;</span>

video_1 = sample_frames(video_1, <span class="hljs-number">6</span>)
video_2 = sample_frames(video_2, <span class="hljs-number">6</span>)

videos = video_1 + video_2

videos

<span class="hljs-comment"># [&lt;PIL.Image.Image image mode=RGB size=1920x1080&gt;,</span>
<span class="hljs-comment"># &lt;PIL.Image.Image image mode=RGB size=1920x1080&gt;,</span>
<span class="hljs-comment"># &lt;PIL.Image.Image image mode=RGB size=1920x1080&gt;, ...]</span>`,wrap:!1}}),H=new $({props:{code:"dXNlcl9wcm9tcHQlMjAlM0QlMjAlMjJBcmUlMjB0aGVzZSUyMHR3byUyMGNhdHMlMjBpbiUyMHRoZXNlJTIwdHdvJTIwdmlkZW9zJTIwZG9pbmclMjB0aGUlMjBzYW1lJTIwdGhpbmclM0YlMjIlMEF0b2tzJTIwJTNEJTIwJTIyJTNDaW1hZ2UlM0UlMjIlMjAqJTIwMTIlMEFwcm9tcHQlMjAlM0QlMjAlMjIlM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMjIlMkIlMjB0b2tzJTIwJTJCJTIwZiUyMiU1Q24lN0J1c2VyX3Byb21wdCU3RCUzQyU3Q2ltX2VuZCU3QyUzRSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTIyJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0Rwcm9tcHQlMkMlMjBpbWFnZXMlM0R2aWRlb3MlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhtb2RlbC5kZXZpY2UlMkMlMjBtb2RlbC5kdHlwZSk=",highlighted:`user_prompt = <span class="hljs-string">&quot;Are these two cats in these two videos doing the same thing?&quot;</span>
toks = <span class="hljs-string">&quot;&lt;image&gt;&quot;</span> * <span class="hljs-number">12</span>
prompt = <span class="hljs-string">&quot;&lt;|im_start|&gt;user&quot;</span>+ toks + <span class="hljs-string">f&quot;\\n<span class="hljs-subst">{user_prompt}</span>&lt;|im_end|&gt;&lt;|im_start|&gt;assistant&quot;</span>
inputs = processor(text=prompt, images=videos, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device, model.dtype)`,wrap:!1}}),R=new $({props:{code:"b3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCUyQyUyMGRvX3NhbXBsZSUzREZhbHNlKSUwQXByaW50KHByb2Nlc3Nvci5kZWNvZGUob3V0cHV0JTVCMCU1RCU1QjIlM0ElNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUJsZW4odXNlcl9wcm9tcHQpJTJCMTAlM0ElNUQpJTBBJTBBJTIzJTIwVGhlJTIwZmlyc3QlMjBjYXQlMjBpcyUyMHNob3duJTIwaW4lMjBhJTIwcmVsYXhlZCUyMHN0YXRlJTJDJTIwd2l0aCUyMGl0cyUyMGV5ZXMlMjBjbG9zZWQlMjBhbmQlMjBhJTIwY29udGVudCUyMGV4cHJlc3Npb24lMkMlMjB3aGlsZSUyMHRoZSUyMHNlY29uZCUyMGNhdCUyMGlzJTIwc2hvd24lMjBpbiUyMGElMjBtb3JlJTIwYWN0aXZlJTIwc3RhdGUlMkMlMjB3aXRoJTIwaXRzJTIwbW91dGglMjBvcGVuJTIwd2lkZSUyQyUyMHBvc3NpYmx5JTIwaW4lMjBhJTIweWF3biUyMG9yJTIwYSUyMHZvY2FsaXphdGlvbi4lMEElMEE=",highlighted:`output = model.generate(**inputs, max_new_tokens=<span class="hljs-number">100</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-built_in">print</span>(processor.decode(output[<span class="hljs-number">0</span>][<span class="hljs-number">2</span>:], skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-built_in">len</span>(user_prompt)+<span class="hljs-number">10</span>:])

<span class="hljs-comment"># The first cat is shown in a relaxed state, with its eyes closed and a content expression, while the second cat is shown in a more active state, with its mouth open wide, possibly in a yawn or a vocalization.</span>

`,wrap:!1}}),E=new Ke({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/video_text_to_text.md"}}),{c(){m=o("meta"),F=a(),S=o("p"),A=a(),r(J.$$.fragment),L=a(),r(U.$$.fragment),q=a(),f=o("p"),f.textContent=je,P=a(),T=o("p"),T.innerHTML=ge,D=a(),v=o("p"),v.textContent=Ce,K=a(),b=o("p"),b.textContent=Ze,O=a(),j=o("ul"),j.innerHTML=Ie,ee=a(),g=o("p"),g.innerHTML=_e,te=a(),C=o("p"),C.textContent=ke,le=a(),r(Z.$$.fragment),se=a(),I=o("p"),I.textContent=Be,ae=a(),r(_.$$.fragment),ne=a(),k=o("p"),k.innerHTML=xe,oe=a(),r(B.$$.fragment),ie=a(),x=o("p"),x.textContent=Ge,pe=a(),r(G.$$.fragment),me=a(),W=o("p"),W.textContent=We,re=a(),u=o("div"),u.innerHTML=Qe,Me=a(),w=o("div"),w.innerHTML=Xe,de=a(),Q=o("p"),Q.textContent=He,ce=a(),X=o("p"),X.innerHTML=ze,ye=a(),r(H.$$.fragment),he=a(),z=o("p"),z.innerHTML=Re,ue=a(),r(R.$$.fragment),we=a(),V=o("p"),V.textContent=Ve,Je=a(),N=o("p"),N.innerHTML=Ne,Ue=a(),r(E.$$.fragment),fe=a(),Y=o("p"),this.h()},l(e){const t=Le("svelte-u9bgzb",document.head);m=i(t,"META",{name:!0,content:!0}),t.forEach(l),F=n(e),S=i(e,"P",{}),Ee(S).forEach(l),A=n(e),M(J.$$.fragment,e),L=n(e),M(U.$$.fragment,e),q=n(e),f=i(e,"P",{"data-svelte-h":!0}),p(f)!=="svelte-lima51"&&(f.textContent=je),P=n(e),T=i(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1vltrkp"&&(T.innerHTML=ge),D=n(e),v=i(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-srvvgy"&&(v.textContent=Ce),K=n(e),b=i(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-jc4sjd"&&(b.textContent=Ze),O=n(e),j=i(e,"UL",{"data-svelte-h":!0}),p(j)!=="svelte-1vpzkb0"&&(j.innerHTML=Ie),ee=n(e),g=i(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-1ds11b0"&&(g.innerHTML=_e),te=n(e),C=i(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-5jp6fp"&&(C.textContent=ke),le=n(e),M(Z.$$.fragment,e),se=n(e),I=i(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1a1j2kh"&&(I.textContent=Be),ae=n(e),M(_.$$.fragment,e),ne=n(e),k=i(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1jecxg9"&&(k.innerHTML=xe),oe=n(e),M(B.$$.fragment,e),ie=n(e),x=i(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1cbhwz2"&&(x.textContent=Ge),pe=n(e),M(G.$$.fragment,e),me=n(e),W=i(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1wvt5vc"&&(W.textContent=We),re=n(e),u=i(e,"DIV",{class:!0,"data-svelte-h":!0}),p(u)!=="svelte-1a6pc9g"&&(u.innerHTML=Qe),Me=n(e),w=i(e,"DIV",{class:!0,"data-svelte-h":!0}),p(w)!=="svelte-1jly6uy"&&(w.innerHTML=Xe),de=n(e),Q=i(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1y3zqy2"&&(Q.textContent=He),ce=n(e),X=i(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-sdf91z"&&(X.innerHTML=ze),ye=n(e),M(H.$$.fragment,e),he=n(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-xm2r0y"&&(z.innerHTML=Re),ue=n(e),M(R.$$.fragment,e),we=n(e),V=i(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1ui1acl"&&(V.textContent=Ve),Je=n(e),N=i(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-8rrqam"&&(N.innerHTML=Ne),Ue=n(e),M(E.$$.fragment,e),fe=n(e),Y=i(e,"P",{}),Ee(Y).forEach(l),this.h()},h(){ve(m,"name","hf:doc:metadata"),ve(m,"content",et),ve(u,"class","container"),ve(w,"class","video-container")},m(e,t){qe(document.head,m),s(e,F,t),s(e,S,t),s(e,A,t),d(J,e,t),s(e,L,t),d(U,e,t),s(e,q,t),s(e,f,t),s(e,P,t),s(e,T,t),s(e,D,t),s(e,v,t),s(e,K,t),s(e,b,t),s(e,O,t),s(e,j,t),s(e,ee,t),s(e,g,t),s(e,te,t),s(e,C,t),s(e,le,t),d(Z,e,t),s(e,se,t),s(e,I,t),s(e,ae,t),d(_,e,t),s(e,ne,t),s(e,k,t),s(e,oe,t),d(B,e,t),s(e,ie,t),s(e,x,t),s(e,pe,t),d(G,e,t),s(e,me,t),s(e,W,t),s(e,re,t),s(e,u,t),s(e,Me,t),s(e,w,t),s(e,de,t),s(e,Q,t),s(e,ce,t),s(e,X,t),s(e,ye,t),d(H,e,t),s(e,he,t),s(e,z,t),s(e,ue,t),d(R,e,t),s(e,we,t),s(e,V,t),s(e,Je,t),s(e,N,t),s(e,Ue,t),d(E,e,t),s(e,fe,t),s(e,Y,t),Te=!0},p:Se,i(e){Te||(c(J.$$.fragment,e),c(U.$$.fragment,e),c(Z.$$.fragment,e),c(_.$$.fragment,e),c(B.$$.fragment,e),c(G.$$.fragment,e),c(H.$$.fragment,e),c(R.$$.fragment,e),c(E.$$.fragment,e),Te=!0)},o(e){y(J.$$.fragment,e),y(U.$$.fragment,e),y(Z.$$.fragment,e),y(_.$$.fragment,e),y(B.$$.fragment,e),y(G.$$.fragment,e),y(H.$$.fragment,e),y(R.$$.fragment,e),y(E.$$.fragment,e),Te=!1},d(e){e&&(l(F),l(S),l(A),l(L),l(q),l(f),l(P),l(T),l(D),l(v),l(K),l(b),l(O),l(j),l(ee),l(g),l(te),l(C),l(le),l(se),l(I),l(ae),l(ne),l(k),l(oe),l(ie),l(x),l(pe),l(me),l(W),l(re),l(u),l(Me),l(w),l(de),l(Q),l(ce),l(X),l(ye),l(he),l(z),l(ue),l(we),l(V),l(Je),l(N),l(Ue),l(fe),l(Y)),l(m),h(J,e),h(U,e),h(Z,e),h(_,e),h(B,e),h(G,e),h(H,e),h(R,e),h(E,e)}}}const et='{"title":"Video-text-to-text","local":"video-text-to-text","sections":[],"depth":1}';function tt(be){return Ye(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pt extends Fe{constructor(m){super(),Ae(this,m,tt,Oe,$e,{})}}export{pt as component};
