import{s as Ao,o as Oo,n as P}from"../chunks/scheduler.18a86fab.js";import{S as Do,i as Ko,g as c,s as r,r as u,A as en,h as p,f as s,c as i,j,u as h,x as y,k as B,y as m,a,v as f,d as g,t as _,w as b}from"../chunks/index.98837b22.js";import{T as Lt}from"../chunks/Tip.77304350.js";import{D as V}from"../chunks/Docstring.6758ea23.js";import{C as Le}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as at}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as S}from"../chunks/Heading.7e7e0c5b.js";import{E as tn}from"../chunks/index.f01015d9.js";function on(v){let n,M="Example:",l,d,T;return d=new Le({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpb0dwdE1vZGVsJTJDJTIwQmlvR3B0Q29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMEJpb0dQVCUyMG1pY3Jvc29mdCUyRmJpb2dwdCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBCaW9HcHRDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBtaWNyb3NvZnQlMkZiaW9ncHQlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMEJpb0dwdE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BioGptModel, BioGptConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a BioGPT microsoft/biogpt style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = BioGptConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the microsoft/biogpt style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BioGptModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){n=c("p"),n.textContent=M,l=r(),u(d.$$.fragment)},l(t){n=p(t,"P",{"data-svelte-h":!0}),y(n)!=="svelte-11lpom8"&&(n.textContent=M),l=i(t),h(d.$$.fragment,t)},m(t,k){a(t,n,k),a(t,l,k),f(d,t,k),T=!0},p:P,i(t){T||(g(d.$$.fragment,t),T=!0)},o(t){_(d.$$.fragment,t),T=!1},d(t){t&&(s(n),s(l)),b(d,t)}}}function nn(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=c("p"),n.innerHTML=M},l(l){n=p(l,"P",{"data-svelte-h":!0}),y(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(l,d){a(l,n,d)},p:P,d(l){l&&s(n)}}}function sn(v){let n,M="Example:",l,d,T;return d=new Le({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBCaW9HcHRNb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmlvZ3B0JTIyKSUwQW1vZGVsJTIwJTNEJTIwQmlvR3B0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRmJpb2dwdCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, BioGptModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/biogpt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BioGptModel.from_pretrained(<span class="hljs-string">&quot;microsoft/biogpt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){n=c("p"),n.textContent=M,l=r(),u(d.$$.fragment)},l(t){n=p(t,"P",{"data-svelte-h":!0}),y(n)!=="svelte-11lpom8"&&(n.textContent=M),l=i(t),h(d.$$.fragment,t)},m(t,k){a(t,n,k),a(t,l,k),f(d,t,k),T=!0},p:P,i(t){T||(g(d.$$.fragment,t),T=!0)},o(t){_(d.$$.fragment,t),T=!1},d(t){t&&(s(n),s(l)),b(d,t)}}}function an(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=c("p"),n.innerHTML=M},l(l){n=p(l,"P",{"data-svelte-h":!0}),y(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(l,d){a(l,n,d)},p:P,d(l){l&&s(n)}}}function rn(v){let n,M="Example:",l,d,T;return d=new Le({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEJpb0dwdEZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmlvZ3B0JTIyKSUwQW1vZGVsJTIwJTNEJTIwQmlvR3B0Rm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRmJpb2dwdCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwbGFiZWxzJTNEaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, BioGptForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/biogpt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BioGptForCausalLM.from_pretrained(<span class="hljs-string">&quot;microsoft/biogpt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=c("p"),n.textContent=M,l=r(),u(d.$$.fragment)},l(t){n=p(t,"P",{"data-svelte-h":!0}),y(n)!=="svelte-11lpom8"&&(n.textContent=M),l=i(t),h(d.$$.fragment,t)},m(t,k){a(t,n,k),a(t,l,k),f(d,t,k),T=!0},p:P,i(t){T||(g(d.$$.fragment,t),T=!0)},o(t){_(d.$$.fragment,t),T=!1},d(t){t&&(s(n),s(l)),b(d,t)}}}function dn(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=c("p"),n.innerHTML=M},l(l){n=p(l,"P",{"data-svelte-h":!0}),y(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(l,d){a(l,n,d)},p:P,d(l){l&&s(n)}}}function ln(v){let n,M="Example:",l,d,T;return d=new Le({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBCaW9HcHRGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiaW9ncHQlMjIpJTBBbW9kZWwlMjAlM0QlMjBCaW9HcHRGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiaW9ncHQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCUyMkh1Z2dpbmdGYWNlJTIwaXMlMjBhJTIwY29tcGFueSUyMGJhc2VkJTIwaW4lMjBQYXJpcyUyMGFuZCUyME5ldyUyMFlvcmslMjIlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfdG9rZW5fY2xhc3NfaWRzJTIwJTNEJTIwbG9naXRzLmFyZ21heCgtMSklMEElMEElMjMlMjBOb3RlJTIwdGhhdCUyMHRva2VucyUyMGFyZSUyMGNsYXNzaWZpZWQlMjByYXRoZXIlMjB0aGVuJTIwaW5wdXQlMjB3b3JkcyUyMHdoaWNoJTIwbWVhbnMlMjB0aGF0JTBBJTIzJTIwdGhlcmUlMjBtaWdodCUyMGJlJTIwbW9yZSUyMHByZWRpY3RlZCUyMHRva2VuJTIwY2xhc3NlcyUyMHRoYW4lMjB3b3Jkcy4lMEElMjMlMjBNdWx0aXBsZSUyMHRva2VuJTIwY2xhc3NlcyUyMG1pZ2h0JTIwYWNjb3VudCUyMGZvciUyMHRoZSUyMHNhbWUlMjB3b3JkJTBBcHJlZGljdGVkX3Rva2Vuc19jbGFzc2VzJTIwJTNEJTIwJTVCbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCdC5pdGVtKCklNUQlMjBmb3IlMjB0JTIwaW4lMjBwcmVkaWN0ZWRfdG9rZW5fY2xhc3NfaWRzJTVCMCU1RCU1RCUwQSUwQWxhYmVscyUyMCUzRCUyMHByZWRpY3RlZF90b2tlbl9jbGFzc19pZHMlMEFsb3NzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpLmxvc3M=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, BioGptForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/biogpt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BioGptForTokenClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/biogpt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;HuggingFace is a company based in Paris and New York&quot;</span>, add_special_tokens=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_class_ids = logits.argmax(-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that tokens are classified rather then input words which means that</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># there might be more predicted token classes than words.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Multiple token classes might account for the same word</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_tokens_classes = [model.config.id2label[t.item()] <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> predicted_token_class_ids[<span class="hljs-number">0</span>]]

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = predicted_token_class_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){n=c("p"),n.textContent=M,l=r(),u(d.$$.fragment)},l(t){n=p(t,"P",{"data-svelte-h":!0}),y(n)!=="svelte-11lpom8"&&(n.textContent=M),l=i(t),h(d.$$.fragment,t)},m(t,k){a(t,n,k),a(t,l,k),f(d,t,k),T=!0},p:P,i(t){T||(g(d.$$.fragment,t),T=!0)},o(t){_(d.$$.fragment,t),T=!1},d(t){t&&(s(n),s(l)),b(d,t)}}}function cn(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=c("p"),n.innerHTML=M},l(l){n=p(l,"P",{"data-svelte-h":!0}),y(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(l,d){a(l,n,d)},p:P,d(l){l&&s(n)}}}function pn(v){let n,M="Example of single-label classification:",l,d,T;return d=new Le({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEJpb0dwdEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiaW9ncHQlMjIpJTBBbW9kZWwlMjAlM0QlMjBCaW9HcHRGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiaW9ncHQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkJTIwJTNEJTIwbG9naXRzLmFyZ21heCgpLml0ZW0oKSUwQSUwQSUyMyUyMFRvJTIwdHJhaW4lMjBhJTIwbW9kZWwlMjBvbiUyMCU2MG51bV9sYWJlbHMlNjAlMjBjbGFzc2VzJTJDJTIweW91JTIwY2FuJTIwcGFzcyUyMCU2MG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTYwJTIwdG8lMjAlNjAuZnJvbV9wcmV0cmFpbmVkKC4uLiklNjAlMEFudW1fbGFiZWxzJTIwJTNEJTIwbGVuKG1vZGVsLmNvbmZpZy5pZDJsYWJlbCklMEFtb2RlbCUyMCUzRCUyMEJpb0dwdEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRmJpb2dwdCUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxJTVEKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, BioGptForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/biogpt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BioGptForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/biogpt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BioGptForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/biogpt&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){n=c("p"),n.textContent=M,l=r(),u(d.$$.fragment)},l(t){n=p(t,"P",{"data-svelte-h":!0}),y(n)!=="svelte-ykxpe4"&&(n.textContent=M),l=i(t),h(d.$$.fragment,t)},m(t,k){a(t,n,k),a(t,l,k),f(d,t,k),T=!0},p:P,i(t){T||(g(d.$$.fragment,t),T=!0)},o(t){_(d.$$.fragment,t),T=!1},d(t){t&&(s(n),s(l)),b(d,t)}}}function mn(v){let n,M="Example of multi-label classification:",l,d,T;return d=new Le({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEJpb0dwdEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiaW9ncHQlMjIpJTBBbW9kZWwlMjAlM0QlMjBCaW9HcHRGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiaW9ncHQlMjIlMkMlMjBwcm9ibGVtX3R5cGUlM0QlMjJtdWx0aV9sYWJlbF9jbGFzc2lmaWNhdGlvbiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfY2xhc3NfaWRzJTIwJTNEJTIwdG9yY2guYXJhbmdlKDAlMkMlMjBsb2dpdHMuc2hhcGUlNUItMSU1RCklNUJ0b3JjaC5zaWdtb2lkKGxvZ2l0cykuc3F1ZWV6ZShkaW0lM0QwKSUyMCUzRSUyMDAuNSU1RCUwQSUwQSUyMyUyMFRvJTIwdHJhaW4lMjBhJTIwbW9kZWwlMjBvbiUyMCU2MG51bV9sYWJlbHMlNjAlMjBjbGFzc2VzJTJDJTIweW91JTIwY2FuJTIwcGFzcyUyMCU2MG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTYwJTIwdG8lMjAlNjAuZnJvbV9wcmV0cmFpbmVkKC4uLiklNjAlMEFudW1fbGFiZWxzJTIwJTNEJTIwbGVuKG1vZGVsLmNvbmZpZy5pZDJsYWJlbCklMEFtb2RlbCUyMCUzRCUyMEJpb0dwdEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMm1pY3Jvc29mdCUyRmJpb2dwdCUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIlMEEpJTBBJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2guc3VtKCUwQSUyMCUyMCUyMCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwub25lX2hvdChwcmVkaWN0ZWRfY2xhc3NfaWRzJTVCTm9uZSUyQyUyMCUzQSU1RC5jbG9uZSgpJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fbGFiZWxzKSUyQyUyMGRpbSUzRDElMEEpLnRvKHRvcmNoLmZsb2F0KSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, BioGptForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/biogpt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BioGptForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/biogpt&quot;</span>, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.arange(<span class="hljs-number">0</span>, logits.shape[-<span class="hljs-number">1</span>])[torch.sigmoid(logits).squeeze(dim=<span class="hljs-number">0</span>) &gt; <span class="hljs-number">0.5</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BioGptForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;microsoft/biogpt&quot;</span>, num_labels=num_labels, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.<span class="hljs-built_in">sum</span>(
<span class="hljs-meta">... </span>    torch.nn.functional.one_hot(predicted_class_ids[<span class="hljs-literal">None</span>, :].clone(), num_classes=num_labels), dim=<span class="hljs-number">1</span>
<span class="hljs-meta">... </span>).to(torch.<span class="hljs-built_in">float</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){n=c("p"),n.textContent=M,l=r(),u(d.$$.fragment)},l(t){n=p(t,"P",{"data-svelte-h":!0}),y(n)!=="svelte-1l8e32d"&&(n.textContent=M),l=i(t),h(d.$$.fragment,t)},m(t,k){a(t,n,k),a(t,l,k),f(d,t,k),T=!0},p:P,i(t){T||(g(d.$$.fragment,t),T=!0)},o(t){_(d.$$.fragment,t),T=!1},d(t){t&&(s(n),s(l)),b(d,t)}}}function un(v){let n,M,l,d,T,t,k,To='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',dt,ae,lt,re,Mo='The BioGPT model was proposed in <a href="https://academic.oup.com/bib/advance-article/doi/10.1093/bib/bbac409/6713511?guestAccessKey=a66d9b5d-4f83-4017-bb52-405815c907b9" rel="nofollow">BioGPT: generative pre-trained transformer for biomedical text generation and mining</a> by Renqian Luo, Liai Sun, Yingce Xia, Tao Qin, Sheng Zhang, Hoifung Poon and Tie-Yan Liu. BioGPT is a domain-specific generative pre-trained Transformer language model for biomedical text generation and mining. BioGPT follows the Transformer language model backbone, and is pre-trained on 15M PubMed abstracts from scratch.',ct,ie,ko="The abstract from the paper is the following:",pt,de,vo="<em>Pre-trained language models have attracted increasing attention in the biomedical domain, inspired by their great success in the general natural language domain. Among the two main branches of pre-trained language models in the general language domain, i.e. BERT (and its variants) and GPT (and its variants), the first one has been extensively studied in the biomedical domain, such as BioBERT and PubMedBERT. While they have achieved great success on a variety of discriminative downstream biomedical tasks, the lack of generation ability constrains their application scope. In this paper, we propose BioGPT, a domain-specific generative Transformer language model pre-trained on large-scale biomedical literature. We evaluate BioGPT on six biomedical natural language processing tasks and demonstrate that our model outperforms previous models on most tasks. Especially, we get 44.98%, 38.42% and 40.76% F1 score on BC5CDR, KD-DTI and DDI end-to-end relation extraction tasks, respectively, and 78.2% accuracy on PubMedQA, creating a new record. Our case study on text generation further demonstrates the advantage of BioGPT on biomedical literature to generate fluent descriptions for biomedical terms.</em>",mt,le,wo='This model was contributed by <a href="https://huggingface.co/kamalkraj" rel="nofollow">kamalkraj</a>. The original code can be found <a href="https://github.com/microsoft/BioGPT" rel="nofollow">here</a>.',ut,ce,ht,pe,$o="<li>BioGPT is a model with absolute position embeddings so it’s usually advised to pad the inputs on the right rather than the left.</li> <li>BioGPT was trained with a causal language modeling (CLM) objective and is therefore powerful at predicting the next token in a sequence. Leveraging this feature allows BioGPT to generate syntactically coherent text as it can be observed in the run_generation.py example script.</li> <li>The model can take the <code>past_key_values</code> (for PyTorch) as input, which is the previously computed key/value attention pairs. Using this (past_key_values or past) value prevents the model from re-computing pre-computed values in the context of text generation. For PyTorch, see past_key_values argument of the BioGptForCausalLM.forward() method for more information on its usage.</li>",ft,me,gt,ue,Co=`PyTorch includes a native scaled dot-product attention (SDPA) operator as part of <code>torch.nn.functional</code>. This function
encompasses several implementations that can be applied depending on the inputs and the hardware in use. See the
<a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">official documentation</a>
or the <a href="https://huggingface.co/docs/transformers/main/en/perf_infer_gpu_one#pytorch-scaled-dot-product-attention" rel="nofollow">GPU Inference</a>
page for more information.`,_t,he,Bo=`SDPA is used by default for <code>torch&gt;=2.1.1</code> when an implementation is available, but you may also set
<code>attn_implementation=&quot;sdpa&quot;</code> in <code>from_pretrained()</code> to explicitly request SDPA to be used.`,bt,fe,yt,ge,Go=`On a local benchmark (NVIDIA GeForce RTX 2060-8GB, PyTorch 2.3.1, OS Ubuntu 20.04) with <code>float16</code> and <code>microsoft/biogpt</code> model with a CausalLM head,
we saw the following speedups during training.`,Tt,_e,xo="For the best speedups, we recommend loading the model in half-precision (e.g. <code>torch.float16</code> or <code>torch.bfloat16</code>).",Mt,be,Jo="<thead><tr><th>num_training_steps</th> <th>batch_size</th> <th>seq_len</th> <th>is cuda</th> <th>Time per batch (eager - s)</th> <th>Time per batch (sdpa - s)</th> <th>Speedup (%)</th> <th>Eager peak mem (MB)</th> <th>sdpa peak mem (MB)</th> <th>Mem saving (%)</th></tr></thead> <tbody><tr><td>100</td> <td>1</td> <td>128</td> <td>False</td> <td>0.038</td> <td>0.031</td> <td>21.301</td> <td>1601.862</td> <td>1601.497</td> <td>0.023</td></tr> <tr><td>100</td> <td>1</td> <td>256</td> <td>False</td> <td>0.039</td> <td>0.034</td> <td>15.084</td> <td>1624.944</td> <td>1625.296</td> <td>-0.022</td></tr> <tr><td>100</td> <td>2</td> <td>128</td> <td>False</td> <td>0.039</td> <td>0.033</td> <td>16.820</td> <td>1624.567</td> <td>1625.296</td> <td>-0.045</td></tr> <tr><td>100</td> <td>2</td> <td>256</td> <td>False</td> <td>0.065</td> <td>0.059</td> <td>10.255</td> <td>1672.164</td> <td>1672.164</td> <td>0.000</td></tr> <tr><td>100</td> <td>4</td> <td>128</td> <td>False</td> <td>0.062</td> <td>0.058</td> <td>6.998</td> <td>1671.435</td> <td>1672.164</td> <td>-0.044</td></tr> <tr><td>100</td> <td>4</td> <td>256</td> <td>False</td> <td>0.113</td> <td>0.100</td> <td>13.316</td> <td>2350.179</td> <td>1848.435</td> <td>27.144</td></tr> <tr><td>100</td> <td>8</td> <td>128</td> <td>False</td> <td>0.107</td> <td>0.098</td> <td>9.883</td> <td>2098.521</td> <td>1848.435</td> <td>13.530</td></tr> <tr><td>100</td> <td>8</td> <td>256</td> <td>False</td> <td>0.222</td> <td>0.196</td> <td>13.413</td> <td>3989.980</td> <td>2986.492</td> <td>33.601</td></tr></tbody>",kt,ye,jo=`On a local benchmark (NVIDIA GeForce RTX 2060-8GB, PyTorch 2.3.1, OS Ubuntu 20.04) with <code>float16</code> and <code>microsoft/biogpt</code> model with a simple AutoModel head,
we saw the following speedups during inference.`,vt,Te,zo="<thead><tr><th>num_batches</th> <th>batch_size</th> <th>seq_len</th> <th>is cuda</th> <th>is half</th> <th>use mask</th> <th>Per token latency eager (ms)</th> <th>Per token latency SDPA (ms)</th> <th>Speedup (%)</th> <th>Mem eager (MB)</th> <th>Mem BT (MB)</th> <th>Mem saved (%)</th></tr></thead> <tbody><tr><td>50</td> <td>1</td> <td>64</td> <td>True</td> <td>True</td> <td>True</td> <td>0.115</td> <td>0.098</td> <td>17.392</td> <td>716.998</td> <td>716.998</td> <td>0.000</td></tr> <tr><td>50</td> <td>1</td> <td>128</td> <td>True</td> <td>True</td> <td>True</td> <td>0.115</td> <td>0.093</td> <td>24.640</td> <td>730.916</td> <td>730.916</td> <td>0.000</td></tr> <tr><td>50</td> <td>2</td> <td>64</td> <td>True</td> <td>True</td> <td>True</td> <td>0.114</td> <td>0.096</td> <td>19.204</td> <td>730.900</td> <td>730.900</td> <td>0.000</td></tr> <tr><td>50</td> <td>2</td> <td>128</td> <td>True</td> <td>True</td> <td>True</td> <td>0.117</td> <td>0.095</td> <td>23.529</td> <td>759.262</td> <td>759.262</td> <td>0.000</td></tr> <tr><td>50</td> <td>4</td> <td>64</td> <td>True</td> <td>True</td> <td>True</td> <td>0.113</td> <td>0.096</td> <td>18.325</td> <td>759.229</td> <td>759.229</td> <td>0.000</td></tr> <tr><td>50</td> <td>4</td> <td>128</td> <td>True</td> <td>True</td> <td>True</td> <td>0.186</td> <td>0.178</td> <td>4.289</td> <td>816.478</td> <td>816.478</td> <td>0.000</td></tr></tbody>",wt,Me,$t,ke,Fo='<li><a href="../tasks/language_modeling">Causal language modeling task guide</a></li>',Ct,ve,Bt,G,we,Rt,Re,Uo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptModel">BioGptModel</a>. It is used to instantiate an
BioGPT model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the BioGPT
<a href="https://huggingface.co/microsoft/biogpt" rel="nofollow">microsoft/biogpt</a> architecture.`,Vt,Ve,Wo=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,St,Y,Gt,$e,xt,x,Ce,Et,Se,qo="Construct an FAIRSEQ Transformer tokenizer. Moses tokenization followed by Byte-Pair Encoding.",Pt,Ee,Zo=`This tokenizer inherits from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`,Qt,Pe,Be,Jt,Ge,jt,W,xe,Xt,Qe,Io=`The bare BioGPT Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Yt,z,Je,At,Xe,Ho='The <a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptModel">BioGptModel</a> forward method, overrides the <code>__call__</code> special method.',Ot,A,Dt,O,zt,je,Ft,q,ze,Kt,Ye,No=`BioGPT Model with a <code>language modeling</code> head on top for CLM fine-tuning.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,eo,F,Fe,to,Ae,Lo='The <a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptForCausalLM">BioGptForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',oo,D,no,K,Ut,Ue,Wt,J,We,so,Oe,Ro=`BioGPT Model with a token classification head on top (a linear layer on top of the hidden-states output) e.g. for
Named-Entity-Recognition (NER) tasks.`,ao,De,Vo=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,ro,U,qe,io,Ke,So='The <a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptForTokenClassification">BioGptForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',lo,ee,co,te,qt,Ze,Zt,w,Ie,po,et,Eo="The BioGpt Model transformer with a sequence classification head on top (linear layer).",mo,tt,Po=`<a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptForSequenceClassification">BioGptForSequenceClassification</a> uses the last token in order to do the classification, as other causal models
(e.g. GPT-2) do.`,uo,ot,Qo=`Since it does classification on the last token, it is required to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,ho,nt,Xo=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,fo,C,He,go,st,Yo='The <a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptForSequenceClassification">BioGptForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',_o,oe,bo,ne,yo,se,It,Ne,Ht,rt,Nt;return T=new S({props:{title:"BioGPT",local:"biogpt",headingTag:"h1"}}),ae=new S({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ce=new S({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),me=new S({props:{title:"Using Scaled Dot Product Attention (SDPA)",local:"using-scaled-dot-product-attention-sdpa",headingTag:"h3"}}),fe=new Le({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpb0dwdEZvckNhdXNhbExNJTBBbW9kZWwlMjAlM0QlMjBCaW9HcHRGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmlvZ3B0JTIyJTJDJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMnNkcGElMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYp",highlighted:`from transformers import BioGptForCausalLM
model = <span class="hljs-module-access"><span class="hljs-module"><span class="hljs-identifier">BioGptForCausalLM</span>.</span></span>from<span class="hljs-constructor">_pretrained(<span class="hljs-string">&quot;microsoft/biogpt&quot;</span>, <span class="hljs-params">attn_implementation</span>=<span class="hljs-string">&quot;sdpa&quot;</span>, <span class="hljs-params">torch_dtype</span>=<span class="hljs-params">torch</span>.<span class="hljs-params">float16</span>)</span>`,wrap:!1}}),Me=new S({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ve=new S({props:{title:"BioGptConfig",local:"transformers.BioGptConfig",headingTag:"h2"}}),we=new V({props:{name:"class transformers.BioGptConfig",anchor:"transformers.BioGptConfig",parameters:[{name:"vocab_size",val:" = 42384"},{name:"hidden_size",val:" = 1024"},{name:"num_hidden_layers",val:" = 24"},{name:"num_attention_heads",val:" = 16"},{name:"intermediate_size",val:" = 4096"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.1"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"max_position_embeddings",val:" = 1024"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"scale_embedding",val:" = True"},{name:"use_cache",val:" = True"},{name:"layerdrop",val:" = 0.0"},{name:"activation_dropout",val:" = 0.0"},{name:"pad_token_id",val:" = 1"},{name:"bos_token_id",val:" = 0"},{name:"eos_token_id",val:" = 2"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BioGptConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 42384) &#x2014;
Vocabulary size of the BioGPT model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptModel">BioGptModel</a>.`,name:"vocab_size"},{anchor:"transformers.BioGptConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimension of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.BioGptConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.BioGptConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.BioGptConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.BioGptConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.BioGptConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.BioGptConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.BioGptConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.BioGptConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.BioGptConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.BioGptConfig.scale_embedding",description:`<strong>scale_embedding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Scale embeddings by diving by sqrt(d_model).`,name:"scale_embedding"},{anchor:"transformers.BioGptConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.BioGptConfig.layerdrop",description:`<strong>layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Please refer to the paper about LayerDrop: <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a> for further details`,name:"layerdrop"},{anchor:"transformers.BioGptConfig.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.BioGptConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.BioGptConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Beginning of stream token id.`,name:"bos_token_id"},{anchor:"transformers.BioGptConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
End of stream token id.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/biogpt/configuration_biogpt.py#L24"}}),Y=new at({props:{anchor:"transformers.BioGptConfig.example",$$slots:{default:[on]},$$scope:{ctx:v}}}),$e=new S({props:{title:"BioGptTokenizer",local:"transformers.BioGptTokenizer",headingTag:"h2"}}),Ce=new V({props:{name:"class transformers.BioGptTokenizer",anchor:"transformers.BioGptTokenizer",parameters:[{name:"vocab_file",val:""},{name:"merges_file",val:""},{name:"unk_token",val:" = '<unk>'"},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"sep_token",val:" = '</s>'"},{name:"pad_token",val:" = '<pad>'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BioGptTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.BioGptTokenizer.merges_file",description:`<strong>merges_file</strong> (<code>str</code>) &#x2014;
Merges file.`,name:"merges_file"},{anchor:"transformers.BioGptTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.BioGptTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the beginning of
sequence. The token used is the <code>cls_token</code>.</p>

					</div>`,name:"bos_token"},{anchor:"transformers.BioGptTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.BioGptTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.BioGptTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/biogpt/tokenization_biogpt.py#L46"}}),Be=new V({props:{name:"save_vocabulary",anchor:"transformers.BioGptTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/biogpt/tokenization_biogpt.py#L314"}}),Ge=new S({props:{title:"BioGptModel",local:"transformers.BioGptModel",headingTag:"h2"}}),xe=new V({props:{name:"class transformers.BioGptModel",anchor:"transformers.BioGptModel",parameters:[{name:"config",val:": BioGptConfig"}],parametersDescription:[{anchor:"transformers.BioGptModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptConfig">~BioGptConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/biogpt/modeling_biogpt.py#L541"}}),Je=new V({props:{name:"forward",anchor:"transformers.BioGptModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BioGptModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BioGptModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.BioGptModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.BioGptModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.BioGptModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.BioGptModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation.
This is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors
than the model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.BioGptModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.BioGptModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.BioGptModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BioGptModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/biogpt/modeling_biogpt.py#L574",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptConfig"
>BioGptConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),A=new Lt({props:{$$slots:{default:[nn]},$$scope:{ctx:v}}}),O=new at({props:{anchor:"transformers.BioGptModel.forward.example",$$slots:{default:[sn]},$$scope:{ctx:v}}}),je=new S({props:{title:"BioGptForCausalLM",local:"transformers.BioGptForCausalLM",headingTag:"h2"}}),ze=new V({props:{name:"class transformers.BioGptForCausalLM",anchor:"transformers.BioGptForCausalLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.BioGptForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptConfig">~BioGptConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/biogpt/modeling_biogpt.py#L722"}}),Fe=new V({props:{name:"forward",anchor:"transformers.BioGptForCausalLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BioGptForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BioGptForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.BioGptForCausalLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.BioGptForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.BioGptForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.BioGptForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation.
This is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors
than the model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.BioGptForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.BioGptForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.BioGptForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BioGptForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.BioGptForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/biogpt/modeling_biogpt.py#L743",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptConfig"
>BioGptConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Cross attentions weights after the attention softmax, used to compute the weighted average in the
cross-attention heads.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>torch.FloatTensor</code> tuples of length <code>config.n_layers</code>, with each tuple containing the cached key,
value states of the self-attention and the cross-attention layers if model is used in encoder-decoder
setting. Only relevant if <code>config.is_decoder = True</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),D=new Lt({props:{$$slots:{default:[an]},$$scope:{ctx:v}}}),K=new at({props:{anchor:"transformers.BioGptForCausalLM.forward.example",$$slots:{default:[rn]},$$scope:{ctx:v}}}),Ue=new S({props:{title:"BioGptForTokenClassification",local:"transformers.BioGptForTokenClassification",headingTag:"h2"}}),We=new V({props:{name:"class transformers.BioGptForTokenClassification",anchor:"transformers.BioGptForTokenClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.BioGptForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptConfig">~BioGptConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/biogpt/modeling_biogpt.py#L818"}}),qe=new V({props:{name:"forward",anchor:"transformers.BioGptForTokenClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.BioGptForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>({0})</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BioGptForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>({0})</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.BioGptForTokenClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.BioGptForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>({0}, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.BioGptForTokenClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.BioGptForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation.
This is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors
than the model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.BioGptForTokenClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.BioGptForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.BioGptForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BioGptForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.BioGptForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/biogpt/modeling_biogpt.py#L840",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptConfig"
>BioGptConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ee=new Lt({props:{$$slots:{default:[dn]},$$scope:{ctx:v}}}),te=new at({props:{anchor:"transformers.BioGptForTokenClassification.forward.example",$$slots:{default:[ln]},$$scope:{ctx:v}}}),Ze=new S({props:{title:"BioGptForSequenceClassification",local:"transformers.BioGptForSequenceClassification",headingTag:"h2"}}),Ie=new V({props:{name:"class transformers.BioGptForSequenceClassification",anchor:"transformers.BioGptForSequenceClassification",parameters:[{name:"config",val:": BioGptConfig"}],parametersDescription:[{anchor:"transformers.BioGptForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptConfig">~BioGptConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/biogpt/modeling_biogpt.py#L910"}}),He=new V({props:{name:"forward",anchor:"transformers.BioGptForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.BioGptForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>({0})</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BioGptForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>({0})</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.BioGptForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.BioGptForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>({0}, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.BioGptForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.BioGptForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation.
This is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors
than the model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.BioGptForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.BioGptForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.BioGptForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BioGptForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.BioGptForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/biogpt/modeling_biogpt.py#L935",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.SequenceClassifierOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/biogpt#transformers.BioGptConfig"
>BioGptConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.SequenceClassifierOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),oe=new Lt({props:{$$slots:{default:[cn]},$$scope:{ctx:v}}}),ne=new at({props:{anchor:"transformers.BioGptForSequenceClassification.forward.example",$$slots:{default:[pn]},$$scope:{ctx:v}}}),se=new at({props:{anchor:"transformers.BioGptForSequenceClassification.forward.example-2",$$slots:{default:[mn]},$$scope:{ctx:v}}}),Ne=new tn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/biogpt.md"}}),{c(){n=c("meta"),M=r(),l=c("p"),d=r(),u(T.$$.fragment),t=r(),k=c("div"),k.innerHTML=To,dt=r(),u(ae.$$.fragment),lt=r(),re=c("p"),re.innerHTML=Mo,ct=r(),ie=c("p"),ie.textContent=ko,pt=r(),de=c("p"),de.innerHTML=vo,mt=r(),le=c("p"),le.innerHTML=wo,ut=r(),u(ce.$$.fragment),ht=r(),pe=c("ul"),pe.innerHTML=$o,ft=r(),u(me.$$.fragment),gt=r(),ue=c("p"),ue.innerHTML=Co,_t=r(),he=c("p"),he.innerHTML=Bo,bt=r(),u(fe.$$.fragment),yt=r(),ge=c("p"),ge.innerHTML=Go,Tt=r(),_e=c("p"),_e.innerHTML=xo,Mt=r(),be=c("table"),be.innerHTML=Jo,kt=r(),ye=c("p"),ye.innerHTML=jo,vt=r(),Te=c("table"),Te.innerHTML=zo,wt=r(),u(Me.$$.fragment),$t=r(),ke=c("ul"),ke.innerHTML=Fo,Ct=r(),u(ve.$$.fragment),Bt=r(),G=c("div"),u(we.$$.fragment),Rt=r(),Re=c("p"),Re.innerHTML=Uo,Vt=r(),Ve=c("p"),Ve.innerHTML=Wo,St=r(),u(Y.$$.fragment),Gt=r(),u($e.$$.fragment),xt=r(),x=c("div"),u(Ce.$$.fragment),Et=r(),Se=c("p"),Se.textContent=qo,Pt=r(),Ee=c("p"),Ee.innerHTML=Zo,Qt=r(),Pe=c("div"),u(Be.$$.fragment),Jt=r(),u(Ge.$$.fragment),jt=r(),W=c("div"),u(xe.$$.fragment),Xt=r(),Qe=c("p"),Qe.innerHTML=Io,Yt=r(),z=c("div"),u(Je.$$.fragment),At=r(),Xe=c("p"),Xe.innerHTML=Ho,Ot=r(),u(A.$$.fragment),Dt=r(),u(O.$$.fragment),zt=r(),u(je.$$.fragment),Ft=r(),q=c("div"),u(ze.$$.fragment),Kt=r(),Ye=c("p"),Ye.innerHTML=No,eo=r(),F=c("div"),u(Fe.$$.fragment),to=r(),Ae=c("p"),Ae.innerHTML=Lo,oo=r(),u(D.$$.fragment),no=r(),u(K.$$.fragment),Ut=r(),u(Ue.$$.fragment),Wt=r(),J=c("div"),u(We.$$.fragment),so=r(),Oe=c("p"),Oe.textContent=Ro,ao=r(),De=c("p"),De.innerHTML=Vo,ro=r(),U=c("div"),u(qe.$$.fragment),io=r(),Ke=c("p"),Ke.innerHTML=So,lo=r(),u(ee.$$.fragment),co=r(),u(te.$$.fragment),qt=r(),u(Ze.$$.fragment),Zt=r(),w=c("div"),u(Ie.$$.fragment),po=r(),et=c("p"),et.textContent=Eo,mo=r(),tt=c("p"),tt.innerHTML=Po,uo=r(),ot=c("p"),ot.innerHTML=Qo,ho=r(),nt=c("p"),nt.innerHTML=Xo,fo=r(),C=c("div"),u(He.$$.fragment),go=r(),st=c("p"),st.innerHTML=Yo,_o=r(),u(oe.$$.fragment),bo=r(),u(ne.$$.fragment),yo=r(),u(se.$$.fragment),It=r(),u(Ne.$$.fragment),Ht=r(),rt=c("p"),this.h()},l(e){const o=en("svelte-u9bgzb",document.head);n=p(o,"META",{name:!0,content:!0}),o.forEach(s),M=i(e),l=p(e,"P",{}),j(l).forEach(s),d=i(e),h(T.$$.fragment,e),t=i(e),k=p(e,"DIV",{class:!0,"data-svelte-h":!0}),y(k)!=="svelte-1yc98sx"&&(k.innerHTML=To),dt=i(e),h(ae.$$.fragment,e),lt=i(e),re=p(e,"P",{"data-svelte-h":!0}),y(re)!=="svelte-sog51v"&&(re.innerHTML=Mo),ct=i(e),ie=p(e,"P",{"data-svelte-h":!0}),y(ie)!=="svelte-vfdo9a"&&(ie.textContent=ko),pt=i(e),de=p(e,"P",{"data-svelte-h":!0}),y(de)!=="svelte-ihk4bt"&&(de.innerHTML=vo),mt=i(e),le=p(e,"P",{"data-svelte-h":!0}),y(le)!=="svelte-fg0afc"&&(le.innerHTML=wo),ut=i(e),h(ce.$$.fragment,e),ht=i(e),pe=p(e,"UL",{"data-svelte-h":!0}),y(pe)!=="svelte-1gszp1d"&&(pe.innerHTML=$o),ft=i(e),h(me.$$.fragment,e),gt=i(e),ue=p(e,"P",{"data-svelte-h":!0}),y(ue)!=="svelte-1cid2pe"&&(ue.innerHTML=Co),_t=i(e),he=p(e,"P",{"data-svelte-h":!0}),y(he)!=="svelte-1x11lxg"&&(he.innerHTML=Bo),bt=i(e),h(fe.$$.fragment,e),yt=i(e),ge=p(e,"P",{"data-svelte-h":!0}),y(ge)!=="svelte-py1kac"&&(ge.innerHTML=Go),Tt=i(e),_e=p(e,"P",{"data-svelte-h":!0}),y(_e)!=="svelte-djb2w0"&&(_e.innerHTML=xo),Mt=i(e),be=p(e,"TABLE",{"data-svelte-h":!0}),y(be)!=="svelte-w87fz0"&&(be.innerHTML=Jo),kt=i(e),ye=p(e,"P",{"data-svelte-h":!0}),y(ye)!=="svelte-11n437x"&&(ye.innerHTML=jo),vt=i(e),Te=p(e,"TABLE",{"data-svelte-h":!0}),y(Te)!=="svelte-1f4dimm"&&(Te.innerHTML=zo),wt=i(e),h(Me.$$.fragment,e),$t=i(e),ke=p(e,"UL",{"data-svelte-h":!0}),y(ke)!=="svelte-162aebv"&&(ke.innerHTML=Fo),Ct=i(e),h(ve.$$.fragment,e),Bt=i(e),G=p(e,"DIV",{class:!0});var Z=j(G);h(we.$$.fragment,Z),Rt=i(Z),Re=p(Z,"P",{"data-svelte-h":!0}),y(Re)!=="svelte-17rw8ci"&&(Re.innerHTML=Uo),Vt=i(Z),Ve=p(Z,"P",{"data-svelte-h":!0}),y(Ve)!=="svelte-o55m63"&&(Ve.innerHTML=Wo),St=i(Z),h(Y.$$.fragment,Z),Z.forEach(s),Gt=i(e),h($e.$$.fragment,e),xt=i(e),x=p(e,"DIV",{class:!0});var I=j(x);h(Ce.$$.fragment,I),Et=i(I),Se=p(I,"P",{"data-svelte-h":!0}),y(Se)!=="svelte-rkichk"&&(Se.textContent=qo),Pt=i(I),Ee=p(I,"P",{"data-svelte-h":!0}),y(Ee)!=="svelte-1c3t5ty"&&(Ee.innerHTML=Zo),Qt=i(I),Pe=p(I,"DIV",{class:!0});var it=j(Pe);h(Be.$$.fragment,it),it.forEach(s),I.forEach(s),Jt=i(e),h(Ge.$$.fragment,e),jt=i(e),W=p(e,"DIV",{class:!0});var Q=j(W);h(xe.$$.fragment,Q),Xt=i(Q),Qe=p(Q,"P",{"data-svelte-h":!0}),y(Qe)!=="svelte-qardyf"&&(Qe.innerHTML=Io),Yt=i(Q),z=p(Q,"DIV",{class:!0});var H=j(z);h(Je.$$.fragment,H),At=i(H),Xe=p(H,"P",{"data-svelte-h":!0}),y(Xe)!=="svelte-1nkwh4q"&&(Xe.innerHTML=Ho),Ot=i(H),h(A.$$.fragment,H),Dt=i(H),h(O.$$.fragment,H),H.forEach(s),Q.forEach(s),zt=i(e),h(je.$$.fragment,e),Ft=i(e),q=p(e,"DIV",{class:!0});var X=j(q);h(ze.$$.fragment,X),Kt=i(X),Ye=p(X,"P",{"data-svelte-h":!0}),y(Ye)!=="svelte-f4sq5v"&&(Ye.innerHTML=No),eo=i(X),F=p(X,"DIV",{class:!0});var N=j(F);h(Fe.$$.fragment,N),to=i(N),Ae=p(N,"P",{"data-svelte-h":!0}),y(Ae)!=="svelte-7kyte"&&(Ae.innerHTML=Lo),oo=i(N),h(D.$$.fragment,N),no=i(N),h(K.$$.fragment,N),N.forEach(s),X.forEach(s),Ut=i(e),h(Ue.$$.fragment,e),Wt=i(e),J=p(e,"DIV",{class:!0});var L=j(J);h(We.$$.fragment,L),so=i(L),Oe=p(L,"P",{"data-svelte-h":!0}),y(Oe)!=="svelte-18enhwc"&&(Oe.textContent=Ro),ao=i(L),De=p(L,"P",{"data-svelte-h":!0}),y(De)!=="svelte-68lg8f"&&(De.innerHTML=Vo),ro=i(L),U=p(L,"DIV",{class:!0});var R=j(U);h(qe.$$.fragment,R),io=i(R),Ke=p(R,"P",{"data-svelte-h":!0}),y(Ke)!=="svelte-14znva4"&&(Ke.innerHTML=So),lo=i(R),h(ee.$$.fragment,R),co=i(R),h(te.$$.fragment,R),R.forEach(s),L.forEach(s),qt=i(e),h(Ze.$$.fragment,e),Zt=i(e),w=p(e,"DIV",{class:!0});var $=j(w);h(Ie.$$.fragment,$),po=i($),et=p($,"P",{"data-svelte-h":!0}),y(et)!=="svelte-1u6ikyr"&&(et.textContent=Eo),mo=i($),tt=p($,"P",{"data-svelte-h":!0}),y(tt)!=="svelte-1xohaar"&&(tt.innerHTML=Po),uo=i($),ot=p($,"P",{"data-svelte-h":!0}),y(ot)!=="svelte-wtyfap"&&(ot.innerHTML=Qo),ho=i($),nt=p($,"P",{"data-svelte-h":!0}),y(nt)!=="svelte-68lg8f"&&(nt.innerHTML=Xo),fo=i($),C=p($,"DIV",{class:!0});var E=j(C);h(He.$$.fragment,E),go=i(E),st=p(E,"P",{"data-svelte-h":!0}),y(st)!=="svelte-1ntan9y"&&(st.innerHTML=Yo),_o=i(E),h(oe.$$.fragment,E),bo=i(E),h(ne.$$.fragment,E),yo=i(E),h(se.$$.fragment,E),E.forEach(s),$.forEach(s),It=i(e),h(Ne.$$.fragment,e),Ht=i(e),rt=p(e,"P",{}),j(rt).forEach(s),this.h()},h(){B(n,"name","hf:doc:metadata"),B(n,"content",hn),B(k,"class","flex flex-wrap space-x-1"),B(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),B(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){m(document.head,n),a(e,M,o),a(e,l,o),a(e,d,o),f(T,e,o),a(e,t,o),a(e,k,o),a(e,dt,o),f(ae,e,o),a(e,lt,o),a(e,re,o),a(e,ct,o),a(e,ie,o),a(e,pt,o),a(e,de,o),a(e,mt,o),a(e,le,o),a(e,ut,o),f(ce,e,o),a(e,ht,o),a(e,pe,o),a(e,ft,o),f(me,e,o),a(e,gt,o),a(e,ue,o),a(e,_t,o),a(e,he,o),a(e,bt,o),f(fe,e,o),a(e,yt,o),a(e,ge,o),a(e,Tt,o),a(e,_e,o),a(e,Mt,o),a(e,be,o),a(e,kt,o),a(e,ye,o),a(e,vt,o),a(e,Te,o),a(e,wt,o),f(Me,e,o),a(e,$t,o),a(e,ke,o),a(e,Ct,o),f(ve,e,o),a(e,Bt,o),a(e,G,o),f(we,G,null),m(G,Rt),m(G,Re),m(G,Vt),m(G,Ve),m(G,St),f(Y,G,null),a(e,Gt,o),f($e,e,o),a(e,xt,o),a(e,x,o),f(Ce,x,null),m(x,Et),m(x,Se),m(x,Pt),m(x,Ee),m(x,Qt),m(x,Pe),f(Be,Pe,null),a(e,Jt,o),f(Ge,e,o),a(e,jt,o),a(e,W,o),f(xe,W,null),m(W,Xt),m(W,Qe),m(W,Yt),m(W,z),f(Je,z,null),m(z,At),m(z,Xe),m(z,Ot),f(A,z,null),m(z,Dt),f(O,z,null),a(e,zt,o),f(je,e,o),a(e,Ft,o),a(e,q,o),f(ze,q,null),m(q,Kt),m(q,Ye),m(q,eo),m(q,F),f(Fe,F,null),m(F,to),m(F,Ae),m(F,oo),f(D,F,null),m(F,no),f(K,F,null),a(e,Ut,o),f(Ue,e,o),a(e,Wt,o),a(e,J,o),f(We,J,null),m(J,so),m(J,Oe),m(J,ao),m(J,De),m(J,ro),m(J,U),f(qe,U,null),m(U,io),m(U,Ke),m(U,lo),f(ee,U,null),m(U,co),f(te,U,null),a(e,qt,o),f(Ze,e,o),a(e,Zt,o),a(e,w,o),f(Ie,w,null),m(w,po),m(w,et),m(w,mo),m(w,tt),m(w,uo),m(w,ot),m(w,ho),m(w,nt),m(w,fo),m(w,C),f(He,C,null),m(C,go),m(C,st),m(C,_o),f(oe,C,null),m(C,bo),f(ne,C,null),m(C,yo),f(se,C,null),a(e,It,o),f(Ne,e,o),a(e,Ht,o),a(e,rt,o),Nt=!0},p(e,[o]){const Z={};o&2&&(Z.$$scope={dirty:o,ctx:e}),Y.$set(Z);const I={};o&2&&(I.$$scope={dirty:o,ctx:e}),A.$set(I);const it={};o&2&&(it.$$scope={dirty:o,ctx:e}),O.$set(it);const Q={};o&2&&(Q.$$scope={dirty:o,ctx:e}),D.$set(Q);const H={};o&2&&(H.$$scope={dirty:o,ctx:e}),K.$set(H);const X={};o&2&&(X.$$scope={dirty:o,ctx:e}),ee.$set(X);const N={};o&2&&(N.$$scope={dirty:o,ctx:e}),te.$set(N);const L={};o&2&&(L.$$scope={dirty:o,ctx:e}),oe.$set(L);const R={};o&2&&(R.$$scope={dirty:o,ctx:e}),ne.$set(R);const $={};o&2&&($.$$scope={dirty:o,ctx:e}),se.$set($)},i(e){Nt||(g(T.$$.fragment,e),g(ae.$$.fragment,e),g(ce.$$.fragment,e),g(me.$$.fragment,e),g(fe.$$.fragment,e),g(Me.$$.fragment,e),g(ve.$$.fragment,e),g(we.$$.fragment,e),g(Y.$$.fragment,e),g($e.$$.fragment,e),g(Ce.$$.fragment,e),g(Be.$$.fragment,e),g(Ge.$$.fragment,e),g(xe.$$.fragment,e),g(Je.$$.fragment,e),g(A.$$.fragment,e),g(O.$$.fragment,e),g(je.$$.fragment,e),g(ze.$$.fragment,e),g(Fe.$$.fragment,e),g(D.$$.fragment,e),g(K.$$.fragment,e),g(Ue.$$.fragment,e),g(We.$$.fragment,e),g(qe.$$.fragment,e),g(ee.$$.fragment,e),g(te.$$.fragment,e),g(Ze.$$.fragment,e),g(Ie.$$.fragment,e),g(He.$$.fragment,e),g(oe.$$.fragment,e),g(ne.$$.fragment,e),g(se.$$.fragment,e),g(Ne.$$.fragment,e),Nt=!0)},o(e){_(T.$$.fragment,e),_(ae.$$.fragment,e),_(ce.$$.fragment,e),_(me.$$.fragment,e),_(fe.$$.fragment,e),_(Me.$$.fragment,e),_(ve.$$.fragment,e),_(we.$$.fragment,e),_(Y.$$.fragment,e),_($e.$$.fragment,e),_(Ce.$$.fragment,e),_(Be.$$.fragment,e),_(Ge.$$.fragment,e),_(xe.$$.fragment,e),_(Je.$$.fragment,e),_(A.$$.fragment,e),_(O.$$.fragment,e),_(je.$$.fragment,e),_(ze.$$.fragment,e),_(Fe.$$.fragment,e),_(D.$$.fragment,e),_(K.$$.fragment,e),_(Ue.$$.fragment,e),_(We.$$.fragment,e),_(qe.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(Ze.$$.fragment,e),_(Ie.$$.fragment,e),_(He.$$.fragment,e),_(oe.$$.fragment,e),_(ne.$$.fragment,e),_(se.$$.fragment,e),_(Ne.$$.fragment,e),Nt=!1},d(e){e&&(s(M),s(l),s(d),s(t),s(k),s(dt),s(lt),s(re),s(ct),s(ie),s(pt),s(de),s(mt),s(le),s(ut),s(ht),s(pe),s(ft),s(gt),s(ue),s(_t),s(he),s(bt),s(yt),s(ge),s(Tt),s(_e),s(Mt),s(be),s(kt),s(ye),s(vt),s(Te),s(wt),s($t),s(ke),s(Ct),s(Bt),s(G),s(Gt),s(xt),s(x),s(Jt),s(jt),s(W),s(zt),s(Ft),s(q),s(Ut),s(Wt),s(J),s(qt),s(Zt),s(w),s(It),s(Ht),s(rt)),s(n),b(T,e),b(ae,e),b(ce,e),b(me,e),b(fe,e),b(Me,e),b(ve,e),b(we),b(Y),b($e,e),b(Ce),b(Be),b(Ge,e),b(xe),b(Je),b(A),b(O),b(je,e),b(ze),b(Fe),b(D),b(K),b(Ue,e),b(We),b(qe),b(ee),b(te),b(Ze,e),b(Ie),b(He),b(oe),b(ne),b(se),b(Ne,e)}}}const hn='{"title":"BioGPT","local":"biogpt","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[{"title":"Using Scaled Dot Product Attention (SDPA)","local":"using-scaled-dot-product-attention-sdpa","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"BioGptConfig","local":"transformers.BioGptConfig","sections":[],"depth":2},{"title":"BioGptTokenizer","local":"transformers.BioGptTokenizer","sections":[],"depth":2},{"title":"BioGptModel","local":"transformers.BioGptModel","sections":[],"depth":2},{"title":"BioGptForCausalLM","local":"transformers.BioGptForCausalLM","sections":[],"depth":2},{"title":"BioGptForTokenClassification","local":"transformers.BioGptForTokenClassification","sections":[],"depth":2},{"title":"BioGptForSequenceClassification","local":"transformers.BioGptForSequenceClassification","sections":[],"depth":2}],"depth":1}';function fn(v){return Oo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wn extends Do{constructor(n){super(),Ko(this,n,fn,un,Ao,{})}}export{wn as component};
