import{s as Es,o as Vs,n as Sl}from"../chunks/scheduler.36a0863c.js";import{S as Ys,i as Qs,g as o,s as a,r as d,A as xs,h as i,f as s,c as n,j as zs,u as p,x as r,k as Gs,y as Hs,a as t,v as M,d as m,t as u,w as y}from"../chunks/index.f891bdb2.js";import{T as Ll}from"../chunks/Tip.a8272f7f.js";import{C as T}from"../chunks/CodeBlock.b05e74dc.js";import{H as Ne,E as qs}from"../chunks/index.748128ce.js";function Fs(w){let c,f="Si tu modelo es muy similar a un modelo dentro de la biblioteca, puedes reutilizar la misma configuración de ese modelo.";return{c(){c=o("p"),c.textContent=f},l(J){c=i(J,"P",{"data-svelte-h":!0}),r(c)!=="svelte-143ofzf"&&(c.textContent=f)},m(J,j){t(J,c,j)},p:Sl,d(J){J&&s(c)}}}function Ls(w){let c,f="Esta <em>API</em> es experimental y puede tener algunos cambios leves en las próximas versiones.";return{c(){c=o("p"),c.innerHTML=f},l(J){c=i(J,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1qtj9q"&&(c.innerHTML=f)},m(J,j){t(J,c,j)},p:Sl,d(J){J&&s(c)}}}function Ss(w){let c,f=`Si copias archivos del modelo desde la biblioteca, deberás reemplazar todas las importaciones relativas en la parte superior
del archivo para importarlos desde el paquete <code>transformers</code>.`;return{c(){c=o("p"),c.innerHTML=f},l(J){c=i(J,"P",{"data-svelte-h":!0}),r(c)!=="svelte-n79je1"&&(c.innerHTML=f)},m(J,j){t(J,c,j)},p:Sl,d(J){J&&s(c)}}}function Ps(w){let c,f,J,j,g,Be,I,Pl=`La biblioteca 🤗 Transformers está diseñada para ser fácilmente ampliable. Cada modelo está completamente codificado
sin abstracción en una subcarpeta determinada del repositorio, por lo que puedes copiar fácilmente un archivo del modelo
y ajustarlo según tus necesidades.`,We,Z,Dl=`Si estás escribiendo un modelo completamente nuevo, podría ser más fácil comenzar desde cero. En este tutorial, te mostraremos
cómo escribir un modelo personalizado y su configuración para que pueda usarse dentro de Transformers, y cómo puedes compartirlo
con la comunidad (con el código en el que se basa) para que cualquiera pueda usarlo, incluso si no está presente en la biblioteca
🤗 Transformers.`,Xe,_,Kl='Ilustraremos todo esto con un modelo ResNet, envolviendo la clase ResNet de la <a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">biblioteca timm</a> en un <code>PreTrainedModel</code>.',ze,h,Ge,v,Ol=`Antes de adentrarnos en el modelo, primero escribamos su configuración. La configuración de un modelo es un objeto que
contendrá toda la información necesaria para construir el modelo. Como veremos en la siguiente sección, el modelo solo puede
tomar un <code>config</code> para ser inicializado, por lo que realmente necesitamos que ese objeto esté lo más completo posible.`,Ee,A,es=`En nuestro ejemplo, tomaremos un par de argumentos de la clase ResNet que tal vez queramos modificar. Las diferentes
configuraciones nos darán los diferentes tipos de ResNet que son posibles. Luego simplemente almacenamos esos argumentos
después de verificar la validez de algunos de ellos.`,Ve,$,Ye,k,ls="Las tres cosas importantes que debes recordar al escribir tu propia configuración son las siguientes:",Qe,N,ss="<li>tienes que heredar de <code>PretrainedConfig</code>,</li> <li>el <code>__init__</code> de tu <code>PretrainedConfig</code> debe aceptar cualquier <code>kwargs</code>,</li> <li>esos <code>kwargs</code> deben pasarse a la superclase <code>__init__</code>.</li>",xe,R,ts=`La herencia es para asegurarte de obtener toda la funcionalidad de la biblioteca 🤗 Transformers, mientras que las otras dos
restricciones provienen del hecho de que una <code>PretrainedConfig</code> tiene más campos que los que estás configurando. Al recargar una
<code>config</code> con el método <code>from_pretrained</code>, esos campos deben ser aceptados por tu <code>config</code> y luego enviados a la superclase.`,He,B,as=`Definir un <code>model_type</code> para tu configuración (en este caso <code>model_type=&quot;resnet&quot;</code>) no es obligatorio, a menos que quieras
registrar tu modelo con las clases automáticas (ver la última sección).`,qe,W,ns=`Una vez hecho esto, puedes crear y guardar fácilmente tu configuración como lo harías con cualquier otra configuración de un
modelo de la biblioteca. Así es como podemos crear una configuración resnet50d y guardarla:`,Fe,X,Le,z,os=`Esto guardará un archivo llamado <code>config.json</code> dentro de la carpeta <code>custom-resnet</code>. Luego puedes volver a cargar tu configuración
con el método <code>from_pretrained</code>:`,Se,G,Pe,E,is=`También puedes usar cualquier otro método de la clase <code>PretrainedConfig</code>, como <code>push_to_hub()</code>, para cargar
directamente tu configuración en el Hub.`,De,V,Ke,Y,rs=`Ahora que tenemos nuestra configuración de ResNet, podemos seguir escribiendo el modelo. En realidad escribiremos dos: una que
extrae las características ocultas de un grupo de imágenes (como <code>BertModel</code>) y una que es adecuada para clasificación de
imagenes (como <code>BertForSequenceClassification</code>).`,Oe,Q,cs=`Como mencionamos antes, solo escribiremos un envoltura (<em>wrapper</em>) libre del modelo para simplificar este ejemplo. Lo único que debemos
hacer antes de escribir esta clase es un mapeo entre los tipos de bloques y las clases de bloques reales. Luego se define el
modelo desde la configuración pasando todo a la clase <code>ResNet</code>:`,el,x,ll,H,ds="Para el modelo que clasificará las imágenes, solo cambiamos el método de avance (es decir, el método <code>forward</code>):",sl,q,tl,F,ps=`En ambos casos, observa cómo heredamos de <code>PreTrainedModel</code> y llamamos a la inicialización de la superclase con <code>config</code>
(un poco como cuando escribes <code>torch.nn.Module</code>). La línea que establece <code>config_class</code> no es obligatoria, a menos
que quieras registrar tu modelo con las clases automáticas (consulta la última sección).`,al,U,nl,L,Ms=`Puedes hacer que tu modelo devuelva lo que quieras, pero devolver un diccionario como lo hicimos para
<code>ResnetModelForImageClassification</code>, con el <code>loss</code> incluido cuando se pasan las etiquetas, hará que tu modelo se pueda
usar directamente dentro de la clase <code>Trainer</code>. Usar otro formato de salida está bien, siempre y cuando estés planeando usar
tu propio bucle de entrenamiento u otra biblioteca para el entrenamiento.`,ol,S,ms="Ahora que tenemos nuestra clase, vamos a crear un modelo:",il,P,rl,D,us=`Nuevamente, puedes usar cualquiera de los métodos de <code>PreTrainedModel</code>, como <code>save_pretrained()</code> o
<code>push_to_hub()</code>. Usaremos el segundo en la siguiente sección y veremos cómo pasar los pesos del modelo
con el código de nuestro modelo. Pero primero, carguemos algunos pesos previamente entrenados dentro de nuestro modelo.`,cl,K,ys=`En tu caso de uso, probablemente estarás entrenando tu modelo personalizado con tus propios datos. Para ir rápido en este
tutorial, usaremos la versión preentrenada de resnet50d. Dado que nuestro modelo es solo un envoltorio alrededor del resnet50d
original, será fácil transferir esos pesos:`,dl,O,pl,ee,Js=`Ahora veamos cómo asegurarnos de que cuando hacemos <code>save_pretrained()</code> o <code>push_to_hub()</code>,
se guarda el código del modelo.`,Ml,le,ml,b,ul,se,Ts=`Primero, asegúrate de que tu modelo esté completamente definido en un archivo <code>.py</code>. Puedes basarte en importaciones
relativas a otros archivos, siempre que todos los archivos estén en el mismo directorio (aún no admitimos submódulos
para esta característica). Para nuestro ejemplo, definiremos un archivo <code>modeling_resnet.py</code> y un archivo
<code>configuration_resnet.py</code> en una carpeta del directorio de trabajo actual llamado <code>resnet_model</code>. El archivo de configuración
contiene el código de <code>ResnetConfig</code> y el archivo del modelo contiene el código de <code>ResnetModel</code> y
<code>ResnetModelForImageClassification</code>.`,yl,te,Jl,ae,fs="El <code>__init__.py</code>  puede estar vacío, solo está ahí para que Python detecte que <code>resnet_model</code> se puede usar como un módulo.",Tl,C,fl,ne,js="Ten en cuenta que puedes reutilizar (o subclasificar) una configuración o modelo existente.",jl,oe,ws=`Para compartir tu modelo con la comunidad, sigue estos pasos: primero importa el modelo y la configuración de ResNet desde
los archivos recién creados:`,wl,ie,Ul,re,Us=`Luego, debes decirle a la biblioteca que deseas copiar el código de esos objetos cuando usas el método <code>save_pretrained</code>
y registrarlos correctamente con una determinada clase automática (especialmente para modelos), simplemente ejecuta:`,bl,ce,Cl,de,bs=`Ten en cuenta que no es necesario especificar una clase automática para la configuración (solo hay una clase automática
para ellos, <code>AutoConfig</code>), pero es diferente para los modelos. Tu modelo personalizado podría ser adecuado para muchas
tareas diferentes, por lo que debes especificar cuál de las clases automáticas es la correcta para tu modelo.`,gl,pe,Cs="A continuación, vamos a crear la configuración y los modelos como lo hicimos antes:",Il,Me,Zl,me,gs="Ahora, para enviar el modelo al Hub, asegúrate de haber iniciado sesión. Ejecuta en tu terminal:",_l,ue,hl,ye,Is="o desde un <em>notebook</em>:",vl,Je,Al,Te,Zs="Luego puedes ingresar a tu propio espacio (o una organización de la que seas miembro) de esta manera:",$l,fe,kl,je,_s=`Además de los pesos del modelo y la configuración en formato json, esto también copió los archivos <code>.py</code> del modelo y la
configuración en la carpeta <code>custom-resnet50d</code> y subió el resultado al Hub. Puedes verificar el resultado en este
<a href="https://huggingface.co/sgugger/custom-resnet50d" rel="nofollow">repositorio de modelos</a>.`,Nl,we,hs='Consulta el tutorial sobre cómo <a href="model_sharing">compartir modelos</a> para obtener más información sobre el método para subir modelos al Hub.',Rl,Ue,Bl,be,vs=`Puedes usar cualquier configuración, modelo o <em>tokenizador</em> con archivos de código personalizado en tu repositorio con las
clases automáticas y el método <code>from_pretrained</code>. Todos los archivos y códigos cargados en el Hub se analizan en busca de
malware (consulta la documentación de <a href="https://huggingface.co/docs/hub/security#malware-scanning" rel="nofollow">seguridad del Hub</a> para
obtener más información), pero aún debes revisar el código del modelo y el autor para evitar la ejecución de código malicioso
en tu computadora. Configura <code>trust_remote_code=True</code> para usar un modelo con código personalizado:`,Wl,Ce,Xl,ge,As=`También se recomienda encarecidamente pasar un <em>hash</em> de confirmación como una “revisión” para asegurarte de que el autor
de los modelos no actualizó el código con algunas líneas nuevas maliciosas (a menos que confíes plenamente en los autores
de los modelos).`,zl,Ie,Gl,Ze,$s=`Ten en cuenta que al navegar por el historial de confirmaciones del repositorio del modelo en Hub, hay un botón para copiar
fácilmente el hash de confirmación de cualquier <em>commit</em>.`,El,_e,Vl,he,ks=`Si estás escribiendo una biblioteca que amplía 🤗 Transformers, es posible que quieras ampliar las clases automáticas para
incluir tu propio modelo. Esto es diferente de enviar el código al Hub en el sentido de que los usuarios necesitarán importar
tu biblioteca para obtener los modelos personalizados (al contrario de descargar automáticamente el código del modelo desde Hub).`,Yl,ve,Ns=`Siempre que tu configuración tenga un atributo <code>model_type</code> que sea diferente de los tipos de modelos existentes, y que tus
clases modelo tengan los atributos <code>config_class</code> correctos, puedes agregarlos a las clases automáticas de la siguiente manera:`,Ql,Ae,xl,$e,Rs=`Ten en cuenta que el primer argumento utilizado al registrar tu configuración personalizada en <code>AutoConfig</code> debe coincidir
con el <code>model_type</code> de tu configuración personalizada, y el primer argumento utilizado al registrar tus modelos personalizados
en cualquier clase del modelo automático debe coincidir con el <code>config_class</code> de esos modelos.`,Hl,ke,ql,Re,Fl;return g=new Ne({props:{title:"Compartir modelos personalizados",local:"compartir-modelos-personalizados",headingTag:"h1"}}),h=new Ne({props:{title:"Escribir una configuración personalizada",local:"escribir-una-configuración-personalizada",headingTag:"h2"}}),$=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PretrainedConfig
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetConfig</span>(<span class="hljs-title class_ inherited__">PretrainedConfig</span>):
    model_type = <span class="hljs-string">&quot;resnet&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>,
        layers: <span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>] = [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">6</span>, <span class="hljs-number">3</span>],
        num_classes: <span class="hljs-built_in">int</span> = <span class="hljs-number">1000</span>,
        input_channels: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>,
        cardinality: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span>,
        base_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_type: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;&quot;</span>,
        avg_down: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
        **kwargs,
    </span>):
        <span class="hljs-keyword">if</span> block_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;basic&quot;</span>, <span class="hljs-string">&quot;bottleneck&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`block_type\` must be &#x27;basic&#x27; or bottleneck&#x27;, got <span class="hljs-subst">{block_type}</span>.&quot;</span>)
        <span class="hljs-keyword">if</span> stem_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;deep&quot;</span>, <span class="hljs-string">&quot;deep-tiered&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`stem_type\` must be &#x27;&#x27;, &#x27;deep&#x27; or &#x27;deep-tiered&#x27;, got <span class="hljs-subst">{stem_type}</span>.&quot;</span>)

        self.block_type = block_type
        self.layers = layers
        self.num_classes = num_classes
        self.input_channels = input_channels
        self.cardinality = cardinality
        self.base_width = base_width
        self.stem_width = stem_width
        self.stem_type = stem_type
        self.avg_down = avg_down
        <span class="hljs-built_in">super</span>().__init__(**kwargs)`,wrap:!1}}),X=new T({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d_config.save_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)`,wrap:!1}}),G=new T({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:'resnet50d_config = ResnetConfig.from_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)',wrap:!1}}),V=new Ne({props:{title:"Escribir un modelo personalizado",local:"escribir-un-modelo-personalizado",headingTag:"h2"}}),x=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRNb2RlbCUwQWZyb20lMjB0aW1tLm1vZGVscy5yZXNuZXQlMjBpbXBvcnQlMjBCYXNpY0Jsb2NrJTJDJTIwQm90dGxlbmVjayUyQyUyMFJlc05ldCUwQWZyb20lMjAuY29uZmlndXJhdGlvbl9yZXNuZXQlMjBpbXBvcnQlMjBSZXNuZXRDb25maWclMEElMEElMEFCTE9DS19NQVBQSU5HJTIwJTNEJTIwJTdCJTIyYmFzaWMlMjIlM0ElMjBCYXNpY0Jsb2NrJTJDJTIwJTIyYm90dGxlbmVjayUyMiUzQSUyMEJvdHRsZW5lY2slN0QlMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb25maWdfY2xhc3MlMjAlM0QlMjBSZXNuZXRDb25maWclMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX2xheWVyJTIwJTNEJTIwQkxPQ0tfTUFQUElORyU1QmNvbmZpZy5ibG9ja190eXBlJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbCUyMCUzRCUyMFJlc05ldCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbmZpZy5sYXllcnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fY2xhc3NlcyUzRGNvbmZpZy5udW1fY2xhc3NlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5zJTNEY29uZmlnLmlucHV0X2NoYW5uZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FyZGluYWxpdHklM0Rjb25maWcuY2FyZGluYWxpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXNlX3dpZHRoJTNEY29uZmlnLmJhc2Vfd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3dpZHRoJTNEY29uZmlnLnN0ZW1fd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3R5cGUlM0Rjb25maWcuc3RlbV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXZnX2Rvd24lM0Rjb25maWcuYXZnX2Rvd24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubW9kZWwuZm9yd2FyZF9mZWF0dXJlcyh0ZW5zb3Ip",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedModel
<span class="hljs-keyword">from</span> timm.models.resnet <span class="hljs-keyword">import</span> BasicBlock, Bottleneck, ResNet
<span class="hljs-keyword">from</span> .configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig


BLOCK_MAPPING = {<span class="hljs-string">&quot;basic&quot;</span>: BasicBlock, <span class="hljs-string">&quot;bottleneck&quot;</span>: Bottleneck}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor</span>):
        <span class="hljs-keyword">return</span> self.model.forward_features(tensor)`,wrap:!1}}),q=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihQcmVUcmFpbmVkTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnX2NsYXNzJTIwJTNEJTIwUmVzbmV0Q29uZmlnJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyMCUzRCUyMEJMT0NLX01BUFBJTkclNUJjb25maWcuYmxvY2tfdHlwZSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWwlMjAlM0QlMjBSZXNOZXQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfbGF5ZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcubGF5ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2NsYXNzZXMlM0Rjb25maWcubnVtX2NsYXNzZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbl9jaGFucyUzRGNvbmZpZy5pbnB1dF9jaGFubmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRpbmFsaXR5JTNEY29uZmlnLmNhcmRpbmFsaXR5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmFzZV93aWR0aCUzRGNvbmZpZy5iYXNlX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV93aWR0aCUzRGNvbmZpZy5zdGVtX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV90eXBlJTNEY29uZmlnLnN0ZW1fdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF2Z19kb3duJTNEY29uZmlnLmF2Z19kb3duJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHRlbnNvciUyQyUyMGxhYmVscyUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwc2VsZi5tb2RlbCh0ZW5zb3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsYWJlbHMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5jcm9zc19lbnRyb3B5KGxvZ2l0cyUyQyUyMGxhYmVscyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJsb3NzJTIyJTNBJTIwbG9zcyUyQyUyMCUyMmxvZ2l0cyUyMiUzQSUyMGxvZ2l0cyU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmxvZ2l0cyUyMiUzQSUyMGxvZ2l0cyU3RA==",highlighted:`<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModelForImageClassification</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor, labels=<span class="hljs-literal">None</span></span>):
        logits = self.model(tensor)
        <span class="hljs-keyword">if</span> labels <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            loss = torch.nn.functional.cross_entropy(logits, labels)
            <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;loss&quot;</span>: loss, <span class="hljs-string">&quot;logits&quot;</span>: logits}
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),U=new Ll({props:{$$slots:{default:[Fs]},$$scope:{ctx:w}}}),P=new T({props:{code:"cmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcp",highlighted:"resnet50d = ResnetModelForImageClassification(resnet50d_config)",wrap:!1}}),O=new T({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQXByZXRyYWluZWRfbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCglMjJyZXNuZXQ1MGQlMjIlMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFyZXNuZXQ1MGQubW9kZWwubG9hZF9zdGF0ZV9kaWN0KHByZXRyYWluZWRfbW9kZWwuc3RhdGVfZGljdCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),le=new Ne({props:{title:"Enviar el código al Hub",local:"enviar-el-código-al-hub",headingTag:"h2"}}),b=new Ll({props:{warning:!0,$$slots:{default:[Ls]},$$scope:{ctx:w}}}),te=new T({props:{code:"LiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHJlc25ldF9tb2RlbCUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMF9faW5pdF9fLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlndXJhdGlvbl9yZXNuZXQucHklMEElMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBtb2RlbGluZ19yZXNuZXQucHk=",highlighted:`.
└── resnet_model
    ├── __init__.<span class="hljs-keyword">py</span>
    ├── configuration_resnet.<span class="hljs-keyword">py</span>
    └── modeling_resnet.<span class="hljs-keyword">py</span>`,wrap:!1}}),C=new Ll({props:{warning:!0,$$slots:{default:[Ss]},$$scope:{ctx:w}}}),ie=new T({props:{code:"ZnJvbSUyMHJlc25ldF9tb2RlbC5jb25maWd1cmF0aW9uX3Jlc25ldCUyMGltcG9ydCUyMFJlc25ldENvbmZpZyUwQWZyb20lMjByZXNuZXRfbW9kZWwubW9kZWxpbmdfcmVzbmV0JTIwaW1wb3J0JTIwUmVzbmV0TW9kZWwlMkMlMjBSZXNuZXRNb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24=",highlighted:`<span class="hljs-keyword">from</span> resnet_model.configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig
<span class="hljs-keyword">from</span> resnet_model.modeling_resnet <span class="hljs-keyword">import</span> ResnetModel, ResnetModelForImageClassification`,wrap:!1}}),ce=new T({props:{code:"UmVzbmV0Q29uZmlnLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCklMEFSZXNuZXRNb2RlbC5yZWdpc3Rlcl9mb3JfYXV0b19jbGFzcyglMjJBdXRvTW9kZWwlMjIpJTBBUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCUyMkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMjIp",highlighted:`ResnetConfig.register_for_auto_class()
ResnetModel.register_for_auto_class(<span class="hljs-string">&quot;AutoModel&quot;</span>)
ResnetModelForImageClassification.register_for_auto_class(<span class="hljs-string">&quot;AutoModelForImageClassification&quot;</span>)`,wrap:!1}}),Me=new T({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcpJTBBJTBBcHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXJlc25ldDUwZC5tb2RlbC5sb2FkX3N0YXRlX2RpY3QocHJldHJhaW5lZF9tb2RlbC5zdGF0ZV9kaWN0KCkp",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d = ResnetModelForImageClassification(resnet50d_config)

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),ue=new T({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),Je=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),fe=new T({props:{code:"cmVzbmV0NTBkLnB1c2hfdG9faHViKCUyMmN1c3RvbS1yZXNuZXQ1MGQlMjIp",highlighted:'resnet50d.push_to_hub(<span class="hljs-string">&quot;custom-resnet50d&quot;</span>)',wrap:!1}}),Ue=new Ne({props:{title:"Usar un modelo con código personalizado",local:"usar-un-modelo-con-código-personalizado",headingTag:"h2"}}),Ce=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnNndWdnZXIlMkZjdXN0b20tcmVzbmV0NTBkJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),Ie=new T({props:{code:"Y29tbWl0X2hhc2glMjAlM0QlMjAlMjJlZDk0YTdjNjI0N2Q4YWVkY2U0NjQ3ZjAwZjIwZGU2ODc1YjViMjkyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzZ3VnZ2VyJTJGY3VzdG9tLXJlc25ldDUwZCUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUyQyUyMHJldmlzaW9uJTNEY29tbWl0X2hhc2glMEEp",highlighted:`commit_hash = <span class="hljs-string">&quot;ed94a7c6247d8aedce4647f00f20de6875b5b292&quot;</span>
model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, revision=commit_hash
)`,wrap:!1}}),_e=new Ne({props:{title:"Registrar un model con código personalizado a las clases automáticas",local:"registrar-un-model-con-código-personalizado-a-las-clases-automáticas",headingTag:"h2"}}),Ae=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBQXV0b0NvbmZpZy5yZWdpc3RlciglMjJyZXNuZXQlMjIlMkMlMjBSZXNuZXRDb25maWcpJTBBQXV0b01vZGVsLnJlZ2lzdGVyKFJlc25ldENvbmZpZyUyQyUyMFJlc25ldE1vZGVsKSUwQUF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24ucmVnaXN0ZXIoUmVzbmV0Q29uZmlnJTJDJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel, AutoModelForImageClassification

AutoConfig.register(<span class="hljs-string">&quot;resnet&quot;</span>, ResnetConfig)
AutoModel.register(ResnetConfig, ResnetModel)
AutoModelForImageClassification.register(ResnetConfig, ResnetModelForImageClassification)`,wrap:!1}}),ke=new qs({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/es/custom_models.md"}}),{c(){c=o("meta"),f=a(),J=o("p"),j=a(),d(g.$$.fragment),Be=a(),I=o("p"),I.textContent=Pl,We=a(),Z=o("p"),Z.textContent=Dl,Xe=a(),_=o("p"),_.innerHTML=Kl,ze=a(),d(h.$$.fragment),Ge=a(),v=o("p"),v.innerHTML=Ol,Ee=a(),A=o("p"),A.textContent=es,Ve=a(),d($.$$.fragment),Ye=a(),k=o("p"),k.textContent=ls,Qe=a(),N=o("ul"),N.innerHTML=ss,xe=a(),R=o("p"),R.innerHTML=ts,He=a(),B=o("p"),B.innerHTML=as,qe=a(),W=o("p"),W.textContent=ns,Fe=a(),d(X.$$.fragment),Le=a(),z=o("p"),z.innerHTML=os,Se=a(),d(G.$$.fragment),Pe=a(),E=o("p"),E.innerHTML=is,De=a(),d(V.$$.fragment),Ke=a(),Y=o("p"),Y.innerHTML=rs,Oe=a(),Q=o("p"),Q.innerHTML=cs,el=a(),d(x.$$.fragment),ll=a(),H=o("p"),H.innerHTML=ds,sl=a(),d(q.$$.fragment),tl=a(),F=o("p"),F.innerHTML=ps,al=a(),d(U.$$.fragment),nl=a(),L=o("p"),L.innerHTML=Ms,ol=a(),S=o("p"),S.textContent=ms,il=a(),d(P.$$.fragment),rl=a(),D=o("p"),D.innerHTML=us,cl=a(),K=o("p"),K.textContent=ys,dl=a(),d(O.$$.fragment),pl=a(),ee=o("p"),ee.innerHTML=Js,Ml=a(),d(le.$$.fragment),ml=a(),d(b.$$.fragment),ul=a(),se=o("p"),se.innerHTML=Ts,yl=a(),d(te.$$.fragment),Jl=a(),ae=o("p"),ae.innerHTML=fs,Tl=a(),d(C.$$.fragment),fl=a(),ne=o("p"),ne.textContent=js,jl=a(),oe=o("p"),oe.textContent=ws,wl=a(),d(ie.$$.fragment),Ul=a(),re=o("p"),re.innerHTML=Us,bl=a(),d(ce.$$.fragment),Cl=a(),de=o("p"),de.innerHTML=bs,gl=a(),pe=o("p"),pe.textContent=Cs,Il=a(),d(Me.$$.fragment),Zl=a(),me=o("p"),me.textContent=gs,_l=a(),d(ue.$$.fragment),hl=a(),ye=o("p"),ye.innerHTML=Is,vl=a(),d(Je.$$.fragment),Al=a(),Te=o("p"),Te.textContent=Zs,$l=a(),d(fe.$$.fragment),kl=a(),je=o("p"),je.innerHTML=_s,Nl=a(),we=o("p"),we.innerHTML=hs,Rl=a(),d(Ue.$$.fragment),Bl=a(),be=o("p"),be.innerHTML=vs,Wl=a(),d(Ce.$$.fragment),Xl=a(),ge=o("p"),ge.innerHTML=As,zl=a(),d(Ie.$$.fragment),Gl=a(),Ze=o("p"),Ze.innerHTML=$s,El=a(),d(_e.$$.fragment),Vl=a(),he=o("p"),he.textContent=ks,Yl=a(),ve=o("p"),ve.innerHTML=Ns,Ql=a(),d(Ae.$$.fragment),xl=a(),$e=o("p"),$e.innerHTML=Rs,Hl=a(),d(ke.$$.fragment),ql=a(),Re=o("p"),this.h()},l(e){const l=xs("svelte-u9bgzb",document.head);c=i(l,"META",{name:!0,content:!0}),l.forEach(s),f=n(e),J=i(e,"P",{}),zs(J).forEach(s),j=n(e),p(g.$$.fragment,e),Be=n(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-tr5y5v"&&(I.textContent=Pl),We=n(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-109xt20"&&(Z.textContent=Dl),Xe=n(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-btynk6"&&(_.innerHTML=Kl),ze=n(e),p(h.$$.fragment,e),Ge=n(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-ogx8ma"&&(v.innerHTML=Ol),Ee=n(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-150l7rd"&&(A.textContent=es),Ve=n(e),p($.$$.fragment,e),Ye=n(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-136d91e"&&(k.textContent=ls),Qe=n(e),N=i(e,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-9z90ps"&&(N.innerHTML=ss),xe=n(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-ydah10"&&(R.innerHTML=ts),He=n(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-9ngg6t"&&(B.innerHTML=as),qe=n(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-aydane"&&(W.textContent=ns),Fe=n(e),p(X.$$.fragment,e),Le=n(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1m9vi80"&&(z.innerHTML=os),Se=n(e),p(G.$$.fragment,e),Pe=n(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-13fhymr"&&(E.innerHTML=is),De=n(e),p(V.$$.fragment,e),Ke=n(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-paws7g"&&(Y.innerHTML=rs),Oe=n(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1ibwyqf"&&(Q.innerHTML=cs),el=n(e),p(x.$$.fragment,e),ll=n(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-836jlz"&&(H.innerHTML=ds),sl=n(e),p(q.$$.fragment,e),tl=n(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-14m6odt"&&(F.innerHTML=ps),al=n(e),p(U.$$.fragment,e),nl=n(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1azo3fe"&&(L.innerHTML=Ms),ol=n(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1shfqlo"&&(S.textContent=ms),il=n(e),p(P.$$.fragment,e),rl=n(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-2zdpdr"&&(D.innerHTML=us),cl=n(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-yesi1m"&&(K.textContent=ys),dl=n(e),p(O.$$.fragment,e),pl=n(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-5f7hiy"&&(ee.innerHTML=Js),Ml=n(e),p(le.$$.fragment,e),ml=n(e),p(b.$$.fragment,e),ul=n(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-5u1ku0"&&(se.innerHTML=Ts),yl=n(e),p(te.$$.fragment,e),Jl=n(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-6pddse"&&(ae.innerHTML=fs),Tl=n(e),p(C.$$.fragment,e),fl=n(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-16nat6k"&&(ne.textContent=js),jl=n(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1wbstm1"&&(oe.textContent=ws),wl=n(e),p(ie.$$.fragment,e),Ul=n(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1w1g05r"&&(re.innerHTML=Us),bl=n(e),p(ce.$$.fragment,e),Cl=n(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1gdhq4n"&&(de.innerHTML=bs),gl=n(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1vs3f15"&&(pe.textContent=Cs),Il=n(e),p(Me.$$.fragment,e),Zl=n(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1alfdyw"&&(me.textContent=gs),_l=n(e),p(ue.$$.fragment,e),hl=n(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-vkjqtt"&&(ye.innerHTML=Is),vl=n(e),p(Je.$$.fragment,e),Al=n(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1n95bu8"&&(Te.textContent=Zs),$l=n(e),p(fe.$$.fragment,e),kl=n(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-5clmj9"&&(je.innerHTML=_s),Nl=n(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1cn7w99"&&(we.innerHTML=hs),Rl=n(e),p(Ue.$$.fragment,e),Bl=n(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-z7pzfv"&&(be.innerHTML=vs),Wl=n(e),p(Ce.$$.fragment,e),Xl=n(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-k6h5j4"&&(ge.innerHTML=As),zl=n(e),p(Ie.$$.fragment,e),Gl=n(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-triido"&&(Ze.innerHTML=$s),El=n(e),p(_e.$$.fragment,e),Vl=n(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1brns02"&&(he.textContent=ks),Yl=n(e),ve=i(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-qfsmdh"&&(ve.innerHTML=Ns),Ql=n(e),p(Ae.$$.fragment,e),xl=n(e),$e=i(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-srgb3"&&($e.innerHTML=Rs),Hl=n(e),p(ke.$$.fragment,e),ql=n(e),Re=i(e,"P",{}),zs(Re).forEach(s),this.h()},h(){Gs(c,"name","hf:doc:metadata"),Gs(c,"content",Ds)},m(e,l){Hs(document.head,c),t(e,f,l),t(e,J,l),t(e,j,l),M(g,e,l),t(e,Be,l),t(e,I,l),t(e,We,l),t(e,Z,l),t(e,Xe,l),t(e,_,l),t(e,ze,l),M(h,e,l),t(e,Ge,l),t(e,v,l),t(e,Ee,l),t(e,A,l),t(e,Ve,l),M($,e,l),t(e,Ye,l),t(e,k,l),t(e,Qe,l),t(e,N,l),t(e,xe,l),t(e,R,l),t(e,He,l),t(e,B,l),t(e,qe,l),t(e,W,l),t(e,Fe,l),M(X,e,l),t(e,Le,l),t(e,z,l),t(e,Se,l),M(G,e,l),t(e,Pe,l),t(e,E,l),t(e,De,l),M(V,e,l),t(e,Ke,l),t(e,Y,l),t(e,Oe,l),t(e,Q,l),t(e,el,l),M(x,e,l),t(e,ll,l),t(e,H,l),t(e,sl,l),M(q,e,l),t(e,tl,l),t(e,F,l),t(e,al,l),M(U,e,l),t(e,nl,l),t(e,L,l),t(e,ol,l),t(e,S,l),t(e,il,l),M(P,e,l),t(e,rl,l),t(e,D,l),t(e,cl,l),t(e,K,l),t(e,dl,l),M(O,e,l),t(e,pl,l),t(e,ee,l),t(e,Ml,l),M(le,e,l),t(e,ml,l),M(b,e,l),t(e,ul,l),t(e,se,l),t(e,yl,l),M(te,e,l),t(e,Jl,l),t(e,ae,l),t(e,Tl,l),M(C,e,l),t(e,fl,l),t(e,ne,l),t(e,jl,l),t(e,oe,l),t(e,wl,l),M(ie,e,l),t(e,Ul,l),t(e,re,l),t(e,bl,l),M(ce,e,l),t(e,Cl,l),t(e,de,l),t(e,gl,l),t(e,pe,l),t(e,Il,l),M(Me,e,l),t(e,Zl,l),t(e,me,l),t(e,_l,l),M(ue,e,l),t(e,hl,l),t(e,ye,l),t(e,vl,l),M(Je,e,l),t(e,Al,l),t(e,Te,l),t(e,$l,l),M(fe,e,l),t(e,kl,l),t(e,je,l),t(e,Nl,l),t(e,we,l),t(e,Rl,l),M(Ue,e,l),t(e,Bl,l),t(e,be,l),t(e,Wl,l),M(Ce,e,l),t(e,Xl,l),t(e,ge,l),t(e,zl,l),M(Ie,e,l),t(e,Gl,l),t(e,Ze,l),t(e,El,l),M(_e,e,l),t(e,Vl,l),t(e,he,l),t(e,Yl,l),t(e,ve,l),t(e,Ql,l),M(Ae,e,l),t(e,xl,l),t(e,$e,l),t(e,Hl,l),M(ke,e,l),t(e,ql,l),t(e,Re,l),Fl=!0},p(e,[l]){const Bs={};l&2&&(Bs.$$scope={dirty:l,ctx:e}),U.$set(Bs);const Ws={};l&2&&(Ws.$$scope={dirty:l,ctx:e}),b.$set(Ws);const Xs={};l&2&&(Xs.$$scope={dirty:l,ctx:e}),C.$set(Xs)},i(e){Fl||(m(g.$$.fragment,e),m(h.$$.fragment,e),m($.$$.fragment,e),m(X.$$.fragment,e),m(G.$$.fragment,e),m(V.$$.fragment,e),m(x.$$.fragment,e),m(q.$$.fragment,e),m(U.$$.fragment,e),m(P.$$.fragment,e),m(O.$$.fragment,e),m(le.$$.fragment,e),m(b.$$.fragment,e),m(te.$$.fragment,e),m(C.$$.fragment,e),m(ie.$$.fragment,e),m(ce.$$.fragment,e),m(Me.$$.fragment,e),m(ue.$$.fragment,e),m(Je.$$.fragment,e),m(fe.$$.fragment,e),m(Ue.$$.fragment,e),m(Ce.$$.fragment,e),m(Ie.$$.fragment,e),m(_e.$$.fragment,e),m(Ae.$$.fragment,e),m(ke.$$.fragment,e),Fl=!0)},o(e){u(g.$$.fragment,e),u(h.$$.fragment,e),u($.$$.fragment,e),u(X.$$.fragment,e),u(G.$$.fragment,e),u(V.$$.fragment,e),u(x.$$.fragment,e),u(q.$$.fragment,e),u(U.$$.fragment,e),u(P.$$.fragment,e),u(O.$$.fragment,e),u(le.$$.fragment,e),u(b.$$.fragment,e),u(te.$$.fragment,e),u(C.$$.fragment,e),u(ie.$$.fragment,e),u(ce.$$.fragment,e),u(Me.$$.fragment,e),u(ue.$$.fragment,e),u(Je.$$.fragment,e),u(fe.$$.fragment,e),u(Ue.$$.fragment,e),u(Ce.$$.fragment,e),u(Ie.$$.fragment,e),u(_e.$$.fragment,e),u(Ae.$$.fragment,e),u(ke.$$.fragment,e),Fl=!1},d(e){e&&(s(f),s(J),s(j),s(Be),s(I),s(We),s(Z),s(Xe),s(_),s(ze),s(Ge),s(v),s(Ee),s(A),s(Ve),s(Ye),s(k),s(Qe),s(N),s(xe),s(R),s(He),s(B),s(qe),s(W),s(Fe),s(Le),s(z),s(Se),s(Pe),s(E),s(De),s(Ke),s(Y),s(Oe),s(Q),s(el),s(ll),s(H),s(sl),s(tl),s(F),s(al),s(nl),s(L),s(ol),s(S),s(il),s(rl),s(D),s(cl),s(K),s(dl),s(pl),s(ee),s(Ml),s(ml),s(ul),s(se),s(yl),s(Jl),s(ae),s(Tl),s(fl),s(ne),s(jl),s(oe),s(wl),s(Ul),s(re),s(bl),s(Cl),s(de),s(gl),s(pe),s(Il),s(Zl),s(me),s(_l),s(hl),s(ye),s(vl),s(Al),s(Te),s($l),s(kl),s(je),s(Nl),s(we),s(Rl),s(Bl),s(be),s(Wl),s(Xl),s(ge),s(zl),s(Gl),s(Ze),s(El),s(Vl),s(he),s(Yl),s(ve),s(Ql),s(xl),s($e),s(Hl),s(ql),s(Re)),s(c),y(g,e),y(h,e),y($,e),y(X,e),y(G,e),y(V,e),y(x,e),y(q,e),y(U,e),y(P,e),y(O,e),y(le,e),y(b,e),y(te,e),y(C,e),y(ie,e),y(ce,e),y(Me,e),y(ue,e),y(Je,e),y(fe,e),y(Ue,e),y(Ce,e),y(Ie,e),y(_e,e),y(Ae,e),y(ke,e)}}}const Ds='{"title":"Compartir modelos personalizados","local":"compartir-modelos-personalizados","sections":[{"title":"Escribir una configuración personalizada","local":"escribir-una-configuración-personalizada","sections":[],"depth":2},{"title":"Escribir un modelo personalizado","local":"escribir-un-modelo-personalizado","sections":[],"depth":2},{"title":"Enviar el código al Hub","local":"enviar-el-código-al-hub","sections":[],"depth":2},{"title":"Usar un modelo con código personalizado","local":"usar-un-modelo-con-código-personalizado","sections":[],"depth":2},{"title":"Registrar un model con código personalizado a las clases automáticas","local":"registrar-un-model-con-código-personalizado-a-las-clases-automáticas","sections":[],"depth":2}],"depth":1}';function Ks(w){return Vs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class at extends Ys{constructor(c){super(),Qs(this,c,Ks,Ps,Es,{})}}export{at as component};
