import{s as $t,o as Ut,n as Jt}from"../chunks/scheduler.36a0863c.js";import{S as vt,i as Zt,g as i,s as l,r,A as It,h as p,f as a,c as n,j as Tt,u as c,x as o,k as va,y as Gt,a as t,v as m,d,t as u,w as h,m as xt,n as kt}from"../chunks/index.f891bdb2.js";import{T as Za}from"../chunks/Tip.a8272f7f.js";import{C as g}from"../chunks/CodeBlock.b05e74dc.js";import{H as w,E as Bt}from"../chunks/index.748128ce.js";function Wt($){let M,y="Echa un vistazo a la documentación de <code>pipeline()</code> para obtener una lista completa de tareas admitidas.";return{c(){M=i("p"),M.innerHTML=y},l(f){M=p(f,"P",{"data-svelte-h":!0}),o(M)!=="svelte-1daerre"&&(M.innerHTML=y)},m(f,b){t(f,M,b)},p:Jt,d(f){f&&a(M)}}}function Ct($){let M;return{c(){M=xt("Crear un motor de inferencia es un tema complejo que merece su propia página.")},l(y){M=kt(y,"Crear un motor de inferencia es un tema complejo que merece su propia página.")},m(y,f){t(y,M,f)},d(y){y&&a(M)}}}function qt($){let M,y='Para ejecutar el ejemplo anterior, debe tener instalado <a href="https://pypi.org/project/pytesseract/" rel="nofollow"><code>pytesseract</code></a> además de 🤗 Transformers:',f,b,T;return b=new g({props:{code:"c3VkbyUyMGFwdCUyMGluc3RhbGwlMjAteSUyMHRlc3NlcmFjdC1vY3IlMEFwaXAlMjBpbnN0YWxsJTIwcHl0ZXNzZXJhY3Q=",highlighted:`sudo apt install -y tesseract-ocr
pip install pytesseract`,wrap:!1}}),{c(){M=i("p"),M.innerHTML=y,f=l(),r(b.$$.fragment)},l(j){M=p(j,"P",{"data-svelte-h":!0}),o(M)!=="svelte-24jat5"&&(M.innerHTML=y),f=n(j),c(b.$$.fragment,j)},m(j,J){t(j,M,J),t(j,f,J),m(b,j,J),T=!0},p:Jt,i(j){T||(d(b.$$.fragment,j),T=!0)},o(j){u(b.$$.fragment,j),T=!1},d(j){j&&(a(M),a(f)),h(b,j)}}}function Xt($){let M,y,f,b,T,j,J,Ia='Un <code>pipeline()</code> simplifica el uso de cualquier modelo del <a href="https://huggingface.co/models" rel="nofollow">Hub</a> para la inferencia en una variedad de tareas como la generación de texto, la segmentación de imágenes y la clasificación de audio. Incluso si no tienes experiencia con una modalidad específica o no comprendes el código que alimenta los modelos, ¡aún puedes usarlos con el <code>pipeline()</code>! Este tutorial te enseñará a:',Ke,G,Ga="<li>Utilizar un <code>pipeline()</code> para inferencia.</li> <li>Utilizar un tokenizador o modelo específico.</li> <li>Utilizar un <code>pipeline()</code> para tareas de audio y visión.</li>",Oe,U,es,x,ss,k,xa="Si bien cada tarea tiene un <code>pipeline()</code> asociado, es más sencillo usar la abstracción general <code>pipeline()</code> que contiene todos los pipelines de tareas específicas. El <code>pipeline()</code> carga automáticamente un modelo predeterminado y un tokenizador con capacidad de inferencia para tu tarea. Veamos el ejemplo de usar un <code>pipeline()</code> para reconocimiento automático del habla (ASR), o texto a voz.",as,B,ka="<li>Comienza creando un <code>pipeline()</code> y específica una tarea de inferencia:</li>",ts,W,ls,v,Ba="<li>Pasa tu entrada a la <code>pipeline()</code>. En el caso del reconocimiento del habla, esto es un archivo de entrada de audio:</li>",ns,C,is,q,Wa=`¿No es el resultado que tenías en mente? Echa un vistazo a algunos de los <a href="https://huggingface.co/models?pipeline_tag=automatic-speech-recognition&amp;sort=trending" rel="nofollow">modelos de reconocimiento automático del habla más descargados</a>
en el Hub para ver si puedes obtener una mejor transcripción.`,ps,X,Ca=`Intentemos con el modelo <a href="https://huggingface.co/openai/whisper-large" rel="nofollow">Whisper large-v2</a> de OpenAI. Whisper se lanzó
2 años después que Wav2Vec2, y se entrenó con cerca de 10 veces más datos. Como tal, supera a Wav2Vec2 en la mayoría de las pruebas
downstream. También tiene el beneficio adicional de predecir puntuación y mayúsculas, ninguno de los cuales es posible con<br/>
Wav2Vec2.`,os,H,qa="Vamos a probarlo aquí para ver cómo se desempeña:",rs,R,cs,z,Xa=`¡Ahora este resultado parece más preciso! Para una comparación detallada de Wav2Vec2 vs Whisper, consulta el <a href="https://huggingface.co/learn/audio-course/chapter5/asr_models" rel="nofollow">Curso de Transformers de Audio</a>.
Realmente te animamos a que eches un vistazo al Hub para modelos en diferentes idiomas, modelos especializados en tu campo, y más.
Puedes comparar directamente los resultados de los modelos desde tu navegador en el Hub para ver si se adapta o
maneja casos de borde mejor que otros.
Y si no encuentras un modelo para tu caso de uso, siempre puedes empezar a <a href="training">entrenar</a> el tuyo propio.`,ms,_,Ha="Si tienes varias entradas, puedes pasar tu entrada como una lista:",ds,Y,us,N,Ra=`Los pipelines son ideales para la experimentación, ya que cambiar de un modelo a otro es trivial; sin embargo, hay algunas formas de optimizarlas para cargas de trabajo más grandes que la experimentación. Consulta las siguientes guías que profundizan en iterar sobre conjuntos de datos completos o utilizar pipelines en un servidor web:
de la documentación:`,hs,V,za='<li><a href="#uso-de-pipelines-en-un-conjunto-de-datos">Uso de pipelines en un conjunto de datos</a></li> <li><a href="./pipeline_webserver">Uso de pipelines para un servidor web</a></li>',Ms,L,gs,S,_a="<code>pipeline()</code> admite muchos parámetros; algunos son específicos de la tarea y algunos son generales para todas las pipelines. En general, puedes especificar parámetros en cualquier lugar que desees:",js,F,fs,E,Ya="Vamos a echar un vistazo a tres importantes:",ys,Q,bs,P,Na="Si usas <code>device=n</code>, el pipeline automáticamente coloca el modelo en el dispositivo especificado. Esto funcionará independientemente de si estás utilizando PyTorch o Tensorflow.",ws,A,Ts,D,Va='Si el modelo es demasiado grande para una sola GPU y estás utilizando PyTorch, puedes establecer <code>device_map=&quot;auto&quot;</code> para determinar automáticamente cómo cargar y almacenar los pesos del modelo. Utilizar el argumento <code>device_map</code> requiere el paquete 🤗 <a href="https://huggingface.co/docs/accelerate" rel="nofollow">Accelerate</a>:',Js,K,$s,O,La="El siguiente código carga y almacena automáticamente los pesos del modelo en varios dispositivos:",Us,ee,vs,se,Sa="Tenga en cuenta que si se pasa <code>device_map=&quot;auto&quot;</code>, no es necesario agregar el argumento <code>device=device</code> al instanciar tu <code>pipeline</code>, ¡ya que podrías encontrar algún comportamiento inesperado!",Zs,ae,Is,te,Fa='Por defecto, los pipelines no realizarán inferencia por lotes por razones explicadas en detalle <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#pipeline-batching" rel="nofollow">aquí</a>. La razón es que la agrupación en lotes no es necesariamente más rápida y, de hecho, puede ser bastante más lenta en algunos casos.',Gs,le,Ea="Pero si funciona en tu caso de uso, puedes utilizar:",xs,ne,ks,ie,Qa="Esto ejecuta el pipeline en los 4 archivos de audio proporcionados, pero los pasará en lotes de a 2 al modelo (que está en una GPU, donde la agrupación en lotes es más probable que ayude) sin requerir ningún código adicional de tu parte. La salida siempre debería coincidir con lo que habrías recibido sin agrupación en lotes. Solo se pretende como una forma de ayudarte a obtener más velocidad de una pipeline.",Bs,pe,Pa='Los pipelines también pueden aliviar algunas de las complejidades de la agrupación en lotes porque, para algunos pipelines, un solo elemento (como un archivo de audio largo) necesita ser dividido en varias partes para ser procesado por un modelo. El pipeline realiza esta <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#pipeline-chunk-batching" rel="nofollow"><em>agrupación en lotes de fragmentos</em></a> por ti.',Ws,oe,Cs,re,Aa="Todas las tareas proporcionan parámetros específicos de la tarea que permiten flexibilidad adicional y opciones para ayudarte a completar tu trabajo. Por ejemplo, el método <code>transformers.AutomaticSpeechRecognitionPipeline.__call__()</code> tiene un parámetro <code>return_timestamps</code> que suena prometedor para subtítulos de videos:",qs,ce,Xs,me,Da="Como puedes ver, el modelo infirió el texto y también salió <strong>cuándo</strong> se pronunciaron las distintas oraciones.",Hs,de,Ka="Hay muchos parámetros disponibles para cada tarea, así que echa un vistazo a la referencia de la API de cada tarea para ver qué puedes ajustar. Por ejemplo, el <code>AutomaticSpeechRecognitionPipeline</code> tiene un parámetro <code>chunk_length_s</code> que es útil para trabajar con archivos de audio realmente largos (por ejemplo, subtítulos de películas completas o videos de una hora de duración) que un modelo típicamente no puede manejar solo:",Rs,ue,zs,he,Oa='¡Si no puedes encontrar un parámetro que te ayude, no dudes en <a href="https://github.com/huggingface/transformers/issues/new?assignees=&amp;labels=feature&amp;template=feature-request.yml" rel="nofollow">solicitarlo</a>!',_s,Me,Ys,ge,et="Los pipeline también puede ejecutar inferencia en un conjunto de datos grande. La forma más fácil que recomendamos para hacer esto es utilizando un iterador:",Ns,je,Vs,fe,st=`El iterador <code>data()</code> produce cada resultado, y el pipeline automáticamente
reconoce que la entrada es iterable y comenzará a buscar los datos mientras
continúa procesándolos en la GPU (dicho proceso utiliza <a href="https://pytorch.org/docs/stable/data.html#torch.utils.data.DataLoader" rel="nofollow">DataLoader</a>). Esto es importante porque no tienes que asignar memoria para todo el conjunto de datos y puedes alimentar la GPU lo más rápido posible.`,Ls,ye,at="Dado que la agrupación en lotes podría acelerar las cosas, puede ser útil intentar ajustar el parámetro <code>batch_size</code> aquí.",Ss,be,tt='La forma más sencilla de iterar sobre un conjunto de datos es cargandolo desde 🤗 <a href="https://github.com/huggingface/datasets/" rel="nofollow">Datasets</a>:',Fs,we,Es,Te,Qs,Z,Ps,Je,lt='<a href="./pipeline_webserver">Link</a>',As,$e,Ds,Ue,nt="Usar un <code>pipeline()</code> para tareas de visión es prácticamente idéntico.",Ks,ve,it="Especifica tu tarea y pasa tu imagen al clasificador. La imagen puede ser un enlace, una ruta local o una imagen codificada en base64. Por ejemplo, ¿qué especie de gato se muestra a continuación?",Os,Ze,pt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg" alt="pipeline-cat-chonk"/>',ea,Ie,sa,Ge,aa,xe,ot="Usar un <code>pipeline()</code> para tareas de PLN es prácticamente idéntico.",ta,ke,la,Be,na,We,rt="<code>pipeline()</code> admite más de una modalidad. Por ejemplo, una tarea de respuesta a preguntas visuales (VQA) combina texto e imagen. No dudes en usar cualquier enlace de imagen que desees y una pregunta que quieras hacer sobre la imagen. La imagen puede ser una URL o una ruta local a la imagen.",ia,Ce,ct='Por ejemplo, si usas esta <a href="https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png" rel="nofollow">imagen de factura</a>:',pa,qe,oa,I,ra,Xe,ca,He,mt="¡Puedes ejecutar fácilmente <code>pipeline</code> en modelos grandes utilizando 🤗 <code>accelerate</code>! Primero asegúrate de haber instalado <code>accelerate</code> con <code>pip install accelerate</code>.",ma,Re,dt="¡Luego carga tu modelo utilizando <code>device_map=&quot;auto&quot;</code>! Utilizaremos <code>facebook/opt-1.3b</code> para nuestro ejemplo.",da,ze,ua,_e,ut="También puedes pasar modelos cargados de 8 bits sí instalas <code>bitsandbytes</code> y agregas el argumento <code>load_in_8bit=True</code>",ha,Ye,Ma,Ne,ht="Nota que puedes reemplazar el punto de control con cualquier modelo de Hugging Face que admita la carga de modelos grandes, como BLOOM.",ga,Ve,ja,Le,Mt='Los pipelines están automáticamente soportadas en <a href="https://github.com/gradio-app/gradio/" rel="nofollow">Gradio</a>, una biblioteca que hace que crear aplicaciones de aprendizaje automático hermosas y fáciles de usar en la web sea un proceso sencillo. Primero, asegúrate de tener Gradio instalado:',fa,Se,ya,Fe,gt="Luego, puedes crear una demo web alrededor de una pipeline de clasificación de imágenes (o cualquier otra pipeline) en una sola línea de código llamando a la función <code>Interface.from_pipeline</code> de Gradio para lanzar la pipeline. Esto crea una interfaz intuitiva <em>drag-and-drop</em> en tu navegador:",ba,Ee,wa,Qe,jt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/panda-classification.png"/>',Ta,Pe,ft='De forma predeterminada, la demo web se ejecuta en un servidor local. Si deseas compartirlo con otros, puedes generar un enlace público temporal estableciendo <code>share=True</code> en <code>launch()</code>. También puedes hospedar tu demo en <a href="https://huggingface.co/spaces" rel="nofollow">Hugging Face Spaces</a> para un enlace permanente.',Ja,Ae,$a,De,Ua;return T=new w({props:{title:"Pipelines para inferencia",local:"pipelines-para-inferencia",headingTag:"h1"}}),U=new Za({props:{$$slots:{default:[Wt]},$$scope:{ctx:$}}}),x=new w({props:{title:"Uso del pipeline",local:"uso-del-pipeline",headingTag:"h2"}}),W=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(task=<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>)`,wrap:!1}}),C=new g({props:{code:"dHJhbnNjcmliZXIoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;I HAVE A DREAM BUT ONE DAY THIS NATION WILL RISE UP LIVE UP THE TRUE MEANING OF ITS TREES&#x27;</span>}`,wrap:!1}}),R=new g({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIpJTBBdHJhbnNjcmliZXIoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; I have a dream that one day this nation will rise up and live out the true meaning of its creed.&#x27;</span>}`,wrap:!1}}),Y=new g({props:{code:"dHJhbnNjcmliZXIoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRk5hcnNpbCUyRmFzcl9kdW1teSUyRnJlc29sdmUlMkZtYWluJTJGMS5mbGFjJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKQ==",highlighted:`transcriber(
    [
        <span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>,
        <span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/1.flac&quot;</span>,
    ]
)`,wrap:!1}}),L=new w({props:{title:"Parámetros",local:"parámetros",headingTag:"h2"}}),F=new g({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBteV9wYXJhbWV0ZXIlM0QxKSUwQSUwQW91dCUyMCUzRCUyMHRyYW5zY3JpYmVyKC4uLiklMjAlMjAlMjMlMjBUaGlzJTIwd2lsbCUyMHVzZSUyMCU2MG15X3BhcmFtZXRlciUzRDElNjAuJTBBb3V0JTIwJTNEJTIwdHJhbnNjcmliZXIoLi4uJTJDJTIwbXlfcGFyYW1ldGVyJTNEMiklMjAlMjAlMjMlMjBUaGlzJTIwd2lsbCUyMG92ZXJyaWRlJTIwYW5kJTIwdXNlJTIwJTYwbXlfcGFyYW1ldGVyJTNEMiU2MC4lMEFvdXQlMjAlM0QlMjB0cmFuc2NyaWJlciguLi4pJTIwJTIwJTIzJTIwVGhpcyUyMHdpbGwlMjBnbyUyMGJhY2slMjB0byUyMHVzaW5nJTIwJTYwbXlfcGFyYW1ldGVyJTNEMSU2MC4=",highlighted:'transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, my_parameter=<span class="hljs-number">1</span>)\n\nout = transcriber(...)  <span class="hljs-comment"># This will use `my_parameter=1`.</span>\nout = transcriber(..., my_parameter=<span class="hljs-number">2</span>)  <span class="hljs-comment"># This will override and use `my_parameter=2`.</span>\nout = transcriber(...)  <span class="hljs-comment"># This will go back to using `my_parameter=1`.</span>',wrap:!1}}),Q=new w({props:{title:"Device",local:"device",headingTag:"h3"}}),A=new g({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBkZXZpY2UlM0QwKQ==",highlighted:'transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, device=<span class="hljs-number">0</span>)',wrap:!1}}),K=new g({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMGFjY2VsZXJhdGU=",highlighted:"pip install --upgrade accelerate",wrap:!1}}),ee=new g({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:'transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)',wrap:!1}}),ae=new w({props:{title:"Batch size",local:"batch-size",headingTag:"h3"}}),ne=new g({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBkZXZpY2UlM0QwJTJDJTIwYmF0Y2hfc2l6ZSUzRDIpJTBBYXVkaW9fZmlsZW5hbWVzJTIwJTNEJTIwJTVCZiUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRk5hcnNpbCUyRmFzcl9kdW1teSUyRnJlc29sdmUlMkZtYWluJTJGJTdCaSU3RC5mbGFjJTIyJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMSUyQyUyMDUpJTVEJTBBdGV4dHMlMjAlM0QlMjB0cmFuc2NyaWJlcihhdWRpb19maWxlbmFtZXMp",highlighted:`transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, device=<span class="hljs-number">0</span>, batch_size=<span class="hljs-number">2</span>)
audio_filenames = [<span class="hljs-string">f&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/<span class="hljs-subst">{i}</span>.flac&quot;</span> <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1</span>, <span class="hljs-number">5</span>)]
texts = transcriber(audio_filenames)`,wrap:!1}}),oe=new w({props:{title:"Task specific parameters",local:"task-specific-parameters",headingTag:"h3"}}),ce=new g({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjByZXR1cm5fdGltZXN0YW1wcyUzRFRydWUpJTBBdHJhbnNjcmliZXIoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, return_timestamps=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; I have a dream that one day this nation will rise up and live out the true meaning of its creed.&#x27;</span>, <span class="hljs-string">&#x27;chunks&#x27;</span>: [{<span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">0.0</span>, <span class="hljs-number">11.88</span>), <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; I have a dream that one day this nation will rise up and live out the true meaning of its&#x27;</span>}, {<span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">11.88</span>, <span class="hljs-number">12.38</span>), <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; creed.&#x27;</span>}]}`,wrap:!1}}),ue=new g({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBjaHVua19sZW5ndGhfcyUzRDMwKSUwQXRyYW5zY3JpYmVyKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRnJlYWNoLXZiJTJGcmFuZG9tLWF1ZGlvcyUyRnJlc29sdmUlMkZtYWluJTJGdGVkXzYwLndhdiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, chunk_length_s=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/reach-vb/random-audios/resolve/main/ted_60.wav&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&quot; So in college, I was a government major, which means I had to write a lot of papers. Now, when a normal student writes a paper, they might spread the work out a little like this. So, you know. You get started maybe a little slowly, but you get enough done in the first week that with some heavier days later on, everything gets done and things stay civil. And I would want to do that like that. That would be the plan. I would have it all ready to go, but then actually the paper would come along, and then I would kind of do this. And that would happen every single paper. But then came my 90-page senior thesis, a paper you&#x27;re supposed to spend a year on. I knew for a paper like that, my normal workflow was not an option, it was way too big a project. So I planned things out and I decided I kind of had to go something like this. This is how the year would go. So I&#x27;d start off light and I&#x27;d bump it up&quot;</span>}`,wrap:!1}}),Me=new w({props:{title:"Uso de pipelines en un conjunto de datos",local:"uso-de-pipelines-en-un-conjunto-de-datos",headingTag:"h2"}}),je=new g({props:{code:"ZGVmJTIwZGF0YSgpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMTAwMCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB5aWVsZCUyMGYlMjJNeSUyMGV4YW1wbGUlMjAlN0JpJTdEJTIyJTBBJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIlMkMlMjBkZXZpY2UlM0QwKSUwQWdlbmVyYXRlZF9jaGFyYWN0ZXJzJTIwJTNEJTIwMCUwQWZvciUyMG91dCUyMGluJTIwcGlwZShkYXRhKCkpJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVkX2NoYXJhY3RlcnMlMjAlMkIlM0QlMjBsZW4ob3V0JTVCMCU1RCU1QiUyMmdlbmVyYXRlZF90ZXh0JTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">data</span>():
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>):
        <span class="hljs-keyword">yield</span> <span class="hljs-string">f&quot;My example <span class="hljs-subst">{i}</span>&quot;</span>


pipe = pipeline(model=<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, device=<span class="hljs-number">0</span>)
generated_characters = <span class="hljs-number">0</span>
<span class="hljs-keyword">for</span> out <span class="hljs-keyword">in</span> pipe(data()):
    generated_characters += <span class="hljs-built_in">len</span>(out[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>])`,wrap:!1}}),we=new g({props:{code:"JTIzJTIwS2V5RGF0YXNldCUyMGlzJTIwYSUyMHV0aWwlMjB0aGF0JTIwd2lsbCUyMGp1c3QlMjBvdXRwdXQlMjB0aGUlMjBpdGVtJTIwd2UncmUlMjBpbnRlcmVzdGVkJTIwaW4uJTBBZnJvbSUyMHRyYW5zZm9ybWVycy5waXBlbGluZXMucHRfdXRpbHMlMjBpbXBvcnQlMjBLZXlEYXRhc2V0JTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRnRpbnktcmFuZG9tLXdhdjJ2ZWMyJTIyJTJDJTIwZGV2aWNlJTNEMCklMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiU1QiUzQTEwJTVEJTIyKSUwQSUwQWZvciUyMG91dCUyMGluJTIwcGlwZShLZXlEYXRhc2V0KGRhdGFzZXQlMkMlMjAlMjJhdWRpbyUyMikpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQob3V0KQ==",highlighted:`<span class="hljs-comment"># KeyDataset is a util that will just output the item we&#x27;re interested in.</span>
<span class="hljs-keyword">from</span> transformers.pipelines.pt_utils <span class="hljs-keyword">import</span> KeyDataset
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

pipe = pipeline(model=<span class="hljs-string">&quot;hf-internal-testing/tiny-random-wav2vec2&quot;</span>, device=<span class="hljs-number">0</span>)
dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation[:10]&quot;</span>)

<span class="hljs-keyword">for</span> out <span class="hljs-keyword">in</span> pipe(KeyDataset(dataset, <span class="hljs-string">&quot;audio&quot;</span>)):
    <span class="hljs-built_in">print</span>(out)`,wrap:!1}}),Te=new w({props:{title:"Uso de pipelines para un servidor web",local:"uso-de-pipelines-para-un-servidor-web",headingTag:"h2"}}),Z=new Za({props:{$$slots:{default:[Ct]},$$scope:{ctx:$}}}),$e=new w({props:{title:"Pipeline de visión",local:"pipeline-de-visión",headingTag:"h2"}}),Ie=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdmlzaW9uX2NsYXNzaWZpZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQXByZWRzJTIwJTNEJTIwdmlzaW9uX2NsYXNzaWZpZXIoJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTNEJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIlMEEpJTBBcHJlZHMlMjAlM0QlMjAlNUIlN0IlMjJzY29yZSUyMiUzQSUyMHJvdW5kKHByZWQlNUIlMjJzY29yZSUyMiU1RCUyQyUyMDQpJTJDJTIwJTIybGFiZWwlMjIlM0ElMjBwcmVkJTVCJTIybGFiZWwlMjIlNUQlN0QlMjBmb3IlMjBwcmVkJTIwaW4lMjBwcmVkcyU1RCUwQXByZWRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>vision_classifier = pipeline(model=<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = vision_classifier(
<span class="hljs-meta">... </span>    images=<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4335</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;lynx, catamount&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0348</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cougar, puma, catamount, mountain lion, painter, panther, Felis concolor&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0324</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow leopard, ounce, Panthera uncia&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0239</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Egyptian cat&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0229</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tiger cat&#x27;</span>}]`,wrap:!1}}),Ge=new w({props:{title:"Pipeline de texto",local:"pipeline-de-texto",headingTag:"h2"}}),ke=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBJTIzJTIwVGhpcyUyMG1vZGVsJTIwaXMlMjBhJTIwJTYwemVyby1zaG90LWNsYXNzaWZpY2F0aW9uJTYwJTIwbW9kZWwuJTBBJTIzJTIwSXQlMjB3aWxsJTIwY2xhc3NpZnklMjB0ZXh0JTJDJTIwZXhjZXB0JTIweW91JTIwYXJlJTIwZnJlZSUyMHRvJTIwY2hvb3NlJTIwYW55JTIwbGFiZWwlMjB5b3UlMjBtaWdodCUyMGltYWdpbmUlMEFjbGFzc2lmaWVyJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJmYWNlYm9vayUyRmJhcnQtbGFyZ2UtbW5saSUyMiklMEFjbGFzc2lmaWVyKCUwQSUyMCUyMCUyMCUyMCUyMkklMjBoYXZlJTIwYSUyMHByb2JsZW0lMjB3aXRoJTIwbXklMjBpcGhvbmUlMjB0aGF0JTIwbmVlZHMlMjB0byUyMGJlJTIwcmVzb2x2ZWQlMjBhc2FwISElMjIlMkMlMEElMjAlMjAlMjAlMjBjYW5kaWRhdGVfbGFiZWxzJTNEJTVCJTIydXJnZW50JTIyJTJDJTIwJTIybm90JTIwdXJnZW50JTIyJTJDJTIwJTIycGhvbmUlMjIlMkMlMjAlMjJ0YWJsZXQlMjIlMkMlMjAlMjJjb21wdXRlciUyMiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This model is a \`zero-shot-classification\` model.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># It will classify text, except you are free to choose any label you might imagine</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(model=<span class="hljs-string">&quot;facebook/bart-large-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>classifier(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;I have a problem with my iphone that needs to be resolved asap!!&quot;</span>,
<span class="hljs-meta">... </span>    candidate_labels=[<span class="hljs-string">&quot;urgent&quot;</span>, <span class="hljs-string">&quot;not urgent&quot;</span>, <span class="hljs-string">&quot;phone&quot;</span>, <span class="hljs-string">&quot;tablet&quot;</span>, <span class="hljs-string">&quot;computer&quot;</span>],
<span class="hljs-meta">... </span>)
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;I have a problem with my iphone that needs to be resolved asap!!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;urgent&#x27;</span>, <span class="hljs-string">&#x27;phone&#x27;</span>, <span class="hljs-string">&#x27;computer&#x27;</span>, <span class="hljs-string">&#x27;not urgent&#x27;</span>, <span class="hljs-string">&#x27;tablet&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.504</span>, <span class="hljs-number">0.479</span>, <span class="hljs-number">0.013</span>, <span class="hljs-number">0.003</span>, <span class="hljs-number">0.002</span>]}`,wrap:!1}}),Be=new w({props:{title:"Pipeline multimodal",local:"pipeline-multimodal",headingTag:"h2"}}),qe=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdnFhJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJpbXBpcmElMkZsYXlvdXRsbS1kb2N1bWVudC1xYSUyMiklMEFvdXRwdXQlMjAlM0QlMjB2cWEoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3BhY2VzJTJGaW1waXJhJTJGZG9jcXVlcnklMkZyZXNvbHZlJTJGMjM1OTIyM2MxODM3YTc1ODc0MDJiZGEwZjI2NDMzODJhNmVlZmVhYiUyRmludm9pY2UucG5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lM0QlMjJXaGF0JTIwaXMlMjB0aGUlMjBpbnZvaWNlJTIwbnVtYmVyJTNGJTIyJTJDJTBBKSUwQW91dHB1dCU1QjAlNUQlNUIlMjJzY29yZSUyMiU1RCUyMCUzRCUyMHJvdW5kKG91dHB1dCU1QjAlNUQlNUIlMjJzY29yZSUyMiU1RCUyQyUyMDMpJTBBb3V0cHV0",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>vqa = pipeline(model=<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = vqa(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&quot;</span>,
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the invoice number?&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;score&quot;</span>] = <span class="hljs-built_in">round</span>(output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">3</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.425</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;us-001&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">16</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">16</span>}]`,wrap:!1}}),I=new Za({props:{$$slots:{default:[qt]},$$scope:{ctx:$}}}),Xe=new w({props:{title:"Uso de pipeline en modelos grandes con 🤗 accelerate :",local:"uso-de-pipeline-en-modelos-grandes-con--accelerate-",headingTag:"h2"}}),ze=new g({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGUlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBwaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBb3V0cHV0JTIwJTNEJTIwcGlwZSglMjJUaGlzJTIwaXMlMjBhJTIwY29vbCUyMGV4YW1wbGUhJTIyJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMHRvcF9wJTNEMC45NSk=",highlighted:`<span class="hljs-comment"># pip install accelerate</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(model=<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
output = pipe(<span class="hljs-string">&quot;This is a cool example!&quot;</span>, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.95</span>)`,wrap:!1}}),Ye=new g({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGUlMjBiaXRzYW5kYnl0ZXMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBwaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMG1vZGVsX2t3YXJncyUzRCU3QiUyMmxvYWRfaW5fOGJpdCUyMiUzQSUyMFRydWUlN0QpJTBBb3V0cHV0JTIwJTNEJTIwcGlwZSglMjJUaGlzJTIwaXMlMjBhJTIwY29vbCUyMGV4YW1wbGUhJTIyJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMHRvcF9wJTNEMC45NSk=",highlighted:`<span class="hljs-comment"># pip install accelerate bitsandbytes</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(model=<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, model_kwargs={<span class="hljs-string">&quot;load_in_8bit&quot;</span>: <span class="hljs-literal">True</span>})
output = pipe(<span class="hljs-string">&quot;This is a cool example!&quot;</span>, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.95</span>)`,wrap:!1}}),Ve=new w({props:{title:"Crear demos web desde pipelines con gradio",local:"crear-demos-web-desde-pipelines-con-gradio",headingTag:"h2"}}),Se=new g({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdyYWRpbw==",highlighted:'pip <span class="hljs-keyword">install</span> gradio',wrap:!1}}),Ee=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSglMjJpbWFnZS1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBJTBBZ3IuSW50ZXJmYWNlLmZyb21fcGlwZWxpbmUocGlwZSkubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

pipe = pipeline(<span class="hljs-string">&quot;image-classification&quot;</span>, model=<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)

gr.Interface.from_pipeline(pipe).launch()`,wrap:!1}}),Ae=new Bt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/es/pipeline_tutorial.md"}}),{c(){M=i("meta"),y=l(),f=i("p"),b=l(),r(T.$$.fragment),j=l(),J=i("p"),J.innerHTML=Ia,Ke=l(),G=i("ul"),G.innerHTML=Ga,Oe=l(),r(U.$$.fragment),es=l(),r(x.$$.fragment),ss=l(),k=i("p"),k.innerHTML=xa,as=l(),B=i("ol"),B.innerHTML=ka,ts=l(),r(W.$$.fragment),ls=l(),v=i("ol"),v.innerHTML=Ba,ns=l(),r(C.$$.fragment),is=l(),q=i("p"),q.innerHTML=Wa,ps=l(),X=i("p"),X.innerHTML=Ca,os=l(),H=i("p"),H.textContent=qa,rs=l(),r(R.$$.fragment),cs=l(),z=i("p"),z.innerHTML=Xa,ms=l(),_=i("p"),_.textContent=Ha,ds=l(),r(Y.$$.fragment),us=l(),N=i("p"),N.textContent=Ra,hs=l(),V=i("ul"),V.innerHTML=za,Ms=l(),r(L.$$.fragment),gs=l(),S=i("p"),S.innerHTML=_a,js=l(),r(F.$$.fragment),fs=l(),E=i("p"),E.textContent=Ya,ys=l(),r(Q.$$.fragment),bs=l(),P=i("p"),P.innerHTML=Na,ws=l(),r(A.$$.fragment),Ts=l(),D=i("p"),D.innerHTML=Va,Js=l(),r(K.$$.fragment),$s=l(),O=i("p"),O.textContent=La,Us=l(),r(ee.$$.fragment),vs=l(),se=i("p"),se.innerHTML=Sa,Zs=l(),r(ae.$$.fragment),Is=l(),te=i("p"),te.innerHTML=Fa,Gs=l(),le=i("p"),le.textContent=Ea,xs=l(),r(ne.$$.fragment),ks=l(),ie=i("p"),ie.textContent=Qa,Bs=l(),pe=i("p"),pe.innerHTML=Pa,Ws=l(),r(oe.$$.fragment),Cs=l(),re=i("p"),re.innerHTML=Aa,qs=l(),r(ce.$$.fragment),Xs=l(),me=i("p"),me.innerHTML=Da,Hs=l(),de=i("p"),de.innerHTML=Ka,Rs=l(),r(ue.$$.fragment),zs=l(),he=i("p"),he.innerHTML=Oa,_s=l(),r(Me.$$.fragment),Ys=l(),ge=i("p"),ge.textContent=et,Ns=l(),r(je.$$.fragment),Vs=l(),fe=i("p"),fe.innerHTML=st,Ls=l(),ye=i("p"),ye.innerHTML=at,Ss=l(),be=i("p"),be.innerHTML=tt,Fs=l(),r(we.$$.fragment),Es=l(),r(Te.$$.fragment),Qs=l(),r(Z.$$.fragment),Ps=l(),Je=i("p"),Je.innerHTML=lt,As=l(),r($e.$$.fragment),Ds=l(),Ue=i("p"),Ue.innerHTML=nt,Ks=l(),ve=i("p"),ve.textContent=it,Os=l(),Ze=i("p"),Ze.innerHTML=pt,ea=l(),r(Ie.$$.fragment),sa=l(),r(Ge.$$.fragment),aa=l(),xe=i("p"),xe.innerHTML=ot,ta=l(),r(ke.$$.fragment),la=l(),r(Be.$$.fragment),na=l(),We=i("p"),We.innerHTML=rt,ia=l(),Ce=i("p"),Ce.innerHTML=ct,pa=l(),r(qe.$$.fragment),oa=l(),r(I.$$.fragment),ra=l(),r(Xe.$$.fragment),ca=l(),He=i("p"),He.innerHTML=mt,ma=l(),Re=i("p"),Re.innerHTML=dt,da=l(),r(ze.$$.fragment),ua=l(),_e=i("p"),_e.innerHTML=ut,ha=l(),r(Ye.$$.fragment),Ma=l(),Ne=i("p"),Ne.textContent=ht,ga=l(),r(Ve.$$.fragment),ja=l(),Le=i("p"),Le.innerHTML=Mt,fa=l(),r(Se.$$.fragment),ya=l(),Fe=i("p"),Fe.innerHTML=gt,ba=l(),r(Ee.$$.fragment),wa=l(),Qe=i("p"),Qe.innerHTML=jt,Ta=l(),Pe=i("p"),Pe.innerHTML=ft,Ja=l(),r(Ae.$$.fragment),$a=l(),De=i("p"),this.h()},l(e){const s=It("svelte-u9bgzb",document.head);M=p(s,"META",{name:!0,content:!0}),s.forEach(a),y=n(e),f=p(e,"P",{}),Tt(f).forEach(a),b=n(e),c(T.$$.fragment,e),j=n(e),J=p(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-ysy02b"&&(J.innerHTML=Ia),Ke=n(e),G=p(e,"UL",{"data-svelte-h":!0}),o(G)!=="svelte-7f1ymp"&&(G.innerHTML=Ga),Oe=n(e),c(U.$$.fragment,e),es=n(e),c(x.$$.fragment,e),ss=n(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-rwymnf"&&(k.innerHTML=xa),as=n(e),B=p(e,"OL",{"data-svelte-h":!0}),o(B)!=="svelte-yki1ef"&&(B.innerHTML=ka),ts=n(e),c(W.$$.fragment,e),ls=n(e),v=p(e,"OL",{start:!0,"data-svelte-h":!0}),o(v)!=="svelte-1caahvs"&&(v.innerHTML=Ba),ns=n(e),c(C.$$.fragment,e),is=n(e),q=p(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-7qscss"&&(q.innerHTML=Wa),ps=n(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1h4c17"&&(X.innerHTML=Ca),os=n(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-lrwk22"&&(H.textContent=qa),rs=n(e),c(R.$$.fragment,e),cs=n(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-7507p"&&(z.innerHTML=Xa),ms=n(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-wo3wsg"&&(_.textContent=Ha),ds=n(e),c(Y.$$.fragment,e),us=n(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1eymkwg"&&(N.textContent=Ra),hs=n(e),V=p(e,"UL",{"data-svelte-h":!0}),o(V)!=="svelte-10wlszr"&&(V.innerHTML=za),Ms=n(e),c(L.$$.fragment,e),gs=n(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1w6audj"&&(S.innerHTML=_a),js=n(e),c(F.$$.fragment,e),fs=n(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1w820uy"&&(E.textContent=Ya),ys=n(e),c(Q.$$.fragment,e),bs=n(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1uz98w3"&&(P.innerHTML=Na),ws=n(e),c(A.$$.fragment,e),Ts=n(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-wy7bp4"&&(D.innerHTML=Va),Js=n(e),c(K.$$.fragment,e),$s=n(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-z7rdkf"&&(O.textContent=La),Us=n(e),c(ee.$$.fragment,e),vs=n(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-162dy4v"&&(se.innerHTML=Sa),Zs=n(e),c(ae.$$.fragment,e),Is=n(e),te=p(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-1eqkd1i"&&(te.innerHTML=Fa),Gs=n(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-5vor7z"&&(le.textContent=Ea),xs=n(e),c(ne.$$.fragment,e),ks=n(e),ie=p(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-1wd3koo"&&(ie.textContent=Qa),Bs=n(e),pe=p(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-1ht9vdv"&&(pe.innerHTML=Pa),Ws=n(e),c(oe.$$.fragment,e),Cs=n(e),re=p(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-1ainvpy"&&(re.innerHTML=Aa),qs=n(e),c(ce.$$.fragment,e),Xs=n(e),me=p(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-ca3vvb"&&(me.innerHTML=Da),Hs=n(e),de=p(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-lzu41c"&&(de.innerHTML=Ka),Rs=n(e),c(ue.$$.fragment,e),zs=n(e),he=p(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-1etjsvo"&&(he.innerHTML=Oa),_s=n(e),c(Me.$$.fragment,e),Ys=n(e),ge=p(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-1hugbdt"&&(ge.textContent=et),Ns=n(e),c(je.$$.fragment,e),Vs=n(e),fe=p(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-1lqeu4h"&&(fe.innerHTML=st),Ls=n(e),ye=p(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-11jhj14"&&(ye.innerHTML=at),Ss=n(e),be=p(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-8xg127"&&(be.innerHTML=tt),Fs=n(e),c(we.$$.fragment,e),Es=n(e),c(Te.$$.fragment,e),Qs=n(e),c(Z.$$.fragment,e),Ps=n(e),Je=p(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-52dmam"&&(Je.innerHTML=lt),As=n(e),c($e.$$.fragment,e),Ds=n(e),Ue=p(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-9pmk0k"&&(Ue.innerHTML=nt),Ks=n(e),ve=p(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-1gqy93z"&&(ve.textContent=it),Os=n(e),Ze=p(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-1bks2jw"&&(Ze.innerHTML=pt),ea=n(e),c(Ie.$$.fragment,e),sa=n(e),c(Ge.$$.fragment,e),aa=n(e),xe=p(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-1qfk8ao"&&(xe.innerHTML=ot),ta=n(e),c(ke.$$.fragment,e),la=n(e),c(Be.$$.fragment,e),na=n(e),We=p(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-3onle0"&&(We.innerHTML=rt),ia=n(e),Ce=p(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-1cnejsx"&&(Ce.innerHTML=ct),pa=n(e),c(qe.$$.fragment,e),oa=n(e),c(I.$$.fragment,e),ra=n(e),c(Xe.$$.fragment,e),ca=n(e),He=p(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-1ux6jbm"&&(He.innerHTML=mt),ma=n(e),Re=p(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-vgqa00"&&(Re.innerHTML=dt),da=n(e),c(ze.$$.fragment,e),ua=n(e),_e=p(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-e0hz9f"&&(_e.innerHTML=ut),ha=n(e),c(Ye.$$.fragment,e),Ma=n(e),Ne=p(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-1u2y2py"&&(Ne.textContent=ht),ga=n(e),c(Ve.$$.fragment,e),ja=n(e),Le=p(e,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-okul4k"&&(Le.innerHTML=Mt),fa=n(e),c(Se.$$.fragment,e),ya=n(e),Fe=p(e,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-4g1wj9"&&(Fe.innerHTML=gt),ba=n(e),c(Ee.$$.fragment,e),wa=n(e),Qe=p(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-rjj5jb"&&(Qe.innerHTML=jt),Ta=n(e),Pe=p(e,"P",{"data-svelte-h":!0}),o(Pe)!=="svelte-1lt3ba4"&&(Pe.innerHTML=ft),Ja=n(e),c(Ae.$$.fragment,e),$a=n(e),De=p(e,"P",{}),Tt(De).forEach(a),this.h()},h(){va(M,"name","hf:doc:metadata"),va(M,"content",Ht),va(v,"start","2")},m(e,s){Gt(document.head,M),t(e,y,s),t(e,f,s),t(e,b,s),m(T,e,s),t(e,j,s),t(e,J,s),t(e,Ke,s),t(e,G,s),t(e,Oe,s),m(U,e,s),t(e,es,s),m(x,e,s),t(e,ss,s),t(e,k,s),t(e,as,s),t(e,B,s),t(e,ts,s),m(W,e,s),t(e,ls,s),t(e,v,s),t(e,ns,s),m(C,e,s),t(e,is,s),t(e,q,s),t(e,ps,s),t(e,X,s),t(e,os,s),t(e,H,s),t(e,rs,s),m(R,e,s),t(e,cs,s),t(e,z,s),t(e,ms,s),t(e,_,s),t(e,ds,s),m(Y,e,s),t(e,us,s),t(e,N,s),t(e,hs,s),t(e,V,s),t(e,Ms,s),m(L,e,s),t(e,gs,s),t(e,S,s),t(e,js,s),m(F,e,s),t(e,fs,s),t(e,E,s),t(e,ys,s),m(Q,e,s),t(e,bs,s),t(e,P,s),t(e,ws,s),m(A,e,s),t(e,Ts,s),t(e,D,s),t(e,Js,s),m(K,e,s),t(e,$s,s),t(e,O,s),t(e,Us,s),m(ee,e,s),t(e,vs,s),t(e,se,s),t(e,Zs,s),m(ae,e,s),t(e,Is,s),t(e,te,s),t(e,Gs,s),t(e,le,s),t(e,xs,s),m(ne,e,s),t(e,ks,s),t(e,ie,s),t(e,Bs,s),t(e,pe,s),t(e,Ws,s),m(oe,e,s),t(e,Cs,s),t(e,re,s),t(e,qs,s),m(ce,e,s),t(e,Xs,s),t(e,me,s),t(e,Hs,s),t(e,de,s),t(e,Rs,s),m(ue,e,s),t(e,zs,s),t(e,he,s),t(e,_s,s),m(Me,e,s),t(e,Ys,s),t(e,ge,s),t(e,Ns,s),m(je,e,s),t(e,Vs,s),t(e,fe,s),t(e,Ls,s),t(e,ye,s),t(e,Ss,s),t(e,be,s),t(e,Fs,s),m(we,e,s),t(e,Es,s),m(Te,e,s),t(e,Qs,s),m(Z,e,s),t(e,Ps,s),t(e,Je,s),t(e,As,s),m($e,e,s),t(e,Ds,s),t(e,Ue,s),t(e,Ks,s),t(e,ve,s),t(e,Os,s),t(e,Ze,s),t(e,ea,s),m(Ie,e,s),t(e,sa,s),m(Ge,e,s),t(e,aa,s),t(e,xe,s),t(e,ta,s),m(ke,e,s),t(e,la,s),m(Be,e,s),t(e,na,s),t(e,We,s),t(e,ia,s),t(e,Ce,s),t(e,pa,s),m(qe,e,s),t(e,oa,s),m(I,e,s),t(e,ra,s),m(Xe,e,s),t(e,ca,s),t(e,He,s),t(e,ma,s),t(e,Re,s),t(e,da,s),m(ze,e,s),t(e,ua,s),t(e,_e,s),t(e,ha,s),m(Ye,e,s),t(e,Ma,s),t(e,Ne,s),t(e,ga,s),m(Ve,e,s),t(e,ja,s),t(e,Le,s),t(e,fa,s),m(Se,e,s),t(e,ya,s),t(e,Fe,s),t(e,ba,s),m(Ee,e,s),t(e,wa,s),t(e,Qe,s),t(e,Ta,s),t(e,Pe,s),t(e,Ja,s),m(Ae,e,s),t(e,$a,s),t(e,De,s),Ua=!0},p(e,[s]){const yt={};s&2&&(yt.$$scope={dirty:s,ctx:e}),U.$set(yt);const bt={};s&2&&(bt.$$scope={dirty:s,ctx:e}),Z.$set(bt);const wt={};s&2&&(wt.$$scope={dirty:s,ctx:e}),I.$set(wt)},i(e){Ua||(d(T.$$.fragment,e),d(U.$$.fragment,e),d(x.$$.fragment,e),d(W.$$.fragment,e),d(C.$$.fragment,e),d(R.$$.fragment,e),d(Y.$$.fragment,e),d(L.$$.fragment,e),d(F.$$.fragment,e),d(Q.$$.fragment,e),d(A.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),d(ae.$$.fragment,e),d(ne.$$.fragment,e),d(oe.$$.fragment,e),d(ce.$$.fragment,e),d(ue.$$.fragment,e),d(Me.$$.fragment,e),d(je.$$.fragment,e),d(we.$$.fragment,e),d(Te.$$.fragment,e),d(Z.$$.fragment,e),d($e.$$.fragment,e),d(Ie.$$.fragment,e),d(Ge.$$.fragment,e),d(ke.$$.fragment,e),d(Be.$$.fragment,e),d(qe.$$.fragment,e),d(I.$$.fragment,e),d(Xe.$$.fragment,e),d(ze.$$.fragment,e),d(Ye.$$.fragment,e),d(Ve.$$.fragment,e),d(Se.$$.fragment,e),d(Ee.$$.fragment,e),d(Ae.$$.fragment,e),Ua=!0)},o(e){u(T.$$.fragment,e),u(U.$$.fragment,e),u(x.$$.fragment,e),u(W.$$.fragment,e),u(C.$$.fragment,e),u(R.$$.fragment,e),u(Y.$$.fragment,e),u(L.$$.fragment,e),u(F.$$.fragment,e),u(Q.$$.fragment,e),u(A.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(ae.$$.fragment,e),u(ne.$$.fragment,e),u(oe.$$.fragment,e),u(ce.$$.fragment,e),u(ue.$$.fragment,e),u(Me.$$.fragment,e),u(je.$$.fragment,e),u(we.$$.fragment,e),u(Te.$$.fragment,e),u(Z.$$.fragment,e),u($e.$$.fragment,e),u(Ie.$$.fragment,e),u(Ge.$$.fragment,e),u(ke.$$.fragment,e),u(Be.$$.fragment,e),u(qe.$$.fragment,e),u(I.$$.fragment,e),u(Xe.$$.fragment,e),u(ze.$$.fragment,e),u(Ye.$$.fragment,e),u(Ve.$$.fragment,e),u(Se.$$.fragment,e),u(Ee.$$.fragment,e),u(Ae.$$.fragment,e),Ua=!1},d(e){e&&(a(y),a(f),a(b),a(j),a(J),a(Ke),a(G),a(Oe),a(es),a(ss),a(k),a(as),a(B),a(ts),a(ls),a(v),a(ns),a(is),a(q),a(ps),a(X),a(os),a(H),a(rs),a(cs),a(z),a(ms),a(_),a(ds),a(us),a(N),a(hs),a(V),a(Ms),a(gs),a(S),a(js),a(fs),a(E),a(ys),a(bs),a(P),a(ws),a(Ts),a(D),a(Js),a($s),a(O),a(Us),a(vs),a(se),a(Zs),a(Is),a(te),a(Gs),a(le),a(xs),a(ks),a(ie),a(Bs),a(pe),a(Ws),a(Cs),a(re),a(qs),a(Xs),a(me),a(Hs),a(de),a(Rs),a(zs),a(he),a(_s),a(Ys),a(ge),a(Ns),a(Vs),a(fe),a(Ls),a(ye),a(Ss),a(be),a(Fs),a(Es),a(Qs),a(Ps),a(Je),a(As),a(Ds),a(Ue),a(Ks),a(ve),a(Os),a(Ze),a(ea),a(sa),a(aa),a(xe),a(ta),a(la),a(na),a(We),a(ia),a(Ce),a(pa),a(oa),a(ra),a(ca),a(He),a(ma),a(Re),a(da),a(ua),a(_e),a(ha),a(Ma),a(Ne),a(ga),a(ja),a(Le),a(fa),a(ya),a(Fe),a(ba),a(wa),a(Qe),a(Ta),a(Pe),a(Ja),a($a),a(De)),a(M),h(T,e),h(U,e),h(x,e),h(W,e),h(C,e),h(R,e),h(Y,e),h(L,e),h(F,e),h(Q,e),h(A,e),h(K,e),h(ee,e),h(ae,e),h(ne,e),h(oe,e),h(ce,e),h(ue,e),h(Me,e),h(je,e),h(we,e),h(Te,e),h(Z,e),h($e,e),h(Ie,e),h(Ge,e),h(ke,e),h(Be,e),h(qe,e),h(I,e),h(Xe,e),h(ze,e),h(Ye,e),h(Ve,e),h(Se,e),h(Ee,e),h(Ae,e)}}}const Ht='{"title":"Pipelines para inferencia","local":"pipelines-para-inferencia","sections":[{"title":"Uso del pipeline","local":"uso-del-pipeline","sections":[],"depth":2},{"title":"Parámetros","local":"parámetros","sections":[{"title":"Device","local":"device","sections":[],"depth":3},{"title":"Batch size","local":"batch-size","sections":[],"depth":3},{"title":"Task specific parameters","local":"task-specific-parameters","sections":[],"depth":3}],"depth":2},{"title":"Uso de pipelines en un conjunto de datos","local":"uso-de-pipelines-en-un-conjunto-de-datos","sections":[],"depth":2},{"title":"Uso de pipelines para un servidor web","local":"uso-de-pipelines-para-un-servidor-web","sections":[],"depth":2},{"title":"Pipeline de visión","local":"pipeline-de-visión","sections":[],"depth":2},{"title":"Pipeline de texto","local":"pipeline-de-texto","sections":[],"depth":2},{"title":"Pipeline multimodal","local":"pipeline-multimodal","sections":[],"depth":2},{"title":"Uso de pipeline en modelos grandes con 🤗 accelerate :","local":"uso-de-pipeline-en-modelos-grandes-con--accelerate-","sections":[],"depth":2},{"title":"Crear demos web desde pipelines con gradio","local":"crear-demos-web-desde-pipelines-con-gradio","sections":[],"depth":2}],"depth":1}';function Rt($){return Ut(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Lt extends vt{constructor(M){super(),Zt(this,M,Rt,Xt,$t,{})}}export{Lt as component};
