import{s as mn,n as gn,o as jn}from"../chunks/scheduler.36a0863c.js";import{S as yn,i as hn,g as i,s as t,r as o,A as Mn,h as p,f as a,c as l,j as Fs,u as c,x as r,k as un,y as J,a as n,v as d,d as u,t as m,w as g}from"../chunks/index.f891bdb2.js";import{C as y}from"../chunks/CodeBlock.b05e74dc.js";import{H as j,E as Jn}from"../chunks/index.748128ce.js";function bn(xa){let h,Ss,Xs,_s,b,As,x,fa="🤗 Transformers es una biblioteca de modelos preentrenados de última generación para procesamiento del lenguaje natural (NLP, por sus siglas en inglés), visión por computadora y tareas de procesamiento de audio y voz. No solo contiene modelos Transformer, sino también modelos no Transformer como redes convolucionales modernas para tareas de visión por computadora. Si observas algunos de los productos de consumo más populares hoy en día, como teléfonos inteligentes, aplicaciones y televisores, es probable que haya alguna tecnología de aprendizaje profundo detrás. ¿Quieres quitar un objeto de fondo de una foto tomada por tu teléfono inteligente? Este es un ejemplo de una tarea de segmentación panóptica (no te preocupes si aún no sabes qué significa, ¡lo describiremos en las siguientes secciones!).",Ps,f,Ua="Esta página proporciona una descripción general de las diferentes tareas de procesamiento de audio y voz, visión por computadora y NLP que se pueden resolver con la biblioteca 🤗 Transformers en solo tres líneas de código.",Ks,U,Ds,T,Ta="Las tareas de procesamiento de audio y voz son un poco diferentes de las otras modalidades principalmente porque el audio como entrada es una señal continua. A diferencia del texto, una forma de onda de audio cruda no se puede dividir ordenadamente en fragmentos discretos de la misma manera en que una oración puede dividirse en palabras. Para superar esto, la señal de audio cruda generalmente se muestrea a intervalos regulares. Si tomas más muestras dentro de un intervalo, la tasa de muestreo es mayor y el audio se asemeja más a la fuente de audio original.",Os,w,wa="Enfoques anteriores preprocesaban el audio para extraer características útiles. Ahora es más común comenzar las tareas de procesamiento de audio y voz alimentando directamente la forma de onda de audio cruda a un codificador de características para extraer una representación de audio. Esto simplifica el paso de preprocesamiento y permite que el modelo aprenda las características más esenciales.",se,C,ee,v,Ca="La clasificación de audio es una tarea que etiqueta datos de audio con un conjunto predefinido de clases. Es una categoría amplia con muchas aplicaciones específicas, algunas de las cuales incluyen:",ae,Z,va="<li>clasificación de escena acústica: etiquetar audio con una etiqueta de escena (“oficina”, “playa”, “estadio”)</li> <li>detección de eventos acústicos: etiquetar audio con una etiqueta de evento de sonido (“bocina de automóvil”, “llamada de ballena”, “cristal rompiéndose”)</li> <li>etiquetado: etiquetar audio que contiene varios sonidos (canto de pájaros, identificación de altavoces en una reunión)</li> <li>clasificación de música: etiquetar música con una etiqueta de género (“metal”, “hip-hop”, “country”)</li>",ne,q,te,I,le,$,Za="El reconocimiento automático del habla (ASR, por sus siglas en inglés) transcribe el habla a texto. Es una de las tareas de audio más comunes, en parte debido a que el habla es una forma natural de comunicación humana. Hoy en día, los sistemas ASR están integrados en productos de tecnología “inteligente” como altavoces, teléfonos y automóviles. Podemos pedirle a nuestros asistentes virtuales que reproduzcan música, establezcan recordatorios y nos informen sobre el clima.",ie,B,qa="Pero uno de los desafíos clave que las arquitecturas Transformer han ayudado a superar es en los idiomas con recursos limitados. Al preentrenar con grandes cantidades de datos de habla, afinar el modelo solo con una hora de datos de habla etiquetados en un idioma con recursos limitados aún puede producir resultados de alta calidad en comparación con los sistemas ASR anteriores entrenados con 100 veces más datos etiquetados.",pe,W,re,k,oe,G,Ia='Una de las primeras y exitosas tareas de visión por computadora fue reconocer imágenes de números de código postal utilizando una <a href="glossary#convolution">red neuronal convolucional</a> (CNN, por sus siglas en inglés). Una imagen está compuesta por píxeles, y cada píxel tiene un valor numérico. Esto facilita representar una imagen como una matriz de valores de píxeles. Cada combinación particular de valores de píxeles describe los colores de una imagen.',ce,H,$a="Dos formas generales en las que se pueden resolver las tareas de visión por computadora son:",de,V,Ba="<li>Utilizar convoluciones para aprender las características jerárquicas de una imagen, desde características de bajo nivel hasta cosas abstractas de alto nivel.</li> <li>Dividir una imagen en parches y utilizar un Transformer para aprender gradualmente cómo cada parche de imagen se relaciona entre sí para formar una imagen. A diferencia del enfoque ascendente preferido por una CNN, esto es como comenzar con una imagen borrosa y luego enfocarla gradualmente.</li>",ue,N,me,R,Wa="La clasificación de imágenes etiqueta una imagen completa con un conjunto predefinido de clases. Como la mayoría de las tareas de clasificación, hay muchos casos prácticos para la clasificación de imágenes, algunos de los cuales incluyen:",ge,z,ka="<li>salud: etiquetar imágenes médicas para detectar enfermedades o monitorear la salud del paciente</li> <li>medio ambiente: etiquetar imágenes de satélite para monitorear la deforestación, informar la gestión de áreas silvestres o detectar incendios forestales</li> <li>agricultura: etiquetar imágenes de cultivos para monitorear la salud de las plantas o imágenes de satélite para el monitoreo del uso del suelo</li> <li>ecología: etiquetar imágenes de especies animales o vegetales para monitorear poblaciones de vida silvestre o rastrear especies en peligro de extinción</li>",je,E,ye,Q,he,Y,Ga="A diferencia de la clasificación de imágenes, la detección de objetos identifica múltiples objetos dentro de una imagen y las posiciones de los objetos en la imagen (definidas por el cuadro delimitador). Algunas aplicaciones ejemplares de la detección de objetos incluyen:",Me,X,Ha="<li>vehículos autónomos: detectar objetos de tráfico cotidianos como otros vehículos, peatones y semáforos</li> <li>teledetección: monitoreo de desastres, planificación urbana y pronóstico del tiempo</li> <li>detección de defectos: detectar grietas o daños estructurales en edificios y defectos de fabricación</li>",Je,L,be,F,xe,S,Va="La segmentación de imágenes es una tarea a nivel de píxeles que asigna cada píxel en una imagen a una clase. A diferencia de la detección de objetos, que utiliza cuadros delimitadores para etiquetar y predecir objetos en una imagen, la segmentación es más granular. La segmentación puede detectar objetos a nivel de píxeles. Hay varios tipos de segmentación de imágenes:",fe,_,Na="<li>segmentación de instancias: además de etiquetar la clase de un objeto, también etiqueta cada instancia distinta de un objeto (“perro-1”, “perro-2”)</li> <li>segmentación panóptica: una combinación de segmentación semántica y de instancias; etiqueta cada píxel con una clase semántica <strong>y</strong> cada instancia distinta de un objeto</li>",Ue,A,Ra="Las tareas de segmentación son útiles en vehículos autónomos para crear un mapa a nivel de píxeles del mundo que los rodea para que puedan navegar de manera segura alrededor de peatones y otros vehículos. También es útil en imágenes médicas, donde la mayor granularidad de la tarea puede ayudar a identificar células anormales o características de órganos. La segmentación de imágenes también se puede utilizar en comercio electrónico para probar virtualmente la ropa o crear experiencias de realidad aumentada superponiendo objetos en el mundo real a través de tu cámara.",Te,P,we,K,Ce,D,za="La estimación de profundidad predice la distancia de cada píxel en una imagen desde la cámara. Esta tarea de visión por computadora es especialmente importante para la comprensión y reconstrucción de escenas. Por ejemplo, en los vehículos autónomos, es necesario entender qué tan lejos están los objetos como peatones, señales de tráfico y otros vehículos para evitar obstáculos y colisiones. La información de profundidad también es útil para construir representaciones 3D a partir de imágenes 2D y se puede utilizar para crear representaciones 3D de alta calidad de estructuras biológicas o edificios.",ve,O,Ea="Hay dos enfoques para la estimación de profundidad:",Ze,ss,Qa="<li>estéreo: las profundidades se estiman comparando dos imágenes de la misma escena desde ángulos ligeramente diferentes</li> <li>monocular: las profundidades se estiman a partir de una sola imagen</li>",qe,es,Ie,as,$e,ns,Ya="Las tareas de procesamiento del lenguaje natural (NLP, por sus siglas en inglés) están entre los tipos de tareas más comunes porque el texto es una forma natural de comunicación para nosotros. Para convertir el texto en un formato reconocido por un modelo, es necesario tokenizarlo. Esto significa dividir una secuencia de texto en palabras o subpalabras separadas (tokens) y luego convertir estos tokens en números. Como resultado, puedes representar una secuencia de texto como una secuencia de números, y una vez que tienes una secuencia de números, se puede ingresar a un modelo para resolver todo tipo de tareas de NLP.",Be,ts,We,ls,Xa="Al igual que las tareas de clasificación en cualquier modalidad, la clasificación de texto etiqueta una secuencia de texto (puede ser a nivel de oración, párrafo o documento) de un conjunto predefinido de clases. Hay muchas aplicaciones prácticas para la clasificación de texto, algunas de las cuales incluyen:",ke,is,La="<li>análisis de sentimientos: etiquetar texto según alguna polaridad como <code>positivo</code> o <code>negativo</code>, lo que puede informar y respaldar la toma de decisiones en campos como política, finanzas y marketing</li> <li>clasificación de contenido: etiquetar texto según algún tema para ayudar a organizar y filtrar información en noticias y feeds de redes sociales (<code>clima</code>, <code>deportes</code>, <code>finanzas</code>, etc.)</li>",Ge,ps,He,rs,Ve,os,Fa='En cualquier tarea de NLP, el texto se procesa separando la secuencia de texto en palabras o subpalabras individuales. Estas se conocen como <a href="glossary#token">tokens</a>. La clasificación de tokens asigna a cada token una etiqueta de un conjunto predefinido de clases.',Ne,cs,Sa="Dos tipos comunes de clasificación de tokens son:",Re,ds,_a="<li>reconocimiento de entidades nombradas (NER, por sus siglas en inglés): etiquetar un token según una categoría de entidad como organización, persona, ubicación o fecha. NER es especialmente popular en entornos biomédicos, donde puede etiquetar genes, proteínas y nombres de medicamentos</li> <li>etiquetado de partes del discurso (POS, por sus siglas en inglés): etiquetar un token según su parte del discurso, como sustantivo, verbo o adjetivo. POS es útil para ayudar a los sistemas de traducción a comprender cómo dos palabras idénticas son gramaticalmente diferentes (por ejemplo, “corte” como sustantivo versus “corte” como verbo)</li>",ze,us,Ee,ms,Qe,gs,Aa="Responder preguntas es otra tarea a nivel de tokens que devuelve una respuesta a una pregunta, a veces con contexto (dominio abierto) y otras veces sin contexto (dominio cerrado). Esta tarea ocurre cuando le preguntamos algo a un asistente virtual, como si un restaurante está abierto. También puede proporcionar soporte al cliente o técnico y ayudar a los motores de búsqueda a recuperar la información relevante que estás buscando.",Ye,js,Pa="Hay dos tipos comunes de respuestas a preguntas:",Xe,ys,Ka="<li>extractivas: dada una pregunta y algún contexto, la respuesta es un fragmento de texto del contexto que el modelo debe extraer</li> <li>abstractivas: dada una pregunta y algún contexto, la respuesta se genera a partir del contexto; este enfoque lo maneja la <code>Text2TextGenerationPipeline</code> en lugar del <code>QuestionAnsweringPipeline</code> que se muestra a continuación</li>",Le,hs,Fe,Ms,Se,Js,Da="Al resumir se crea una versión más corta de un texto más largo mientras intenta preservar la mayor parte del significado del documento original. Resumir es una tarea de secuencia a secuencia; produce una secuencia de texto más corta que la entrada. Hay muchos documentos de formato largo que se pueden resumir para ayudar a los lectores a comprender rápidamente los puntos principales. Proyectos de ley legislativos, documentos legales y financieros, patentes y artículos científicos son algunos ejemplos de documentos que podrían resumirse para ahorrar tiempo a los lectores y servir como ayuda para la lectura.",_e,bs,Oa="Al igual que en las respuestas a preguntas, hay dos tipos de resumen:",Ae,xs,sn="<li>extractiva: identifica y extrae las oraciones más importantes del texto original</li> <li>abstractiva: genera el resumen objetivo (que puede incluir nuevas palabras no presentes en el documento de entrada) a partir del texto original; el <code>SummarizationPipeline</code> utiliza el enfoque abstractivo</li>",Pe,fs,Ke,Us,De,Ts,en="La traducción convierte una secuencia de texto en un idioma a otro. Es importante para ayudar a personas de diferentes orígenes a comunicarse entre sí, traducir contenido para llegar a audiencias más amplias e incluso ser una herramienta de aprendizaje para ayudar a las personas a aprender un nuevo idioma. Al igual que resumir, la traducción es una tarea de secuencia a secuencia, lo que significa que el modelo recibe una secuencia de entrada y devuelve una secuencia de salida objetivo.",Oe,ws,an="En sus primeros días, los modelos de traducción eran principalmente monolingües, pero recientemente ha habido un creciente interés en modelos multilingües que pueden traducir entre muchas combinaciones de idiomas.",sa,Cs,ea,vs,aa,Zs,nn="El modelado de lenguaje es una tarea que predice una palabra en una secuencia de texto. Se ha vuelto una tarea de NLP muy popular porque un modelo de lenguaje preentrenado puede ser afinado para muchas otras tareas secundarias. Últimamente, ha habido mucho interés en modelos de lenguaje grandes (LLM, por sus siglas en inglés) que demuestran aprendizaje de cero o con pocas muestras (zero- or few-shot learning). ¡Esto significa que el modelo puede resolver tareas para las cuales no fue entrenado explícitamente! Los modelos de lenguaje se pueden utilizar para generar texto fluido y convincente, aunque debes tener cuidado, ya que el texto no siempre puede ser preciso.",na,qs,tn="Hay dos tipos de modelado de lenguaje:",ta,M,Is,Qs,ln="causal: el objetivo del modelo es predecir el próximo token en una secuencia, y los tokens futuros están enmascarados",Ma,$s,Ja,Bs,Ys,pn="enmascarado: el objetivo del modelo es predecir un token enmascarado en una secuencia con acceso completo a los tokens en la secuencia",ba,Ws,la,ks,ia,Gs,rn="Las tareas multimodales requieren que un modelo procese múltiples modalidades de datos (texto, imagen, audio, video) para resolver un problema particular. La descripción de imágenes es un ejemplo de una tarea multimodal en la que el modelo toma una imagen como entrada y produce una secuencia de texto que describe la imagen o algunas propiedades de la imagen.",pa,Hs,on="Aunque los modelos multimodales trabajan con diferentes tipos de datos o modalidades, internamente, los pasos de preprocesamiento ayudan al modelo a convertir todos los tipos de datos en embeddings (vectores o listas de números que contienen información significativa sobre los datos). Para una tarea como la descripción de imágenes, el modelo aprende las relaciones entre los embeddings de imágenes y los embeddings de texto.",ra,Vs,oa,Ns,cn="Las respuestas a preguntas de documentos es una tarea que responde preguntas en lenguaje natural a partir de un documento. A diferencia de una tarea de respuestas a preguntas a nivel de token que toma texto como entrada, las respuestas a preguntas de documentos toman una imagen de un documento como entrada junto con una pregunta sobre el documento y devuelven una respuesta. Las respuestas a preguntas de documentos pueden usarse para analizar documentos estructurados y extraer información clave de ellos. En el ejemplo a continuación, el monto total y el cambio debido se pueden extraer de un recibo.",ca,Rs,da,zs,dn='Con suerte, esta página te ha proporcionado más información de fondo sobre todos los tipos de tareas en cada modalidad y la importancia práctica de cada una. En la próxima <a href="tasks_explained">sección</a>, aprenderás <strong>cómo</strong> 🤗 Transformers trabaja para resolver estas tareas.',ua,Es,ma,Ls,ga;return b=new j({props:{title:"Lo que 🤗 Transformers puede hacer",local:"lo-que--transformers-puede-hacer",headingTag:"h1"}}),U=new j({props:{title:"Audio",local:"audio",headingTag:"h2"}}),C=new j({props:{title:"Clasificación de audio",local:"clasificación-de-audio",headingTag:"h3"}}),q=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJhdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyc3VwZXJiJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWVyJTIyKSUwQXByZWRzJTIwJTNEJTIwY2xhc3NpZmllciglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1say5mbGFjJTIyKSUwQXByZWRzJTIwJTNEJTIwJTVCJTdCJTIyc2NvcmUlMjIlM0ElMjByb3VuZChwcmVkJTVCJTIyc2NvcmUlMjIlNUQlMkMlMjA0KSUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwcHJlZCU1QiUyMmxhYmVsJTIyJTVEJTdEJTIwZm9yJTIwcHJlZCUyMGluJTIwcHJlZHMlNUQlMEFwcmVkcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;superb/hubert-base-superb-er&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4532</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;hap&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.3622</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;sad&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0943</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;neu&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0903</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;ang&#x27;</span>}]`,wrap:!1}}),I=new j({props:{title:"Reconocimiento automático del habla",local:"reconocimiento-automático-del-habla",headingTag:"h3"}}),W=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyb3BlbmFpJTJGd2hpc3Blci1zbWFsbCUyMiklMEF0cmFuc2NyaWJlciglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1say5mbGFjJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(task=<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; I have a dream that one day this nation will rise up and live out the true meaning of its creed.&#x27;</span>}`,wrap:!1}}),k=new j({props:{title:"Visión por computadora",local:"visión-por-computadora",headingTag:"h2"}}),N=new j({props:{title:"Clasificación de imágenes",local:"clasificación-de-imágenes",headingTag:"h3"}}),E=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJpbWFnZS1jbGFzc2lmaWNhdGlvbiUyMiklMEFwcmVkcyUyMCUzRCUyMGNsYXNzaWZpZXIoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIlMEEpJTBBcHJlZHMlMjAlM0QlMjAlNUIlN0IlMjJzY29yZSUyMiUzQSUyMHJvdW5kKHByZWQlNUIlMjJzY29yZSUyMiU1RCUyQyUyMDQpJTJDJTIwJTIybGFiZWwlMjIlM0ElMjBwcmVkJTVCJTIybGFiZWwlMjIlNUQlN0QlMjBmb3IlMjBwcmVkJTIwaW4lMjBwcmVkcyU1RCUwQXByaW50KCpwcmVkcyUyQyUyMHNlcCUzRCUyMiU1Q24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;image-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(*preds, sep=<span class="hljs-string">&quot;\\n&quot;</span>)
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4335</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;lynx, catamount&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0348</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cougar, puma, catamount, mountain lion, painter, panther, Felis concolor&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0324</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow leopard, ounce, Panthera uncia&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0239</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Egyptian cat&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0229</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tiger cat&#x27;</span>}`,wrap:!1}}),Q=new j({props:{title:"Detección de objetos",local:"detección-de-objetos",headingTag:"h3"}}),L=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZGV0ZWN0b3IlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyb2JqZWN0LWRldGVjdGlvbiUyMiklMEFwcmVkcyUyMCUzRCUyMGRldGVjdG9yKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnBpcGVsaW5lLWNhdC1jaG9uay5qcGVnJTIyJTBBKSUwQXByZWRzJTIwJTNEJTIwJTVCJTdCJTIyc2NvcmUlMjIlM0ElMjByb3VuZChwcmVkJTVCJTIyc2NvcmUlMjIlNUQlMkMlMjA0KSUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwcHJlZCU1QiUyMmxhYmVsJTIyJTVEJTJDJTIwJTIyYm94JTIyJTNBJTIwcHJlZCU1QiUyMmJveCUyMiU1RCU3RCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTVEJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>detector = pipeline(task=<span class="hljs-string">&quot;object-detection&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = detector(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>], <span class="hljs-string">&quot;box&quot;</span>: pred[<span class="hljs-string">&quot;box&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9865</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cat&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">178</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">154</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">882</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">598</span>}}]`,wrap:!1}}),F=new j({props:{title:"Segmentación de imágenes",local:"segmentación-de-imágenes",headingTag:"h3"}}),P=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBc2VnbWVudGVyJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMmltYWdlLXNlZ21lbnRhdGlvbiUyMiklMEFwcmVkcyUyMCUzRCUyMHNlZ21lbnRlciglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZwaXBlbGluZS1jYXQtY2hvbmsuanBlZyUyMiUwQSklMEFwcmVkcyUyMCUzRCUyMCU1QiU3QiUyMnNjb3JlJTIyJTNBJTIwcm91bmQocHJlZCU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwNCklMkMlMjAlMjJsYWJlbCUyMiUzQSUyMHByZWQlNUIlMjJsYWJlbCUyMiU1RCU3RCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTVEJTBBcHJpbnQoKnByZWRzJTJDJTIwc2VwJTNEJTIyJTVDbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>segmenter = pipeline(task=<span class="hljs-string">&quot;image-segmentation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = segmenter(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(*preds, sep=<span class="hljs-string">&quot;\\n&quot;</span>)
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9879</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;LABEL_184&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9973</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9972</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cat&#x27;</span>}`,wrap:!1}}),K=new j({props:{title:"Estimación de profundidad",local:"estimación-de-profundidad",headingTag:"h3"}}),es=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZGVwdGhfZXN0aW1hdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMmRlcHRoLWVzdGltYXRpb24lMjIpJTBBcHJlZHMlMjAlM0QlMjBkZXB0aF9lc3RpbWF0b3IoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>depth_estimator = pipeline(task=<span class="hljs-string">&quot;depth-estimation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = depth_estimator(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),as=new j({props:{title:"Procesamiento del lenguaje natural",local:"procesamiento-del-lenguaje-natural",headingTag:"h2"}}),ts=new j({props:{title:"Clasificación de texto",local:"clasificación-de-texto",headingTag:"h3"}}),ps=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJzZW50aW1lbnQtYW5hbHlzaXMlMjIpJTBBcHJlZHMlMjAlM0QlMjBjbGFzc2lmaWVyKCUyMkh1Z2dpbmclMjBGYWNlJTIwaXMlMjB0aGUlMjBiZXN0JTIwdGhpbmclMjBzaW5jZSUyMHNsaWNlZCUyMGJyZWFkISUyMiklMEFwcmVkcyUyMCUzRCUyMCU1QiU3QiUyMnNjb3JlJTIyJTNBJTIwcm91bmQocHJlZCU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwNCklMkMlMjAlMjJsYWJlbCUyMiUzQSUyMHByZWQlNUIlMjJsYWJlbCUyMiU1RCU3RCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTVEJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;sentiment-analysis&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(<span class="hljs-string">&quot;Hugging Face is the best thing since sliced bread!&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9991</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;POSITIVE&#x27;</span>}]`,wrap:!1}}),rs=new j({props:{title:"Clasificación de tokens",local:"clasificación-de-tokens",headingTag:"h3"}}),us=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJuZXIlMjIpJTBBcHJlZHMlMjAlM0QlMjBjbGFzc2lmaWVyKCUyMkh1Z2dpbmclMjBGYWNlJTIwaXMlMjBhJTIwRnJlbmNoJTIwY29tcGFueSUyMGJhc2VkJTIwaW4lMjBOZXclMjBZb3JrJTIwQ2l0eS4lMjIpJTBBcHJlZHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbnRpdHklMjIlM0ElMjBwcmVkJTVCJTIyZW50aXR5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2NvcmUlMjIlM0ElMjByb3VuZChwcmVkJTVCJTIyc2NvcmUlMjIlNUQlMkMlMjA0KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmluZGV4JTIyJTNBJTIwcHJlZCU1QiUyMmluZGV4JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyd29yZCUyMiUzQSUyMHByZWQlNUIlMjJ3b3JkJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3RhcnQlMjIlM0ElMjBwcmVkJTVCJTIyc3RhcnQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbmQlMjIlM0ElMjBwcmVkJTVCJTIyZW5kJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwZm9yJTIwcHJlZCUyMGluJTIwcHJlZHMlMEElNUQlMEFwcmludCgqcHJlZHMlMkMlMjBzZXAlM0QlMjIlNUNuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;ner&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(<span class="hljs-string">&quot;Hugging Face is a French company based in New York City.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;entity&quot;</span>: pred[<span class="hljs-string">&quot;entity&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;index&quot;</span>: pred[<span class="hljs-string">&quot;index&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;word&quot;</span>: pred[<span class="hljs-string">&quot;word&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;start&quot;</span>: pred[<span class="hljs-string">&quot;start&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;end&quot;</span>: pred[<span class="hljs-string">&quot;end&quot;</span>],
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(*preds, sep=<span class="hljs-string">&quot;\\n&quot;</span>)
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-ORG&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9968</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;Hu&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">2</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-ORG&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9293</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;##gging&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">7</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-ORG&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9763</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;Face&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">8</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">12</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-MISC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9983</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">6</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;French&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">18</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">24</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-LOC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.999</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">10</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;New&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">42</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">45</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-LOC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9987</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">11</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;York&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">46</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">50</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-LOC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9992</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">12</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;City&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">51</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">55</span>}`,wrap:!1}}),ms=new j({props:{title:"Respuestas a preguntas",local:"respuestas-a-preguntas",headingTag:"h3"}}),hs=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcXVlc3Rpb25fYW5zd2VyZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIycXVlc3Rpb24tYW5zd2VyaW5nJTIyKSUwQXByZWRzJTIwJTNEJTIwcXVlc3Rpb25fYW5zd2VyZXIoJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lM0QlMjJXaGF0JTIwaXMlMjB0aGUlMjBuYW1lJTIwb2YlMjB0aGUlMjByZXBvc2l0b3J5JTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dCUzRCUyMlRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMHJlcG9zaXRvcnklMjBpcyUyMGh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzJTIyJTJDJTBBKSUwQXByaW50KCUwQSUyMCUyMCUyMCUyMGYlMjJzY29yZSUzQSUyMCU3QnJvdW5kKHByZWRzJTVCJ3Njb3JlJyU1RCUyQyUyMDQpJTdEJTJDJTIwc3RhcnQlM0ElMjAlN0JwcmVkcyU1QidzdGFydCclNUQlN0QlMkMlMjBlbmQlM0ElMjAlN0JwcmVkcyU1QidlbmQnJTVEJTdEJTJDJTIwYW5zd2VyJTNBJTIwJTdCcHJlZHMlNUInYW5zd2VyJyU1RCU3RCUyMiUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>question_answerer = pipeline(task=<span class="hljs-string">&quot;question-answering&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = question_answerer(
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the name of the repository?&quot;</span>,
<span class="hljs-meta">... </span>    context=<span class="hljs-string">&quot;The name of the repository is huggingface/transformers&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>    <span class="hljs-string">f&quot;score: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(preds[<span class="hljs-string">&#x27;score&#x27;</span>], <span class="hljs-number">4</span>)}</span>, start: <span class="hljs-subst">{preds[<span class="hljs-string">&#x27;start&#x27;</span>]}</span>, end: <span class="hljs-subst">{preds[<span class="hljs-string">&#x27;end&#x27;</span>]}</span>, answer: <span class="hljs-subst">{preds[<span class="hljs-string">&#x27;answer&#x27;</span>]}</span>&quot;</span>
<span class="hljs-meta">... </span>)
score: <span class="hljs-number">0.9327</span>, start: <span class="hljs-number">30</span>, end: <span class="hljs-number">54</span>, answer: huggingface/transformers`,wrap:!1}}),Ms=new j({props:{title:"Resumir",local:"resumir",headingTag:"h3"}}),fs=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBc3VtbWFyaXplciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJzdW1tYXJpemF0aW9uJTIyKSUwQXN1bW1hcml6ZXIoJTBBJTIwJTIwJTIwJTIwJTIySW4lMjB0aGlzJTIwd29yayUyQyUyMHdlJTIwcHJlc2VudGVkJTIwdGhlJTIwVHJhbnNmb3JtZXIlMkMlMjB0aGUlMjBmaXJzdCUyMHNlcXVlbmNlJTIwdHJhbnNkdWN0aW9uJTIwbW9kZWwlMjBiYXNlZCUyMGVudGlyZWx5JTIwb24lMjBhdHRlbnRpb24lMkMlMjByZXBsYWNpbmclMjB0aGUlMjByZWN1cnJlbnQlMjBsYXllcnMlMjBtb3N0JTIwY29tbW9ubHklMjB1c2VkJTIwaW4lMjBlbmNvZGVyLWRlY29kZXIlMjBhcmNoaXRlY3R1cmVzJTIwd2l0aCUyMG11bHRpLWhlYWRlZCUyMHNlbGYtYXR0ZW50aW9uLiUyMEZvciUyMHRyYW5zbGF0aW9uJTIwdGFza3MlMkMlMjB0aGUlMjBUcmFuc2Zvcm1lciUyMGNhbiUyMGJlJTIwdHJhaW5lZCUyMHNpZ25pZmljYW50bHklMjBmYXN0ZXIlMjB0aGFuJTIwYXJjaGl0ZWN0dXJlcyUyMGJhc2VkJTIwb24lMjByZWN1cnJlbnQlMjBvciUyMGNvbnZvbHV0aW9uYWwlMjBsYXllcnMuJTIwT24lMjBib3RoJTIwV01UJTIwMjAxNCUyMEVuZ2xpc2gtdG8tR2VybWFuJTIwYW5kJTIwV01UJTIwMjAxNCUyMEVuZ2xpc2gtdG8tRnJlbmNoJTIwdHJhbnNsYXRpb24lMjB0YXNrcyUyQyUyMHdlJTIwYWNoaWV2ZSUyMGElMjBuZXclMjBzdGF0ZSUyMG9mJTIwdGhlJTIwYXJ0LiUyMEluJTIwdGhlJTIwZm9ybWVyJTIwdGFzayUyMG91ciUyMGJlc3QlMjBtb2RlbCUyMG91dHBlcmZvcm1zJTIwZXZlbiUyMGFsbCUyMHByZXZpb3VzbHklMjByZXBvcnRlZCUyMGVuc2VtYmxlcy4lMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>summarizer = pipeline(task=<span class="hljs-string">&quot;summarization&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summarizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;In this work, we presented the Transformer, the first sequence transduction model based entirely on attention, replacing the recurrent layers most commonly used in encoder-decoder architectures with multi-headed self-attention. For translation tasks, the Transformer can be trained significantly faster than architectures based on recurrent or convolutional layers. On both WMT 2014 English-to-German and WMT 2014 English-to-French translation tasks, we achieve a new state of the art. In the former task our best model outperforms even all previously reported ensembles.&quot;</span>
<span class="hljs-meta">... </span>)
[{<span class="hljs-string">&#x27;summary_text&#x27;</span>: <span class="hljs-string">&#x27; The Transformer is the first sequence transduction model based entirely on attention . It replaces the recurrent layers most commonly used in encoder-decoder architectures with multi-headed self-attention . For translation tasks, the Transformer can be trained significantly faster than architectures based on recurrent or convolutional layers .&#x27;</span>}]`,wrap:!1}}),Us=new j({props:{title:"Traducción",local:"traducción",headingTag:"h3"}}),Cs=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdGV4dCUyMCUzRCUyMCUyMnRyYW5zbGF0ZSUyMEVuZ2xpc2glMjB0byUyMEZyZW5jaCUzQSUyMEh1Z2dpbmclMjBGYWNlJTIwaXMlMjBhJTIwY29tbXVuaXR5LWJhc2VkJTIwb3Blbi1zb3VyY2UlMjBwbGF0Zm9ybSUyMGZvciUyMG1hY2hpbmUlMjBsZWFybmluZy4lMjIlMEF0cmFuc2xhdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnRyYW5zbGF0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJ0NS1zbWFsbCUyMiklMEF0cmFuc2xhdG9yKHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;translate English to French: Hugging Face is a community-based open-source platform for machine learning.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>translator = pipeline(task=<span class="hljs-string">&quot;translation&quot;</span>, model=<span class="hljs-string">&quot;t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>translator(text)
[{<span class="hljs-string">&#x27;translation_text&#x27;</span>: <span class="hljs-string">&quot;Hugging Face est une tribune communautaire de l&#x27;apprentissage des machines.&quot;</span>}]`,wrap:!1}}),vs=new j({props:{title:"Modelado de lenguaje",local:"modelado-de-lenguaje",headingTag:"h3"}}),$s=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIySHVnZ2luZyUyMEZhY2UlMjBpcyUyMGElMjBjb21tdW5pdHktYmFzZWQlMjBvcGVuLXNvdXJjZSUyMHBsYXRmb3JtJTIwZm9yJTIwbWFjaGluZSUyMGxlYXJuaW5nLiUyMiUwQWdlbmVyYXRvciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIpJTBBZ2VuZXJhdG9yKHByb21wdCklMjAlMjAlMjMlMjBkb2N0ZXN0JTNBJTIwJTJCU0tJUA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hugging Face is a community-based open-source platform for machine learning.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(task=<span class="hljs-string">&quot;text-generation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generator(prompt)  <span class="hljs-comment"># doctest: +SKIP</span>`,wrap:!1}}),Ws=new y({props:{code:"dGV4dCUyMCUzRCUyMCUyMkh1Z2dpbmclMjBGYWNlJTIwaXMlMjBhJTIwY29tbXVuaXR5LWJhc2VkJTIwb3Blbi1zb3VyY2UlMjAlM0NtYXNrJTNFJTIwZm9yJTIwbWFjaGluZSUyMGxlYXJuaW5nLiUyMiUwQWZpbGxfbWFzayUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJmaWxsLW1hc2slMjIpJTBBcHJlZHMlMjAlM0QlMjBmaWxsX21hc2sodGV4dCUyQyUyMHRvcF9rJTNEMSklMEFwcmVkcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNjb3JlJTIyJTNBJTIwcm91bmQocHJlZCU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwNCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0b2tlbiUyMiUzQSUyMHByZWQlNUIlMjJ0b2tlbiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRva2VuX3N0ciUyMiUzQSUyMHByZWQlNUIlMjJ0b2tlbl9zdHIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzZXF1ZW5jZSUyMiUzQSUyMHByZWQlNUIlMjJzZXF1ZW5jZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTBBJTVEJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Hugging Face is a community-based open-source &lt;mask&gt; for machine learning.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fill_mask = pipeline(task=<span class="hljs-string">&quot;fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = fill_mask(text, top_k=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;token&quot;</span>: pred[<span class="hljs-string">&quot;token&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;token_str&quot;</span>: pred[<span class="hljs-string">&quot;token_str&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;sequence&quot;</span>: pred[<span class="hljs-string">&quot;sequence&quot;</span>],
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.2236</span>,
  <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">1761</span>,
  <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27; platform&#x27;</span>,
  <span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hugging Face is a community-based open-source platform for machine learning.&#x27;</span>}]`,wrap:!1}}),ks=new j({props:{title:"Multimodal",local:"multimodal",headingTag:"h2"}}),Vs=new j({props:{title:"Respuestas a preguntas de documentos",local:"respuestas-a-preguntas-de-documentos",headingTag:"h3"}}),Rs=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZXhhbXBsZS1kb2N1bWVudHMlMkZyZXNvbHZlJTJGbWFpbiUyRmpwZWdfaW1hZ2VzJTJGMi5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFkb2NfcXVlc3Rpb25fYW5zd2VyZXIlMjAlM0QlMjBwaXBlbGluZSglMjJkb2N1bWVudC1xdWVzdGlvbi1hbnN3ZXJpbmclMjIlMkMlMjBtb2RlbCUzRCUyMm1hZ29yc2h1bm92JTJGbGF5b3V0bG0taW52b2ljZXMlMjIpJTBBcHJlZHMlMjAlM0QlMjBkb2NfcXVlc3Rpb25fYW5zd2VyZXIoJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lM0QlMjJXaGF0JTIwaXMlMjB0aGUlMjB0b3RhbCUyMGFtb3VudCUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW1hZ2UlMkMlMEEpJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/example-documents/resolve/main/jpeg_images/2.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>doc_question_answerer = pipeline(<span class="hljs-string">&quot;document-question-answering&quot;</span>, model=<span class="hljs-string">&quot;magorshunov/layoutlm-invoices&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = doc_question_answerer(
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the total amount?&quot;</span>,
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.8531</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;17,000&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">4</span>}]`,wrap:!1}}),Es=new Jn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/es/task_summary.md"}}),{c(){h=i("meta"),Ss=t(),Xs=i("p"),_s=t(),o(b.$$.fragment),As=t(),x=i("p"),x.textContent=fa,Ps=t(),f=i("p"),f.textContent=Ua,Ks=t(),o(U.$$.fragment),Ds=t(),T=i("p"),T.textContent=Ta,Os=t(),w=i("p"),w.textContent=wa,se=t(),o(C.$$.fragment),ee=t(),v=i("p"),v.textContent=Ca,ae=t(),Z=i("ul"),Z.innerHTML=va,ne=t(),o(q.$$.fragment),te=t(),o(I.$$.fragment),le=t(),$=i("p"),$.textContent=Za,ie=t(),B=i("p"),B.textContent=qa,pe=t(),o(W.$$.fragment),re=t(),o(k.$$.fragment),oe=t(),G=i("p"),G.innerHTML=Ia,ce=t(),H=i("p"),H.textContent=$a,de=t(),V=i("ol"),V.innerHTML=Ba,ue=t(),o(N.$$.fragment),me=t(),R=i("p"),R.textContent=Wa,ge=t(),z=i("ul"),z.innerHTML=ka,je=t(),o(E.$$.fragment),ye=t(),o(Q.$$.fragment),he=t(),Y=i("p"),Y.textContent=Ga,Me=t(),X=i("ul"),X.innerHTML=Ha,Je=t(),o(L.$$.fragment),be=t(),o(F.$$.fragment),xe=t(),S=i("p"),S.textContent=Va,fe=t(),_=i("ul"),_.innerHTML=Na,Ue=t(),A=i("p"),A.textContent=Ra,Te=t(),o(P.$$.fragment),we=t(),o(K.$$.fragment),Ce=t(),D=i("p"),D.textContent=za,ve=t(),O=i("p"),O.textContent=Ea,Ze=t(),ss=i("ul"),ss.innerHTML=Qa,qe=t(),o(es.$$.fragment),Ie=t(),o(as.$$.fragment),$e=t(),ns=i("p"),ns.textContent=Ya,Be=t(),o(ts.$$.fragment),We=t(),ls=i("p"),ls.textContent=Xa,ke=t(),is=i("ul"),is.innerHTML=La,Ge=t(),o(ps.$$.fragment),He=t(),o(rs.$$.fragment),Ve=t(),os=i("p"),os.innerHTML=Fa,Ne=t(),cs=i("p"),cs.textContent=Sa,Re=t(),ds=i("ul"),ds.innerHTML=_a,ze=t(),o(us.$$.fragment),Ee=t(),o(ms.$$.fragment),Qe=t(),gs=i("p"),gs.textContent=Aa,Ye=t(),js=i("p"),js.textContent=Pa,Xe=t(),ys=i("ul"),ys.innerHTML=Ka,Le=t(),o(hs.$$.fragment),Fe=t(),o(Ms.$$.fragment),Se=t(),Js=i("p"),Js.textContent=Da,_e=t(),bs=i("p"),bs.textContent=Oa,Ae=t(),xs=i("ul"),xs.innerHTML=sn,Pe=t(),o(fs.$$.fragment),Ke=t(),o(Us.$$.fragment),De=t(),Ts=i("p"),Ts.textContent=en,Oe=t(),ws=i("p"),ws.textContent=an,sa=t(),o(Cs.$$.fragment),ea=t(),o(vs.$$.fragment),aa=t(),Zs=i("p"),Zs.textContent=nn,na=t(),qs=i("p"),qs.textContent=tn,ta=t(),M=i("ul"),Is=i("li"),Qs=i("p"),Qs.textContent=ln,Ma=t(),o($s.$$.fragment),Ja=t(),Bs=i("li"),Ys=i("p"),Ys.textContent=pn,ba=t(),o(Ws.$$.fragment),la=t(),o(ks.$$.fragment),ia=t(),Gs=i("p"),Gs.textContent=rn,pa=t(),Hs=i("p"),Hs.textContent=on,ra=t(),o(Vs.$$.fragment),oa=t(),Ns=i("p"),Ns.textContent=cn,ca=t(),o(Rs.$$.fragment),da=t(),zs=i("p"),zs.innerHTML=dn,ua=t(),o(Es.$$.fragment),ma=t(),Ls=i("p"),this.h()},l(s){const e=Mn("svelte-u9bgzb",document.head);h=p(e,"META",{name:!0,content:!0}),e.forEach(a),Ss=l(s),Xs=p(s,"P",{}),Fs(Xs).forEach(a),_s=l(s),c(b.$$.fragment,s),As=l(s),x=p(s,"P",{"data-svelte-h":!0}),r(x)!=="svelte-wrov2v"&&(x.textContent=fa),Ps=l(s),f=p(s,"P",{"data-svelte-h":!0}),r(f)!=="svelte-ugqvf2"&&(f.textContent=Ua),Ks=l(s),c(U.$$.fragment,s),Ds=l(s),T=p(s,"P",{"data-svelte-h":!0}),r(T)!=="svelte-t6wlqa"&&(T.textContent=Ta),Os=l(s),w=p(s,"P",{"data-svelte-h":!0}),r(w)!=="svelte-3l7d80"&&(w.textContent=wa),se=l(s),c(C.$$.fragment,s),ee=l(s),v=p(s,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1yxh2g8"&&(v.textContent=Ca),ae=l(s),Z=p(s,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-17p9ds6"&&(Z.innerHTML=va),ne=l(s),c(q.$$.fragment,s),te=l(s),c(I.$$.fragment,s),le=l(s),$=p(s,"P",{"data-svelte-h":!0}),r($)!=="svelte-ccqudd"&&($.textContent=Za),ie=l(s),B=p(s,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1e2na1v"&&(B.textContent=qa),pe=l(s),c(W.$$.fragment,s),re=l(s),c(k.$$.fragment,s),oe=l(s),G=p(s,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1pw1pju"&&(G.innerHTML=Ia),ce=l(s),H=p(s,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1j2cqc"&&(H.textContent=$a),de=l(s),V=p(s,"OL",{"data-svelte-h":!0}),r(V)!=="svelte-qy24n8"&&(V.innerHTML=Ba),ue=l(s),c(N.$$.fragment,s),me=l(s),R=p(s,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1wm6rmp"&&(R.textContent=Wa),ge=l(s),z=p(s,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-53djgi"&&(z.innerHTML=ka),je=l(s),c(E.$$.fragment,s),ye=l(s),c(Q.$$.fragment,s),he=l(s),Y=p(s,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-7ee2c8"&&(Y.textContent=Ga),Me=l(s),X=p(s,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-r9s62m"&&(X.innerHTML=Ha),Je=l(s),c(L.$$.fragment,s),be=l(s),c(F.$$.fragment,s),xe=l(s),S=p(s,"P",{"data-svelte-h":!0}),r(S)!=="svelte-umk665"&&(S.textContent=Va),fe=l(s),_=p(s,"UL",{"data-svelte-h":!0}),r(_)!=="svelte-471xgq"&&(_.innerHTML=Na),Ue=l(s),A=p(s,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1rvyh07"&&(A.textContent=Ra),Te=l(s),c(P.$$.fragment,s),we=l(s),c(K.$$.fragment,s),Ce=l(s),D=p(s,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1araow4"&&(D.textContent=za),ve=l(s),O=p(s,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1ul6ize"&&(O.textContent=Ea),Ze=l(s),ss=p(s,"UL",{"data-svelte-h":!0}),r(ss)!=="svelte-1urr7zw"&&(ss.innerHTML=Qa),qe=l(s),c(es.$$.fragment,s),Ie=l(s),c(as.$$.fragment,s),$e=l(s),ns=p(s,"P",{"data-svelte-h":!0}),r(ns)!=="svelte-1bszmd1"&&(ns.textContent=Ya),Be=l(s),c(ts.$$.fragment,s),We=l(s),ls=p(s,"P",{"data-svelte-h":!0}),r(ls)!=="svelte-9ss1nd"&&(ls.textContent=Xa),ke=l(s),is=p(s,"UL",{"data-svelte-h":!0}),r(is)!=="svelte-1qkjwt4"&&(is.innerHTML=La),Ge=l(s),c(ps.$$.fragment,s),He=l(s),c(rs.$$.fragment,s),Ve=l(s),os=p(s,"P",{"data-svelte-h":!0}),r(os)!=="svelte-i2csfh"&&(os.innerHTML=Fa),Ne=l(s),cs=p(s,"P",{"data-svelte-h":!0}),r(cs)!=="svelte-1b0d6b"&&(cs.textContent=Sa),Re=l(s),ds=p(s,"UL",{"data-svelte-h":!0}),r(ds)!=="svelte-sj8n4u"&&(ds.innerHTML=_a),ze=l(s),c(us.$$.fragment,s),Ee=l(s),c(ms.$$.fragment,s),Qe=l(s),gs=p(s,"P",{"data-svelte-h":!0}),r(gs)!=="svelte-12fjabo"&&(gs.textContent=Aa),Ye=l(s),js=p(s,"P",{"data-svelte-h":!0}),r(js)!=="svelte-yahlih"&&(js.textContent=Pa),Xe=l(s),ys=p(s,"UL",{"data-svelte-h":!0}),r(ys)!=="svelte-2kfb6v"&&(ys.innerHTML=Ka),Le=l(s),c(hs.$$.fragment,s),Fe=l(s),c(Ms.$$.fragment,s),Se=l(s),Js=p(s,"P",{"data-svelte-h":!0}),r(Js)!=="svelte-sdy6sp"&&(Js.textContent=Da),_e=l(s),bs=p(s,"P",{"data-svelte-h":!0}),r(bs)!=="svelte-17k9bdx"&&(bs.textContent=Oa),Ae=l(s),xs=p(s,"UL",{"data-svelte-h":!0}),r(xs)!=="svelte-1dcb4tb"&&(xs.innerHTML=sn),Pe=l(s),c(fs.$$.fragment,s),Ke=l(s),c(Us.$$.fragment,s),De=l(s),Ts=p(s,"P",{"data-svelte-h":!0}),r(Ts)!=="svelte-w9yj0m"&&(Ts.textContent=en),Oe=l(s),ws=p(s,"P",{"data-svelte-h":!0}),r(ws)!=="svelte-12c54pg"&&(ws.textContent=an),sa=l(s),c(Cs.$$.fragment,s),ea=l(s),c(vs.$$.fragment,s),aa=l(s),Zs=p(s,"P",{"data-svelte-h":!0}),r(Zs)!=="svelte-9rwjil"&&(Zs.textContent=nn),na=l(s),qs=p(s,"P",{"data-svelte-h":!0}),r(qs)!=="svelte-1m2onmr"&&(qs.textContent=tn),ta=l(s),M=p(s,"UL",{});var ja=Fs(M);Is=p(ja,"LI",{});var ya=Fs(Is);Qs=p(ya,"P",{"data-svelte-h":!0}),r(Qs)!=="svelte-ibingj"&&(Qs.textContent=ln),Ma=l(ya),c($s.$$.fragment,ya),ya.forEach(a),Ja=l(ja),Bs=p(ja,"LI",{});var ha=Fs(Bs);Ys=p(ha,"P",{"data-svelte-h":!0}),r(Ys)!=="svelte-qp63kz"&&(Ys.textContent=pn),ba=l(ha),c(Ws.$$.fragment,ha),ha.forEach(a),ja.forEach(a),la=l(s),c(ks.$$.fragment,s),ia=l(s),Gs=p(s,"P",{"data-svelte-h":!0}),r(Gs)!=="svelte-rd5dr6"&&(Gs.textContent=rn),pa=l(s),Hs=p(s,"P",{"data-svelte-h":!0}),r(Hs)!=="svelte-tzxech"&&(Hs.textContent=on),ra=l(s),c(Vs.$$.fragment,s),oa=l(s),Ns=p(s,"P",{"data-svelte-h":!0}),r(Ns)!=="svelte-zqriyx"&&(Ns.textContent=cn),ca=l(s),c(Rs.$$.fragment,s),da=l(s),zs=p(s,"P",{"data-svelte-h":!0}),r(zs)!=="svelte-19bgxb6"&&(zs.innerHTML=dn),ua=l(s),c(Es.$$.fragment,s),ma=l(s),Ls=p(s,"P",{}),Fs(Ls).forEach(a),this.h()},h(){un(h,"name","hf:doc:metadata"),un(h,"content",xn)},m(s,e){J(document.head,h),n(s,Ss,e),n(s,Xs,e),n(s,_s,e),d(b,s,e),n(s,As,e),n(s,x,e),n(s,Ps,e),n(s,f,e),n(s,Ks,e),d(U,s,e),n(s,Ds,e),n(s,T,e),n(s,Os,e),n(s,w,e),n(s,se,e),d(C,s,e),n(s,ee,e),n(s,v,e),n(s,ae,e),n(s,Z,e),n(s,ne,e),d(q,s,e),n(s,te,e),d(I,s,e),n(s,le,e),n(s,$,e),n(s,ie,e),n(s,B,e),n(s,pe,e),d(W,s,e),n(s,re,e),d(k,s,e),n(s,oe,e),n(s,G,e),n(s,ce,e),n(s,H,e),n(s,de,e),n(s,V,e),n(s,ue,e),d(N,s,e),n(s,me,e),n(s,R,e),n(s,ge,e),n(s,z,e),n(s,je,e),d(E,s,e),n(s,ye,e),d(Q,s,e),n(s,he,e),n(s,Y,e),n(s,Me,e),n(s,X,e),n(s,Je,e),d(L,s,e),n(s,be,e),d(F,s,e),n(s,xe,e),n(s,S,e),n(s,fe,e),n(s,_,e),n(s,Ue,e),n(s,A,e),n(s,Te,e),d(P,s,e),n(s,we,e),d(K,s,e),n(s,Ce,e),n(s,D,e),n(s,ve,e),n(s,O,e),n(s,Ze,e),n(s,ss,e),n(s,qe,e),d(es,s,e),n(s,Ie,e),d(as,s,e),n(s,$e,e),n(s,ns,e),n(s,Be,e),d(ts,s,e),n(s,We,e),n(s,ls,e),n(s,ke,e),n(s,is,e),n(s,Ge,e),d(ps,s,e),n(s,He,e),d(rs,s,e),n(s,Ve,e),n(s,os,e),n(s,Ne,e),n(s,cs,e),n(s,Re,e),n(s,ds,e),n(s,ze,e),d(us,s,e),n(s,Ee,e),d(ms,s,e),n(s,Qe,e),n(s,gs,e),n(s,Ye,e),n(s,js,e),n(s,Xe,e),n(s,ys,e),n(s,Le,e),d(hs,s,e),n(s,Fe,e),d(Ms,s,e),n(s,Se,e),n(s,Js,e),n(s,_e,e),n(s,bs,e),n(s,Ae,e),n(s,xs,e),n(s,Pe,e),d(fs,s,e),n(s,Ke,e),d(Us,s,e),n(s,De,e),n(s,Ts,e),n(s,Oe,e),n(s,ws,e),n(s,sa,e),d(Cs,s,e),n(s,ea,e),d(vs,s,e),n(s,aa,e),n(s,Zs,e),n(s,na,e),n(s,qs,e),n(s,ta,e),n(s,M,e),J(M,Is),J(Is,Qs),J(Is,Ma),d($s,Is,null),J(M,Ja),J(M,Bs),J(Bs,Ys),J(Bs,ba),d(Ws,Bs,null),n(s,la,e),d(ks,s,e),n(s,ia,e),n(s,Gs,e),n(s,pa,e),n(s,Hs,e),n(s,ra,e),d(Vs,s,e),n(s,oa,e),n(s,Ns,e),n(s,ca,e),d(Rs,s,e),n(s,da,e),n(s,zs,e),n(s,ua,e),d(Es,s,e),n(s,ma,e),n(s,Ls,e),ga=!0},p:gn,i(s){ga||(u(b.$$.fragment,s),u(U.$$.fragment,s),u(C.$$.fragment,s),u(q.$$.fragment,s),u(I.$$.fragment,s),u(W.$$.fragment,s),u(k.$$.fragment,s),u(N.$$.fragment,s),u(E.$$.fragment,s),u(Q.$$.fragment,s),u(L.$$.fragment,s),u(F.$$.fragment,s),u(P.$$.fragment,s),u(K.$$.fragment,s),u(es.$$.fragment,s),u(as.$$.fragment,s),u(ts.$$.fragment,s),u(ps.$$.fragment,s),u(rs.$$.fragment,s),u(us.$$.fragment,s),u(ms.$$.fragment,s),u(hs.$$.fragment,s),u(Ms.$$.fragment,s),u(fs.$$.fragment,s),u(Us.$$.fragment,s),u(Cs.$$.fragment,s),u(vs.$$.fragment,s),u($s.$$.fragment,s),u(Ws.$$.fragment,s),u(ks.$$.fragment,s),u(Vs.$$.fragment,s),u(Rs.$$.fragment,s),u(Es.$$.fragment,s),ga=!0)},o(s){m(b.$$.fragment,s),m(U.$$.fragment,s),m(C.$$.fragment,s),m(q.$$.fragment,s),m(I.$$.fragment,s),m(W.$$.fragment,s),m(k.$$.fragment,s),m(N.$$.fragment,s),m(E.$$.fragment,s),m(Q.$$.fragment,s),m(L.$$.fragment,s),m(F.$$.fragment,s),m(P.$$.fragment,s),m(K.$$.fragment,s),m(es.$$.fragment,s),m(as.$$.fragment,s),m(ts.$$.fragment,s),m(ps.$$.fragment,s),m(rs.$$.fragment,s),m(us.$$.fragment,s),m(ms.$$.fragment,s),m(hs.$$.fragment,s),m(Ms.$$.fragment,s),m(fs.$$.fragment,s),m(Us.$$.fragment,s),m(Cs.$$.fragment,s),m(vs.$$.fragment,s),m($s.$$.fragment,s),m(Ws.$$.fragment,s),m(ks.$$.fragment,s),m(Vs.$$.fragment,s),m(Rs.$$.fragment,s),m(Es.$$.fragment,s),ga=!1},d(s){s&&(a(Ss),a(Xs),a(_s),a(As),a(x),a(Ps),a(f),a(Ks),a(Ds),a(T),a(Os),a(w),a(se),a(ee),a(v),a(ae),a(Z),a(ne),a(te),a(le),a($),a(ie),a(B),a(pe),a(re),a(oe),a(G),a(ce),a(H),a(de),a(V),a(ue),a(me),a(R),a(ge),a(z),a(je),a(ye),a(he),a(Y),a(Me),a(X),a(Je),a(be),a(xe),a(S),a(fe),a(_),a(Ue),a(A),a(Te),a(we),a(Ce),a(D),a(ve),a(O),a(Ze),a(ss),a(qe),a(Ie),a($e),a(ns),a(Be),a(We),a(ls),a(ke),a(is),a(Ge),a(He),a(Ve),a(os),a(Ne),a(cs),a(Re),a(ds),a(ze),a(Ee),a(Qe),a(gs),a(Ye),a(js),a(Xe),a(ys),a(Le),a(Fe),a(Se),a(Js),a(_e),a(bs),a(Ae),a(xs),a(Pe),a(Ke),a(De),a(Ts),a(Oe),a(ws),a(sa),a(ea),a(aa),a(Zs),a(na),a(qs),a(ta),a(M),a(la),a(ia),a(Gs),a(pa),a(Hs),a(ra),a(oa),a(Ns),a(ca),a(da),a(zs),a(ua),a(ma),a(Ls)),a(h),g(b,s),g(U,s),g(C,s),g(q,s),g(I,s),g(W,s),g(k,s),g(N,s),g(E,s),g(Q,s),g(L,s),g(F,s),g(P,s),g(K,s),g(es,s),g(as,s),g(ts,s),g(ps,s),g(rs,s),g(us,s),g(ms,s),g(hs,s),g(Ms,s),g(fs,s),g(Us,s),g(Cs,s),g(vs,s),g($s),g(Ws),g(ks,s),g(Vs,s),g(Rs,s),g(Es,s)}}}const xn='{"title":"Lo que 🤗 Transformers puede hacer","local":"lo-que--transformers-puede-hacer","sections":[{"title":"Audio","local":"audio","sections":[{"title":"Clasificación de audio","local":"clasificación-de-audio","sections":[],"depth":3},{"title":"Reconocimiento automático del habla","local":"reconocimiento-automático-del-habla","sections":[],"depth":3}],"depth":2},{"title":"Visión por computadora","local":"visión-por-computadora","sections":[{"title":"Clasificación de imágenes","local":"clasificación-de-imágenes","sections":[],"depth":3},{"title":"Detección de objetos","local":"detección-de-objetos","sections":[],"depth":3},{"title":"Segmentación de imágenes","local":"segmentación-de-imágenes","sections":[],"depth":3},{"title":"Estimación de profundidad","local":"estimación-de-profundidad","sections":[],"depth":3}],"depth":2},{"title":"Procesamiento del lenguaje natural","local":"procesamiento-del-lenguaje-natural","sections":[{"title":"Clasificación de texto","local":"clasificación-de-texto","sections":[],"depth":3},{"title":"Clasificación de tokens","local":"clasificación-de-tokens","sections":[],"depth":3},{"title":"Respuestas a preguntas","local":"respuestas-a-preguntas","sections":[],"depth":3},{"title":"Resumir","local":"resumir","sections":[],"depth":3},{"title":"Traducción","local":"traducción","sections":[],"depth":3},{"title":"Modelado de lenguaje","local":"modelado-de-lenguaje","sections":[],"depth":3}],"depth":2},{"title":"Multimodal","local":"multimodal","sections":[{"title":"Respuestas a preguntas de documentos","local":"respuestas-a-preguntas-de-documentos","sections":[],"depth":3}],"depth":2}],"depth":1}';function fn(xa){return jn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vn extends yn{constructor(h){super(),hn(this,h,fn,bn,mn,{})}}export{vn as component};
