import{s as _t,o as kt,n as Vs}from"../chunks/scheduler.bdbef820.js";import{S as Zt,i as Ct,g as j,s as i,r as h,A as Wt,h as b,f as t,c as m,j as Tt,u as f,x as T,k as Jt,y as vt,a as e,v as u,d,t as g,w as y,m as Gt,n as Xt}from"../chunks/index.33f81d56.js";import{T as mt}from"../chunks/Tip.34194030.js";import{C as G}from"../chunks/CodeBlock.3bad7fc9.js";import{D as Rt}from"../chunks/DocNotebookDropdown.339158fb.js";import{F as Ut,M as it}from"../chunks/Markdown.8a4b74ff.js";import{H as Gs,E as xt}from"../chunks/index.1b7d14e3.js";function Vt(V){let a,M='<a href="/docs/transformers/main/ja/main_classes/trainer#transformers.Trainer">Trainer</a> を使用したモデルの微調整に慣れていない場合は、<a href="../training#train-with-pytorch-trainer">ここ</a> の基本的なチュートリアルをご覧ください。';return{c(){a=j("p"),a.innerHTML=M},l(n){a=b(n,"P",{"data-svelte-h":!0}),T(a)!=="svelte-1ubngji"&&(a.innerHTML=M)},m(n,o){e(n,a,o)},p:Vs,d(n){n&&t(a)}}}function It(V){let a,M,n,o='これでモデルのトレーニングを開始する準備が整いました。 <a href="/docs/transformers/main/ja/model_doc/auto#transformers.AutoModelForMultipleChoice">AutoModelForMultipleChoice</a> を使用して BERT をロードします。',$,_,x,C,k="この時点で残っている手順は次の 3 つだけです。",X,Z,I='<li><a href="/docs/transformers/main/ja/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> でトレーニング ハイパーパラメータを定義します。唯一の必須パラメータは、モデルの保存場所を指定する <code>output_dir</code> です。 <code>push_to_hub=True</code>を設定して、このモデルをハブにプッシュします (モデルをアップロードするには、Hugging Face にサインインする必要があります)。各エポックの終了時に、<a href="/docs/transformers/main/ja/main_classes/trainer#transformers.Trainer">Trainer</a> は精度を評価し、トレーニング チェックポイントを保存します。</li> <li>トレーニング引数を、モデル、データセット、トークナイザー、データ照合器、および <code>compute_metrics</code> 関数とともに <a href="/docs/transformers/main/ja/main_classes/trainer#transformers.Trainer">Trainer</a> に渡します。</li> <li><a href="/docs/transformers/main/ja/main_classes/trainer#transformers.Trainer.train">train()</a> を呼び出してモデルを微調整します。</li>',R,U,W,r,J='トレーニングが完了したら、 <a href="/docs/transformers/main/ja/main_classes/trainer#transformers.Trainer.push_to_hub">push_to_hub()</a> メソッドを使用してモデルをハブに共有し、誰もがモデルを使用できますように。',B,F,z;return a=new mt({props:{$$slots:{default:[Vt]},$$scope:{ctx:V}}}),_=new G({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlJTJDJTIwVHJhaW5pbmdBcmd1bWVudHMlMkMlMjBUcmFpbmVyJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JNdWx0aXBsZUNob2ljZS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtdW5jYXNlZCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForMultipleChoice, TrainingArguments, Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)`,wrap:!1}}),U=new G({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjJteV9hd2Vzb21lX3N3YWdfbW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjBldmFsX3N0cmF0ZWd5JTNEJTIyZXBvY2glMjIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0cmF0ZWd5JTNEJTIyZXBvY2glMjIlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2Jlc3RfbW9kZWxfYXRfZW5kJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0Q1ZS01JTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX2V2YWxfYmF0Y2hfc2l6ZSUzRDE2JTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluX2Vwb2NocyUzRDMlMkMlMEElMjAlMjAlMjAlMjB3ZWlnaHRfZGVjYXklM0QwLjAxJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0b2tlbml6ZWRfc3dhZyU1QiUyMnRyYWluJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEdG9rZW5pemVkX3N3YWclNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc2luZ19jbGFzcyUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRvciUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(
<span class="hljs-meta">... </span>    output_dir=<span class="hljs-string">&quot;my_awesome_swag_model&quot;</span>,
<span class="hljs-meta">... </span>    eval_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
<span class="hljs-meta">... </span>    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
<span class="hljs-meta">... </span>    load_best_model_at_end=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">5e-5</span>,
<span class="hljs-meta">... </span>    per_device_train_batch_size=<span class="hljs-number">16</span>,
<span class="hljs-meta">... </span>    per_device_eval_batch_size=<span class="hljs-number">16</span>,
<span class="hljs-meta">... </span>    num_train_epochs=<span class="hljs-number">3</span>,
<span class="hljs-meta">... </span>    weight_decay=<span class="hljs-number">0.01</span>,
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    train_dataset=tokenized_swag[<span class="hljs-string">&quot;train&quot;</span>],
<span class="hljs-meta">... </span>    eval_dataset=tokenized_swag[<span class="hljs-string">&quot;validation&quot;</span>],
<span class="hljs-meta">... </span>    processing_class=tokenizer,
<span class="hljs-meta">... </span>    data_collator=collator,
<span class="hljs-meta">... </span>    compute_metrics=compute_metrics,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()`,wrap:!1}}),F=new G({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()',wrap:!1}}),{c(){h(a.$$.fragment),M=i(),n=j("p"),n.innerHTML=o,$=i(),h(_.$$.fragment),x=i(),C=j("p"),C.textContent=k,X=i(),Z=j("ol"),Z.innerHTML=I,R=i(),h(U.$$.fragment),W=i(),r=j("p"),r.innerHTML=J,B=i(),h(F.$$.fragment)},l(c){f(a.$$.fragment,c),M=m(c),n=b(c,"P",{"data-svelte-h":!0}),T(n)!=="svelte-xazux0"&&(n.innerHTML=o),$=m(c),f(_.$$.fragment,c),x=m(c),C=b(c,"P",{"data-svelte-h":!0}),T(C)!=="svelte-1j8bgyv"&&(C.textContent=k),X=m(c),Z=b(c,"OL",{"data-svelte-h":!0}),T(Z)!=="svelte-1ahmepw"&&(Z.innerHTML=I),R=m(c),f(U.$$.fragment,c),W=m(c),r=b(c,"P",{"data-svelte-h":!0}),T(r)!=="svelte-1hfdqw3"&&(r.innerHTML=J),B=m(c),f(F.$$.fragment,c)},m(c,v){u(a,c,v),e(c,M,v),e(c,n,v),e(c,$,v),u(_,c,v),e(c,x,v),e(c,C,v),e(c,X,v),e(c,Z,v),e(c,R,v),u(U,c,v),e(c,W,v),e(c,r,v),e(c,B,v),u(F,c,v),z=!0},p(c,v){const Y={};v&2&&(Y.$$scope={dirty:v,ctx:c}),a.$set(Y)},i(c){z||(d(a.$$.fragment,c),d(_.$$.fragment,c),d(U.$$.fragment,c),d(F.$$.fragment,c),z=!0)},o(c){g(a.$$.fragment,c),g(_.$$.fragment,c),g(U.$$.fragment,c),g(F.$$.fragment,c),z=!1},d(c){c&&(t(M),t(n),t($),t(x),t(C),t(X),t(Z),t(R),t(W),t(r),t(B)),y(a,c),y(_,c),y(U,c),y(F,c)}}}function Bt(V){let a,M;return a=new it({props:{$$slots:{default:[It]},$$scope:{ctx:V}}}),{c(){h(a.$$.fragment)},l(n){f(a.$$.fragment,n)},m(n,o){u(a,n,o),M=!0},p(n,o){const $={};o&2&&($.$$scope={dirty:o,ctx:n}),a.$set($)},i(n){M||(d(a.$$.fragment,n),M=!0)},o(n){g(a.$$.fragment,n),M=!1},d(n){y(a,n)}}}function Yt(V){let a,M='Keras を使用したモデルの微調整に慣れていない場合は、<a href="../training#train-a-tensorflow-model-with-keras">こちら</a> の基本的なチュートリアルをご覧ください。';return{c(){a=j("p"),a.innerHTML=M},l(n){a=b(n,"P",{"data-svelte-h":!0}),T(a)!=="svelte-1jwo7q8"&&(a.innerHTML=M)},m(n,o){e(n,a,o)},p:Vs,d(n){n&&t(a)}}}function zt(V){let a,M,n,o,$,_='次に、<a href="/docs/transformers/main/ja/model_doc/auto#transformers.TFAutoModelForMultipleChoice">TFAutoModelForMultipleChoice</a> を使用して BERT をロードできます。',x,C,k,X,Z='<a href="/docs/transformers/main/ja/main_classes/model#transformers.TFPreTrainedModel.prepare_tf_dataset">prepare_tf_dataset()</a> を使用して、データセットを <code>tf.data.Dataset</code> 形式に変換します。',I,R,U,W,r='<a href="https://keras.io/api/models/model_training_apis/#compile-method" rel="nofollow"><code>compile</code></a> を使用してトレーニング用のモデルを設定します。 Transformers モデルにはすべてデフォルトのタスク関連の損失関数があるため、次の場合を除き、損失関数を指定する必要はないことに注意してください。',J,B,F,z,c='トレーニングを開始する前にセットアップする最後の 2 つのことは、予測から精度を計算することと、モデルをハブにプッシュする方法を提供することです。どちらも <a href="../main_classes/keras_callbacks">Keras コールバック</a> を使用して行われます。',v,Y,Xs='<code>compute_metrics</code> 関数を <a href="/docs/transformers/main/ja/main_classes/keras_callbacks#transformers.KerasMetricCallback">KerasMetricCallback</a> に渡します。',ss,N,ts,H,ms='<a href="/docs/transformers/main/ja/main_classes/keras_callbacks#transformers.PushToHubCallback">PushToHubCallback</a> でモデルとトークナイザーをプッシュする場所を指定します。',q,P,es,Q,cs="次に、コールバックをまとめてバンドルします。",L,D,ls,E,os='ついに、モデルのトレーニングを開始する準備が整いました。トレーニングおよび検証データセット、エポック数、コールバックを指定して <a href="https://keras.io/api/models/model_training_apis/#fit-method" rel="nofollow"><code>fit</code></a> を呼び出し、モデルを微調整します。',S,K,as,A,Rs="トレーニングが完了すると、モデルは自動的にハブにアップロードされ、誰でも使用できるようになります。",ns;return a=new mt({props:{$$slots:{default:[Yt]},$$scope:{ctx:V}}}),n=new G({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGNyZWF0ZV9vcHRpbWl6ZXIlMEElMEFiYXRjaF9zaXplJTIwJTNEJTIwMTYlMEFudW1fdHJhaW5fZXBvY2hzJTIwJTNEJTIwMiUwQXRvdGFsX3RyYWluX3N0ZXBzJTIwJTNEJTIwKGxlbih0b2tlbml6ZWRfc3dhZyU1QiUyMnRyYWluJTIyJTVEKSUyMCUyRiUyRiUyMGJhdGNoX3NpemUpJTIwKiUyMG51bV90cmFpbl9lcG9jaHMlMEFvcHRpbWl6ZXIlMkMlMjBzY2hlZHVsZSUyMCUzRCUyMGNyZWF0ZV9vcHRpbWl6ZXIoaW5pdF9sciUzRDVlLTUlMkMlMjBudW1fd2FybXVwX3N0ZXBzJTNEMCUyQyUyMG51bV90cmFpbl9zdGVwcyUzRHRvdGFsX3RyYWluX3N0ZXBzKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> create_optimizer

<span class="hljs-meta">&gt;&gt;&gt; </span>batch_size = <span class="hljs-number">16</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_train_epochs = <span class="hljs-number">2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>total_train_steps = (<span class="hljs-built_in">len</span>(tokenized_swag[<span class="hljs-string">&quot;train&quot;</span>]) // batch_size) * num_train_epochs
<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer, schedule = create_optimizer(init_lr=<span class="hljs-number">5e-5</span>, num_warmup_steps=<span class="hljs-number">0</span>, num_train_steps=total_train_steps)`,wrap:!1}}),C=new G({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRGQXV0b01vZGVsRm9yTXVsdGlwbGVDaG9pY2UlMEElMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLXVuY2FzZWQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TFAutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)`,wrap:!1}}),R=new G({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvckZvck11bHRpcGxlQ2hvaWNlKHRva2VuaXplciUzRHRva2VuaXplciklMEF0Zl90cmFpbl9zZXQlMjAlM0QlMjBtb2RlbC5wcmVwYXJlX3RmX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVkX3N3YWclNUIlMjJ0cmFpbiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHNodWZmbGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUlMkMlMEElMjAlMjAlMjAlMjBjb2xsYXRlX2ZuJTNEZGF0YV9jb2xsYXRvciUyQyUwQSklMEElMEF0Zl92YWxpZGF0aW9uX3NldCUyMCUzRCUyMG1vZGVsLnByZXBhcmVfdGZfZGF0YXNldCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZWRfc3dhZyU1QiUyMnZhbGlkYXRpb24lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBzaHVmZmxlJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMGNvbGxhdGVfZm4lM0RkYXRhX2NvbGxhdG9yJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>data_collator = DataCollatorForMultipleChoice(tokenizer=tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>tf_train_set = model.prepare_tf_dataset(
<span class="hljs-meta">... </span>    tokenized_swag[<span class="hljs-string">&quot;train&quot;</span>],
<span class="hljs-meta">... </span>    shuffle=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    batch_size=batch_size,
<span class="hljs-meta">... </span>    collate_fn=data_collator,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tf_validation_set = model.prepare_tf_dataset(
<span class="hljs-meta">... </span>    tokenized_swag[<span class="hljs-string">&quot;validation&quot;</span>],
<span class="hljs-meta">... </span>    shuffle=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    batch_size=batch_size,
<span class="hljs-meta">... </span>    collate_fn=data_collator,
<span class="hljs-meta">... </span>)`,wrap:!1}}),B=new G({props:{code:"bW9kZWwuY29tcGlsZShvcHRpbWl6ZXIlM0RvcHRpbWl6ZXIpJTIwJTIwJTIzJTIwTm8lMjBsb3NzJTIwYXJndW1lbnQh",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">compile</span>(optimizer=optimizer)  <span class="hljs-comment"># No loss argument!</span>',wrap:!1}}),N=new G({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5rZXJhc19jYWxsYmFja3MlMjBpbXBvcnQlMjBLZXJhc01ldHJpY0NhbGxiYWNrJTBBJTBBbWV0cmljX2NhbGxiYWNrJTIwJTNEJTIwS2VyYXNNZXRyaWNDYWxsYmFjayhtZXRyaWNfZm4lM0Rjb21wdXRlX21ldHJpY3MlMkMlMjBldmFsX2RhdGFzZXQlM0R0Zl92YWxpZGF0aW9uX3NldCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.keras_callbacks <span class="hljs-keyword">import</span> KerasMetricCallback

<span class="hljs-meta">&gt;&gt;&gt; </span>metric_callback = KerasMetricCallback(metric_fn=compute_metrics, eval_dataset=tf_validation_set)`,wrap:!1}}),P=new G({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5rZXJhc19jYWxsYmFja3MlMjBpbXBvcnQlMjBQdXNoVG9IdWJDYWxsYmFjayUwQSUwQXB1c2hfdG9faHViX2NhbGxiYWNrJTIwJTNEJTIwUHVzaFRvSHViQ2FsbGJhY2soJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMm15X2F3ZXNvbWVfbW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.keras_callbacks <span class="hljs-keyword">import</span> PushToHubCallback

<span class="hljs-meta">&gt;&gt;&gt; </span>push_to_hub_callback = PushToHubCallback(
<span class="hljs-meta">... </span>    output_dir=<span class="hljs-string">&quot;my_awesome_model&quot;</span>,
<span class="hljs-meta">... </span>    tokenizer=tokenizer,
<span class="hljs-meta">... </span>)`,wrap:!1}}),D=new G({props:{code:"Y2FsbGJhY2tzJTIwJTNEJTIwJTVCbWV0cmljX2NhbGxiYWNrJTJDJTIwcHVzaF90b19odWJfY2FsbGJhY2slNUQ=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>callbacks = [metric_callback, push_to_hub_callback]',wrap:!1}}),K=new G({props:{code:"bW9kZWwuZml0KHglM0R0Zl90cmFpbl9zZXQlMkMlMjB2YWxpZGF0aW9uX2RhdGElM0R0Zl92YWxpZGF0aW9uX3NldCUyQyUyMGVwb2NocyUzRDIlMkMlMjBjYWxsYmFja3MlM0RjYWxsYmFja3Mp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model.fit(x=tf_train_set, validation_data=tf_validation_set, epochs=<span class="hljs-number">2</span>, callbacks=callbacks)',wrap:!1}}),{c(){h(a.$$.fragment),M=Gt(`
TensorFlow でモデルを微調整するには、オプティマイザー関数、学習率スケジュール、およびいくつかのトレーニング ハイパーパラメーターをセットアップすることから始めます。

	`),h(n.$$.fragment),o=i(),$=j("p"),$.innerHTML=_,x=i(),h(C.$$.fragment),k=i(),X=j("p"),X.innerHTML=Z,I=i(),h(R.$$.fragment),U=i(),W=j("p"),W.innerHTML=r,J=i(),h(B.$$.fragment),F=i(),z=j("p"),z.innerHTML=c,v=i(),Y=j("p"),Y.innerHTML=Xs,ss=i(),h(N.$$.fragment),ts=i(),H=j("p"),H.innerHTML=ms,q=i(),h(P.$$.fragment),es=i(),Q=j("p"),Q.textContent=cs,L=i(),h(D.$$.fragment),ls=i(),E=j("p"),E.innerHTML=os,S=i(),h(K.$$.fragment),as=i(),A=j("p"),A.textContent=Rs},l(l){f(a.$$.fragment,l),M=Xt(l,`
TensorFlow でモデルを微調整するには、オプティマイザー関数、学習率スケジュール、およびいくつかのトレーニング ハイパーパラメーターをセットアップすることから始めます。

	`),f(n.$$.fragment,l),o=m(l),$=b(l,"P",{"data-svelte-h":!0}),T($)!=="svelte-whs12v"&&($.innerHTML=_),x=m(l),f(C.$$.fragment,l),k=m(l),X=b(l,"P",{"data-svelte-h":!0}),T(X)!=="svelte-1mdvspu"&&(X.innerHTML=Z),I=m(l),f(R.$$.fragment,l),U=m(l),W=b(l,"P",{"data-svelte-h":!0}),T(W)!=="svelte-1pd5few"&&(W.innerHTML=r),J=m(l),f(B.$$.fragment,l),F=m(l),z=b(l,"P",{"data-svelte-h":!0}),T(z)!=="svelte-16n7r85"&&(z.innerHTML=c),v=m(l),Y=b(l,"P",{"data-svelte-h":!0}),T(Y)!=="svelte-ht78yi"&&(Y.innerHTML=Xs),ss=m(l),f(N.$$.fragment,l),ts=m(l),H=b(l,"P",{"data-svelte-h":!0}),T(H)!=="svelte-1rwfgpb"&&(H.innerHTML=ms),q=m(l),f(P.$$.fragment,l),es=m(l),Q=b(l,"P",{"data-svelte-h":!0}),T(Q)!=="svelte-r16oc5"&&(Q.textContent=cs),L=m(l),f(D.$$.fragment,l),ls=m(l),E=b(l,"P",{"data-svelte-h":!0}),T(E)!=="svelte-ffgub5"&&(E.innerHTML=os),S=m(l),f(K.$$.fragment,l),as=m(l),A=b(l,"P",{"data-svelte-h":!0}),T(A)!=="svelte-vh7z0v"&&(A.textContent=Rs)},m(l,w){u(a,l,w),e(l,M,w),u(n,l,w),e(l,o,w),e(l,$,w),e(l,x,w),u(C,l,w),e(l,k,w),e(l,X,w),e(l,I,w),u(R,l,w),e(l,U,w),e(l,W,w),e(l,J,w),u(B,l,w),e(l,F,w),e(l,z,w),e(l,v,w),e(l,Y,w),e(l,ss,w),u(N,l,w),e(l,ts,w),e(l,H,w),e(l,q,w),u(P,l,w),e(l,es,w),e(l,Q,w),e(l,L,w),u(D,l,w),e(l,ls,w),e(l,E,w),e(l,S,w),u(K,l,w),e(l,as,w),e(l,A,w),ns=!0},p(l,w){const O={};w&2&&(O.$$scope={dirty:w,ctx:l}),a.$set(O)},i(l){ns||(d(a.$$.fragment,l),d(n.$$.fragment,l),d(C.$$.fragment,l),d(R.$$.fragment,l),d(B.$$.fragment,l),d(N.$$.fragment,l),d(P.$$.fragment,l),d(D.$$.fragment,l),d(K.$$.fragment,l),ns=!0)},o(l){g(a.$$.fragment,l),g(n.$$.fragment,l),g(C.$$.fragment,l),g(R.$$.fragment,l),g(B.$$.fragment,l),g(N.$$.fragment,l),g(P.$$.fragment,l),g(D.$$.fragment,l),g(K.$$.fragment,l),ns=!1},d(l){l&&(t(M),t(o),t($),t(x),t(k),t(X),t(I),t(U),t(W),t(J),t(F),t(z),t(v),t(Y),t(ss),t(ts),t(H),t(q),t(es),t(Q),t(L),t(ls),t(E),t(S),t(as),t(A)),y(a,l),y(n,l),y(C,l),y(R,l),y(B,l),y(N,l),y(P,l),y(D,l),y(K,l)}}}function Ft(V){let a,M;return a=new it({props:{$$slots:{default:[zt]},$$scope:{ctx:V}}}),{c(){h(a.$$.fragment)},l(n){f(a.$$.fragment,n)},m(n,o){u(a,n,o),M=!0},p(n,o){const $={};o&2&&($.$$scope={dirty:o,ctx:n}),a.$set($)},i(n){M||(d(a.$$.fragment,n),M=!0)},o(n){g(a.$$.fragment,n),M=!1},d(n){y(a,n)}}}function Nt(V){let a,M=`複数選択用にモデルを微調整する方法の詳細な例については、対応するセクションを参照してください。
<a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/multiple_choice.ipynb" rel="nofollow">PyTorch ノートブック</a>
または <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/multiple_choice-tf.ipynb" rel="nofollow">TensorFlow ノートブック</a>。`;return{c(){a=j("p"),a.innerHTML=M},l(n){a=b(n,"P",{"data-svelte-h":!0}),T(a)!=="svelte-qfa40k"&&(a.innerHTML=M)},m(n,o){e(n,a,o)},p:Vs,d(n){n&&t(a)}}}function Ht(V){let a,M="各プロンプトと回答候補のペアをトークン化し、PyTorch テンソルを返します。いくつかの<code>lables</code>も作成する必要があります。",n,o,$,_,x="入力とラベルをモデルに渡し、<code>logits</code>を返します。",C,k,X,Z,I="最も高い確率でクラスを取得します。",R,U,W;return o=new G({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJteV9hd2Vzb21lX3N3YWdfbW9kZWwlMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiU1QnByb21wdCUyQyUyMGNhbmRpZGF0ZTElNUQlMkMlMjAlNUJwcm9tcHQlMkMlMjBjYW5kaWRhdGUyJTVEJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHBhZGRpbmclM0RUcnVlKSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvcigwKS51bnNxdWVlemUoMCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;my_awesome_swag_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([[prompt, candidate1], [prompt, candidate2]], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor(<span class="hljs-number">0</span>).unsqueeze(<span class="hljs-number">0</span>)`,wrap:!1}}),k=new G({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JNdWx0aXBsZUNob2ljZS5mcm9tX3ByZXRyYWluZWQoJTIybXlfYXdlc29tZV9zd2FnX21vZGVsJTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKiU3QmslM0ElMjB2LnVuc3F1ZWV6ZSgwKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBpbnB1dHMuaXRlbXMoKSU3RCUyQyUyMGxhYmVscyUzRGxhYmVscyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;my_awesome_swag_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**{k: v.unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),U=new G({props:{code:"cHJlZGljdGVkX2NsYXNzJTIwJTNEJTIwbG9naXRzLmFyZ21heCgpLml0ZW0oKSUwQXByZWRpY3RlZF9jbGFzcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class = logits.argmax().item()
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class
<span class="hljs-string">&#x27;0&#x27;</span>`,wrap:!1}}),{c(){a=j("p"),a.innerHTML=M,n=i(),h(o.$$.fragment),$=i(),_=j("p"),_.innerHTML=x,C=i(),h(k.$$.fragment),X=i(),Z=j("p"),Z.textContent=I,R=i(),h(U.$$.fragment)},l(r){a=b(r,"P",{"data-svelte-h":!0}),T(a)!=="svelte-zbyraq"&&(a.innerHTML=M),n=m(r),f(o.$$.fragment,r),$=m(r),_=b(r,"P",{"data-svelte-h":!0}),T(_)!=="svelte-3ueqnu"&&(_.innerHTML=x),C=m(r),f(k.$$.fragment,r),X=m(r),Z=b(r,"P",{"data-svelte-h":!0}),T(Z)!=="svelte-yua5rw"&&(Z.textContent=I),R=m(r),f(U.$$.fragment,r)},m(r,J){e(r,a,J),e(r,n,J),u(o,r,J),e(r,$,J),e(r,_,J),e(r,C,J),u(k,r,J),e(r,X,J),e(r,Z,J),e(r,R,J),u(U,r,J),W=!0},p:Vs,i(r){W||(d(o.$$.fragment,r),d(k.$$.fragment,r),d(U.$$.fragment,r),W=!0)},o(r){g(o.$$.fragment,r),g(k.$$.fragment,r),g(U.$$.fragment,r),W=!1},d(r){r&&(t(a),t(n),t($),t(_),t(C),t(X),t(Z),t(R)),y(o,r),y(k,r),y(U,r)}}}function Qt(V){let a,M;return a=new it({props:{$$slots:{default:[Ht]},$$scope:{ctx:V}}}),{c(){h(a.$$.fragment)},l(n){f(a.$$.fragment,n)},m(n,o){u(a,n,o),M=!0},p(n,o){const $={};o&2&&($.$$scope={dirty:o,ctx:n}),a.$set($)},i(n){M||(d(a.$$.fragment,n),M=!0)},o(n){g(a.$$.fragment,n),M=!1},d(n){y(a,n)}}}function Et(V){let a,M="各プロンプトと回答候補のペアをトークン化し、TensorFlow テンソルを返します。",n,o,$,_,x="入力をモデルに渡し、<code>logits</code>を返します。",C,k,X,Z,I="最も高い確率でクラスを取得します。",R,U,W;return o=new G({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJteV9hd2Vzb21lX3N3YWdfbW9kZWwlMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiU1QnByb21wdCUyQyUyMGNhbmRpZGF0ZTElNUQlMkMlMjAlNUJwcm9tcHQlMkMlMjBjYW5kaWRhdGUyJTVEJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiUyQyUyMHBhZGRpbmclM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;my_awesome_swag_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([[prompt, candidate1], [prompt, candidate2]], return_tensors=<span class="hljs-string">&quot;tf&quot;</span>, padding=<span class="hljs-literal">True</span>)`,wrap:!1}}),k=new G({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRGQXV0b01vZGVsRm9yTXVsdGlwbGVDaG9pY2UlMEElMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9wcmV0cmFpbmVkKCUyMm15X2F3ZXNvbWVfc3dhZ19tb2RlbCUyMiklMEFpbnB1dHMlMjAlM0QlMjAlN0JrJTNBJTIwdGYuZXhwYW5kX2RpbXModiUyQyUyMDApJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGlucHV0cy5pdGVtcygpJTdEJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TFAutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;my_awesome_swag_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = {k: tf.expand_dims(v, <span class="hljs-number">0</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),U=new G({props:{code:"cHJlZGljdGVkX2NsYXNzJTIwJTNEJTIwaW50KHRmLm1hdGguYXJnbWF4KGxvZ2l0cyUyQyUyMGF4aXMlM0QtMSklNUIwJTVEKSUwQXByZWRpY3RlZF9jbGFzcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class = <span class="hljs-built_in">int</span>(tf.math.argmax(logits, axis=-<span class="hljs-number">1</span>)[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class
<span class="hljs-string">&#x27;0&#x27;</span>`,wrap:!1}}),{c(){a=j("p"),a.textContent=M,n=i(),h(o.$$.fragment),$=i(),_=j("p"),_.innerHTML=x,C=i(),h(k.$$.fragment),X=i(),Z=j("p"),Z.textContent=I,R=i(),h(U.$$.fragment)},l(r){a=b(r,"P",{"data-svelte-h":!0}),T(a)!=="svelte-fvrqfh"&&(a.textContent=M),n=m(r),f(o.$$.fragment,r),$=m(r),_=b(r,"P",{"data-svelte-h":!0}),T(_)!=="svelte-1rvunpz"&&(_.innerHTML=x),C=m(r),f(k.$$.fragment,r),X=m(r),Z=b(r,"P",{"data-svelte-h":!0}),T(Z)!=="svelte-yua5rw"&&(Z.textContent=I),R=m(r),f(U.$$.fragment,r)},m(r,J){e(r,a,J),e(r,n,J),u(o,r,J),e(r,$,J),e(r,_,J),e(r,C,J),u(k,r,J),e(r,X,J),e(r,Z,J),e(r,R,J),u(U,r,J),W=!0},p:Vs,i(r){W||(d(o.$$.fragment,r),d(k.$$.fragment,r),d(U.$$.fragment,r),W=!0)},o(r){g(o.$$.fragment,r),g(k.$$.fragment,r),g(U.$$.fragment,r),W=!1},d(r){r&&(t(a),t(n),t($),t(_),t(C),t(X),t(Z),t(R)),y(o,r),y(k,r),y(U,r)}}}function At(V){let a,M;return a=new it({props:{$$slots:{default:[Et]},$$scope:{ctx:V}}}),{c(){h(a.$$.fragment)},l(n){f(a.$$.fragment,n)},m(n,o){u(a,n,o),M=!0},p(n,o){const $={};o&2&&($.$$scope={dirty:o,ctx:n}),a.$set($)},i(n){M||(d(a.$$.fragment,n),M=!0)},o(n){g(a.$$.fragment,n),M=!1},d(n){y(a,n)}}}function qt(V){let a,M,n,o,$,_,x,C,k,X="多肢選択タスクは質問応答に似ていますが、いくつかの候補の回答がコンテキストとともに提供され、正しい回答を選択するようにモデルがトレーニングされる点が異なります。",Z,I,R="このガイドでは、次の方法を説明します。",U,W,r='<li><a href="https://huggingface.co/datasets/swag" rel="nofollow">SWAG</a> データセットの「通常」構成で <a href="https://huggingface.co/google-bert/bert-base-uncased" rel="nofollow">BERT</a> を微調整して、最適なデータセットを選択します複数の選択肢と何らかのコンテキストを考慮して回答します。</li> <li>微調整したモデルを推論に使用します。</li>',J,B,F="始める前に、必要なライブラリがすべてインストールされていることを確認してください。",z,c,v,Y,Xs="モデルをアップロードしてコミュニティと共有できるように、Hugging Face アカウントにログインすることをお勧めします。プロンプトが表示されたら、トークンを入力してログインします。",ss,N,ts,H,ms,q,P="まず、🤗 データセット ライブラリから SWAG データセットの「通常」構成をロードします。",es,Q,cs,L,D="次に、例を見てみましょう。",ls,E,os,S,K="ここにはたくさんのフィールドがあるように見えますが、実際は非常に簡単です。",as,A,Rs="<li><code>sent1</code> と <code>sent2</code>: これらのフィールドは文の始まりを示し、この 2 つを組み合わせると <code>startphrase</code> フィールドが得られます。</li> <li><code>ending</code>: 文の終わり方として考えられる終わり方を示唆しますが、正しいのは 1 つだけです。</li> <li><code>label</code>: 正しい文の終わりを識別します。</li>",ns,l,w,O,ct="次のステップでは、BERT トークナイザーをロードして、文の始まりと 4 つの可能な終わりを処理します。",Is,Ms,Bs,hs,ot="作成する前処理関数は次のことを行う必要があります。",Ys,fs,Mt="<li><code>sent1</code> フィールドのコピーを 4 つ作成し、それぞれを <code>sent2</code> と組み合わせて文の始まりを再現します。</li> <li><code>sent2</code> を 4 つの可能な文末尾のそれぞれと組み合わせます。</li> <li>これら 2 つのリストをトークン化できるようにフラット化し、その後、各例に対応する <code>input_ids</code>、<code>attention_mask</code>、および <code>labels</code> フィールドが含まれるように非フラット化します。</li>",zs,us,Fs,ds,ht="データセット全体に前処理関数を適用するには、🤗 Datasets <code>map</code> メソッドを使用します。 <code>batched=True</code> を設定してデータセットの複数の要素を一度に処理することで、<code>map</code> 関数を高速化できます。",Ns,gs,Hs,ys,ft="<code>DataCollatorForMultipleChoice</code> は、すべてのモデル入力を平坦化し、パディングを適用して、結果を非平坦化します。",Qs,js,Es,bs,As,ws,ut='トレーニング中にメトリクスを含めると、多くの場合、モデルのパフォーマンスを評価するのに役立ちます。 🤗 <a href="https://huggingface.co/docs/evaluate/index" rel="nofollow">Evaluate</a> ライブラリを使用して、評価メソッドをすばやくロードできます。このタスクでは、<a href="https://huggingface.co/spaces/evaluate-metric/accuracy" rel="nofollow">accuracy</a> メトリクスを読み込みます (🤗 Evaluate <a href="https://huggingface.co/docs/evaluate/a_quick_tour" rel="nofollow">クイック ツアー</a> を参照してください) ) メトリクスの読み込みと計算方法の詳細については、次を参照してください)。',qs,$s,Ls,Ts,dt="次に、予測とラベルを <code>compute</code> に渡して精度を計算する関数を作成します。",Ss,Js,Ps,Us,gt="これで<code>compute_metrics</code>関数の準備が整いました。トレーニングをセットアップするときにこの関数に戻ります。",Ds,_s,Ks,ps,Os,rs,st,ks,tt,Zs,yt="モデルを微調整したので、それを推論に使用できるようになりました。",et,Cs,jt="いくつかのテキストと 2 つの回答候補を考えてください。",lt,Ws,at,is,nt,vs,pt,xs,rt;return $=new Gs({props:{title:"Multiple choice",local:"multiple-choice",headingTag:"h1"}}),x=new Rt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/multiple_choice.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/pytorch/multiple_choice.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/tensorflow/multiple_choice.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/multiple_choice.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/pytorch/multiple_choice.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/tensorflow/multiple_choice.ipynb"}]}}),c=new G({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwZXZhbHVhdGU=",highlighted:"pip install transformers datasets evaluate",wrap:!1}}),N=new G({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),H=new Gs({props:{title:"Load SWAG dataset",local:"load-swag-dataset",headingTag:"h2"}}),Q=new G({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBc3dhZyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJzd2FnJTIyJTJDJTIwJTIycmVndWxhciUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>swag = load_dataset(<span class="hljs-string">&quot;swag&quot;</span>, <span class="hljs-string">&quot;regular&quot;</span>)`,wrap:!1}}),E=new G({props:{code:"c3dhZyU1QiUyMnRyYWluJTIyJTVEJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>swag[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;ending0&#x27;</span>: <span class="hljs-string">&#x27;passes by walking down the street playing their instruments.&#x27;</span>,
 <span class="hljs-string">&#x27;ending1&#x27;</span>: <span class="hljs-string">&#x27;has heard approaching them.&#x27;</span>,
 <span class="hljs-string">&#x27;ending2&#x27;</span>: <span class="hljs-string">&quot;arrives and they&#x27;re outside dancing and asleep.&quot;</span>,
 <span class="hljs-string">&#x27;ending3&#x27;</span>: <span class="hljs-string">&#x27;turns the lead singer watches the performance.&#x27;</span>,
 <span class="hljs-string">&#x27;fold-ind&#x27;</span>: <span class="hljs-string">&#x27;3416&#x27;</span>,
 <span class="hljs-string">&#x27;gold-source&#x27;</span>: <span class="hljs-string">&#x27;gold&#x27;</span>,
 <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;sent1&#x27;</span>: <span class="hljs-string">&#x27;Members of the procession walk down the street holding small horn brass instruments.&#x27;</span>,
 <span class="hljs-string">&#x27;sent2&#x27;</span>: <span class="hljs-string">&#x27;A drum line&#x27;</span>,
 <span class="hljs-string">&#x27;startphrase&#x27;</span>: <span class="hljs-string">&#x27;Members of the procession walk down the street holding small horn brass instruments. A drum line&#x27;</span>,
 <span class="hljs-string">&#x27;video-id&#x27;</span>: <span class="hljs-string">&#x27;anetv_jkn6uvmqwh4&#x27;</span>}`,wrap:!1}}),l=new Gs({props:{title:"Preprocess",local:"preprocess",headingTag:"h2"}}),Ms=new G({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS11bmNhc2VkJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)`,wrap:!1}}),us=new G({props:{code:"ZW5kaW5nX25hbWVzJTIwJTNEJTIwJTVCJTIyZW5kaW5nMCUyMiUyQyUyMCUyMmVuZGluZzElMjIlMkMlMjAlMjJlbmRpbmcyJTIyJTJDJTIwJTIyZW5kaW5nMyUyMiU1RCUwQSUwQSUwQWRlZiUyMHByZXByb2Nlc3NfZnVuY3Rpb24oZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwZmlyc3Rfc2VudGVuY2VzJTIwJTNEJTIwJTVCJTVCY29udGV4dCU1RCUyMColMjA0JTIwZm9yJTIwY29udGV4dCUyMGluJTIwZXhhbXBsZXMlNUIlMjJzZW50MSUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMHF1ZXN0aW9uX2hlYWRlcnMlMjAlM0QlMjBleGFtcGxlcyU1QiUyMnNlbnQyJTIyJTVEJTBBJTIwJTIwJTIwJTIwc2Vjb25kX3NlbnRlbmNlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QmYlMjIlN0JoZWFkZXIlN0QlMjAlN0JleGFtcGxlcyU1QmVuZCU1RCU1QmklNUQlN0QlMjIlMjBmb3IlMjBlbmQlMjBpbiUyMGVuZGluZ19uYW1lcyU1RCUyMGZvciUyMGklMkMlMjBoZWFkZXIlMjBpbiUyMGVudW1lcmF0ZShxdWVzdGlvbl9oZWFkZXJzKSUwQSUyMCUyMCUyMCUyMCU1RCUwQSUwQSUyMCUyMCUyMCUyMGZpcnN0X3NlbnRlbmNlcyUyMCUzRCUyMHN1bShmaXJzdF9zZW50ZW5jZXMlMkMlMjAlNUIlNUQpJTBBJTIwJTIwJTIwJTIwc2Vjb25kX3NlbnRlbmNlcyUyMCUzRCUyMHN1bShzZWNvbmRfc2VudGVuY2VzJTJDJTIwJTVCJTVEKSUwQSUwQSUyMCUyMCUyMCUyMHRva2VuaXplZF9leGFtcGxlcyUyMCUzRCUyMHRva2VuaXplcihmaXJzdF9zZW50ZW5jZXMlMkMlMjBzZWNvbmRfc2VudGVuY2VzJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCayUzQSUyMCU1QnYlNUJpJTIwJTNBJTIwaSUyMCUyQiUyMDQlNUQlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKHYpJTJDJTIwNCklNUQlMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwdG9rZW5pemVkX2V4YW1wbGVzLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>ending_names = [<span class="hljs-string">&quot;ending0&quot;</span>, <span class="hljs-string">&quot;ending1&quot;</span>, <span class="hljs-string">&quot;ending2&quot;</span>, <span class="hljs-string">&quot;ending3&quot;</span>]


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    first_sentences = [[context] * <span class="hljs-number">4</span> <span class="hljs-keyword">for</span> context <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;sent1&quot;</span>]]
<span class="hljs-meta">... </span>    question_headers = examples[<span class="hljs-string">&quot;sent2&quot;</span>]
<span class="hljs-meta">... </span>    second_sentences = [
<span class="hljs-meta">... </span>        [<span class="hljs-string">f&quot;<span class="hljs-subst">{header}</span> <span class="hljs-subst">{examples[end][i]}</span>&quot;</span> <span class="hljs-keyword">for</span> end <span class="hljs-keyword">in</span> ending_names] <span class="hljs-keyword">for</span> i, header <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(question_headers)
<span class="hljs-meta">... </span>    ]

<span class="hljs-meta">... </span>    first_sentences = <span class="hljs-built_in">sum</span>(first_sentences, [])
<span class="hljs-meta">... </span>    second_sentences = <span class="hljs-built_in">sum</span>(second_sentences, [])

<span class="hljs-meta">... </span>    tokenized_examples = tokenizer(first_sentences, second_sentences, truncation=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {k: [v[i : i + <span class="hljs-number">4</span>] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(v), <span class="hljs-number">4</span>)] <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> tokenized_examples.items()}`,wrap:!1}}),gs=new G({props:{code:"dG9rZW5pemVkX3N3YWclMjAlM0QlMjBzd2FnLm1hcChwcmVwcm9jZXNzX2Z1bmN0aW9uJTJDJTIwYmF0Y2hlZCUzRFRydWUp",highlighted:'tokenized_swag = swag.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)',wrap:!1}}),js=new G({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERhdGFDb2xsYXRvckZvck11bHRpcGxlQ2hvaWNlJTBBY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JGb3JNdWx0aXBsZUNob2ljZSh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DataCollatorForMultipleChoice
<span class="hljs-meta">&gt;&gt;&gt; </span>collator = DataCollatorForMultipleChoice(tokenizer=tokenizer)`,wrap:!1}}),bs=new Gs({props:{title:"Evaluate",local:"evaluate",headingTag:"h2"}}),$s=new G({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFhY2N1cmFjeSUyMCUzRCUyMGV2YWx1YXRlLmxvYWQoJTIyYWNjdXJhY3klMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> evaluate

<span class="hljs-meta">&gt;&gt;&gt; </span>accuracy = evaluate.load(<span class="hljs-string">&quot;accuracy&quot;</span>)`,wrap:!1}}),Js=new G({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTBBZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZCklM0ElMEElMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyQyUyMGxhYmVscyUyMCUzRCUyMGV2YWxfcHJlZCUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwbnAuYXJnbWF4KHByZWRpY3Rpb25zJTJDJTIwYXhpcyUzRDEpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYWNjdXJhY3kuY29tcHV0ZShwcmVkaWN0aW9ucyUzRHByZWRpY3Rpb25zJTJDJTIwcmVmZXJlbmNlcyUzRGxhYmVscyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
<span class="hljs-meta">... </span>    predictions, labels = eval_pred
<span class="hljs-meta">... </span>    predictions = np.argmax(predictions, axis=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> accuracy.compute(predictions=predictions, references=labels)`,wrap:!1}}),_s=new Gs({props:{title:"Train",local:"train",headingTag:"h2"}}),ps=new Ut({props:{pytorch:!0,tensorflow:!0,jax:!1,$$slots:{tensorflow:[Ft],pytorch:[Bt]},$$scope:{ctx:V}}}),rs=new mt({props:{$$slots:{default:[Nt]},$$scope:{ctx:V}}}),ks=new Gs({props:{title:"Inference",local:"inference",headingTag:"h1"}}),Ws=new G({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyRnJhbmNlJTIwaGFzJTIwYSUyMGJyZWFkJTIwbGF3JTJDJTIwTGUlMjBEJUMzJUE5Y3JldCUyMFBhaW4lMkMlMjB3aXRoJTIwc3RyaWN0JTIwcnVsZXMlMjBvbiUyMHdoYXQlMjBpcyUyMGFsbG93ZWQlMjBpbiUyMGElMjB0cmFkaXRpb25hbCUyMGJhZ3VldHRlLiUyMiUwQWNhbmRpZGF0ZTElMjAlM0QlMjAlMjJUaGUlMjBsYXclMjBkb2VzJTIwbm90JTIwYXBwbHklMjB0byUyMGNyb2lzc2FudHMlMjBhbmQlMjBicmlvY2hlLiUyMiUwQWNhbmRpZGF0ZTIlMjAlM0QlMjAlMjJUaGUlMjBsYXclMjBhcHBsaWVzJTIwdG8lMjBiYWd1ZXR0ZXMuJTIy",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;France has a bread law, Le Décret Pain, with strict rules on what is allowed in a traditional baguette.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>candidate1 = <span class="hljs-string">&quot;The law does not apply to croissants and brioche.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>candidate2 = <span class="hljs-string">&quot;The law applies to baguettes.&quot;</span>`,wrap:!1}}),is=new Ut({props:{pytorch:!0,tensorflow:!0,jax:!1,$$slots:{tensorflow:[At],pytorch:[Qt]},$$scope:{ctx:V}}}),vs=new xt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ja/tasks/multiple_choice.md"}}),{c(){a=j("meta"),M=i(),n=j("p"),o=i(),h($.$$.fragment),_=i(),h(x.$$.fragment),C=i(),k=j("p"),k.textContent=X,Z=i(),I=j("p"),I.textContent=R,U=i(),W=j("ol"),W.innerHTML=r,J=i(),B=j("p"),B.textContent=F,z=i(),h(c.$$.fragment),v=i(),Y=j("p"),Y.textContent=Xs,ss=i(),h(N.$$.fragment),ts=i(),h(H.$$.fragment),ms=i(),q=j("p"),q.textContent=P,es=i(),h(Q.$$.fragment),cs=i(),L=j("p"),L.textContent=D,ls=i(),h(E.$$.fragment),os=i(),S=j("p"),S.textContent=K,as=i(),A=j("ul"),A.innerHTML=Rs,ns=i(),h(l.$$.fragment),w=i(),O=j("p"),O.textContent=ct,Is=i(),h(Ms.$$.fragment),Bs=i(),hs=j("p"),hs.textContent=ot,Ys=i(),fs=j("ol"),fs.innerHTML=Mt,zs=i(),h(us.$$.fragment),Fs=i(),ds=j("p"),ds.innerHTML=ht,Ns=i(),h(gs.$$.fragment),Hs=i(),ys=j("p"),ys.innerHTML=ft,Qs=i(),h(js.$$.fragment),Es=i(),h(bs.$$.fragment),As=i(),ws=j("p"),ws.innerHTML=ut,qs=i(),h($s.$$.fragment),Ls=i(),Ts=j("p"),Ts.innerHTML=dt,Ss=i(),h(Js.$$.fragment),Ps=i(),Us=j("p"),Us.innerHTML=gt,Ds=i(),h(_s.$$.fragment),Ks=i(),h(ps.$$.fragment),Os=i(),h(rs.$$.fragment),st=i(),h(ks.$$.fragment),tt=i(),Zs=j("p"),Zs.textContent=yt,et=i(),Cs=j("p"),Cs.textContent=jt,lt=i(),h(Ws.$$.fragment),at=i(),h(is.$$.fragment),nt=i(),h(vs.$$.fragment),pt=i(),xs=j("p"),this.h()},l(s){const p=Wt("svelte-u9bgzb",document.head);a=b(p,"META",{name:!0,content:!0}),p.forEach(t),M=m(s),n=b(s,"P",{}),Tt(n).forEach(t),o=m(s),f($.$$.fragment,s),_=m(s),f(x.$$.fragment,s),C=m(s),k=b(s,"P",{"data-svelte-h":!0}),T(k)!=="svelte-eakc5k"&&(k.textContent=X),Z=m(s),I=b(s,"P",{"data-svelte-h":!0}),T(I)!=="svelte-w5jzhi"&&(I.textContent=R),U=m(s),W=b(s,"OL",{"data-svelte-h":!0}),T(W)!=="svelte-2ipb08"&&(W.innerHTML=r),J=m(s),B=b(s,"P",{"data-svelte-h":!0}),T(B)!=="svelte-1lya3k8"&&(B.textContent=F),z=m(s),f(c.$$.fragment,s),v=m(s),Y=b(s,"P",{"data-svelte-h":!0}),T(Y)!=="svelte-193zy02"&&(Y.textContent=Xs),ss=m(s),f(N.$$.fragment,s),ts=m(s),f(H.$$.fragment,s),ms=m(s),q=b(s,"P",{"data-svelte-h":!0}),T(q)!=="svelte-gtxhgw"&&(q.textContent=P),es=m(s),f(Q.$$.fragment,s),cs=m(s),L=b(s,"P",{"data-svelte-h":!0}),T(L)!=="svelte-1r6oj5w"&&(L.textContent=D),ls=m(s),f(E.$$.fragment,s),os=m(s),S=b(s,"P",{"data-svelte-h":!0}),T(S)!=="svelte-1441z1m"&&(S.textContent=K),as=m(s),A=b(s,"UL",{"data-svelte-h":!0}),T(A)!=="svelte-aqbkoq"&&(A.innerHTML=Rs),ns=m(s),f(l.$$.fragment,s),w=m(s),O=b(s,"P",{"data-svelte-h":!0}),T(O)!=="svelte-1onnjgu"&&(O.textContent=ct),Is=m(s),f(Ms.$$.fragment,s),Bs=m(s),hs=b(s,"P",{"data-svelte-h":!0}),T(hs)!=="svelte-pmbrx1"&&(hs.textContent=ot),Ys=m(s),fs=b(s,"OL",{"data-svelte-h":!0}),T(fs)!=="svelte-b8ymrh"&&(fs.innerHTML=Mt),zs=m(s),f(us.$$.fragment,s),Fs=m(s),ds=b(s,"P",{"data-svelte-h":!0}),T(ds)!=="svelte-1rdkxip"&&(ds.innerHTML=ht),Ns=m(s),f(gs.$$.fragment,s),Hs=m(s),ys=b(s,"P",{"data-svelte-h":!0}),T(ys)!=="svelte-1hnscam"&&(ys.innerHTML=ft),Qs=m(s),f(js.$$.fragment,s),Es=m(s),f(bs.$$.fragment,s),As=m(s),ws=b(s,"P",{"data-svelte-h":!0}),T(ws)!=="svelte-629o19"&&(ws.innerHTML=ut),qs=m(s),f($s.$$.fragment,s),Ls=m(s),Ts=b(s,"P",{"data-svelte-h":!0}),T(Ts)!=="svelte-o90xg4"&&(Ts.innerHTML=dt),Ss=m(s),f(Js.$$.fragment,s),Ps=m(s),Us=b(s,"P",{"data-svelte-h":!0}),T(Us)!=="svelte-18cw5xr"&&(Us.innerHTML=gt),Ds=m(s),f(_s.$$.fragment,s),Ks=m(s),f(ps.$$.fragment,s),Os=m(s),f(rs.$$.fragment,s),st=m(s),f(ks.$$.fragment,s),tt=m(s),Zs=b(s,"P",{"data-svelte-h":!0}),T(Zs)!=="svelte-cyrfc8"&&(Zs.textContent=yt),et=m(s),Cs=b(s,"P",{"data-svelte-h":!0}),T(Cs)!=="svelte-l4pjg8"&&(Cs.textContent=jt),lt=m(s),f(Ws.$$.fragment,s),at=m(s),f(is.$$.fragment,s),nt=m(s),f(vs.$$.fragment,s),pt=m(s),xs=b(s,"P",{}),Tt(xs).forEach(t),this.h()},h(){Jt(a,"name","hf:doc:metadata"),Jt(a,"content",Lt)},m(s,p){vt(document.head,a),e(s,M,p),e(s,n,p),e(s,o,p),u($,s,p),e(s,_,p),u(x,s,p),e(s,C,p),e(s,k,p),e(s,Z,p),e(s,I,p),e(s,U,p),e(s,W,p),e(s,J,p),e(s,B,p),e(s,z,p),u(c,s,p),e(s,v,p),e(s,Y,p),e(s,ss,p),u(N,s,p),e(s,ts,p),u(H,s,p),e(s,ms,p),e(s,q,p),e(s,es,p),u(Q,s,p),e(s,cs,p),e(s,L,p),e(s,ls,p),u(E,s,p),e(s,os,p),e(s,S,p),e(s,as,p),e(s,A,p),e(s,ns,p),u(l,s,p),e(s,w,p),e(s,O,p),e(s,Is,p),u(Ms,s,p),e(s,Bs,p),e(s,hs,p),e(s,Ys,p),e(s,fs,p),e(s,zs,p),u(us,s,p),e(s,Fs,p),e(s,ds,p),e(s,Ns,p),u(gs,s,p),e(s,Hs,p),e(s,ys,p),e(s,Qs,p),u(js,s,p),e(s,Es,p),u(bs,s,p),e(s,As,p),e(s,ws,p),e(s,qs,p),u($s,s,p),e(s,Ls,p),e(s,Ts,p),e(s,Ss,p),u(Js,s,p),e(s,Ps,p),e(s,Us,p),e(s,Ds,p),u(_s,s,p),e(s,Ks,p),u(ps,s,p),e(s,Os,p),u(rs,s,p),e(s,st,p),u(ks,s,p),e(s,tt,p),e(s,Zs,p),e(s,et,p),e(s,Cs,p),e(s,lt,p),u(Ws,s,p),e(s,at,p),u(is,s,p),e(s,nt,p),u(vs,s,p),e(s,pt,p),e(s,xs,p),rt=!0},p(s,[p]){const bt={};p&2&&(bt.$$scope={dirty:p,ctx:s}),ps.$set(bt);const wt={};p&2&&(wt.$$scope={dirty:p,ctx:s}),rs.$set(wt);const $t={};p&2&&($t.$$scope={dirty:p,ctx:s}),is.$set($t)},i(s){rt||(d($.$$.fragment,s),d(x.$$.fragment,s),d(c.$$.fragment,s),d(N.$$.fragment,s),d(H.$$.fragment,s),d(Q.$$.fragment,s),d(E.$$.fragment,s),d(l.$$.fragment,s),d(Ms.$$.fragment,s),d(us.$$.fragment,s),d(gs.$$.fragment,s),d(js.$$.fragment,s),d(bs.$$.fragment,s),d($s.$$.fragment,s),d(Js.$$.fragment,s),d(_s.$$.fragment,s),d(ps.$$.fragment,s),d(rs.$$.fragment,s),d(ks.$$.fragment,s),d(Ws.$$.fragment,s),d(is.$$.fragment,s),d(vs.$$.fragment,s),rt=!0)},o(s){g($.$$.fragment,s),g(x.$$.fragment,s),g(c.$$.fragment,s),g(N.$$.fragment,s),g(H.$$.fragment,s),g(Q.$$.fragment,s),g(E.$$.fragment,s),g(l.$$.fragment,s),g(Ms.$$.fragment,s),g(us.$$.fragment,s),g(gs.$$.fragment,s),g(js.$$.fragment,s),g(bs.$$.fragment,s),g($s.$$.fragment,s),g(Js.$$.fragment,s),g(_s.$$.fragment,s),g(ps.$$.fragment,s),g(rs.$$.fragment,s),g(ks.$$.fragment,s),g(Ws.$$.fragment,s),g(is.$$.fragment,s),g(vs.$$.fragment,s),rt=!1},d(s){s&&(t(M),t(n),t(o),t(_),t(C),t(k),t(Z),t(I),t(U),t(W),t(J),t(B),t(z),t(v),t(Y),t(ss),t(ts),t(ms),t(q),t(es),t(cs),t(L),t(ls),t(os),t(S),t(as),t(A),t(ns),t(w),t(O),t(Is),t(Bs),t(hs),t(Ys),t(fs),t(zs),t(Fs),t(ds),t(Ns),t(Hs),t(ys),t(Qs),t(Es),t(As),t(ws),t(qs),t(Ls),t(Ts),t(Ss),t(Ps),t(Us),t(Ds),t(Ks),t(Os),t(st),t(tt),t(Zs),t(et),t(Cs),t(lt),t(at),t(nt),t(pt),t(xs)),t(a),y($,s),y(x,s),y(c,s),y(N,s),y(H,s),y(Q,s),y(E,s),y(l,s),y(Ms,s),y(us,s),y(gs,s),y(js,s),y(bs,s),y($s,s),y(Js,s),y(_s,s),y(ps,s),y(rs,s),y(ks,s),y(Ws,s),y(is,s),y(vs,s)}}}const Lt='{"title":"Multiple choice","local":"multiple-choice","sections":[{"title":"Load SWAG dataset","local":"load-swag-dataset","sections":[],"depth":2},{"title":"Preprocess","local":"preprocess","sections":[],"depth":2},{"title":"Evaluate","local":"evaluate","sections":[],"depth":2},{"title":"Train","local":"train","sections":[],"depth":2}],"depth":1}';function St(V){return kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class le extends Zt{constructor(a){super(),Ct(this,a,St,qt,_t,{})}}export{le as component};
