import{s as ye,n as fe,o as we}from"../chunks/scheduler.bdbef820.js";import{S as Je,i as Te,g as p,s as a,r,A as xe,h as i,f as l,c as n,j as be,u as c,x as m,k as qs,y as Ue,a as e,v as o,d as g,t as h,w as M}from"../chunks/index.33f81d56.js";import{C as j}from"../chunks/CodeBlock.3bad7fc9.js";import{D as $e}from"../chunks/DocNotebookDropdown.339158fb.js";import{H as zs,E as Ce}from"../chunks/index.1b7d14e3.js";function Ze(xl){let d,Ls,Ys,Ss,f,Ps,w,Ds,J,Ul="시각적 질의응답(VQA)은 이미지를 기반으로 개방형 질문에 대응하는 작업입니다. 이 작업을 지원하는 모델의 입력은 대부분 이미지와 질문의 조합이며, 출력은 자연어로 된 답변입니다.",Ks,T,$l="VQA의 주요 사용 사례는 다음과 같습니다:",Os,x,Cl="<li>시각 장애인을 위한 접근성 애플리케이션을 구축할 수 있습니다.</li> <li>교육: 강의나 교과서에 나온 시각 자료에 대한 질문에 답할 수 있습니다. 또한 체험형 전시와 유적 등에서도 VQA를 활용할 수 있습니다.</li> <li>고객 서비스 및 전자상거래: VQA는 사용자가 제품에 대해 질문할 수 있게 함으로써 사용자 경험을 향상시킬 수 있습니다.</li> <li>이미지 검색: VQA 모델을 사용하여 원하는 특성을 가진 이미지를 검색할 수 있습니다. 예를 들어 사용자는 “강아지가 있어?”라고 물어봐서 주어진 이미지 묶음에서 강아지가 있는 모든 이미지를 받아볼 수 있습니다.</li>",st,U,Zl="이 가이드에서 학습할 내용은 다음과 같습니다:",tt,$,_l='<li>VQA 모델 중 하나인 <a href="../../en/model_doc/vilt">ViLT</a>를 <a href="https://huggingface.co/datasets/Graphcore/vqa" rel="nofollow"><code>Graphcore/vqa</code> 데이터셋</a> 에서 미세조정하는 방법</li> <li>미세조정된 ViLT 모델로 추론하는 방법</li> <li>BLIP-2 같은 생성 모델로 제로샷 VQA 추론을 실행하는 방법</li>',lt,C,et,Z,vl=`ViLT는 Vision Transformer (ViT) 내에 텍스트 임베딩을 포함하여 비전/자연어 사전훈련(VLP; Vision-and-Language Pretraining)을 위한 기본 디자인을 제공합니다.
ViLT 모델은 비전 트랜스포머(ViT)에 텍스트 임베딩을 넣어 비전/언어 사전훈련(VLP; Vision-and-Language Pre-training)을 위한 기본적인 디자인을 갖췄습니다. 이 모델은 여러 다운스트림 작업에 사용할 수 있습니다. VQA 태스크에서는 (<code>[CLS]</code> 토큰의 최종 은닉 상태 위에 선형 레이어인) 분류 헤더가 있으며 무작위로 초기화됩니다.
따라서 여기에서 시각적 질의응답은 <strong>분류 문제</strong>로 취급됩니다.`,at,_,Vl="최근의 BLIP, BLIP-2, InstructBLIP와 같은 모델들은 VQA를 생성형 작업으로 간주합니다. 가이드의 후반부에서는 이런 모델들을 사용하여 제로샷 VQA 추론을 하는 방법에 대해 설명하겠습니다.",nt,v,kl="시작하기 전 필요한 모든 라이브러리를 설치했는지 확인하세요.",pt,V,it,k,Gl=`커뮤니티에 모델을 공유하는 것을 권장 드립니다. Hugging Face 계정에 로그인하여 🤗 Hub에 업로드할 수 있습니다.
메시지가 나타나면 로그인할 토큰을 입력하세요:`,mt,G,rt,W,Wl="모델 체크포인트를 전역 변수로 선언하세요.",ct,I,ot,B,gt,X,Il='이 가이드에서는 <code>Graphcore/vqa</code> 데이터세트의 작은 샘플을 사용합니다. 전체 데이터세트는 <a href="https://huggingface.co/datasets/Graphcore/vqa" rel="nofollow">🤗 Hub</a> 에서 확인할 수 있습니다.',ht,Q,Bl=`<a href="https://huggingface.co/datasets/Graphcore/vqa" rel="nofollow"><code>Graphcore/vqa</code> 데이터세트</a> 의 대안으로 공식 <a href="https://visualqa.org/download.html" rel="nofollow">VQA 데이터세트 페이지</a> 에서 동일한 데이터를 수동으로 다운로드할 수 있습니다. 직접 공수한 데이터로 튜토리얼을 따르고 싶다면 <a href="https://huggingface.co/docs/datasets/image_dataset#loading-script" rel="nofollow">이미지 데이터세트 만들기</a> 라는
🤗 Datasets 문서를 참조하세요.`,Mt,R,Xl="검증 데이터의 첫 200개 항목을 불러와 데이터세트의 특성을 확인해 보겠습니다:",jt,H,dt,F,Ql="예제를 하나 뽑아 데이터세트의 특성을 이해해 보겠습니다.",ut,N,bt,E,Rl="데이터세트에는 다음과 같은 특성이 포함되어 있습니다:",yt,z,Hl="<li><code>question</code>: 이미지에 대한 질문</li> <li><code>image_id</code>: 질문과 관련된 이미지의 경로</li> <li><code>label</code>: 데이터의 레이블 (annotations)</li>",ft,Y,Fl="나머지 특성들은 필요하지 않기 때문에 삭제해도 됩니다:",wt,A,Jt,q,Nl="보시다시피 <code>label</code> 특성은 같은 질문마다 답변이 여러 개 있을 수 있습니다. 모두 다른 데이터 라벨러들로부터 수집되었기 때문인데요. 질문의 답변은 주관적일 수 있습니다. 이 경우 질문은 “그는 어디를 보고 있나요?” 였지만, 어떤 사람들은 “아래”로 레이블을 달았고, 다른 사람들은 “테이블” 또는 “스케이트보드” 등으로 주석을 달았습니다.",Tt,L,El="아래의 이미지를 보고 어떤 답변을 선택할 것인지 생각해 보세요:",xt,S,Ut,u,zl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/vqa-example.png" alt="VQA Image Example"/>',$t,P,Yl="질문과 답변의 모호성으로 인해 이러한 데이터세트는 여러 개의 답변이 가능하므로 다중 레이블 분류 문제로 처리됩니다. 게다가, 원핫(one-hot) 인코딩 벡터를 생성하기보다는 레이블에서 특정 답변이 나타나는 횟수를 기반으로 소프트 인코딩을 생성합니다.",Ct,D,Al="위의 예시에서 “아래”라는 답변이 다른 답변보다 훨씬 더 자주 선택되었기 때문에 데이터세트에서 <code>weight</code>라고 불리는 점수로 1.0을 가지며, 나머지 답변들은 1.0 미만의 점수를 가집니다.",Zt,K,ql="적절한 분류 헤더로 모델을 나중에 인스턴스화하기 위해 레이블을 정수로 매핑한 딕셔너리 하나, 반대로 정수를 레이블로 매핑한 딕셔너리 하나 총 2개의 딕셔너리를 생성하세요:",_t,O,vt,ss,Ll="이제 매핑이 완료되었으므로 문자열 답변을 해당 id로 교체하고, 데이터세트의 더 편리한 후처리를 위해 편평화 할 수 있습니다.",Vt,ts,kt,ls,Gt,es,Sl=`다음 단계는 모델을 위해 이미지와 텍스트 데이터를 준비하기 위해 ViLT 프로세서를 가져오는 것입니다.
<code>ViltProcessor</code>는 BERT 토크나이저와 ViLT 이미지 프로세서를 편리하게 하나의 프로세서로 묶습니다:`,Wt,as,It,ns,Pl=`데이터를 전처리하려면 이미지와 질문을 <code>ViltProcessor</code>로 인코딩해야 합니다. 프로세서는 <a href="/docs/transformers/main/ko/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a>로 텍스트를 토크나이즈하고 텍스트 데이터를 위해 <code>input_ids</code>, <code>attention_mask</code> 및 <code>token_type_ids</code>를 생성합니다.
이미지는 <code>ViltImageProcessor</code>로 이미지를 크기 조정하고 정규화하며, <code>pixel_values</code>와 <code>pixel_mask</code>를 생성합니다.`,Bt,ps,Dl="이런 전처리 단계는 모두 내부에서 이루어지므로, <code>processor</code>를 호출하기만 하면 됩니다. 하지만 아직 타겟 레이블이 완성되지 않았습니다. 타겟의 표현에서 각 요소는 가능한 답변(레이블)에 해당합니다. 정확한 답변의 요소는 해당 점수(weight)를 유지시키고 나머지 요소는 0으로 설정해야 합니다.",Xt,is,Kl="아래 함수가 위에서 설명한대로 이미지와 질문에 <code>processor</code>를 적용하고 레이블을 형식에 맞춥니다:",Qt,ms,Rt,rs,Ol="전체 데이터세트에 전처리 함수를 적용하려면 🤗 Datasets의 <code>map</code> 함수를 사용하십시오. <code>batched=True</code>를 설정하여 데이터세트의 여러 요소를 한 번에 처리함으로써 <code>map</code>을 더 빠르게 할 수 있습니다. 이 시점에서 필요하지 않은 열은 제거하세요.",Ht,cs,Ft,os,se='마지막 단계로, <a href="/docs/transformers/main/ko/main_classes/data_collator#transformers.DefaultDataCollator">DefaultDataCollator</a>를 사용하여 예제로 쓸 배치를 생성하세요:',Nt,gs,Et,hs,zt,Ms,te="이제 모델을 훈련하기 위해 준비되었습니다! <code>ViltForQuestionAnswering</code>으로 ViLT를 가져올 차례입니다. 레이블의 수와 레이블 매핑을 지정하세요:",Yt,js,At,ds,le="이 시점에서는 다음 세 단계만 남았습니다:",qt,us,ee='<li><a href="/docs/transformers/main/ko/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>에서 훈련 하이퍼파라미터를 정의하세요:</li>',Lt,bs,St,b,ae='<li>모델, 데이터세트, 프로세서, 데이터 콜레이터와 함께 훈련 인수를 <a href="/docs/transformers/main/ko/main_classes/trainer#transformers.Trainer">Trainer</a>에 전달하세요:</li>',Pt,ys,Dt,y,ne='<li><a href="/docs/transformers/main/ko/main_classes/trainer#transformers.Trainer.train">train()</a>을 호출하여 모델을 미세 조정하세요:</li>',Kt,fs,Ot,ws,pe='훈련이 완료되면, <a href="/docs/transformers/main/ko/main_classes/trainer#transformers.Trainer.push_to_hub">push_to_hub()</a> 메소드를 사용하여 🤗 Hub에 모델을 공유하세요:',sl,Js,tl,Ts,ll,xs,ie="ViLT 모델을 미세 조정하고 🤗 Hub에 업로드했다면 추론에 사용할 수 있습니다. 미세 조정된 모델을 추론에 사용해보는 가장 간단한 방법은 <code>Pipeline</code>에서 사용하는 것입니다.",el,Us,al,$s,me="이 가이드의 모델은 200개의 예제에서만 훈련되었으므로 그다지 많은 것을 기대할 수는 없습니다. 데이터세트의 첫 번째 예제를 사용하여 추론 결과를 설명해보겠습니다:",nl,Cs,pl,Zs,re="비록 확신은 별로 없지만, 모델은 실제로 무언가를 배웠습니다. 더 많은 예제와 더 긴 훈련 기간이 주어진다면 분명 더 나은 결과를 얻을 수 있을 것입니다!",il,_s,ce="원한다면 파이프라인의 결과를 수동으로 복제할 수도 있습니다:",ml,vs,oe="<li>이미지와 질문을 가져와서 프로세서를 사용하여 모델에 준비합니다.</li> <li>전처리된 결과를 모델에 전달합니다.</li> <li>로짓에서 가장 가능성 있는 답변의 id를 가져와서 <code>id2label</code>에서 실제 답변을 찾습니다.</li>",rl,Vs,cl,ks,ol,Gs,ge=`이전 모델은 VQA를 분류 문제로 처리했습니다. BLIP, BLIP-2 및 InstructBLIP와 같은 최근의 모델은 VQA를 생성 작업으로 접근합니다. <a href="../../en/model_doc/blip-2">BLIP-2</a>를 예로 들어 보겠습니다. 이 모델은 사전훈련된 비전 인코더와 LLM의 모든 조합을 사용할 수 있는 새로운 비전-자연어 사전 학습 패러다임을 도입했습니다. (<a href="https://huggingface.co/blog/blip-2" rel="nofollow">BLIP-2 블로그 포스트</a>를 통해 더 자세히 알아볼 수 있어요)
이를 통해 시각적 질의응답을 포함한 여러 비전-자연어 작업에서 SOTA를 달성할 수 있었습니다.`,gl,Ws,he='이 모델을 어떻게 VQA에 사용할 수 있는지 설명해 보겠습니다. 먼저 모델을 가져와 보겠습니다. 여기서 GPU가 사용 가능한 경우 모델을 명시적으로 GPU로 전송할 것입니다. 이전에는 훈련할 때 쓰지 않은 이유는 <a href="/docs/transformers/main/ko/main_classes/trainer#transformers.Trainer">Trainer</a>가 이 부분을 자동으로 처리하기 때문입니다:',hl,Is,Ml,Bs,Me="모델은 이미지와 텍스트를 입력으로 받으므로, VQA 데이터세트의 첫 번째 예제에서와 동일한 이미지/질문 쌍을 사용해 보겠습니다:",jl,Xs,dl,Qs,je="BLIP-2를 시각적 질의응답 작업에 사용하려면 텍스트 프롬프트가 <code>Question: {} Answer:</code> 형식을 따라야 합니다.",ul,Rs,bl,Hs,de="이제 모델의 프로세서로 이미지/프롬프트를 전처리하고, 처리된 입력을 모델을 통해 전달하고, 출력을 디코드해야 합니다:",yl,Fs,fl,Ns,ue="보시다시피 모델은 군중을 인식하고, 얼굴의 방향(아래쪽을 보고 있음)을 인식했지만, 군중이 스케이터 뒤에 있다는 사실을 놓쳤습니다. 그러나 사람이 직접 라벨링한 데이터셋을 얻을 수 없는 경우에, 이 접근법은 빠르게 유용한 결과를 생성할 수 있습니다.",wl,Es,Jl,As,Tl;return f=new zs({props:{title:"시각적 질의응답 (Visual Question Answering)",local:"시각적-질의응답-visual-question-answering",headingTag:"h1"}}),w=new $e({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/visual_question_answering.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/visual_question_answering.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/visual_question_answering.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/visual_question_answering.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/visual_question_answering.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/visual_question_answering.ipynb"}]}}),C=new zs({props:{title:"ViLT 미세 조정",local:"finetuning-vilt",headingTag:"h2"}}),V=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJzJTIwZGF0YXNldHM=",highlighted:"pip install -q transformers datasets",wrap:!1}}),G=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),I=new j({props:{code:"bW9kZWxfY2hlY2twb2ludCUyMCUzRCUyMCUyMmRhbmRlbGluJTJGdmlsdC1iMzItbWxtJTIy",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model_checkpoint = <span class="hljs-string">&quot;dandelin/vilt-b32-mlm&quot;</span>',wrap:!1}}),B=new zs({props:{title:"데이터 가져오기",local:"load-the-data",headingTag:"h2"}}),H=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJHcmFwaGNvcmUlMkZ2cWElMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lNUIlM0EyMDAlNUQlMjIpJTBBZGF0YXNldA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;Graphcore/vqa&quot;</span>, split=<span class="hljs-string">&quot;validation[:200]&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
    features: [<span class="hljs-string">&#x27;question&#x27;</span>, <span class="hljs-string">&#x27;question_type&#x27;</span>, <span class="hljs-string">&#x27;question_id&#x27;</span>, <span class="hljs-string">&#x27;image_id&#x27;</span>, <span class="hljs-string">&#x27;answer_type&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
    num_rows: <span class="hljs-number">200</span>
})`,wrap:!1}}),N=new j({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;question&#x27;</span>: <span class="hljs-string">&#x27;Where is he looking?&#x27;</span>,
 <span class="hljs-string">&#x27;question_type&#x27;</span>: <span class="hljs-string">&#x27;none of the above&#x27;</span>,
 <span class="hljs-string">&#x27;question_id&#x27;</span>: <span class="hljs-number">262148000</span>,
 <span class="hljs-string">&#x27;image_id&#x27;</span>: <span class="hljs-string">&#x27;/root/.cache/huggingface/datasets/downloads/extracted/ca733e0e000fb2d7a09fbcc94dbfe7b5a30750681d0e965f8e0a23b1c2f98c75/val2014/COCO_val2014_000000262148.jpg&#x27;</span>,
 <span class="hljs-string">&#x27;answer_type&#x27;</span>: <span class="hljs-string">&#x27;other&#x27;</span>,
 <span class="hljs-string">&#x27;label&#x27;</span>: {<span class="hljs-string">&#x27;ids&#x27;</span>: [<span class="hljs-string">&#x27;at table&#x27;</span>, <span class="hljs-string">&#x27;down&#x27;</span>, <span class="hljs-string">&#x27;skateboard&#x27;</span>, <span class="hljs-string">&#x27;table&#x27;</span>],
  <span class="hljs-string">&#x27;weights&#x27;</span>: [<span class="hljs-number">0.30000001192092896</span>,
   <span class="hljs-number">1.0</span>,
   <span class="hljs-number">0.30000001192092896</span>,
   <span class="hljs-number">0.30000001192092896</span>]}}`,wrap:!1}}),A=new j({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQucmVtb3ZlX2NvbHVtbnMoJTVCJ3F1ZXN0aW9uX3R5cGUnJTJDJTIwJ3F1ZXN0aW9uX2lkJyUyQyUyMCdhbnN3ZXJfdHlwZSclNUQp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.remove_columns([<span class="hljs-string">&#x27;question_type&#x27;</span>, <span class="hljs-string">&#x27;question_id&#x27;</span>, <span class="hljs-string">&#x27;answer_type&#x27;</span>])',wrap:!1}}),S=new j({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKGRhdGFzZXQlNUIwJTVEJTVCJ2ltYWdlX2lkJyU1RCklMEFpbWFnZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;image_id&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),O=new j({props:{code:"aW1wb3J0JTIwaXRlcnRvb2xzJTBBJTBBbGFiZWxzJTIwJTNEJTIwJTVCaXRlbSU1QidpZHMnJTVEJTIwZm9yJTIwaXRlbSUyMGluJTIwZGF0YXNldCU1QidsYWJlbCclNUQlNUQlMEFmbGF0dGVuZWRfbGFiZWxzJTIwJTNEJTIwbGlzdChpdGVydG9vbHMuY2hhaW4oKmxhYmVscykpJTBBdW5pcXVlX2xhYmVscyUyMCUzRCUyMGxpc3Qoc2V0KGZsYXR0ZW5lZF9sYWJlbHMpKSUwQSUwQWxhYmVsMmlkJTIwJTNEJTIwJTdCbGFiZWwlM0ElMjBpZHglMjBmb3IlMjBpZHglMkMlMjBsYWJlbCUyMGluJTIwZW51bWVyYXRlKHVuaXF1ZV9sYWJlbHMpJTdEJTBBaWQybGFiZWwlMjAlM0QlMjAlN0JpZHglM0ElMjBsYWJlbCUyMGZvciUyMGxhYmVsJTJDJTIwaWR4JTIwaW4lMjBsYWJlbDJpZC5pdGVtcygpJTdE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> itertools

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [item[<span class="hljs-string">&#x27;ids&#x27;</span>] <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> dataset[<span class="hljs-string">&#x27;label&#x27;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>flattened_labels = <span class="hljs-built_in">list</span>(itertools.chain(*labels))
<span class="hljs-meta">&gt;&gt;&gt; </span>unique_labels = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(flattened_labels))

<span class="hljs-meta">&gt;&gt;&gt; </span>label2id = {label: idx <span class="hljs-keyword">for</span> idx, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(unique_labels)}
<span class="hljs-meta">&gt;&gt;&gt; </span>id2label = {idx: label <span class="hljs-keyword">for</span> label, idx <span class="hljs-keyword">in</span> label2id.items()}`,wrap:!1}}),ts=new j({props:{code:"ZGVmJTIwcmVwbGFjZV9pZHMoaW5wdXRzKSUzQSUwQSUyMCUyMGlucHV0cyU1QiUyMmxhYmVsJTIyJTVEJTVCJTIyaWRzJTIyJTVEJTIwJTNEJTIwJTVCbGFiZWwyaWQlNUJ4JTVEJTIwZm9yJTIweCUyMGluJTIwaW5wdXRzJTVCJTIybGFiZWwlMjIlNUQlNUIlMjJpZHMlMjIlNUQlNUQlMEElMjAlMjByZXR1cm4lMjBpbnB1dHMlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAocmVwbGFjZV9pZHMpJTBBZmxhdF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5mbGF0dGVuKCklMEFmbGF0X2RhdGFzZXQuZmVhdHVyZXM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">replace_ids</span>(<span class="hljs-params">inputs</span>):
<span class="hljs-meta">... </span>  inputs[<span class="hljs-string">&quot;label&quot;</span>][<span class="hljs-string">&quot;ids&quot;</span>] = [label2id[x] <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> inputs[<span class="hljs-string">&quot;label&quot;</span>][<span class="hljs-string">&quot;ids&quot;</span>]]
<span class="hljs-meta">... </span>  <span class="hljs-keyword">return</span> inputs


<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">map</span>(replace_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>flat_dataset = dataset.flatten()
<span class="hljs-meta">&gt;&gt;&gt; </span>flat_dataset.features
{<span class="hljs-string">&#x27;question&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;image_id&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;label.ids&#x27;</span>: <span class="hljs-type">Sequence</span>(feature=Value(dtype=<span class="hljs-string">&#x27;int64&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;label.weights&#x27;</span>: <span class="hljs-type">Sequence</span>(feature=Value(dtype=<span class="hljs-string">&#x27;float64&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}`,wrap:!1}}),ls=new zs({props:{title:"데이터 전처리",local:"preprocessing-data",headingTag:"h2"}}),as=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpbHRQcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBWaWx0UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChtb2RlbF9jaGVja3BvaW50KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ViltProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = ViltProcessor.from_pretrained(model_checkpoint)`,wrap:!1}}),ms=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZWYlMjBwcmVwcm9jZXNzX2RhdGEoZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2VfcGF0aHMlMjAlM0QlMjBleGFtcGxlcyU1QidpbWFnZV9pZCclNUQlMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjAlNUJJbWFnZS5vcGVuKGltYWdlX3BhdGgpJTIwZm9yJTIwaW1hZ2VfcGF0aCUyMGluJTIwaW1hZ2VfcGF0aHMlNUQlMEElMjAlMjAlMjAlMjB0ZXh0cyUyMCUzRCUyMGV4YW1wbGVzJTVCJ3F1ZXN0aW9uJyU1RCUwQSUwQSUyMCUyMCUyMCUyMGVuY29kaW5nJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUyQyUyMHRleHRzJTJDJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIwJTIwJTIwJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGVuY29kaW5nLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbmNvZGluZyU1QmslNUQlMjAlM0QlMjB2LnNxdWVlemUoKSUwQSUwQSUyMCUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjAlNUIlNUQlMEElMEElMjAlMjAlMjAlMjBmb3IlMjBsYWJlbHMlMkMlMjBzY29yZXMlMjBpbiUyMHppcChleGFtcGxlcyU1QidsYWJlbC5pZHMnJTVEJTJDJTIwZXhhbXBsZXMlNUInbGFiZWwud2VpZ2h0cyclNUQpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGFyZ2V0JTIwJTNEJTIwdG9yY2guemVyb3MobGVuKGlkMmxhYmVsKSklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBsYWJlbCUyQyUyMHNjb3JlJTIwaW4lMjB6aXAobGFiZWxzJTJDJTIwc2NvcmVzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhcmdldCU1QmxhYmVsJTVEJTIwJTNEJTIwc2NvcmUlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0YXJnZXRzLmFwcGVuZCh0YXJnZXQpJTBBJTBBJTIwJTIwJTIwJTIwZW5jb2RpbmclNUIlMjJsYWJlbHMlMjIlNUQlMjAlM0QlMjB0YXJnZXRzJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZW5jb2Rpbmc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_data</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    image_paths = examples[<span class="hljs-string">&#x27;image_id&#x27;</span>]
<span class="hljs-meta">... </span>    images = [Image.<span class="hljs-built_in">open</span>(image_path) <span class="hljs-keyword">for</span> image_path <span class="hljs-keyword">in</span> image_paths]
<span class="hljs-meta">... </span>    texts = examples[<span class="hljs-string">&#x27;question&#x27;</span>]

<span class="hljs-meta">... </span>    encoding = processor(images, texts, padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> encoding.items():
<span class="hljs-meta">... </span>          encoding[k] = v.squeeze()

<span class="hljs-meta">... </span>    targets = []

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> labels, scores <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(examples[<span class="hljs-string">&#x27;label.ids&#x27;</span>], examples[<span class="hljs-string">&#x27;label.weights&#x27;</span>]):
<span class="hljs-meta">... </span>        target = torch.zeros(<span class="hljs-built_in">len</span>(id2label))

<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> label, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(labels, scores):
<span class="hljs-meta">... </span>            target[label] = score

<span class="hljs-meta">... </span>        targets.append(target)

<span class="hljs-meta">... </span>    encoding[<span class="hljs-string">&quot;labels&quot;</span>] = targets

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> encoding`,wrap:!1}}),cs=new j({props:{code:"cHJvY2Vzc2VkX2RhdGFzZXQlMjAlM0QlMjBmbGF0X2RhdGFzZXQubWFwKHByZXByb2Nlc3NfZGF0YSUyQyUyMGJhdGNoZWQlM0RUcnVlJTJDJTIwcmVtb3ZlX2NvbHVtbnMlM0QlNUIncXVlc3Rpb24nJTJDJ3F1ZXN0aW9uX3R5cGUnJTJDJTIwJTIwJ3F1ZXN0aW9uX2lkJyUyQyUyMCdpbWFnZV9pZCclMkMlMjAnYW5zd2VyX3R5cGUnJTJDJTIwJ2xhYmVsLmlkcyclMkMlMjAnbGFiZWwud2VpZ2h0cyclNUQpJTBBcHJvY2Vzc2VkX2RhdGFzZXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>processed_dataset = flat_dataset.<span class="hljs-built_in">map</span>(preprocess_data, batched=<span class="hljs-literal">True</span>, remove_columns=[<span class="hljs-string">&#x27;question&#x27;</span>,<span class="hljs-string">&#x27;question_type&#x27;</span>,  <span class="hljs-string">&#x27;question_id&#x27;</span>, <span class="hljs-string">&#x27;image_id&#x27;</span>, <span class="hljs-string">&#x27;answer_type&#x27;</span>, <span class="hljs-string">&#x27;label.ids&#x27;</span>, <span class="hljs-string">&#x27;label.weights&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>processed_dataset
Dataset({
    features: [<span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;token_type_ids&#x27;</span>, <span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;pixel_values&#x27;</span>, <span class="hljs-string">&#x27;pixel_mask&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>],
    num_rows: <span class="hljs-number">200</span>
})`,wrap:!1}}),gs=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlZmF1bHREYXRhQ29sbGF0b3IlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGVmYXVsdERhdGFDb2xsYXRvcigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DefaultDataCollator

<span class="hljs-meta">&gt;&gt;&gt; </span>data_collator = DefaultDataCollator()`,wrap:!1}}),hs=new zs({props:{title:"모델 훈련",local:"train-the-model",headingTag:"h2"}}),js=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpbHRGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQW1vZGVsJTIwJTNEJTIwVmlsdEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZChtb2RlbF9jaGVja3BvaW50JTJDJTIwbnVtX2xhYmVscyUzRGxlbihpZDJsYWJlbCklMkMlMjBpZDJsYWJlbCUzRGlkMmxhYmVsJTJDJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ViltForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ViltForQuestionAnswering.from_pretrained(model_checkpoint, num_labels=<span class="hljs-built_in">len</span>(id2label), id2label=id2label, label2id=label2id)`,wrap:!1}}),bs=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMk1hcmlhSyUyRnZpbHRfZmluZXR1bmVkXzIwMCUyMiUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyglMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMEElMjAlMjAlMjAlMjBudW1fdHJhaW5fZXBvY2hzJTNEMjAlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0ZXBzJTNEMjAwJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDVlLTUlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3RvdGFsX2xpbWl0JTNEMiUyQyUwQSUyMCUyMCUyMCUyMHJlbW92ZV91bnVzZWRfY29sdW1ucyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;MariaK/vilt_finetuned_200&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(
<span class="hljs-meta">... </span>    output_dir=repo_id,
<span class="hljs-meta">... </span>    per_device_train_batch_size=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_train_epochs=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    save_steps=<span class="hljs-number">200</span>,
<span class="hljs-meta">... </span>    logging_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">5e-5</span>,
<span class="hljs-meta">... </span>    save_total_limit=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    remove_unused_columns=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),ys=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEZGF0YV9jb2xsYXRvciUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0Rwcm9jZXNzZWRfZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMHByb2Nlc3NpbmdfY2xhc3MlM0Rwcm9jZXNzb3IlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    data_collator=data_collator,
<span class="hljs-meta">... </span>    train_dataset=processed_dataset,
<span class="hljs-meta">... </span>    processing_class=processor,
<span class="hljs-meta">... </span>)`,wrap:!1}}),fs=new j({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()',wrap:!1}}),Js=new j({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()',wrap:!1}}),Ts=new zs({props:{title:"추론",local:"inference",headingTag:"h2"}}),Us=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnZpc3VhbC1xdWVzdGlvbi1hbnN3ZXJpbmclMjIlMkMlMjBtb2RlbCUzRCUyMk1hcmlhSyUyRnZpbHRfZmluZXR1bmVkXzIwMCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;visual-question-answering&quot;</span>, model=<span class="hljs-string">&quot;MariaK/vilt_finetuned_200&quot;</span>)`,wrap:!1}}),Cs=new j({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIwJTVEJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKGV4YW1wbGUlNUInaW1hZ2VfaWQnJTVEKSUwQXF1ZXN0aW9uJTIwJTNEJTIwZXhhbXBsZSU1QidxdWVzdGlvbiclNUQlMEFwcmludChxdWVzdGlvbiklMEFwaXBlKGltYWdlJTJDJTIwcXVlc3Rpb24lMkMlMjB0b3BfayUzRDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>example = dataset[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(example[<span class="hljs-string">&#x27;image_id&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>question = example[<span class="hljs-string">&#x27;question&#x27;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(question)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(image, question, top_k=<span class="hljs-number">1</span>)
<span class="hljs-string">&quot;Where is he looking?&quot;</span>
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.5498199462890625</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;down&#x27;</span>}]`,wrap:!1}}),Vs=new j({props:{code:"cHJvY2Vzc29yJTIwJTNEJTIwVmlsdFByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyTWFyaWFLJTJGdmlsdF9maW5ldHVuZWRfMjAwJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihleGFtcGxlJTVCJ2ltYWdlX2lkJyU1RCklMEFxdWVzdGlvbiUyMCUzRCUyMGV4YW1wbGUlNUIncXVlc3Rpb24nJTVEJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGlucHV0cyUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZSUyQyUyMHF1ZXN0aW9uJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFtb2RlbCUyMCUzRCUyMFZpbHRGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyTWFyaWFLJTJGdmlsdF9maW5ldHVuZWRfMjAwJTIyKSUwQSUwQSUyMyUyMGZvcndhcmQlMjBwYXNzJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWlkeCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KCUyMlByZWRpY3RlZCUyMGFuc3dlciUzQSUyMiUyQyUyMG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QmlkeCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>processor = ViltProcessor.from_pretrained(<span class="hljs-string">&quot;MariaK/vilt_finetuned_200&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(example[<span class="hljs-string">&#x27;image_id&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>question = example[<span class="hljs-string">&#x27;question&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, question, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ViltForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;MariaK/vilt_finetuned_200&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span>idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted answer:&quot;</span>, model.config.id2label[idx])
Predicted answer: down`,wrap:!1}}),ks=new zs({props:{title:"제로샷 VQA",local:"zeroshot-vqa",headingTag:"h2"}}),Is=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBCbGlwMkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyU2FsZXNmb3JjZSUyRmJsaXAyLW9wdC0yLjdiJTIyKSUwQW1vZGVsJTIwJTNEJTIwQmxpcDJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMlNhbGVzZm9yY2UlMkZibGlwMi1vcHQtMi43YiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCUyMmNwdSUyMiUwQW1vZGVsLnRvKGRldmljZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Blip2ForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Salesforce/blip2-opt-2.7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Blip2ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;Salesforce/blip2-opt-2.7b&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)`,wrap:!1}}),Xs=new j({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIwJTVEJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKGV4YW1wbGUlNUInaW1hZ2VfaWQnJTVEKSUwQXF1ZXN0aW9uJTIwJTNEJTIwZXhhbXBsZSU1QidxdWVzdGlvbiclNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>example = dataset[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(example[<span class="hljs-string">&#x27;image_id&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>question = example[<span class="hljs-string">&#x27;question&#x27;</span>]`,wrap:!1}}),Rs=new j({props:{code:"cHJvbXB0JTIwJTNEJTIwZiUyMlF1ZXN0aW9uJTNBJTIwJTdCcXVlc3Rpb24lN0QlMjBBbnN3ZXIlM0ElMjI=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">f&quot;Question: <span class="hljs-subst">{question}</span> Answer:&quot;</span>',wrap:!1}}),Fs=new j({props:{code:"aW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlJTJDJTIwdGV4dCUzRHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKGRldmljZSUyQyUyMHRvcmNoLmZsb2F0MTYpJTBBJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCklMEFnZW5lcmF0ZWRfdGV4dCUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQuc3RyaXAoKSUwQXByaW50KGdlbmVyYXRlZF90ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, text=prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device, torch.float16)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>].strip()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text)
<span class="hljs-string">&quot;He is looking at the crowd&quot;</span>`,wrap:!1}}),Es=new Ce({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ko/tasks/visual_question_answering.md"}}),{c(){d=p("meta"),Ls=a(),Ys=p("p"),Ss=a(),r(f.$$.fragment),Ps=a(),r(w.$$.fragment),Ds=a(),J=p("p"),J.textContent=Ul,Ks=a(),T=p("p"),T.textContent=$l,Os=a(),x=p("ul"),x.innerHTML=Cl,st=a(),U=p("p"),U.textContent=Zl,tt=a(),$=p("ul"),$.innerHTML=_l,lt=a(),r(C.$$.fragment),et=a(),Z=p("p"),Z.innerHTML=vl,at=a(),_=p("p"),_.textContent=Vl,nt=a(),v=p("p"),v.textContent=kl,pt=a(),r(V.$$.fragment),it=a(),k=p("p"),k.textContent=Gl,mt=a(),r(G.$$.fragment),rt=a(),W=p("p"),W.textContent=Wl,ct=a(),r(I.$$.fragment),ot=a(),r(B.$$.fragment),gt=a(),X=p("p"),X.innerHTML=Il,ht=a(),Q=p("p"),Q.innerHTML=Bl,Mt=a(),R=p("p"),R.textContent=Xl,jt=a(),r(H.$$.fragment),dt=a(),F=p("p"),F.textContent=Ql,ut=a(),r(N.$$.fragment),bt=a(),E=p("p"),E.textContent=Rl,yt=a(),z=p("ul"),z.innerHTML=Hl,ft=a(),Y=p("p"),Y.textContent=Fl,wt=a(),r(A.$$.fragment),Jt=a(),q=p("p"),q.innerHTML=Nl,Tt=a(),L=p("p"),L.textContent=El,xt=a(),r(S.$$.fragment),Ut=a(),u=p("div"),u.innerHTML=zl,$t=a(),P=p("p"),P.textContent=Yl,Ct=a(),D=p("p"),D.innerHTML=Al,Zt=a(),K=p("p"),K.textContent=ql,_t=a(),r(O.$$.fragment),vt=a(),ss=p("p"),ss.textContent=Ll,Vt=a(),r(ts.$$.fragment),kt=a(),r(ls.$$.fragment),Gt=a(),es=p("p"),es.innerHTML=Sl,Wt=a(),r(as.$$.fragment),It=a(),ns=p("p"),ns.innerHTML=Pl,Bt=a(),ps=p("p"),ps.innerHTML=Dl,Xt=a(),is=p("p"),is.innerHTML=Kl,Qt=a(),r(ms.$$.fragment),Rt=a(),rs=p("p"),rs.innerHTML=Ol,Ht=a(),r(cs.$$.fragment),Ft=a(),os=p("p"),os.innerHTML=se,Nt=a(),r(gs.$$.fragment),Et=a(),r(hs.$$.fragment),zt=a(),Ms=p("p"),Ms.innerHTML=te,Yt=a(),r(js.$$.fragment),At=a(),ds=p("p"),ds.textContent=le,qt=a(),us=p("ol"),us.innerHTML=ee,Lt=a(),r(bs.$$.fragment),St=a(),b=p("ol"),b.innerHTML=ae,Pt=a(),r(ys.$$.fragment),Dt=a(),y=p("ol"),y.innerHTML=ne,Kt=a(),r(fs.$$.fragment),Ot=a(),ws=p("p"),ws.innerHTML=pe,sl=a(),r(Js.$$.fragment),tl=a(),r(Ts.$$.fragment),ll=a(),xs=p("p"),xs.innerHTML=ie,el=a(),r(Us.$$.fragment),al=a(),$s=p("p"),$s.textContent=me,nl=a(),r(Cs.$$.fragment),pl=a(),Zs=p("p"),Zs.textContent=re,il=a(),_s=p("p"),_s.textContent=ce,ml=a(),vs=p("ol"),vs.innerHTML=oe,rl=a(),r(Vs.$$.fragment),cl=a(),r(ks.$$.fragment),ol=a(),Gs=p("p"),Gs.innerHTML=ge,gl=a(),Ws=p("p"),Ws.innerHTML=he,hl=a(),r(Is.$$.fragment),Ml=a(),Bs=p("p"),Bs.textContent=Me,jl=a(),r(Xs.$$.fragment),dl=a(),Qs=p("p"),Qs.innerHTML=je,ul=a(),r(Rs.$$.fragment),bl=a(),Hs=p("p"),Hs.textContent=de,yl=a(),r(Fs.$$.fragment),fl=a(),Ns=p("p"),Ns.textContent=ue,wl=a(),r(Es.$$.fragment),Jl=a(),As=p("p"),this.h()},l(s){const t=xe("svelte-u9bgzb",document.head);d=i(t,"META",{name:!0,content:!0}),t.forEach(l),Ls=n(s),Ys=i(s,"P",{}),be(Ys).forEach(l),Ss=n(s),c(f.$$.fragment,s),Ps=n(s),c(w.$$.fragment,s),Ds=n(s),J=i(s,"P",{"data-svelte-h":!0}),m(J)!=="svelte-lsf3d3"&&(J.textContent=Ul),Ks=n(s),T=i(s,"P",{"data-svelte-h":!0}),m(T)!=="svelte-1m5x0xt"&&(T.textContent=$l),Os=n(s),x=i(s,"UL",{"data-svelte-h":!0}),m(x)!=="svelte-19c3jz6"&&(x.innerHTML=Cl),st=n(s),U=i(s,"P",{"data-svelte-h":!0}),m(U)!=="svelte-27ww4z"&&(U.textContent=Zl),tt=n(s),$=i(s,"UL",{"data-svelte-h":!0}),m($)!=="svelte-4zovkh"&&($.innerHTML=_l),lt=n(s),c(C.$$.fragment,s),et=n(s),Z=i(s,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-l5s5vs"&&(Z.innerHTML=vl),at=n(s),_=i(s,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1gnol8d"&&(_.textContent=Vl),nt=n(s),v=i(s,"P",{"data-svelte-h":!0}),m(v)!=="svelte-16n8ks6"&&(v.textContent=kl),pt=n(s),c(V.$$.fragment,s),it=n(s),k=i(s,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1tfz9ll"&&(k.textContent=Gl),mt=n(s),c(G.$$.fragment,s),rt=n(s),W=i(s,"P",{"data-svelte-h":!0}),m(W)!=="svelte-8hbytf"&&(W.textContent=Wl),ct=n(s),c(I.$$.fragment,s),ot=n(s),c(B.$$.fragment,s),gt=n(s),X=i(s,"P",{"data-svelte-h":!0}),m(X)!=="svelte-ogma3f"&&(X.innerHTML=Il),ht=n(s),Q=i(s,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1yqcape"&&(Q.innerHTML=Bl),Mt=n(s),R=i(s,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1e6q69w"&&(R.textContent=Xl),jt=n(s),c(H.$$.fragment,s),dt=n(s),F=i(s,"P",{"data-svelte-h":!0}),m(F)!=="svelte-k3mzt8"&&(F.textContent=Ql),ut=n(s),c(N.$$.fragment,s),bt=n(s),E=i(s,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1vwvj02"&&(E.textContent=Rl),yt=n(s),z=i(s,"UL",{"data-svelte-h":!0}),m(z)!=="svelte-1bz53k7"&&(z.innerHTML=Hl),ft=n(s),Y=i(s,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-1hynqfk"&&(Y.textContent=Fl),wt=n(s),c(A.$$.fragment,s),Jt=n(s),q=i(s,"P",{"data-svelte-h":!0}),m(q)!=="svelte-6vh6f7"&&(q.innerHTML=Nl),Tt=n(s),L=i(s,"P",{"data-svelte-h":!0}),m(L)!=="svelte-1o0kwl9"&&(L.textContent=El),xt=n(s),c(S.$$.fragment,s),Ut=n(s),u=i(s,"DIV",{class:!0,"data-svelte-h":!0}),m(u)!=="svelte-1tjg4st"&&(u.innerHTML=zl),$t=n(s),P=i(s,"P",{"data-svelte-h":!0}),m(P)!=="svelte-bmlc3i"&&(P.textContent=Yl),Ct=n(s),D=i(s,"P",{"data-svelte-h":!0}),m(D)!=="svelte-1isdfaj"&&(D.innerHTML=Al),Zt=n(s),K=i(s,"P",{"data-svelte-h":!0}),m(K)!=="svelte-1hwga8k"&&(K.textContent=ql),_t=n(s),c(O.$$.fragment,s),vt=n(s),ss=i(s,"P",{"data-svelte-h":!0}),m(ss)!=="svelte-1f1gsw8"&&(ss.textContent=Ll),Vt=n(s),c(ts.$$.fragment,s),kt=n(s),c(ls.$$.fragment,s),Gt=n(s),es=i(s,"P",{"data-svelte-h":!0}),m(es)!=="svelte-u0lfur"&&(es.innerHTML=Sl),Wt=n(s),c(as.$$.fragment,s),It=n(s),ns=i(s,"P",{"data-svelte-h":!0}),m(ns)!=="svelte-1rkig1n"&&(ns.innerHTML=Pl),Bt=n(s),ps=i(s,"P",{"data-svelte-h":!0}),m(ps)!=="svelte-8a14gg"&&(ps.innerHTML=Dl),Xt=n(s),is=i(s,"P",{"data-svelte-h":!0}),m(is)!=="svelte-x4dc7"&&(is.innerHTML=Kl),Qt=n(s),c(ms.$$.fragment,s),Rt=n(s),rs=i(s,"P",{"data-svelte-h":!0}),m(rs)!=="svelte-y8sr6z"&&(rs.innerHTML=Ol),Ht=n(s),c(cs.$$.fragment,s),Ft=n(s),os=i(s,"P",{"data-svelte-h":!0}),m(os)!=="svelte-1tsno8f"&&(os.innerHTML=se),Nt=n(s),c(gs.$$.fragment,s),Et=n(s),c(hs.$$.fragment,s),zt=n(s),Ms=i(s,"P",{"data-svelte-h":!0}),m(Ms)!=="svelte-117iw8t"&&(Ms.innerHTML=te),Yt=n(s),c(js.$$.fragment,s),At=n(s),ds=i(s,"P",{"data-svelte-h":!0}),m(ds)!=="svelte-ahfk2n"&&(ds.textContent=le),qt=n(s),us=i(s,"OL",{"data-svelte-h":!0}),m(us)!=="svelte-1j1t9wj"&&(us.innerHTML=ee),Lt=n(s),c(bs.$$.fragment,s),St=n(s),b=i(s,"OL",{start:!0,"data-svelte-h":!0}),m(b)!=="svelte-1emhm53"&&(b.innerHTML=ae),Pt=n(s),c(ys.$$.fragment,s),Dt=n(s),y=i(s,"OL",{start:!0,"data-svelte-h":!0}),m(y)!=="svelte-881axr"&&(y.innerHTML=ne),Kt=n(s),c(fs.$$.fragment,s),Ot=n(s),ws=i(s,"P",{"data-svelte-h":!0}),m(ws)!=="svelte-1b3g1ef"&&(ws.innerHTML=pe),sl=n(s),c(Js.$$.fragment,s),tl=n(s),c(Ts.$$.fragment,s),ll=n(s),xs=i(s,"P",{"data-svelte-h":!0}),m(xs)!=="svelte-1uxaimc"&&(xs.innerHTML=ie),el=n(s),c(Us.$$.fragment,s),al=n(s),$s=i(s,"P",{"data-svelte-h":!0}),m($s)!=="svelte-2v1cek"&&($s.textContent=me),nl=n(s),c(Cs.$$.fragment,s),pl=n(s),Zs=i(s,"P",{"data-svelte-h":!0}),m(Zs)!=="svelte-tjyuxs"&&(Zs.textContent=re),il=n(s),_s=i(s,"P",{"data-svelte-h":!0}),m(_s)!=="svelte-4epvs7"&&(_s.textContent=ce),ml=n(s),vs=i(s,"OL",{"data-svelte-h":!0}),m(vs)!=="svelte-gtxums"&&(vs.innerHTML=oe),rl=n(s),c(Vs.$$.fragment,s),cl=n(s),c(ks.$$.fragment,s),ol=n(s),Gs=i(s,"P",{"data-svelte-h":!0}),m(Gs)!=="svelte-y6okgx"&&(Gs.innerHTML=ge),gl=n(s),Ws=i(s,"P",{"data-svelte-h":!0}),m(Ws)!=="svelte-49mqo4"&&(Ws.innerHTML=he),hl=n(s),c(Is.$$.fragment,s),Ml=n(s),Bs=i(s,"P",{"data-svelte-h":!0}),m(Bs)!=="svelte-bl55fy"&&(Bs.textContent=Me),jl=n(s),c(Xs.$$.fragment,s),dl=n(s),Qs=i(s,"P",{"data-svelte-h":!0}),m(Qs)!=="svelte-179kzpa"&&(Qs.innerHTML=je),ul=n(s),c(Rs.$$.fragment,s),bl=n(s),Hs=i(s,"P",{"data-svelte-h":!0}),m(Hs)!=="svelte-les5jw"&&(Hs.textContent=de),yl=n(s),c(Fs.$$.fragment,s),fl=n(s),Ns=i(s,"P",{"data-svelte-h":!0}),m(Ns)!=="svelte-1wddc64"&&(Ns.textContent=ue),wl=n(s),c(Es.$$.fragment,s),Jl=n(s),As=i(s,"P",{}),be(As).forEach(l),this.h()},h(){qs(d,"name","hf:doc:metadata"),qs(d,"content",_e),qs(u,"class","flex justify-center"),qs(b,"start","2"),qs(y,"start","3")},m(s,t){Ue(document.head,d),e(s,Ls,t),e(s,Ys,t),e(s,Ss,t),o(f,s,t),e(s,Ps,t),o(w,s,t),e(s,Ds,t),e(s,J,t),e(s,Ks,t),e(s,T,t),e(s,Os,t),e(s,x,t),e(s,st,t),e(s,U,t),e(s,tt,t),e(s,$,t),e(s,lt,t),o(C,s,t),e(s,et,t),e(s,Z,t),e(s,at,t),e(s,_,t),e(s,nt,t),e(s,v,t),e(s,pt,t),o(V,s,t),e(s,it,t),e(s,k,t),e(s,mt,t),o(G,s,t),e(s,rt,t),e(s,W,t),e(s,ct,t),o(I,s,t),e(s,ot,t),o(B,s,t),e(s,gt,t),e(s,X,t),e(s,ht,t),e(s,Q,t),e(s,Mt,t),e(s,R,t),e(s,jt,t),o(H,s,t),e(s,dt,t),e(s,F,t),e(s,ut,t),o(N,s,t),e(s,bt,t),e(s,E,t),e(s,yt,t),e(s,z,t),e(s,ft,t),e(s,Y,t),e(s,wt,t),o(A,s,t),e(s,Jt,t),e(s,q,t),e(s,Tt,t),e(s,L,t),e(s,xt,t),o(S,s,t),e(s,Ut,t),e(s,u,t),e(s,$t,t),e(s,P,t),e(s,Ct,t),e(s,D,t),e(s,Zt,t),e(s,K,t),e(s,_t,t),o(O,s,t),e(s,vt,t),e(s,ss,t),e(s,Vt,t),o(ts,s,t),e(s,kt,t),o(ls,s,t),e(s,Gt,t),e(s,es,t),e(s,Wt,t),o(as,s,t),e(s,It,t),e(s,ns,t),e(s,Bt,t),e(s,ps,t),e(s,Xt,t),e(s,is,t),e(s,Qt,t),o(ms,s,t),e(s,Rt,t),e(s,rs,t),e(s,Ht,t),o(cs,s,t),e(s,Ft,t),e(s,os,t),e(s,Nt,t),o(gs,s,t),e(s,Et,t),o(hs,s,t),e(s,zt,t),e(s,Ms,t),e(s,Yt,t),o(js,s,t),e(s,At,t),e(s,ds,t),e(s,qt,t),e(s,us,t),e(s,Lt,t),o(bs,s,t),e(s,St,t),e(s,b,t),e(s,Pt,t),o(ys,s,t),e(s,Dt,t),e(s,y,t),e(s,Kt,t),o(fs,s,t),e(s,Ot,t),e(s,ws,t),e(s,sl,t),o(Js,s,t),e(s,tl,t),o(Ts,s,t),e(s,ll,t),e(s,xs,t),e(s,el,t),o(Us,s,t),e(s,al,t),e(s,$s,t),e(s,nl,t),o(Cs,s,t),e(s,pl,t),e(s,Zs,t),e(s,il,t),e(s,_s,t),e(s,ml,t),e(s,vs,t),e(s,rl,t),o(Vs,s,t),e(s,cl,t),o(ks,s,t),e(s,ol,t),e(s,Gs,t),e(s,gl,t),e(s,Ws,t),e(s,hl,t),o(Is,s,t),e(s,Ml,t),e(s,Bs,t),e(s,jl,t),o(Xs,s,t),e(s,dl,t),e(s,Qs,t),e(s,ul,t),o(Rs,s,t),e(s,bl,t),e(s,Hs,t),e(s,yl,t),o(Fs,s,t),e(s,fl,t),e(s,Ns,t),e(s,wl,t),o(Es,s,t),e(s,Jl,t),e(s,As,t),Tl=!0},p:fe,i(s){Tl||(g(f.$$.fragment,s),g(w.$$.fragment,s),g(C.$$.fragment,s),g(V.$$.fragment,s),g(G.$$.fragment,s),g(I.$$.fragment,s),g(B.$$.fragment,s),g(H.$$.fragment,s),g(N.$$.fragment,s),g(A.$$.fragment,s),g(S.$$.fragment,s),g(O.$$.fragment,s),g(ts.$$.fragment,s),g(ls.$$.fragment,s),g(as.$$.fragment,s),g(ms.$$.fragment,s),g(cs.$$.fragment,s),g(gs.$$.fragment,s),g(hs.$$.fragment,s),g(js.$$.fragment,s),g(bs.$$.fragment,s),g(ys.$$.fragment,s),g(fs.$$.fragment,s),g(Js.$$.fragment,s),g(Ts.$$.fragment,s),g(Us.$$.fragment,s),g(Cs.$$.fragment,s),g(Vs.$$.fragment,s),g(ks.$$.fragment,s),g(Is.$$.fragment,s),g(Xs.$$.fragment,s),g(Rs.$$.fragment,s),g(Fs.$$.fragment,s),g(Es.$$.fragment,s),Tl=!0)},o(s){h(f.$$.fragment,s),h(w.$$.fragment,s),h(C.$$.fragment,s),h(V.$$.fragment,s),h(G.$$.fragment,s),h(I.$$.fragment,s),h(B.$$.fragment,s),h(H.$$.fragment,s),h(N.$$.fragment,s),h(A.$$.fragment,s),h(S.$$.fragment,s),h(O.$$.fragment,s),h(ts.$$.fragment,s),h(ls.$$.fragment,s),h(as.$$.fragment,s),h(ms.$$.fragment,s),h(cs.$$.fragment,s),h(gs.$$.fragment,s),h(hs.$$.fragment,s),h(js.$$.fragment,s),h(bs.$$.fragment,s),h(ys.$$.fragment,s),h(fs.$$.fragment,s),h(Js.$$.fragment,s),h(Ts.$$.fragment,s),h(Us.$$.fragment,s),h(Cs.$$.fragment,s),h(Vs.$$.fragment,s),h(ks.$$.fragment,s),h(Is.$$.fragment,s),h(Xs.$$.fragment,s),h(Rs.$$.fragment,s),h(Fs.$$.fragment,s),h(Es.$$.fragment,s),Tl=!1},d(s){s&&(l(Ls),l(Ys),l(Ss),l(Ps),l(Ds),l(J),l(Ks),l(T),l(Os),l(x),l(st),l(U),l(tt),l($),l(lt),l(et),l(Z),l(at),l(_),l(nt),l(v),l(pt),l(it),l(k),l(mt),l(rt),l(W),l(ct),l(ot),l(gt),l(X),l(ht),l(Q),l(Mt),l(R),l(jt),l(dt),l(F),l(ut),l(bt),l(E),l(yt),l(z),l(ft),l(Y),l(wt),l(Jt),l(q),l(Tt),l(L),l(xt),l(Ut),l(u),l($t),l(P),l(Ct),l(D),l(Zt),l(K),l(_t),l(vt),l(ss),l(Vt),l(kt),l(Gt),l(es),l(Wt),l(It),l(ns),l(Bt),l(ps),l(Xt),l(is),l(Qt),l(Rt),l(rs),l(Ht),l(Ft),l(os),l(Nt),l(Et),l(zt),l(Ms),l(Yt),l(At),l(ds),l(qt),l(us),l(Lt),l(St),l(b),l(Pt),l(Dt),l(y),l(Kt),l(Ot),l(ws),l(sl),l(tl),l(ll),l(xs),l(el),l(al),l($s),l(nl),l(pl),l(Zs),l(il),l(_s),l(ml),l(vs),l(rl),l(cl),l(ol),l(Gs),l(gl),l(Ws),l(hl),l(Ml),l(Bs),l(jl),l(dl),l(Qs),l(ul),l(bl),l(Hs),l(yl),l(fl),l(Ns),l(wl),l(Jl),l(As)),l(d),M(f,s),M(w,s),M(C,s),M(V,s),M(G,s),M(I,s),M(B,s),M(H,s),M(N,s),M(A,s),M(S,s),M(O,s),M(ts,s),M(ls,s),M(as,s),M(ms,s),M(cs,s),M(gs,s),M(hs,s),M(js,s),M(bs,s),M(ys,s),M(fs,s),M(Js,s),M(Ts,s),M(Us,s),M(Cs,s),M(Vs,s),M(ks,s),M(Is,s),M(Xs,s),M(Rs,s),M(Fs,s),M(Es,s)}}}const _e='{"title":"시각적 질의응답 (Visual Question Answering)","local":"시각적-질의응답-visual-question-answering","sections":[{"title":"ViLT 미세 조정","local":"finetuning-vilt","sections":[],"depth":2},{"title":"데이터 가져오기","local":"load-the-data","sections":[],"depth":2},{"title":"데이터 전처리","local":"preprocessing-data","sections":[],"depth":2},{"title":"모델 훈련","local":"train-the-model","sections":[],"depth":2},{"title":"추론","local":"inference","sections":[],"depth":2},{"title":"제로샷 VQA","local":"zeroshot-vqa","sections":[],"depth":2}],"depth":1}';function ve(xl){return we(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Be extends Je{constructor(d){super(),Te(this,d,ve,Ze,ye,{})}}export{Be as component};
