import{s as Dl,f as Ol,o as Kl,n as Q}from"../chunks/scheduler.bdbef820.js";import{S as Pl,i as et,g as d,s as M,r as u,A as lt,h as T,f as s,c,j as ul,u as f,x as U,k as Re,y as tt,a as n,v as h,d as w,t as b,w as j}from"../chunks/index.33f81d56.js";import{T as z}from"../chunks/Tip.34194030.js";import{C as W}from"../chunks/CodeBlock.3bad7fc9.js";import{H as K,E as st}from"../chunks/index.1b7d14e3.js";import{H as fl,a as Ge}from"../chunks/HfOption.6b792247.js";function at(V){let l,r='Hugging Face는 LLM을 추론에 최적화하여 배포하고 서비스하는 데 전념하는 라이브러리인 <a href="https://hf.co/docs/text-generation-inference" rel="nofollow">Text Generation Inference (TGI)</a>을 제공합니다. 이 라이브러리는 처리량 증가를 위한 지속적인 배칭과 다중 GPU 추론을 위한 텐서 병렬화와 같은 Transformers에 포함되지 않은 배포 지향 최적화 기능을 포함합니다.';return{c(){l=d("p"),l.innerHTML=r},l(t){l=T(t,"P",{"data-svelte-h":!0}),U(l)!=="svelte-9ielvc"&&(l.innerHTML=r)},m(t,o){n(t,l,o)},p:Q,d(t){t&&s(l)}}}function nt(V){let l,r='현재 <a href="./model_doc/llama2">Llama</a> 및 몇 가지 다른 모델만 정적 kv-cache와 <code>torch.compile</code>을 지원합니다. 실시간 모델 호환성 목록은 <a href="https://github.com/huggingface/transformers/issues/28981" rel="nofollow">이 이슈</a>를 확인하십시오.';return{c(){l=d("p"),l.innerHTML=r},l(t){l=T(t,"P",{"data-svelte-h":!0}),U(l)!=="svelte-1oypbst"&&(l.innerHTML=r)},m(t,o){n(t,l,o)},p:Q,d(t){t&&s(l)}}}function ot(V){let l,r='<code>torch.compile</code>을 사용할 때 어떤 전략을 사용하든, LLM 입력을 제한된 값 세트로 왼쪽에 패딩하면 모양과 관련된 재컴파일을 피할 수 있습니다. <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizer.__call__.pad_to_multiple_of" rel="nofollow"><code>pad_to_multiple_of</code> tokenizer flag</a>가 유용할 것입니다!';return{c(){l=d("p"),l.innerHTML=r},l(t){l=T(t,"P",{"data-svelte-h":!0}),U(l)!=="svelte-1y0azda"&&(l.innerHTML=r)},m(t,o){n(t,l,o)},p:Q,d(t){t&&s(l)}}}function it(V){let l,r='다중 턴 대화와 같은 정적 캐시의 고급 사용을 위해서는, 캐시 객체를 <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> 외부에서 인스턴스화하고 조작하는 것을 권장합니다. 고급 사용법 탭을 참조하세요.';return{c(){l=d("p"),l.innerHTML=r},l(t){l=T(t,"P",{"data-svelte-h":!0}),U(l)!=="svelte-ycigin"&&(l.innerHTML=r)},m(t,o){n(t,l,o)},p:Q,d(t){t&&s(l)}}}function pt(V){let l,r='이 예제에서는 <a href="https://hf.co/google/gemma-2b" rel="nofollow">Gemma</a> 모델을 사용해 보겠습니다. 필요한 작업은 다음과 같습니다:',t,o,i="<li>모델의 <code>generation_config</code> 속성에 접근하여 <code>cache_implementation</code>을 “static”으로 설정합니다;</li> <li>모델의 <code>forward</code> 패스를 정적 kv-cache와 함께 컴파일하기 위해 <code>torch.compile</code>을 호출합니다.</li>",p,m,Z="이렇게 하면 끝입니다!",$,I,_,C,G="<code>generate</code> 함수는 내부적으로 동일한 캐시 객체를 재사용하려고 시도하며, 이를 통해 각 호출 시 재컴파일의 필요성을 제거합니다. 재컴파일을 피하는 것은 <code>torch.compile</code>의 성능을 최대한 활용하는 데 매우 중요하며, 다음 사항에 유의해야 합니다:",F,v,B="<li>배치 크기가 변경되거나 호출 간 최대 출력 길이가 증가하면 캐시를 다시 초기화해야 하며, 이로 인해 새로 컴파일을 해야 합니다;</li> <li>컴파일된 함수의 첫 몇 번의 호출은 함수가 컴파일되는 동안 더 느립니다.</li>",X,k,g;return I=new W({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwb3MlMEFvcy5lbnZpcm9uJTVCJTIyVE9LRU5JWkVSU19QQVJBTExFTElTTSUyMiU1RCUyMCUzRCUyMCUyMmZhbHNlJTIyJTIwJTIwJTIzJTIwJUVBJUI4JUI0JTIwJUVBJUIyJUJEJUVBJUIzJUEwJTIwJUVCJUE5JTk0JUVDJThCJTlDJUVDJUE3JTgwJUVCJUE1JUJDJTIwJUVCJUIwJUE5JUVDJUE3JTgwJUVEJTk1JTk4JUVBJUI4JUIwJTIwJUVDJTlDJTg0JUVEJTk1JUI0JTIwJUVDJTg0JUE0JUVDJUEwJTk1JTIwJTNBKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcuY2FjaGVfaW1wbGVtZW50YXRpb24lMjAlM0QlMjAlMjJzdGF0aWMlMjIlMEElMEFtb2RlbC5mb3J3YXJkJTIwJTNEJTIwdG9yY2guY29tcGlsZShtb2RlbC5mb3J3YXJkJTJDJTIwbW9kZSUzRCUyMnJlZHVjZS1vdmVyaGVhZCUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBaW5wdXRfdGV4dCUyMCUzRCUyMCUyMlRoZSUyMHRoZW9yeSUyMG9mJTIwc3BlY2lhbCUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjAlMjIlMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRfaWRzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElNUInVGhlJTIwdGhlb3J5JTIwb2YlMjBzcGVjaWFsJTIwcmVsYXRpdml0eSUyMHN0YXRlcyUyMDEuJTIwVGhlJTIwc3BlZWQlMjBvZiUyMGxpZ2h0JTIwaXMlMjBjb25zdGFudCUyMGluJTIwYWxsJTIwaW5lcnRpYWwlMjByZWZlcmVuY2UnJTVE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> os
os.environ[<span class="hljs-string">&quot;TOKENIZERS_PARALLELISM&quot;</span>] = <span class="hljs-string">&quot;false&quot;</span>  <span class="hljs-comment"># 긴 경고 메시지를 방지하기 위해 설정 :)</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)

model.generation_config.cache_implementation = <span class="hljs-string">&quot;static&quot;</span>

model.forward = torch.<span class="hljs-built_in">compile</span>(model.forward, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
input_text = <span class="hljs-string">&quot;The theory of special relativity states &quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

outputs = model.generate(**input_ids)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The theory of special relativity states 1. The speed of light is constant in all inertial reference&#x27;</span>]`,wrap:!1}}),k=new z({props:{warning:!0,$$slots:{default:[it]},$$scope:{ctx:V}}}),{c(){l=d("p"),l.innerHTML=r,t=M(),o=d("ol"),o.innerHTML=i,p=M(),m=d("p"),m.textContent=Z,$=M(),u(I.$$.fragment),_=M(),C=d("p"),C.innerHTML=G,F=M(),v=d("ol"),v.innerHTML=B,X=M(),u(k.$$.fragment)},l(y){l=T(y,"P",{"data-svelte-h":!0}),U(l)!=="svelte-zgi424"&&(l.innerHTML=r),t=c(y),o=T(y,"OL",{"data-svelte-h":!0}),U(o)!=="svelte-1eyfj2k"&&(o.innerHTML=i),p=c(y),m=T(y,"P",{"data-svelte-h":!0}),U(m)!=="svelte-1li9iek"&&(m.textContent=Z),$=c(y),f(I.$$.fragment,y),_=c(y),C=T(y,"P",{"data-svelte-h":!0}),U(C)!=="svelte-13n4tf3"&&(C.innerHTML=G),F=c(y),v=T(y,"OL",{"data-svelte-h":!0}),U(v)!=="svelte-1b9xyp9"&&(v.innerHTML=B),X=c(y),f(k.$$.fragment,y)},m(y,J){n(y,l,J),n(y,t,J),n(y,o,J),n(y,p,J),n(y,m,J),n(y,$,J),h(I,y,J),n(y,_,J),n(y,C,J),n(y,F,J),n(y,v,J),n(y,X,J),h(k,y,J),g=!0},p(y,J){const R={};J&2&&(R.$$scope={dirty:J,ctx:y}),k.$set(R)},i(y){g||(w(I.$$.fragment,y),w(k.$$.fragment,y),g=!0)},o(y){b(I.$$.fragment,y),b(k.$$.fragment,y),g=!1},d(y){y&&(s(l),s(t),s(o),s(p),s(m),s($),s(_),s(C),s(F),s(v),s(X)),j(I,y),j(k,y)}}}function rt(V){let l,r='동일한 <a href="/docs/transformers/main/ko/internal/generation_utils#transformers.StaticCache">StaticCache</a> 객체를 새로운 프롬프트에 사용하려면, 호출 간에 <code>.reset()</code> 메서드를 사용하여 그 내용을 초기화하는 것이 좋습니다.';return{c(){l=d("p"),l.innerHTML=r},l(t){l=T(t,"P",{"data-svelte-h":!0}),U(l)!=="svelte-3i24c8"&&(l.innerHTML=r)},m(t,o){n(t,l,o)},p:Q,d(t){t&&s(l)}}}function Mt(V){let l,r='<a href="/docs/transformers/main/ko/internal/generation_utils#transformers.StaticCache">StaticCache</a> 객체는 <code>past_key_values</code> 인수로 모델의 <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> 함수에 전달할 수 있습니다. 이 객체는 캐시 내용을 유지하므로, 동적 캐시를 사용하는 것처럼 새로운 <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> 호출에 이를 전달하여 생성을 계속할 수 있습니다.',t,o,i,p,m,Z,$='더 깊이 들어가고 싶다면, <a href="/docs/transformers/main/ko/internal/generation_utils#transformers.StaticCache">StaticCache</a> 객체를 모델의 <code>forward</code> 패스에 동일한 <code>past_key_values</code> 인수로 전달할 수도 있습니다. 이 전략을 사용하면, 현재 토큰과 이전에 생성된 토큰의 위치 및 캐시 위치를 바탕으로 다음 토큰을 디코딩하는 자체 함수를 작성할 수 있습니다.',I,_,C,G,F="<code>StaticCache</code> 메서드를 사용하여 정적 kv-cache와 <code>torch.compile</code>을 활성화하려면 몇 가지 중요한 작업을 수행해야 합니다:",v,B,X='<li>추론에 모델을 사용하기 전에 <a href="/docs/transformers/main/ko/internal/generation_utils#transformers.StaticCache">StaticCache</a> 인스턴스를 초기화합니다. 여기서 최대 배치 크기와 시퀀스 길이와 같은 매개변수를 설정할 수 있습니다.</li> <li>정적 kv-cache와 함께 순전파를 컴파일하기 위해 모델에 <code>torch.compile</code>을 호출합니다.</li> <li><a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">torch.backends.cuda.sdp_kernel</a> 컨텍스트 관리자에서 <code>enable_math=True</code>를 설정하여 네이티브 PyTorch C++ 구현된 스케일된 점곱 어텐션(scaled dot product attention)을 활성화하여 추론 속도를 더욱 높입니다.</li>',k,g,y;return o=new W({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFN0YXRpY0NhY2hlJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBvcyUwQW9zLmVudmlyb24lNUIlMjJUT0tFTklaRVJTX1BBUkFMTEVMSVNNJTIyJTVEJTIwJTNEJTIwJTIyZmFsc2UlMjIlMjAlMjAlMjMlMjAlRUElQjglQjQlMjAlRUElQjIlQkQlRUElQjMlQTAlMjAlRUIlQTklOTQlRUMlOEIlOUMlRUMlQTclODAlRUIlQTUlQkMlMjAlRUIlQjAlQTklRUMlQTclODAlRUQlOTUlOTglRUElQjglQjAlMjAlRUMlOUMlODQlRUQlOTUlQjQlMjAlRUMlODQlQTQlRUMlQTAlOTUlMjAlM0EpJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZ2VtbWEtMmIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZ2VtbWEtMmIlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiklMEElMEFtb2RlbC5mb3J3YXJkJTIwJTNEJTIwdG9yY2guY29tcGlsZShtb2RlbC5mb3J3YXJkJTJDJTIwbW9kZSUzRCUyMnJlZHVjZS1vdmVyaGVhZCUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBaW5wdXRfdGV4dCUyMCUzRCUyMCUyMlRoZSUyMHRoZW9yeSUyMG9mJTIwc3BlY2lhbCUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjAlMjIlMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBcHJvbXB0X2xlbmd0aCUyMCUzRCUyMGlucHV0X2lkcy5pbnB1dF9pZHMuc2hhcGUlNUIxJTVEJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcubWF4X25ld190b2tlbnMlMjAlM0QlMjAxNiUwQSUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMFN0YXRpY0NhY2hlKCUwQSUyMCUyMCUyMCUyMGNvbmZpZyUzRG1vZGVsLmNvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMG1heF9iYXRjaF9zaXplJTNEMSUyQyUwQSUyMCUyMCUyMCUyMCUyMyUyMCVFQyVCQSU5MCVFQyU4QiU5QyVFQiVBNSVCQyUyMCVFQyU5RSVBQyVFQyU4MiVBQyVFQyU5QSVBOSVFRCU5NSVBMCUyMCVFQSVCMyU4NCVFRCU5QSU4RCVFQyU5RCVCNCUyMCVFQyU5RSU4OCVFQiU4QSU5NCUyMCVFQSVCMiVCRCVFQyU5QSVCMCUyQyUyMCVFQiVBQSVBOCVFQiU5MyVBMCUyMCVFQSVCMiVCRCVFQyU5QSVCMCVFQyU5NyU5MCUyMCVFQyVCNiVBOSVFQiVCNiU4NCVFRCU5NSU5QyUyMCVFQyVCQSU5MCVFQyU4QiU5QyUyMCVFQSVCOCVCOCVFQyU5RCVCNCVFQiVBNSVCQyUyMCVFQyU4NCVBNCVFQyVBMCU5NSVFRCU5NSVCNCVFQyU5NSVCQyUyMCVFRCU5NSVBOSVFQiU4QiU4OCVFQiU4QiVBNCUwQSUyMCUyMCUyMCUyMG1heF9jYWNoZV9sZW4lM0Rwcm9tcHRfbGVuZ3RoJTJCKG1vZGVsLmdlbmVyYXRpb25fY29uZmlnLm1heF9uZXdfdG9rZW5zKjIpJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlJTNEbW9kZWwuZGV2aWNlJTJDJTBBJTIwJTIwJTIwJTIwZHR5cGUlM0Rtb2RlbC5kdHlwZSUwQSklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dF9pZHMlMkMlMjBwYXN0X2tleV92YWx1ZXMlM0RwYXN0X2tleV92YWx1ZXMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSU1QidUaGUlMjB0aGVvcnklMjBvZiUyMHNwZWNpYWwlMjByZWxhdGl2aXR5JTIwc3RhdGVzJTIwMS4lMjBUaGUlMjBzcGVlZCUyMG9mJTIwbGlnaHQlMjBpcyUyMGNvbnN0YW50JTIwaW4lMjBhbGwlMjBpbmVydGlhbCUyMHJlZmVyZW5jZSUyMGZyYW1lcy4lMjAyJyU1RCUwQSUwQSUyMyUyMCVFQyU4MyU5RCVFQyU4NCVCMSVFQiU5MCU5QyUyMCVFRCU4NSU4RCVFQyU4QSVBNCVFRCU4QSVCOCVFQyU5OSU4MCUyMCVFQiU4RiU5OSVFQyU5RCVCQyVFRCU5NSU5QyUyMCVFQyVCQSU5MCVFQyU4QiU5QyUyMCVFQSVCMCU5RCVFQyVCMiVCNCVFQiVBNSVCQyUyMCVFQyVBMCU4NCVFQiU4QiVBQyVFRCU5NSU5OCVFQyU5NyVBQyUyQyUyMCVFQyVBNCU5MSVFQiU4QiVBOCVFRCU5NSU5QyUyMCVFQSVCMyVCMyVFQyU5NyU5MCVFQyU4NCU5QyUyMCVFQyU4MyU5RCVFQyU4NCVCMSVFQyU5RCU4NCUyMCVFQSVCMyU4NCVFQyU4NiU4RCVFRCU5NSVBOSVFQiU4QiU4OCVFQiU4QiVBNC4lMEElMjMlMjAlRUIlOEIlQTQlRUMlQTQlOTElMjAlRUQlODQlQjQlMjAlRUIlOEMlODAlRUQlOTklOTQlRUMlOUQlOTglMjAlRUElQjIlQkQlRUMlOUElQjAlMkMlMjAlRUMlODMlOUQlRUMlODQlQjElRUIlOTAlOUMlMjAlRUQlODUlOEQlRUMlOEElQTQlRUQlOEElQjglRUMlOTclOTAlMjAlRUMlODMlODglRUIlQTElOUMlRUMlOUElQjQlMjAlRUMlODIlQUMlRUMlOUElQTklRUMlOUUlOTAlMjAlRUMlOUUlODUlRUIlQTAlQTUlRUMlOUQlODQlMjAlRUMlQjYlOTQlRUElQjAlODAlRUQlOTUlQTAlMjAlRUMlODglOTglMjAlRUMlOUUlODglRUMlOEElQjUlRUIlOEIlODglRUIlOEIlQTQuJTBBbmV3X2lucHV0X2lkcyUyMCUzRCUyMG91dHB1dHMlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUobmV3X2lucHV0X2lkcyUyQyUyMHBhc3Rfa2V5X3ZhbHVlcyUzRHBhc3Rfa2V5X3ZhbHVlcyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkpJTBBJTVCJ1RoZSUyMHRoZW9yeSUyMG9mJTIwc3BlY2lhbCUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjAxLiUyMFRoZSUyMHNwZWVkJTIwb2YlMjBsaWdodCUyMGlzJTIwY29uc3RhbnQlMjBpbiUyMGFsbCUyMGluZXJ0aWFsJTIwcmVmZXJlbmNlJTIwZnJhbWVzLiUyMDIuJTIwVGhlJTIwc3BlZWQlMjBvZiUyMGxpZ2h0JTIwaXMlMjBjb25zdGFudCUyMGluJTIwYWxsJTIwaW5lcnRpYWwlMjByZWZlcmVuY2UlMjBmcmFtZXMuJTIwMy4nJTVE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, StaticCache
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> os
os.environ[<span class="hljs-string">&quot;TOKENIZERS_PARALLELISM&quot;</span>] = <span class="hljs-string">&quot;false&quot;</span>  <span class="hljs-comment"># 긴 경고 메시지를 방지하기 위해 설정 :)</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)

model.forward = torch.<span class="hljs-built_in">compile</span>(model.forward, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
input_text = <span class="hljs-string">&quot;The theory of special relativity states &quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt_length = input_ids.input_ids.shape[<span class="hljs-number">1</span>]
model.generation_config.max_new_tokens = <span class="hljs-number">16</span>

past_key_values = StaticCache(
    config=model.config,
    max_batch_size=<span class="hljs-number">1</span>,
    <span class="hljs-comment"># 캐시를 재사용할 계획이 있는 경우, 모든 경우에 충분한 캐시 길이를 설정해야 합니다</span>
    max_cache_len=prompt_length+(model.generation_config.max_new_tokens*<span class="hljs-number">2</span>),
    device=model.device,
    dtype=model.dtype
)
outputs = model.generate(**input_ids, past_key_values=past_key_values)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The theory of special relativity states 1. The speed of light is constant in all inertial reference frames. 2&#x27;</span>]

<span class="hljs-comment"># 생성된 텍스트와 동일한 캐시 객체를 전달하여, 중단한 곳에서 생성을 계속합니다.</span>
<span class="hljs-comment"># 다중 턴 대화의 경우, 생성된 텍스트에 새로운 사용자 입력을 추가할 수 있습니다.</span>
new_input_ids = outputs
outputs = model.generate(new_input_ids, past_key_values=past_key_values)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The theory of special relativity states 1. The speed of light is constant in all inertial reference frames. 2. The speed of light is constant in all inertial reference frames. 3.&#x27;</span>]`,wrap:!1}}),p=new z({props:{warning:!1,$$slots:{default:[rt]},$$scope:{ctx:V}}}),_=new W({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hVG9rZW5pemVyJTJDJTIwTGxhbWFGb3JDYXVzYWxMTSUyQyUyMFN0YXRpY0NhY2hlJTJDJTIwbG9nZ2luZyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMudGVzdGluZ191dGlscyUyMGltcG9ydCUyMENhcHR1cmVMb2dnZXIlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXByb21wdHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJTaW1wbHklMjBwdXQlMkMlMjB0aGUlMjB0aGVvcnklMjBvZiUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjB0aGF0JTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyTXklMjBmYXZvcml0ZSUyMGFsbCUyMHRpbWUlMjBmYXZvcml0ZSUyMGNvbmRpbWVudCUyMGlzJTIwa2V0Y2h1cC4lMjIlMkMlMEElNUQlMEElMEFOVU1fVE9LRU5TX1RPX0dFTkVSQVRFJTIwJTNEJTIwNDAlMEF0b3JjaF9kZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwTGxhbWFUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1ldGEtbGxhbWElMkZMbGFtYS0yLTdiLWhmJTIyJTJDJTIwcGFkX3Rva2VuJTNEJTIyJTNDJTJGcyUzRSUyMiUyQyUyMHBhZGRpbmdfc2lkZSUzRCUyMnJpZ2h0JTIyKSUwQW1vZGVsJTIwJTNEJTIwTGxhbWFGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItaGYlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyc2VxdWVudGlhbCUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0cyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjBwYWRkaW5nJTNEVHJ1ZSkudG8obW9kZWwuZGV2aWNlKSUwQSUwQWRlZiUyMGRlY29kZV9vbmVfdG9rZW5zKG1vZGVsJTJDJTIwY3VyX3Rva2VuJTJDJTIwaW5wdXRfcG9zJTJDJTIwY2FjaGVfcG9zaXRpb24lMkMlMjBwYXN0X2tleV92YWx1ZXMpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY3VyX3Rva2VuJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcG9zaXRpb25faWRzJTNEaW5wdXRfcG9zJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FjaGVfcG9zaXRpb24lM0RjYWNoZV9wb3NpdGlvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhc3Rfa2V5X3ZhbHVlcyUzRHBhc3Rfa2V5X3ZhbHVlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybl9kaWN0JTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB1c2VfY2FjaGUlM0RUcnVlJTBBJTIwJTIwJTIwJTIwKSU1QjAlNUQlMEElMjAlMjAlMjAlMjBuZXdfdG9rZW4lMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTVCJTNBJTJDJTIwLTElNUQlMkMlMjBkaW0lM0QtMSklNUIlM0ElMkMlMjBOb25lJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbmV3X3Rva2Vu",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlamaTokenizer, LlamaForCausalLM, StaticCache, logging
<span class="hljs-keyword">from</span> transformers.testing_utils <span class="hljs-keyword">import</span> CaptureLogger
<span class="hljs-keyword">import</span> torch

prompts = [
    <span class="hljs-string">&quot;Simply put, the theory of relativity states that &quot;</span>,
    <span class="hljs-string">&quot;My favorite all time favorite condiment is ketchup.&quot;</span>,
]

NUM_TOKENS_TO_GENERATE = <span class="hljs-number">40</span>
torch_device = <span class="hljs-string">&quot;cuda&quot;</span>

tokenizer = LlamaTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>, padding_side=<span class="hljs-string">&quot;right&quot;</span>)
model = LlamaForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>, device_map=<span class="hljs-string">&quot;sequential&quot;</span>)
inputs = tokenizer(prompts, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>).to(model.device)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">decode_one_tokens</span>(<span class="hljs-params">model, cur_token, input_pos, cache_position, past_key_values</span>):
    logits = model(
        cur_token,
        position_ids=input_pos,
        cache_position=cache_position,
        past_key_values=past_key_values,
        return_dict=<span class="hljs-literal">False</span>,
        use_cache=<span class="hljs-literal">True</span>
    )[<span class="hljs-number">0</span>]
    new_token = torch.argmax(logits[:, -<span class="hljs-number">1</span>], dim=-<span class="hljs-number">1</span>)[:, <span class="hljs-literal">None</span>]
    <span class="hljs-keyword">return</span> new_token`,wrap:!1}}),g=new W({props:{code:"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",highlighted:`batch_size, seq_length = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape
<span class="hljs-keyword">with</span> torch.no_grad():
    past_key_values = StaticCache(
        config=model.config, max_batch_size=<span class="hljs-number">2</span>, max_cache_len=<span class="hljs-number">4096</span>, device=torch_device, dtype=model.dtype
    )
    cache_position = torch.arange(seq_length, device=torch_device)
    generated_ids = torch.zeros(
        batch_size, seq_length + NUM_TOKENS_TO_GENERATE + <span class="hljs-number">1</span>, dtype=torch.<span class="hljs-built_in">int</span>, device=torch_device
    )
    generated_ids[:, cache_position] = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].to(torch_device).to(torch.<span class="hljs-built_in">int</span>)

    logits = model(
        **inputs, cache_position=cache_position, past_key_values=past_key_values,return_dict=<span class="hljs-literal">False</span>, use_cache=<span class="hljs-literal">True</span>
    )[<span class="hljs-number">0</span>]
    next_token = torch.argmax(logits[:, -<span class="hljs-number">1</span>], dim=-<span class="hljs-number">1</span>)[:, <span class="hljs-literal">None</span>]
    generated_ids[:, seq_length] = next_token[:, <span class="hljs-number">0</span>]

    decode_one_tokens = torch.<span class="hljs-built_in">compile</span>(decode_one_tokens, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
    cache_position = torch.tensor([seq_length + <span class="hljs-number">1</span>], device=torch_device)
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1</span>, NUM_TOKENS_TO_GENERATE):
        <span class="hljs-keyword">with</span> torch.backends.cuda.sdp_kernel(enable_flash=<span class="hljs-literal">False</span>, enable_mem_efficient=<span class="hljs-literal">False</span>, enable_math=<span class="hljs-literal">True</span>):
            next_token = decode_one_tokens(model, next_token.clone(), <span class="hljs-literal">None</span>, cache_position, past_key_values)
            generated_ids[:, cache_position] = next_token.<span class="hljs-built_in">int</span>()
        cache_position += <span class="hljs-number">1</span>

text = tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
text
[<span class="hljs-string">&#x27;Simply put, the theory of relativity states that 1) the speed of light is constant, 2) the speed of light is the same for all observers, and 3) the laws of physics are the same for all observers.&#x27;</span>,
 <span class="hljs-string">&#x27;My favorite all time favorite condiment is ketchup. I love it on everything. I love it on my eggs, my fries, my chicken, my burgers, my hot dogs, my sandwiches, my salads, my p&#x27;</span>]`,wrap:!1}}),{c(){l=d("p"),l.innerHTML=r,t=M(),u(o.$$.fragment),i=M(),u(p.$$.fragment),m=M(),Z=d("p"),Z.innerHTML=$,I=M(),u(_.$$.fragment),C=M(),G=d("p"),G.innerHTML=F,v=M(),B=d("ol"),B.innerHTML=X,k=M(),u(g.$$.fragment)},l(J){l=T(J,"P",{"data-svelte-h":!0}),U(l)!=="svelte-1dmwvmx"&&(l.innerHTML=r),t=c(J),f(o.$$.fragment,J),i=c(J),f(p.$$.fragment,J),m=c(J),Z=T(J,"P",{"data-svelte-h":!0}),U(Z)!=="svelte-6zphge"&&(Z.innerHTML=$),I=c(J),f(_.$$.fragment,J),C=c(J),G=T(J,"P",{"data-svelte-h":!0}),U(G)!=="svelte-1tznqst"&&(G.innerHTML=F),v=c(J),B=T(J,"OL",{"data-svelte-h":!0}),U(B)!=="svelte-5jrift"&&(B.innerHTML=X),k=c(J),f(g.$$.fragment,J)},m(J,R){n(J,l,R),n(J,t,R),h(o,J,R),n(J,i,R),h(p,J,R),n(J,m,R),n(J,Z,R),n(J,I,R),h(_,J,R),n(J,C,R),n(J,G,R),n(J,v,R),n(J,B,R),n(J,k,R),h(g,J,R),y=!0},p(J,R){const N={};R&2&&(N.$$scope={dirty:R,ctx:J}),p.$set(N)},i(J){y||(w(o.$$.fragment,J),w(p.$$.fragment,J),w(_.$$.fragment,J),w(g.$$.fragment,J),y=!0)},o(J){b(o.$$.fragment,J),b(p.$$.fragment,J),b(_.$$.fragment,J),b(g.$$.fragment,J),y=!1},d(J){J&&(s(l),s(t),s(i),s(m),s(Z),s(I),s(C),s(G),s(v),s(B),s(k)),j(o,J),j(p,J),j(_,J),j(g,J)}}}function ct(V){let l,r="전체 <code>generate</code> 함수를 컴파일하는 것은 코드 측면에서 기본 사용법보다 더 간단합니다. <code>generate</code> 함수에 대해 <code>torch.compile</code>을 호출하여 전체 함수를 컴파일하면 됩니다. 정적 캐시의 사용을 지정할 필요는 없습니다. 정적 캐시는 호환되지만, 벤치마크에서는 동적 캐시(기본 설정)가 더 빠른 것으로 나타났습니다.",t,o,i,p,m="이 방법을 통해 모델의 forward 패스뿐만 아니라, 입력 준비, logit 처리기 작업 등을 포함한 모든 것을 컴파일합니다. 기본 사용 예제에 비해 <code>generate</code> 호출이 약간 더 빠를 수 있으며, 컴파일된 그래프는 더 특이한 하드웨어 장치나 사용 사례에 적합할 수 있습니다. 그러나 이 접근 방식을 사용하는 데는 몇 가지 큰 단점이 있습니다:",Z,$,I="<li>컴파일 속도가 훨씬 느립니다;</li> <li><code>generate</code>의 모든 매개변수 설정은 <code>generation_config</code>를 통해서만 가능합니다;</li> <li>많은 경고와 예외가 억제됩니다. — 먼저 컴파일 되지 않은 형태로 테스트하는 것을 권장합니다;</li> <li>현재 작업 중이지만 기능 제한이 심합니다(예: 작성 시점에서는 EOS 토큰이 선택되어도 생성이 중단되지 않습니다).</li>",_;return o=new W({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwb3MlMEFvcy5lbnZpcm9uJTVCJTIyVE9LRU5JWkVSU19QQVJBTExFTElTTSUyMiU1RCUyMCUzRCUyMCUyMmZhbHNlJTIyJTIwJTIwJTIzJTIwJUVBJUI4JUI0JTIwJUVBJUIyJUJEJUVBJUIzJUEwJTIwJUVCJUE5JTk0JUVDJThCJTlDJUVDJUE3JTgwJUVCJUE1JUJDJTIwJUVCJUIwJUE5JUVDJUE3JTgwJUVEJTk1JTk4JUVBJUI4JUIwJTIwJUVDJTlDJTg0JUVEJTk1JUI0JTIwJUVDJTg0JUE0JUVDJUEwJTk1JTIwJTNBKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBJTBBbW9kZWwuZ2VuZXJhdGUlMjAlM0QlMjB0b3JjaC5jb21waWxlKG1vZGVsLmdlbmVyYXRlJTJDJTIwbW9kZSUzRCUyMnJlZHVjZS1vdmVyaGVhZCUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBaW5wdXRfdGV4dCUyMCUzRCUyMCUyMlRoZSUyMHRoZW9yeSUyMG9mJTIwc3BlY2lhbCUyMHJlbGF0aXZpdHklMjBzdGF0ZXMlMjAlMjIlMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRfaWRzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElNUInVGhlJTIwdGhlb3J5JTIwb2YlMjBzcGVjaWFsJTIwcmVsYXRpdml0eSUyMHN0YXRlcyUyMDEuJTIwVGhlJTIwc3BlZWQlMjBvZiUyMGxpZ2h0JTIwaXMlMjBjb25zdGFudCUyMGluJTIwYWxsJTIwaW5lcnRpYWwlMjByZWZlcmVuY2UnJTVE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> os
os.environ[<span class="hljs-string">&quot;TOKENIZERS_PARALLELISM&quot;</span>] = <span class="hljs-string">&quot;false&quot;</span>  <span class="hljs-comment"># 긴 경고 메시지를 방지하기 위해 설정 :)</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)

model.generate = torch.<span class="hljs-built_in">compile</span>(model.generate, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
input_text = <span class="hljs-string">&quot;The theory of special relativity states &quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

outputs = model.generate(**input_ids)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The theory of special relativity states 1. The speed of light is constant in all inertial reference&#x27;</span>]`,wrap:!1}}),{c(){l=d("p"),l.innerHTML=r,t=M(),u(o.$$.fragment),i=M(),p=d("p"),p.innerHTML=m,Z=M(),$=d("ol"),$.innerHTML=I},l(C){l=T(C,"P",{"data-svelte-h":!0}),U(l)!=="svelte-gsicdl"&&(l.innerHTML=r),t=c(C),f(o.$$.fragment,C),i=c(C),p=T(C,"P",{"data-svelte-h":!0}),U(p)!=="svelte-q1zvmc"&&(p.innerHTML=m),Z=c(C),$=T(C,"OL",{"data-svelte-h":!0}),U($)!=="svelte-1h1n9r2"&&($.innerHTML=I)},m(C,G){n(C,l,G),n(C,t,G),h(o,C,G),n(C,i,G),n(C,p,G),n(C,Z,G),n(C,$,G),_=!0},p:Q,i(C){_||(w(o.$$.fragment,C),_=!0)},o(C){b(o.$$.fragment,C),_=!1},d(C){C&&(s(l),s(t),s(i),s(p),s(Z),s($)),j(o,C)}}}function Jt(V){let l,r,t,o,i,p;return l=new Ge({props:{id:"static-kv",option:"basic usage: generation_config",$$slots:{default:[pt]},$$scope:{ctx:V}}}),t=new Ge({props:{id:"static-kv",option:"advanced usage: control Static Cache",$$slots:{default:[Mt]},$$scope:{ctx:V}}}),i=new Ge({props:{id:"static-kv",option:"advanced usage: end-to-end generate compilation",$$slots:{default:[ct]},$$scope:{ctx:V}}}),{c(){u(l.$$.fragment),r=M(),u(t.$$.fragment),o=M(),u(i.$$.fragment)},l(m){f(l.$$.fragment,m),r=c(m),f(t.$$.fragment,m),o=c(m),f(i.$$.fragment,m)},m(m,Z){h(l,m,Z),n(m,r,Z),h(t,m,Z),n(m,o,Z),h(i,m,Z),p=!0},p(m,Z){const $={};Z&2&&($.$$scope={dirty:Z,ctx:m}),l.$set($);const I={};Z&2&&(I.$$scope={dirty:Z,ctx:m}),t.$set(I);const _={};Z&2&&(_.$$scope={dirty:Z,ctx:m}),i.$set(_)},i(m){p||(w(l.$$.fragment,m),w(t.$$.fragment,m),w(i.$$.fragment,m),p=!0)},o(m){b(l.$$.fragment,m),b(t.$$.fragment,m),b(i.$$.fragment,m),p=!1},d(m){m&&(s(r),s(o)),j(l,m),j(t,m),j(i,m)}}}function mt(V){let l,r='보다 심층적인 설명을 원한다면, <a href="https://hf.co/blog/assisted-generation" rel="nofollow">Assisted Generation: a new direction toward low-latency text generation</a> 블로그 게시물을 확인하십시오!';return{c(){l=d("p"),l.innerHTML=r},l(t){l=T(t,"P",{"data-svelte-h":!0}),U(l)!=="svelte-144tzha"&&(l.innerHTML=r)},m(t,o){n(t,l,o)},p:Q,d(t){t&&s(l)}}}function yt(V){let l,r="추정 디코딩은 탐욕 검색과 샘플링 디코딩 전략에서만 지원되며, 배치 입력을 지원하지 않습니다.";return{c(){l=d("p"),l.textContent=r},l(t){l=T(t,"P",{"data-svelte-h":!0}),U(l)!=="svelte-11g2hie"&&(l.textContent=r)},m(t,o){n(t,l,o)},p:Q,d(t){t&&s(l)}}}function dt(V){let l,r;return l=new W({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xLjNiJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJFaW5zdGVpbidzJTIwdGhlb3J5JTIwb2YlMjByZWxhdGl2aXR5JTIwc3RhdGVzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oZGV2aWNlKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpLnRvKGRldmljZSklMEFhc3Npc3RhbnRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMTI1bSUyMikudG8oZGV2aWNlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGFzc2lzdGFudF9tb2RlbCUzRGFzc2lzdGFudF9tb2RlbCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEElNUIlMjJFaW5zdGVpbidzJTIwdGhlb3J5JTIwb2YlMjByZWxhdGl2aXR5JTIwc3RhdGVzJTIwdGhhdCUyMHRoZSUyMHNwZWVkJTIwb2YlMjBsaWdodCUyMGlzJTIwY29uc3RhbnQuJTIwJTIwJTIwJTIwJTIyJTVE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>).to(device)
assistant_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>).to(device)
outputs = model.generate(**inputs, assistant_model=assistant_model)
tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states that the speed of light is constant.    &quot;</span>]`,wrap:!1}}),{c(){u(l.$$.fragment)},l(t){f(l.$$.fragment,t)},m(t,o){h(l,t,o),r=!0},p:Q,i(t){r||(w(l.$$.fragment,t),r=!0)},o(t){b(l.$$.fragment,t),r=!1},d(t){j(l,t)}}}function Tt(V){let l,r='추정 샘플링 디코딩(speculative sampling decoding)을 위해, 보조 모델 외에도 <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> 메서드에 <code>do_sample</code> 및 <code>temperature</code> 매개변수를 추가하십시오.',t,o,i;return o=new W({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xLjNiJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJFaW5zdGVpbidzJTIwdGhlb3J5JTIwb2YlMjByZWxhdGl2aXR5JTIwc3RhdGVzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oZGV2aWNlKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpLnRvKGRldmljZSklMEFhc3Npc3RhbnRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMTI1bSUyMikudG8oZGV2aWNlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGFzc2lzdGFudF9tb2RlbCUzRGFzc2lzdGFudF9tb2RlbCUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0ZW1wZXJhdHVyZSUzRDAuNyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkpJTBBJTVCJTIyRWluc3RlaW4ncyUyMHRoZW9yeSUyMG9mJTIwcmVsYXRpdml0eSUyMHN0YXRlcyUyMHRoYXQlMjBtb3Rpb24lMjBpbiUyMHRoZSUyMHVuaXZlcnNlJTIwaXMlMjBub3QlMjBhJTIwc3RyYWlnaHQlMjBsaW5lLiU1Q24lMjIlNUQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>).to(device)
assistant_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>).to(device)
outputs = model.generate(**inputs, assistant_model=assistant_model, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.7</span>)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&quot;Einstein&#x27;s theory of relativity states that motion in the universe is not a straight line.\\n&quot;</span>]`,wrap:!1}}),{c(){l=d("p"),l.innerHTML=r,t=M(),u(o.$$.fragment)},l(p){l=T(p,"P",{"data-svelte-h":!0}),U(l)!=="svelte-dueo05"&&(l.innerHTML=r),t=c(p),f(o.$$.fragment,p)},m(p,m){n(p,l,m),n(p,t,m),h(o,p,m),i=!0},p:Q,i(p){i||(w(o.$$.fragment,p),i=!0)},o(p){b(o.$$.fragment,p),i=!1},d(p){p&&(s(l),s(t)),j(o,p)}}}function Ut(V){let l,r,t,o;return l=new Ge({props:{id:"spec-decoding",option:"greedy search",$$slots:{default:[dt]},$$scope:{ctx:V}}}),t=new Ge({props:{id:"spec-decoding",option:"sampling",$$slots:{default:[Tt]},$$scope:{ctx:V}}}),{c(){u(l.$$.fragment),r=M(),u(t.$$.fragment)},l(i){f(l.$$.fragment,i),r=c(i),f(t.$$.fragment,i)},m(i,p){h(l,i,p),n(i,r,p),h(t,i,p),o=!0},p(i,p){const m={};p&2&&(m.$$scope={dirty:p,ctx:i}),l.$set(m);const Z={};p&2&&(Z.$$scope={dirty:p,ctx:i}),t.$set(Z)},i(i){o||(w(l.$$.fragment,i),w(t.$$.fragment,i),o=!0)},o(i){b(l.$$.fragment,i),b(t.$$.fragment,i),o=!1},d(i){i&&s(r),j(l,i),j(t,i)}}}function ut(V){let l,r;return l=new W({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xLjNiJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUaGUlMjBzZWNvbmQlMjBsYXclMjBvZiUyMHRoZXJtb2R5bmFtaWNzJTIwc3RhdGVzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oZGV2aWNlKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpLnRvKGRldmljZSklMEFhc3Npc3RhbnRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMTI1bSUyMikudG8oZGV2aWNlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHByb21wdF9sb29rdXBfbnVtX3Rva2VucyUzRDMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSU1QidUaGUlMjBzZWNvbmQlMjBsYXclMjBvZiUyMHRoZXJtb2R5bmFtaWNzJTIwc3RhdGVzJTIwdGhhdCUyMGVudHJvcHklMjBpbmNyZWFzZXMlMjB3aXRoJTIwdGVtcGVyYXR1cmUuJTIwJTIwJTIwJTIwJTIwJTIwJyU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;The second law of thermodynamics states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>).to(device)
assistant_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>).to(device)
outputs = model.generate(**inputs, prompt_lookup_num_tokens=<span class="hljs-number">3</span>)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;The second law of thermodynamics states that entropy increases with temperature.      &#x27;</span>]`,wrap:!1}}),{c(){u(l.$$.fragment)},l(t){f(l.$$.fragment,t)},m(t,o){h(l,t,o),r=!0},p:Q,i(t){r||(w(l.$$.fragment,t),r=!0)},o(t){b(l.$$.fragment,t),r=!1},d(t){j(l,t)}}}function ft(V){let l,r='샘플링과 함께 프롬프트 조회 디코딩을 사용하려면, <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> 메서드에 <code>do_sample</code> 및 <code>temperature</code> 매개변수를 추가하십시오.',t,o,i;return o=new W({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0xLjNiJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUaGUlMjBzZWNvbmQlMjBsYXclMjBvZiUyMHRoZXJtb2R5bmFtaWNzJTIwc3RhdGVzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oZGV2aWNlKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIpLnRvKGRldmljZSklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBwcm9tcHRfbG9va3VwX251bV90b2tlbnMlM0QzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMHRlbXBlcmF0dXJlJTNEMC43KSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElNUIlMjJUaGUlMjBzZWNvbmQlMjBsYXclMjBvZiUyMHRoZXJtb2R5bmFtaWNzJTIwc3RhdGVzJTIwdGhhdCUyMGVuZXJneSUyMGNhbm5vdCUyMGJlJTIwY3JlYXRlZCUyMG5vciUyMGRlc3Ryb3llZC4lMjBJdCdzJTIwbm90JTIwYSUyMiU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;The second law of thermodynamics states&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>).to(device)
outputs = model.generate(**inputs, prompt_lookup_num_tokens=<span class="hljs-number">3</span>, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.7</span>)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&quot;The second law of thermodynamics states that energy cannot be created nor destroyed. It&#x27;s not a&quot;</span>]`,wrap:!1}}),{c(){l=d("p"),l.innerHTML=r,t=M(),u(o.$$.fragment)},l(p){l=T(p,"P",{"data-svelte-h":!0}),U(l)!=="svelte-1q3v49f"&&(l.innerHTML=r),t=c(p),f(o.$$.fragment,p)},m(p,m){n(p,l,m),n(p,t,m),h(o,p,m),i=!0},p:Q,i(p){i||(w(o.$$.fragment,p),i=!0)},o(p){b(o.$$.fragment,p),i=!1},d(p){p&&(s(l),s(t)),j(o,p)}}}function ht(V){let l,r,t,o;return l=new Ge({props:{id:"pld",option:"greedy decoding",$$slots:{default:[ut]},$$scope:{ctx:V}}}),t=new Ge({props:{id:"pld",option:"sampling",$$slots:{default:[ft]},$$scope:{ctx:V}}}),{c(){u(l.$$.fragment),r=M(),u(t.$$.fragment)},l(i){f(l.$$.fragment,i),r=c(i),f(t.$$.fragment,i)},m(i,p){h(l,i,p),n(i,r,p),h(t,i,p),o=!0},p(i,p){const m={};p&2&&(m.$$scope={dirty:p,ctx:i}),l.$set(m);const Z={};p&2&&(Z.$$scope={dirty:p,ctx:i}),t.$set(Z)},i(i){o||(w(l.$$.fragment,i),w(t.$$.fragment,i),o=!0)},o(i){b(l.$$.fragment,i),b(t.$$.fragment,i),o=!1},d(i){i&&s(r),j(l,i),j(t,i)}}}function wt(V){let l,r="SDPA는 최신 PyTorch 버전이 설치되어 있으면 FlashAttention-2도 지원합니다.";return{c(){l=d("p"),l.textContent=r},l(t){l=T(t,"P",{"data-svelte-h":!0}),U(l)!=="svelte-1yx0a1x"&&(l.textContent=r)},m(t,o){n(t,l,o)},p:Q,d(t){t&&s(l)}}}function bt(V){let l,r='다양한 양자화 라이브러리(자세한 내용은 <a href="./quantization">Quantization</a> 가이드를 참조하십시오)가 있습니다. 여기에는 Quanto, AQLM, VPTQ, AWQ 및 AutoGPTQ가 포함됩니다. 사용 사례에 가장 잘 맞는 라이브러리를 사용해 보십시오. 또한 AutoGPTQ와 bitsandbytes를 비교하는 <a href="https://hf.co/blog/overview-quantization-transformers" rel="nofollow">Overview of natively supported quantization schemes in 🤗 Transformers</a> 블로그 게시물을 읽어보는 것을 추천합니다.';return{c(){l=d("p"),l.innerHTML=r},l(t){l=T(t,"P",{"data-svelte-h":!0}),U(l)!=="svelte-2xoxfl"&&(l.innerHTML=r)},m(t,o){n(t,l,o)},p:Q,d(t){t&&s(l)}}}function jt(V){let l,r,t,o,i,p,m,Z="대규모 언어 모델(LLM)은 채팅 및 코드 완성 모델과 같은 텍스트 생성 응용 프로그램을 한 단계 끌어올리며, 높은 수준의 이해력과 유창함을 보여주는 텍스트를 생성합니다. 그러나 LLM을 강력하게 만드는 요소인 그들의 크기는 동시에 추론 과정에서 도전 과제가 되기도 합니다.",$,I,_="기본적인 추론은 느립니다, 왜냐하면 LLM이 다음 토큰을 생성하기 위해 반복적으로 호출되어야 하기 때문입니다. 생성이 진행됨에 따라 입력 시퀀스가 길어져 처리 시간이 점점 길어집니다. 또한, LLM은 수십억 개의 매개변수를 가지고 있어 모든 가중치를 메모리에 저장하고 처리하는 데 어려움이 있습니다.",C,G,F="이 가이드는 LLM 추론을 가속하기 위해 Transformers에서 사용할 수 있는 최적화 기술을 사용하는 방법을 보여줍니다.",v,B,X,k,g,y,J="디코딩 중에 LLM은 각 입력 토큰에 대한 key-value(kv) 값을 계산합니다. LLM은 자기회귀(autoregressive)이기 때문에 생성된 출력이 현재 입력의 일부가 되어 매번 동일한 kv 값을 계산합니다. 이는 매번 동일한 kv 값을 다시 계산하기 때문에 효율적이지 않습니다.",R,N,hl='이를 최적화하기 위해, 이전 키(key)와 값(value)을 재계산하지 않고 저장하는 kv-cache를 사용할 수 있습니다. 그러나 kv-cache는 각 생성 단계에서 증가하며 동적이기 때문에 PyTorch 코드를 빠르고 최적화된 커널로 통합하는 강력한 최적화 도구인 <a href="./perf_torch_compile"><code>torch.compile</code></a>을 사용하는 데 제약이 있습니다.',_e,P,wl="<em>정적 kv-cache</em>는 최댓값을 미리 할당하여 이 문제를 해결하여 <code>torch.compile</code>과 결합할 수 있게 합니다. 이를 통해 최대 4배의 속도 향상이 가능합니다. 속도 향상은 모델 크기(더 큰 모델은 속도 향상이 적음)와 하드웨어에 따라 다를 수 있습니다.",ke,H,Be,ee,bl="작업의 복잡성에 따라 세 가지 방식의 정적 kv-cache 사용 방법이 있습니다:",ve,le,jl="<li>기본 사용법: <code>generation_config</code>에서 플래그를 설정하기만 하면 됩니다(권장);</li> <li>고급 사용법: 여러 번의 생성이나 맞춤형 생성 루프를 위해 캐시 객체를 처리합니다;</li> <li>고급 사용법: 단일 그래프가 필요한 경우, 전체 <code>generate</code> 함수를 하나의 그래프로 컴파일합니다.</li>",ge,te,Vl="올바른 탭을 선택하여 각 방법에 대한 추가 지침을 확인하세요.",Qe,S,We,Y,Xe,se,Fe,x,Ne,ae,Cl="자기 회귀의 또 다른 문제는 각 입력 토큰에 대해 순전파 중에 모델 가중치를 매번 로드해야 한다는 점입니다. 이는 수십억 개의 매개변수를 가진 LLM에는 느리고 번거롭습니다. 추정 디코딩(speculative decoding)은 더 작고 빠른 보조 모델을 사용하여 후보 토큰을 생성하고, 이를 큰 LLM이 단일 순전파에서 검증하여 이 속도 저하를 완화합니다. 검증된 토큰이 정확하다면, LLM은 본래 자체적으로 생성하는 것처럼 토큰을 얻을 수 있습니다. 전방 패스가 동일한 출력을 보장하기 때문에 정확도 저하가 없습니다.",Ee,ne,Zl="가장 큰 속도 향상을 얻기 위해, 보조 모델은 빠르게 토큰을 생성할 수 있도록 LLM보다 훨씬 작아야 합니다. 보조 모델과 LLM 모델은 토큰을 다시 인코딩하고 디코딩하지 않도록 동일한 토크나이저를 공유해야 합니다.",ze,A,He,oe,Il='보조 모델을 로드하고 이를 <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> 메서드에 전달하여 추정 디코딩을 활성화하십시오.',Se,L,Ye,ie,xe,pe,Gl="프롬프트 조회 디코딩은 탐욕 검색과 샘플링과도 호환되는 추정 디코딩의 변형입니다. 프롬프트 조회는 요약과 같은 입력 기반 작업에 특히 잘 작동합니다. 여기서는 프롬프트와 출력 간에 종종 겹치는 단어가 있습니다. 이러한 겹치는 n-그램이 LLM 후보 토큰으로 사용됩니다.",Ae,re,Rl='프롬프트 조회 디코딩을 활성화하려면 <code>prompt_lookup_num_tokens</code> 매개변수에 겹치는 토큰 수를 지정하십시오. 그런 다음 이 매개변수를 <a href="/docs/transformers/main/ko/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> 메서드에 전달할 수 있습니다.',Le,q,qe,Me,De,ce,$l="트랜스포머 모델의 알려진 문제는 셀프 어텐션 메커니즘이 입력 토큰 수와 함께 계산 및 메모리가 제곱으로 증가한다는 것입니다. 이 제한은 훨씬 더 긴 시퀀스를 처리하는 LLM에서는 더욱 커집니다. 이를 해결하기 위해 FlashAttention2 또는 PyTorch의 스케일된 점곱 어텐션을 사용해 보십시오. 이들은 더 메모리 효율적인 어텐션 구현으로 추론을 가속화할 수 있습니다.",Oe,Je,Ke,me,_l='FlashAttention과 <a href="./perf_infer_gpu_one#flashattention-2">FlashAttention-2</a>는 어텐션 계산을 더 작은 청크로 나누고 중간 읽기/쓰기 작업을 줄여 추론 속도를 높입니다. FlashAttention-2는 원래 FlashAttention 알고리즘을 개선하여 시퀀스 길이 차원에서도 병렬 처리를 수행하고 하드웨어에서 작업을 더 잘 분할하여 동기화 및 통신 오버헤드를 줄입니다.',Pe,ye,kl='FlashAttention-2를 사용하려면 <a href="/docs/transformers/main/ko/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> 메서드에서 <code>attn_implementation=&quot;flash_attention_2&quot;</code>를 설정하십시오.',el,de,ll,Te,tl,Ue,Bl="스케일된 점곱 어텐션(SDPA)는 PyTorch 2.0에서 자동으로 활성화되며, FlashAttention, xFormers, PyTorch의 C++ 구현을 지원합니다. SDPA는 CUDA 백엔드를 사용하는 경우 가장 성능이 좋은 어텐션 알고리즘을 선택합니다. 다른 백엔드에서는 SDPA가 PyTorch C++ 구현으로 기본 설정됩니다.",sl,D,al,ue,vl='세 가지 어텐션 알고리즘 중 하나를 명시적으로 활성화하거나 비활성화하려면 <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">torch.backends.cuda.sdp_kernel</a> 컨텍스트 관리자를 사용하십시오. 예를 들어 FlashAttention을 활성화하려면 <code>enable_flash=True</code>로 설정하십시오.',nl,fe,ol,he,il,we,gl="양자화는 LLM 가중치를 더 낮은 정밀도로 저장하여 크기를 줄입니다. 이는 메모리 사용량을 줄이며 GPU 메모리에 제약이 있는 경우 추론을 위해 LLM을 로드하는 것을 더 용이하게 합니다. GPU가 충분하다면, 모델을 양자화할 필요는 없습니다. 추가적인 양자화 및 양자화 해제 단계로 인해 약간의 지연이 발생할 수 있기 때문입니다(AWQ 및 융합 AWQ 모듈 제외).",pl,O,rl,be,Ql='아래의 모델 메모리 계산기를 사용하여 모델을 로드하는 데 필요한 메모리를 추정하고 비교해 보십시오. 예를 들어 <a href="https://huggingface.co/mistralai/Mistral-7B-v0.1" rel="nofollow">Mistral-7B-v0.1</a>를 로드하는 데 필요한 메모리를 추정해 보십시오.',Ml,E,Wl,cl,je,Xl='Mistral-7B-v0.1을 반정밀도로 로드하려면 <a href="/docs/transformers/main/ko/model_doc/auto#transformers.AutoModel.from_pretrained">from_pretrained()</a> 메서드에서 <code>torch_dtype</code> 매개변수를 <code>torch.bfloat16</code>으로 설정하십시오. 이 경우 13.74GB의 메모리가 필요합니다.',Jl,Ve,ml,Ce,Fl='추론을 위해 양자화된 모델(8비트 또는 4비트)을 로드하려면 <a href="https://hf.co/docs/bitsandbytes" rel="nofollow">bitsandbytes</a>를 사용하고 <code>load_in_4bit</code> 또는 <code>load_in_8bit</code> 매개변수를 <code>True</code>로 설정하십시오. 모델을 8비트로 로드하는 데는 6.87GB의 메모리만 필요합니다.',yl,Ze,dl,Ie,Tl,$e,Ul;return i=new K({props:{title:"LLM 추론 최적화",local:"llm-inference-optimization",headingTag:"h1"}}),B=new z({props:{warning:!1,$$slots:{default:[at]},$$scope:{ctx:V}}}),k=new K({props:{title:"정적 kv-cache와 torch.compile",local:"static-kv-cache-and-torchcompile",headingTag:"h2"}}),H=new z({props:{warning:!0,$$slots:{default:[nt]},$$scope:{ctx:V}}}),S=new z({props:{warning:!1,$$slots:{default:[ot]},$$scope:{ctx:V}}}),Y=new fl({props:{id:"static-kv",options:["basic usage: generation_config","advanced usage: control Static Cache","advanced usage: end-to-end generate compilation"],$$slots:{default:[Jt]},$$scope:{ctx:V}}}),se=new K({props:{title:"추정 디코딩",local:"speculative-decoding",headingTag:"h2"}}),x=new z({props:{warning:!1,$$slots:{default:[mt]},$$scope:{ctx:V}}}),A=new z({props:{warning:!0,$$slots:{default:[yt]},$$scope:{ctx:V}}}),L=new fl({props:{id:"spec-decoding",options:["greedy search","sampling"],$$slots:{default:[Ut]},$$scope:{ctx:V}}}),ie=new K({props:{title:"프롬프트 조회 디코딩",local:"prompt-lookup-decoding",headingTag:"h3"}}),q=new fl({props:{id:"pld",options:["greedy decoding","sampling"],$$slots:{default:[ht]},$$scope:{ctx:V}}}),Me=new K({props:{title:"어텐션 최적화",local:"attention-optimizations",headingTag:"h2"}}),Je=new K({props:{title:"FlashAttention-2",local:"flashattention-2",headingTag:"h3"}}),de=new W({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZ29vZ2xlJTJGZ2VtbWEtMmIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJmbGFzaF9hdHRlbnRpb25fMiUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

quant_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;google/gemma-2b&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.bfloat16,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
)`,wrap:!1}}),Te=new K({props:{title:"PyTorch 스케일된 점곱 어텐션(scaled dot product attention)",local:"pytorch-scaled-dot-product-attention",headingTag:"h3"}}),D=new z({props:{warning:!1,$$slots:{default:[wt]},$$scope:{ctx:V}}}),fe=new W({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJnb29nbGUlMkZnZW1tYS0yYiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEpJTBBJTBBd2l0aCUyMHRvcmNoLmJhY2tlbmRzLmN1ZGEuc2RwX2tlcm5lbChlbmFibGVfZmxhc2glM0RUcnVlJTJDJTIwZW5hYmxlX21hdGglM0RGYWxzZSUyQyUyMGVuYWJsZV9tZW1fZWZmaWNpZW50JTNERmFsc2UpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;google/gemma-2b&quot;</span>,
    torch_dtype=torch.bfloat16,
)

<span class="hljs-keyword">with</span> torch.backends.cuda.sdp_kernel(enable_flash=<span class="hljs-literal">True</span>, enable_math=<span class="hljs-literal">False</span>, enable_mem_efficient=<span class="hljs-literal">False</span>):
    outputs = model.generate(**inputs)`,wrap:!1}}),he=new K({props:{title:"양자화",local:"quantization",headingTag:"h2"}}),O=new z({props:{warning:!1,$$slots:{default:[bt]},$$scope:{ctx:V}}}),Ve=new W({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">import</span> torch

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)`,wrap:!1}}),Ze=new W({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, BitsAndBytesConfig
<span class="hljs-keyword">import</span> torch

quant_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, quantization_config=quant_config, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),Ie=new st({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ko/llm_optims.md"}}),{c(){l=d("meta"),r=M(),t=d("p"),o=M(),u(i.$$.fragment),p=M(),m=d("p"),m.textContent=Z,$=M(),I=d("p"),I.textContent=_,C=M(),G=d("p"),G.textContent=F,v=M(),u(B.$$.fragment),X=M(),u(k.$$.fragment),g=M(),y=d("p"),y.textContent=J,R=M(),N=d("p"),N.innerHTML=hl,_e=M(),P=d("p"),P.innerHTML=wl,ke=M(),u(H.$$.fragment),Be=M(),ee=d("p"),ee.textContent=bl,ve=M(),le=d("ol"),le.innerHTML=jl,ge=M(),te=d("p"),te.textContent=Vl,Qe=M(),u(S.$$.fragment),We=M(),u(Y.$$.fragment),Xe=M(),u(se.$$.fragment),Fe=M(),u(x.$$.fragment),Ne=M(),ae=d("p"),ae.textContent=Cl,Ee=M(),ne=d("p"),ne.textContent=Zl,ze=M(),u(A.$$.fragment),He=M(),oe=d("p"),oe.innerHTML=Il,Se=M(),u(L.$$.fragment),Ye=M(),u(ie.$$.fragment),xe=M(),pe=d("p"),pe.textContent=Gl,Ae=M(),re=d("p"),re.innerHTML=Rl,Le=M(),u(q.$$.fragment),qe=M(),u(Me.$$.fragment),De=M(),ce=d("p"),ce.textContent=$l,Oe=M(),u(Je.$$.fragment),Ke=M(),me=d("p"),me.innerHTML=_l,Pe=M(),ye=d("p"),ye.innerHTML=kl,el=M(),u(de.$$.fragment),ll=M(),u(Te.$$.fragment),tl=M(),Ue=d("p"),Ue.textContent=Bl,sl=M(),u(D.$$.fragment),al=M(),ue=d("p"),ue.innerHTML=vl,nl=M(),u(fe.$$.fragment),ol=M(),u(he.$$.fragment),il=M(),we=d("p"),we.textContent=gl,pl=M(),u(O.$$.fragment),rl=M(),be=d("p"),be.innerHTML=Ql,Ml=M(),E=d("iframe"),cl=M(),je=d("p"),je.innerHTML=Xl,Jl=M(),u(Ve.$$.fragment),ml=M(),Ce=d("p"),Ce.innerHTML=Fl,yl=M(),u(Ze.$$.fragment),dl=M(),u(Ie.$$.fragment),Tl=M(),$e=d("p"),this.h()},l(e){const a=lt("svelte-u9bgzb",document.head);l=T(a,"META",{name:!0,content:!0}),a.forEach(s),r=c(e),t=T(e,"P",{}),ul(t).forEach(s),o=c(e),f(i.$$.fragment,e),p=c(e),m=T(e,"P",{"data-svelte-h":!0}),U(m)!=="svelte-ikijop"&&(m.textContent=Z),$=c(e),I=T(e,"P",{"data-svelte-h":!0}),U(I)!=="svelte-lgr6n0"&&(I.textContent=_),C=c(e),G=T(e,"P",{"data-svelte-h":!0}),U(G)!=="svelte-18buelc"&&(G.textContent=F),v=c(e),f(B.$$.fragment,e),X=c(e),f(k.$$.fragment,e),g=c(e),y=T(e,"P",{"data-svelte-h":!0}),U(y)!=="svelte-1fmnpkw"&&(y.textContent=J),R=c(e),N=T(e,"P",{"data-svelte-h":!0}),U(N)!=="svelte-14rruly"&&(N.innerHTML=hl),_e=c(e),P=T(e,"P",{"data-svelte-h":!0}),U(P)!=="svelte-1s0aiak"&&(P.innerHTML=wl),ke=c(e),f(H.$$.fragment,e),Be=c(e),ee=T(e,"P",{"data-svelte-h":!0}),U(ee)!=="svelte-608bjv"&&(ee.textContent=bl),ve=c(e),le=T(e,"OL",{"data-svelte-h":!0}),U(le)!=="svelte-1jphkc4"&&(le.innerHTML=jl),ge=c(e),te=T(e,"P",{"data-svelte-h":!0}),U(te)!=="svelte-alzl50"&&(te.textContent=Vl),Qe=c(e),f(S.$$.fragment,e),We=c(e),f(Y.$$.fragment,e),Xe=c(e),f(se.$$.fragment,e),Fe=c(e),f(x.$$.fragment,e),Ne=c(e),ae=T(e,"P",{"data-svelte-h":!0}),U(ae)!=="svelte-xfh61h"&&(ae.textContent=Cl),Ee=c(e),ne=T(e,"P",{"data-svelte-h":!0}),U(ne)!=="svelte-q0jd9k"&&(ne.textContent=Zl),ze=c(e),f(A.$$.fragment,e),He=c(e),oe=T(e,"P",{"data-svelte-h":!0}),U(oe)!=="svelte-xru2io"&&(oe.innerHTML=Il),Se=c(e),f(L.$$.fragment,e),Ye=c(e),f(ie.$$.fragment,e),xe=c(e),pe=T(e,"P",{"data-svelte-h":!0}),U(pe)!=="svelte-2e74to"&&(pe.textContent=Gl),Ae=c(e),re=T(e,"P",{"data-svelte-h":!0}),U(re)!=="svelte-1lcp9y"&&(re.innerHTML=Rl),Le=c(e),f(q.$$.fragment,e),qe=c(e),f(Me.$$.fragment,e),De=c(e),ce=T(e,"P",{"data-svelte-h":!0}),U(ce)!=="svelte-dg6lyb"&&(ce.textContent=$l),Oe=c(e),f(Je.$$.fragment,e),Ke=c(e),me=T(e,"P",{"data-svelte-h":!0}),U(me)!=="svelte-1wj8lzh"&&(me.innerHTML=_l),Pe=c(e),ye=T(e,"P",{"data-svelte-h":!0}),U(ye)!=="svelte-9peo57"&&(ye.innerHTML=kl),el=c(e),f(de.$$.fragment,e),ll=c(e),f(Te.$$.fragment,e),tl=c(e),Ue=T(e,"P",{"data-svelte-h":!0}),U(Ue)!=="svelte-1pkp4tn"&&(Ue.textContent=Bl),sl=c(e),f(D.$$.fragment,e),al=c(e),ue=T(e,"P",{"data-svelte-h":!0}),U(ue)!=="svelte-1m2wes8"&&(ue.innerHTML=vl),nl=c(e),f(fe.$$.fragment,e),ol=c(e),f(he.$$.fragment,e),il=c(e),we=T(e,"P",{"data-svelte-h":!0}),U(we)!=="svelte-1nlhjc4"&&(we.textContent=gl),pl=c(e),f(O.$$.fragment,e),rl=c(e),be=T(e,"P",{"data-svelte-h":!0}),U(be)!=="svelte-hdeqf"&&(be.innerHTML=Ql),Ml=c(e),E=T(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),ul(E).forEach(s),cl=c(e),je=T(e,"P",{"data-svelte-h":!0}),U(je)!=="svelte-1ubbh59"&&(je.innerHTML=Xl),Jl=c(e),f(Ve.$$.fragment,e),ml=c(e),Ce=T(e,"P",{"data-svelte-h":!0}),U(Ce)!=="svelte-11tku4g"&&(Ce.innerHTML=Fl),yl=c(e),f(Ze.$$.fragment,e),dl=c(e),f(Ie.$$.fragment,e),Tl=c(e),$e=T(e,"P",{}),ul($e).forEach(s),this.h()},h(){Re(l,"name","hf:doc:metadata"),Re(l,"content",Vt),Ol(E.src,Wl="https://hf-accelerate-model-memory-usage.hf.space")||Re(E,"src",Wl),Re(E,"frameborder","0"),Re(E,"width","850"),Re(E,"height","450")},m(e,a){tt(document.head,l),n(e,r,a),n(e,t,a),n(e,o,a),h(i,e,a),n(e,p,a),n(e,m,a),n(e,$,a),n(e,I,a),n(e,C,a),n(e,G,a),n(e,v,a),h(B,e,a),n(e,X,a),h(k,e,a),n(e,g,a),n(e,y,a),n(e,R,a),n(e,N,a),n(e,_e,a),n(e,P,a),n(e,ke,a),h(H,e,a),n(e,Be,a),n(e,ee,a),n(e,ve,a),n(e,le,a),n(e,ge,a),n(e,te,a),n(e,Qe,a),h(S,e,a),n(e,We,a),h(Y,e,a),n(e,Xe,a),h(se,e,a),n(e,Fe,a),h(x,e,a),n(e,Ne,a),n(e,ae,a),n(e,Ee,a),n(e,ne,a),n(e,ze,a),h(A,e,a),n(e,He,a),n(e,oe,a),n(e,Se,a),h(L,e,a),n(e,Ye,a),h(ie,e,a),n(e,xe,a),n(e,pe,a),n(e,Ae,a),n(e,re,a),n(e,Le,a),h(q,e,a),n(e,qe,a),h(Me,e,a),n(e,De,a),n(e,ce,a),n(e,Oe,a),h(Je,e,a),n(e,Ke,a),n(e,me,a),n(e,Pe,a),n(e,ye,a),n(e,el,a),h(de,e,a),n(e,ll,a),h(Te,e,a),n(e,tl,a),n(e,Ue,a),n(e,sl,a),h(D,e,a),n(e,al,a),n(e,ue,a),n(e,nl,a),h(fe,e,a),n(e,ol,a),h(he,e,a),n(e,il,a),n(e,we,a),n(e,pl,a),h(O,e,a),n(e,rl,a),n(e,be,a),n(e,Ml,a),n(e,E,a),n(e,cl,a),n(e,je,a),n(e,Jl,a),h(Ve,e,a),n(e,ml,a),n(e,Ce,a),n(e,yl,a),h(Ze,e,a),n(e,dl,a),h(Ie,e,a),n(e,Tl,a),n(e,$e,a),Ul=!0},p(e,[a]){const Nl={};a&2&&(Nl.$$scope={dirty:a,ctx:e}),B.$set(Nl);const El={};a&2&&(El.$$scope={dirty:a,ctx:e}),H.$set(El);const zl={};a&2&&(zl.$$scope={dirty:a,ctx:e}),S.$set(zl);const Hl={};a&2&&(Hl.$$scope={dirty:a,ctx:e}),Y.$set(Hl);const Sl={};a&2&&(Sl.$$scope={dirty:a,ctx:e}),x.$set(Sl);const Yl={};a&2&&(Yl.$$scope={dirty:a,ctx:e}),A.$set(Yl);const xl={};a&2&&(xl.$$scope={dirty:a,ctx:e}),L.$set(xl);const Al={};a&2&&(Al.$$scope={dirty:a,ctx:e}),q.$set(Al);const Ll={};a&2&&(Ll.$$scope={dirty:a,ctx:e}),D.$set(Ll);const ql={};a&2&&(ql.$$scope={dirty:a,ctx:e}),O.$set(ql)},i(e){Ul||(w(i.$$.fragment,e),w(B.$$.fragment,e),w(k.$$.fragment,e),w(H.$$.fragment,e),w(S.$$.fragment,e),w(Y.$$.fragment,e),w(se.$$.fragment,e),w(x.$$.fragment,e),w(A.$$.fragment,e),w(L.$$.fragment,e),w(ie.$$.fragment,e),w(q.$$.fragment,e),w(Me.$$.fragment,e),w(Je.$$.fragment,e),w(de.$$.fragment,e),w(Te.$$.fragment,e),w(D.$$.fragment,e),w(fe.$$.fragment,e),w(he.$$.fragment,e),w(O.$$.fragment,e),w(Ve.$$.fragment,e),w(Ze.$$.fragment,e),w(Ie.$$.fragment,e),Ul=!0)},o(e){b(i.$$.fragment,e),b(B.$$.fragment,e),b(k.$$.fragment,e),b(H.$$.fragment,e),b(S.$$.fragment,e),b(Y.$$.fragment,e),b(se.$$.fragment,e),b(x.$$.fragment,e),b(A.$$.fragment,e),b(L.$$.fragment,e),b(ie.$$.fragment,e),b(q.$$.fragment,e),b(Me.$$.fragment,e),b(Je.$$.fragment,e),b(de.$$.fragment,e),b(Te.$$.fragment,e),b(D.$$.fragment,e),b(fe.$$.fragment,e),b(he.$$.fragment,e),b(O.$$.fragment,e),b(Ve.$$.fragment,e),b(Ze.$$.fragment,e),b(Ie.$$.fragment,e),Ul=!1},d(e){e&&(s(r),s(t),s(o),s(p),s(m),s($),s(I),s(C),s(G),s(v),s(X),s(g),s(y),s(R),s(N),s(_e),s(P),s(ke),s(Be),s(ee),s(ve),s(le),s(ge),s(te),s(Qe),s(We),s(Xe),s(Fe),s(Ne),s(ae),s(Ee),s(ne),s(ze),s(He),s(oe),s(Se),s(Ye),s(xe),s(pe),s(Ae),s(re),s(Le),s(qe),s(De),s(ce),s(Oe),s(Ke),s(me),s(Pe),s(ye),s(el),s(ll),s(tl),s(Ue),s(sl),s(al),s(ue),s(nl),s(ol),s(il),s(we),s(pl),s(rl),s(be),s(Ml),s(E),s(cl),s(je),s(Jl),s(ml),s(Ce),s(yl),s(dl),s(Tl),s($e)),s(l),j(i,e),j(B,e),j(k,e),j(H,e),j(S,e),j(Y,e),j(se,e),j(x,e),j(A,e),j(L,e),j(ie,e),j(q,e),j(Me,e),j(Je,e),j(de,e),j(Te,e),j(D,e),j(fe,e),j(he,e),j(O,e),j(Ve,e),j(Ze,e),j(Ie,e)}}}const Vt='{"title":"LLM 추론 최적화","local":"llm-inference-optimization","sections":[{"title":"정적 kv-cache와 torch.compile","local":"static-kv-cache-and-torchcompile","sections":[],"depth":2},{"title":"추정 디코딩","local":"speculative-decoding","sections":[{"title":"프롬프트 조회 디코딩","local":"prompt-lookup-decoding","sections":[],"depth":3}],"depth":2},{"title":"어텐션 최적화","local":"attention-optimizations","sections":[{"title":"FlashAttention-2","local":"flashattention-2","sections":[],"depth":3},{"title":"PyTorch 스케일된 점곱 어텐션(scaled dot product attention)","local":"pytorch-scaled-dot-product-attention","sections":[],"depth":3}],"depth":2},{"title":"양자화","local":"quantization","sections":[],"depth":2}],"depth":1}';function Ct(V){return Kl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class kt extends Pl{constructor(l){super(),et(this,l,Ct,jt,Dl,{})}}export{kt as component};
