import{s as Vs,o as Ns,n as ns}from"../chunks/scheduler.d586627e.js";import{S as As,i as qs,g as o,s as l,r as p,A as Ls,h as r,f as a,c as n,j as y,u as i,x as f,k as rt,y as $,a as s,v as m,d,t as c,w as u}from"../chunks/index.8589a59c.js";import{T as ls}from"../chunks/Tip.84e2336e.js";import{Y as Ka}from"../chunks/Youtube.49101e7b.js";import{C as g}from"../chunks/CodeBlock.dffc9a5b.js";import{D as Qs}from"../chunks/DocNotebookDropdown.5cbb20c5.js";import{H as b,E as Ss}from"../chunks/index.fd9d4aff.js";function Ps(v){let h,j=`Você verá um alerta sobre alguns pesos pré-treinados que não estão sendo utilizados e que alguns pesos estão
sendo inicializados aleatoriamente. Não se preocupe, essa mensagem é completamente normal.
O header/cabeçário pré-treinado do modelo BERT é descartado e substitui-se por um header de classificação
inicializado aleatoriamente. Assim, pode aplicar o fine-tuning a este novo header do modelo em sua tarefa
de classificação de sequências fazendo um transfer learning do modelo pré-treinado.`;return{c(){h=o("p"),h.textContent=j},l(M){h=r(M,"P",{"data-svelte-h":!0}),f(h)!=="svelte-ejxvym"&&(h.textContent=j)},m(M,T){s(M,h,T)},p:ns,d(M){M&&a(h)}}}function Ds(v){let h,j=`O <code>Trainer</code> utiliza <code>DataCollatorWithPadding</code> por padrão, então você não precisa especificar explicitamente um
colador de dados (data collator).`;return{c(){h=o("p"),h.innerHTML=j},l(M){h=r(M,"P",{"data-svelte-h":!0}),f(h)!=="svelte-hfa5bk"&&(h.innerHTML=j)},m(M,T){s(M,h,T)},p:ns,d(M){M&&a(h)}}}function Ks(v){let h,j=`Se necessário, você pode obter o acesso gratuito a uma GPU na núvem por meio de um notebook no
<a href="https://colab.research.google.com/" rel="nofollow">Colaboratory</a> ou <a href="https://studiolab.sagemaker.aws/" rel="nofollow">SageMaker StudioLab</a>
se não tiver esse recurso de forma local.`;return{c(){h=o("p"),h.innerHTML=j},l(M){h=r(M,"P",{"data-svelte-h":!0}),f(h)!=="svelte-ivn2a7"&&(h.innerHTML=j)},m(M,T){s(M,h,T)},p:ns,d(M){M&&a(h)}}}function Os(v){let h,j,M,T,U,Mt,C,bt,I,os=`O uso de um modelo pré-treinado tem importantes vantagens. Redução do custo computacional, a pegada de carbono, e te
permite utilizar modelos de última geração sem ter que treinar um novo desde o início.
O 🤗 Transformers proporciona acesso a milhares de modelos pré-treinados numa ampla gama de tarefas.
Quando utilizar um modelo pré-treinado, treine-o com um dataset específico para a sua tarefa.
Isto é chamado de fine-tuning, uma técnica de treinamento incrivelmente poderosa. Neste tutorial faremos o fine-tuning
de um modelo pré-treinado com um framework de Deep Learning da sua escolha:`,jt,R,rs="<li>Fine-tuning de um modelo pré-treinado com o 🤗 Transformers <code>Trainer</code>.</li> <li>Fine-tuning de um modelo pré-treinado no TensorFlow com o Keras.</li> <li>Fine-tuning de um modelo pré-treinado em PyTorch nativo.</li>",$t,pt,yt,G,Tt,W,wt,X,ps=`Antes de aplicar o fine-tuning a um modelo pré-treinado, baixe um dataset e prepare-o para o treinamento.
O tutorial anterior ensinará a processar os dados para o treinamento, e então poderá ter a oportunidade de testar
esse novo conhecimento em algo prático.`,Jt,z,is='Comece carregando o dataset <a href="https://huggingface.co/datasets/yelp_review_full" rel="nofollow">Yelp Reviews</a>:',vt,F,kt,x,ms=`Como já sabe, é necessário ter um tokenizador para processar o texto e incluir uma estratégia de padding e truncamento,
para manejar qualquer tamanho varíavel de sequência. Para processar o seu dataset em apenas um passo, utilize o método de
🤗 Datasets <a href="https://huggingface.co/docs/datasets/process#map" rel="nofollow"><code>map</code></a> para aplicar uma função de preprocessamento sobre
todo o dataset.`,Zt,E,_t,B,ds="Se desejar, é possível criar um subconjunto menor do dataset completo para aplicar o fine-tuning e assim reduzir o tempo necessário.",Ut,Y,Ct,it,It,H,Rt,V,Gt,N,cs=`O 🤗 Transformers proporciona uma classe <code>Trainer</code> otimizada para o treinamento de modelos de 🤗 Transformers,
facilitando os primeiros passos do treinamento sem a necessidade de escrever manualmente o seu próprio ciclo.
A API do <code>Trainer</code> suporta um grande conjunto de opções de treinamento e funcionalidades, como o logging,
o gradient accumulation e o mixed precision.`,Wt,A,us=`Comece carregando seu modelo e especifique o número de labels de previsão.
A partir do <a href="https://huggingface.co/datasets/yelp_review_full#data-fields" rel="nofollow">Card Dataset</a> do Yelp Reveiw, que ja
sabemos ter 5 labels usamos o seguinte código:`,Xt,q,zt,k,Ft,L,xt,Q,fs=`Em seguida, crie uma classe <code>TrainingArguments</code> que contenha todos os hiperparâmetros que possam ser ajustados, assim
como os indicadores para ativar as diferentes opções de treinamento. Para este tutorial, você pode começar o treinamento
usando os <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">hiperparámetros</a> padrão,
porém, sinta-se livre para experimentar com eles e encontrar uma configuração ótima.`,Et,S,hs="Especifique onde salvar os checkpoints do treinamento:",Bt,P,Yt,D,Ht,K,gs=`O <code>Trainer</code> não avalia automaticamente o rendimento do modelo durante o treinamento. Será necessário passar ao
<code>Trainer</code> uma função para calcular e fazer um diagnóstico sobre as métricas. A biblioteca 🤗 Datasets proporciona
uma função de <a href="https://huggingface.co/metrics/accuracy" rel="nofollow"><code>accuracy</code></a> simples que pode ser carregada com a função
<code>load_metric</code> (ver este <a href="https://huggingface.co/docs/datasets/metrics" rel="nofollow">tutorial</a> para mais informações):`,Vt,O,Nt,ee,Ms=`Defina a função <code>compute</code> dentro de <code>metric</code> para calcular a precisão das suas predições.
Antes de passar as suas predições ao <code>compute</code>, é necessário converter as predições à logits (lembre-se que
todos os modelos de 🤗 Transformers retornam logits).`,At,te,qt,ae,bs=`Se quiser controlar as suas métricas de avaliação durante o fine-tuning, especifique o parâmetro <code>eval_strategy</code>
nos seus argumentos de treinamento para que o modelo considere a métrica de avaliação ao final de cada época:`,Lt,se,Qt,le,St,ne,js="Crie um objeto <code>Trainer</code> com o seu modelo, argumentos de treinamento, conjuntos de dados de treinamento e de teste, e a sua função de avaliação:",Pt,oe,Dt,re,$s="Em seguida, aplique o fine-tuning a seu modelo chamado <code>train()</code>:",Kt,pe,Ot,mt,ea,ie,ta,me,aa,de,ys=`Os modelos de 🤗 Transformers também permitem realizar o treinamento com o TensorFlow com a API do Keras.
Contudo, será necessário fazer algumas mudanças antes de realizar o fine-tuning.`,sa,ce,la,ue,Ts=`O <code>DefaultDataCollator</code> junta os tensores em um batch para que o modelo possa ser treinado em cima deles.
Assegure-se de especificar os <code>return_tensors</code> para retornar os tensores do TensorFlow:`,na,fe,oa,Z,ra,he,ws=`Em seguida, converta os datasets tokenizados em datasets do TensorFlow com o método
<a href="https://huggingface.co/docs/datasets/package_reference/main_classes#datasets.Dataset.to_tf_dataset" rel="nofollow"><code>to_tf_dataset</code></a>.
Especifique suas entradas em <code>columns</code> e seu rótulo em <code>label_cols</code>:`,pa,ge,ia,Me,ma,be,Js="Carregue um modelo do TensorFlow com o número esperado de rótulos:",da,je,ca,$e,vs=`A seguir, compile e ajuste o fine-tuning a seu modelo com <a href="https://keras.io/api/models/model_training_apis/" rel="nofollow"><code>fit</code></a> como
faria com qualquer outro modelo do Keras:`,ua,ye,fa,dt,ha,Te,ga,we,Ma,Je,ks=`O <code>Trainer</code> se encarrega do ciclo de treinamento e permite aplicar o fine-tuning a um modelo em uma linha de código apenas.
Para os usuários que preferirem escrever o seu próprio ciclo de treinamento, também é possível aplicar o fine-tuning a um
modelo de 🤗 Transformers em PyTorch nativo.`,ba,ve,Zs=`Neste momento, talvez ocorra a necessidade de reinicar seu notebook ou executar a seguinte linha de código para liberar
memória:`,ja,ke,$a,Ze,_s="Em sequência, faremos um post-processing manual do <code>tokenized_dataset</code> e assim prepará-lo para o treinamento.",ya,w,_e,ct,Us="Apague a coluna de <code>text</code> porque o modelo não aceita texto cru como entrada:",Oa,Ue,es,Ce,ut,Cs="Troque o nome da coluna <code>label</code> para <code>labels</code>, pois o modelo espera um argumento de mesmo nome:",ts,Ie,as,Re,ft,Is="Defina o formato do dataset para retornar tensores do PyTorch no lugar de listas:",ss,Ge,Ta,We,Rs="Em sequência, crie um subconjunto menor do dataset, como foi mostrado anteriormente, para acelerá-lo o fine-tuning.",wa,Xe,Ja,ze,va,Fe,Gs="Crie um <code>DataLoader</code> para os seus datasets de treinamento e de teste para poder iterar sobre batches de dados:",ka,xe,Za,Ee,Ws="Carregue seu modelo com o número de labels esperados:",_a,Be,Ua,Ye,Ca,He,Xs=`Crie um otimizador e um learning rate para aplicar o fine-tuning ao modelo.
Iremos utilizar o otimizador <a href="https://pytorch.org/docs/stable/generated/torch.optim.AdamW.html" rel="nofollow"><code>AdamW</code></a> do PyTorch:`,Ia,Ve,Ra,Ne,zs="Defina o learning rate do <code>Trainer</code>:",Ga,Ae,Wa,qe,Fs=`Por último, especifique o <code>device</code> do ambiente para utilizar uma GPU se tiver acesso à alguma. Caso contrário, o treinamento
em uma CPU pode acabar levando várias horas em vez de minutos.`,Xa,Le,za,_,Fa,Qe,xs="Perfeito, agora estamos prontos para começar o treinamento! 🥳",xa,Se,Ea,Pe,Es=`Para visualizar melhor o processo de treinamento, utilize a biblioteca <a href="https://tqdm.github.io/" rel="nofollow">tqdm</a> para adicionar
uma barra de progresso sobre o número de passos percorridos no treinamento atual:`,Ba,De,Ya,Ke,Ha,Oe,Bs=`Da mesma forma que é necessário adicionar uma função de avaliação ao <code>Trainer</code>, é necessário fazer o mesmo quando
escrevendo o próprio ciclo de treinamento. Contudo, em vez de calcular e retornar a métrica final de cada época,
você deverá adicionar todos os batches com <a href="https://huggingface.co/docs/datasets/package_reference/main_classes?highlight=add_batch#datasets.Metric.add_batch" rel="nofollow"><code>add_batch</code></a>
e calcular a métrica apenas no final.`,Va,et,Na,ht,Aa,tt,qa,at,Ys="Para mais exemplos de fine-tuning acesse:",La,st,Hs=`<li><p><a href="https://github.com/huggingface/transformers/tree/main/examples" rel="nofollow">🤗 Transformers Examples</a> inclui scripts
para treinas tarefas comuns de NLP em PyTorch e TensorFlow.</p></li> <li><p><a href="notebooks">🤗 Transformers Notebooks</a> contém vários notebooks sobre como aplicar o fine-tuning a um modelo
para tarefas específicas no PyTorch e TensorFlow.</p></li>`,Qa,lt,Sa,gt,Pa;return U=new b({props:{title:"Fine-tuning de um modelo pré-treinado",local:"fine-tuning-de-um-modelo-pré-treinado",headingTag:"h1"}}),C=new Qs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/pt/training.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/pt/pytorch/training.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/pt/tensorflow/training.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/pt/training.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/pt/pytorch/training.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/pt/tensorflow/training.ipynb"}]}}),G=new b({props:{title:"Preparando um dataset",local:"preparando-um-dataset",headingTag:"h2"}}),W=new Ka({props:{id:"_BZearw7f0w"}}),F=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ5ZWxwX3Jldmlld19mdWxsJTIyKSUwQWRhdGFzZXQlNUIxMDAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;yelp_review_full&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">100</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;My expectations for McDonalds are t rarely high. But for one to still fail so spectacularly...that takes something special!\\\\nThe cashier took my friends\\&#x27;s order, then promptly ignored me. I had to force myself in front of a cashier who opened his register to wait on the person BEHIND me. I waited over five minutes for a gigantic order that included precisely one kid\\&#x27;s meal. After watching two people who ordered after me be handed their food, I asked where mine was. The manager started yelling at the cashiers for \\\\&quot;serving off their orders\\\\&quot; when they didn\\&#x27;t have their food. But neither cashier was anywhere near those controls, and the manager was the one serving food to customers and clearing the boards.\\\\nThe manager was rude when giving me my order. She didn\\&#x27;t make sure that I had everything ON MY RECEIPT, and never even had the decency to apologize that I felt I was getting poor service.\\\\nI\\&#x27;ve eaten at various McDonalds restaurants for over 30 years. I\\&#x27;ve worked at more than one location. I expect bad days, bad moods, and the occasional mistake. But I have yet to have a decent experience at this store. It will remain a place I avoid unless someone in my party needs to avoid illness from low blood sugar. Perhaps I should go back to the racially biased service of Steak n Shake instead!&#x27;</span>}`,wrap:!1}}),E=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMEFkZWYlMjB0b2tlbml6ZV9mdW5jdGlvbihleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjB0b2tlbml6ZXIoZXhhbXBsZXMlNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSklMEElMEElMEF0b2tlbml6ZWRfZGF0YXNldHMlMjAlM0QlMjBkYXRhc2V0Lm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;text&quot;</span>], padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_datasets = dataset.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)`,wrap:!1}}),Y=new g({props:{code:"c21hbGxfdHJhaW5fZGF0YXNldCUyMCUzRCUyMHRva2VuaXplZF9kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVELnNodWZmbGUoc2VlZCUzRDQyKS5zZWxlY3QocmFuZ2UoMTAwMCkpJTBBc21hbGxfZXZhbF9kYXRhc2V0JTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydGVzdCUyMiU1RC5zaHVmZmxlKHNlZWQlM0Q0Mikuc2VsZWN0KHJhbmdlKDEwMDApKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>small_train_dataset = tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>small_eval_dataset = tokenized_datasets[<span class="hljs-string">&quot;test&quot;</span>].shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))`,wrap:!1}}),H=new b({props:{title:"Fine-tuning com o Trainer",local:"fine-tuning-com-o-trainer",headingTag:"h2"}}),V=new Ka({props:{id:"nvBXf7s7vTI"}}),q=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwbnVtX2xhYmVscyUzRDUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, num_labels=<span class="hljs-number">5</span>)`,wrap:!1}}),k=new ls({props:{$$slots:{default:[Ps]},$$scope:{ctx:v}}}),L=new b({props:{title:"Hiperparâmetros de treinamento",local:"hiperparâmetros-de-treinamento",headingTag:"h3"}}),P=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKG91dHB1dF9kaXIlM0QlMjJ0ZXN0X3RyYWluZXIlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(output_dir=<span class="hljs-string">&quot;test_trainer&quot;</span>)`,wrap:!1}}),D=new b({props:{title:"Métricas",local:"métricas",headingTag:"h3"}}),O=new g({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9tZXRyaWMlMEElMEFtZXRyaWMlMjAlM0QlMjBsb2FkX21ldHJpYyglMjJhY2N1cmFjeSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_metric

<span class="hljs-meta">&gt;&gt;&gt; </span>metric = load_metric(<span class="hljs-string">&quot;accuracy&quot;</span>)`,wrap:!1}}),te=new g({props:{code:"ZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMkMlMjBsYWJlbHMlMjAlM0QlMjBldmFsX3ByZWQlMEElMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyMCUzRCUyMG5wLmFyZ21heChsb2dpdHMlMkMlMjBheGlzJTNELTEpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbWV0cmljLmNvbXB1dGUocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RsYWJlbHMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
<span class="hljs-meta">... </span>    logits, labels = eval_pred
<span class="hljs-meta">... </span>    predictions = np.argmax(logits, axis=-<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)`,wrap:!1}}),se=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKG91dHB1dF9kaXIlM0QlMjJ0ZXN0X3RyYWluZXIlMjIlMkMlMjBldmFsX3N0cmF0ZWd5JTNEJTIyZXBvY2glMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(output_dir=<span class="hljs-string">&quot;test_trainer&quot;</span>, eval_strategy=<span class="hljs-string">&quot;epoch&quot;</span>)`,wrap:!1}}),le=new b({props:{title:"Trainer",local:"trainer",headingTag:"h3"}}),oe=new g({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHNtYWxsX3RyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RzbWFsbF9ldmFsX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    train_dataset=small_train_dataset,
<span class="hljs-meta">... </span>    eval_dataset=small_eval_dataset,
<span class="hljs-meta">... </span>    compute_metrics=compute_metrics,
<span class="hljs-meta">... </span>)`,wrap:!1}}),pe=new g({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()',wrap:!1}}),ie=new b({props:{title:"Fine-tuning com Keras",local:"fine-tuning-com-keras",headingTag:"h2"}}),me=new Ka({props:{id:"rnTGBy2ax1c"}}),ce=new b({props:{title:"Conversão do dataset ao formato do TensorFlow",local:"conversão-do-dataset-ao-formato-do-tensorflow",headingTag:"h3"}}),fe=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlZmF1bHREYXRhQ29sbGF0b3IlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGVmYXVsdERhdGFDb2xsYXRvcihyZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DefaultDataCollator

<span class="hljs-meta">&gt;&gt;&gt; </span>data_collator = DefaultDataCollator(return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)`,wrap:!1}}),Z=new ls({props:{$$slots:{default:[Ds]},$$scope:{ctx:v}}}),ge=new g({props:{code:"dGZfdHJhaW5fZGF0YXNldCUyMCUzRCUyMHNtYWxsX3RyYWluX2RhdGFzZXQudG9fdGZfZGF0YXNldCglMEElMjAlMjAlMjAlMjBjb2x1bW5zJTNEJTVCJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJpbnB1dF9pZHMlMjIlMkMlMjAlMjJ0b2tlbl90eXBlX2lkcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsX2NvbHMlM0QlMjJsYWJlbHMlMjIlMkMlMEElMjAlMjAlMjAlMjBzaHVmZmxlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGNvbGxhdGVfZm4lM0RkYXRhX2NvbGxhdG9yJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzRDglMkMlMEEpJTBBJTBBdGZfdmFsaWRhdGlvbl9kYXRhc2V0JTIwJTNEJTIwc21hbGxfZXZhbF9kYXRhc2V0LnRvX3RmX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwY29sdW1ucyUzRCU1QiUyMmF0dGVudGlvbl9tYXNrJTIyJTJDJTIwJTIyaW5wdXRfaWRzJTIyJTJDJTIwJTIydG9rZW5fdHlwZV9pZHMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBsYWJlbF9jb2xzJTNEJTIybGFiZWxzJTIyJTJDJTBBJTIwJTIwJTIwJTIwc2h1ZmZsZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwY29sbGF0ZV9mbiUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>tf_train_dataset = small_train_dataset.to_tf_dataset(
<span class="hljs-meta">... </span>    columns=[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>],
<span class="hljs-meta">... </span>    label_cols=<span class="hljs-string">&quot;labels&quot;</span>,
<span class="hljs-meta">... </span>    shuffle=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    collate_fn=data_collator,
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tf_validation_dataset = small_eval_dataset.to_tf_dataset(
<span class="hljs-meta">... </span>    columns=[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>],
<span class="hljs-meta">... </span>    label_cols=<span class="hljs-string">&quot;labels&quot;</span>,
<span class="hljs-meta">... </span>    shuffle=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    collate_fn=data_collator,
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),Me=new b({props:{title:"Compilação e ajustes",local:"compilação-e-ajustes",headingTag:"h3"}}),je=new g({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVEZBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwbnVtX2xhYmVscyUzRDUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TFAutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, num_labels=<span class="hljs-number">5</span>)`,wrap:!1}}),ye=new g({props:{code:"bW9kZWwuY29tcGlsZSglMEElMjAlMjAlMjAlMjBvcHRpbWl6ZXIlM0R0Zi5rZXJhcy5vcHRpbWl6ZXJzLkFkYW0obGVhcm5pbmdfcmF0ZSUzRDVlLTUpJTJDJTBBJTIwJTIwJTIwJTIwbG9zcyUzRHRmLmtlcmFzLmxvc3Nlcy5TcGFyc2VDYXRlZ29yaWNhbENyb3NzZW50cm9weShmcm9tX2xvZ2l0cyUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwbWV0cmljcyUzRHRmLm1ldHJpY3MuU3BhcnNlQ2F0ZWdvcmljYWxBY2N1cmFjeSgpJTJDJTBBKSUwQSUwQW1vZGVsLmZpdCh0Zl90cmFpbl9kYXRhc2V0JTJDJTIwdmFsaWRhdGlvbl9kYXRhJTNEdGZfdmFsaWRhdGlvbl9kYXRhc2V0JTJDJTIwZXBvY2hzJTNEMyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">compile</span>(
<span class="hljs-meta">... </span>    optimizer=tf.keras.optimizers.Adam(learning_rate=<span class="hljs-number">5e-5</span>),
<span class="hljs-meta">... </span>    loss=tf.keras.losses.SparseCategoricalCrossentropy(from_logits=<span class="hljs-literal">True</span>),
<span class="hljs-meta">... </span>    metrics=tf.metrics.SparseCategoricalAccuracy(),
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model.fit(tf_train_dataset, validation_data=tf_validation_dataset, epochs=<span class="hljs-number">3</span>)`,wrap:!1}}),Te=new b({props:{title:"Fine-tune em PyTorch nativo",local:"fine-tune-em-pytorch-nativo",headingTag:"h2"}}),we=new Ka({props:{id:"Dh9CL8fyG80"}}),ke=new g({props:{code:"ZGVsJTIwbW9kZWwlMEFkZWwlMjBweXRvcmNoX21vZGVsJTBBZGVsJTIwdHJhaW5lciUwQXRvcmNoLmN1ZGEuZW1wdHlfY2FjaGUoKQ==",highlighted:`<span class="hljs-keyword">del</span> model
<span class="hljs-keyword">del</span> pytorch_model
<span class="hljs-keyword">del</span> trainer
torch.cuda.empty_cache()`,wrap:!1}}),Ue=new g({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzLnJlbW92ZV9jb2x1bW5zKCU1QiUyMnRleHQlMjIlNUQp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_datasets = tokenized_datasets.remove_columns([<span class="hljs-string">&quot;text&quot;</span>])',wrap:!1}}),Ie=new g({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzLnJlbmFtZV9jb2x1bW4oJTIybGFiZWwlMjIlMkMlMjAlMjJsYWJlbHMlMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_datasets = tokenized_datasets.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)',wrap:!1}}),Ge=new g({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzLnNldF9mb3JtYXQoJTIydG9yY2glMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_datasets.set_format(<span class="hljs-string">&quot;torch&quot;</span>)',wrap:!1}}),Xe=new g({props:{code:"c21hbGxfdHJhaW5fZGF0YXNldCUyMCUzRCUyMHRva2VuaXplZF9kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVELnNodWZmbGUoc2VlZCUzRDQyKS5zZWxlY3QocmFuZ2UoMTAwMCkpJTBBc21hbGxfZXZhbF9kYXRhc2V0JTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydGVzdCUyMiU1RC5zaHVmZmxlKHNlZWQlM0Q0Mikuc2VsZWN0KHJhbmdlKDEwMDApKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>small_train_dataset = tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>small_eval_dataset = tokenized_datasets[<span class="hljs-string">&quot;test&quot;</span>].shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))`,wrap:!1}}),ze=new b({props:{title:"DataLoader",local:"dataloader",headingTag:"h3"}}),xe=new g({props:{code:"ZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBJTBBdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoc21hbGxfdHJhaW5fZGF0YXNldCUyQyUyMHNodWZmbGUlM0RUcnVlJTJDJTIwYmF0Y2hfc2l6ZSUzRDgpJTBBZXZhbF9kYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlcihzbWFsbF9ldmFsX2RhdGFzZXQlMkMlMjBiYXRjaF9zaXplJTNEOCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader

<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader = DataLoader(small_train_dataset, shuffle=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">8</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>eval_dataloader = DataLoader(small_eval_dataset, batch_size=<span class="hljs-number">8</span>)`,wrap:!1}}),Be=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyJTJDJTIwbnVtX2xhYmVscyUzRDUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, num_labels=<span class="hljs-number">5</span>)`,wrap:!1}}),Ye=new b({props:{title:"Otimização e configuração do Learning Rate",local:"otimização-e-configuração-do-learning-rate",headingTag:"h3"}}),Ve=new g({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDVlLTUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW

<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">5e-5</span>)`,wrap:!1}}),Ae=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGdldF9zY2hlZHVsZXIlMEElMEFudW1fZXBvY2hzJTIwJTNEJTIwMyUwQW51bV90cmFpbmluZ19zdGVwcyUyMCUzRCUyMG51bV9lcG9jaHMlMjAqJTIwbGVuKHRyYWluX2RhdGFsb2FkZXIpJTBBbHJfc2NoZWR1bGVyJTIwJTNEJTIwZ2V0X3NjaGVkdWxlciglMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIybGluZWFyJTIyJTJDJTIwb3B0aW1pemVyJTNEb3B0aW1pemVyJTJDJTIwbnVtX3dhcm11cF9zdGVwcyUzRDAlMkMlMjBudW1fdHJhaW5pbmdfc3RlcHMlM0RudW1fdHJhaW5pbmdfc3RlcHMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> get_scheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>num_epochs = <span class="hljs-number">3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
<span class="hljs-meta">&gt;&gt;&gt; </span>lr_scheduler = get_scheduler(
<span class="hljs-meta">... </span>    name=<span class="hljs-string">&quot;linear&quot;</span>, optimizer=optimizer, num_warmup_steps=<span class="hljs-number">0</span>, num_training_steps=num_training_steps
<span class="hljs-meta">... </span>)`,wrap:!1}}),Le=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFtb2RlbC50byhkZXZpY2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)`,wrap:!1}}),_=new ls({props:{$$slots:{default:[Ks]},$$scope:{ctx:v}}}),Se=new b({props:{title:"Ciclo de treinamento",local:"ciclo-de-treinamento",headingTag:"h3"}}),De=new g({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFwcm9ncmVzc19iYXIlMjAlM0QlMjB0cWRtKHJhbmdlKG51bV90cmFpbmluZ19zdGVwcykpJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZShudW1fZXBvY2hzKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

<span class="hljs-meta">&gt;&gt;&gt; </span>progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

<span class="hljs-meta">&gt;&gt;&gt; </span>model.train()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
<span class="hljs-meta">... </span>        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
<span class="hljs-meta">... </span>        outputs = model(**batch)
<span class="hljs-meta">... </span>        loss = outputs.loss
<span class="hljs-meta">... </span>        loss.backward()

<span class="hljs-meta">... </span>        optimizer.step()
<span class="hljs-meta">... </span>        lr_scheduler.step()
<span class="hljs-meta">... </span>        optimizer.zero_grad()
<span class="hljs-meta">... </span>        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),Ke=new b({props:{title:"Métricas",local:"métricas",headingTag:"h3"}}),et=new g({props:{code:"bWV0cmljJTIwJTNEJTIwbG9hZF9tZXRyaWMoJTIyYWNjdXJhY3klMjIpJTBBbW9kZWwuZXZhbCgpJTBBZm9yJTIwYmF0Y2glMjBpbiUyMGV2YWxfZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMGJhdGNoJTIwJTNEJTIwJTdCayUzQSUyMHYudG8oZGV2aWNlKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBiYXRjaC5pdGVtcygpJTdEJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmJhdGNoKSUwQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTJDJTIwZGltJTNELTEpJTBBJTIwJTIwJTIwJTIwbWV0cmljLmFkZF9iYXRjaChwcmVkaWN0aW9ucyUzRHByZWRpY3Rpb25zJTJDJTIwcmVmZXJlbmNlcyUzRGJhdGNoJTVCJTIybGFiZWxzJTIyJTVEKSUwQSUwQW1ldHJpYy5jb21wdXRlKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>metric = load_metric(<span class="hljs-string">&quot;accuracy&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
<span class="hljs-meta">... </span>    batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        outputs = model(**batch)

<span class="hljs-meta">... </span>    logits = outputs.logits
<span class="hljs-meta">... </span>    predictions = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    metric.add_batch(predictions=predictions, references=batch[<span class="hljs-string">&quot;labels&quot;</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>metric.compute()`,wrap:!1}}),tt=new b({props:{title:"Recursos adicionais",local:"recursos-adicionais",headingTag:"h2"}}),lt=new Ss({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/pt/training.md"}}),{c(){h=o("meta"),j=l(),M=o("p"),T=l(),p(U.$$.fragment),Mt=l(),p(C.$$.fragment),bt=l(),I=o("p"),I.textContent=os,jt=l(),R=o("ul"),R.innerHTML=rs,$t=l(),pt=o("a"),yt=l(),p(G.$$.fragment),Tt=l(),p(W.$$.fragment),wt=l(),X=o("p"),X.textContent=ps,Jt=l(),z=o("p"),z.innerHTML=is,vt=l(),p(F.$$.fragment),kt=l(),x=o("p"),x.innerHTML=ms,Zt=l(),p(E.$$.fragment),_t=l(),B=o("p"),B.textContent=ds,Ut=l(),p(Y.$$.fragment),Ct=l(),it=o("a"),It=l(),p(H.$$.fragment),Rt=l(),p(V.$$.fragment),Gt=l(),N=o("p"),N.innerHTML=cs,Wt=l(),A=o("p"),A.innerHTML=us,Xt=l(),p(q.$$.fragment),zt=l(),p(k.$$.fragment),Ft=l(),p(L.$$.fragment),xt=l(),Q=o("p"),Q.innerHTML=fs,Et=l(),S=o("p"),S.textContent=hs,Bt=l(),p(P.$$.fragment),Yt=l(),p(D.$$.fragment),Ht=l(),K=o("p"),K.innerHTML=gs,Vt=l(),p(O.$$.fragment),Nt=l(),ee=o("p"),ee.innerHTML=Ms,At=l(),p(te.$$.fragment),qt=l(),ae=o("p"),ae.innerHTML=bs,Lt=l(),p(se.$$.fragment),Qt=l(),p(le.$$.fragment),St=l(),ne=o("p"),ne.innerHTML=js,Pt=l(),p(oe.$$.fragment),Dt=l(),re=o("p"),re.innerHTML=$s,Kt=l(),p(pe.$$.fragment),Ot=l(),mt=o("a"),ea=l(),p(ie.$$.fragment),ta=l(),p(me.$$.fragment),aa=l(),de=o("p"),de.textContent=ys,sa=l(),p(ce.$$.fragment),la=l(),ue=o("p"),ue.innerHTML=Ts,na=l(),p(fe.$$.fragment),oa=l(),p(Z.$$.fragment),ra=l(),he=o("p"),he.innerHTML=ws,pa=l(),p(ge.$$.fragment),ia=l(),p(Me.$$.fragment),ma=l(),be=o("p"),be.textContent=Js,da=l(),p(je.$$.fragment),ca=l(),$e=o("p"),$e.innerHTML=vs,ua=l(),p(ye.$$.fragment),fa=l(),dt=o("a"),ha=l(),p(Te.$$.fragment),ga=l(),p(we.$$.fragment),Ma=l(),Je=o("p"),Je.innerHTML=ks,ba=l(),ve=o("p"),ve.textContent=Zs,ja=l(),p(ke.$$.fragment),$a=l(),Ze=o("p"),Ze.innerHTML=_s,ya=l(),w=o("ol"),_e=o("li"),ct=o("p"),ct.innerHTML=Us,Oa=l(),p(Ue.$$.fragment),es=l(),Ce=o("li"),ut=o("p"),ut.innerHTML=Cs,ts=l(),p(Ie.$$.fragment),as=l(),Re=o("li"),ft=o("p"),ft.textContent=Is,ss=l(),p(Ge.$$.fragment),Ta=l(),We=o("p"),We.textContent=Rs,wa=l(),p(Xe.$$.fragment),Ja=l(),p(ze.$$.fragment),va=l(),Fe=o("p"),Fe.innerHTML=Gs,ka=l(),p(xe.$$.fragment),Za=l(),Ee=o("p"),Ee.textContent=Ws,_a=l(),p(Be.$$.fragment),Ua=l(),p(Ye.$$.fragment),Ca=l(),He=o("p"),He.innerHTML=Xs,Ia=l(),p(Ve.$$.fragment),Ra=l(),Ne=o("p"),Ne.innerHTML=zs,Ga=l(),p(Ae.$$.fragment),Wa=l(),qe=o("p"),qe.innerHTML=Fs,Xa=l(),p(Le.$$.fragment),za=l(),p(_.$$.fragment),Fa=l(),Qe=o("p"),Qe.textContent=xs,xa=l(),p(Se.$$.fragment),Ea=l(),Pe=o("p"),Pe.innerHTML=Es,Ba=l(),p(De.$$.fragment),Ya=l(),p(Ke.$$.fragment),Ha=l(),Oe=o("p"),Oe.innerHTML=Bs,Va=l(),p(et.$$.fragment),Na=l(),ht=o("a"),Aa=l(),p(tt.$$.fragment),qa=l(),at=o("p"),at.textContent=Ys,La=l(),st=o("ul"),st.innerHTML=Hs,Qa=l(),p(lt.$$.fragment),Sa=l(),gt=o("p"),this.h()},l(e){const t=Ls("svelte-u9bgzb",document.head);h=r(t,"META",{name:!0,content:!0}),t.forEach(a),j=n(e),M=r(e,"P",{}),y(M).forEach(a),T=n(e),i(U.$$.fragment,e),Mt=n(e),i(C.$$.fragment,e),bt=n(e),I=r(e,"P",{"data-svelte-h":!0}),f(I)!=="svelte-fhi5po"&&(I.textContent=os),jt=n(e),R=r(e,"UL",{"data-svelte-h":!0}),f(R)!=="svelte-1uar1qx"&&(R.innerHTML=rs),$t=n(e),pt=r(e,"A",{id:!0}),y(pt).forEach(a),yt=n(e),i(G.$$.fragment,e),Tt=n(e),i(W.$$.fragment,e),wt=n(e),X=r(e,"P",{"data-svelte-h":!0}),f(X)!=="svelte-1opso33"&&(X.textContent=ps),Jt=n(e),z=r(e,"P",{"data-svelte-h":!0}),f(z)!=="svelte-14tknsg"&&(z.innerHTML=is),vt=n(e),i(F.$$.fragment,e),kt=n(e),x=r(e,"P",{"data-svelte-h":!0}),f(x)!=="svelte-wxbab7"&&(x.innerHTML=ms),Zt=n(e),i(E.$$.fragment,e),_t=n(e),B=r(e,"P",{"data-svelte-h":!0}),f(B)!=="svelte-1cg4wp0"&&(B.textContent=ds),Ut=n(e),i(Y.$$.fragment,e),Ct=n(e),it=r(e,"A",{id:!0}),y(it).forEach(a),It=n(e),i(H.$$.fragment,e),Rt=n(e),i(V.$$.fragment,e),Gt=n(e),N=r(e,"P",{"data-svelte-h":!0}),f(N)!=="svelte-1j0gwk8"&&(N.innerHTML=cs),Wt=n(e),A=r(e,"P",{"data-svelte-h":!0}),f(A)!=="svelte-56udk6"&&(A.innerHTML=us),Xt=n(e),i(q.$$.fragment,e),zt=n(e),i(k.$$.fragment,e),Ft=n(e),i(L.$$.fragment,e),xt=n(e),Q=r(e,"P",{"data-svelte-h":!0}),f(Q)!=="svelte-1vu82s5"&&(Q.innerHTML=fs),Et=n(e),S=r(e,"P",{"data-svelte-h":!0}),f(S)!=="svelte-fjh0nm"&&(S.textContent=hs),Bt=n(e),i(P.$$.fragment,e),Yt=n(e),i(D.$$.fragment,e),Ht=n(e),K=r(e,"P",{"data-svelte-h":!0}),f(K)!=="svelte-1o1vpfm"&&(K.innerHTML=gs),Vt=n(e),i(O.$$.fragment,e),Nt=n(e),ee=r(e,"P",{"data-svelte-h":!0}),f(ee)!=="svelte-1oopkat"&&(ee.innerHTML=Ms),At=n(e),i(te.$$.fragment,e),qt=n(e),ae=r(e,"P",{"data-svelte-h":!0}),f(ae)!=="svelte-1nw8vw4"&&(ae.innerHTML=bs),Lt=n(e),i(se.$$.fragment,e),Qt=n(e),i(le.$$.fragment,e),St=n(e),ne=r(e,"P",{"data-svelte-h":!0}),f(ne)!=="svelte-1r3j7rx"&&(ne.innerHTML=js),Pt=n(e),i(oe.$$.fragment,e),Dt=n(e),re=r(e,"P",{"data-svelte-h":!0}),f(re)!=="svelte-a3f13l"&&(re.innerHTML=$s),Kt=n(e),i(pe.$$.fragment,e),Ot=n(e),mt=r(e,"A",{id:!0}),y(mt).forEach(a),ea=n(e),i(ie.$$.fragment,e),ta=n(e),i(me.$$.fragment,e),aa=n(e),de=r(e,"P",{"data-svelte-h":!0}),f(de)!=="svelte-j16adj"&&(de.textContent=ys),sa=n(e),i(ce.$$.fragment,e),la=n(e),ue=r(e,"P",{"data-svelte-h":!0}),f(ue)!=="svelte-1gyci2m"&&(ue.innerHTML=Ts),na=n(e),i(fe.$$.fragment,e),oa=n(e),i(Z.$$.fragment,e),ra=n(e),he=r(e,"P",{"data-svelte-h":!0}),f(he)!=="svelte-1kkaz"&&(he.innerHTML=ws),pa=n(e),i(ge.$$.fragment,e),ia=n(e),i(Me.$$.fragment,e),ma=n(e),be=r(e,"P",{"data-svelte-h":!0}),f(be)!=="svelte-rgss8z"&&(be.textContent=Js),da=n(e),i(je.$$.fragment,e),ca=n(e),$e=r(e,"P",{"data-svelte-h":!0}),f($e)!=="svelte-qjchcy"&&($e.innerHTML=vs),ua=n(e),i(ye.$$.fragment,e),fa=n(e),dt=r(e,"A",{id:!0}),y(dt).forEach(a),ha=n(e),i(Te.$$.fragment,e),ga=n(e),i(we.$$.fragment,e),Ma=n(e),Je=r(e,"P",{"data-svelte-h":!0}),f(Je)!=="svelte-1q1pzl3"&&(Je.innerHTML=ks),ba=n(e),ve=r(e,"P",{"data-svelte-h":!0}),f(ve)!=="svelte-1abyi5e"&&(ve.textContent=Zs),ja=n(e),i(ke.$$.fragment,e),$a=n(e),Ze=r(e,"P",{"data-svelte-h":!0}),f(Ze)!=="svelte-1a8dyp8"&&(Ze.innerHTML=_s),ya=n(e),w=r(e,"OL",{});var J=y(w);_e=r(J,"LI",{});var nt=y(_e);ct=r(nt,"P",{"data-svelte-h":!0}),f(ct)!=="svelte-n1mzi4"&&(ct.innerHTML=Us),Oa=n(nt),i(Ue.$$.fragment,nt),nt.forEach(a),es=n(J),Ce=r(J,"LI",{});var ot=y(Ce);ut=r(ot,"P",{"data-svelte-h":!0}),f(ut)!=="svelte-dx24cp"&&(ut.innerHTML=Cs),ts=n(ot),i(Ie.$$.fragment,ot),ot.forEach(a),as=n(J),Re=r(J,"LI",{});var Da=y(Re);ft=r(Da,"P",{"data-svelte-h":!0}),f(ft)!=="svelte-15zkuau"&&(ft.textContent=Is),ss=n(Da),i(Ge.$$.fragment,Da),Da.forEach(a),J.forEach(a),Ta=n(e),We=r(e,"P",{"data-svelte-h":!0}),f(We)!=="svelte-x0bqu0"&&(We.textContent=Rs),wa=n(e),i(Xe.$$.fragment,e),Ja=n(e),i(ze.$$.fragment,e),va=n(e),Fe=r(e,"P",{"data-svelte-h":!0}),f(Fe)!=="svelte-lg4as"&&(Fe.innerHTML=Gs),ka=n(e),i(xe.$$.fragment,e),Za=n(e),Ee=r(e,"P",{"data-svelte-h":!0}),f(Ee)!=="svelte-1y9asxq"&&(Ee.textContent=Ws),_a=n(e),i(Be.$$.fragment,e),Ua=n(e),i(Ye.$$.fragment,e),Ca=n(e),He=r(e,"P",{"data-svelte-h":!0}),f(He)!=="svelte-1355v62"&&(He.innerHTML=Xs),Ia=n(e),i(Ve.$$.fragment,e),Ra=n(e),Ne=r(e,"P",{"data-svelte-h":!0}),f(Ne)!=="svelte-61qbj5"&&(Ne.innerHTML=zs),Ga=n(e),i(Ae.$$.fragment,e),Wa=n(e),qe=r(e,"P",{"data-svelte-h":!0}),f(qe)!=="svelte-794g8f"&&(qe.innerHTML=Fs),Xa=n(e),i(Le.$$.fragment,e),za=n(e),i(_.$$.fragment,e),Fa=n(e),Qe=r(e,"P",{"data-svelte-h":!0}),f(Qe)!=="svelte-10cun9s"&&(Qe.textContent=xs),xa=n(e),i(Se.$$.fragment,e),Ea=n(e),Pe=r(e,"P",{"data-svelte-h":!0}),f(Pe)!=="svelte-ibqtt9"&&(Pe.innerHTML=Es),Ba=n(e),i(De.$$.fragment,e),Ya=n(e),i(Ke.$$.fragment,e),Ha=n(e),Oe=r(e,"P",{"data-svelte-h":!0}),f(Oe)!=="svelte-i3ujem"&&(Oe.innerHTML=Bs),Va=n(e),i(et.$$.fragment,e),Na=n(e),ht=r(e,"A",{id:!0}),y(ht).forEach(a),Aa=n(e),i(tt.$$.fragment,e),qa=n(e),at=r(e,"P",{"data-svelte-h":!0}),f(at)!=="svelte-vbn27k"&&(at.textContent=Ys),La=n(e),st=r(e,"UL",{"data-svelte-h":!0}),f(st)!=="svelte-1n639bw"&&(st.innerHTML=Hs),Qa=n(e),i(lt.$$.fragment,e),Sa=n(e),gt=r(e,"P",{}),y(gt).forEach(a),this.h()},h(){rt(h,"name","hf:doc:metadata"),rt(h,"content",el),rt(pt,"id","data-processing"),rt(it,"id","trainer"),rt(mt,"id","keras"),rt(dt,"id","pytorch_native"),rt(ht,"id","additional-resources")},m(e,t){$(document.head,h),s(e,j,t),s(e,M,t),s(e,T,t),m(U,e,t),s(e,Mt,t),m(C,e,t),s(e,bt,t),s(e,I,t),s(e,jt,t),s(e,R,t),s(e,$t,t),s(e,pt,t),s(e,yt,t),m(G,e,t),s(e,Tt,t),m(W,e,t),s(e,wt,t),s(e,X,t),s(e,Jt,t),s(e,z,t),s(e,vt,t),m(F,e,t),s(e,kt,t),s(e,x,t),s(e,Zt,t),m(E,e,t),s(e,_t,t),s(e,B,t),s(e,Ut,t),m(Y,e,t),s(e,Ct,t),s(e,it,t),s(e,It,t),m(H,e,t),s(e,Rt,t),m(V,e,t),s(e,Gt,t),s(e,N,t),s(e,Wt,t),s(e,A,t),s(e,Xt,t),m(q,e,t),s(e,zt,t),m(k,e,t),s(e,Ft,t),m(L,e,t),s(e,xt,t),s(e,Q,t),s(e,Et,t),s(e,S,t),s(e,Bt,t),m(P,e,t),s(e,Yt,t),m(D,e,t),s(e,Ht,t),s(e,K,t),s(e,Vt,t),m(O,e,t),s(e,Nt,t),s(e,ee,t),s(e,At,t),m(te,e,t),s(e,qt,t),s(e,ae,t),s(e,Lt,t),m(se,e,t),s(e,Qt,t),m(le,e,t),s(e,St,t),s(e,ne,t),s(e,Pt,t),m(oe,e,t),s(e,Dt,t),s(e,re,t),s(e,Kt,t),m(pe,e,t),s(e,Ot,t),s(e,mt,t),s(e,ea,t),m(ie,e,t),s(e,ta,t),m(me,e,t),s(e,aa,t),s(e,de,t),s(e,sa,t),m(ce,e,t),s(e,la,t),s(e,ue,t),s(e,na,t),m(fe,e,t),s(e,oa,t),m(Z,e,t),s(e,ra,t),s(e,he,t),s(e,pa,t),m(ge,e,t),s(e,ia,t),m(Me,e,t),s(e,ma,t),s(e,be,t),s(e,da,t),m(je,e,t),s(e,ca,t),s(e,$e,t),s(e,ua,t),m(ye,e,t),s(e,fa,t),s(e,dt,t),s(e,ha,t),m(Te,e,t),s(e,ga,t),m(we,e,t),s(e,Ma,t),s(e,Je,t),s(e,ba,t),s(e,ve,t),s(e,ja,t),m(ke,e,t),s(e,$a,t),s(e,Ze,t),s(e,ya,t),s(e,w,t),$(w,_e),$(_e,ct),$(_e,Oa),m(Ue,_e,null),$(w,es),$(w,Ce),$(Ce,ut),$(Ce,ts),m(Ie,Ce,null),$(w,as),$(w,Re),$(Re,ft),$(Re,ss),m(Ge,Re,null),s(e,Ta,t),s(e,We,t),s(e,wa,t),m(Xe,e,t),s(e,Ja,t),m(ze,e,t),s(e,va,t),s(e,Fe,t),s(e,ka,t),m(xe,e,t),s(e,Za,t),s(e,Ee,t),s(e,_a,t),m(Be,e,t),s(e,Ua,t),m(Ye,e,t),s(e,Ca,t),s(e,He,t),s(e,Ia,t),m(Ve,e,t),s(e,Ra,t),s(e,Ne,t),s(e,Ga,t),m(Ae,e,t),s(e,Wa,t),s(e,qe,t),s(e,Xa,t),m(Le,e,t),s(e,za,t),m(_,e,t),s(e,Fa,t),s(e,Qe,t),s(e,xa,t),m(Se,e,t),s(e,Ea,t),s(e,Pe,t),s(e,Ba,t),m(De,e,t),s(e,Ya,t),m(Ke,e,t),s(e,Ha,t),s(e,Oe,t),s(e,Va,t),m(et,e,t),s(e,Na,t),s(e,ht,t),s(e,Aa,t),m(tt,e,t),s(e,qa,t),s(e,at,t),s(e,La,t),s(e,st,t),s(e,Qa,t),m(lt,e,t),s(e,Sa,t),s(e,gt,t),Pa=!0},p(e,[t]){const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),k.$set(J);const nt={};t&2&&(nt.$$scope={dirty:t,ctx:e}),Z.$set(nt);const ot={};t&2&&(ot.$$scope={dirty:t,ctx:e}),_.$set(ot)},i(e){Pa||(d(U.$$.fragment,e),d(C.$$.fragment,e),d(G.$$.fragment,e),d(W.$$.fragment,e),d(F.$$.fragment,e),d(E.$$.fragment,e),d(Y.$$.fragment,e),d(H.$$.fragment,e),d(V.$$.fragment,e),d(q.$$.fragment,e),d(k.$$.fragment,e),d(L.$$.fragment,e),d(P.$$.fragment,e),d(D.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(se.$$.fragment,e),d(le.$$.fragment,e),d(oe.$$.fragment,e),d(pe.$$.fragment,e),d(ie.$$.fragment,e),d(me.$$.fragment,e),d(ce.$$.fragment,e),d(fe.$$.fragment,e),d(Z.$$.fragment,e),d(ge.$$.fragment,e),d(Me.$$.fragment,e),d(je.$$.fragment,e),d(ye.$$.fragment,e),d(Te.$$.fragment,e),d(we.$$.fragment,e),d(ke.$$.fragment,e),d(Ue.$$.fragment,e),d(Ie.$$.fragment,e),d(Ge.$$.fragment,e),d(Xe.$$.fragment,e),d(ze.$$.fragment,e),d(xe.$$.fragment,e),d(Be.$$.fragment,e),d(Ye.$$.fragment,e),d(Ve.$$.fragment,e),d(Ae.$$.fragment,e),d(Le.$$.fragment,e),d(_.$$.fragment,e),d(Se.$$.fragment,e),d(De.$$.fragment,e),d(Ke.$$.fragment,e),d(et.$$.fragment,e),d(tt.$$.fragment,e),d(lt.$$.fragment,e),Pa=!0)},o(e){c(U.$$.fragment,e),c(C.$$.fragment,e),c(G.$$.fragment,e),c(W.$$.fragment,e),c(F.$$.fragment,e),c(E.$$.fragment,e),c(Y.$$.fragment,e),c(H.$$.fragment,e),c(V.$$.fragment,e),c(q.$$.fragment,e),c(k.$$.fragment,e),c(L.$$.fragment,e),c(P.$$.fragment,e),c(D.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(se.$$.fragment,e),c(le.$$.fragment,e),c(oe.$$.fragment,e),c(pe.$$.fragment,e),c(ie.$$.fragment,e),c(me.$$.fragment,e),c(ce.$$.fragment,e),c(fe.$$.fragment,e),c(Z.$$.fragment,e),c(ge.$$.fragment,e),c(Me.$$.fragment,e),c(je.$$.fragment,e),c(ye.$$.fragment,e),c(Te.$$.fragment,e),c(we.$$.fragment,e),c(ke.$$.fragment,e),c(Ue.$$.fragment,e),c(Ie.$$.fragment,e),c(Ge.$$.fragment,e),c(Xe.$$.fragment,e),c(ze.$$.fragment,e),c(xe.$$.fragment,e),c(Be.$$.fragment,e),c(Ye.$$.fragment,e),c(Ve.$$.fragment,e),c(Ae.$$.fragment,e),c(Le.$$.fragment,e),c(_.$$.fragment,e),c(Se.$$.fragment,e),c(De.$$.fragment,e),c(Ke.$$.fragment,e),c(et.$$.fragment,e),c(tt.$$.fragment,e),c(lt.$$.fragment,e),Pa=!1},d(e){e&&(a(j),a(M),a(T),a(Mt),a(bt),a(I),a(jt),a(R),a($t),a(pt),a(yt),a(Tt),a(wt),a(X),a(Jt),a(z),a(vt),a(kt),a(x),a(Zt),a(_t),a(B),a(Ut),a(Ct),a(it),a(It),a(Rt),a(Gt),a(N),a(Wt),a(A),a(Xt),a(zt),a(Ft),a(xt),a(Q),a(Et),a(S),a(Bt),a(Yt),a(Ht),a(K),a(Vt),a(Nt),a(ee),a(At),a(qt),a(ae),a(Lt),a(Qt),a(St),a(ne),a(Pt),a(Dt),a(re),a(Kt),a(Ot),a(mt),a(ea),a(ta),a(aa),a(de),a(sa),a(la),a(ue),a(na),a(oa),a(ra),a(he),a(pa),a(ia),a(ma),a(be),a(da),a(ca),a($e),a(ua),a(fa),a(dt),a(ha),a(ga),a(Ma),a(Je),a(ba),a(ve),a(ja),a($a),a(Ze),a(ya),a(w),a(Ta),a(We),a(wa),a(Ja),a(va),a(Fe),a(ka),a(Za),a(Ee),a(_a),a(Ua),a(Ca),a(He),a(Ia),a(Ra),a(Ne),a(Ga),a(Wa),a(qe),a(Xa),a(za),a(Fa),a(Qe),a(xa),a(Ea),a(Pe),a(Ba),a(Ya),a(Ha),a(Oe),a(Va),a(Na),a(ht),a(Aa),a(qa),a(at),a(La),a(st),a(Qa),a(Sa),a(gt)),a(h),u(U,e),u(C,e),u(G,e),u(W,e),u(F,e),u(E,e),u(Y,e),u(H,e),u(V,e),u(q,e),u(k,e),u(L,e),u(P,e),u(D,e),u(O,e),u(te,e),u(se,e),u(le,e),u(oe,e),u(pe,e),u(ie,e),u(me,e),u(ce,e),u(fe,e),u(Z,e),u(ge,e),u(Me,e),u(je,e),u(ye,e),u(Te,e),u(we,e),u(ke,e),u(Ue),u(Ie),u(Ge),u(Xe,e),u(ze,e),u(xe,e),u(Be,e),u(Ye,e),u(Ve,e),u(Ae,e),u(Le,e),u(_,e),u(Se,e),u(De,e),u(Ke,e),u(et,e),u(tt,e),u(lt,e)}}}const el='{"title":"Fine-tuning de um modelo pré-treinado","local":"fine-tuning-de-um-modelo-pré-treinado","sections":[{"title":"Preparando um dataset","local":"preparando-um-dataset","sections":[],"depth":2},{"title":"Fine-tuning com o Trainer","local":"fine-tuning-com-o-trainer","sections":[{"title":"Hiperparâmetros de treinamento","local":"hiperparâmetros-de-treinamento","sections":[],"depth":3},{"title":"Métricas","local":"métricas","sections":[],"depth":3},{"title":"Trainer","local":"trainer","sections":[],"depth":3}],"depth":2},{"title":"Fine-tuning com Keras","local":"fine-tuning-com-keras","sections":[{"title":"Conversão do dataset ao formato do TensorFlow","local":"conversão-do-dataset-ao-formato-do-tensorflow","sections":[],"depth":3},{"title":"Compilação e ajustes","local":"compilação-e-ajustes","sections":[],"depth":3}],"depth":2},{"title":"Fine-tune em PyTorch nativo","local":"fine-tune-em-pytorch-nativo","sections":[{"title":"DataLoader","local":"dataloader","sections":[],"depth":3},{"title":"Otimização e configuração do Learning Rate","local":"otimização-e-configuração-do-learning-rate","sections":[],"depth":3},{"title":"Ciclo de treinamento","local":"ciclo-de-treinamento","sections":[],"depth":3},{"title":"Métricas","local":"métricas","sections":[],"depth":3}],"depth":2},{"title":"Recursos adicionais","local":"recursos-adicionais","sections":[],"depth":2}],"depth":1}';function tl(v){return Ns(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class il extends As{constructor(h){super(),qs(this,h,tl,Os,Vs,{})}}export{il as component};
