import{s as Ot,n as el,o as tl}from"../chunks/scheduler.d586627e.js";import{S as ll,i as sl,g as o,s as a,r,A as al,h as i,f as l,c as n,j as Dt,u as d,x as m,k as Kt,y as nl,a as s,v as p,d as u,t as g,w as c}from"../chunks/index.8589a59c.js";import{C as M}from"../chunks/CodeBlock.dffc9a5b.js";import{D as ol}from"../chunks/DocNotebookDropdown.5cbb20c5.js";import{H as f,E as il}from"../chunks/index.fd9d4aff.js";function ml(Tt){let b,Je,be,Te,J,ye,T,he,y,yt=`Existem vários modelos multilinguísticos no 🤗 Transformers e seus usos para inferência diferem dos modelos monolíngues.
No entanto, nem <em>todos</em> os usos dos modelos multilíngues são tão diferentes.
Alguns modelos, como o <a href="https://huggingface.co/google-bert/bert-base-multilingual-uncased" rel="nofollow">google-bert/bert-base-multilingual-uncased</a>,
podem ser usados como se fossem monolíngues. Este guia irá te ajudar a usar modelos multilíngues cujo uso difere
para o propósito de inferência.`,Ue,h,ke,U,ht=`O XLM tem dez checkpoints diferentes dos quais apenas um é monolíngue.
Os nove checkpoints restantes do modelo são subdivididos em duas categorias:
checkpoints que usam de language embeddings e os que não.`,$e,k,we,$,Ut="Os seguintes modelos de XLM usam language embeddings para especificar a linguagem utilizada para a inferência.",je,w,kt="<li><code>FacebookAI/xlm-mlm-ende-1024</code> (Masked language modeling, English-German)</li> <li><code>FacebookAI/xlm-mlm-enfr-1024</code> (Masked language modeling, English-French)</li> <li><code>FacebookAI/xlm-mlm-enro-1024</code> (Masked language modeling, English-Romanian)</li> <li><code>FacebookAI/xlm-mlm-xnli15-1024</code> (Masked language modeling, XNLI languages)</li> <li><code>FacebookAI/xlm-mlm-tlm-xnli15-1024</code> (Masked language modeling + translation, XNLI languages)</li> <li><code>FacebookAI/xlm-clm-enfr-1024</code> (Causal language modeling, English-French)</li> <li><code>FacebookAI/xlm-clm-ende-1024</code> (Causal language modeling, English-German)</li>",xe,j,$t=`Os language embeddings são representados por um tensor de mesma dimensão que os <code>input_ids</code> passados ao modelo.
Os valores destes tensores dependem do idioma utilizado e se identificam pelos atributos <code>lang2id</code> e <code>id2lang</code> do tokenizador.`,ve,x,wt="Neste exemplo, carregamos o checkpoint <code>FacebookAI/xlm-clm-enfr-1024</code>(Causal language modeling, English-French):",Ze,v,Ce,Z,jt="O atributo <code>lang2id</code> do tokenizador mostra os idiomas deste modelo e seus ids:",_e,C,Ie,_,xt="Em seguida, cria-se um input de exemplo:",Xe,I,Ge,X,vt=`Estabelece-se o id do idioma, por exemplo <code>&quot;en&quot;</code>, e utiliza-se o mesmo para definir a language embedding.
A language embedding é um tensor preenchido com <code>0</code>, que é o id de idioma para o inglês.
Este tensor deve ser do mesmo tamanho que os <code>input_ids</code>.`,ze,G,We,z,Zt="Agora você pode passar os <code>input_ids</code> e a language embedding ao modelo:",Ve,W,Le,V,Ct='O script <a href="https://github.com/huggingface/transformers/tree/master/examples/pytorch/text-generation/run_generation.py" rel="nofollow">run_generation.py</a> pode gerar um texto com language embeddings utilizando os checkpoints <code>xlm-clm</code>.',Re,L,Ee,R,_t="Os seguintes modelos XLM não requerem o uso de language embeddings durante a inferência:",Be,E,It="<li><code>FacebookAI/xlm-mlm-17-1280</code> (Modelagem de linguagem com máscara, 17 idiomas)</li> <li><code>FacebookAI/xlm-mlm-100-1280</code> (Modelagem de linguagem com máscara, 100 idiomas)</li>",Fe,B,Xt="Estes modelos são utilizados para representações genéricas de frase diferentemente dos checkpoints XLM anteriores.",qe,F,He,q,Gt="Os seguintes modelos do BERT podem ser utilizados para tarefas multilinguísticas:",Qe,H,zt="<li><code>google-bert/bert-base-multilingual-uncased</code> (Modelagem de linguagem com máscara + Previsão de frases, 102 idiomas)</li> <li><code>google-bert/bert-base-multilingual-cased</code> (Modelagem de linguagem com máscara + Previsão de frases, 104 idiomas)</li>",Ne,Q,Wt=`Estes modelos não requerem language embeddings durante a inferência. Devem identificar a linguagem a partir
do contexto e realizar a inferência em sequência.`,Ye,N,Ae,Y,Vt="Os seguintes modelos do XLM-RoBERTa podem ser utilizados para tarefas multilinguísticas:",Pe,A,Lt="<li><code>FacebookAI/xlm-roberta-base</code> (Modelagem de linguagem com máscara, 100 idiomas)</li> <li><code>FacebookAI/xlm-roberta-large</code> Modelagem de linguagem com máscara, 100 idiomas)</li>",Se,P,Rt=`O XLM-RoBERTa foi treinado com 2,5 TB de dados do CommonCrawl recém-criados e testados em 100 idiomas.
Proporciona fortes vantagens sobre os modelos multilinguísticos publicados anteriormente como o mBERT e o XLM em tarefas
subsequentes como a classificação, a rotulagem de sequências e à respostas a perguntas.`,De,S,Ke,D,Et="Os seguintes modelos de M2M100 podem ser utilizados para traduções multilinguísticas:",Oe,K,Bt="<li><code>facebook/m2m100_418M</code> (Tradução)</li> <li><code>facebook/m2m100_1.2B</code> (Tradução)</li>",et,O,Ft=`Neste exemplo, o checkpoint <code>facebook/m2m100_418M</code> é carregado para traduzir do mandarim ao inglês. É possível
estabelecer o idioma de origem no tokenizador:`,tt,ee,lt,te,qt="Tokenização do texto:",st,le,at,se,Ht=`O M2M100 força o id do idioma de destino como o primeiro token gerado para traduzir ao idioma de destino.
É definido o <code>forced_bos_token_id</code> como <code>en</code> no método <code>generate</code> para traduzir ao inglês.`,nt,ae,ot,ne,it,oe,Qt="Os seguintes modelos do MBart podem ser utilizados para tradução multilinguística:",mt,ie,Nt="<li><code>facebook/mbart-large-50-one-to-many-mmt</code> (Tradução automática multilinguística de um a vários, 50 idiomas)</li> <li><code>facebook/mbart-large-50-many-to-many-mmt</code> (Tradução automática multilinguística de vários a vários, 50 idiomas)</li> <li><code>facebook/mbart-large-50-many-to-one-mmt</code> (Tradução automática multilinguística vários a um, 50 idiomas)</li> <li><code>facebook/mbart-large-50</code> (Tradução multilinguística, 50 idiomas)</li> <li><code>facebook/mbart-large-cc25</code></li>",rt,me,Yt=`Neste exemplo, carrega-se o checkpoint <code>facebook/mbart-large-50-many-to-many-mmt</code> para traduzir do finlandês ao inglês.
Pode-se definir o idioma de origem no tokenizador:`,dt,re,pt,de,At="Tokenizando o texto:",ut,pe,gt,ue,Pt=`O MBart força o id do idioma de destino como o primeiro token gerado para traduzir ao idioma de destino.
É definido o <code>forced_bos_token_id</code> como <code>en</code> no método <code>generate</code> para traduzir ao inglês.`,ct,ge,Mt,ce,St=`Se estiver usando o checkpoint <code>facebook/mbart-large-50-many-to-one-mmt</code> não será necessário forçar o id do idioma de destino
como sendo o primeiro token generado, caso contrário a usagem é a mesma.`,bt,Me,ft,fe,Jt;return J=new f({props:{title:"Modelos multilinguísticos para inferência",local:"modelos-multilinguísticos-para-inferência",headingTag:"h1"}}),T=new ol({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/pt/multilingual.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/pt/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/pt/tensorflow/multilingual.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/pt/multilingual.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/pt/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/pt/tensorflow/multilingual.ipynb"}]}}),h=new f({props:{title:"XLM",local:"xlm",headingTag:"h2"}}),k=new f({props:{title:"XLM com language embeddings",local:"xlm-com-language-embeddings",headingTag:"h3"}}),v=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwWExNVG9rZW5pemVyJTJDJTIwWExNV2l0aExNSGVhZE1vZGVsJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwWExNVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJGYWNlYm9va0FJJTJGeGxtLWNsbS1lbmZyLTEwMjQlMjIpJTBBbW9kZWwlMjAlM0QlMjBYTE1XaXRoTE1IZWFkTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMkZhY2Vib29rQUklMkZ4bG0tY2xtLWVuZnItMTAyNCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLMTokenizer, XLMWithLMHeadModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = XLMTokenizer.from_pretrained(<span class="hljs-string">&quot;FacebookAI/xlm-clm-enfr-1024&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = XLMWithLMHeadModel.from_pretrained(<span class="hljs-string">&quot;FacebookAI/xlm-clm-enfr-1024&quot;</span>)`,wrap:!1}}),C=new M({props:{code:"cHJpbnQodG9rZW5pemVyLmxhbmcyaWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.lang2id)
{<span class="hljs-string">&#x27;en&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;fr&#x27;</span>: <span class="hljs-number">1</span>}`,wrap:!1}}),I=new M({props:{code:"aW5wdXRfaWRzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QnRva2VuaXplci5lbmNvZGUoJTIyV2lraXBlZGlhJTIwd2FzJTIwdXNlZCUyMHRvJTIyKSU1RCklMjAlMjAlMjMlMjBiYXRjaCUyMHNpemUlMjBvZiUyMDE=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.tensor([tokenizer.encode(<span class="hljs-string">&quot;Wikipedia was used to&quot;</span>)])  <span class="hljs-comment"># batch size of 1</span>',wrap:!1}}),G=new M({props:{code:"bGFuZ3VhZ2VfaWQlMjAlM0QlMjB0b2tlbml6ZXIubGFuZzJpZCU1QiUyMmVuJTIyJTVEJTIwJTIwJTIzJTIwMCUwQWxhbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1Qmxhbmd1YWdlX2lkJTVEJTIwKiUyMGlucHV0X2lkcy5zaGFwZSU1QjElNUQpJTIwJTIwJTIzJTIwdG9yY2gudGVuc29yKCU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMC4uLiUyQyUyMDAlNUQpJTBBJTBBJTIzJTIwV2UlMjByZXNoYXBlJTIwaXQlMjB0byUyMGJlJTIwb2YlMjBzaXplJTIwKGJhdGNoX3NpemUlMkMlMjBzZXF1ZW5jZV9sZW5ndGgpJTBBbGFuZ3MlMjAlM0QlMjBsYW5ncy52aWV3KDElMkMlMjAtMSklMjAlMjAlMjMlMjBpcyUyMG5vdyUyMG9mJTIwc2hhcGUlMjAlNUIxJTJDJTIwc2VxdWVuY2VfbGVuZ3RoJTVEJTIwKHdlJTIwaGF2ZSUyMGElMjBiYXRjaCUyMHNpemUlMjBvZiUyMDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>language_id = tokenizer.lang2id[<span class="hljs-string">&quot;en&quot;</span>]  <span class="hljs-comment"># 0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = torch.tensor([language_id] * input_ids.shape[<span class="hljs-number">1</span>])  <span class="hljs-comment"># torch.tensor([0, 0, 0, ..., 0])</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We reshape it to be of size (batch_size, sequence_length)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = langs.view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>)  <span class="hljs-comment"># is now of shape [1, sequence_length] (we have a batch size of 1)</span>`,wrap:!1}}),W=new M({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUyQyUyMGxhbmdzJTNEbGFuZ3Mp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids, langs=langs)',wrap:!1}}),L=new f({props:{title:"XLM sem language embeddings",local:"xlm-sem-language-embeddings",headingTag:"h3"}}),F=new f({props:{title:"BERT",local:"bert",headingTag:"h2"}}),N=new f({props:{title:"XLM-RoBERTa",local:"xlm-roberta",headingTag:"h2"}}),S=new f({props:{title:"M2M100",local:"m2m100",headingTag:"h2"}}),ee=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME0yTTEwMEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyME0yTTEwMFRva2VuaXplciUwQSUwQWVuX3RleHQlMjAlM0QlMjAlMjJEbyUyMG5vdCUyMG1lZGRsZSUyMGluJTIwdGhlJTIwYWZmYWlycyUyMG9mJTIwd2l6YXJkcyUyQyUyMGZvciUyMHRoZXklMjBhcmUlMjBzdWJ0bGUlMjBhbmQlMjBxdWljayUyMHRvJTIwYW5nZXIuJTIyJTBBY2hpbmVzZV90ZXh0JTIwJTNEJTIwJTIyJUU0JUI4JThEJUU4JUE2JTgxJUU2JThGJTkyJUU2JTg5JThCJUU1JUI3JUFCJUU1JUI4JUFCJUU3JTlBJTg0JUU0JUJBJThCJUU1JThCJTk5JTJDJTIwJUU1JTlCJUEwJUU3JTgyJUJBJUU0JUJCJTk2JUU1JTgwJTkxJUU2JTk4JUFGJUU1JUJFJUFFJUU1JUE2JTk5JUU3JTlBJTg0JTJDJTIwJUU1JUJFJTg4JUU1JUJGJUFCJUU1JUIwJUIxJUU2JTlDJTgzJUU3JTk5JUJDJUU2JTgwJTkyLiUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyME0yTTEwMFRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtMm0xMDBfNDE4TSUyMiUyQyUyMHNyY19sYW5nJTNEJTIyemglMjIpJTBBbW9kZWwlMjAlM0QlMjBNMk0xMDBGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbTJtMTAwXzQxOE0lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> M2M100ForConditionalGeneration, M2M100Tokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>chinese_text = <span class="hljs-string">&quot;不要插手巫師的事務, 因為他們是微妙的, 很快就會發怒.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = M2M100Tokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>, src_lang=<span class="hljs-string">&quot;zh&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = M2M100ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>)`,wrap:!1}}),le=new M({props:{code:"ZW5jb2RlZF96aCUyMCUzRCUyMHRva2VuaXplcihjaGluZXNlX3RleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_zh = tokenizer(chinese_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),ae=new M({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF96aCUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIuZ2V0X2xhbmdfaWQoJTIyZW4lMjIpKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX3Rva2VucyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_zh, forced_bos_token_id=tokenizer.get_lang_id(<span class="hljs-string">&quot;en&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&#x27;Do not interfere with the matters of the witches, because they are delicate and will soon be angry.&#x27;</span>`,wrap:!1}}),ne=new f({props:{title:"MBart",local:"mbart",headingTag:"h2"}}),re=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFlbl90ZXh0JTIwJTNEJTIwJTIyRG8lMjBub3QlMjBtZWRkbGUlMjBpbiUyMHRoZSUyMGFmZmFpcnMlMjBvZiUyMHdpemFyZHMlMkMlMjBmb3IlMjB0aGV5JTIwYXJlJTIwc3VidGxlJTIwYW5kJTIwcXVpY2slMjB0byUyMGFuZ2VyLiUyMiUwQWZpX3RleHQlMjAlM0QlMjAlMjIlQzMlODRsJUMzJUE0JTIwc2VrYWFubnUlMjB2ZWxob2plbiUyMGFzaW9paGluJTJDJTIwc2lsbCVDMyVBNCUyMG5lJTIwb3ZhdCUyMGhpZW5vdmFyYWlzaWElMjBqYSUyMG5vcGVhc3RpJTIwdmloYWlzaWEuJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJmaV9GSSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fi_text = <span class="hljs-string">&quot;Älä sekaannu velhojen asioihin, sillä ne ovat hienovaraisia ja nopeasti vihaisia.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;fi_FI&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>)`,wrap:!1}}),pe=new M({props:{code:"ZW5jb2RlZF9lbiUyMCUzRCUyMHRva2VuaXplcihlbl90ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_en = tokenizer(en_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),ge=new M({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF9lbiUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIubGFuZ19jb2RlX3RvX2lkKCUyMmVuX1hYJTIyKSklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF90b2tlbnMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_en, forced_bos_token_id=tokenizer.lang_code_to_id(<span class="hljs-string">&quot;en_XX&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;Don&#x27;t interfere with the wizard&#x27;s affairs, because they are subtle, will soon get angry.&quot;</span>`,wrap:!1}}),Me=new il({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/pt/multilingual.md"}}),{c(){b=o("meta"),Je=a(),be=o("p"),Te=a(),r(J.$$.fragment),ye=a(),r(T.$$.fragment),he=a(),y=o("p"),y.innerHTML=yt,Ue=a(),r(h.$$.fragment),ke=a(),U=o("p"),U.textContent=ht,$e=a(),r(k.$$.fragment),we=a(),$=o("p"),$.textContent=Ut,je=a(),w=o("ul"),w.innerHTML=kt,xe=a(),j=o("p"),j.innerHTML=$t,ve=a(),x=o("p"),x.innerHTML=wt,Ze=a(),r(v.$$.fragment),Ce=a(),Z=o("p"),Z.innerHTML=jt,_e=a(),r(C.$$.fragment),Ie=a(),_=o("p"),_.textContent=xt,Xe=a(),r(I.$$.fragment),Ge=a(),X=o("p"),X.innerHTML=vt,ze=a(),r(G.$$.fragment),We=a(),z=o("p"),z.innerHTML=Zt,Ve=a(),r(W.$$.fragment),Le=a(),V=o("p"),V.innerHTML=Ct,Re=a(),r(L.$$.fragment),Ee=a(),R=o("p"),R.textContent=_t,Be=a(),E=o("ul"),E.innerHTML=It,Fe=a(),B=o("p"),B.textContent=Xt,qe=a(),r(F.$$.fragment),He=a(),q=o("p"),q.textContent=Gt,Qe=a(),H=o("ul"),H.innerHTML=zt,Ne=a(),Q=o("p"),Q.textContent=Wt,Ye=a(),r(N.$$.fragment),Ae=a(),Y=o("p"),Y.textContent=Vt,Pe=a(),A=o("ul"),A.innerHTML=Lt,Se=a(),P=o("p"),P.textContent=Rt,De=a(),r(S.$$.fragment),Ke=a(),D=o("p"),D.textContent=Et,Oe=a(),K=o("ul"),K.innerHTML=Bt,et=a(),O=o("p"),O.innerHTML=Ft,tt=a(),r(ee.$$.fragment),lt=a(),te=o("p"),te.textContent=qt,st=a(),r(le.$$.fragment),at=a(),se=o("p"),se.innerHTML=Ht,nt=a(),r(ae.$$.fragment),ot=a(),r(ne.$$.fragment),it=a(),oe=o("p"),oe.textContent=Qt,mt=a(),ie=o("ul"),ie.innerHTML=Nt,rt=a(),me=o("p"),me.innerHTML=Yt,dt=a(),r(re.$$.fragment),pt=a(),de=o("p"),de.textContent=At,ut=a(),r(pe.$$.fragment),gt=a(),ue=o("p"),ue.innerHTML=Pt,ct=a(),r(ge.$$.fragment),Mt=a(),ce=o("p"),ce.innerHTML=St,bt=a(),r(Me.$$.fragment),ft=a(),fe=o("p"),this.h()},l(e){const t=al("svelte-u9bgzb",document.head);b=i(t,"META",{name:!0,content:!0}),t.forEach(l),Je=n(e),be=i(e,"P",{}),Dt(be).forEach(l),Te=n(e),d(J.$$.fragment,e),ye=n(e),d(T.$$.fragment,e),he=n(e),y=i(e,"P",{"data-svelte-h":!0}),m(y)!=="svelte-16vg6ah"&&(y.innerHTML=yt),Ue=n(e),d(h.$$.fragment,e),ke=n(e),U=i(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-1b8wedt"&&(U.textContent=ht),$e=n(e),d(k.$$.fragment,e),we=n(e),$=i(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-1g05fmh"&&($.textContent=Ut),je=n(e),w=i(e,"UL",{"data-svelte-h":!0}),m(w)!=="svelte-bq7gp5"&&(w.innerHTML=kt),xe=n(e),j=i(e,"P",{"data-svelte-h":!0}),m(j)!=="svelte-1wzx267"&&(j.innerHTML=$t),ve=n(e),x=i(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-16xglvw"&&(x.innerHTML=wt),Ze=n(e),d(v.$$.fragment,e),Ce=n(e),Z=i(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1jlw8vy"&&(Z.innerHTML=jt),_e=n(e),d(C.$$.fragment,e),Ie=n(e),_=i(e,"P",{"data-svelte-h":!0}),m(_)!=="svelte-fdserj"&&(_.textContent=xt),Xe=n(e),d(I.$$.fragment,e),Ge=n(e),X=i(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-gr6p76"&&(X.innerHTML=vt),ze=n(e),d(G.$$.fragment,e),We=n(e),z=i(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-syxnxn"&&(z.innerHTML=Zt),Ve=n(e),d(W.$$.fragment,e),Le=n(e),V=i(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1olpich"&&(V.innerHTML=Ct),Re=n(e),d(L.$$.fragment,e),Ee=n(e),R=i(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-uu1fkj"&&(R.textContent=_t),Be=n(e),E=i(e,"UL",{"data-svelte-h":!0}),m(E)!=="svelte-1fta402"&&(E.innerHTML=It),Fe=n(e),B=i(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1647i4h"&&(B.textContent=Xt),qe=n(e),d(F.$$.fragment,e),He=n(e),q=i(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-1otw1i1"&&(q.textContent=Gt),Qe=n(e),H=i(e,"UL",{"data-svelte-h":!0}),m(H)!=="svelte-e6dubl"&&(H.innerHTML=zt),Ne=n(e),Q=i(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-188d9hb"&&(Q.textContent=Wt),Ye=n(e),d(N.$$.fragment,e),Ae=n(e),Y=i(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-1on8run"&&(Y.textContent=Vt),Pe=n(e),A=i(e,"UL",{"data-svelte-h":!0}),m(A)!=="svelte-10y283s"&&(A.innerHTML=Lt),Se=n(e),P=i(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1mo7moz"&&(P.textContent=Rt),De=n(e),d(S.$$.fragment,e),Ke=n(e),D=i(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-1uzzyuv"&&(D.textContent=Et),Oe=n(e),K=i(e,"UL",{"data-svelte-h":!0}),m(K)!=="svelte-1811mz9"&&(K.innerHTML=Bt),et=n(e),O=i(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-18dxqmr"&&(O.innerHTML=Ft),tt=n(e),d(ee.$$.fragment,e),lt=n(e),te=i(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-6ksz4d"&&(te.textContent=qt),st=n(e),d(le.$$.fragment,e),at=n(e),se=i(e,"P",{"data-svelte-h":!0}),m(se)!=="svelte-1k8y33q"&&(se.innerHTML=Ht),nt=n(e),d(ae.$$.fragment,e),ot=n(e),d(ne.$$.fragment,e),it=n(e),oe=i(e,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-i72hny"&&(oe.textContent=Qt),mt=n(e),ie=i(e,"UL",{"data-svelte-h":!0}),m(ie)!=="svelte-1wsg399"&&(ie.innerHTML=Nt),rt=n(e),me=i(e,"P",{"data-svelte-h":!0}),m(me)!=="svelte-134fnsi"&&(me.innerHTML=Yt),dt=n(e),d(re.$$.fragment,e),pt=n(e),de=i(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-u1agxv"&&(de.textContent=At),ut=n(e),d(pe.$$.fragment,e),gt=n(e),ue=i(e,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-ybbnzp"&&(ue.innerHTML=Pt),ct=n(e),d(ge.$$.fragment,e),Mt=n(e),ce=i(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-quxms0"&&(ce.innerHTML=St),bt=n(e),d(Me.$$.fragment,e),ft=n(e),fe=i(e,"P",{}),Dt(fe).forEach(l),this.h()},h(){Kt(b,"name","hf:doc:metadata"),Kt(b,"content",rl)},m(e,t){nl(document.head,b),s(e,Je,t),s(e,be,t),s(e,Te,t),p(J,e,t),s(e,ye,t),p(T,e,t),s(e,he,t),s(e,y,t),s(e,Ue,t),p(h,e,t),s(e,ke,t),s(e,U,t),s(e,$e,t),p(k,e,t),s(e,we,t),s(e,$,t),s(e,je,t),s(e,w,t),s(e,xe,t),s(e,j,t),s(e,ve,t),s(e,x,t),s(e,Ze,t),p(v,e,t),s(e,Ce,t),s(e,Z,t),s(e,_e,t),p(C,e,t),s(e,Ie,t),s(e,_,t),s(e,Xe,t),p(I,e,t),s(e,Ge,t),s(e,X,t),s(e,ze,t),p(G,e,t),s(e,We,t),s(e,z,t),s(e,Ve,t),p(W,e,t),s(e,Le,t),s(e,V,t),s(e,Re,t),p(L,e,t),s(e,Ee,t),s(e,R,t),s(e,Be,t),s(e,E,t),s(e,Fe,t),s(e,B,t),s(e,qe,t),p(F,e,t),s(e,He,t),s(e,q,t),s(e,Qe,t),s(e,H,t),s(e,Ne,t),s(e,Q,t),s(e,Ye,t),p(N,e,t),s(e,Ae,t),s(e,Y,t),s(e,Pe,t),s(e,A,t),s(e,Se,t),s(e,P,t),s(e,De,t),p(S,e,t),s(e,Ke,t),s(e,D,t),s(e,Oe,t),s(e,K,t),s(e,et,t),s(e,O,t),s(e,tt,t),p(ee,e,t),s(e,lt,t),s(e,te,t),s(e,st,t),p(le,e,t),s(e,at,t),s(e,se,t),s(e,nt,t),p(ae,e,t),s(e,ot,t),p(ne,e,t),s(e,it,t),s(e,oe,t),s(e,mt,t),s(e,ie,t),s(e,rt,t),s(e,me,t),s(e,dt,t),p(re,e,t),s(e,pt,t),s(e,de,t),s(e,ut,t),p(pe,e,t),s(e,gt,t),s(e,ue,t),s(e,ct,t),p(ge,e,t),s(e,Mt,t),s(e,ce,t),s(e,bt,t),p(Me,e,t),s(e,ft,t),s(e,fe,t),Jt=!0},p:el,i(e){Jt||(u(J.$$.fragment,e),u(T.$$.fragment,e),u(h.$$.fragment,e),u(k.$$.fragment,e),u(v.$$.fragment,e),u(C.$$.fragment,e),u(I.$$.fragment,e),u(G.$$.fragment,e),u(W.$$.fragment,e),u(L.$$.fragment,e),u(F.$$.fragment,e),u(N.$$.fragment,e),u(S.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(ae.$$.fragment,e),u(ne.$$.fragment,e),u(re.$$.fragment,e),u(pe.$$.fragment,e),u(ge.$$.fragment,e),u(Me.$$.fragment,e),Jt=!0)},o(e){g(J.$$.fragment,e),g(T.$$.fragment,e),g(h.$$.fragment,e),g(k.$$.fragment,e),g(v.$$.fragment,e),g(C.$$.fragment,e),g(I.$$.fragment,e),g(G.$$.fragment,e),g(W.$$.fragment,e),g(L.$$.fragment,e),g(F.$$.fragment,e),g(N.$$.fragment,e),g(S.$$.fragment,e),g(ee.$$.fragment,e),g(le.$$.fragment,e),g(ae.$$.fragment,e),g(ne.$$.fragment,e),g(re.$$.fragment,e),g(pe.$$.fragment,e),g(ge.$$.fragment,e),g(Me.$$.fragment,e),Jt=!1},d(e){e&&(l(Je),l(be),l(Te),l(ye),l(he),l(y),l(Ue),l(ke),l(U),l($e),l(we),l($),l(je),l(w),l(xe),l(j),l(ve),l(x),l(Ze),l(Ce),l(Z),l(_e),l(Ie),l(_),l(Xe),l(Ge),l(X),l(ze),l(We),l(z),l(Ve),l(Le),l(V),l(Re),l(Ee),l(R),l(Be),l(E),l(Fe),l(B),l(qe),l(He),l(q),l(Qe),l(H),l(Ne),l(Q),l(Ye),l(Ae),l(Y),l(Pe),l(A),l(Se),l(P),l(De),l(Ke),l(D),l(Oe),l(K),l(et),l(O),l(tt),l(lt),l(te),l(st),l(at),l(se),l(nt),l(ot),l(it),l(oe),l(mt),l(ie),l(rt),l(me),l(dt),l(pt),l(de),l(ut),l(gt),l(ue),l(ct),l(Mt),l(ce),l(bt),l(ft),l(fe)),l(b),c(J,e),c(T,e),c(h,e),c(k,e),c(v,e),c(C,e),c(I,e),c(G,e),c(W,e),c(L,e),c(F,e),c(N,e),c(S,e),c(ee,e),c(le,e),c(ae,e),c(ne,e),c(re,e),c(pe,e),c(ge,e),c(Me,e)}}}const rl='{"title":"Modelos multilinguísticos para inferência","local":"modelos-multilinguísticos-para-inferência","sections":[{"title":"XLM","local":"xlm","sections":[{"title":"XLM com language embeddings","local":"xlm-com-language-embeddings","sections":[],"depth":3},{"title":"XLM sem language embeddings","local":"xlm-sem-language-embeddings","sections":[],"depth":3}],"depth":2},{"title":"BERT","local":"bert","sections":[],"depth":2},{"title":"XLM-RoBERTa","local":"xlm-roberta","sections":[],"depth":2},{"title":"M2M100","local":"m2m100","sections":[],"depth":2},{"title":"MBart","local":"mbart","sections":[],"depth":2}],"depth":1}';function dl(Tt){return tl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bl extends ll{constructor(b){super(),sl(this,b,dl,ml,Ot,{})}}export{bl as component};
