import{s as Zt,n as Wt,o as Ct}from"../chunks/scheduler.85c25b89.js";import{S as Bt,i as kt,g as p,s as a,r as m,A as xt,h as i,f as e,c as n,j as Ut,u as o,x as r,k as $t,y as vt,a as l,v as c,d as h,t as J,w as M}from"../chunks/index.c9bcf812.js";import{C as Q}from"../chunks/CodeBlock.94efc595.js";import{H as V}from"../chunks/Heading.3c6e5b17.js";function Gt(Jt){let d,R,Y,H,g,F,w,Mt="<strong>AdvProp</strong> is an adversarial training scheme which treats adversarial examples as additional examples, to prevent overfitting. Key to the method is the usage of a separate auxiliary batch norm for adversarial examples, as they have different underlying distributions to normal examples.",A,j,dt='The weights from this model were ported from <a href="https://github.com/tensorflow/tpu" rel="nofollow">Tensorflow/TPU</a>.',S,T,z,y,gt="To load a pretrained model:",L,f,P,u,wt="To load and preprocess the image:",q,b,D,I,jt="To get the model predictions:",K,U,O,$,Tt="To get the top-5 predictions class names:",tt,Z,st,W,yt="Replace the model name with the variant you want to use, e.g. <code>tf_efficientnet_b0_ap</code>. You can find the IDs in the model summaries at the top of this page.",et,C,ft='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',lt,B,at,k,ut="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",nt,x,pt,v,bt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,it,G,mt,N,It='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',ot,E,rt,_,ct,X,ht;return g=new V({props:{title:"AdvProp (EfficientNet)",local:"advprop-efficientnet",headingTag:"h1"}}),T=new V({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),f=new Q({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3RmX2VmZmljaWVudG5ldF9iMF9hcCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_efficientnet_b0_ap&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new Q({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new Q({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),B=new V({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),x=new Q({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgndGZfZWZmaWNpZW50bmV0X2IwX2FwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_efficientnet_b0_ap&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),G=new V({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new V({props:{title:"Citation",local:"citation",headingTag:"h2"}}),_=new Q({props:{code:"JTQwbWlzYyU3QnhpZTIwMjBhZHZlcnNhcmlhbCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCQWR2ZXJzYXJpYWwlMjBFeGFtcGxlcyUyMEltcHJvdmUlMjBJbWFnZSUyMFJlY29nbml0aW9uJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCQ2loYW5nJTIwWGllJTIwYW5kJTIwTWluZ3hpbmclMjBUYW4lMjBhbmQlMjBCb3FpbmclMjBHb25nJTIwYW5kJTIwSmlhbmclMjBXYW5nJTIwYW5kJTIwQWxhbiUyMFl1aWxsZSUyMGFuZCUyMFF1b2MlMjBWLiUyMExlJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxOTExLjA5NjY1JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`@misc{xie2020adversarial,
      title={Adversarial Examples Improve Image Recognition}, 
      author={Cihang Xie <span class="hljs-keyword">and </span>Mingxing Tan <span class="hljs-keyword">and </span><span class="hljs-keyword">Boqing </span>Gong <span class="hljs-keyword">and </span><span class="hljs-keyword">Jiang </span>Wang <span class="hljs-keyword">and </span>Alan Yuille <span class="hljs-keyword">and </span>Quoc V. Le},
      year={<span class="hljs-number">2020</span>},
      eprint={<span class="hljs-number">1911</span>.<span class="hljs-number">09665</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),{c(){d=p("meta"),R=a(),Y=p("p"),H=a(),m(g.$$.fragment),F=a(),w=p("p"),w.innerHTML=Mt,A=a(),j=p("p"),j.innerHTML=dt,S=a(),m(T.$$.fragment),z=a(),y=p("p"),y.textContent=gt,L=a(),m(f.$$.fragment),P=a(),u=p("p"),u.textContent=wt,q=a(),m(b.$$.fragment),D=a(),I=p("p"),I.textContent=jt,K=a(),m(U.$$.fragment),O=a(),$=p("p"),$.textContent=Tt,tt=a(),m(Z.$$.fragment),st=a(),W=p("p"),W.innerHTML=yt,et=a(),C=p("p"),C.innerHTML=ft,lt=a(),m(B.$$.fragment),at=a(),k=p("p"),k.textContent=ut,nt=a(),m(x.$$.fragment),pt=a(),v=p("p"),v.innerHTML=bt,it=a(),m(G.$$.fragment),mt=a(),N=p("p"),N.innerHTML=It,ot=a(),m(E.$$.fragment),rt=a(),m(_.$$.fragment),ct=a(),X=p("p"),this.h()},l(t){const s=xt("svelte-u9bgzb",document.head);d=i(s,"META",{name:!0,content:!0}),s.forEach(e),R=n(t),Y=i(t,"P",{}),Ut(Y).forEach(e),H=n(t),o(g.$$.fragment,t),F=n(t),w=i(t,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1x6a5c1"&&(w.innerHTML=Mt),A=n(t),j=i(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-k8hpf1"&&(j.innerHTML=dt),S=n(t),o(T.$$.fragment,t),z=n(t),y=i(t,"P",{"data-svelte-h":!0}),r(y)!=="svelte-18ywhxh"&&(y.textContent=gt),L=n(t),o(f.$$.fragment,t),P=n(t),u=i(t,"P",{"data-svelte-h":!0}),r(u)!=="svelte-1c2ipa8"&&(u.textContent=wt),q=n(t),o(b.$$.fragment,t),D=n(t),I=i(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1n9qsq1"&&(I.textContent=jt),K=n(t),o(U.$$.fragment,t),O=n(t),$=i(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-19cnvx1"&&($.textContent=Tt),tt=n(t),o(Z.$$.fragment,t),st=n(t),W=i(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-m13wpe"&&(W.innerHTML=yt),et=n(t),C=i(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1wmi3ea"&&(C.innerHTML=ft),lt=n(t),o(B.$$.fragment,t),at=n(t),k=i(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-9sr7nh"&&(k.textContent=ut),nt=n(t),o(x.$$.fragment,t),pt=n(t),v=i(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1kguc51"&&(v.innerHTML=bt),it=n(t),o(G.$$.fragment,t),mt=n(t),N=i(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1n0coha"&&(N.innerHTML=It),ot=n(t),o(E.$$.fragment,t),rt=n(t),o(_.$$.fragment,t),ct=n(t),X=i(t,"P",{}),Ut(X).forEach(e),this.h()},h(){$t(d,"name","hf:doc:metadata"),$t(d,"content",Nt)},m(t,s){vt(document.head,d),l(t,R,s),l(t,Y,s),l(t,H,s),c(g,t,s),l(t,F,s),l(t,w,s),l(t,A,s),l(t,j,s),l(t,S,s),c(T,t,s),l(t,z,s),l(t,y,s),l(t,L,s),c(f,t,s),l(t,P,s),l(t,u,s),l(t,q,s),c(b,t,s),l(t,D,s),l(t,I,s),l(t,K,s),c(U,t,s),l(t,O,s),l(t,$,s),l(t,tt,s),c(Z,t,s),l(t,st,s),l(t,W,s),l(t,et,s),l(t,C,s),l(t,lt,s),c(B,t,s),l(t,at,s),l(t,k,s),l(t,nt,s),c(x,t,s),l(t,pt,s),l(t,v,s),l(t,it,s),c(G,t,s),l(t,mt,s),l(t,N,s),l(t,ot,s),c(E,t,s),l(t,rt,s),c(_,t,s),l(t,ct,s),l(t,X,s),ht=!0},p:Wt,i(t){ht||(h(g.$$.fragment,t),h(T.$$.fragment,t),h(f.$$.fragment,t),h(b.$$.fragment,t),h(U.$$.fragment,t),h(Z.$$.fragment,t),h(B.$$.fragment,t),h(x.$$.fragment,t),h(G.$$.fragment,t),h(E.$$.fragment,t),h(_.$$.fragment,t),ht=!0)},o(t){J(g.$$.fragment,t),J(T.$$.fragment,t),J(f.$$.fragment,t),J(b.$$.fragment,t),J(U.$$.fragment,t),J(Z.$$.fragment,t),J(B.$$.fragment,t),J(x.$$.fragment,t),J(G.$$.fragment,t),J(E.$$.fragment,t),J(_.$$.fragment,t),ht=!1},d(t){t&&(e(R),e(Y),e(H),e(F),e(w),e(A),e(j),e(S),e(z),e(y),e(L),e(P),e(u),e(q),e(D),e(I),e(K),e(O),e($),e(tt),e(st),e(W),e(et),e(C),e(lt),e(at),e(k),e(nt),e(pt),e(v),e(it),e(mt),e(N),e(ot),e(rt),e(ct),e(X)),e(d),M(g,t),M(T,t),M(f,t),M(b,t),M(U,t),M(Z,t),M(B,t),M(x,t),M(G,t),M(E,t),M(_,t)}}}const Nt='{"title":"AdvProp (EfficientNet)","local":"advprop-efficientnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Et(Jt){return Ct(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vt extends Bt{constructor(d){super(),kt(this,d,Et,Gt,Zt,{})}}export{Vt as component};
