import{s as Ct,n as _t,o as Rt}from"../chunks/scheduler.7da89386.js";import{S as St,i as kt,g as i,s as a,r as m,A as Qt,h as p,f as l,c as n,j as $t,u as o,x as b,k as ot,y as Nt,a as s,v as r,d,t as u,w as c}from"../chunks/index.20910acc.js";import{C as M}from"../chunks/CodeBlock.143bd81e.js";import{H as h}from"../chunks/getInferenceSnippets.3bc14635.js";function Ft(rt){let y,ce,de,be,w,Me,J,he,Z,dt=`Stable Diffusion models can also be used when running inference with OpenVINO. When Stable Diffusion models
are exported to the OpenVINO format, they are decomposed into different components that are later combined during inference:`,ye,U,ut="<li>The text encoder</li> <li>The U-NET</li> <li>The VAE encoder</li> <li>The VAE decoder</li>",fe,T,ct="<thead><tr><th>Task</th> <th>Auto Class</th></tr></thead> <tbody><tr><td><code>text-to-image</code></td> <td><code>OVStableDiffusionPipeline</code></td></tr> <tr><td><code>image-to-image</code></td> <td><code>OVStableDiffusionImg2ImgPipeline</code></td></tr> <tr><td><code>inpaint</code></td> <td><code>OVStableDiffusionInpaintPipeline</code></td></tr></tbody>",we,g,Je,W,bt="Here is an example of how you can load an OpenVINO Stable Diffusion model and run inference using OpenVINO Runtime:",Ze,j,Ue,G,Mt="To load your PyTorch model and convert it to OpenVINO on the fly, you can set <code>export=True</code>.",Te,B,ge,v,ht="To further speed up inference, the model can be statically reshaped :",We,V,je,x,yt="In case you want to change any parameters such as the outputs height or width, you’ll need to statically reshape your model once again.",Ge,f,ft='<img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/stable_diffusion_v1_5_sail_boat_rembrandt.png"/>',Be,I,ve,X,wt="Here is an example of how you can load an OpenVINO Stable Diffusion model with pre-trained textual inversion embeddings and run inference using OpenVINO Runtime:",Ve,$,Jt="First, you can run original pipeline without textual inversion",xe,C,Ie,_,Zt='Then, you can load <a href="https://huggingface.co/sd-concepts-library/cat-toy" rel="nofollow">sd-concepts-library/cat-toy</a> textual inversion embedding and run pipeline with same prompt again',Xe,R,$e,S,Ut="The left image shows the generation result of original stable diffusion v1.5, the right image shows the generation result of stable diffusion v1.5 with textual inversion.",Ce,k,Tt='<thead><tr><th></th> <th></th></tr></thead> <tbody><tr><td><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/textual_inversion/stable_diffusion_v1_5_without_textual_inversion.png"/></td> <td><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/textual_inversion/stable_diffusion_v1_5_with_textual_inversion.png"/></td></tr></tbody>',_e,Q,Re,N,Se,F,ke,Y,gt="<thead><tr><th>Task</th> <th>Auto Class</th></tr></thead> <tbody><tr><td><code>text-to-image</code></td> <td><code>OVStableDiffusionXLPipeline</code></td></tr> <tr><td><code>image-to-image</code></td> <td><code>OVStableDiffusionXLImg2ImgPipeline</code></td></tr></tbody>",Qe,z,Ne,H,Wt='Here is an example of how you can load a SDXL OpenVINO model from <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a> and run inference using OpenVINO Runtime:',Fe,E,Ye,L,jt='<thead><tr><th></th> <th></th></tr></thead> <tbody><tr><td><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/train_station_friedrich.png"/></td> <td><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/train_station_friedrich_2.png"/></td></tr></tbody>',ze,q,He,D,Gt='Here is an example of how you can load an SDXL OpenVINO model from <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a> with pre-trained textual inversion embeddings and run inference using OpenVINO Runtime:',Ee,P,Bt="First, you can run original pipeline without textual inversion",Le,O,qe,A,vt='Then, you can load <a href="https://civitai.com/models/3036/charturner-character-turnaround-helper-for-15-and-21" rel="nofollow">charturnerv2</a> textual inversion embedding and run pipeline with same prompt again',De,K,Pe,ee,Oe,te,Vt="Here is an example of how you can load a PyTorch SDXL model, convert it to OpenVINO on-the-fly and run inference using OpenVINO Runtime for <em>image-to-image</em>:",Ae,le,Ke,se,et,ae,xt='The image can be refined by making use of a model like <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-refiner-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-refiner-1.0</a>. In this case, you only have to output the latents from the base model.',tt,ne,lt,ie,st,pe,It="<thead><tr><th>Task</th> <th>Auto Class</th></tr></thead> <tbody><tr><td><code>text-to-image</code></td> <td><code>OVLatentConsistencyModelPipeline</code></td></tr></tbody>",at,me,nt,oe,Xt='Here is an example of how you can load a Latent Consistency Model (LCM) from <a href="https://huggingface.co/SimianLuo/LCM_Dreamshaper_v7" rel="nofollow">SimianLuo/LCM_Dreamshaper_v7</a> and run inference using OpenVINO :',it,re,pt,ue,mt;return w=new h({props:{title:"Generate images with Diffusion models",local:"generate-images-with-diffusion-models",headingTag:"h1"}}),J=new h({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h2"}}),g=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),j=new M({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVlN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJlY2hhcmxhaXglMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUtb3BlbnZpbm8lMjIlMEFwaXBlbGluZSUyMCUzRCUyME9WU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXByb21wdCUyMCUzRCUyMCUyMnNhaWxpbmclMjBzaGlwJTIwaW4lMjBzdG9ybSUyMGJ5JTIwUmVtYnJhbmR0JTIyJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0KS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionPipeline

model_id = <span class="hljs-string">&quot;echarlaix/stable-diffusion-v1-5-openvino&quot;</span>
pipeline = OVStableDiffusionPipeline.from_pretrained(model_id)
prompt = <span class="hljs-string">&quot;sailing ship in storm by Rembrandt&quot;</span>
images = pipeline(prompt).images`,wrap:!1}}),B=new M({props:{code:"bW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGVsaW5lJTIwJTNEJTIwT1ZTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlKSUwQSUyMyUyMERvbid0JTIwZm9yZ2V0JTIwdG8lMjBzYXZlJTIwdGhlJTIwZXhwb3J0ZWQlMjBtb2RlbCUwQXBpcGVsaW5lLnNhdmVfcHJldHJhaW5lZCglMjJvcGVudmluby1zZC12MS01JTIyKQ==",highlighted:`model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipeline = OVStableDiffusionPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)
<span class="hljs-comment"># Don&#x27;t forget to save the exported model</span>
pipeline.save_pretrained(<span class="hljs-string">&quot;openvino-sd-v1-5&quot;</span>)`,wrap:!1}}),V=new M({props:{code:"JTIzJTIwRGVmaW5lJTIwdGhlJTIwc2hhcGVzJTIwcmVsYXRlZCUyMHRvJTIwdGhlJTIwaW5wdXRzJTIwYW5kJTIwZGVzaXJlZCUyMG91dHB1dHMlMEFiYXRjaF9zaXplJTJDJTIwbnVtX2ltYWdlcyUyQyUyMGhlaWdodCUyQyUyMHdpZHRoJTIwJTNEJTIwMSUyQyUyMDElMkMlMjA1MTIlMkMlMjA1MTIlMEElMjMlMjBTdGF0aWNhbGx5JTIwcmVzaGFwZSUyMHRoZSUyMG1vZGVsJTBBcGlwZWxpbmUucmVzaGFwZShiYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyQyUyMGhlaWdodCUzRGhlaWdodCUyQyUyMHdpZHRoJTNEd2lkdGglMkMlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0RudW1faW1hZ2VzKSUwQSUyMyUyMENvbXBpbGUlMjB0aGUlMjBtb2RlbCUyMGJlZm9yZSUyMHRoZSUyMGZpcnN0JTIwaW5mZXJlbmNlJTBBcGlwZWxpbmUuY29tcGlsZSgpJTBBJTBBJTIzJTIwUnVuJTIwaW5mZXJlbmNlJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaGVpZ2h0JTNEaGVpZ2h0JTJDJTIwd2lkdGglM0R3aWR0aCUyQyUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCUzRG51bV9pbWFnZXMpLmltYWdlcw==",highlighted:`<span class="hljs-comment"># Define the shapes related to the inputs and desired outputs</span>
batch_size, num_images, height, width = <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">512</span>, <span class="hljs-number">512</span>
<span class="hljs-comment"># Statically reshape the model</span>
pipeline.reshape(batch_size=batch_size, height=height, width=width, num_images_per_prompt=num_images)
<span class="hljs-comment"># Compile the model before the first inference</span>
pipeline.<span class="hljs-built_in">compile</span>()

<span class="hljs-comment"># Run inference</span>
images = pipeline(prompt, height=height, width=width, num_images_per_prompt=num_images).images`,wrap:!1}}),I=new h({props:{title:"Text-to-Image with Textual Inversion",local:"text-to-image-with-textual-inversion",headingTag:"h3"}}),C=new M({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVlN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJlY2hhcmxhaXglMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUtb3BlbnZpbm8lMjIlMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwJTNDY2F0LXRveSUzRSUyMGJhY2stcGFjayUyMiUwQSUyMyUyMFNldCUyMGElMjByYW5kb20lMjBzZWVkJTIwZm9yJTIwYmV0dGVyJTIwY29tcGFyaXNvbiUwQW5wLnJhbmRvbS5zZWVkKDQyKSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwT1ZTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RGYWxzZSUyQyUyMGNvbXBpbGUlM0RGYWxzZSklMEFwaXBlbGluZS5jb21waWxlKCklMEFpbWFnZTElMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZTEuc2F2ZSglMjJzdGFibGVfZGlmZnVzaW9uX3YxXzVfd2l0aG91dF90ZXh0dWFsX2ludmVyc2lvbi5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionPipeline
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

model_id = <span class="hljs-string">&quot;echarlaix/stable-diffusion-v1-5-openvino&quot;</span>
prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; back-pack&quot;</span>
<span class="hljs-comment"># Set a random seed for better comparison</span>
np.random.seed(<span class="hljs-number">42</span>)

pipeline = OVStableDiffusionPipeline.from_pretrained(model_id, export=<span class="hljs-literal">False</span>, <span class="hljs-built_in">compile</span>=<span class="hljs-literal">False</span>)
pipeline.<span class="hljs-built_in">compile</span>()
image1 = pipeline(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image1.save(<span class="hljs-string">&quot;stable_diffusion_v1_5_without_textual_inversion.png&quot;</span>)`,wrap:!1}}),R=new M({props:{code:"JTIzJTIwUmVzZXQlMjBzdGFibGUlMjBkaWZmdXNpb24lMjBwaXBlbGluZSUwQXBpcGVsaW5lLmNsZWFyX3JlcXVlc3RzKCklMEElMEElMjMlMjBMb2FkJTIwdGV4dHVhbCUyMGludmVyc2lvbiUyMGludG8lMjBzdGFibGUlMjBkaWZmdXNpb24lMjBwaXBlbGluZSUwQXBpcGVsaW5lLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIlMkMlMjAlMjIlM0NjYXQtdG95JTNFJTIyKSUwQSUwQSUyMyUyMENvbXBpbGUlMjB0aGUlMjBtb2RlbCUyMGJlZm9yZSUyMHRoZSUyMGZpcnN0JTIwaW5mZXJlbmNlJTBBcGlwZWxpbmUuY29tcGlsZSgpJTBBaW1hZ2UyJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2UyLnNhdmUoJTIyc3RhYmxlX2RpZmZ1c2lvbl92MV81X3dpdGhfdGV4dHVhbF9pbnZlcnNpb24ucG5nJTIyKQ==",highlighted:`<span class="hljs-comment"># Reset stable diffusion pipeline</span>
pipeline.clear_requests()

<span class="hljs-comment"># Load textual inversion into stable diffusion pipeline</span>
pipeline.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>, <span class="hljs-string">&quot;&lt;cat-toy&gt;&quot;</span>)

<span class="hljs-comment"># Compile the model before the first inference</span>
pipeline.<span class="hljs-built_in">compile</span>()
image2 = pipeline(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image2.save(<span class="hljs-string">&quot;stable_diffusion_v1_5_with_textual_inversion.png&quot;</span>)`,wrap:!1}}),Q=new h({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h3"}}),N=new M({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEFmcm9tJTIwb3B0aW11bS5pbnRlbCUyMGltcG9ydCUyME9WU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGVsaW5lJTIwJTNEJTIwT1ZTdGFibGVEaWZmdXNpb25JbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwZXhwb3J0JTNEVHJ1ZSklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbiUyRm1haW4lMkZhc3NldHMlMkZzdGFibGUtc2FtcGxlcyUyRmltZzJpbWclMkZza2V0Y2gtbW91bnRhaW5zLWlucHV0LmpwZyUyMiUwQXJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEFpbml0X2ltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFpbml0X2ltYWdlJTIwJTNEJTIwaW5pdF9pbWFnZS5yZXNpemUoKDc2OCUyQyUyMDUxMikpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGZhbnRhc3klMjBsYW5kc2NhcGUlMkMlMjB0cmVuZGluZyUyMG9uJTIwYXJ0c3RhdGlvbiUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwc3RyZW5ndGglM0QwLjc1JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q3LjUpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmZhbnRhc3lfbGFuZHNjYXBlLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionImg2ImgPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipeline = OVStableDiffusionImg2ImgPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>
response = requests.get(url)
init_image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
init_image = init_image.resize((<span class="hljs-number">768</span>, <span class="hljs-number">512</span>))
prompt = <span class="hljs-string">&quot;A fantasy landscape, trending on artstation&quot;</span>
image = pipeline(prompt=prompt, image=init_image, strength=<span class="hljs-number">0.75</span>, guidance_scale=<span class="hljs-number">7.5</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;fantasy_landscape.png&quot;</span>)`,wrap:!1}}),F=new h({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),z=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),E=new M({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVlN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUwQWJhc2UlMjAlM0QlMjBPVlN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXByb21wdCUyMCUzRCUyMCUyMnRyYWluJTIwc3RhdGlvbiUyMGJ5JTIwQ2FzcGFyJTIwRGF2aWQlMjBGcmllZHJpY2glMjIlMEFpbWFnZSUyMCUzRCUyMGJhc2UocHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJ0cmFpbl9zdGF0aW9uLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionXLPipeline

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
base = OVStableDiffusionXLPipeline.from_pretrained(model_id)
prompt = <span class="hljs-string">&quot;train station by Caspar David Friedrich&quot;</span>
image = base(prompt).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;train_station.png&quot;</span>)`,wrap:!1}}),q=new h({props:{title:"Text-to-Image with Textual Inversion",local:"text-to-image-with-textual-inversion",headingTag:"h3"}}),O=new M({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVlN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMHdlYXJpbmclMjBhJTIwcmVkJTIwamFja2V0JTIwYW5kJTIwYmxhY2slMjBzaGlydCUyQyUyMGJlc3QlMjBxdWFsaXR5JTJDJTIwaW50cmljYXRlJTIwZGV0YWlscy4lMjIlMEElMjMlMjBTZXQlMjBhJTIwcmFuZG9tJTIwc2VlZCUyMGZvciUyMGJldHRlciUyMGNvbXBhcmlzb24lMEFucC5yYW5kb20uc2VlZCgxMTIpJTBBJTBBYmFzZSUyMCUzRCUyME9WU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RGYWxzZSUyQyUyMGNvbXBpbGUlM0RGYWxzZSklMEFiYXNlLmNvbXBpbGUoKSUwQWltYWdlMSUyMCUzRCUyMGJhc2UocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2UxLnNhdmUoJTIyc2R4bF93aXRob3V0X3RleHR1YWxfaW52ZXJzaW9uLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionXLPipeline
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround wearing a red jacket and black shirt, best quality, intricate details.&quot;</span>
<span class="hljs-comment"># Set a random seed for better comparison</span>
np.random.seed(<span class="hljs-number">112</span>)

base = OVStableDiffusionXLPipeline.from_pretrained(model_id, export=<span class="hljs-literal">False</span>, <span class="hljs-built_in">compile</span>=<span class="hljs-literal">False</span>)
base.<span class="hljs-built_in">compile</span>()
image1 = base(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image1.save(<span class="hljs-string">&quot;sdxl_without_textual_inversion.png&quot;</span>)`,wrap:!1}}),K=new M({props:{code:"JTIzJTIwUmVzZXQlMjBzdGFibGUlMjBkaWZmdXNpb24lMjBwaXBlbGluZSUwQWJhc2UuY2xlYXJfcmVxdWVzdHMoKSUwQSUwQSUyMyUyMExvYWQlMjB0ZXh0dWFsJTIwaW52ZXJzaW9uJTIwaW50byUyMHN0YWJsZSUyMGRpZmZ1c2lvbiUyMHBpcGVsaW5lJTBBYmFzZS5sb2FkX3RleHR1YWxfaW52ZXJzaW9uKCUyMi4lMkZjaGFydHVybmVydjIucHQlMjIlMkMlMjAlMjJjaGFydHVybmVydjIlMjIpJTBBJTBBJTIzJTIwQ29tcGlsZSUyMHRoZSUyMG1vZGVsJTIwYmVmb3JlJTIwdGhlJTIwZmlyc3QlMjBpbmZlcmVuY2UlMEFiYXNlLmNvbXBpbGUoKSUwQWltYWdlMiUyMCUzRCUyMGJhc2UocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2UyLnNhdmUoJTIyc2R4bF93aXRoX3RleHR1YWxfaW52ZXJzaW9uLnBuZyUyMik=",highlighted:`<span class="hljs-comment"># Reset stable diffusion pipeline</span>
base.clear_requests()

<span class="hljs-comment"># Load textual inversion into stable diffusion pipeline</span>
base.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, <span class="hljs-string">&quot;charturnerv2&quot;</span>)

<span class="hljs-comment"># Compile the model before the first inference</span>
base.<span class="hljs-built_in">compile</span>()
image2 = base(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image2.save(<span class="hljs-string">&quot;sdxl_with_textual_inversion.png&quot;</span>)`,wrap:!1}}),ee=new h({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h3"}}),le=new M({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVlN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1yZWZpbmVyLTEuMCUyMiUwQXBpcGVsaW5lJTIwJTNEJTIwT1ZTdGFibGVEaWZmdXNpb25YTEltZzJJbWdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRm9wdGltdW0lMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGaW50ZWwlMkZvcGVudmlubyUyRnNkX3hsJTJGY2FzdGxlX2ZyaWVkcmljaC5wbmclMjIlMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UodXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJtZWRpZXZhbCUyMGNhc3RsZSUyMGJ5JTIwQ2FzcGFyJTIwRGF2aWQlMjBGcmllZHJpY2glMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGltYWdlJTNEaW1hZ2UpLmltYWdlcyU1QjAlNUQlMEElMjMlMjBEb24ndCUyMGZvcmdldCUyMHRvJTIwc2F2ZSUyMHlvdXIlMjBPcGVuVklOTyUyMG1vZGVsJTIwc28lMjB0aGF0JTIweW91JTIwY2FuJTIwbG9hZCUyMGl0JTIwd2l0aG91dCUyMGV4cG9ydGluZyUyMGl0JTIwd2l0aCUyMCU2MGV4cG9ydCUzRFRydWUlNjAlMEFwaXBlbGluZS5zYXZlX3ByZXRyYWluZWQoJTIyb3BlbnZpbm8tc2QteGwtcmVmaW5lci0xLjAlMjIp",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionXLImg2ImgPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>
pipeline = OVStableDiffusionXLImg2ImgPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/castle_friedrich.png&quot;</span>
image = load_image(url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
prompt = <span class="hljs-string">&quot;medieval castle by Caspar David Friedrich&quot;</span>
image = pipeline(prompt, image=image).images[<span class="hljs-number">0</span>]
<span class="hljs-comment"># Don&#x27;t forget to save your OpenVINO model so that you can load it without exporting it with \`export=True\`</span>
pipeline.save_pretrained(<span class="hljs-string">&quot;openvino-sd-xl-refiner-1.0&quot;</span>)`,wrap:!1}}),se=new h({props:{title:"Refining the image output",local:"refining-the-image-output",headingTag:"h3"}}),ne=new M({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVlN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtcmVmaW5lci0xLjAlMjIlMEFyZWZpbmVyJTIwJTNEJTIwT1ZTdGFibGVEaWZmdXNpb25YTEltZzJJbWdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlKSUwQSUwQWltYWdlJTIwJTNEJTIwYmFzZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBvdXRwdXRfdHlwZSUzRCUyMmxhdGVudCUyMikuaW1hZ2VzJTVCMCU1RCUwQWltYWdlJTIwJTNEJTIwcmVmaW5lcihwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGltYWdlJTVCTm9uZSUyQyUyMCUzQSU1RCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionXLImg2ImgPipeline

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>
refiner = OVStableDiffusionXLImg2ImgPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)

image = base(prompt=prompt, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]
image = refiner(prompt=prompt, image=image[<span class="hljs-literal">None</span>, :]).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ie=new h({props:{title:"Latent Consistency Models",local:"latent-consistency-models",headingTag:"h2"}}),me=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),re=new M({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVkxhdGVudENvbnNpc3RlbmN5TW9kZWxQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyU2ltaWFuTHVvJTJGTENNX0RyZWFtc2hhcGVyX3Y3JTIyJTBBcGlwZWxpbmUlMjAlM0QlMjBPVkxhdGVudENvbnNpc3RlbmN5TW9kZWxQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlKSUwQXByb21wdCUyMCUzRCUyMCUyMnNhaWxpbmclMjBzaGlwJTIwaW4lMjBzdG9ybSUyMGJ5JTIwTGVvbmFyZG8lMjBkYSUyMFZpbmNpJTIyJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDguMCkuaW1hZ2Vz",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVLatentConsistencyModelPipeline

model_id = <span class="hljs-string">&quot;SimianLuo/LCM_Dreamshaper_v7&quot;</span>
pipeline = OVLatentConsistencyModelPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)
prompt = <span class="hljs-string">&quot;sailing ship in storm by Leonardo da Vinci&quot;</span>
images = pipeline(prompt, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">8.0</span>).images`,wrap:!1}}),{c(){y=i("meta"),ce=a(),de=i("p"),be=a(),m(w.$$.fragment),Me=a(),m(J.$$.fragment),he=a(),Z=i("p"),Z.textContent=dt,ye=a(),U=i("ul"),U.innerHTML=ut,fe=a(),T=i("table"),T.innerHTML=ct,we=a(),m(g.$$.fragment),Je=a(),W=i("p"),W.textContent=bt,Ze=a(),m(j.$$.fragment),Ue=a(),G=i("p"),G.innerHTML=Mt,Te=a(),m(B.$$.fragment),ge=a(),v=i("p"),v.textContent=ht,We=a(),m(V.$$.fragment),je=a(),x=i("p"),x.textContent=yt,Ge=a(),f=i("div"),f.innerHTML=ft,Be=a(),m(I.$$.fragment),ve=a(),X=i("p"),X.textContent=wt,Ve=a(),$=i("p"),$.textContent=Jt,xe=a(),m(C.$$.fragment),Ie=a(),_=i("p"),_.innerHTML=Zt,Xe=a(),m(R.$$.fragment),$e=a(),S=i("p"),S.textContent=Ut,Ce=a(),k=i("table"),k.innerHTML=Tt,_e=a(),m(Q.$$.fragment),Re=a(),m(N.$$.fragment),Se=a(),m(F.$$.fragment),ke=a(),Y=i("table"),Y.innerHTML=gt,Qe=a(),m(z.$$.fragment),Ne=a(),H=i("p"),H.innerHTML=Wt,Fe=a(),m(E.$$.fragment),Ye=a(),L=i("table"),L.innerHTML=jt,ze=a(),m(q.$$.fragment),He=a(),D=i("p"),D.innerHTML=Gt,Ee=a(),P=i("p"),P.textContent=Bt,Le=a(),m(O.$$.fragment),qe=a(),A=i("p"),A.innerHTML=vt,De=a(),m(K.$$.fragment),Pe=a(),m(ee.$$.fragment),Oe=a(),te=i("p"),te.innerHTML=Vt,Ae=a(),m(le.$$.fragment),Ke=a(),m(se.$$.fragment),et=a(),ae=i("p"),ae.innerHTML=xt,tt=a(),m(ne.$$.fragment),lt=a(),m(ie.$$.fragment),st=a(),pe=i("table"),pe.innerHTML=It,at=a(),m(me.$$.fragment),nt=a(),oe=i("p"),oe.innerHTML=Xt,it=a(),m(re.$$.fragment),pt=a(),ue=i("p"),this.h()},l(e){const t=Qt("svelte-u9bgzb",document.head);y=p(t,"META",{name:!0,content:!0}),t.forEach(l),ce=n(e),de=p(e,"P",{}),$t(de).forEach(l),be=n(e),o(w.$$.fragment,e),Me=n(e),o(J.$$.fragment,e),he=n(e),Z=p(e,"P",{"data-svelte-h":!0}),b(Z)!=="svelte-1isd6gx"&&(Z.textContent=dt),ye=n(e),U=p(e,"UL",{"data-svelte-h":!0}),b(U)!=="svelte-bu3ryq"&&(U.innerHTML=ut),fe=n(e),T=p(e,"TABLE",{"data-svelte-h":!0}),b(T)!=="svelte-9sg8v5"&&(T.innerHTML=ct),we=n(e),o(g.$$.fragment,e),Je=n(e),W=p(e,"P",{"data-svelte-h":!0}),b(W)!=="svelte-t90xds"&&(W.textContent=bt),Ze=n(e),o(j.$$.fragment,e),Ue=n(e),G=p(e,"P",{"data-svelte-h":!0}),b(G)!=="svelte-1870w60"&&(G.innerHTML=Mt),Te=n(e),o(B.$$.fragment,e),ge=n(e),v=p(e,"P",{"data-svelte-h":!0}),b(v)!=="svelte-f1ib2z"&&(v.textContent=ht),We=n(e),o(V.$$.fragment,e),je=n(e),x=p(e,"P",{"data-svelte-h":!0}),b(x)!=="svelte-k76x21"&&(x.textContent=yt),Ge=n(e),f=p(e,"DIV",{class:!0,"data-svelte-h":!0}),b(f)!=="svelte-1bbei4i"&&(f.innerHTML=ft),Be=n(e),o(I.$$.fragment,e),ve=n(e),X=p(e,"P",{"data-svelte-h":!0}),b(X)!=="svelte-gj1zll"&&(X.textContent=wt),Ve=n(e),$=p(e,"P",{"data-svelte-h":!0}),b($)!=="svelte-1ephhdh"&&($.textContent=Jt),xe=n(e),o(C.$$.fragment,e),Ie=n(e),_=p(e,"P",{"data-svelte-h":!0}),b(_)!=="svelte-j9a9m8"&&(_.innerHTML=Zt),Xe=n(e),o(R.$$.fragment,e),$e=n(e),S=p(e,"P",{"data-svelte-h":!0}),b(S)!=="svelte-1ohkhi8"&&(S.textContent=Ut),Ce=n(e),k=p(e,"TABLE",{"data-svelte-h":!0}),b(k)!=="svelte-1sy4xw8"&&(k.innerHTML=Tt),_e=n(e),o(Q.$$.fragment,e),Re=n(e),o(N.$$.fragment,e),Se=n(e),o(F.$$.fragment,e),ke=n(e),Y=p(e,"TABLE",{"data-svelte-h":!0}),b(Y)!=="svelte-o49bnr"&&(Y.innerHTML=gt),Qe=n(e),o(z.$$.fragment,e),Ne=n(e),H=p(e,"P",{"data-svelte-h":!0}),b(H)!=="svelte-1kedcjk"&&(H.innerHTML=Wt),Fe=n(e),o(E.$$.fragment,e),Ye=n(e),L=p(e,"TABLE",{"data-svelte-h":!0}),b(L)!=="svelte-35z5uj"&&(L.innerHTML=jt),ze=n(e),o(q.$$.fragment,e),He=n(e),D=p(e,"P",{"data-svelte-h":!0}),b(D)!=="svelte-1rl3w3v"&&(D.innerHTML=Gt),Ee=n(e),P=p(e,"P",{"data-svelte-h":!0}),b(P)!=="svelte-1ephhdh"&&(P.textContent=Bt),Le=n(e),o(O.$$.fragment,e),qe=n(e),A=p(e,"P",{"data-svelte-h":!0}),b(A)!=="svelte-197o8c3"&&(A.innerHTML=vt),De=n(e),o(K.$$.fragment,e),Pe=n(e),o(ee.$$.fragment,e),Oe=n(e),te=p(e,"P",{"data-svelte-h":!0}),b(te)!=="svelte-1g03pef"&&(te.innerHTML=Vt),Ae=n(e),o(le.$$.fragment,e),Ke=n(e),o(se.$$.fragment,e),et=n(e),ae=p(e,"P",{"data-svelte-h":!0}),b(ae)!=="svelte-1lzmdpv"&&(ae.innerHTML=xt),tt=n(e),o(ne.$$.fragment,e),lt=n(e),o(ie.$$.fragment,e),st=n(e),pe=p(e,"TABLE",{"data-svelte-h":!0}),b(pe)!=="svelte-veyn1t"&&(pe.innerHTML=It),at=n(e),o(me.$$.fragment,e),nt=n(e),oe=p(e,"P",{"data-svelte-h":!0}),b(oe)!=="svelte-5xcutu"&&(oe.innerHTML=Xt),it=n(e),o(re.$$.fragment,e),pt=n(e),ue=p(e,"P",{}),$t(ue).forEach(l),this.h()},h(){ot(y,"name","hf:doc:metadata"),ot(y,"content",Yt),ot(f,"class","flex justify-center")},m(e,t){Nt(document.head,y),s(e,ce,t),s(e,de,t),s(e,be,t),r(w,e,t),s(e,Me,t),r(J,e,t),s(e,he,t),s(e,Z,t),s(e,ye,t),s(e,U,t),s(e,fe,t),s(e,T,t),s(e,we,t),r(g,e,t),s(e,Je,t),s(e,W,t),s(e,Ze,t),r(j,e,t),s(e,Ue,t),s(e,G,t),s(e,Te,t),r(B,e,t),s(e,ge,t),s(e,v,t),s(e,We,t),r(V,e,t),s(e,je,t),s(e,x,t),s(e,Ge,t),s(e,f,t),s(e,Be,t),r(I,e,t),s(e,ve,t),s(e,X,t),s(e,Ve,t),s(e,$,t),s(e,xe,t),r(C,e,t),s(e,Ie,t),s(e,_,t),s(e,Xe,t),r(R,e,t),s(e,$e,t),s(e,S,t),s(e,Ce,t),s(e,k,t),s(e,_e,t),r(Q,e,t),s(e,Re,t),r(N,e,t),s(e,Se,t),r(F,e,t),s(e,ke,t),s(e,Y,t),s(e,Qe,t),r(z,e,t),s(e,Ne,t),s(e,H,t),s(e,Fe,t),r(E,e,t),s(e,Ye,t),s(e,L,t),s(e,ze,t),r(q,e,t),s(e,He,t),s(e,D,t),s(e,Ee,t),s(e,P,t),s(e,Le,t),r(O,e,t),s(e,qe,t),s(e,A,t),s(e,De,t),r(K,e,t),s(e,Pe,t),r(ee,e,t),s(e,Oe,t),s(e,te,t),s(e,Ae,t),r(le,e,t),s(e,Ke,t),r(se,e,t),s(e,et,t),s(e,ae,t),s(e,tt,t),r(ne,e,t),s(e,lt,t),r(ie,e,t),s(e,st,t),s(e,pe,t),s(e,at,t),r(me,e,t),s(e,nt,t),s(e,oe,t),s(e,it,t),r(re,e,t),s(e,pt,t),s(e,ue,t),mt=!0},p:_t,i(e){mt||(d(w.$$.fragment,e),d(J.$$.fragment,e),d(g.$$.fragment,e),d(j.$$.fragment,e),d(B.$$.fragment,e),d(V.$$.fragment,e),d(I.$$.fragment,e),d(C.$$.fragment,e),d(R.$$.fragment,e),d(Q.$$.fragment,e),d(N.$$.fragment,e),d(F.$$.fragment,e),d(z.$$.fragment,e),d(E.$$.fragment,e),d(q.$$.fragment,e),d(O.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(se.$$.fragment,e),d(ne.$$.fragment,e),d(ie.$$.fragment,e),d(me.$$.fragment,e),d(re.$$.fragment,e),mt=!0)},o(e){u(w.$$.fragment,e),u(J.$$.fragment,e),u(g.$$.fragment,e),u(j.$$.fragment,e),u(B.$$.fragment,e),u(V.$$.fragment,e),u(I.$$.fragment,e),u(C.$$.fragment,e),u(R.$$.fragment,e),u(Q.$$.fragment,e),u(N.$$.fragment,e),u(F.$$.fragment,e),u(z.$$.fragment,e),u(E.$$.fragment,e),u(q.$$.fragment,e),u(O.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(se.$$.fragment,e),u(ne.$$.fragment,e),u(ie.$$.fragment,e),u(me.$$.fragment,e),u(re.$$.fragment,e),mt=!1},d(e){e&&(l(ce),l(de),l(be),l(Me),l(he),l(Z),l(ye),l(U),l(fe),l(T),l(we),l(Je),l(W),l(Ze),l(Ue),l(G),l(Te),l(ge),l(v),l(We),l(je),l(x),l(Ge),l(f),l(Be),l(ve),l(X),l(Ve),l($),l(xe),l(Ie),l(_),l(Xe),l($e),l(S),l(Ce),l(k),l(_e),l(Re),l(Se),l(ke),l(Y),l(Qe),l(Ne),l(H),l(Fe),l(Ye),l(L),l(ze),l(He),l(D),l(Ee),l(P),l(Le),l(qe),l(A),l(De),l(Pe),l(Oe),l(te),l(Ae),l(Ke),l(et),l(ae),l(tt),l(lt),l(st),l(pe),l(at),l(nt),l(oe),l(it),l(pt),l(ue)),l(y),c(w,e),c(J,e),c(g,e),c(j,e),c(B,e),c(V,e),c(I,e),c(C,e),c(R,e),c(Q,e),c(N,e),c(F,e),c(z,e),c(E,e),c(q,e),c(O,e),c(K,e),c(ee,e),c(le,e),c(se,e),c(ne,e),c(ie,e),c(me,e),c(re,e)}}}const Yt='{"title":"Generate images with Diffusion models","local":"generate-images-with-diffusion-models","sections":[{"title":"Stable Diffusion","local":"stable-diffusion","sections":[{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"Text-to-Image with Textual Inversion","local":"text-to-image-with-textual-inversion","sections":[],"depth":3},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":3}],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"Text-to-Image with Textual Inversion","local":"text-to-image-with-textual-inversion","sections":[],"depth":3},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":3},{"title":"Refining the image output","local":"refining-the-image-output","sections":[],"depth":3}],"depth":2},{"title":"Latent Consistency Models","local":"latent-consistency-models","sections":[{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3}],"depth":2}],"depth":1}';function zt(rt){return Rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Dt extends St{constructor(y){super(),kt(this,y,zt,Ft,Ct,{})}}export{Dt as component};
