import{s as mt,o as ut}from"../chunks/scheduler.37c15a92.js";import{S as Tt,i as Ut,g as M,s as n,r as o,A as ht,h as p,f as t,c as a,j as wt,u as r,x as i,k as Jt,y as dt,a as e,v as c,d as y,t as j,w,m as Vs,n as $s}from"../chunks/index.2bf4358c.js";import{T as ks}from"../chunks/Tip.363c041f.js";import{C as u}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as bt}from"../chunks/CourseFloatingBanner.15ba07e6.js";import{H as U,E as It}from"../chunks/EditOnGithub.8916dc7c.js";function ft(h){let J;return{c(){J=Vs("This exercise can be run on a free Google Colab T4 GPU. For the best experience, follow along with the notebook linked above and try it out yourself.")},l(m){J=$s(m,"This exercise can be run on a free Google Colab T4 GPU. For the best experience, follow along with the notebook linked above and try it out yourself.")},m(m,T){e(m,J,T)},d(m){m&&t(J)}}}function Ct(h){let J;return{c(){J=Vs("We won't cover the details of LoRA in this chapter, but you can learn more in [Chapter 11](/en/chapter11/3).")},l(m){J=$s(m,"We won't cover the details of LoRA in this chapter, but you can learn more in [Chapter 11](/en/chapter11/3).")},m(m,T){e(m,J,T)},d(m){m&&t(J)}}}function gt(h){let J;return{c(){J=Vs("Training may take some time. You might not see rewards increase immediately - it can take 150-200 steps before you start seeing improvements. Be patient!")},l(m){J=$s(m,"Training may take some time. You might not see rewards increase immediately - it can take 150-200 steps before you start seeing improvements. Be patient!")},m(m,T){e(m,J,T)},d(m){m&&t(J)}}}function Bt(h){let J,m,T,gl,f,Bl,C,Al,g,Qs='In this exercise, you’ll fine-tune a model with GRPO (Group Relative Policy Optimization) using Unsloth, to improve a model’s reasoning capabilities. We covered GRPO in <a href="/en/chapter3/3">Chapter 3</a>.',Gl,B,Es="Unsloth is a library that accelerates LLM fine-tuning, making it possible to train models faster and with less computational resources. Unsloth is plugs into TRL, so we’ll build on what we learned in the previous sections, and adapt it for Unsloth specifics.",_l,d,Zl,A,kl,G,Rs="First, let’s install the necessary libraries. We’ll need Unsloth for the accelerated fine-tuning and vLLM for fast inference.",Vl,_,$l,Z,Ql,k,Ns="Unsloth provides a class (<code>FastLanguageModel</code>) that integrates transformers with Unsloth optimizations. Let’s import it:",El,V,Rl,$,vs="Now, let’s load Google’s Gemma 3 1B Instruct model and configure it for fine-tuning:",Nl,Q,vl,E,xs="This code loads the model in 4-bit quantization to save memory and applies LoRA (Low-Rank Adaptation) for efficient fine-tuning. The <code>target_modules</code> parameter specifies which layers of the model to fine-tune, and <code>use_gradient_checkpointing</code> enables training with longer contexts.",xl,b,Xl,R,Wl,N,Xs="For this exercise, we’ll use the GSM8K dataset, which contains grade school math problems. We’ll format the data to encourage the model to show its reasoning before providing an answer.",Yl,v,Ws="First, we will define the format of the prompts and answers:",ql,x,zl,X,Ys="Now, let’s prepare the dataset:",Fl,W,Hl,Y,qs="The dataset is prepared by extracting the answer from the dataset and formatting it as a string.",Sl,q,Ll,z,zs='As we discussed in <a href="/en/chapter13/4">an earlier page</a>, GRPO can use reward functions to guide the model’s learning based on verifiable criteria like length and formatting.',Dl,F,Fs="In this exercise, we’ll define several reward functions that encourage different aspects of good reasoning. For example, we’ll reward the model for providing an integer answer, and for following the strict format.",Pl,H,Kl,S,Hs="These reward functions serve different purposes:",Ol,L,Ss="<thead><tr><th>Reward Function</th> <th>Purpose</th></tr></thead> <tbody><tr><td><code>correctness_reward_func</code></td> <td>Rewards the model when its answer matches the correct answer</td></tr> <tr><td><code>int_reward_func</code></td> <td>Rewards the model for providing a numeric answer</td></tr> <tr><td><code>strict_format_reward_func</code> and <code>soft_format_reward_func</code></td> <td>Reward the model for following the specified format</td></tr> <tr><td><code>xmlcount_reward_func</code></td> <td>Rewards proper XML tag usage and penalizes extra content after the closing tags</td></tr></tbody>",ls,D,ss,P,Ls='Now we’ll set up the GRPO trainer with our model, tokenizer, and reward functions. This part follows the same approach as the <a href="/en/chapter12/5">previous exercise</a>.',ts,K,es,O,Ds="The <code>GRPOConfig</code> sets various hyperparameters for training:",ns,ll,Ps="<li><code>use_vllm</code>: Enables fast inference with vLLM</li> <li><code>learning_rate</code>: Controls how quickly the model learns</li> <li><code>num_generations</code>: Number of completions to generate for each prompt</li> <li><code>max_steps</code>: Total number of training steps to perform</li>",as,sl,Ks="Now let’s start the training:",Ms,tl,ps,I,is,el,os,nl,Os="After training, let’s test our model to see how it performs. First, we’ll save the LoRA weights:",rs,al,cs,Ml,lt="Now, let’s test the model with a new question:",ys,pl,js,il,st="You should see that the model now follows the specified format, showing its reasoning before providing an answer.",ws,ol,Js,rl,tt="Unsloth provides several options for saving your fine-tuned model, but we’ll focus on the most common.",ms,cl,us,yl,Ts,jl,et="We’ll push the model to the Hugging Face Hub using the <code>push_to_hub_merged</code> method. This method allows us to push the model in multiple quantization formats.",Us,wl,hs,Jl,nt="Unsloth also supports saving to GGUF format for use with llama.cpp:",ds,ml,bs,ul,at="The GGUF files can be used with llama.cpp or UI-based systems like Jan or Open WebUI.",Is,Tl,fs,Ul,Mt="In this exercise, you’ve learned how to:",Cs,hl,pt="<li>Set up Unsloth for accelerated fine-tuning</li> <li>Prepare data for GRPO training</li> <li>Define custom reward functions to guide the model’s learning</li> <li>Train a model using GRPO</li> <li>Test the fine-tuned model</li> <li>Save the model in various formats</li>",gs,dl,it="GRPO is a powerful technique for aligning language models with specific behaviors, and Unsloth makes it accessible even on limited hardware. By combining multiple reward functions, you can guide the model to follow a specific format while also improving its reasoning capabilities.",Bs,bl,ot="For more information and resources, check out:",As,Il,rt='<li><a href="https://docs.unsloth.ai/" rel="nofollow">Unsloth Documentation</a></li> <li><a href="https://discord.gg/unsloth" rel="nofollow">Unsloth Discord</a></li> <li><a href="https://github.com/unslothai/unsloth" rel="nofollow">Unsloth GitHub</a></li>',Gs,fl,_s,Cl,Zs;return f=new bt({props:{chapter:2,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/unslothai/notebooks/blob/main/nb/HuggingFace%20Course-Gemma3_(1B)-GRPO.ipynb"}]}}),C=new U({props:{title:"Practical Exercise: GRPO with Unsloth",local:"practical-exercise-grpo-with-unsloth",headingTag:"h1"}}),d=new ks({props:{$$slots:{default:[ft]},$$scope:{ctx:h}}}),A=new U({props:{title:"Install dependencies",local:"install-dependencies",headingTag:"h2"}}),_=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMHVuc2xvdGglMjB2bGxtJTBBcGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMHBpbGxvdw==",highlighted:`pip install unsloth vllm
pip install --upgrade pillow`,wrap:!1}}),Z=new U({props:{title:"Setting up Unsloth",local:"setting-up-unsloth",headingTag:"h2"}}),V=new u({props:{code:"ZnJvbSUyMHVuc2xvdGglMjBpbXBvcnQlMjBGYXN0TGFuZ3VhZ2VNb2RlbA==",highlighted:'<span class="hljs-keyword">from</span> unsloth <span class="hljs-keyword">import</span> FastLanguageModel',wrap:!1}}),Q=new u({props:{code:"ZnJvbSUyMHVuc2xvdGglMjBpbXBvcnQlMjBGYXN0TGFuZ3VhZ2VNb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbWF4X3NlcV9sZW5ndGglMjAlM0QlMjAxMDI0JTIwJTIwJTIzJTIwQ2FuJTIwaW5jcmVhc2UlMjBmb3IlMjBsb25nZXIlMjByZWFzb25pbmclMjB0cmFjZXMlMEFsb3JhX3JhbmslMjAlM0QlMjAzMiUyMCUyMCUyMyUyMExhcmdlciUyMHJhbmslMjAlM0QlMjBzbWFydGVyJTJDJTIwYnV0JTIwc2xvd2VyJTBBJTBBbW9kZWwlMkMlMjB0b2tlbml6ZXIlMjAlM0QlMjBGYXN0TGFuZ3VhZ2VNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfbmFtZSUzRCUyMmdvb2dsZSUyRmdlbW1hLTMtMWItaXQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRG1heF9zZXFfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUyMCUyMCUyMyUyMEZhbHNlJTIwZm9yJTIwTG9SQSUyMDE2Yml0JTBBJTIwJTIwJTIwJTIwZmFzdF9pbmZlcmVuY2UlM0RUcnVlJTJDJTIwJTIwJTIzJTIwRW5hYmxlJTIwdkxMTSUyMGZhc3QlMjBpbmZlcmVuY2UlMEElMjAlMjAlMjAlMjBtYXhfbG9yYV9yYW5rJTNEbG9yYV9yYW5rJTJDJTBBJTIwJTIwJTIwJTIwZ3B1X21lbW9yeV91dGlsaXphdGlvbiUzRDAuNiUyQyUyMCUyMCUyMyUyMFJlZHVjZSUyMGlmJTIwb3V0JTIwb2YlMjBtZW1vcnklMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjBGYXN0TGFuZ3VhZ2VNb2RlbC5nZXRfcGVmdF9tb2RlbCglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHIlM0Rsb3JhX3JhbmslMkMlMjAlMjAlMjMlMjBDaG9vc2UlMjBhbnklMjBudW1iZXIlMjAlM0UlMjAwJTIwISUyMFN1Z2dlc3RlZCUyMDglMkMlMjAxNiUyQyUyMDMyJTJDJTIwNjQlMkMlMjAxMjglMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnFfcHJvaiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmtfcHJvaiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnZfcHJvaiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm9fcHJvaiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmdhdGVfcHJvaiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVwX3Byb2olMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkb3duX3Byb2olMjIlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMjAlMjAlMjMlMjBSZW1vdmUlMjBRS1ZPJTIwaWYlMjBvdXQlMjBvZiUyMG1lbW9yeSUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0Rsb3JhX3JhbmslMkMlMEElMjAlMjAlMjAlMjB1c2VfZ3JhZGllbnRfY2hlY2twb2ludGluZyUzRCUyMnVuc2xvdGglMjIlMkMlMjAlMjAlMjMlMjBFbmFibGUlMjBsb25nJTIwY29udGV4dCUyMGZpbmV0dW5pbmclMEElMjAlMjAlMjAlMjByYW5kb21fc3RhdGUlM0QzNDA3JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> unsloth <span class="hljs-keyword">import</span> FastLanguageModel
<span class="hljs-keyword">import</span> torch

max_seq_length = <span class="hljs-number">1024</span>  <span class="hljs-comment"># Can increase for longer reasoning traces</span>
lora_rank = <span class="hljs-number">32</span>  <span class="hljs-comment"># Larger rank = smarter, but slower</span>

model, tokenizer = FastLanguageModel.from_pretrained(
    model_name=<span class="hljs-string">&quot;google/gemma-3-1b-it&quot;</span>,
    max_seq_length=max_seq_length,
    load_in_4bit=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># False for LoRA 16bit</span>
    fast_inference=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Enable vLLM fast inference</span>
    max_lora_rank=lora_rank,
    gpu_memory_utilization=<span class="hljs-number">0.6</span>,  <span class="hljs-comment"># Reduce if out of memory</span>
)

model = FastLanguageModel.get_peft_model(
    model,
    r=lora_rank,  <span class="hljs-comment"># Choose any number &gt; 0 ! Suggested 8, 16, 32, 64, 128</span>
    target_modules=[
        <span class="hljs-string">&quot;q_proj&quot;</span>,
        <span class="hljs-string">&quot;k_proj&quot;</span>,
        <span class="hljs-string">&quot;v_proj&quot;</span>,
        <span class="hljs-string">&quot;o_proj&quot;</span>,
        <span class="hljs-string">&quot;gate_proj&quot;</span>,
        <span class="hljs-string">&quot;up_proj&quot;</span>,
        <span class="hljs-string">&quot;down_proj&quot;</span>,
    ],  <span class="hljs-comment"># Remove QKVO if out of memory</span>
    lora_alpha=lora_rank,
    use_gradient_checkpointing=<span class="hljs-string">&quot;unsloth&quot;</span>,  <span class="hljs-comment"># Enable long context finetuning</span>
    random_state=<span class="hljs-number">3407</span>,
)`,wrap:!1}}),b=new ks({props:{$$slots:{default:[Ct]},$$scope:{ctx:h}}}),R=new U({props:{title:"Data Preparation",local:"data-preparation",headingTag:"h2"}}),x=new u({props:{code:"",highlighted:`<span class="hljs-comment"># Define the system prompt that instructs the model to use a specific format</span>
SYSTEM_PROMPT = <span class="hljs-string">&quot;&quot;&quot;
Respond in the following format:
&lt;reasoning&gt;
...
&lt;/reasoning&gt;
&lt;answer&gt;
...
&lt;/answer&gt;
&quot;&quot;&quot;</span>

XML_COT_FORMAT = <span class="hljs-string">&quot;&quot;&quot;\\
&lt;reasoning&gt;
{reasoning}
&lt;/reasoning&gt;
&lt;answer&gt;
{answer}
&lt;/answer&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),W=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> re
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Dataset


<span class="hljs-comment"># Helper functions to extract answers from different formats</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_xml_answer</span>(<span class="hljs-params">text: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    answer = text.split(<span class="hljs-string">&quot;&lt;answer&gt;&quot;</span>)[-<span class="hljs-number">1</span>]
    answer = answer.split(<span class="hljs-string">&quot;&lt;/answer&gt;&quot;</span>)[<span class="hljs-number">0</span>]
    <span class="hljs-keyword">return</span> answer.strip()


<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_hash_answer</span>(<span class="hljs-params">text: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span> | <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;####&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> text:
        <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>
    <span class="hljs-keyword">return</span> text.split(<span class="hljs-string">&quot;####&quot;</span>)[<span class="hljs-number">1</span>].strip()


<span class="hljs-comment"># Function to prepare the GSM8K dataset</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_gsm8k_questions</span>(<span class="hljs-params">split=<span class="hljs-string">&quot;train&quot;</span></span>) -&gt; Dataset:
    data = load_dataset(<span class="hljs-string">&quot;openai/gsm8k&quot;</span>, <span class="hljs-string">&quot;main&quot;</span>)[split]
    data = data.<span class="hljs-built_in">map</span>(
        <span class="hljs-keyword">lambda</span> x: {
            <span class="hljs-string">&quot;prompt&quot;</span>: [
                {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: SYSTEM_PROMPT},
                {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: x[<span class="hljs-string">&quot;question&quot;</span>]},
            ],
            <span class="hljs-string">&quot;answer&quot;</span>: extract_hash_answer(x[<span class="hljs-string">&quot;answer&quot;</span>]),
        }
    )
    <span class="hljs-keyword">return</span> data


dataset = get_gsm8k_questions()`,wrap:!1}}),q=new U({props:{title:"Defining Reward Functions",local:"defining-reward-functions",headingTag:"h2"}}),H=new u({props:{code:"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",highlighted:`<span class="hljs-comment"># Reward function that checks if the answer is correct</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">correctness_reward_func</span>(<span class="hljs-params">prompts, completions, answer, **kwargs</span>) -&gt; <span class="hljs-built_in">list</span>[<span class="hljs-built_in">float</span>]:
    responses = [completion[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;content&quot;</span>] <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions]
    q = prompts[<span class="hljs-number">0</span>][-<span class="hljs-number">1</span>][<span class="hljs-string">&quot;content&quot;</span>]
    extracted_responses = [extract_xml_answer(r) <span class="hljs-keyword">for</span> r <span class="hljs-keyword">in</span> responses]
    <span class="hljs-built_in">print</span>(
        <span class="hljs-string">&quot;-&quot;</span> * <span class="hljs-number">20</span>,
        <span class="hljs-string">f&quot;Question:\\n<span class="hljs-subst">{q}</span>&quot;</span>,
        <span class="hljs-string">f&quot;\\nAnswer:\\n<span class="hljs-subst">{answer[<span class="hljs-number">0</span>]}</span>&quot;</span>,
        <span class="hljs-string">f&quot;\\nResponse:\\n<span class="hljs-subst">{responses[<span class="hljs-number">0</span>]}</span>&quot;</span>,
        <span class="hljs-string">f&quot;\\nExtracted:\\n<span class="hljs-subst">{extracted_responses[<span class="hljs-number">0</span>]}</span>&quot;</span>,
    )
    <span class="hljs-keyword">return</span> [<span class="hljs-number">2.0</span> <span class="hljs-keyword">if</span> r == a <span class="hljs-keyword">else</span> <span class="hljs-number">0.0</span> <span class="hljs-keyword">for</span> r, a <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(extracted_responses, answer)]


<span class="hljs-comment"># Reward function that checks if the answer is an integer</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">int_reward_func</span>(<span class="hljs-params">completions, **kwargs</span>) -&gt; <span class="hljs-built_in">list</span>[<span class="hljs-built_in">float</span>]:
    responses = [completion[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;content&quot;</span>] <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions]
    extracted_responses = [extract_xml_answer(r) <span class="hljs-keyword">for</span> r <span class="hljs-keyword">in</span> responses]
    <span class="hljs-keyword">return</span> [<span class="hljs-number">0.5</span> <span class="hljs-keyword">if</span> r.isdigit() <span class="hljs-keyword">else</span> <span class="hljs-number">0.0</span> <span class="hljs-keyword">for</span> r <span class="hljs-keyword">in</span> extracted_responses]


<span class="hljs-comment"># Reward function that checks if the completion follows the strict format</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">strict_format_reward_func</span>(<span class="hljs-params">completions, **kwargs</span>) -&gt; <span class="hljs-built_in">list</span>[<span class="hljs-built_in">float</span>]:
    pattern = <span class="hljs-string">r&quot;^&lt;reasoning&gt;\\n.*?\\n&lt;/reasoning&gt;\\n&lt;answer&gt;\\n.*?\\n&lt;/answer&gt;\\n$&quot;</span>
    responses = [completion[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;content&quot;</span>] <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions]
    matches = [re.<span class="hljs-keyword">match</span>(pattern, r) <span class="hljs-keyword">for</span> r <span class="hljs-keyword">in</span> responses]
    <span class="hljs-keyword">return</span> [<span class="hljs-number">0.5</span> <span class="hljs-keyword">if</span> <span class="hljs-keyword">match</span> <span class="hljs-keyword">else</span> <span class="hljs-number">0.0</span> <span class="hljs-keyword">for</span> <span class="hljs-keyword">match</span> <span class="hljs-keyword">in</span> matches]


<span class="hljs-comment"># Reward function that checks if the completion follows a more relaxed format</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">soft_format_reward_func</span>(<span class="hljs-params">completions, **kwargs</span>) -&gt; <span class="hljs-built_in">list</span>[<span class="hljs-built_in">float</span>]:
    pattern = <span class="hljs-string">r&quot;&lt;reasoning&gt;.*?&lt;/reasoning&gt;\\s*&lt;answer&gt;.*?&lt;/answer&gt;&quot;</span>
    responses = [completion[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;content&quot;</span>] <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions]
    matches = [re.<span class="hljs-keyword">match</span>(pattern, r) <span class="hljs-keyword">for</span> r <span class="hljs-keyword">in</span> responses]
    <span class="hljs-keyword">return</span> [<span class="hljs-number">0.5</span> <span class="hljs-keyword">if</span> <span class="hljs-keyword">match</span> <span class="hljs-keyword">else</span> <span class="hljs-number">0.0</span> <span class="hljs-keyword">for</span> <span class="hljs-keyword">match</span> <span class="hljs-keyword">in</span> matches]


<span class="hljs-comment"># Reward function that counts XML tags and penalizes extra content</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">count_xml</span>(<span class="hljs-params">text</span>) -&gt; <span class="hljs-built_in">float</span>:
    count = <span class="hljs-number">0.0</span>
    <span class="hljs-keyword">if</span> text.count(<span class="hljs-string">&quot;&lt;reasoning&gt;\\n&quot;</span>) == <span class="hljs-number">1</span>:
        count += <span class="hljs-number">0.125</span>
    <span class="hljs-keyword">if</span> text.count(<span class="hljs-string">&quot;\\n&lt;/reasoning&gt;\\n&quot;</span>) == <span class="hljs-number">1</span>:
        count += <span class="hljs-number">0.125</span>
    <span class="hljs-keyword">if</span> text.count(<span class="hljs-string">&quot;\\n&lt;answer&gt;\\n&quot;</span>) == <span class="hljs-number">1</span>:
        count += <span class="hljs-number">0.125</span>
        count -= <span class="hljs-built_in">len</span>(text.split(<span class="hljs-string">&quot;\\n&lt;/answer&gt;\\n&quot;</span>)[-<span class="hljs-number">1</span>]) * <span class="hljs-number">0.001</span>
    <span class="hljs-keyword">if</span> text.count(<span class="hljs-string">&quot;\\n&lt;/answer&gt;&quot;</span>) == <span class="hljs-number">1</span>:
        count += <span class="hljs-number">0.125</span>
        count -= (<span class="hljs-built_in">len</span>(text.split(<span class="hljs-string">&quot;\\n&lt;/answer&gt;&quot;</span>)[-<span class="hljs-number">1</span>]) - <span class="hljs-number">1</span>) * <span class="hljs-number">0.001</span>
    <span class="hljs-keyword">return</span> count


<span class="hljs-keyword">def</span> <span class="hljs-title function_">xmlcount_reward_func</span>(<span class="hljs-params">completions, **kwargs</span>) -&gt; <span class="hljs-built_in">list</span>[<span class="hljs-built_in">float</span>]:
    contents = [completion[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;content&quot;</span>] <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions]
    <span class="hljs-keyword">return</span> [count_xml(c) <span class="hljs-keyword">for</span> c <span class="hljs-keyword">in</span> contents]`,wrap:!1}}),D=new U({props:{title:"Training with GRPO",local:"training-with-grpo",headingTag:"h2"}}),K=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> GRPOConfig, GRPOTrainer

max_prompt_length = <span class="hljs-number">256</span>

training_args = GRPOConfig(
    learning_rate=<span class="hljs-number">5e-6</span>,
    adam_beta1=<span class="hljs-number">0.9</span>,
    adam_beta2=<span class="hljs-number">0.99</span>,
    weight_decay=<span class="hljs-number">0.1</span>,
    warmup_ratio=<span class="hljs-number">0.1</span>,
    lr_scheduler_type=<span class="hljs-string">&quot;cosine&quot;</span>,
    optim=<span class="hljs-string">&quot;paged_adamw_8bit&quot;</span>,
    logging_steps=<span class="hljs-number">1</span>,
    per_device_train_batch_size=<span class="hljs-number">1</span>,
    gradient_accumulation_steps=<span class="hljs-number">1</span>,  <span class="hljs-comment"># Increase to 4 for smoother training</span>
    num_generations=<span class="hljs-number">6</span>,  <span class="hljs-comment"># Decrease if out of memory</span>
    max_prompt_length=max_prompt_length,
    max_completion_length=max_seq_length - max_prompt_length,
    <span class="hljs-comment"># num_train_epochs = 1, # Set to 1 for a full training run</span>
    max_steps=<span class="hljs-number">250</span>,
    save_steps=<span class="hljs-number">250</span>,
    max_grad_norm=<span class="hljs-number">0.1</span>,
    report_to=<span class="hljs-string">&quot;none&quot;</span>,  <span class="hljs-comment"># Can use Weights &amp; Biases</span>
    output_dir=<span class="hljs-string">&quot;outputs&quot;</span>,
)

trainer = GRPOTrainer(
    model=model,
    processing_class=tokenizer,
    reward_funcs=[
        xmlcount_reward_func,
        soft_format_reward_func,
        strict_format_reward_func,
        int_reward_func,
        correctness_reward_func,
    ],
    args=training_args,
    train_dataset=dataset,
)`,wrap:!1}}),tl=new u({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),I=new ks({props:{warning:!0,$$slots:{default:[gt]},$$scope:{ctx:h}}}),el=new U({props:{title:"Testing the Model",local:"testing-the-model",headingTag:"h2"}}),al=new u({props:{code:"bW9kZWwuc2F2ZV9sb3JhKCUyMmdycG9fc2F2ZWRfbG9yYSUyMik=",highlighted:'model.save_lora(<span class="hljs-string">&quot;grpo_saved_lora&quot;</span>)',wrap:!1}}),pl=new u({props:{code:"ZnJvbSUyMHZsbG0lMjBpbXBvcnQlMjBTYW1wbGluZ1BhcmFtcyUwQSUwQXRleHQlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMFNZU1RFTV9QUk9NUFQlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDYWxjdWxhdGUlMjBwaS4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUyQyUwQSklMEElMEFzYW1wbGluZ19wYXJhbXMlMjAlM0QlMjBTYW1wbGluZ1BhcmFtcyglMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuOCUyQyUwQSUyMCUyMCUyMCUyMHRvcF9wJTNEMC45NSUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDI0JTJDJTBBKSUwQW91dHB1dCUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjBtb2RlbC5mYXN0X2dlbmVyYXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRleHQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzYW1wbGluZ19wYXJhbXMlM0RzYW1wbGluZ19wYXJhbXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3JhX3JlcXVlc3QlM0Rtb2RlbC5sb2FkX2xvcmEoJTIyZ3Jwb19zYXZlZF9sb3JhJTIyKSUyQyUwQSUyMCUyMCUyMCUyMCklNUIwJTVEJTBBJTIwJTIwJTIwJTIwLm91dHB1dHMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwLnRleHQlMEEpJTBBJTBBcHJpbnQob3V0cHV0KQ==",highlighted:`<span class="hljs-keyword">from</span> vllm <span class="hljs-keyword">import</span> SamplingParams

text = tokenizer.apply_chat_template(
    [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: SYSTEM_PROMPT},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Calculate pi.&quot;</span>},
    ],
    tokenize=<span class="hljs-literal">False</span>,
    add_generation_prompt=<span class="hljs-literal">True</span>,
)

sampling_params = SamplingParams(
    temperature=<span class="hljs-number">0.8</span>,
    top_p=<span class="hljs-number">0.95</span>,
    max_tokens=<span class="hljs-number">1024</span>,
)
output = (
    model.fast_generate(
        text,
        sampling_params=sampling_params,
        lora_request=model.load_lora(<span class="hljs-string">&quot;grpo_saved_lora&quot;</span>),
    )[<span class="hljs-number">0</span>]
    .outputs[<span class="hljs-number">0</span>]
    .text
)

<span class="hljs-built_in">print</span>(output)`,wrap:!1}}),ol=new U({props:{title:"Saving the Model",local:"saving-the-model",headingTag:"h2"}}),cl=new u({props:{code:"JTIzJTIwU2F2ZSUyMHRvJTIwMTYtYml0JTIwcHJlY2lzaW9uJTBBbW9kZWwuc2F2ZV9wcmV0cmFpbmVkX21lcmdlZCglMjJtb2RlbCUyMiUyQyUyMHRva2VuaXplciUyQyUyMHNhdmVfbWV0aG9kJTNEJTIybWVyZ2VkXzE2Yml0JTIyKQ==",highlighted:`<span class="hljs-comment"># Save to 16-bit precision</span>
model.save_pretrained_merged(<span class="hljs-string">&quot;model&quot;</span>, tokenizer, save_method=<span class="hljs-string">&quot;merged_16bit&quot;</span>)`,wrap:!1}}),yl=new U({props:{title:"Pushing to Hugging Face Hub",local:"pushing-to-hugging-face-hub",headingTag:"h2"}}),wl=new u({props:{code:"JTIzJTIwUHVzaCUyMHRvJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIlMjAocmVxdWlyZXMlMjBhJTIwdG9rZW4pJTBBbW9kZWwucHVzaF90b19odWJfbWVyZ2VkKCUwQSUyMCUyMCUyMCUyMCUyMnlvdXItdXNlcm5hbWUlMkZtb2RlbC1uYW1lJTIyJTJDJTIwdG9rZW5pemVyJTJDJTIwc2F2ZV9tZXRob2QlM0QlMjJtZXJnZWRfMTZiaXQlMjIlMkMlMjB0b2tlbiUzRCUyMnlvdXItdG9rZW4lMjIlMEEp",highlighted:`<span class="hljs-comment"># Push to Hugging Face Hub (requires a token)</span>
model.push_to_hub_merged(
    <span class="hljs-string">&quot;your-username/model-name&quot;</span>, tokenizer, save_method=<span class="hljs-string">&quot;merged_16bit&quot;</span>, token=<span class="hljs-string">&quot;your-token&quot;</span>
)`,wrap:!1}}),ml=new u({props:{code:"bW9kZWwucHVzaF90b19odWJfZ2d1ZiglMEElMjAlMjAlMjAlMjAlMjJ5b3VyLXVzZXJuYW1lJTJGbW9kZWwtbmFtZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9tZXRob2QlM0QlNUIlMjJxNF9rX20lMjIlMkMlMjAlMjJxOF8wJTIyJTJDJTIwJTIycTVfa19tJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW4lM0QlMjJ5b3VyLXRva2VuJTIyJTJDJTBBKQ==",highlighted:`model.push_to_hub_gguf(
    <span class="hljs-string">&quot;your-username/model-name&quot;</span>,
    tokenizer,
    quantization_method=[<span class="hljs-string">&quot;q4_k_m&quot;</span>, <span class="hljs-string">&quot;q8_0&quot;</span>, <span class="hljs-string">&quot;q5_k_m&quot;</span>],
    token=<span class="hljs-string">&quot;your-token&quot;</span>,
)`,wrap:!1}}),Tl=new U({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),fl=new It({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter12/6.mdx"}}),{c(){J=M("meta"),m=n(),T=M("p"),gl=n(),o(f.$$.fragment),Bl=n(),o(C.$$.fragment),Al=n(),g=M("p"),g.innerHTML=Qs,Gl=n(),B=M("p"),B.textContent=Es,_l=n(),o(d.$$.fragment),Zl=n(),o(A.$$.fragment),kl=n(),G=M("p"),G.textContent=Rs,Vl=n(),o(_.$$.fragment),$l=n(),o(Z.$$.fragment),Ql=n(),k=M("p"),k.innerHTML=Ns,El=n(),o(V.$$.fragment),Rl=n(),$=M("p"),$.textContent=vs,Nl=n(),o(Q.$$.fragment),vl=n(),E=M("p"),E.innerHTML=xs,xl=n(),o(b.$$.fragment),Xl=n(),o(R.$$.fragment),Wl=n(),N=M("p"),N.textContent=Xs,Yl=n(),v=M("p"),v.textContent=Ws,ql=n(),o(x.$$.fragment),zl=n(),X=M("p"),X.textContent=Ys,Fl=n(),o(W.$$.fragment),Hl=n(),Y=M("p"),Y.textContent=qs,Sl=n(),o(q.$$.fragment),Ll=n(),z=M("p"),z.innerHTML=zs,Dl=n(),F=M("p"),F.textContent=Fs,Pl=n(),o(H.$$.fragment),Kl=n(),S=M("p"),S.textContent=Hs,Ol=n(),L=M("table"),L.innerHTML=Ss,ls=n(),o(D.$$.fragment),ss=n(),P=M("p"),P.innerHTML=Ls,ts=n(),o(K.$$.fragment),es=n(),O=M("p"),O.innerHTML=Ds,ns=n(),ll=M("ul"),ll.innerHTML=Ps,as=n(),sl=M("p"),sl.textContent=Ks,Ms=n(),o(tl.$$.fragment),ps=n(),o(I.$$.fragment),is=n(),o(el.$$.fragment),os=n(),nl=M("p"),nl.textContent=Os,rs=n(),o(al.$$.fragment),cs=n(),Ml=M("p"),Ml.textContent=lt,ys=n(),o(pl.$$.fragment),js=n(),il=M("p"),il.textContent=st,ws=n(),o(ol.$$.fragment),Js=n(),rl=M("p"),rl.textContent=tt,ms=n(),o(cl.$$.fragment),us=n(),o(yl.$$.fragment),Ts=n(),jl=M("p"),jl.innerHTML=et,Us=n(),o(wl.$$.fragment),hs=n(),Jl=M("p"),Jl.textContent=nt,ds=n(),o(ml.$$.fragment),bs=n(),ul=M("p"),ul.textContent=at,Is=n(),o(Tl.$$.fragment),fs=n(),Ul=M("p"),Ul.textContent=Mt,Cs=n(),hl=M("ol"),hl.innerHTML=pt,gs=n(),dl=M("p"),dl.textContent=it,Bs=n(),bl=M("p"),bl.textContent=ot,As=n(),Il=M("ul"),Il.innerHTML=rt,Gs=n(),o(fl.$$.fragment),_s=n(),Cl=M("p"),this.h()},l(l){const s=ht("svelte-u9bgzb",document.head);J=p(s,"META",{name:!0,content:!0}),s.forEach(t),m=a(l),T=p(l,"P",{}),wt(T).forEach(t),gl=a(l),r(f.$$.fragment,l),Bl=a(l),r(C.$$.fragment,l),Al=a(l),g=p(l,"P",{"data-svelte-h":!0}),i(g)!=="svelte-28ga60"&&(g.innerHTML=Qs),Gl=a(l),B=p(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-v44mtq"&&(B.textContent=Es),_l=a(l),r(d.$$.fragment,l),Zl=a(l),r(A.$$.fragment,l),kl=a(l),G=p(l,"P",{"data-svelte-h":!0}),i(G)!=="svelte-7apc0w"&&(G.textContent=Rs),Vl=a(l),r(_.$$.fragment,l),$l=a(l),r(Z.$$.fragment,l),Ql=a(l),k=p(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-uhz6q0"&&(k.innerHTML=Ns),El=a(l),r(V.$$.fragment,l),Rl=a(l),$=p(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-1o52er5"&&($.textContent=vs),Nl=a(l),r(Q.$$.fragment,l),vl=a(l),E=p(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-ihivum"&&(E.innerHTML=xs),xl=a(l),r(b.$$.fragment,l),Xl=a(l),r(R.$$.fragment,l),Wl=a(l),N=p(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1jqnhvo"&&(N.textContent=Xs),Yl=a(l),v=p(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-222xwa"&&(v.textContent=Ws),ql=a(l),r(x.$$.fragment,l),zl=a(l),X=p(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-uuip11"&&(X.textContent=Ys),Fl=a(l),r(W.$$.fragment,l),Hl=a(l),Y=p(l,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-yuvu2n"&&(Y.textContent=qs),Sl=a(l),r(q.$$.fragment,l),Ll=a(l),z=p(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1wqrmwt"&&(z.innerHTML=zs),Dl=a(l),F=p(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1bbmyq2"&&(F.textContent=Fs),Pl=a(l),r(H.$$.fragment,l),Kl=a(l),S=p(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-10lwv8u"&&(S.textContent=Hs),Ol=a(l),L=p(l,"TABLE",{"data-svelte-h":!0}),i(L)!=="svelte-beg5py"&&(L.innerHTML=Ss),ls=a(l),r(D.$$.fragment,l),ss=a(l),P=p(l,"P",{"data-svelte-h":!0}),i(P)!=="svelte-1h10geb"&&(P.innerHTML=Ls),ts=a(l),r(K.$$.fragment,l),es=a(l),O=p(l,"P",{"data-svelte-h":!0}),i(O)!=="svelte-1jo17wb"&&(O.innerHTML=Ds),ns=a(l),ll=p(l,"UL",{"data-svelte-h":!0}),i(ll)!=="svelte-eo3csz"&&(ll.innerHTML=Ps),as=a(l),sl=p(l,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-c65a8i"&&(sl.textContent=Ks),Ms=a(l),r(tl.$$.fragment,l),ps=a(l),r(I.$$.fragment,l),is=a(l),r(el.$$.fragment,l),os=a(l),nl=p(l,"P",{"data-svelte-h":!0}),i(nl)!=="svelte-dwjtn"&&(nl.textContent=Os),rs=a(l),r(al.$$.fragment,l),cs=a(l),Ml=p(l,"P",{"data-svelte-h":!0}),i(Ml)!=="svelte-6mnmyk"&&(Ml.textContent=lt),ys=a(l),r(pl.$$.fragment,l),js=a(l),il=p(l,"P",{"data-svelte-h":!0}),i(il)!=="svelte-n6ify3"&&(il.textContent=st),ws=a(l),r(ol.$$.fragment,l),Js=a(l),rl=p(l,"P",{"data-svelte-h":!0}),i(rl)!=="svelte-8mgtgx"&&(rl.textContent=tt),ms=a(l),r(cl.$$.fragment,l),us=a(l),r(yl.$$.fragment,l),Ts=a(l),jl=p(l,"P",{"data-svelte-h":!0}),i(jl)!=="svelte-5e9stk"&&(jl.innerHTML=et),Us=a(l),r(wl.$$.fragment,l),hs=a(l),Jl=p(l,"P",{"data-svelte-h":!0}),i(Jl)!=="svelte-hwdwrb"&&(Jl.textContent=nt),ds=a(l),r(ml.$$.fragment,l),bs=a(l),ul=p(l,"P",{"data-svelte-h":!0}),i(ul)!=="svelte-102ov0f"&&(ul.textContent=at),Is=a(l),r(Tl.$$.fragment,l),fs=a(l),Ul=p(l,"P",{"data-svelte-h":!0}),i(Ul)!=="svelte-onfwxy"&&(Ul.textContent=Mt),Cs=a(l),hl=p(l,"OL",{"data-svelte-h":!0}),i(hl)!=="svelte-j3tqlf"&&(hl.innerHTML=pt),gs=a(l),dl=p(l,"P",{"data-svelte-h":!0}),i(dl)!=="svelte-ntlp2y"&&(dl.textContent=it),Bs=a(l),bl=p(l,"P",{"data-svelte-h":!0}),i(bl)!=="svelte-1r9yves"&&(bl.textContent=ot),As=a(l),Il=p(l,"UL",{"data-svelte-h":!0}),i(Il)!=="svelte-1fz95oy"&&(Il.innerHTML=rt),Gs=a(l),r(fl.$$.fragment,l),_s=a(l),Cl=p(l,"P",{}),wt(Cl).forEach(t),this.h()},h(){Jt(J,"name","hf:doc:metadata"),Jt(J,"content",At)},m(l,s){dt(document.head,J),e(l,m,s),e(l,T,s),e(l,gl,s),c(f,l,s),e(l,Bl,s),c(C,l,s),e(l,Al,s),e(l,g,s),e(l,Gl,s),e(l,B,s),e(l,_l,s),c(d,l,s),e(l,Zl,s),c(A,l,s),e(l,kl,s),e(l,G,s),e(l,Vl,s),c(_,l,s),e(l,$l,s),c(Z,l,s),e(l,Ql,s),e(l,k,s),e(l,El,s),c(V,l,s),e(l,Rl,s),e(l,$,s),e(l,Nl,s),c(Q,l,s),e(l,vl,s),e(l,E,s),e(l,xl,s),c(b,l,s),e(l,Xl,s),c(R,l,s),e(l,Wl,s),e(l,N,s),e(l,Yl,s),e(l,v,s),e(l,ql,s),c(x,l,s),e(l,zl,s),e(l,X,s),e(l,Fl,s),c(W,l,s),e(l,Hl,s),e(l,Y,s),e(l,Sl,s),c(q,l,s),e(l,Ll,s),e(l,z,s),e(l,Dl,s),e(l,F,s),e(l,Pl,s),c(H,l,s),e(l,Kl,s),e(l,S,s),e(l,Ol,s),e(l,L,s),e(l,ls,s),c(D,l,s),e(l,ss,s),e(l,P,s),e(l,ts,s),c(K,l,s),e(l,es,s),e(l,O,s),e(l,ns,s),e(l,ll,s),e(l,as,s),e(l,sl,s),e(l,Ms,s),c(tl,l,s),e(l,ps,s),c(I,l,s),e(l,is,s),c(el,l,s),e(l,os,s),e(l,nl,s),e(l,rs,s),c(al,l,s),e(l,cs,s),e(l,Ml,s),e(l,ys,s),c(pl,l,s),e(l,js,s),e(l,il,s),e(l,ws,s),c(ol,l,s),e(l,Js,s),e(l,rl,s),e(l,ms,s),c(cl,l,s),e(l,us,s),c(yl,l,s),e(l,Ts,s),e(l,jl,s),e(l,Us,s),c(wl,l,s),e(l,hs,s),e(l,Jl,s),e(l,ds,s),c(ml,l,s),e(l,bs,s),e(l,ul,s),e(l,Is,s),c(Tl,l,s),e(l,fs,s),e(l,Ul,s),e(l,Cs,s),e(l,hl,s),e(l,gs,s),e(l,dl,s),e(l,Bs,s),e(l,bl,s),e(l,As,s),e(l,Il,s),e(l,Gs,s),c(fl,l,s),e(l,_s,s),e(l,Cl,s),Zs=!0},p(l,[s]){const ct={};s&2&&(ct.$$scope={dirty:s,ctx:l}),d.$set(ct);const yt={};s&2&&(yt.$$scope={dirty:s,ctx:l}),b.$set(yt);const jt={};s&2&&(jt.$$scope={dirty:s,ctx:l}),I.$set(jt)},i(l){Zs||(y(f.$$.fragment,l),y(C.$$.fragment,l),y(d.$$.fragment,l),y(A.$$.fragment,l),y(_.$$.fragment,l),y(Z.$$.fragment,l),y(V.$$.fragment,l),y(Q.$$.fragment,l),y(b.$$.fragment,l),y(R.$$.fragment,l),y(x.$$.fragment,l),y(W.$$.fragment,l),y(q.$$.fragment,l),y(H.$$.fragment,l),y(D.$$.fragment,l),y(K.$$.fragment,l),y(tl.$$.fragment,l),y(I.$$.fragment,l),y(el.$$.fragment,l),y(al.$$.fragment,l),y(pl.$$.fragment,l),y(ol.$$.fragment,l),y(cl.$$.fragment,l),y(yl.$$.fragment,l),y(wl.$$.fragment,l),y(ml.$$.fragment,l),y(Tl.$$.fragment,l),y(fl.$$.fragment,l),Zs=!0)},o(l){j(f.$$.fragment,l),j(C.$$.fragment,l),j(d.$$.fragment,l),j(A.$$.fragment,l),j(_.$$.fragment,l),j(Z.$$.fragment,l),j(V.$$.fragment,l),j(Q.$$.fragment,l),j(b.$$.fragment,l),j(R.$$.fragment,l),j(x.$$.fragment,l),j(W.$$.fragment,l),j(q.$$.fragment,l),j(H.$$.fragment,l),j(D.$$.fragment,l),j(K.$$.fragment,l),j(tl.$$.fragment,l),j(I.$$.fragment,l),j(el.$$.fragment,l),j(al.$$.fragment,l),j(pl.$$.fragment,l),j(ol.$$.fragment,l),j(cl.$$.fragment,l),j(yl.$$.fragment,l),j(wl.$$.fragment,l),j(ml.$$.fragment,l),j(Tl.$$.fragment,l),j(fl.$$.fragment,l),Zs=!1},d(l){l&&(t(m),t(T),t(gl),t(Bl),t(Al),t(g),t(Gl),t(B),t(_l),t(Zl),t(kl),t(G),t(Vl),t($l),t(Ql),t(k),t(El),t(Rl),t($),t(Nl),t(vl),t(E),t(xl),t(Xl),t(Wl),t(N),t(Yl),t(v),t(ql),t(zl),t(X),t(Fl),t(Hl),t(Y),t(Sl),t(Ll),t(z),t(Dl),t(F),t(Pl),t(Kl),t(S),t(Ol),t(L),t(ls),t(ss),t(P),t(ts),t(es),t(O),t(ns),t(ll),t(as),t(sl),t(Ms),t(ps),t(is),t(os),t(nl),t(rs),t(cs),t(Ml),t(ys),t(js),t(il),t(ws),t(Js),t(rl),t(ms),t(us),t(Ts),t(jl),t(Us),t(hs),t(Jl),t(ds),t(bs),t(ul),t(Is),t(fs),t(Ul),t(Cs),t(hl),t(gs),t(dl),t(Bs),t(bl),t(As),t(Il),t(Gs),t(_s),t(Cl)),t(J),w(f,l),w(C,l),w(d,l),w(A,l),w(_,l),w(Z,l),w(V,l),w(Q,l),w(b,l),w(R,l),w(x,l),w(W,l),w(q,l),w(H,l),w(D,l),w(K,l),w(tl,l),w(I,l),w(el,l),w(al,l),w(pl,l),w(ol,l),w(cl,l),w(yl,l),w(wl,l),w(ml,l),w(Tl,l),w(fl,l)}}}const At='{"title":"Practical Exercise: GRPO with Unsloth","local":"practical-exercise-grpo-with-unsloth","sections":[{"title":"Install dependencies","local":"install-dependencies","sections":[],"depth":2},{"title":"Setting up Unsloth","local":"setting-up-unsloth","sections":[],"depth":2},{"title":"Data Preparation","local":"data-preparation","sections":[],"depth":2},{"title":"Defining Reward Functions","local":"defining-reward-functions","sections":[],"depth":2},{"title":"Training with GRPO","local":"training-with-grpo","sections":[],"depth":2},{"title":"Testing the Model","local":"testing-the-model","sections":[],"depth":2},{"title":"Saving the Model","local":"saving-the-model","sections":[],"depth":2},{"title":"Pushing to Hugging Face Hub","local":"pushing-to-hugging-face-hub","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function Gt(h){return ut(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Et extends Tt{constructor(J){super(),Ut(this,J,Gt,Bt,mt,{})}}export{Et as component};
