import{s as me,o as _e,n as ue}from"../chunks/scheduler.9039eef2.js";import{S as ce,i as ge,g as r,s as o,r as c,A as ve,h as i,f as n,c as s,j as x,u as g,x as B,k as S,y as A,a as t,v,d,t as y,w as b}from"../chunks/index.cdcc3d35.js";import{T as de}from"../chunks/Tip.6f74db41.js";import{D as te}from"../chunks/Docstring.fff63cfc.js";import{C as ye}from"../chunks/CodeBlock.e3ac94d9.js";import{H as le}from"../chunks/Heading.96ce3702.js";function be(L){let l,f='The <a href="https://huggingface.co/docs/optimum/neuron/package_reference/trainer#optimum.neuron.NeuronTrainer" rel="nofollow"><code>NeuronTrainer</code></a> class is optimized for 🤗 Transformers models running on AWS Trainium.';return{c(){l=r("p"),l.innerHTML=f},l(p){l=i(p,"P",{"data-svelte-h":!0}),B(l)!=="svelte-95vt7d"&&(l.innerHTML=f)},m(p,k){t(p,l,k)},p:ue,d(p){p&&n(l)}}}function fe(L){let l,f,p,k,h,Z,T,oe='The <a href="https://huggingface.co/docs/optimum/neuron/package_reference/trainer#optimum.neuron.NeuronTrainer" rel="nofollow"><code>NeuronTrainer</code></a> class provides an extended API for the feature-complete <a href="https://huggingface.co/docs/transformers/main_classes/trainer" rel="nofollow">Transformers Trainer</a>. It is used in all the <a href="https://github.com/huggingface/optimum-neuron/tree/main/examples" rel="nofollow">example scripts</a>.',V,u,X,w,se='Here is an example of how to customize <a href="https://huggingface.co/docs/optimum/neuron/package_reference/trainer#optimum.neuron.NeuronTrainer" rel="nofollow"><code>NeuronTrainer</code></a> to use a weighted loss (useful when you have an unbalanced training set):',W,N,R,M,re='Another way to customize the training loop behavior for the PyTorch <a href="https://huggingface.co/docs/optimum/neuron/package_reference/trainer#optimum.neuron.NeuronTrainer" rel="nofollow"><code>NeuronTrainer</code></a> is to use <a href="https://huggingface.co/docs/transformers/main_classes/callback" rel="nofollow">callbacks</a> that can inspect the training loop state (for progress reporting, logging on TensorBoard or other ML platforms…) and take decisions (like early stopping).',E,J,q,$,U,G,I,P,m,O,ae,F,ie="Trainer that is suited for performing training on AWS Trainium instances.",Q,_,j,ne,C,pe="Seq2SeqTrainer that is suited for performing training on AWS Trainium instances.",D,H,Y;return h=new le({props:{title:"NeuronTrainer",local:"neurontrainer",headingTag:"h1"}}),u=new de({props:{warning:!0,$$slots:{default:[be]},$$scope:{ctx:L}}}),N=new ye({props:{code:"ZnJvbSUyMHRvcmNoJTIwaW1wb3J0JTIwbm4lMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25UcmFpbmVyJTBBJTBBJTBBY2xhc3MlMjBDdXN0b21OZXVyb25UcmFpbmVyKE5ldXJvblRyYWluZXIpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwY29tcHV0ZV9sb3NzKHNlbGYlMkMlMjBtb2RlbCUyQyUyMGlucHV0cyUyQyUyMHJldHVybl9vdXRwdXRzJTNERmFsc2UpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWxzJTIwJTNEJTIwaW5wdXRzLmdldCglMjJsYWJlbHMlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZm9yd2FyZCUyMHBhc3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5nZXQoJTIybG9naXRzJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMGNvbXB1dGUlMjBjdXN0b20lMjBsb3NzJTIwKHN1cHBvc2UlMjBvbmUlMjBoYXMlMjAzJTIwbGFiZWxzJTIwd2l0aCUyMGRpZmZlcmVudCUyMHdlaWdodHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zc19mY3QlMjAlM0QlMjBubi5Dcm9zc0VudHJvcHlMb3NzKHdlaWdodCUzRHRvcmNoLnRlbnNvciglNUIxLjAlMkMlMjAyLjAlMkMlMjAzLjAlNUQpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2ZjdChsb2dpdHMudmlldygtMSUyQyUyMHNlbGYubW9kZWwuY29uZmlnLm51bV9sYWJlbHMpJTJDJTIwbGFiZWxzLnZpZXcoLTEpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMChsb3NzJTJDJTIwb3V0cHV0cyklMjBpZiUyMHJldHVybl9vdXRwdXRzJTIwZWxzZSUyMGxvc3M=",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronTrainer


<span class="hljs-keyword">class</span> <span class="hljs-title class_">CustomNeuronTrainer</span>(<span class="hljs-title class_ inherited__">NeuronTrainer</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_loss</span>(<span class="hljs-params">self, model, inputs, return_outputs=<span class="hljs-literal">False</span></span>):
        labels = inputs.get(<span class="hljs-string">&quot;labels&quot;</span>)
        <span class="hljs-comment"># forward pass</span>
        outputs = model(**inputs)
        logits = outputs.get(<span class="hljs-string">&quot;logits&quot;</span>)
        <span class="hljs-comment"># compute custom loss (suppose one has 3 labels with different weights)</span>
        loss_fct = nn.CrossEntropyLoss(weight=torch.tensor([<span class="hljs-number">1.0</span>, <span class="hljs-number">2.0</span>, <span class="hljs-number">3.0</span>]))
        loss = loss_fct(logits.view(-<span class="hljs-number">1</span>, self.model.config.num_labels), labels.view(-<span class="hljs-number">1</span>))
        <span class="hljs-keyword">return</span> (loss, outputs) <span class="hljs-keyword">if</span> return_outputs <span class="hljs-keyword">else</span> loss`,wrap:!1}}),J=new le({props:{title:"NeuronTrainingArguments",local:"optimum.neuron.NeuronTrainingArguments",headingTag:"h2"}}),U=new te({props:{name:"class optimum.neuron.NeuronTrainingArguments",anchor:"optimum.neuron.NeuronTrainingArguments",parameters:[{name:"output_dir",val:": typing.Optional[str] = None"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": typing.Optional[int] = None"},{name:"per_gpu_eval_batch_size",val:": typing.Optional[int] = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": typing.Optional[int] = None"},{name:"eval_delay",val:": typing.Optional[float] = 0"},{name:"torch_empty_cache_steps",val:": typing.Optional[int] = None"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": typing.Union[transformers.trainer_utils.SchedulerType, str] = 'linear'"},{name:"lr_scheduler_kwargs",val:": typing.Union[dict, str, NoneType] = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": typing.Optional[str] = 'passive'"},{name:"log_level_replica",val:": typing.Optional[str] = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": typing.Optional[str] = None"},{name:"logging_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": typing.Union[transformers.trainer_utils.SaveStrategy, str] = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": typing.Optional[int] = None"},{name:"save_safetensors",val:": typing.Optional[bool] = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": typing.Optional[int] = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'xla'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": typing.Optional[bool] = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": typing.Optional[str] = None"},{name:"tpu_num_cores",val:": typing.Optional[int] = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": typing.Union[str, typing.List[transformers.debug_utils.DebugOption]] = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": typing.Optional[float] = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": typing.Optional[int] = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": typing.Optional[str] = None"},{name:"disable_tqdm",val:": typing.Optional[bool] = None"},{name:"remove_unused_columns",val:": typing.Optional[bool] = True"},{name:"label_names",val:": typing.Optional[typing.List[str]] = None"},{name:"load_best_model_at_end",val:": typing.Optional[bool] = False"},{name:"metric_for_best_model",val:": typing.Optional[str] = None"},{name:"greater_is_better",val:": typing.Optional[bool] = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": typing.Union[typing.List[transformers.trainer_utils.FSDPOption], str, NoneType] = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": typing.Union[dict, str, NoneType] = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": typing.Optional[str] = None"},{name:"accelerator_config",val:": typing.Union[dict, str, NoneType] = None"},{name:"deepspeed",val:": typing.Union[dict, str, NoneType] = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": typing.Union[transformers.training_args.OptimizerNames, str] = 'adamw_torch'"},{name:"optim_args",val:": typing.Optional[str] = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": typing.Optional[str] = 'length'"},{name:"report_to",val:": typing.Union[NoneType, str, typing.List[str]] = None"},{name:"ddp_find_unused_parameters",val:": typing.Optional[bool] = None"},{name:"ddp_bucket_cap_mb",val:": typing.Optional[int] = None"},{name:"ddp_broadcast_buffers",val:": typing.Optional[bool] = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": typing.Optional[str] = None"},{name:"hub_model_id",val:": typing.Optional[str] = None"},{name:"hub_strategy",val:": typing.Union[transformers.trainer_utils.HubStrategy, str] = 'every_save'"},{name:"hub_token",val:": typing.Optional[str] = None"},{name:"hub_private_repo",val:": typing.Optional[bool] = None"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": typing.Union[dict, str, NoneType] = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"include_for_metrics",val:": typing.List[str] = <factory>"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = None"},{name:"push_to_hub_model_id",val:": typing.Optional[str] = None"},{name:"push_to_hub_organization",val:": typing.Optional[str] = None"},{name:"push_to_hub_token",val:": typing.Optional[str] = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": typing.Optional[str] = None"},{name:"ray_scope",val:": typing.Optional[str] = 'last'"},{name:"ddp_timeout",val:": typing.Optional[int] = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": typing.Optional[str] = None"},{name:"torch_compile_mode",val:": typing.Optional[str] = None"},{name:"dispatch_batches",val:": typing.Optional[bool] = None"},{name:"split_batches",val:": typing.Optional[bool] = None"},{name:"include_tokens_per_second",val:": typing.Optional[bool] = False"},{name:"include_num_input_tokens_seen",val:": typing.Optional[bool] = False"},{name:"neftune_noise_alpha",val:": typing.Optional[float] = None"},{name:"optim_target_modules",val:": typing.Union[NoneType, str, typing.List[str]] = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"use_liger_kernel",val:": typing.Optional[bool] = False"},{name:"eval_use_gather_object",val:": typing.Optional[bool] = False"},{name:"average_tokens_across_devices",val:": typing.Optional[bool] = False"},{name:"skip_cache_push",val:": bool = False"},{name:"zero_1",val:": bool = False"},{name:"tensor_parallel_size",val:": int = 1"},{name:"disable_embedding_parallelization",val:": bool = False"},{name:"disable_sequence_parallel",val:": bool = False"},{name:"neuron_cc_optlevel",val:": typing.Optional[int] = None"},{name:"pipeline_parallel_size",val:": int = 1"},{name:"pipeline_parallel_num_microbatches",val:": int = -1"},{name:"kv_size_multiplier",val:": typing.Optional[int] = None"},{name:"num_local_ranks_per_step",val:": int = 8"},{name:"use_xser",val:": bool = True"},{name:"async_save",val:": bool = False"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/training_args.py#L251"}}),I=new le({props:{title:"NeuronTrainer",local:"optimum.neuron.NeuronTrainer",headingTag:"h2"}}),O=new te({props:{name:"class optimum.neuron.NeuronTrainer",anchor:"optimum.neuron.NeuronTrainer",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/trainers.py#L1504"}}),j=new te({props:{name:"class optimum.neuron.Seq2SeqNeuronTrainer",anchor:"optimum.neuron.Seq2SeqNeuronTrainer",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/trainers.py#L1510"}}),{c(){l=r("meta"),f=o(),p=r("p"),k=o(),c(h.$$.fragment),Z=o(),T=r("p"),T.innerHTML=oe,V=o(),c(u.$$.fragment),X=o(),w=r("p"),w.innerHTML=se,W=o(),c(N.$$.fragment),R=o(),M=r("p"),M.innerHTML=re,E=o(),c(J.$$.fragment),q=o(),$=r("div"),c(U.$$.fragment),G=o(),c(I.$$.fragment),P=o(),m=r("div"),c(O.$$.fragment),ae=o(),F=r("p"),F.textContent=ie,Q=o(),_=r("div"),c(j.$$.fragment),ne=o(),C=r("p"),C.textContent=pe,D=o(),H=r("p"),this.h()},l(e){const a=ve("svelte-u9bgzb",document.head);l=i(a,"META",{name:!0,content:!0}),a.forEach(n),f=s(e),p=i(e,"P",{}),x(p).forEach(n),k=s(e),g(h.$$.fragment,e),Z=s(e),T=i(e,"P",{"data-svelte-h":!0}),B(T)!=="svelte-17t4iuq"&&(T.innerHTML=oe),V=s(e),g(u.$$.fragment,e),X=s(e),w=i(e,"P",{"data-svelte-h":!0}),B(w)!=="svelte-6qwkss"&&(w.innerHTML=se),W=s(e),g(N.$$.fragment,e),R=s(e),M=i(e,"P",{"data-svelte-h":!0}),B(M)!=="svelte-1v1d9m6"&&(M.innerHTML=re),E=s(e),g(J.$$.fragment,e),q=s(e),$=i(e,"DIV",{class:!0});var z=x($);g(U.$$.fragment,z),z.forEach(n),G=s(e),g(I.$$.fragment,e),P=s(e),m=i(e,"DIV",{class:!0});var K=x(m);g(O.$$.fragment,K),ae=s(K),F=i(K,"P",{"data-svelte-h":!0}),B(F)!=="svelte-14t3s5l"&&(F.textContent=ie),K.forEach(n),Q=s(e),_=i(e,"DIV",{class:!0});var ee=x(_);g(j.$$.fragment,ee),ne=s(ee),C=i(ee,"P",{"data-svelte-h":!0}),B(C)!=="svelte-trkut5"&&(C.textContent=pe),ee.forEach(n),D=s(e),H=i(e,"P",{}),x(H).forEach(n),this.h()},h(){S(l,"name","hf:doc:metadata"),S(l,"content",he),S($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),S(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){A(document.head,l),t(e,f,a),t(e,p,a),t(e,k,a),v(h,e,a),t(e,Z,a),t(e,T,a),t(e,V,a),v(u,e,a),t(e,X,a),t(e,w,a),t(e,W,a),v(N,e,a),t(e,R,a),t(e,M,a),t(e,E,a),v(J,e,a),t(e,q,a),t(e,$,a),v(U,$,null),t(e,G,a),v(I,e,a),t(e,P,a),t(e,m,a),v(O,m,null),A(m,ae),A(m,F),t(e,Q,a),t(e,_,a),v(j,_,null),A(_,ne),A(_,C),t(e,D,a),t(e,H,a),Y=!0},p(e,[a]){const z={};a&2&&(z.$$scope={dirty:a,ctx:e}),u.$set(z)},i(e){Y||(d(h.$$.fragment,e),d(u.$$.fragment,e),d(N.$$.fragment,e),d(J.$$.fragment,e),d(U.$$.fragment,e),d(I.$$.fragment,e),d(O.$$.fragment,e),d(j.$$.fragment,e),Y=!0)},o(e){y(h.$$.fragment,e),y(u.$$.fragment,e),y(N.$$.fragment,e),y(J.$$.fragment,e),y(U.$$.fragment,e),y(I.$$.fragment,e),y(O.$$.fragment,e),y(j.$$.fragment,e),Y=!1},d(e){e&&(n(f),n(p),n(k),n(Z),n(T),n(V),n(X),n(w),n(W),n(R),n(M),n(E),n(q),n($),n(G),n(P),n(m),n(Q),n(_),n(D),n(H)),n(l),b(h,e),b(u,e),b(N,e),b(J,e),b(U),b(I,e),b(O),b(j)}}}const he='{"title":"NeuronTrainer","local":"neurontrainer","sections":[{"title":"NeuronTrainingArguments","local":"optimum.neuron.NeuronTrainingArguments","sections":[],"depth":2},{"title":"NeuronTrainer","local":"optimum.neuron.NeuronTrainer","sections":[],"depth":2}],"depth":1}';function Te(L){return _e(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ie extends ce{constructor(l){super(),ge(this,l,Te,fe,me,{})}}export{Ie as component};
