import{s as sa,n as la,o as ia}from"../chunks/scheduler.a2b4ca8e.js";import{S as da,i as pa,g as s,s as r,r as c,A as ca,h as l,f as n,c as o,j as w,u as m,x as d,k as b,l as ma,y as i,a,v as h,d as g,t as u,w as f}from"../chunks/index.f6e1d51d.js";import{D as y}from"../chunks/Docstring.e7c4afb2.js";import{C as v}from"../chunks/CodeBlock.9607aa3b.js";import{H as Xe,E as ha}from"../chunks/EditOnGithub.d27dc01b.js";function ga(Mn){let _,Qe,Ne,Se,Z,De,B,vn='TRL supports the <a href="https://arxiv.org/abs/1707.06347" rel="nofollow">PPO</a> Trainer for training language models on any reward signal with RL. The reward signal can come from a handcrafted rule, a metric or from preference data using a Reward Model. For a full example have a look at <a href="https://github.com/lvwerra/trl/blob/main/examples/notebooks/gpt2-sentiment.ipynb" rel="nofollow"><code>examples/notebooks/gpt2-sentiment.ipynb</code></a>. The trainer is heavily inspired by the original <a href="https://github.com/openai/summarize-from-feedback" rel="nofollow">OpenAI learning to summarize work</a>.',Ye,q,Jn='The first step is to train your SFT model (see the <a href="sft_trainer">SFTTrainer</a>), to ensure the data we train on is in-distribution for the PPO algorithm. In addition we need to train a Reward model (see <a href="reward_trainer">RewardTrainer</a>) which will be used to optimize the SFT model using the PPO algorithm.',Ke,L,et,H,Pn="Fine-tuning a language model via PPO consists of roughly three steps:",tt,G,In="<li><strong>Rollout</strong>: The language model generates a response or continuation based on query which could be the start of a sentence.</li> <li><strong>Evaluation</strong>: The query and response are evaluated with a function, model, human feedback or some combination of them. The important thing is that this process should yield a scalar value for each query/response pair.</li> <li><strong>Optimization</strong>: This is the most complex part. In the optimisation step the query/response pairs are used to calculate the log-probabilities of the tokens in the sequences. This is done with the model that is trained and a reference model, which is usually the pre-trained model before fine-tuning. The KL-divergence between the two outputs is used as an additional reward signal to make sure the generated responses don’t deviate too far from the reference language model. The active language model is then trained with PPO.</li>",nt,W,xn="This process is illustrated in the sketch below:",at,J,$n='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/trl_overview.png" width="800"/> <p style="text-align: center;"><b>Figure:</b> Sketch of the workflow.</p>',rt,V,ot,R,Un="The <code>PPOTrainer</code> expects to align a generated response with a query given the rewards obtained from the Reward model. During each step of the PPO algorithm we sample a batch of prompts from the dataset, we then use these prompts to generate the a responses from the SFT model. Next, the Reward model is used to compute the rewards for the generated response. Finally, these rewards are used to optimize the SFT model using the PPO algorithm.",st,A,jn="Therefore the dataset should contain a text column which we can rename to <code>query</code>. Each of the other data-points required to optimize the SFT model are obtained during the training loop.",lt,N,Cn='Here is an example with the <a href="https://huggingface.co/datasets/HuggingFaceH4/cherry_picked_prompts" rel="nofollow">HuggingFaceH4/cherry_picked_prompts</a> dataset:',it,E,dt,X,kn="Resulting in the following subset of the dataset:",pt,Q,ct,S,mt,D,zn='For a detailed example have a look at the <a href="https://github.com/lvwerra/trl/blob/main/examples/notebooks/gpt2-sentiment.ipynb" rel="nofollow"><code>examples/notebooks/gpt2-sentiment.ipynb</code></a> notebook. At a high level we need to initialize the <code>PPOTrainer</code> with a <code>model</code> we wish to train. Additionally, we require a reference <code>reward_model</code> which we will use to rate the generated response.',ht,Y,gt,K,Fn="The <code>PPOConfig</code> dataclass controls all the hyperparameters and settings for the PPO algorithm and trainer.",ut,ee,ft,te,On="Now we can initialize our model. Note that PPO also requires a reference model, but this model is generated by the ‘PPOTrainer` automatically. The model can be initialized as follows:",Tt,ne,wt,ae,Zn="As mentioned above, the reward can be generated using any function that returns a single value for a string, be it a simple rule (e.g. length of string), a metric (e.g. BLEU), or a reward model based on human preferences. In this example we use a reward model and initialize it using <code>transformers.pipeline</code> for ease of use.",bt,re,yt,oe,Bn="Lastly, we pretokenize our dataset using the <code>tokenizer</code> to ensure we can efficiently generate responses during the training loop:",_t,se,Mt,le,qn="Now we are ready to initialize the <code>PPOTrainer</code> using the defined config, datasets, and model.",vt,ie,Jt,de,Ln="### Starting the training loop",Pt,pe,Hn="Because the <code>PPOTrainer</code> needs an active <code>reward</code> per execution step, we need to define a method to get rewards during each step of the PPO algorithm. In this example we will be using the sentiment <code>reward_model</code> initialized above.",It,ce,Gn='To guide the generation process we use the <code>generation_kwargs</code> which are passed to the <code>model.generate</code> method for the SFT-model during each step. A more detailed example can be found over <a href="how_to_train#how-to-generate-text-for-training">here</a>.',xt,me,$t,he,Wn="We can then loop over all examples in the dataset and generate a response for each query. We then calculate the reward for each generated response using the <code>reward_model</code> and pass these rewards to the <code>ppo_trainer.step</code> method. The <code>ppo_trainer.step</code> method will then optimize the SFT model using the PPO algorithm.",Ut,ge,jt,ue,Vn="## Logging",Ct,fe,Rn="While training and evaluating we log the following metrics:",kt,Te,An="<li><code>stats</code>: The statistics of the PPO algorithm, including the loss, entropy, etc.</li> <li><code>batch</code>: The batch of data used to train the SFT model.</li> <li><code>rewards</code>: The rewards obtained from the Reward model.</li>",zt,we,Nn="## PPOTrainer[[trl.PPOTrainer]]",Ft,p,be,Dt,ze,En=`The PPOTrainer uses Proximal Policy Optimization to optimise language models.
Note, this trainer is heavily inspired by the original OpenAI learning to summarize work here:
<a href="https://github.com/openai/summarize-from-feedback" rel="nofollow">https://github.com/openai/summarize-from-feedback</a>`,Yt,P,ye,Kt,Fe,Xn="Calculate model outputs in multiple batches.",en,I,_e,tn,Oe,Qn="Compute per token rewards from scores and KL-penalty.",nn,x,Me,an,Ze,Sn="Creates and saves a model card for a TRL model.",rn,$,ve,on,Be,Dn="Gather stats from all processes. Useful in the context of distributed training.",sn,U,Je,ln,qe,Yn=`Generate response with the model given the query tensor.
call the <code>generate</code> method of the model.`,dn,j,Pe,pn,Le,Kn="A function that logs all the training stats. Call it at the end of each epoch.",cn,C,Ie,mn,He,ea="Calculate policy and value losses.",hn,k,xe,gn,Ge,ta="Prepare the dataloader for training.",un,z,$e,fn,We,na="Record training step statistics.",Tn,F,Ue,wn,Ve,aa="Run a PPO optimisation step given a list of queries, model responses, and rewards.",bn,O,je,yn,Re,ra="Train one PPO minibatch",Ot,M,Ce,_n,Ae,oa="Configuration class for PPOTrainer",Zt,ke,Bt,Ee,qt;return Z=new Xe({props:{title:"PPO Trainer",local:"ppo-trainer",headingTag:"h1"}}),L=new Xe({props:{title:"How PPO works",local:"how-ppo-works",headingTag:"h2"}}),V=new Xe({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),E=new v({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJIdWdnaW5nRmFjZUg0JTJGY2hlcnJ5X3BpY2tlZF9wcm9tcHRzJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5yZW5hbWVfY29sdW1uKCUyMnByb21wdCUyMiUyQyUyMCUyMnF1ZXJ5JTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbW92ZV9jb2x1bW5zKCU1QiUyMm1ldGElMjIlMkMlMjAlMjJjb21wbGV0aW9uJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;HuggingFaceH4/cherry_picked_prompts&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
dataset = dataset.rename_column(<span class="hljs-string">&quot;prompt&quot;</span>, <span class="hljs-string">&quot;query&quot;</span>)
dataset = dataset.remove_columns([<span class="hljs-string">&quot;meta&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>])`,wrap:!1}}),Q=new v({props:{code:"cHBvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnF1ZXJ5JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyRXhwbGFpbiUyMHRoZSUyMG1vb24lMjBsYW5kaW5nJTIwdG8lMjBhJTIwNiUyMHllYXIlMjBvbGQlMjBpbiUyMGElMjBmZXclMjBzZW50ZW5jZXMuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2h5JTIwYXJlbiVFMiU4MCU5OXQlMjBiaXJkcyUyMHJlYWwlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaGFwcGVucyUyMGlmJTIweW91JTIwZmlyZSUyMGElMjBjYW5ub25iYWxsJTIwZGlyZWN0bHklMjBhdCUyMGElMjBwdW1wa2luJTIwYXQlMjBoaWdoJTIwc3BlZWRzJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySG93JTIwY2FuJTIwSSUyMHN0ZWFsJTIwZnJvbSUyMGElMjBncm9jZXJ5JTIwc3RvcmUlMjB3aXRob3V0JTIwZ2V0dGluZyUyMGNhdWdodCUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoeSUyMGlzJTIwaXQlMjBpbXBvcnRhbnQlMjB0byUyMGVhdCUyMHNvY2tzJTIwYWZ0ZXIlMjBtZWRpdGF0aW5nJTNGJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTVEJTBBJTdE",highlighted:`ppo_dataset_dict = {
    <span class="hljs-string">&quot;query&quot;</span>: [
        <span class="hljs-string">&quot;Explain the moon landing to a 6 year old in a few sentences.&quot;</span>,
        <span class="hljs-string">&quot;Why aren’t birds real?&quot;</span>,
        <span class="hljs-string">&quot;What happens if you fire a cannonball directly at a pumpkin at high speeds?&quot;</span>,
        <span class="hljs-string">&quot;How can I steal from a grocery store without getting caught?&quot;</span>,
        <span class="hljs-string">&quot;Why is it important to eat socks after meditating? &quot;</span>
    ]
}`,wrap:!1}}),S=new Xe({props:{title:"Using the PPOTrainer",local:"using-the-ppotrainer",headingTag:"h2"}}),Y=new Xe({props:{title:"Initializing the PPOTrainer",local:"initializing-the-ppotrainer",headingTag:"h3"}}),ee=new v({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMFBQT0NvbmZpZyUwQSUwQWNvbmZpZyUyMCUzRCUyMFBQT0NvbmZpZyglMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTNEJTIyZ3B0MiUyMiUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QxLjQxZS01JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> PPOConfig

config = PPOConfig(
    model_name=<span class="hljs-string">&quot;gpt2&quot;</span>,
    learning_rate=<span class="hljs-number">1.41e-5</span>,
)`,wrap:!1}}),ne=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEFmcm9tJTIwdHJsJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE1XaXRoVmFsdWVIZWFkJTJDJTIwUFBPQ29uZmlnJTJDJTIwUFBPVHJhaW5lciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE1XaXRoVmFsdWVIZWFkLmZyb21fcHJldHJhaW5lZChjb25maWcubW9kZWxfbmFtZSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjb25maWcubW9kZWxfbmFtZSklMEElMEF0b2tlbml6ZXIucGFkX3Rva2VuJTIwJTNEJTIwdG9rZW5pemVyLmVvc190b2tlbg==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> AutoModelForCausalLMWithValueHead, PPOConfig, PPOTrainer

model = AutoModelForCausalLMWithValueHead.from_pretrained(config.model_name)
tokenizer = AutoTokenizer.from_pretrained(config.model_name)

tokenizer.pad_token = tokenizer.eos_token`,wrap:!1}}),re=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcmV3YXJkX21vZGVsJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIybHZ3ZXJyYSUyRmRpc3RpbGJlcnQtaW1kYiUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

reward_model = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=<span class="hljs-string">&quot;lvwerra/distilbert-imdb&quot;</span>)`,wrap:!1}}),se=new v({props:{code:"ZGVmJTIwdG9rZW5pemUoc2FtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMHNhbXBsZSU1QiUyMmlucHV0X2lkcyUyMiU1RCUyMCUzRCUyMHRva2VuaXplci5lbmNvZGUoc2FtcGxlJTVCJTIycXVlcnklMjIlNUQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2FtcGxlJTBBJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKHRva2VuaXplJTJDJTIwYmF0Y2hlZCUzREZhbHNlKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">sample</span>):
    sample[<span class="hljs-string">&quot;input_ids&quot;</span>] = tokenizer.encode(sample[<span class="hljs-string">&quot;query&quot;</span>])
    <span class="hljs-keyword">return</span> sample

dataset = dataset.<span class="hljs-built_in">map</span>(tokenize, batched=<span class="hljs-literal">False</span>)`,wrap:!1}}),ie=new v({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMFBQT1RyYWluZXIlMEElMEFwcG9fdHJhaW5lciUyMCUzRCUyMFBQT1RyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGNvbmZpZyUzRGNvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> PPOTrainer

ppo_trainer = PPOTrainer(
    model=model,
    config=config,
    dataset=dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),me=new v({props:{code:"Z2VuZXJhdGlvbl9rd2FyZ3MlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJtaW5fbGVuZ3RoJTIyJTNBJTIwLTElMkMlMEElMjAlMjAlMjAlMjAlMjJ0b3BfayUyMiUzQSUyMDAuMCUyQyUwQSUyMCUyMCUyMCUyMCUyMnRvcF9wJTIyJTNBJTIwMS4wJTJDJTBBJTIwJTIwJTIwJTIwJTIyZG9fc2FtcGxlJTIyJTNBJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMnBhZF90b2tlbl9pZCUyMiUzQSUyMHRva2VuaXplci5lb3NfdG9rZW5faWQlMkMlMEElN0Q=",highlighted:`generation_kwargs = {
    <span class="hljs-string">&quot;min_length&quot;</span>: -<span class="hljs-number">1</span>,
    <span class="hljs-string">&quot;top_k&quot;</span>: <span class="hljs-number">0.0</span>,
    <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">1.0</span>,
    <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
    <span class="hljs-string">&quot;pad_token_id&quot;</span>: tokenizer.eos_token_id,
}`,wrap:!1}}),ge=new v({props:{code:"ZnJvbSUyMHRxZG0lMjBpbXBvcnQlMjB0cWRtJTBBJTBBJTBBZXBvY2hzJTIwJTNEJTIwMTAlMEFmb3IlMjBlcG9jaCUyMGluJTIwdHFkbShyYW5nZShlcG9jaHMpJTJDJTIwJTIyZXBvY2glM0ElMjAlMjIpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRxZG0ocHBvX3RyYWluZXIuZGF0YWxvYWRlciklM0ElMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBxdWVyeV90ZW5zb3JzJTIwJTNEJTIwYmF0Y2glNUIlMjJpbnB1dF9pZHMlMjIlNUQlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjMlMjMlMjMlMjBHZXQlMjByZXNwb25zZSUyMGZyb20lMjBTRlRNb2RlbCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlc3BvbnNlX3RlbnNvcnMlMjAlM0QlMjBwcG9fdHJhaW5lci5nZW5lcmF0ZShxdWVyeV90ZW5zb3JzJTJDJTIwKipnZW5lcmF0aW9uX2t3YXJncyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCU1QiUyMnJlc3BvbnNlJTIyJTVEJTIwJTNEJTIwJTVCdG9rZW5pemVyLmRlY29kZShyLnNxdWVlemUoKSklMjBmb3IlMjByJTIwaW4lMjByZXNwb25zZV90ZW5zb3JzJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIzJTIzJTIzJTIwQ29tcHV0ZSUyMHJld2FyZCUyMHNjb3JlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGV4dHMlMjAlM0QlMjAlNUJxJTIwJTJCJTIwciUyMGZvciUyMHElMkMlMjByJTIwaW4lMjB6aXAoYmF0Y2glNUIlMjJxdWVyeSUyMiU1RCUyQyUyMGJhdGNoJTVCJTIycmVzcG9uc2UlMjIlNUQpJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlwZV9vdXRwdXRzJTIwJTNEJTIwcmV3YXJkX21vZGVsKHRleHRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJld2FyZHMlMjAlM0QlMjAlNUJ0b3JjaC50ZW5zb3Iob3V0cHV0JTVCMSU1RCU1QiUyMnNjb3JlJTIyJTVEKSUyMGZvciUyMG91dHB1dCUyMGluJTIwcGlwZV9vdXRwdXRzJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIzJTIzJTIzJTIwUnVuJTIwUFBPJTIwc3RlcCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0YXRzJTIwJTNEJTIwcHBvX3RyYWluZXIuc3RlcChxdWVyeV90ZW5zb3JzJTJDJTIwcmVzcG9uc2VfdGVuc29ycyUyQyUyMHJld2FyZHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHBvX3RyYWluZXIubG9nX3N0YXRzKHN0YXRzJTJDJTIwYmF0Y2glMkMlMjByZXdhcmRzKSUwQSUwQSUyMyUyMyUyMyUyMyUyMFNhdmUlMjBtb2RlbCUwQXBwb190cmFpbmVyLnNhdmVfcHJldHJhaW5lZCglMjJteV9wcG9fbW9kZWwlMjIp",highlighted:`<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm


epochs = <span class="hljs-number">10</span>
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">range</span>(epochs), <span class="hljs-string">&quot;epoch: &quot;</span>):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> tqdm(ppo_trainer.dataloader): 
        query_tensors = batch[<span class="hljs-string">&quot;input_ids&quot;</span>]
    
        <span class="hljs-comment">#### Get response from SFTModel</span>
        response_tensors = ppo_trainer.generate(query_tensors, **generation_kwargs)
        batch[<span class="hljs-string">&quot;response&quot;</span>] = [tokenizer.decode(r.squeeze()) <span class="hljs-keyword">for</span> r <span class="hljs-keyword">in</span> response_tensors]
    
        <span class="hljs-comment">#### Compute reward score</span>
        texts = [q + r <span class="hljs-keyword">for</span> q, r <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(batch[<span class="hljs-string">&quot;query&quot;</span>], batch[<span class="hljs-string">&quot;response&quot;</span>])]
        pipe_outputs = reward_model(texts)
        rewards = [torch.tensor(output[<span class="hljs-number">1</span>][<span class="hljs-string">&quot;score&quot;</span>]) <span class="hljs-keyword">for</span> output <span class="hljs-keyword">in</span> pipe_outputs]
    
        <span class="hljs-comment">#### Run PPO step</span>
        stats = ppo_trainer.step(query_tensors, response_tensors, rewards)
        ppo_trainer.log_stats(stats, batch, rewards)

<span class="hljs-comment">#### Save model</span>
ppo_trainer.save_pretrained(<span class="hljs-string">&quot;my_ppo_model&quot;</span>)`,wrap:!1}}),be=new y({props:{name:"class trl.PPOTrainer",anchor:"trl.PPOTrainer",parameters:[{name:"config",val:": Optional = None"},{name:"model",val:": Optional = None"},{name:"ref_model",val:": Optional = None"},{name:"tokenizer",val:": Optional = None"},{name:"dataset",val:": Union = None"},{name:"optimizer",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"num_shared_layers",val:": Optional = None"},{name:"lr_scheduler",val:": Optional = None"},{name:"training_data_collator",val:": Optional = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.*config**",description:`*<strong>*config**</strong> (<code>PPOConfig</code>) &#x2014; Configuration object for PPOTrainer. Check the documentation of <code>PPOConfig</code> for more &#x2014;
details.`,name:"*config**"},{anchor:"trl.PPOTrainer.*model**",description:`*<strong>*model**</strong> (<code>PreTrainedModelWrapper</code>) &#x2014; Model to be optimized, Hugging Face transformer model with a value head. &#x2014;
Check the documentation of <code>PreTrainedModelWrapper</code> for more details.`,name:"*model**"},{anchor:"trl.PPOTrainer.*ref_model**",description:`*<strong>*ref_model**</strong> (<code>PreTrainedModelWrapper</code>, <em>optional</em>) &#x2014; Reference model to be used for KL penalty, Hugging Face &#x2014;
transformer model with a casual language modelling head. Check the documentation of <code>PreTrainedModelWrapper</code>
for more details. If no reference model is provided, the trainer will create a reference model with the same
architecture as the model to be optimized with shared layers.`,name:"*ref_model**"},{anchor:"trl.PPOTrainer.*tokenizer**",description:`*<strong>*tokenizer**</strong> (<code>PreTrainedTokenizerBase</code>) &#x2014; Tokenizer to be used for encoding the &#x2014;
data. Check the documentation of <code>transformers.PreTrainedTokenizer</code> and
<code>transformers.PreTrainedTokenizerFast</code> for more details.`,name:"*tokenizer**"},{anchor:"trl.PPOTrainer.*dataset**",description:`*<strong>*dataset**</strong> (Union[<code>torch.utils.data.Dataset</code>, <code>datasets.Dataset</code>], <em>optional</em>) &#x2014; PyTorch dataset or Hugging &#x2014;
Face dataset. This is used to create a PyTorch dataloader. If no dataset is provided, the dataloader must be
created outside the trainer users needs to design their own dataloader and make sure the batch
size that is used is the same as the one specified in the configuration object.`,name:"*dataset**"},{anchor:"trl.PPOTrainer.*optimizer**",description:`*<strong>*optimizer**</strong> (<code>torch.optim.Optimizer</code>, <em>optional</em>) &#x2014; Optimizer to be used for training. If no optimizer is &#x2014;
provided, the trainer will create an Adam optimizer with the learning rate specified in the configuration
object.`,name:"*optimizer**"},{anchor:"trl.PPOTrainer.*data_collator**",description:`*<strong>*data_collator**</strong> (DataCollatorForLanguageModeling, <em>optional</em>) &#x2014; Data collator to be used for training and &#x2014;
passed along the dataloader`,name:"*data_collator**"},{anchor:"trl.PPOTrainer.*num_shared_layers**",description:`*<strong>*num_shared_layers**</strong> (int, <em>optional</em>) &#x2014; Number of layers to be shared between the model and the reference &#x2014;
model, if no reference model is passed. If no number is provided, all the layers will be shared.`,name:"*num_shared_layers**"},{anchor:"trl.PPOTrainer.*lr_scheduler**",description:"*<strong>*lr_scheduler**</strong> (<code>torch.optim.lr_scheduler</code>, <em>optional</em>) &#x2014; Learning rate scheduler to be used for training. &#x2014;",name:"*lr_scheduler**"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L114"}}),ye=new y({props:{name:"batched_forward_pass",anchor:"trl.PPOTrainer.batched_forward_pass",parameters:[{name:"model",val:": PreTrainedModelWrapper"},{name:"queries",val:": Tensor"},{name:"responses",val:": Tensor"},{name:"model_inputs",val:": dict"},{name:"return_logits",val:": bool = False"},{name:"response_masks",val:": Optional = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.batched_forward_pass.queries",description:`<strong>queries</strong> (<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded queries, shape (<code>batch_size</code>, <code>query_length</code>)`,name:"queries"},{anchor:"trl.PPOTrainer.batched_forward_pass.responses",description:`<strong>responses</strong> (<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded responses, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"responses"},{anchor:"trl.PPOTrainer.batched_forward_pass.return_logits",description:`<strong>return_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return all_logits. Set to <code>False</code> if logits are not needed to reduce memory consumption.`,name:"return_logits"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L970",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>all_logprobs (<code>torch.FloatTensor</code>): Log probabilities of the responses,
shape (<code>batch_size</code>, <code>response_length</code>)</li>
<li>all_ref_logprobs (<code>torch.FloatTensor</code>): Log probabilities of the responses,
shape (<code>batch_size</code>, <code>response_length</code>)</li>
<li>all_values (<code>torch.FloatTensor</code>): Values of the responses, shape (<code>batch_size</code>, <code>response_length</code>)</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(tuple)</p>
`}}),_e=new y({props:{name:"compute_rewards",anchor:"trl.PPOTrainer.compute_rewards",parameters:[{name:"scores",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"ref_logprobs",val:": FloatTensor"},{name:"masks",val:": LongTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.compute_rewards.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code>) &#x2014;
Scores from the reward model, shape (<code>batch_size</code>)`,name:"scores"},{anchor:"trl.PPOTrainer.compute_rewards.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"logprobs"},{anchor:"trl.PPOTrainer.compute_rewards.ref_logprobs",description:`<strong>ref_logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the reference model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"ref_logprobs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1107",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Per token rewards, shape (<code>batch_size</code>, <code>response_length</code>)
<code>torch.FloatTensor</code>: Non score rewards, shape (<code>batch_size</code>, <code>response_length</code>)
<code>torch.FloatTensor</code>: KL penalty, shape (<code>batch_size</code>, <code>response_length</code>)</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),Me=new y({props:{name:"create_model_card",anchor:"trl.PPOTrainer.create_model_card",parameters:[{name:"path",val:": str"},{name:"model_name",val:": Optional = 'TRL Model'"}],parametersDescription:[{anchor:"trl.PPOTrainer.create_model_card.path",description:"<strong>path</strong> (<code>str</code>) &#x2014; The path to save the model card to.",name:"path"},{anchor:"trl.PPOTrainer.create_model_card.model_name",description:"<strong>model_name</strong> (<code>str</code>, <em>optional</em>) &#x2014; The name of the model, defaults to <code>TRL Model</code>.",name:"model_name"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1415"}}),ve=new y({props:{name:"gather_stats",anchor:"trl.PPOTrainer.gather_stats",parameters:[{name:"stats",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.gather_stats.stats",description:"<strong>stats</strong> (dict[str, Any]) &#x2014;",name:"stats"},{anchor:"trl.PPOTrainer.gather_stats.a",description:"<strong>a</strong> dictionary of stats to be gathered. The stats should contain torch tensors. &#x2014;",name:"a"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L926",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary of stats with the tensors gathered.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),Je=new y({props:{name:"generate",anchor:"trl.PPOTrainer.generate",parameters:[{name:"query_tensor",val:": Union"},{name:"length_sampler",val:": Optional = None"},{name:"batch_size",val:": int = 4"},{name:"return_prompt",val:": bool = True"},{name:"generate_ref_response",val:": bool = False"},{name:"**generation_kwargs",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.generate.query_tensor",description:`<strong>query_tensor</strong> (<code>torch.LongTensor</code>) &#x2014;
A tensor of shape (<code>seq_len</code>) containing query tokens or a list of tensors of shape (<code>seq_len</code>).`,name:"query_tensor"},{anchor:"trl.PPOTrainer.generate.length_sampler",description:`<strong>length_sampler</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Callable that returns the number of newly generated tokens.`,name:"length_sampler"},{anchor:"trl.PPOTrainer.generate.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, *optional) &#x2014;
Batch size used for generation, defaults to <code>4</code>.`,name:"batch_size"},{anchor:"trl.PPOTrainer.generate.return_prompt",description:`<strong>return_prompt</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>False</code> the prompt is not returned but only the newly generated tokens, defaults to <code>True</code>.`,name:"return_prompt"},{anchor:"trl.PPOTrainer.generate.generate_ref_response",description:`<strong>generate_ref_response</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code> the reference response is also generated, defaults to <code>False</code>.`,name:"generate_ref_response"},{anchor:"trl.PPOTrainer.generate.generation_kwargs",description:`<strong>generation_kwargs</strong> (dict[str, Any]) &#x2014;
Keyword arguments for generation.`,name:"generation_kwargs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L455",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (<code>batch_size</code>, <code>gen_len</code>) containing response tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.LongTensor</code></p>
`}}),Pe=new y({props:{name:"log_stats",anchor:"trl.PPOTrainer.log_stats",parameters:[{name:"stats",val:": dict"},{name:"batch",val:": dict"},{name:"rewards",val:": List"},{name:"columns_to_log",val:": Iterable = ('query', 'response')"}],parametersDescription:[{anchor:"trl.PPOTrainer.log_stats.stats",description:`<strong>stats</strong> (dict[str, Any]) &#x2014;
A dictionary of training stats.`,name:"stats"},{anchor:"trl.PPOTrainer.log_stats.batch",description:`<strong>batch</strong> (dict[str, Any]) &#x2014;
A dictionary of batch data, this contains the queries and responses.`,name:"batch"},{anchor:"trl.PPOTrainer.log_stats.rewards",description:`<strong>rewards</strong> (<code>List[torch.FloatTensor]</code>) &#x2014;
A tensor of rewards.`,name:"rewards"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1342"}}),Ie=new y({props:{name:"loss",anchor:"trl.PPOTrainer.loss",parameters:[{name:"old_logprobs",val:": FloatTensor"},{name:"values",val:": FloatTensor"},{name:"logits",val:": FloatTensor"},{name:"vpreds",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"mask",val:": LongTensor"},{name:"advantages",val:": FloatTensor"},{name:"returns",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.loss.old_logprobs",description:`<strong>old_logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"old_logprobs"},{anchor:"trl.PPOTrainer.loss.values",description:`<strong>values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"values"},{anchor:"trl.PPOTrainer.loss.rewards",description:`<strong>rewards</strong> (<code>torch.FloatTensor</code>) &#x2014;
Rewards from the reward model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"rewards"},{anchor:"trl.PPOTrainer.loss.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
Logits of the model, shape (<code>batch_size</code>, <code>response_length</code>, <code>vocab_size</code>)`,name:"logits"},{anchor:"trl.PPOTrainer.loss.v_pred",description:`<strong>v_pred</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"v_pred"},{anchor:"trl.PPOTrainer.loss.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"logprobs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1189"}}),xe=new y({props:{name:"prepare_dataloader",anchor:"trl.PPOTrainer.prepare_dataloader",parameters:[{name:"dataset",val:": Union"},{name:"data_collator",val:" = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.prepare_dataloader.dataset",description:`<strong>dataset</strong> (Union[<code>torch.utils.data.Dataset</code>, <code>datasets.Dataset</code>]) &#x2014;
PyTorch dataset or Hugging Face dataset. If a Hugging Face dataset is passed, the dataset
will be preprocessed by removing the columns that are not used by the model.`,name:"dataset"},{anchor:"trl.PPOTrainer.prepare_dataloader.data_collator",description:`<strong>data_collator</strong> (Optional[function]) &#x2014;
Data collator function.`,name:"data_collator"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L400",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>PyTorch dataloader</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.utils.data.DataLoader</code></p>
`}}),$e=new y({props:{name:"record_step_stats",anchor:"trl.PPOTrainer.record_step_stats",parameters:[{name:"kl_coef",val:": float"},{name:"**data",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.record_step_stats.kl_coef",description:`<strong>kl_coef</strong> (<code>float</code>) &#x2014;
KL coefficient`,name:"kl_coef"},{anchor:"trl.PPOTrainer.record_step_stats.data",description:`<strong>data</strong> (<code>dict</code>) &#x2014;
Dictionary of training step data`,name:"data"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1278",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of training step statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>stats (<code>dict</code>)</p>
`}}),Ue=new y({props:{name:"step",anchor:"trl.PPOTrainer.step",parameters:[{name:"queries",val:": List"},{name:"responses",val:": List"},{name:"scores",val:": List"},{name:"response_masks",val:": Optional = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.step.queries",description:`<strong>queries</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded queries of shape (<code>query_length</code>)`,name:"queries"},{anchor:"trl.PPOTrainer.step.responses",description:`<strong>responses</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded responses of shape (<code>response_length</code>)`,name:"responses"},{anchor:"trl.PPOTrainer.step.scores",description:`<strong>scores</strong> (List<code>torch.FloatTensor</code>) &#x2014;
List of tensors containing the scores.`,name:"scores"},{anchor:"trl.PPOTrainer.step.response_masks",description:`<strong>response_masks</strong> (List<code>torch.FloatTensor</code>, <em>optional</em>)) &#x2014;
List of tensors containing masks of the response tokens.`,name:"response_masks"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L646",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A summary of the training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),je=new y({props:{name:"train_minibatch",anchor:"trl.PPOTrainer.train_minibatch",parameters:[{name:"old_logprobs",val:": FloatTensor"},{name:"values",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"logits",val:": FloatTensor"},{name:"vpreds",val:": FloatTensor"},{name:"mask",val:": LongTensor"},{name:"advantages",val:": FloatTensor"},{name:"returns",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.train_minibatch.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape [mini_batch_size, response_length]`,name:"logprobs"},{anchor:"trl.PPOTrainer.train_minibatch.values",description:`<strong>values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape [mini_batch_size, response_length]`,name:"values"},{anchor:"trl.PPOTrainer.train_minibatch.query",description:`<strong>query</strong> (<code>torch.LongTensor</code>) &#x2014;
Encoded queries, shape [mini_batch_size, query_length]`,name:"query"},{anchor:"trl.PPOTrainer.train_minibatch.response",description:`<strong>response</strong> (<code>torch.LongTensor</code>) &#x2014;
Encoded responses, shape [mini_batch_size, response_length]`,name:"response"},{anchor:"trl.PPOTrainer.train_minibatch.model_input",description:`<strong>model_input</strong> (<code>torch.LongTensor</code>) &#x2014;
Concatenated queries and responses, shape [mini_batch_size, query_length+response_length]`,name:"model_input"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1061",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>train_stats (dict[str, <code>torch.Tensor</code>])</p>
`}}),Ce=new y({props:{name:"class trl.PPOConfig",anchor:"trl.PPOConfig",parameters:[{name:"exp_name",val:": str = 'doc-buil'"},{name:"seed",val:": int = 0"},{name:"log_with",val:": Optional = None"},{name:"task_name",val:": Optional = None"},{name:"model_name",val:": Optional = 'gpt2'"},{name:"query_dataset",val:": Optional = 'imdb'"},{name:"reward_model",val:": Optional = 'sentiment-analysis:lvwerra/distilbert-imdb'"},{name:"remove_unused_columns",val:": bool = True"},{name:"tracker_kwargs",val:": Annotated = <factory>"},{name:"accelerator_kwargs",val:": Annotated = <factory>"},{name:"project_kwargs",val:": Annotated = <factory>"},{name:"tracker_project_name",val:": str = 'trl'"},{name:"push_to_hub_if_best_kwargs",val:": Annotated = <factory>"},{name:"steps",val:": int = 20000"},{name:"learning_rate",val:": float = 1.41e-05"},{name:"adap_kl_ctrl",val:": bool = True"},{name:"init_kl_coef",val:": Optional = 0.2"},{name:"kl_penalty",val:": Literal = 'kl'"},{name:"target",val:": Optional = 6"},{name:"horizon",val:": Optional = 10000"},{name:"gamma",val:": float = 1"},{name:"lam",val:": float = 0.95"},{name:"cliprange",val:": float = 0.2"},{name:"cliprange_value",val:": float = 0.2"},{name:"vf_coef",val:": float = 0.1"},{name:"batch_size",val:": int = 128"},{name:"forward_batch_size",val:": Optional = None"},{name:"mini_batch_size",val:": int = 128"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"world_size",val:": Annotated = None"},{name:"ppo_epochs",val:": int = 4"},{name:"max_grad_norm",val:": Optional = None"},{name:"optimize_cuda_cache",val:": Optional = None"},{name:"optimize_device_cache",val:": Optional = False"},{name:"early_stopping",val:": bool = False"},{name:"target_kl",val:": float = 1"},{name:"compare_steps",val:": int = 1"},{name:"ratio_threshold",val:": float = 10.0"},{name:"use_score_scaling",val:": bool = False"},{name:"use_score_norm",val:": bool = False"},{name:"score_clip",val:": Optional = None"},{name:"whiten_rewards",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"is_peft_model",val:": Optional = None"},{name:"backward_batch_size",val:": Annotated = None"},{name:"global_backward_batch_size",val:": Annotated = None"},{name:"global_batch_size",val:": Annotated = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_config.py#L34"}}),ke=new ha({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/ppo_trainer.mdx"}}),{c(){_=s("meta"),Qe=r(),Ne=s("p"),Se=r(),c(Z.$$.fragment),De=r(),B=s("p"),B.innerHTML=vn,Ye=r(),q=s("p"),q.innerHTML=Jn,Ke=r(),c(L.$$.fragment),et=r(),H=s("p"),H.textContent=Pn,tt=r(),G=s("ol"),G.innerHTML=In,nt=r(),W=s("p"),W.textContent=xn,at=r(),J=s("div"),J.innerHTML=$n,rt=r(),c(V.$$.fragment),ot=r(),R=s("p"),R.innerHTML=Un,st=r(),A=s("p"),A.innerHTML=jn,lt=r(),N=s("p"),N.innerHTML=Cn,it=r(),c(E.$$.fragment),dt=r(),X=s("p"),X.textContent=kn,pt=r(),c(Q.$$.fragment),ct=r(),c(S.$$.fragment),mt=r(),D=s("p"),D.innerHTML=zn,ht=r(),c(Y.$$.fragment),gt=r(),K=s("p"),K.innerHTML=Fn,ut=r(),c(ee.$$.fragment),ft=r(),te=s("p"),te.textContent=On,Tt=r(),c(ne.$$.fragment),wt=r(),ae=s("p"),ae.innerHTML=Zn,bt=r(),c(re.$$.fragment),yt=r(),oe=s("p"),oe.innerHTML=Bn,_t=r(),c(se.$$.fragment),Mt=r(),le=s("p"),le.innerHTML=qn,vt=r(),c(ie.$$.fragment),Jt=r(),de=s("p"),de.textContent=Ln,Pt=r(),pe=s("p"),pe.innerHTML=Hn,It=r(),ce=s("p"),ce.innerHTML=Gn,xt=r(),c(me.$$.fragment),$t=r(),he=s("p"),he.innerHTML=Wn,Ut=r(),c(ge.$$.fragment),jt=r(),ue=s("p"),ue.textContent=Vn,Ct=r(),fe=s("p"),fe.textContent=Rn,kt=r(),Te=s("ul"),Te.innerHTML=An,zt=r(),we=s("p"),we.textContent=Nn,Ft=r(),p=s("div"),c(be.$$.fragment),Dt=r(),ze=s("p"),ze.innerHTML=En,Yt=r(),P=s("div"),c(ye.$$.fragment),Kt=r(),Fe=s("p"),Fe.textContent=Xn,en=r(),I=s("div"),c(_e.$$.fragment),tn=r(),Oe=s("p"),Oe.textContent=Qn,nn=r(),x=s("div"),c(Me.$$.fragment),an=r(),Ze=s("p"),Ze.textContent=Sn,rn=r(),$=s("div"),c(ve.$$.fragment),on=r(),Be=s("p"),Be.textContent=Dn,sn=r(),U=s("div"),c(Je.$$.fragment),ln=r(),qe=s("p"),qe.innerHTML=Yn,dn=r(),j=s("div"),c(Pe.$$.fragment),pn=r(),Le=s("p"),Le.textContent=Kn,cn=r(),C=s("div"),c(Ie.$$.fragment),mn=r(),He=s("p"),He.textContent=ea,hn=r(),k=s("div"),c(xe.$$.fragment),gn=r(),Ge=s("p"),Ge.textContent=ta,un=r(),z=s("div"),c($e.$$.fragment),fn=r(),We=s("p"),We.textContent=na,Tn=r(),F=s("div"),c(Ue.$$.fragment),wn=r(),Ve=s("p"),Ve.textContent=aa,bn=r(),O=s("div"),c(je.$$.fragment),yn=r(),Re=s("p"),Re.textContent=ra,Ot=r(),M=s("div"),c(Ce.$$.fragment),_n=r(),Ae=s("p"),Ae.textContent=oa,Zt=r(),c(ke.$$.fragment),Bt=r(),Ee=s("p"),this.h()},l(e){const t=ca("svelte-u9bgzb",document.head);_=l(t,"META",{name:!0,content:!0}),t.forEach(n),Qe=o(e),Ne=l(e,"P",{}),w(Ne).forEach(n),Se=o(e),m(Z.$$.fragment,e),De=o(e),B=l(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1ulw62x"&&(B.innerHTML=vn),Ye=o(e),q=l(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-1c2evbn"&&(q.innerHTML=Jn),Ke=o(e),m(L.$$.fragment,e),et=o(e),H=l(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-79li59"&&(H.textContent=Pn),tt=o(e),G=l(e,"OL",{"data-svelte-h":!0}),d(G)!=="svelte-19gvbbs"&&(G.innerHTML=In),nt=o(e),W=l(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-11407q1"&&(W.textContent=xn),at=o(e),J=l(e,"DIV",{style:!0,"data-svelte-h":!0}),d(J)!=="svelte-7jo56"&&(J.innerHTML=$n),rt=o(e),m(V.$$.fragment,e),ot=o(e),R=l(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-r47fon"&&(R.innerHTML=Un),st=o(e),A=l(e,"P",{"data-svelte-h":!0}),d(A)!=="svelte-nw9p0e"&&(A.innerHTML=jn),lt=o(e),N=l(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-ew3j45"&&(N.innerHTML=Cn),it=o(e),m(E.$$.fragment,e),dt=o(e),X=l(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-1lutirw"&&(X.textContent=kn),pt=o(e),m(Q.$$.fragment,e),ct=o(e),m(S.$$.fragment,e),mt=o(e),D=l(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-kuth75"&&(D.innerHTML=zn),ht=o(e),m(Y.$$.fragment,e),gt=o(e),K=l(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-15i9f61"&&(K.innerHTML=Fn),ut=o(e),m(ee.$$.fragment,e),ft=o(e),te=l(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-ft92fq"&&(te.textContent=On),Tt=o(e),m(ne.$$.fragment,e),wt=o(e),ae=l(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-5saaij"&&(ae.innerHTML=Zn),bt=o(e),m(re.$$.fragment,e),yt=o(e),oe=l(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-1tdshp6"&&(oe.innerHTML=Bn),_t=o(e),m(se.$$.fragment,e),Mt=o(e),le=l(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-1dqo05b"&&(le.innerHTML=qn),vt=o(e),m(ie.$$.fragment,e),Jt=o(e),de=l(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-zzns90"&&(de.textContent=Ln),Pt=o(e),pe=l(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-1gfcgdl"&&(pe.innerHTML=Hn),It=o(e),ce=l(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-suejqf"&&(ce.innerHTML=Gn),xt=o(e),m(me.$$.fragment,e),$t=o(e),he=l(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-jd50df"&&(he.innerHTML=Wn),Ut=o(e),m(ge.$$.fragment,e),jt=o(e),ue=l(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-syz1xp"&&(ue.textContent=Vn),Ct=o(e),fe=l(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-1jybr47"&&(fe.textContent=Rn),kt=o(e),Te=l(e,"UL",{"data-svelte-h":!0}),d(Te)!=="svelte-1qs2o7q"&&(Te.innerHTML=An),zt=o(e),we=l(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-1f3y85q"&&(we.textContent=Nn),Ft=o(e),p=l(e,"DIV",{class:!0});var T=w(p);m(be.$$.fragment,T),Dt=o(T),ze=l(T,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-hys9rl"&&(ze.innerHTML=En),Yt=o(T),P=l(T,"DIV",{class:!0});var Lt=w(P);m(ye.$$.fragment,Lt),Kt=o(Lt),Fe=l(Lt,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-185nst0"&&(Fe.textContent=Xn),Lt.forEach(n),en=o(T),I=l(T,"DIV",{class:!0});var Ht=w(I);m(_e.$$.fragment,Ht),tn=o(Ht),Oe=l(Ht,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-3nt516"&&(Oe.textContent=Qn),Ht.forEach(n),nn=o(T),x=l(T,"DIV",{class:!0});var Gt=w(x);m(Me.$$.fragment,Gt),an=o(Gt),Ze=l(Gt,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-3jfrz9"&&(Ze.textContent=Sn),Gt.forEach(n),rn=o(T),$=l(T,"DIV",{class:!0});var Wt=w($);m(ve.$$.fragment,Wt),on=o(Wt),Be=l(Wt,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-lcc1u3"&&(Be.textContent=Dn),Wt.forEach(n),sn=o(T),U=l(T,"DIV",{class:!0});var Vt=w(U);m(Je.$$.fragment,Vt),ln=o(Vt),qe=l(Vt,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-1gqqzmu"&&(qe.innerHTML=Yn),Vt.forEach(n),dn=o(T),j=l(T,"DIV",{class:!0});var Rt=w(j);m(Pe.$$.fragment,Rt),pn=o(Rt),Le=l(Rt,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-ffqz5"&&(Le.textContent=Kn),Rt.forEach(n),cn=o(T),C=l(T,"DIV",{class:!0});var At=w(C);m(Ie.$$.fragment,At),mn=o(At),He=l(At,"P",{"data-svelte-h":!0}),d(He)!=="svelte-febvhf"&&(He.textContent=ea),At.forEach(n),hn=o(T),k=l(T,"DIV",{class:!0});var Nt=w(k);m(xe.$$.fragment,Nt),gn=o(Nt),Ge=l(Nt,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-1hbodkw"&&(Ge.textContent=ta),Nt.forEach(n),un=o(T),z=l(T,"DIV",{class:!0});var Et=w(z);m($e.$$.fragment,Et),fn=o(Et),We=l(Et,"P",{"data-svelte-h":!0}),d(We)!=="svelte-1hfgx92"&&(We.textContent=na),Et.forEach(n),Tn=o(T),F=l(T,"DIV",{class:!0});var Xt=w(F);m(Ue.$$.fragment,Xt),wn=o(Xt),Ve=l(Xt,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-yrsdu6"&&(Ve.textContent=aa),Xt.forEach(n),bn=o(T),O=l(T,"DIV",{class:!0});var Qt=w(O);m(je.$$.fragment,Qt),yn=o(Qt),Re=l(Qt,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-3k7k5e"&&(Re.textContent=ra),Qt.forEach(n),T.forEach(n),Ot=o(e),M=l(e,"DIV",{class:!0});var St=w(M);m(Ce.$$.fragment,St),_n=o(St),Ae=l(St,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-aondqr"&&(Ae.textContent=oa),St.forEach(n),Zt=o(e),m(ke.$$.fragment,e),Bt=o(e),Ee=l(e,"P",{}),w(Ee).forEach(n),this.h()},h(){b(_,"name","hf:doc:metadata"),b(_,"content",ua),ma(J,"text-align","center"),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,_),a(e,Qe,t),a(e,Ne,t),a(e,Se,t),h(Z,e,t),a(e,De,t),a(e,B,t),a(e,Ye,t),a(e,q,t),a(e,Ke,t),h(L,e,t),a(e,et,t),a(e,H,t),a(e,tt,t),a(e,G,t),a(e,nt,t),a(e,W,t),a(e,at,t),a(e,J,t),a(e,rt,t),h(V,e,t),a(e,ot,t),a(e,R,t),a(e,st,t),a(e,A,t),a(e,lt,t),a(e,N,t),a(e,it,t),h(E,e,t),a(e,dt,t),a(e,X,t),a(e,pt,t),h(Q,e,t),a(e,ct,t),h(S,e,t),a(e,mt,t),a(e,D,t),a(e,ht,t),h(Y,e,t),a(e,gt,t),a(e,K,t),a(e,ut,t),h(ee,e,t),a(e,ft,t),a(e,te,t),a(e,Tt,t),h(ne,e,t),a(e,wt,t),a(e,ae,t),a(e,bt,t),h(re,e,t),a(e,yt,t),a(e,oe,t),a(e,_t,t),h(se,e,t),a(e,Mt,t),a(e,le,t),a(e,vt,t),h(ie,e,t),a(e,Jt,t),a(e,de,t),a(e,Pt,t),a(e,pe,t),a(e,It,t),a(e,ce,t),a(e,xt,t),h(me,e,t),a(e,$t,t),a(e,he,t),a(e,Ut,t),h(ge,e,t),a(e,jt,t),a(e,ue,t),a(e,Ct,t),a(e,fe,t),a(e,kt,t),a(e,Te,t),a(e,zt,t),a(e,we,t),a(e,Ft,t),a(e,p,t),h(be,p,null),i(p,Dt),i(p,ze),i(p,Yt),i(p,P),h(ye,P,null),i(P,Kt),i(P,Fe),i(p,en),i(p,I),h(_e,I,null),i(I,tn),i(I,Oe),i(p,nn),i(p,x),h(Me,x,null),i(x,an),i(x,Ze),i(p,rn),i(p,$),h(ve,$,null),i($,on),i($,Be),i(p,sn),i(p,U),h(Je,U,null),i(U,ln),i(U,qe),i(p,dn),i(p,j),h(Pe,j,null),i(j,pn),i(j,Le),i(p,cn),i(p,C),h(Ie,C,null),i(C,mn),i(C,He),i(p,hn),i(p,k),h(xe,k,null),i(k,gn),i(k,Ge),i(p,un),i(p,z),h($e,z,null),i(z,fn),i(z,We),i(p,Tn),i(p,F),h(Ue,F,null),i(F,wn),i(F,Ve),i(p,bn),i(p,O),h(je,O,null),i(O,yn),i(O,Re),a(e,Ot,t),a(e,M,t),h(Ce,M,null),i(M,_n),i(M,Ae),a(e,Zt,t),h(ke,e,t),a(e,Bt,t),a(e,Ee,t),qt=!0},p:la,i(e){qt||(g(Z.$$.fragment,e),g(L.$$.fragment,e),g(V.$$.fragment,e),g(E.$$.fragment,e),g(Q.$$.fragment,e),g(S.$$.fragment,e),g(Y.$$.fragment,e),g(ee.$$.fragment,e),g(ne.$$.fragment,e),g(re.$$.fragment,e),g(se.$$.fragment,e),g(ie.$$.fragment,e),g(me.$$.fragment,e),g(ge.$$.fragment,e),g(be.$$.fragment,e),g(ye.$$.fragment,e),g(_e.$$.fragment,e),g(Me.$$.fragment,e),g(ve.$$.fragment,e),g(Je.$$.fragment,e),g(Pe.$$.fragment,e),g(Ie.$$.fragment,e),g(xe.$$.fragment,e),g($e.$$.fragment,e),g(Ue.$$.fragment,e),g(je.$$.fragment,e),g(Ce.$$.fragment,e),g(ke.$$.fragment,e),qt=!0)},o(e){u(Z.$$.fragment,e),u(L.$$.fragment,e),u(V.$$.fragment,e),u(E.$$.fragment,e),u(Q.$$.fragment,e),u(S.$$.fragment,e),u(Y.$$.fragment,e),u(ee.$$.fragment,e),u(ne.$$.fragment,e),u(re.$$.fragment,e),u(se.$$.fragment,e),u(ie.$$.fragment,e),u(me.$$.fragment,e),u(ge.$$.fragment,e),u(be.$$.fragment,e),u(ye.$$.fragment,e),u(_e.$$.fragment,e),u(Me.$$.fragment,e),u(ve.$$.fragment,e),u(Je.$$.fragment,e),u(Pe.$$.fragment,e),u(Ie.$$.fragment,e),u(xe.$$.fragment,e),u($e.$$.fragment,e),u(Ue.$$.fragment,e),u(je.$$.fragment,e),u(Ce.$$.fragment,e),u(ke.$$.fragment,e),qt=!1},d(e){e&&(n(Qe),n(Ne),n(Se),n(De),n(B),n(Ye),n(q),n(Ke),n(et),n(H),n(tt),n(G),n(nt),n(W),n(at),n(J),n(rt),n(ot),n(R),n(st),n(A),n(lt),n(N),n(it),n(dt),n(X),n(pt),n(ct),n(mt),n(D),n(ht),n(gt),n(K),n(ut),n(ft),n(te),n(Tt),n(wt),n(ae),n(bt),n(yt),n(oe),n(_t),n(Mt),n(le),n(vt),n(Jt),n(de),n(Pt),n(pe),n(It),n(ce),n(xt),n($t),n(he),n(Ut),n(jt),n(ue),n(Ct),n(fe),n(kt),n(Te),n(zt),n(we),n(Ft),n(p),n(Ot),n(M),n(Zt),n(Bt),n(Ee)),n(_),f(Z,e),f(L,e),f(V,e),f(E,e),f(Q,e),f(S,e),f(Y,e),f(ee,e),f(ne,e),f(re,e),f(se,e),f(ie,e),f(me,e),f(ge,e),f(be),f(ye),f(_e),f(Me),f(ve),f(Je),f(Pe),f(Ie),f(xe),f($e),f(Ue),f(je),f(Ce),f(ke,e)}}}const ua='{"title":"PPO Trainer","local":"ppo-trainer","sections":[{"title":"How PPO works","local":"how-ppo-works","sections":[],"depth":2},{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Using the PPOTrainer","local":"using-the-ppotrainer","sections":[{"title":"Initializing the PPOTrainer","local":"initializing-the-ppotrainer","sections":[],"depth":3}],"depth":2}],"depth":1}';function fa(Mn){return ia(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ma extends da{constructor(_){super(),pa(this,_,fa,ga,sa,{})}}export{Ma as component};
