import{s as pt,o as rt,n as Ge}from"../chunks/scheduler.d6170356.js";import{S as ct,i as ut,g as o,s,r as h,A as ht,h as p,f as a,c as n,j as nt,u as d,x as r,k as it,y as dt,a as l,v as f,d as m,t as g,w}from"../chunks/index.fcd4cc08.js";import{T as xe}from"../chunks/Tip.b09c67cf.js";import{C as ot}from"../chunks/CodeBlock.7b16bdef.js";import{H as D}from"../chunks/Heading.8660bd0e.js";function ft(T){let i,u='This guide will take you through the process of integrating a <em>Sign-In with HF</em> button into any Space. If you’re seeking a fast and simple method to implement this in a <strong>Gradio</strong> Space, take a look at its <a href="https://www.gradio.app/guides/sharing-your-app#o-auth-login-via-hugging-face" rel="nofollow">built-in integration</a>.';return{c(){i=o("p"),i.innerHTML=u},l(c){i=p(c,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1nqltc0"&&(i.innerHTML=u)},m(c,M){l(c,i,M)},p:Ge,d(c){c&&a(i)}}}function mt(T){let i,u='You can also use the HF OAuth flow to create a “Sign in with HF” flow in any website or App, outside of Spaces. <a href="./oauth">Read our general OAuth page</a>.';return{c(){i=o("p"),i.innerHTML=u},l(c){i=p(c,"P",{"data-svelte-h":!0}),r(i)!=="svelte-138wjpm"&&(i.innerHTML=u)},m(c,M){l(c,i,M)},p:Ge,d(c){c&&a(i)}}}function gt(T){let i,u="You should use <code>target=_blank</code> on the button to open the sign-in page in a new tab, unless you run the space outside its <code>iframe</code>. Otherwise, you might encounter issues with cookies on some browsers.";return{c(){i=o("p"),i.innerHTML=u},l(c){i=p(c,"P",{"data-svelte-h":!0}),r(i)!=="svelte-9c51kn"&&(i.innerHTML=u)},m(c,M){l(c,i,M)},p:Ge,d(c){c&&a(i)}}}function wt(T){let i,u,c,M,j,ee,v,ke='You can enable a built-in sign-in flow in your Space by seamlessly creating and associating an <a href="https://developer.okta.com/blog/2019/10/21/illustrated-guide-to-oauth-and-oidc" rel="nofollow">OAuth/OpenID connect</a> app so users can log in with their HF account.',te,_,Ee='This enables new use cases for your Space. For instance, when combined with <a href="https://huggingface.co/docs/hub/spaces-storage" rel="nofollow">Persistent Storage</a>, a generative AI Space could allow users to log in to access their previous generations, only accessible to them.',ae,b,le,y,se,J,ne,C,Be="All you need to do is add <code>hf_oauth: true</code> to your Space’s metadata inside your <code>README.md</code> file.",ie,I,Re="Here’s an example of metadata for a Gradio Space:",oe,H,pe,U,Ze='You can check out the <a href="./spaces-config-reference">configuration reference docs</a> for more information.',re,S,Ae='This will add the following <a href="https://huggingface.co/docs/hub/spaces-overview#helper-environment-variables" rel="nofollow">environment variables</a> to your space:',ce,L,Pe='<li><code>OAUTH_CLIENT_ID</code>: the client ID of your OAuth app (public)</li> <li><code>OAUTH_CLIENT_SECRET</code>: the client secret of your OAuth app</li> <li><code>OAUTH_SCOPES</code>: scopes accessible by your OAuth app.</li> <li><code>OPENID_PROVIDER_URL</code>: The URL of the OpenID provider. The OpenID metadata will be available at <a href="https://huggingface.co/.well-known/openid-configuration" rel="nofollow"><code>{OPENID_PROVIDER_URL}/.well-known/openid-configuration</code></a>.</li>',ue,x,We="As for any other environment variable, you can use them in your code by using <code>os.getenv(&quot;OAUTH_CLIENT_ID&quot;)</code>, for example.",he,G,de,k,Xe="You can use any redirect URL you want, as long as it targets your Space.",fe,E,Fe='Note that <code>SPACE_HOST</code> is <a href="https://huggingface.co/docs/hub/spaces-overview#helper-environment-variables" rel="nofollow">available</a> as an environment variable.',me,B,Ne="For example, you can use <code>https://{SPACE_HOST}/login/callback</code> as a redirect URI.",ge,R,we,Z,Ye="The following scopes are always included for Spaces:",Me,A,Oe="<li><code>openid</code>: Get the ID token in addition to the access token.</li> <li><code>profile</code>: Get the user’s profile information (username, avatar, etc.)</li>",Te,P,Ve="Those scopes are optional and can be added by setting <code>hf_oauth_scopes</code> in your Space’s metadata:",be,W,ze='<li><code>email</code>: Get the user’s email address.</li> <li><code>read-repos</code>: Get read access to the user’s personal repos.</li> <li><code>write-repos</code>: Get write/read access to the user’s personal repos.</li> <li><code>manage-repos</code>: Get full access to the user’s personal repos. Also grants repo creation and deletion.</li> <li><code>inference-api</code>: Get access to the <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a>, you will be able to make inference requests on behalf of the user.</li>',ye,X,$e,F,Qe='You now have all the information to add a “Sign-in with HF” button to your Space. Some libraries (<a href="https://github.com/lepture/authlib" rel="nofollow">Python</a>, <a href="https://github.com/panva/node-openid-client" rel="nofollow">NodeJS</a>) can help you implement the OpenID/OAuth protocol.',je,N,qe='Gradio and hugginface.js also provide <strong>built-in support</strong>, making implementing the Sign-in with HF button a breeze; you can check out the associated guides with <a href="https://www.gradio.app/guides/sharing-your-app#o-auth-login-via-hugging-face" rel="nofollow">gradio</a> and with <a href="https://huggingface.co/docs/huggingface.js/hub/README#oauth-login" rel="nofollow">hugginface.js</a>.',ve,Y,De="Basically, you need to:",_e,O,Ke="<li>Redirect the user to <code>https://huggingface.co/oauth/authorize?redirect_uri={REDIRECT_URI}&amp;scope=openid%20profile&amp;client_id={CLIENT_ID}&amp;state={STATE}</code>, where <code>STATE</code> is a random string that you will need to verify later.</li> <li>Handle the callback on <code>/auth/callback</code> or <code>/login/callback</code> (or your own custom callback URL) and verify the <code>state</code> parameter.</li> <li>Use the <code>code</code> query parameter to get an access token and id token from <code>https://huggingface.co/oauth/token</code> (POST request with <code>client_id</code>, <code>code</code>, <code>grant_type=authorization_code</code> and <code>redirect_uri</code> as form data, and with <code>Authorization: Basic {base64(client_id:client_secret)}</code> as a header).</li>",Je,$,Ce,V,Ie,z,et='<li><a href="https://huggingface.co/spaces/Wauplin/gradio-oauth-test" rel="nofollow">Gradio test app</a></li> <li><a href="https://huggingface.co/spaces/huggingchat/chat-ui" rel="nofollow">Hugging Chat (NodeJS/SvelteKit)</a></li> <li><a href="https://huggingface.co/spaces/huggingfacejs/inference-widgets" rel="nofollow">Inference Widgets (Auth.js/SvelteKit)</a>, uses the <code>inference-api</code> scope to make inference requests on behalf of the user.</li> <li><a href="https://huggingface.co/spaces/huggingfacejs/client-side-oauth" rel="nofollow">Client-Side in a Static Space (huggingface.js)</a> - very simple JavaScript example.</li>',He,Q,tt="JS Code example:",Ue,q,Se,K,Le;return j=new D({props:{title:"Adding a Sign-In with HF button to your Space",local:"adding-a-sign-in-with-hf-button-to-your-space",headingTag:"h1"}}),b=new xe({props:{$$slots:{default:[ft]},$$scope:{ctx:T}}}),y=new xe({props:{$$slots:{default:[mt]},$$scope:{ctx:T}}}),J=new D({props:{title:"Create an OAuth app",local:"create-an-oauth-app",headingTag:"h2"}}),H=new ot({props:{code:"dGl0bGUlM0ElMjBHcmFkaW8lMjBPYXV0aCUyMFRlc3QlMEFlbW9qaSUzQSUyMCVGMCU5RiU4RiU4NiUwQWNvbG9yRnJvbSUzQSUyMHBpbmslMEFjb2xvclRvJTNBJTIwcGluayUwQXNkayUzQSUyMGdyYWRpbyUwQXNka192ZXJzaW9uJTNBJTIwMy40MC4wJTBBcHl0aG9uX3ZlcnNpb24lM0ElMjAzLjEwLjYlMEFhcHBfZmlsZSUzQSUyMGFwcC5weSUwQSUwQWhmX29hdXRoJTNBJTIwdHJ1ZSUwQSUyMyUyMG9wdGlvbmFsJTJDJTIwZGVmYXVsdCUyMGR1cmF0aW9uJTIwaXMlMjA4JTIwaG91cnMlMkY0ODAlMjBtaW51dGVzLiUyME1heCUyMGR1cmF0aW9uJTIwaXMlMjAzMCUyMGRheXMlMkY0MzIwMCUyMG1pbnV0ZXMuJTBBaGZfb2F1dGhfZXhwaXJhdGlvbl9taW51dGVzJTNBJTIwNDgwJTBBJTIzJTIwb3B0aW9uYWwlMkMlMjBzZWUlMjAlMjJTY29wZXMlMjIlMjBiZWxvdy4lMjAlMjJvcGVuaWQlMjBwcm9maWxlJTIyJTIwaXMlMjBhbHdheXMlMjBpbmNsdWRlZC4lMEFoZl9vYXV0aF9zY29wZXMlM0ElMEElMjAtJTIwcmVhZC1yZXBvcyUwQSUyMC0lMjB3cml0ZS1yZXBvcyUwQSUyMC0lMjBtYW5hZ2UtcmVwb3MlMEElMjAtJTIwaW5mZXJlbmNlLWFwaQ==",highlighted:`<span class="hljs-attr">title:</span> <span class="hljs-string">Gradio</span> <span class="hljs-string">Oauth</span> <span class="hljs-string">Test</span>
<span class="hljs-attr">emoji:</span> <span class="hljs-string">🏆</span>
<span class="hljs-attr">colorFrom:</span> <span class="hljs-string">pink</span>
<span class="hljs-attr">colorTo:</span> <span class="hljs-string">pink</span>
<span class="hljs-attr">sdk:</span> <span class="hljs-string">gradio</span>
<span class="hljs-attr">sdk_version:</span> <span class="hljs-number">3.40</span><span class="hljs-number">.0</span>
<span class="hljs-attr">python_version:</span> <span class="hljs-number">3.10</span><span class="hljs-number">.6</span>
<span class="hljs-attr">app_file:</span> <span class="hljs-string">app.py</span>

<span class="hljs-attr">hf_oauth:</span> <span class="hljs-literal">true</span>
<span class="hljs-comment"># optional, default duration is 8 hours/480 minutes. Max duration is 30 days/43200 minutes.</span>
<span class="hljs-attr">hf_oauth_expiration_minutes:</span> <span class="hljs-number">480</span>
<span class="hljs-comment"># optional, see &quot;Scopes&quot; below. &quot;openid profile&quot; is always included.</span>
<span class="hljs-attr">hf_oauth_scopes:</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">read-repos</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">write-repos</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">manage-repos</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">inference-api</span>`,wrap:!1}}),G=new D({props:{title:"Redirect URLs",local:"redirect-urls",headingTag:"h2"}}),R=new D({props:{title:"Scopes",local:"scopes",headingTag:"h2"}}),X=new D({props:{title:"Adding the button to your Space",local:"adding-the-button-to-your-space",headingTag:"h2"}}),$=new xe({props:{warning:!0,$$slots:{default:[gt]},$$scope:{ctx:T}}}),V=new D({props:{title:"Examples:",local:"examples",headingTag:"h2"}}),q=new ot({props:{code:"aW1wb3J0JTIwJTdCJTIwb2F1dGhMb2dpblVybCUyQyUyMG9hdXRoSGFuZGxlUmVkaXJlY3RJZlByZXNlbnQlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlM0IlMEElMEFjb25zdCUyMG9hdXRoUmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBvYXV0aEhhbmRsZVJlZGlyZWN0SWZQcmVzZW50KCklM0IlMEElMEFpZiUyMCghb2F1dGhSZXN1bHQpJTIwJTdCJTBBJTIwJTIwJTJGJTJGJTIwSWYlMjB0aGUlMjB1c2VyJTIwaXMlMjBub3QlMjBsb2dnZWQlMjBpbiUyQyUyMHJlZGlyZWN0JTIwdG8lMjB0aGUlMjBsb2dpbiUyMHBhZ2UlMEElMjAlMjB3aW5kb3cubG9jYXRpb24uaHJlZiUyMCUzRCUyMGF3YWl0JTIwb2F1dGhMb2dpblVybCgpJTNCJTBBJTdEJTBBJTBBJTJGJTJGJTIwWW91JTIwY2FuJTIwdXNlJTIwb2F1dGhSZXN1bHQuYWNjZXNzVG9rZW4lMkMlMjBvYXV0aFJlc3VsdC51c2VySW5mbyUyMGFtb25nJTIwb3RoZXIlMjB0aGluZ3MlMEFjb25zb2xlLmxvZyhvYXV0aFJlc3VsdCklM0I=",highlighted:`<span class="hljs-keyword">import</span> { oauthLoginUrl, oauthHandleRedirectIfPresent } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> oauthResult = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthHandleRedirectIfPresent</span>();

<span class="hljs-keyword">if</span> (!oauthResult) {
  <span class="hljs-comment">// If the user is not logged in, redirect to the login page</span>
  <span class="hljs-variable language_">window</span>.<span class="hljs-property">location</span>.<span class="hljs-property">href</span> = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthLoginUrl</span>();
}

<span class="hljs-comment">// You can use oauthResult.accessToken, oauthResult.userInfo among other things</span>
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(oauthResult);`,wrap:!1}}),{c(){i=o("meta"),u=s(),c=o("p"),M=s(),h(j.$$.fragment),ee=s(),v=o("p"),v.innerHTML=ke,te=s(),_=o("p"),_.innerHTML=Ee,ae=s(),h(b.$$.fragment),le=s(),h(y.$$.fragment),se=s(),h(J.$$.fragment),ne=s(),C=o("p"),C.innerHTML=Be,ie=s(),I=o("p"),I.textContent=Re,oe=s(),h(H.$$.fragment),pe=s(),U=o("p"),U.innerHTML=Ze,re=s(),S=o("p"),S.innerHTML=Ae,ce=s(),L=o("ul"),L.innerHTML=Pe,ue=s(),x=o("p"),x.innerHTML=We,he=s(),h(G.$$.fragment),de=s(),k=o("p"),k.textContent=Xe,fe=s(),E=o("p"),E.innerHTML=Fe,me=s(),B=o("p"),B.innerHTML=Ne,ge=s(),h(R.$$.fragment),we=s(),Z=o("p"),Z.textContent=Ye,Me=s(),A=o("ul"),A.innerHTML=Oe,Te=s(),P=o("p"),P.innerHTML=Ve,be=s(),W=o("ul"),W.innerHTML=ze,ye=s(),h(X.$$.fragment),$e=s(),F=o("p"),F.innerHTML=Qe,je=s(),N=o("p"),N.innerHTML=qe,ve=s(),Y=o("p"),Y.textContent=De,_e=s(),O=o("ul"),O.innerHTML=Ke,Je=s(),h($.$$.fragment),Ce=s(),h(V.$$.fragment),Ie=s(),z=o("ul"),z.innerHTML=et,He=s(),Q=o("p"),Q.textContent=tt,Ue=s(),h(q.$$.fragment),Se=s(),K=o("p"),this.h()},l(e){const t=ht("svelte-u9bgzb",document.head);i=p(t,"META",{name:!0,content:!0}),t.forEach(a),u=n(e),c=p(e,"P",{}),nt(c).forEach(a),M=n(e),d(j.$$.fragment,e),ee=n(e),v=p(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1nfjaew"&&(v.innerHTML=ke),te=n(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1t83yje"&&(_.innerHTML=Ee),ae=n(e),d(b.$$.fragment,e),le=n(e),d(y.$$.fragment,e),se=n(e),d(J.$$.fragment,e),ne=n(e),C=p(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1u00faw"&&(C.innerHTML=Be),ie=n(e),I=p(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-vlpqut"&&(I.textContent=Re),oe=n(e),d(H.$$.fragment,e),pe=n(e),U=p(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-ml9rcy"&&(U.innerHTML=Ze),re=n(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-12m1u10"&&(S.innerHTML=Ae),ce=n(e),L=p(e,"UL",{"data-svelte-h":!0}),r(L)!=="svelte-k73zcv"&&(L.innerHTML=Pe),ue=n(e),x=p(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-qqxlx3"&&(x.innerHTML=We),he=n(e),d(G.$$.fragment,e),de=n(e),k=p(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-eoih5g"&&(k.textContent=Xe),fe=n(e),E=p(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1a014a5"&&(E.innerHTML=Fe),me=n(e),B=p(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-4fyftp"&&(B.innerHTML=Ne),ge=n(e),d(R.$$.fragment,e),we=n(e),Z=p(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-sd96qs"&&(Z.textContent=Ye),Me=n(e),A=p(e,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-3wn6r0"&&(A.innerHTML=Oe),Te=n(e),P=p(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-181zoj"&&(P.innerHTML=Ve),be=n(e),W=p(e,"UL",{"data-svelte-h":!0}),r(W)!=="svelte-icfyf6"&&(W.innerHTML=ze),ye=n(e),d(X.$$.fragment,e),$e=n(e),F=p(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1a3vuj4"&&(F.innerHTML=Qe),je=n(e),N=p(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1ox841a"&&(N.innerHTML=qe),ve=n(e),Y=p(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-g0kxak"&&(Y.textContent=De),_e=n(e),O=p(e,"UL",{"data-svelte-h":!0}),r(O)!=="svelte-159xo4d"&&(O.innerHTML=Ke),Je=n(e),d($.$$.fragment,e),Ce=n(e),d(V.$$.fragment,e),Ie=n(e),z=p(e,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-lipo2y"&&(z.innerHTML=et),He=n(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1g8zr10"&&(Q.textContent=tt),Ue=n(e),d(q.$$.fragment,e),Se=n(e),K=p(e,"P",{}),nt(K).forEach(a),this.h()},h(){it(i,"name","hf:doc:metadata"),it(i,"content",Mt)},m(e,t){dt(document.head,i),l(e,u,t),l(e,c,t),l(e,M,t),f(j,e,t),l(e,ee,t),l(e,v,t),l(e,te,t),l(e,_,t),l(e,ae,t),f(b,e,t),l(e,le,t),f(y,e,t),l(e,se,t),f(J,e,t),l(e,ne,t),l(e,C,t),l(e,ie,t),l(e,I,t),l(e,oe,t),f(H,e,t),l(e,pe,t),l(e,U,t),l(e,re,t),l(e,S,t),l(e,ce,t),l(e,L,t),l(e,ue,t),l(e,x,t),l(e,he,t),f(G,e,t),l(e,de,t),l(e,k,t),l(e,fe,t),l(e,E,t),l(e,me,t),l(e,B,t),l(e,ge,t),f(R,e,t),l(e,we,t),l(e,Z,t),l(e,Me,t),l(e,A,t),l(e,Te,t),l(e,P,t),l(e,be,t),l(e,W,t),l(e,ye,t),f(X,e,t),l(e,$e,t),l(e,F,t),l(e,je,t),l(e,N,t),l(e,ve,t),l(e,Y,t),l(e,_e,t),l(e,O,t),l(e,Je,t),f($,e,t),l(e,Ce,t),f(V,e,t),l(e,Ie,t),l(e,z,t),l(e,He,t),l(e,Q,t),l(e,Ue,t),f(q,e,t),l(e,Se,t),l(e,K,t),Le=!0},p(e,[t]){const at={};t&2&&(at.$$scope={dirty:t,ctx:e}),b.$set(at);const lt={};t&2&&(lt.$$scope={dirty:t,ctx:e}),y.$set(lt);const st={};t&2&&(st.$$scope={dirty:t,ctx:e}),$.$set(st)},i(e){Le||(m(j.$$.fragment,e),m(b.$$.fragment,e),m(y.$$.fragment,e),m(J.$$.fragment,e),m(H.$$.fragment,e),m(G.$$.fragment,e),m(R.$$.fragment,e),m(X.$$.fragment,e),m($.$$.fragment,e),m(V.$$.fragment,e),m(q.$$.fragment,e),Le=!0)},o(e){g(j.$$.fragment,e),g(b.$$.fragment,e),g(y.$$.fragment,e),g(J.$$.fragment,e),g(H.$$.fragment,e),g(G.$$.fragment,e),g(R.$$.fragment,e),g(X.$$.fragment,e),g($.$$.fragment,e),g(V.$$.fragment,e),g(q.$$.fragment,e),Le=!1},d(e){e&&(a(u),a(c),a(M),a(ee),a(v),a(te),a(_),a(ae),a(le),a(se),a(ne),a(C),a(ie),a(I),a(oe),a(pe),a(U),a(re),a(S),a(ce),a(L),a(ue),a(x),a(he),a(de),a(k),a(fe),a(E),a(me),a(B),a(ge),a(we),a(Z),a(Me),a(A),a(Te),a(P),a(be),a(W),a(ye),a($e),a(F),a(je),a(N),a(ve),a(Y),a(_e),a(O),a(Je),a(Ce),a(Ie),a(z),a(He),a(Q),a(Ue),a(Se),a(K)),a(i),w(j,e),w(b,e),w(y,e),w(J,e),w(H,e),w(G,e),w(R,e),w(X,e),w($,e),w(V,e),w(q,e)}}}const Mt='{"title":"Adding a Sign-In with HF button to your Space","local":"adding-a-sign-in-with-hf-button-to-your-space","sections":[{"title":"Create an OAuth app","local":"create-an-oauth-app","sections":[],"depth":2},{"title":"Redirect URLs","local":"redirect-urls","sections":[],"depth":2},{"title":"Scopes","local":"scopes","sections":[],"depth":2},{"title":"Adding the button to your Space","local":"adding-the-button-to-your-space","sections":[],"depth":2},{"title":"Examples:","local":"examples","sections":[],"depth":2}],"depth":1}';function Tt(T){return rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _t extends ct{constructor(i){super(),ut(this,i,Tt,wt,pt,{})}}export{_t as component};
