import{s as Re,o as Be,n as We}from"../chunks/scheduler.d6170356.js";import{S as Xe,i as Le,g as o,s as a,r,A as ze,h as m,f as l,c as n,j as _e,u as p,x as w,k as He,y as Fe,a as s,v as d,d as c,t as M,w as h}from"../chunks/index.fcd4cc08.js";import{T as Ee}from"../chunks/Tip.b09c67cf.js";import{C as ge}from"../chunks/CodeBlock.7b16bdef.js";import{H as y}from"../chunks/Heading.8660bd0e.js";function Qe(V){let i,g="As of today (2024-03-08) mlx does not support <code>group</code> param for nn.Conv2d. Therefore, architectures such as <code>resnext</code>, <code>regnet</code> or <code>efficientnet</code> are not yet supported in <code>mlxim</code>.";return{c(){i=o("p"),i.innerHTML=g},l(f){i=m(f,"P",{"data-svelte-h":!0}),w(i)!=="svelte-1qywutr"&&(i.innerHTML=g)},m(f,Y){s(f,i,Y)},p:We,d(f){f&&l(i)}}}function Ye(V){let i,g,f,Y,T,A,J,Te='<a href="https://github.com/riccardomusmeci/mlx-image" rel="nofollow"><code>mlxim</code></a> is an image models library built on Apple <a href="https://github.com/ml-explore/mlx" rel="nofollow">MLX</a>. It tries to replicate the great <a href="https://github.com/huggingface/pytorch-image-models" rel="nofollow">timm</a> library from Ross Wightman, but for MLX models.',S,b,q,$,Je=`You can find <code>mlxim</code> models by filtering using the <code>mlxim</code> library name, like in <a href="https://huggingface.co/models?library=mlx-image&amp;sort=trending" rel="nofollow">this query</a>.
There’s also an open <a href="https://huggingface.co/mlx-vision" rel="nofollow">mlx-vision</a> space for contributors converting and publishing weights for MLX format.`,P,j,be="Thanks to MLX Hugging Face Hub integration, you can load MLX models with a few lines of code.",D,U,K,I,O,x,ee,C,$e='Model weights are available on the <a href="https://huggingface.co/mlx-vision" rel="nofollow"><code>mlx-vision</code></a> community on HuggingFace.',te,Z,je="To load a model with pre-trained weights:",le,v,se,G,Ue="To list all available models:",ae,k,ne,u,ie,_,oe,H,Ie='Go to <a href="https://github.com/riccardomusmeci/mlx-image/blob/main/results/results-imagenet-1k.csv" rel="nofollow">results-imagenet-1k.csv</a> to check every model converted to <code>mlxim</code> and its performance on ImageNet-1K with different settings.',me,R,xe="<p><strong>TL;DR</strong> performance is comparable to the original models from PyTorch implementations.</p>",re,B,pe,W,Ce="<code>mlxim</code> tries to be as close as possible to PyTorch:",de,X,Ze="<li><code>DataLoader</code> -&gt; you can define your own <code>collate_fn</code> and also use <code>num_workers</code> to speed up data loading</li> <li><code>Dataset</code> -&gt; <code>mlxim</code> already supports <code>LabelFolderDataset</code> (the good and old PyTorch <code>ImageFolder</code>) and <code>FolderDataset</code> (a generic folder with images in it)</li> <li><code>ModelCheckpoint</code> -&gt; keeps track of the best model and saves it to disk (similar to PyTorchLightning). It also suggests early stopping</li>",ce,L,Me,z,ve="Training is similar to PyTorch. Here’s an example of how to train a model:",he,F,we,E,fe,Q,Ge='<li><a href="https://github.com/riccardomusmeci/mlx-image" rel="nofollow">mlxim repository</a></li> <li><a href="https://huggingface.co/models?library=mlxim&amp;sort=trending" rel="nofollow">All mlxim models on Hub</a></li>',ue,N,ye;return T=new y({props:{title:"Using mlxim at Hugging Face",local:"using-mlxim-at-hugging-face",headingTag:"h1"}}),b=new y({props:{title:"Exploring MLX on the Hub",local:"exploring-mlx-on-the-hub",headingTag:"h2"}}),U=new y({props:{title:"Installation",local:"installation",headingTag:"h2"}}),I=new ge({props:{code:"cGlwJTIwaW5zdGFsbCUyMG1seC1pbWFnZQ==",highlighted:"pip install mlx-image",wrap:!1}}),x=new y({props:{title:"Models",local:"models",headingTag:"h2"}}),v=new ge({props:{code:"ZnJvbSUyMG1seGltLm1vZGVsJTIwaW1wb3J0JTIwY3JlYXRlX21vZGVsJTBBJTBBJTIzJTIwbG9hZGluZyUyMHdlaWdodHMlMjBmcm9tJTIwSHVnZ2luZ0ZhY2UlMjAoaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRm1seC12aXNpb24lMkZyZXNuZXQxOC1tbHhpbSklMEFtb2RlbCUyMCUzRCUyMGNyZWF0ZV9tb2RlbCglMjJyZXNuZXQxOCUyMiklMjAlMjMlMjBwcmV0cmFpbmVkJTIwd2VpZ2h0cyUyMGxvYWRlZCUyMGZyb20lMjBIRiUwQSUwQSUyMyUyMGxvYWRpbmclMjB3ZWlnaHRzJTIwZnJvbSUyMGxvY2FsJTIwZmlsZSUwQW1vZGVsJTIwJTNEJTIwY3JlYXRlX21vZGVsKCUyMnJlc25ldDE4JTIyJTJDJTIwd2VpZ2h0cyUzRCUyMnBhdGglMkZ0byUyRnJlc25ldDE4JTJGbW9kZWwuc2FmZXRlbnNvcnMlMjIp",highlighted:`<span class="hljs-keyword">from</span> mlxim.model <span class="hljs-keyword">import</span> create_model

<span class="hljs-comment"># loading weights from HuggingFace (https://huggingface.co/mlx-vision/resnet18-mlxim)</span>
model = create_model(<span class="hljs-string">&quot;resnet18&quot;</span>) <span class="hljs-comment"># pretrained weights loaded from HF</span>

<span class="hljs-comment"># loading weights from local file</span>
model = create_model(<span class="hljs-string">&quot;resnet18&quot;</span>, weights=<span class="hljs-string">&quot;path/to/resnet18/model.safetensors&quot;</span>)`,wrap:!1}}),k=new ge({props:{code:"ZnJvbSUyMG1seGltLm1vZGVsJTIwaW1wb3J0JTIwbGlzdF9tb2RlbHMlMEFsaXN0X21vZGVscygp",highlighted:`<span class="hljs-keyword">from</span> mlxim.model <span class="hljs-keyword">import</span> list_models
list_models()`,wrap:!1}}),u=new Ee({props:{warning:!0,$$slots:{default:[Qe]},$$scope:{ctx:V}}}),_=new y({props:{title:"ImageNet-1K Results",local:"imagenet-1k-results",headingTag:"h2"}}),B=new y({props:{title:"Similarity to PyTorch and other familiar tools",local:"similarity-to-pytorch-and-other-familiar-tools",headingTag:"h2"}}),L=new y({props:{title:"Training",local:"training",headingTag:"h2"}}),F=new ge({props:{code:"aW1wb3J0JTIwbWx4Lm5uJTIwYXMlMjBubiUwQWltcG9ydCUyMG1seC5vcHRpbWl6ZXJzJTIwYXMlMjBvcHRpbSUwQWZyb20lMjBtbHhpbS5tb2RlbCUyMGltcG9ydCUyMGNyZWF0ZV9tb2RlbCUwQWZyb20lMjBtbHhpbS5kYXRhJTIwaW1wb3J0JTIwTGFiZWxGb2xkZXJEYXRhc2V0JTJDJTIwRGF0YUxvYWRlciUwQSUwQXRyYWluX2RhdGFzZXQlMjAlM0QlMjBMYWJlbEZvbGRlckRhdGFzZXQoJTBBJTIwJTIwJTIwJTIwcm9vdF9kaXIlM0QlMjJwYXRoJTJGdG8lMkZ0cmFpbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsYXNzX21hcCUzRCU3QjAlM0ElMjAlMjJjbGFzc18wJTIyJTJDJTIwMSUzQSUyMCUyMmNsYXNzXzElMjIlMkMlMjAyJTNBJTIwJTVCJTIyY2xhc3NfMiUyMiUyQyUyMCUyMmNsYXNzXzMlMjIlNUQlN0QlMEEpJTBBdHJhaW5fbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlciglMEElMjAlMjAlMjAlMjBkYXRhc2V0JTNEdHJhaW5fZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGJhdGNoX3NpemUlM0QzMiUyQyUwQSUyMCUyMCUyMCUyMHNodWZmbGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3dvcmtlcnMlM0Q0JTBBKSUwQW1vZGVsJTIwJTNEJTIwY3JlYXRlX21vZGVsKCUyMnJlc25ldDE4JTIyKSUyMCUyMyUyMHByZXRyYWluZWQlMjB3ZWlnaHRzJTIwbG9hZGVkJTIwZnJvbSUyMEhGJTBBb3B0aW1pemVyJTIwJTNEJTIwb3B0aW0uQWRhbShsZWFybmluZ19yYXRlJTNEMWUtMyklMEElMEFkZWYlMjB0cmFpbl9zdGVwKG1vZGVsJTJDJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG14Lm1lYW4obm4ubG9zc2VzLmNyb3NzX2VudHJvcHkobG9naXRzJTJDJTIwdGFyZ2V0KSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBsb3NzJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZSgxMCklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBiYXRjaCUyMGluJTIwdHJhaW5fbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyQyUyMHRhcmdldCUyMCUzRCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhaW5fc3RlcF9mbiUyMCUzRCUyMG5uLnZhbHVlX2FuZF9ncmFkKG1vZGVsJTJDJTIwdHJhaW5fc3RlcCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTJDJTIwZ3JhZHMlMjAlM0QlMjB0cmFpbl9zdGVwX2ZuKHglMkMlMjB0YXJnZXQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnVwZGF0ZShtb2RlbCUyQyUyMGdyYWRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG14LmV2YWwobW9kZWwuc3RhdGUlMkMlMjBvcHRpbWl6ZXIuc3RhdGUp",highlighted:`<span class="hljs-keyword">import</span> mlx.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">import</span> mlx.optimizers <span class="hljs-keyword">as</span> optim
<span class="hljs-keyword">from</span> mlxim.model <span class="hljs-keyword">import</span> create_model
<span class="hljs-keyword">from</span> mlxim.data <span class="hljs-keyword">import</span> LabelFolderDataset, DataLoader

train_dataset = LabelFolderDataset(
    root_dir=<span class="hljs-string">&quot;path/to/train&quot;</span>,
    class_map={<span class="hljs-number">0</span>: <span class="hljs-string">&quot;class_0&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;class_1&quot;</span>, <span class="hljs-number">2</span>: [<span class="hljs-string">&quot;class_2&quot;</span>, <span class="hljs-string">&quot;class_3&quot;</span>]}
)
train_loader = DataLoader(
    dataset=train_dataset,
    batch_size=<span class="hljs-number">32</span>,
    shuffle=<span class="hljs-literal">True</span>,
    num_workers=<span class="hljs-number">4</span>
)
model = create_model(<span class="hljs-string">&quot;resnet18&quot;</span>) <span class="hljs-comment"># pretrained weights loaded from HF</span>
optimizer = optim.Adam(learning_rate=<span class="hljs-number">1e-3</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">train_step</span>(<span class="hljs-params">model, inputs, targets</span>):
    logits = model(inputs)
    loss = mx.mean(nn.losses.cross_entropy(logits, target))
    <span class="hljs-keyword">return</span> loss

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">10</span>):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_loader:
        x, target = batch
        train_step_fn = nn.value_and_grad(model, train_step)
        loss, grads = train_step_fn(x, target)
        optimizer.update(model, grads)
        mx.<span class="hljs-built_in">eval</span>(model.state, optimizer.state)`,wrap:!1}}),E=new y({props:{title:"Additional Resources",local:"additional-resources",headingTag:"h2"}}),{c(){i=o("meta"),g=a(),f=o("p"),Y=a(),r(T.$$.fragment),A=a(),J=o("p"),J.innerHTML=Te,S=a(),r(b.$$.fragment),q=a(),$=o("p"),$.innerHTML=Je,P=a(),j=o("p"),j.textContent=be,D=a(),r(U.$$.fragment),K=a(),r(I.$$.fragment),O=a(),r(x.$$.fragment),ee=a(),C=o("p"),C.innerHTML=$e,te=a(),Z=o("p"),Z.textContent=je,le=a(),r(v.$$.fragment),se=a(),G=o("p"),G.textContent=Ue,ae=a(),r(k.$$.fragment),ne=a(),r(u.$$.fragment),ie=a(),r(_.$$.fragment),oe=a(),H=o("p"),H.innerHTML=Ie,me=a(),R=o("blockquote"),R.innerHTML=xe,re=a(),r(B.$$.fragment),pe=a(),W=o("p"),W.innerHTML=Ce,de=a(),X=o("ul"),X.innerHTML=Ze,ce=a(),r(L.$$.fragment),Me=a(),z=o("p"),z.textContent=ve,he=a(),r(F.$$.fragment),we=a(),r(E.$$.fragment),fe=a(),Q=o("ul"),Q.innerHTML=Ge,ue=a(),N=o("p"),this.h()},l(e){const t=ze("svelte-u9bgzb",document.head);i=m(t,"META",{name:!0,content:!0}),t.forEach(l),g=n(e),f=m(e,"P",{}),_e(f).forEach(l),Y=n(e),p(T.$$.fragment,e),A=n(e),J=m(e,"P",{"data-svelte-h":!0}),w(J)!=="svelte-2n12bf"&&(J.innerHTML=Te),S=n(e),p(b.$$.fragment,e),q=n(e),$=m(e,"P",{"data-svelte-h":!0}),w($)!=="svelte-r3zoo2"&&($.innerHTML=Je),P=n(e),j=m(e,"P",{"data-svelte-h":!0}),w(j)!=="svelte-msvbqi"&&(j.textContent=be),D=n(e),p(U.$$.fragment,e),K=n(e),p(I.$$.fragment,e),O=n(e),p(x.$$.fragment,e),ee=n(e),C=m(e,"P",{"data-svelte-h":!0}),w(C)!=="svelte-13m84xx"&&(C.innerHTML=$e),te=n(e),Z=m(e,"P",{"data-svelte-h":!0}),w(Z)!=="svelte-rlp6qh"&&(Z.textContent=je),le=n(e),p(v.$$.fragment,e),se=n(e),G=m(e,"P",{"data-svelte-h":!0}),w(G)!=="svelte-1xjx8g7"&&(G.textContent=Ue),ae=n(e),p(k.$$.fragment,e),ne=n(e),p(u.$$.fragment,e),ie=n(e),p(_.$$.fragment,e),oe=n(e),H=m(e,"P",{"data-svelte-h":!0}),w(H)!=="svelte-1wwkzln"&&(H.innerHTML=Ie),me=n(e),R=m(e,"BLOCKQUOTE",{"data-svelte-h":!0}),w(R)!=="svelte-1xz4blu"&&(R.innerHTML=xe),re=n(e),p(B.$$.fragment,e),pe=n(e),W=m(e,"P",{"data-svelte-h":!0}),w(W)!=="svelte-v30u5e"&&(W.innerHTML=Ce),de=n(e),X=m(e,"UL",{"data-svelte-h":!0}),w(X)!=="svelte-w6ibn"&&(X.innerHTML=Ze),ce=n(e),p(L.$$.fragment,e),Me=n(e),z=m(e,"P",{"data-svelte-h":!0}),w(z)!=="svelte-1cvxtzq"&&(z.textContent=ve),he=n(e),p(F.$$.fragment,e),we=n(e),p(E.$$.fragment,e),fe=n(e),Q=m(e,"UL",{"data-svelte-h":!0}),w(Q)!=="svelte-1397dzj"&&(Q.innerHTML=Ge),ue=n(e),N=m(e,"P",{}),_e(N).forEach(l),this.h()},h(){He(i,"name","hf:doc:metadata"),He(i,"content",Ne)},m(e,t){Fe(document.head,i),s(e,g,t),s(e,f,t),s(e,Y,t),d(T,e,t),s(e,A,t),s(e,J,t),s(e,S,t),d(b,e,t),s(e,q,t),s(e,$,t),s(e,P,t),s(e,j,t),s(e,D,t),d(U,e,t),s(e,K,t),d(I,e,t),s(e,O,t),d(x,e,t),s(e,ee,t),s(e,C,t),s(e,te,t),s(e,Z,t),s(e,le,t),d(v,e,t),s(e,se,t),s(e,G,t),s(e,ae,t),d(k,e,t),s(e,ne,t),d(u,e,t),s(e,ie,t),d(_,e,t),s(e,oe,t),s(e,H,t),s(e,me,t),s(e,R,t),s(e,re,t),d(B,e,t),s(e,pe,t),s(e,W,t),s(e,de,t),s(e,X,t),s(e,ce,t),d(L,e,t),s(e,Me,t),s(e,z,t),s(e,he,t),d(F,e,t),s(e,we,t),d(E,e,t),s(e,fe,t),s(e,Q,t),s(e,ue,t),s(e,N,t),ye=!0},p(e,[t]){const ke={};t&2&&(ke.$$scope={dirty:t,ctx:e}),u.$set(ke)},i(e){ye||(c(T.$$.fragment,e),c(b.$$.fragment,e),c(U.$$.fragment,e),c(I.$$.fragment,e),c(x.$$.fragment,e),c(v.$$.fragment,e),c(k.$$.fragment,e),c(u.$$.fragment,e),c(_.$$.fragment,e),c(B.$$.fragment,e),c(L.$$.fragment,e),c(F.$$.fragment,e),c(E.$$.fragment,e),ye=!0)},o(e){M(T.$$.fragment,e),M(b.$$.fragment,e),M(U.$$.fragment,e),M(I.$$.fragment,e),M(x.$$.fragment,e),M(v.$$.fragment,e),M(k.$$.fragment,e),M(u.$$.fragment,e),M(_.$$.fragment,e),M(B.$$.fragment,e),M(L.$$.fragment,e),M(F.$$.fragment,e),M(E.$$.fragment,e),ye=!1},d(e){e&&(l(g),l(f),l(Y),l(A),l(J),l(S),l(q),l($),l(P),l(j),l(D),l(K),l(O),l(ee),l(C),l(te),l(Z),l(le),l(se),l(G),l(ae),l(ne),l(ie),l(oe),l(H),l(me),l(R),l(re),l(pe),l(W),l(de),l(X),l(ce),l(Me),l(z),l(he),l(we),l(fe),l(Q),l(ue),l(N)),l(i),h(T,e),h(b,e),h(U,e),h(I,e),h(x,e),h(v,e),h(k,e),h(u,e),h(_,e),h(B,e),h(L,e),h(F,e),h(E,e)}}}const Ne='{"title":"Using mlxim at Hugging Face","local":"using-mlxim-at-hugging-face","sections":[{"title":"Exploring MLX on the Hub","local":"exploring-mlx-on-the-hub","sections":[],"depth":2},{"title":"Installation","local":"installation","sections":[],"depth":2},{"title":"Models","local":"models","sections":[],"depth":2},{"title":"ImageNet-1K Results","local":"imagenet-1k-results","sections":[],"depth":2},{"title":"Similarity to PyTorch and other familiar tools","local":"similarity-to-pytorch-and-other-familiar-tools","sections":[],"depth":2},{"title":"Training","local":"training","sections":[],"depth":2},{"title":"Additional Resources","local":"additional-resources","sections":[],"depth":2}],"depth":1}';function Ve(V){return Be(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ke extends Xe{constructor(i){super(),Le(this,i,Ve,Ye,Re,{})}}export{Ke as component};
