import{s as Pg,n as $g,o as wg}from"../chunks/scheduler.b108d059.js";import{S as vg,i as kg,g as r,s,r as p,A as xg,h as n,f as t,c as l,j as c,u,x as d,k as a,y as yg,a as i,v as g,d as m,t as f,w as h}from"../chunks/index.008de539.js";import{H as _}from"../chunks/Heading.88bfeb84.js";function Cg(jc){let L,os,es,is,b,ss,T,ls,P,Gc="Classes, functions, and utilities for generation.",rs,$,Ic="<strong>Todo</strong>",ns,w,Fc="<li>Describe how to create a custom <code>GenerationConfig</code>.</li>",ds,v,qc='<li><a href="#module_utils/generation">utils/generation</a><ul><li><em>static</em><ul><li><a href="#module_utils/generation.LogitsProcessorList">.LogitsProcessorList</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_utils/generation.LogitsProcessorList_new"><code>new LogitsProcessorList()</code></a></li> <li><a href="#module_utils/generation.LogitsProcessorList+push"><code>.push(item)</code></a></li> <li><a href="#module_utils/generation.LogitsProcessorList+extend"><code>.extend(items)</code></a></li> <li><a href="#module_utils/generation.LogitsProcessorList+_call"><code>._call(input_ids, batchedLogits)</code></a></li></ul></li> <li><a href="#module_utils/generation.LogitsProcessor">.LogitsProcessor</a> ⇐ <code>Callable</code><ul><li><em><a href="#module_utils/generation.LogitsProcessor+_call"><code>._call(input_ids, logits)</code></a></em></li></ul></li> <li><a href="#module_utils/generation.ForceTokensLogitsProcessor">.ForceTokensLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.ForceTokensLogitsProcessor_new"><code>new ForceTokensLogitsProcessor(forced_decoder_ids)</code></a></li> <li><a href="#module_utils/generation.ForceTokensLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Tensor</code></li></ul></li> <li><a href="#module_utils/generation.ForcedBOSTokenLogitsProcessor">.ForcedBOSTokenLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.ForcedBOSTokenLogitsProcessor_new"><code>new ForcedBOSTokenLogitsProcessor(bos_token_id)</code></a></li> <li><a href="#module_utils/generation.ForcedBOSTokenLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li> <li><a href="#module_utils/generation.ForcedEOSTokenLogitsProcessor">.ForcedEOSTokenLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.ForcedEOSTokenLogitsProcessor_new"><code>new ForcedEOSTokenLogitsProcessor(max_length, forced_eos_token_id)</code></a></li> <li><a href="#module_utils/generation.ForcedEOSTokenLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a></li></ul></li> <li><a href="#module_utils/generation.SuppressTokensAtBeginLogitsProcessor">.SuppressTokensAtBeginLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.SuppressTokensAtBeginLogitsProcessor_new"><code>new SuppressTokensAtBeginLogitsProcessor(begin_suppress_tokens, begin_index)</code></a></li> <li><a href="#module_utils/generation.SuppressTokensAtBeginLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li> <li><a href="#module_utils/generation.WhisperTimeStampLogitsProcessor">.WhisperTimeStampLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.WhisperTimeStampLogitsProcessor_new"><code>new WhisperTimeStampLogitsProcessor(generate_config)</code></a></li> <li><a href="#module_utils/generation.WhisperTimeStampLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Tensor</code></li></ul></li> <li><a href="#module_utils/generation.NoRepeatNGramLogitsProcessor">.NoRepeatNGramLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.NoRepeatNGramLogitsProcessor_new"><code>new NoRepeatNGramLogitsProcessor(no_repeat_ngram_size)</code></a></li> <li><a href="#module_utils/generation.NoRepeatNGramLogitsProcessor+getNgrams"><code>.getNgrams(prevInputIds)</code></a> ⇒ <code>Map.&lt;string, Array&lt;number&gt;&gt;</code></li> <li><a href="#module_utils/generation.NoRepeatNGramLogitsProcessor+getGeneratedNgrams"><code>.getGeneratedNgrams(bannedNgrams, prevInputIds)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/generation.NoRepeatNGramLogitsProcessor+calcBannedNgramTokens"><code>.calcBannedNgramTokens(prevInputIds)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/generation.NoRepeatNGramLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li> <li><a href="#module_utils/generation.RepetitionPenaltyLogitsProcessor">.RepetitionPenaltyLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.RepetitionPenaltyLogitsProcessor_new"><code>new RepetitionPenaltyLogitsProcessor(penalty)</code></a></li> <li><a href="#module_utils/generation.RepetitionPenaltyLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li> <li><a href="#module_utils/generation.MinLengthLogitsProcessor">.MinLengthLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.MinLengthLogitsProcessor_new"><code>new MinLengthLogitsProcessor(min_length, eos_token_id)</code></a></li> <li><a href="#module_utils/generation.MinLengthLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li> <li><a href="#module_utils/generation.MinNewTokensLengthLogitsProcessor">.MinNewTokensLengthLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.MinNewTokensLengthLogitsProcessor_new"><code>new MinNewTokensLengthLogitsProcessor(prompt_length_to_skip, min_new_tokens, eos_token_id)</code></a></li> <li><a href="#module_utils/generation.MinNewTokensLengthLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li> <li><a href="#module_utils/generation.GenerationConfig">.GenerationConfig</a><ul><li><a href="#new_module_utils/generation.GenerationConfig_new"><code>new GenerationConfig([kwargs])</code></a></li></ul></li> <li><a href="#module_utils/generation.Sampler">.Sampler</a><ul><li><a href="#new_module_utils/generation.Sampler_new"><code>new Sampler(generation_config)</code></a></li> <li><em>instance</em><ul><li><a href="#module_utils/generation.Sampler+_call"><code>._call(logits, index)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/generation.Sampler+sample"><code>.sample(logits, index)</code></a></li> <li><a href="#module_utils/generation.Sampler+getLogits"><code>.getLogits(logits, index)</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/generation.Sampler+randomSelect"><code>.randomSelect(probabilities)</code></a> ⇒ <code>number</code></li></ul></li> <li><em>static</em><ul><li><a href="#module_utils/generation.Sampler.getSampler"><code>.getSampler(generation_config)</code></a> ⇒ <code>Sampler</code></li></ul></li></ul></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/generation..GreedySampler">~GreedySampler</a> ⇐ <code>Sampler</code><ul><li><a href="#module_utils/generation..GreedySampler+sample"><code>.sample(logits, [index])</code></a> ⇒ <code>Array</code></li></ul></li> <li><a href="#module_utils/generation..MultinomialSampler">~MultinomialSampler</a> ⇐ <code>Sampler</code><ul><li><a href="#module_utils/generation..MultinomialSampler+sample"><code>.sample(logits, index)</code></a> ⇒ <code>Array</code></li></ul></li> <li><a href="#module_utils/generation..BeamSearchSampler">~BeamSearchSampler</a> ⇐ <code>Sampler</code><ul><li><a href="#module_utils/generation..BeamSearchSampler+sample"><code>.sample(logits, index)</code></a> ⇒ <code>Array</code></li></ul></li></ul></li></ul></li>',as,cs,ps,k,us,x,gs,y,Dc=`A class representing a list of logits processors. A logits processor is a function that modifies the logits
output of a language model. This class provides methods for adding new processors and applying all processors to a
batch of logits.`,ms,C,zc='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>Callable</code>',fs,M,Kc='<li><a href="#module_utils/generation.LogitsProcessorList">.LogitsProcessorList</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_utils/generation.LogitsProcessorList_new"><code>new LogitsProcessorList()</code></a></li> <li><a href="#module_utils/generation.LogitsProcessorList+push"><code>.push(item)</code></a></li> <li><a href="#module_utils/generation.LogitsProcessorList+extend"><code>.extend(items)</code></a></li> <li><a href="#module_utils/generation.LogitsProcessorList+_call"><code>._call(input_ids, batchedLogits)</code></a></li></ul></li>',hs,_s,Ls,H,bs,S,Ts,A,Wc="Constructs a new instance of <code>LogitsProcessorList</code>.",Ps,$s,ws,R,vs,E,ks,N,Uc="Adds a new logits processor to the list.",xs,B,Jc='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.LogitsProcessorList"><code>LogitsProcessorList</code></a>',ys,O,Qc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>item</td><td><code>LogitsProcessor</code></td><td><p>The logits processor function to add.</p></td></tr></tbody>",Cs,Ms,Hs,j,Ss,G,As,I,Vc="Adds multiple logits processors to the list.",Rs,F,Xc='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.LogitsProcessorList"><code>LogitsProcessorList</code></a>',Es,q,Yc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>items</td><td><code>Array.&lt;LogitsProcessor&gt;</code></td><td><p>The logits processor functions to add.</p></td></tr></tbody>",Ns,Bs,Os,D,js,z,Gs,K,Zc="Applies all logits processors in the list to a batch of logits, modifying them in-place.",Is,W,ep='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.LogitsProcessorList"><code>LogitsProcessorList</code></a>',Fs,U,tp=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array.&lt;number&gt;</code></td><td><p>The input IDs for the language model.</p></td> </tr><tr><td>batchedLogits</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td><p>A 2D array of logits, where each row corresponds to a single
                                               input sequence in the batch.</p></td></tr></tbody>`,qs,Ds,zs,J,Ks,Q,Ws,V,op="Base class for processing logits.",Us,X,ip='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>Callable</code>',Js,Qs,Vs,Y,Xs,Z,Ys,ee,sp="Apply the processor to the input logits.",Zs,te,lp='<strong>Kind</strong>: instance abstract method of <a href="#module_utils/generation.LogitsProcessor"><code>LogitsProcessor</code></a><br/> <strong>Throws</strong>:',el,oe,rp="<li><code>Error</code> Throws an error if `_call` is not implemented in the subclass.</li>",tl,ie,np="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array</code></td><td><p>The input ids.</p></td> </tr><tr><td>logits</td><td><code>Tensor</code></td><td><p>The logits to process.</p></td></tr></tbody>",ol,il,sl,se,ll,le,rl,re,dp="A logits processor that forces a specific token to be generated by the decoder.",nl,ne,ap='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>LogitsProcessor</code>',dl,de,cp='<li><a href="#module_utils/generation.ForceTokensLogitsProcessor">.ForceTokensLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.ForceTokensLogitsProcessor_new"><code>new ForceTokensLogitsProcessor(forced_decoder_ids)</code></a></li> <li><a href="#module_utils/generation.ForceTokensLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Tensor</code></li></ul></li>',al,cl,pl,ae,ul,ce,gl,pe,pp="Constructs a new instance of <code>ForceTokensLogitsProcessor</code>.",ml,ue,up="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>forced_decoder_ids</td><td><code>Array</code></td><td><p>The ids of tokens that should be forced.</p></td></tr></tbody>",fl,hl,_l,ge,Ll,me,bl,fe,gp="Apply the processor to the input logits.",Tl,he,mp='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.ForceTokensLogitsProcessor"><code>ForceTokensLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The processed logits.',Pl,_e,fp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array</code></td><td><p>The input ids.</p></td> </tr><tr><td>logits</td><td><code>Tensor</code></td><td><p>The logits to process.</p></td></tr></tbody>",$l,wl,vl,Le,kl,be,xl,Te,hp="A LogitsProcessor that forces a BOS token at the beginning of the generated sequence.",yl,Pe,_p='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>LogitsProcessor</code>',Cl,$e,Lp='<li><a href="#module_utils/generation.ForcedBOSTokenLogitsProcessor">.ForcedBOSTokenLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.ForcedBOSTokenLogitsProcessor_new"><code>new ForcedBOSTokenLogitsProcessor(bos_token_id)</code></a></li> <li><a href="#module_utils/generation.ForcedBOSTokenLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li>',Ml,Hl,Sl,we,Al,ve,Rl,ke,bp="Create a ForcedBOSTokenLogitsProcessor.",El,xe,Tp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>bos_token_id</td><td><code>number</code></td><td><p>The ID of the beginning-of-sequence token to be forced.</p></td></tr></tbody>",Nl,Bl,Ol,ye,jl,Ce,Gl,Me,Pp="Apply the BOS token forcing to the logits.",Il,He,$p='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.ForcedBOSTokenLogitsProcessor"><code>ForcedBOSTokenLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Object</code> - The logits with BOS token forcing.',Fl,Se,wp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array</code></td><td><p>The input IDs.</p></td> </tr><tr><td>logits</td><td><code>Object</code></td><td><p>The logits.</p></td></tr></tbody>",ql,Dl,zl,Ae,Kl,Re,Wl,Ee,vp="A logits processor that forces end-of-sequence token probability to 1.",Ul,Ne,kp='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>LogitsProcessor</code>',Jl,Be,xp='<li><a href="#module_utils/generation.ForcedEOSTokenLogitsProcessor">.ForcedEOSTokenLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.ForcedEOSTokenLogitsProcessor_new"><code>new ForcedEOSTokenLogitsProcessor(max_length, forced_eos_token_id)</code></a></li> <li><a href="#module_utils/generation.ForcedEOSTokenLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a></li></ul></li>',Ql,Vl,Xl,Oe,Yl,je,Zl,Ge,yp="Create a ForcedEOSTokenLogitsProcessor.",er,Ie,Cp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>max_length</td><td><code>number</code></td><td><p>Max length of the sequence.</p></td> </tr><tr><td>forced_eos_token_id</td><td><code>number</code> | <code>Array&lt;number&gt;</code></td><td><p>The ID of the end-of-sequence token to be forced.</p></td></tr></tbody>",tr,or,ir,Fe,sr,qe,lr,De,Mp="Apply the processor to input_ids and logits.",rr,ze,Hp='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.ForcedEOSTokenLogitsProcessor"><code>ForcedEOSTokenLogitsProcessor</code></a>',nr,Ke,Sp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array.&lt;number&gt;</code></td><td><p>The input ids.</p></td> </tr><tr><td>logits</td><td><code>Tensor</code></td><td><p>The logits tensor.</p></td></tr></tbody>",dr,ar,cr,We,pr,Ue,ur,Je,Ap=`A LogitsProcessor that suppresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by
<code>begin_suppress_tokens</code> at not sampled at the begining of the generation.`,gr,Qe,Rp='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>LogitsProcessor</code>',mr,Ve,Ep='<li><a href="#module_utils/generation.SuppressTokensAtBeginLogitsProcessor">.SuppressTokensAtBeginLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.SuppressTokensAtBeginLogitsProcessor_new"><code>new SuppressTokensAtBeginLogitsProcessor(begin_suppress_tokens, begin_index)</code></a></li> <li><a href="#module_utils/generation.SuppressTokensAtBeginLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li>',fr,hr,_r,Xe,Lr,Ye,br,Ze,Np="Create a SuppressTokensAtBeginLogitsProcessor.",Tr,et,Bp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>begin_suppress_tokens</td><td><code>Array.&lt;number&gt;</code></td><td><p>The IDs of the tokens to suppress.</p></td> </tr><tr><td>begin_index</td><td><code>number</code></td><td><p>The number of tokens to generate before suppressing tokens.</p></td></tr></tbody>",Pr,$r,wr,tt,vr,ot,kr,it,Op="Apply the BOS token forcing to the logits.",xr,st,jp='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.SuppressTokensAtBeginLogitsProcessor"><code>SuppressTokensAtBeginLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Object</code> - The logits with BOS token forcing.',yr,lt,Gp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array</code></td><td><p>The input IDs.</p></td> </tr><tr><td>logits</td><td><code>Object</code></td><td><p>The logits.</p></td></tr></tbody>",Cr,Mr,Hr,rt,Sr,nt,Ar,dt,Ip="A LogitsProcessor that handles adding timestamps to generated text.",Rr,at,Fp='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>LogitsProcessor</code>',Er,ct,qp='<li><a href="#module_utils/generation.WhisperTimeStampLogitsProcessor">.WhisperTimeStampLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.WhisperTimeStampLogitsProcessor_new"><code>new WhisperTimeStampLogitsProcessor(generate_config)</code></a></li> <li><a href="#module_utils/generation.WhisperTimeStampLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Tensor</code></li></ul></li>',Nr,Br,Or,pt,jr,ut,Gr,gt,Dp="Constructs a new WhisperTimeStampLogitsProcessor.",Ir,mt,zp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>generate_config</td><td><code>Object</code></td><td><p>The config object passed to the <code>generate()</code> method of a transformer model.</p></td> </tr><tr><td>generate_config.eos_token_id</td><td><code>number</code></td><td><p>The ID of the end-of-sequence token.</p></td> </tr><tr><td>generate_config.no_timestamps_token_id</td><td><code>number</code></td><td><p>The ID of the token used to indicate that a token should not have a timestamp.</p></td> </tr><tr><td>[generate_config.forced_decoder_ids]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td><p>An array of two-element arrays representing decoder IDs that are forced to appear in the output. The second element of each array indicates whether the token is a timestamp.</p></td> </tr><tr><td>[generate_config.max_initial_timestamp_index]</td><td><code>number</code></td><td><p>The maximum index at which an initial timestamp can appear.</p></td></tr></tbody>",Fr,qr,Dr,ft,zr,ht,Kr,_t,Kp="Modify the logits to handle timestamp tokens.",Wr,Lt,Wp='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.WhisperTimeStampLogitsProcessor"><code>WhisperTimeStampLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The modified logits.',Ur,bt,Up="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array</code></td><td><p>The input sequence of tokens.</p></td> </tr><tr><td>logits</td><td><code>Tensor</code></td><td><p>The logits output by the model.</p></td></tr></tbody>",Jr,Qr,Vr,Tt,Xr,Pt,Yr,$t,Jp="A logits processor that disallows ngrams of a certain size to be repeated.",Zr,wt,Qp='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>LogitsProcessor</code>',en,vt,Vp='<li><a href="#module_utils/generation.NoRepeatNGramLogitsProcessor">.NoRepeatNGramLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.NoRepeatNGramLogitsProcessor_new"><code>new NoRepeatNGramLogitsProcessor(no_repeat_ngram_size)</code></a></li> <li><a href="#module_utils/generation.NoRepeatNGramLogitsProcessor+getNgrams"><code>.getNgrams(prevInputIds)</code></a> ⇒ <code>Map.&lt;string, Array&lt;number&gt;&gt;</code></li> <li><a href="#module_utils/generation.NoRepeatNGramLogitsProcessor+getGeneratedNgrams"><code>.getGeneratedNgrams(bannedNgrams, prevInputIds)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/generation.NoRepeatNGramLogitsProcessor+calcBannedNgramTokens"><code>.calcBannedNgramTokens(prevInputIds)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/generation.NoRepeatNGramLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li>',tn,on,sn,kt,ln,xt,rn,yt,Xp="Create a NoRepeatNGramLogitsProcessor.",nn,Ct,Yp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>no_repeat_ngram_size</td><td><code>number</code></td><td><p>The no-repeat-ngram size. All ngrams of this size can only occur once.</p></td></tr></tbody>",dn,an,cn,Mt,pn,Ht,un,St,Zp="Generate n-grams from a sequence of token ids.",gn,At,eu='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.NoRepeatNGramLogitsProcessor"><code>NoRepeatNGramLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Map.&lt;string, Array&lt;number&gt;&gt;</code> - Map of generated n-grams',mn,Rt,tu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>prevInputIds</td><td><code>Array.&lt;number&gt;</code></td><td><p>List of previous input ids</p></td></tr></tbody>",fn,hn,_n,Et,Ln,Nt,bn,Bt,ou="Generate n-grams from a sequence of token ids.",Tn,Ot,iu='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.NoRepeatNGramLogitsProcessor"><code>NoRepeatNGramLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - Map of generated n-grams',Pn,jt,su="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>bannedNgrams</td><td><code>Map.&lt;string, Array&lt;number&gt;&gt;</code></td><td><p>Map of banned n-grams</p></td> </tr><tr><td>prevInputIds</td><td><code>Array.&lt;number&gt;</code></td><td><p>List of previous input ids</p></td></tr></tbody>",$n,wn,vn,Gt,kn,It,xn,Ft,lu="Calculate banned n-gram tokens",yn,qt,ru='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.NoRepeatNGramLogitsProcessor"><code>NoRepeatNGramLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - Map of generated n-grams',Cn,Dt,nu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>prevInputIds</td><td><code>Array.&lt;number&gt;</code></td><td><p>List of previous input ids</p></td></tr></tbody>",Mn,Hn,Sn,zt,An,Kt,Rn,Wt,du="Apply the no-repeat-ngram processor to the logits.",En,Ut,au='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.NoRepeatNGramLogitsProcessor"><code>NoRepeatNGramLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Object</code> - The logits with no-repeat-ngram processing.',Nn,Jt,cu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array</code></td><td><p>The input IDs.</p></td> </tr><tr><td>logits</td><td><code>Object</code></td><td><p>The logits.</p></td></tr></tbody>",Bn,On,jn,Qt,Gn,Vt,In,Xt,pu="A logits processor that penalises repeated output tokens.",Fn,Yt,uu='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>LogitsProcessor</code>',qn,Zt,gu='<li><a href="#module_utils/generation.RepetitionPenaltyLogitsProcessor">.RepetitionPenaltyLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.RepetitionPenaltyLogitsProcessor_new"><code>new RepetitionPenaltyLogitsProcessor(penalty)</code></a></li> <li><a href="#module_utils/generation.RepetitionPenaltyLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li>',Dn,zn,Kn,eo,Wn,to,Un,oo,mu="Create a RepetitionPenaltyLogitsProcessor.",Jn,io,fu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>penalty</td><td><code>number</code></td><td><p>The penalty to apply for repeated tokens.</p></td></tr></tbody>",Qn,Vn,Xn,so,Yn,lo,Zn,ro,hu="Apply the repetition penalty to the logits.",ed,no,_u='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.RepetitionPenaltyLogitsProcessor"><code>RepetitionPenaltyLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Object</code> - The logits with repetition penalty processing.',td,ao,Lu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array</code></td><td><p>The input IDs.</p></td> </tr><tr><td>logits</td><td><code>Object</code></td><td><p>The logits.</p></td></tr></tbody>",od,id,sd,co,ld,po,rd,uo,bu="A logits processor that enforces a minimum number of tokens.",nd,go,Tu='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>LogitsProcessor</code>',dd,mo,Pu='<li><a href="#module_utils/generation.MinLengthLogitsProcessor">.MinLengthLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.MinLengthLogitsProcessor_new"><code>new MinLengthLogitsProcessor(min_length, eos_token_id)</code></a></li> <li><a href="#module_utils/generation.MinLengthLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li>',ad,cd,pd,fo,ud,ho,gd,_o,$u="Create a MinLengthLogitsProcessor.",md,Lo,wu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>min_length</td><td><code>number</code></td><td><p>The minimum length below which the score of <code>eos_token_id</code> is set to negative infinity.</p></td> </tr><tr><td>eos_token_id</td><td><code>number</code> | <code>Array&lt;number&gt;</code></td><td><p>The ID/IDs of the end-of-sequence token.</p></td></tr></tbody>",fd,hd,_d,bo,Ld,To,bd,Po,vu="Apply logit processor.",Td,$o,ku='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.MinLengthLogitsProcessor"><code>MinLengthLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Object</code> - The processed logits.',Pd,wo,xu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array</code></td><td><p>The input IDs.</p></td> </tr><tr><td>logits</td><td><code>Object</code></td><td><p>The logits.</p></td></tr></tbody>",$d,wd,vd,vo,kd,ko,xd,xo,yu="A logits processor that enforces a minimum number of new tokens.",yd,yo,Cu='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>LogitsProcessor</code>',Cd,Co,Mu='<li><a href="#module_utils/generation.MinNewTokensLengthLogitsProcessor">.MinNewTokensLengthLogitsProcessor</a> ⇐ <code>LogitsProcessor</code><ul><li><a href="#new_module_utils/generation.MinNewTokensLengthLogitsProcessor_new"><code>new MinNewTokensLengthLogitsProcessor(prompt_length_to_skip, min_new_tokens, eos_token_id)</code></a></li> <li><a href="#module_utils/generation.MinNewTokensLengthLogitsProcessor+_call"><code>._call(input_ids, logits)</code></a> ⇒ <code>Object</code></li></ul></li>',Md,Hd,Sd,Mo,Ad,Ho,Rd,So,Hu="Create a MinNewTokensLengthLogitsProcessor.",Ed,Ao,Su="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>prompt_length_to_skip</td><td><code>number</code></td><td><p>The input tokens length.</p></td> </tr><tr><td>min_new_tokens</td><td><code>number</code></td><td><p>The minimum <em>new</em> tokens length below which the score of <code>eos_token_id</code> is set to negative infinity.</p></td> </tr><tr><td>eos_token_id</td><td><code>number</code> | <code>Array&lt;number&gt;</code></td><td><p>The ID/IDs of the end-of-sequence token.</p></td></tr></tbody>",Nd,Bd,Od,Ro,jd,Eo,Gd,No,Au="Apply logit processor.",Id,Bo,Ru='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.MinNewTokensLengthLogitsProcessor"><code>MinNewTokensLengthLogitsProcessor</code></a><br/> <strong>Returns</strong>: <code>Object</code> - The processed logits.',Fd,Oo,Eu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input_ids</td><td><code>Array</code></td><td><p>The input IDs.</p></td> </tr><tr><td>logits</td><td><code>Object</code></td><td><p>The logits.</p></td></tr></tbody>",qd,Dd,zd,jo,Kd,Go,Wd,Io,Nu="Class that holds a configuration for a generation task.",Ud,Fo,Bu='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a>',Jd,Qd,Vd,qo,Xd,Do,Yd,zo,Ou="Create a GenerationConfig object",Zd,Ko,ju='<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[kwargs]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>The configuration parameters. If not set, the default values are used.</p></td> </tr><tr><td>[kwargs.max_length]</td><td><code>number</code></td><td><code>20</code></td><td><p>The maximum length the generated tokens can have. Corresponds to the length of the input prompt + <code>max_new_tokens</code>. Its effect is overridden by <code>max_new_tokens</code>, if also set.</p></td> </tr><tr><td>[kwargs.max_new_tokens]</td><td><code>number</code></td><td><code></code></td><td><p>The maximum numbers of tokens to generate, ignoring the number of tokens in the prompt.</p></td> </tr><tr><td>[kwargs.min_length]</td><td><code>number</code></td><td><code>0</code></td><td><p>The minimum length of the sequence to be generated. Corresponds to the length of the input prompt + <code>min_new_tokens</code>. Its effect is overridden by <code>min_new_tokens</code>, if also set.</p></td> </tr><tr><td>[kwargs.min_new_tokens]</td><td><code>number</code></td><td><code></code></td><td><p>The minimum numbers of tokens to generate, ignoring the number of tokens in the prompt.</p></td> </tr><tr><td>[kwargs.early_stopping]</td><td><code>boolean</code> | <code>&quot;never&quot;</code></td><td><code>false</code></td><td><p>Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:</p> <ul><li><code>true</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates;</li> <li><code>false</code>, where an heuristic is applied and the generation stops when is it very unlikely to find better candidates;</li> <li><code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical beam search algorithm).</li></ul></td> </tr><tr><td>[kwargs.max_time]</td><td><code>number</code></td><td><code></code></td><td><p>The maximum amount of time you allow the computation to run for in seconds. Generation will still finish the current pass after allocated time has been passed.</p></td> </tr><tr><td>[kwargs.do_sample]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to use sampling; use greedy decoding otherwise.</p></td> </tr><tr><td>[kwargs.num_beams]</td><td><code>number</code></td><td><code>1</code></td><td><p>Number of beams for beam search. 1 means no beam search.</p></td> </tr><tr><td>[kwargs.num_beam_groups]</td><td><code>number</code></td><td><code>1</code></td><td><p>Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams. See <a href="https://arxiv.org/pdf/1610.02424.pdf">this paper</a> for more details.</p></td> </tr><tr><td>[kwargs.penalty_alpha]</td><td><code>number</code></td><td><code></code></td><td><p>The values balance the model confidence and the degeneration penalty in contrastive search decoding.</p></td> </tr><tr><td>[kwargs.use_cache]</td><td><code>boolean</code></td><td><code>true</code></td><td><p>Whether or not the model should use the past last key/values attentions (if applicable to the model) to speed up decoding.</p></td> </tr><tr><td>[kwargs.temperature]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>The value used to modulate the next token probabilities.</p></td> </tr><tr><td>[kwargs.top_k]</td><td><code>number</code></td><td><code>50</code></td><td><p>The number of highest probability vocabulary tokens to keep for top-k-filtering.</p></td> </tr><tr><td>[kwargs.top_p]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>If set to float &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or higher are kept for generation.</p></td> </tr><tr><td>[kwargs.typical_p]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>Local typicality measures how similar the conditional probability of predicting a target token next is to the expected conditional probability of predicting a random token next, given the partial text already generated. If set to float &lt; 1, the smallest set of the most locally typical tokens with probabilities that add up to <code>typical_p</code> or higher are kept for generation. See <a href="https://arxiv.org/pdf/2202.00666.pdf">this paper</a> for more details.</p></td> </tr><tr><td>[kwargs.epsilon_cutoff]</td><td><code>number</code></td><td><code>0.0</code></td><td><p>If set to float strictly between 0 and 1, only tokens with a conditional probability greater than <code>epsilon_cutoff</code> will be sampled. In the paper, suggested values range from 3e-4 to 9e-4, depending on the size of the model. See <a href="https://arxiv.org/abs/2210.15191">Truncation Sampling as Language Model Desmoothing</a> for more details.</p></td> </tr><tr><td>[kwargs.eta_cutoff]</td><td><code>number</code></td><td><code>0.0</code></td><td><p>Eta sampling is a hybrid of locally typical sampling and epsilon sampling. If set to float strictly between 0 and 1, a token is only considered if it is greater than either <code>eta_cutoff</code> or <code>sqrt(eta_cutoff) * exp(-entropy(softmax(next_token_logits)))</code>. The latter term is intuitively the expected next token probability, scaled by <code>sqrt(eta_cutoff)</code>. In the paper, suggested values range from 3e-4 to 2e-3, depending on the size of the model. See <a href="https://arxiv.org/abs/2210.15191">Truncation Sampling as Language Model Desmoothing</a> for more details.</p></td> </tr><tr><td>[kwargs.diversity_penalty]</td><td><code>number</code></td><td><code>0.0</code></td><td><p>This value is subtracted from a beam&#39;s score if it generates a token same as any beam from other group at a particular time. Note that <code>diversity_penalty</code> is only effective if <code>group beam search</code> is enabled.</p></td> </tr><tr><td>[kwargs.repetition_penalty]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf">this paper</a> for more details.</p></td> </tr><tr><td>[kwargs.encoder_repetition_penalty]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>The paramater for encoder_repetition_penalty. An exponential penalty on sequences that are not in the original input. 1.0 means no penalty.</p></td> </tr><tr><td>[kwargs.length_penalty]</td><td><code>number</code></td><td><code>1.0</code></td><td><p>Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while <code>length_penalty</code> &lt; 0.0 encourages shorter sequences.</p></td> </tr><tr><td>[kwargs.no_repeat_ngram_size]</td><td><code>number</code></td><td><code>0</code></td><td><p>If set to int &gt; 0, all ngrams of that size can only occur once.</p></td> </tr><tr><td>[kwargs.bad_words_ids]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td><code></code></td><td><p>List of token ids that are not allowed to be generated. In order to get the token ids of the words that should not appear in the generated text, use <code>(await tokenizer(bad_words, {add_prefix_space: true, add_special_tokens: false})).input_ids</code>.</p></td> </tr><tr><td>[kwargs.force_words_ids]</td><td><code>Array&lt;Array&lt;number&gt;&gt;</code> | <code>Array&lt;Array&lt;Array&lt;number&gt;&gt;&gt;</code></td><td><code></code></td><td><p>List of token ids that must be generated. If given a <code>number[][]</code>, this is treated as a simple list of words that must be included, the opposite to <code>bad_words_ids</code>. If given <code>number[][][]</code>, this triggers a <a href="https://github.com/huggingface/transformers/issues/14081">disjunctive constraint</a>, where one can allow different forms of each word.</p></td> </tr><tr><td>[kwargs.renormalize_logits]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to renormalize the logits after applying all the logits processors or warpers (including the custom ones). It&#39;s highly recommended to set this flag to <code>true</code> as the search algorithms suppose the score logits are normalized but some logit processors or warpers break the normalization.</p></td> </tr><tr><td>[kwargs.constraints]</td><td><code>Array.&lt;Object&gt;</code></td><td><code></code></td><td><p>Custom constraints that can be added to the generation to ensure that the output will contain the use of certain tokens as defined by <code>Constraint</code> objects, in the most sensible way possible.</p></td> </tr><tr><td>[kwargs.forced_bos_token_id]</td><td><code>number</code></td><td><code></code></td><td><p>The id of the token to force as the first generated token after the <code>decoder_start_token_id</code>. Useful for multilingual models like mBART where the first generated token needs to be the target language token.</p></td> </tr><tr><td>[kwargs.forced_eos_token_id]</td><td><code>number</code> | <code>Array&lt;number&gt;</code></td><td><code></code></td><td><p>The id of the token to force as the last generated token when <code>max_length</code> is reached. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.</p></td> </tr><tr><td>[kwargs.remove_invalid_values]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to remove possible <em>nan</em> and <em>inf</em> outputs of the model to prevent the generation method to crash. Note that using <code>remove_invalid_values</code> can slow down generation.</p></td> </tr><tr><td>[kwargs.exponential_decay_length_penalty]</td><td><code>Array.&lt;number&gt;</code></td><td><code></code></td><td><p>This Tuple adds an exponentially increasing length penalty, after a certain amount of tokens have been generated. The tuple shall consist of: <code>(start_index, decay_factor)</code> where <code>start_index</code> indicates where penalty starts and <code>decay_factor</code> represents the factor of exponential decay.</p></td> </tr><tr><td>[kwargs.suppress_tokens]</td><td><code>Array.&lt;number&gt;</code></td><td><code></code></td><td><p>A list of tokens that will be suppressed at generation. The <code>SupressTokens</code> logit processor will set their log probs to <code>-inf</code> so that they are not sampled.</p></td> </tr><tr><td>[kwargs.begin_suppress_tokens]</td><td><code>Array.&lt;number&gt;</code></td><td><code></code></td><td><p>A list of tokens that will be suppressed at the beginning of the generation. The <code>SupressBeginTokens</code> logit processor will set their log probs to <code>-inf</code> so that they are not sampled.</p></td> </tr><tr><td>[kwargs.forced_decoder_ids]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td><code></code></td><td><p>A list of pairs of integers which indicates a mapping from generation indices to token indices that will be forced before sampling. For example, <code>[[1, 123]]</code> means the second generated token will always be a token of index 123.</p></td> </tr><tr><td>[kwargs.num_return_sequences]</td><td><code>number</code></td><td><code>1</code></td><td><p>The number of independently computed returned sequences for each element in the batch.</p></td> </tr><tr><td>[kwargs.output_attentions]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned tensors for more details.</p></td> </tr><tr><td>[kwargs.output_hidden_states]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for more details.</p></td> </tr><tr><td>[kwargs.output_scores]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.</p></td> </tr><tr><td>[kwargs.return_dict_in_generate]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to return a <code>ModelOutput</code> instead of a plain tuple.</p></td> </tr><tr><td>[kwargs.pad_token_id]</td><td><code>number</code></td><td><code></code></td><td><p>The id of the <em>padding</em> token.</p></td> </tr><tr><td>[kwargs.bos_token_id]</td><td><code>number</code></td><td><code></code></td><td><p>The id of the <em>beginning-of-sequence</em> token.</p></td> </tr><tr><td>[kwargs.eos_token_id]</td><td><code>number</code> | <code>Array&lt;number&gt;</code></td><td><code></code></td><td><p>The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.</p></td> </tr><tr><td>[kwargs.encoder_no_repeat_ngram_size]</td><td><code>number</code></td><td><code>0</code></td><td><p>If set to int &gt; 0, all ngrams of that size that occur in the <code>encoder_input_ids</code> cannot occur in the <code>decoder_input_ids</code>.</p></td> </tr><tr><td>[kwargs.decoder_start_token_id]</td><td><code>number</code></td><td><code></code></td><td><p>If an encoder-decoder model starts decoding with a different token than <em>bos</em>, the id of that token.</p></td> </tr><tr><td>[kwargs.generation_kwargs]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Additional generation kwargs will be forwarded to the <code>generate</code> function of the model. Kwargs that are not present in <code>generate</code>&#39;s signature will be used in the model forward pass.</p></td></tr></tbody>',ea,ta,oa,Wo,ia,Uo,sa,Jo,Gu="Sampler is a base class for all sampling methods used for text generation.",la,Qo,Iu='<strong>Kind</strong>: static class of <a href="#module_utils/generation"><code>utils/generation</code></a>',ra,Vo,Fu='<li><a href="#module_utils/generation.Sampler">.Sampler</a><ul><li><a href="#new_module_utils/generation.Sampler_new"><code>new Sampler(generation_config)</code></a></li> <li><em>instance</em><ul><li><a href="#module_utils/generation.Sampler+_call"><code>._call(logits, index)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/generation.Sampler+sample"><code>.sample(logits, index)</code></a></li> <li><a href="#module_utils/generation.Sampler+getLogits"><code>.getLogits(logits, index)</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/generation.Sampler+randomSelect"><code>.randomSelect(probabilities)</code></a> ⇒ <code>number</code></li></ul></li> <li><em>static</em><ul><li><a href="#module_utils/generation.Sampler.getSampler"><code>.getSampler(generation_config)</code></a> ⇒ <code>Sampler</code></li></ul></li></ul></li>',na,da,aa,Xo,ca,Yo,pa,Zo,qu="Creates a new Sampler object with the specified generation config.",ua,ei,Du="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>generation_config</td><td><code>GenerationConfig</code></td><td><p>The generation config.</p></td></tr></tbody>",ga,ma,fa,ti,ha,oi,_a,ii,zu="Executes the sampler, using the specified logits.",La,si,Ku='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.Sampler"><code>Sampler</code></a>',ba,li,Wu="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>logits</td><td><code>Tensor</code></td> </tr><tr><td>index</td><td><code>number</code></td></tr></tbody>",Ta,Pa,$a,ri,wa,ni,va,di,Uu="Abstract method for sampling the logits.",ka,ai,Ju='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.Sampler"><code>Sampler</code></a><br/> <strong>Throws</strong>:',xa,ci,Qu="<li><code>Error</code></li>",ya,pi,Vu="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>logits</td><td><code>Tensor</code></td> </tr><tr><td>index</td><td><code>number</code></td></tr></tbody>",Ca,Ma,Ha,ui,Sa,gi,Aa,mi,Xu="Returns the specified logits as an array, with temperature applied.",Ra,fi,Yu='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.Sampler"><code>Sampler</code></a>',Ea,hi,Zu="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>logits</td><td><code>Tensor</code></td> </tr><tr><td>index</td><td><code>number</code></td></tr></tbody>",Na,Ba,Oa,_i,ja,Li,Ga,bi,eg="Selects an item randomly based on the specified probabilities.",Ia,Ti,tg='<strong>Kind</strong>: instance method of <a href="#module_utils/generation.Sampler"><code>Sampler</code></a><br/> <strong>Returns</strong>: <code>number</code> - The index of the selected item.',Fa,Pi,og="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>probabilities</td><td><code>Array</code></td><td><p>An array of probabilities to use for selection.</p></td></tr></tbody>",qa,Da,za,$i,Ka,wi,Wa,vi,ig="Returns a Sampler object based on the specified options.",Ua,ki,sg='<strong>Kind</strong>: static method of <a href="#module_utils/generation.Sampler"><code>Sampler</code></a><br/> <strong>Returns</strong>: <code>Sampler</code> - A Sampler object.',Ja,xi,lg="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>generation_config</td><td><code>GenerationConfig</code></td><td><p>An object containing options for the sampler.</p></td></tr></tbody>",Qa,Va,Xa,yi,Ya,Ci,Za,Mi,rg="Class representing a Greedy Sampler.",ec,Hi,ng='<strong>Kind</strong>: inner class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>Sampler</code>',tc,oc,ic,Si,sc,Ai,lc,Ri,dg="Sample the maximum probability of a given logits tensor.",rc,Ei,ag='<strong>Kind</strong>: instance method of <a href="#module_utils/generation..GreedySampler"><code>GreedySampler</code></a><br/> <strong>Returns</strong>: <code>Array</code> - An array with a single tuple, containing the index of the maximum value and a meaningless score (since this is a greedy search).',nc,Ni,cg="<thead><tr><th>Param</th><th>Type</th><th>Default</th></tr></thead> <tbody><tr><td>logits</td><td><code>Tensor</code></td><td></td> </tr><tr><td>[index]</td><td><code>number</code></td><td><code>-1</code></td></tr></tbody>",dc,ac,cc,Bi,pc,Oi,uc,ji,pg="Class representing a MultinomialSampler.",gc,Gi,ug='<strong>Kind</strong>: inner class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>Sampler</code>',mc,fc,hc,Ii,_c,Fi,Lc,qi,gg="Sample from the logits.",bc,Di,mg='<strong>Kind</strong>: instance method of <a href="#module_utils/generation..MultinomialSampler"><code>MultinomialSampler</code></a>',Tc,zi,fg="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>logits</td><td><code>Tensor</code></td> </tr><tr><td>index</td><td><code>number</code></td></tr></tbody>",Pc,$c,wc,Ki,vc,Wi,kc,Ui,hg="Class representing a BeamSearchSampler.",xc,Ji,_g='<strong>Kind</strong>: inner class of <a href="#module_utils/generation"><code>utils/generation</code></a><br/> <strong>Extends</strong>: <code>Sampler</code>',yc,Cc,Mc,Qi,Hc,Vi,Sc,Xi,Lg="Sample from the logits.",Ac,Yi,bg='<strong>Kind</strong>: instance method of <a href="#module_utils/generation..BeamSearchSampler"><code>BeamSearchSampler</code></a>',Rc,Zi,Tg="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>logits</td><td><code>Tensor</code></td> </tr><tr><td>index</td><td><code>number</code></td></tr></tbody>",Ec,Nc,Bc,ts,Oc;return T=new _({props:{title:"utils/generation",local:"utilsgeneration",headingTag:"h1"}}),x=new _({props:{title:"utils/generation.LogitsProcessorList ⇐ <code> Callable </code>",local:"utilsgenerationlogitsprocessorlist--code-callable-code",headingTag:"h2"}}),S=new _({props:{title:"new LogitsProcessorList()",local:"new-logitsprocessorlist",headingTag:"h3"}}),E=new _({props:{title:"logitsProcessorList.push(item)",local:"logitsprocessorlistpushitem",headingTag:"h3"}}),G=new _({props:{title:"logitsProcessorList.extend(items)",local:"logitsprocessorlistextenditems",headingTag:"h3"}}),z=new _({props:{title:"logitsProcessorList._call(input_ids, batchedLogits)",local:"logitsprocessorlistcallinputids-batchedlogits",headingTag:"h3"}}),Q=new _({props:{title:"utils/generation.LogitsProcessor ⇐ <code> Callable </code>",local:"utilsgenerationlogitsprocessor--code-callable-code",headingTag:"h2"}}),Z=new _({props:{title:"logitsProcessor._call(input_ids, logits)",local:"logitsprocessorcallinputids-logits",headingTag:"h3"}}),le=new _({props:{title:"utils/generation.ForceTokensLogitsProcessor ⇐ <code> LogitsProcessor </code>",local:"utilsgenerationforcetokenslogitsprocessor--code-logitsprocessor-code",headingTag:"h2"}}),ce=new _({props:{title:"new ForceTokensLogitsProcessor(forced_decoder_ids)",local:"new-forcetokenslogitsprocessorforceddecoderids",headingTag:"h3"}}),me=new _({props:{title:"forceTokensLogitsProcessor._call(input_ids, logits) ⇒ <code> Tensor </code>",local:"forcetokenslogitsprocessorcallinputids-logits--code-tensor-code",headingTag:"h3"}}),be=new _({props:{title:"utils/generation.ForcedBOSTokenLogitsProcessor ⇐ <code> LogitsProcessor </code>",local:"utilsgenerationforcedbostokenlogitsprocessor--code-logitsprocessor-code",headingTag:"h2"}}),ve=new _({props:{title:"new ForcedBOSTokenLogitsProcessor(bos_token_id)",local:"new-forcedbostokenlogitsprocessorbostokenid",headingTag:"h3"}}),Ce=new _({props:{title:"forcedBOSTokenLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>",local:"forcedbostokenlogitsprocessorcallinputids-logits--code-object-code",headingTag:"h3"}}),Re=new _({props:{title:"utils/generation.ForcedEOSTokenLogitsProcessor ⇐ <code> LogitsProcessor </code>",local:"utilsgenerationforcedeostokenlogitsprocessor--code-logitsprocessor-code",headingTag:"h2"}}),je=new _({props:{title:"new ForcedEOSTokenLogitsProcessor(max_length, forced_eos_token_id)",local:"new-forcedeostokenlogitsprocessormaxlength-forcedeostokenid",headingTag:"h3"}}),qe=new _({props:{title:"forcedEOSTokenLogitsProcessor._call(input_ids, logits)",local:"forcedeostokenlogitsprocessorcallinputids-logits",headingTag:"h3"}}),Ue=new _({props:{title:"utils/generation.SuppressTokensAtBeginLogitsProcessor ⇐ <code> LogitsProcessor </code>",local:"utilsgenerationsuppresstokensatbeginlogitsprocessor--code-logitsprocessor-code",headingTag:"h2"}}),Ye=new _({props:{title:"new SuppressTokensAtBeginLogitsProcessor(begin_suppress_tokens, begin_index)",local:"new-suppresstokensatbeginlogitsprocessorbeginsuppresstokens-beginindex",headingTag:"h3"}}),ot=new _({props:{title:"suppressTokensAtBeginLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>",local:"suppresstokensatbeginlogitsprocessorcallinputids-logits--code-object-code",headingTag:"h3"}}),nt=new _({props:{title:"utils/generation.WhisperTimeStampLogitsProcessor ⇐ <code> LogitsProcessor </code>",local:"utilsgenerationwhispertimestamplogitsprocessor--code-logitsprocessor-code",headingTag:"h2"}}),ut=new _({props:{title:"new WhisperTimeStampLogitsProcessor(generate_config)",local:"new-whispertimestamplogitsprocessorgenerateconfig",headingTag:"h3"}}),ht=new _({props:{title:"whisperTimeStampLogitsProcessor._call(input_ids, logits) ⇒ <code> Tensor </code>",local:"whispertimestamplogitsprocessorcallinputids-logits--code-tensor-code",headingTag:"h3"}}),Pt=new _({props:{title:"utils/generation.NoRepeatNGramLogitsProcessor ⇐ <code> LogitsProcessor </code>",local:"utilsgenerationnorepeatngramlogitsprocessor--code-logitsprocessor-code",headingTag:"h2"}}),xt=new _({props:{title:"new NoRepeatNGramLogitsProcessor(no_repeat_ngram_size)",local:"new-norepeatngramlogitsprocessornorepeatngramsize",headingTag:"h3"}}),Ht=new _({props:{title:"noRepeatNGramLogitsProcessor.getNgrams(prevInputIds) ⇒ <code> Map. < string, Array < number > > </code>",local:"norepeatngramlogitsprocessorgetngramsprevinputids--code-map--string-array--number---code",headingTag:"h3"}}),Nt=new _({props:{title:"noRepeatNGramLogitsProcessor.getGeneratedNgrams(bannedNgrams, prevInputIds) ⇒ <code> Array. < number > </code>",local:"norepeatngramlogitsprocessorgetgeneratedngramsbannedngrams-previnputids--code-array--number--code",headingTag:"h3"}}),It=new _({props:{title:"noRepeatNGramLogitsProcessor.calcBannedNgramTokens(prevInputIds) ⇒ <code> Array. < number > </code>",local:"norepeatngramlogitsprocessorcalcbannedngramtokensprevinputids--code-array--number--code",headingTag:"h3"}}),Kt=new _({props:{title:"noRepeatNGramLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>",local:"norepeatngramlogitsprocessorcallinputids-logits--code-object-code",headingTag:"h3"}}),Vt=new _({props:{title:"utils/generation.RepetitionPenaltyLogitsProcessor ⇐ <code> LogitsProcessor </code>",local:"utilsgenerationrepetitionpenaltylogitsprocessor--code-logitsprocessor-code",headingTag:"h2"}}),to=new _({props:{title:"new RepetitionPenaltyLogitsProcessor(penalty)",local:"new-repetitionpenaltylogitsprocessorpenalty",headingTag:"h3"}}),lo=new _({props:{title:"repetitionPenaltyLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>",local:"repetitionpenaltylogitsprocessorcallinputids-logits--code-object-code",headingTag:"h3"}}),po=new _({props:{title:"utils/generation.MinLengthLogitsProcessor ⇐ <code> LogitsProcessor </code>",local:"utilsgenerationminlengthlogitsprocessor--code-logitsprocessor-code",headingTag:"h2"}}),ho=new _({props:{title:"new MinLengthLogitsProcessor(min_length, eos_token_id)",local:"new-minlengthlogitsprocessorminlength-eostokenid",headingTag:"h3"}}),To=new _({props:{title:"minLengthLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>",local:"minlengthlogitsprocessorcallinputids-logits--code-object-code",headingTag:"h3"}}),ko=new _({props:{title:"utils/generation.MinNewTokensLengthLogitsProcessor ⇐ <code> LogitsProcessor </code>",local:"utilsgenerationminnewtokenslengthlogitsprocessor--code-logitsprocessor-code",headingTag:"h2"}}),Ho=new _({props:{title:"new MinNewTokensLengthLogitsProcessor(prompt_length_to_skip, min_new_tokens, eos_token_id)",local:"new-minnewtokenslengthlogitsprocessorpromptlengthtoskip-minnewtokens-eostokenid",headingTag:"h3"}}),Eo=new _({props:{title:"minNewTokensLengthLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>",local:"minnewtokenslengthlogitsprocessorcallinputids-logits--code-object-code",headingTag:"h3"}}),Go=new _({props:{title:"utils/generation.GenerationConfig",local:"utilsgenerationgenerationconfig",headingTag:"h2"}}),Do=new _({props:{title:"new GenerationConfig([kwargs])",local:"new-generationconfigkwargs",headingTag:"h3"}}),Uo=new _({props:{title:"utils/generation.Sampler",local:"utilsgenerationsampler",headingTag:"h2"}}),Yo=new _({props:{title:"new Sampler(generation_config)",local:"new-samplergenerationconfig",headingTag:"h3"}}),oi=new _({props:{title:"sampler._call(logits, index) ⇒ <code> void </code>",local:"samplercalllogits-index--code-void-code",headingTag:"h3"}}),ni=new _({props:{title:"sampler.sample(logits, index)",local:"samplersamplelogits-index",headingTag:"h3"}}),gi=new _({props:{title:"sampler.getLogits(logits, index) ⇒ <code> Array </code>",local:"samplergetlogitslogits-index--code-array-code",headingTag:"h3"}}),Li=new _({props:{title:"sampler.randomSelect(probabilities) ⇒ <code> number </code>",local:"samplerrandomselectprobabilities--code-number-code",headingTag:"h3"}}),wi=new _({props:{title:"Sampler.getSampler(generation_config) ⇒ <code> Sampler </code>",local:"samplergetsamplergenerationconfig--code-sampler-code",headingTag:"h3"}}),Ci=new _({props:{title:"utils/generation~GreedySampler ⇐ <code> Sampler </code>",local:"utilsgenerationgreedysampler--code-sampler-code",headingTag:"h2"}}),Ai=new _({props:{title:"greedySampler.sample(logits, [index]) ⇒ <code> Array </code>",local:"greedysamplersamplelogits-index--code-array-code",headingTag:"h3"}}),Oi=new _({props:{title:"utils/generation~MultinomialSampler ⇐ <code> Sampler </code>",local:"utilsgenerationmultinomialsampler--code-sampler-code",headingTag:"h2"}}),Fi=new _({props:{title:"multinomialSampler.sample(logits, index) ⇒ <code> Array </code>",local:"multinomialsamplersamplelogits-index--code-array-code",headingTag:"h3"}}),Wi=new _({props:{title:"utils/generation~BeamSearchSampler ⇐ <code> Sampler </code>",local:"utilsgenerationbeamsearchsampler--code-sampler-code",headingTag:"h2"}}),Vi=new _({props:{title:"beamSearchSampler.sample(logits, index) ⇒ <code> Array </code>",local:"beamsearchsamplersamplelogits-index--code-array-code",headingTag:"h3"}}),{c(){L=r("meta"),os=s(),es=r("p"),is=s(),b=r("a"),ss=s(),p(T.$$.fragment),ls=s(),P=r("p"),P.textContent=Gc,rs=s(),$=r("p"),$.innerHTML=Ic,ns=s(),w=r("ul"),w.innerHTML=Fc,ds=s(),v=r("ul"),v.innerHTML=qc,as=s(),cs=r("hr"),ps=s(),k=r("a"),us=s(),p(x.$$.fragment),gs=s(),y=r("p"),y.textContent=Dc,ms=s(),C=r("p"),C.innerHTML=zc,fs=s(),M=r("ul"),M.innerHTML=Kc,hs=s(),_s=r("hr"),Ls=s(),H=r("a"),bs=s(),p(S.$$.fragment),Ts=s(),A=r("p"),A.innerHTML=Wc,Ps=s(),$s=r("hr"),ws=s(),R=r("a"),vs=s(),p(E.$$.fragment),ks=s(),N=r("p"),N.textContent=Uc,xs=s(),B=r("p"),B.innerHTML=Jc,ys=s(),O=r("table"),O.innerHTML=Qc,Cs=s(),Ms=r("hr"),Hs=s(),j=r("a"),Ss=s(),p(G.$$.fragment),As=s(),I=r("p"),I.textContent=Vc,Rs=s(),F=r("p"),F.innerHTML=Xc,Es=s(),q=r("table"),q.innerHTML=Yc,Ns=s(),Bs=r("hr"),Os=s(),D=r("a"),js=s(),p(z.$$.fragment),Gs=s(),K=r("p"),K.textContent=Zc,Is=s(),W=r("p"),W.innerHTML=ep,Fs=s(),U=r("table"),U.innerHTML=tp,qs=s(),Ds=r("hr"),zs=s(),J=r("a"),Ks=s(),p(Q.$$.fragment),Ws=s(),V=r("p"),V.textContent=op,Us=s(),X=r("p"),X.innerHTML=ip,Js=s(),Qs=r("hr"),Vs=s(),Y=r("a"),Xs=s(),p(Z.$$.fragment),Ys=s(),ee=r("p"),ee.textContent=sp,Zs=s(),te=r("p"),te.innerHTML=lp,el=s(),oe=r("ul"),oe.innerHTML=rp,tl=s(),ie=r("table"),ie.innerHTML=np,ol=s(),il=r("hr"),sl=s(),se=r("a"),ll=s(),p(le.$$.fragment),rl=s(),re=r("p"),re.textContent=dp,nl=s(),ne=r("p"),ne.innerHTML=ap,dl=s(),de=r("ul"),de.innerHTML=cp,al=s(),cl=r("hr"),pl=s(),ae=r("a"),ul=s(),p(ce.$$.fragment),gl=s(),pe=r("p"),pe.innerHTML=pp,ml=s(),ue=r("table"),ue.innerHTML=up,fl=s(),hl=r("hr"),_l=s(),ge=r("a"),Ll=s(),p(me.$$.fragment),bl=s(),fe=r("p"),fe.textContent=gp,Tl=s(),he=r("p"),he.innerHTML=mp,Pl=s(),_e=r("table"),_e.innerHTML=fp,$l=s(),wl=r("hr"),vl=s(),Le=r("a"),kl=s(),p(be.$$.fragment),xl=s(),Te=r("p"),Te.textContent=hp,yl=s(),Pe=r("p"),Pe.innerHTML=_p,Cl=s(),$e=r("ul"),$e.innerHTML=Lp,Ml=s(),Hl=r("hr"),Sl=s(),we=r("a"),Al=s(),p(ve.$$.fragment),Rl=s(),ke=r("p"),ke.textContent=bp,El=s(),xe=r("table"),xe.innerHTML=Tp,Nl=s(),Bl=r("hr"),Ol=s(),ye=r("a"),jl=s(),p(Ce.$$.fragment),Gl=s(),Me=r("p"),Me.textContent=Pp,Il=s(),He=r("p"),He.innerHTML=$p,Fl=s(),Se=r("table"),Se.innerHTML=wp,ql=s(),Dl=r("hr"),zl=s(),Ae=r("a"),Kl=s(),p(Re.$$.fragment),Wl=s(),Ee=r("p"),Ee.textContent=vp,Ul=s(),Ne=r("p"),Ne.innerHTML=kp,Jl=s(),Be=r("ul"),Be.innerHTML=xp,Ql=s(),Vl=r("hr"),Xl=s(),Oe=r("a"),Yl=s(),p(je.$$.fragment),Zl=s(),Ge=r("p"),Ge.textContent=yp,er=s(),Ie=r("table"),Ie.innerHTML=Cp,tr=s(),or=r("hr"),ir=s(),Fe=r("a"),sr=s(),p(qe.$$.fragment),lr=s(),De=r("p"),De.textContent=Mp,rr=s(),ze=r("p"),ze.innerHTML=Hp,nr=s(),Ke=r("table"),Ke.innerHTML=Sp,dr=s(),ar=r("hr"),cr=s(),We=r("a"),pr=s(),p(Ue.$$.fragment),ur=s(),Je=r("p"),Je.innerHTML=Ap,gr=s(),Qe=r("p"),Qe.innerHTML=Rp,mr=s(),Ve=r("ul"),Ve.innerHTML=Ep,fr=s(),hr=r("hr"),_r=s(),Xe=r("a"),Lr=s(),p(Ye.$$.fragment),br=s(),Ze=r("p"),Ze.textContent=Np,Tr=s(),et=r("table"),et.innerHTML=Bp,Pr=s(),$r=r("hr"),wr=s(),tt=r("a"),vr=s(),p(ot.$$.fragment),kr=s(),it=r("p"),it.textContent=Op,xr=s(),st=r("p"),st.innerHTML=jp,yr=s(),lt=r("table"),lt.innerHTML=Gp,Cr=s(),Mr=r("hr"),Hr=s(),rt=r("a"),Sr=s(),p(nt.$$.fragment),Ar=s(),dt=r("p"),dt.textContent=Ip,Rr=s(),at=r("p"),at.innerHTML=Fp,Er=s(),ct=r("ul"),ct.innerHTML=qp,Nr=s(),Br=r("hr"),Or=s(),pt=r("a"),jr=s(),p(ut.$$.fragment),Gr=s(),gt=r("p"),gt.textContent=Dp,Ir=s(),mt=r("table"),mt.innerHTML=zp,Fr=s(),qr=r("hr"),Dr=s(),ft=r("a"),zr=s(),p(ht.$$.fragment),Kr=s(),_t=r("p"),_t.textContent=Kp,Wr=s(),Lt=r("p"),Lt.innerHTML=Wp,Ur=s(),bt=r("table"),bt.innerHTML=Up,Jr=s(),Qr=r("hr"),Vr=s(),Tt=r("a"),Xr=s(),p(Pt.$$.fragment),Yr=s(),$t=r("p"),$t.textContent=Jp,Zr=s(),wt=r("p"),wt.innerHTML=Qp,en=s(),vt=r("ul"),vt.innerHTML=Vp,tn=s(),on=r("hr"),sn=s(),kt=r("a"),ln=s(),p(xt.$$.fragment),rn=s(),yt=r("p"),yt.textContent=Xp,nn=s(),Ct=r("table"),Ct.innerHTML=Yp,dn=s(),an=r("hr"),cn=s(),Mt=r("a"),pn=s(),p(Ht.$$.fragment),un=s(),St=r("p"),St.textContent=Zp,gn=s(),At=r("p"),At.innerHTML=eu,mn=s(),Rt=r("table"),Rt.innerHTML=tu,fn=s(),hn=r("hr"),_n=s(),Et=r("a"),Ln=s(),p(Nt.$$.fragment),bn=s(),Bt=r("p"),Bt.textContent=ou,Tn=s(),Ot=r("p"),Ot.innerHTML=iu,Pn=s(),jt=r("table"),jt.innerHTML=su,$n=s(),wn=r("hr"),vn=s(),Gt=r("a"),kn=s(),p(It.$$.fragment),xn=s(),Ft=r("p"),Ft.textContent=lu,yn=s(),qt=r("p"),qt.innerHTML=ru,Cn=s(),Dt=r("table"),Dt.innerHTML=nu,Mn=s(),Hn=r("hr"),Sn=s(),zt=r("a"),An=s(),p(Kt.$$.fragment),Rn=s(),Wt=r("p"),Wt.textContent=du,En=s(),Ut=r("p"),Ut.innerHTML=au,Nn=s(),Jt=r("table"),Jt.innerHTML=cu,Bn=s(),On=r("hr"),jn=s(),Qt=r("a"),Gn=s(),p(Vt.$$.fragment),In=s(),Xt=r("p"),Xt.textContent=pu,Fn=s(),Yt=r("p"),Yt.innerHTML=uu,qn=s(),Zt=r("ul"),Zt.innerHTML=gu,Dn=s(),zn=r("hr"),Kn=s(),eo=r("a"),Wn=s(),p(to.$$.fragment),Un=s(),oo=r("p"),oo.textContent=mu,Jn=s(),io=r("table"),io.innerHTML=fu,Qn=s(),Vn=r("hr"),Xn=s(),so=r("a"),Yn=s(),p(lo.$$.fragment),Zn=s(),ro=r("p"),ro.textContent=hu,ed=s(),no=r("p"),no.innerHTML=_u,td=s(),ao=r("table"),ao.innerHTML=Lu,od=s(),id=r("hr"),sd=s(),co=r("a"),ld=s(),p(po.$$.fragment),rd=s(),uo=r("p"),uo.textContent=bu,nd=s(),go=r("p"),go.innerHTML=Tu,dd=s(),mo=r("ul"),mo.innerHTML=Pu,ad=s(),cd=r("hr"),pd=s(),fo=r("a"),ud=s(),p(ho.$$.fragment),gd=s(),_o=r("p"),_o.textContent=$u,md=s(),Lo=r("table"),Lo.innerHTML=wu,fd=s(),hd=r("hr"),_d=s(),bo=r("a"),Ld=s(),p(To.$$.fragment),bd=s(),Po=r("p"),Po.textContent=vu,Td=s(),$o=r("p"),$o.innerHTML=ku,Pd=s(),wo=r("table"),wo.innerHTML=xu,$d=s(),wd=r("hr"),vd=s(),vo=r("a"),kd=s(),p(ko.$$.fragment),xd=s(),xo=r("p"),xo.textContent=yu,yd=s(),yo=r("p"),yo.innerHTML=Cu,Cd=s(),Co=r("ul"),Co.innerHTML=Mu,Md=s(),Hd=r("hr"),Sd=s(),Mo=r("a"),Ad=s(),p(Ho.$$.fragment),Rd=s(),So=r("p"),So.textContent=Hu,Ed=s(),Ao=r("table"),Ao.innerHTML=Su,Nd=s(),Bd=r("hr"),Od=s(),Ro=r("a"),jd=s(),p(Eo.$$.fragment),Gd=s(),No=r("p"),No.textContent=Au,Id=s(),Bo=r("p"),Bo.innerHTML=Ru,Fd=s(),Oo=r("table"),Oo.innerHTML=Eu,qd=s(),Dd=r("hr"),zd=s(),jo=r("a"),Kd=s(),p(Go.$$.fragment),Wd=s(),Io=r("p"),Io.textContent=Nu,Ud=s(),Fo=r("p"),Fo.innerHTML=Bu,Jd=s(),Qd=r("hr"),Vd=s(),qo=r("a"),Xd=s(),p(Do.$$.fragment),Yd=s(),zo=r("p"),zo.textContent=Ou,Zd=s(),Ko=r("table"),Ko.innerHTML=ju,ea=s(),ta=r("hr"),oa=s(),Wo=r("a"),ia=s(),p(Uo.$$.fragment),sa=s(),Jo=r("p"),Jo.textContent=Gu,la=s(),Qo=r("p"),Qo.innerHTML=Iu,ra=s(),Vo=r("ul"),Vo.innerHTML=Fu,na=s(),da=r("hr"),aa=s(),Xo=r("a"),ca=s(),p(Yo.$$.fragment),pa=s(),Zo=r("p"),Zo.textContent=qu,ua=s(),ei=r("table"),ei.innerHTML=Du,ga=s(),ma=r("hr"),fa=s(),ti=r("a"),ha=s(),p(oi.$$.fragment),_a=s(),ii=r("p"),ii.textContent=zu,La=s(),si=r("p"),si.innerHTML=Ku,ba=s(),li=r("table"),li.innerHTML=Wu,Ta=s(),Pa=r("hr"),$a=s(),ri=r("a"),wa=s(),p(ni.$$.fragment),va=s(),di=r("p"),di.textContent=Uu,ka=s(),ai=r("p"),ai.innerHTML=Ju,xa=s(),ci=r("ul"),ci.innerHTML=Qu,ya=s(),pi=r("table"),pi.innerHTML=Vu,Ca=s(),Ma=r("hr"),Ha=s(),ui=r("a"),Sa=s(),p(gi.$$.fragment),Aa=s(),mi=r("p"),mi.textContent=Xu,Ra=s(),fi=r("p"),fi.innerHTML=Yu,Ea=s(),hi=r("table"),hi.innerHTML=Zu,Na=s(),Ba=r("hr"),Oa=s(),_i=r("a"),ja=s(),p(Li.$$.fragment),Ga=s(),bi=r("p"),bi.textContent=eg,Ia=s(),Ti=r("p"),Ti.innerHTML=tg,Fa=s(),Pi=r("table"),Pi.innerHTML=og,qa=s(),Da=r("hr"),za=s(),$i=r("a"),Ka=s(),p(wi.$$.fragment),Wa=s(),vi=r("p"),vi.textContent=ig,Ua=s(),ki=r("p"),ki.innerHTML=sg,Ja=s(),xi=r("table"),xi.innerHTML=lg,Qa=s(),Va=r("hr"),Xa=s(),yi=r("a"),Ya=s(),p(Ci.$$.fragment),Za=s(),Mi=r("p"),Mi.textContent=rg,ec=s(),Hi=r("p"),Hi.innerHTML=ng,tc=s(),oc=r("hr"),ic=s(),Si=r("a"),sc=s(),p(Ai.$$.fragment),lc=s(),Ri=r("p"),Ri.textContent=dg,rc=s(),Ei=r("p"),Ei.innerHTML=ag,nc=s(),Ni=r("table"),Ni.innerHTML=cg,dc=s(),ac=r("hr"),cc=s(),Bi=r("a"),pc=s(),p(Oi.$$.fragment),uc=s(),ji=r("p"),ji.textContent=pg,gc=s(),Gi=r("p"),Gi.innerHTML=ug,mc=s(),fc=r("hr"),hc=s(),Ii=r("a"),_c=s(),p(Fi.$$.fragment),Lc=s(),qi=r("p"),qi.textContent=gg,bc=s(),Di=r("p"),Di.innerHTML=mg,Tc=s(),zi=r("table"),zi.innerHTML=fg,Pc=s(),$c=r("hr"),wc=s(),Ki=r("a"),vc=s(),p(Wi.$$.fragment),kc=s(),Ui=r("p"),Ui.textContent=hg,xc=s(),Ji=r("p"),Ji.innerHTML=_g,yc=s(),Cc=r("hr"),Mc=s(),Qi=r("a"),Hc=s(),p(Vi.$$.fragment),Sc=s(),Xi=r("p"),Xi.textContent=Lg,Ac=s(),Yi=r("p"),Yi.innerHTML=bg,Rc=s(),Zi=r("table"),Zi.innerHTML=Tg,Ec=s(),Nc=r("hr"),Bc=s(),ts=r("p"),this.h()},l(e){const o=xg("svelte-u9bgzb",document.head);L=n(o,"META",{name:!0,content:!0}),o.forEach(t),os=l(e),es=n(e,"P",{}),c(es).forEach(t),is=l(e),b=n(e,"A",{id:!0,class:!0}),c(b).forEach(t),ss=l(e),u(T.$$.fragment,e),ls=l(e),P=n(e,"P",{"data-svelte-h":!0}),d(P)!=="svelte-sqdsz9"&&(P.textContent=Gc),rs=l(e),$=n(e,"P",{"data-svelte-h":!0}),d($)!=="svelte-1dx7r99"&&($.innerHTML=Ic),ns=l(e),w=n(e,"UL",{"data-svelte-h":!0}),d(w)!=="svelte-145ffvq"&&(w.innerHTML=Fc),ds=l(e),v=n(e,"UL",{"data-svelte-h":!0}),d(v)!=="svelte-4jeimg"&&(v.innerHTML=qc),as=l(e),cs=n(e,"HR",{}),ps=l(e),k=n(e,"A",{id:!0,class:!0}),c(k).forEach(t),us=l(e),u(x.$$.fragment,e),gs=l(e),y=n(e,"P",{"data-svelte-h":!0}),d(y)!=="svelte-3s9f37"&&(y.textContent=Dc),ms=l(e),C=n(e,"P",{"data-svelte-h":!0}),d(C)!=="svelte-2xq34v"&&(C.innerHTML=zc),fs=l(e),M=n(e,"UL",{"data-svelte-h":!0}),d(M)!=="svelte-a0tc84"&&(M.innerHTML=Kc),hs=l(e),_s=n(e,"HR",{}),Ls=l(e),H=n(e,"A",{id:!0,class:!0}),c(H).forEach(t),bs=l(e),u(S.$$.fragment,e),Ts=l(e),A=n(e,"P",{"data-svelte-h":!0}),d(A)!=="svelte-7qo2qs"&&(A.innerHTML=Wc),Ps=l(e),$s=n(e,"HR",{}),ws=l(e),R=n(e,"A",{id:!0,class:!0}),c(R).forEach(t),vs=l(e),u(E.$$.fragment,e),ks=l(e),N=n(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-y2lyqr"&&(N.textContent=Uc),xs=l(e),B=n(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-ye1us2"&&(B.innerHTML=Jc),ys=l(e),O=n(e,"TABLE",{"data-svelte-h":!0}),d(O)!=="svelte-wth0th"&&(O.innerHTML=Qc),Cs=l(e),Ms=n(e,"HR",{}),Hs=l(e),j=n(e,"A",{id:!0,class:!0}),c(j).forEach(t),Ss=l(e),u(G.$$.fragment,e),As=l(e),I=n(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-19ybhdd"&&(I.textContent=Vc),Rs=l(e),F=n(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-ye1us2"&&(F.innerHTML=Xc),Es=l(e),q=n(e,"TABLE",{"data-svelte-h":!0}),d(q)!=="svelte-qfvccr"&&(q.innerHTML=Yc),Ns=l(e),Bs=n(e,"HR",{}),Os=l(e),D=n(e,"A",{id:!0,class:!0}),c(D).forEach(t),js=l(e),u(z.$$.fragment,e),Gs=l(e),K=n(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-1a5adsy"&&(K.textContent=Zc),Is=l(e),W=n(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-ye1us2"&&(W.innerHTML=ep),Fs=l(e),U=n(e,"TABLE",{"data-svelte-h":!0}),d(U)!=="svelte-afve8l"&&(U.innerHTML=tp),qs=l(e),Ds=n(e,"HR",{}),zs=l(e),J=n(e,"A",{id:!0,class:!0}),c(J).forEach(t),Ks=l(e),u(Q.$$.fragment,e),Ws=l(e),V=n(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-1skhj6b"&&(V.textContent=op),Us=l(e),X=n(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-2xq34v"&&(X.innerHTML=ip),Js=l(e),Qs=n(e,"HR",{}),Vs=l(e),Y=n(e,"A",{id:!0,class:!0}),c(Y).forEach(t),Xs=l(e),u(Z.$$.fragment,e),Ys=l(e),ee=n(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-pof7bn"&&(ee.textContent=sp),Zs=l(e),te=n(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-1v7ihvu"&&(te.innerHTML=lp),el=l(e),oe=n(e,"UL",{"data-svelte-h":!0}),d(oe)!=="svelte-1881dk3"&&(oe.innerHTML=rp),tl=l(e),ie=n(e,"TABLE",{"data-svelte-h":!0}),d(ie)!=="svelte-znwo1g"&&(ie.innerHTML=np),ol=l(e),il=n(e,"HR",{}),sl=l(e),se=n(e,"A",{id:!0,class:!0}),c(se).forEach(t),ll=l(e),u(le.$$.fragment,e),rl=l(e),re=n(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-1d43oth"&&(re.textContent=dp),nl=l(e),ne=n(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-9hwh5b"&&(ne.innerHTML=ap),dl=l(e),de=n(e,"UL",{"data-svelte-h":!0}),d(de)!=="svelte-8mww04"&&(de.innerHTML=cp),al=l(e),cl=n(e,"HR",{}),pl=l(e),ae=n(e,"A",{id:!0,class:!0}),c(ae).forEach(t),ul=l(e),u(ce.$$.fragment,e),gl=l(e),pe=n(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-1shgsb3"&&(pe.innerHTML=pp),ml=l(e),ue=n(e,"TABLE",{"data-svelte-h":!0}),d(ue)!=="svelte-wcljf3"&&(ue.innerHTML=up),fl=l(e),hl=n(e,"HR",{}),_l=l(e),ge=n(e,"A",{id:!0,class:!0}),c(ge).forEach(t),Ll=l(e),u(me.$$.fragment,e),bl=l(e),fe=n(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-pof7bn"&&(fe.textContent=gp),Tl=l(e),he=n(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-1fawzos"&&(he.innerHTML=mp),Pl=l(e),_e=n(e,"TABLE",{"data-svelte-h":!0}),d(_e)!=="svelte-znwo1g"&&(_e.innerHTML=fp),$l=l(e),wl=n(e,"HR",{}),vl=l(e),Le=n(e,"A",{id:!0,class:!0}),c(Le).forEach(t),kl=l(e),u(be.$$.fragment,e),xl=l(e),Te=n(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-o4hur7"&&(Te.textContent=hp),yl=l(e),Pe=n(e,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-9hwh5b"&&(Pe.innerHTML=_p),Cl=l(e),$e=n(e,"UL",{"data-svelte-h":!0}),d($e)!=="svelte-1p5owii"&&($e.innerHTML=Lp),Ml=l(e),Hl=n(e,"HR",{}),Sl=l(e),we=n(e,"A",{id:!0,class:!0}),c(we).forEach(t),Al=l(e),u(ve.$$.fragment,e),Rl=l(e),ke=n(e,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-1gtxb4f"&&(ke.textContent=bp),El=l(e),xe=n(e,"TABLE",{"data-svelte-h":!0}),d(xe)!=="svelte-5i4wcj"&&(xe.innerHTML=Tp),Nl=l(e),Bl=n(e,"HR",{}),Ol=l(e),ye=n(e,"A",{id:!0,class:!0}),c(ye).forEach(t),jl=l(e),u(Ce.$$.fragment,e),Gl=l(e),Me=n(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-uhajj6"&&(Me.textContent=Pp),Il=l(e),He=n(e,"P",{"data-svelte-h":!0}),d(He)!=="svelte-1ljjg3x"&&(He.innerHTML=$p),Fl=l(e),Se=n(e,"TABLE",{"data-svelte-h":!0}),d(Se)!=="svelte-aks9lu"&&(Se.innerHTML=wp),ql=l(e),Dl=n(e,"HR",{}),zl=l(e),Ae=n(e,"A",{id:!0,class:!0}),c(Ae).forEach(t),Kl=l(e),u(Re.$$.fragment,e),Wl=l(e),Ee=n(e,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-13qkt8b"&&(Ee.textContent=vp),Ul=l(e),Ne=n(e,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-9hwh5b"&&(Ne.innerHTML=kp),Jl=l(e),Be=n(e,"UL",{"data-svelte-h":!0}),d(Be)!=="svelte-1kyyz39"&&(Be.innerHTML=xp),Ql=l(e),Vl=n(e,"HR",{}),Xl=l(e),Oe=n(e,"A",{id:!0,class:!0}),c(Oe).forEach(t),Yl=l(e),u(je.$$.fragment,e),Zl=l(e),Ge=n(e,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-16ugs6s"&&(Ge.textContent=yp),er=l(e),Ie=n(e,"TABLE",{"data-svelte-h":!0}),d(Ie)!=="svelte-ahgedn"&&(Ie.innerHTML=Cp),tr=l(e),or=n(e,"HR",{}),ir=l(e),Fe=n(e,"A",{id:!0,class:!0}),c(Fe).forEach(t),sr=l(e),u(qe.$$.fragment,e),lr=l(e),De=n(e,"P",{"data-svelte-h":!0}),d(De)!=="svelte-2wlv12"&&(De.textContent=Mp),rr=l(e),ze=n(e,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-9znmwc"&&(ze.innerHTML=Hp),nr=l(e),Ke=n(e,"TABLE",{"data-svelte-h":!0}),d(Ke)!=="svelte-je9vmv"&&(Ke.innerHTML=Sp),dr=l(e),ar=n(e,"HR",{}),cr=l(e),We=n(e,"A",{id:!0,class:!0}),c(We).forEach(t),pr=l(e),u(Ue.$$.fragment,e),ur=l(e),Je=n(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-5s9hr2"&&(Je.innerHTML=Ap),gr=l(e),Qe=n(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-9hwh5b"&&(Qe.innerHTML=Rp),mr=l(e),Ve=n(e,"UL",{"data-svelte-h":!0}),d(Ve)!=="svelte-1otb2bz"&&(Ve.innerHTML=Ep),fr=l(e),hr=n(e,"HR",{}),_r=l(e),Xe=n(e,"A",{id:!0,class:!0}),c(Xe).forEach(t),Lr=l(e),u(Ye.$$.fragment,e),br=l(e),Ze=n(e,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-459vk0"&&(Ze.textContent=Np),Tr=l(e),et=n(e,"TABLE",{"data-svelte-h":!0}),d(et)!=="svelte-rmc35r"&&(et.innerHTML=Bp),Pr=l(e),$r=n(e,"HR",{}),wr=l(e),tt=n(e,"A",{id:!0,class:!0}),c(tt).forEach(t),vr=l(e),u(ot.$$.fragment,e),kr=l(e),it=n(e,"P",{"data-svelte-h":!0}),d(it)!=="svelte-uhajj6"&&(it.textContent=Op),xr=l(e),st=n(e,"P",{"data-svelte-h":!0}),d(st)!=="svelte-ysooxp"&&(st.innerHTML=jp),yr=l(e),lt=n(e,"TABLE",{"data-svelte-h":!0}),d(lt)!=="svelte-aks9lu"&&(lt.innerHTML=Gp),Cr=l(e),Mr=n(e,"HR",{}),Hr=l(e),rt=n(e,"A",{id:!0,class:!0}),c(rt).forEach(t),Sr=l(e),u(nt.$$.fragment,e),Ar=l(e),dt=n(e,"P",{"data-svelte-h":!0}),d(dt)!=="svelte-7cf1c8"&&(dt.textContent=Ip),Rr=l(e),at=n(e,"P",{"data-svelte-h":!0}),d(at)!=="svelte-9hwh5b"&&(at.innerHTML=Fp),Er=l(e),ct=n(e,"UL",{"data-svelte-h":!0}),d(ct)!=="svelte-1df9ntq"&&(ct.innerHTML=qp),Nr=l(e),Br=n(e,"HR",{}),Or=l(e),pt=n(e,"A",{id:!0,class:!0}),c(pt).forEach(t),jr=l(e),u(ut.$$.fragment,e),Gr=l(e),gt=n(e,"P",{"data-svelte-h":!0}),d(gt)!=="svelte-h97ofl"&&(gt.textContent=Dp),Ir=l(e),mt=n(e,"TABLE",{"data-svelte-h":!0}),d(mt)!=="svelte-ouguny"&&(mt.innerHTML=zp),Fr=l(e),qr=n(e,"HR",{}),Dr=l(e),ft=n(e,"A",{id:!0,class:!0}),c(ft).forEach(t),zr=l(e),u(ht.$$.fragment,e),Kr=l(e),_t=n(e,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-t6pj9i"&&(_t.textContent=Kp),Wr=l(e),Lt=n(e,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-1ba862j"&&(Lt.innerHTML=Wp),Ur=l(e),bt=n(e,"TABLE",{"data-svelte-h":!0}),d(bt)!=="svelte-1i9o6ca"&&(bt.innerHTML=Up),Jr=l(e),Qr=n(e,"HR",{}),Vr=l(e),Tt=n(e,"A",{id:!0,class:!0}),c(Tt).forEach(t),Xr=l(e),u(Pt.$$.fragment,e),Yr=l(e),$t=n(e,"P",{"data-svelte-h":!0}),d($t)!=="svelte-1nbhk1j"&&($t.textContent=Jp),Zr=l(e),wt=n(e,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-9hwh5b"&&(wt.innerHTML=Qp),en=l(e),vt=n(e,"UL",{"data-svelte-h":!0}),d(vt)!=="svelte-bbnk9b"&&(vt.innerHTML=Vp),tn=l(e),on=n(e,"HR",{}),sn=l(e),kt=n(e,"A",{id:!0,class:!0}),c(kt).forEach(t),ln=l(e),u(xt.$$.fragment,e),rn=l(e),yt=n(e,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-ztp378"&&(yt.textContent=Xp),nn=l(e),Ct=n(e,"TABLE",{"data-svelte-h":!0}),d(Ct)!=="svelte-1oeknti"&&(Ct.innerHTML=Yp),dn=l(e),an=n(e,"HR",{}),cn=l(e),Mt=n(e,"A",{id:!0,class:!0}),c(Mt).forEach(t),pn=l(e),u(Ht.$$.fragment,e),un=l(e),St=n(e,"P",{"data-svelte-h":!0}),d(St)!=="svelte-kezmb4"&&(St.textContent=Zp),gn=l(e),At=n(e,"P",{"data-svelte-h":!0}),d(At)!=="svelte-4618wm"&&(At.innerHTML=eu),mn=l(e),Rt=n(e,"TABLE",{"data-svelte-h":!0}),d(Rt)!=="svelte-7hcqif"&&(Rt.innerHTML=tu),fn=l(e),hn=n(e,"HR",{}),_n=l(e),Et=n(e,"A",{id:!0,class:!0}),c(Et).forEach(t),Ln=l(e),u(Nt.$$.fragment,e),bn=l(e),Bt=n(e,"P",{"data-svelte-h":!0}),d(Bt)!=="svelte-kezmb4"&&(Bt.textContent=ou),Tn=l(e),Ot=n(e,"P",{"data-svelte-h":!0}),d(Ot)!=="svelte-56j6v5"&&(Ot.innerHTML=iu),Pn=l(e),jt=n(e,"TABLE",{"data-svelte-h":!0}),d(jt)!=="svelte-12kqlqq"&&(jt.innerHTML=su),$n=l(e),wn=n(e,"HR",{}),vn=l(e),Gt=n(e,"A",{id:!0,class:!0}),c(Gt).forEach(t),kn=l(e),u(It.$$.fragment,e),xn=l(e),Ft=n(e,"P",{"data-svelte-h":!0}),d(Ft)!=="svelte-i6fmo8"&&(Ft.textContent=lu),yn=l(e),qt=n(e,"P",{"data-svelte-h":!0}),d(qt)!=="svelte-56j6v5"&&(qt.innerHTML=ru),Cn=l(e),Dt=n(e,"TABLE",{"data-svelte-h":!0}),d(Dt)!=="svelte-7hcqif"&&(Dt.innerHTML=nu),Mn=l(e),Hn=n(e,"HR",{}),Sn=l(e),zt=n(e,"A",{id:!0,class:!0}),c(zt).forEach(t),An=l(e),u(Kt.$$.fragment,e),Rn=l(e),Wt=n(e,"P",{"data-svelte-h":!0}),d(Wt)!=="svelte-ns64he"&&(Wt.textContent=du),En=l(e),Ut=n(e,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-eb379u"&&(Ut.innerHTML=au),Nn=l(e),Jt=n(e,"TABLE",{"data-svelte-h":!0}),d(Jt)!=="svelte-aks9lu"&&(Jt.innerHTML=cu),Bn=l(e),On=n(e,"HR",{}),jn=l(e),Qt=n(e,"A",{id:!0,class:!0}),c(Qt).forEach(t),Gn=l(e),u(Vt.$$.fragment,e),In=l(e),Xt=n(e,"P",{"data-svelte-h":!0}),d(Xt)!=="svelte-1swjk5j"&&(Xt.textContent=pu),Fn=l(e),Yt=n(e,"P",{"data-svelte-h":!0}),d(Yt)!=="svelte-9hwh5b"&&(Yt.innerHTML=uu),qn=l(e),Zt=n(e,"UL",{"data-svelte-h":!0}),d(Zt)!=="svelte-8ptdd5"&&(Zt.innerHTML=gu),Dn=l(e),zn=n(e,"HR",{}),Kn=l(e),eo=n(e,"A",{id:!0,class:!0}),c(eo).forEach(t),Wn=l(e),u(to.$$.fragment,e),Un=l(e),oo=n(e,"P",{"data-svelte-h":!0}),d(oo)!=="svelte-1miwk7z"&&(oo.textContent=mu),Jn=l(e),io=n(e,"TABLE",{"data-svelte-h":!0}),d(io)!=="svelte-qogrf9"&&(io.innerHTML=fu),Qn=l(e),Vn=n(e,"HR",{}),Xn=l(e),so=n(e,"A",{id:!0,class:!0}),c(so).forEach(t),Yn=l(e),u(lo.$$.fragment,e),Zn=l(e),ro=n(e,"P",{"data-svelte-h":!0}),d(ro)!=="svelte-ttelh1"&&(ro.textContent=hu),ed=l(e),no=n(e,"P",{"data-svelte-h":!0}),d(no)!=="svelte-1l9hzxj"&&(no.innerHTML=_u),td=l(e),ao=n(e,"TABLE",{"data-svelte-h":!0}),d(ao)!=="svelte-aks9lu"&&(ao.innerHTML=Lu),od=l(e),id=n(e,"HR",{}),sd=l(e),co=n(e,"A",{id:!0,class:!0}),c(co).forEach(t),ld=l(e),u(po.$$.fragment,e),rd=l(e),uo=n(e,"P",{"data-svelte-h":!0}),d(uo)!=="svelte-9c4wc0"&&(uo.textContent=bu),nd=l(e),go=n(e,"P",{"data-svelte-h":!0}),d(go)!=="svelte-9hwh5b"&&(go.innerHTML=Tu),dd=l(e),mo=n(e,"UL",{"data-svelte-h":!0}),d(mo)!=="svelte-5gysvm"&&(mo.innerHTML=Pu),ad=l(e),cd=n(e,"HR",{}),pd=l(e),fo=n(e,"A",{id:!0,class:!0}),c(fo).forEach(t),ud=l(e),u(ho.$$.fragment,e),gd=l(e),_o=n(e,"P",{"data-svelte-h":!0}),d(_o)!=="svelte-1m5mw53"&&(_o.textContent=$u),md=l(e),Lo=n(e,"TABLE",{"data-svelte-h":!0}),d(Lo)!=="svelte-1glhq7b"&&(Lo.innerHTML=wu),fd=l(e),hd=n(e,"HR",{}),_d=l(e),bo=n(e,"A",{id:!0,class:!0}),c(bo).forEach(t),Ld=l(e),u(To.$$.fragment,e),bd=l(e),Po=n(e,"P",{"data-svelte-h":!0}),d(Po)!=="svelte-uo9cbt"&&(Po.textContent=vu),Td=l(e),$o=n(e,"P",{"data-svelte-h":!0}),d($o)!=="svelte-r6npgs"&&($o.innerHTML=ku),Pd=l(e),wo=n(e,"TABLE",{"data-svelte-h":!0}),d(wo)!=="svelte-aks9lu"&&(wo.innerHTML=xu),$d=l(e),wd=n(e,"HR",{}),vd=l(e),vo=n(e,"A",{id:!0,class:!0}),c(vo).forEach(t),kd=l(e),u(ko.$$.fragment,e),xd=l(e),xo=n(e,"P",{"data-svelte-h":!0}),d(xo)!=="svelte-ozjzty"&&(xo.textContent=yu),yd=l(e),yo=n(e,"P",{"data-svelte-h":!0}),d(yo)!=="svelte-9hwh5b"&&(yo.innerHTML=Cu),Cd=l(e),Co=n(e,"UL",{"data-svelte-h":!0}),d(Co)!=="svelte-1ry7094"&&(Co.innerHTML=Mu),Md=l(e),Hd=n(e,"HR",{}),Sd=l(e),Mo=n(e,"A",{id:!0,class:!0}),c(Mo).forEach(t),Ad=l(e),u(Ho.$$.fragment,e),Rd=l(e),So=n(e,"P",{"data-svelte-h":!0}),d(So)!=="svelte-6z34lb"&&(So.textContent=Hu),Ed=l(e),Ao=n(e,"TABLE",{"data-svelte-h":!0}),d(Ao)!=="svelte-1hv5g9s"&&(Ao.innerHTML=Su),Nd=l(e),Bd=n(e,"HR",{}),Od=l(e),Ro=n(e,"A",{id:!0,class:!0}),c(Ro).forEach(t),jd=l(e),u(Eo.$$.fragment,e),Gd=l(e),No=n(e,"P",{"data-svelte-h":!0}),d(No)!=="svelte-uo9cbt"&&(No.textContent=Au),Id=l(e),Bo=n(e,"P",{"data-svelte-h":!0}),d(Bo)!=="svelte-1o7er1i"&&(Bo.innerHTML=Ru),Fd=l(e),Oo=n(e,"TABLE",{"data-svelte-h":!0}),d(Oo)!=="svelte-aks9lu"&&(Oo.innerHTML=Eu),qd=l(e),Dd=n(e,"HR",{}),zd=l(e),jo=n(e,"A",{id:!0,class:!0}),c(jo).forEach(t),Kd=l(e),u(Go.$$.fragment,e),Wd=l(e),Io=n(e,"P",{"data-svelte-h":!0}),d(Io)!=="svelte-setd0x"&&(Io.textContent=Nu),Ud=l(e),Fo=n(e,"P",{"data-svelte-h":!0}),d(Fo)!=="svelte-8k9dr4"&&(Fo.innerHTML=Bu),Jd=l(e),Qd=n(e,"HR",{}),Vd=l(e),qo=n(e,"A",{id:!0,class:!0}),c(qo).forEach(t),Xd=l(e),u(Do.$$.fragment,e),Yd=l(e),zo=n(e,"P",{"data-svelte-h":!0}),d(zo)!=="svelte-fn6kkw"&&(zo.textContent=Ou),Zd=l(e),Ko=n(e,"TABLE",{"data-svelte-h":!0}),d(Ko)!=="svelte-2bvx5l"&&(Ko.innerHTML=ju),ea=l(e),ta=n(e,"HR",{}),oa=l(e),Wo=n(e,"A",{id:!0,class:!0}),c(Wo).forEach(t),ia=l(e),u(Uo.$$.fragment,e),sa=l(e),Jo=n(e,"P",{"data-svelte-h":!0}),d(Jo)!=="svelte-p0jtpm"&&(Jo.textContent=Gu),la=l(e),Qo=n(e,"P",{"data-svelte-h":!0}),d(Qo)!=="svelte-8k9dr4"&&(Qo.innerHTML=Iu),ra=l(e),Vo=n(e,"UL",{"data-svelte-h":!0}),d(Vo)!=="svelte-ait4x5"&&(Vo.innerHTML=Fu),na=l(e),da=n(e,"HR",{}),aa=l(e),Xo=n(e,"A",{id:!0,class:!0}),c(Xo).forEach(t),ca=l(e),u(Yo.$$.fragment,e),pa=l(e),Zo=n(e,"P",{"data-svelte-h":!0}),d(Zo)!=="svelte-cx2gtq"&&(Zo.textContent=qu),ua=l(e),ei=n(e,"TABLE",{"data-svelte-h":!0}),d(ei)!=="svelte-i95exv"&&(ei.innerHTML=Du),ga=l(e),ma=n(e,"HR",{}),fa=l(e),ti=n(e,"A",{id:!0,class:!0}),c(ti).forEach(t),ha=l(e),u(oi.$$.fragment,e),_a=l(e),ii=n(e,"P",{"data-svelte-h":!0}),d(ii)!=="svelte-18hhszu"&&(ii.textContent=zu),La=l(e),si=n(e,"P",{"data-svelte-h":!0}),d(si)!=="svelte-1hkhr2u"&&(si.innerHTML=Ku),ba=l(e),li=n(e,"TABLE",{"data-svelte-h":!0}),d(li)!=="svelte-1ks6oyq"&&(li.innerHTML=Wu),Ta=l(e),Pa=n(e,"HR",{}),$a=l(e),ri=n(e,"A",{id:!0,class:!0}),c(ri).forEach(t),wa=l(e),u(ni.$$.fragment,e),va=l(e),di=n(e,"P",{"data-svelte-h":!0}),d(di)!=="svelte-mhsbvo"&&(di.textContent=Uu),ka=l(e),ai=n(e,"P",{"data-svelte-h":!0}),d(ai)!=="svelte-mok1bi"&&(ai.innerHTML=Ju),xa=l(e),ci=n(e,"UL",{"data-svelte-h":!0}),d(ci)!=="svelte-1ijvx2"&&(ci.innerHTML=Qu),ya=l(e),pi=n(e,"TABLE",{"data-svelte-h":!0}),d(pi)!=="svelte-1ks6oyq"&&(pi.innerHTML=Vu),Ca=l(e),Ma=n(e,"HR",{}),Ha=l(e),ui=n(e,"A",{id:!0,class:!0}),c(ui).forEach(t),Sa=l(e),u(gi.$$.fragment,e),Aa=l(e),mi=n(e,"P",{"data-svelte-h":!0}),d(mi)!=="svelte-1tthoub"&&(mi.textContent=Xu),Ra=l(e),fi=n(e,"P",{"data-svelte-h":!0}),d(fi)!=="svelte-1hkhr2u"&&(fi.innerHTML=Yu),Ea=l(e),hi=n(e,"TABLE",{"data-svelte-h":!0}),d(hi)!=="svelte-1ks6oyq"&&(hi.innerHTML=Zu),Na=l(e),Ba=n(e,"HR",{}),Oa=l(e),_i=n(e,"A",{id:!0,class:!0}),c(_i).forEach(t),ja=l(e),u(Li.$$.fragment,e),Ga=l(e),bi=n(e,"P",{"data-svelte-h":!0}),d(bi)!=="svelte-yywnzb"&&(bi.textContent=eg),Ia=l(e),Ti=n(e,"P",{"data-svelte-h":!0}),d(Ti)!=="svelte-1o7ozs"&&(Ti.innerHTML=tg),Fa=l(e),Pi=n(e,"TABLE",{"data-svelte-h":!0}),d(Pi)!=="svelte-415bxe"&&(Pi.innerHTML=og),qa=l(e),Da=n(e,"HR",{}),za=l(e),$i=n(e,"A",{id:!0,class:!0}),c($i).forEach(t),Ka=l(e),u(wi.$$.fragment,e),Wa=l(e),vi=n(e,"P",{"data-svelte-h":!0}),d(vi)!=="svelte-wl8u0w"&&(vi.textContent=ig),Ua=l(e),ki=n(e,"P",{"data-svelte-h":!0}),d(ki)!=="svelte-18j5rpb"&&(ki.innerHTML=sg),Ja=l(e),xi=n(e,"TABLE",{"data-svelte-h":!0}),d(xi)!=="svelte-1vneufm"&&(xi.innerHTML=lg),Qa=l(e),Va=n(e,"HR",{}),Xa=l(e),yi=n(e,"A",{id:!0,class:!0}),c(yi).forEach(t),Ya=l(e),u(Ci.$$.fragment,e),Za=l(e),Mi=n(e,"P",{"data-svelte-h":!0}),d(Mi)!=="svelte-1pvj197"&&(Mi.textContent=rg),ec=l(e),Hi=n(e,"P",{"data-svelte-h":!0}),d(Hi)!=="svelte-1cm4lld"&&(Hi.innerHTML=ng),tc=l(e),oc=n(e,"HR",{}),ic=l(e),Si=n(e,"A",{id:!0,class:!0}),c(Si).forEach(t),sc=l(e),u(Ai.$$.fragment,e),lc=l(e),Ri=n(e,"P",{"data-svelte-h":!0}),d(Ri)!=="svelte-1acvd9s"&&(Ri.textContent=dg),rc=l(e),Ei=n(e,"P",{"data-svelte-h":!0}),d(Ei)!=="svelte-dut2ci"&&(Ei.innerHTML=ag),nc=l(e),Ni=n(e,"TABLE",{"data-svelte-h":!0}),d(Ni)!=="svelte-tzng1p"&&(Ni.innerHTML=cg),dc=l(e),ac=n(e,"HR",{}),cc=l(e),Bi=n(e,"A",{id:!0,class:!0}),c(Bi).forEach(t),pc=l(e),u(Oi.$$.fragment,e),uc=l(e),ji=n(e,"P",{"data-svelte-h":!0}),d(ji)!=="svelte-2u15u0"&&(ji.textContent=pg),gc=l(e),Gi=n(e,"P",{"data-svelte-h":!0}),d(Gi)!=="svelte-1cm4lld"&&(Gi.innerHTML=ug),mc=l(e),fc=n(e,"HR",{}),hc=l(e),Ii=n(e,"A",{id:!0,class:!0}),c(Ii).forEach(t),_c=l(e),u(Fi.$$.fragment,e),Lc=l(e),qi=n(e,"P",{"data-svelte-h":!0}),d(qi)!=="svelte-1uart2f"&&(qi.textContent=gg),bc=l(e),Di=n(e,"P",{"data-svelte-h":!0}),d(Di)!=="svelte-6rm4k"&&(Di.innerHTML=mg),Tc=l(e),zi=n(e,"TABLE",{"data-svelte-h":!0}),d(zi)!=="svelte-1ks6oyq"&&(zi.innerHTML=fg),Pc=l(e),$c=n(e,"HR",{}),wc=l(e),Ki=n(e,"A",{id:!0,class:!0}),c(Ki).forEach(t),vc=l(e),u(Wi.$$.fragment,e),kc=l(e),Ui=n(e,"P",{"data-svelte-h":!0}),d(Ui)!=="svelte-tcl9v8"&&(Ui.textContent=hg),xc=l(e),Ji=n(e,"P",{"data-svelte-h":!0}),d(Ji)!=="svelte-1cm4lld"&&(Ji.innerHTML=_g),yc=l(e),Cc=n(e,"HR",{}),Mc=l(e),Qi=n(e,"A",{id:!0,class:!0}),c(Qi).forEach(t),Hc=l(e),u(Vi.$$.fragment,e),Sc=l(e),Xi=n(e,"P",{"data-svelte-h":!0}),d(Xi)!=="svelte-1uart2f"&&(Xi.textContent=Lg),Ac=l(e),Yi=n(e,"P",{"data-svelte-h":!0}),d(Yi)!=="svelte-18emm88"&&(Yi.innerHTML=bg),Rc=l(e),Zi=n(e,"TABLE",{"data-svelte-h":!0}),d(Zi)!=="svelte-1ks6oyq"&&(Zi.innerHTML=Tg),Ec=l(e),Nc=n(e,"HR",{}),Bc=l(e),ts=n(e,"P",{}),c(ts).forEach(t),this.h()},h(){a(L,"name","hf:doc:metadata"),a(L,"content",Mg),a(b,"id","module_utils/generation"),a(b,"class","group"),a(k,"id","module_utils/generation.LogitsProcessorList"),a(k,"class","group"),a(H,"id","new_module_utils/generation.LogitsProcessorList_new"),a(H,"class","group"),a(R,"id","module_utils/generation.LogitsProcessorList+push"),a(R,"class","group"),a(j,"id","module_utils/generation.LogitsProcessorList+extend"),a(j,"class","group"),a(D,"id","module_utils/generation.LogitsProcessorList+_call"),a(D,"class","group"),a(J,"id","module_utils/generation.LogitsProcessor"),a(J,"class","group"),a(Y,"id","module_utils/generation.LogitsProcessor+_call"),a(Y,"class","group"),a(se,"id","module_utils/generation.ForceTokensLogitsProcessor"),a(se,"class","group"),a(ae,"id","new_module_utils/generation.ForceTokensLogitsProcessor_new"),a(ae,"class","group"),a(ge,"id","module_utils/generation.ForceTokensLogitsProcessor+_call"),a(ge,"class","group"),a(Le,"id","module_utils/generation.ForcedBOSTokenLogitsProcessor"),a(Le,"class","group"),a(we,"id","new_module_utils/generation.ForcedBOSTokenLogitsProcessor_new"),a(we,"class","group"),a(ye,"id","module_utils/generation.ForcedBOSTokenLogitsProcessor+_call"),a(ye,"class","group"),a(Ae,"id","module_utils/generation.ForcedEOSTokenLogitsProcessor"),a(Ae,"class","group"),a(Oe,"id","new_module_utils/generation.ForcedEOSTokenLogitsProcessor_new"),a(Oe,"class","group"),a(Fe,"id","module_utils/generation.ForcedEOSTokenLogitsProcessor+_call"),a(Fe,"class","group"),a(We,"id","module_utils/generation.SuppressTokensAtBeginLogitsProcessor"),a(We,"class","group"),a(Xe,"id","new_module_utils/generation.SuppressTokensAtBeginLogitsProcessor_new"),a(Xe,"class","group"),a(tt,"id","module_utils/generation.SuppressTokensAtBeginLogitsProcessor+_call"),a(tt,"class","group"),a(rt,"id","module_utils/generation.WhisperTimeStampLogitsProcessor"),a(rt,"class","group"),a(pt,"id","new_module_utils/generation.WhisperTimeStampLogitsProcessor_new"),a(pt,"class","group"),a(ft,"id","module_utils/generation.WhisperTimeStampLogitsProcessor+_call"),a(ft,"class","group"),a(Tt,"id","module_utils/generation.NoRepeatNGramLogitsProcessor"),a(Tt,"class","group"),a(kt,"id","new_module_utils/generation.NoRepeatNGramLogitsProcessor_new"),a(kt,"class","group"),a(Mt,"id","module_utils/generation.NoRepeatNGramLogitsProcessor+getNgrams"),a(Mt,"class","group"),a(Et,"id","module_utils/generation.NoRepeatNGramLogitsProcessor+getGeneratedNgrams"),a(Et,"class","group"),a(Gt,"id","module_utils/generation.NoRepeatNGramLogitsProcessor+calcBannedNgramTokens"),a(Gt,"class","group"),a(zt,"id","module_utils/generation.NoRepeatNGramLogitsProcessor+_call"),a(zt,"class","group"),a(Qt,"id","module_utils/generation.RepetitionPenaltyLogitsProcessor"),a(Qt,"class","group"),a(eo,"id","new_module_utils/generation.RepetitionPenaltyLogitsProcessor_new"),a(eo,"class","group"),a(so,"id","module_utils/generation.RepetitionPenaltyLogitsProcessor+_call"),a(so,"class","group"),a(co,"id","module_utils/generation.MinLengthLogitsProcessor"),a(co,"class","group"),a(fo,"id","new_module_utils/generation.MinLengthLogitsProcessor_new"),a(fo,"class","group"),a(bo,"id","module_utils/generation.MinLengthLogitsProcessor+_call"),a(bo,"class","group"),a(vo,"id","module_utils/generation.MinNewTokensLengthLogitsProcessor"),a(vo,"class","group"),a(Mo,"id","new_module_utils/generation.MinNewTokensLengthLogitsProcessor_new"),a(Mo,"class","group"),a(Ro,"id","module_utils/generation.MinNewTokensLengthLogitsProcessor+_call"),a(Ro,"class","group"),a(jo,"id","module_utils/generation.GenerationConfig"),a(jo,"class","group"),a(qo,"id","new_module_utils/generation.GenerationConfig_new"),a(qo,"class","group"),a(Wo,"id","module_utils/generation.Sampler"),a(Wo,"class","group"),a(Xo,"id","new_module_utils/generation.Sampler_new"),a(Xo,"class","group"),a(ti,"id","module_utils/generation.Sampler+_call"),a(ti,"class","group"),a(ri,"id","module_utils/generation.Sampler+sample"),a(ri,"class","group"),a(ui,"id","module_utils/generation.Sampler+getLogits"),a(ui,"class","group"),a(_i,"id","module_utils/generation.Sampler+randomSelect"),a(_i,"class","group"),a($i,"id","module_utils/generation.Sampler.getSampler"),a($i,"class","group"),a(yi,"id","module_utils/generation..GreedySampler"),a(yi,"class","group"),a(Si,"id","module_utils/generation..GreedySampler+sample"),a(Si,"class","group"),a(Bi,"id","module_utils/generation..MultinomialSampler"),a(Bi,"class","group"),a(Ii,"id","module_utils/generation..MultinomialSampler+sample"),a(Ii,"class","group"),a(Ki,"id","module_utils/generation..BeamSearchSampler"),a(Ki,"class","group"),a(Qi,"id","module_utils/generation..BeamSearchSampler+sample"),a(Qi,"class","group")},m(e,o){yg(document.head,L),i(e,os,o),i(e,es,o),i(e,is,o),i(e,b,o),i(e,ss,o),g(T,e,o),i(e,ls,o),i(e,P,o),i(e,rs,o),i(e,$,o),i(e,ns,o),i(e,w,o),i(e,ds,o),i(e,v,o),i(e,as,o),i(e,cs,o),i(e,ps,o),i(e,k,o),i(e,us,o),g(x,e,o),i(e,gs,o),i(e,y,o),i(e,ms,o),i(e,C,o),i(e,fs,o),i(e,M,o),i(e,hs,o),i(e,_s,o),i(e,Ls,o),i(e,H,o),i(e,bs,o),g(S,e,o),i(e,Ts,o),i(e,A,o),i(e,Ps,o),i(e,$s,o),i(e,ws,o),i(e,R,o),i(e,vs,o),g(E,e,o),i(e,ks,o),i(e,N,o),i(e,xs,o),i(e,B,o),i(e,ys,o),i(e,O,o),i(e,Cs,o),i(e,Ms,o),i(e,Hs,o),i(e,j,o),i(e,Ss,o),g(G,e,o),i(e,As,o),i(e,I,o),i(e,Rs,o),i(e,F,o),i(e,Es,o),i(e,q,o),i(e,Ns,o),i(e,Bs,o),i(e,Os,o),i(e,D,o),i(e,js,o),g(z,e,o),i(e,Gs,o),i(e,K,o),i(e,Is,o),i(e,W,o),i(e,Fs,o),i(e,U,o),i(e,qs,o),i(e,Ds,o),i(e,zs,o),i(e,J,o),i(e,Ks,o),g(Q,e,o),i(e,Ws,o),i(e,V,o),i(e,Us,o),i(e,X,o),i(e,Js,o),i(e,Qs,o),i(e,Vs,o),i(e,Y,o),i(e,Xs,o),g(Z,e,o),i(e,Ys,o),i(e,ee,o),i(e,Zs,o),i(e,te,o),i(e,el,o),i(e,oe,o),i(e,tl,o),i(e,ie,o),i(e,ol,o),i(e,il,o),i(e,sl,o),i(e,se,o),i(e,ll,o),g(le,e,o),i(e,rl,o),i(e,re,o),i(e,nl,o),i(e,ne,o),i(e,dl,o),i(e,de,o),i(e,al,o),i(e,cl,o),i(e,pl,o),i(e,ae,o),i(e,ul,o),g(ce,e,o),i(e,gl,o),i(e,pe,o),i(e,ml,o),i(e,ue,o),i(e,fl,o),i(e,hl,o),i(e,_l,o),i(e,ge,o),i(e,Ll,o),g(me,e,o),i(e,bl,o),i(e,fe,o),i(e,Tl,o),i(e,he,o),i(e,Pl,o),i(e,_e,o),i(e,$l,o),i(e,wl,o),i(e,vl,o),i(e,Le,o),i(e,kl,o),g(be,e,o),i(e,xl,o),i(e,Te,o),i(e,yl,o),i(e,Pe,o),i(e,Cl,o),i(e,$e,o),i(e,Ml,o),i(e,Hl,o),i(e,Sl,o),i(e,we,o),i(e,Al,o),g(ve,e,o),i(e,Rl,o),i(e,ke,o),i(e,El,o),i(e,xe,o),i(e,Nl,o),i(e,Bl,o),i(e,Ol,o),i(e,ye,o),i(e,jl,o),g(Ce,e,o),i(e,Gl,o),i(e,Me,o),i(e,Il,o),i(e,He,o),i(e,Fl,o),i(e,Se,o),i(e,ql,o),i(e,Dl,o),i(e,zl,o),i(e,Ae,o),i(e,Kl,o),g(Re,e,o),i(e,Wl,o),i(e,Ee,o),i(e,Ul,o),i(e,Ne,o),i(e,Jl,o),i(e,Be,o),i(e,Ql,o),i(e,Vl,o),i(e,Xl,o),i(e,Oe,o),i(e,Yl,o),g(je,e,o),i(e,Zl,o),i(e,Ge,o),i(e,er,o),i(e,Ie,o),i(e,tr,o),i(e,or,o),i(e,ir,o),i(e,Fe,o),i(e,sr,o),g(qe,e,o),i(e,lr,o),i(e,De,o),i(e,rr,o),i(e,ze,o),i(e,nr,o),i(e,Ke,o),i(e,dr,o),i(e,ar,o),i(e,cr,o),i(e,We,o),i(e,pr,o),g(Ue,e,o),i(e,ur,o),i(e,Je,o),i(e,gr,o),i(e,Qe,o),i(e,mr,o),i(e,Ve,o),i(e,fr,o),i(e,hr,o),i(e,_r,o),i(e,Xe,o),i(e,Lr,o),g(Ye,e,o),i(e,br,o),i(e,Ze,o),i(e,Tr,o),i(e,et,o),i(e,Pr,o),i(e,$r,o),i(e,wr,o),i(e,tt,o),i(e,vr,o),g(ot,e,o),i(e,kr,o),i(e,it,o),i(e,xr,o),i(e,st,o),i(e,yr,o),i(e,lt,o),i(e,Cr,o),i(e,Mr,o),i(e,Hr,o),i(e,rt,o),i(e,Sr,o),g(nt,e,o),i(e,Ar,o),i(e,dt,o),i(e,Rr,o),i(e,at,o),i(e,Er,o),i(e,ct,o),i(e,Nr,o),i(e,Br,o),i(e,Or,o),i(e,pt,o),i(e,jr,o),g(ut,e,o),i(e,Gr,o),i(e,gt,o),i(e,Ir,o),i(e,mt,o),i(e,Fr,o),i(e,qr,o),i(e,Dr,o),i(e,ft,o),i(e,zr,o),g(ht,e,o),i(e,Kr,o),i(e,_t,o),i(e,Wr,o),i(e,Lt,o),i(e,Ur,o),i(e,bt,o),i(e,Jr,o),i(e,Qr,o),i(e,Vr,o),i(e,Tt,o),i(e,Xr,o),g(Pt,e,o),i(e,Yr,o),i(e,$t,o),i(e,Zr,o),i(e,wt,o),i(e,en,o),i(e,vt,o),i(e,tn,o),i(e,on,o),i(e,sn,o),i(e,kt,o),i(e,ln,o),g(xt,e,o),i(e,rn,o),i(e,yt,o),i(e,nn,o),i(e,Ct,o),i(e,dn,o),i(e,an,o),i(e,cn,o),i(e,Mt,o),i(e,pn,o),g(Ht,e,o),i(e,un,o),i(e,St,o),i(e,gn,o),i(e,At,o),i(e,mn,o),i(e,Rt,o),i(e,fn,o),i(e,hn,o),i(e,_n,o),i(e,Et,o),i(e,Ln,o),g(Nt,e,o),i(e,bn,o),i(e,Bt,o),i(e,Tn,o),i(e,Ot,o),i(e,Pn,o),i(e,jt,o),i(e,$n,o),i(e,wn,o),i(e,vn,o),i(e,Gt,o),i(e,kn,o),g(It,e,o),i(e,xn,o),i(e,Ft,o),i(e,yn,o),i(e,qt,o),i(e,Cn,o),i(e,Dt,o),i(e,Mn,o),i(e,Hn,o),i(e,Sn,o),i(e,zt,o),i(e,An,o),g(Kt,e,o),i(e,Rn,o),i(e,Wt,o),i(e,En,o),i(e,Ut,o),i(e,Nn,o),i(e,Jt,o),i(e,Bn,o),i(e,On,o),i(e,jn,o),i(e,Qt,o),i(e,Gn,o),g(Vt,e,o),i(e,In,o),i(e,Xt,o),i(e,Fn,o),i(e,Yt,o),i(e,qn,o),i(e,Zt,o),i(e,Dn,o),i(e,zn,o),i(e,Kn,o),i(e,eo,o),i(e,Wn,o),g(to,e,o),i(e,Un,o),i(e,oo,o),i(e,Jn,o),i(e,io,o),i(e,Qn,o),i(e,Vn,o),i(e,Xn,o),i(e,so,o),i(e,Yn,o),g(lo,e,o),i(e,Zn,o),i(e,ro,o),i(e,ed,o),i(e,no,o),i(e,td,o),i(e,ao,o),i(e,od,o),i(e,id,o),i(e,sd,o),i(e,co,o),i(e,ld,o),g(po,e,o),i(e,rd,o),i(e,uo,o),i(e,nd,o),i(e,go,o),i(e,dd,o),i(e,mo,o),i(e,ad,o),i(e,cd,o),i(e,pd,o),i(e,fo,o),i(e,ud,o),g(ho,e,o),i(e,gd,o),i(e,_o,o),i(e,md,o),i(e,Lo,o),i(e,fd,o),i(e,hd,o),i(e,_d,o),i(e,bo,o),i(e,Ld,o),g(To,e,o),i(e,bd,o),i(e,Po,o),i(e,Td,o),i(e,$o,o),i(e,Pd,o),i(e,wo,o),i(e,$d,o),i(e,wd,o),i(e,vd,o),i(e,vo,o),i(e,kd,o),g(ko,e,o),i(e,xd,o),i(e,xo,o),i(e,yd,o),i(e,yo,o),i(e,Cd,o),i(e,Co,o),i(e,Md,o),i(e,Hd,o),i(e,Sd,o),i(e,Mo,o),i(e,Ad,o),g(Ho,e,o),i(e,Rd,o),i(e,So,o),i(e,Ed,o),i(e,Ao,o),i(e,Nd,o),i(e,Bd,o),i(e,Od,o),i(e,Ro,o),i(e,jd,o),g(Eo,e,o),i(e,Gd,o),i(e,No,o),i(e,Id,o),i(e,Bo,o),i(e,Fd,o),i(e,Oo,o),i(e,qd,o),i(e,Dd,o),i(e,zd,o),i(e,jo,o),i(e,Kd,o),g(Go,e,o),i(e,Wd,o),i(e,Io,o),i(e,Ud,o),i(e,Fo,o),i(e,Jd,o),i(e,Qd,o),i(e,Vd,o),i(e,qo,o),i(e,Xd,o),g(Do,e,o),i(e,Yd,o),i(e,zo,o),i(e,Zd,o),i(e,Ko,o),i(e,ea,o),i(e,ta,o),i(e,oa,o),i(e,Wo,o),i(e,ia,o),g(Uo,e,o),i(e,sa,o),i(e,Jo,o),i(e,la,o),i(e,Qo,o),i(e,ra,o),i(e,Vo,o),i(e,na,o),i(e,da,o),i(e,aa,o),i(e,Xo,o),i(e,ca,o),g(Yo,e,o),i(e,pa,o),i(e,Zo,o),i(e,ua,o),i(e,ei,o),i(e,ga,o),i(e,ma,o),i(e,fa,o),i(e,ti,o),i(e,ha,o),g(oi,e,o),i(e,_a,o),i(e,ii,o),i(e,La,o),i(e,si,o),i(e,ba,o),i(e,li,o),i(e,Ta,o),i(e,Pa,o),i(e,$a,o),i(e,ri,o),i(e,wa,o),g(ni,e,o),i(e,va,o),i(e,di,o),i(e,ka,o),i(e,ai,o),i(e,xa,o),i(e,ci,o),i(e,ya,o),i(e,pi,o),i(e,Ca,o),i(e,Ma,o),i(e,Ha,o),i(e,ui,o),i(e,Sa,o),g(gi,e,o),i(e,Aa,o),i(e,mi,o),i(e,Ra,o),i(e,fi,o),i(e,Ea,o),i(e,hi,o),i(e,Na,o),i(e,Ba,o),i(e,Oa,o),i(e,_i,o),i(e,ja,o),g(Li,e,o),i(e,Ga,o),i(e,bi,o),i(e,Ia,o),i(e,Ti,o),i(e,Fa,o),i(e,Pi,o),i(e,qa,o),i(e,Da,o),i(e,za,o),i(e,$i,o),i(e,Ka,o),g(wi,e,o),i(e,Wa,o),i(e,vi,o),i(e,Ua,o),i(e,ki,o),i(e,Ja,o),i(e,xi,o),i(e,Qa,o),i(e,Va,o),i(e,Xa,o),i(e,yi,o),i(e,Ya,o),g(Ci,e,o),i(e,Za,o),i(e,Mi,o),i(e,ec,o),i(e,Hi,o),i(e,tc,o),i(e,oc,o),i(e,ic,o),i(e,Si,o),i(e,sc,o),g(Ai,e,o),i(e,lc,o),i(e,Ri,o),i(e,rc,o),i(e,Ei,o),i(e,nc,o),i(e,Ni,o),i(e,dc,o),i(e,ac,o),i(e,cc,o),i(e,Bi,o),i(e,pc,o),g(Oi,e,o),i(e,uc,o),i(e,ji,o),i(e,gc,o),i(e,Gi,o),i(e,mc,o),i(e,fc,o),i(e,hc,o),i(e,Ii,o),i(e,_c,o),g(Fi,e,o),i(e,Lc,o),i(e,qi,o),i(e,bc,o),i(e,Di,o),i(e,Tc,o),i(e,zi,o),i(e,Pc,o),i(e,$c,o),i(e,wc,o),i(e,Ki,o),i(e,vc,o),g(Wi,e,o),i(e,kc,o),i(e,Ui,o),i(e,xc,o),i(e,Ji,o),i(e,yc,o),i(e,Cc,o),i(e,Mc,o),i(e,Qi,o),i(e,Hc,o),g(Vi,e,o),i(e,Sc,o),i(e,Xi,o),i(e,Ac,o),i(e,Yi,o),i(e,Rc,o),i(e,Zi,o),i(e,Ec,o),i(e,Nc,o),i(e,Bc,o),i(e,ts,o),Oc=!0},p:$g,i(e){Oc||(m(T.$$.fragment,e),m(x.$$.fragment,e),m(S.$$.fragment,e),m(E.$$.fragment,e),m(G.$$.fragment,e),m(z.$$.fragment,e),m(Q.$$.fragment,e),m(Z.$$.fragment,e),m(le.$$.fragment,e),m(ce.$$.fragment,e),m(me.$$.fragment,e),m(be.$$.fragment,e),m(ve.$$.fragment,e),m(Ce.$$.fragment,e),m(Re.$$.fragment,e),m(je.$$.fragment,e),m(qe.$$.fragment,e),m(Ue.$$.fragment,e),m(Ye.$$.fragment,e),m(ot.$$.fragment,e),m(nt.$$.fragment,e),m(ut.$$.fragment,e),m(ht.$$.fragment,e),m(Pt.$$.fragment,e),m(xt.$$.fragment,e),m(Ht.$$.fragment,e),m(Nt.$$.fragment,e),m(It.$$.fragment,e),m(Kt.$$.fragment,e),m(Vt.$$.fragment,e),m(to.$$.fragment,e),m(lo.$$.fragment,e),m(po.$$.fragment,e),m(ho.$$.fragment,e),m(To.$$.fragment,e),m(ko.$$.fragment,e),m(Ho.$$.fragment,e),m(Eo.$$.fragment,e),m(Go.$$.fragment,e),m(Do.$$.fragment,e),m(Uo.$$.fragment,e),m(Yo.$$.fragment,e),m(oi.$$.fragment,e),m(ni.$$.fragment,e),m(gi.$$.fragment,e),m(Li.$$.fragment,e),m(wi.$$.fragment,e),m(Ci.$$.fragment,e),m(Ai.$$.fragment,e),m(Oi.$$.fragment,e),m(Fi.$$.fragment,e),m(Wi.$$.fragment,e),m(Vi.$$.fragment,e),Oc=!0)},o(e){f(T.$$.fragment,e),f(x.$$.fragment,e),f(S.$$.fragment,e),f(E.$$.fragment,e),f(G.$$.fragment,e),f(z.$$.fragment,e),f(Q.$$.fragment,e),f(Z.$$.fragment,e),f(le.$$.fragment,e),f(ce.$$.fragment,e),f(me.$$.fragment,e),f(be.$$.fragment,e),f(ve.$$.fragment,e),f(Ce.$$.fragment,e),f(Re.$$.fragment,e),f(je.$$.fragment,e),f(qe.$$.fragment,e),f(Ue.$$.fragment,e),f(Ye.$$.fragment,e),f(ot.$$.fragment,e),f(nt.$$.fragment,e),f(ut.$$.fragment,e),f(ht.$$.fragment,e),f(Pt.$$.fragment,e),f(xt.$$.fragment,e),f(Ht.$$.fragment,e),f(Nt.$$.fragment,e),f(It.$$.fragment,e),f(Kt.$$.fragment,e),f(Vt.$$.fragment,e),f(to.$$.fragment,e),f(lo.$$.fragment,e),f(po.$$.fragment,e),f(ho.$$.fragment,e),f(To.$$.fragment,e),f(ko.$$.fragment,e),f(Ho.$$.fragment,e),f(Eo.$$.fragment,e),f(Go.$$.fragment,e),f(Do.$$.fragment,e),f(Uo.$$.fragment,e),f(Yo.$$.fragment,e),f(oi.$$.fragment,e),f(ni.$$.fragment,e),f(gi.$$.fragment,e),f(Li.$$.fragment,e),f(wi.$$.fragment,e),f(Ci.$$.fragment,e),f(Ai.$$.fragment,e),f(Oi.$$.fragment,e),f(Fi.$$.fragment,e),f(Wi.$$.fragment,e),f(Vi.$$.fragment,e),Oc=!1},d(e){e&&(t(os),t(es),t(is),t(b),t(ss),t(ls),t(P),t(rs),t($),t(ns),t(w),t(ds),t(v),t(as),t(cs),t(ps),t(k),t(us),t(gs),t(y),t(ms),t(C),t(fs),t(M),t(hs),t(_s),t(Ls),t(H),t(bs),t(Ts),t(A),t(Ps),t($s),t(ws),t(R),t(vs),t(ks),t(N),t(xs),t(B),t(ys),t(O),t(Cs),t(Ms),t(Hs),t(j),t(Ss),t(As),t(I),t(Rs),t(F),t(Es),t(q),t(Ns),t(Bs),t(Os),t(D),t(js),t(Gs),t(K),t(Is),t(W),t(Fs),t(U),t(qs),t(Ds),t(zs),t(J),t(Ks),t(Ws),t(V),t(Us),t(X),t(Js),t(Qs),t(Vs),t(Y),t(Xs),t(Ys),t(ee),t(Zs),t(te),t(el),t(oe),t(tl),t(ie),t(ol),t(il),t(sl),t(se),t(ll),t(rl),t(re),t(nl),t(ne),t(dl),t(de),t(al),t(cl),t(pl),t(ae),t(ul),t(gl),t(pe),t(ml),t(ue),t(fl),t(hl),t(_l),t(ge),t(Ll),t(bl),t(fe),t(Tl),t(he),t(Pl),t(_e),t($l),t(wl),t(vl),t(Le),t(kl),t(xl),t(Te),t(yl),t(Pe),t(Cl),t($e),t(Ml),t(Hl),t(Sl),t(we),t(Al),t(Rl),t(ke),t(El),t(xe),t(Nl),t(Bl),t(Ol),t(ye),t(jl),t(Gl),t(Me),t(Il),t(He),t(Fl),t(Se),t(ql),t(Dl),t(zl),t(Ae),t(Kl),t(Wl),t(Ee),t(Ul),t(Ne),t(Jl),t(Be),t(Ql),t(Vl),t(Xl),t(Oe),t(Yl),t(Zl),t(Ge),t(er),t(Ie),t(tr),t(or),t(ir),t(Fe),t(sr),t(lr),t(De),t(rr),t(ze),t(nr),t(Ke),t(dr),t(ar),t(cr),t(We),t(pr),t(ur),t(Je),t(gr),t(Qe),t(mr),t(Ve),t(fr),t(hr),t(_r),t(Xe),t(Lr),t(br),t(Ze),t(Tr),t(et),t(Pr),t($r),t(wr),t(tt),t(vr),t(kr),t(it),t(xr),t(st),t(yr),t(lt),t(Cr),t(Mr),t(Hr),t(rt),t(Sr),t(Ar),t(dt),t(Rr),t(at),t(Er),t(ct),t(Nr),t(Br),t(Or),t(pt),t(jr),t(Gr),t(gt),t(Ir),t(mt),t(Fr),t(qr),t(Dr),t(ft),t(zr),t(Kr),t(_t),t(Wr),t(Lt),t(Ur),t(bt),t(Jr),t(Qr),t(Vr),t(Tt),t(Xr),t(Yr),t($t),t(Zr),t(wt),t(en),t(vt),t(tn),t(on),t(sn),t(kt),t(ln),t(rn),t(yt),t(nn),t(Ct),t(dn),t(an),t(cn),t(Mt),t(pn),t(un),t(St),t(gn),t(At),t(mn),t(Rt),t(fn),t(hn),t(_n),t(Et),t(Ln),t(bn),t(Bt),t(Tn),t(Ot),t(Pn),t(jt),t($n),t(wn),t(vn),t(Gt),t(kn),t(xn),t(Ft),t(yn),t(qt),t(Cn),t(Dt),t(Mn),t(Hn),t(Sn),t(zt),t(An),t(Rn),t(Wt),t(En),t(Ut),t(Nn),t(Jt),t(Bn),t(On),t(jn),t(Qt),t(Gn),t(In),t(Xt),t(Fn),t(Yt),t(qn),t(Zt),t(Dn),t(zn),t(Kn),t(eo),t(Wn),t(Un),t(oo),t(Jn),t(io),t(Qn),t(Vn),t(Xn),t(so),t(Yn),t(Zn),t(ro),t(ed),t(no),t(td),t(ao),t(od),t(id),t(sd),t(co),t(ld),t(rd),t(uo),t(nd),t(go),t(dd),t(mo),t(ad),t(cd),t(pd),t(fo),t(ud),t(gd),t(_o),t(md),t(Lo),t(fd),t(hd),t(_d),t(bo),t(Ld),t(bd),t(Po),t(Td),t($o),t(Pd),t(wo),t($d),t(wd),t(vd),t(vo),t(kd),t(xd),t(xo),t(yd),t(yo),t(Cd),t(Co),t(Md),t(Hd),t(Sd),t(Mo),t(Ad),t(Rd),t(So),t(Ed),t(Ao),t(Nd),t(Bd),t(Od),t(Ro),t(jd),t(Gd),t(No),t(Id),t(Bo),t(Fd),t(Oo),t(qd),t(Dd),t(zd),t(jo),t(Kd),t(Wd),t(Io),t(Ud),t(Fo),t(Jd),t(Qd),t(Vd),t(qo),t(Xd),t(Yd),t(zo),t(Zd),t(Ko),t(ea),t(ta),t(oa),t(Wo),t(ia),t(sa),t(Jo),t(la),t(Qo),t(ra),t(Vo),t(na),t(da),t(aa),t(Xo),t(ca),t(pa),t(Zo),t(ua),t(ei),t(ga),t(ma),t(fa),t(ti),t(ha),t(_a),t(ii),t(La),t(si),t(ba),t(li),t(Ta),t(Pa),t($a),t(ri),t(wa),t(va),t(di),t(ka),t(ai),t(xa),t(ci),t(ya),t(pi),t(Ca),t(Ma),t(Ha),t(ui),t(Sa),t(Aa),t(mi),t(Ra),t(fi),t(Ea),t(hi),t(Na),t(Ba),t(Oa),t(_i),t(ja),t(Ga),t(bi),t(Ia),t(Ti),t(Fa),t(Pi),t(qa),t(Da),t(za),t($i),t(Ka),t(Wa),t(vi),t(Ua),t(ki),t(Ja),t(xi),t(Qa),t(Va),t(Xa),t(yi),t(Ya),t(Za),t(Mi),t(ec),t(Hi),t(tc),t(oc),t(ic),t(Si),t(sc),t(lc),t(Ri),t(rc),t(Ei),t(nc),t(Ni),t(dc),t(ac),t(cc),t(Bi),t(pc),t(uc),t(ji),t(gc),t(Gi),t(mc),t(fc),t(hc),t(Ii),t(_c),t(Lc),t(qi),t(bc),t(Di),t(Tc),t(zi),t(Pc),t($c),t(wc),t(Ki),t(vc),t(kc),t(Ui),t(xc),t(Ji),t(yc),t(Cc),t(Mc),t(Qi),t(Hc),t(Sc),t(Xi),t(Ac),t(Yi),t(Rc),t(Zi),t(Ec),t(Nc),t(Bc),t(ts)),t(L),h(T,e),h(x,e),h(S,e),h(E,e),h(G,e),h(z,e),h(Q,e),h(Z,e),h(le,e),h(ce,e),h(me,e),h(be,e),h(ve,e),h(Ce,e),h(Re,e),h(je,e),h(qe,e),h(Ue,e),h(Ye,e),h(ot,e),h(nt,e),h(ut,e),h(ht,e),h(Pt,e),h(xt,e),h(Ht,e),h(Nt,e),h(It,e),h(Kt,e),h(Vt,e),h(to,e),h(lo,e),h(po,e),h(ho,e),h(To,e),h(ko,e),h(Ho,e),h(Eo,e),h(Go,e),h(Do,e),h(Uo,e),h(Yo,e),h(oi,e),h(ni,e),h(gi,e),h(Li,e),h(wi,e),h(Ci,e),h(Ai,e),h(Oi,e),h(Fi,e),h(Wi,e),h(Vi,e)}}}const Mg='{"title":"utils/generation","local":"utilsgeneration","sections":[{"title":"utils/generation.LogitsProcessorList ⇐ <code> Callable </code>","local":"utilsgenerationlogitsprocessorlist--code-callable-code","sections":[{"title":"new LogitsProcessorList()","local":"new-logitsprocessorlist","sections":[],"depth":3},{"title":"logitsProcessorList.push(item)","local":"logitsprocessorlistpushitem","sections":[],"depth":3},{"title":"logitsProcessorList.extend(items)","local":"logitsprocessorlistextenditems","sections":[],"depth":3},{"title":"logitsProcessorList._call(input_ids, batchedLogits)","local":"logitsprocessorlistcallinputids-batchedlogits","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.LogitsProcessor ⇐ <code> Callable </code>","local":"utilsgenerationlogitsprocessor--code-callable-code","sections":[{"title":"logitsProcessor._call(input_ids, logits)","local":"logitsprocessorcallinputids-logits","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.ForceTokensLogitsProcessor ⇐ <code> LogitsProcessor </code>","local":"utilsgenerationforcetokenslogitsprocessor--code-logitsprocessor-code","sections":[{"title":"new ForceTokensLogitsProcessor(forced_decoder_ids)","local":"new-forcetokenslogitsprocessorforceddecoderids","sections":[],"depth":3},{"title":"forceTokensLogitsProcessor._call(input_ids, logits) ⇒ <code> Tensor </code>","local":"forcetokenslogitsprocessorcallinputids-logits--code-tensor-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.ForcedBOSTokenLogitsProcessor ⇐ <code> LogitsProcessor </code>","local":"utilsgenerationforcedbostokenlogitsprocessor--code-logitsprocessor-code","sections":[{"title":"new ForcedBOSTokenLogitsProcessor(bos_token_id)","local":"new-forcedbostokenlogitsprocessorbostokenid","sections":[],"depth":3},{"title":"forcedBOSTokenLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>","local":"forcedbostokenlogitsprocessorcallinputids-logits--code-object-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.ForcedEOSTokenLogitsProcessor ⇐ <code> LogitsProcessor </code>","local":"utilsgenerationforcedeostokenlogitsprocessor--code-logitsprocessor-code","sections":[{"title":"new ForcedEOSTokenLogitsProcessor(max_length, forced_eos_token_id)","local":"new-forcedeostokenlogitsprocessormaxlength-forcedeostokenid","sections":[],"depth":3},{"title":"forcedEOSTokenLogitsProcessor._call(input_ids, logits)","local":"forcedeostokenlogitsprocessorcallinputids-logits","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.SuppressTokensAtBeginLogitsProcessor ⇐ <code> LogitsProcessor </code>","local":"utilsgenerationsuppresstokensatbeginlogitsprocessor--code-logitsprocessor-code","sections":[{"title":"new SuppressTokensAtBeginLogitsProcessor(begin_suppress_tokens, begin_index)","local":"new-suppresstokensatbeginlogitsprocessorbeginsuppresstokens-beginindex","sections":[],"depth":3},{"title":"suppressTokensAtBeginLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>","local":"suppresstokensatbeginlogitsprocessorcallinputids-logits--code-object-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.WhisperTimeStampLogitsProcessor ⇐ <code> LogitsProcessor </code>","local":"utilsgenerationwhispertimestamplogitsprocessor--code-logitsprocessor-code","sections":[{"title":"new WhisperTimeStampLogitsProcessor(generate_config)","local":"new-whispertimestamplogitsprocessorgenerateconfig","sections":[],"depth":3},{"title":"whisperTimeStampLogitsProcessor._call(input_ids, logits) ⇒ <code> Tensor </code>","local":"whispertimestamplogitsprocessorcallinputids-logits--code-tensor-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.NoRepeatNGramLogitsProcessor ⇐ <code> LogitsProcessor </code>","local":"utilsgenerationnorepeatngramlogitsprocessor--code-logitsprocessor-code","sections":[{"title":"new NoRepeatNGramLogitsProcessor(no_repeat_ngram_size)","local":"new-norepeatngramlogitsprocessornorepeatngramsize","sections":[],"depth":3},{"title":"noRepeatNGramLogitsProcessor.getNgrams(prevInputIds) ⇒ <code> Map. < string, Array < number > > </code>","local":"norepeatngramlogitsprocessorgetngramsprevinputids--code-map--string-array--number---code","sections":[],"depth":3},{"title":"noRepeatNGramLogitsProcessor.getGeneratedNgrams(bannedNgrams, prevInputIds) ⇒ <code> Array. < number > </code>","local":"norepeatngramlogitsprocessorgetgeneratedngramsbannedngrams-previnputids--code-array--number--code","sections":[],"depth":3},{"title":"noRepeatNGramLogitsProcessor.calcBannedNgramTokens(prevInputIds) ⇒ <code> Array. < number > </code>","local":"norepeatngramlogitsprocessorcalcbannedngramtokensprevinputids--code-array--number--code","sections":[],"depth":3},{"title":"noRepeatNGramLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>","local":"norepeatngramlogitsprocessorcallinputids-logits--code-object-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.RepetitionPenaltyLogitsProcessor ⇐ <code> LogitsProcessor </code>","local":"utilsgenerationrepetitionpenaltylogitsprocessor--code-logitsprocessor-code","sections":[{"title":"new RepetitionPenaltyLogitsProcessor(penalty)","local":"new-repetitionpenaltylogitsprocessorpenalty","sections":[],"depth":3},{"title":"repetitionPenaltyLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>","local":"repetitionpenaltylogitsprocessorcallinputids-logits--code-object-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.MinLengthLogitsProcessor ⇐ <code> LogitsProcessor </code>","local":"utilsgenerationminlengthlogitsprocessor--code-logitsprocessor-code","sections":[{"title":"new MinLengthLogitsProcessor(min_length, eos_token_id)","local":"new-minlengthlogitsprocessorminlength-eostokenid","sections":[],"depth":3},{"title":"minLengthLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>","local":"minlengthlogitsprocessorcallinputids-logits--code-object-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.MinNewTokensLengthLogitsProcessor ⇐ <code> LogitsProcessor </code>","local":"utilsgenerationminnewtokenslengthlogitsprocessor--code-logitsprocessor-code","sections":[{"title":"new MinNewTokensLengthLogitsProcessor(prompt_length_to_skip, min_new_tokens, eos_token_id)","local":"new-minnewtokenslengthlogitsprocessorpromptlengthtoskip-minnewtokens-eostokenid","sections":[],"depth":3},{"title":"minNewTokensLengthLogitsProcessor._call(input_ids, logits) ⇒ <code> Object </code>","local":"minnewtokenslengthlogitsprocessorcallinputids-logits--code-object-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.GenerationConfig","local":"utilsgenerationgenerationconfig","sections":[{"title":"new GenerationConfig([kwargs])","local":"new-generationconfigkwargs","sections":[],"depth":3}],"depth":2},{"title":"utils/generation.Sampler","local":"utilsgenerationsampler","sections":[{"title":"new Sampler(generation_config)","local":"new-samplergenerationconfig","sections":[],"depth":3},{"title":"sampler._call(logits, index) ⇒ <code> void </code>","local":"samplercalllogits-index--code-void-code","sections":[],"depth":3},{"title":"sampler.sample(logits, index)","local":"samplersamplelogits-index","sections":[],"depth":3},{"title":"sampler.getLogits(logits, index) ⇒ <code> Array </code>","local":"samplergetlogitslogits-index--code-array-code","sections":[],"depth":3},{"title":"sampler.randomSelect(probabilities) ⇒ <code> number </code>","local":"samplerrandomselectprobabilities--code-number-code","sections":[],"depth":3},{"title":"Sampler.getSampler(generation_config) ⇒ <code> Sampler </code>","local":"samplergetsamplergenerationconfig--code-sampler-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation~GreedySampler ⇐ <code> Sampler </code>","local":"utilsgenerationgreedysampler--code-sampler-code","sections":[{"title":"greedySampler.sample(logits, [index]) ⇒ <code> Array </code>","local":"greedysamplersamplelogits-index--code-array-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation~MultinomialSampler ⇐ <code> Sampler </code>","local":"utilsgenerationmultinomialsampler--code-sampler-code","sections":[{"title":"multinomialSampler.sample(logits, index) ⇒ <code> Array </code>","local":"multinomialsamplersamplelogits-index--code-array-code","sections":[],"depth":3}],"depth":2},{"title":"utils/generation~BeamSearchSampler ⇐ <code> Sampler </code>","local":"utilsgenerationbeamsearchsampler--code-sampler-code","sections":[{"title":"beamSearchSampler.sample(logits, index) ⇒ <code> Array </code>","local":"beamsearchsamplersamplelogits-index--code-array-code","sections":[],"depth":3}],"depth":2}],"depth":1}';function Hg(jc){return wg(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Eg extends vg{constructor(L){super(),kg(this,L,Hg,Cg,Pg,{})}}export{Eg as component};
