import{s as mt,n as pt,o as ut}from"../chunks/scheduler.b108d059.js";import{S as wt,i as bt,g as i,s as n,r as h,A as yt,h as s,f as a,c as r,j as ee,u as g,x as l,k as ct,y as q,a as o,v as d,d as f,t as c,w as m}from"../chunks/index.008de539.js";import{C as ze}from"../chunks/CodeBlock.3968c746.js";import{H as p}from"../chunks/Heading.88bfeb84.js";function Tt(Ue){let u,re,te,ie,b,se,y,Ze="State-of-the-art Machine Learning for the web. Run 🤗 Transformers directly in your browser, with no need for a server!",le,T,Ye='Transformers.js is designed to be functionally equivalent to Hugging Face’s <a href="https://github.com/huggingface/transformers" rel="nofollow">transformers</a> python library, meaning you can run the same pretrained models using a very similar API. These models support common tasks in different modalities, such as:',he,v,Ve="<li>📝 <strong>Natural Language Processing</strong>: text classification, named entity recognition, question answering, language modeling, summarization, translation, multiple choice, and text generation.</li> <li>🖼️ <strong>Computer Vision</strong>: image classification, object detection, and segmentation.</li> <li>🗣️ <strong>Audio</strong>: automatic speech recognition and audio classification.</li> <li>🐙 <strong>Multimodal</strong>: zero-shot image classification.</li>",ge,M,Xe='Transformers.js uses <a href="https://onnxruntime.ai/" rel="nofollow">ONNX Runtime</a> to run models in the browser. The best part about it, is that you can easily <a href="#convert-your-models-to-onnx">convert</a> your pretrained PyTorch, TensorFlow, or JAX models to ONNX using <a href="https://github.com/huggingface/optimum#onnx--onnx-runtime" rel="nofollow">🤗 Optimum</a>.',de,x,Ke='For more information, check out the full <a href="https://huggingface.co/docs/transformers.js" rel="nofollow">documentation</a>.',fe,k,ce,L,Oe="It’s super simple to translate from existing code! Just like the python library, we support the <code>pipeline</code> API. Pipelines group together a pretrained model with preprocessing of inputs and postprocessing of outputs, making it the easiest way to run models with the library.",me,w,Q,qe='<th width="440px" align="center"><b>Python (original)</b></th> <th width="440px" align="center"><b>Javascript (ours)</b></th>',Fe,S,ae,A,Ne,oe,C,pe,_,Qe="You can also use a different model by specifying the model id or path as the second argument to the <code>pipeline</code> function. For example:",ue,R,we,j,be,B,et="The documentation is organized into 4 sections:",ye,G,tt="<li><strong>GET STARTED</strong> provides a quick tour of the library and installation instructions to get up and running.</li> <li><strong>TUTORIALS</strong> are a great place to start if you’re a beginner! We also include sample applications for you to play around with!</li> <li><strong>DEVELOPER GUIDES</strong> show you how to use the library to achieve a specific goal.</li> <li><strong>API REFERENCE</strong> describes all classes and functions, as well as their available parameters and types.</li>",Te,$,ve,E,at=`Here is the list of all tasks and architectures currently supported by Transformers.js.
If you don’t see your task/model listed here or it is not yet supported, feel free
to open up a feature request <a href="https://github.com/xenova/transformers.js/issues/new/choose" rel="nofollow">here</a>.`,Me,P,ot=`To find compatible models on the Hub, select the “transformers.js” library tag in the filter menu (or visit <a href="https://huggingface.co/models?library=transformers.js" rel="nofollow">this link</a>).
You can refine your search by selecting the task you’re interested in (e.g., <a href="https://huggingface.co/models?pipeline_tag=text-classification&amp;library=transformers.js" rel="nofollow">text-classification</a>).`,xe,J,ke,I,Le,H,nt='<thead><tr><th>Task</th> <th>ID</th> <th>Description</th> <th>Supported?</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/tasks/conversational" rel="nofollow">Conversational</a></td> <td><code>conversational</code></td> <td>Generating conversational text that is relevant, coherent and knowledgable given a prompt.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/fill-mask" rel="nofollow">Fill-Mask</a></td> <td><code>fill-mask</code></td> <td>Masking some of the words in a sentence and predicting which words should replace those masks.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.FillMaskPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=fill-mask&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/question-answering" rel="nofollow">Question Answering</a></td> <td><code>question-answering</code></td> <td>Retrieve the answer to a question from a given text.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.QuestionAnsweringPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=question-answering&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/sentence-similarity" rel="nofollow">Sentence Similarity</a></td> <td><code>sentence-similarity</code></td> <td>Determining how similar two texts are.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.FeatureExtractionPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=feature-extraction&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/summarization" rel="nofollow">Summarization</a></td> <td><code>summarization</code></td> <td>Producing a shorter version of a document while preserving its important information.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.SummarizationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=summarization&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/table-question-answering" rel="nofollow">Table Question Answering</a></td> <td><code>table-question-answering</code></td> <td>Answering a question about information from a given table.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/text-classification" rel="nofollow">Text Classification</a></td> <td><code>text-classification</code> or <code>sentiment-analysis</code></td> <td>Assigning a label or class to a given text.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.TextClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=text-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/text-generation#completion-generation-models" rel="nofollow">Text Generation</a></td> <td><code>text-generation</code></td> <td>Producing new text by predicting the next word in a sequence.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.TextGenerationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=text-generation&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/text-generation#text-to-text-generation-models" rel="nofollow">Text-to-text Generation</a></td> <td><code>text2text-generation</code></td> <td>Converting one text sequence into another text sequence.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.Text2TextGenerationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=text2text-generation&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/token-classification" rel="nofollow">Token Classification</a></td> <td><code>token-classification</code> or <code>ner</code></td> <td>Assigning a label to each token in a text.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.TokenClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=token-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/translation" rel="nofollow">Translation</a></td> <td><code>translation</code></td> <td>Converting text from one language to another.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.TranslationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=translation&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/zero-shot-classification" rel="nofollow">Zero-Shot Classification</a></td> <td><code>zero-shot-classification</code></td> <td>Classifying text into classes that are unseen during training.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ZeroShotClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=zero-shot-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr></tbody>',Se,W,Ae,D,rt='<thead><tr><th>Task</th> <th>ID</th> <th>Description</th> <th>Supported?</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/tasks/depth-estimation" rel="nofollow">Depth Estimation</a></td> <td><code>depth-estimation</code></td> <td>Predicting the depth of objects present in an image.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/image-classification" rel="nofollow">Image Classification</a></td> <td><code>image-classification</code></td> <td>Assigning a label or class to an entire image.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ImageClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=image-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/image-segmentation" rel="nofollow">Image Segmentation</a></td> <td><code>image-segmentation</code></td> <td>Divides an image into segments where each pixel is mapped to an object. This task has multiple variants such as instance segmentation, panoptic segmentation and semantic segmentation.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ImageSegmentationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=image-segmentation&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/image-to-image" rel="nofollow">Image-to-Image</a></td> <td><code>image-to-image</code></td> <td>Transforming a source image to match the characteristics of a target image or a target image domain.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/mask-generation" rel="nofollow">Mask Generation</a></td> <td><code>mask-generation</code></td> <td>Generate masks for the objects in an image.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/object-detection" rel="nofollow">Object Detection</a></td> <td><code>object-detection</code></td> <td>Identify objects of certain defined classes within an image.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ObjectDetectionPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=object-detection&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/video-classification" rel="nofollow">Video Classification</a></td> <td>n/a</td> <td>Assigning a label or class to an entire video.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/unconditional-image-generation" rel="nofollow">Unconditional Image Generation</a></td> <td>n/a</td> <td>Generating images with no condition in any context (like a prompt text or another image).</td> <td>❌</td></tr></tbody>',Ce,F,_e,N,it='<thead><tr><th>Task</th> <th>ID</th> <th>Description</th> <th>Supported?</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/tasks/audio-classification" rel="nofollow">Audio Classification</a></td> <td><code>audio-classification</code></td> <td>Assigning a label or class to a given audio.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.AudioClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=audio-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/audio-to-audio" rel="nofollow">Audio-to-Audio</a></td> <td>n/a</td> <td>Generating audio from an input audio source.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/automatic-speech-recognition" rel="nofollow">Automatic Speech Recognition</a></td> <td><code>automatic-speech-recognition</code></td> <td>Transcribing a given audio into text.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.AutomaticSpeechRecognitionPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=automatic-speech-recognition&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/text-to-speech" rel="nofollow">Text-to-Speech</a></td> <td><code>text-to-speech</code> or <code>text-to-audio</code></td> <td>Generating natural-sounding speech given text input.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.TextToAudioPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=text-to-audio&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr></tbody>',Re,z,je,U,st='<thead><tr><th>Task</th> <th>ID</th> <th>Description</th> <th>Supported?</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/tasks/tabular-classification" rel="nofollow">Tabular Classification</a></td> <td>n/a</td> <td>Classifying a target category (a group) based on set of attributes.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/tabular-regression" rel="nofollow">Tabular Regression</a></td> <td>n/a</td> <td>Predicting a numerical value given a set of attributes.</td> <td>❌</td></tr></tbody>',Be,Z,Ge,Y,lt='<thead><tr><th>Task</th> <th>ID</th> <th>Description</th> <th>Supported?</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/tasks/document-question-answering" rel="nofollow">Document Question Answering</a></td> <td><code>document-question-answering</code></td> <td>Answering questions on document images.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.DocumentQuestionAnsweringPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=document-question-answering&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/feature-extraction" rel="nofollow">Feature Extraction</a></td> <td><code>feature-extraction</code></td> <td>Transforming raw data into numerical features that can be processed while preserving the information in the original dataset.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.FeatureExtractionPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=feature-extraction&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/image-to-text" rel="nofollow">Image-to-Text</a></td> <td><code>image-to-text</code></td> <td>Output text from a given image.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ImageToTextPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=image-to-text&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/text-to-image" rel="nofollow">Text-to-Image</a></td> <td><code>text-to-image</code></td> <td>Generates images from input text.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/visual-question-answering" rel="nofollow">Visual Question Answering</a></td> <td><code>visual-question-answering</code></td> <td>Answering open-ended questions based on an image.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/zero-shot-image-classification" rel="nofollow">Zero-Shot Image Classification</a></td> <td><code>zero-shot-image-classification</code></td> <td>Classifying images into classes that are unseen during training.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ZeroShotImageClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=zero-shot-image-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr></tbody>',$e,V,Ee,X,ht='<thead><tr><th>Task</th> <th>ID</th> <th>Description</th> <th>Supported?</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/tasks/reinforcement-learning" rel="nofollow">Reinforcement Learning</a></td> <td>n/a</td> <td>Learning from actions by interacting with an environment through trial and error and receiving rewards (negative or positive) as feedback.</td> <td>❌</td></tr></tbody>',Pe,K,Je,O,gt='<li><strong><a href="https://huggingface.co/docs/transformers/model_doc/albert" rel="nofollow">ALBERT</a></strong> (from Google Research and the Toyota Technological Institute at Chicago) released with the paper <a href="https://arxiv.org/abs/1909.11942" rel="nofollow">ALBERT: A Lite BERT for Self-supervised Learning of Language Representations</a>, by Zhenzhong Lan, Mingda Chen, Sebastian Goodman, Kevin Gimpel, Piyush Sharma, Radu Soricut.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/bart" rel="nofollow">BART</a></strong> (from Facebook) released with the paper <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">BART: Denoising Sequence-to-Sequence Pre-training for Natural Language Generation, Translation, and Comprehension</a> by Mike Lewis, Yinhan Liu, Naman Goyal, Marjan Ghazvininejad, Abdelrahman Mohamed, Omer Levy, Ves Stoyanov and Luke Zettlemoyer.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/beit" rel="nofollow">BEiT</a></strong> (from Microsoft) released with the paper <a href="https://arxiv.org/abs/2106.08254" rel="nofollow">BEiT: BERT Pre-Training of Image Transformers</a> by Hangbo Bao, Li Dong, Furu Wei.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/bert" rel="nofollow">BERT</a></strong> (from Google) released with the paper <a href="https://arxiv.org/abs/1810.04805" rel="nofollow">BERT: Pre-training of Deep Bidirectional Transformers for Language Understanding</a> by Jacob Devlin, Ming-Wei Chang, Kenton Lee and Kristina Toutanova.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/blenderbot" rel="nofollow">Blenderbot</a></strong> (from Facebook) released with the paper <a href="https://arxiv.org/abs/2004.13637" rel="nofollow">Recipes for building an open-domain chatbot</a> by Stephen Roller, Emily Dinan, Naman Goyal, Da Ju, Mary Williamson, Yinhan Liu, Jing Xu, Myle Ott, Kurt Shuster, Eric M. Smith, Y-Lan Boureau, Jason Weston.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/blenderbot-small" rel="nofollow">BlenderbotSmall</a></strong> (from Facebook) released with the paper <a href="https://arxiv.org/abs/2004.13637" rel="nofollow">Recipes for building an open-domain chatbot</a> by Stephen Roller, Emily Dinan, Naman Goyal, Da Ju, Mary Williamson, Yinhan Liu, Jing Xu, Myle Ott, Kurt Shuster, Eric M. Smith, Y-Lan Boureau, Jason Weston.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/bloom" rel="nofollow">BLOOM</a></strong> (from BigScience workshop) released by the <a href="https://bigscience.huggingface.co/" rel="nofollow">BigScience Workshop</a>.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/camembert" rel="nofollow">CamemBERT</a></strong> (from Inria/Facebook/Sorbonne) released with the paper <a href="https://arxiv.org/abs/1911.03894" rel="nofollow">CamemBERT: a Tasty French Language Model</a> by Louis Martin<em>, Benjamin Muller</em>, Pedro Javier Ortiz Suárez*, Yoann Dupont, Laurent Romary, Éric Villemonte de la Clergerie, Djamé Seddah and Benoît Sagot.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/clip" rel="nofollow">CLIP</a></strong> (from OpenAI) released with the paper <a href="https://arxiv.org/abs/2103.00020" rel="nofollow">Learning Transferable Visual Models From Natural Language Supervision</a> by Alec Radford, Jong Wook Kim, Chris Hallacy, Aditya Ramesh, Gabriel Goh, Sandhini Agarwal, Girish Sastry, Amanda Askell, Pamela Mishkin, Jack Clark, Gretchen Krueger, Ilya Sutskever.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/codegen" rel="nofollow">CodeGen</a></strong> (from Salesforce) released with the paper <a href="https://arxiv.org/abs/2203.13474" rel="nofollow">A Conversational Paradigm for Program Synthesis</a> by Erik Nijkamp, Bo Pang, Hiroaki Hayashi, Lifu Tu, Huan Wang, Yingbo Zhou, Silvio Savarese, Caiming Xiong.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/llama_code" rel="nofollow">CodeLlama</a></strong> (from MetaAI) released with the paper <a href="https://ai.meta.com/research/publications/code-llama-open-foundation-models-for-code/" rel="nofollow">Code Llama: Open Foundation Models for Code</a> by Baptiste Rozière, Jonas Gehring, Fabian Gloeckle, Sten Sootla, Itai Gat, Xiaoqing Ellen Tan, Yossi Adi, Jingyu Liu, Tal Remez, Jérémy Rapin, Artyom Kozhevnikov, Ivan Evtimov, Joanna Bitton, Manish Bhatt, Cristian Canton Ferrer, Aaron Grattafiori, Wenhan Xiong, Alexandre Défossez, Jade Copet, Faisal Azhar, Hugo Touvron, Louis Martin, Nicolas Usunier, Thomas Scialom, Gabriel Synnaeve.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/deberta" rel="nofollow">DeBERTa</a></strong> (from Microsoft) released with the paper <a href="https://arxiv.org/abs/2006.03654" rel="nofollow">DeBERTa: Decoding-enhanced BERT with Disentangled Attention</a> by Pengcheng He, Xiaodong Liu, Jianfeng Gao, Weizhu Chen.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/deberta-v2" rel="nofollow">DeBERTa-v2</a></strong> (from Microsoft) released with the paper <a href="https://arxiv.org/abs/2006.03654" rel="nofollow">DeBERTa: Decoding-enhanced BERT with Disentangled Attention</a> by Pengcheng He, Xiaodong Liu, Jianfeng Gao, Weizhu Chen.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/deit" rel="nofollow">DeiT</a></strong> (from Facebook) released with the paper <a href="https://arxiv.org/abs/2012.12877" rel="nofollow">Training data-efficient image transformers &amp; distillation through attention</a> by Hugo Touvron, Matthieu Cord, Matthijs Douze, Francisco Massa, Alexandre Sablayrolles, Hervé Jégou.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/detr" rel="nofollow">DETR</a></strong> (from Facebook) released with the paper <a href="https://arxiv.org/abs/2005.12872" rel="nofollow">End-to-End Object Detection with Transformers</a> by Nicolas Carion, Francisco Massa, Gabriel Synnaeve, Nicolas Usunier, Alexander Kirillov, Sergey Zagoruyko.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/distilbert" rel="nofollow">DistilBERT</a></strong> (from HuggingFace), released together with the paper <a href="https://arxiv.org/abs/1910.01108" rel="nofollow">DistilBERT, a distilled version of BERT: smaller, faster, cheaper and lighter</a> by Victor Sanh, Lysandre Debut and Thomas Wolf. The same method has been applied to compress GPT2 into <a href="https://github.com/huggingface/transformers/tree/main/examples/research_projects/distillation" rel="nofollow">DistilGPT2</a>, RoBERTa into <a href="https://github.com/huggingface/transformers/tree/main/examples/research_projects/distillation" rel="nofollow">DistilRoBERTa</a>, Multilingual BERT into <a href="https://github.com/huggingface/transformers/tree/main/examples/research_projects/distillation" rel="nofollow">DistilmBERT</a> and a German version of DistilBERT.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/donut" rel="nofollow">Donut</a></strong> (from NAVER), released together with the paper <a href="https://arxiv.org/abs/2111.15664" rel="nofollow">OCR-free Document Understanding Transformer</a> by Geewook Kim, Teakgyu Hong, Moonbin Yim, Jeongyeon Nam, Jinyoung Park, Jinyeong Yim, Wonseok Hwang, Sangdoo Yun, Dongyoon Han, Seunghyun Park.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/flan-t5" rel="nofollow">FLAN-T5</a></strong> (from Google AI) released in the repository <a href="https://github.com/google-research/t5x/blob/main/docs/models.md#flan-t5-checkpoints" rel="nofollow">google-research/t5x</a> by Hyung Won Chung, Le Hou, Shayne Longpre, Barret Zoph, Yi Tay, William Fedus, Eric Li, Xuezhi Wang, Mostafa Dehghani, Siddhartha Brahma, Albert Webson, Shixiang Shane Gu, Zhuyun Dai, Mirac Suzgun, Xinyun Chen, Aakanksha Chowdhery, Sharan Narang, Gaurav Mishra, Adams Yu, Vincent Zhao, Yanping Huang, Andrew Dai, Hongkun Yu, Slav Petrov, Ed H. Chi, Jeff Dean, Jacob Devlin, Adam Roberts, Denny Zhou, Quoc V. Le, and Jason Wei</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/gpt_neo" rel="nofollow">GPT Neo</a></strong> (from EleutherAI) released in the repository <a href="https://github.com/EleutherAI/gpt-neo" rel="nofollow">EleutherAI/gpt-neo</a> by Sid Black, Stella Biderman, Leo Gao, Phil Wang and Connor Leahy.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/gpt_neox" rel="nofollow">GPT NeoX</a></strong> (from EleutherAI) released with the paper <a href="https://arxiv.org/abs/2204.06745" rel="nofollow">GPT-NeoX-20B: An Open-Source Autoregressive Language Model</a> by Sid Black, Stella Biderman, Eric Hallahan, Quentin Anthony, Leo Gao, Laurence Golding, Horace He, Connor Leahy, Kyle McDonell, Jason Phang, Michael Pieler, USVSN Sai Prashanth, Shivanshu Purohit, Laria Reynolds, Jonathan Tow, Ben Wang, Samuel Weinbach</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/gpt2" rel="nofollow">GPT-2</a></strong> (from OpenAI) released with the paper <a href="https://blog.openai.com/better-language-models/" rel="nofollow">Language Models are Unsupervised Multitask Learners</a> by Alec Radford<em>, Jeffrey Wu</em>, Rewon Child, David Luan, Dario Amodei<strong>and Ilya Sutskever</strong>.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/gptj" rel="nofollow">GPT-J</a></strong> (from EleutherAI) released in the repository <a href="https://github.com/kingoflolz/mesh-transformer-jax/" rel="nofollow">kingoflolz/mesh-transformer-jax</a> by Ben Wang and Aran Komatsuzaki.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/gpt_bigcode" rel="nofollow">GPTBigCode</a></strong> (from BigCode) released with the paper <a href="https://arxiv.org/abs/2301.03988" rel="nofollow">SantaCoder: don’t reach for the stars!</a> by Loubna Ben Allal, Raymond Li, Denis Kocetkov, Chenghao Mou, Christopher Akiki, Carlos Munoz Ferrandis, Niklas Muennighoff, Mayank Mishra, Alex Gu, Manan Dey, Logesh Kumar Umapathi, Carolyn Jane Anderson, Yangtian Zi, Joel Lamy Poirier, Hailey Schoelkopf, Sergey Troshin, Dmitry Abulkhanov, Manuel Romero, Michael Lappert, Francesco De Toni, Bernardo García del Río, Qian Liu, Shamik Bose, Urvashi Bhattacharyya, Terry Yue Zhuo, Ian Yu, Paulo Villegas, Marco Zocca, Sourab Mangrulkar, David Lansky, Huu Nguyen, Danish Contractor, Luis Villa, Jia Li, Dzmitry Bahdanau, Yacine Jernite, Sean Hughes, Daniel Fried, Arjun Guha, Harm de Vries, Leandro von Werra.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/herbert" rel="nofollow">HerBERT</a></strong> (from Allegro.pl, AGH University of Science and Technology) released with the paper <a href="https://www.aclweb.org/anthology/2020.acl-main.111.pdf" rel="nofollow">KLEJ: Comprehensive Benchmark for Polish Language Understanding</a> by Piotr Rybak, Robert Mroczkowski, Janusz Tracz, Ireneusz Gawlik.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/longt5" rel="nofollow">LongT5</a></strong> (from Google AI) released with the paper <a href="https://arxiv.org/abs/2112.07916" rel="nofollow">LongT5: Efficient Text-To-Text Transformer for Long Sequences</a> by Mandy Guo, Joshua Ainslie, David Uthus, Santiago Ontanon, Jianmo Ni, Yun-Hsuan Sung, Yinfei Yang.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/llama" rel="nofollow">LLaMA</a></strong> (from The FAIR team of Meta AI) released with the paper <a href="https://arxiv.org/abs/2302.13971" rel="nofollow">LLaMA: Open and Efficient Foundation Language Models</a> by Hugo Touvron, Thibaut Lavril, Gautier Izacard, Xavier Martinet, Marie-Anne Lachaux, Timothée Lacroix, Baptiste Rozière, Naman Goyal, Eric Hambro, Faisal Azhar, Aurelien Rodriguez, Armand Joulin, Edouard Grave, Guillaume Lample.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/llama2" rel="nofollow">Llama2</a></strong> (from The FAIR team of Meta AI) released with the paper <a href="https://ai.meta.com/research/publications/llama-2-open-foundation-and-fine-tuned-chat-models/XXX" rel="nofollow">Llama2: Open Foundation and Fine-Tuned Chat Models</a> by Hugo Touvron, Louis Martin, Kevin Stone, Peter Albert, Amjad Almahairi, Yasmine Babaei, Nikolay Bashlykov, Soumya Batra, Prajjwal Bhargava, Shruti Bhosale, Dan Bikel, Lukas Blecher, Cristian Canton Ferrer, Moya Chen, Guillem Cucurull, David Esiobu, Jude Fernandes, Jeremy Fu, Wenyin Fu, Brian Fuller, Cynthia Gao, Vedanuj Goswami, Naman Goyal, Anthony Hartshorn, Saghar Hosseini, Rui Hou, Hakan Inan, Marcin Kardas, Viktor Kerkez Madian Khabsa, Isabel Kloumann, Artem Korenev, Punit Singh Koura, Marie-Anne Lachaux, Thibaut Lavril, Jenya Lee, Diana Liskovich, Yinghai Lu, Yuning Mao, Xavier Martinet, Todor Mihaylov, Pushka rMishra, Igor Molybog, Yixin Nie, Andrew Poulton, Jeremy Reizenstein, Rashi Rungta, Kalyan Saladi, Alan Schelten, Ruan Silva, Eric Michael Smith, Ranjan Subramanian, Xiaoqing EllenTan, Binh Tang, Ross Taylor, Adina Williams, Jian Xiang Kuan, Puxin Xu, Zheng Yan, Iliyan Zarov, Yuchen Zhang, Angela Fan, Melanie Kambadur, Sharan Narang, Aurelien Rodriguez, Robert Stojnic, Sergey Edunov, Thomas Scialom.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/m2m_100" rel="nofollow">M2M100</a></strong> (from Facebook) released with the paper <a href="https://arxiv.org/abs/2010.11125" rel="nofollow">Beyond English-Centric Multilingual Machine Translation</a> by Angela Fan, Shruti Bhosale, Holger Schwenk, Zhiyi Ma, Ahmed El-Kishky, Siddharth Goyal, Mandeep Baines, Onur Celebi, Guillaume Wenzek, Vishrav Chaudhary, Naman Goyal, Tom Birch, Vitaliy Liptchinsky, Sergey Edunov, Edouard Grave, Michael Auli, Armand Joulin.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/marian" rel="nofollow">MarianMT</a></strong> Machine translation models trained using <a href="http://opus.nlpl.eu/" rel="nofollow">OPUS</a> data by Jörg Tiedemann. The <a href="https://marian-nmt.github.io/" rel="nofollow">Marian Framework</a> is being developed by the Microsoft Translator Team.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/mbart" rel="nofollow">mBART</a></strong> (from Facebook) released with the paper <a href="https://arxiv.org/abs/2001.08210" rel="nofollow">Multilingual Denoising Pre-training for Neural Machine Translation</a> by Yinhan Liu, Jiatao Gu, Naman Goyal, Xian Li, Sergey Edunov, Marjan Ghazvininejad, Mike Lewis, Luke Zettlemoyer.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/mbart" rel="nofollow">mBART-50</a></strong> (from Facebook) released with the paper <a href="https://arxiv.org/abs/2008.00401" rel="nofollow">Multilingual Translation with Extensible Multilingual Pretraining and Finetuning</a> by Yuqing Tang, Chau Tran, Xian Li, Peng-Jen Chen, Naman Goyal, Vishrav Chaudhary, Jiatao Gu, Angela Fan.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/mms" rel="nofollow">MMS</a></strong> (from Facebook) released with the paper <a href="https://arxiv.org/abs/2305.13516" rel="nofollow">Scaling Speech Technology to 1,000+ Languages</a> by Vineel Pratap, Andros Tjandra, Bowen Shi, Paden Tomasello, Arun Babu, Sayani Kundu, Ali Elkahky, Zhaoheng Ni, Apoorv Vyas, Maryam Fazel-Zarandi, Alexei Baevski, Yossi Adi, Xiaohui Zhang, Wei-Ning Hsu, Alexis Conneau, Michael Auli.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/mobilebert" rel="nofollow">MobileBERT</a></strong> (from CMU/Google Brain) released with the paper <a href="https://arxiv.org/abs/2004.02984" rel="nofollow">MobileBERT: a Compact Task-Agnostic BERT for Resource-Limited Devices</a> by Zhiqing Sun, Hongkun Yu, Xiaodan Song, Renjie Liu, Yiming Yang, and Denny Zhou.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/mobilevit" rel="nofollow">MobileViT</a></strong> (from Apple) released with the paper <a href="https://arxiv.org/abs/2110.02178" rel="nofollow">MobileViT: Light-weight, General-purpose, and Mobile-friendly Vision Transformer</a> by Sachin Mehta and Mohammad Rastegari.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/mpnet" rel="nofollow">MPNet</a></strong> (from Microsoft Research) released with the paper <a href="https://arxiv.org/abs/2004.09297" rel="nofollow">MPNet: Masked and Permuted Pre-training for Language Understanding</a> by Kaitao Song, Xu Tan, Tao Qin, Jianfeng Lu, Tie-Yan Liu.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/mpt" rel="nofollow">MPT</a></strong> (from MosaiML) released with the repository <a href="https://github.com/mosaicml/llm-foundry/" rel="nofollow">llm-foundry</a> by the MosaicML NLP Team.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/mt5" rel="nofollow">MT5</a></strong> (from Google AI) released with the paper <a href="https://arxiv.org/abs/2010.11934" rel="nofollow">mT5: A massively multilingual pre-trained text-to-text transformer</a> by Linting Xue, Noah Constant, Adam Roberts, Mihir Kale, Rami Al-Rfou, Aditya Siddhant, Aditya Barua, Colin Raffel.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/nllb" rel="nofollow">NLLB</a></strong> (from Meta) released with the paper <a href="https://arxiv.org/abs/2207.04672" rel="nofollow">No Language Left Behind: Scaling Human-Centered Machine Translation</a> by the NLLB team.</li> <li><strong><a href="https://huggingface.co/docs/transformers/master/model_doc/opt" rel="nofollow">OPT</a></strong> (from Meta AI) released with the paper <a href="https://arxiv.org/abs/2205.01068" rel="nofollow">OPT: Open Pre-trained Transformer Language Models</a> by Susan Zhang, Stephen Roller, Naman Goyal, Mikel Artetxe, Moya Chen, Shuohui Chen et al.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/resnet" rel="nofollow">ResNet</a></strong> (from Microsoft Research) released with the paper <a href="https://arxiv.org/abs/1512.03385" rel="nofollow">Deep Residual Learning for Image Recognition</a> by Kaiming He, Xiangyu Zhang, Shaoqing Ren, Jian Sun.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/roberta" rel="nofollow">RoBERTa</a></strong> (from Facebook), released together with the paper <a href="https://arxiv.org/abs/1907.11692" rel="nofollow">RoBERTa: A Robustly Optimized BERT Pretraining Approach</a> by Yinhan Liu, Myle Ott, Naman Goyal, Jingfei Du, Mandar Joshi, Danqi Chen, Omer Levy, Mike Lewis, Luke Zettlemoyer, Veselin Stoyanov.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/speecht5" rel="nofollow">SpeechT5</a></strong> (from Microsoft Research) released with the paper <a href="https://arxiv.org/abs/2110.07205" rel="nofollow">SpeechT5: Unified-Modal Encoder-Decoder Pre-Training for Spoken Language Processing</a> by Junyi Ao, Rui Wang, Long Zhou, Chengyi Wang, Shuo Ren, Yu Wu, Shujie Liu, Tom Ko, Qing Li, Yu Zhang, Zhihua Wei, Yao Qian, Jinyu Li, Furu Wei.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/squeezebert" rel="nofollow">SqueezeBERT</a></strong> (from Berkeley) released with the paper <a href="https://arxiv.org/abs/2006.11316" rel="nofollow">SqueezeBERT: What can computer vision teach NLP about efficient neural networks?</a> by Forrest N. Iandola, Albert E. Shaw, Ravi Krishna, and Kurt W. Keutzer.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/swin" rel="nofollow">Swin Transformer</a></strong> (from Microsoft) released with the paper <a href="https://arxiv.org/abs/2103.14030" rel="nofollow">Swin Transformer: Hierarchical Vision Transformer using Shifted Windows</a> by Ze Liu, Yutong Lin, Yue Cao, Han Hu, Yixuan Wei, Zheng Zhang, Stephen Lin, Baining Guo.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/t5" rel="nofollow">T5</a></strong> (from Google AI) released with the paper <a href="https://arxiv.org/abs/1910.10683" rel="nofollow">Exploring the Limits of Transfer Learning with a Unified Text-to-Text Transformer</a> by Colin Raffel and Noam Shazeer and Adam Roberts and Katherine Lee and Sharan Narang and Michael Matena and Yanqi Zhou and Wei Li and Peter J. Liu.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/t5v1.1" rel="nofollow">T5v1.1</a></strong> (from Google AI) released in the repository <a href="https://github.com/google-research/text-to-text-transfer-transformer/blob/main/released_checkpoints.md#t511" rel="nofollow">google-research/text-to-text-transfer-transformer</a> by Colin Raffel and Noam Shazeer and Adam Roberts and Katherine Lee and Sharan Narang and Michael Matena and Yanqi Zhou and Wei Li and Peter J. Liu.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/vit" rel="nofollow">Vision Transformer (ViT)</a></strong> (from Google AI) released with the paper <a href="https://arxiv.org/abs/2010.11929" rel="nofollow">An Image is Worth 16x16 Words: Transformers for Image Recognition at Scale</a> by Alexey Dosovitskiy, Lucas Beyer, Alexander Kolesnikov, Dirk Weissenborn, Xiaohua Zhai, Thomas Unterthiner, Mostafa Dehghani, Matthias Minderer, Georg Heigold, Sylvain Gelly, Jakob Uszkoreit, Neil Houlsby.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/wav2vec2" rel="nofollow">Wav2Vec2</a></strong> (from Facebook AI) released with the paper <a href="https://arxiv.org/abs/2006.11477" rel="nofollow">wav2vec 2.0: A Framework for Self-Supervised Learning of Speech Representations</a> by Alexei Baevski, Henry Zhou, Abdelrahman Mohamed, Michael Auli.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/wavlm" rel="nofollow">WavLM</a></strong> (from Microsoft Research) released with the paper <a href="https://arxiv.org/abs/2110.13900" rel="nofollow">WavLM: Large-Scale Self-Supervised Pre-Training for Full Stack Speech Processing</a> by Sanyuan Chen, Chengyi Wang, Zhengyang Chen, Yu Wu, Shujie Liu, Zhuo Chen, Jinyu Li, Naoyuki Kanda, Takuya Yoshioka, Xiong Xiao, Jian Wu, Long Zhou, Shuo Ren, Yanmin Qian, Yao Qian, Jian Wu, Michael Zeng, Furu Wei.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a></strong> (from OpenAI) released with the paper <a href="https://cdn.openai.com/papers/whisper.pdf" rel="nofollow">Robust Speech Recognition via Large-Scale Weak Supervision</a> by Alec Radford, Jong Wook Kim, Tao Xu, Greg Brockman, Christine McLeavey, Ilya Sutskever.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/xlm" rel="nofollow">XLM</a></strong> (from Facebook) released together with the paper <a href="https://arxiv.org/abs/1901.07291" rel="nofollow">Cross-lingual Language Model Pretraining</a> by Guillaume Lample and Alexis Conneau.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/xlm-roberta" rel="nofollow">XLM-RoBERTa</a></strong> (from Facebook AI), released together with the paper <a href="https://arxiv.org/abs/1911.02116" rel="nofollow">Unsupervised Cross-lingual Representation Learning at Scale</a> by Alexis Conneau<em>, Kartikay Khandelwal</em>, Naman Goyal, Vishrav Chaudhary, Guillaume Wenzek, Francisco Guzmán, Edouard Grave, Myle Ott, Luke Zettlemoyer and Veselin Stoyanov.</li> <li><strong><a href="https://huggingface.co/docs/transformers/model_doc/yolos" rel="nofollow">YOLOS</a></strong> (from Huazhong University of Science &amp; Technology) released with the paper <a href="https://arxiv.org/abs/2106.00666" rel="nofollow">You Only Look at One Sequence: Rethinking Transformer in Vision through Object Detection</a> by Yuxin Fang, Bencheng Liao, Xinggang Wang, Jiemin Fang, Jiyang Qi, Rui Wu, Jianwei Niu, Wenyu Liu.</li>',Ie,ne,He;return b=new p({props:{title:"Transformers.js",local:"transformersjs",headingTag:"h1"}}),k=new p({props:{title:"Quick tour",local:"quick-tour",headingTag:"h2"}}),A=new ze({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBJTIzJTIwQWxsb2NhdGUlMjBhJTIwcGlwZWxpbmUlMjBmb3IlMjBzZW50aW1lbnQtYW5hbHlzaXMlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJ3NlbnRpbWVudC1hbmFseXNpcycpJTBBJTBBb3V0JTIwJTNEJTIwcGlwZSgnSSUyMGxvdmUlMjB0cmFuc2Zvcm1lcnMhJyklMEElMjMlMjAlNUIlN0InbGFiZWwnJTNBJTIwJ1BPU0lUSVZFJyUyQyUyMCdzY29yZSclM0ElMjAwLjk5OTgwNjk0MSU3RCU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-comment"># Allocate a pipeline for sentiment-analysis</span>
pipe = pipeline(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>)

out = pipe(<span class="hljs-string">&#x27;I love transformers!&#x27;</span>)
<span class="hljs-comment"># [{&#x27;label&#x27;: &#x27;POSITIVE&#x27;, &#x27;score&#x27;: 0.999806941}]</span>`,wrap:!1}}),C=new ze({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMjAlN0QlMjBmcm9tJTIwJyU0MHhlbm92YSUyRnRyYW5zZm9ybWVycyclM0IlMEElMEElMkYlMkYlMjBBbGxvY2F0ZSUyMGElMjBwaXBlbGluZSUyMGZvciUyMHNlbnRpbWVudC1hbmFseXNpcyUwQWxldCUyMHBpcGUlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdzZW50aW1lbnQtYW5hbHlzaXMnKSUzQiUwQSUwQWxldCUyMG91dCUyMCUzRCUyMGF3YWl0JTIwcGlwZSgnSSUyMGxvdmUlMjB0cmFuc2Zvcm1lcnMhJyklM0IlMEElMkYlMkYlMjAlNUIlN0InbGFiZWwnJTNBJTIwJ1BPU0lUSVZFJyUyQyUyMCdzY29yZSclM0ElMjAwLjk5OTgxNzY4NiU3RCU1RA==",highlighted:`<span class="hljs-keyword">import</span> { pipeline } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@xenova/transformers&#x27;</span>;

<span class="hljs-comment">// Allocate a pipeline for sentiment-analysis</span>
<span class="hljs-keyword">let</span> pipe = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>);

<span class="hljs-keyword">let</span> out = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipe</span>(<span class="hljs-string">&#x27;I love transformers!&#x27;</span>);
<span class="hljs-comment">// [{&#x27;label&#x27;: &#x27;POSITIVE&#x27;, &#x27;score&#x27;: 0.999817686}]</span>`,wrap:!1}}),R=new ze({props:{code:"JTJGJTJGJTIwVXNlJTIwYSUyMGRpZmZlcmVudCUyMG1vZGVsJTIwZm9yJTIwc2VudGltZW50LWFuYWx5c2lzJTBBbGV0JTIwcGlwZSUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3NlbnRpbWVudC1hbmFseXNpcyclMkMlMjAnbmxwdG93biUyRmJlcnQtYmFzZS1tdWx0aWxpbmd1YWwtdW5jYXNlZC1zZW50aW1lbnQnKSUzQg==",highlighted:`<span class="hljs-comment">// Use a different model for sentiment-analysis</span>
<span class="hljs-keyword">let</span> pipe = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>, <span class="hljs-string">&#x27;nlptown/bert-base-multilingual-uncased-sentiment&#x27;</span>);`,wrap:!1}}),j=new p({props:{title:"Contents",local:"contents",headingTag:"h2"}}),$=new p({props:{title:"Supported tasks/models",local:"supported-tasksmodels",headingTag:"h2"}}),J=new p({props:{title:"Tasks",local:"tasks",headingTag:"h3"}}),I=new p({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h4"}}),W=new p({props:{title:"Vision",local:"vision",headingTag:"h4"}}),F=new p({props:{title:"Audio",local:"audio",headingTag:"h4"}}),z=new p({props:{title:"Tabular",local:"tabular",headingTag:"h4"}}),Z=new p({props:{title:"Multimodal",local:"multimodal",headingTag:"h4"}}),V=new p({props:{title:"Reinforcement Learning",local:"reinforcement-learning",headingTag:"h4"}}),K=new p({props:{title:"Models",local:"models",headingTag:"h3"}}),{c(){u=i("meta"),re=n(),te=i("p"),ie=n(),h(b.$$.fragment),se=n(),y=i("p"),y.textContent=Ze,le=n(),T=i("p"),T.innerHTML=Ye,he=n(),v=i("ul"),v.innerHTML=Ve,ge=n(),M=i("p"),M.innerHTML=Xe,de=n(),x=i("p"),x.innerHTML=Ke,fe=n(),h(k.$$.fragment),ce=n(),L=i("p"),L.innerHTML=Oe,me=n(),w=i("table"),Q=i("tr"),Q.innerHTML=qe,Fe=n(),S=i("tr"),ae=i("td"),h(A.$$.fragment),Ne=n(),oe=i("td"),h(C.$$.fragment),pe=n(),_=i("p"),_.innerHTML=Qe,ue=n(),h(R.$$.fragment),we=n(),h(j.$$.fragment),be=n(),B=i("p"),B.textContent=et,ye=n(),G=i("ol"),G.innerHTML=tt,Te=n(),h($.$$.fragment),ve=n(),E=i("p"),E.innerHTML=at,Me=n(),P=i("p"),P.innerHTML=ot,xe=n(),h(J.$$.fragment),ke=n(),h(I.$$.fragment),Le=n(),H=i("table"),H.innerHTML=nt,Se=n(),h(W.$$.fragment),Ae=n(),D=i("table"),D.innerHTML=rt,Ce=n(),h(F.$$.fragment),_e=n(),N=i("table"),N.innerHTML=it,Re=n(),h(z.$$.fragment),je=n(),U=i("table"),U.innerHTML=st,Be=n(),h(Z.$$.fragment),Ge=n(),Y=i("table"),Y.innerHTML=lt,$e=n(),h(V.$$.fragment),Ee=n(),X=i("table"),X.innerHTML=ht,Pe=n(),h(K.$$.fragment),Je=n(),O=i("ol"),O.innerHTML=gt,Ie=n(),ne=i("p"),this.h()},l(e){const t=yt("svelte-u9bgzb",document.head);u=s(t,"META",{name:!0,content:!0}),t.forEach(a),re=r(e),te=s(e,"P",{}),ee(te).forEach(a),ie=r(e),g(b.$$.fragment,e),se=r(e),y=s(e,"P",{"data-svelte-h":!0}),l(y)!=="svelte-152v5jb"&&(y.textContent=Ze),le=r(e),T=s(e,"P",{"data-svelte-h":!0}),l(T)!=="svelte-olh0v"&&(T.innerHTML=Ye),he=r(e),v=s(e,"UL",{"data-svelte-h":!0}),l(v)!=="svelte-1pv05x3"&&(v.innerHTML=Ve),ge=r(e),M=s(e,"P",{"data-svelte-h":!0}),l(M)!=="svelte-ipd7z8"&&(M.innerHTML=Xe),de=r(e),x=s(e,"P",{"data-svelte-h":!0}),l(x)!=="svelte-1xcnsfs"&&(x.innerHTML=Ke),fe=r(e),g(k.$$.fragment,e),ce=r(e),L=s(e,"P",{"data-svelte-h":!0}),l(L)!=="svelte-bgtw6b"&&(L.innerHTML=Oe),me=r(e),w=s(e,"TABLE",{});var We=ee(w);Q=s(We,"TR",{"data-svelte-h":!0}),l(Q)!=="svelte-171mvpd"&&(Q.innerHTML=qe),Fe=r(We),S=s(We,"TR",{});var De=ee(S);ae=s(De,"TD",{});var dt=ee(ae);g(A.$$.fragment,dt),dt.forEach(a),Ne=r(De),oe=s(De,"TD",{});var ft=ee(oe);g(C.$$.fragment,ft),ft.forEach(a),De.forEach(a),We.forEach(a),pe=r(e),_=s(e,"P",{"data-svelte-h":!0}),l(_)!=="svelte-q6076l"&&(_.innerHTML=Qe),ue=r(e),g(R.$$.fragment,e),we=r(e),g(j.$$.fragment,e),be=r(e),B=s(e,"P",{"data-svelte-h":!0}),l(B)!=="svelte-18u0bwk"&&(B.textContent=et),ye=r(e),G=s(e,"OL",{"data-svelte-h":!0}),l(G)!=="svelte-1pokmay"&&(G.innerHTML=tt),Te=r(e),g($.$$.fragment,e),ve=r(e),E=s(e,"P",{"data-svelte-h":!0}),l(E)!=="svelte-zaysjl"&&(E.innerHTML=at),Me=r(e),P=s(e,"P",{"data-svelte-h":!0}),l(P)!=="svelte-1g0xvq3"&&(P.innerHTML=ot),xe=r(e),g(J.$$.fragment,e),ke=r(e),g(I.$$.fragment,e),Le=r(e),H=s(e,"TABLE",{"data-svelte-h":!0}),l(H)!=="svelte-1cx9utv"&&(H.innerHTML=nt),Se=r(e),g(W.$$.fragment,e),Ae=r(e),D=s(e,"TABLE",{"data-svelte-h":!0}),l(D)!=="svelte-4h860n"&&(D.innerHTML=rt),Ce=r(e),g(F.$$.fragment,e),_e=r(e),N=s(e,"TABLE",{"data-svelte-h":!0}),l(N)!=="svelte-vw70ih"&&(N.innerHTML=it),Re=r(e),g(z.$$.fragment,e),je=r(e),U=s(e,"TABLE",{"data-svelte-h":!0}),l(U)!=="svelte-1rd81se"&&(U.innerHTML=st),Be=r(e),g(Z.$$.fragment,e),Ge=r(e),Y=s(e,"TABLE",{"data-svelte-h":!0}),l(Y)!=="svelte-1b6cz3g"&&(Y.innerHTML=lt),$e=r(e),g(V.$$.fragment,e),Ee=r(e),X=s(e,"TABLE",{"data-svelte-h":!0}),l(X)!=="svelte-73s5wc"&&(X.innerHTML=ht),Pe=r(e),g(K.$$.fragment,e),Je=r(e),O=s(e,"OL",{"data-svelte-h":!0}),l(O)!=="svelte-6rxw1e"&&(O.innerHTML=gt),Ie=r(e),ne=s(e,"P",{}),ee(ne).forEach(a),this.h()},h(){ct(u,"name","hf:doc:metadata"),ct(u,"content",vt)},m(e,t){q(document.head,u),o(e,re,t),o(e,te,t),o(e,ie,t),d(b,e,t),o(e,se,t),o(e,y,t),o(e,le,t),o(e,T,t),o(e,he,t),o(e,v,t),o(e,ge,t),o(e,M,t),o(e,de,t),o(e,x,t),o(e,fe,t),d(k,e,t),o(e,ce,t),o(e,L,t),o(e,me,t),o(e,w,t),q(w,Q),q(w,Fe),q(w,S),q(S,ae),d(A,ae,null),q(S,Ne),q(S,oe),d(C,oe,null),o(e,pe,t),o(e,_,t),o(e,ue,t),d(R,e,t),o(e,we,t),d(j,e,t),o(e,be,t),o(e,B,t),o(e,ye,t),o(e,G,t),o(e,Te,t),d($,e,t),o(e,ve,t),o(e,E,t),o(e,Me,t),o(e,P,t),o(e,xe,t),d(J,e,t),o(e,ke,t),d(I,e,t),o(e,Le,t),o(e,H,t),o(e,Se,t),d(W,e,t),o(e,Ae,t),o(e,D,t),o(e,Ce,t),d(F,e,t),o(e,_e,t),o(e,N,t),o(e,Re,t),d(z,e,t),o(e,je,t),o(e,U,t),o(e,Be,t),d(Z,e,t),o(e,Ge,t),o(e,Y,t),o(e,$e,t),d(V,e,t),o(e,Ee,t),o(e,X,t),o(e,Pe,t),d(K,e,t),o(e,Je,t),o(e,O,t),o(e,Ie,t),o(e,ne,t),He=!0},p:pt,i(e){He||(f(b.$$.fragment,e),f(k.$$.fragment,e),f(A.$$.fragment,e),f(C.$$.fragment,e),f(R.$$.fragment,e),f(j.$$.fragment,e),f($.$$.fragment,e),f(J.$$.fragment,e),f(I.$$.fragment,e),f(W.$$.fragment,e),f(F.$$.fragment,e),f(z.$$.fragment,e),f(Z.$$.fragment,e),f(V.$$.fragment,e),f(K.$$.fragment,e),He=!0)},o(e){c(b.$$.fragment,e),c(k.$$.fragment,e),c(A.$$.fragment,e),c(C.$$.fragment,e),c(R.$$.fragment,e),c(j.$$.fragment,e),c($.$$.fragment,e),c(J.$$.fragment,e),c(I.$$.fragment,e),c(W.$$.fragment,e),c(F.$$.fragment,e),c(z.$$.fragment,e),c(Z.$$.fragment,e),c(V.$$.fragment,e),c(K.$$.fragment,e),He=!1},d(e){e&&(a(re),a(te),a(ie),a(se),a(y),a(le),a(T),a(he),a(v),a(ge),a(M),a(de),a(x),a(fe),a(ce),a(L),a(me),a(w),a(pe),a(_),a(ue),a(we),a(be),a(B),a(ye),a(G),a(Te),a(ve),a(E),a(Me),a(P),a(xe),a(ke),a(Le),a(H),a(Se),a(Ae),a(D),a(Ce),a(_e),a(N),a(Re),a(je),a(U),a(Be),a(Ge),a(Y),a($e),a(Ee),a(X),a(Pe),a(Je),a(O),a(Ie),a(ne)),a(u),m(b,e),m(k,e),m(A),m(C),m(R,e),m(j,e),m($,e),m(J,e),m(I,e),m(W,e),m(F,e),m(z,e),m(Z,e),m(V,e),m(K,e)}}}const vt='{"title":"Transformers.js","local":"transformersjs","sections":[{"title":"Quick tour","local":"quick-tour","sections":[],"depth":2},{"title":"Contents","local":"contents","sections":[],"depth":2},{"title":"Supported tasks/models","local":"supported-tasksmodels","sections":[{"title":"Tasks","local":"tasks","sections":[{"title":"Natural Language Processing","local":"natural-language-processing","sections":[],"depth":4},{"title":"Vision","local":"vision","sections":[],"depth":4},{"title":"Audio","local":"audio","sections":[],"depth":4},{"title":"Tabular","local":"tabular","sections":[],"depth":4},{"title":"Multimodal","local":"multimodal","sections":[],"depth":4},{"title":"Reinforcement Learning","local":"reinforcement-learning","sections":[],"depth":4}],"depth":3},{"title":"Models","local":"models","sections":[],"depth":3}],"depth":2}],"depth":1}';function Mt(Ue){return ut(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class At extends wt{constructor(u){super(),bt(this,u,Mt,Tt,mt,{})}}export{At as component};
