import{s as cJ,n as rJ,o as MJ}from"../chunks/scheduler.b108d059.js";import{S as mJ,i as TJ,g as a,s as i,r as c,A as yJ,h as p,f as l,c as n,j as u,u as r,x as o,k as d,y as uJ,a as s,v as M,d as m,t as T,w as y}from"../chunks/index.008de539.js";import{C as h}from"../chunks/CodeBlock.3968c746.js";import{H as J}from"../chunks/Heading.88bfeb84.js";function JJ(Hm){let w,Gn,kn,vn,j,Zn,U,Qn,f,Wm="Pipelines provide a high-level, easy to use, API for running machine learning models.",An,b,zm="<strong>Example:</strong> Instantiate pipeline using the <code>pipeline</code> function.",Nn,x,_n,C,Sm='<li><a href="#module_pipelines">pipelines</a><ul><li><em>static</em><ul><li><a href="#module_pipelines.Pipeline">.Pipeline</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_pipelines.Pipeline_new"><code>new Pipeline(options)</code></a></li> <li><a href="#module_pipelines.Pipeline+dispose"><code>.dispose()</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li> <li><a href="#module_pipelines.Pipeline+_call"><code>._call(texts, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.TextClassificationPipeline">.TextClassificationPipeline</a><ul><li><a href="#module_pipelines.TextClassificationPipeline+_call"><code>._call(texts, options)</code></a> ⇒ <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code></li></ul></li> <li><a href="#module_pipelines.TokenClassificationPipeline">.TokenClassificationPipeline</a><ul><li><a href="#module_pipelines.TokenClassificationPipeline+_call"><code>._call(texts, options)</code></a> ⇒ <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code></li></ul></li> <li><a href="#module_pipelines.QuestionAnsweringPipeline">.QuestionAnsweringPipeline</a><ul><li><a href="#module_pipelines.QuestionAnsweringPipeline+_call"><code>._call(question, context, options)</code></a> ⇒ <code>QuestionAnsweringReturnType</code></li></ul></li> <li><a href="#module_pipelines.FillMaskPipeline">.FillMaskPipeline</a><ul><li><a href="#module_pipelines.FillMaskPipeline+_call"><code>._call(texts, options)</code></a> ⇒ <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code></li></ul></li> <li><a href="#module_pipelines.Text2TextGenerationPipeline">.Text2TextGenerationPipeline</a><ul><li><a href="#module_pipelines.Text2TextGenerationPipeline+_call"><code>._call(texts, [options])</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.SummarizationPipeline">.SummarizationPipeline</a></li> <li><a href="#module_pipelines.TranslationPipeline">.TranslationPipeline</a></li> <li><a href="#module_pipelines.TextGenerationPipeline">.TextGenerationPipeline</a><ul><li><a href="#module_pipelines.TextGenerationPipeline+_call"><code>._call(texts, [generate_kwargs])</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.ZeroShotClassificationPipeline">.ZeroShotClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotClassificationPipeline_new"><code>new ZeroShotClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotClassificationPipeline+_call"><code>._call(texts, candidate_labels, options)</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li> <li><a href="#module_pipelines.FeatureExtractionPipeline">.FeatureExtractionPipeline</a><ul><li><a href="#module_pipelines.FeatureExtractionPipeline+_call"><code>._call(texts, options)</code></a> ⇒</li></ul></li> <li><a href="#module_pipelines.AudioClassificationPipeline">.AudioClassificationPipeline</a><ul><li><a href="#new_module_pipelines.AudioClassificationPipeline_new"><code>new AudioClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.AudioClassificationPipeline+_call"><code>._call(audio, options)</code></a> ⇒ <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code></li></ul></li> <li><a href="#module_pipelines.AutomaticSpeechRecognitionPipeline">.AutomaticSpeechRecognitionPipeline</a><ul><li><a href="#new_module_pipelines.AutomaticSpeechRecognitionPipeline_new"><code>new AutomaticSpeechRecognitionPipeline(options)</code></a></li> <li><a href="#module_pipelines.AutomaticSpeechRecognitionPipeline+_call"><code>._call(audio, [kwargs])</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li> <li><a href="#module_pipelines.ImageToTextPipeline">.ImageToTextPipeline</a><ul><li><a href="#new_module_pipelines.ImageToTextPipeline_new"><code>new ImageToTextPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageToTextPipeline+_call"><code>._call(images, [generate_kwargs])</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li> <li><a href="#module_pipelines.ImageClassificationPipeline">.ImageClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ImageClassificationPipeline_new"><code>new ImageClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageClassificationPipeline+_call"><code>._call(images, options)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.ImageSegmentationPipeline">.ImageSegmentationPipeline</a><ul><li><a href="#new_module_pipelines.ImageSegmentationPipeline_new"><code>new ImageSegmentationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageSegmentationPipeline+_call"><code>._call(images, options)</code></a> ⇒ <code>Promise.&lt;Array&gt;</code></li></ul></li> <li><a href="#module_pipelines.ZeroShotImageClassificationPipeline">.ZeroShotImageClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotImageClassificationPipeline_new"><code>new ZeroShotImageClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotImageClassificationPipeline+_call"><code>._call(images, candidate_labels, options)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_pipelines.ObjectDetectionPipeline">.ObjectDetectionPipeline</a><ul><li><a href="#new_module_pipelines.ObjectDetectionPipeline_new"><code>new ObjectDetectionPipeline(options)</code></a></li> <li><a href="#module_pipelines.ObjectDetectionPipeline+_call"><code>._call(images, options)</code></a></li></ul></li> <li><a href="#module_pipelines.DocumentQuestionAnsweringPipeline">.DocumentQuestionAnsweringPipeline</a><ul><li><a href="#new_module_pipelines.DocumentQuestionAnsweringPipeline_new"><code>new DocumentQuestionAnsweringPipeline(options)</code></a></li> <li><a href="#module_pipelines.DocumentQuestionAnsweringPipeline+_call"><code>._call(image, question, [generate_kwargs])</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li> <li><a href="#module_pipelines.TextToAudioPipeline">.TextToAudioPipeline</a><ul><li><a href="#new_module_pipelines.TextToAudioPipeline_new"><code>new TextToAudioPipeline(options)</code></a></li> <li><a href="#module_pipelines.TextToAudioPipeline+_call"><code>._call(text_inputs, options)</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li> <li><a href="#module_pipelines.pipeline"><code>.pipeline(task, [model], [options])</code></a> ⇒ <code>Promise.&lt;Pipeline&gt;</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_pipelines..QuestionAnsweringResult"><code>~QuestionAnsweringResult</code></a> : <code>object</code></li> <li><a href="#module_pipelines..QuestionAnsweringReturnType"><code>~QuestionAnsweringReturnType</code></a> : <code>Promise.&lt;(QuestionAnsweringResult|Array&lt;QuestionAnsweringResult&gt;)&gt;</code></li> <li><a href="#module_pipelines..ChunkCallback"><code>~ChunkCallback</code></a> : <code>function</code></li></ul></li></ul></li>',$n,Rn,Yn,g,Vn,I,Pn,k,Xm=`The Pipeline class is the class from which all pipelines inherit.
Refer to this class for methods shared across different pipelines.`,En,B,Lm='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Extends</strong>: <code>Callable</code>',Hn,G,Fm='<li><a href="#module_pipelines.Pipeline">.Pipeline</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_pipelines.Pipeline_new"><code>new Pipeline(options)</code></a></li> <li><a href="#module_pipelines.Pipeline+dispose"><code>.dispose()</code></a> ⇒ <code>Promise.&lt;void&gt;</code></li> <li><a href="#module_pipelines.Pipeline+_call"><code>._call(texts, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',Wn,zn,Sn,v,Xn,Z,Ln,Q,Dm="Create a new Pipeline.",Fn,A,qm="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><code></code></td><td><p>The tokenizer to use (if any).</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><code></code></td><td><p>The processor to use (if any).</p></td></tr></tbody>",Dn,qn,On,N,Kn,_,ea,$,Om="Disposes the model.",ta,R,Km='<strong>Kind</strong>: instance method of <a href="#module_pipelines.Pipeline"><code>Pipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;void&gt;</code> - A promise that resolves when the model has been disposed.',la,sa,ia,Y,na,V,aa,P,eT="Executes the task associated with the pipeline.",pa,E,tT='<strong>Kind</strong>: instance method of <a href="#module_pipelines.Pipeline"><code>Pipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A promise that resolves to an array containing the inputs and outputs of the task.',oa,H,lT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>any</code></td><td><p>The input texts to be processed.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",da,ca,ra,W,Ma,z,ma,S,sT="Text classification pipeline using any <code>ModelForSequenceClassification</code>.",Ta,X,iT="<strong>Example:</strong> Sentiment-analysis w/ <code>Xenova/distilbert-base-uncased-finetuned-sst-2-english</code>.",ya,L,ua,F,nT="<strong>Example:</strong> Multilingual sentiment-analysis w/ <code>Xenova/bert-base-multilingual-uncased-sentiment</code> (and return top 5 classes).",Ja,D,ha,q,aT="<strong>Example:</strong> Toxic comment classification w/ <code>Xenova/toxic-bert</code> (and return all classes).",wa,O,ja,K,pT='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Ua,fa,ba,ee,xa,te,Ca,le,oT="Executes the text classification task.",ga,se,dT='<strong>Kind</strong>: instance method of <a href="#module_pipelines.TextClassificationPipeline"><code>TextClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code> - A promise that resolves to an array or object containing the predicted labels and scores.',Ia,ie,cT="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>any</code></td><td></td><td><p>The input texts to be classified.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An optional object containing the following properties:</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>1</code></td><td><p>The number of top predictions to be returned.</p></td></tr></tbody>",ka,Ba,Ga,ne,va,ae,Za,pe,rT="Named Entity Recognition pipeline using any <code>ModelForTokenClassification</code>.",Qa,oe,MT="<strong>Example:</strong> Perform named entity recognition with <code>Xenova/bert-base-NER</code>.",Aa,de,Na,ce,mT="<strong>Example:</strong> Perform named entity recognition with <code>Xenova/bert-base-NER</code> (and return all labels).",_a,re,$a,Me,TT='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Ra,Ya,Va,me,Pa,Te,Ea,ye,yT="Executes the token classification task.",Ha,ue,uT='<strong>Kind</strong>: instance method of <a href="#module_pipelines.TokenClassificationPipeline"><code>TokenClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code> - A promise that resolves to an array or object containing the predicted labels and scores.',Wa,Je,JT="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>any</code></td><td><p>The input texts to be classified.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td><p>An optional object containing the following properties:</p></td></tr></tbody>",za,Sa,Xa,he,La,we,Fa,je,hT="Question Answering pipeline using any <code>ModelForQuestionAnswering</code>.",Da,Ue,wT="<strong>Example:</strong> Run question answering with <code>Xenova/distilbert-base-uncased-distilled-squad</code>.",qa,fe,Oa,be,jT='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Ka,ep,tp,xe,lp,Ce,sp,ge,UT="Executes the question answering task.",ip,Ie,fT=`<strong>Kind</strong>: instance method of <a href="#module_pipelines.QuestionAnsweringPipeline"><code>QuestionAnsweringPipeline</code></a><br/> <strong>Returns</strong>: <code>QuestionAnsweringReturnType</code> - A promise that resolves to an array or object
containing the predicted answers and scores.`,np,ke,bT="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>question</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td></td><td><p>The question(s) to be answered.</p></td> </tr><tr><td>context</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td></td><td><p>The context(s) where the answer(s) can be found.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An optional object containing the following properties:</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>1</code></td><td><p>The number of top answer predictions to be returned.</p></td></tr></tbody>",ap,pp,op,Be,dp,Ge,cp,ve,xT="Masked language modeling prediction pipeline using any <code>ModelWithLMHead</code>.",rp,Ze,CT="<strong>Example:</strong> Perform masked language modelling (a.k.a. “fill-mask”) with <code>Xenova/bert-base-uncased</code>.",Mp,Qe,mp,Ae,gT="<strong>Example:</strong> Perform masked language modelling (a.k.a. “fill-mask”) with <code>Xenova/bert-base-cased</code> (and return top result).",Tp,Ne,yp,_e,IT='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',up,Jp,hp,$e,wp,Re,jp,Ye,kT="Fill the masked token in the text(s) given as inputs.",Up,Ve,BT='<strong>Kind</strong>: instance method of <a href="#module_pipelines.FillMaskPipeline"><code>FillMaskPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code> - A promise that resolves to an array or object containing the predicted tokens and scores.',fp,Pe,GT="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>any</code></td><td></td><td><p>The masked input texts.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An optional object containing the following properties:</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>5</code></td><td><p>The number of top predictions to be returned.</p></td></tr></tbody>",bp,xp,Cp,Ee,gp,He,Ip,We,vT="Text2TextGenerationPipeline class for generating text using a model that performs text-to-text generation tasks.",kp,ze,ZT="<strong>Example:</strong> Text-to-text generation w/ <code>Xenova/LaMini-Flan-T5-783M</code>.",Bp,Se,Gp,Xe,QT='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',vp,Zp,Qp,Le,Ap,Fe,Np,De,AT="Fill the masked token in the text(s) given as inputs.",_p,qe,NT=`<strong>Kind</strong>: instance method of <a href="#module_pipelines.Text2TextGenerationPipeline"><code>Text2TextGenerationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - An array of objects containing the score, predicted token, predicted token string,
and the sequence with the predicted token filled in, or an array of such arrays (one for each input text).
If only one input text is given, the output will be an array of objects.<br/> <strong>Throws</strong>:`,$p,Oe,_T="<li><code>Error</code> When the mask token is not found in the input text.</li>",Rp,Ke,$T="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td></td><td><p>The text or array of texts to be processed.</p></td> </tr><tr><td>[options]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Options for the fill-mask pipeline.</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>5</code></td><td><p>The number of top-k predictions to return.</p></td></tr></tbody>",Yp,Vp,Pp,et,Ep,tt,Hp,lt,RT="A pipeline for summarization tasks, inheriting from Text2TextGenerationPipeline.",Wp,st,YT="<strong>Example:</strong> Summarization w/ <code>Xenova/distilbart-cnn-6-6</code>.",zp,it,Sp,nt,VT='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Xp,Lp,Fp,at,Dp,pt,qp,ot,PT="Translates text from one language to another.",Op,dt,ET="<strong>Example:</strong> Multilingual translation w/ <code>Xenova/nllb-200-distilled-600M</code>.",Kp,ct,HT=`See <a href="https://github.com/facebookresearch/flores/blob/main/flores200/README.md#languages-in-flores-200" rel="nofollow">here</a>
for the full list of languages and their corresponding codes.`,eo,rt,to,Mt,WT="<strong>Example:</strong> Multilingual translation w/ <code>Xenova/m2m100_418M</code>.",lo,mt,zT=`See <a href="https://huggingface.co/facebook/m2m100_418M#languages-covered" rel="nofollow">here</a>
for the full list of languages and their corresponding codes.`,so,Tt,io,yt,ST="<strong>Example:</strong> Multilingual translation w/ <code>Xenova/mbart-large-50-many-to-many-mmt</code>.",no,ut,XT=`See <a href="https://huggingface.co/facebook/mbart-large-50-many-to-many-mmt#languages-covered" rel="nofollow">here</a>
for the full list of languages and their corresponding codes.`,ao,Jt,po,ht,LT='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',oo,co,ro,wt,Mo,jt,mo,Ut,FT=`Language generation pipeline using any <code>ModelWithLMHead</code> or <code>ModelForCausalLM</code>.
This pipeline predicts the words that will follow a specified text prompt.
NOTE: For the full list of generation parameters, see <a href="./utils/generation#module_utils/generation.GenerationConfig"><code>GenerationConfig</code></a>.`,To,ft,DT="<strong>Example:</strong> Text generation with <code>Xenova/distilgpt2</code> (default settings).",yo,bt,uo,xt,qT="<strong>Example:</strong> Text generation with <code>Xenova/distilgpt2</code> (custom settings).",Jo,Ct,ho,gt,OT="<strong>Example:</strong> Run code generation with <code>Xenova/codegen-350M-mono</code>.",wo,It,jo,kt,KT='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Uo,fo,bo,Bt,xo,Gt,Co,vt,ey="Generates text based on an input prompt.",go,Zt,ty='<strong>Kind</strong>: instance method of <a href="#module_pipelines.TextGenerationPipeline"><code>TextGenerationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - The generated text or texts.',Io,Qt,ly="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>any</code></td><td></td><td><p>The input prompt or prompts to generate text from.</p></td> </tr><tr><td>[generate_kwargs]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Additional arguments for text generation.</p></td></tr></tbody>",ko,Bo,Go,At,vo,Nt,Zo,_t,sy=`NLI-based zero-shot classification pipeline using a <code>ModelForSequenceClassification</code>
trained on NLI (natural language inference) tasks. Equivalent of <code>text-classification</code>
pipelines, but these models don’t require a hardcoded number of potential classes, they
can be chosen at runtime. It usually means it’s slower but it is <strong>much</strong> more flexible.`,Qo,$t,iy="<strong>Example:</strong> Zero shot classification with <code>Xenova/mobilebert-uncased-mnli</code>.",Ao,Rt,No,Yt,ny="<strong>Example:</strong> Zero shot classification with <code>Xenova/nli-deberta-v3-xsmall</code> (multi-label).",_o,Vt,$o,Pt,ay='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Ro,Et,py='<li><a href="#module_pipelines.ZeroShotClassificationPipeline">.ZeroShotClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotClassificationPipeline_new"><code>new ZeroShotClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotClassificationPipeline+_call"><code>._call(texts, candidate_labels, options)</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li>',Yo,Vo,Po,Ht,Eo,Wt,Ho,zt,oy="Create a new ZeroShotClassificationPipeline.",Wo,St,dy="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td></tr></tbody>",zo,So,Xo,Xt,Lo,Lt,Fo,Ft,cy='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ZeroShotClassificationPipeline"><code>ZeroShotClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code> - The prediction(s), as a map (or list of maps) from label to score.',Do,Dt,ry=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>Array.&lt;any&gt;</code></td><td></td><td></td> </tr><tr><td>candidate_labels</td><td><code>Array.&lt;string&gt;</code></td><td></td><td></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>Additional options:</p></td> </tr><tr><td>[options.hypothesis_template]</td><td><code>string</code></td><td><code>&quot;&quot;This example is {}.&quot;&quot;</code></td><td><p>The template used to turn each
candidate label into an NLI-style hypothesis. The candidate label will replace the &amp;#123;} placeholder.</p></td> </tr><tr><td>[options.multi_label]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not multiple candidate labels can be true.
If <code>false</code>, the scores are normalized such that the sum of the label likelihoods for each sequence
is 1. If <code>true</code>, the labels are considered independent and probabilities are normalized for each
candidate by doing a softmax of the entailment score vs. the contradiction score.</p></td></tr></tbody>`,qo,Oo,Ko,qt,ed,Ot,td,Kt,My=`Feature extraction pipeline using no model head. This pipeline extracts the hidden
states from the base transformer, which can be used as features in downstream tasks.`,ld,el,my="<strong>Example:</strong> Run feature extraction with <code>bert-base-uncased</code> (without pooling/normalization).",sd,tl,id,ll,Ty="<strong>Example:</strong> Run feature extraction with <code>bert-base-uncased</code> (with pooling/normalization).",nd,sl,ad,il,yy="<strong>Example:</strong> Calculating embeddings with <code>sentence-transformers</code> models.",pd,nl,od,al,uy='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',dd,cd,rd,pl,Md,ol,md,dl,Jy="Extract the features of the input(s).",Td,cl,hy='<strong>Kind</strong>: instance method of <a href="#module_pipelines.FeatureExtractionPipeline"><code>FeatureExtractionPipeline</code></a><br/> <strong>Returns</strong>: The features computed by the model.',yd,rl,wy="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>texts</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td></td><td><p>The input texts</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>Additional options:</p></td> </tr><tr><td>[options.pooling]</td><td><code>string</code></td><td><code>&quot;&quot;none&quot;&quot;</code></td><td><p>The pooling method to use. Can be one of: &quot;none&quot;, &quot;mean&quot;.</p></td> </tr><tr><td>[options.normalize]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether or not to normalize the embeddings in the last dimension.</p></td></tr></tbody>",ud,Jd,hd,Ml,wd,ml,jd,Tl,jy=`Audio classification pipeline using any <code>AutoModelForAudioClassification</code>.
This pipeline predicts the class of a raw waveform or an audio file.`,Ud,yl,Uy="<strong>Example:</strong> Perform audio classification.",fd,ul,bd,Jl,fy='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',xd,hl,by='<li><a href="#module_pipelines.AudioClassificationPipeline">.AudioClassificationPipeline</a><ul><li><a href="#new_module_pipelines.AudioClassificationPipeline_new"><code>new AudioClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.AudioClassificationPipeline+_call"><code>._call(audio, options)</code></a> ⇒ <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code></li></ul></li>',Cd,gd,Id,wl,kd,jl,Bd,Ul,xy="Create a new AudioClassificationPipeline.",Gd,fl,Cy="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",vd,Zd,Qd,bl,Ad,xl,Nd,Cl,gy="Executes the audio classification task.",_d,gl,Iy='<strong>Kind</strong>: instance method of <a href="#module_pipelines.AudioClassificationPipeline"><code>AudioClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Array&lt;Object&gt;|Object)&gt;</code> - A promise that resolves to an array or object containing the predicted labels and scores.',$d,Il,ky="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>audio</td><td><code>any</code></td><td></td><td><p>The input audio files to be classified.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>An optional object containing the following properties:</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>5</code></td><td><p>The number of top predictions to be returned.</p></td></tr></tbody>",Rd,Yd,Vd,kl,Pd,Bl,Ed,Gl,By="Pipeline that aims at extracting spoken text contained within some audio.",Hd,vl,Gy="<strong>Example:</strong> Transcribe English.",Wd,Zl,zd,Ql,vy="<strong>Example:</strong> Transcribe English w/ timestamps.",Sd,Al,Xd,Nl,Zy="<strong>Example:</strong> Transcribe English w/ word-level timestamps.",Ld,_l,Fd,$l,Qy="<strong>Example:</strong> Transcribe French.",Dd,Rl,qd,Yl,Ay="<strong>Example:</strong> Translate French to English.",Od,Vl,Kd,Pl,Ny="<strong>Example:</strong> Transcribe/translate audio longer than 30 seconds.",ec,El,tc,Hl,_y='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',lc,Wl,$y='<li><a href="#module_pipelines.AutomaticSpeechRecognitionPipeline">.AutomaticSpeechRecognitionPipeline</a><ul><li><a href="#new_module_pipelines.AutomaticSpeechRecognitionPipeline_new"><code>new AutomaticSpeechRecognitionPipeline(options)</code></a></li> <li><a href="#module_pipelines.AutomaticSpeechRecognitionPipeline+_call"><code>._call(audio, [kwargs])</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li>',sc,ic,nc,zl,ac,Sl,pc,Xl,Ry="Create a new AutomaticSpeechRecognitionPipeline.",oc,Ll,Yy="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",dc,cc,rc,Fl,Mc,Dl,mc,ql,Vy="Asynchronously processes audio and generates text transcription using the model.",Tc,Ol,Py='<strong>Kind</strong>: instance method of <a href="#module_pipelines.AutomaticSpeechRecognitionPipeline"><code>AutomaticSpeechRecognitionPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Object&gt;</code> - A Promise that resolves to an object containing the transcription text and optionally timestamps if <code>return_timestamps</code> is <code>true</code>.',yc,Kl,Ey=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>audio</td><td><code>Float32Array</code> | <code>Array&lt;Float32Array&gt;</code></td><td></td><td><p>The audio to be transcribed. Can be a single Float32Array or an array of Float32Arrays.</p></td> </tr><tr><td>[kwargs]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Optional arguments.</p></td> </tr><tr><td>[kwargs.return_timestamps]</td><td><code>boolean</code> | <code>&#39;word&#39;</code></td><td></td><td><p>Whether to return timestamps or not. Default is <code>false</code>.</p></td> </tr><tr><td>[kwargs.chunk_length_s]</td><td><code>number</code></td><td></td><td><p>The length of audio chunks to process in seconds. Default is 0 (no chunking).</p></td> </tr><tr><td>[kwargs.stride_length_s]</td><td><code>number</code></td><td></td><td><p>The length of overlap between consecutive audio chunks in seconds. If not provided, defaults to <code>chunk_length_s / 6</code>.</p></td> </tr><tr><td>[kwargs.chunk_callback]</td><td><code>ChunkCallback</code></td><td></td><td><p>Callback function to be called with each chunk processed.</p></td> </tr><tr><td>[kwargs.force_full_sequences]</td><td><code>boolean</code></td><td></td><td><p>Whether to force outputting full sequences or not. Default is <code>false</code>.</p></td> </tr><tr><td>[kwargs.language]</td><td><code>string</code></td><td></td><td><p>The source language. Default is <code>null</code>, meaning it should be auto-detected. Use this to potentially improve performance if the source language is known.</p></td> </tr><tr><td>[kwargs.task]</td><td><code>string</code></td><td></td><td><p>The task to perform. Default is <code>null</code>, meaning it should be auto-detected.</p></td> </tr><tr><td>[kwargs.forced_decoder_ids]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td></td><td><p>A list of pairs of integers which indicates a mapping from generation indices to token indices
that will be forced before sampling. For example, [[1, 123]] means the second generated token will always be a token of index 123.</p></td></tr></tbody>`,uc,Jc,hc,es,wc,ts,jc,ls,Hy="Image To Text pipeline using a <code>AutoModelForVision2Seq</code>. This pipeline predicts a caption for a given image.",Uc,ss,Wy="<strong>Example:</strong> Generate a caption for an image w/ <code>Xenova/vit-gpt2-image-captioning</code>.",fc,is,bc,ns,zy='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',xc,as,Sy='<li><a href="#module_pipelines.ImageToTextPipeline">.ImageToTextPipeline</a><ul><li><a href="#new_module_pipelines.ImageToTextPipeline_new"><code>new ImageToTextPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageToTextPipeline+_call"><code>._call(images, [generate_kwargs])</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li>',Cc,gc,Ic,ps,kc,os,Bc,ds,Xy="Create a new ImageToTextPipeline.",Gc,cs,Ly="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",vc,Zc,Qc,rs,Ac,Ms,Nc,ms,Fy="Assign labels to the image(s) passed as inputs.",_c,Ts,Dy='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ImageToTextPipeline"><code>ImageToTextPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code> - A Promise that resolves to an object (or array of objects) containing the generated text(s).',$c,ys,qy="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;any&gt;</code></td><td></td><td><p>The images to be captioned.</p></td> </tr><tr><td>[generate_kwargs]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Optional generation arguments.</p></td></tr></tbody>",Rc,Yc,Vc,us,Pc,Js,Ec,hs,Oy=`Image classification pipeline using any <code>AutoModelForImageClassification</code>.
This pipeline predicts the class of an image.`,Hc,ws,Ky="<strong>Example:</strong> Classify an image.",Wc,js,zc,Us,eu="<strong>Example:</strong> Classify an image and return top <code>n</code> classes.",Sc,fs,Xc,bs,tu="<strong>Example:</strong> Classify an image and return all classes.",Lc,xs,Fc,Cs,lu='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Dc,gs,su='<li><a href="#module_pipelines.ImageClassificationPipeline">.ImageClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ImageClassificationPipeline_new"><code>new ImageClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageClassificationPipeline+_call"><code>._call(images, options)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',qc,Oc,Kc,Is,er,ks,tr,Bs,iu="Create a new ImageClassificationPipeline.",lr,Gs,nu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",sr,ir,nr,vs,ar,Zs,pr,Qs,au="Classify the given images.",or,As,pu='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ImageClassificationPipeline"><code>ImageClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - The top classification results for the images.',dr,Ns,ou="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>any</code></td><td></td><td><p>The images to classify.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options to use for classification.</p></td> </tr><tr><td>[options.topk]</td><td><code>number</code></td><td><code>1</code></td><td><p>The number of top results to return.</p></td></tr></tbody>",cr,rr,Mr,_s,mr,$s,Tr,Rs,du=`Image segmentation pipeline using any <code>AutoModelForXXXSegmentation</code>.
This pipeline predicts masks of objects and their classes.`,yr,Ys,cu="<strong>Example:</strong> Perform image segmentation with <code>Xenova/detr-resnet-50-panoptic</code>.",ur,Vs,Jr,Ps,ru='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',hr,Es,Mu='<li><a href="#module_pipelines.ImageSegmentationPipeline">.ImageSegmentationPipeline</a><ul><li><a href="#new_module_pipelines.ImageSegmentationPipeline_new"><code>new ImageSegmentationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ImageSegmentationPipeline+_call"><code>._call(images, options)</code></a> ⇒ <code>Promise.&lt;Array&gt;</code></li></ul></li>',wr,jr,Ur,Hs,fr,Ws,br,zs,mu="Create a new ImageSegmentationPipeline.",xr,Ss,Tu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",Cr,gr,Ir,Xs,kr,Ls,Br,Fs,yu="Segment the input images.",Gr,Ds,uu='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ImageSegmentationPipeline"><code>ImageSegmentationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Array&gt;</code> - The annotated segments.',vr,qs,Ju="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array</code></td><td></td><td><p>The input images.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options to use for segmentation.</p></td> </tr><tr><td>[options.threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>Probability threshold to filter out predicted masks.</p></td> </tr><tr><td>[options.mask_threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>Threshold to use when turning the predicted masks into binary values.</p></td> </tr><tr><td>[options.overlap_mask_area_threshold]</td><td><code>number</code></td><td><code>0.8</code></td><td><p>Mask overlap threshold to eliminate small, disconnected segments.</p></td> </tr><tr><td>[options.subtask]</td><td><code>null</code> | <code>string</code></td><td><code></code></td><td><p>Segmentation task to be performed. One of [<code>panoptic</code>, <code>instance</code>, and <code>semantic</code>], depending on model capabilities. If not set, the pipeline will attempt to resolve (in that order).</p></td> </tr><tr><td>[options.label_ids_to_fuse]</td><td><code>Array</code></td><td><code></code></td><td><p>List of label ids to fuse. If not set, do not fuse any labels.</p></td> </tr><tr><td>[options.target_sizes]</td><td><code>Array</code></td><td><code></code></td><td><p>List of target sizes for the input images. If not set, use the original image sizes.</p></td></tr></tbody>",Zr,Qr,Ar,Os,Nr,Ks,_r,ei,hu=`Zero shot image classification pipeline. This pipeline predicts the class of
an image when you provide an image and a set of <code>candidate_labels</code>.`,$r,ti,wu="<strong>Example:</strong> Zero shot image classification w/ <code>Xenova/clip-vit-base-patch32</code>.",Rr,li,Yr,si,ju='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',Vr,ii,Uu='<li><a href="#module_pipelines.ZeroShotImageClassificationPipeline">.ZeroShotImageClassificationPipeline</a><ul><li><a href="#new_module_pipelines.ZeroShotImageClassificationPipeline_new"><code>new ZeroShotImageClassificationPipeline(options)</code></a></li> <li><a href="#module_pipelines.ZeroShotImageClassificationPipeline+_call"><code>._call(images, candidate_labels, options)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',Pr,Er,Hr,ni,Wr,ai,zr,pi,fu="Create a new ZeroShotImageClassificationPipeline.",Sr,oi,bu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",Xr,Lr,Fr,di,Dr,ci,qr,ri,xu="Classify the input images with candidate labels using a zero-shot approach.",Or,Mi,Cu='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ZeroShotImageClassificationPipeline"><code>ZeroShotImageClassificationPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - An array of classifications for each input image or a single classification object if only one input image is provided.',Kr,mi,gu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array</code></td><td><p>The input images.</p></td> </tr><tr><td>candidate_labels</td><td><code>Array.&lt;string&gt;</code></td><td><p>The candidate labels.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td><p>The options for the classification.</p></td> </tr><tr><td>[options.hypothesis_template]</td><td><code>string</code></td><td><p>The hypothesis template to use for zero-shot classification. Default: &quot;This is a photo of &amp;#123;}&quot;.</p></td></tr></tbody>",eM,tM,lM,Ti,sM,yi,iM,ui,Iu=`Object detection pipeline using any <code>AutoModelForObjectDetection</code>.
This pipeline predicts bounding boxes of objects and their classes.`,nM,Ji,ku="<strong>Example:</strong> Run object-detection with <code>facebook/detr-resnet-50</code>.",aM,hi,pM,wi,Bu='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',oM,ji,Gu='<li><a href="#module_pipelines.ObjectDetectionPipeline">.ObjectDetectionPipeline</a><ul><li><a href="#new_module_pipelines.ObjectDetectionPipeline_new"><code>new ObjectDetectionPipeline(options)</code></a></li> <li><a href="#module_pipelines.ObjectDetectionPipeline+_call"><code>._call(images, options)</code></a></li></ul></li>',dM,cM,rM,Ui,MM,fi,mM,bi,vu="Create a new ObjectDetectionPipeline.",TM,xi,Zu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",yM,uM,JM,Ci,hM,gi,wM,Ii,Qu="Detect objects (bounding boxes & classes) in the image(s) passed as inputs.",jM,ki,Au='<strong>Kind</strong>: instance method of <a href="#module_pipelines.ObjectDetectionPipeline"><code>ObjectDetectionPipeline</code></a>',UM,Bi,Nu="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;any&gt;</code></td><td></td><td><p>The input images.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options for the object detection.</p></td> </tr><tr><td>[options.threshold]</td><td><code>number</code></td><td><code>0.9</code></td><td><p>The threshold used to filter boxes by score.</p></td> </tr><tr><td>[options.percentage]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to return the boxes coordinates in percentage (true) or in pixels (false).</p></td></tr></tbody>",fM,bM,xM,Gi,CM,vi,gM,Zi,_u=`Document Question Answering pipeline using any <code>AutoModelForDocumentQuestionAnswering</code>.
The inputs/outputs are similar to the (extractive) question answering pipeline; however,
the pipeline takes an image (and optional OCR’d words/boxes) as input instead of text context.`,IM,Qi,$u="<strong>Example:</strong> Answer questions about a document with <code>Xenova/donut-base-finetuned-docvqa</code>.",kM,Ai,BM,Ni,Ru='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',GM,_i,Yu='<li><a href="#module_pipelines.DocumentQuestionAnsweringPipeline">.DocumentQuestionAnsweringPipeline</a><ul><li><a href="#new_module_pipelines.DocumentQuestionAnsweringPipeline_new"><code>new DocumentQuestionAnsweringPipeline(options)</code></a></li> <li><a href="#module_pipelines.DocumentQuestionAnsweringPipeline+_call"><code>._call(image, question, [generate_kwargs])</code></a> ⇒ <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code></li></ul></li>',vM,ZM,QM,$i,AM,Ri,NM,Yi,Vu="Create a new DocumentQuestionAnsweringPipeline.",_M,Vi,Pu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td></tr></tbody>",$M,RM,YM,Pi,VM,Ei,PM,Hi,Eu="Answer the question given as input by using the document.",EM,Wi,Hu='<strong>Kind</strong>: instance method of <a href="#module_pipelines.DocumentQuestionAnsweringPipeline"><code>DocumentQuestionAnsweringPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;(Object|Array&lt;Object&gt;)&gt;</code> - A Promise that resolves to an object (or array of objects) containing the generated text(s).',HM,zi,Wu="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>any</code></td><td></td><td><p>The image of the document to use.</p></td> </tr><tr><td>question</td><td><code>string</code></td><td></td><td><p>A question to ask of the document.</p></td> </tr><tr><td>[generate_kwargs]</td><td><code>Object</code></td><td><code>{}</code></td><td><p>Optional generation arguments.</p></td></tr></tbody>",WM,zM,SM,Si,XM,Xi,LM,Li,zu=`Text-to-audio generation pipeline using any <code>AutoModelForTextToWaveform</code> or <code>AutoModelForTextToSpectrogram</code>.
This pipeline generates an audio file from an input text and optional other conditional inputs.`,FM,Fi,Su="<strong>Example:</strong> Generate audio from text with <code>Xenova/speecht5_tts</code>.",DM,Di,qM,qi,Xu="You can then save the audio to a .wav file with the <code>wavefile</code> package:",OM,Oi,KM,Ki,Lu='<strong>Kind</strong>: static class of <a href="#module_pipelines"><code>pipelines</code></a>',em,en,Fu='<li><a href="#module_pipelines.TextToAudioPipeline">.TextToAudioPipeline</a><ul><li><a href="#new_module_pipelines.TextToAudioPipeline_new"><code>new TextToAudioPipeline(options)</code></a></li> <li><a href="#module_pipelines.TextToAudioPipeline+_call"><code>._call(text_inputs, options)</code></a> ⇒ <code>Promise.&lt;Object&gt;</code></li></ul></li>',tm,lm,sm,tn,im,ln,nm,sn,Du="Create a new TextToAudioPipeline.",am,nn,qu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>options</td><td><code>Object</code></td><td><p>An object containing the following properties:</p></td> </tr><tr><td>[options.task]</td><td><code>string</code></td><td><p>The task of the pipeline. Useful for specifying subtasks.</p></td> </tr><tr><td>[options.model]</td><td><code>PreTrainedModel</code></td><td><p>The model to use.</p></td> </tr><tr><td>[options.tokenizer]</td><td><code>PreTrainedTokenizer</code></td><td><p>The tokenizer to use.</p></td> </tr><tr><td>[options.processor]</td><td><code>Processor</code></td><td><p>The processor to use.</p></td> </tr><tr><td>[options.vocoder]</td><td><code>PreTrainedModel</code></td><td><p>The vocoder to use.</p></td></tr></tbody>",pm,om,dm,an,cm,pn,rm,on,Ou="Generates speech/audio from the inputs.",Mm,dn,Ku='<strong>Kind</strong>: instance method of <a href="#module_pipelines.TextToAudioPipeline"><code>TextToAudioPipeline</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Object&gt;</code> - An object containing the generated audio and sampling rate.',mm,cn,eJ="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>text_inputs</td><td><code>string</code> | <code>Array&lt;string&gt;</code></td><td></td><td><p>The text(s) to generate.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>Parameters passed to the model generation/forward method.</p></td> </tr><tr><td>[options.vocoder]</td><td><code>PreTrainedModel</code></td><td><code></code></td><td><p>The vocoder to use (if the model uses one). If not provided, use the default HifiGan vocoder.</p></td> </tr><tr><td>[options.speaker_embeddings]</td><td><code>Tensor</code> | <code>Float32Array</code> | <code>string</code> | <code>URL</code></td><td><code></code></td><td></td></tr></tbody>",Tm,ym,um,rn,Jm,Mn,hm,mn,tJ="Utility factory method to build a [<code>Pipeline</code>] object.",wm,Tn,lJ='<strong>Kind</strong>: static method of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Pipeline&gt;</code> - A Pipeline object for the specified task.<br/> <strong>Throws</strong>:',jm,yn,sJ="<li><code>Error</code> If an unsupported pipeline is requested.</li>",Um,un,iJ="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>task</td><td><code>string</code></td><td></td><td><p>The task defining which pipeline will be returned. Currently accepted tasks are:</p> <ul><li><code>&quot;audio-classification&quot;</code>: will return a <code>AudioClassificationPipeline</code>.</li> <li><code>&quot;automatic-speech-recognition&quot;</code>: will return a <code>AutomaticSpeechRecognitionPipeline</code>.</li> <li><code>&quot;document-question-answering&quot;</code>: will return a <code>DocumentQuestionAnsweringPipeline</code>.</li> <li><code>&quot;feature-extraction&quot;</code>: will return a <code>FeatureExtractionPipeline</code>.</li> <li><code>&quot;fill-mask&quot;</code>: will return a <code>FillMaskPipeline</code>.</li> <li><code>&quot;image-classification&quot;</code>: will return a <code>ImageClassificationPipeline</code>.</li> <li><code>&quot;image-segmentation&quot;</code>: will return a <code>ImageSegmentationPipeline</code>.</li> <li><code>&quot;image-to-text&quot;</code>: will return a <code>ImageToTextPipeline</code>.</li> <li><code>&quot;object-detection&quot;</code>: will return a <code>ObjectDetectionPipeline</code>.</li> <li><code>&quot;question-answering&quot;</code>: will return a <code>QuestionAnsweringPipeline</code>.</li> <li><code>&quot;summarization&quot;</code>: will return a <code>SummarizationPipeline</code>.</li> <li><code>&quot;text2text-generation&quot;</code>: will return a <code>Text2TextGenerationPipeline</code>.</li> <li><code>&quot;text-classification&quot;</code> (alias &quot;sentiment-analysis&quot; available): will return a <code>TextClassificationPipeline</code>.</li> <li><code>&quot;text-generation&quot;</code>: will return a <code>TextGenerationPipeline</code>.</li> <li><code>&quot;token-classification&quot;</code> (alias &quot;ner&quot; available): will return a <code>TokenClassificationPipeline</code>.</li> <li><code>&quot;translation&quot;</code>: will return a <code>TranslationPipeline</code>.</li> <li><code>&quot;translation_xx_to_yy&quot;</code>: will return a <code>TranslationPipeline</code>.</li> <li><code>&quot;zero-shot-classification&quot;</code>: will return a <code>ZeroShotClassificationPipeline</code>.</li> <li><code>&quot;zero-shot-image-classification&quot;</code>: will return a <code>ZeroShotImageClassificationPipeline</code>.</li></ul></td> </tr><tr><td>[model]</td><td><code>string</code></td><td><code>null</code></td><td><p>The name of the pre-trained model to use. If not specified, the default model for the task will be used.</p></td> </tr><tr><td>[options]</td><td><code>*</code></td><td></td><td><p>Optional parameters for the pipeline.</p></td></tr></tbody>",fm,bm,xm,Jn,Cm,hn,gm,wn,nJ='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a><br/> <strong>Properties</strong>',Im,jn,aJ="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>answer</td><td><code>string</code></td><td><p>The answer.</p></td> </tr><tr><td>score</td><td><code>number</code></td><td><p>The score.</p></td></tr></tbody>",km,Bm,Gm,Un,vm,fn,Zm,bn,pJ='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a>',Qm,Am,Nm,xn,_m,Cn,$m,gn,oJ='<strong>Kind</strong>: inner typedef of <a href="#module_pipelines"><code>pipelines</code></a>',Rm,In,dJ="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>chunk</td><td><code>Chunk</code></td><td><p>The chunk to process.</p></td></tr></tbody>",Ym,Vm,Pm,Bn,Em;return U=new J({props:{title:"pipelines",local:"pipelines",headingTag:"h1"}}),x=new h({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMjAlN0QlMjBmcm9tJTIwJyU0MHhlbm92YSUyRnRyYW5zZm9ybWVycyclM0IlMEElMEFsZXQlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnc2VudGltZW50LWFuYWx5c2lzJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIoJ0klMjBsb3ZlJTIwdHJhbnNmb3JtZXJzIScpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJ2xhYmVsJyUzQSUyMCdQT1NJVElWRSclMkMlMjAnc2NvcmUnJTNBJTIwMC45OTk4MTc2ODYlN0QlNUQ=",highlighted:`<span class="hljs-keyword">import</span> { pipeline } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@xenova/transformers&#x27;</span>;

<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;I love transformers!&#x27;</span>);
<span class="hljs-comment">// [{&#x27;label&#x27;: &#x27;POSITIVE&#x27;, &#x27;score&#x27;: 0.999817686}]</span>`,wrap:!1}}),I=new J({props:{title:"pipelines.Pipeline ⇐ <code> Callable </code>",local:"pipelinespipeline--code-callable-code",headingTag:"h2"}}),Z=new J({props:{title:"new Pipeline(options)",local:"new-pipelineoptions",headingTag:"h3"}}),_=new J({props:{title:"pipeline.dispose() ⇒ <code> Promise. < void > </code>",local:"pipelinedispose--code-promise--void--code",headingTag:"h3"}}),V=new J({props:{title:"pipeline._call(texts, ...args) ⇒ <code> Promise. < any > </code>",local:"pipelinecalltexts-args--code-promise--any--code",headingTag:"h3"}}),z=new J({props:{title:"pipelines.TextClassificationPipeline",local:"pipelinestextclassificationpipeline",headingTag:"h2"}}),L=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3NlbnRpbWVudC1hbmFseXNpcyclMkMlMjAnWGVub3ZhJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2gnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcignSSUyMGxvdmUlMjB0cmFuc2Zvcm1lcnMhJyklM0IlMEElMkYlMkYlMjAlNUIlN0IlMjBsYWJlbCUzQSUyMCdQT1NJVElWRSclMkMlMjBzY29yZSUzQSUyMDAuOTk5Nzg4NzYxMTM4OTE2JTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;I love transformers!&#x27;</span>);
<span class="hljs-comment">// [{ label: &#x27;POSITIVE&#x27;, score: 0.999788761138916 }]</span>`,wrap:!1}}),D=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3NlbnRpbWVudC1hbmFseXNpcyclMkMlMjAnWGVub3ZhJTJGYmVydC1iYXNlLW11bHRpbGluZ3VhbC11bmNhc2VkLXNlbnRpbWVudCcpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKCdMZSUyMG1laWxsZXVyJTIwZmlsbSUyMGRlJTIwdG91cyUyMGxlcyUyMHRlbXBzLiclMkMlMjAlN0IlMjB0b3BrJTNBJTIwNSUyMCU3RCklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBsYWJlbCUzQSUyMCc1JTIwc3RhcnMnJTJDJTIwc2NvcmUlM0ElMjAwLjk2MTA3NTk2MTU4OTgxMzIlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBsYWJlbCUzQSUyMCc0JTIwc3RhcnMnJTJDJTIwc2NvcmUlM0ElMjAwLjAzMzIzMzUxNTkxODI1NDg1JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnMyUyMHN0YXJzJyUyQyUyMHNjb3JlJTNBJTIwMC4wMDM2MTU1MTgxMDA1NTk3MTE1JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnMSUyMHN0YXInJTJDJTIwc2NvcmUlM0ElMjAwLjAwMTEzMjU5Njc0OTgxMjM2NDYlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBsYWJlbCUzQSUyMCcyJTIwc3RhcnMnJTJDJTIwc2NvcmUlM0ElMjAwLjAwMDk0MjM5NzEwNTk3MzIxMzklMjAlN0QlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-multilingual-uncased-sentiment&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;Le meilleur film de tous les temps.&#x27;</span>, { <span class="hljs-attr">topk</span>: <span class="hljs-number">5</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;5 stars&#x27;, score: 0.9610759615898132 },</span>
<span class="hljs-comment">//   { label: &#x27;4 stars&#x27;, score: 0.03323351591825485 },</span>
<span class="hljs-comment">//   { label: &#x27;3 stars&#x27;, score: 0.0036155181005597115 },</span>
<span class="hljs-comment">//   { label: &#x27;1 star&#x27;, score: 0.0011325967498123646 },</span>
<span class="hljs-comment">//   { label: &#x27;2 stars&#x27;, score: 0.0009423971059732139 }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),O=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RleHQtY2xhc3NpZmljYXRpb24nJTJDJTIwJ1hlbm92YSUyRnRveGljLWJlcnQnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcignSSUyMGhhdGUlMjB5b3UhJyUyQyUyMCU3QiUyMHRvcGslM0ElMjBudWxsJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RveGljJyUyQyUyMHNjb3JlJTNBJTIwMC45NTkzMTQwNDgyOTAyNTI3JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnaW5zdWx0JyUyQyUyMHNjb3JlJTNBJTIwMC4xNjE4NzMzNDA2MDY2ODk0NSUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ29ic2NlbmUnJTJDJTIwc2NvcmUlM0ElMjAwLjAzNDUyNjgwNjMyNDcyMDM4JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnaWRlbnRpdHlfaGF0ZSclMkMlMjBzY29yZSUzQSUyMDAuMDIyMzI1MDU3NTM2MzYzNiUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RocmVhdCclMkMlMjBzY29yZSUzQSUyMDAuMDE5MTk3MDQxMTY4ODA4OTM3JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnc2V2ZXJlX3RveGljJyUyQyUyMHNjb3JlJTNBJTIwMC4wMDU2NTEwOTk2MDczNDg0NDIlMjAlN0QlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/toxic-bert&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;I hate you!&#x27;</span>, { <span class="hljs-attr">topk</span>: <span class="hljs-literal">null</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;toxic&#x27;, score: 0.9593140482902527 },</span>
<span class="hljs-comment">//   { label: &#x27;insult&#x27;, score: 0.16187334060668945 },</span>
<span class="hljs-comment">//   { label: &#x27;obscene&#x27;, score: 0.03452680632472038 },</span>
<span class="hljs-comment">//   { label: &#x27;identity_hate&#x27;, score: 0.0223250575363636 },</span>
<span class="hljs-comment">//   { label: &#x27;threat&#x27;, score: 0.019197041168808937 },</span>
<span class="hljs-comment">//   { label: &#x27;severe_toxic&#x27;, score: 0.005651099607348442 }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),te=new J({props:{title:"textClassificationPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>",local:"textclassificationpipelinecalltexts-options--code-promise--array--object--object--code",headingTag:"h3"}}),ae=new J({props:{title:"pipelines.TokenClassificationPipeline",local:"pipelinestokenclassificationpipeline",headingTag:"h2"}}),de=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3Rva2VuLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZiZXJ0LWJhc2UtTkVSJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIoJ015JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwTG9uZG9uJyklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBlbnRpdHklM0ElMjAnQi1QRVInJTJDJTIwc2NvcmUlM0ElMjAwLjk5ODAyMDI5MTMyODQzMDIlMkMlMjBpbmRleCUzQSUyMDQlMkMlMjB3b3JkJTNBJTIwJ1NhcmFoJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdCLUxPQyclMkMlMjBzY29yZSUzQSUyMDAuOTk5NDQ3NDA1MzM4Mjg3NCUyQyUyMGluZGV4JTNBJTIwOSUyQyUyMHdvcmQlM0ElMjAnTG9uZG9uJyUyMCU3RCUwQSUyRiUyRiUyMCU1RA==",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;token-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-NER&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;My name is Sarah and I live in London&#x27;</span>);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { entity: &#x27;B-PER&#x27;, score: 0.9980202913284302, index: 4, word: &#x27;Sarah&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;B-LOC&#x27;, score: 0.9994474053382874, index: 9, word: &#x27;London&#x27; }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),re=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3Rva2VuLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZiZXJ0LWJhc2UtTkVSJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIoJ1NhcmFoJTIwbGl2ZXMlMjBpbiUyMHRoZSUyMFVuaXRlZCUyMFN0YXRlcyUyMG9mJTIwQW1lcmljYSclMkMlMjAlN0IlMjBpZ25vcmVfbGFiZWxzJTNBJTIwJTVCJTVEJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdCLVBFUiclMkMlMjBzY29yZSUzQSUyMDAuOTk2NjU4NzQyNDI3ODI1OSUyQyUyMGluZGV4JTNBJTIwMSUyQyUyMHdvcmQlM0ElMjAnU2FyYWgnJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwZW50aXR5JTNBJTIwJ08nJTJDJTIwc2NvcmUlM0ElMjAwLjk5ODczODU4NjkwMjYxODQlMkMlMjBpbmRleCUzQSUyMDIlMkMlMjB3b3JkJTNBJTIwJ2xpdmVzJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdPJyUyQyUyMHNjb3JlJTNBJTIwMC45OTkwMDcyODQ2NDEyNjU5JTJDJTIwaW5kZXglM0ElMjAzJTJDJTIwd29yZCUzQSUyMCdpbiclMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBlbnRpdHklM0ElMjAnTyclMkMlMjBzY29yZSUzQSUyMDAuOTk4ODI5ODQxNjEzNzY5NSUyQyUyMGluZGV4JTNBJTIwNCUyQyUyMHdvcmQlM0ElMjAndGhlJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdCLUxPQyclMkMlMjBzY29yZSUzQSUyMDAuOTk5NTUxMDU3ODE1NTUxOCUyQyUyMGluZGV4JTNBJTIwNSUyQyUyMHdvcmQlM0ElMjAnVW5pdGVkJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdJLUxPQyclMkMlMjBzY29yZSUzQSUyMDAuOTk5MDM5NTMwNzU0MDg5NCUyQyUyMGluZGV4JTNBJTIwNiUyQyUyMHdvcmQlM0ElMjAnU3RhdGVzJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGVudGl0eSUzQSUyMCdJLUxPQyclMkMlMjBzY29yZSUzQSUyMDAuOTk4NjcyNDg1MzUxNTYyNSUyQyUyMGluZGV4JTNBJTIwNyUyQyUyMHdvcmQlM0ElMjAnb2YnJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwZW50aXR5JTNBJTIwJ0ktTE9DJyUyQyUyMHNjb3JlJTNBJTIwMC45OTc1Mjk0NDcwNzg3MDQ4JTJDJTIwaW5kZXglM0ElMjA4JTJDJTIwd29yZCUzQSUyMCdBbWVyaWNhJyUyMCU3RCUwQSUyRiUyRiUyMCU1RA==",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;token-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-NER&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;Sarah lives in the United States of America&#x27;</span>, { <span class="hljs-attr">ignore_labels</span>: [] });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { entity: &#x27;B-PER&#x27;, score: 0.9966587424278259, index: 1, word: &#x27;Sarah&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;O&#x27;, score: 0.9987385869026184, index: 2, word: &#x27;lives&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;O&#x27;, score: 0.9990072846412659, index: 3, word: &#x27;in&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;O&#x27;, score: 0.9988298416137695, index: 4, word: &#x27;the&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;B-LOC&#x27;, score: 0.9995510578155518, index: 5, word: &#x27;United&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;I-LOC&#x27;, score: 0.9990395307540894, index: 6, word: &#x27;States&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;I-LOC&#x27;, score: 0.9986724853515625, index: 7, word: &#x27;of&#x27; },</span>
<span class="hljs-comment">//   { entity: &#x27;I-LOC&#x27;, score: 0.9975294470787048, index: 8, word: &#x27;America&#x27; }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Te=new J({props:{title:"tokenClassificationPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>",local:"tokenclassificationpipelinecalltexts-options--code-promise--array--object--object--code",headingTag:"h3"}}),we=new J({props:{title:"pipelines.QuestionAnsweringPipeline",local:"pipelinesquestionansweringpipeline",headingTag:"h2"}}),fe=new h({props:{code:"bGV0JTIwcXVlc3Rpb24lMjAlM0QlMjAnV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJyUzQiUwQWxldCUyMGNvbnRleHQlMjAlM0QlMjAnSmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQuJyUzQiUwQSUwQWxldCUyMGFuc3dlcmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgncXVlc3Rpb24tYW5zd2VyaW5nJyUyQyUyMCdYZW5vdmElMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1kaXN0aWxsZWQtc3F1YWQnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwYW5zd2VyZXIocXVlc3Rpb24lMkMlMjBjb250ZXh0KSUzQiUwQSUyRiUyRiUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMCUyMmFuc3dlciUyMiUzQSUyMCUyMmElMjBuaWNlJTIwcHVwcGV0JTIyJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIyc2NvcmUlMjIlM0ElMjAwLjU3Njg5MTE1MDI1MjY3NDElMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">let</span> question = <span class="hljs-string">&#x27;Who was Jim Henson?&#x27;</span>;
<span class="hljs-keyword">let</span> context = <span class="hljs-string">&#x27;Jim Henson was a nice puppet.&#x27;</span>;

<span class="hljs-keyword">let</span> answerer = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;question-answering&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilbert-base-uncased-distilled-squad&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">answerer</span>(question, context);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   &quot;answer&quot;: &quot;a nice puppet&quot;,</span>
<span class="hljs-comment">//   &quot;score&quot;: 0.5768911502526741</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Ce=new J({props:{title:"questionAnsweringPipeline._call(question, context, options) ⇒ <code> QuestionAnsweringReturnType </code>",local:"questionansweringpipelinecallquestion-context-options--code-questionansweringreturntype-code",headingTag:"h3"}}),Ge=new J({props:{title:"pipelines.FillMaskPipeline",local:"pipelinesfillmaskpipeline",headingTag:"h2"}}),Qe=new h({props:{code:"bGV0JTIwdW5tYXNrZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdmaWxsLW1hc2snJTJDJTIwJ1hlbm92YSUyRmJlcnQtYmFzZS1jYXNlZCcpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB1bm1hc2tlcignVGhlJTIwZ29hbCUyMG9mJTIwbGlmZSUyMGlzJTIwJTVCTUFTSyU1RC4nKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMHRva2VuX3N0ciUzQSUyMCdzdXJ2aXZhbCclMkMlMjBzY29yZSUzQSUyMDAuMDYxMzc0MTk0OTIwMDYzMDIlMkMlMjB0b2tlbiUzQSUyMDgxMTUlMkMlMjBzZXF1ZW5jZSUzQSUyMCdUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjBzdXJ2aXZhbC4nJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwdG9rZW5fc3RyJTNBJTIwJ2xvdmUnJTJDJTIwc2NvcmUlM0ElMjAwLjAzOTAyNDUwMjAzODk1NTY5JTJDJTIwdG9rZW4lM0ElMjAxNTY3JTJDJTIwc2VxdWVuY2UlM0ElMjAnVGhlJTIwZ29hbCUyMG9mJTIwbGlmZSUyMGlzJTIwbG92ZS4nJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwdG9rZW5fc3RyJTNBJTIwJ2hhcHBpbmVzcyclMkMlMjBzY29yZSUzQSUyMDAuMDMyNTMxODM1MTM4Nzk3NzYlMkMlMjB0b2tlbiUzQSUyMDkyNjYlMkMlMjBzZXF1ZW5jZSUzQSUyMCdUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjBoYXBwaW5lc3MuJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMHRva2VuX3N0ciUzQSUyMCdmcmVlZG9tJyUyQyUyMHNjb3JlJTNBJTIwMC4wMTg3MzYzMDY1Nzc5MjA5MTQlMkMlMjB0b2tlbiUzQSUyMDQ0MzglMkMlMjBzZXF1ZW5jZSUzQSUyMCdUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjBmcmVlZG9tLiclMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjB0b2tlbl9zdHIlM0ElMjAnbGlmZSclMkMlMjBzY29yZSUzQSUyMDAuMDE4NTk3OTQ3NDMzNTkwODklMkMlMjB0b2tlbiUzQSUyMDEyOTclMkMlMjBzZXF1ZW5jZSUzQSUyMCdUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjBsaWZlLiclMjAlN0QlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">let</span> unmasker = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;fill-mask&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-cased&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">unmasker</span>(<span class="hljs-string">&#x27;The goal of life is [MASK].&#x27;</span>);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { token_str: &#x27;survival&#x27;, score: 0.06137419492006302, token: 8115, sequence: &#x27;The goal of life is survival.&#x27; },</span>
<span class="hljs-comment">//   { token_str: &#x27;love&#x27;, score: 0.03902450203895569, token: 1567, sequence: &#x27;The goal of life is love.&#x27; },</span>
<span class="hljs-comment">//   { token_str: &#x27;happiness&#x27;, score: 0.03253183513879776, token: 9266, sequence: &#x27;The goal of life is happiness.&#x27; },</span>
<span class="hljs-comment">//   { token_str: &#x27;freedom&#x27;, score: 0.018736306577920914, token: 4438, sequence: &#x27;The goal of life is freedom.&#x27; },</span>
<span class="hljs-comment">//   { token_str: &#x27;life&#x27;, score: 0.01859794743359089, token: 1297, sequence: &#x27;The goal of life is life.&#x27; }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Ne=new h({props:{code:"bGV0JTIwdW5tYXNrZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdmaWxsLW1hc2snJTJDJTIwJ1hlbm92YSUyRmJlcnQtYmFzZS1jYXNlZCcpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB1bm1hc2tlcignVGhlJTIwTWlsa3klMjBXYXklMjBpcyUyMGElMjAlNUJNQVNLJTVEJTIwZ2FsYXh5LiclMkMlMjAlN0IlMjB0b3BrJTNBJTIwMSUyMCU3RCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMjB0b2tlbl9zdHIlM0ElMjAnc3BpcmFsJyUyQyUyMHNjb3JlJTNBJTIwMC42Mjk5OTg3NDM1MzQwODgxJTJDJTIwdG9rZW4lM0ElMjAxNDA2MSUyQyUyMHNlcXVlbmNlJTNBJTIwJ1RoZSUyME1pbGt5JTIwV2F5JTIwaXMlMjBhJTIwc3BpcmFsJTIwZ2FsYXh5LiclMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> unmasker = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;fill-mask&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-cased&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">unmasker</span>(<span class="hljs-string">&#x27;The Milky Way is a [MASK] galaxy.&#x27;</span>, { <span class="hljs-attr">topk</span>: <span class="hljs-number">1</span> });
<span class="hljs-comment">// [{ token_str: &#x27;spiral&#x27;, score: 0.6299987435340881, token: 14061, sequence: &#x27;The Milky Way is a spiral galaxy.&#x27; }]</span>`,wrap:!1}}),Re=new J({props:{title:"fillMaskPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>",local:"fillmaskpipelinecalltexts-options--code-promise--array--object--object--code",headingTag:"h3"}}),He=new J({props:{title:"pipelines.Text2TextGenerationPipeline",local:"pipelinestext2textgenerationpipeline",headingTag:"h2"}}),Se=new h({props:{code:"bGV0JTIwZ2VuZXJhdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgndGV4dDJ0ZXh0LWdlbmVyYXRpb24nJTJDJTIwJ1hlbm92YSUyRkxhTWluaS1GbGFuLVQ1LTc4M00nKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwZ2VuZXJhdG9yKCdob3clMjBjYW4lMjBJJTIwYmVjb21lJTIwbW9yZSUyMGhlYWx0aHklM0YnJTJDJTIwJTdCJTBBJTIwJTIwbWF4X25ld190b2tlbnMlM0ElMjAxMDAlMkMlMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTIwJ1RvJTIwYmVjb21lJTIwbW9yZSUyMGhlYWx0aHklMkMlMjB5b3UlMjBjYW4lM0ElMjAxLiUyMEVhdCUyMGElMjBiYWxhbmNlZCUyMGRpZXQlMjB3aXRoJTIwcGxlbnR5JTIwb2YlMjBmcnVpdHMlMkMlMjB2ZWdldGFibGVzJTJDJTIwd2hvbGUlMjBncmFpbnMlMkMlMjBsZWFuJTIwcHJvdGVpbnMlMkMlMjBhbmQlMjBoZWFsdGh5JTIwZmF0cy4lMjAyLiUyMFN0YXklMjBoeWRyYXRlZCUyMGJ5JTIwZHJpbmtpbmclMjBwbGVudHklMjBvZiUyMHdhdGVyLiUyMDMuJTIwR2V0JTIwZW5vdWdoJTIwc2xlZXAlMjBhbmQlMjBtYW5hZ2UlMjBzdHJlc3MlMjBsZXZlbHMuJTIwNC4lMjBBdm9pZCUyMHNtb2tpbmclMjBhbmQlMjBleGNlc3NpdmUlMjBhbGNvaG9sJTIwY29uc3VtcHRpb24uJTIwNS4lMjBSZWd1bGFybHklMjBleGVyY2lzZSUyMGFuZCUyMG1haW50YWluJTIwYSUyMGhlYWx0aHklMjB3ZWlnaHQuJTIwNi4lMjBQcmFjdGljZSUyMGdvb2QlMjBoeWdpZW5lJTIwYW5kJTIwc2FuaXRhdGlvbi4lMjA3LiUyMFNlZWslMjBtZWRpY2FsJTIwYXR0ZW50aW9uJTIwaWYlMjB5b3UlMjBleHBlcmllbmNlJTIwYW55JTIwaGVhbHRoJTIwaXNzdWVzLiclMjAlNUQ=",highlighted:`<span class="hljs-keyword">let</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text2text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/LaMini-Flan-T5-783M&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(<span class="hljs-string">&#x27;how can I become more healthy?&#x27;</span>, {
  <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">100</span>,
});
<span class="hljs-comment">// [ &#x27;To become more healthy, you can: 1. Eat a balanced diet with plenty of fruits, vegetables, whole grains, lean proteins, and healthy fats. 2. Stay hydrated by drinking plenty of water. 3. Get enough sleep and manage stress levels. 4. Avoid smoking and excessive alcohol consumption. 5. Regularly exercise and maintain a healthy weight. 6. Practice good hygiene and sanitation. 7. Seek medical attention if you experience any health issues.&#x27; ]</span>`,wrap:!1}}),Fe=new J({props:{title:"text2TextGenerationPipeline._call(texts, [options]) ⇒ <code> Promise. < any > </code>",local:"text2textgenerationpipelinecalltexts-options--code-promise--any--code",headingTag:"h3"}}),tt=new J({props:{title:"pipelines.SummarizationPipeline",local:"pipelinessummarizationpipeline",headingTag:"h2"}}),it=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;The tower is 324 metres (1,063 ft) tall, about the same height as an 81-storey building, &#x27;</span> +
  <span class="hljs-string">&#x27;and the tallest structure in Paris. Its base is square, measuring 125 metres (410 ft) on each side. &#x27;</span> +
  <span class="hljs-string">&#x27;During its construction, the Eiffel Tower surpassed the Washington Monument to become the tallest &#x27;</span> +
  <span class="hljs-string">&#x27;man-made structure in the world, a title it held for 41 years until the Chrysler Building in New &#x27;</span> +
  <span class="hljs-string">&#x27;York City was finished in 1930. It was the first structure to reach a height of 300 metres. Due to &#x27;</span> +
  <span class="hljs-string">&#x27;the addition of a broadcasting aerial at the top of the tower in 1957, it is now taller than the &#x27;</span> +
  <span class="hljs-string">&#x27;Chrysler Building by 5.2 metres (17 ft). Excluding transmitters, the Eiffel Tower is the second &#x27;</span> +
  <span class="hljs-string">&#x27;tallest free-standing structure in France after the Millau Viaduct.&#x27;</span>;

<span class="hljs-keyword">let</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;summarization&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilbart-cnn-6-6&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(text, {
  <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">100</span>,
});
<span class="hljs-comment">// [{ summary_text: &#x27; The Eiffel Tower is about the same height as an 81-storey building and the tallest structure in Paris. It is the second tallest free-standing structure in France after the Millau Viaduct.&#x27; }]</span>`,wrap:!1}}),pt=new J({props:{title:"pipelines.TranslationPipeline",local:"pipelinestranslationpipeline",headingTag:"h2"}}),rt=new h({props:{code:"bGV0JTIwdHJhbnNsYXRvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RyYW5zbGF0aW9uJyUyQyUyMCdYZW5vdmElMkZubGxiLTIwMC1kaXN0aWxsZWQtNjAwTScpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2xhdG9yKCclRTAlQTQlOUMlRTAlQTUlODAlRTAlQTQlQjUlRTAlQTQlQTglMjAlRTAlQTQlOEYlRTAlQTQlOTUlMjAlRTAlQTQlOUElRTAlQTUlODklRTAlQTQlOTUlRTAlQTQlQjIlRTAlQTUlODclRTAlQTQlOUYlMjAlRTAlQTQlQUMlRTAlQTUlODklRTAlQTQlOTUlRTAlQTUlOEQlRTAlQTQlQjglMjAlRTAlQTQlOTUlRTAlQTUlODAlMjAlRTAlQTQlQTQlRTAlQTQlQjAlRTAlQTQlQjklMjAlRTAlQTQlQjklRTAlQTUlODglRTAlQTUlQTQnJTJDJTIwJTdCJTBBJTIwJTIwc3JjX2xhbmclM0ElMjAnaGluX0RldmEnJTJDJTIwJTJGJTJGJTIwSGluZGklMEElMjAlMjB0Z3RfbGFuZyUzQSUyMCdmcmFfTGF0biclMkMlMjAlMkYlMkYlMjBGcmVuY2glMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwdHJhbnNsYXRpb25fdGV4dCUzQSUyMCdMYSUyMHZpZSUyMGVzdCUyMGNvbW1lJTIwdW5lJTIwYm8lQzMlQUV0ZSUyMCVDMyVBMCUyMGNob2NvbGF0LiclMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> translator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;translation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/nllb-200-distilled-600M&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translator</span>(<span class="hljs-string">&#x27;जीवन एक चॉकलेट बॉक्स की तरह है।&#x27;</span>, {
  <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&#x27;hin_Deva&#x27;</span>, <span class="hljs-comment">// Hindi</span>
  <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&#x27;fra_Latn&#x27;</span>, <span class="hljs-comment">// French</span>
});
<span class="hljs-comment">// [{ translation_text: &#x27;La vie est comme une boîte à chocolat.&#x27; }]</span>`,wrap:!1}}),Tt=new h({props:{code:"bGV0JTIwdHJhbnNsYXRvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RyYW5zbGF0aW9uJyUyQyUyMCdYZW5vdmElMkZtMm0xMDBfNDE4TScpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2xhdG9yKCclRTclOTQlOUYlRTYlQjQlQkIlRTUlQjAlQjElRTUlODMlOEYlRTQlQjglODAlRTclOUIlOTIlRTUlQjclQTclRTUlODUlOEIlRTUlOEElOUIlRTMlODAlODInJTJDJTIwJTdCJTBBJTIwJTIwc3JjX2xhbmclM0ElMjAnemgnJTJDJTIwJTJGJTJGJTIwQ2hpbmVzZSUwQSUyMCUyMHRndF9sYW5nJTNBJTIwJ2VuJyUyQyUyMCUyRiUyRiUyMEVuZ2xpc2glMEElN0QpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwdHJhbnNsYXRpb25fdGV4dCUzQSUyMCdMaWZlJTIwaXMlMjBsaWtlJTIwYSUyMGJveCUyMG9mJTIwY2hvY29sYXRlLiclMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">let</span> translator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;translation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/m2m100_418M&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translator</span>(<span class="hljs-string">&#x27;生活就像一盒巧克力。&#x27;</span>, {
  <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&#x27;zh&#x27;</span>, <span class="hljs-comment">// Chinese</span>
  <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-comment">// English</span>
});
<span class="hljs-comment">// [{ translation_text: &#x27;Life is like a box of chocolate.&#x27; }]</span>`,wrap:!1}}),Jt=new h({props:{code:"bGV0JTIwdHJhbnNsYXRvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RyYW5zbGF0aW9uJyUyQyUyMCdYZW5vdmElMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zbGF0b3IoJyVFMCVBNCVCOCVFMCVBNCU4MiVFMCVBNCVBRiVFMCVBNSU4MSVFMCVBNCU5NSVFMCVBNSU4RCVFMCVBNCVBNCUyMCVFMCVBNCVCMCVFMCVBNCVCRSVFMCVBNCVCNyVFMCVBNSU4RCVFMCVBNCU5RiVFMCVBNSU4RCVFMCVBNCVCMCUyMCVFMCVBNCU5NSVFMCVBNSU4NyUyMCVFMCVBNCVBQSVFMCVBNSU4RCVFMCVBNCVCMCVFMCVBNCVBRSVFMCVBNSU4MSVFMCVBNCU5NiUyMCVFMCVBNCU5NSVFMCVBNCVCRSUyMCVFMCVBNCU5NSVFMCVBNCVCOSVFMCVBNCVBOCVFMCVBNCVCRSUyMCVFMCVBNCVCOSVFMCVBNSU4OCUyMCVFMCVBNCU5NSVFMCVBNCVCRiUyMCVFMCVBNCVCOCVFMCVBNSU4MCVFMCVBNCVCMCVFMCVBNCVCRiVFMCVBNCVBRiVFMCVBNCVCRSUyMCVFMCVBNCVBRSVFMCVBNSU4NyVFMCVBNCU4MiUyMCVFMCVBNCU5NSVFMCVBNSU4QiVFMCVBNCU4OCUyMCVFMCVBNCVCOCVFMCVBNSU4OCVFMCVBNCVBOCVFMCVBNSU4RCVFMCVBNCVBRiUyMCVFMCVBNCVCOCVFMCVBNCVBRSVFMCVBNCVCRSVFMCVBNCVBNyVFMCVBNCVCRSVFMCVBNCVBOCUyMCVFMCVBNCVBOCVFMCVBNCVCOSVFMCVBNSU4MCVFMCVBNCU4MiUyMCVFMCVBNCVCOSVFMCVBNSU4OCclMkMlMjAlN0IlMEElMjAlMjBzcmNfbGFuZyUzQSUyMCdoaV9JTiclMkMlMjAlMkYlMkYlMjBIaW5kaSUwQSUyMCUyMHRndF9sYW5nJTNBJTIwJ2ZyX1hYJyUyQyUyMCUyRiUyRiUyMEZyZW5jaCUwQSU3RCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMjB0cmFuc2xhdGlvbl90ZXh0JTNBJTIwJ0xlJTIwY2hlZiUyMGRlcyUyME5hdGlvbnMlMjBhZmZpcm1lJTIwcXUlMjAnaWwlMjBuJTIwJ3klMjBhJTIwbWlsaXRhcnklMjBzb2x1dGlvbiUyMGluJTIwU3lyaWEuJyUyMCU3RCU1RA==",highlighted:`<span class="hljs-keyword">let</span> translator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;translation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/mbart-large-50-many-to-many-mmt&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translator</span>(<span class="hljs-string">&#x27;संयुक्त राष्ट्र के प्रमुख का कहना है कि सीरिया में कोई सैन्य समाधान नहीं है&#x27;</span>, {
  <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&#x27;hi_IN&#x27;</span>, <span class="hljs-comment">// Hindi</span>
  <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&#x27;fr_XX&#x27;</span>, <span class="hljs-comment">// French</span>
});
<span class="hljs-comment">// [{ translation_text: &#x27;Le chef des Nations affirme qu &#x27;il n &#x27;y a military solution in Syria.&#x27; }]</span>`,wrap:!1}}),jt=new J({props:{title:"pipelines.TextGenerationPipeline",local:"pipelinestextgenerationpipeline",headingTag:"h2"}}),bt=new h({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdJJTIwZW5qb3klMjB3YWxraW5nJTIwd2l0aCUyMG15JTIwY3V0ZSUyMGRvZyUyQyclM0IlMEFsZXQlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgndGV4dC1nZW5lcmF0aW9uJyUyQyUyMCdYZW5vdmElMkZkaXN0aWxncHQyJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIodGV4dCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMjBnZW5lcmF0ZWRfdGV4dCUzQSUyMCUyMkklMjBlbmpveSUyMHdhbGtpbmclMjB3aXRoJTIwbXklMjBjdXRlJTIwZG9nJTJDJTIwYW5kJTIwSSUyMGxvdmUlMjB0byUyMHBsYXklMjB3aXRoJTIwdGhlJTIwb3RoZXIlMjBkb2dzLiUyMiUyMCU3RCU1RA==",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;I enjoy walking with my cute dog,&#x27;</span>;
<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilgpt2&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(text);
<span class="hljs-comment">// [{ generated_text: &quot;I enjoy walking with my cute dog, and I love to play with the other dogs.&quot; }]</span>`,wrap:!1}}),Ct=new h({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdPbmNlJTIwdXBvbiUyMGElMjB0aW1lJTJDJTIwdGhlcmUlMjB3YXMnJTNCJTBBbGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RleHQtZ2VuZXJhdGlvbiclMkMlMjAnWGVub3ZhJTJGZGlzdGlsZ3B0MicpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHRleHQlMkMlMjAlN0IlMEElMjAlMjB0ZW1wZXJhdHVyZSUzQSUyMDIlMkMlMEElMjAlMjBtYXhfbmV3X3Rva2VucyUzQSUyMDEwJTJDJTBBJTIwJTIwcmVwZXRpdGlvbl9wZW5hbHR5JTNBJTIwMS41JTJDJTBBJTIwJTIwbm9fcmVwZWF0X25ncmFtX3NpemUlM0ElMjAyJTJDJTBBJTIwJTIwbnVtX2JlYW1zJTNBJTIwMiUyQyUwQSUyMCUyMG51bV9yZXR1cm5fc2VxdWVuY2VzJTNBJTIwMiUyQyUwQSU3RCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMEElMkYlMkYlMjAlMjAlMjAlMjJnZW5lcmF0ZWRfdGV4dCUyMiUzQSUyMCUyMk9uY2UlMjB1cG9uJTIwYSUyMHRpbWUlMkMlMjB0aGVyZSUyMHdhcyUyMGFuJTIwYWJ1bmRhbmNlJTIwb2YlMjBpbmZvcm1hdGlvbiUyMGFib3V0JTIwdGhlJTIwaGlzdG9yeSUyMGFuZCUyMGFjdGl2aXRpZXMlMjB0aGF0JTIyJTBBJTJGJTJGJTIwJTdEJTJDJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIyZ2VuZXJhdGVkX3RleHQlMjIlM0ElMjAlMjJPbmNlJTIwdXBvbiUyMGElMjB0aW1lJTJDJTIwdGhlcmUlMjB3YXMlMjBhbiUyMGFidW5kYW5jZSUyMG9mJTIwaW5mb3JtYXRpb24lMjBhYm91dCUyMHRoZSUyMG1vc3QlMjBpbXBvcnRhbnQlMjBhbmQlMjBpbmZsdWVudGlhbCUyMiUwQSUyRiUyRiUyMCU3RCU1RA==",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;Once upon a time, there was&#x27;</span>;
<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/distilgpt2&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(text, {
  <span class="hljs-attr">temperature</span>: <span class="hljs-number">2</span>,
  <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">10</span>,
  <span class="hljs-attr">repetition_penalty</span>: <span class="hljs-number">1.5</span>,
  <span class="hljs-attr">no_repeat_ngram_size</span>: <span class="hljs-number">2</span>,
  <span class="hljs-attr">num_beams</span>: <span class="hljs-number">2</span>,
  <span class="hljs-attr">num_return_sequences</span>: <span class="hljs-number">2</span>,
});
<span class="hljs-comment">// [{</span>
<span class="hljs-comment">//   &quot;generated_text&quot;: &quot;Once upon a time, there was an abundance of information about the history and activities that&quot;</span>
<span class="hljs-comment">// }, {</span>
<span class="hljs-comment">//   &quot;generated_text&quot;: &quot;Once upon a time, there was an abundance of information about the most important and influential&quot;</span>
<span class="hljs-comment">// }]</span>`,wrap:!1}}),It=new h({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdkZWYlMjBmaWIobiklM0EnJTNCJTBBbGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RleHQtZ2VuZXJhdGlvbiclMkMlMjAnWGVub3ZhJTJGY29kZWdlbi0zNTBNLW1vbm8nKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcih0ZXh0JTJDJTIwJTdCJTBBJTIwJTIwbWF4X25ld190b2tlbnMlM0ElMjA0NCUyQyUwQSU3RCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMEElMkYlMkYlMjAlMjAlMjBnZW5lcmF0ZWRfdGV4dCUzQSUyMCdkZWYlMjBmaWIobiklM0ElNUNuJyUyMCUyQiUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCclMjAlMjAlMjAlMjBpZiUyMG4lMjAlM0QlM0QlMjAwJTNBJTVDbiclMjAlMkIlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAnJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwMCU1Q24nJTIwJTJCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJyUyMCUyMCUyMCUyMGVsaWYlMjBuJTIwJTNEJTNEJTIwMSUzQSU1Q24nJTIwJTJCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMDElNUNuJyUyMCUyQiUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCclMjAlMjAlMjAlMjBlbHNlJTNBJTVDbiclMjAlMkIlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAnJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwZmliKG4tMSklMjAlMkIlMjBmaWIobi0yKSU1Q24nJTBBJTJGJTJGJTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;def fib(n):&#x27;</span>;
<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/codegen-350M-mono&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(text, {
  <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">44</span>,
});
<span class="hljs-comment">// [{</span>
<span class="hljs-comment">//   generated_text: &#x27;def fib(n):\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;    if n == 0:\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;        return 0\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;    elif n == 1:\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;        return 1\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;    else:\\n&#x27; +</span>
<span class="hljs-comment">//     &#x27;        return fib(n-1) + fib(n-2)\\n&#x27;</span>
<span class="hljs-comment">// }]</span>`,wrap:!1}}),Gt=new J({props:{title:"textGenerationPipeline._call(texts, [generate_kwargs]) ⇒ <code> Promise. < any > </code>",local:"textgenerationpipelinecalltexts-generatekwargs--code-promise--any--code",headingTag:"h3"}}),Nt=new J({props:{title:"pipelines.ZeroShotClassificationPipeline",local:"pipelineszeroshotclassificationpipeline",headingTag:"h2"}}),Rt=new h({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdMYXN0JTIwd2VlayUyMEklMjB1cGdyYWRlZCUyMG15JTIwaU9TJTIwdmVyc2lvbiUyMGFuZCUyMGV2ZXIlMjBzaW5jZSUyMHRoZW4lMjBteSUyMHBob25lJTIwaGFzJTIwYmVlbiUyMG92ZXJoZWF0aW5nJTIwd2hlbmV2ZXIlMjBJJTIwdXNlJTIweW91ciUyMGFwcC4nJTNCJTBBbGV0JTIwbGFiZWxzJTIwJTNEJTIwJTVCJTIwJ21vYmlsZSclMkMlMjAnYmlsbGluZyclMkMlMjAnd2Vic2l0ZSclMkMlMjAnYWNjb3VudCUyMGFjY2VzcyclMjAlNUQlM0IlMEFsZXQlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnemVyby1zaG90LWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZtb2JpbGViZXJ0LXVuY2FzZWQtbW5saScpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHRleHQlMkMlMjBsYWJlbHMpJTNCJTBBJTJGJTJGJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwc2VxdWVuY2UlM0ElMjAnTGFzdCUyMHdlZWslMjBJJTIwdXBncmFkZWQlMjBteSUyMGlPUyUyMHZlcnNpb24lMjBhbmQlMjBldmVyJTIwc2luY2UlMjB0aGVuJTIwbXklMjBwaG9uZSUyMGhhcyUyMGJlZW4lMjBvdmVyaGVhdGluZyUyMHdoZW5ldmVyJTIwSSUyMHVzZSUyMHlvdXIlMjBhcHAuJyUyQyUwQSUyRiUyRiUyMCUyMCUyMGxhYmVscyUzQSUyMCU1QiUyMCdtb2JpbGUnJTJDJTIwJ3dlYnNpdGUnJTJDJTIwJ2JpbGxpbmcnJTJDJTIwJ2FjY291bnQlMjBhY2Nlc3MnJTIwJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwc2NvcmVzJTNBJTIwJTVCJTIwMC41NTYyMDkxMDQwNDgyMDE4JTJDJTIwMC4xODQzNjIxMzA3ODYwODUzJTJDJTIwMC4xMzk0MjY0NjYzOTMzNjM3NiUyQyUyMDAuMTIwMDAyMjk4NzcyMzQ5MjMlMjAlNUQlMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;Last week I upgraded my iOS version and ever since then my phone has been overheating whenever I use your app.&#x27;</span>;
<span class="hljs-keyword">let</span> labels = [ <span class="hljs-string">&#x27;mobile&#x27;</span>, <span class="hljs-string">&#x27;billing&#x27;</span>, <span class="hljs-string">&#x27;website&#x27;</span>, <span class="hljs-string">&#x27;account access&#x27;</span> ];
<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;zero-shot-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/mobilebert-uncased-mnli&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(text, labels);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   sequence: &#x27;Last week I upgraded my iOS version and ever since then my phone has been overheating whenever I use your app.&#x27;,</span>
<span class="hljs-comment">//   labels: [ &#x27;mobile&#x27;, &#x27;website&#x27;, &#x27;billing&#x27;, &#x27;account access&#x27; ],</span>
<span class="hljs-comment">//   scores: [ 0.5562091040482018, 0.1843621307860853, 0.13942646639336376, 0.12000229877234923 ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Vt=new h({props:{code:"bGV0JTIwdGV4dCUyMCUzRCUyMCdJJTIwaGF2ZSUyMGElMjBwcm9ibGVtJTIwd2l0aCUyMG15JTIwaXBob25lJTIwdGhhdCUyMG5lZWRzJTIwdG8lMjBiZSUyMHJlc29sdmVkJTIwYXNhcCEnJTNCJTBBbGV0JTIwbGFiZWxzJTIwJTNEJTIwJTVCJTIwJ3VyZ2VudCclMkMlMjAnbm90JTIwdXJnZW50JyUyQyUyMCdwaG9uZSclMkMlMjAndGFibGV0JyUyQyUyMCdjb21wdXRlciclMjAlNUQlM0IlMEFsZXQlMjBjbGFzc2lmaWVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnemVyby1zaG90LWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZubGktZGViZXJ0YS12My14c21hbGwnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcih0ZXh0JTJDJTIwbGFiZWxzJTJDJTIwJTdCJTIwbXVsdGlfbGFiZWwlM0ElMjB0cnVlJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMHNlcXVlbmNlJTNBJTIwJ0klMjBoYXZlJTIwYSUyMHByb2JsZW0lMjB3aXRoJTIwbXklMjBpcGhvbmUlMjB0aGF0JTIwbmVlZHMlMjB0byUyMGJlJTIwcmVzb2x2ZWQlMjBhc2FwISclMkMlMEElMkYlMkYlMjAlMjAlMjBsYWJlbHMlM0ElMjAlNUIlMjAndXJnZW50JyUyQyUyMCdwaG9uZSclMkMlMjAnY29tcHV0ZXInJTJDJTIwJ3RhYmxldCclMkMlMjAnbm90JTIwdXJnZW50JyUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMHNjb3JlcyUzQSUyMCU1QiUyMDAuOTk1ODg3MDk1NjM2MDI3NSUyQyUyMDAuOTkyMzk2MzQwMDY5NzAzNSUyQyUyMDAuMDAyMzMzNTM3OTQ2MTYwMjM1JTJDJTIwMC4wMDE1MTM0MTM4NTY3NTk4NzY1JTJDJTIwMC4wMDEwNjk5Mzg0MjA4Mzc3MTYzJTIwJTVEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> text = <span class="hljs-string">&#x27;I have a problem with my iphone that needs to be resolved asap!&#x27;</span>;
<span class="hljs-keyword">let</span> labels = [ <span class="hljs-string">&#x27;urgent&#x27;</span>, <span class="hljs-string">&#x27;not urgent&#x27;</span>, <span class="hljs-string">&#x27;phone&#x27;</span>, <span class="hljs-string">&#x27;tablet&#x27;</span>, <span class="hljs-string">&#x27;computer&#x27;</span> ];
<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;zero-shot-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/nli-deberta-v3-xsmall&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(text, labels, { <span class="hljs-attr">multi_label</span>: <span class="hljs-literal">true</span> });
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   sequence: &#x27;I have a problem with my iphone that needs to be resolved asap!&#x27;,</span>
<span class="hljs-comment">//   labels: [ &#x27;urgent&#x27;, &#x27;phone&#x27;, &#x27;computer&#x27;, &#x27;tablet&#x27;, &#x27;not urgent&#x27; ],</span>
<span class="hljs-comment">//   scores: [ 0.9958870956360275, 0.9923963400697035, 0.002333537946160235, 0.0015134138567598765, 0.0010699384208377163 ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Wt=new J({props:{title:"new ZeroShotClassificationPipeline(options)",local:"new-zeroshotclassificationpipelineoptions",headingTag:"h3"}}),Lt=new J({props:{title:"zeroShotClassificationPipeline._call(texts, candidate_labels, options) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>",local:"zeroshotclassificationpipelinecalltexts-candidatelabels-options--code-promise--objectarray--object----code",headingTag:"h3"}}),Ot=new J({props:{title:"pipelines.FeatureExtractionPipeline",local:"pipelinesfeatureextractionpipeline",headingTag:"h2"}}),tl=new h({props:{code:"bGV0JTIwZXh0cmFjdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnZmVhdHVyZS1leHRyYWN0aW9uJyUyQyUyMCdYZW5vdmElMkZiZXJ0LWJhc2UtdW5jYXNlZCclMkMlMjAlN0IlMjByZXZpc2lvbiUzQSUyMCdkZWZhdWx0JyUyMCU3RCklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGV4dHJhY3RvcignVGhpcyUyMGlzJTIwYSUyMHNpbXBsZSUyMHRlc3QuJyklM0IlMEElMkYlMkYlMjBUZW5zb3IlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjB0eXBlJTNBJTIwJ2Zsb2F0MzInJTJDJTBBJTJGJTJGJTIwJTIwJTIwZGF0YSUzQSUyMEZsb2F0MzJBcnJheSUyMCU1QjAuMDU5Mzk5MjQ3MTY5NDk0NjMlMkMlMjAwLjAyMTY1NTkzNTc5NDExNTA2NyUyQyUyMC4uLiU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMGRpbXMlM0ElMjAlNUIxJTJDJTIwOCUyQyUyMDc2OCU1RCUwQSUyRiUyRiUyMCU3RA==",highlighted:`<span class="hljs-keyword">let</span> extractor = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;feature-extraction&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-uncased&#x27;</span>, { <span class="hljs-attr">revision</span>: <span class="hljs-string">&#x27;default&#x27;</span> });
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">extractor</span>(<span class="hljs-string">&#x27;This is a simple test.&#x27;</span>);
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   data: Float32Array [0.05939924716949463, 0.021655935794115067, ...],</span>
<span class="hljs-comment">//   dims: [1, 8, 768]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),sl=new h({props:{code:"bGV0JTIwZXh0cmFjdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnZmVhdHVyZS1leHRyYWN0aW9uJyUyQyUyMCdYZW5vdmElMkZiZXJ0LWJhc2UtdW5jYXNlZCclMkMlMjAlN0IlMjByZXZpc2lvbiUzQSUyMCdkZWZhdWx0JyUyMCU3RCklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGV4dHJhY3RvcignVGhpcyUyMGlzJTIwYSUyMHNpbXBsZSUyMHRlc3QuJyUyQyUyMCU3QiUyMHBvb2xpbmclM0ElMjAnbWVhbiclMkMlMjBub3JtYWxpemUlM0ElMjB0cnVlJTIwJTdEKSUzQiUwQSUyRiUyRiUyMFRlbnNvciUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMHR5cGUlM0ElMjAnZmxvYXQzMiclMkMlMEElMkYlMkYlMjAlMjAlMjBkYXRhJTNBJTIwRmxvYXQzMkFycmF5JTIwJTVCMC4wMzM3Mzc3ODk4Mzk1MDYxNSUyQyUyMC0wLjAxMDEwNjA3NzQxNzczMTI4NSUyQyUyMC4uLiU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMGRpbXMlM0ElMjAlNUIxJTJDJTIwNzY4JTVEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> extractor = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;feature-extraction&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-uncased&#x27;</span>, { <span class="hljs-attr">revision</span>: <span class="hljs-string">&#x27;default&#x27;</span> });
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">extractor</span>(<span class="hljs-string">&#x27;This is a simple test.&#x27;</span>, { <span class="hljs-attr">pooling</span>: <span class="hljs-string">&#x27;mean&#x27;</span>, <span class="hljs-attr">normalize</span>: <span class="hljs-literal">true</span> });
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   data: Float32Array [0.03373778983950615, -0.010106077417731285, ...],</span>
<span class="hljs-comment">//   dims: [1, 768]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),nl=new h({props:{code:"bGV0JTIwZXh0cmFjdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnZmVhdHVyZS1leHRyYWN0aW9uJyUyQyUyMCdYZW5vdmElMkZhbGwtTWluaUxNLUw2LXYyJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGV4dHJhY3RvcignVGhpcyUyMGlzJTIwYSUyMHNpbXBsZSUyMHRlc3QuJyUyQyUyMCU3QiUyMHBvb2xpbmclM0ElMjAnbWVhbiclMkMlMjBub3JtYWxpemUlM0ElMjB0cnVlJTIwJTdEKSUzQiUwQSUyRiUyRiUyMFRlbnNvciUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMHR5cGUlM0ElMjAnZmxvYXQzMiclMkMlMEElMkYlMkYlMjAlMjAlMjBkYXRhJTNBJTIwRmxvYXQzMkFycmF5JTIwJTVCMC4wOTA5NDk4MjU5NDI1MTYzMyUyQyUyMC0wLjAxNDc3NDI0NjE0MTMxNDUwNyUyQyUyMC4uLiU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMGRpbXMlM0ElMjAlNUIxJTJDJTIwMzg0JTVEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> extractor = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;feature-extraction&#x27;</span>, <span class="hljs-string">&#x27;Xenova/all-MiniLM-L6-v2&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">extractor</span>(<span class="hljs-string">&#x27;This is a simple test.&#x27;</span>, { <span class="hljs-attr">pooling</span>: <span class="hljs-string">&#x27;mean&#x27;</span>, <span class="hljs-attr">normalize</span>: <span class="hljs-literal">true</span> });
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   data: Float32Array [0.09094982594251633, -0.014774246141314507, ...],</span>
<span class="hljs-comment">//   dims: [1, 384]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),ol=new J({props:{title:"featureExtractionPipeline._call(texts, options) ⇒",local:"featureextractionpipelinecalltexts-options-",headingTag:"h3"}}),ml=new J({props:{title:"pipelines.AudioClassificationPipeline",local:"pipelinesaudioclassificationpipeline",headingTag:"h2"}}),ul=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZqZmsud2F2JyUzQiUwQWxldCUyMGNsYXNzaWZpZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdhdWRpby1jbGFzc2lmaWNhdGlvbiclMkMlMjAnWGVub3ZhJTJGd2F2MnZlYzItbGFyZ2UteGxzci01My1nZW5kZXItcmVjb2duaXRpb24tbGlicmlzcGVlY2gnKSUzQiUwQWxldCUyMG91dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xhc3NpZmllcih1cmwpJTNCJTBBJTJGJTJGJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnbWFsZSclMkMlMjBzY29yZSUzQSUyMDAuOTk4MTU0MjIyOTY1MjQwNSUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ2ZlbWFsZSclMkMlMjBzY29yZSUzQSUyMDAuMDAxODQ1NzQ3ODE0NTEzNzQzJTIwJTdEJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;audio-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/wav2vec2-large-xlsr-53-gender-recognition-librispeech&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;male&#x27;, score: 0.9981542229652405 },</span>
<span class="hljs-comment">//   { label: &#x27;female&#x27;, score: 0.001845747814513743 }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),jl=new J({props:{title:"new AudioClassificationPipeline(options)",local:"new-audioclassificationpipelineoptions",headingTag:"h3"}}),xl=new J({props:{title:"audioClassificationPipeline._call(audio, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>",local:"audioclassificationpipelinecallaudio-options--code-promise--array--object--object--code",headingTag:"h3"}}),Bl=new J({props:{title:"pipelines.AutomaticSpeechRecognitionPipeline",local:"pipelinesautomaticspeechrecognitionpipeline",headingTag:"h2"}}),Zl=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZqZmsud2F2JyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci10aW55LmVuJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zY3JpYmVyKHVybCklM0IlMEElMkYlMkYlMjAlN0IlMjB0ZXh0JTNBJTIwJTIyJTIwQW5kJTIwc28lMjBteSUyMGZlbGxvdyUyMEFtZXJpY2FucyUyMGFzayUyMG5vdCUyMHdoYXQlMjB5b3VyJTIwY291bnRyeSUyMGNhbiUyMGRvJTIwZm9yJTIweW91JTJDJTIwYXNrJTIwd2hhdCUyMHlvdSUyMGNhbiUyMGRvJTIwZm9yJTIweW91ciUyMGNvdW50cnkuJTIyJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url);
<span class="hljs-comment">// { text: &quot; And so my fellow Americans ask not what your country can do for you, ask what you can do for your country.&quot; }</span>`,wrap:!1}}),Al=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZqZmsud2F2JyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci10aW55LmVuJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zY3JpYmVyKHVybCUyQyUyMCU3QiUyMHJldHVybl90aW1lc3RhbXBzJTNBJTIwdHJ1ZSUyMCU3RCklM0IlMEElMkYlMkYlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjB0ZXh0JTNBJTIwJTIyJTIwQW5kJTIwc28lMjBteSUyMGZlbGxvdyUyMEFtZXJpY2FucyUyMGFzayUyMG5vdCUyMHdoYXQlMjB5b3VyJTIwY291bnRyeSUyMGNhbiUyMGRvJTIwZm9yJTIweW91JTJDJTIwYXNrJTIwd2hhdCUyMHlvdSUyMGNhbiUyMGRvJTIwZm9yJTIweW91ciUyMGNvdW50cnkuJTIyJTBBJTJGJTJGJTIwJTIwJTIwY2h1bmtzJTNBJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTIwdGltZXN0YW1wJTNBJTIwJTVCMCUyQyUyMDglNUQlMkMlMjAlMjB0ZXh0JTNBJTIwJTIyJTIwQW5kJTIwc28lMjBteSUyMGZlbGxvdyUyMEFtZXJpY2FucyUyMGFzayUyMG5vdCUyMHdoYXQlMjB5b3VyJTIwY291bnRyeSUyMGNhbiUyMGRvJTIwZm9yJTIweW91JTIyJTIwJTdEJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTIwdGltZXN0YW1wJTNBJTIwJTVCOCUyQyUyMDExJTVEJTJDJTIwdGV4dCUzQSUyMCUyMiUyMGFzayUyMHdoYXQlMjB5b3UlMjBjYW4lMjBkbyUyMGZvciUyMHlvdXIlMjBjb3VudHJ5LiUyMiUyMCU3RCUwQSUyRiUyRiUyMCUyMCUyMCU1RCUwQSUyRiUyRiUyMCU3RA==",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">return_timestamps</span>: <span class="hljs-literal">true</span> });
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   text: &quot; And so my fellow Americans ask not what your country can do for you, ask what you can do for your country.&quot;</span>
<span class="hljs-comment">//   chunks: [</span>
<span class="hljs-comment">//     { timestamp: [0, 8],  text: &quot; And so my fellow Americans ask not what your country can do for you&quot; }</span>
<span class="hljs-comment">//     { timestamp: [8, 11], text: &quot; ask what you can do for your country.&quot; }</span>
<span class="hljs-comment">//   ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),_l=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZqZmsud2F2JyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci10aW55LmVuJyUyQyUyMCU3QiUwQSUyMCUyMCUyMCUyMHJldmlzaW9uJTNBJTIwJ291dHB1dF9hdHRlbnRpb25zJyUyQyUwQSU3RCklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zY3JpYmVyKHVybCUyQyUyMCU3QiUyMHJldHVybl90aW1lc3RhbXBzJTNBJTIwJ3dvcmQnJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU3QiUwQSUyRiUyRiUyMCUyMCUyMCUyMnRleHQlMjIlM0ElMjAlMjIlMjBBbmQlMjBzbyUyMG15JTIwZmVsbG93JTIwQW1lcmljYW5zJTIwYXNrJTIwbm90JTIwd2hhdCUyMHlvdXIlMjBjb3VudHJ5JTIwY2FuJTIwZG8lMjBmb3IlMjB5b3UlMjBhc2slMjB3aGF0JTIweW91JTIwY2FuJTIwZG8lMjBmb3IlMjB5b3VyJTIwY291bnRyeS4lMjIlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjJjaHVua3MlMjIlM0ElMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyJTIwQW5kJTIyJTJDJTIwJTIydGltZXN0YW1wJTIyJTNBJTIwJTVCMCUyQyUyMDAuNzglNUQlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyJTIwc28lMjIlMkMlMjAlMjJ0aW1lc3RhbXAlMjIlM0ElMjAlNUIwLjc4JTJDJTIwMS4wNiU1RCUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCU3QiUyMCUyMnRleHQlMjIlM0ElMjAlMjIlMjBteSUyMiUyQyUyMCUyMnRpbWVzdGFtcCUyMiUzQSUyMCU1QjEuMDYlMkMlMjAxLjQ2JTVEJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTIwJTIydGV4dCUyMiUzQSUyMCUyMiUyMGZvciUyMiUyQyUyMCUyMnRpbWVzdGFtcCUyMiUzQSUyMCU1QjkuNzIlMkMlMjA5LjkyJTVEJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTIwJTIydGV4dCUyMiUzQSUyMCUyMiUyMHlvdXIlMjIlMkMlMjAlMjJ0aW1lc3RhbXAlMjIlM0ElMjAlNUI5LjkyJTJDJTIwMTAuMjIlNUQlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyJTIwY291bnRyeS4lMjIlMkMlMjAlMjJ0aW1lc3RhbXAlMjIlM0ElMjAlNUIxMC4yMiUyQyUyMDEzLjUlNUQlMjAlN0QlMEElMkYlMkYlMjAlMjAlMjAlNUQlMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/jfk.wav&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>, {
    <span class="hljs-attr">revision</span>: <span class="hljs-string">&#x27;output_attentions&#x27;</span>,
});
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">return_timestamps</span>: <span class="hljs-string">&#x27;word&#x27;</span> });
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   &quot;text&quot;: &quot; And so my fellow Americans ask not what your country can do for you ask what you can do for your country.&quot;,</span>
<span class="hljs-comment">//   &quot;chunks&quot;: [</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; And&quot;, &quot;timestamp&quot;: [0, 0.78] },</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; so&quot;, &quot;timestamp&quot;: [0.78, 1.06] },</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; my&quot;, &quot;timestamp&quot;: [1.06, 1.46] },</span>
<span class="hljs-comment">//     ...</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; for&quot;, &quot;timestamp&quot;: [9.72, 9.92] },</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; your&quot;, &quot;timestamp&quot;: [9.92, 10.22] },</span>
<span class="hljs-comment">//     { &quot;text&quot;: &quot; country.&quot;, &quot;timestamp&quot;: [10.22, 13.5] }</span>
<span class="hljs-comment">//   ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Rl=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZmcmVuY2gtYXVkaW8ubXAzJyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci1zbWFsbCcpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2NyaWJlcih1cmwlMkMlMjAlN0IlMjBsYW5ndWFnZSUzQSUyMCdmcmVuY2gnJTJDJTIwdGFzayUzQSUyMCd0cmFuc2NyaWJlJyUyMCU3RCklM0IlMEElMkYlMkYlMjAlN0IlMjB0ZXh0JTNBJTIwJTIyJTIwSidhZG9yZSUyQyUyMGonYWltZSUyQyUyMGplJTIwbidhaW1lJTIwcGFzJTJDJTIwamUlMjBkJUMzJUE5dGVzdGUuJTIyJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/french-audio.mp3&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-small&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">language</span>: <span class="hljs-string">&#x27;french&#x27;</span>, <span class="hljs-attr">task</span>: <span class="hljs-string">&#x27;transcribe&#x27;</span> });
<span class="hljs-comment">// { text: &quot; J&#x27;adore, j&#x27;aime, je n&#x27;aime pas, je déteste.&quot; }</span>`,wrap:!1}}),Vl=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZmcmVuY2gtYXVkaW8ubXAzJyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci1zbWFsbCcpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjB0cmFuc2NyaWJlcih1cmwlMkMlMjAlN0IlMjBsYW5ndWFnZSUzQSUyMCdmcmVuY2gnJTJDJTIwdGFzayUzQSUyMCd0cmFuc2xhdGUnJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU3QiUyMHRleHQlM0ElMjAlMjIlMjBJJTIwbG92ZSUyQyUyMEklMjBsaWtlJTJDJTIwSSUyMGRvbid0JTIwbGlrZSUyQyUyMEklMjBoYXRlLiUyMiUyMCU3RA==",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/french-audio.mp3&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-small&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">language</span>: <span class="hljs-string">&#x27;french&#x27;</span>, <span class="hljs-attr">task</span>: <span class="hljs-string">&#x27;translate&#x27;</span> });
<span class="hljs-comment">// { text: &quot; I love, I like, I don&#x27;t like, I hate.&quot; }</span>`,wrap:!1}}),El=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0ZWRfNjAud2F2JyUzQiUwQWxldCUyMHRyYW5zY3JpYmVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiclMkMlMjAnWGVub3ZhJTJGd2hpc3Blci10aW55LmVuJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHRyYW5zY3JpYmVyKHVybCUyQyUyMCU3QiUyMGNodW5rX2xlbmd0aF9zJTNBJTIwMzAlMkMlMjBzdHJpZGVfbGVuZ3RoX3MlM0ElMjA1JTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU3QiUyMHRleHQlM0ElMjAlMjIlMjBTbyUyMGluJTIwY29sbGVnZSUyQyUyMEklMjB3YXMlMjBhJTIwZ292ZXJubWVudCUyMG1ham9yJTJDJTIwd2hpY2glMjBtZWFucyUyMCU1Qi4uLiU1RCUyMFNvJTIwSSdkJTIwc3RhcnQlMjBvZmYlMjBsaWdodCUyMGFuZCUyMEknZCUyMGJ1bXAlMjBpdCUyMHVwJTIyJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/ted_60.wav&#x27;</span>;
<span class="hljs-keyword">let</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(url, { <span class="hljs-attr">chunk_length_s</span>: <span class="hljs-number">30</span>, <span class="hljs-attr">stride_length_s</span>: <span class="hljs-number">5</span> });
<span class="hljs-comment">// { text: &quot; So in college, I was a government major, which means [...] So I&#x27;d start off light and I&#x27;d bump it up&quot; }</span>`,wrap:!1}}),Sl=new J({props:{title:"new AutomaticSpeechRecognitionPipeline(options)",local:"new-automaticspeechrecognitionpipelineoptions",headingTag:"h3"}}),Dl=new J({props:{title:"automaticSpeechRecognitionPipeline._call(audio, [kwargs]) ⇒ <code> Promise. < Object > </code>",local:"automaticspeechrecognitionpipelinecallaudio-kwargs--code-promise--object--code",headingTag:"h3"}}),ts=new J({props:{title:"pipelines.ImageToTextPipeline",local:"pipelinesimagetotextpipeline",headingTag:"h2"}}),is=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZjYXRzLmpwZyclM0IlMEFsZXQlMjBjYXB0aW9uZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdpbWFnZS10by10ZXh0JyUyQyUyMCdYZW5vdmElMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNhcHRpb25lcih1cmwpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJTIwZ2VuZXJhdGVkX3RleHQlM0ElMjAnYSUyMGNhdCUyMGxheWluZyUyMG9uJTIwYSUyMGNvdWNoJTIwd2l0aCUyMGFub3RoZXIlMjBjYXQnJTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/cats.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> captioner = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-to-text&#x27;</span>, <span class="hljs-string">&#x27;Xenova/vit-gpt2-image-captioning&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">captioner</span>(url);
<span class="hljs-comment">// [{ generated_text: &#x27;a cat laying on a couch with another cat&#x27; }]</span>`,wrap:!1}}),os=new J({props:{title:"new ImageToTextPipeline(options)",local:"new-imagetotextpipelineoptions",headingTag:"h3"}}),Ms=new J({props:{title:"imageToTextPipeline._call(images, [generate_kwargs]) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>",local:"imagetotextpipelinecallimages-generatekwargs--code-promise--objectarray--object----code",headingTag:"h3"}}),Js=new J({props:{title:"pipelines.ImageClassificationPipeline",local:"pipelinesimageclassificationpipeline",headingTag:"h2"}}),js=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2ltYWdlLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCcpJTNCJTBBbGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGcnJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHVybCklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlN0JsYWJlbCUzQSUyMCd0aWdlciUyQyUyMFBhbnRoZXJhJTIwdGlncmlzJyUyQyUyMHNjb3JlJTNBJTIwMC42MzI2OTU3MzQ1MDA4ODUlN0QlMkMlMEElMkYlMkYlMjAlNUQ=",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/vit-base-patch16-224&#x27;</span>);
<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/tiger.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   {label: &#x27;tiger, Panthera tigris&#x27;, score: 0.632695734500885},</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),fs=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2ltYWdlLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCcpJTNCJTBBbGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGcnJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHVybCUyQyUyMCU3QiUyMHRvcGslM0ElMjAzJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RpZ2VyJTJDJTIwUGFudGhlcmElMjB0aWdyaXMnJTJDJTIwc2NvcmUlM0ElMjAwLjYzMjY5NTczNDUwMDg4NSUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMGxhYmVsJTNBJTIwJ3RpZ2VyJTIwY2F0JyUyQyUyMHNjb3JlJTNBJTIwMC4zNjM0ODI1NjQ2ODc3Mjg5JTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnbGlvbiUyQyUyMGtpbmclMjBvZiUyMGJlYXN0cyUyQyUyMFBhbnRoZXJhJTIwbGVvJyUyQyUyMHNjb3JlJTNBJTIwMC4wMDA0NTA2MDMwODE4NDQ3NDcwNyUyMCU3RCUyQyUwQSUyRiUyRiUyMCU1RA==",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/vit-base-patch16-224&#x27;</span>);
<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/tiger.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url, { <span class="hljs-attr">topk</span>: <span class="hljs-number">3</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;tiger, Panthera tigris&#x27;, score: 0.632695734500885 },</span>
<span class="hljs-comment">//   { label: &#x27;tiger cat&#x27;, score: 0.3634825646877289 },</span>
<span class="hljs-comment">//   { label: &#x27;lion, king of beasts, Panthera leo&#x27;, score: 0.00045060308184474707 },</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),xs=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2ltYWdlLWNsYXNzaWZpY2F0aW9uJyUyQyUyMCdYZW5vdmElMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCcpJTNCJTBBbGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGcnJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBjbGFzc2lmaWVyKHVybCUyQyUyMCU3QiUyMHRvcGslM0ElMjAwJTIwJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCU3QmxhYmVsJTNBJTIwJ3RpZ2VyJTJDJTIwUGFudGhlcmElMjB0aWdyaXMnJTJDJTIwc2NvcmUlM0ElMjAwLjYzMjY5NTczNDUwMDg4NSU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QmxhYmVsJTNBJTIwJ3RpZ2VyJTIwY2F0JyUyQyUyMHNjb3JlJTNBJTIwMC4zNjM0ODI1NjQ2ODc3Mjg5JTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCbGFiZWwlM0ElMjAnbGlvbiUyQyUyMGtpbmclMjBvZiUyMGJlYXN0cyUyQyUyMFBhbnRoZXJhJTIwbGVvJyUyQyUyMHNjb3JlJTNBJTIwMC4wMDA0NTA2MDMwODE4NDQ3NDcwNyU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QmxhYmVsJTNBJTIwJ2phZ3VhciUyQyUyMHBhbnRoZXIlMkMlMjBQYW50aGVyYSUyMG9uY2ElMkMlMjBGZWxpcyUyMG9uY2EnJTJDJTIwc2NvcmUlM0ElMjAwLjAwMDM1NDY1NDk5OTY4MjY3OTc3JTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwLi4uJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/vit-base-patch16-224&#x27;</span>);
<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/tiger.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url, { <span class="hljs-attr">topk</span>: <span class="hljs-number">0</span> });
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   {label: &#x27;tiger, Panthera tigris&#x27;, score: 0.632695734500885},</span>
<span class="hljs-comment">//   {label: &#x27;tiger cat&#x27;, score: 0.3634825646877289},</span>
<span class="hljs-comment">//   {label: &#x27;lion, king of beasts, Panthera leo&#x27;, score: 0.00045060308184474707},</span>
<span class="hljs-comment">//   {label: &#x27;jaguar, panther, Panthera onca, Felis onca&#x27;, score: 0.00035465499968267977},</span>
<span class="hljs-comment">//   ...</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),ks=new J({props:{title:"new ImageClassificationPipeline(options)",local:"new-imageclassificationpipelineoptions",headingTag:"h3"}}),Zs=new J({props:{title:"imageClassificationPipeline._call(images, options) ⇒ <code> Promise. < any > </code>",local:"imageclassificationpipelinecallimages-options--code-promise--any--code",headingTag:"h3"}}),$s=new J({props:{title:"pipelines.ImageSegmentationPipeline",local:"pipelinesimagesegmentationpipeline",headingTag:"h2"}}),Vs=new h({props:{code:"bGV0JTIwdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZjYXRzLmpwZyclM0IlMEFsZXQlMjBzZWdtZW50ZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdpbWFnZS1zZWdtZW50YXRpb24nJTJDJTIwJ1hlbm92YSUyRmRldHItcmVzbmV0LTUwLXBhbm9wdGljJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMHNlZ21lbnRlcih1cmwpJTNCJTBBJTJGJTJGJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAncmVtb3RlJyUyQyUyMHNjb3JlJTNBJTIwMC45OTg0NjQ5NDE5Nzg0NTQ2JTJDJTIwbWFzayUzQSUyMFJhd0ltYWdlJTIwJTdCJTIwLi4uJTIwJTdEJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwbGFiZWwlM0ElMjAnY2F0JyUyQyUyMHNjb3JlJTNBJTIwMC45OTk0MzE2MTAxMDc0MjE5JTJDJTIwbWFzayUzQSUyMFJhd0ltYWdlJTIwJTdCJTIwLi4uJTIwJTdEJTIwJTdEJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/cats.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> segmenter = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;image-segmentation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/detr-resnet-50-panoptic&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">segmenter</span>(url);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { label: &#x27;remote&#x27;, score: 0.9984649419784546, mask: RawImage { ... } },</span>
<span class="hljs-comment">//   { label: &#x27;cat&#x27;, score: 0.9994316101074219, mask: RawImage { ... } }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),Ws=new J({props:{title:"new ImageSegmentationPipeline(options)",local:"new-imagesegmentationpipelineoptions",headingTag:"h3"}}),Ls=new J({props:{title:"imageSegmentationPipeline._call(images, options) ⇒ <code> Promise. < Array > </code>",local:"imagesegmentationpipelinecallimages-options--code-promise--array--code",headingTag:"h3"}}),Ks=new J({props:{title:"pipelines.ZeroShotImageClassificationPipeline",local:"pipelineszeroshotimageclassificationpipeline",headingTag:"h2"}}),li=new h({props:{code:"bGV0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3plcm8tc2hvdC1pbWFnZS1jbGFzc2lmaWNhdGlvbiclMkMlMjAnWGVub3ZhJTJGY2xpcC12aXQtYmFzZS1wYXRjaDMyJyklM0IlMEFsZXQlMjB1cmwlMjAlM0QlMjAnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRnRpZ2VyLmpwZyclM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIodXJsJTJDJTIwJTVCJ3RpZ2VyJyUyQyUyMCdob3JzZSclMkMlMjAnZG9nJyU1RCklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlN0IlMjBzY29yZSUzQSUyMDAuOTk5MzkxNzk0MjA0NzExOSUyQyUyMGxhYmVsJTNBJTIwJ3RpZ2VyJyUyMCU3RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCU3QiUyMHNjb3JlJTNBJTIwMC4wMDAzNTE5Mjk0ODQxNjgwNjc2JTJDJTIwbGFiZWwlM0ElMjAnaG9yc2UnJTIwJTdEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTdCJTIwc2NvcmUlM0ElMjAwLjAwMDI1NjI2OTg3OTE3MzQ4NzQlMkMlMjBsYWJlbCUzQSUyMCdkb2cnJTIwJTdEJTBBJTJGJTJGJTIwJTVE",highlighted:`<span class="hljs-keyword">let</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;zero-shot-image-classification&#x27;</span>, <span class="hljs-string">&#x27;Xenova/clip-vit-base-patch32&#x27;</span>);
<span class="hljs-keyword">let</span> url = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/tiger.jpg&#x27;</span>;
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(url, [<span class="hljs-string">&#x27;tiger&#x27;</span>, <span class="hljs-string">&#x27;horse&#x27;</span>, <span class="hljs-string">&#x27;dog&#x27;</span>]);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//   { score: 0.9993917942047119, label: &#x27;tiger&#x27; },</span>
<span class="hljs-comment">//   { score: 0.0003519294841680676, label: &#x27;horse&#x27; },</span>
<span class="hljs-comment">//   { score: 0.0002562698791734874, label: &#x27;dog&#x27; }</span>
<span class="hljs-comment">// ]</span>`,wrap:!1}}),ai=new J({props:{title:"new ZeroShotImageClassificationPipeline(options)",local:"new-zeroshotimageclassificationpipelineoptions",headingTag:"h3"}}),ci=new J({props:{title:"zeroShotImageClassificationPipeline._call(images, candidate_labels, options) ⇒ <code> Promise. < any > </code>",local:"zeroshotimageclassificationpipelinecallimages-candidatelabels-options--code-promise--any--code",headingTag:"h3"}}),yi=new J({props:{title:"pipelines.ObjectDetectionPipeline",local:"pipelinesobjectdetectionpipeline",headingTag:"h2"}}),hi=new h({props:{code:"bGV0JTIwaW1nJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZjYXRzLmpwZyclM0IlMEElMEFsZXQlMjBkZXRlY3RvciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ29iamVjdC1kZXRlY3Rpb24nJTJDJTIwJ1hlbm92YSUyRmRldHItcmVzbmV0LTUwJyklM0IlMEFsZXQlMjBvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGRldGVjdG9yKGltZyUyQyUyMCU3QiUyMHRocmVzaG9sZCUzQSUyMDAuOSUyMCU3RCklM0IlMEElMkYlMkYlMjAlNUIlN0IlMEElMkYlMkYlMjAlMjAlMjAlMjJzY29yZSUyMiUzQSUyMDAuOTk3NjM3MDkzMDY3MTY5MiUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTIycmVtb3RlJTIyJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIyYm94JTIyJTNBJTIwJTdCJTIwJTIyeG1pbiUyMiUzQSUyMDMxJTJDJTIwJTIyeW1pbiUyMiUzQSUyMDY4JTJDJTIwJTIyeG1heCUyMiUzQSUyMDE5MCUyQyUyMCUyMnltYXglMjIlM0ElMjAxMTglMjAlN0QlMEElMkYlMkYlMjAlN0QlMkMlMEElMkYlMkYlMjAuLi4lMEElMkYlMkYlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjAlMjJzY29yZSUyMiUzQSUyMDAuOTk4NDA5MjExNjM1NTg5NiUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTIyY2F0JTIyJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIyYm94JTIyJTNBJTIwJTdCJTIwJTIyeG1pbiUyMiUzQSUyMDMzMSUyQyUyMCUyMnltaW4lMjIlM0ElMjAxOSUyQyUyMCUyMnhtYXglMjIlM0ElMjA2NDklMkMlMjAlMjJ5bWF4JTIyJTNBJTIwMzcxJTIwJTdEJTBBJTJGJTJGJTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">let</span> img = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/cats.jpg&#x27;</span>;

<span class="hljs-keyword">let</span> detector = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;object-detection&#x27;</span>, <span class="hljs-string">&#x27;Xenova/detr-resnet-50&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">detector</span>(img, { <span class="hljs-attr">threshold</span>: <span class="hljs-number">0.9</span> });
<span class="hljs-comment">// [{</span>
<span class="hljs-comment">//   &quot;score&quot;: 0.9976370930671692,</span>
<span class="hljs-comment">//   &quot;label&quot;: &quot;remote&quot;,</span>
<span class="hljs-comment">//   &quot;box&quot;: { &quot;xmin&quot;: 31, &quot;ymin&quot;: 68, &quot;xmax&quot;: 190, &quot;ymax&quot;: 118 }</span>
<span class="hljs-comment">// },</span>
<span class="hljs-comment">// ...</span>
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   &quot;score&quot;: 0.9984092116355896,</span>
<span class="hljs-comment">//   &quot;label&quot;: &quot;cat&quot;,</span>
<span class="hljs-comment">//   &quot;box&quot;: { &quot;xmin&quot;: 331, &quot;ymin&quot;: 19, &quot;xmax&quot;: 649, &quot;ymax&quot;: 371 }</span>
<span class="hljs-comment">// }]</span>`,wrap:!1}}),fi=new J({props:{title:"new ObjectDetectionPipeline(options)",local:"new-objectdetectionpipelineoptions",headingTag:"h3"}}),gi=new J({props:{title:"objectDetectionPipeline._call(images, options)",local:"objectdetectionpipelinecallimages-options",headingTag:"h3"}}),vi=new J({props:{title:"pipelines.DocumentQuestionAnsweringPipeline",local:"pipelinesdocumentquestionansweringpipeline",headingTag:"h2"}}),Ai=new h({props:{code:"bGV0JTIwaW1hZ2UlMjAlM0QlMjAnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRmludm9pY2UucG5nJyUzQiUwQWxldCUyMHF1ZXN0aW9uJTIwJTNEJTIwJ1doYXQlMjBpcyUyMHRoZSUyMGludm9pY2UlMjBudW1iZXIlM0YnJTNCJTBBJTBBbGV0JTIwcWFfcGlwZWxpbmUlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdkb2N1bWVudC1xdWVzdGlvbi1hbnN3ZXJpbmcnJTJDJTIwJ1hlbm92YSUyRmRvbnV0LWJhc2UtZmluZXR1bmVkLWRvY3ZxYScpJTNCJTBBbGV0JTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjBxYV9waXBlbGluZShpbWFnZSUyQyUyMHF1ZXN0aW9uKSUzQiUwQSUyRiUyRiUyMCU1QiU3QiUyMGFuc3dlciUzQSUyMCd1cy0wMDEnJTIwJTdEJTVE",highlighted:`<span class="hljs-keyword">let</span> image = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/invoice.png&#x27;</span>;
<span class="hljs-keyword">let</span> question = <span class="hljs-string">&#x27;What is the invoice number?&#x27;</span>;

<span class="hljs-keyword">let</span> qa_pipeline = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;document-question-answering&#x27;</span>, <span class="hljs-string">&#x27;Xenova/donut-base-finetuned-docvqa&#x27;</span>);
<span class="hljs-keyword">let</span> output = <span class="hljs-keyword">await</span> <span class="hljs-title function_">qa_pipeline</span>(image, question);
<span class="hljs-comment">// [{ answer: &#x27;us-001&#x27; }]</span>`,wrap:!1}}),Ri=new J({props:{title:"new DocumentQuestionAnsweringPipeline(options)",local:"new-documentquestionansweringpipelineoptions",headingTag:"h3"}}),Ei=new J({props:{title:"documentQuestionAnsweringPipeline._call(image, question, [generate_kwargs]) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>",local:"documentquestionansweringpipelinecallimage-question-generatekwargs--code-promise--objectarray--object----code",headingTag:"h3"}}),Xi=new J({props:{title:"pipelines.TextToAudioPipeline",local:"pipelinestexttoaudiopipeline",headingTag:"h2"}}),Di=new h({props:{code:"bGV0JTIwc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRlhlbm92YSUyRnRyYW5zZm9ybWVycy5qcy1kb2NzJTJGcmVzb2x2ZSUyRm1haW4lMkZzcGVha2VyX2VtYmVkZGluZ3MuYmluJyUzQiUwQWxldCUyMHN5bnRoZXNpemVyJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgndGV4dC10by1zcGVlY2gnJTJDJTIwJ1hlbm92YSUyRnNwZWVjaHQ1X3R0cyclMkMlMjAlN0IlMjBxdWFudGl6ZWQlM0ElMjBmYWxzZSUyMCU3RCklM0IlMEFsZXQlMjBvdXQlMjAlM0QlMjBhd2FpdCUyMHN5bnRoZXNpemVyKCdIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJyUyQyUyMCU3QiUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyMCU3RCklM0IlMEElMkYlMkYlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjBhdWRpbyUzQSUyMEZsb2F0MzJBcnJheSgyNjExMiklMjAlNUItMC4wMDAwNTY1NzMzNzg5Njk5MTUyMSUyQyUyMDAuMDAwMjA1ODM4NzQ3MjA2MTQ0MDMlMkMlMjAuLi4lNUQlMkMlMEElMkYlMkYlMjAlMjAlMjBzYW1wbGluZ19yYXRlJTNBJTIwMTYwMDAlMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">let</span> speaker_embeddings = <span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/speaker_embeddings.bin&#x27;</span>;
<span class="hljs-keyword">let</span> synthesizer = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text-to-speech&#x27;</span>, <span class="hljs-string">&#x27;Xenova/speecht5_tts&#x27;</span>, { <span class="hljs-attr">quantized</span>: <span class="hljs-literal">false</span> });
<span class="hljs-keyword">let</span> out = <span class="hljs-keyword">await</span> <span class="hljs-title function_">synthesizer</span>(<span class="hljs-string">&#x27;Hello, my dog is cute&#x27;</span>, { speaker_embeddings });
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   audio: Float32Array(26112) [-0.00005657337896991521, 0.00020583874720614403, ...],</span>
<span class="hljs-comment">//   sampling_rate: 16000</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Oi=new h({props:{code:"aW1wb3J0JTIwd2F2ZWZpbGUlMjBmcm9tJTIwJ3dhdmVmaWxlJyUzQiUwQWltcG9ydCUyMGZzJTIwZnJvbSUyMCdmcyclM0IlMEElMEFsZXQlMjB3YXYlMjAlM0QlMjBuZXclMjB3YXZlZmlsZS5XYXZlRmlsZSgpJTNCJTBBd2F2LmZyb21TY3JhdGNoKDElMkMlMjBvdXQuc2FtcGxpbmdfcmF0ZSUyQyUyMCczMmYnJTJDJTIwb3V0LmF1ZGlvKSUzQiUwQWZzLndyaXRlRmlsZVN5bmMoJ291dC53YXYnJTJDJTIwd2F2LnRvQnVmZmVyKCkpJTNC",highlighted:`<span class="hljs-keyword">import</span> wavefile <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;wavefile&#x27;</span>;
<span class="hljs-keyword">import</span> fs <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;fs&#x27;</span>;

<span class="hljs-keyword">let</span> wav = <span class="hljs-keyword">new</span> wavefile.<span class="hljs-title class_">WaveFile</span>();
wav.<span class="hljs-title function_">fromScratch</span>(<span class="hljs-number">1</span>, out.<span class="hljs-property">sampling_rate</span>, <span class="hljs-string">&#x27;32f&#x27;</span>, out.<span class="hljs-property">audio</span>);
fs.<span class="hljs-title function_">writeFileSync</span>(<span class="hljs-string">&#x27;out.wav&#x27;</span>, wav.<span class="hljs-title function_">toBuffer</span>());`,wrap:!1}}),ln=new J({props:{title:"new TextToAudioPipeline(options)",local:"new-texttoaudiopipelineoptions",headingTag:"h3"}}),pn=new J({props:{title:"textToAudioPipeline._call(text_inputs, options) ⇒ <code> Promise. < Object > </code>",local:"texttoaudiopipelinecalltextinputs-options--code-promise--object--code",headingTag:"h3"}}),Mn=new J({props:{title:"pipelines.pipeline(task, [model], [options]) ⇒ <code> Promise. < Pipeline > </code>",local:"pipelinespipelinetask-model-options--code-promise--pipeline--code",headingTag:"h2"}}),hn=new J({props:{title:"pipelines~QuestionAnsweringResult : <code> object </code>",local:"pipelinesquestionansweringresult--code-object-code",headingTag:"h2"}}),fn=new J({props:{title:"pipelines~QuestionAnsweringReturnType : <code> Promise. < (QuestionAnsweringResult|Array < QuestionAnsweringResult > ) > </code>",local:"pipelinesquestionansweringreturntype--code-promise--questionansweringresultarray--questionansweringresult----code",headingTag:"h2"}}),Cn=new J({props:{title:"pipelines~ChunkCallback : <code> function </code>",local:"pipelineschunkcallback--code-function-code",headingTag:"h2"}}),{c(){w=a("meta"),Gn=i(),kn=a("p"),vn=i(),j=a("a"),Zn=i(),c(U.$$.fragment),Qn=i(),f=a("p"),f.textContent=Wm,An=i(),b=a("p"),b.innerHTML=zm,Nn=i(),c(x.$$.fragment),_n=i(),C=a("ul"),C.innerHTML=Sm,$n=i(),Rn=a("hr"),Yn=i(),g=a("a"),Vn=i(),c(I.$$.fragment),Pn=i(),k=a("p"),k.textContent=Xm,En=i(),B=a("p"),B.innerHTML=Lm,Hn=i(),G=a("ul"),G.innerHTML=Fm,Wn=i(),zn=a("hr"),Sn=i(),v=a("a"),Xn=i(),c(Z.$$.fragment),Ln=i(),Q=a("p"),Q.textContent=Dm,Fn=i(),A=a("table"),A.innerHTML=qm,Dn=i(),qn=a("hr"),On=i(),N=a("a"),Kn=i(),c(_.$$.fragment),ea=i(),$=a("p"),$.textContent=Om,ta=i(),R=a("p"),R.innerHTML=Km,la=i(),sa=a("hr"),ia=i(),Y=a("a"),na=i(),c(V.$$.fragment),aa=i(),P=a("p"),P.textContent=eT,pa=i(),E=a("p"),E.innerHTML=tT,oa=i(),H=a("table"),H.innerHTML=lT,da=i(),ca=a("hr"),ra=i(),W=a("a"),Ma=i(),c(z.$$.fragment),ma=i(),S=a("p"),S.innerHTML=sT,Ta=i(),X=a("p"),X.innerHTML=iT,ya=i(),c(L.$$.fragment),ua=i(),F=a("p"),F.innerHTML=nT,Ja=i(),c(D.$$.fragment),ha=i(),q=a("p"),q.innerHTML=aT,wa=i(),c(O.$$.fragment),ja=i(),K=a("p"),K.innerHTML=pT,Ua=i(),fa=a("hr"),ba=i(),ee=a("a"),xa=i(),c(te.$$.fragment),Ca=i(),le=a("p"),le.textContent=oT,ga=i(),se=a("p"),se.innerHTML=dT,Ia=i(),ie=a("table"),ie.innerHTML=cT,ka=i(),Ba=a("hr"),Ga=i(),ne=a("a"),va=i(),c(ae.$$.fragment),Za=i(),pe=a("p"),pe.innerHTML=rT,Qa=i(),oe=a("p"),oe.innerHTML=MT,Aa=i(),c(de.$$.fragment),Na=i(),ce=a("p"),ce.innerHTML=mT,_a=i(),c(re.$$.fragment),$a=i(),Me=a("p"),Me.innerHTML=TT,Ra=i(),Ya=a("hr"),Va=i(),me=a("a"),Pa=i(),c(Te.$$.fragment),Ea=i(),ye=a("p"),ye.textContent=yT,Ha=i(),ue=a("p"),ue.innerHTML=uT,Wa=i(),Je=a("table"),Je.innerHTML=JT,za=i(),Sa=a("hr"),Xa=i(),he=a("a"),La=i(),c(we.$$.fragment),Fa=i(),je=a("p"),je.innerHTML=hT,Da=i(),Ue=a("p"),Ue.innerHTML=wT,qa=i(),c(fe.$$.fragment),Oa=i(),be=a("p"),be.innerHTML=jT,Ka=i(),ep=a("hr"),tp=i(),xe=a("a"),lp=i(),c(Ce.$$.fragment),sp=i(),ge=a("p"),ge.textContent=UT,ip=i(),Ie=a("p"),Ie.innerHTML=fT,np=i(),ke=a("table"),ke.innerHTML=bT,ap=i(),pp=a("hr"),op=i(),Be=a("a"),dp=i(),c(Ge.$$.fragment),cp=i(),ve=a("p"),ve.innerHTML=xT,rp=i(),Ze=a("p"),Ze.innerHTML=CT,Mp=i(),c(Qe.$$.fragment),mp=i(),Ae=a("p"),Ae.innerHTML=gT,Tp=i(),c(Ne.$$.fragment),yp=i(),_e=a("p"),_e.innerHTML=IT,up=i(),Jp=a("hr"),hp=i(),$e=a("a"),wp=i(),c(Re.$$.fragment),jp=i(),Ye=a("p"),Ye.textContent=kT,Up=i(),Ve=a("p"),Ve.innerHTML=BT,fp=i(),Pe=a("table"),Pe.innerHTML=GT,bp=i(),xp=a("hr"),Cp=i(),Ee=a("a"),gp=i(),c(He.$$.fragment),Ip=i(),We=a("p"),We.textContent=vT,kp=i(),ze=a("p"),ze.innerHTML=ZT,Bp=i(),c(Se.$$.fragment),Gp=i(),Xe=a("p"),Xe.innerHTML=QT,vp=i(),Zp=a("hr"),Qp=i(),Le=a("a"),Ap=i(),c(Fe.$$.fragment),Np=i(),De=a("p"),De.textContent=AT,_p=i(),qe=a("p"),qe.innerHTML=NT,$p=i(),Oe=a("ul"),Oe.innerHTML=_T,Rp=i(),Ke=a("table"),Ke.innerHTML=$T,Yp=i(),Vp=a("hr"),Pp=i(),et=a("a"),Ep=i(),c(tt.$$.fragment),Hp=i(),lt=a("p"),lt.textContent=RT,Wp=i(),st=a("p"),st.innerHTML=YT,zp=i(),c(it.$$.fragment),Sp=i(),nt=a("p"),nt.innerHTML=VT,Xp=i(),Lp=a("hr"),Fp=i(),at=a("a"),Dp=i(),c(pt.$$.fragment),qp=i(),ot=a("p"),ot.textContent=PT,Op=i(),dt=a("p"),dt.innerHTML=ET,Kp=i(),ct=a("p"),ct.innerHTML=HT,eo=i(),c(rt.$$.fragment),to=i(),Mt=a("p"),Mt.innerHTML=WT,lo=i(),mt=a("p"),mt.innerHTML=zT,so=i(),c(Tt.$$.fragment),io=i(),yt=a("p"),yt.innerHTML=ST,no=i(),ut=a("p"),ut.innerHTML=XT,ao=i(),c(Jt.$$.fragment),po=i(),ht=a("p"),ht.innerHTML=LT,oo=i(),co=a("hr"),ro=i(),wt=a("a"),Mo=i(),c(jt.$$.fragment),mo=i(),Ut=a("p"),Ut.innerHTML=FT,To=i(),ft=a("p"),ft.innerHTML=DT,yo=i(),c(bt.$$.fragment),uo=i(),xt=a("p"),xt.innerHTML=qT,Jo=i(),c(Ct.$$.fragment),ho=i(),gt=a("p"),gt.innerHTML=OT,wo=i(),c(It.$$.fragment),jo=i(),kt=a("p"),kt.innerHTML=KT,Uo=i(),fo=a("hr"),bo=i(),Bt=a("a"),xo=i(),c(Gt.$$.fragment),Co=i(),vt=a("p"),vt.textContent=ey,go=i(),Zt=a("p"),Zt.innerHTML=ty,Io=i(),Qt=a("table"),Qt.innerHTML=ly,ko=i(),Bo=a("hr"),Go=i(),At=a("a"),vo=i(),c(Nt.$$.fragment),Zo=i(),_t=a("p"),_t.innerHTML=sy,Qo=i(),$t=a("p"),$t.innerHTML=iy,Ao=i(),c(Rt.$$.fragment),No=i(),Yt=a("p"),Yt.innerHTML=ny,_o=i(),c(Vt.$$.fragment),$o=i(),Pt=a("p"),Pt.innerHTML=ay,Ro=i(),Et=a("ul"),Et.innerHTML=py,Yo=i(),Vo=a("hr"),Po=i(),Ht=a("a"),Eo=i(),c(Wt.$$.fragment),Ho=i(),zt=a("p"),zt.textContent=oy,Wo=i(),St=a("table"),St.innerHTML=dy,zo=i(),So=a("hr"),Xo=i(),Xt=a("a"),Lo=i(),c(Lt.$$.fragment),Fo=i(),Ft=a("p"),Ft.innerHTML=cy,Do=i(),Dt=a("table"),Dt.innerHTML=ry,qo=i(),Oo=a("hr"),Ko=i(),qt=a("a"),ed=i(),c(Ot.$$.fragment),td=i(),Kt=a("p"),Kt.textContent=My,ld=i(),el=a("p"),el.innerHTML=my,sd=i(),c(tl.$$.fragment),id=i(),ll=a("p"),ll.innerHTML=Ty,nd=i(),c(sl.$$.fragment),ad=i(),il=a("p"),il.innerHTML=yy,pd=i(),c(nl.$$.fragment),od=i(),al=a("p"),al.innerHTML=uy,dd=i(),cd=a("hr"),rd=i(),pl=a("a"),Md=i(),c(ol.$$.fragment),md=i(),dl=a("p"),dl.textContent=Jy,Td=i(),cl=a("p"),cl.innerHTML=hy,yd=i(),rl=a("table"),rl.innerHTML=wy,ud=i(),Jd=a("hr"),hd=i(),Ml=a("a"),wd=i(),c(ml.$$.fragment),jd=i(),Tl=a("p"),Tl.innerHTML=jy,Ud=i(),yl=a("p"),yl.innerHTML=Uy,fd=i(),c(ul.$$.fragment),bd=i(),Jl=a("p"),Jl.innerHTML=fy,xd=i(),hl=a("ul"),hl.innerHTML=by,Cd=i(),gd=a("hr"),Id=i(),wl=a("a"),kd=i(),c(jl.$$.fragment),Bd=i(),Ul=a("p"),Ul.textContent=xy,Gd=i(),fl=a("table"),fl.innerHTML=Cy,vd=i(),Zd=a("hr"),Qd=i(),bl=a("a"),Ad=i(),c(xl.$$.fragment),Nd=i(),Cl=a("p"),Cl.textContent=gy,_d=i(),gl=a("p"),gl.innerHTML=Iy,$d=i(),Il=a("table"),Il.innerHTML=ky,Rd=i(),Yd=a("hr"),Vd=i(),kl=a("a"),Pd=i(),c(Bl.$$.fragment),Ed=i(),Gl=a("p"),Gl.textContent=By,Hd=i(),vl=a("p"),vl.innerHTML=Gy,Wd=i(),c(Zl.$$.fragment),zd=i(),Ql=a("p"),Ql.innerHTML=vy,Sd=i(),c(Al.$$.fragment),Xd=i(),Nl=a("p"),Nl.innerHTML=Zy,Ld=i(),c(_l.$$.fragment),Fd=i(),$l=a("p"),$l.innerHTML=Qy,Dd=i(),c(Rl.$$.fragment),qd=i(),Yl=a("p"),Yl.innerHTML=Ay,Od=i(),c(Vl.$$.fragment),Kd=i(),Pl=a("p"),Pl.innerHTML=Ny,ec=i(),c(El.$$.fragment),tc=i(),Hl=a("p"),Hl.innerHTML=_y,lc=i(),Wl=a("ul"),Wl.innerHTML=$y,sc=i(),ic=a("hr"),nc=i(),zl=a("a"),ac=i(),c(Sl.$$.fragment),pc=i(),Xl=a("p"),Xl.textContent=Ry,oc=i(),Ll=a("table"),Ll.innerHTML=Yy,dc=i(),cc=a("hr"),rc=i(),Fl=a("a"),Mc=i(),c(Dl.$$.fragment),mc=i(),ql=a("p"),ql.textContent=Vy,Tc=i(),Ol=a("p"),Ol.innerHTML=Py,yc=i(),Kl=a("table"),Kl.innerHTML=Ey,uc=i(),Jc=a("hr"),hc=i(),es=a("a"),wc=i(),c(ts.$$.fragment),jc=i(),ls=a("p"),ls.innerHTML=Hy,Uc=i(),ss=a("p"),ss.innerHTML=Wy,fc=i(),c(is.$$.fragment),bc=i(),ns=a("p"),ns.innerHTML=zy,xc=i(),as=a("ul"),as.innerHTML=Sy,Cc=i(),gc=a("hr"),Ic=i(),ps=a("a"),kc=i(),c(os.$$.fragment),Bc=i(),ds=a("p"),ds.textContent=Xy,Gc=i(),cs=a("table"),cs.innerHTML=Ly,vc=i(),Zc=a("hr"),Qc=i(),rs=a("a"),Ac=i(),c(Ms.$$.fragment),Nc=i(),ms=a("p"),ms.textContent=Fy,_c=i(),Ts=a("p"),Ts.innerHTML=Dy,$c=i(),ys=a("table"),ys.innerHTML=qy,Rc=i(),Yc=a("hr"),Vc=i(),us=a("a"),Pc=i(),c(Js.$$.fragment),Ec=i(),hs=a("p"),hs.innerHTML=Oy,Hc=i(),ws=a("p"),ws.innerHTML=Ky,Wc=i(),c(js.$$.fragment),zc=i(),Us=a("p"),Us.innerHTML=eu,Sc=i(),c(fs.$$.fragment),Xc=i(),bs=a("p"),bs.innerHTML=tu,Lc=i(),c(xs.$$.fragment),Fc=i(),Cs=a("p"),Cs.innerHTML=lu,Dc=i(),gs=a("ul"),gs.innerHTML=su,qc=i(),Oc=a("hr"),Kc=i(),Is=a("a"),er=i(),c(ks.$$.fragment),tr=i(),Bs=a("p"),Bs.textContent=iu,lr=i(),Gs=a("table"),Gs.innerHTML=nu,sr=i(),ir=a("hr"),nr=i(),vs=a("a"),ar=i(),c(Zs.$$.fragment),pr=i(),Qs=a("p"),Qs.textContent=au,or=i(),As=a("p"),As.innerHTML=pu,dr=i(),Ns=a("table"),Ns.innerHTML=ou,cr=i(),rr=a("hr"),Mr=i(),_s=a("a"),mr=i(),c($s.$$.fragment),Tr=i(),Rs=a("p"),Rs.innerHTML=du,yr=i(),Ys=a("p"),Ys.innerHTML=cu,ur=i(),c(Vs.$$.fragment),Jr=i(),Ps=a("p"),Ps.innerHTML=ru,hr=i(),Es=a("ul"),Es.innerHTML=Mu,wr=i(),jr=a("hr"),Ur=i(),Hs=a("a"),fr=i(),c(Ws.$$.fragment),br=i(),zs=a("p"),zs.textContent=mu,xr=i(),Ss=a("table"),Ss.innerHTML=Tu,Cr=i(),gr=a("hr"),Ir=i(),Xs=a("a"),kr=i(),c(Ls.$$.fragment),Br=i(),Fs=a("p"),Fs.textContent=yu,Gr=i(),Ds=a("p"),Ds.innerHTML=uu,vr=i(),qs=a("table"),qs.innerHTML=Ju,Zr=i(),Qr=a("hr"),Ar=i(),Os=a("a"),Nr=i(),c(Ks.$$.fragment),_r=i(),ei=a("p"),ei.innerHTML=hu,$r=i(),ti=a("p"),ti.innerHTML=wu,Rr=i(),c(li.$$.fragment),Yr=i(),si=a("p"),si.innerHTML=ju,Vr=i(),ii=a("ul"),ii.innerHTML=Uu,Pr=i(),Er=a("hr"),Hr=i(),ni=a("a"),Wr=i(),c(ai.$$.fragment),zr=i(),pi=a("p"),pi.textContent=fu,Sr=i(),oi=a("table"),oi.innerHTML=bu,Xr=i(),Lr=a("hr"),Fr=i(),di=a("a"),Dr=i(),c(ci.$$.fragment),qr=i(),ri=a("p"),ri.textContent=xu,Or=i(),Mi=a("p"),Mi.innerHTML=Cu,Kr=i(),mi=a("table"),mi.innerHTML=gu,eM=i(),tM=a("hr"),lM=i(),Ti=a("a"),sM=i(),c(yi.$$.fragment),iM=i(),ui=a("p"),ui.innerHTML=Iu,nM=i(),Ji=a("p"),Ji.innerHTML=ku,aM=i(),c(hi.$$.fragment),pM=i(),wi=a("p"),wi.innerHTML=Bu,oM=i(),ji=a("ul"),ji.innerHTML=Gu,dM=i(),cM=a("hr"),rM=i(),Ui=a("a"),MM=i(),c(fi.$$.fragment),mM=i(),bi=a("p"),bi.textContent=vu,TM=i(),xi=a("table"),xi.innerHTML=Zu,yM=i(),uM=a("hr"),JM=i(),Ci=a("a"),hM=i(),c(gi.$$.fragment),wM=i(),Ii=a("p"),Ii.textContent=Qu,jM=i(),ki=a("p"),ki.innerHTML=Au,UM=i(),Bi=a("table"),Bi.innerHTML=Nu,fM=i(),bM=a("hr"),xM=i(),Gi=a("a"),CM=i(),c(vi.$$.fragment),gM=i(),Zi=a("p"),Zi.innerHTML=_u,IM=i(),Qi=a("p"),Qi.innerHTML=$u,kM=i(),c(Ai.$$.fragment),BM=i(),Ni=a("p"),Ni.innerHTML=Ru,GM=i(),_i=a("ul"),_i.innerHTML=Yu,vM=i(),ZM=a("hr"),QM=i(),$i=a("a"),AM=i(),c(Ri.$$.fragment),NM=i(),Yi=a("p"),Yi.textContent=Vu,_M=i(),Vi=a("table"),Vi.innerHTML=Pu,$M=i(),RM=a("hr"),YM=i(),Pi=a("a"),VM=i(),c(Ei.$$.fragment),PM=i(),Hi=a("p"),Hi.textContent=Eu,EM=i(),Wi=a("p"),Wi.innerHTML=Hu,HM=i(),zi=a("table"),zi.innerHTML=Wu,WM=i(),zM=a("hr"),SM=i(),Si=a("a"),XM=i(),c(Xi.$$.fragment),LM=i(),Li=a("p"),Li.innerHTML=zu,FM=i(),Fi=a("p"),Fi.innerHTML=Su,DM=i(),c(Di.$$.fragment),qM=i(),qi=a("p"),qi.innerHTML=Xu,OM=i(),c(Oi.$$.fragment),KM=i(),Ki=a("p"),Ki.innerHTML=Lu,em=i(),en=a("ul"),en.innerHTML=Fu,tm=i(),lm=a("hr"),sm=i(),tn=a("a"),im=i(),c(ln.$$.fragment),nm=i(),sn=a("p"),sn.textContent=Du,am=i(),nn=a("table"),nn.innerHTML=qu,pm=i(),om=a("hr"),dm=i(),an=a("a"),cm=i(),c(pn.$$.fragment),rm=i(),on=a("p"),on.textContent=Ou,Mm=i(),dn=a("p"),dn.innerHTML=Ku,mm=i(),cn=a("table"),cn.innerHTML=eJ,Tm=i(),ym=a("hr"),um=i(),rn=a("a"),Jm=i(),c(Mn.$$.fragment),hm=i(),mn=a("p"),mn.innerHTML=tJ,wm=i(),Tn=a("p"),Tn.innerHTML=lJ,jm=i(),yn=a("ul"),yn.innerHTML=sJ,Um=i(),un=a("table"),un.innerHTML=iJ,fm=i(),bm=a("hr"),xm=i(),Jn=a("a"),Cm=i(),c(hn.$$.fragment),gm=i(),wn=a("p"),wn.innerHTML=nJ,Im=i(),jn=a("table"),jn.innerHTML=aJ,km=i(),Bm=a("hr"),Gm=i(),Un=a("a"),vm=i(),c(fn.$$.fragment),Zm=i(),bn=a("p"),bn.innerHTML=pJ,Qm=i(),Am=a("hr"),Nm=i(),xn=a("a"),_m=i(),c(Cn.$$.fragment),$m=i(),gn=a("p"),gn.innerHTML=oJ,Rm=i(),In=a("table"),In.innerHTML=dJ,Ym=i(),Vm=a("hr"),Pm=i(),Bn=a("p"),this.h()},l(e){const t=yJ("svelte-u9bgzb",document.head);w=p(t,"META",{name:!0,content:!0}),t.forEach(l),Gn=n(e),kn=p(e,"P",{}),u(kn).forEach(l),vn=n(e),j=p(e,"A",{id:!0,class:!0}),u(j).forEach(l),Zn=n(e),r(U.$$.fragment,e),Qn=n(e),f=p(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1inm2t9"&&(f.textContent=Wm),An=n(e),b=p(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1pjech"&&(b.innerHTML=zm),Nn=n(e),r(x.$$.fragment,e),_n=n(e),C=p(e,"UL",{"data-svelte-h":!0}),o(C)!=="svelte-4mywo1"&&(C.innerHTML=Sm),$n=n(e),Rn=p(e,"HR",{}),Yn=n(e),g=p(e,"A",{id:!0,class:!0}),u(g).forEach(l),Vn=n(e),r(I.$$.fragment,e),Pn=n(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-16ix8v2"&&(k.textContent=Xm),En=n(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1olpg2f"&&(B.innerHTML=Lm),Hn=n(e),G=p(e,"UL",{"data-svelte-h":!0}),o(G)!=="svelte-1wo4saj"&&(G.innerHTML=Fm),Wn=n(e),zn=p(e,"HR",{}),Sn=n(e),v=p(e,"A",{id:!0,class:!0}),u(v).forEach(l),Xn=n(e),r(Z.$$.fragment,e),Ln=n(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-10jkwj"&&(Q.textContent=Dm),Fn=n(e),A=p(e,"TABLE",{"data-svelte-h":!0}),o(A)!=="svelte-13q0syp"&&(A.innerHTML=qm),Dn=n(e),qn=p(e,"HR",{}),On=n(e),N=p(e,"A",{id:!0,class:!0}),u(N).forEach(l),Kn=n(e),r(_.$$.fragment,e),ea=n(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1yhr8qe"&&($.textContent=Om),ta=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1yqombv"&&(R.innerHTML=Km),la=n(e),sa=p(e,"HR",{}),ia=n(e),Y=p(e,"A",{id:!0,class:!0}),u(Y).forEach(l),na=n(e),r(V.$$.fragment,e),aa=n(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-phuke9"&&(P.textContent=eT),pa=n(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1xajepz"&&(E.innerHTML=tT),oa=n(e),H=p(e,"TABLE",{"data-svelte-h":!0}),o(H)!=="svelte-1dl6le6"&&(H.innerHTML=lT),da=n(e),ca=p(e,"HR",{}),ra=n(e),W=p(e,"A",{id:!0,class:!0}),u(W).forEach(l),Ma=n(e),r(z.$$.fragment,e),ma=n(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1aega0x"&&(S.innerHTML=sT),Ta=n(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-twv4w2"&&(X.innerHTML=iT),ya=n(e),r(L.$$.fragment,e),ua=n(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-9l8wqs"&&(F.innerHTML=nT),Ja=n(e),r(D.$$.fragment,e),ha=n(e),q=p(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-63pkoo"&&(q.innerHTML=aT),wa=n(e),r(O.$$.fragment,e),ja=n(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-s10qq4"&&(K.innerHTML=pT),Ua=n(e),fa=p(e,"HR",{}),ba=n(e),ee=p(e,"A",{id:!0,class:!0}),u(ee).forEach(l),xa=n(e),r(te.$$.fragment,e),Ca=n(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-319swt"&&(le.textContent=oT),ga=n(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1vshn55"&&(se.innerHTML=dT),Ia=n(e),ie=p(e,"TABLE",{"data-svelte-h":!0}),o(ie)!=="svelte-mqkhxk"&&(ie.innerHTML=cT),ka=n(e),Ba=p(e,"HR",{}),Ga=n(e),ne=p(e,"A",{id:!0,class:!0}),u(ne).forEach(l),va=n(e),r(ae.$$.fragment,e),Za=n(e),pe=p(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-199l8oj"&&(pe.innerHTML=rT),Qa=n(e),oe=p(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-3ojewp"&&(oe.innerHTML=MT),Aa=n(e),r(de.$$.fragment,e),Na=n(e),ce=p(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-1ln7q61"&&(ce.innerHTML=mT),_a=n(e),r(re.$$.fragment,e),$a=n(e),Me=p(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-s10qq4"&&(Me.innerHTML=TT),Ra=n(e),Ya=p(e,"HR",{}),Va=n(e),me=p(e,"A",{id:!0,class:!0}),u(me).forEach(l),Pa=n(e),r(Te.$$.fragment,e),Ea=n(e),ye=p(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-qfvk6r"&&(ye.textContent=yT),Ha=n(e),ue=p(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-1tvkl0p"&&(ue.innerHTML=uT),Wa=n(e),Je=p(e,"TABLE",{"data-svelte-h":!0}),o(Je)!=="svelte-1p6smdx"&&(Je.innerHTML=JT),za=n(e),Sa=p(e,"HR",{}),Xa=n(e),he=p(e,"A",{id:!0,class:!0}),u(he).forEach(l),La=n(e),r(we.$$.fragment,e),Fa=n(e),je=p(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-14f3xkz"&&(je.innerHTML=hT),Da=n(e),Ue=p(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-o2pgcr"&&(Ue.innerHTML=wT),qa=n(e),r(fe.$$.fragment,e),Oa=n(e),be=p(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-s10qq4"&&(be.innerHTML=jT),Ka=n(e),ep=p(e,"HR",{}),tp=n(e),xe=p(e,"A",{id:!0,class:!0}),u(xe).forEach(l),lp=n(e),r(Ce.$$.fragment,e),sp=n(e),ge=p(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-v1s8i"&&(ge.textContent=UT),ip=n(e),Ie=p(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-1jet258"&&(Ie.innerHTML=fT),np=n(e),ke=p(e,"TABLE",{"data-svelte-h":!0}),o(ke)!=="svelte-dmekw3"&&(ke.innerHTML=bT),ap=n(e),pp=p(e,"HR",{}),op=n(e),Be=p(e,"A",{id:!0,class:!0}),u(Be).forEach(l),dp=n(e),r(Ge.$$.fragment,e),cp=n(e),ve=p(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-nzjx48"&&(ve.innerHTML=xT),rp=n(e),Ze=p(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-1xict4f"&&(Ze.innerHTML=CT),Mp=n(e),r(Qe.$$.fragment,e),mp=n(e),Ae=p(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-1sz7ava"&&(Ae.innerHTML=gT),Tp=n(e),r(Ne.$$.fragment,e),yp=n(e),_e=p(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-s10qq4"&&(_e.innerHTML=IT),up=n(e),Jp=p(e,"HR",{}),hp=n(e),$e=p(e,"A",{id:!0,class:!0}),u($e).forEach(l),wp=n(e),r(Re.$$.fragment,e),jp=n(e),Ye=p(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-1dgb1r"&&(Ye.textContent=kT),Up=n(e),Ve=p(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-ht5bcu"&&(Ve.innerHTML=BT),fp=n(e),Pe=p(e,"TABLE",{"data-svelte-h":!0}),o(Pe)!=="svelte-dhvci0"&&(Pe.innerHTML=GT),bp=n(e),xp=p(e,"HR",{}),Cp=n(e),Ee=p(e,"A",{id:!0,class:!0}),u(Ee).forEach(l),gp=n(e),r(He.$$.fragment,e),Ip=n(e),We=p(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-e2spcq"&&(We.textContent=vT),kp=n(e),ze=p(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-j4hwgn"&&(ze.innerHTML=ZT),Bp=n(e),r(Se.$$.fragment,e),Gp=n(e),Xe=p(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-s10qq4"&&(Xe.innerHTML=QT),vp=n(e),Zp=p(e,"HR",{}),Qp=n(e),Le=p(e,"A",{id:!0,class:!0}),u(Le).forEach(l),Ap=n(e),r(Fe.$$.fragment,e),Np=n(e),De=p(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-1dgb1r"&&(De.textContent=AT),_p=n(e),qe=p(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-k5n4xx"&&(qe.innerHTML=NT),$p=n(e),Oe=p(e,"UL",{"data-svelte-h":!0}),o(Oe)!=="svelte-wmzf9w"&&(Oe.innerHTML=_T),Rp=n(e),Ke=p(e,"TABLE",{"data-svelte-h":!0}),o(Ke)!=="svelte-18cf78d"&&(Ke.innerHTML=$T),Yp=n(e),Vp=p(e,"HR",{}),Pp=n(e),et=p(e,"A",{id:!0,class:!0}),u(et).forEach(l),Ep=n(e),r(tt.$$.fragment,e),Hp=n(e),lt=p(e,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-1axdht2"&&(lt.textContent=RT),Wp=n(e),st=p(e,"P",{"data-svelte-h":!0}),o(st)!=="svelte-1416cqx"&&(st.innerHTML=YT),zp=n(e),r(it.$$.fragment,e),Sp=n(e),nt=p(e,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-s10qq4"&&(nt.innerHTML=VT),Xp=n(e),Lp=p(e,"HR",{}),Fp=n(e),at=p(e,"A",{id:!0,class:!0}),u(at).forEach(l),Dp=n(e),r(pt.$$.fragment,e),qp=n(e),ot=p(e,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-3abd20"&&(ot.textContent=PT),Op=n(e),dt=p(e,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-1ut0vme"&&(dt.innerHTML=ET),Kp=n(e),ct=p(e,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-dr1wsd"&&(ct.innerHTML=HT),eo=n(e),r(rt.$$.fragment,e),to=n(e),Mt=p(e,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-mqh15a"&&(Mt.innerHTML=WT),lo=n(e),mt=p(e,"P",{"data-svelte-h":!0}),o(mt)!=="svelte-zf4dht"&&(mt.innerHTML=zT),so=n(e),r(Tt.$$.fragment,e),io=n(e),yt=p(e,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-1877ohf"&&(yt.innerHTML=ST),no=n(e),ut=p(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-1ox1juk"&&(ut.innerHTML=XT),ao=n(e),r(Jt.$$.fragment,e),po=n(e),ht=p(e,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-s10qq4"&&(ht.innerHTML=LT),oo=n(e),co=p(e,"HR",{}),ro=n(e),wt=p(e,"A",{id:!0,class:!0}),u(wt).forEach(l),Mo=n(e),r(jt.$$.fragment,e),mo=n(e),Ut=p(e,"P",{"data-svelte-h":!0}),o(Ut)!=="svelte-1yek3op"&&(Ut.innerHTML=FT),To=n(e),ft=p(e,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-11p32pq"&&(ft.innerHTML=DT),yo=n(e),r(bt.$$.fragment,e),uo=n(e),xt=p(e,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-1uqom1e"&&(xt.innerHTML=qT),Jo=n(e),r(Ct.$$.fragment,e),ho=n(e),gt=p(e,"P",{"data-svelte-h":!0}),o(gt)!=="svelte-1a7k67n"&&(gt.innerHTML=OT),wo=n(e),r(It.$$.fragment,e),jo=n(e),kt=p(e,"P",{"data-svelte-h":!0}),o(kt)!=="svelte-s10qq4"&&(kt.innerHTML=KT),Uo=n(e),fo=p(e,"HR",{}),bo=n(e),Bt=p(e,"A",{id:!0,class:!0}),u(Bt).forEach(l),xo=n(e),r(Gt.$$.fragment,e),Co=n(e),vt=p(e,"P",{"data-svelte-h":!0}),o(vt)!=="svelte-6m3xhk"&&(vt.textContent=ey),go=n(e),Zt=p(e,"P",{"data-svelte-h":!0}),o(Zt)!=="svelte-1f5btis"&&(Zt.innerHTML=ty),Io=n(e),Qt=p(e,"TABLE",{"data-svelte-h":!0}),o(Qt)!=="svelte-5kvkn6"&&(Qt.innerHTML=ly),ko=n(e),Bo=p(e,"HR",{}),Go=n(e),At=p(e,"A",{id:!0,class:!0}),u(At).forEach(l),vo=n(e),r(Nt.$$.fragment,e),Zo=n(e),_t=p(e,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-104v5zf"&&(_t.innerHTML=sy),Qo=n(e),$t=p(e,"P",{"data-svelte-h":!0}),o($t)!=="svelte-17n9q32"&&($t.innerHTML=iy),Ao=n(e),r(Rt.$$.fragment,e),No=n(e),Yt=p(e,"P",{"data-svelte-h":!0}),o(Yt)!=="svelte-v99qry"&&(Yt.innerHTML=ny),_o=n(e),r(Vt.$$.fragment,e),$o=n(e),Pt=p(e,"P",{"data-svelte-h":!0}),o(Pt)!=="svelte-s10qq4"&&(Pt.innerHTML=ay),Ro=n(e),Et=p(e,"UL",{"data-svelte-h":!0}),o(Et)!=="svelte-svwcak"&&(Et.innerHTML=py),Yo=n(e),Vo=p(e,"HR",{}),Po=n(e),Ht=p(e,"A",{id:!0,class:!0}),u(Ht).forEach(l),Eo=n(e),r(Wt.$$.fragment,e),Ho=n(e),zt=p(e,"P",{"data-svelte-h":!0}),o(zt)!=="svelte-1n1xlcl"&&(zt.textContent=oy),Wo=n(e),St=p(e,"TABLE",{"data-svelte-h":!0}),o(St)!=="svelte-1h8f"&&(St.innerHTML=dy),zo=n(e),So=p(e,"HR",{}),Xo=n(e),Xt=p(e,"A",{id:!0,class:!0}),u(Xt).forEach(l),Lo=n(e),r(Lt.$$.fragment,e),Fo=n(e),Ft=p(e,"P",{"data-svelte-h":!0}),o(Ft)!=="svelte-c8gx4u"&&(Ft.innerHTML=cy),Do=n(e),Dt=p(e,"TABLE",{"data-svelte-h":!0}),o(Dt)!=="svelte-y9oo3q"&&(Dt.innerHTML=ry),qo=n(e),Oo=p(e,"HR",{}),Ko=n(e),qt=p(e,"A",{id:!0,class:!0}),u(qt).forEach(l),ed=n(e),r(Ot.$$.fragment,e),td=n(e),Kt=p(e,"P",{"data-svelte-h":!0}),o(Kt)!=="svelte-tzucv0"&&(Kt.textContent=My),ld=n(e),el=p(e,"P",{"data-svelte-h":!0}),o(el)!=="svelte-zrdgvs"&&(el.innerHTML=my),sd=n(e),r(tl.$$.fragment,e),id=n(e),ll=p(e,"P",{"data-svelte-h":!0}),o(ll)!=="svelte-et9i9m"&&(ll.innerHTML=Ty),nd=n(e),r(sl.$$.fragment,e),ad=n(e),il=p(e,"P",{"data-svelte-h":!0}),o(il)!=="svelte-162t9ct"&&(il.innerHTML=yy),pd=n(e),r(nl.$$.fragment,e),od=n(e),al=p(e,"P",{"data-svelte-h":!0}),o(al)!=="svelte-s10qq4"&&(al.innerHTML=uy),dd=n(e),cd=p(e,"HR",{}),rd=n(e),pl=p(e,"A",{id:!0,class:!0}),u(pl).forEach(l),Md=n(e),r(ol.$$.fragment,e),md=n(e),dl=p(e,"P",{"data-svelte-h":!0}),o(dl)!=="svelte-11eoigb"&&(dl.textContent=Jy),Td=n(e),cl=p(e,"P",{"data-svelte-h":!0}),o(cl)!=="svelte-un4fzt"&&(cl.innerHTML=hy),yd=n(e),rl=p(e,"TABLE",{"data-svelte-h":!0}),o(rl)!=="svelte-1qj38gf"&&(rl.innerHTML=wy),ud=n(e),Jd=p(e,"HR",{}),hd=n(e),Ml=p(e,"A",{id:!0,class:!0}),u(Ml).forEach(l),wd=n(e),r(ml.$$.fragment,e),jd=n(e),Tl=p(e,"P",{"data-svelte-h":!0}),o(Tl)!=="svelte-9xhkxa"&&(Tl.innerHTML=jy),Ud=n(e),yl=p(e,"P",{"data-svelte-h":!0}),o(yl)!=="svelte-gobmso"&&(yl.innerHTML=Uy),fd=n(e),r(ul.$$.fragment,e),bd=n(e),Jl=p(e,"P",{"data-svelte-h":!0}),o(Jl)!=="svelte-s10qq4"&&(Jl.innerHTML=fy),xd=n(e),hl=p(e,"UL",{"data-svelte-h":!0}),o(hl)!=="svelte-fjr04l"&&(hl.innerHTML=by),Cd=n(e),gd=p(e,"HR",{}),Id=n(e),wl=p(e,"A",{id:!0,class:!0}),u(wl).forEach(l),kd=n(e),r(jl.$$.fragment,e),Bd=n(e),Ul=p(e,"P",{"data-svelte-h":!0}),o(Ul)!=="svelte-1enract"&&(Ul.textContent=xy),Gd=n(e),fl=p(e,"TABLE",{"data-svelte-h":!0}),o(fl)!=="svelte-dgeggs"&&(fl.innerHTML=Cy),vd=n(e),Zd=p(e,"HR",{}),Qd=n(e),bl=p(e,"A",{id:!0,class:!0}),u(bl).forEach(l),Ad=n(e),r(xl.$$.fragment,e),Nd=n(e),Cl=p(e,"P",{"data-svelte-h":!0}),o(Cl)!=="svelte-19qhuwa"&&(Cl.textContent=gy),_d=n(e),gl=p(e,"P",{"data-svelte-h":!0}),o(gl)!=="svelte-1gq3dbn"&&(gl.innerHTML=Iy),$d=n(e),Il=p(e,"TABLE",{"data-svelte-h":!0}),o(Il)!=="svelte-17m2nm1"&&(Il.innerHTML=ky),Rd=n(e),Yd=p(e,"HR",{}),Vd=n(e),kl=p(e,"A",{id:!0,class:!0}),u(kl).forEach(l),Pd=n(e),r(Bl.$$.fragment,e),Ed=n(e),Gl=p(e,"P",{"data-svelte-h":!0}),o(Gl)!=="svelte-vm8asa"&&(Gl.textContent=By),Hd=n(e),vl=p(e,"P",{"data-svelte-h":!0}),o(vl)!=="svelte-p9nqmy"&&(vl.innerHTML=Gy),Wd=n(e),r(Zl.$$.fragment,e),zd=n(e),Ql=p(e,"P",{"data-svelte-h":!0}),o(Ql)!=="svelte-1xb4yln"&&(Ql.innerHTML=vy),Sd=n(e),r(Al.$$.fragment,e),Xd=n(e),Nl=p(e,"P",{"data-svelte-h":!0}),o(Nl)!=="svelte-aly754"&&(Nl.innerHTML=Zy),Ld=n(e),r(_l.$$.fragment,e),Fd=n(e),$l=p(e,"P",{"data-svelte-h":!0}),o($l)!=="svelte-127z1r2"&&($l.innerHTML=Qy),Dd=n(e),r(Rl.$$.fragment,e),qd=n(e),Yl=p(e,"P",{"data-svelte-h":!0}),o(Yl)!=="svelte-5ad2vc"&&(Yl.innerHTML=Ay),Od=n(e),r(Vl.$$.fragment,e),Kd=n(e),Pl=p(e,"P",{"data-svelte-h":!0}),o(Pl)!=="svelte-1ybp4y9"&&(Pl.innerHTML=Ny),ec=n(e),r(El.$$.fragment,e),tc=n(e),Hl=p(e,"P",{"data-svelte-h":!0}),o(Hl)!=="svelte-s10qq4"&&(Hl.innerHTML=_y),lc=n(e),Wl=p(e,"UL",{"data-svelte-h":!0}),o(Wl)!=="svelte-32csn1"&&(Wl.innerHTML=$y),sc=n(e),ic=p(e,"HR",{}),nc=n(e),zl=p(e,"A",{id:!0,class:!0}),u(zl).forEach(l),ac=n(e),r(Sl.$$.fragment,e),pc=n(e),Xl=p(e,"P",{"data-svelte-h":!0}),o(Xl)!=="svelte-1kkefov"&&(Xl.textContent=Ry),oc=n(e),Ll=p(e,"TABLE",{"data-svelte-h":!0}),o(Ll)!=="svelte-1a94q5m"&&(Ll.innerHTML=Yy),dc=n(e),cc=p(e,"HR",{}),rc=n(e),Fl=p(e,"A",{id:!0,class:!0}),u(Fl).forEach(l),Mc=n(e),r(Dl.$$.fragment,e),mc=n(e),ql=p(e,"P",{"data-svelte-h":!0}),o(ql)!=="svelte-d8vj38"&&(ql.textContent=Vy),Tc=n(e),Ol=p(e,"P",{"data-svelte-h":!0}),o(Ol)!=="svelte-hgdjqs"&&(Ol.innerHTML=Py),yc=n(e),Kl=p(e,"TABLE",{"data-svelte-h":!0}),o(Kl)!=="svelte-1usuiaq"&&(Kl.innerHTML=Ey),uc=n(e),Jc=p(e,"HR",{}),hc=n(e),es=p(e,"A",{id:!0,class:!0}),u(es).forEach(l),wc=n(e),r(ts.$$.fragment,e),jc=n(e),ls=p(e,"P",{"data-svelte-h":!0}),o(ls)!=="svelte-yuzbfo"&&(ls.innerHTML=Hy),Uc=n(e),ss=p(e,"P",{"data-svelte-h":!0}),o(ss)!=="svelte-gwolyd"&&(ss.innerHTML=Wy),fc=n(e),r(is.$$.fragment,e),bc=n(e),ns=p(e,"P",{"data-svelte-h":!0}),o(ns)!=="svelte-s10qq4"&&(ns.innerHTML=zy),xc=n(e),as=p(e,"UL",{"data-svelte-h":!0}),o(as)!=="svelte-3k2o01"&&(as.innerHTML=Sy),Cc=n(e),gc=p(e,"HR",{}),Ic=n(e),ps=p(e,"A",{id:!0,class:!0}),u(ps).forEach(l),kc=n(e),r(os.$$.fragment,e),Bc=n(e),ds=p(e,"P",{"data-svelte-h":!0}),o(ds)!=="svelte-10qze5e"&&(ds.textContent=Xy),Gc=n(e),cs=p(e,"TABLE",{"data-svelte-h":!0}),o(cs)!=="svelte-1a94q5m"&&(cs.innerHTML=Ly),vc=n(e),Zc=p(e,"HR",{}),Qc=n(e),rs=p(e,"A",{id:!0,class:!0}),u(rs).forEach(l),Ac=n(e),r(Ms.$$.fragment,e),Nc=n(e),ms=p(e,"P",{"data-svelte-h":!0}),o(ms)!=="svelte-ypfmt8"&&(ms.textContent=Fy),_c=n(e),Ts=p(e,"P",{"data-svelte-h":!0}),o(Ts)!=="svelte-sv0g8q"&&(Ts.innerHTML=Dy),$c=n(e),ys=p(e,"TABLE",{"data-svelte-h":!0}),o(ys)!=="svelte-1d2oy3p"&&(ys.innerHTML=qy),Rc=n(e),Yc=p(e,"HR",{}),Vc=n(e),us=p(e,"A",{id:!0,class:!0}),u(us).forEach(l),Pc=n(e),r(Js.$$.fragment,e),Ec=n(e),hs=p(e,"P",{"data-svelte-h":!0}),o(hs)!=="svelte-w5osnc"&&(hs.innerHTML=Oy),Hc=n(e),ws=p(e,"P",{"data-svelte-h":!0}),o(ws)!=="svelte-1h4310j"&&(ws.innerHTML=Ky),Wc=n(e),r(js.$$.fragment,e),zc=n(e),Us=p(e,"P",{"data-svelte-h":!0}),o(Us)!=="svelte-xv6hak"&&(Us.innerHTML=eu),Sc=n(e),r(fs.$$.fragment,e),Xc=n(e),bs=p(e,"P",{"data-svelte-h":!0}),o(bs)!=="svelte-1ids6l"&&(bs.innerHTML=tu),Lc=n(e),r(xs.$$.fragment,e),Fc=n(e),Cs=p(e,"P",{"data-svelte-h":!0}),o(Cs)!=="svelte-s10qq4"&&(Cs.innerHTML=lu),Dc=n(e),gs=p(e,"UL",{"data-svelte-h":!0}),o(gs)!=="svelte-z3581k"&&(gs.innerHTML=su),qc=n(e),Oc=p(e,"HR",{}),Kc=n(e),Is=p(e,"A",{id:!0,class:!0}),u(Is).forEach(l),er=n(e),r(ks.$$.fragment,e),tr=n(e),Bs=p(e,"P",{"data-svelte-h":!0}),o(Bs)!=="svelte-71b02w"&&(Bs.textContent=iu),lr=n(e),Gs=p(e,"TABLE",{"data-svelte-h":!0}),o(Gs)!=="svelte-dgeggs"&&(Gs.innerHTML=nu),sr=n(e),ir=p(e,"HR",{}),nr=n(e),vs=p(e,"A",{id:!0,class:!0}),u(vs).forEach(l),ar=n(e),r(Zs.$$.fragment,e),pr=n(e),Qs=p(e,"P",{"data-svelte-h":!0}),o(Qs)!=="svelte-1rpepg8"&&(Qs.textContent=au),or=n(e),As=p(e,"P",{"data-svelte-h":!0}),o(As)!=="svelte-zgzruq"&&(As.innerHTML=pu),dr=n(e),Ns=p(e,"TABLE",{"data-svelte-h":!0}),o(Ns)!=="svelte-17j2fmt"&&(Ns.innerHTML=ou),cr=n(e),rr=p(e,"HR",{}),Mr=n(e),_s=p(e,"A",{id:!0,class:!0}),u(_s).forEach(l),mr=n(e),r($s.$$.fragment,e),Tr=n(e),Rs=p(e,"P",{"data-svelte-h":!0}),o(Rs)!=="svelte-1rwi35s"&&(Rs.innerHTML=du),yr=n(e),Ys=p(e,"P",{"data-svelte-h":!0}),o(Ys)!=="svelte-1tpbwb6"&&(Ys.innerHTML=cu),ur=n(e),r(Vs.$$.fragment,e),Jr=n(e),Ps=p(e,"P",{"data-svelte-h":!0}),o(Ps)!=="svelte-s10qq4"&&(Ps.innerHTML=ru),hr=n(e),Es=p(e,"UL",{"data-svelte-h":!0}),o(Es)!=="svelte-1n3ebqn"&&(Es.innerHTML=Mu),wr=n(e),jr=p(e,"HR",{}),Ur=n(e),Hs=p(e,"A",{id:!0,class:!0}),u(Hs).forEach(l),fr=n(e),r(Ws.$$.fragment,e),br=n(e),zs=p(e,"P",{"data-svelte-h":!0}),o(zs)!=="svelte-1ctgtyq"&&(zs.textContent=mu),xr=n(e),Ss=p(e,"TABLE",{"data-svelte-h":!0}),o(Ss)!=="svelte-dgeggs"&&(Ss.innerHTML=Tu),Cr=n(e),gr=p(e,"HR",{}),Ir=n(e),Xs=p(e,"A",{id:!0,class:!0}),u(Xs).forEach(l),kr=n(e),r(Ls.$$.fragment,e),Br=n(e),Fs=p(e,"P",{"data-svelte-h":!0}),o(Fs)!=="svelte-1v51wpq"&&(Fs.textContent=yu),Gr=n(e),Ds=p(e,"P",{"data-svelte-h":!0}),o(Ds)!=="svelte-7em0sw"&&(Ds.innerHTML=uu),vr=n(e),qs=p(e,"TABLE",{"data-svelte-h":!0}),o(qs)!=="svelte-usc03t"&&(qs.innerHTML=Ju),Zr=n(e),Qr=p(e,"HR",{}),Ar=n(e),Os=p(e,"A",{id:!0,class:!0}),u(Os).forEach(l),Nr=n(e),r(Ks.$$.fragment,e),_r=n(e),ei=p(e,"P",{"data-svelte-h":!0}),o(ei)!=="svelte-20dgme"&&(ei.innerHTML=hu),$r=n(e),ti=p(e,"P",{"data-svelte-h":!0}),o(ti)!=="svelte-eob2i5"&&(ti.innerHTML=wu),Rr=n(e),r(li.$$.fragment,e),Yr=n(e),si=p(e,"P",{"data-svelte-h":!0}),o(si)!=="svelte-s10qq4"&&(si.innerHTML=ju),Vr=n(e),ii=p(e,"UL",{"data-svelte-h":!0}),o(ii)!=="svelte-1psrxkl"&&(ii.innerHTML=Uu),Pr=n(e),Er=p(e,"HR",{}),Hr=n(e),ni=p(e,"A",{id:!0,class:!0}),u(ni).forEach(l),Wr=n(e),r(ai.$$.fragment,e),zr=n(e),pi=p(e,"P",{"data-svelte-h":!0}),o(pi)!=="svelte-3wys82"&&(pi.textContent=fu),Sr=n(e),oi=p(e,"TABLE",{"data-svelte-h":!0}),o(oi)!=="svelte-1a94q5m"&&(oi.innerHTML=bu),Xr=n(e),Lr=p(e,"HR",{}),Fr=n(e),di=p(e,"A",{id:!0,class:!0}),u(di).forEach(l),Dr=n(e),r(ci.$$.fragment,e),qr=n(e),ri=p(e,"P",{"data-svelte-h":!0}),o(ri)!=="svelte-g4x6jx"&&(ri.textContent=xu),Or=n(e),Mi=p(e,"P",{"data-svelte-h":!0}),o(Mi)!=="svelte-zhb55f"&&(Mi.innerHTML=Cu),Kr=n(e),mi=p(e,"TABLE",{"data-svelte-h":!0}),o(mi)!=="svelte-tncnks"&&(mi.innerHTML=gu),eM=n(e),tM=p(e,"HR",{}),lM=n(e),Ti=p(e,"A",{id:!0,class:!0}),u(Ti).forEach(l),sM=n(e),r(yi.$$.fragment,e),iM=n(e),ui=p(e,"P",{"data-svelte-h":!0}),o(ui)!=="svelte-11wm84h"&&(ui.innerHTML=Iu),nM=n(e),Ji=p(e,"P",{"data-svelte-h":!0}),o(Ji)!=="svelte-yzldbw"&&(Ji.innerHTML=ku),aM=n(e),r(hi.$$.fragment,e),pM=n(e),wi=p(e,"P",{"data-svelte-h":!0}),o(wi)!=="svelte-s10qq4"&&(wi.innerHTML=Bu),oM=n(e),ji=p(e,"UL",{"data-svelte-h":!0}),o(ji)!=="svelte-1kysuxh"&&(ji.innerHTML=Gu),dM=n(e),cM=p(e,"HR",{}),rM=n(e),Ui=p(e,"A",{id:!0,class:!0}),u(Ui).forEach(l),MM=n(e),r(fi.$$.fragment,e),mM=n(e),bi=p(e,"P",{"data-svelte-h":!0}),o(bi)!=="svelte-1la8w69"&&(bi.textContent=vu),TM=n(e),xi=p(e,"TABLE",{"data-svelte-h":!0}),o(xi)!=="svelte-dgeggs"&&(xi.innerHTML=Zu),yM=n(e),uM=p(e,"HR",{}),JM=n(e),Ci=p(e,"A",{id:!0,class:!0}),u(Ci).forEach(l),hM=n(e),r(gi.$$.fragment,e),wM=n(e),Ii=p(e,"P",{"data-svelte-h":!0}),o(Ii)!=="svelte-1ws18e1"&&(Ii.textContent=Qu),jM=n(e),ki=p(e,"P",{"data-svelte-h":!0}),o(ki)!=="svelte-i9mudt"&&(ki.innerHTML=Au),UM=n(e),Bi=p(e,"TABLE",{"data-svelte-h":!0}),o(Bi)!=="svelte-th688q"&&(Bi.innerHTML=Nu),fM=n(e),bM=p(e,"HR",{}),xM=n(e),Gi=p(e,"A",{id:!0,class:!0}),u(Gi).forEach(l),CM=n(e),r(vi.$$.fragment,e),gM=n(e),Zi=p(e,"P",{"data-svelte-h":!0}),o(Zi)!=="svelte-iv1c6p"&&(Zi.innerHTML=_u),IM=n(e),Qi=p(e,"P",{"data-svelte-h":!0}),o(Qi)!=="svelte-1mtx2cy"&&(Qi.innerHTML=$u),kM=n(e),r(Ai.$$.fragment,e),BM=n(e),Ni=p(e,"P",{"data-svelte-h":!0}),o(Ni)!=="svelte-s10qq4"&&(Ni.innerHTML=Ru),GM=n(e),_i=p(e,"UL",{"data-svelte-h":!0}),o(_i)!=="svelte-1x43yje"&&(_i.innerHTML=Yu),vM=n(e),ZM=p(e,"HR",{}),QM=n(e),$i=p(e,"A",{id:!0,class:!0}),u($i).forEach(l),AM=n(e),r(Ri.$$.fragment,e),NM=n(e),Yi=p(e,"P",{"data-svelte-h":!0}),o(Yi)!=="svelte-at8fug"&&(Yi.textContent=Vu),_M=n(e),Vi=p(e,"TABLE",{"data-svelte-h":!0}),o(Vi)!=="svelte-1a94q5m"&&(Vi.innerHTML=Pu),$M=n(e),RM=p(e,"HR",{}),YM=n(e),Pi=p(e,"A",{id:!0,class:!0}),u(Pi).forEach(l),VM=n(e),r(Ei.$$.fragment,e),PM=n(e),Hi=p(e,"P",{"data-svelte-h":!0}),o(Hi)!=="svelte-bu7lod"&&(Hi.textContent=Eu),EM=n(e),Wi=p(e,"P",{"data-svelte-h":!0}),o(Wi)!=="svelte-1or1fiw"&&(Wi.innerHTML=Hu),HM=n(e),zi=p(e,"TABLE",{"data-svelte-h":!0}),o(zi)!=="svelte-55abd5"&&(zi.innerHTML=Wu),WM=n(e),zM=p(e,"HR",{}),SM=n(e),Si=p(e,"A",{id:!0,class:!0}),u(Si).forEach(l),XM=n(e),r(Xi.$$.fragment,e),LM=n(e),Li=p(e,"P",{"data-svelte-h":!0}),o(Li)!=="svelte-1nzvfes"&&(Li.innerHTML=zu),FM=n(e),Fi=p(e,"P",{"data-svelte-h":!0}),o(Fi)!=="svelte-1qq0cp9"&&(Fi.innerHTML=Su),DM=n(e),r(Di.$$.fragment,e),qM=n(e),qi=p(e,"P",{"data-svelte-h":!0}),o(qi)!=="svelte-1mslt41"&&(qi.innerHTML=Xu),OM=n(e),r(Oi.$$.fragment,e),KM=n(e),Ki=p(e,"P",{"data-svelte-h":!0}),o(Ki)!=="svelte-s10qq4"&&(Ki.innerHTML=Lu),em=n(e),en=p(e,"UL",{"data-svelte-h":!0}),o(en)!=="svelte-1p37gsh"&&(en.innerHTML=Fu),tm=n(e),lm=p(e,"HR",{}),sm=n(e),tn=p(e,"A",{id:!0,class:!0}),u(tn).forEach(l),im=n(e),r(ln.$$.fragment,e),nm=n(e),sn=p(e,"P",{"data-svelte-h":!0}),o(sn)!=="svelte-ipwl63"&&(sn.textContent=Du),am=n(e),nn=p(e,"TABLE",{"data-svelte-h":!0}),o(nn)!=="svelte-11vehfm"&&(nn.innerHTML=qu),pm=n(e),om=p(e,"HR",{}),dm=n(e),an=p(e,"A",{id:!0,class:!0}),u(an).forEach(l),cm=n(e),r(pn.$$.fragment,e),rm=n(e),on=p(e,"P",{"data-svelte-h":!0}),o(on)!=="svelte-1a4c4hr"&&(on.textContent=Ou),Mm=n(e),dn=p(e,"P",{"data-svelte-h":!0}),o(dn)!=="svelte-70tp0b"&&(dn.innerHTML=Ku),mm=n(e),cn=p(e,"TABLE",{"data-svelte-h":!0}),o(cn)!=="svelte-1hspmv9"&&(cn.innerHTML=eJ),Tm=n(e),ym=p(e,"HR",{}),um=n(e),rn=p(e,"A",{id:!0,class:!0}),u(rn).forEach(l),Jm=n(e),r(Mn.$$.fragment,e),hm=n(e),mn=p(e,"P",{"data-svelte-h":!0}),o(mn)!=="svelte-mcsd8f"&&(mn.innerHTML=tJ),wm=n(e),Tn=p(e,"P",{"data-svelte-h":!0}),o(Tn)!=="svelte-lb0vbj"&&(Tn.innerHTML=lJ),jm=n(e),yn=p(e,"UL",{"data-svelte-h":!0}),o(yn)!=="svelte-wk6owh"&&(yn.innerHTML=sJ),Um=n(e),un=p(e,"TABLE",{"data-svelte-h":!0}),o(un)!=="svelte-1hm9kaq"&&(un.innerHTML=iJ),fm=n(e),bm=p(e,"HR",{}),xm=n(e),Jn=p(e,"A",{id:!0,class:!0}),u(Jn).forEach(l),Cm=n(e),r(hn.$$.fragment,e),gm=n(e),wn=p(e,"P",{"data-svelte-h":!0}),o(wn)!=="svelte-ptv3i7"&&(wn.innerHTML=nJ),Im=n(e),jn=p(e,"TABLE",{"data-svelte-h":!0}),o(jn)!=="svelte-2eqjop"&&(jn.innerHTML=aJ),km=n(e),Bm=p(e,"HR",{}),Gm=n(e),Un=p(e,"A",{id:!0,class:!0}),u(Un).forEach(l),vm=n(e),r(fn.$$.fragment,e),Zm=n(e),bn=p(e,"P",{"data-svelte-h":!0}),o(bn)!=="svelte-1axcw5l"&&(bn.innerHTML=pJ),Qm=n(e),Am=p(e,"HR",{}),Nm=n(e),xn=p(e,"A",{id:!0,class:!0}),u(xn).forEach(l),_m=n(e),r(Cn.$$.fragment,e),$m=n(e),gn=p(e,"P",{"data-svelte-h":!0}),o(gn)!=="svelte-1axcw5l"&&(gn.innerHTML=oJ),Rm=n(e),In=p(e,"TABLE",{"data-svelte-h":!0}),o(In)!=="svelte-flnl7b"&&(In.innerHTML=dJ),Ym=n(e),Vm=p(e,"HR",{}),Pm=n(e),Bn=p(e,"P",{}),u(Bn).forEach(l),this.h()},h(){d(w,"name","hf:doc:metadata"),d(w,"content",hJ),d(j,"id","module_pipelines"),d(j,"class","group"),d(g,"id","module_pipelines.Pipeline"),d(g,"class","group"),d(v,"id","new_module_pipelines.Pipeline_new"),d(v,"class","group"),d(N,"id","module_pipelines.Pipeline+dispose"),d(N,"class","group"),d(Y,"id","module_pipelines.Pipeline+_call"),d(Y,"class","group"),d(W,"id","module_pipelines.TextClassificationPipeline"),d(W,"class","group"),d(ee,"id","module_pipelines.TextClassificationPipeline+_call"),d(ee,"class","group"),d(ne,"id","module_pipelines.TokenClassificationPipeline"),d(ne,"class","group"),d(me,"id","module_pipelines.TokenClassificationPipeline+_call"),d(me,"class","group"),d(he,"id","module_pipelines.QuestionAnsweringPipeline"),d(he,"class","group"),d(xe,"id","module_pipelines.QuestionAnsweringPipeline+_call"),d(xe,"class","group"),d(Be,"id","module_pipelines.FillMaskPipeline"),d(Be,"class","group"),d($e,"id","module_pipelines.FillMaskPipeline+_call"),d($e,"class","group"),d(Ee,"id","module_pipelines.Text2TextGenerationPipeline"),d(Ee,"class","group"),d(Le,"id","module_pipelines.Text2TextGenerationPipeline+_call"),d(Le,"class","group"),d(et,"id","module_pipelines.SummarizationPipeline"),d(et,"class","group"),d(at,"id","module_pipelines.TranslationPipeline"),d(at,"class","group"),d(wt,"id","module_pipelines.TextGenerationPipeline"),d(wt,"class","group"),d(Bt,"id","module_pipelines.TextGenerationPipeline+_call"),d(Bt,"class","group"),d(At,"id","module_pipelines.ZeroShotClassificationPipeline"),d(At,"class","group"),d(Ht,"id","new_module_pipelines.ZeroShotClassificationPipeline_new"),d(Ht,"class","group"),d(Xt,"id","module_pipelines.ZeroShotClassificationPipeline+_call"),d(Xt,"class","group"),d(qt,"id","module_pipelines.FeatureExtractionPipeline"),d(qt,"class","group"),d(pl,"id","module_pipelines.FeatureExtractionPipeline+_call"),d(pl,"class","group"),d(Ml,"id","module_pipelines.AudioClassificationPipeline"),d(Ml,"class","group"),d(wl,"id","new_module_pipelines.AudioClassificationPipeline_new"),d(wl,"class","group"),d(bl,"id","module_pipelines.AudioClassificationPipeline+_call"),d(bl,"class","group"),d(kl,"id","module_pipelines.AutomaticSpeechRecognitionPipeline"),d(kl,"class","group"),d(zl,"id","new_module_pipelines.AutomaticSpeechRecognitionPipeline_new"),d(zl,"class","group"),d(Fl,"id","module_pipelines.AutomaticSpeechRecognitionPipeline+_call"),d(Fl,"class","group"),d(es,"id","module_pipelines.ImageToTextPipeline"),d(es,"class","group"),d(ps,"id","new_module_pipelines.ImageToTextPipeline_new"),d(ps,"class","group"),d(rs,"id","module_pipelines.ImageToTextPipeline+_call"),d(rs,"class","group"),d(us,"id","module_pipelines.ImageClassificationPipeline"),d(us,"class","group"),d(Is,"id","new_module_pipelines.ImageClassificationPipeline_new"),d(Is,"class","group"),d(vs,"id","module_pipelines.ImageClassificationPipeline+_call"),d(vs,"class","group"),d(_s,"id","module_pipelines.ImageSegmentationPipeline"),d(_s,"class","group"),d(Hs,"id","new_module_pipelines.ImageSegmentationPipeline_new"),d(Hs,"class","group"),d(Xs,"id","module_pipelines.ImageSegmentationPipeline+_call"),d(Xs,"class","group"),d(Os,"id","module_pipelines.ZeroShotImageClassificationPipeline"),d(Os,"class","group"),d(ni,"id","new_module_pipelines.ZeroShotImageClassificationPipeline_new"),d(ni,"class","group"),d(di,"id","module_pipelines.ZeroShotImageClassificationPipeline+_call"),d(di,"class","group"),d(Ti,"id","module_pipelines.ObjectDetectionPipeline"),d(Ti,"class","group"),d(Ui,"id","new_module_pipelines.ObjectDetectionPipeline_new"),d(Ui,"class","group"),d(Ci,"id","module_pipelines.ObjectDetectionPipeline+_call"),d(Ci,"class","group"),d(Gi,"id","module_pipelines.DocumentQuestionAnsweringPipeline"),d(Gi,"class","group"),d($i,"id","new_module_pipelines.DocumentQuestionAnsweringPipeline_new"),d($i,"class","group"),d(Pi,"id","module_pipelines.DocumentQuestionAnsweringPipeline+_call"),d(Pi,"class","group"),d(Si,"id","module_pipelines.TextToAudioPipeline"),d(Si,"class","group"),d(tn,"id","new_module_pipelines.TextToAudioPipeline_new"),d(tn,"class","group"),d(an,"id","module_pipelines.TextToAudioPipeline+_call"),d(an,"class","group"),d(rn,"id","module_pipelines.pipeline"),d(rn,"class","group"),d(Jn,"id","module_pipelines..QuestionAnsweringResult"),d(Jn,"class","group"),d(Un,"id","module_pipelines..QuestionAnsweringReturnType"),d(Un,"class","group"),d(xn,"id","module_pipelines..ChunkCallback"),d(xn,"class","group")},m(e,t){uJ(document.head,w),s(e,Gn,t),s(e,kn,t),s(e,vn,t),s(e,j,t),s(e,Zn,t),M(U,e,t),s(e,Qn,t),s(e,f,t),s(e,An,t),s(e,b,t),s(e,Nn,t),M(x,e,t),s(e,_n,t),s(e,C,t),s(e,$n,t),s(e,Rn,t),s(e,Yn,t),s(e,g,t),s(e,Vn,t),M(I,e,t),s(e,Pn,t),s(e,k,t),s(e,En,t),s(e,B,t),s(e,Hn,t),s(e,G,t),s(e,Wn,t),s(e,zn,t),s(e,Sn,t),s(e,v,t),s(e,Xn,t),M(Z,e,t),s(e,Ln,t),s(e,Q,t),s(e,Fn,t),s(e,A,t),s(e,Dn,t),s(e,qn,t),s(e,On,t),s(e,N,t),s(e,Kn,t),M(_,e,t),s(e,ea,t),s(e,$,t),s(e,ta,t),s(e,R,t),s(e,la,t),s(e,sa,t),s(e,ia,t),s(e,Y,t),s(e,na,t),M(V,e,t),s(e,aa,t),s(e,P,t),s(e,pa,t),s(e,E,t),s(e,oa,t),s(e,H,t),s(e,da,t),s(e,ca,t),s(e,ra,t),s(e,W,t),s(e,Ma,t),M(z,e,t),s(e,ma,t),s(e,S,t),s(e,Ta,t),s(e,X,t),s(e,ya,t),M(L,e,t),s(e,ua,t),s(e,F,t),s(e,Ja,t),M(D,e,t),s(e,ha,t),s(e,q,t),s(e,wa,t),M(O,e,t),s(e,ja,t),s(e,K,t),s(e,Ua,t),s(e,fa,t),s(e,ba,t),s(e,ee,t),s(e,xa,t),M(te,e,t),s(e,Ca,t),s(e,le,t),s(e,ga,t),s(e,se,t),s(e,Ia,t),s(e,ie,t),s(e,ka,t),s(e,Ba,t),s(e,Ga,t),s(e,ne,t),s(e,va,t),M(ae,e,t),s(e,Za,t),s(e,pe,t),s(e,Qa,t),s(e,oe,t),s(e,Aa,t),M(de,e,t),s(e,Na,t),s(e,ce,t),s(e,_a,t),M(re,e,t),s(e,$a,t),s(e,Me,t),s(e,Ra,t),s(e,Ya,t),s(e,Va,t),s(e,me,t),s(e,Pa,t),M(Te,e,t),s(e,Ea,t),s(e,ye,t),s(e,Ha,t),s(e,ue,t),s(e,Wa,t),s(e,Je,t),s(e,za,t),s(e,Sa,t),s(e,Xa,t),s(e,he,t),s(e,La,t),M(we,e,t),s(e,Fa,t),s(e,je,t),s(e,Da,t),s(e,Ue,t),s(e,qa,t),M(fe,e,t),s(e,Oa,t),s(e,be,t),s(e,Ka,t),s(e,ep,t),s(e,tp,t),s(e,xe,t),s(e,lp,t),M(Ce,e,t),s(e,sp,t),s(e,ge,t),s(e,ip,t),s(e,Ie,t),s(e,np,t),s(e,ke,t),s(e,ap,t),s(e,pp,t),s(e,op,t),s(e,Be,t),s(e,dp,t),M(Ge,e,t),s(e,cp,t),s(e,ve,t),s(e,rp,t),s(e,Ze,t),s(e,Mp,t),M(Qe,e,t),s(e,mp,t),s(e,Ae,t),s(e,Tp,t),M(Ne,e,t),s(e,yp,t),s(e,_e,t),s(e,up,t),s(e,Jp,t),s(e,hp,t),s(e,$e,t),s(e,wp,t),M(Re,e,t),s(e,jp,t),s(e,Ye,t),s(e,Up,t),s(e,Ve,t),s(e,fp,t),s(e,Pe,t),s(e,bp,t),s(e,xp,t),s(e,Cp,t),s(e,Ee,t),s(e,gp,t),M(He,e,t),s(e,Ip,t),s(e,We,t),s(e,kp,t),s(e,ze,t),s(e,Bp,t),M(Se,e,t),s(e,Gp,t),s(e,Xe,t),s(e,vp,t),s(e,Zp,t),s(e,Qp,t),s(e,Le,t),s(e,Ap,t),M(Fe,e,t),s(e,Np,t),s(e,De,t),s(e,_p,t),s(e,qe,t),s(e,$p,t),s(e,Oe,t),s(e,Rp,t),s(e,Ke,t),s(e,Yp,t),s(e,Vp,t),s(e,Pp,t),s(e,et,t),s(e,Ep,t),M(tt,e,t),s(e,Hp,t),s(e,lt,t),s(e,Wp,t),s(e,st,t),s(e,zp,t),M(it,e,t),s(e,Sp,t),s(e,nt,t),s(e,Xp,t),s(e,Lp,t),s(e,Fp,t),s(e,at,t),s(e,Dp,t),M(pt,e,t),s(e,qp,t),s(e,ot,t),s(e,Op,t),s(e,dt,t),s(e,Kp,t),s(e,ct,t),s(e,eo,t),M(rt,e,t),s(e,to,t),s(e,Mt,t),s(e,lo,t),s(e,mt,t),s(e,so,t),M(Tt,e,t),s(e,io,t),s(e,yt,t),s(e,no,t),s(e,ut,t),s(e,ao,t),M(Jt,e,t),s(e,po,t),s(e,ht,t),s(e,oo,t),s(e,co,t),s(e,ro,t),s(e,wt,t),s(e,Mo,t),M(jt,e,t),s(e,mo,t),s(e,Ut,t),s(e,To,t),s(e,ft,t),s(e,yo,t),M(bt,e,t),s(e,uo,t),s(e,xt,t),s(e,Jo,t),M(Ct,e,t),s(e,ho,t),s(e,gt,t),s(e,wo,t),M(It,e,t),s(e,jo,t),s(e,kt,t),s(e,Uo,t),s(e,fo,t),s(e,bo,t),s(e,Bt,t),s(e,xo,t),M(Gt,e,t),s(e,Co,t),s(e,vt,t),s(e,go,t),s(e,Zt,t),s(e,Io,t),s(e,Qt,t),s(e,ko,t),s(e,Bo,t),s(e,Go,t),s(e,At,t),s(e,vo,t),M(Nt,e,t),s(e,Zo,t),s(e,_t,t),s(e,Qo,t),s(e,$t,t),s(e,Ao,t),M(Rt,e,t),s(e,No,t),s(e,Yt,t),s(e,_o,t),M(Vt,e,t),s(e,$o,t),s(e,Pt,t),s(e,Ro,t),s(e,Et,t),s(e,Yo,t),s(e,Vo,t),s(e,Po,t),s(e,Ht,t),s(e,Eo,t),M(Wt,e,t),s(e,Ho,t),s(e,zt,t),s(e,Wo,t),s(e,St,t),s(e,zo,t),s(e,So,t),s(e,Xo,t),s(e,Xt,t),s(e,Lo,t),M(Lt,e,t),s(e,Fo,t),s(e,Ft,t),s(e,Do,t),s(e,Dt,t),s(e,qo,t),s(e,Oo,t),s(e,Ko,t),s(e,qt,t),s(e,ed,t),M(Ot,e,t),s(e,td,t),s(e,Kt,t),s(e,ld,t),s(e,el,t),s(e,sd,t),M(tl,e,t),s(e,id,t),s(e,ll,t),s(e,nd,t),M(sl,e,t),s(e,ad,t),s(e,il,t),s(e,pd,t),M(nl,e,t),s(e,od,t),s(e,al,t),s(e,dd,t),s(e,cd,t),s(e,rd,t),s(e,pl,t),s(e,Md,t),M(ol,e,t),s(e,md,t),s(e,dl,t),s(e,Td,t),s(e,cl,t),s(e,yd,t),s(e,rl,t),s(e,ud,t),s(e,Jd,t),s(e,hd,t),s(e,Ml,t),s(e,wd,t),M(ml,e,t),s(e,jd,t),s(e,Tl,t),s(e,Ud,t),s(e,yl,t),s(e,fd,t),M(ul,e,t),s(e,bd,t),s(e,Jl,t),s(e,xd,t),s(e,hl,t),s(e,Cd,t),s(e,gd,t),s(e,Id,t),s(e,wl,t),s(e,kd,t),M(jl,e,t),s(e,Bd,t),s(e,Ul,t),s(e,Gd,t),s(e,fl,t),s(e,vd,t),s(e,Zd,t),s(e,Qd,t),s(e,bl,t),s(e,Ad,t),M(xl,e,t),s(e,Nd,t),s(e,Cl,t),s(e,_d,t),s(e,gl,t),s(e,$d,t),s(e,Il,t),s(e,Rd,t),s(e,Yd,t),s(e,Vd,t),s(e,kl,t),s(e,Pd,t),M(Bl,e,t),s(e,Ed,t),s(e,Gl,t),s(e,Hd,t),s(e,vl,t),s(e,Wd,t),M(Zl,e,t),s(e,zd,t),s(e,Ql,t),s(e,Sd,t),M(Al,e,t),s(e,Xd,t),s(e,Nl,t),s(e,Ld,t),M(_l,e,t),s(e,Fd,t),s(e,$l,t),s(e,Dd,t),M(Rl,e,t),s(e,qd,t),s(e,Yl,t),s(e,Od,t),M(Vl,e,t),s(e,Kd,t),s(e,Pl,t),s(e,ec,t),M(El,e,t),s(e,tc,t),s(e,Hl,t),s(e,lc,t),s(e,Wl,t),s(e,sc,t),s(e,ic,t),s(e,nc,t),s(e,zl,t),s(e,ac,t),M(Sl,e,t),s(e,pc,t),s(e,Xl,t),s(e,oc,t),s(e,Ll,t),s(e,dc,t),s(e,cc,t),s(e,rc,t),s(e,Fl,t),s(e,Mc,t),M(Dl,e,t),s(e,mc,t),s(e,ql,t),s(e,Tc,t),s(e,Ol,t),s(e,yc,t),s(e,Kl,t),s(e,uc,t),s(e,Jc,t),s(e,hc,t),s(e,es,t),s(e,wc,t),M(ts,e,t),s(e,jc,t),s(e,ls,t),s(e,Uc,t),s(e,ss,t),s(e,fc,t),M(is,e,t),s(e,bc,t),s(e,ns,t),s(e,xc,t),s(e,as,t),s(e,Cc,t),s(e,gc,t),s(e,Ic,t),s(e,ps,t),s(e,kc,t),M(os,e,t),s(e,Bc,t),s(e,ds,t),s(e,Gc,t),s(e,cs,t),s(e,vc,t),s(e,Zc,t),s(e,Qc,t),s(e,rs,t),s(e,Ac,t),M(Ms,e,t),s(e,Nc,t),s(e,ms,t),s(e,_c,t),s(e,Ts,t),s(e,$c,t),s(e,ys,t),s(e,Rc,t),s(e,Yc,t),s(e,Vc,t),s(e,us,t),s(e,Pc,t),M(Js,e,t),s(e,Ec,t),s(e,hs,t),s(e,Hc,t),s(e,ws,t),s(e,Wc,t),M(js,e,t),s(e,zc,t),s(e,Us,t),s(e,Sc,t),M(fs,e,t),s(e,Xc,t),s(e,bs,t),s(e,Lc,t),M(xs,e,t),s(e,Fc,t),s(e,Cs,t),s(e,Dc,t),s(e,gs,t),s(e,qc,t),s(e,Oc,t),s(e,Kc,t),s(e,Is,t),s(e,er,t),M(ks,e,t),s(e,tr,t),s(e,Bs,t),s(e,lr,t),s(e,Gs,t),s(e,sr,t),s(e,ir,t),s(e,nr,t),s(e,vs,t),s(e,ar,t),M(Zs,e,t),s(e,pr,t),s(e,Qs,t),s(e,or,t),s(e,As,t),s(e,dr,t),s(e,Ns,t),s(e,cr,t),s(e,rr,t),s(e,Mr,t),s(e,_s,t),s(e,mr,t),M($s,e,t),s(e,Tr,t),s(e,Rs,t),s(e,yr,t),s(e,Ys,t),s(e,ur,t),M(Vs,e,t),s(e,Jr,t),s(e,Ps,t),s(e,hr,t),s(e,Es,t),s(e,wr,t),s(e,jr,t),s(e,Ur,t),s(e,Hs,t),s(e,fr,t),M(Ws,e,t),s(e,br,t),s(e,zs,t),s(e,xr,t),s(e,Ss,t),s(e,Cr,t),s(e,gr,t),s(e,Ir,t),s(e,Xs,t),s(e,kr,t),M(Ls,e,t),s(e,Br,t),s(e,Fs,t),s(e,Gr,t),s(e,Ds,t),s(e,vr,t),s(e,qs,t),s(e,Zr,t),s(e,Qr,t),s(e,Ar,t),s(e,Os,t),s(e,Nr,t),M(Ks,e,t),s(e,_r,t),s(e,ei,t),s(e,$r,t),s(e,ti,t),s(e,Rr,t),M(li,e,t),s(e,Yr,t),s(e,si,t),s(e,Vr,t),s(e,ii,t),s(e,Pr,t),s(e,Er,t),s(e,Hr,t),s(e,ni,t),s(e,Wr,t),M(ai,e,t),s(e,zr,t),s(e,pi,t),s(e,Sr,t),s(e,oi,t),s(e,Xr,t),s(e,Lr,t),s(e,Fr,t),s(e,di,t),s(e,Dr,t),M(ci,e,t),s(e,qr,t),s(e,ri,t),s(e,Or,t),s(e,Mi,t),s(e,Kr,t),s(e,mi,t),s(e,eM,t),s(e,tM,t),s(e,lM,t),s(e,Ti,t),s(e,sM,t),M(yi,e,t),s(e,iM,t),s(e,ui,t),s(e,nM,t),s(e,Ji,t),s(e,aM,t),M(hi,e,t),s(e,pM,t),s(e,wi,t),s(e,oM,t),s(e,ji,t),s(e,dM,t),s(e,cM,t),s(e,rM,t),s(e,Ui,t),s(e,MM,t),M(fi,e,t),s(e,mM,t),s(e,bi,t),s(e,TM,t),s(e,xi,t),s(e,yM,t),s(e,uM,t),s(e,JM,t),s(e,Ci,t),s(e,hM,t),M(gi,e,t),s(e,wM,t),s(e,Ii,t),s(e,jM,t),s(e,ki,t),s(e,UM,t),s(e,Bi,t),s(e,fM,t),s(e,bM,t),s(e,xM,t),s(e,Gi,t),s(e,CM,t),M(vi,e,t),s(e,gM,t),s(e,Zi,t),s(e,IM,t),s(e,Qi,t),s(e,kM,t),M(Ai,e,t),s(e,BM,t),s(e,Ni,t),s(e,GM,t),s(e,_i,t),s(e,vM,t),s(e,ZM,t),s(e,QM,t),s(e,$i,t),s(e,AM,t),M(Ri,e,t),s(e,NM,t),s(e,Yi,t),s(e,_M,t),s(e,Vi,t),s(e,$M,t),s(e,RM,t),s(e,YM,t),s(e,Pi,t),s(e,VM,t),M(Ei,e,t),s(e,PM,t),s(e,Hi,t),s(e,EM,t),s(e,Wi,t),s(e,HM,t),s(e,zi,t),s(e,WM,t),s(e,zM,t),s(e,SM,t),s(e,Si,t),s(e,XM,t),M(Xi,e,t),s(e,LM,t),s(e,Li,t),s(e,FM,t),s(e,Fi,t),s(e,DM,t),M(Di,e,t),s(e,qM,t),s(e,qi,t),s(e,OM,t),M(Oi,e,t),s(e,KM,t),s(e,Ki,t),s(e,em,t),s(e,en,t),s(e,tm,t),s(e,lm,t),s(e,sm,t),s(e,tn,t),s(e,im,t),M(ln,e,t),s(e,nm,t),s(e,sn,t),s(e,am,t),s(e,nn,t),s(e,pm,t),s(e,om,t),s(e,dm,t),s(e,an,t),s(e,cm,t),M(pn,e,t),s(e,rm,t),s(e,on,t),s(e,Mm,t),s(e,dn,t),s(e,mm,t),s(e,cn,t),s(e,Tm,t),s(e,ym,t),s(e,um,t),s(e,rn,t),s(e,Jm,t),M(Mn,e,t),s(e,hm,t),s(e,mn,t),s(e,wm,t),s(e,Tn,t),s(e,jm,t),s(e,yn,t),s(e,Um,t),s(e,un,t),s(e,fm,t),s(e,bm,t),s(e,xm,t),s(e,Jn,t),s(e,Cm,t),M(hn,e,t),s(e,gm,t),s(e,wn,t),s(e,Im,t),s(e,jn,t),s(e,km,t),s(e,Bm,t),s(e,Gm,t),s(e,Un,t),s(e,vm,t),M(fn,e,t),s(e,Zm,t),s(e,bn,t),s(e,Qm,t),s(e,Am,t),s(e,Nm,t),s(e,xn,t),s(e,_m,t),M(Cn,e,t),s(e,$m,t),s(e,gn,t),s(e,Rm,t),s(e,In,t),s(e,Ym,t),s(e,Vm,t),s(e,Pm,t),s(e,Bn,t),Em=!0},p:rJ,i(e){Em||(m(U.$$.fragment,e),m(x.$$.fragment,e),m(I.$$.fragment,e),m(Z.$$.fragment,e),m(_.$$.fragment,e),m(V.$$.fragment,e),m(z.$$.fragment,e),m(L.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(te.$$.fragment,e),m(ae.$$.fragment,e),m(de.$$.fragment,e),m(re.$$.fragment,e),m(Te.$$.fragment,e),m(we.$$.fragment,e),m(fe.$$.fragment,e),m(Ce.$$.fragment,e),m(Ge.$$.fragment,e),m(Qe.$$.fragment,e),m(Ne.$$.fragment,e),m(Re.$$.fragment,e),m(He.$$.fragment,e),m(Se.$$.fragment,e),m(Fe.$$.fragment,e),m(tt.$$.fragment,e),m(it.$$.fragment,e),m(pt.$$.fragment,e),m(rt.$$.fragment,e),m(Tt.$$.fragment,e),m(Jt.$$.fragment,e),m(jt.$$.fragment,e),m(bt.$$.fragment,e),m(Ct.$$.fragment,e),m(It.$$.fragment,e),m(Gt.$$.fragment,e),m(Nt.$$.fragment,e),m(Rt.$$.fragment,e),m(Vt.$$.fragment,e),m(Wt.$$.fragment,e),m(Lt.$$.fragment,e),m(Ot.$$.fragment,e),m(tl.$$.fragment,e),m(sl.$$.fragment,e),m(nl.$$.fragment,e),m(ol.$$.fragment,e),m(ml.$$.fragment,e),m(ul.$$.fragment,e),m(jl.$$.fragment,e),m(xl.$$.fragment,e),m(Bl.$$.fragment,e),m(Zl.$$.fragment,e),m(Al.$$.fragment,e),m(_l.$$.fragment,e),m(Rl.$$.fragment,e),m(Vl.$$.fragment,e),m(El.$$.fragment,e),m(Sl.$$.fragment,e),m(Dl.$$.fragment,e),m(ts.$$.fragment,e),m(is.$$.fragment,e),m(os.$$.fragment,e),m(Ms.$$.fragment,e),m(Js.$$.fragment,e),m(js.$$.fragment,e),m(fs.$$.fragment,e),m(xs.$$.fragment,e),m(ks.$$.fragment,e),m(Zs.$$.fragment,e),m($s.$$.fragment,e),m(Vs.$$.fragment,e),m(Ws.$$.fragment,e),m(Ls.$$.fragment,e),m(Ks.$$.fragment,e),m(li.$$.fragment,e),m(ai.$$.fragment,e),m(ci.$$.fragment,e),m(yi.$$.fragment,e),m(hi.$$.fragment,e),m(fi.$$.fragment,e),m(gi.$$.fragment,e),m(vi.$$.fragment,e),m(Ai.$$.fragment,e),m(Ri.$$.fragment,e),m(Ei.$$.fragment,e),m(Xi.$$.fragment,e),m(Di.$$.fragment,e),m(Oi.$$.fragment,e),m(ln.$$.fragment,e),m(pn.$$.fragment,e),m(Mn.$$.fragment,e),m(hn.$$.fragment,e),m(fn.$$.fragment,e),m(Cn.$$.fragment,e),Em=!0)},o(e){T(U.$$.fragment,e),T(x.$$.fragment,e),T(I.$$.fragment,e),T(Z.$$.fragment,e),T(_.$$.fragment,e),T(V.$$.fragment,e),T(z.$$.fragment,e),T(L.$$.fragment,e),T(D.$$.fragment,e),T(O.$$.fragment,e),T(te.$$.fragment,e),T(ae.$$.fragment,e),T(de.$$.fragment,e),T(re.$$.fragment,e),T(Te.$$.fragment,e),T(we.$$.fragment,e),T(fe.$$.fragment,e),T(Ce.$$.fragment,e),T(Ge.$$.fragment,e),T(Qe.$$.fragment,e),T(Ne.$$.fragment,e),T(Re.$$.fragment,e),T(He.$$.fragment,e),T(Se.$$.fragment,e),T(Fe.$$.fragment,e),T(tt.$$.fragment,e),T(it.$$.fragment,e),T(pt.$$.fragment,e),T(rt.$$.fragment,e),T(Tt.$$.fragment,e),T(Jt.$$.fragment,e),T(jt.$$.fragment,e),T(bt.$$.fragment,e),T(Ct.$$.fragment,e),T(It.$$.fragment,e),T(Gt.$$.fragment,e),T(Nt.$$.fragment,e),T(Rt.$$.fragment,e),T(Vt.$$.fragment,e),T(Wt.$$.fragment,e),T(Lt.$$.fragment,e),T(Ot.$$.fragment,e),T(tl.$$.fragment,e),T(sl.$$.fragment,e),T(nl.$$.fragment,e),T(ol.$$.fragment,e),T(ml.$$.fragment,e),T(ul.$$.fragment,e),T(jl.$$.fragment,e),T(xl.$$.fragment,e),T(Bl.$$.fragment,e),T(Zl.$$.fragment,e),T(Al.$$.fragment,e),T(_l.$$.fragment,e),T(Rl.$$.fragment,e),T(Vl.$$.fragment,e),T(El.$$.fragment,e),T(Sl.$$.fragment,e),T(Dl.$$.fragment,e),T(ts.$$.fragment,e),T(is.$$.fragment,e),T(os.$$.fragment,e),T(Ms.$$.fragment,e),T(Js.$$.fragment,e),T(js.$$.fragment,e),T(fs.$$.fragment,e),T(xs.$$.fragment,e),T(ks.$$.fragment,e),T(Zs.$$.fragment,e),T($s.$$.fragment,e),T(Vs.$$.fragment,e),T(Ws.$$.fragment,e),T(Ls.$$.fragment,e),T(Ks.$$.fragment,e),T(li.$$.fragment,e),T(ai.$$.fragment,e),T(ci.$$.fragment,e),T(yi.$$.fragment,e),T(hi.$$.fragment,e),T(fi.$$.fragment,e),T(gi.$$.fragment,e),T(vi.$$.fragment,e),T(Ai.$$.fragment,e),T(Ri.$$.fragment,e),T(Ei.$$.fragment,e),T(Xi.$$.fragment,e),T(Di.$$.fragment,e),T(Oi.$$.fragment,e),T(ln.$$.fragment,e),T(pn.$$.fragment,e),T(Mn.$$.fragment,e),T(hn.$$.fragment,e),T(fn.$$.fragment,e),T(Cn.$$.fragment,e),Em=!1},d(e){e&&(l(Gn),l(kn),l(vn),l(j),l(Zn),l(Qn),l(f),l(An),l(b),l(Nn),l(_n),l(C),l($n),l(Rn),l(Yn),l(g),l(Vn),l(Pn),l(k),l(En),l(B),l(Hn),l(G),l(Wn),l(zn),l(Sn),l(v),l(Xn),l(Ln),l(Q),l(Fn),l(A),l(Dn),l(qn),l(On),l(N),l(Kn),l(ea),l($),l(ta),l(R),l(la),l(sa),l(ia),l(Y),l(na),l(aa),l(P),l(pa),l(E),l(oa),l(H),l(da),l(ca),l(ra),l(W),l(Ma),l(ma),l(S),l(Ta),l(X),l(ya),l(ua),l(F),l(Ja),l(ha),l(q),l(wa),l(ja),l(K),l(Ua),l(fa),l(ba),l(ee),l(xa),l(Ca),l(le),l(ga),l(se),l(Ia),l(ie),l(ka),l(Ba),l(Ga),l(ne),l(va),l(Za),l(pe),l(Qa),l(oe),l(Aa),l(Na),l(ce),l(_a),l($a),l(Me),l(Ra),l(Ya),l(Va),l(me),l(Pa),l(Ea),l(ye),l(Ha),l(ue),l(Wa),l(Je),l(za),l(Sa),l(Xa),l(he),l(La),l(Fa),l(je),l(Da),l(Ue),l(qa),l(Oa),l(be),l(Ka),l(ep),l(tp),l(xe),l(lp),l(sp),l(ge),l(ip),l(Ie),l(np),l(ke),l(ap),l(pp),l(op),l(Be),l(dp),l(cp),l(ve),l(rp),l(Ze),l(Mp),l(mp),l(Ae),l(Tp),l(yp),l(_e),l(up),l(Jp),l(hp),l($e),l(wp),l(jp),l(Ye),l(Up),l(Ve),l(fp),l(Pe),l(bp),l(xp),l(Cp),l(Ee),l(gp),l(Ip),l(We),l(kp),l(ze),l(Bp),l(Gp),l(Xe),l(vp),l(Zp),l(Qp),l(Le),l(Ap),l(Np),l(De),l(_p),l(qe),l($p),l(Oe),l(Rp),l(Ke),l(Yp),l(Vp),l(Pp),l(et),l(Ep),l(Hp),l(lt),l(Wp),l(st),l(zp),l(Sp),l(nt),l(Xp),l(Lp),l(Fp),l(at),l(Dp),l(qp),l(ot),l(Op),l(dt),l(Kp),l(ct),l(eo),l(to),l(Mt),l(lo),l(mt),l(so),l(io),l(yt),l(no),l(ut),l(ao),l(po),l(ht),l(oo),l(co),l(ro),l(wt),l(Mo),l(mo),l(Ut),l(To),l(ft),l(yo),l(uo),l(xt),l(Jo),l(ho),l(gt),l(wo),l(jo),l(kt),l(Uo),l(fo),l(bo),l(Bt),l(xo),l(Co),l(vt),l(go),l(Zt),l(Io),l(Qt),l(ko),l(Bo),l(Go),l(At),l(vo),l(Zo),l(_t),l(Qo),l($t),l(Ao),l(No),l(Yt),l(_o),l($o),l(Pt),l(Ro),l(Et),l(Yo),l(Vo),l(Po),l(Ht),l(Eo),l(Ho),l(zt),l(Wo),l(St),l(zo),l(So),l(Xo),l(Xt),l(Lo),l(Fo),l(Ft),l(Do),l(Dt),l(qo),l(Oo),l(Ko),l(qt),l(ed),l(td),l(Kt),l(ld),l(el),l(sd),l(id),l(ll),l(nd),l(ad),l(il),l(pd),l(od),l(al),l(dd),l(cd),l(rd),l(pl),l(Md),l(md),l(dl),l(Td),l(cl),l(yd),l(rl),l(ud),l(Jd),l(hd),l(Ml),l(wd),l(jd),l(Tl),l(Ud),l(yl),l(fd),l(bd),l(Jl),l(xd),l(hl),l(Cd),l(gd),l(Id),l(wl),l(kd),l(Bd),l(Ul),l(Gd),l(fl),l(vd),l(Zd),l(Qd),l(bl),l(Ad),l(Nd),l(Cl),l(_d),l(gl),l($d),l(Il),l(Rd),l(Yd),l(Vd),l(kl),l(Pd),l(Ed),l(Gl),l(Hd),l(vl),l(Wd),l(zd),l(Ql),l(Sd),l(Xd),l(Nl),l(Ld),l(Fd),l($l),l(Dd),l(qd),l(Yl),l(Od),l(Kd),l(Pl),l(ec),l(tc),l(Hl),l(lc),l(Wl),l(sc),l(ic),l(nc),l(zl),l(ac),l(pc),l(Xl),l(oc),l(Ll),l(dc),l(cc),l(rc),l(Fl),l(Mc),l(mc),l(ql),l(Tc),l(Ol),l(yc),l(Kl),l(uc),l(Jc),l(hc),l(es),l(wc),l(jc),l(ls),l(Uc),l(ss),l(fc),l(bc),l(ns),l(xc),l(as),l(Cc),l(gc),l(Ic),l(ps),l(kc),l(Bc),l(ds),l(Gc),l(cs),l(vc),l(Zc),l(Qc),l(rs),l(Ac),l(Nc),l(ms),l(_c),l(Ts),l($c),l(ys),l(Rc),l(Yc),l(Vc),l(us),l(Pc),l(Ec),l(hs),l(Hc),l(ws),l(Wc),l(zc),l(Us),l(Sc),l(Xc),l(bs),l(Lc),l(Fc),l(Cs),l(Dc),l(gs),l(qc),l(Oc),l(Kc),l(Is),l(er),l(tr),l(Bs),l(lr),l(Gs),l(sr),l(ir),l(nr),l(vs),l(ar),l(pr),l(Qs),l(or),l(As),l(dr),l(Ns),l(cr),l(rr),l(Mr),l(_s),l(mr),l(Tr),l(Rs),l(yr),l(Ys),l(ur),l(Jr),l(Ps),l(hr),l(Es),l(wr),l(jr),l(Ur),l(Hs),l(fr),l(br),l(zs),l(xr),l(Ss),l(Cr),l(gr),l(Ir),l(Xs),l(kr),l(Br),l(Fs),l(Gr),l(Ds),l(vr),l(qs),l(Zr),l(Qr),l(Ar),l(Os),l(Nr),l(_r),l(ei),l($r),l(ti),l(Rr),l(Yr),l(si),l(Vr),l(ii),l(Pr),l(Er),l(Hr),l(ni),l(Wr),l(zr),l(pi),l(Sr),l(oi),l(Xr),l(Lr),l(Fr),l(di),l(Dr),l(qr),l(ri),l(Or),l(Mi),l(Kr),l(mi),l(eM),l(tM),l(lM),l(Ti),l(sM),l(iM),l(ui),l(nM),l(Ji),l(aM),l(pM),l(wi),l(oM),l(ji),l(dM),l(cM),l(rM),l(Ui),l(MM),l(mM),l(bi),l(TM),l(xi),l(yM),l(uM),l(JM),l(Ci),l(hM),l(wM),l(Ii),l(jM),l(ki),l(UM),l(Bi),l(fM),l(bM),l(xM),l(Gi),l(CM),l(gM),l(Zi),l(IM),l(Qi),l(kM),l(BM),l(Ni),l(GM),l(_i),l(vM),l(ZM),l(QM),l($i),l(AM),l(NM),l(Yi),l(_M),l(Vi),l($M),l(RM),l(YM),l(Pi),l(VM),l(PM),l(Hi),l(EM),l(Wi),l(HM),l(zi),l(WM),l(zM),l(SM),l(Si),l(XM),l(LM),l(Li),l(FM),l(Fi),l(DM),l(qM),l(qi),l(OM),l(KM),l(Ki),l(em),l(en),l(tm),l(lm),l(sm),l(tn),l(im),l(nm),l(sn),l(am),l(nn),l(pm),l(om),l(dm),l(an),l(cm),l(rm),l(on),l(Mm),l(dn),l(mm),l(cn),l(Tm),l(ym),l(um),l(rn),l(Jm),l(hm),l(mn),l(wm),l(Tn),l(jm),l(yn),l(Um),l(un),l(fm),l(bm),l(xm),l(Jn),l(Cm),l(gm),l(wn),l(Im),l(jn),l(km),l(Bm),l(Gm),l(Un),l(vm),l(Zm),l(bn),l(Qm),l(Am),l(Nm),l(xn),l(_m),l($m),l(gn),l(Rm),l(In),l(Ym),l(Vm),l(Pm),l(Bn)),l(w),y(U,e),y(x,e),y(I,e),y(Z,e),y(_,e),y(V,e),y(z,e),y(L,e),y(D,e),y(O,e),y(te,e),y(ae,e),y(de,e),y(re,e),y(Te,e),y(we,e),y(fe,e),y(Ce,e),y(Ge,e),y(Qe,e),y(Ne,e),y(Re,e),y(He,e),y(Se,e),y(Fe,e),y(tt,e),y(it,e),y(pt,e),y(rt,e),y(Tt,e),y(Jt,e),y(jt,e),y(bt,e),y(Ct,e),y(It,e),y(Gt,e),y(Nt,e),y(Rt,e),y(Vt,e),y(Wt,e),y(Lt,e),y(Ot,e),y(tl,e),y(sl,e),y(nl,e),y(ol,e),y(ml,e),y(ul,e),y(jl,e),y(xl,e),y(Bl,e),y(Zl,e),y(Al,e),y(_l,e),y(Rl,e),y(Vl,e),y(El,e),y(Sl,e),y(Dl,e),y(ts,e),y(is,e),y(os,e),y(Ms,e),y(Js,e),y(js,e),y(fs,e),y(xs,e),y(ks,e),y(Zs,e),y($s,e),y(Vs,e),y(Ws,e),y(Ls,e),y(Ks,e),y(li,e),y(ai,e),y(ci,e),y(yi,e),y(hi,e),y(fi,e),y(gi,e),y(vi,e),y(Ai,e),y(Ri,e),y(Ei,e),y(Xi,e),y(Di,e),y(Oi,e),y(ln,e),y(pn,e),y(Mn,e),y(hn,e),y(fn,e),y(Cn,e)}}}const hJ='{"title":"pipelines","local":"pipelines","sections":[{"title":"pipelines.Pipeline ⇐ <code> Callable </code>","local":"pipelinespipeline--code-callable-code","sections":[{"title":"new Pipeline(options)","local":"new-pipelineoptions","sections":[],"depth":3},{"title":"pipeline.dispose() ⇒ <code> Promise. < void > </code>","local":"pipelinedispose--code-promise--void--code","sections":[],"depth":3},{"title":"pipeline._call(texts, ...args) ⇒ <code> Promise. < any > </code>","local":"pipelinecalltexts-args--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.TextClassificationPipeline","local":"pipelinestextclassificationpipeline","sections":[{"title":"textClassificationPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>","local":"textclassificationpipelinecalltexts-options--code-promise--array--object--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.TokenClassificationPipeline","local":"pipelinestokenclassificationpipeline","sections":[{"title":"tokenClassificationPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>","local":"tokenclassificationpipelinecalltexts-options--code-promise--array--object--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.QuestionAnsweringPipeline","local":"pipelinesquestionansweringpipeline","sections":[{"title":"questionAnsweringPipeline._call(question, context, options) ⇒ <code> QuestionAnsweringReturnType </code>","local":"questionansweringpipelinecallquestion-context-options--code-questionansweringreturntype-code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.FillMaskPipeline","local":"pipelinesfillmaskpipeline","sections":[{"title":"fillMaskPipeline._call(texts, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>","local":"fillmaskpipelinecalltexts-options--code-promise--array--object--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.Text2TextGenerationPipeline","local":"pipelinestext2textgenerationpipeline","sections":[{"title":"text2TextGenerationPipeline._call(texts, [options]) ⇒ <code> Promise. < any > </code>","local":"text2textgenerationpipelinecalltexts-options--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.SummarizationPipeline","local":"pipelinessummarizationpipeline","sections":[],"depth":2},{"title":"pipelines.TranslationPipeline","local":"pipelinestranslationpipeline","sections":[],"depth":2},{"title":"pipelines.TextGenerationPipeline","local":"pipelinestextgenerationpipeline","sections":[{"title":"textGenerationPipeline._call(texts, [generate_kwargs]) ⇒ <code> Promise. < any > </code>","local":"textgenerationpipelinecalltexts-generatekwargs--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ZeroShotClassificationPipeline","local":"pipelineszeroshotclassificationpipeline","sections":[{"title":"new ZeroShotClassificationPipeline(options)","local":"new-zeroshotclassificationpipelineoptions","sections":[],"depth":3},{"title":"zeroShotClassificationPipeline._call(texts, candidate_labels, options) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>","local":"zeroshotclassificationpipelinecalltexts-candidatelabels-options--code-promise--objectarray--object----code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.FeatureExtractionPipeline","local":"pipelinesfeatureextractionpipeline","sections":[{"title":"featureExtractionPipeline._call(texts, options) ⇒","local":"featureextractionpipelinecalltexts-options-","sections":[],"depth":3}],"depth":2},{"title":"pipelines.AudioClassificationPipeline","local":"pipelinesaudioclassificationpipeline","sections":[{"title":"new AudioClassificationPipeline(options)","local":"new-audioclassificationpipelineoptions","sections":[],"depth":3},{"title":"audioClassificationPipeline._call(audio, options) ⇒ <code> Promise. < (Array < Object > |Object) > </code>","local":"audioclassificationpipelinecallaudio-options--code-promise--array--object--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.AutomaticSpeechRecognitionPipeline","local":"pipelinesautomaticspeechrecognitionpipeline","sections":[{"title":"new AutomaticSpeechRecognitionPipeline(options)","local":"new-automaticspeechrecognitionpipelineoptions","sections":[],"depth":3},{"title":"automaticSpeechRecognitionPipeline._call(audio, [kwargs]) ⇒ <code> Promise. < Object > </code>","local":"automaticspeechrecognitionpipelinecallaudio-kwargs--code-promise--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ImageToTextPipeline","local":"pipelinesimagetotextpipeline","sections":[{"title":"new ImageToTextPipeline(options)","local":"new-imagetotextpipelineoptions","sections":[],"depth":3},{"title":"imageToTextPipeline._call(images, [generate_kwargs]) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>","local":"imagetotextpipelinecallimages-generatekwargs--code-promise--objectarray--object----code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ImageClassificationPipeline","local":"pipelinesimageclassificationpipeline","sections":[{"title":"new ImageClassificationPipeline(options)","local":"new-imageclassificationpipelineoptions","sections":[],"depth":3},{"title":"imageClassificationPipeline._call(images, options) ⇒ <code> Promise. < any > </code>","local":"imageclassificationpipelinecallimages-options--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ImageSegmentationPipeline","local":"pipelinesimagesegmentationpipeline","sections":[{"title":"new ImageSegmentationPipeline(options)","local":"new-imagesegmentationpipelineoptions","sections":[],"depth":3},{"title":"imageSegmentationPipeline._call(images, options) ⇒ <code> Promise. < Array > </code>","local":"imagesegmentationpipelinecallimages-options--code-promise--array--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ZeroShotImageClassificationPipeline","local":"pipelineszeroshotimageclassificationpipeline","sections":[{"title":"new ZeroShotImageClassificationPipeline(options)","local":"new-zeroshotimageclassificationpipelineoptions","sections":[],"depth":3},{"title":"zeroShotImageClassificationPipeline._call(images, candidate_labels, options) ⇒ <code> Promise. < any > </code>","local":"zeroshotimageclassificationpipelinecallimages-candidatelabels-options--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.ObjectDetectionPipeline","local":"pipelinesobjectdetectionpipeline","sections":[{"title":"new ObjectDetectionPipeline(options)","local":"new-objectdetectionpipelineoptions","sections":[],"depth":3},{"title":"objectDetectionPipeline._call(images, options)","local":"objectdetectionpipelinecallimages-options","sections":[],"depth":3}],"depth":2},{"title":"pipelines.DocumentQuestionAnsweringPipeline","local":"pipelinesdocumentquestionansweringpipeline","sections":[{"title":"new DocumentQuestionAnsweringPipeline(options)","local":"new-documentquestionansweringpipelineoptions","sections":[],"depth":3},{"title":"documentQuestionAnsweringPipeline._call(image, question, [generate_kwargs]) ⇒ <code> Promise. < (Object|Array < Object > ) > </code>","local":"documentquestionansweringpipelinecallimage-question-generatekwargs--code-promise--objectarray--object----code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.TextToAudioPipeline","local":"pipelinestexttoaudiopipeline","sections":[{"title":"new TextToAudioPipeline(options)","local":"new-texttoaudiopipelineoptions","sections":[],"depth":3},{"title":"textToAudioPipeline._call(text_inputs, options) ⇒ <code> Promise. < Object > </code>","local":"texttoaudiopipelinecalltextinputs-options--code-promise--object--code","sections":[],"depth":3}],"depth":2},{"title":"pipelines.pipeline(task, [model], [options]) ⇒ <code> Promise. < Pipeline > </code>","local":"pipelinespipelinetask-model-options--code-promise--pipeline--code","sections":[],"depth":2},{"title":"pipelines~QuestionAnsweringResult : <code> object </code>","local":"pipelinesquestionansweringresult--code-object-code","sections":[],"depth":2},{"title":"pipelines~QuestionAnsweringReturnType : <code> Promise. < (QuestionAnsweringResult|Array < QuestionAnsweringResult > ) > </code>","local":"pipelinesquestionansweringreturntype--code-promise--questionansweringresultarray--questionansweringresult----code","sections":[],"depth":2},{"title":"pipelines~ChunkCallback : <code> function </code>","local":"pipelineschunkcallback--code-function-code","sections":[],"depth":2}],"depth":1}';function wJ(Hm){return MJ(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xJ extends mJ{constructor(w){super(),TJ(this,w,wJ,JJ,cJ,{})}}export{xJ as component};
