import{s as Ie,n as Be,o as Se}from"../chunks/scheduler.182ea377.js";import{S as Re,i as Ye,g as i,s as n,r as p,A as ze,h as o,f as s,c as a,j as Ce,u as r,x as m,k as Ze,y as Ee,a as l,v as d,d as c,t as u,w as f}from"../chunks/index.abf12888.js";import{C as N}from"../chunks/CodeBlock.57fe6e13.js";import{D as Ne}from"../chunks/DocNotebookDropdown.5fa27ace.js";import{H as Me,E as Fe}from"../chunks/EditOnGithub.9b8e78e4.js";function Qe(Je){let h,F,z,Q,b,D,M,L,Z,we='<a href="https://huggingface.co/papers/2311.15127" rel="nofollow">Stable Video Diffusion (SVD)</a> is a powerful image-to-video generation model that can generate 2-4 second high resolution (576x1024) videos conditioned on an input image.',H,J,ye="This guide will show you how to use SVD to generate short videos from images.",q,w,ve="Before you begin, make sure you have the following libraries installed:",P,y,K,v,Te='The are two variants of this model, <a href="https://huggingface.co/stabilityai/stable-video-diffusion-img2vid" rel="nofollow">SVD</a> and <a href="https://huggingface.co/stabilityai/stable-video-diffusion-img2vid-xt" rel="nofollow">SVD-XT</a>. The SVD checkpoint is trained to generate 14 frames and the SVD-XT checkpoint is further finetuned to generate 25 frames.',A,T,ke="You’ll use the SVD-XT checkpoint for this guide.",O,k,ee,g,Ue='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/rocket.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">&quot;source image of a rocket&quot;</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/output_rocket.gif"/> <figcaption class="mt-2 text-center text-sm text-gray-500">&quot;generated video from source image&quot;</figcaption></div>',te,U,se,W,We='You can gain a 20-25% speedup at the expense of slightly increased memory by <a href="../optimization/torch2.0#torchcompile">compiling</a> the UNet.',le,_,ne,j,ae,$,_e="Video generation is very memory intensive because you’re essentially generating <code>num_frames</code> all at once, similar to text-to-image generation with a high batch size. To reduce the memory requirement, there are multiple options that trade-off inference speed for lower memory requirement:",ie,V,je="<li>enable model offloading: each component of the pipeline is offloaded to the CPU once it’s not needed anymore.</li> <li>enable feed-forward chunking: the feed-forward layer runs in a loop instead of running a single feed-forward with a huge batch size.</li> <li>reduce <code>decode_chunk_size</code>: the VAE decodes frames in chunks instead of decoding them all together. Setting <code>decode_chunk_size=1</code> decodes one frame at a time and uses the least amount of memory (we recommend adjusting this value based on your GPU memory) but the video might have some flickering.</li>",oe,X,me,G,$e="Using all these tricks together should lower the memory requirement to less than 8GB VRAM.",pe,x,re,C,Ve="Stable Diffusion Video also accepts micro-conditioning, in addition to the conditioning image, which allows more control over the generated video:",de,I,Xe="<li><code>fps</code>: the frames per second of the generated video.</li> <li><code>motion_bucket_id</code>: the motion bucket id to use for the generated video. This can be used to control the motion of the generated video. Increasing the motion bucket id increases the motion of the generated video.</li> <li><code>noise_aug_strength</code>: the amount of noise added to the conditioning image. The higher the values the less the video resembles the conditioning image. Increasing this value also increases the motion of the generated video.</li>",ce,B,Ge="For example, to generate a video with more motion, use the <code>motion_bucket_id</code> and <code>noise_aug_strength</code> micro-conditioning parameters:",ue,S,fe,R,xe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/output_rocket_with_conditions.gif"/>',he,Y,ge,E,be;return b=new Me({props:{title:"Stable Video Diffusion",local:"stable-video-diffusion",headingTag:"h1"}}),M=new Ne({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/svd.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/svd.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/svd.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/svd.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/svd.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/svd.ipynb"}]}}),y=new N({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMC1VJTIwZGlmZnVzZXJzJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZQ==",highlighted:"!pip install -q -U diffusers transformers accelerate",wrap:!1}}),k=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlVmlkZW9EaWZmdXNpb25QaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZVZpZGVvRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLXZpZGVvLWRpZmZ1c2lvbi1pbWcydmlkLXh0JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMEEpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQSUyMyUyMExvYWQlMjB0aGUlMjBjb25kaXRpb25pbmclMjBpbWFnZSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZzdmQlMkZyb2NrZXQucG5nJTIyKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2UucmVzaXplKCgxMDI0JTJDJTIwNTc2KSklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCg0MiklMEFmcmFtZXMlMjAlM0QlMjBwaXBlKGltYWdlJTJDJTIwZGVjb2RlX2NodW5rX3NpemUlM0Q4JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5mcmFtZXMlNUIwJTVEJTBBJTBBZXhwb3J0X3RvX3ZpZGVvKGZyYW1lcyUyQyUyMCUyMmdlbmVyYXRlZC5tcDQlMjIlMkMlMjBmcHMlM0Q3KQ==",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableVideoDiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, export_to_video

pipe = StableVideoDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-video-diffusion-img2vid-xt&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># Load the conditioning image</span>
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/rocket.png&quot;</span>)
image = image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">576</span>))

generator = torch.manual_seed(<span class="hljs-number">42</span>)
frames = pipe(image, decode_chunk_size=<span class="hljs-number">8</span>, generator=generator).frames[<span class="hljs-number">0</span>]

export_to_video(frames, <span class="hljs-string">&quot;generated.mp4&quot;</span>, fps=<span class="hljs-number">7</span>)`,wrap:!1}}),U=new Me({props:{title:"torch.compile",local:"torchcompile",headingTag:"h2"}}),_=new N({props:{code:"LSUyMHBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMkIlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTJCJTIwcGlwZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnVuZXQlMkMlMjBtb2RlJTNEJTIycmVkdWNlLW92ZXJoZWFkJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSk=",highlighted:`<span class="hljs-deletion">- pipe.enable_model_cpu_offload()</span>
<span class="hljs-addition">+ pipe.to(&quot;cuda&quot;)</span>
<span class="hljs-addition">+ pipe.unet = torch.compile(pipe.unet, mode=&quot;reduce-overhead&quot;, fullgraph=True)</span>`,wrap:!1}}),j=new Me({props:{title:"Reduce memory usage",local:"reduce-memory-usage",headingTag:"h2"}}),X=new N({props:{code:"LSUyMHBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEEtJTIwZnJhbWVzJTIwJTNEJTIwcGlwZShpbWFnZSUyQyUyMGRlY29kZV9jaHVua19zaXplJTNEOCUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvcikuZnJhbWVzJTVCMCU1RCUwQSUyQiUyMHBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMkIlMjBwaXBlLnVuZXQuZW5hYmxlX2ZvcndhcmRfY2h1bmtpbmcoKSUwQSUyQiUyMGZyYW1lcyUyMCUzRCUyMHBpcGUoaW1hZ2UlMkMlMjBkZWNvZGVfY2h1bmtfc2l6ZSUzRDIlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1fZnJhbWVzJTNEMjUpLmZyYW1lcyU1QjAlNUQ=",highlighted:`<span class="hljs-deletion">- pipe.enable_model_cpu_offload()</span>
<span class="hljs-deletion">- frames = pipe(image, decode_chunk_size=8, generator=generator).frames[0]</span>
<span class="hljs-addition">+ pipe.enable_model_cpu_offload()</span>
<span class="hljs-addition">+ pipe.unet.enable_forward_chunking()</span>
<span class="hljs-addition">+ frames = pipe(image, decode_chunk_size=2, generator=generator, num_frames=25).frames[0]</span>`,wrap:!1}}),x=new Me({props:{title:"Micro-conditioning",local:"micro-conditioning",headingTag:"h2"}}),S=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlVmlkZW9EaWZmdXNpb25QaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZVZpZGVvRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLXZpZGVvLWRpZmZ1c2lvbi1pbWcydmlkLXh0JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMEEpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQSUyMyUyMExvYWQlMjB0aGUlMjBjb25kaXRpb25pbmclMjBpbWFnZSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZzdmQlMkZyb2NrZXQucG5nJTIyKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2UucmVzaXplKCgxMDI0JTJDJTIwNTc2KSklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCg0MiklMEFmcmFtZXMlMjAlM0QlMjBwaXBlKGltYWdlJTJDJTIwZGVjb2RlX2NodW5rX3NpemUlM0Q4JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwbW90aW9uX2J1Y2tldF9pZCUzRDE4MCUyQyUyMG5vaXNlX2F1Z19zdHJlbmd0aCUzRDAuMSkuZnJhbWVzJTVCMCU1RCUwQWV4cG9ydF90b192aWRlbyhmcmFtZXMlMkMlMjAlMjJnZW5lcmF0ZWQubXA0JTIyJTJDJTIwZnBzJTNENyk=",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableVideoDiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, export_to_video

pipe = StableVideoDiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;stabilityai/stable-video-diffusion-img2vid-xt&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
)
pipe.enable_model_cpu_offload()

<span class="hljs-comment"># Load the conditioning image</span>
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/rocket.png&quot;</span>)
image = image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">576</span>))

generator = torch.manual_seed(<span class="hljs-number">42</span>)
frames = pipe(image, decode_chunk_size=<span class="hljs-number">8</span>, generator=generator, motion_bucket_id=<span class="hljs-number">180</span>, noise_aug_strength=<span class="hljs-number">0.1</span>).frames[<span class="hljs-number">0</span>]
export_to_video(frames, <span class="hljs-string">&quot;generated.mp4&quot;</span>, fps=<span class="hljs-number">7</span>)`,wrap:!1}}),Y=new Fe({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/svd.md"}}),{c(){h=i("meta"),F=n(),z=i("p"),Q=n(),p(b.$$.fragment),D=n(),p(M.$$.fragment),L=n(),Z=i("p"),Z.innerHTML=we,H=n(),J=i("p"),J.textContent=ye,q=n(),w=i("p"),w.textContent=ve,P=n(),p(y.$$.fragment),K=n(),v=i("p"),v.innerHTML=Te,A=n(),T=i("p"),T.textContent=ke,O=n(),p(k.$$.fragment),ee=n(),g=i("div"),g.innerHTML=Ue,te=n(),p(U.$$.fragment),se=n(),W=i("p"),W.innerHTML=We,le=n(),p(_.$$.fragment),ne=n(),p(j.$$.fragment),ae=n(),$=i("p"),$.innerHTML=_e,ie=n(),V=i("ul"),V.innerHTML=je,oe=n(),p(X.$$.fragment),me=n(),G=i("p"),G.textContent=$e,pe=n(),p(x.$$.fragment),re=n(),C=i("p"),C.textContent=Ve,de=n(),I=i("ul"),I.innerHTML=Xe,ce=n(),B=i("p"),B.innerHTML=Ge,ue=n(),p(S.$$.fragment),fe=n(),R=i("p"),R.innerHTML=xe,he=n(),p(Y.$$.fragment),ge=n(),E=i("p"),this.h()},l(e){const t=ze("svelte-u9bgzb",document.head);h=o(t,"META",{name:!0,content:!0}),t.forEach(s),F=a(e),z=o(e,"P",{}),Ce(z).forEach(s),Q=a(e),r(b.$$.fragment,e),D=a(e),r(M.$$.fragment,e),L=a(e),Z=o(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-6831zo"&&(Z.innerHTML=we),H=a(e),J=o(e,"P",{"data-svelte-h":!0}),m(J)!=="svelte-9hcj9z"&&(J.textContent=ye),q=a(e),w=o(e,"P",{"data-svelte-h":!0}),m(w)!=="svelte-cwruts"&&(w.textContent=ve),P=a(e),r(y.$$.fragment,e),K=a(e),v=o(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-iibvlr"&&(v.innerHTML=Te),A=a(e),T=o(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-u5kxxd"&&(T.textContent=ke),O=a(e),r(k.$$.fragment,e),ee=a(e),g=o(e,"DIV",{class:!0,"data-svelte-h":!0}),m(g)!=="svelte-25rdw"&&(g.innerHTML=Ue),te=a(e),r(U.$$.fragment,e),se=a(e),W=o(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1hgzo8e"&&(W.innerHTML=We),le=a(e),r(_.$$.fragment,e),ne=a(e),r(j.$$.fragment,e),ae=a(e),$=o(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-1aihuum"&&($.innerHTML=_e),ie=a(e),V=o(e,"UL",{"data-svelte-h":!0}),m(V)!=="svelte-carvgs"&&(V.innerHTML=je),oe=a(e),r(X.$$.fragment,e),me=a(e),G=o(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1dz5kg5"&&(G.textContent=$e),pe=a(e),r(x.$$.fragment,e),re=a(e),C=o(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-crombe"&&(C.textContent=Ve),de=a(e),I=o(e,"UL",{"data-svelte-h":!0}),m(I)!=="svelte-hs8jkz"&&(I.innerHTML=Xe),ce=a(e),B=o(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-3jffic"&&(B.innerHTML=Ge),ue=a(e),r(S.$$.fragment,e),fe=a(e),R=o(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-19qaph4"&&(R.innerHTML=xe),he=a(e),r(Y.$$.fragment,e),ge=a(e),E=o(e,"P",{}),Ce(E).forEach(s),this.h()},h(){Ze(h,"name","hf:doc:metadata"),Ze(h,"content",De),Ze(g,"class","flex gap-4")},m(e,t){Ee(document.head,h),l(e,F,t),l(e,z,t),l(e,Q,t),d(b,e,t),l(e,D,t),d(M,e,t),l(e,L,t),l(e,Z,t),l(e,H,t),l(e,J,t),l(e,q,t),l(e,w,t),l(e,P,t),d(y,e,t),l(e,K,t),l(e,v,t),l(e,A,t),l(e,T,t),l(e,O,t),d(k,e,t),l(e,ee,t),l(e,g,t),l(e,te,t),d(U,e,t),l(e,se,t),l(e,W,t),l(e,le,t),d(_,e,t),l(e,ne,t),d(j,e,t),l(e,ae,t),l(e,$,t),l(e,ie,t),l(e,V,t),l(e,oe,t),d(X,e,t),l(e,me,t),l(e,G,t),l(e,pe,t),d(x,e,t),l(e,re,t),l(e,C,t),l(e,de,t),l(e,I,t),l(e,ce,t),l(e,B,t),l(e,ue,t),d(S,e,t),l(e,fe,t),l(e,R,t),l(e,he,t),d(Y,e,t),l(e,ge,t),l(e,E,t),be=!0},p:Be,i(e){be||(c(b.$$.fragment,e),c(M.$$.fragment,e),c(y.$$.fragment,e),c(k.$$.fragment,e),c(U.$$.fragment,e),c(_.$$.fragment,e),c(j.$$.fragment,e),c(X.$$.fragment,e),c(x.$$.fragment,e),c(S.$$.fragment,e),c(Y.$$.fragment,e),be=!0)},o(e){u(b.$$.fragment,e),u(M.$$.fragment,e),u(y.$$.fragment,e),u(k.$$.fragment,e),u(U.$$.fragment,e),u(_.$$.fragment,e),u(j.$$.fragment,e),u(X.$$.fragment,e),u(x.$$.fragment,e),u(S.$$.fragment,e),u(Y.$$.fragment,e),be=!1},d(e){e&&(s(F),s(z),s(Q),s(D),s(L),s(Z),s(H),s(J),s(q),s(w),s(P),s(K),s(v),s(A),s(T),s(O),s(ee),s(g),s(te),s(se),s(W),s(le),s(ne),s(ae),s($),s(ie),s(V),s(oe),s(me),s(G),s(pe),s(re),s(C),s(de),s(I),s(ce),s(B),s(ue),s(fe),s(R),s(he),s(ge),s(E)),s(h),f(b,e),f(M,e),f(y,e),f(k,e),f(U,e),f(_,e),f(j,e),f(X,e),f(x,e),f(S,e),f(Y,e)}}}const De='{"title":"Stable Video Diffusion","local":"stable-video-diffusion","sections":[{"title":"torch.compile","local":"torchcompile","sections":[],"depth":2},{"title":"Reduce memory usage","local":"reduce-memory-usage","sections":[],"depth":2},{"title":"Micro-conditioning","local":"micro-conditioning","sections":[],"depth":2}],"depth":1}';function Le(Je){return Se(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Oe extends Re{constructor(h){super(),Ye(this,h,Le,Qe,Ie,{})}}export{Oe as component};
