import{s as Al,o as zl,n as Sl}from"../chunks/scheduler.9bc65507.js";import{S as Fl,i as Pl,g as l,s as p,u as m,A as Ql,h as n,f as s,c as i,j as h,v as u,y as r,k as o,o as c,a,w as f,d,t as g,x as y,m as Dl,n as Kl}from"../chunks/index.78c82d43.js";import{T as Ja}from"../chunks/Tip.87d55b76.js";import{I as J}from"../chunks/IconCopyLink.bedaa44d.js";import{C as v}from"../chunks/CodeBlock.48618ec2.js";function Ol(E){let j,x='Take a look at the <a href="/docs/transformers/v4.33.3/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> documentation for a complete list of supported tasks and available parameters.';return{c(){j=l("p"),j.innerHTML=x},l(w){j=n(w,"P",{"data-svelte-h":!0}),r(j)!=="svelte-hrm15y"&&(j.innerHTML=x)},m(w,b){a(w,j,b)},p:Sl,d(w){w&&s(j)}}}function en(E){let j;return{c(){j=Dl(`Creating an inference engine is a complex topic which deserves it's own
page.`)},l(x){j=Kl(x,`Creating an inference engine is a complex topic which deserves it's own
page.`)},m(x,w){a(x,j,w)},d(x){x&&s(j)}}}function sn(E){let j,x='To run the example above you need to have <a href="https://pypi.org/project/pytesseract/" rel="nofollow"><code>pytesseract</code></a> installed in addition to 🤗 Transformers:',w,b,T;return b=new v({props:{code:"c3VkbyUyMGFwdCUyMGluc3RhbGwlMjAteSUyMHRlc3NlcmFjdC1vY3IlMEFwaXAlMjBpbnN0YWxsJTIwcHl0ZXNzZXJhY3Q=",highlighted:`sudo apt install -y tesseract-ocr
pip install pytesseract`}}),{c(){j=l("p"),j.innerHTML=x,w=p(),m(b.$$.fragment)},l(M){j=n(M,"P",{"data-svelte-h":!0}),r(j)!=="svelte-z3k1tk"&&(j.innerHTML=x),w=i(M),u(b.$$.fragment,M)},m(M,$){a(M,j,$),a(M,w,$),f(b,M,$),T=!0},p:Sl,i(M){T||(d(b.$$.fragment,M),T=!0)},o(M){g(b.$$.fragment,M),T=!1},d(M){M&&(s(j),s(w)),y(b,M)}}}function tn(E){let j,x,w,b,T,M,$,ee,ua,us,$a="Pipelines for inference",Xs,se,Ua='The <a href="/docs/transformers/v4.33.3/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> makes it simple to use any model from the <a href="https://huggingface.co/models" rel="nofollow">Hub</a> for inference on any language, computer vision, speech, and multimodal tasks. Even if you don’t have experience with a specific modality or aren’t familiar with the underlying code behind the models, you can still use them for inference with the <a href="/docs/transformers/v4.33.3/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>! This tutorial will teach you to:',Vs,te,ka='<li>Use a <a href="/docs/transformers/v4.33.3/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> for inference.</li> <li>Use a specific tokenizer or model.</li> <li>Use a <a href="/docs/transformers/v4.33.3/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> for audio, vision, and multimodal tasks.</li>',Rs,X,Ys,U,V,Js,ae,fa,fs,Za="Pipeline usage",qs,le,Ia='While each task has an associated <a href="/docs/transformers/v4.33.3/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>, it is simpler to use the general <a href="/docs/transformers/v4.33.3/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> abstraction which contains all the task-specific pipelines. The <a href="/docs/transformers/v4.33.3/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> automatically loads a default model and a preprocessing class capable of inference for your task.',Ls,ne,Ga='<li>Start by creating a <a href="/docs/transformers/v4.33.3/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> and specify an inference task:</li>',Ss,pe,As,R,Ca='<li>Pass your input text to the <a href="/docs/transformers/v4.33.3/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>:</li>',zs,ie,Fs,re,_a=`Not the result you had in mind? Check out some of the <a href="https://huggingface.co/models?pipeline_tag=automatic-speech-recognition&amp;sort=downloads" rel="nofollow">most downloaded automatic speech recognition models</a> on the Hub to see if you can get a better transcription.
Let’s try <a href="https://huggingface.co/openai/whisper-large" rel="nofollow">openai/whisper-large</a>:`,Ps,oe,Qs,ce,Wa=`Now this result looks more accurate!
We really encourage you to check out the Hub for models in different languages, models specialized in your field, and more.
You can check out and compare model results directly from your browser on the Hub to see if it fits or
handles corner cases better than other ones.
And if you don’t find a model for your use case, you can always start <a href="training">training</a> your own!`,Ds,he,Ba="If you have several inputs, you can pass your input as a list:",Ks,me,Os,ue,Na="If you want to iterate over a whole dataset, or want to use it for inference in a webserver, check out dedicated parts",et,fe,Ha='<a href="#using-pipelines-on-a-dataset">Using pipelines on a dataset</a>',st,de,Ea='<a href="./pipeline_webserver">Using pipelines for a webserver</a>',tt,k,Y,$s,ge,da,ds,Xa="Parameters",at,ye,Va=`<a href="/docs/transformers/v4.33.3/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> supports many parameters; some are task specific, and some are general to all pipelines.
In general you can specify parameters anywhere you want:`,lt,je,nt,Me,Ra="Let’s check out 3 important ones:",pt,Z,q,Us,we,ga,gs,Ya="Device",it,ve,qa=`If you use <code>device=n</code>, the pipeline automatically puts the model on the specified device.
This will work regardless of whether you are using PyTorch or Tensorflow.`,rt,xe,ot,be,La='If the model is too large for a single GPU, you can set <code>device_map=&quot;auto&quot;</code> to allow 🤗 <a href="https://huggingface.co/docs/accelerate" rel="nofollow">Accelerate</a> to automatically determine how to load and store the model weights.',ct,Te,ht,Je,Sa="Note that if  <code>device_map=&quot;auto&quot;</code> is passed, there is no need to add the argument <code>device=device</code> when instantiating your <code>pipeline</code> as you may encounter some unexpected behavior!",mt,I,L,ks,$e,ya,ys,Aa="Batch size",ut,Ue,za='By default, pipelines will not batch inference for reasons explained in detail <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#pipeline-batching" rel="nofollow">here</a>. The reason is that batching is not necessarily faster, and can actually be quite slower in some cases.',ft,ke,Fa="But if it works in your use case, you can use:",dt,Ze,gt,Ie,Pa=`This runs the pipeline on the 10 provided audio files, but it will pass them in batches of 2
to the model (which is on a GPU, where batching is more likely to help) without requiring any further code from you.
The output should always match what you would have received without batching. It is only meant as a way to help you get more speed out of a pipeline.`,yt,Ge,Qa='Pipelines can also alleviate some of the complexities of batching because, for some pipelines, a single item (like a long audio file) needs to be chunked into multiple parts to be processed by a model. The pipeline performs this <a href="./main_classes/pipelines#pipeline-chunk-batching"><em>chunk batching</em></a> for you.',jt,G,S,Zs,Ce,ja,js,Da="Task specific parameters",Mt,_e,Ka=`All tasks provide task specific parameters which allow for additional flexibility and options to help you get your job done.
For instance, the <a href="/docs/transformers/v4.33.3/en/main_classes/pipelines#transformers.AutomaticSpeechRecognitionPipeline.__call__">transformers.AutomaticSpeechRecognitionPipeline.<strong>call</strong>()</a> method has a <code>return_timestamps</code> parameter which sounds promising for subtitling videos:`,wt,We,vt,Be,Oa=`As you can see, the model inferred the text and also outputted <strong>when</strong> the various words were pronounced
in the sentence.`,xt,Ne,el=`There are many parameters available for each task, so check out each task’s API reference to see what you can tinker with!
For instance, the <a href="/docs/transformers/v4.33.3/en/main_classes/pipelines#transformers.AutomaticSpeechRecognitionPipeline">AutomaticSpeechRecognitionPipeline</a> has a <code>chunk_length_s</code> parameter which is helpful for working on really long audio files (for example, subtitling entire movies or hour-long videos) that a model typically cannot handle on its own.`,bt,He,sl='If you can’t find a parameter that would really help you out, feel free to <a href="https://github.com/huggingface/transformers/issues/new?assignees=&amp;labels=feature&amp;template=feature-request.yml" rel="nofollow">request it</a>!',Tt,C,A,Is,Ee,Ma,Ms,tl="Using pipelines on a dataset",Jt,Xe,al="The pipeline can also run inference on a large dataset. The easiest way we recommend doing this is by using an iterator:",$t,Ve,Ut,Re,ll=`The iterator <code>data()</code> yields each result, and the pipeline automatically
recognizes the input is iterable and will start fetching the data while
it continues to process it on the GPU (this uses <a href="https://pytorch.org/docs/stable/data.html#torch.utils.data.DataLoader" rel="nofollow">DataLoader</a> under the hood).
This is important because you don’t have to allocate memory for the whole dataset
and you can feed the GPU as fast as possible.`,kt,Ye,nl="Since batching could speed things up, it may be useful to try tuning the <code>batch_size</code> parameter here.",Zt,qe,pl='The simplest way to iterate over a dataset is to just load one from 🤗 <a href="https://github.com/huggingface/datasets/" rel="nofollow">Datasets</a>:',It,Le,Gt,_,z,Gs,Se,wa,ws,il="Using pipelines for a webserver",Ct,F,_t,Ae,rl='<a href="./pipeline_webserver">Link</a>',Wt,W,P,Cs,ze,va,vs,ol="Vision pipeline",Bt,Fe,cl='Using a <a href="/docs/transformers/v4.33.3/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> for vision tasks is practically identical.',Nt,Pe,hl="Specify your task and pass your image to the classifier. The image can be a link, a local path or a base64-encoded image. For example, what species of cat is shown below?",Ht,Qe,ml='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg" alt="pipeline-cat-chonk"/>',Et,De,Xt,B,Q,_s,Ke,xa,xs,ul="Text pipeline",Vt,Oe,fl='Using a <a href="/docs/transformers/v4.33.3/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> for NLP tasks is practically identical.',Rt,es,Yt,N,D,Ws,ss,ba,bs,dl="Multimodal pipeline",qt,ts,gl='The <a href="/docs/transformers/v4.33.3/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> supports more than one modality. For example, a visual question answering (VQA) task combines text and image. Feel free to use any image link you like and a question you want to ask about the image. The image can be a URL or a local path to the image.',Lt,as,yl='For example, if you use this <a href="https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png" rel="nofollow">invoice image</a>:',St,ls,At,K,zt,H,O,Bs,ns,Ta,Ts,jl="Using <code>pipeline</code> on large models with 🤗 <code>accelerate</code>:",Ft,ps,Ml="You can easily run <code>pipeline</code> on large models using 🤗 <code>accelerate</code>! First make sure you have installed <code>accelerate</code> with <code>pip install accelerate</code>.",Pt,is,wl="First load your model using <code>device_map=&quot;auto&quot;</code>! We will use <code>facebook/opt-1.3b</code> for our example.",Qt,rs,Dt,os,vl="You can also pass 8-bit loaded models if you install <code>bitsandbytes</code> and add the argument <code>load_in_8bit=True</code>",Kt,cs,Ot,hs,xl="Note that you can replace the checkpoint with any of the Hugging Face model that supports large model loading such as BLOOM!",ea,Ns,sa;return ee=new J({}),X=new Ja({props:{$$slots:{default:[Ol]},$$scope:{ctx:E}}}),ae=new J({}),pe=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(task=<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>)`}}),ie=new v({props:{code:"Z2VuZXJhdG9yKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRk5hcnNpbCUyRmFzcl9kdW1teSUyRnJlc29sdmUlMkZtYWluJTJGbWxrLmZsYWMlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;I HAVE A DREAM BUT ONE DAY THIS NATION WILL RISE UP LIVE UP THE TRUE MEANING OF ITS TREES&#x27;</span>}`}}),oe=new v({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJvcGVuYWklMkZ3aGlzcGVyLWxhcmdlJTIyKSUwQWdlbmVyYXRvciglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1say5mbGFjJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generator(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; I have a dream that one day this nation will rise up and live out the true meaning of its creed.&#x27;</span>}`}}),me=new v({props:{code:"Z2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRk5hcnNpbCUyRmFzcl9kdW1teSUyRnJlc29sdmUlMkZtYWluJTJGbWxrLmZsYWMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRjEuZmxhYyUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSk=",highlighted:`generator(
    [
        <span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>,
        <span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/1.flac&quot;</span>,
    ]
)`}}),ge=new J({}),je=new v({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJvcGVuYWklMkZ3aGlzcGVyLWxhcmdlJTIyJTJDJTIwbXlfcGFyYW1ldGVyJTNEMSklMEFvdXQlMjAlM0QlMjBnZW5lcmF0b3IoLi4uKSUyMCUyMCUyMyUyMFRoaXMlMjB3aWxsJTIwdXNlJTIwJTYwbXlfcGFyYW1ldGVyJTNEMSU2MC4lMEFvdXQlMjAlM0QlMjBnZW5lcmF0b3IoLi4uJTJDJTIwbXlfcGFyYW1ldGVyJTNEMiklMjAlMjAlMjMlMjBUaGlzJTIwd2lsbCUyMG92ZXJyaWRlJTIwYW5kJTIwdXNlJTIwJTYwbXlfcGFyYW1ldGVyJTNEMiU2MC4lMEFvdXQlMjAlM0QlMjBnZW5lcmF0b3IoLi4uKSUyMCUyMCUyMyUyMFRoaXMlMjB3aWxsJTIwZ28lMjBiYWNrJTIwdG8lMjB1c2luZyUyMCU2MG15X3BhcmFtZXRlciUzRDElNjAu",highlighted:'generator = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large&quot;</span>, my_parameter=<span class="hljs-number">1</span>)\nout = generator(...)  <span class="hljs-comment"># This will use `my_parameter=1`.</span>\nout = generator(..., my_parameter=<span class="hljs-number">2</span>)  <span class="hljs-comment"># This will override and use `my_parameter=2`.</span>\nout = generator(...)  <span class="hljs-comment"># This will go back to using `my_parameter=1`.</span>'}}),we=new J({}),xe=new v({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJvcGVuYWklMkZ3aGlzcGVyLWxhcmdlJTIyJTJDJTIwZGV2aWNlJTNEMCk=",highlighted:'generator = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large&quot;</span>, device=<span class="hljs-number">0</span>)'}}),Te=new v({props:{code:"JTIzIXBpcCUyMGluc3RhbGwlMjBhY2NlbGVyYXRlJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJvcGVuYWklMkZ3aGlzcGVyLWxhcmdlJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIp",highlighted:`<span class="hljs-comment">#!pip install accelerate</span>
generator = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`}}),$e=new J({}),Ze=new v({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJvcGVuYWklMkZ3aGlzcGVyLWxhcmdlJTIyJTJDJTIwZGV2aWNlJTNEMCUyQyUyMGJhdGNoX3NpemUlM0QyKSUwQWF1ZGlvX2ZpbGVuYW1lcyUyMCUzRCUyMCU1QmYlMjJhdWRpb18lN0JpJTdELmZsYWMlMjIlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgxMCklNUQlMEF0ZXh0cyUyMCUzRCUyMGdlbmVyYXRvcihhdWRpb19maWxlbmFtZXMp",highlighted:`generator = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large&quot;</span>, device=<span class="hljs-number">0</span>, batch_size=<span class="hljs-number">2</span>)
audio_filenames = [<span class="hljs-string">f&quot;audio_<span class="hljs-subst">{i}</span>.flac&quot;</span> <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">10</span>)]
texts = generator(audio_filenames)`}}),Ce=new J({}),We=new v({props:{code:"JTIzJTIwTm90JTIwdXNpbmclMjB3aGlzcGVyJTJDJTIwYXMlMjBpdCUyMGNhbm5vdCUyMHByb3ZpZGUlMjB0aW1lc3RhbXBzLiUwQWdlbmVyYXRvciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyZmFjZWJvb2slMkZ3YXYydmVjMi1sYXJnZS05NjBoLWx2NjAtc2VsZiUyMiUyQyUyMHJldHVybl90aW1lc3RhbXBzJTNEJTIyd29yZCUyMiklMEFnZW5lcmF0b3IoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Not using whisper, as it cannot provide timestamps.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(model=<span class="hljs-string">&quot;facebook/wav2vec2-large-960h-lv60-self&quot;</span>, return_timestamps=<span class="hljs-string">&quot;word&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generator(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;I HAVE A DREAM BUT ONE DAY THIS NATION WILL RISE UP AND LIVE OUT THE TRUE MEANING OF ITS CREED&#x27;</span>, <span class="hljs-string">&#x27;chunks&#x27;</span>: [{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;I&#x27;</span>, <span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">1.22</span>, <span class="hljs-number">1.24</span>)}, {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;HAVE&#x27;</span>, <span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">1.42</span>, <span class="hljs-number">1.58</span>)}, {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;A&#x27;</span>, <span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">1.66</span>, <span class="hljs-number">1.68</span>)}, {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;DREAM&#x27;</span>, <span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">1.76</span>, <span class="hljs-number">2.14</span>)}, {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;BUT&#x27;</span>, <span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">3.68</span>, <span class="hljs-number">3.8</span>)}, {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;ONE&#x27;</span>, <span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">3.94</span>, <span class="hljs-number">4.06</span>)}, {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;DAY&#x27;</span>, <span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">4.16</span>, <span class="hljs-number">4.3</span>)}, {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;THIS&#x27;</span>, <span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">6.36</span>, <span class="hljs-number">6.54</span>)}, {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;NATION&#x27;</span>, <span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">6.68</span>, <span class="hljs-number">7.1</span>)}, {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;WILL&#x27;</span>, <span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">7.32</span>, <span class="hljs-number">7.56</span>)}, {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;RISE&#x27;</span>, <span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">7.8</span>, <span class="hljs-number">8.26</span>)}, {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;UP&#x27;</span>, <span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">8.38</span>, <span class="hljs-number">8.48</span>)}, {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;AND&#x27;</span>, <span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">10.08</span>, <span class="hljs-number">10.18</span>)}, {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;LIVE&#x27;</span>, <span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">10.26</span>, <span class="hljs-number">10.48</span>)}, {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;OUT&#x27;</span>, <span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">10.58</span>, <span class="hljs-number">10.7</span>)}, {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;THE&#x27;</span>, <span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">10.82</span>, <span class="hljs-number">10.9</span>)}, {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;TRUE&#x27;</span>, <span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">10.98</span>, <span class="hljs-number">11.18</span>)}, {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;MEANING&#x27;</span>, <span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">11.26</span>, <span class="hljs-number">11.58</span>)}, {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;OF&#x27;</span>, <span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">11.66</span>, <span class="hljs-number">11.7</span>)}, {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;ITS&#x27;</span>, <span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">11.76</span>, <span class="hljs-number">11.88</span>)}, {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;CREED&#x27;</span>, <span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">12.0</span>, <span class="hljs-number">12.38</span>)}]}`}}),Ee=new J({}),Ve=new v({props:{code:"ZGVmJTIwZGF0YSgpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMTAwMCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB5aWVsZCUyMGYlMjJNeSUyMGV4YW1wbGUlMjAlN0JpJTdEJTIyJTBBJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyZ3B0MiUyMiUyQyUyMGRldmljZSUzRDApJTBBZ2VuZXJhdGVkX2NoYXJhY3RlcnMlMjAlM0QlMjAwJTBBZm9yJTIwb3V0JTIwaW4lMjBwaXBlKGRhdGEoKSklM0ElMEElMjAlMjAlMjAlMjBnZW5lcmF0ZWRfY2hhcmFjdGVycyUyMCUyQiUzRCUyMGxlbihvdXQlNUIwJTVEJTVCJTIyZ2VuZXJhdGVkX3RleHQlMjIlNUQp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">data</span>():
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>):
        <span class="hljs-keyword">yield</span> <span class="hljs-string">f&quot;My example <span class="hljs-subst">{i}</span>&quot;</span>


pipe = pipeline(model=<span class="hljs-string">&quot;gpt2&quot;</span>, device=<span class="hljs-number">0</span>)
generated_characters = <span class="hljs-number">0</span>
<span class="hljs-keyword">for</span> out <span class="hljs-keyword">in</span> pipe(data()):
    generated_characters += <span class="hljs-built_in">len</span>(out[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>])`}}),Le=new v({props:{code:"JTIzJTIwS2V5RGF0YXNldCUyMGlzJTIwYSUyMHV0aWwlMjB0aGF0JTIwd2lsbCUyMGp1c3QlMjBvdXRwdXQlMjB0aGUlMjBpdGVtJTIwd2UncmUlMjBpbnRlcmVzdGVkJTIwaW4uJTBBZnJvbSUyMHRyYW5zZm9ybWVycy5waXBlbGluZXMucHRfdXRpbHMlMjBpbXBvcnQlMjBLZXlEYXRhc2V0JTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRnRpbnktcmFuZG9tLXdhdjJ2ZWMyJTIyJTJDJTIwZGV2aWNlJTNEMCklMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiU1QiUzQTEwJTVEJTIyKSUwQSUwQWZvciUyMG91dCUyMGluJTIwcGlwZShLZXlEYXRhc2V0KGRhdGFzZXQlMkMlMjAlMjJhdWRpbyUyMikpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQob3V0KQ==",highlighted:`<span class="hljs-comment"># KeyDataset is a util that will just output the item we&#x27;re interested in.</span>
<span class="hljs-keyword">from</span> transformers.pipelines.pt_utils <span class="hljs-keyword">import</span> KeyDataset
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

pipe = pipeline(model=<span class="hljs-string">&quot;hf-internal-testing/tiny-random-wav2vec2&quot;</span>, device=<span class="hljs-number">0</span>)
dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation[:10]&quot;</span>)

<span class="hljs-keyword">for</span> out <span class="hljs-keyword">in</span> pipe(KeyDataset(dataset, <span class="hljs-string">&quot;audio&quot;</span>)):
    <span class="hljs-built_in">print</span>(out)`}}),Se=new J({}),F=new Ja({props:{$$slots:{default:[en]},$$scope:{ctx:E}}}),ze=new J({}),De=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdmlzaW9uX2NsYXNzaWZpZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQXByZWRzJTIwJTNEJTIwdmlzaW9uX2NsYXNzaWZpZXIoJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTNEJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIlMEEpJTBBcHJlZHMlMjAlM0QlMjAlNUIlN0IlMjJzY29yZSUyMiUzQSUyMHJvdW5kKHByZWQlNUIlMjJzY29yZSUyMiU1RCUyQyUyMDQpJTJDJTIwJTIybGFiZWwlMjIlM0ElMjBwcmVkJTVCJTIybGFiZWwlMjIlNUQlN0QlMjBmb3IlMjBwcmVkJTIwaW4lMjBwcmVkcyU1RCUwQXByZWRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>vision_classifier = pipeline(model=<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = vision_classifier(
<span class="hljs-meta">... </span>    images=<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4335</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;lynx, catamount&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0348</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cougar, puma, catamount, mountain lion, painter, panther, Felis concolor&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0324</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow leopard, ounce, Panthera uncia&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0239</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Egyptian cat&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0229</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tiger cat&#x27;</span>}]`}}),Ke=new J({}),es=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBJTIzJTIwVGhpcyUyMG1vZGVsJTIwaXMlMjBhJTIwJTYwemVyby1zaG90LWNsYXNzaWZpY2F0aW9uJTYwJTIwbW9kZWwuJTBBJTIzJTIwSXQlMjB3aWxsJTIwY2xhc3NpZnklMjB0ZXh0JTJDJTIwZXhjZXB0JTIweW91JTIwYXJlJTIwZnJlZSUyMHRvJTIwY2hvb3NlJTIwYW55JTIwbGFiZWwlMjB5b3UlMjBtaWdodCUyMGltYWdpbmUlMEFjbGFzc2lmaWVyJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJmYWNlYm9vayUyRmJhcnQtbGFyZ2UtbW5saSUyMiklMEFjbGFzc2lmaWVyKCUwQSUyMCUyMCUyMCUyMCUyMkklMjBoYXZlJTIwYSUyMHByb2JsZW0lMjB3aXRoJTIwbXklMjBpcGhvbmUlMjB0aGF0JTIwbmVlZHMlMjB0byUyMGJlJTIwcmVzb2x2ZWQlMjBhc2FwISElMjIlMkMlMEElMjAlMjAlMjAlMjBjYW5kaWRhdGVfbGFiZWxzJTNEJTVCJTIydXJnZW50JTIyJTJDJTIwJTIybm90JTIwdXJnZW50JTIyJTJDJTIwJTIycGhvbmUlMjIlMkMlMjAlMjJ0YWJsZXQlMjIlMkMlMjAlMjJjb21wdXRlciUyMiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This model is a \`zero-shot-classification\` model.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># It will classify text, except you are free to choose any label you might imagine</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(model=<span class="hljs-string">&quot;facebook/bart-large-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>classifier(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;I have a problem with my iphone that needs to be resolved asap!!&quot;</span>,
<span class="hljs-meta">... </span>    candidate_labels=[<span class="hljs-string">&quot;urgent&quot;</span>, <span class="hljs-string">&quot;not urgent&quot;</span>, <span class="hljs-string">&quot;phone&quot;</span>, <span class="hljs-string">&quot;tablet&quot;</span>, <span class="hljs-string">&quot;computer&quot;</span>],
<span class="hljs-meta">... </span>)
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;I have a problem with my iphone that needs to be resolved asap!!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;urgent&#x27;</span>, <span class="hljs-string">&#x27;phone&#x27;</span>, <span class="hljs-string">&#x27;computer&#x27;</span>, <span class="hljs-string">&#x27;not urgent&#x27;</span>, <span class="hljs-string">&#x27;tablet&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.504</span>, <span class="hljs-number">0.479</span>, <span class="hljs-number">0.013</span>, <span class="hljs-number">0.003</span>, <span class="hljs-number">0.002</span>]}`}}),ss=new J({}),ls=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdnFhJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJpbXBpcmElMkZsYXlvdXRsbS1kb2N1bWVudC1xYSUyMiklMEF2cWEoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3BhY2VzJTJGaW1waXJhJTJGZG9jcXVlcnklMkZyZXNvbHZlJTJGMjM1OTIyM2MxODM3YTc1ODc0MDJiZGEwZjI2NDMzODJhNmVlZmVhYiUyRmludm9pY2UucG5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lM0QlMjJXaGF0JTIwaXMlMjB0aGUlMjBpbnZvaWNlJTIwbnVtYmVyJTNGJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>vqa = pipeline(model=<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>vqa(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&quot;</span>,
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the invoice number?&quot;</span>,
<span class="hljs-meta">... </span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.42515</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;us-001&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">16</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">16</span>}]`}}),K=new Ja({props:{$$slots:{default:[sn]},$$scope:{ctx:E}}}),ns=new J({}),rs=new v({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGUlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBwaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBb3V0cHV0JTIwJTNEJTIwcGlwZSglMjJUaGlzJTIwaXMlMjBhJTIwY29vbCUyMGV4YW1wbGUhJTIyJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMHRvcF9wJTNEMC45NSk=",highlighted:`<span class="hljs-comment"># pip install accelerate</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(model=<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
output = pipe(<span class="hljs-string">&quot;This is a cool example!&quot;</span>, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.95</span>)`}}),cs=new v({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGUlMjBiaXRzYW5kYnl0ZXMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBwaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMG1vZGVsX2t3YXJncyUzRCU3QiUyMmxvYWRfaW5fOGJpdCUyMiUzQSUyMFRydWUlN0QpJTBBb3V0cHV0JTIwJTNEJTIwcGlwZSglMjJUaGlzJTIwaXMlMjBhJTIwY29vbCUyMGV4YW1wbGUhJTIyJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMHRvcF9wJTNEMC45NSk=",highlighted:`<span class="hljs-comment"># pip install accelerate bitsandbytes</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(model=<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, model_kwargs={<span class="hljs-string">&quot;load_in_8bit&quot;</span>: <span class="hljs-literal">True</span>})
output = pipe(<span class="hljs-string">&quot;This is a cool example!&quot;</span>, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.95</span>)`}}),{c(){j=l("meta"),x=p(),w=l("p"),b=p(),T=l("h1"),M=l("a"),$=l("span"),m(ee.$$.fragment),ua=p(),us=l("span"),us.textContent=$a,Xs=p(),se=l("p"),se.innerHTML=Ua,Vs=p(),te=l("ul"),te.innerHTML=ka,Rs=p(),m(X.$$.fragment),Ys=p(),U=l("h2"),V=l("a"),Js=l("span"),m(ae.$$.fragment),fa=p(),fs=l("span"),fs.textContent=Za,qs=p(),le=l("p"),le.innerHTML=Ia,Ls=p(),ne=l("ol"),ne.innerHTML=Ga,Ss=p(),m(pe.$$.fragment),As=p(),R=l("ol"),R.innerHTML=Ca,zs=p(),m(ie.$$.fragment),Fs=p(),re=l("p"),re.innerHTML=_a,Ps=p(),m(oe.$$.fragment),Qs=p(),ce=l("p"),ce.innerHTML=Wa,Ds=p(),he=l("p"),he.textContent=Ba,Ks=p(),m(me.$$.fragment),Os=p(),ue=l("p"),ue.textContent=Na,et=p(),fe=l("p"),fe.innerHTML=Ha,st=p(),de=l("p"),de.innerHTML=Ea,tt=p(),k=l("h2"),Y=l("a"),$s=l("span"),m(ge.$$.fragment),da=p(),ds=l("span"),ds.textContent=Xa,at=p(),ye=l("p"),ye.innerHTML=Va,lt=p(),m(je.$$.fragment),nt=p(),Me=l("p"),Me.textContent=Ra,pt=p(),Z=l("h3"),q=l("a"),Us=l("span"),m(we.$$.fragment),ga=p(),gs=l("span"),gs.textContent=Ya,it=p(),ve=l("p"),ve.innerHTML=qa,rt=p(),m(xe.$$.fragment),ot=p(),be=l("p"),be.innerHTML=La,ct=p(),m(Te.$$.fragment),ht=p(),Je=l("p"),Je.innerHTML=Sa,mt=p(),I=l("h3"),L=l("a"),ks=l("span"),m($e.$$.fragment),ya=p(),ys=l("span"),ys.textContent=Aa,ut=p(),Ue=l("p"),Ue.innerHTML=za,ft=p(),ke=l("p"),ke.textContent=Fa,dt=p(),m(Ze.$$.fragment),gt=p(),Ie=l("p"),Ie.textContent=Pa,yt=p(),Ge=l("p"),Ge.innerHTML=Qa,jt=p(),G=l("h3"),S=l("a"),Zs=l("span"),m(Ce.$$.fragment),ja=p(),js=l("span"),js.textContent=Da,Mt=p(),_e=l("p"),_e.innerHTML=Ka,wt=p(),m(We.$$.fragment),vt=p(),Be=l("p"),Be.innerHTML=Oa,xt=p(),Ne=l("p"),Ne.innerHTML=el,bt=p(),He=l("p"),He.innerHTML=sl,Tt=p(),C=l("h2"),A=l("a"),Is=l("span"),m(Ee.$$.fragment),Ma=p(),Ms=l("span"),Ms.textContent=tl,Jt=p(),Xe=l("p"),Xe.textContent=al,$t=p(),m(Ve.$$.fragment),Ut=p(),Re=l("p"),Re.innerHTML=ll,kt=p(),Ye=l("p"),Ye.innerHTML=nl,Zt=p(),qe=l("p"),qe.innerHTML=pl,It=p(),m(Le.$$.fragment),Gt=p(),_=l("h2"),z=l("a"),Gs=l("span"),m(Se.$$.fragment),wa=p(),ws=l("span"),ws.textContent=il,Ct=p(),m(F.$$.fragment),_t=p(),Ae=l("p"),Ae.innerHTML=rl,Wt=p(),W=l("h2"),P=l("a"),Cs=l("span"),m(ze.$$.fragment),va=p(),vs=l("span"),vs.textContent=ol,Bt=p(),Fe=l("p"),Fe.innerHTML=cl,Nt=p(),Pe=l("p"),Pe.textContent=hl,Ht=p(),Qe=l("p"),Qe.innerHTML=ml,Et=p(),m(De.$$.fragment),Xt=p(),B=l("h2"),Q=l("a"),_s=l("span"),m(Ke.$$.fragment),xa=p(),xs=l("span"),xs.textContent=ul,Vt=p(),Oe=l("p"),Oe.innerHTML=fl,Rt=p(),m(es.$$.fragment),Yt=p(),N=l("h2"),D=l("a"),Ws=l("span"),m(ss.$$.fragment),ba=p(),bs=l("span"),bs.textContent=dl,qt=p(),ts=l("p"),ts.innerHTML=gl,Lt=p(),as=l("p"),as.innerHTML=yl,St=p(),m(ls.$$.fragment),At=p(),m(K.$$.fragment),zt=p(),H=l("h2"),O=l("a"),Bs=l("span"),m(ns.$$.fragment),Ta=p(),Ts=l("span"),Ts.innerHTML=jl,Ft=p(),ps=l("p"),ps.innerHTML=Ml,Pt=p(),is=l("p"),is.innerHTML=wl,Qt=p(),m(rs.$$.fragment),Dt=p(),os=l("p"),os.innerHTML=vl,Kt=p(),m(cs.$$.fragment),Ot=p(),hs=l("p"),hs.textContent=xl,ea=p(),Ns=l("p"),this.h()},l(e){const t=Ql("svelte-1phssyn",document.head);j=n(t,"META",{name:!0,content:!0}),t.forEach(s),x=i(e),w=n(e,"P",{}),h(w).forEach(s),b=i(e),T=n(e,"H1",{class:!0});var ms=h(T);M=n(ms,"A",{id:!0,class:!0,href:!0});var Hs=h(M);$=n(Hs,"SPAN",{});var Es=h($);u(ee.$$.fragment,Es),Es.forEach(s),Hs.forEach(s),ua=i(ms),us=n(ms,"SPAN",{"data-svelte-h":!0}),r(us)!=="svelte-121yjmk"&&(us.textContent=$a),ms.forEach(s),Xs=i(e),se=n(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1v8emeo"&&(se.innerHTML=Ua),Vs=i(e),te=n(e,"UL",{"data-svelte-h":!0}),r(te)!=="svelte-y3fvrg"&&(te.innerHTML=ka),Rs=i(e),u(X.$$.fragment,e),Ys=i(e),U=n(e,"H2",{class:!0});var ta=h(U);V=n(ta,"A",{id:!0,class:!0,href:!0});var bl=h(V);Js=n(bl,"SPAN",{});var Tl=h(Js);u(ae.$$.fragment,Tl),Tl.forEach(s),bl.forEach(s),fa=i(ta),fs=n(ta,"SPAN",{"data-svelte-h":!0}),r(fs)!=="svelte-1hfx7v2"&&(fs.textContent=Za),ta.forEach(s),qs=i(e),le=n(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-vikeun"&&(le.innerHTML=Ia),Ls=i(e),ne=n(e,"OL",{"data-svelte-h":!0}),r(ne)!=="svelte-9wgvms"&&(ne.innerHTML=Ga),Ss=i(e),u(pe.$$.fragment,e),As=i(e),R=n(e,"OL",{start:!0,"data-svelte-h":!0}),r(R)!=="svelte-8nohu8"&&(R.innerHTML=Ca),zs=i(e),u(ie.$$.fragment,e),Fs=i(e),re=n(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-11n7now"&&(re.innerHTML=_a),Ps=i(e),u(oe.$$.fragment,e),Qs=i(e),ce=n(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-10x2hkg"&&(ce.innerHTML=Wa),Ds=i(e),he=n(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1udq0dv"&&(he.textContent=Ba),Ks=i(e),u(me.$$.fragment,e),Os=i(e),ue=n(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1lcss8j"&&(ue.textContent=Na),et=i(e),fe=n(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1ucdvta"&&(fe.innerHTML=Ha),st=i(e),de=n(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1d5458w"&&(de.innerHTML=Ea),tt=i(e),k=n(e,"H2",{class:!0});var aa=h(k);Y=n(aa,"A",{id:!0,class:!0,href:!0});var Jl=h(Y);$s=n(Jl,"SPAN",{});var $l=h($s);u(ge.$$.fragment,$l),$l.forEach(s),Jl.forEach(s),da=i(aa),ds=n(aa,"SPAN",{"data-svelte-h":!0}),r(ds)!=="svelte-1wk3i6h"&&(ds.textContent=Xa),aa.forEach(s),at=i(e),ye=n(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1q9h3i1"&&(ye.innerHTML=Va),lt=i(e),u(je.$$.fragment,e),nt=i(e),Me=n(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-e9485z"&&(Me.textContent=Ra),pt=i(e),Z=n(e,"H3",{class:!0});var la=h(Z);q=n(la,"A",{id:!0,class:!0,href:!0});var Ul=h(q);Us=n(Ul,"SPAN",{});var kl=h(Us);u(we.$$.fragment,kl),kl.forEach(s),Ul.forEach(s),ga=i(la),gs=n(la,"SPAN",{"data-svelte-h":!0}),r(gs)!=="svelte-1m3z64j"&&(gs.textContent=Ya),la.forEach(s),it=i(e),ve=n(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-sob7ne"&&(ve.innerHTML=qa),rt=i(e),u(xe.$$.fragment,e),ot=i(e),be=n(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1kjucao"&&(be.innerHTML=La),ct=i(e),u(Te.$$.fragment,e),ht=i(e),Je=n(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1otna9r"&&(Je.innerHTML=Sa),mt=i(e),I=n(e,"H3",{class:!0});var na=h(I);L=n(na,"A",{id:!0,class:!0,href:!0});var Zl=h(L);ks=n(Zl,"SPAN",{});var Il=h(ks);u($e.$$.fragment,Il),Il.forEach(s),Zl.forEach(s),ya=i(na),ys=n(na,"SPAN",{"data-svelte-h":!0}),r(ys)!=="svelte-tl3n1q"&&(ys.textContent=Aa),na.forEach(s),ut=i(e),Ue=n(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-v1mumi"&&(Ue.innerHTML=za),ft=i(e),ke=n(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1jutax8"&&(ke.textContent=Fa),dt=i(e),u(Ze.$$.fragment,e),gt=i(e),Ie=n(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1qshzkd"&&(Ie.textContent=Pa),yt=i(e),Ge=n(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-sq1wry"&&(Ge.innerHTML=Qa),jt=i(e),G=n(e,"H3",{class:!0});var pa=h(G);S=n(pa,"A",{id:!0,class:!0,href:!0});var Gl=h(S);Zs=n(Gl,"SPAN",{});var Cl=h(Zs);u(Ce.$$.fragment,Cl),Cl.forEach(s),Gl.forEach(s),ja=i(pa),js=n(pa,"SPAN",{"data-svelte-h":!0}),r(js)!=="svelte-1w6n8om"&&(js.textContent=Da),pa.forEach(s),Mt=i(e),_e=n(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-wn1tow"&&(_e.innerHTML=Ka),wt=i(e),u(We.$$.fragment,e),vt=i(e),Be=n(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1gng3we"&&(Be.innerHTML=Oa),xt=i(e),Ne=n(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-1ese9k6"&&(Ne.innerHTML=el),bt=i(e),He=n(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-1nowgzq"&&(He.innerHTML=sl),Tt=i(e),C=n(e,"H2",{class:!0});var ia=h(C);A=n(ia,"A",{id:!0,class:!0,href:!0});var _l=h(A);Is=n(_l,"SPAN",{});var Wl=h(Is);u(Ee.$$.fragment,Wl),Wl.forEach(s),_l.forEach(s),Ma=i(ia),Ms=n(ia,"SPAN",{"data-svelte-h":!0}),r(Ms)!=="svelte-qun44c"&&(Ms.textContent=tl),ia.forEach(s),Jt=i(e),Xe=n(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1sh6mg6"&&(Xe.textContent=al),$t=i(e),u(Ve.$$.fragment,e),Ut=i(e),Re=n(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-1rrzg9"&&(Re.innerHTML=ll),kt=i(e),Ye=n(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1litpj1"&&(Ye.innerHTML=nl),Zt=i(e),qe=n(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-1pgxdbs"&&(qe.innerHTML=pl),It=i(e),u(Le.$$.fragment,e),Gt=i(e),_=n(e,"H2",{class:!0});var ra=h(_);z=n(ra,"A",{id:!0,class:!0,href:!0});var Bl=h(z);Gs=n(Bl,"SPAN",{});var Nl=h(Gs);u(Se.$$.fragment,Nl),Nl.forEach(s),Bl.forEach(s),wa=i(ra),ws=n(ra,"SPAN",{"data-svelte-h":!0}),r(ws)!=="svelte-b1sisp"&&(ws.textContent=il),ra.forEach(s),Ct=i(e),u(F.$$.fragment,e),_t=i(e),Ae=n(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-52dmam"&&(Ae.innerHTML=rl),Wt=i(e),W=n(e,"H2",{class:!0});var oa=h(W);P=n(oa,"A",{id:!0,class:!0,href:!0});var Hl=h(P);Cs=n(Hl,"SPAN",{});var El=h(Cs);u(ze.$$.fragment,El),El.forEach(s),Hl.forEach(s),va=i(oa),vs=n(oa,"SPAN",{"data-svelte-h":!0}),r(vs)!=="svelte-gs2plx"&&(vs.textContent=ol),oa.forEach(s),Bt=i(e),Fe=n(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-r86tae"&&(Fe.innerHTML=cl),Nt=i(e),Pe=n(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-ip2z2f"&&(Pe.textContent=hl),Ht=i(e),Qe=n(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-1bks2jw"&&(Qe.innerHTML=ml),Et=i(e),u(De.$$.fragment,e),Xt=i(e),B=n(e,"H2",{class:!0});var ca=h(B);Q=n(ca,"A",{id:!0,class:!0,href:!0});var Xl=h(Q);_s=n(Xl,"SPAN",{});var Vl=h(_s);u(Ke.$$.fragment,Vl),Vl.forEach(s),Xl.forEach(s),xa=i(ca),xs=n(ca,"SPAN",{"data-svelte-h":!0}),r(xs)!=="svelte-umgmbk"&&(xs.textContent=ul),ca.forEach(s),Vt=i(e),Oe=n(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-1xa20pq"&&(Oe.innerHTML=fl),Rt=i(e),u(es.$$.fragment,e),Yt=i(e),N=n(e,"H2",{class:!0});var ha=h(N);D=n(ha,"A",{id:!0,class:!0,href:!0});var Rl=h(D);Ws=n(Rl,"SPAN",{});var Yl=h(Ws);u(ss.$$.fragment,Yl),Yl.forEach(s),Rl.forEach(s),ba=i(ha),bs=n(ha,"SPAN",{"data-svelte-h":!0}),r(bs)!=="svelte-ag1idn"&&(bs.textContent=dl),ha.forEach(s),qt=i(e),ts=n(e,"P",{"data-svelte-h":!0}),r(ts)!=="svelte-yipyr7"&&(ts.innerHTML=gl),Lt=i(e),as=n(e,"P",{"data-svelte-h":!0}),r(as)!=="svelte-4s0csr"&&(as.innerHTML=yl),St=i(e),u(ls.$$.fragment,e),At=i(e),u(K.$$.fragment,e),zt=i(e),H=n(e,"H2",{class:!0});var ma=h(H);O=n(ma,"A",{id:!0,class:!0,href:!0});var ql=h(O);Bs=n(ql,"SPAN",{});var Ll=h(Bs);u(ns.$$.fragment,Ll),Ll.forEach(s),ql.forEach(s),Ta=i(ma),Ts=n(ma,"SPAN",{"data-svelte-h":!0}),r(Ts)!=="svelte-1w79szp"&&(Ts.innerHTML=jl),ma.forEach(s),Ft=i(e),ps=n(e,"P",{"data-svelte-h":!0}),r(ps)!=="svelte-32c7q2"&&(ps.innerHTML=Ml),Pt=i(e),is=n(e,"P",{"data-svelte-h":!0}),r(is)!=="svelte-1yg483v"&&(is.innerHTML=wl),Qt=i(e),u(rs.$$.fragment,e),Dt=i(e),os=n(e,"P",{"data-svelte-h":!0}),r(os)!=="svelte-1c9ycn6"&&(os.innerHTML=vl),Kt=i(e),u(cs.$$.fragment,e),Ot=i(e),hs=n(e,"P",{"data-svelte-h":!0}),r(hs)!=="svelte-1f2oxpa"&&(hs.textContent=xl),ea=i(e),Ns=n(e,"P",{}),h(Ns).forEach(s),this.h()},h(){o(j,"name","hf:doc:metadata"),o(j,"content",JSON.stringify(an)),o(M,"id","pipelines-for-inference"),o(M,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(M,"href","#pipelines-for-inference"),o(T,"class","relative group"),o(V,"id","pipeline-usage"),o(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(V,"href","#pipeline-usage"),o(U,"class","relative group"),o(R,"start","2"),o(Y,"id","parameters"),o(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(Y,"href","#parameters"),o(k,"class","relative group"),o(q,"id","device"),o(q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(q,"href","#device"),o(Z,"class","relative group"),o(L,"id","batch-size"),o(L,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(L,"href","#batch-size"),o(I,"class","relative group"),o(S,"id","task-specific-parameters"),o(S,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(S,"href","#task-specific-parameters"),o(G,"class","relative group"),o(A,"id","using-pipelines-on-a-dataset"),o(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(A,"href","#using-pipelines-on-a-dataset"),o(C,"class","relative group"),o(z,"id","using-pipelines-for-a-webserver"),o(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(z,"href","#using-pipelines-for-a-webserver"),o(_,"class","relative group"),o(P,"id","vision-pipeline"),o(P,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(P,"href","#vision-pipeline"),o(W,"class","relative group"),o(Q,"id","text-pipeline"),o(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(Q,"href","#text-pipeline"),o(B,"class","relative group"),o(D,"id","multimodal-pipeline"),o(D,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(D,"href","#multimodal-pipeline"),o(N,"class","relative group"),o(O,"id","using-pipeline-on-large-models-with-accelerate"),o(O,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(O,"href","#using-pipeline-on-large-models-with-accelerate"),o(H,"class","relative group")},m(e,t){c(document.head,j),a(e,x,t),a(e,w,t),a(e,b,t),a(e,T,t),c(T,M),c(M,$),f(ee,$,null),c(T,ua),c(T,us),a(e,Xs,t),a(e,se,t),a(e,Vs,t),a(e,te,t),a(e,Rs,t),f(X,e,t),a(e,Ys,t),a(e,U,t),c(U,V),c(V,Js),f(ae,Js,null),c(U,fa),c(U,fs),a(e,qs,t),a(e,le,t),a(e,Ls,t),a(e,ne,t),a(e,Ss,t),f(pe,e,t),a(e,As,t),a(e,R,t),a(e,zs,t),f(ie,e,t),a(e,Fs,t),a(e,re,t),a(e,Ps,t),f(oe,e,t),a(e,Qs,t),a(e,ce,t),a(e,Ds,t),a(e,he,t),a(e,Ks,t),f(me,e,t),a(e,Os,t),a(e,ue,t),a(e,et,t),a(e,fe,t),a(e,st,t),a(e,de,t),a(e,tt,t),a(e,k,t),c(k,Y),c(Y,$s),f(ge,$s,null),c(k,da),c(k,ds),a(e,at,t),a(e,ye,t),a(e,lt,t),f(je,e,t),a(e,nt,t),a(e,Me,t),a(e,pt,t),a(e,Z,t),c(Z,q),c(q,Us),f(we,Us,null),c(Z,ga),c(Z,gs),a(e,it,t),a(e,ve,t),a(e,rt,t),f(xe,e,t),a(e,ot,t),a(e,be,t),a(e,ct,t),f(Te,e,t),a(e,ht,t),a(e,Je,t),a(e,mt,t),a(e,I,t),c(I,L),c(L,ks),f($e,ks,null),c(I,ya),c(I,ys),a(e,ut,t),a(e,Ue,t),a(e,ft,t),a(e,ke,t),a(e,dt,t),f(Ze,e,t),a(e,gt,t),a(e,Ie,t),a(e,yt,t),a(e,Ge,t),a(e,jt,t),a(e,G,t),c(G,S),c(S,Zs),f(Ce,Zs,null),c(G,ja),c(G,js),a(e,Mt,t),a(e,_e,t),a(e,wt,t),f(We,e,t),a(e,vt,t),a(e,Be,t),a(e,xt,t),a(e,Ne,t),a(e,bt,t),a(e,He,t),a(e,Tt,t),a(e,C,t),c(C,A),c(A,Is),f(Ee,Is,null),c(C,Ma),c(C,Ms),a(e,Jt,t),a(e,Xe,t),a(e,$t,t),f(Ve,e,t),a(e,Ut,t),a(e,Re,t),a(e,kt,t),a(e,Ye,t),a(e,Zt,t),a(e,qe,t),a(e,It,t),f(Le,e,t),a(e,Gt,t),a(e,_,t),c(_,z),c(z,Gs),f(Se,Gs,null),c(_,wa),c(_,ws),a(e,Ct,t),f(F,e,t),a(e,_t,t),a(e,Ae,t),a(e,Wt,t),a(e,W,t),c(W,P),c(P,Cs),f(ze,Cs,null),c(W,va),c(W,vs),a(e,Bt,t),a(e,Fe,t),a(e,Nt,t),a(e,Pe,t),a(e,Ht,t),a(e,Qe,t),a(e,Et,t),f(De,e,t),a(e,Xt,t),a(e,B,t),c(B,Q),c(Q,_s),f(Ke,_s,null),c(B,xa),c(B,xs),a(e,Vt,t),a(e,Oe,t),a(e,Rt,t),f(es,e,t),a(e,Yt,t),a(e,N,t),c(N,D),c(D,Ws),f(ss,Ws,null),c(N,ba),c(N,bs),a(e,qt,t),a(e,ts,t),a(e,Lt,t),a(e,as,t),a(e,St,t),f(ls,e,t),a(e,At,t),f(K,e,t),a(e,zt,t),a(e,H,t),c(H,O),c(O,Bs),f(ns,Bs,null),c(H,Ta),c(H,Ts),a(e,Ft,t),a(e,ps,t),a(e,Pt,t),a(e,is,t),a(e,Qt,t),f(rs,e,t),a(e,Dt,t),a(e,os,t),a(e,Kt,t),f(cs,e,t),a(e,Ot,t),a(e,hs,t),a(e,ea,t),a(e,Ns,t),sa=!0},p(e,[t]){const ms={};t&2&&(ms.$$scope={dirty:t,ctx:e}),X.$set(ms);const Hs={};t&2&&(Hs.$$scope={dirty:t,ctx:e}),F.$set(Hs);const Es={};t&2&&(Es.$$scope={dirty:t,ctx:e}),K.$set(Es)},i(e){sa||(d(ee.$$.fragment,e),d(X.$$.fragment,e),d(ae.$$.fragment,e),d(pe.$$.fragment,e),d(ie.$$.fragment,e),d(oe.$$.fragment,e),d(me.$$.fragment,e),d(ge.$$.fragment,e),d(je.$$.fragment,e),d(we.$$.fragment,e),d(xe.$$.fragment,e),d(Te.$$.fragment,e),d($e.$$.fragment,e),d(Ze.$$.fragment,e),d(Ce.$$.fragment,e),d(We.$$.fragment,e),d(Ee.$$.fragment,e),d(Ve.$$.fragment,e),d(Le.$$.fragment,e),d(Se.$$.fragment,e),d(F.$$.fragment,e),d(ze.$$.fragment,e),d(De.$$.fragment,e),d(Ke.$$.fragment,e),d(es.$$.fragment,e),d(ss.$$.fragment,e),d(ls.$$.fragment,e),d(K.$$.fragment,e),d(ns.$$.fragment,e),d(rs.$$.fragment,e),d(cs.$$.fragment,e),sa=!0)},o(e){g(ee.$$.fragment,e),g(X.$$.fragment,e),g(ae.$$.fragment,e),g(pe.$$.fragment,e),g(ie.$$.fragment,e),g(oe.$$.fragment,e),g(me.$$.fragment,e),g(ge.$$.fragment,e),g(je.$$.fragment,e),g(we.$$.fragment,e),g(xe.$$.fragment,e),g(Te.$$.fragment,e),g($e.$$.fragment,e),g(Ze.$$.fragment,e),g(Ce.$$.fragment,e),g(We.$$.fragment,e),g(Ee.$$.fragment,e),g(Ve.$$.fragment,e),g(Le.$$.fragment,e),g(Se.$$.fragment,e),g(F.$$.fragment,e),g(ze.$$.fragment,e),g(De.$$.fragment,e),g(Ke.$$.fragment,e),g(es.$$.fragment,e),g(ss.$$.fragment,e),g(ls.$$.fragment,e),g(K.$$.fragment,e),g(ns.$$.fragment,e),g(rs.$$.fragment,e),g(cs.$$.fragment,e),sa=!1},d(e){e&&(s(x),s(w),s(b),s(T),s(Xs),s(se),s(Vs),s(te),s(Rs),s(Ys),s(U),s(qs),s(le),s(Ls),s(ne),s(Ss),s(As),s(R),s(zs),s(Fs),s(re),s(Ps),s(Qs),s(ce),s(Ds),s(he),s(Ks),s(Os),s(ue),s(et),s(fe),s(st),s(de),s(tt),s(k),s(at),s(ye),s(lt),s(nt),s(Me),s(pt),s(Z),s(it),s(ve),s(rt),s(ot),s(be),s(ct),s(ht),s(Je),s(mt),s(I),s(ut),s(Ue),s(ft),s(ke),s(dt),s(gt),s(Ie),s(yt),s(Ge),s(jt),s(G),s(Mt),s(_e),s(wt),s(vt),s(Be),s(xt),s(Ne),s(bt),s(He),s(Tt),s(C),s(Jt),s(Xe),s($t),s(Ut),s(Re),s(kt),s(Ye),s(Zt),s(qe),s(It),s(Gt),s(_),s(Ct),s(_t),s(Ae),s(Wt),s(W),s(Bt),s(Fe),s(Nt),s(Pe),s(Ht),s(Qe),s(Et),s(Xt),s(B),s(Vt),s(Oe),s(Rt),s(Yt),s(N),s(qt),s(ts),s(Lt),s(as),s(St),s(At),s(zt),s(H),s(Ft),s(ps),s(Pt),s(is),s(Qt),s(Dt),s(os),s(Kt),s(Ot),s(hs),s(ea),s(Ns)),s(j),y(ee),y(X,e),y(ae),y(pe,e),y(ie,e),y(oe,e),y(me,e),y(ge),y(je,e),y(we),y(xe,e),y(Te,e),y($e),y(Ze,e),y(Ce),y(We,e),y(Ee),y(Ve,e),y(Le,e),y(Se),y(F,e),y(ze),y(De,e),y(Ke),y(es,e),y(ss),y(ls,e),y(K,e),y(ns),y(rs,e),y(cs,e)}}}const an={local:"pipelines-for-inference",sections:[{local:"pipeline-usage",title:"Pipeline usage"},{local:"parameters",sections:[{local:"device",title:"Device"},{local:"batch-size",title:"Batch size"},{local:"task-specific-parameters",title:"Task specific parameters"}],title:"Parameters"},{local:"using-pipelines-on-a-dataset",title:"Using pipelines on a dataset"},{local:"using-pipelines-for-a-webserver",title:"Using pipelines for a webserver"},{local:"vision-pipeline",title:"Vision pipeline"},{local:"text-pipeline",title:"Text pipeline"},{local:"multimodal-pipeline",title:"Multimodal pipeline"},{local:"using-pipeline-on-large-models-with-accelerate",title:"Using `pipeline` on large models with 🤗 `accelerate`:"}],title:"Pipelines for inference"};function ln(E){return zl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hn extends Fl{constructor(j){super(),Pl(this,j,ln,tn,Al,{})}}export{hn as component};
