import{s as $s,n as Ks,o as Ps}from"../chunks/scheduler.7bc62968.js";import{S as Os,i as qs,g as M,s as a,r as J,m as pl,H as Ts,A as le,h as p,f as e,c as t,j as il,u as c,x as i,n as ol,B as ws,k as Xs,y as o,a as n,v as T,d as w,t as r,w as m}from"../chunks/index.2f8492b0.js";import{C as se}from"../chunks/CodeBlock.4e96d6f7.js";import{H as u}from"../chunks/Heading.14fb2476.js";function ee(rs){let U,Jl,yl,cl,h,Tl,C,ms="In this chapter we will go through a convolutional architecture called GoogleNet.",wl,b,rl,A,Us="The Inception architecture, a convolutional neural network (CNN) designed for tasks in computer vision such as classification and detection, stands out due to its efficiency. It contains fewer than 7 million parameters and is significantly more compact than its predecessors, being 9 times smaller than AlexNet and 22 times smaller than VGG16. This architecture gained recognition in the ImageNet 2014 challenge, where Google’s adaptation, named GoogLeNet (a tribute to LeNet), set new benchmarks in performance while utilizing fewer parameters compared to previous leading methods.",ml,d,Ul,f,us="Before the advent of the Inception architecture, models like AlexNet and VGG demonstrated the benefits of deeper network structures. However, deeper networks typically entail more computational steps and can lead to issues such as overfitting and the vanishing gradient problem. The Inception architecture offers a solution, enabling the training of complex CNNs with a reduced count of floating-point parameters.",ul,x,Il,k,Is="In prior networks, such as AlexNet or VGG, the fundamental block is the convolution layer itself. However, Lin et al. 2013, introduced the concept of Network In Network, arguing that a single convolution is not necessarily a correct fundamental building block. It ought to be more complex. So, inspired by that, the Inception model authors decided to have a more complex building block called the Inception Module, aptly named after the famous movie - “The Inception” (dream in dream).",hl,g,hs="The Inception Module insists on applying convolution filters of different kernel sizes for feature extraction at multiple scales. For any input feature map, it applies a $1 \\times 1$ convolution, a 3x3 convolution, and a 5x5 convolution in parallel. In addition to convolution a max pooling operation is also applied. All four operations have padding and stride in such a way as to have the same spatial dimension. These features are concatenated and form the input to the next stage. See Figure 1.",Cl,v,Cs='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/inception_naive.png" alt="inception_naive"/>',bl,B,bs="Figure 1: Naive Inception Module",Al,Q,As="As we can see applying multiple convolutions at multiple scales with bigger kernel sizes, like 5x5, can increase the number of parameters drastically. This problem is pronounced as the input feature size (channel size) increases. So as we go deep in the network stacking these “Inception Modules”, the computation will increase drastically. The simple solution is to reduce the number of features wherever computational requirements seem to increase. The major pain points of high computation are the convolution layers. The feature dimension is reduced by a computationally inexpensive $1 \\times 1$ convolution just before the 3x3 and 5x5 convolution. Let’s see it with an example.",dl,N,ds="We want to convert a feature map of (\\ S \\times S \\times 128 \\) to (\\ S \\times S \\times 256 \\) via a 5x5 convolution. The number of parameters (excluding biases) is 5<em>5</em>128*256 = 819,200. However, if we reduce the feature dimension first by a $1 \\times 1$ convolution to 64, then the number of parameters(excluding biases) is (\\ 1\\times 1\\times 128\\times 64 + 5\\times 5\\times 64\\times 256 = 8,192 + 409,600 = 417,792 \\). That means the number of parameters was reduced by almost half!",fl,E,fs="We would also want to reduce the output features of max pooling before concatenating with the output feature map. So, we add one more (\\ 1\\times 1 \\) convolution after the max-pooling layer. We also add a ReLU activation after each (\\ 1\\times 1 \\) convolution increasing non-linearity and complexity of the module. See Figure 2.",xl,G,xs='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/inception_reduced.png" alt="inception_reduced"/>',kl,Z,ks="Figure 2: Inception Module",gl,z,gs="Also, because of the parallel operations of convolutions at multiple scales, we are ensuring more operations without going deeper into the network, essentially mitigating the vanishing gradient problem.",vl,D,Bl,S,vs="In prior networks, like AlexNet or VGG, the final layers would be a few fully connected layers. These fully connected layers, due to their large number of units would contribute to most of the parameters in a network. For example, 89% of the parameters of VGG16 are in the final three fully connected layers. 95% of parameters in AlexNet are in the final fully connected layers. This need can be attributed to the premise that a Convolutional layer is not necessarily complex enough.",Ql,_,Nl,V,Bs="Before the advent of the Inception architecture, models like AlexNet and VGG demonstrated the benefits of deeper network structures. However, deeper networks typically entail more computational steps and can lead to issues such as overfitting and the vanishing gradient problem. The Inception architecture offers a solution, enabling the training of complex CNNs with a reduced count of floating-point parameters.",El,H,Qs="In a conventional CNN design, layers are typically categorized as either pooling or convolution layers, with specific sizes for convolution filters. Although layering different sizes of convolution filters is beneficial for various tasks, it can rapidly increase the total number of parameters. The Inception architecture takes a different approach by running the convolution filters of various sizes (1x1, 3x3, 5x5) in parallel.  That means it is possible to get different lower-dimensional embeddings -and hence, more information- from the same higher-dimensional features using these parallel processes! These are then integrated with max pooling into a unified component known as the Inception module. The GoogLeNet architecture is composed of a series of 9 such Inception modules. This configuration allows the network to maintain flexibility and learn complex tasks without a substantial increase in depth.",Gl,Y,Ns="However, with an Inception block at our disposal, we do not need fully connected layers and a simple average pooling along the spatial dimensions should be enough. This was also derived from the Network in Network paper. However, GoogLeNet included one fully connected layer. They reported an increase of 0.6% in top-1 accuracy.",Zl,W,Es="GoogLeNet has only 15% of the parameters in the fully connected layers.",zl,X,Dl,I,ps,Sl,Rs='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mn>1</mn><mo>×</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> 1 \\times 1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7278em;vertical-align:-0.0833em;"></span><span class="mord">1</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',_l,Vl,R,Gs="The paper introduces the auxiliary classifiers - branch out a few small classifiers from the layers in between and add the loss from these classifiers to the total loss(with less weightage). This ensures that the layers close to the input also receive gradients of decent magnitude.",Hl,F,Zs="The auxiliary classifier consists of",Yl,y,L,is,Wl,Fs='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mn>5</mn><mo>×</mo><mn>5</mn></mrow><annotation encoding="application/x-tex"> 5 \\times 5 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7278em;vertical-align:-0.0833em;"></span><span class="mord">5</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">5</span></span></span></span>',Xl,os,$,ys,Rl,Ls='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mn>1</mn><mo>×</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> 1 \\times 1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7278em;vertical-align:-0.0833em;"></span><span class="mord">1</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',Fl,js,al,zs="A fully connected layer with 1024 units and rectified linear activation.",Js,tl,Ds="A dropout layer with 70% ratio of dropped outputs.",cs,Ml,Ss="A linear layer with softmax loss as the classifier.",Ll,K,_s="These auxiliary classifiers are removed at inference time. However, minimal gains are achieved from using auxiliary classifiers (0.5%).",$l,P,Vs='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/googlenet_auxiliary_classifier.jpg" alt="googlenet_aux_clf"/>',Kl,O,Hs="Figure 3: An Auxiliary Classifier",Pl,q,Ol,ll,Ys="The complete architecture of GoogLeNet is shown in Figure below. All convolutions, including inside the inception block, use ReLU activation. It starts with two convolution(s) and max-pooling blocks. This is followed by a block of two inception modules (3a and 3b) and a max pooling. This follows a block of 5 inception blocks (4a, 4b, 4c, 4d, 4e) and a max pooling after. The auxiliary classifiers are taken out from outputs of 4a and 4d. Two inception blocks follow (5a and 5b). After this, an average pooling and a fully connected layer of 128 units are used.",ql,sl,Ws=`<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/googlenet_architecture.png" alt="googlenet_arch"/>
Figure 4: Complete GoogLeNet Architecture`,ls,el,ss,nl,es,jl,ns;return h=new u({props:{title:"GoogLeNet",local:"googlenet",headingTag:"h1"}}),b=new u({props:{title:"Overview",local:"overview",headingTag:"h2"}}),d=new u({props:{title:"Architectural Innovations",local:"architectural-innovations",headingTag:"h3"}}),x=new u({props:{title:"The Inception “Network In Network” Module",local:"the-inception-network-in-network-module",headingTag:"h4"}}),D=new u({props:{title:"Average Pooling",local:"average-pooling",headingTag:"h4"}}),_=new u({props:{title:"Architectural Innovations",local:"architectural-innovations",headingTag:"h3"}}),X=new u({props:{title:"Auxiliary Classifiers",local:"auxiliary-classifiers",headingTag:"h4"}}),q=new u({props:{title:"Architecture - GoogLeNet",local:"architecture---googlenet",headingTag:"h3"}}),el=new u({props:{title:"Code",local:"code",headingTag:"h3"}}),nl=new se({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn


<span class="hljs-keyword">class</span> <span class="hljs-title class_">BaseConv2d</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, in_channels, out_channels, **kwargs</span>):
        <span class="hljs-built_in">super</span>(BaseConv2d, self).__init__()
        self.conv = nn.Conv2d(in_channels, out_channels, **kwargs)
        self.relu = nn.ReLU()

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = self.conv(x)
        x = self.relu(x)
        <span class="hljs-keyword">return</span> x


<span class="hljs-keyword">class</span> <span class="hljs-title class_">InceptionModule</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, in_channels, n1x1, n3x3red, n3x3, n5x5red, n5x5, pool_proj</span>):
        <span class="hljs-built_in">super</span>(InceptionModule, self).__init__()

        self.b1 = BaseConv2d(in_channels, n1x1, kernel_size=<span class="hljs-number">1</span>)

        self.b1 = nn.Sequential(
            nn.Conv2d(in_channels, n1x1, kernel_size=<span class="hljs-number">1</span>),
            nn.ReLU(<span class="hljs-literal">True</span>),
        )

        self.b2 = nn.Sequential(
            BaseConv2d(in_channels, n3x3red, kernel_size=<span class="hljs-number">1</span>),
            BaseConv2d(n3x3red, n3x3, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
        )

        self.b3 = nn.Sequential(
            BaseConv2d(in_channels, n5x5red, kernel_size=<span class="hljs-number">1</span>),
            BaseConv2d(n5x5red, n5x5, kernel_size=<span class="hljs-number">5</span>, padding=<span class="hljs-number">2</span>),
        )

        self.b4 = nn.Sequential(
            nn.MaxPool2d(<span class="hljs-number">3</span>, stride=<span class="hljs-number">1</span>, padding=<span class="hljs-number">1</span>),
            BaseConv2d(in_channels, pool_proj, kernel_size=<span class="hljs-number">1</span>),
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        y1 = self.b1(x)
        y2 = self.b2(x)
        y3 = self.b3(x)
        y4 = self.b4(x)
        <span class="hljs-keyword">return</span> torch.cat([y1, y2, y3, y4], <span class="hljs-number">1</span>)


<span class="hljs-keyword">class</span> <span class="hljs-title class_">AuxiliaryClassifier</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, in_channels, num_classes, dropout=<span class="hljs-number">0.7</span></span>):
        <span class="hljs-built_in">super</span>(AuxiliaryClassifier, self).__init__()
        self.pool = nn.AvgPool2d(<span class="hljs-number">5</span>, stride=<span class="hljs-number">3</span>)
        self.conv = BaseConv2d(in_channels, <span class="hljs-number">128</span>, kernel_size=<span class="hljs-number">1</span>)
        self.relu = nn.ReLU(<span class="hljs-literal">True</span>)
        self.flatten = nn.Flatten()
        self.fc1 = nn.Linear(<span class="hljs-number">2048</span>, <span class="hljs-number">1024</span>)
        self.dropout = nn.Dropout(dropout)
        self.fc2 = nn.Linear(<span class="hljs-number">1024</span>, num_classes)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = self.pool(x)
        x = self.conv(x)
        x = self.flatten(x)
        x = self.fc1(x)
        x = self.relu(x)
        x = self.dropout(x)
        x = self.fc2(x)
        <span class="hljs-keyword">return</span> x


<span class="hljs-keyword">class</span> <span class="hljs-title class_">GoogLeNet</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, use_aux=<span class="hljs-literal">True</span></span>):
        <span class="hljs-built_in">super</span>(GoogLeNet, self).__init__()

        self.use_aux = use_aux
        <span class="hljs-comment">## block 1</span>
        self.conv1 = BaseConv2d(<span class="hljs-number">3</span>, <span class="hljs-number">64</span>, kernel_size=<span class="hljs-number">7</span>, stride=<span class="hljs-number">2</span>, padding=<span class="hljs-number">3</span>)
        self.lrn1 = nn.LocalResponseNorm(<span class="hljs-number">5</span>, alpha=<span class="hljs-number">0.0001</span>, beta=<span class="hljs-number">0.75</span>)
        self.maxpool1 = nn.MaxPool2d(<span class="hljs-number">3</span>, stride=<span class="hljs-number">2</span>, padding=<span class="hljs-number">1</span>)

        <span class="hljs-comment">## block 2</span>
        self.conv2 = BaseConv2d(<span class="hljs-number">64</span>, <span class="hljs-number">64</span>, kernel_size=<span class="hljs-number">1</span>)
        self.conv3 = BaseConv2d(<span class="hljs-number">64</span>, <span class="hljs-number">192</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>)
        self.lrn2 = nn.LocalResponseNorm(<span class="hljs-number">5</span>, alpha=<span class="hljs-number">0.0001</span>, beta=<span class="hljs-number">0.75</span>)
        self.maxpool2 = nn.MaxPool2d(<span class="hljs-number">3</span>, stride=<span class="hljs-number">2</span>, padding=<span class="hljs-number">1</span>)

        <span class="hljs-comment">## block 3</span>
        self.inception3a = InceptionModule(<span class="hljs-number">192</span>, <span class="hljs-number">64</span>, <span class="hljs-number">96</span>, <span class="hljs-number">128</span>, <span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">32</span>)
        self.inception3b = InceptionModule(<span class="hljs-number">256</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>, <span class="hljs-number">192</span>, <span class="hljs-number">32</span>, <span class="hljs-number">96</span>, <span class="hljs-number">64</span>)
        self.maxpool3 = nn.MaxPool2d(<span class="hljs-number">3</span>, stride=<span class="hljs-number">2</span>, padding=<span class="hljs-number">1</span>)

        <span class="hljs-comment">## block 4</span>
        self.inception4a = InceptionModule(<span class="hljs-number">480</span>, <span class="hljs-number">192</span>, <span class="hljs-number">96</span>, <span class="hljs-number">208</span>, <span class="hljs-number">16</span>, <span class="hljs-number">48</span>, <span class="hljs-number">64</span>)
        self.inception4b = InceptionModule(<span class="hljs-number">512</span>, <span class="hljs-number">160</span>, <span class="hljs-number">112</span>, <span class="hljs-number">224</span>, <span class="hljs-number">24</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>)
        self.inception4c = InceptionModule(<span class="hljs-number">512</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>, <span class="hljs-number">256</span>, <span class="hljs-number">24</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>)
        self.inception4d = InceptionModule(<span class="hljs-number">512</span>, <span class="hljs-number">112</span>, <span class="hljs-number">144</span>, <span class="hljs-number">288</span>, <span class="hljs-number">32</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>)
        self.inception4e = InceptionModule(<span class="hljs-number">528</span>, <span class="hljs-number">256</span>, <span class="hljs-number">160</span>, <span class="hljs-number">320</span>, <span class="hljs-number">32</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>)
        self.maxpool4 = nn.MaxPool2d(<span class="hljs-number">3</span>, stride=<span class="hljs-number">2</span>, padding=<span class="hljs-number">1</span>)

        <span class="hljs-comment">## block 5</span>
        self.inception5a = InceptionModule(<span class="hljs-number">832</span>, <span class="hljs-number">256</span>, <span class="hljs-number">160</span>, <span class="hljs-number">320</span>, <span class="hljs-number">32</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>)
        self.inception5b = InceptionModule(<span class="hljs-number">832</span>, <span class="hljs-number">384</span>, <span class="hljs-number">192</span>, <span class="hljs-number">384</span>, <span class="hljs-number">48</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>)

        <span class="hljs-comment">## auxiliary classifier</span>
        <span class="hljs-keyword">if</span> self.use_aux:
            self.aux1 = AuxiliaryClassifier(<span class="hljs-number">512</span>, <span class="hljs-number">1000</span>)
            self.aux2 = AuxiliaryClassifier(<span class="hljs-number">528</span>, <span class="hljs-number">1000</span>)

        <span class="hljs-comment">## block 6</span>
        self.avgpool = nn.AvgPool2d(<span class="hljs-number">7</span>, stride=<span class="hljs-number">1</span>)
        self.dropout = nn.Dropout(<span class="hljs-number">0.4</span>)
        self.fc = nn.Linear(<span class="hljs-number">1024</span>, <span class="hljs-number">1000</span>)

        self.pre_layers = nn.Sequential(
            nn.Conv2d(<span class="hljs-number">3</span>, <span class="hljs-number">64</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(<span class="hljs-literal">True</span>),
        )

        self.inception_blocks = nn.Sequential(
            InceptionModule(<span class="hljs-number">64</span>, <span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">32</span>, <span class="hljs-number">16</span>, <span class="hljs-number">8</span>, <span class="hljs-number">8</span>),
            InceptionModule(<span class="hljs-number">64</span>, <span class="hljs-number">24</span>, <span class="hljs-number">32</span>, <span class="hljs-number">48</span>, <span class="hljs-number">16</span>, <span class="hljs-number">12</span>, <span class="hljs-number">12</span>),
            nn.MaxPool2d(<span class="hljs-number">3</span>, stride=<span class="hljs-number">2</span>, padding=<span class="hljs-number">1</span>),
            InceptionModule(<span class="hljs-number">96</span>, <span class="hljs-number">24</span>, <span class="hljs-number">32</span>, <span class="hljs-number">48</span>, <span class="hljs-number">16</span>, <span class="hljs-number">12</span>, <span class="hljs-number">12</span>),
            InceptionModule(<span class="hljs-number">96</span>, <span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">48</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>),
            InceptionModule(<span class="hljs-number">96</span>, <span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">48</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>),
            InceptionModule(<span class="hljs-number">96</span>, <span class="hljs-number">16</span>, <span class="hljs-number">32</span>, <span class="hljs-number">48</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>),
            InceptionModule(<span class="hljs-number">96</span>, <span class="hljs-number">32</span>, <span class="hljs-number">32</span>, <span class="hljs-number">48</span>, <span class="hljs-number">16</span>, <span class="hljs-number">24</span>, <span class="hljs-number">24</span>),
            nn.MaxPool2d(<span class="hljs-number">3</span>, stride=<span class="hljs-number">2</span>, padding=<span class="hljs-number">1</span>),
            InceptionModule(<span class="hljs-number">128</span>, <span class="hljs-number">32</span>, <span class="hljs-number">48</span>, <span class="hljs-number">64</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>),
            InceptionModule(<span class="hljs-number">128</span>, <span class="hljs-number">32</span>, <span class="hljs-number">48</span>, <span class="hljs-number">64</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>),
        )

        self.output_net = nn.Sequential(
            nn.AdaptiveAvgPool2d((<span class="hljs-number">1</span>, <span class="hljs-number">1</span>)), nn.Flatten(), nn.Linear(<span class="hljs-number">128</span>, <span class="hljs-number">100</span>)
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        <span class="hljs-comment">## block 1</span>
        x = self.conv1(x)
        x = self.maxpool1(x)
        x = self.lrn1(x)

        <span class="hljs-comment">## block 2</span>
        x = self.conv2(x)
        x = self.conv3(x)
        x = self.lrn2(x)
        x = self.maxpool2(x)

        <span class="hljs-comment">## block 3</span>
        x = self.inception3a(x)
        x = self.inception3b(x)
        x = self.maxpool3(x)

        <span class="hljs-comment">## block 4</span>
        x = self.inception4a(x)
        <span class="hljs-keyword">if</span> self.use_aux:
            aux1 = self.aux1(x)
        x = self.inception4b(x)
        x = self.inception4c(x)
        x = self.inception4d(x)
        <span class="hljs-keyword">if</span> self.use_aux:
            aux2 = self.aux2(x)
        x = self.inception4e(x)
        x = self.maxpool4(x)

        <span class="hljs-comment">## block 5</span>
        x = self.inception5a(x)
        x = self.inception5b(x)

        <span class="hljs-comment">## block 6</span>
        x = self.avgpool(x)
        x = torch.flatten(x, <span class="hljs-number">1</span>)
        x = self.dropout(x)
        x = self.fc(x)

        <span class="hljs-keyword">if</span> self.use_aux:
            <span class="hljs-keyword">return</span> x, aux1, aux2
        <span class="hljs-keyword">else</span>:
            <span class="hljs-keyword">return</span> x`,wrap:!1}}),{c(){U=M("meta"),Jl=a(),yl=M("p"),cl=a(),J(h.$$.fragment),Tl=a(),C=M("p"),C.textContent=ms,wl=a(),J(b.$$.fragment),rl=a(),A=M("p"),A.textContent=Us,ml=a(),J(d.$$.fragment),Ul=a(),f=M("p"),f.textContent=us,ul=a(),J(x.$$.fragment),Il=a(),k=M("p"),k.textContent=Is,hl=a(),g=M("p"),g.textContent=hs,Cl=a(),v=M("p"),v.innerHTML=Cs,bl=a(),B=M("p"),B.textContent=bs,Al=a(),Q=M("p"),Q.textContent=As,dl=a(),N=M("p"),N.innerHTML=ds,fl=a(),E=M("p"),E.textContent=fs,xl=a(),G=M("p"),G.innerHTML=xs,kl=a(),Z=M("p"),Z.textContent=ks,gl=a(),z=M("p"),z.textContent=gs,vl=a(),J(D.$$.fragment),Bl=a(),S=M("p"),S.textContent=vs,Ql=a(),J(_.$$.fragment),Nl=a(),V=M("p"),V.textContent=Bs,El=a(),H=M("p"),H.textContent=Qs,Gl=a(),Y=M("p"),Y.textContent=Ns,Zl=a(),W=M("p"),W.textContent=Es,zl=a(),J(X.$$.fragment),Dl=a(),I=M("p"),ps=pl("With the introduction of compute saving"),Sl=new Ts(!1),_l=pl(" convolution and the replacement of multiple fully connected layers with average pooling, the parameters of this network are reduced significantly, which means we can add more layers and go deeper into the network. However, stacking layers can cause the problem of vanishing gradient, where the gradients get smaller and close to zero while propagating back to the initial layers of the network."),Vl=a(),R=M("p"),R.textContent=Gs,Hl=a(),F=M("p"),F.textContent=Zs,Yl=a(),y=M("ul"),L=M("li"),is=pl("An average pooling layer with"),Wl=new Ts(!1),Xl=pl(" filter size and stride 3."),os=a(),$=M("li"),ys=pl("A"),Rl=new Ts(!1),Fl=pl(" convolution with 128 filters for dimension reduction and rectified linear activation."),js=a(),al=M("li"),al.textContent=zs,Js=a(),tl=M("li"),tl.textContent=Ds,cs=a(),Ml=M("li"),Ml.textContent=Ss,Ll=a(),K=M("p"),K.textContent=_s,$l=a(),P=M("p"),P.innerHTML=Vs,Kl=a(),O=M("p"),O.textContent=Hs,Pl=a(),J(q.$$.fragment),Ol=a(),ll=M("p"),ll.textContent=Ys,ql=a(),sl=M("p"),sl.innerHTML=Ws,ls=a(),J(el.$$.fragment),ss=a(),J(nl.$$.fragment),es=a(),jl=M("p"),this.h()},l(l){const s=le("svelte-u9bgzb",document.head);U=p(s,"META",{name:!0,content:!0}),s.forEach(e),Jl=t(l),yl=p(l,"P",{}),il(yl).forEach(e),cl=t(l),c(h.$$.fragment,l),Tl=t(l),C=p(l,"P",{"data-svelte-h":!0}),i(C)!=="svelte-xslj5l"&&(C.textContent=ms),wl=t(l),c(b.$$.fragment,l),rl=t(l),A=p(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-a1s7z3"&&(A.textContent=Us),ml=t(l),c(d.$$.fragment,l),Ul=t(l),f=p(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-1v203bk"&&(f.textContent=us),ul=t(l),c(x.$$.fragment,l),Il=t(l),k=p(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-z24t8v"&&(k.textContent=Is),hl=t(l),g=p(l,"P",{"data-svelte-h":!0}),i(g)!=="svelte-7ihfvy"&&(g.textContent=hs),Cl=t(l),v=p(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-o31koc"&&(v.innerHTML=Cs),bl=t(l),B=p(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-16ratth"&&(B.textContent=bs),Al=t(l),Q=p(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1sqb65w"&&(Q.textContent=As),dl=t(l),N=p(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-12r3jjo"&&(N.innerHTML=ds),fl=t(l),E=p(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-snbukh"&&(E.textContent=fs),xl=t(l),G=p(l,"P",{"data-svelte-h":!0}),i(G)!=="svelte-hswu6s"&&(G.innerHTML=xs),kl=t(l),Z=p(l,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-10lkpf"&&(Z.textContent=ks),gl=t(l),z=p(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-tdwvb3"&&(z.textContent=gs),vl=t(l),c(D.$$.fragment,l),Bl=t(l),S=p(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1qbnxjr"&&(S.textContent=vs),Ql=t(l),c(_.$$.fragment,l),Nl=t(l),V=p(l,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1v203bk"&&(V.textContent=Bs),El=t(l),H=p(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-tsnk6g"&&(H.textContent=Qs),Gl=t(l),Y=p(l,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-12625s8"&&(Y.textContent=Ns),Zl=t(l),W=p(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-18qz3gm"&&(W.textContent=Es),zl=t(l),c(X.$$.fragment,l),Dl=t(l),I=p(l,"P",{});var as=il(I);ps=ol(as,"With the introduction of compute saving"),Sl=ws(as,!1),_l=ol(as," convolution and the replacement of multiple fully connected layers with average pooling, the parameters of this network are reduced significantly, which means we can add more layers and go deeper into the network. However, stacking layers can cause the problem of vanishing gradient, where the gradients get smaller and close to zero while propagating back to the initial layers of the network."),as.forEach(e),Vl=t(l),R=p(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-76pfk2"&&(R.textContent=Gs),Hl=t(l),F=p(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-meutr"&&(F.textContent=Zs),Yl=t(l),y=p(l,"UL",{});var j=il(y);L=p(j,"LI",{});var ts=il(L);is=ol(ts,"An average pooling layer with"),Wl=ws(ts,!1),Xl=ol(ts," filter size and stride 3."),ts.forEach(e),os=t(j),$=p(j,"LI",{});var Ms=il($);ys=ol(Ms,"A"),Rl=ws(Ms,!1),Fl=ol(Ms," convolution with 128 filters for dimension reduction and rectified linear activation."),Ms.forEach(e),js=t(j),al=p(j,"LI",{"data-svelte-h":!0}),i(al)!=="svelte-1n9c038"&&(al.textContent=zs),Js=t(j),tl=p(j,"LI",{"data-svelte-h":!0}),i(tl)!=="svelte-tksu1v"&&(tl.textContent=Ds),cs=t(j),Ml=p(j,"LI",{"data-svelte-h":!0}),i(Ml)!=="svelte-i097ho"&&(Ml.textContent=Ss),j.forEach(e),Ll=t(l),K=p(l,"P",{"data-svelte-h":!0}),i(K)!=="svelte-4uto13"&&(K.textContent=_s),$l=t(l),P=p(l,"P",{"data-svelte-h":!0}),i(P)!=="svelte-1low2wu"&&(P.innerHTML=Vs),Kl=t(l),O=p(l,"P",{"data-svelte-h":!0}),i(O)!=="svelte-5sbbdp"&&(O.textContent=Hs),Pl=t(l),c(q.$$.fragment,l),Ol=t(l),ll=p(l,"P",{"data-svelte-h":!0}),i(ll)!=="svelte-1e43aaq"&&(ll.textContent=Ys),ql=t(l),sl=p(l,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-1rdgdjr"&&(sl.innerHTML=Ws),ls=t(l),c(el.$$.fragment,l),ss=t(l),c(nl.$$.fragment,l),es=t(l),jl=p(l,"P",{}),il(jl).forEach(e),this.h()},h(){Xs(U,"name","hf:doc:metadata"),Xs(U,"content",ne),Sl.a=_l,Wl.a=Xl,Rl.a=Fl},m(l,s){o(document.head,U),n(l,Jl,s),n(l,yl,s),n(l,cl,s),T(h,l,s),n(l,Tl,s),n(l,C,s),n(l,wl,s),T(b,l,s),n(l,rl,s),n(l,A,s),n(l,ml,s),T(d,l,s),n(l,Ul,s),n(l,f,s),n(l,ul,s),T(x,l,s),n(l,Il,s),n(l,k,s),n(l,hl,s),n(l,g,s),n(l,Cl,s),n(l,v,s),n(l,bl,s),n(l,B,s),n(l,Al,s),n(l,Q,s),n(l,dl,s),n(l,N,s),n(l,fl,s),n(l,E,s),n(l,xl,s),n(l,G,s),n(l,kl,s),n(l,Z,s),n(l,gl,s),n(l,z,s),n(l,vl,s),T(D,l,s),n(l,Bl,s),n(l,S,s),n(l,Ql,s),T(_,l,s),n(l,Nl,s),n(l,V,s),n(l,El,s),n(l,H,s),n(l,Gl,s),n(l,Y,s),n(l,Zl,s),n(l,W,s),n(l,zl,s),T(X,l,s),n(l,Dl,s),n(l,I,s),o(I,ps),Sl.m(Rs,I),o(I,_l),n(l,Vl,s),n(l,R,s),n(l,Hl,s),n(l,F,s),n(l,Yl,s),n(l,y,s),o(y,L),o(L,is),Wl.m(Fs,L),o(L,Xl),o(y,os),o(y,$),o($,ys),Rl.m(Ls,$),o($,Fl),o(y,js),o(y,al),o(y,Js),o(y,tl),o(y,cs),o(y,Ml),n(l,Ll,s),n(l,K,s),n(l,$l,s),n(l,P,s),n(l,Kl,s),n(l,O,s),n(l,Pl,s),T(q,l,s),n(l,Ol,s),n(l,ll,s),n(l,ql,s),n(l,sl,s),n(l,ls,s),T(el,l,s),n(l,ss,s),T(nl,l,s),n(l,es,s),n(l,jl,s),ns=!0},p:Ks,i(l){ns||(w(h.$$.fragment,l),w(b.$$.fragment,l),w(d.$$.fragment,l),w(x.$$.fragment,l),w(D.$$.fragment,l),w(_.$$.fragment,l),w(X.$$.fragment,l),w(q.$$.fragment,l),w(el.$$.fragment,l),w(nl.$$.fragment,l),ns=!0)},o(l){r(h.$$.fragment,l),r(b.$$.fragment,l),r(d.$$.fragment,l),r(x.$$.fragment,l),r(D.$$.fragment,l),r(_.$$.fragment,l),r(X.$$.fragment,l),r(q.$$.fragment,l),r(el.$$.fragment,l),r(nl.$$.fragment,l),ns=!1},d(l){l&&(e(Jl),e(yl),e(cl),e(Tl),e(C),e(wl),e(rl),e(A),e(ml),e(Ul),e(f),e(ul),e(Il),e(k),e(hl),e(g),e(Cl),e(v),e(bl),e(B),e(Al),e(Q),e(dl),e(N),e(fl),e(E),e(xl),e(G),e(kl),e(Z),e(gl),e(z),e(vl),e(Bl),e(S),e(Ql),e(Nl),e(V),e(El),e(H),e(Gl),e(Y),e(Zl),e(W),e(zl),e(Dl),e(I),e(Vl),e(R),e(Hl),e(F),e(Yl),e(y),e(Ll),e(K),e($l),e(P),e(Kl),e(O),e(Pl),e(Ol),e(ll),e(ql),e(sl),e(ls),e(ss),e(es),e(jl)),e(U),m(h,l),m(b,l),m(d,l),m(x,l),m(D,l),m(_,l),m(X,l),m(q,l),m(el,l),m(nl,l)}}}const ne='{"title":"GoogLeNet","local":"googlenet","sections":[{"title":"Overview","local":"overview","sections":[{"title":"Architectural Innovations","local":"architectural-innovations","sections":[{"title":"The Inception “Network In Network” Module","local":"the-inception-network-in-network-module","sections":[],"depth":4},{"title":"Average Pooling","local":"average-pooling","sections":[],"depth":4}],"depth":3},{"title":"Architectural Innovations","local":"architectural-innovations","sections":[{"title":"Auxiliary Classifiers","local":"auxiliary-classifiers","sections":[],"depth":4}],"depth":3},{"title":"Architecture - GoogLeNet","local":"architecture---googlenet","sections":[],"depth":3},{"title":"Code","local":"code","sections":[],"depth":3}],"depth":2}],"depth":1}';function ae(rs){return Ps(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class oe extends Os{constructor(U){super(),qs(this,U,ae,ee,$s,{})}}export{oe as component};
