import{s as ps,n as rs,o as _s}from"../chunks/scheduler.7bc62968.js";import{S as hs,i as fs,g as o,s as n,r as X,m as ns,A as Ms,h as i,f as s,c as a,j as as,u as x,x as p,n as os,k as r,y as cs,a as l,v as J,d as Q,t as I,w as k}from"../chunks/index.2f8492b0.js";import{C as is}from"../chunks/CodeBlock.4e96d6f7.js";import{H as Me}from"../chunks/Heading.14fb2476.js";function us(ut){let _,we,ce,ge,b,ye,N,me,A,wt=`Convolution is an operation used to extract features from data. The data can be 1D, 2D or 3D. We’ll explain the operation with a solid example. All you need to know now is that the operation simply takes a matrix made of numbers, moves it through the data, and takes the sum of products between the data and that matrix. This matrix is called kernel or filter. You might say, “What does it have to do with the feature extraction, and how am I supposed to apply it?
Don’t panic! We’re getting to it.`,ve,D,gt="To illustrate the intuition, let’s take a look at this example. We have this 1D data, and we visualize it. Visualization will help understand the effects of convolution operation.",Ce,h,yt='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/CNNs/kernel_image.png" alt="Kernel Image"/>',de,$,mt="We have this kernel [-1, 1]. We’ll start from the left-most element, put the kernel, multiply the overlapping numbers, and sum them up. Kernels have centers; it’s one of the elements. Here, we pick the center as 1 (the element on the right). We picked the center here as 1, assuming an imaginary zero on the left, it is called a pad, you will see later on. Now, the kernel’s center has to touch every single element, so we put a zero to the left of the element for convenience. If we don’t pad it, I’ll have to start multiplying -1 with the left-most element, and 1 will not touch the left-most element, so we apply padding. Let’s see what it looks like.",je,f,vt='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/CNNs/1d_conv.jpg" alt="1D Conv"/>',Te,z,Ct="I’m multiplying the left-most element (that is currently a pad) with -1, and the first element (zero) with 1 and sum them up, get a 0, and note it down. Now, we’ll move the kernel by one position and do the same. Note it down again, this movement is called striding, this is usually done by moving the kernel by one pixel. You can also move it with more pixels. The result (convolved data) is currently an array [0, 0].",Ue,M,dt='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/CNNs/1d_conv_multiplication.png" alt="1D Conv Multiplication"/>',Xe,P,jt="We will repeat it until the right element of the kernel touches every element, which yields the below result.",xe,c,Tt='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/CNNs/1d_conv_result.png" alt="1D Conv Result"/>',Je,L,Ut="Notice anything? The filter gives the rate of change in the data (the derivatives!). This is one characteristic we could extract from our data. Let’s visualize it.",Qe,u,Xt='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/CNNs/convolved_illustrated.png" alt="Convolved Illustrated"/>',Ie,B,xt="The convolved data (the result of the convolution) is called a feature map. And it makes sense, as it shows the features we can extract, the characteristics related to the data, and the rate of change.",ke,H,Jt="This is exactly what edge detection filters do! Let’s see it in 2-dimensional data. This time, our kernel will be different. It will be a 3x3 kernel (just so you know it could’ve been a 2x2 too).",be,w,Qt='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/CNNs/2d_conv.png" alt="2D Conv"/>',Ne,W,It="This filter is actually quite famous, but we won’t spoil it for you now :). The previous filter was [-1 1]. Meanwhile, this one is [-1 0 1]. It’s just of shape 3x3 and nothing different, and it shows increments and decrements on the horizontal axis. Let’s see an example and apply convolution. Below is our 2D data.",Ae,g,kt='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/CNNs/2d_conv_matrix.png" alt="2D Conv"/>',De,E,bt="Think of this as an image, and we want to extract the horizontal changes. Now, the center of the filter has to touch every single pixel, so we pad the image.",$e,y,Nt='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/CNNs/padding.png" alt="Padding"/>',ze,F,At="The feature map will be the same size as the original data. The result of the convolution will be written to the same position that the center of the kernel touched in the original matrix, meaning, for this one, it will touch the leftmost and the top positions.",Pe,m,Dt='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/CNNs/2d_conv_illustrated.png" alt="2D Conv"/>',Le,V,$t="If we keep applying the convolution, we get the following feature map.",Be,v,zt='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/CNNs/2d-feature_map.png" alt="2D Feature Map"/>',He,S,Pt="Which shows us the horizontal changes (the edges). This filter is actually called the Prewitt Filter.",We,C,Lt='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/CNNs/prewitt_sobel.png" alt="Prewitt and Sobel"/>',Ee,G,Bt='You can flip <a href="https://en.wikipedia.org/wiki/Prewitt_operator" rel="nofollow">the Prewitt filter</a> to get the changes in vertical direction. <a href="https://en.wikipedia.org/wiki/Sobel_operator" rel="nofollow">The Sobel filter</a> is another famous filter for edge detection.',Fe,K,Ve,Y,Ht="Fine, but what does it have to do with deep learning? Well, brute forcing filters to extract features does not work well with every image. Imagine if we could somehow find the optimal filters to extract important information or even detect objects in the images. That’s where convolutional neural networks come into play. We convolve images with various filters, and these pixels in the feature maps will eventually become the parameters that we will optimize, and in the end, we will find the best filters for our problem.",Se,Z,Wt="The idea is, that we will use filters to extract information. We will randomly initialize multiple filters, create our feature maps, feed them to a classifier, and do backpropagation. Before diving into it, I’d like to introduce you to something we call “pooling”.",Ge,q,Et="As you can see above, there are many pixels that show the change in the feature map. To know that there’s an edge, we only need to see that there’s a change (an edge, a corner, anything), and that’s it.",Ke,d,Ft='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/CNNs/max_pooling.png" alt="Pooling"/>',Ye,R,Vt="In the above example, we could have got only one of the two, and that would be enough. This way, we would store fewer parameters and still have the features. This operation of getting the most important element in the feature map is called pooling. With pooling, we lose the exact pixel location of where there’s an edge but we store fewer parameters. Also, this way, our feature extraction mechanism will be more robust to small changes, e.g., we only need to know that there are two eyes, a nose, and a mouth to know that there’s a face in an image, the distance between those elements and the size of those elements tend to change from face to face, and pooling enables the model to be more robust against these changes. Another good thing about pooling is that it helps us handle varying input sizes. We’d like you to watch this video to gain a better intuition. Below is the max pooling operation, where every four pixels, we get the maximum pixel. There are various types of pooling, e.g., average pooling, weighted pooling, or L2 pooling.",Ze,O,St="Let’s build a simple CNN architecture. We will use a Keras example (for the sake of illustration) and we will walk you through what’s happening. Below is our model (again, don’t panic, we will walk you through what’s happening).",qe,ee,Gt="If you don’t know what Keras Sequential API is doing, it stacks layers like lego bricks and connects them. Each layer has different hyperparameters, the Conv2D layer takes a number of convolution filters, kernel size, and activation function, while MaxPooling2D takes pooling size, and the dense layer takes a number of output units (again, don’t panic).",Re,te,Kt="Most of the convnet implementations don’t do padding for the sake of letting the kernel touch every pixel in an image processing fashion. Padding with zeroes comes with an assumption that we might have features in borders, and it adds complexity for calculation on top. That’s why you see that the first input size is (26,26), we lose information along the borders.",Oe,se,et,le,tt,ne,Yt="Convolutional neural networks start with an input layer and a convolutional layer. Keras Conv2D layers take a number of kernels and the size of the kernel as parameters. What’s happening is illustrated below. Here, we convolve the image with 32 kernels and end up with 32 feature maps, each having the size of the image.",st,j,Zt='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/CNNs/network_illustration.png" alt="Network"/>',lt,ae,qt="After convolutional layers, we put a max pooling layer to reduce the number of parameters stored and make the model robust to the changes, as discussed above. This will reduce the number of parameters calculated.",nt,T,Rt='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/CNNs/network_illustration_2.png" alt="Network"/>',at,U,Ot='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/CNNs/network_illustration_3.png" alt="Network"/>',ot,oe,it,ie,es="How does the backpropagation work here? We want to optimize for the best kernel values here, so they’re our weights. In the end, we expect the classifier to figure out the relationship between pixel values, kernels, and classes. Thus, we have a very long flattened array consisting of elements that are pooled and activated versions of pixels convolved with initial weights (the kernel elements). We update those weights such that we answer the question “which kernels should I apply to make a distinction between cat and a dog photo?”. The point of training CNNs is to come up with the optimal kernels, and these are found using backpropagation. Prior to CNNs, people would try to try a lot of filters on an image to extract features themselves, meanwhile most generic filters (as we’ve seen above, e.g., Prewitt or Sobel) do not necessarily work for all images given images can be very different, even in the same dataset. This is why CNNs outperform traditional image processing techniques.",pt,pe,ts="There are a couple of advantages by means of storage when we use convolutional neural networks.",rt,re,_t,_e,ss="In convolutional neural networks, we convolve with the same filter across all pixels, all channels, and all images which provides an advantage over storing parameters, this is much more efficient than going through an image with a dense neural network. This is called “weight tying” and those weights are called “tied weights”. This is also seen in autoencoders.",ht,he,ft,fe,ls="In densely connected neural networks, we input the whole piece of data at once -which is very overwhelming due to how images have hundreds or thousands of pixels-, meanwhile in convnets, we have smaller kernels that we use to extract features. This is called sparse interaction, and it helps us use less memory.",Mt,ue,ct;return b=new Me({props:{title:"Introduction to Convolutional Neural Networks",local:"introduction-to-convolutional-neural-networks",headingTag:"h1"}}),N=new Me({props:{title:"Convolution: Basic Ideas",local:"convolution-basic-ideas",headingTag:"h2"}}),K=new Me({props:{title:"Convolutional Neural Networks",local:"convolutional-neural-networks",headingTag:"h2"}}),se=new is({props:{code:"bW9kZWwlMjAlM0QlMjBrZXJhcy5TZXF1ZW50aWFsKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGtlcmFzLklucHV0KHNoYXBlJTNEaW5wdXRfc2hhcGUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGF5ZXJzLkNvbnYyRCgzMiUyQyUyMGtlcm5lbF9zaXplJTNEKDMlMkMlMjAzKSUyQyUyMGFjdGl2YXRpb24lM0QlMjJyZWx1JTIyKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVycy5NYXhQb29saW5nMkQocG9vbF9zaXplJTNEKDIlMkMlMjAyKSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYXllcnMuQ29udjJEKDY0JTJDJTIwa2VybmVsX3NpemUlM0QoMyUyQyUyMDMpJTJDJTIwYWN0aXZhdGlvbiUzRCUyMnJlbHUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGF5ZXJzLk1heFBvb2xpbmcyRChwb29sX3NpemUlM0QoMiUyQyUyMDIpKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVycy5GbGF0dGVuKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYXllcnMuRHJvcG91dCgwLjUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGF5ZXJzLkRlbnNlKG51bV9jbGFzc2VzJTJDJTIwYWN0aXZhdGlvbiUzRCUyMnNvZnRtYXglMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKSUwQW1vZGVsLnN1bW1hcnkoKQ==",highlighted:`model = keras.Sequential(
    [
        keras.Input(shape=input_shape),
        layers.Conv2D(<span class="hljs-number">32</span>, kernel_size=(<span class="hljs-number">3</span>, <span class="hljs-number">3</span>), activation=<span class="hljs-string">&quot;relu&quot;</span>),
        layers.MaxPooling2D(pool_size=(<span class="hljs-number">2</span>, <span class="hljs-number">2</span>)),
        layers.Conv2D(<span class="hljs-number">64</span>, kernel_size=(<span class="hljs-number">3</span>, <span class="hljs-number">3</span>), activation=<span class="hljs-string">&quot;relu&quot;</span>),
        layers.MaxPooling2D(pool_size=(<span class="hljs-number">2</span>, <span class="hljs-number">2</span>)),
        layers.Flatten(),
        layers.Dropout(<span class="hljs-number">0.5</span>),
        layers.Dense(num_classes, activation=<span class="hljs-string">&quot;softmax&quot;</span>),
    ]
)
model.summary()`,wrap:!1}}),le=new is({props:{code:"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",highlighted:`Model: &quot;sequential&quot;
<span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span>_
<span class="hljs-section">Layer (type)                 Output Shape              Param #   
=================================================================</span>
conv2d (Conv2D)              (None, 26, 26, 32)        320       
<span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span>_
max<span class="hljs-emphasis">_pooling2d (MaxPooling2D) (None, 13, 13, 32)        0         
<span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span>_</span>
conv2d<span class="hljs-emphasis">_1 (Conv2D)            (None, 11, 11, 64)        18496     
<span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span>_</span>
max<span class="hljs-emphasis">_pooling2d_</span>1 (MaxPooling2 (None, 5, 5, 64)          0         
<span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span>_
flatten (Flatten)            (None, 1600)              0         
<span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span>_
dropout (Dropout)            (None, 1600)              0         
<span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span>_
<span class="hljs-section">dense (Dense)                (None, 10)                16010     
=================================================================</span>
Total params: 34,826
Trainable params: 34,826
Non-trainable params: 0
<span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-emphasis">_</span>`,wrap:!1}}),oe=new Me({props:{title:"Backpropagation in Convolutional Neural Networks in Theory",local:"backpropagation-in-convolutional-neural-networks-in-theory",headingTag:"h3"}}),re=new Me({props:{title:"Parameter sharing",local:"parameter-sharing",headingTag:"h3"}}),he=new Me({props:{title:"Sparse Interactions",local:"sparse-interactions",headingTag:"h3"}}),{c(){_=o("meta"),we=n(),ce=o("p"),ge=n(),X(b.$$.fragment),ye=n(),X(N.$$.fragment),me=n(),A=o("p"),A.textContent=wt,ve=n(),D=o("p"),D.textContent=gt,Ce=n(),h=o("div"),h.innerHTML=yt,de=n(),$=o("p"),$.textContent=mt,je=n(),f=o("div"),f.innerHTML=vt,Te=n(),z=o("p"),z.textContent=Ct,Ue=n(),M=o("div"),M.innerHTML=dt,Xe=n(),P=o("p"),P.textContent=jt,xe=n(),c=o("div"),c.innerHTML=Tt,Je=n(),L=o("p"),L.textContent=Ut,Qe=n(),u=o("div"),u.innerHTML=Xt,Ie=n(),B=o("p"),B.textContent=xt,ke=n(),H=o("p"),H.textContent=Jt,be=n(),w=o("div"),w.innerHTML=Qt,Ne=n(),W=o("p"),W.textContent=It,Ae=n(),g=o("div"),g.innerHTML=kt,De=n(),E=o("p"),E.textContent=bt,$e=n(),y=o("div"),y.innerHTML=Nt,ze=n(),F=o("p"),F.textContent=At,Pe=n(),m=o("div"),m.innerHTML=Dt,Le=n(),V=o("p"),V.textContent=$t,Be=n(),v=o("div"),v.innerHTML=zt,He=n(),S=o("p"),S.textContent=Pt,We=n(),C=o("div"),C.innerHTML=Lt,Ee=n(),G=o("p"),G.innerHTML=Bt,Fe=n(),X(K.$$.fragment),Ve=n(),Y=o("p"),Y.textContent=Ht,Se=n(),Z=o("p"),Z.textContent=Wt,Ge=n(),q=o("p"),q.textContent=Et,Ke=n(),d=o("div"),d.innerHTML=Ft,Ye=n(),R=o("p"),R.textContent=Vt,Ze=n(),O=o("p"),O.textContent=St,qe=n(),ee=o("p"),ee.textContent=Gt,Re=n(),te=o("p"),te.textContent=Kt,Oe=n(),X(se.$$.fragment),et=n(),X(le.$$.fragment),tt=n(),ne=o("p"),ne.textContent=Yt,st=n(),j=o("div"),j.innerHTML=Zt,lt=n(),ae=o("p"),ae.textContent=qt,nt=n(),T=o("div"),T.innerHTML=Rt,at=ns(`
Then, these feature maps are concatenated together and flattened.
`),U=o("div"),U.innerHTML=Ot,ot=ns(`
Later on, we use something called dropout to drop a portion of parameters to avoid overfitting. Finally, the final form of weights will go through a dense layer to get classified and backpropagation will take place.
`),X(oe.$$.fragment),it=n(),ie=o("p"),ie.textContent=es,pt=n(),pe=o("p"),pe.textContent=ts,rt=n(),X(re.$$.fragment),_t=n(),_e=o("p"),_e.textContent=ss,ht=n(),X(he.$$.fragment),ft=n(),fe=o("p"),fe.textContent=ls,Mt=n(),ue=o("p"),this.h()},l(e){const t=Ms("svelte-u9bgzb",document.head);_=i(t,"META",{name:!0,content:!0}),t.forEach(s),we=a(e),ce=i(e,"P",{}),as(ce).forEach(s),ge=a(e),x(b.$$.fragment,e),ye=a(e),x(N.$$.fragment,e),me=a(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-js1wle"&&(A.textContent=wt),ve=a(e),D=i(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1ux31d8"&&(D.textContent=gt),Ce=a(e),h=i(e,"DIV",{class:!0,"data-svelte-h":!0}),p(h)!=="svelte-j86518"&&(h.innerHTML=yt),de=a(e),$=i(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-bgkhoi"&&($.textContent=mt),je=a(e),f=i(e,"DIV",{class:!0,"data-svelte-h":!0}),p(f)!=="svelte-1tp3zli"&&(f.innerHTML=vt),Te=a(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-qr4ipf"&&(z.textContent=Ct),Ue=a(e),M=i(e,"DIV",{class:!0,"data-svelte-h":!0}),p(M)!=="svelte-jflkbb"&&(M.innerHTML=dt),Xe=a(e),P=i(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-l50d3w"&&(P.textContent=jt),xe=a(e),c=i(e,"DIV",{class:!0,"data-svelte-h":!0}),p(c)!=="svelte-1e1de3x"&&(c.innerHTML=Tt),Je=a(e),L=i(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1c6lnzy"&&(L.textContent=Ut),Qe=a(e),u=i(e,"DIV",{class:!0,"data-svelte-h":!0}),p(u)!=="svelte-mktq3s"&&(u.innerHTML=Xt),Ie=a(e),B=i(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1je5z3e"&&(B.textContent=xt),ke=a(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-81pbi9"&&(H.textContent=Jt),be=a(e),w=i(e,"DIV",{class:!0,"data-svelte-h":!0}),p(w)!=="svelte-1xoh2ju"&&(w.innerHTML=Qt),Ne=a(e),W=i(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-7tiixt"&&(W.textContent=It),Ae=a(e),g=i(e,"DIV",{class:!0,"data-svelte-h":!0}),p(g)!=="svelte-15q22x2"&&(g.innerHTML=kt),De=a(e),E=i(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-h89lro"&&(E.textContent=bt),$e=a(e),y=i(e,"DIV",{class:!0,"data-svelte-h":!0}),p(y)!=="svelte-vfwqx9"&&(y.innerHTML=Nt),ze=a(e),F=i(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-t7bv9p"&&(F.textContent=At),Pe=a(e),m=i(e,"DIV",{class:!0,"data-svelte-h":!0}),p(m)!=="svelte-8gj7o8"&&(m.innerHTML=Dt),Le=a(e),V=i(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-10c7o21"&&(V.textContent=$t),Be=a(e),v=i(e,"DIV",{class:!0,"data-svelte-h":!0}),p(v)!=="svelte-zgwf19"&&(v.innerHTML=zt),He=a(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1i0lgcz"&&(S.textContent=Pt),We=a(e),C=i(e,"DIV",{class:!0,"data-svelte-h":!0}),p(C)!=="svelte-1yo4kb7"&&(C.innerHTML=Lt),Ee=a(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1hzskr6"&&(G.innerHTML=Bt),Fe=a(e),x(K.$$.fragment,e),Ve=a(e),Y=i(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-4b3wij"&&(Y.textContent=Ht),Se=a(e),Z=i(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1bwr5lk"&&(Z.textContent=Wt),Ge=a(e),q=i(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-uobelj"&&(q.textContent=Et),Ke=a(e),d=i(e,"DIV",{class:!0,"data-svelte-h":!0}),p(d)!=="svelte-1n9bk6y"&&(d.innerHTML=Ft),Ye=a(e),R=i(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1bbyip8"&&(R.textContent=Vt),Ze=a(e),O=i(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-125rfo9"&&(O.textContent=St),qe=a(e),ee=i(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-mkpmog"&&(ee.textContent=Gt),Re=a(e),te=i(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-7oa27"&&(te.textContent=Kt),Oe=a(e),x(se.$$.fragment,e),et=a(e),x(le.$$.fragment,e),tt=a(e),ne=i(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-epav3e"&&(ne.textContent=Yt),st=a(e),j=i(e,"DIV",{class:!0,"data-svelte-h":!0}),p(j)!=="svelte-1t03irm"&&(j.innerHTML=Zt),lt=a(e),ae=i(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-itm15h"&&(ae.textContent=qt),nt=a(e),T=i(e,"DIV",{class:!0,"data-svelte-h":!0}),p(T)!=="svelte-x94ptb"&&(T.innerHTML=Rt),at=os(e,`
Then, these feature maps are concatenated together and flattened.
`),U=i(e,"DIV",{class:!0,"data-svelte-h":!0}),p(U)!=="svelte-aeapfs"&&(U.innerHTML=Ot),ot=os(e,`
Later on, we use something called dropout to drop a portion of parameters to avoid overfitting. Finally, the final form of weights will go through a dense layer to get classified and backpropagation will take place.
`),x(oe.$$.fragment,e),it=a(e),ie=i(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-19vtkdl"&&(ie.textContent=es),pt=a(e),pe=i(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-y803lj"&&(pe.textContent=ts),rt=a(e),x(re.$$.fragment,e),_t=a(e),_e=i(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-p7dm8c"&&(_e.textContent=ss),ht=a(e),x(he.$$.fragment,e),ft=a(e),fe=i(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-1wtxxcv"&&(fe.textContent=ls),Mt=a(e),ue=i(e,"P",{}),as(ue).forEach(s),this.h()},h(){r(_,"name","hf:doc:metadata"),r(_,"content",ws),r(h,"class","flex justify-center"),r(f,"class","flex justify-center"),r(M,"class","flex justify-center"),r(c,"class","flex justify-center"),r(u,"class","flex justify-center"),r(w,"class","flex justify-center"),r(g,"class","flex justify-center"),r(y,"class","flex justify-center"),r(m,"class","flex justify-center"),r(v,"class","flex justify-center"),r(C,"class","flex justify-center"),r(d,"class","flex justify-center"),r(j,"class","flex justify-center"),r(T,"class","flex justify-center"),r(U,"class","flex justify-center")},m(e,t){cs(document.head,_),l(e,we,t),l(e,ce,t),l(e,ge,t),J(b,e,t),l(e,ye,t),J(N,e,t),l(e,me,t),l(e,A,t),l(e,ve,t),l(e,D,t),l(e,Ce,t),l(e,h,t),l(e,de,t),l(e,$,t),l(e,je,t),l(e,f,t),l(e,Te,t),l(e,z,t),l(e,Ue,t),l(e,M,t),l(e,Xe,t),l(e,P,t),l(e,xe,t),l(e,c,t),l(e,Je,t),l(e,L,t),l(e,Qe,t),l(e,u,t),l(e,Ie,t),l(e,B,t),l(e,ke,t),l(e,H,t),l(e,be,t),l(e,w,t),l(e,Ne,t),l(e,W,t),l(e,Ae,t),l(e,g,t),l(e,De,t),l(e,E,t),l(e,$e,t),l(e,y,t),l(e,ze,t),l(e,F,t),l(e,Pe,t),l(e,m,t),l(e,Le,t),l(e,V,t),l(e,Be,t),l(e,v,t),l(e,He,t),l(e,S,t),l(e,We,t),l(e,C,t),l(e,Ee,t),l(e,G,t),l(e,Fe,t),J(K,e,t),l(e,Ve,t),l(e,Y,t),l(e,Se,t),l(e,Z,t),l(e,Ge,t),l(e,q,t),l(e,Ke,t),l(e,d,t),l(e,Ye,t),l(e,R,t),l(e,Ze,t),l(e,O,t),l(e,qe,t),l(e,ee,t),l(e,Re,t),l(e,te,t),l(e,Oe,t),J(se,e,t),l(e,et,t),J(le,e,t),l(e,tt,t),l(e,ne,t),l(e,st,t),l(e,j,t),l(e,lt,t),l(e,ae,t),l(e,nt,t),l(e,T,t),l(e,at,t),l(e,U,t),l(e,ot,t),J(oe,e,t),l(e,it,t),l(e,ie,t),l(e,pt,t),l(e,pe,t),l(e,rt,t),J(re,e,t),l(e,_t,t),l(e,_e,t),l(e,ht,t),J(he,e,t),l(e,ft,t),l(e,fe,t),l(e,Mt,t),l(e,ue,t),ct=!0},p:rs,i(e){ct||(Q(b.$$.fragment,e),Q(N.$$.fragment,e),Q(K.$$.fragment,e),Q(se.$$.fragment,e),Q(le.$$.fragment,e),Q(oe.$$.fragment,e),Q(re.$$.fragment,e),Q(he.$$.fragment,e),ct=!0)},o(e){I(b.$$.fragment,e),I(N.$$.fragment,e),I(K.$$.fragment,e),I(se.$$.fragment,e),I(le.$$.fragment,e),I(oe.$$.fragment,e),I(re.$$.fragment,e),I(he.$$.fragment,e),ct=!1},d(e){e&&(s(we),s(ce),s(ge),s(ye),s(me),s(A),s(ve),s(D),s(Ce),s(h),s(de),s($),s(je),s(f),s(Te),s(z),s(Ue),s(M),s(Xe),s(P),s(xe),s(c),s(Je),s(L),s(Qe),s(u),s(Ie),s(B),s(ke),s(H),s(be),s(w),s(Ne),s(W),s(Ae),s(g),s(De),s(E),s($e),s(y),s(ze),s(F),s(Pe),s(m),s(Le),s(V),s(Be),s(v),s(He),s(S),s(We),s(C),s(Ee),s(G),s(Fe),s(Ve),s(Y),s(Se),s(Z),s(Ge),s(q),s(Ke),s(d),s(Ye),s(R),s(Ze),s(O),s(qe),s(ee),s(Re),s(te),s(Oe),s(et),s(tt),s(ne),s(st),s(j),s(lt),s(ae),s(nt),s(T),s(at),s(U),s(ot),s(it),s(ie),s(pt),s(pe),s(rt),s(_t),s(_e),s(ht),s(ft),s(fe),s(Mt),s(ue)),s(_),k(b,e),k(N,e),k(K,e),k(se,e),k(le,e),k(oe,e),k(re,e),k(he,e)}}}const ws='{"title":"Introduction to Convolutional Neural Networks","local":"introduction-to-convolutional-neural-networks","sections":[{"title":"Convolution: Basic Ideas","local":"convolution-basic-ideas","sections":[],"depth":2},{"title":"Convolutional Neural Networks","local":"convolutional-neural-networks","sections":[{"title":"Backpropagation in Convolutional Neural Networks in Theory","local":"backpropagation-in-convolutional-neural-networks-in-theory","sections":[],"depth":3},{"title":"Parameter sharing","local":"parameter-sharing","sections":[],"depth":3},{"title":"Sparse Interactions","local":"sparse-interactions","sections":[],"depth":3}],"depth":2}],"depth":1}';function gs(ut){return _s(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ds extends hs{constructor(_){super(),fs(this,_,gs,us,ps,{})}}export{ds as component};
