import{s as K,n as F,o as P}from"../chunks/scheduler.7bc62968.js";import{S as O,i as q,g as c,s as e,r as C,A as ll,h as m,f as M,c as a,j as H,u as o,x as z,k as Y,y as sl,a as n,v as u,d as h,t as A,w as b}from"../chunks/index.2f8492b0.js";import{C as Ml}from"../chunks/CodeBlock.4e96d6f7.js";import{H as B}from"../chunks/Heading.14fb2476.js";function nl(_){let y,f,d,G,J,Q,T,g,t,X="The VGG architecture was developed in 2014 by Karen Simonyan and Andrew Zisserman from the Visual Geometry Group -and hence named VGG- at Oxford University. The model demonstrated significant improvements over the past models at that time- to be specific 2014 Imagenet challange also known as ILSVRC.",x,U,Z,w,W="<li>Inputs are 224x224 images.</li> <li>Convolution kernel shape is (3,3) and max pooling window shape is (2,2).</li> <li>Number of channels for each convolutional layer 64 -&gt; 128 -&gt; 256 -&gt; 512 -&gt; 512.</li> <li>VGG16 has 16 hidden layers (13 convolutional layers and 3 fully connected layers).</li> <li>VGG19 has 19 hidden layers (16 convolutional layers and 3 fully connected layers).</li>",V,j,S,p,$="<li>VGG (16 or 19 layers) was relatively deeper than other SOTA networks at the time. AlexNet, the winning model for ILSVRC 2012 only has 8 layers.</li> <li>Multiple small (3X3) receptive field filters with ReLU activation instead of one large (7X7 or 11X11) filter lead to better learning of complex features. Smaller filters also mean fewer parameters per layer, with additional nonlinearity introduced in between.</li> <li>Multiscale training and inference. Each image was trained in multiple rounds with varying scales to ensure similar characteristics were captured at different sizes.</li> <li>Consistency and simplicity of the VGG network make it easier to scale or modify for future improvements.</li>",R,i,v,r,L="Below you can find the PyTorch implementation of VGG19.",N,I,D,k,E;return J=new B({props:{title:"Very Deep Convolutional Networks for Large Scale Image Recognition (2014)",local:"very-deep-convolutional-networks-for-large-scale-image-recognition-2014",headingTag:"h1"}}),T=new B({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),U=new B({props:{title:"VGG Network Architechture",local:"vgg-network-architechture",headingTag:"h2"}}),j=new B({props:{title:"Key Comparisons",local:"key-comparisons",headingTag:"h2"}}),i=new B({props:{title:"PyTorch Example",local:"pytorch-example",headingTag:"h2"}}),I=new Ml({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn


<span class="hljs-keyword">class</span> <span class="hljs-title class_">VGG19</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, num_classes=<span class="hljs-number">1000</span></span>):
        <span class="hljs-built_in">super</span>(VGG19, self).__init__()

        <span class="hljs-comment"># Feature extraction layers: Convolutional and pooling layers</span>
        self.feature_extractor = nn.Sequential(
            nn.Conv2d(
                <span class="hljs-number">3</span>, <span class="hljs-number">64</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>
            ),  <span class="hljs-comment"># 3 input channels, 64 output channels, 3x3 kernel, 1 padding</span>
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">64</span>, <span class="hljs-number">64</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.MaxPool2d(
                kernel_size=<span class="hljs-number">2</span>, stride=<span class="hljs-number">2</span>
            ),  <span class="hljs-comment"># Max pooling with 2x2 kernel and stride 2</span>
            nn.Conv2d(<span class="hljs-number">64</span>, <span class="hljs-number">128</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">128</span>, <span class="hljs-number">128</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.MaxPool2d(kernel_size=<span class="hljs-number">2</span>, stride=<span class="hljs-number">2</span>),
            nn.Conv2d(<span class="hljs-number">128</span>, <span class="hljs-number">256</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">256</span>, <span class="hljs-number">256</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">256</span>, <span class="hljs-number">256</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">256</span>, <span class="hljs-number">256</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.MaxPool2d(kernel_size=<span class="hljs-number">2</span>, stride=<span class="hljs-number">2</span>),
            nn.Conv2d(<span class="hljs-number">256</span>, <span class="hljs-number">512</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.Conv2d(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, kernel_size=<span class="hljs-number">3</span>, padding=<span class="hljs-number">1</span>),
            nn.ReLU(),
            nn.MaxPool2d(kernel_size=<span class="hljs-number">2</span>, stride=<span class="hljs-number">2</span>),
        )

        <span class="hljs-comment"># Fully connected layers for classification</span>
        self.classifier = nn.Sequential(
            nn.Linear(
                <span class="hljs-number">512</span> * <span class="hljs-number">7</span> * <span class="hljs-number">7</span>, <span class="hljs-number">4096</span>
            ),  <span class="hljs-comment"># 512 channels, 7x7 spatial dimensions after max pooling</span>
            nn.ReLU(),
            nn.Dropout(<span class="hljs-number">0.5</span>),  <span class="hljs-comment"># Dropout layer with 0.5 dropout probability</span>
            nn.Linear(<span class="hljs-number">4096</span>, <span class="hljs-number">4096</span>),
            nn.ReLU(),
            nn.Dropout(<span class="hljs-number">0.5</span>),
            nn.Linear(<span class="hljs-number">4096</span>, num_classes),  <span class="hljs-comment"># Output layer with &#x27;num_classes&#x27; output units</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = self.feature_extractor(x)  <span class="hljs-comment"># Pass input through the feature extractor layers</span>
        x = x.view(x.size(<span class="hljs-number">0</span>), -<span class="hljs-number">1</span>)  <span class="hljs-comment"># Flatten the output for the fully connected layers</span>
        x = self.classifier(x)  <span class="hljs-comment"># Pass flattened output through the classifier layers</span>
        <span class="hljs-keyword">return</span> x`,wrap:!1}}),{c(){y=c("meta"),f=e(),d=c("p"),G=e(),C(J.$$.fragment),Q=e(),C(T.$$.fragment),g=e(),t=c("p"),t.textContent=X,x=e(),C(U.$$.fragment),Z=e(),w=c("ul"),w.innerHTML=W,V=e(),C(j.$$.fragment),S=e(),p=c("ul"),p.innerHTML=$,R=e(),C(i.$$.fragment),v=e(),r=c("p"),r.textContent=L,N=e(),C(I.$$.fragment),D=e(),k=c("p"),this.h()},l(l){const s=ll("svelte-u9bgzb",document.head);y=m(s,"META",{name:!0,content:!0}),s.forEach(M),f=a(l),d=m(l,"P",{}),H(d).forEach(M),G=a(l),o(J.$$.fragment,l),Q=a(l),o(T.$$.fragment,l),g=a(l),t=m(l,"P",{"data-svelte-h":!0}),z(t)!=="svelte-13pxk3z"&&(t.textContent=X),x=a(l),o(U.$$.fragment,l),Z=a(l),w=m(l,"UL",{"data-svelte-h":!0}),z(w)!=="svelte-1rax18l"&&(w.innerHTML=W),V=a(l),o(j.$$.fragment,l),S=a(l),p=m(l,"UL",{"data-svelte-h":!0}),z(p)!=="svelte-qri0w"&&(p.innerHTML=$),R=a(l),o(i.$$.fragment,l),v=a(l),r=m(l,"P",{"data-svelte-h":!0}),z(r)!=="svelte-1i2dftw"&&(r.textContent=L),N=a(l),o(I.$$.fragment,l),D=a(l),k=m(l,"P",{}),H(k).forEach(M),this.h()},h(){Y(y,"name","hf:doc:metadata"),Y(y,"content",el)},m(l,s){sl(document.head,y),n(l,f,s),n(l,d,s),n(l,G,s),u(J,l,s),n(l,Q,s),u(T,l,s),n(l,g,s),n(l,t,s),n(l,x,s),u(U,l,s),n(l,Z,s),n(l,w,s),n(l,V,s),u(j,l,s),n(l,S,s),n(l,p,s),n(l,R,s),u(i,l,s),n(l,v,s),n(l,r,s),n(l,N,s),u(I,l,s),n(l,D,s),n(l,k,s),E=!0},p:F,i(l){E||(h(J.$$.fragment,l),h(T.$$.fragment,l),h(U.$$.fragment,l),h(j.$$.fragment,l),h(i.$$.fragment,l),h(I.$$.fragment,l),E=!0)},o(l){A(J.$$.fragment,l),A(T.$$.fragment,l),A(U.$$.fragment,l),A(j.$$.fragment,l),A(i.$$.fragment,l),A(I.$$.fragment,l),E=!1},d(l){l&&(M(f),M(d),M(G),M(Q),M(g),M(t),M(x),M(Z),M(w),M(V),M(S),M(p),M(R),M(v),M(r),M(N),M(D),M(k)),M(y),b(J,l),b(T,l),b(U,l),b(j,l),b(i,l),b(I,l)}}}const el='{"title":"Very Deep Convolutional Networks for Large Scale Image Recognition (2014)","local":"very-deep-convolutional-networks-for-large-scale-image-recognition-2014","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"VGG Network Architechture","local":"vgg-network-architechture","sections":[],"depth":2},{"title":"Key Comparisons","local":"key-comparisons","sections":[],"depth":2},{"title":"PyTorch Example","local":"pytorch-example","sections":[],"depth":2}],"depth":1}';function al(_){return P(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ul extends O{constructor(y){super(),q(this,y,al,nl,K,{})}}export{Ul as component};
