import{s as dt,f as ct,n as ht,o as ut}from"../chunks/scheduler.7bc62968.js";import{S as ft,i as Mt,g as n,s as l,r as u,m as xe,H as wt,A as gt,h as o,f as a,c as i,j as Se,u as f,x as r,n as _e,B as yt,k as M,y as A,a as s,v as w,d as g,t as y,w as J}from"../chunks/index.2f8492b0.js";import{C as Fe}from"../chunks/CodeBlock.4e96d6f7.js";import{H as He}from"../chunks/Heading.14fb2476.js";function Jt(Ye){let d,K,q,O,T,ee,b,Re=`This chapter introduces the building blocks of Stable Diffusion which is a generative artificial intelligence (generative AI) model that produces unique photorealistic images from text and image prompts. It originally launched in 2022 and was made possible thanks to a collaboration with
<a href="https://stability.ai/" rel="nofollow">Stability AI</a>, <a href="https://runwayml.com/" rel="nofollow">RunwayML</a> and CompVis Group at LMU Munich following the <a href="https://arxiv.org/pdf/2112.10752.pdf" rel="nofollow">paper</a>.`,te,Z,Ee="What will you learn from this chapter?",ae,U,Le="<li>Fundamental components of Stable Diffusion</li> <li>How to use <code>text-to-image</code>, <code>image2image</code>, inpainting pipelines</li>",se,W,le,j,$e=`To make this section interesting we will try to answer some questions to understand the basic components of the Stable Diffusion process.
We will briefly discuss each component as they are already covered in our Diffusers course. Also, you can visit our previous section, which talks about GANS and Diffusion models in details.`,ie,v,Qe="<li>What strategies does Stable Diffusion employ to learn new information?<ul><li>It uses forward and reverse processes of diffusion models. In the forward process, we add Gaussian noise to an image until all that remains is the random noise. Usually we cannot identify the final noisy version of the image.</li> <li>In the reserve process, we have a learned neural network trained to gradually denoise an image starting from pure noise, until you end up with an actual image.</li></ul></li>",ne,m,Ve,D,Ne="T",Ce,oe,pt='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>t</mi><mn>0</mn></msub></mrow><annotation encoding="application/x-tex">t_0</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7651em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal">t</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">0</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',re,c,ze="Hugging Face Blog",Xe,me,I,Ae="<li>Since our images can be huge how can we compress it?</li>",pe,k,De=`When you have large images, they require more computing power to process. This becomes very noticeable in a specific operation known as self-attention. The bigger the image, the more calculations are needed, and these calculations increase very quickly (in a way mathematicians call “quadratically”) with the size of the image.
For example, if you have an image that’s 128 pixels wide and tall, it has four times more pixels than an image that’s only 64 pixels wide and tall. Because of how self-attention works, dealing with this larger image doesn’t just need four times more memory and computing power, it actually needs sixteen times more (since 4 times 4 equals 16). This makes it challenging to work with very high-resolution images, as they require a lot of resources to process.
Latent diffusion models address the high computational demands of processing large images by using a Variational Auto-Encoder (VAE) to shrink the images into a more manageable size. The idea is that many images have repetitive or unnecessary information. A VAE, after being trained on a lot of data, can compress an image into a much smaller, condensed form. This smaller version still retains the essential features of the original image.`,de,B,qe="<li>How are we fusing texts with images since we are using prompts?</li>",ce,G,Pe=`We know that during inference time, we can feed in the description of an image we’d like to see and some pure noise as a starting point, and the model does its best to ‘denoise’ the random input into something that matches the caption.
SD leverages a pre-trained transformer model based on something called <a href="https://github.com/johko/computer-vision-course/blob/main/chapters/en/Unit%204%20-%20Mulitmodal%20Models/CLIP%20and%20relatives/clip.mdx" rel="nofollow">CLIP</a>. CLIP’s text encoder was designed to process image captions into a form that could be used to compare images and text, so it is well suited to the task of creating useful representations from image descriptions. An input prompt is first tokenized (based on a large vocabulary where each word or sub-word is assigned a specific token) and then fed through the CLIP text encoder, producing a 768-dimensional (in the case of SD 1.X) or 1024-dimensional (SD 2.X) vector for each token. To keep things consistent prompts are always padded/truncated to be 77 tokens long, and so the final representation which we use as conditioning is a tensor of shape 77x1024 per prompt.`,he,x,Ke="<li>How can we add-in good inductive biases?</li>",ue,_,Oe=`Since, we are trying to generate something new(e.g., a realistic Pokemon), we need a way to go beyond the images we have seen before(e.g., an anime Pokemon). That’s where U-Net and self-attention come into the picture. Given a noisy version of an image, the model is tasked with predicting the denoised version based on additional clues such as a text description of the image. Ok, how do we actually feed this conditioning information into the U-Net for it to use as it makes predictions? The answer is something called cross-attention. Scattered throughout the U-Net are cross-attention layers.
Each spatial location in the U-Net can ‘attend’ to different tokens in the text conditioning, bringing in relevant information from the prompt.`,fe,F,Me,H,et='This section introduces helpful usecases and how we can perform these tasks using the <a href="https://github.com/huggingface/diffusers" rel="nofollow">Diffusers</a> library.',we,V,tt=`<li>Steps for <code>text-to-image</code> inference
The idea is to pass in the text prompt, which is converted to the output image.</li>`,ge,p,at="",st,ye,C,lt="Using the <code>diffusers</code> library you can get <code>text-to-image</code> working in 2 steps.",Je,X,it="Let’s install the <code>diffusers</code> library first.",Te,S,be,Y,nt="We will now initialize the pipeline and pass our prompt inside and infer.",Ze,R,Ue,E,ot=`<li>Steps for image-to-image inference
In similar fashion, we can initialize the pipeline, but pass an image and a text prompt instead.</li>`,We,L,je,$,rt=`<li>Steps for Inpainting
For inpainting pipeline, we need to pass an image, a text prompt, and a mask based on an object in that image, which indicates what to inpaint in the image.
In this example we also pass a negative prompt to further influence the inference on what we want to avoid.</li>`,ve,Q,Ie,N,ke,z,mt='<li><a href="https://huggingface.co/docs/diffusers/using-diffusers/pipeline_overview" rel="nofollow">Diffusers documentation</a></li> <li><a href="https://huggingface.co/docs/diffusers/installation" rel="nofollow">Diffusers installation</a></li>',Be,P,Ge;return T=new He({props:{title:"Introduction to Stable Diffusion",local:"introduction-to-stable-diffusion",headingTag:"h1"}}),W=new He({props:{title:"What Do We Need for Stable Diffusion to Work?",local:"what-do-we-need-for-stable-diffusion-to-work",headingTag:"h2"}}),F=new He({props:{title:"How to use text-to-image , image-to-image , Inpainting Models in Diffusers",local:"how-to-use-text-to-image--image-to-image--inpainting-models-in-diffusers",headingTag:"h2"}}),S=new Fe({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRpZmZ1c2Vycw==",highlighted:"pip install diffusers",wrap:!1}}),R=new Fe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUwQSkudG8oJTIyY3VkYSUyMiklMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3VkYSUyMikubWFudWFsX3NlZWQoMzEpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjAlMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBjb2xkJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwbXV0ZWQlMjBjb2xvcnMlMkMlMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">31</span>)
image = pipeline(
    <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),L=new Fe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUyQyUyMG1ha2VfaW1hZ2VfZ3JpZCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXIlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTJDJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBJTIzJTIwTG9hZCUyMGFuJTIwaW1hZ2UlMjB0byUyMHBhc3MlMjB0byUyMHRoZSUyMHBpcGVsaW5lJTNBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGY2F0LnBuZyUyMiUwQSklMEElMEElMjMlMjBQYXNzJTIwYSUyMHByb21wdCUyMGFuZCUyMGltYWdlJTIwdG8lMjB0aGUlMjBwaXBlbGluZSUyMHRvJTIwZ2VuZXJhdGUlMjBhbiUyMGltYWdlJTNBJTBBcHJvbXB0JTIwJTNEJTIwJTIyY2F0JTIwd2l6YXJkJTJDJTIwZ2FuZGFsZiUyQyUyMGxvcmQlMjBvZiUyMHRoZSUyMHJpbmdzJTJDJTIwZGV0YWlsZWQlMkMlMjBmYW50YXN5JTJDJTIwY3V0ZSUyQyUyMGFkb3JhYmxlJTJDJTIwUGl4YXIlMkMlMjBEaXNuZXklMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># Load an image to pass to the pipeline:</span>
init_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cat.png&quot;</span>
)

<span class="hljs-comment"># Pass a prompt and image to the pipeline to generate an image:</span>
prompt = <span class="hljs-string">&quot;cat wizard, gandalf, lord of the rings, detailed, fantasy, cute, adorable, Pixar, Disney, 8k&quot;</span>
image = pipeline(prompt, image=init_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),Q=new Fe({props:{code:"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",highlighted:`<span class="hljs-comment"># Load the pipeline</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder-inpaint&quot;</span>, torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># Load the base and mask images:</span>
init_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>
)
mask_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>
)

<span class="hljs-comment"># Create a prompt to inpaint the image with and pass it to the pipeline with the base and mask images:</span>
prompt = (
    <span class="hljs-string">&quot;a black cat with glowing eyes, cute, adorable, disney, pixar, highly detailed, 8k&quot;</span>
)
negative_prompt = <span class="hljs-string">&quot;bad anatomy, deformed, ugly, disfigured&quot;</span>
image = pipeline(
    prompt=prompt,
    negative_prompt=negative_prompt,
    image=init_image,
    mask_image=mask_image,
).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),N=new He({props:{title:"Further Reading",local:"further-reading",headingTag:"h3"}}),{c(){d=n("meta"),K=l(),q=n("p"),O=l(),u(T.$$.fragment),ee=l(),b=n("p"),b.innerHTML=Re,te=l(),Z=n("p"),Z.textContent=Ee,ae=l(),U=n("ul"),U.innerHTML=Le,se=l(),u(W.$$.fragment),le=l(),j=n("p"),j.textContent=$e,ie=l(),v=n("ul"),v.innerHTML=Qe,ne=l(),m=n("p"),Ve=xe("Both of these processes happens for a finite number of steps "),D=n("code"),D.textContent=Ne,Ce=xe("(as per DDPM paper T=1000). You begin the process at time"),oe=new wt(!1),re=xe(" by sampling a real image from your data distribution, and the forward process samples some noise from a Gaussian distribution at each time step t, which is added to the image of the previous time step. To get more mathematical intuition, please read "),c=n("a"),c.textContent=ze,Xe=xe(" on Diffusion Models."),me=l(),I=n("ul"),I.innerHTML=Ae,pe=l(),k=n("p"),k.textContent=De,de=l(),B=n("ul"),B.innerHTML=qe,ce=l(),G=n("p"),G.innerHTML=Pe,he=l(),x=n("ul"),x.innerHTML=Ke,ue=l(),_=n("p"),_.textContent=Oe,fe=l(),u(F.$$.fragment),Me=l(),H=n("p"),H.innerHTML=et,we=l(),V=n("ul"),V.innerHTML=tt,ge=l(),p=n("iframe"),p.innerHTML=at,ye=l(),C=n("p"),C.innerHTML=lt,Je=l(),X=n("p"),X.innerHTML=it,Te=l(),u(S.$$.fragment),be=l(),Y=n("p"),Y.textContent=nt,Ze=l(),u(R.$$.fragment),Ue=l(),E=n("ul"),E.innerHTML=ot,We=l(),u(L.$$.fragment),je=l(),$=n("ul"),$.innerHTML=rt,ve=l(),u(Q.$$.fragment),Ie=l(),u(N.$$.fragment),ke=l(),z=n("ul"),z.innerHTML=mt,Be=l(),P=n("p"),this.h()},l(e){const t=gt("svelte-u9bgzb",document.head);d=o(t,"META",{name:!0,content:!0}),t.forEach(a),K=i(e),q=o(e,"P",{}),Se(q).forEach(a),O=i(e),f(T.$$.fragment,e),ee=i(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-z66int"&&(b.innerHTML=Re),te=i(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1sm6n8h"&&(Z.textContent=Ee),ae=i(e),U=o(e,"UL",{"data-svelte-h":!0}),r(U)!=="svelte-1h3l3ap"&&(U.innerHTML=Le),se=i(e),f(W.$$.fragment,e),le=i(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-15v5s0q"&&(j.textContent=$e),ie=i(e),v=o(e,"UL",{"data-svelte-h":!0}),r(v)!=="svelte-cbr84n"&&(v.innerHTML=Qe),ne=i(e),m=o(e,"P",{});var h=Se(m);Ve=_e(h,"Both of these processes happens for a finite number of steps "),D=o(h,"CODE",{"data-svelte-h":!0}),r(D)!=="svelte-18tc35m"&&(D.textContent=Ne),Ce=_e(h,"(as per DDPM paper T=1000). You begin the process at time"),oe=yt(h,!1),re=_e(h," by sampling a real image from your data distribution, and the forward process samples some noise from a Gaussian distribution at each time step t, which is added to the image of the previous time step. To get more mathematical intuition, please read "),c=o(h,"A",{href:!0,rel:!0,"data-svelte-h":!0}),r(c)!=="svelte-1h13rvl"&&(c.textContent=ze),Xe=_e(h," on Diffusion Models."),h.forEach(a),me=i(e),I=o(e,"UL",{"data-svelte-h":!0}),r(I)!=="svelte-nhvgmx"&&(I.innerHTML=Ae),pe=i(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-ghqky8"&&(k.textContent=De),de=i(e),B=o(e,"UL",{"data-svelte-h":!0}),r(B)!=="svelte-wgoof5"&&(B.innerHTML=qe),ce=i(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-2rrp3n"&&(G.innerHTML=Pe),he=i(e),x=o(e,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-1gci2og"&&(x.innerHTML=Ke),ue=i(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-ceb1g8"&&(_.textContent=Oe),fe=i(e),f(F.$$.fragment,e),Me=i(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1tbjqci"&&(H.innerHTML=et),we=i(e),V=o(e,"UL",{"data-svelte-h":!0}),r(V)!=="svelte-4vkcyc"&&(V.innerHTML=tt),ge=i(e),p=o(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0,"data-svelte-h":!0}),r(p)!=="svelte-1du1c08"&&(p.innerHTML=at),ye=i(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1xlt128"&&(C.innerHTML=lt),Je=i(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-3yyytc"&&(X.innerHTML=it),Te=i(e),f(S.$$.fragment,e),be=i(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-18bx7u2"&&(Y.textContent=nt),Ze=i(e),f(R.$$.fragment,e),Ue=i(e),E=o(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-k07d6l"&&(E.innerHTML=ot),We=i(e),f(L.$$.fragment,e),je=i(e),$=o(e,"UL",{"data-svelte-h":!0}),r($)!=="svelte-3vw8pj"&&($.innerHTML=rt),ve=i(e),f(Q.$$.fragment,e),Ie=i(e),f(N.$$.fragment,e),ke=i(e),z=o(e,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-cvv663"&&(z.innerHTML=mt),Be=i(e),P=o(e,"P",{}),Se(P).forEach(a),this.h()},h(){M(d,"name","hf:doc:metadata"),M(d,"content",Tt),oe.a=re,M(c,"href","https://huggingface.co/blog/annotated-diffusion"),M(c,"rel","nofollow"),ct(p.src,st="https://hysts-controlnet-v1-1.hf.space/")||M(p,"src",st),M(p,"frameborder","0"),M(p,"width","850"),M(p,"height","450")},m(e,t){A(document.head,d),s(e,K,t),s(e,q,t),s(e,O,t),w(T,e,t),s(e,ee,t),s(e,b,t),s(e,te,t),s(e,Z,t),s(e,ae,t),s(e,U,t),s(e,se,t),w(W,e,t),s(e,le,t),s(e,j,t),s(e,ie,t),s(e,v,t),s(e,ne,t),s(e,m,t),A(m,Ve),A(m,D),A(m,Ce),oe.m(pt,m),A(m,re),A(m,c),A(m,Xe),s(e,me,t),s(e,I,t),s(e,pe,t),s(e,k,t),s(e,de,t),s(e,B,t),s(e,ce,t),s(e,G,t),s(e,he,t),s(e,x,t),s(e,ue,t),s(e,_,t),s(e,fe,t),w(F,e,t),s(e,Me,t),s(e,H,t),s(e,we,t),s(e,V,t),s(e,ge,t),s(e,p,t),s(e,ye,t),s(e,C,t),s(e,Je,t),s(e,X,t),s(e,Te,t),w(S,e,t),s(e,be,t),s(e,Y,t),s(e,Ze,t),w(R,e,t),s(e,Ue,t),s(e,E,t),s(e,We,t),w(L,e,t),s(e,je,t),s(e,$,t),s(e,ve,t),w(Q,e,t),s(e,Ie,t),w(N,e,t),s(e,ke,t),s(e,z,t),s(e,Be,t),s(e,P,t),Ge=!0},p:ht,i(e){Ge||(g(T.$$.fragment,e),g(W.$$.fragment,e),g(F.$$.fragment,e),g(S.$$.fragment,e),g(R.$$.fragment,e),g(L.$$.fragment,e),g(Q.$$.fragment,e),g(N.$$.fragment,e),Ge=!0)},o(e){y(T.$$.fragment,e),y(W.$$.fragment,e),y(F.$$.fragment,e),y(S.$$.fragment,e),y(R.$$.fragment,e),y(L.$$.fragment,e),y(Q.$$.fragment,e),y(N.$$.fragment,e),Ge=!1},d(e){e&&(a(K),a(q),a(O),a(ee),a(b),a(te),a(Z),a(ae),a(U),a(se),a(le),a(j),a(ie),a(v),a(ne),a(m),a(me),a(I),a(pe),a(k),a(de),a(B),a(ce),a(G),a(he),a(x),a(ue),a(_),a(fe),a(Me),a(H),a(we),a(V),a(ge),a(p),a(ye),a(C),a(Je),a(X),a(Te),a(be),a(Y),a(Ze),a(Ue),a(E),a(We),a(je),a($),a(ve),a(Ie),a(ke),a(z),a(Be),a(P)),a(d),J(T,e),J(W,e),J(F,e),J(S,e),J(R,e),J(L,e),J(Q,e),J(N,e)}}}const Tt='{"title":"Introduction to Stable Diffusion","local":"introduction-to-stable-diffusion","sections":[{"title":"What Do We Need for Stable Diffusion to Work?","local":"what-do-we-need-for-stable-diffusion-to-work","sections":[],"depth":2},{"title":"How to use text-to-image , image-to-image , Inpainting Models in Diffusers","local":"how-to-use-text-to-image--image-to-image--inpainting-models-in-diffusers","sections":[{"title":"Further Reading","local":"further-reading","sections":[],"depth":3}],"depth":2}],"depth":1}';function bt(Ye){return ut(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vt extends ft{constructor(d){super(),Mt(this,d,bt,Jt,dt,{})}}export{vt as component};
