import{s as pl,n as rl,o as ml}from"../chunks/scheduler.7bc62968.js";import{S as ol,i as Ml,g as i,s as a,r as m,A as hl,h as p,f as s,c as n,j as il,u as o,x as r,k as fs,y as cl,a as l,v as M,d as h,t as c,w as y}from"../chunks/index.2f8492b0.js";import{C as f}from"../chunks/CodeBlock.4e96d6f7.js";import{H as ys}from"../chunks/Heading.14fb2476.js";function yl(us){let u,Le,Ee,Ze,T,Qe,U,ws="How can we match detected features from one image to another? Feature matching involves comparing key attributes in different images to find similarities. Feature matching is useful in many computer vision applications, including scene understanding, image stitching, object tracking, and pattern recognition.",Ye,d,Ve,J,Ts="Imagine you have a giant box of puzzle pieces, and you’re trying to find a specific piece that fits into your puzzle. This is similar to searching for matching features in images. Instead of having any special strategy, you decide to check every piece, one by one until you find the right one. This straightforward method is a brute-force search. The advantage of brute force is its simplicity. You don’t need any special tricks – just patience. However, it can be time-consuming, especially if there are a lot of pieces to check. In the context of feature matching, this brute force approach is akin to comparing every pixel in one image to every pixel in another to see if they match. It’s exhaustive and it might take a lot of time, especially for large images.",Xe,b,Us="Now that we have an intuitive idea of how brute-force matches are found, let’s dive into the algorithms. We are going to use the descriptors that we learned about in the previous chapter to find the matching features in two images.",De,C,ds="First install and load libraries",Ke,g,He,j,Pe,k,Js="<strong>Brute Force with SIFT</strong>",qe,$,bs="Let’s start by initializing SIFT detector.",Oe,I,et,v,Cs="Find the keypoints and descriptors with SIFT.",tt,R,st,x,gs="Find matches using k nearest neighbors.",lt,N,at,B,js="Apply ratio test to threshold the best matches.",nt,F,it,_,ks="Draw the matches.",pt,z,rt,w,$s='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/feature-extraction-feature-matching/SIFT.png" alt="SIFT"/>',mt,G,Is="<strong>Brute Force with ORB (binary) descriptors</strong>",ot,S,vs="Initialize the ORB descriptor.",Mt,W,ht,E,Rs="Find keypoints and descriptors.",ct,A,yt,L,xs=`Because ORB is a binary descriptor, we find matches using <a href="https://www.geeksforgeeks.org/hamming-distance-two-strings/" rel="nofollow">Hamming Distance</a>,
which is a measure of the difference between two strings of equal length.`,ft,Z,ut,Q,Ns="We will now find the matches.",wt,Y,Tt,V,Bs="We can sort them in the order of their distance like the following.",Ut,X,dt,D,Fs="Draw first n matches.",Jt,K,bt,H,_s="<strong>Fast Library for Approximate Nearest Neighbors (FLANN)</strong>",Ct,P,zs=`FLANN was proposed in <a href="https://www.cs.ubc.ca/research/flann/uploads/FLANN/flann_visapp09.pdf" rel="nofollow">Fast Approximate Nearest Neighbors With Automatic Algorithm Configuration</a> by Muja and Lowe. To explain FLANN, we will continue with our puzzle solving example. Visualize a giant puzzle with hundreds of pieces scattered around. Your goal is to organize these pieces based on how well they fit together. Instead of randomly trying to match pieces,
FLANN uses some clever tricks to quickly figure out which pieces are most likely to go together. Instead of trying every piece against every other piece, FLANN streamlines the process by finding pieces that are approximately similar. This means it can make educated guesses about which pieces might fit well together, even if they’re not an exact match. Under the hood, FLANN is uses something called k-D trees. Think of it as organizing the puzzle pieces in a special way. Instead of checking every piece against every other piece, FLANN arranges them in a tree-like structure that makes finding matches faster. In each node of the k-D tree, FLANN puts pieces with similar features together. It’s like sorting puzzle pieces with similar shapes or colors into piles. This way, when you’re looking for a match, you can quickly check the pile that’s most likely to have similar pieces. Let’s say you’re looking for a “sky” piece. Instead of searching through all the pieces, FLANN guides you to the right spot in the k-D tree where the sky-colored pieces are sorted. FLANN also adjusts its strategy based on the features of the puzzle pieces. If you have a puzzle with lots of colors, it will focus on color features. Alternately, if it’s a puzzle with intricate shapes, it pays attention to those shapes. By balancing speed and accuracy when finding matching features, FLANN substantially improves query time.`,gt,q,Gs="First, we create a dictionary to specify the algorithm we will use, for SIFT or SURF it looks like the following.",jt,O,kt,ee,Ss="For ORB, will use the parameters from the paper.",$t,te,It,se,Ws="We also create a dictionary to specify the maximum leafs to visit as follows.",vt,le,Rt,ae,Es="Initiate SIFT detector",xt,ne,Nt,ie,As="Find the keypoints and descriptors with SIFT",Bt,pe,Ft,re,Ls="We will now define the FLANN parameters. Here, trees is the number of bins you want.",_t,me,zt,oe,Zs="We will only draw good matches, so create a mask.",Gt,Me,St,he,Qs="We can perform a ratio test to determine good matches.",Wt,ce,Et,ye,Ys="Now let’s visualize the matches.",At,fe,Lt,ue,Vs='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/feature-extraction-feature-matching/FLANN.png" alt="FLANN"/>',Zt,we,Qt,Te,Xs=`LoFTR was proposed in <a href="https://arxiv.org/pdf/2104.00680.pdf" rel="nofollow">LoFTR: Detector-Free Local Feature Matching with Transformers</a> by Sun, et. al.
Instead of using feature detectors, LoFTR uses a learning-based approach to feature matching.`,Yt,Ue,Ds=`Let’s keep it simple and use our puzzle example once again. Instead of simply comparing images pixel by pixel, LoFTR looks for specific key points, or features, in each image. It’s like identifying the corners and edges of each puzzle piece. And just as someone really good a putting together a puzzle might focus on distinctive marks, LoFTR identifies these unique points in one image. These could be key landmarks or structures that stand out. As we have already learned, it is important that the matching algorithm handles changes in rotation or scale. If a feature is turned or resized, LoFTR would still recognize it. It’s like solving puzzles where pieces may be flipped or adjusted. As LoFTR matches features, it assigns a similarity score to indicate how well the features align. Higher scores mean better matches. It’s like giving a grade to how well one puzzle piece fits with another.
LoFTR is also invariant to certain transformations, meaning it can handle variations in lighting, angle, or perspective. This is crucial when dealing with images that might be photographed under different conditions. LoFTR’s ability to robustly match features makes it valuable for tasks like image stitching, where you combine multiple images seamlessly by identifying and connecting common features.`,Vt,de,Ks='We can use <a href="https://github.com/kornia/kornia" rel="nofollow">Kornia</a> to find matching features in two images using LoFTR.',Xt,Je,Dt,be,Hs="Import the necessary libraries.",Kt,Ce,Ht,ge,Ps="Load and resize the images.",Pt,je,qt,ke,qs="Indicate whether the image is an “indoor” or “outdoor” image.",Ot,$e,es,Ie,Os="LoFTR only works on grayscale images, so convert to images to grayscale.",ts,ve,ss,Re,el="Let’s perform the inference.",ls,xe,as,Ne,tl='Clean up the correspondences using Random Sample Consensus (<a href="https://en.wikipedia.org/wiki/Random_sample_consensus" rel="nofollow">RANSAC</a>). This helps to deal with noise or outliers in the data.',ns,Be,is,Fe,sl="Finally, we can visualize the matches",ps,_e,rs,ze,ll="The best matches are visualized in green, while less certain matches are in blue.",ms,Ge,al='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/feature-extraction-feature-matching/LoFTR.png" alt="LoFTR"/>',os,Se,Ms,We,nl='<li><a href="https://github.com/flann-lib/flann" rel="nofollow">FLANN Github</a></li> <li><a href="https://arxiv.org/pdf/1710.02726.pdf" rel="nofollow">Image Matching Using SIFT, SURF, BRIEF and ORB: Performance Comparison for Distorted Images</a></li> <li><a href="https://docs.opencv.org/4.x/d1/d89/tutorial_py_orb.html" rel="nofollow">ORB (Oriented FAST and Rotated BRIEF) tutorial</a></li> <li><a href="https://kornia.github.io/tutorials/nbs/image_matching.html" rel="nofollow">Kornia tutorial on Image Matching</a></li> <li><a href="https://github.com/zju3dv/LoFTR" rel="nofollow">LoFTR Github</a></li> <li><a href="https://github.com/opencv/opencv-python" rel="nofollow">OpenCV Github</a></li> <li><a href="https://docs.opencv.org/4.x/dc/dc3/tutorial_py_matcher.html" rel="nofollow">OpenCV Feature Matching Tutorial</a></li> <li><a href="https://arxiv.org/abs/2204.08870" rel="nofollow">OpenGlue: Open Source Graph Neural Net Based Pipeline for Image Matching</a></li>',hs,Ae,cs;return T=new ys({props:{title:"Feature Matching",local:"feature-matching",headingTag:"h1"}}),d=new ys({props:{title:"Brute-Force Search",local:"brute-force-search",headingTag:"h2"}}),g=new f({props:{code:"IXBpcCUyMGluc3RhbGwlMjBvcGVuY3YtcHl0aG9u",highlighted:"!pip install opencv-python",wrap:!1}}),j=new f({props:{code:"aW1wb3J0JTIwY3YyJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5w",highlighted:`<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np`,wrap:!1}}),I=new f({props:{code:"c2lmdCUyMCUzRCUyMGN2LlNJRlRfY3JlYXRlKCk=",highlighted:"sift = cv.SIFT_create()",wrap:!1}}),R=new f({props:{code:"a3AxJTJDJTIwZGVzMSUyMCUzRCUyMHNpZnQuZGV0ZWN0QW5kQ29tcHV0ZShpbWcxJTJDJTIwTm9uZSklMEFrcDIlMkMlMjBkZXMyJTIwJTNEJTIwc2lmdC5kZXRlY3RBbmRDb21wdXRlKGltZzIlMkMlMjBOb25lKQ==",highlighted:`kp1, des1 = sift.detectAndCompute(img1, <span class="hljs-literal">None</span>)
kp2, des2 = sift.detectAndCompute(img2, <span class="hljs-literal">None</span>)`,wrap:!1}}),N=new f({props:{code:"YmYlMjAlM0QlMjBjdi5CRk1hdGNoZXIoKSUwQW1hdGNoZXMlMjAlM0QlMjBiZi5rbm5NYXRjaChkZXMxJTJDJTIwZGVzMiUyQyUyMGslM0QyKQ==",highlighted:`bf = cv.BFMatcher()
matches = bf.knnMatch(des1, des2, k=<span class="hljs-number">2</span>)`,wrap:!1}}),F=new f({props:{code:"Z29vZCUyMCUzRCUyMCU1QiU1RCUwQWZvciUyMG0lMkMlMjBuJTIwaW4lMjBtYXRjaGVzJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBtLmRpc3RhbmNlJTIwJTNDJTIwMC43NSUyMColMjBuLmRpc3RhbmNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ29vZC5hcHBlbmQoJTVCbSU1RCk=",highlighted:`good = []
<span class="hljs-keyword">for</span> m, n <span class="hljs-keyword">in</span> matches:
    <span class="hljs-keyword">if</span> m.distance &lt; <span class="hljs-number">0.75</span> * n.distance:
        good.append([m])`,wrap:!1}}),z=new f({props:{code:"aW1nMyUyMCUzRCUyMGN2LmRyYXdNYXRjaGVzS25uKCUwQSUyMCUyMCUyMCUyMGltZzElMkMlMjBrcDElMkMlMjBpbWcyJTJDJTIwa3AyJTJDJTIwZ29vZCUyQyUyME5vbmUlMkMlMjBmbGFncyUzRGN2LkRyYXdNYXRjaGVzRmxhZ3NfTk9UX0RSQVdfU0lOR0xFX1BPSU5UUyUwQSk=",highlighted:`img3 = cv.drawMatchesKnn(
    img1, kp1, img2, kp2, good, <span class="hljs-literal">None</span>, flags=cv.DrawMatchesFlags_NOT_DRAW_SINGLE_POINTS
)`,wrap:!1}}),W=new f({props:{code:"b3JiJTIwJTNEJTIwY3YuT1JCX2NyZWF0ZSgp",highlighted:"orb = cv.ORB_create()",wrap:!1}}),A=new f({props:{code:"a3AxJTJDJTIwZGVzMSUyMCUzRCUyMG9yYi5kZXRlY3RBbmRDb21wdXRlKGltZzElMkMlMjBOb25lKSUwQWtwMiUyQyUyMGRlczIlMjAlM0QlMjBvcmIuZGV0ZWN0QW5kQ29tcHV0ZShpbWcyJTJDJTIwTm9uZSk=",highlighted:`kp1, des1 = orb.detectAndCompute(img1, <span class="hljs-literal">None</span>)
kp2, des2 = orb.detectAndCompute(img2, <span class="hljs-literal">None</span>)`,wrap:!1}}),Z=new f({props:{code:"YmYlMjAlM0QlMjBjdi5CRk1hdGNoZXIoY3YuTk9STV9IQU1NSU5HJTJDJTIwY3Jvc3NDaGVjayUzRFRydWUp",highlighted:'bf = cv.BFMatcher(cv.NORM_HAMMING, crossCheck=<span class="hljs-literal">True</span>)',wrap:!1}}),Y=new f({props:{code:"bWF0Y2hlcyUyMCUzRCUyMGJmLm1hdGNoKGRlczElMkMlMjBkZXMyKQ==",highlighted:'matches = bf.<span class="hljs-keyword">match</span>(des1, des2)',wrap:!1}}),X=new f({props:{code:"bWF0Y2hlcyUyMCUzRCUyMHNvcnRlZChtYXRjaGVzJTJDJTIwa2V5JTNEbGFtYmRhJTIweCUzQSUyMHguZGlzdGFuY2Up",highlighted:'matches = <span class="hljs-built_in">sorted</span>(matches, key=<span class="hljs-keyword">lambda</span> x: x.distance)',wrap:!1}}),K=new f({props:{code:"aW1nMyUyMCUzRCUyMGN2LmRyYXdNYXRjaGVzKCUwQSUyMCUyMCUyMCUyMGltZzElMkMlMEElMjAlMjAlMjAlMjBrcDElMkMlMEElMjAlMjAlMjAlMjBpbWcyJTJDJTBBJTIwJTIwJTIwJTIwa3AyJTJDJTBBJTIwJTIwJTIwJTIwbWF0Y2hlcyU1QiUzQW4lNUQlMkMlMEElMjAlMjAlMjAlMjBOb25lJTJDJTBBJTIwJTIwJTIwJTIwZmxhZ3MlM0Rjdi5EcmF3TWF0Y2hlc0ZsYWdzX05PVF9EUkFXX1NJTkdMRV9QT0lOVFMlMkMlMEEp",highlighted:`img3 = cv.drawMatches(
    img1,
    kp1,
    img2,
    kp2,
    matches[:n],
    <span class="hljs-literal">None</span>,
    flags=cv.DrawMatchesFlags_NOT_DRAW_SINGLE_POINTS,
)`,wrap:!1}}),O=new f({props:{code:"RkxBTk5fSU5ERVhfS0RUUkVFJTIwJTNEJTIwMSUwQWluZGV4X3BhcmFtcyUyMCUzRCUyMGRpY3QoYWxnb3JpdGhtJTNERkxBTk5fSU5ERVhfS0RUUkVFJTJDJTIwdHJlZXMlM0Q1KQ==",highlighted:`FLANN_INDEX_KDTREE = <span class="hljs-number">1</span>
index_params = <span class="hljs-built_in">dict</span>(algorithm=FLANN_INDEX_KDTREE, trees=<span class="hljs-number">5</span>)`,wrap:!1}}),te=new f({props:{code:"RkxBTk5fSU5ERVhfTFNIJTIwJTNEJTIwNiUwQWluZGV4X3BhcmFtcyUyMCUzRCUyMGRpY3QoJTBBJTIwJTIwJTIwJTIwYWxnb3JpdGhtJTNERkxBTk5fSU5ERVhfTFNIJTJDJTIwdGFibGVfbnVtYmVyJTNEMTIlMkMlMjBrZXlfc2l6ZSUzRDIwJTJDJTIwbXVsdGlfcHJvYmVfbGV2ZWwlM0QyJTBBKQ==",highlighted:`FLANN_INDEX_LSH = <span class="hljs-number">6</span>
index_params = <span class="hljs-built_in">dict</span>(
    algorithm=FLANN_INDEX_LSH, table_number=<span class="hljs-number">12</span>, key_size=<span class="hljs-number">20</span>, multi_probe_level=<span class="hljs-number">2</span>
)`,wrap:!1}}),le=new f({props:{code:"c2VhcmNoX3BhcmFtcyUyMCUzRCUyMGRpY3QoY2hlY2tzJTNENTAp",highlighted:'search_params = <span class="hljs-built_in">dict</span>(checks=<span class="hljs-number">50</span>)',wrap:!1}}),ne=new f({props:{code:"c2lmdCUyMCUzRCUyMGN2LlNJRlRfY3JlYXRlKCk=",highlighted:"sift = cv.SIFT_create()",wrap:!1}}),pe=new f({props:{code:"a3AxJTJDJTIwZGVzMSUyMCUzRCUyMHNpZnQuZGV0ZWN0QW5kQ29tcHV0ZShpbWcxJTJDJTIwTm9uZSklMEFrcDIlMkMlMjBkZXMyJTIwJTNEJTIwc2lmdC5kZXRlY3RBbmRDb21wdXRlKGltZzIlMkMlMjBOb25lKQ==",highlighted:`kp1, des1 = sift.detectAndCompute(img1, <span class="hljs-literal">None</span>)
kp2, des2 = sift.detectAndCompute(img2, <span class="hljs-literal">None</span>)`,wrap:!1}}),me=new f({props:{code:"RkxBTk5fSU5ERVhfS0RUUkVFJTIwJTNEJTIwMSUwQWluZGV4X3BhcmFtcyUyMCUzRCUyMGRpY3QoYWxnb3JpdGhtJTNERkxBTk5fSU5ERVhfS0RUUkVFJTJDJTIwdHJlZXMlM0Q1KSUwQXNlYXJjaF9wYXJhbXMlMjAlM0QlMjBkaWN0KGNoZWNrcyUzRDUwKSUwQWZsYW5uJTIwJTNEJTIwY3YuRmxhbm5CYXNlZE1hdGNoZXIoaW5kZXhfcGFyYW1zJTJDJTIwc2VhcmNoX3BhcmFtcyklMEElMEFtYXRjaGVzJTIwJTNEJTIwZmxhbm4ua25uTWF0Y2goZGVzMSUyQyUyMGRlczIlMkMlMjBrJTNEMik=",highlighted:`FLANN_INDEX_KDTREE = <span class="hljs-number">1</span>
index_params = <span class="hljs-built_in">dict</span>(algorithm=FLANN_INDEX_KDTREE, trees=<span class="hljs-number">5</span>)
search_params = <span class="hljs-built_in">dict</span>(checks=<span class="hljs-number">50</span>)
flann = cv.FlannBasedMatcher(index_params, search_params)

matches = flann.knnMatch(des1, des2, k=<span class="hljs-number">2</span>)`,wrap:!1}}),Me=new f({props:{code:"bWF0Y2hlc01hc2slMjAlM0QlMjAlNUIlNUIwJTJDJTIwMCU1RCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihtYXRjaGVzKSklNUQ=",highlighted:'matchesMask = [[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(matches))]',wrap:!1}}),ce=new f({props:{code:"Zm9yJTIwaSUyQyUyMChtJTJDJTIwbiklMjBpbiUyMGVudW1lcmF0ZShtYXRjaGVzKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbS5kaXN0YW5jZSUyMCUzQyUyMDAuNyUyMColMjBuLmRpc3RhbmNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF0Y2hlc01hc2slNUJpJTVEJTIwJTNEJTIwJTVCMSUyQyUyMDAlNUQ=",highlighted:`<span class="hljs-keyword">for</span> i, (m, n) <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(matches):
    <span class="hljs-keyword">if</span> m.distance &lt; <span class="hljs-number">0.7</span> * n.distance:
        matchesMask[i] = [<span class="hljs-number">1</span>, <span class="hljs-number">0</span>]`,wrap:!1}}),fe=new f({props:{code:"ZHJhd19wYXJhbXMlMjAlM0QlMjBkaWN0KCUwQSUyMCUyMCUyMCUyMG1hdGNoQ29sb3IlM0QoMCUyQyUyMDI1NSUyQyUyMDApJTJDJTBBJTIwJTIwJTIwJTIwc2luZ2xlUG9pbnRDb2xvciUzRCgyNTUlMkMlMjAwJTJDJTIwMCklMkMlMEElMjAlMjAlMjAlMjBtYXRjaGVzTWFzayUzRG1hdGNoZXNNYXNrJTJDJTBBJTIwJTIwJTIwJTIwZmxhZ3MlM0Rjdi5EcmF3TWF0Y2hlc0ZsYWdzX0RFRkFVTFQlMkMlMEEpJTBBJTBBaW1nMyUyMCUzRCUyMGN2LmRyYXdNYXRjaGVzS25uKGltZzElMkMlMjBrcDElMkMlMjBpbWcyJTJDJTIwa3AyJTJDJTIwbWF0Y2hlcyUyQyUyME5vbmUlMkMlMjAqKmRyYXdfcGFyYW1zKQ==",highlighted:`draw_params = <span class="hljs-built_in">dict</span>(
    matchColor=(<span class="hljs-number">0</span>, <span class="hljs-number">255</span>, <span class="hljs-number">0</span>),
    singlePointColor=(<span class="hljs-number">255</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>),
    matchesMask=matchesMask,
    flags=cv.DrawMatchesFlags_DEFAULT,
)

img3 = cv.drawMatchesKnn(img1, kp1, img2, kp2, matches, <span class="hljs-literal">None</span>, **draw_params)`,wrap:!1}}),we=new ys({props:{title:"Local Feature Matching with Transformers (LoFTR)",local:"local-feature-matching-with-transformers-loftr",headingTag:"h2"}}),Je=new f({props:{code:"IXBpcCUyMGluc3RhbGwlMjBrb3JuaWElMjAlMjBrb3JuaWEtcnMlMjAlMjBrb3JuaWFfbW9vbnMlMjBvcGVuY3YtcHl0aG9uJTIwLS11cGdyYWRl",highlighted:"!pip install kornia  kornia-rs  kornia_moons opencv-python --upgrade",wrap:!1}}),Ce=new f({props:{code:"aW1wb3J0JTIwY3YyJTBBaW1wb3J0JTIwa29ybmlhJTIwYXMlMjBLJTBBaW1wb3J0JTIwa29ybmlhLmZlYXR1cmUlMjBhcyUyMEtGJTBBaW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGtvcm5pYV9tb29ucy52aXolMjBpbXBvcnQlMjBkcmF3X0xBRl9tYXRjaGVz",highlighted:`<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> kornia <span class="hljs-keyword">as</span> K
<span class="hljs-keyword">import</span> kornia.feature <span class="hljs-keyword">as</span> KF
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> kornia_moons.viz <span class="hljs-keyword">import</span> draw_LAF_matches`,wrap:!1}}),je=new f({props:{code:"ZnJvbSUyMGtvcm5pYS5mZWF0dXJlJTIwaW1wb3J0JTIwTG9GVFIlMEElMEFpbWcxJTIwJTNEJTIwSy5pby5sb2FkX2ltYWdlKGltYWdlMS5qcGclMkMlMjBLLmlvLkltYWdlTG9hZFR5cGUuUkdCMzIpJTVCTm9uZSUyQyUyMC4uLiU1RCUwQWltZzIlMjAlM0QlMjBLLmlvLmxvYWRfaW1hZ2UoaW1hZ2UyLmpwZyUyQyUyMEsuaW8uSW1hZ2VMb2FkVHlwZS5SR0IzMiklNUJOb25lJTJDJTIwLi4uJTVEJTBBJTBBaW1nMSUyMCUzRCUyMEsuZ2VvbWV0cnkucmVzaXplKGltZzElMkMlMjAoNTEyJTJDJTIwNTEyKSUyQyUyMGFudGlhbGlhcyUzRFRydWUpJTBBaW1nMiUyMCUzRCUyMEsuZ2VvbWV0cnkucmVzaXplKGltZzIlMkMlMjAoNTEyJTJDJTIwNTEyKSUyQyUyMGFudGlhbGlhcyUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> kornia.feature <span class="hljs-keyword">import</span> LoFTR

img1 = K.io.load_image(image1.jpg, K.io.ImageLoadType.RGB32)[<span class="hljs-literal">None</span>, ...]
img2 = K.io.load_image(image2.jpg, K.io.ImageLoadType.RGB32)[<span class="hljs-literal">None</span>, ...]

img1 = K.geometry.resize(img1, (<span class="hljs-number">512</span>, <span class="hljs-number">512</span>), antialias=<span class="hljs-literal">True</span>)
img2 = K.geometry.resize(img2, (<span class="hljs-number">512</span>, <span class="hljs-number">512</span>), antialias=<span class="hljs-literal">True</span>)`,wrap:!1}}),$e=new f({props:{code:"bWF0Y2hlciUyMCUzRCUyMExvRlRSKHByZXRyYWluZWQlM0QlMjJvdXRkb29yJTIyKQ==",highlighted:'matcher = LoFTR(pretrained=<span class="hljs-string">&quot;outdoor&quot;</span>)',wrap:!1}}),ve=new f({props:{code:"aW5wdXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmltYWdlMCUyMiUzQSUyMEsuY29sb3IucmdiX3RvX2dyYXlzY2FsZShpbWcxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMmltYWdlMSUyMiUzQSUyMEsuY29sb3IucmdiX3RvX2dyYXlzY2FsZShpbWcyKSUyQyUwQSU3RA==",highlighted:`input_dict = {
    <span class="hljs-string">&quot;image0&quot;</span>: K.color.rgb_to_grayscale(img1),
    <span class="hljs-string">&quot;image1&quot;</span>: K.color.rgb_to_grayscale(img2),
}`,wrap:!1}}),xe=new f({props:{code:"d2l0aCUyMHRvcmNoLmluZmVyZW5jZV9tb2RlKCklM0ElMEElMjAlMjAlMjAlMjBjb3JyZXNwb25kZW5jZXMlMjAlM0QlMjBtYXRjaGVyKGlucHV0X2RpY3Qp",highlighted:`<span class="hljs-keyword">with</span> torch.inference_mode():
    correspondences = matcher(input_dict)`,wrap:!1}}),Be=new f({props:{code:"bWtwdHMwJTIwJTNEJTIwY29ycmVzcG9uZGVuY2VzJTVCJTIya2V5cG9pbnRzMCUyMiU1RC5jcHUoKS5udW1weSgpJTBBbWtwdHMxJTIwJTNEJTIwY29ycmVzcG9uZGVuY2VzJTVCJTIya2V5cG9pbnRzMSUyMiU1RC5jcHUoKS5udW1weSgpJTBBRm0lMkMlMjBpbmxpZXJzJTIwJTNEJTIwY3YyLmZpbmRGdW5kYW1lbnRhbE1hdChta3B0czAlMkMlMjBta3B0czElMkMlMjBjdjIuVVNBQ19NQUdTQUMlMkMlMjAwLjUlMkMlMjAwLjk5OSUyQyUyMDEwMDAwMCklMEFpbmxpZXJzJTIwJTNEJTIwaW5saWVycyUyMCUzRSUyMDA=",highlighted:`mkpts0 = correspondences[<span class="hljs-string">&quot;keypoints0&quot;</span>].cpu().numpy()
mkpts1 = correspondences[<span class="hljs-string">&quot;keypoints1&quot;</span>].cpu().numpy()
Fm, inliers = cv2.findFundamentalMat(mkpts0, mkpts1, cv2.USAC_MAGSAC, <span class="hljs-number">0.5</span>, <span class="hljs-number">0.999</span>, <span class="hljs-number">100000</span>)
inliers = inliers &gt; <span class="hljs-number">0</span>`,wrap:!1}}),_e=new f({props:{code:"ZHJhd19MQUZfbWF0Y2hlcyglMEElMjAlMjAlMjAlMjBLRi5sYWZfZnJvbV9jZW50ZXJfc2NhbGVfb3JpKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvcmNoLmZyb21fbnVtcHkobWtwdHMwKS52aWV3KDElMkMlMjAtMSUyQyUyMDIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2gub25lcyhta3B0czAuc2hhcGUlNUIwJTVEKS52aWV3KDElMkMlMjAtMSUyQyUyMDElMkMlMjAxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvcmNoLm9uZXMobWtwdHMwLnNoYXBlJTVCMCU1RCkudmlldygxJTJDJTIwLTElMkMlMjAxKSUyQyUwQSUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjBLRi5sYWZfZnJvbV9jZW50ZXJfc2NhbGVfb3JpKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvcmNoLmZyb21fbnVtcHkobWtwdHMxKS52aWV3KDElMkMlMjAtMSUyQyUyMDIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2gub25lcyhta3B0czEuc2hhcGUlNUIwJTVEKS52aWV3KDElMkMlMjAtMSUyQyUyMDElMkMlMjAxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvcmNoLm9uZXMobWtwdHMxLnNoYXBlJTVCMCU1RCkudmlldygxJTJDJTIwLTElMkMlMjAxKSUyQyUwQSUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjB0b3JjaC5hcmFuZ2UobWtwdHMwLnNoYXBlJTVCMCU1RCkudmlldygtMSUyQyUyMDEpLnJlcGVhdCgxJTJDJTIwMiklMkMlMEElMjAlMjAlMjAlMjBLLnRlbnNvcl90b19pbWFnZShpbWcxKSUyQyUwQSUyMCUyMCUyMCUyMEsudGVuc29yX3RvX2ltYWdlKGltZzIpJTJDJTBBJTIwJTIwJTIwJTIwaW5saWVycyUyQyUwQSUyMCUyMCUyMCUyMGRyYXdfZGljdCUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmlubGllcl9jb2xvciUyMiUzQSUyMCgwLjElMkMlMjAxJTJDJTIwMC4xJTJDJTIwMC41KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRlbnRhdGl2ZV9jb2xvciUyMiUzQSUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJmZWF0dXJlX2NvbG9yJTIyJTNBJTIwKDAuMiUyQyUyMDAuMiUyQyUyMDElMkMlMjAwLjUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydmVydGljYWwlMjIlM0ElMjBGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSk=",highlighted:`draw_LAF_matches(
    KF.laf_from_center_scale_ori(
        torch.from_numpy(mkpts0).view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, <span class="hljs-number">2</span>),
        torch.ones(mkpts0.shape[<span class="hljs-number">0</span>]).view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>),
        torch.ones(mkpts0.shape[<span class="hljs-number">0</span>]).view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, <span class="hljs-number">1</span>),
    ),
    KF.laf_from_center_scale_ori(
        torch.from_numpy(mkpts1).view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, <span class="hljs-number">2</span>),
        torch.ones(mkpts1.shape[<span class="hljs-number">0</span>]).view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>),
        torch.ones(mkpts1.shape[<span class="hljs-number">0</span>]).view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, <span class="hljs-number">1</span>),
    ),
    torch.arange(mkpts0.shape[<span class="hljs-number">0</span>]).view(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>).repeat(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>),
    K.tensor_to_image(img1),
    K.tensor_to_image(img2),
    inliers,
    draw_dict={
        <span class="hljs-string">&quot;inlier_color&quot;</span>: (<span class="hljs-number">0.1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0.1</span>, <span class="hljs-number">0.5</span>),
        <span class="hljs-string">&quot;tentative_color&quot;</span>: <span class="hljs-literal">None</span>,
        <span class="hljs-string">&quot;feature_color&quot;</span>: (<span class="hljs-number">0.2</span>, <span class="hljs-number">0.2</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0.5</span>),
        <span class="hljs-string">&quot;vertical&quot;</span>: <span class="hljs-literal">False</span>,
    },
)`,wrap:!1}}),Se=new ys({props:{title:"Resources and Further Reading",local:"resources-and-further-reading",headingTag:"h2"}}),{c(){u=i("meta"),Le=a(),Ee=i("p"),Ze=a(),m(T.$$.fragment),Qe=a(),U=i("p"),U.textContent=ws,Ye=a(),m(d.$$.fragment),Ve=a(),J=i("p"),J.textContent=Ts,Xe=a(),b=i("p"),b.textContent=Us,De=a(),C=i("p"),C.textContent=ds,Ke=a(),m(g.$$.fragment),He=a(),m(j.$$.fragment),Pe=a(),k=i("p"),k.innerHTML=Js,qe=a(),$=i("p"),$.textContent=bs,Oe=a(),m(I.$$.fragment),et=a(),v=i("p"),v.textContent=Cs,tt=a(),m(R.$$.fragment),st=a(),x=i("p"),x.textContent=gs,lt=a(),m(N.$$.fragment),at=a(),B=i("p"),B.textContent=js,nt=a(),m(F.$$.fragment),it=a(),_=i("p"),_.textContent=ks,pt=a(),m(z.$$.fragment),rt=a(),w=i("div"),w.innerHTML=$s,mt=a(),G=i("p"),G.innerHTML=Is,ot=a(),S=i("p"),S.textContent=vs,Mt=a(),m(W.$$.fragment),ht=a(),E=i("p"),E.textContent=Rs,ct=a(),m(A.$$.fragment),yt=a(),L=i("p"),L.innerHTML=xs,ft=a(),m(Z.$$.fragment),ut=a(),Q=i("p"),Q.textContent=Ns,wt=a(),m(Y.$$.fragment),Tt=a(),V=i("p"),V.textContent=Bs,Ut=a(),m(X.$$.fragment),dt=a(),D=i("p"),D.textContent=Fs,Jt=a(),m(K.$$.fragment),bt=a(),H=i("p"),H.innerHTML=_s,Ct=a(),P=i("p"),P.innerHTML=zs,gt=a(),q=i("p"),q.textContent=Gs,jt=a(),m(O.$$.fragment),kt=a(),ee=i("p"),ee.textContent=Ss,$t=a(),m(te.$$.fragment),It=a(),se=i("p"),se.textContent=Ws,vt=a(),m(le.$$.fragment),Rt=a(),ae=i("p"),ae.textContent=Es,xt=a(),m(ne.$$.fragment),Nt=a(),ie=i("p"),ie.textContent=As,Bt=a(),m(pe.$$.fragment),Ft=a(),re=i("p"),re.textContent=Ls,_t=a(),m(me.$$.fragment),zt=a(),oe=i("p"),oe.textContent=Zs,Gt=a(),m(Me.$$.fragment),St=a(),he=i("p"),he.textContent=Qs,Wt=a(),m(ce.$$.fragment),Et=a(),ye=i("p"),ye.textContent=Ys,At=a(),m(fe.$$.fragment),Lt=a(),ue=i("p"),ue.innerHTML=Vs,Zt=a(),m(we.$$.fragment),Qt=a(),Te=i("p"),Te.innerHTML=Xs,Yt=a(),Ue=i("p"),Ue.textContent=Ds,Vt=a(),de=i("p"),de.innerHTML=Ks,Xt=a(),m(Je.$$.fragment),Dt=a(),be=i("p"),be.textContent=Hs,Kt=a(),m(Ce.$$.fragment),Ht=a(),ge=i("p"),ge.textContent=Ps,Pt=a(),m(je.$$.fragment),qt=a(),ke=i("p"),ke.textContent=qs,Ot=a(),m($e.$$.fragment),es=a(),Ie=i("p"),Ie.textContent=Os,ts=a(),m(ve.$$.fragment),ss=a(),Re=i("p"),Re.textContent=el,ls=a(),m(xe.$$.fragment),as=a(),Ne=i("p"),Ne.innerHTML=tl,ns=a(),m(Be.$$.fragment),is=a(),Fe=i("p"),Fe.textContent=sl,ps=a(),m(_e.$$.fragment),rs=a(),ze=i("p"),ze.textContent=ll,ms=a(),Ge=i("p"),Ge.innerHTML=al,os=a(),m(Se.$$.fragment),Ms=a(),We=i("ul"),We.innerHTML=nl,hs=a(),Ae=i("p"),this.h()},l(e){const t=hl("svelte-u9bgzb",document.head);u=p(t,"META",{name:!0,content:!0}),t.forEach(s),Le=n(e),Ee=p(e,"P",{}),il(Ee).forEach(s),Ze=n(e),o(T.$$.fragment,e),Qe=n(e),U=p(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-15xns04"&&(U.textContent=ws),Ye=n(e),o(d.$$.fragment,e),Ve=n(e),J=p(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-on1oww"&&(J.textContent=Ts),Xe=n(e),b=p(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-18ol5uq"&&(b.textContent=Us),De=n(e),C=p(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-wejofh"&&(C.textContent=ds),Ke=n(e),o(g.$$.fragment,e),He=n(e),o(j.$$.fragment,e),Pe=n(e),k=p(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-9u0yio"&&(k.innerHTML=Js),qe=n(e),$=p(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-w6x33t"&&($.textContent=bs),Oe=n(e),o(I.$$.fragment,e),et=n(e),v=p(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1rqvoxt"&&(v.textContent=Cs),tt=n(e),o(R.$$.fragment,e),st=n(e),x=p(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1s4nnss"&&(x.textContent=gs),lt=n(e),o(N.$$.fragment,e),at=n(e),B=p(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-11pmghx"&&(B.textContent=js),nt=n(e),o(F.$$.fragment,e),it=n(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1dxu9r2"&&(_.textContent=ks),pt=n(e),o(z.$$.fragment,e),rt=n(e),w=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-65csdm"&&(w.innerHTML=$s),mt=n(e),G=p(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-ugbzmf"&&(G.innerHTML=Is),ot=n(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-118nbqb"&&(S.textContent=vs),Mt=n(e),o(W.$$.fragment,e),ht=n(e),E=p(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1db2byq"&&(E.textContent=Rs),ct=n(e),o(A.$$.fragment,e),yt=n(e),L=p(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-16ya51f"&&(L.innerHTML=xs),ft=n(e),o(Z.$$.fragment,e),ut=n(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1qu6t9d"&&(Q.textContent=Ns),wt=n(e),o(Y.$$.fragment,e),Tt=n(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-16suw0v"&&(V.textContent=Bs),Ut=n(e),o(X.$$.fragment,e),dt=n(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1uxd7nf"&&(D.textContent=Fs),Jt=n(e),o(K.$$.fragment,e),bt=n(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1br77qa"&&(H.innerHTML=_s),Ct=n(e),P=p(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1bts3l5"&&(P.innerHTML=zs),gt=n(e),q=p(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-12c8hlw"&&(q.textContent=Gs),jt=n(e),o(O.$$.fragment,e),kt=n(e),ee=p(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-xztual"&&(ee.textContent=Ss),$t=n(e),o(te.$$.fragment,e),It=n(e),se=p(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-aqv1ru"&&(se.textContent=Ws),vt=n(e),o(le.$$.fragment,e),Rt=n(e),ae=p(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-nee6yp"&&(ae.textContent=Es),xt=n(e),o(ne.$$.fragment,e),Nt=n(e),ie=p(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-j9xg9v"&&(ie.textContent=As),Bt=n(e),o(pe.$$.fragment,e),Ft=n(e),re=p(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1owh1z6"&&(re.textContent=Ls),_t=n(e),o(me.$$.fragment,e),zt=n(e),oe=p(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-fflevz"&&(oe.textContent=Zs),Gt=n(e),o(Me.$$.fragment,e),St=n(e),he=p(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-wxpfev"&&(he.textContent=Qs),Wt=n(e),o(ce.$$.fragment,e),Et=n(e),ye=p(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1v2s6y7"&&(ye.textContent=Ys),At=n(e),o(fe.$$.fragment,e),Lt=n(e),ue=p(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1wrykwq"&&(ue.innerHTML=Vs),Zt=n(e),o(we.$$.fragment,e),Qt=n(e),Te=p(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-lacwgz"&&(Te.innerHTML=Xs),Yt=n(e),Ue=p(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-9siw9c"&&(Ue.textContent=Ds),Vt=n(e),de=p(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1e39a5t"&&(de.innerHTML=Ks),Xt=n(e),o(Je.$$.fragment,e),Dt=n(e),be=p(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-srwjmc"&&(be.textContent=Hs),Kt=n(e),o(Ce.$$.fragment,e),Ht=n(e),ge=p(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-5yf40"&&(ge.textContent=Ps),Pt=n(e),o(je.$$.fragment,e),qt=n(e),ke=p(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-h1pkxc"&&(ke.textContent=qs),Ot=n(e),o($e.$$.fragment,e),es=n(e),Ie=p(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-mpwa7r"&&(Ie.textContent=Os),ts=n(e),o(ve.$$.fragment,e),ss=n(e),Re=p(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-1d3obuy"&&(Re.textContent=el),ls=n(e),o(xe.$$.fragment,e),as=n(e),Ne=p(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-1pdz4rs"&&(Ne.innerHTML=tl),ns=n(e),o(Be.$$.fragment,e),is=n(e),Fe=p(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-162adi5"&&(Fe.textContent=sl),ps=n(e),o(_e.$$.fragment,e),rs=n(e),ze=p(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-19n2hbq"&&(ze.textContent=ll),ms=n(e),Ge=p(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1p8df1m"&&(Ge.innerHTML=al),os=n(e),o(Se.$$.fragment,e),Ms=n(e),We=p(e,"UL",{"data-svelte-h":!0}),r(We)!=="svelte-5o0z5y"&&(We.innerHTML=nl),hs=n(e),Ae=p(e,"P",{}),il(Ae).forEach(s),this.h()},h(){fs(u,"name","hf:doc:metadata"),fs(u,"content",fl),fs(w,"class","flex justify-center")},m(e,t){cl(document.head,u),l(e,Le,t),l(e,Ee,t),l(e,Ze,t),M(T,e,t),l(e,Qe,t),l(e,U,t),l(e,Ye,t),M(d,e,t),l(e,Ve,t),l(e,J,t),l(e,Xe,t),l(e,b,t),l(e,De,t),l(e,C,t),l(e,Ke,t),M(g,e,t),l(e,He,t),M(j,e,t),l(e,Pe,t),l(e,k,t),l(e,qe,t),l(e,$,t),l(e,Oe,t),M(I,e,t),l(e,et,t),l(e,v,t),l(e,tt,t),M(R,e,t),l(e,st,t),l(e,x,t),l(e,lt,t),M(N,e,t),l(e,at,t),l(e,B,t),l(e,nt,t),M(F,e,t),l(e,it,t),l(e,_,t),l(e,pt,t),M(z,e,t),l(e,rt,t),l(e,w,t),l(e,mt,t),l(e,G,t),l(e,ot,t),l(e,S,t),l(e,Mt,t),M(W,e,t),l(e,ht,t),l(e,E,t),l(e,ct,t),M(A,e,t),l(e,yt,t),l(e,L,t),l(e,ft,t),M(Z,e,t),l(e,ut,t),l(e,Q,t),l(e,wt,t),M(Y,e,t),l(e,Tt,t),l(e,V,t),l(e,Ut,t),M(X,e,t),l(e,dt,t),l(e,D,t),l(e,Jt,t),M(K,e,t),l(e,bt,t),l(e,H,t),l(e,Ct,t),l(e,P,t),l(e,gt,t),l(e,q,t),l(e,jt,t),M(O,e,t),l(e,kt,t),l(e,ee,t),l(e,$t,t),M(te,e,t),l(e,It,t),l(e,se,t),l(e,vt,t),M(le,e,t),l(e,Rt,t),l(e,ae,t),l(e,xt,t),M(ne,e,t),l(e,Nt,t),l(e,ie,t),l(e,Bt,t),M(pe,e,t),l(e,Ft,t),l(e,re,t),l(e,_t,t),M(me,e,t),l(e,zt,t),l(e,oe,t),l(e,Gt,t),M(Me,e,t),l(e,St,t),l(e,he,t),l(e,Wt,t),M(ce,e,t),l(e,Et,t),l(e,ye,t),l(e,At,t),M(fe,e,t),l(e,Lt,t),l(e,ue,t),l(e,Zt,t),M(we,e,t),l(e,Qt,t),l(e,Te,t),l(e,Yt,t),l(e,Ue,t),l(e,Vt,t),l(e,de,t),l(e,Xt,t),M(Je,e,t),l(e,Dt,t),l(e,be,t),l(e,Kt,t),M(Ce,e,t),l(e,Ht,t),l(e,ge,t),l(e,Pt,t),M(je,e,t),l(e,qt,t),l(e,ke,t),l(e,Ot,t),M($e,e,t),l(e,es,t),l(e,Ie,t),l(e,ts,t),M(ve,e,t),l(e,ss,t),l(e,Re,t),l(e,ls,t),M(xe,e,t),l(e,as,t),l(e,Ne,t),l(e,ns,t),M(Be,e,t),l(e,is,t),l(e,Fe,t),l(e,ps,t),M(_e,e,t),l(e,rs,t),l(e,ze,t),l(e,ms,t),l(e,Ge,t),l(e,os,t),M(Se,e,t),l(e,Ms,t),l(e,We,t),l(e,hs,t),l(e,Ae,t),cs=!0},p:rl,i(e){cs||(h(T.$$.fragment,e),h(d.$$.fragment,e),h(g.$$.fragment,e),h(j.$$.fragment,e),h(I.$$.fragment,e),h(R.$$.fragment,e),h(N.$$.fragment,e),h(F.$$.fragment,e),h(z.$$.fragment,e),h(W.$$.fragment,e),h(A.$$.fragment,e),h(Z.$$.fragment,e),h(Y.$$.fragment,e),h(X.$$.fragment,e),h(K.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),h(le.$$.fragment,e),h(ne.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),h(Me.$$.fragment,e),h(ce.$$.fragment,e),h(fe.$$.fragment,e),h(we.$$.fragment,e),h(Je.$$.fragment,e),h(Ce.$$.fragment,e),h(je.$$.fragment,e),h($e.$$.fragment,e),h(ve.$$.fragment,e),h(xe.$$.fragment,e),h(Be.$$.fragment,e),h(_e.$$.fragment,e),h(Se.$$.fragment,e),cs=!0)},o(e){c(T.$$.fragment,e),c(d.$$.fragment,e),c(g.$$.fragment,e),c(j.$$.fragment,e),c(I.$$.fragment,e),c(R.$$.fragment,e),c(N.$$.fragment,e),c(F.$$.fragment,e),c(z.$$.fragment,e),c(W.$$.fragment,e),c(A.$$.fragment,e),c(Z.$$.fragment,e),c(Y.$$.fragment,e),c(X.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(le.$$.fragment,e),c(ne.$$.fragment,e),c(pe.$$.fragment,e),c(me.$$.fragment,e),c(Me.$$.fragment,e),c(ce.$$.fragment,e),c(fe.$$.fragment,e),c(we.$$.fragment,e),c(Je.$$.fragment,e),c(Ce.$$.fragment,e),c(je.$$.fragment,e),c($e.$$.fragment,e),c(ve.$$.fragment,e),c(xe.$$.fragment,e),c(Be.$$.fragment,e),c(_e.$$.fragment,e),c(Se.$$.fragment,e),cs=!1},d(e){e&&(s(Le),s(Ee),s(Ze),s(Qe),s(U),s(Ye),s(Ve),s(J),s(Xe),s(b),s(De),s(C),s(Ke),s(He),s(Pe),s(k),s(qe),s($),s(Oe),s(et),s(v),s(tt),s(st),s(x),s(lt),s(at),s(B),s(nt),s(it),s(_),s(pt),s(rt),s(w),s(mt),s(G),s(ot),s(S),s(Mt),s(ht),s(E),s(ct),s(yt),s(L),s(ft),s(ut),s(Q),s(wt),s(Tt),s(V),s(Ut),s(dt),s(D),s(Jt),s(bt),s(H),s(Ct),s(P),s(gt),s(q),s(jt),s(kt),s(ee),s($t),s(It),s(se),s(vt),s(Rt),s(ae),s(xt),s(Nt),s(ie),s(Bt),s(Ft),s(re),s(_t),s(zt),s(oe),s(Gt),s(St),s(he),s(Wt),s(Et),s(ye),s(At),s(Lt),s(ue),s(Zt),s(Qt),s(Te),s(Yt),s(Ue),s(Vt),s(de),s(Xt),s(Dt),s(be),s(Kt),s(Ht),s(ge),s(Pt),s(qt),s(ke),s(Ot),s(es),s(Ie),s(ts),s(ss),s(Re),s(ls),s(as),s(Ne),s(ns),s(is),s(Fe),s(ps),s(rs),s(ze),s(ms),s(Ge),s(os),s(Ms),s(We),s(hs),s(Ae)),s(u),y(T,e),y(d,e),y(g,e),y(j,e),y(I,e),y(R,e),y(N,e),y(F,e),y(z,e),y(W,e),y(A,e),y(Z,e),y(Y,e),y(X,e),y(K,e),y(O,e),y(te,e),y(le,e),y(ne,e),y(pe,e),y(me,e),y(Me,e),y(ce,e),y(fe,e),y(we,e),y(Je,e),y(Ce,e),y(je,e),y($e,e),y(ve,e),y(xe,e),y(Be,e),y(_e,e),y(Se,e)}}}const fl='{"title":"Feature Matching","local":"feature-matching","sections":[{"title":"Brute-Force Search","local":"brute-force-search","sections":[],"depth":2},{"title":"Local Feature Matching with Transformers (LoFTR)","local":"local-feature-matching-with-transformers-loftr","sections":[],"depth":2},{"title":"Resources and Further Reading","local":"resources-and-further-reading","sections":[],"depth":2}],"depth":1}';function ul(us){return ml(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Jl extends ol{constructor(u){super(),Ml(this,u,ul,yl,pl,{})}}export{Jl as component};
