import{s as Oi,n as Ri,o as Ei}from"../chunks/scheduler.7bc62968.js";import{S as qi,i as Ai,g as m,s as n,r as y,m as d,H as h,A as ji,h as l,f as t,c as i,j as o,u as w,x as p,n as f,B as c,k as C,y as r,a as e,v as _,d as x,t as b,w as L}from"../chunks/index.2f8492b0.js";import{H as M}from"../chunks/Heading.14fb2476.js";function Si(Ve){let P,_t,it,xt,A,bt,j,Ze="This section explains how stereo vision works and how it can be used to find the 3-dimensional structure of surrounding objects. Stereo vision involves capturing two or more images of the same scene from varying positions and viewpoints. These images can be obtained using multiple cameras or by repositioning the same camera.",Lt,S,Mt,W,Ge="Let’s understand the problem statement of finding the 3D structure of objects by understanding the geometry of image formation. As shown in Figure 1, we have a point P in 3D with x, y, z coordinates. Point P gets projected to the camera’s image plane via the pinhole. This can also be viewed as projecting a 3D point to a 2D image plane.",kt,F,Je="Now, let’s say we are given this 2D image and the location of the pixel coordinates of point P in this image. We want to find the 3D coordinates of point P. Is this possible? Is point P unique, or are there other 3D points that also map to the same pixel coordinates as point P? Answer is that all 3D points that lie on the line joining point P, and the pinhole will map to the same pixel coordinates in the 2D image plane.",Ct,K,Qe="We aim to solve the problem of determining the 3D structure of objects. In our problem statement, we can represent an object in 3D as a set of 3D points. Finding the 3D coordinates of each of these points helps us determine the 3D structure of the object.",zt,U,an='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/image_formation_single_camera.png?download=true" alt="Figure 1: Image formation using single camera"/>',$t,Y,tn="Figure 1: Image formation using single camera",Tt,B,Pt,X,sn="Let’s assume we are given the following information:",It,N,en="<li>Single image of a scene point P</li> <li>Pixel coordinates of point P in the image</li> <li>Position and orientation of the camera used to capture the image. For simplicity, we can also place an XYZ coordinate system at the location of the pinhole, with the z-axis perpendicular to the image place and the x-axis, and y-axis parallel to the image plane like in Figure 1.</li> <li>Internal parameters of the camera, such as focal length and location of principal point. The principal point is where the optical axis intersects the image plane. Its location in the image plane is usually denoted as (Ox,Oy).</li>",Ht,V,nn="With the information provided above, we can find a 3D line that originates from the pixel coordinates of point P (the projection of point P in the image plane), passes through the pinhole, and extends to infinity. Based on the principles of image formation geometry, we can conclude that point P must exist somewhere along this line.",Dt,Z,mn="<li>Initially (without an image) point P could have been present anywhere in the 3D space.</li> <li>Using a single image, we reduced possible locations of point P to a single line in 3D.</li> <li>Now, let’s consider whether we can further narrow down the potential locations to pinpoint the precise location of point P on this 3D line.</li> <li>Imagine moving the camera to a different position. Let the coordinate system remain fixed at the previous position. The 3D line we found also remains the same and point P still lies somewhere on this line.</li> <li>From this new location of the camera, capture another image of the same scene point P. Once more, utilizing the pixel coordinates of point P within this new image and considering the updated location of the camera pinhole, find the 3D line on which point P must lie.</li> <li>Now we have 2 lines in 3D and point P lies somewhere on both of these lines. So, point P must lie on the intersection of these 2 lines.</li>",Ot,G,ln="Given 2 lines in 3D, there are are three possibilities for their intersection:",Rt,J,rn="<li>Intersect at exactly 1 point</li> <li>Intersect at infinite number of points</li> <li>Do not intersect</li>",Et,Q,pn="If both images (with original and new camera positions) contain point P, we can conclude that the 3D lines must intersect at least once and that the intersection point is point P. Furthermore, we can envision infinite points where both lines intersect only if the two lines are collinear. This is achievable if the pinhole at the new camera position lies somewhere on the original 3D line. For all other positions and orientations of the new camera location, the two 3D lines must intersect precisely at one point, where point P lies.",qt,aa,on="Therefore, using 2 images of the same scene point P, known positions and orientations of the camera locations, and known internal parameters of the camera, we can precisely find where point P lies in the 3D space.",At,ta,jt,sa,hn="Since there are many different positions and orientations for the camera locations which can be selected, we can select a location that makes the math simpler, less complex, and reduces computational processing when running on a computer or an embedded device. One configuration that is popular and generally used is shown in Figure 2. We use 2 cameras in this configuration, which is equivalent to a single camera for capturing 2 images from 2 different locations.",St,ea,cn='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/image_formation_simple_stereo.jpg?download=true" alt="Figure 2: Image formation using 2 cameras"/>',Wt,na,gn="Figure 2: Image formation using 2 cameras",Ft,ia,dn="<li>Origin of the coordinate system is placed at the pinhole of the first camera which is usually the left camera.</li> <li>Z axis of the coordinate system is defined perpendicular to the image plane.</li> <li>X and Y axis of the coordinate system are defined parallel to the image plane.</li> <li>We also have X and Y directions in a 2D image. X is the horizontal direction and Y is the vertical direction. We will refer to these directions in the image plane as u and v respectively. Therefore, pixel coordinates of a point are defined using (u,v) values.</li> <li>X axis of the coordinate system is defined as the u direction / horizontal direction in the image plane.</li> <li>Similarly Y axis of the coordinate system is defined as the v direction / vertical direction in the image plane.</li> <li>Second camera (more precisely the pinhole of the second camera) is placed at a distance b called baseline in the positive x direction to the right of the first camera. Therefore, x,y,z coordinates of pinhole of second camera are (b,0,0)</li> <li>Image plane of the second camera is oriented parallel to the image plane of the first camera.</li> <li>u and v directions in the image plane of second/right camera are aligned with the u and v directions in the image plane of the first/left camera</li> <li>Both left and right cameras are assumed to have the same intrinsic parameters like focal length and location of principal point</li>",Kt,ma,fn="With the above configuration in place, we have the below equations which map a point in 3D to the image plane in 2D.",Ut,I,Ya,Me,la,mt,Yt,li='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>=</mo><mi>f</mi><mi mathvariant="normal">_</mi><mi>x</mi><mo>∗</mo><mfrac><mi>x</mi><mi>z</mi></mfrac><mo>+</mo><mi>O</mi><mi mathvariant="normal">_</mi><mi>x</mi></mrow><annotation encoding="application/x-tex">u\\_left = f\\_x * \\frac{x}{z} + O\\_x</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal">x</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.0404em;vertical-align:-0.345em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.6954em;"><span style="top:-2.655em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.04398em;">z</span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.394em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">x</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.345em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.9933em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">O</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal">x</span></span></span></span>',ke,lt,Bt,ri='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>v</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>=</mo><mi>f</mi><mi mathvariant="normal">_</mi><mi>y</mi><mo>∗</mo><mfrac><mi>y</mi><mi>z</mi></mfrac><mo>+</mo><mi>O</mi><mi mathvariant="normal">_</mi><mi>y</mi></mrow><annotation encoding="application/x-tex">v\\_left = f\\_y * \\frac{y}{z} + O\\_y</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.03588em;">y</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.0925em;vertical-align:-0.345em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.7475em;"><span style="top:-2.655em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.04398em;">z</span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.4461em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.03588em;">y</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.345em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.9933em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">O</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.03588em;">y</span></span></span></span>',Ce,Ba,ze,ra,rt,Xt,pi='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi><mo>=</mo><mi>f</mi><mi mathvariant="normal">_</mi><mi>x</mi><mo>∗</mo><mfrac><mrow><mi>x</mi><mo>−</mo><mi>b</mi></mrow><mi>z</mi></mfrac><mo>+</mo><mi>O</mi><mi mathvariant="normal">_</mi><mi>x</mi></mrow><annotation encoding="application/x-tex">u\\_right = f\\_x * \\frac{x-b}{z} + O\\_x</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord mathnormal">i</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord mathnormal">h</span><span class="mord mathnormal">t</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal">x</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.2251em;vertical-align:-0.345em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8801em;"><span style="top:-2.655em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.04398em;">z</span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.394em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">x</span><span class="mbin mtight">−</span><span class="mord mathnormal mtight">b</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.345em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.9933em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">O</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal">x</span></span></span></span>',$e,pt,Nt,oi='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>v</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi><mo>=</mo><mi>f</mi><mi mathvariant="normal">_</mi><mi>y</mi><mo>∗</mo><mfrac><mi>y</mi><mi>z</mi></mfrac><mo>+</mo><mi>O</mi><mi mathvariant="normal">_</mi><mi>y</mi></mrow><annotation encoding="application/x-tex">v\\_right = f\\_y * \\frac{y}{z} + O\\_y</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord mathnormal">i</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord mathnormal">h</span><span class="mord mathnormal">t</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.03588em;">y</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.0925em;vertical-align:-0.345em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.7475em;"><span style="top:-2.655em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.04398em;">z</span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.4461em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.03588em;">y</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.345em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.9933em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">O</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.03588em;">y</span></span></span></span>',Vt,pa,un="Different symbols used in above equations are defined below:",Zt,u,H,Gt,hi='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">u\\_left</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span></span></span></span>',Jt,Qt,ci='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>v</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">v\\_left</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span></span></span></span>',as,Te,D,ts,gi='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">u\\_right</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord mathnormal">i</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord mathnormal">h</span><span class="mord mathnormal">t</span></span></span></span>',ss,es,di='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>v</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">v\\_right</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord mathnormal">i</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord mathnormal">h</span><span class="mord mathnormal">t</span></span></span></span>',ns,Pe,O,is,fi='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>f</mi><mi mathvariant="normal">_</mi><mi>x</mi></mrow><annotation encoding="application/x-tex">f\\_x</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal">x</span></span></span></span>',ms,ls,ui='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>f</mi><mi mathvariant="normal">_</mi><mi>y</mi></mrow><annotation encoding="application/x-tex">f\\_y</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.03588em;">y</span></span></span></span>',rs,Ie,Xa,vn="x,y,z are 3D coordinates of the point P (any unit like cm, feet, etc can be used)",He,R,ps,vi='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>O</mi><mi mathvariant="normal">_</mi><mi>x</mi></mrow><annotation encoding="application/x-tex">O\\_x</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9933em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">O</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal">x</span></span></span></span>',os,hs,yi='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>O</mi><mi mathvariant="normal">_</mi><mi>y</mi></mrow><annotation encoding="application/x-tex">O\\_y</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9933em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">O</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.03588em;">y</span></span></span></span>',cs,De,Na,yn="b is called the baseline and refers to the distance between the left and right cameras. Same units are used for both b and x,y,z coordinates (any unit like cm, feet, etc can be used)",gs,oa,wn="We have 4 equations above and 3 unknowns - x, y and z coordinates of a 3D point P. Intrinsic camera parameters - focal lengths and principal point are assumed to be known. Equations 1.2 and 2.2 indicate that the v coordinate value in the left and right images is the same.",ds,ha,ot,fs,wi='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>v</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>=</mo><mi>v</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">v\\_left = v\\_right</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord mathnormal">i</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord mathnormal">h</span><span class="mord mathnormal">t</span></span></span></span>',us,ca,_n="Using equations 1.1, 1.2 and 2.1 we can derive the x,y,z coordinates of point P.",vs,z,ht,ys,_i='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>x</mi><mo>=</mo><mfrac><mrow><mi>b</mi><mo>∗</mo><mo stretchy="false">(</mo><mi>u</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>−</mo><mi>O</mi><mi mathvariant="normal">_</mi><mi>x</mi><mo stretchy="false">)</mo></mrow><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>−</mo><mi>u</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi></mrow></mfrac></mrow><annotation encoding="application/x-tex">x = \\frac{b * (u\\_left - O\\_x)}{u\\_left - u\\_right}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.4306em;"></span><span class="mord mathnormal">x</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.614em;vertical-align:-0.562em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.052em;"><span style="top:-2.655em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">u</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span><span class="mord mathnormal mtight">e</span><span class="mord mathnormal mtight" style="margin-right:0.10764em;">f</span><span class="mord mathnormal mtight">t</span><span class="mbin mtight">−</span><span class="mord mathnormal mtight">u</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight" style="margin-right:0.02778em;">r</span><span class="mord mathnormal mtight">i</span><span class="mord mathnormal mtight" style="margin-right:0.03588em;">g</span><span class="mord mathnormal mtight">h</span><span class="mord mathnormal mtight">t</span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.527em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">b</span><span class="mbin mtight">∗</span><span class="mopen mtight">(</span><span class="mord mathnormal mtight">u</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span><span class="mord mathnormal mtight">e</span><span class="mord mathnormal mtight" style="margin-right:0.10764em;">f</span><span class="mord mathnormal mtight">t</span><span class="mbin mtight">−</span><span class="mord mathnormal mtight" style="margin-right:0.02778em;">O</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight">x</span><span class="mclose mtight">)</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.562em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span></span></span></span>',Oe,ct,ws,xi='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>y</mi><mo>=</mo><mfrac><mrow><mi>b</mi><mo>∗</mo><mi>f</mi><mi mathvariant="normal">_</mi><mi>x</mi><mo>∗</mo><mo stretchy="false">(</mo><mi>v</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>−</mo><mi>O</mi><mi mathvariant="normal">_</mi><mi>y</mi><mo stretchy="false">)</mo></mrow><mrow><mi>f</mi><mi mathvariant="normal">_</mi><mi>y</mi><mo>∗</mo><mo stretchy="false">(</mo><mi>u</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>−</mo><mi>u</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi><mo stretchy="false">)</mo></mrow></mfrac></mrow><annotation encoding="application/x-tex">y = \\frac{b * f\\_x * (v\\_left - O\\_y)}{ f\\_y * (u\\_left - u\\_right)}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.625em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">y</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.614em;vertical-align:-0.562em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.052em;"><span style="top:-2.655em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.10764em;">f</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight" style="margin-right:0.03588em;">y</span><span class="mbin mtight">∗</span><span class="mopen mtight">(</span><span class="mord mathnormal mtight">u</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span><span class="mord mathnormal mtight">e</span><span class="mord mathnormal mtight" style="margin-right:0.10764em;">f</span><span class="mord mathnormal mtight">t</span><span class="mbin mtight">−</span><span class="mord mathnormal mtight">u</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight" style="margin-right:0.02778em;">r</span><span class="mord mathnormal mtight">i</span><span class="mord mathnormal mtight" style="margin-right:0.03588em;">g</span><span class="mord mathnormal mtight">h</span><span class="mord mathnormal mtight">t</span><span class="mclose mtight">)</span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.527em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">b</span><span class="mbin mtight">∗</span><span class="mord mathnormal mtight" style="margin-right:0.10764em;">f</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight">x</span><span class="mbin mtight">∗</span><span class="mopen mtight">(</span><span class="mord mathnormal mtight" style="margin-right:0.03588em;">v</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span><span class="mord mathnormal mtight">e</span><span class="mord mathnormal mtight" style="margin-right:0.10764em;">f</span><span class="mord mathnormal mtight">t</span><span class="mbin mtight">−</span><span class="mord mathnormal mtight" style="margin-right:0.02778em;">O</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight" style="margin-right:0.03588em;">y</span><span class="mclose mtight">)</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.562em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span></span></span></span>',Re,gt,_s,bi='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>z</mi><mo>=</mo><mfrac><mrow><mi>b</mi><mo>∗</mo><mi>f</mi><mi mathvariant="normal">_</mi><mi>x</mi></mrow><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>−</mo><mi>u</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi></mrow></mfrac></mrow><annotation encoding="application/x-tex">z = \\frac{b * f\\_x}{u\\_left - u\\_right}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.4306em;"></span><span class="mord mathnormal" style="margin-right:0.04398em;">z</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.5751em;vertical-align:-0.562em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.0131em;"><span style="top:-2.655em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">u</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span><span class="mord mathnormal mtight">e</span><span class="mord mathnormal mtight" style="margin-right:0.10764em;">f</span><span class="mord mathnormal mtight">t</span><span class="mbin mtight">−</span><span class="mord mathnormal mtight">u</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight" style="margin-right:0.02778em;">r</span><span class="mord mathnormal mtight">i</span><span class="mord mathnormal mtight" style="margin-right:0.03588em;">g</span><span class="mord mathnormal mtight">h</span><span class="mord mathnormal mtight">t</span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.527em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">b</span><span class="mbin mtight">∗</span><span class="mord mathnormal mtight" style="margin-right:0.10764em;">f</span><span class="mord mtight" style="margin-right:0.02778em;">_</span><span class="mord mathnormal mtight">x</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.562em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span></span></span></span>',xs,ga,xn="Note that the x and y values above concern the left camera since the origin of the coordinate system is aligned with the left camera. The above equations show that we can find 3D coordinates of a point P using its 2 images captured from 2 different camera locations. z value is also referred to as the depth value. Using this technique, we can find the depth values for different pixels within an image and their real-world x and y coordinates. We can also find real-world distances between different points in an image.",bs,da,Ls,fa,Ms,ua,bn="We’ll work through an example, capture some images, and perform some calculations to find out if our above assumptions and math work out! For capturing the images we’ll use a hardware known as OAK-D Lite (OAK stands for OpenCV AI Kit). This device has 3 cameras - left and right mono (black and white) and a center color cameras. We’ll use the left and right mono cameras for our experiment. A regular smartphone camera could also be used, but OAK-D lite has some advantages listed below.",ks,va,Ln="<li>Intrinsic camera parameters like focal length and location of principal point are known for an OAK-D Lite since the device comes pre-calibrated, and these parameters can be read from the device using its Python API. For a smartphone camera, intrinsic parameters need to be determined and could be found by performing camera calibration or sometimes present in the metadata of the image captured using the smartphone.</li> <li>One of the main assumptions above is that the position and orientation of the left and right cameras are known. Using a smartphone camera, it may be difficult to determine this information or additional calibration may be required.  On the other hand, for an OAK-D Lite device, the position and orientation of the left and right cameras are fixed, known, pre-calibrated, and very similar to the geometry of the simplified solution mentioned above. Although some post-processing/image rectification detailed below on the raw images is still required.</li>",Cs,ya,zs,wa,Mn="The left and right cameras in OAK-D Lite are oriented similarly to the geometry of the simplified solution detailed above. The baseline distance between the left and right cameras is 7.5cm. Left and right images of a scene captured using this device are shown below. The figure also shows these images stacked horizontally with a red line drawn at a constant height (i.e. at a constant v value ). We’ll refer to the horizontal x-axis as u and the vertical y-axis as v.",$s,_a,kn=`Raw Left Image
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/unrectified_left_frame.jpg?download=true" alt="Raw Left Image"/>`,Ts,xa,Cn=`Raw Right Image
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/unrectified_right_frame.jpg?download=true" alt="Raw Right Image"/>`,Ps,ba,zn=`<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/unrectified_stacked_frames.jpg?download=true" alt="Raw Stacked Left and Right Images "/>
Raw Stacked Left and Right Images`,Is,E,Ee,Hs,Li='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>v</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>=</mo><mi>v</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">v\\_left = v\\_right</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord mathnormal">i</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord mathnormal">h</span><span class="mord mathnormal">t</span></span></span></span>',Ds,Os,La,$n="<li>The intrinsic parameters for the left and right cameras are different. The principal point for the left camera is at (319.13, 233.86), whereas it is (298.85, 245.52) for the right camera. The focal length for the left camera is 450.9, whereas it is 452.9 for the right camera. The values of fx are equal to fy for both the left and right cameras. These intrinsic parameters were read from the device using it’s python API and could be different for different OAK-D Lite devices.</li> <li>Left and right camera orientations differ slightly from the geometry of the simplified solution detailed above.</li>",Rs,Ma,Es,ka,Tn='We can perform image rectification/post-processing to correct for differences in intrinsic parameters and orientations of the left and right cameras. This process involves performing 3x3 matrix transformations. In the OAK-D Lite API, a stereo node performs these calculations and outputs the rectified left and right images. Details and source code can be viewed <a href="https://github.com/luxonis/depthai-experiments/blob/master/gen2-stereo-on-host/main.py" rel="nofollow">here</a>. In this specific implementation, correction for intrinsic parameters is performed using intrinsic camera matrices, and correction for orientation is performed using rotation matrices(part of calibration parameters) for the left and right cameras. The rectified left image is transformed as if the left camera had the same intrinsic parameters as the right one. Therefore, in all our following calculations, we’ll use the intrinsic parameters for the right camera i.e. focal length of 452.9 and principal point at (298.85, 245.52). In the rectified and stacked images below, notice that the red line at constant v touches the top-left corner of the laptop in both the left and right images.',qs,Ca,Pn=`Rectified Left Image
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/rectified_left_frame.jpg?download=true" alt="Rectified Left Image"/>`,As,za,In=`Rectified Right Image
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/rectified_right_frame.jpg?download=true" alt="Rectified Right Image"/>`,js,$a,Hn=`Rectified and Stacked Left and Right Images
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/rectified_stacked_frames.jpg?download=true" alt="Rectified and Stacked Left and Right Images"/>`,Ss,$,qe,Ws,Mi='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>−</mo><mi>u</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">u\\_left - u\\_right</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord mathnormal">i</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord mathnormal">h</span><span class="mord mathnormal">t</span></span></span></span>',Fs,Ks,ki='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi><mo>−</mo><mi>u</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">u\\_left - u\\_right</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord mathnormal">i</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord mathnormal">h</span><span class="mord mathnormal">t</span></span></span></span>',Us,Ys,Ta,Dn=`Rectified and Overlapped Left and Right Images
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/rectified_overlapping_frames.jpg?download=true" alt="Rectified and Overlapped Left and Right Images"/>`,Bs,Pa,Xs,Ia,On="Let’s find the 3D coordinates for some points in the scene. A few points are selected and manually annotated with their (u,v) values, as shown in the figures below. Instead of manual annotations, we can also use template-based matching, feature detection algorithms like SIFT, etc for finding corresponding points in left and right images.",Ns,Ha,Rn=`Annotated Left Image
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/annotated_left_img.jpg?download=true" alt="Annotated Left Image"/>`,Vs,Da,En=`Annotated Right Image
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/annotated_right_img.jpg?download=true" alt="Annotated Right Image"/>`,Zs,Oa,Gs,Ra,qn="Twelve points are selected in the scene, and their (u,v) values in the left and right images are tabulated below. Using equations 4, 5, and 6, (x,y,z) coordinates for these points are also calculated and tabulated below. X and Y coordinates concerning the left camera, and the origin is at the left camera’s pinhole (or optical center of the lens). Therefore, 3D points left and above the pinhole have negative X and Y values, respectively.",Js,q,dt,g,Ea,An="point",Ae,Va,Qs,Ci='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">u\\_left</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span></span></span></span>',je,Za,ae,zi='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>v</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">v\\_left</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span></span></span></span>',Se,Ga,te,$i='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>u</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">u\\_right</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal">u</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord mathnormal">i</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord mathnormal">h</span><span class="mord mathnormal">t</span></span></span></span>',We,Ja,se,Ti='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>v</mi><mi mathvariant="normal">_</mi><mi>r</mi><mi>i</mi><mi>g</mi><mi>h</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">v\\_right</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord mathnormal">i</span><span class="mord mathnormal" style="margin-right:0.03588em;">g</span><span class="mord mathnormal">h</span><span class="mord mathnormal">t</span></span></span></span>',Fe,qa,jn="depth/z(cm)",Ke,Qa,ee,Pi='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>x</mi><mi mathvariant="normal">_</mi><mi>w</mi><mi>r</mi><mi>t</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">x\\_wrt\\_left</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal">x</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.02691em;">w</span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord mathnormal">t</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span></span></span></span>',Ue,at,ne,Ii='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>y</mi><mi mathvariant="normal">_</mi><mi>w</mi><mi>r</mi><mi>t</mi><mi mathvariant="normal">_</mi><mi>l</mi><mi>e</mi><mi>f</mi><mi>t</mi></mrow><annotation encoding="application/x-tex">y\\_wrt\\_left</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0044em;vertical-align:-0.31em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">y</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.02691em;">w</span><span class="mord mathnormal" style="margin-right:0.02778em;">r</span><span class="mord mathnormal">t</span><span class="mord" style="margin-right:0.02778em;">_</span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mord mathnormal">e</span><span class="mord mathnormal" style="margin-right:0.10764em;">f</span><span class="mord mathnormal">t</span></span></span></span>',Ye,tt,Sn='<tr><td align="center">pt1</td> <td align="center">138</td> <td align="center">219</td> <td align="center">102</td> <td align="center">219</td> <td align="center">94.36</td> <td align="center">-33.51</td> <td align="center">-5.53</td></tr> <tr><td align="center">pt2</td> <td align="center">264</td> <td align="center">216</td> <td align="center">234</td> <td align="center">217</td> <td align="center">113.23</td> <td align="center">-8.72</td> <td align="center">-7.38</td></tr> <tr><td align="center">pt3</td> <td align="center">137</td> <td align="center">320</td> <td align="center">101</td> <td align="center">321</td> <td align="center">94.36</td> <td align="center">-33.72</td> <td align="center">15.52</td></tr> <tr><td align="center">pt4</td> <td align="center">263</td> <td align="center">303</td> <td align="center">233</td> <td align="center">302</td> <td align="center">113.23</td> <td align="center">-8.97</td> <td align="center">14.37</td></tr> <tr><td align="center">pt5</td> <td align="center">307</td> <td align="center">211</td> <td align="center">280</td> <td align="center">211</td> <td align="center">125.81</td> <td align="center">2.26</td> <td align="center">-9.59</td></tr> <tr><td align="center">pt6</td> <td align="center">367</td> <td align="center">212</td> <td align="center">339</td> <td align="center">212</td> <td align="center">121.32</td> <td align="center">18.25</td> <td align="center">-8.98</td></tr> <tr><td align="center">pt7</td> <td align="center">305</td> <td align="center">298</td> <td align="center">278</td> <td align="center">298</td> <td align="center">125.81</td> <td align="center">1.71</td> <td align="center">14.58</td></tr> <tr><td align="center">pt8</td> <td align="center">365</td> <td align="center">299</td> <td align="center">338</td> <td align="center">299</td> <td align="center">125.81</td> <td align="center">18.37</td> <td align="center">14.86</td></tr> <tr><td align="center">pt9</td> <td align="center">466</td> <td align="center">225</td> <td align="center">415</td> <td align="center">225</td> <td align="center">66.61</td> <td align="center">24.58</td> <td align="center">-3.02</td></tr> <tr><td align="center">pt10</td> <td align="center">581</td> <td align="center">225</td> <td align="center">530</td> <td align="center">226</td> <td align="center">66.61</td> <td align="center">41.49</td> <td align="center">-3.02</td></tr> <tr><td align="center">pt11</td> <td align="center">464</td> <td align="center">387</td> <td align="center">413</td> <td align="center">388</td> <td align="center">66.61</td> <td align="center">24.29</td> <td align="center">20.81</td></tr> <tr><td align="center">pt12</td> <td align="center">579</td> <td align="center">388</td> <td align="center">528</td> <td align="center">390</td> <td align="center">66.61</td> <td align="center">41.2</td> <td align="center">20.95</td></tr>',ie,Aa,me,T,Be,le,Hi=`<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>d</mi><mi>i</mi><mi>s</mi><mi>t</mi><mi>a</mi><mi>n</mi><mi>c</mi><mi>e</mi><mo>=</mo><msqrt><mrow><mo stretchy="false">(</mo><mi>x</mi><mi mathvariant="normal">_</mi><mn>2</mn><mo>−</mo><mi>x</mi><mi mathvariant="normal">_</mi><mn>1</mn><msup><mo stretchy="false">)</mo><mn>2</mn></msup><mo>+</mo><mo stretchy="false">(</mo><mi>y</mi><mi mathvariant="normal">_</mi><mn>2</mn><mo>−</mo><mi>y</mi><mi mathvariant="normal">_</mi><mn>1</mn><msup><mo stretchy="false">)</mo><mn>2</mn></msup><mo>+</mo><mo stretchy="false">(</mo><mi>z</mi><mi mathvariant="normal">_</mi><mn>2</mn><mo>−</mo><mi>z</mi><mi mathvariant="normal">_</mi><mn>1</mn><msup><mo stretchy="false">)</mo><mn>2</mn></msup></mrow></msqrt></mrow><annotation encoding="application/x-tex">distance = \\sqrt{(x\\_2 - x\\_1)^2 + (y\\_2 - y\\_1)^2 + (z\\_2 - z\\_1)^2}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal">d</span><span class="mord mathnormal">i</span><span class="mord mathnormal">s</span><span class="mord mathnormal">t</span><span class="mord mathnormal">an</span><span class="mord mathnormal">ce</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.24em;vertical-align:-0.335em;"></span><span class="mord sqrt"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.905em;"><span class="svg-align" style="top:-3.2em;"><span class="pstrut" style="height:3.2em;"></span><span class="mord" style="padding-left:1em;"><span class="mopen">(</span><span class="mord mathnormal">x</span><span class="mord">_2</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord mathnormal">x</span><span class="mord">_1</span><span class="mclose"><span class="mclose">)</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.7401em;"><span style="top:-2.989em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mopen">(</span><span class="mord mathnormal" style="margin-right:0.03588em;">y</span><span class="mord">_2</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">y</span><span class="mord">_1</span><span class="mclose"><span class="mclose">)</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.7401em;"><span style="top:-2.989em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mopen">(</span><span class="mord mathnormal" style="margin-right:0.04398em;">z</span><span class="mord">_2</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord mathnormal" style="margin-right:0.04398em;">z</span><span class="mord">_1</span><span class="mclose"><span class="mclose">)</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.7401em;"><span style="top:-2.989em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span></span></span><span style="top:-2.865em;"><span class="pstrut" style="height:3.2em;"></span><span class="hide-tail" style="min-width:1.02em;height:1.28em;"><svg xmlns="http://www.w3.org/2000/svg" width='400em' height='1.28em' viewBox='0 0 400000 1296' preserveAspectRatio='xMinYMin slice'><path d='M263,681c0.7,0,18,39.7,52,119
c34,79.3,68.167,158.7,102.5,238c34.3,79.3,51.8,119.3,52.5,120
c340,-704.7,510.7,-1060.3,512,-1067
l0 -0
c4.7,-7.3,11,-11,19,-11
H40000v40H1012.3
s-271.3,567,-271.3,567c-38.7,80.7,-84,175,-136,283c-52,108,-89.167,185.3,-111.5,232
c-22.3,46.7,-33.8,70.3,-34.5,71c-4.7,4.7,-12.3,7,-23,7s-12,-1,-12,-1
s-109,-253,-109,-253c-72.7,-168,-109.3,-252,-110,-252c-10.7,8,-22,16.7,-34,26
c-22,17.3,-33.3,26,-34,26s-26,-26,-26,-26s76,-59,76,-59s76,-60,76,-60z
M1001 80h400000v40h-400000z'/></svg></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.335em;"><span></span></span></span></span></span></span></span></span>`,re,pe,Di='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mo stretchy="false">(</mo><mfrac><mrow><mo stretchy="false">(</mo><mi>a</mi><mi>c</mi><mi>t</mi><mi>u</mi><mi>a</mi><mi>l</mi><mo>−</mo><mi>m</mi><mi>e</mi><mi>a</mi><mi>s</mi><mi>u</mi><mi>r</mi><mi>e</mi><mi>d</mi><mo stretchy="false">)</mo><mo>∗</mo><mn>100</mn></mrow><mrow><mi>a</mi><mi>c</mi><mi>t</mi><mi>u</mi><mi>a</mi><mi>l</mi></mrow></mfrac></mrow><annotation encoding="application/x-tex">( \\frac{(actual-measured) * 100}{actual}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.355em;vertical-align:-0.345em;"></span><span class="mopen">(</span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.01em;"><span style="top:-2.655em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">a</span><span class="mord mathnormal mtight">c</span><span class="mord mathnormal mtight">t</span><span class="mord mathnormal mtight">u</span><span class="mord mathnormal mtight">a</span><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.485em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mopen mtight">(</span><span class="mord mathnormal mtight">a</span><span class="mord mathnormal mtight">c</span><span class="mord mathnormal mtight">t</span><span class="mord mathnormal mtight">u</span><span class="mord mathnormal mtight">a</span><span class="mord mathnormal mtight" style="margin-right:0.01968em;">l</span><span class="mbin mtight">−</span><span class="mord mathnormal mtight">m</span><span class="mord mathnormal mtight">e</span><span class="mord mathnormal mtight">a</span><span class="mord mathnormal mtight">s</span><span class="mord mathnormal mtight">u</span><span class="mord mathnormal mtight">re</span><span class="mord mathnormal mtight">d</span><span class="mclose mtight">)</span><span class="mbin mtight">∗</span><span class="mord mtight">100</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.345em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span></span></span></span>',oe,he,ja,Wn='<thead><tr><th align="center">dimension</th> <th align="center">calculated(cm)</th> <th align="center">actual(cm)</th> <th align="center">% error</th></tr></thead> <tbody><tr><td align="center">d1(1-2)</td> <td align="center">31.2</td> <td align="center">31.2</td> <td align="center">0</td></tr> <tr><td align="center">d2(1-3)</td> <td align="center">21.1</td> <td align="center">21.3</td> <td align="center">0.94</td></tr> <tr><td align="center">d3(5-6)</td> <td align="center">16.6</td> <td align="center">16.7</td> <td align="center">0.6</td></tr> <tr><td align="center">d4(5-7)</td> <td align="center">24.2</td> <td align="center">24</td> <td align="center">0.83</td></tr> <tr><td align="center">d5(9-10)</td> <td align="center">16.9</td> <td align="center">16.7</td> <td align="center">1.2</td></tr> <tr><td align="center">d6(9-11)</td> <td align="center">23.8</td> <td align="center">24</td> <td align="center">0.83</td></tr></tbody>',ce,Sa,Fn='Calculated Dimension Results<br/> <img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/3d_stereo_vision_images/calculated_dim_results.png?download=true" alt="Calculated Dimension Results"/>',ge,Wa,de,Fa,Kn="<li>In summary, we learned how stereo vision works, the equations used to find the real-world coordinates (x, y, z) of a point P given its two images captured from different viewpoints, and compared theoretical values with experimental results.</li> <li>We assumed that the intrinsic parameters - focal length and principal point of the cameras - are known, along with their position and orientation information. This is also referred to as calibrated stereo vision.</li> <li>Interestingly, it is also possible to find the 3D coordinates of a point, P, if the position and orientation of the cameras are unknown. In fact, the position and orientation of the cameras with respect to each other can be found using the images themselves. This is referred to as uncalibrated stereo vision!</li>",fe,Ka,ue,Ua,Un='<li>3D Reconstruction - Multiple Viewpoints <a href="https://www.coursera.org/learn/3d-reconstruction-multiple-viewpoints" rel="nofollow">Coursera</a></li> <li>Stereo Vision and Depth Estimation using OpenCV AI Kit <a href="https://learnopencv.com/stereo-vision-and-depth-estimation-using-opencv-ai-kit/" rel="nofollow">LearnOpenCV</a></li> <li>OAK-D Lite <a href="https://docs.luxonis.com/projects/hardware/en/latest/pages/DM9095/" rel="nofollow">Luxonics</a></li>',ve,ft,ye;return A=new M({props:{title:"Introduction",local:"introduction",headingTag:"h1"}}),S=new M({props:{title:"Problem Statement",local:"problem-statement",headingTag:"h2"}}),B=new M({props:{title:"Solution",local:"solution",headingTag:"h2"}}),ta=new M({props:{title:"Simplified Solution",local:"simplified-solution",headingTag:"h2"}}),da=new M({props:{title:"Demo",local:"demo",headingTag:"h2"}}),fa=new M({props:{title:"Setup",local:"setup",headingTag:"h3"}}),ya=new M({props:{title:"Raw Left and Right Images",local:"raw-left-and-right-images",headingTag:"h3"}}),Ma=new M({props:{title:"Rectified Left and Right Images",local:"rectified-left-and-right-images",headingTag:"h3"}}),Pa=new M({props:{title:"Annotated Left and Right Rectified Images",local:"annotated-left-and-right-rectified-images",headingTag:"h3"}}),Oa=new M({props:{title:"3D Coordinate Calculations",local:"3d-coordinate-calculations",headingTag:"h3"}}),Aa=new M({props:{title:"Dimension Calculations and Accuracy",local:"dimension-calculations-and-accuracy",headingTag:"h3"}}),Wa=new M({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),Ka=new M({props:{title:"References",local:"references",headingTag:"h2"}}),{c(){P=m("meta"),_t=n(),it=m("p"),xt=n(),y(A.$$.fragment),bt=n(),j=m("p"),j.textContent=Ze,Lt=n(),y(S.$$.fragment),Mt=n(),W=m("p"),W.textContent=Ge,kt=n(),F=m("p"),F.textContent=Je,Ct=n(),K=m("p"),K.textContent=Qe,zt=n(),U=m("p"),U.innerHTML=an,$t=n(),Y=m("p"),Y.textContent=tn,Tt=n(),y(B.$$.fragment),Pt=n(),X=m("p"),X.textContent=sn,It=n(),N=m("ol"),N.innerHTML=en,Ht=n(),V=m("p"),V.textContent=nn,Dt=n(),Z=m("ol"),Z.innerHTML=mn,Ot=n(),G=m("p"),G.textContent=ln,Rt=n(),J=m("ol"),J.innerHTML=rn,Et=n(),Q=m("p"),Q.textContent=pn,qt=n(),aa=m("p"),aa.textContent=on,At=n(),y(ta.$$.fragment),jt=n(),sa=m("p"),sa.textContent=hn,St=n(),ea=m("p"),ea.innerHTML=cn,Wt=n(),na=m("p"),na.textContent=gn,Ft=n(),ia=m("ol"),ia.innerHTML=dn,Kt=n(),ma=m("p"),ma.textContent=fn,Ut=n(),I=m("ol"),Ya=m("li"),Me=d("Left camera  "),la=m("ol"),mt=m("li"),Yt=new h(!1),ke=n(),lt=m("li"),Bt=new h(!1),Ce=n(),Ba=m("li"),ze=d("Right camera   "),ra=m("ol"),rt=m("li"),Xt=new h(!1),$e=n(),pt=m("li"),Nt=new h(!1),Vt=n(),pa=m("p"),pa.textContent=un,Zt=n(),u=m("ul"),H=m("li"),Gt=new h(!1),Jt=d(","),Qt=new h(!1),as=d(" refer to pixel coordinates of point P in the left image"),Te=n(),D=m("li"),ts=new h(!1),ss=d(", "),es=new h(!1),ns=d(" refer to pixel coordinates of point P in the right image"),Pe=n(),O=m("li"),is=new h(!1),ms=d(" refers to the focal length (in pixels) in x direction and"),ls=new h(!1),rs=d(" refers to the focal length (in pixels) in y direction. Actually, there is only 1 focal length for a camera which is the distance between the pinhole (optical center of the lens) to the image plane. However, pixels may be rectangular and not perfect squares, resulting in different fx and fy values when we represent f in terms of pixels."),Ie=n(),Xa=m("li"),Xa.textContent=vn,He=n(),R=m("li"),ps=new h(!1),os=d("  and "),hs=new h(!1),cs=d("  refer to pixel coordinates of the principal point"),De=n(),Na=m("li"),Na.textContent=yn,gs=n(),oa=m("p"),oa.textContent=wn,ds=n(),ha=m("ol"),ot=m("li"),fs=new h(!1),us=n(),ca=m("p"),ca.textContent=_n,vs=n(),z=m("ol"),ht=m("li"),ys=new h(!1),Oe=n(),ct=m("li"),ws=new h(!1),Re=n(),gt=m("li"),_s=new h(!1),xs=n(),ga=m("p"),ga.textContent=xn,bs=n(),y(da.$$.fragment),Ls=n(),y(fa.$$.fragment),Ms=n(),ua=m("p"),ua.textContent=bn,ks=n(),va=m("ul"),va.innerHTML=Ln,Cs=n(),y(ya.$$.fragment),zs=n(),wa=m("p"),wa.textContent=Mn,$s=n(),_a=m("p"),_a.innerHTML=kn,Ts=n(),xa=m("p"),xa.innerHTML=Cn,Ps=n(),ba=m("p"),ba.innerHTML=zn,Is=n(),E=m("p"),Ee=d("Let’s focus on a single point - the top left corner of the laptop. As per equation 3 above, "),Hs=new h(!1),Ds=d("  for the same point in the left and right images. However, notice that the red line, which is at a constant v value, touches the top-left corner of the laptop in the left image but misses this point by a few pixels in the right image. There are two main reasons for this discrepancy:"),Os=n(),La=m("ul"),La.innerHTML=$n,Rs=n(),y(Ma.$$.fragment),Es=n(),ka=m("p"),ka.innerHTML=Tn,qs=n(),Ca=m("p"),Ca.innerHTML=Pn,As=n(),za=m("p"),za.innerHTML=In,js=n(),$a=m("p"),$a.innerHTML=Hn,Ss=n(),$=m("p"),qe=d("Let’s also overlap the rectified left and right images to see the difference. We can see that the v values for different points remain mostly constant in the left and right images. However, the u values change, and this difference in the u values helps us find the depth information for different points in the scene, as shown in Equation 6 above. This difference in ‘u’ values"),Ws=new h(!1),Fs=d(" is called disparity, and we can notice that the disparity for points near the camera is greater compared to points further away. Depth z and disparity "),Ks=new h(!1),Us=d("  are inversely proportional, as shown in equation 6."),Ys=n(),Ta=m("p"),Ta.innerHTML=Dn,Bs=n(),y(Pa.$$.fragment),Xs=n(),Ia=m("p"),Ia.textContent=On,Ns=n(),Ha=m("p"),Ha.innerHTML=Rn,Vs=n(),Da=m("p"),Da.innerHTML=En,Zs=n(),y(Oa.$$.fragment),Gs=n(),Ra=m("p"),Ra.textContent=qn,Js=n(),q=m("table"),dt=m("thead"),g=m("tr"),Ea=m("th"),Ea.textContent=An,Ae=n(),Va=m("th"),Qs=new h(!1),je=n(),Za=m("th"),ae=new h(!1),Se=n(),Ga=m("th"),te=new h(!1),We=n(),Ja=m("th"),se=new h(!1),Fe=n(),qa=m("th"),qa.textContent=jn,Ke=n(),Qa=m("th"),ee=new h(!1),Ue=n(),at=m("th"),ne=new h(!1),Ye=n(),tt=m("tbody"),tt.innerHTML=Sn,ie=n(),y(Aa.$$.fragment),me=n(),T=m("p"),Be=d("We can also compute 3D distances between different points using their (x,y,z) values using the formulae"),le=new h(!1),re=d(". Computed distances between some of the points are tabulated below along with their actual measured values. Percentage error"),pe=new h(!1),oe=d(") is also computed and tabulated. Notice that the calculated and actual values match very well with a percentage error of 1.2% or less."),he=n(),ja=m("table"),ja.innerHTML=Wn,ce=n(),Sa=m("p"),Sa.innerHTML=Fn,ge=n(),y(Wa.$$.fragment),de=n(),Fa=m("ol"),Fa.innerHTML=Kn,fe=n(),y(Ka.$$.fragment),ue=n(),Ua=m("ol"),Ua.innerHTML=Un,ve=n(),ft=m("p"),this.h()},l(a){const s=ji("svelte-u9bgzb",document.head);P=l(s,"META",{name:!0,content:!0}),s.forEach(t),_t=i(a),it=l(a,"P",{}),o(it).forEach(t),xt=i(a),w(A.$$.fragment,a),bt=i(a),j=l(a,"P",{"data-svelte-h":!0}),p(j)!=="svelte-dalhkv"&&(j.textContent=Ze),Lt=i(a),w(S.$$.fragment,a),Mt=i(a),W=l(a,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1uco4qc"&&(W.textContent=Ge),kt=i(a),F=l(a,"P",{"data-svelte-h":!0}),p(F)!=="svelte-kimr6l"&&(F.textContent=Je),Ct=i(a),K=l(a,"P",{"data-svelte-h":!0}),p(K)!=="svelte-q94rlb"&&(K.textContent=Qe),zt=i(a),U=l(a,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1vrgbq7"&&(U.innerHTML=an),$t=i(a),Y=l(a,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1wa9vwi"&&(Y.textContent=tn),Tt=i(a),w(B.$$.fragment,a),Pt=i(a),X=l(a,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1nrdwlc"&&(X.textContent=sn),It=i(a),N=l(a,"OL",{"data-svelte-h":!0}),p(N)!=="svelte-1thy4kf"&&(N.innerHTML=en),Ht=i(a),V=l(a,"P",{"data-svelte-h":!0}),p(V)!=="svelte-16e7hw4"&&(V.textContent=nn),Dt=i(a),Z=l(a,"OL",{"data-svelte-h":!0}),p(Z)!=="svelte-t58y5k"&&(Z.innerHTML=mn),Ot=i(a),G=l(a,"P",{"data-svelte-h":!0}),p(G)!=="svelte-iezcon"&&(G.textContent=ln),Rt=i(a),J=l(a,"OL",{"data-svelte-h":!0}),p(J)!=="svelte-2e63hu"&&(J.innerHTML=rn),Et=i(a),Q=l(a,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-zaapl6"&&(Q.textContent=pn),qt=i(a),aa=l(a,"P",{"data-svelte-h":!0}),p(aa)!=="svelte-1t8agog"&&(aa.textContent=on),At=i(a),w(ta.$$.fragment,a),jt=i(a),sa=l(a,"P",{"data-svelte-h":!0}),p(sa)!=="svelte-qw6123"&&(sa.textContent=hn),St=i(a),ea=l(a,"P",{"data-svelte-h":!0}),p(ea)!=="svelte-k5jegy"&&(ea.innerHTML=cn),Wt=i(a),na=l(a,"P",{"data-svelte-h":!0}),p(na)!=="svelte-1tyi8k4"&&(na.textContent=gn),Ft=i(a),ia=l(a,"OL",{"data-svelte-h":!0}),p(ia)!=="svelte-9ofcil"&&(ia.innerHTML=dn),Kt=i(a),ma=l(a,"P",{"data-svelte-h":!0}),p(ma)!=="svelte-1tijo6x"&&(ma.textContent=fn),Ut=i(a),I=l(a,"OL",{});var we=o(I);Ya=l(we,"LI",{});var Xe=o(Ya);Me=f(Xe,"Left camera  "),la=l(Xe,"OL",{});var _e=o(la);mt=l(_e,"LI",{});var Yn=o(mt);Yt=c(Yn,!1),Yn.forEach(t),ke=i(_e),lt=l(_e,"LI",{});var Bn=o(lt);Bt=c(Bn,!1),Bn.forEach(t),_e.forEach(t),Xe.forEach(t),Ce=i(we),Ba=l(we,"LI",{});var Ne=o(Ba);ze=f(Ne,"Right camera   "),ra=l(Ne,"OL",{});var xe=o(ra);rt=l(xe,"LI",{});var Xn=o(rt);Xt=c(Xn,!1),Xn.forEach(t),$e=i(xe),pt=l(xe,"LI",{});var Nn=o(pt);Nt=c(Nn,!1),Nn.forEach(t),xe.forEach(t),Ne.forEach(t),we.forEach(t),Vt=i(a),pa=l(a,"P",{"data-svelte-h":!0}),p(pa)!=="svelte-qh7m8q"&&(pa.textContent=un),Zt=i(a),u=l(a,"UL",{});var k=o(u);H=l(k,"LI",{});var ut=o(H);Gt=c(ut,!1),Jt=f(ut,","),Qt=c(ut,!1),as=f(ut," refer to pixel coordinates of point P in the left image"),ut.forEach(t),Te=i(k),D=l(k,"LI",{});var vt=o(D);ts=c(vt,!1),ss=f(vt,", "),es=c(vt,!1),ns=f(vt," refer to pixel coordinates of point P in the right image"),vt.forEach(t),Pe=i(k),O=l(k,"LI",{});var yt=o(O);is=c(yt,!1),ms=f(yt," refers to the focal length (in pixels) in x direction and"),ls=c(yt,!1),rs=f(yt," refers to the focal length (in pixels) in y direction. Actually, there is only 1 focal length for a camera which is the distance between the pinhole (optical center of the lens) to the image plane. However, pixels may be rectangular and not perfect squares, resulting in different fx and fy values when we represent f in terms of pixels."),yt.forEach(t),Ie=i(k),Xa=l(k,"LI",{"data-svelte-h":!0}),p(Xa)!=="svelte-1ihpmkn"&&(Xa.textContent=vn),He=i(k),R=l(k,"LI",{});var wt=o(R);ps=c(wt,!1),os=f(wt,"  and "),hs=c(wt,!1),cs=f(wt,"  refer to pixel coordinates of the principal point"),wt.forEach(t),De=i(k),Na=l(k,"LI",{"data-svelte-h":!0}),p(Na)!=="svelte-mvtqey"&&(Na.textContent=yn),k.forEach(t),gs=i(a),oa=l(a,"P",{"data-svelte-h":!0}),p(oa)!=="svelte-uxu6gh"&&(oa.textContent=wn),ds=i(a),ha=l(a,"OL",{start:!0});var Vn=o(ha);ot=l(Vn,"LI",{});var Zn=o(ot);fs=c(Zn,!1),Zn.forEach(t),Vn.forEach(t),us=i(a),ca=l(a,"P",{"data-svelte-h":!0}),p(ca)!=="svelte-xl9yi3"&&(ca.textContent=_n),vs=i(a),z=l(a,"OL",{start:!0});var st=o(z);ht=l(st,"LI",{});var Gn=o(ht);ys=c(Gn,!1),Gn.forEach(t),Oe=i(st),ct=l(st,"LI",{});var Jn=o(ct);ws=c(Jn,!1),Jn.forEach(t),Re=i(st),gt=l(st,"LI",{});var Qn=o(gt);_s=c(Qn,!1),Qn.forEach(t),st.forEach(t),xs=i(a),ga=l(a,"P",{"data-svelte-h":!0}),p(ga)!=="svelte-6ra58q"&&(ga.textContent=xn),bs=i(a),w(da.$$.fragment,a),Ls=i(a),w(fa.$$.fragment,a),Ms=i(a),ua=l(a,"P",{"data-svelte-h":!0}),p(ua)!=="svelte-1d7pwai"&&(ua.textContent=bn),ks=i(a),va=l(a,"UL",{"data-svelte-h":!0}),p(va)!=="svelte-woii1q"&&(va.innerHTML=Ln),Cs=i(a),w(ya.$$.fragment,a),zs=i(a),wa=l(a,"P",{"data-svelte-h":!0}),p(wa)!=="svelte-1p5cc63"&&(wa.textContent=Mn),$s=i(a),_a=l(a,"P",{"data-svelte-h":!0}),p(_a)!=="svelte-1gg0qex"&&(_a.innerHTML=kn),Ts=i(a),xa=l(a,"P",{"data-svelte-h":!0}),p(xa)!=="svelte-vckj40"&&(xa.innerHTML=Cn),Ps=i(a),ba=l(a,"P",{"data-svelte-h":!0}),p(ba)!=="svelte-1i90nqk"&&(ba.innerHTML=zn),Is=i(a),E=l(a,"P",{});var be=o(E);Ee=f(be,"Let’s focus on a single point - the top left corner of the laptop. As per equation 3 above, "),Hs=c(be,!1),Ds=f(be,"  for the same point in the left and right images. However, notice that the red line, which is at a constant v value, touches the top-left corner of the laptop in the left image but misses this point by a few pixels in the right image. There are two main reasons for this discrepancy:"),be.forEach(t),Os=i(a),La=l(a,"UL",{"data-svelte-h":!0}),p(La)!=="svelte-1dzlzv2"&&(La.innerHTML=$n),Rs=i(a),w(Ma.$$.fragment,a),Es=i(a),ka=l(a,"P",{"data-svelte-h":!0}),p(ka)!=="svelte-7ct0rj"&&(ka.innerHTML=Tn),qs=i(a),Ca=l(a,"P",{"data-svelte-h":!0}),p(Ca)!=="svelte-1ck938e"&&(Ca.innerHTML=Pn),As=i(a),za=l(a,"P",{"data-svelte-h":!0}),p(za)!=="svelte-pcxnrd"&&(za.innerHTML=In),js=i(a),$a=l(a,"P",{"data-svelte-h":!0}),p($a)!=="svelte-4x8yv3"&&($a.innerHTML=Hn),Ss=i(a),$=l(a,"P",{});var et=o($);qe=f(et,"Let’s also overlap the rectified left and right images to see the difference. We can see that the v values for different points remain mostly constant in the left and right images. However, the u values change, and this difference in the u values helps us find the depth information for different points in the scene, as shown in Equation 6 above. This difference in ‘u’ values"),Ws=c(et,!1),Fs=f(et," is called disparity, and we can notice that the disparity for points near the camera is greater compared to points further away. Depth z and disparity "),Ks=c(et,!1),Us=f(et,"  are inversely proportional, as shown in equation 6."),et.forEach(t),Ys=i(a),Ta=l(a,"P",{"data-svelte-h":!0}),p(Ta)!=="svelte-14rdbyn"&&(Ta.innerHTML=Dn),Bs=i(a),w(Pa.$$.fragment,a),Xs=i(a),Ia=l(a,"P",{"data-svelte-h":!0}),p(Ia)!=="svelte-1qtzgo8"&&(Ia.textContent=On),Ns=i(a),Ha=l(a,"P",{"data-svelte-h":!0}),p(Ha)!=="svelte-1c4jor3"&&(Ha.innerHTML=Rn),Vs=i(a),Da=l(a,"P",{"data-svelte-h":!0}),p(Da)!=="svelte-1ydw2mm"&&(Da.innerHTML=En),Zs=i(a),w(Oa.$$.fragment,a),Gs=i(a),Ra=l(a,"P",{"data-svelte-h":!0}),p(Ra)!=="svelte-g4rd26"&&(Ra.textContent=qn),Js=i(a),q=l(a,"TABLE",{});var Le=o(q);dt=l(Le,"THEAD",{});var ai=o(dt);g=l(ai,"TR",{});var v=o(g);Ea=l(v,"TH",{align:!0,"data-svelte-h":!0}),p(Ea)!=="svelte-7qkg13"&&(Ea.textContent=An),Ae=i(v),Va=l(v,"TH",{align:!0});var ti=o(Va);Qs=c(ti,!1),ti.forEach(t),je=i(v),Za=l(v,"TH",{align:!0});var si=o(Za);ae=c(si,!1),si.forEach(t),Se=i(v),Ga=l(v,"TH",{align:!0});var ei=o(Ga);te=c(ei,!1),ei.forEach(t),We=i(v),Ja=l(v,"TH",{align:!0});var ni=o(Ja);se=c(ni,!1),ni.forEach(t),Fe=i(v),qa=l(v,"TH",{align:!0,"data-svelte-h":!0}),p(qa)!=="svelte-ybkm9u"&&(qa.textContent=jn),Ke=i(v),Qa=l(v,"TH",{align:!0});var ii=o(Qa);ee=c(ii,!1),ii.forEach(t),Ue=i(v),at=l(v,"TH",{align:!0});var mi=o(at);ne=c(mi,!1),mi.forEach(t),v.forEach(t),ai.forEach(t),Ye=i(Le),tt=l(Le,"TBODY",{"data-svelte-h":!0}),p(tt)!=="svelte-1rt6yz"&&(tt.innerHTML=Sn),Le.forEach(t),ie=i(a),w(Aa.$$.fragment,a),me=i(a),T=l(a,"P",{});var nt=o(T);Be=f(nt,"We can also compute 3D distances between different points using their (x,y,z) values using the formulae"),le=c(nt,!1),re=f(nt,". Computed distances between some of the points are tabulated below along with their actual measured values. Percentage error"),pe=c(nt,!1),oe=f(nt,") is also computed and tabulated. Notice that the calculated and actual values match very well with a percentage error of 1.2% or less."),nt.forEach(t),he=i(a),ja=l(a,"TABLE",{"data-svelte-h":!0}),p(ja)!=="svelte-1mrocde"&&(ja.innerHTML=Wn),ce=i(a),Sa=l(a,"P",{"data-svelte-h":!0}),p(Sa)!=="svelte-7wv9fd"&&(Sa.innerHTML=Fn),ge=i(a),w(Wa.$$.fragment,a),de=i(a),Fa=l(a,"OL",{"data-svelte-h":!0}),p(Fa)!=="svelte-8n4kzy"&&(Fa.innerHTML=Kn),fe=i(a),w(Ka.$$.fragment,a),ue=i(a),Ua=l(a,"OL",{"data-svelte-h":!0}),p(Ua)!=="svelte-vggie1"&&(Ua.innerHTML=Un),ve=i(a),ft=l(a,"P",{}),o(ft).forEach(t),this.h()},h(){C(P,"name","hf:doc:metadata"),C(P,"content",Wi),Yt.a=null,Bt.a=null,Xt.a=null,Nt.a=null,Gt.a=Jt,Qt.a=as,ts.a=ss,es.a=ns,is.a=ms,ls.a=rs,ps.a=os,hs.a=cs,fs.a=null,C(ha,"start","3"),ys.a=null,ws.a=null,_s.a=null,C(z,"start","4"),Hs.a=Ds,Ws.a=Fs,Ks.a=Us,C(Ea,"align","center"),Qs.a=null,C(Va,"align","center"),ae.a=null,C(Za,"align","center"),te.a=null,C(Ga,"align","center"),se.a=null,C(Ja,"align","center"),C(qa,"align","center"),ee.a=null,C(Qa,"align","center"),ne.a=null,C(at,"align","center"),le.a=re,pe.a=oe},m(a,s){r(document.head,P),e(a,_t,s),e(a,it,s),e(a,xt,s),_(A,a,s),e(a,bt,s),e(a,j,s),e(a,Lt,s),_(S,a,s),e(a,Mt,s),e(a,W,s),e(a,kt,s),e(a,F,s),e(a,Ct,s),e(a,K,s),e(a,zt,s),e(a,U,s),e(a,$t,s),e(a,Y,s),e(a,Tt,s),_(B,a,s),e(a,Pt,s),e(a,X,s),e(a,It,s),e(a,N,s),e(a,Ht,s),e(a,V,s),e(a,Dt,s),e(a,Z,s),e(a,Ot,s),e(a,G,s),e(a,Rt,s),e(a,J,s),e(a,Et,s),e(a,Q,s),e(a,qt,s),e(a,aa,s),e(a,At,s),_(ta,a,s),e(a,jt,s),e(a,sa,s),e(a,St,s),e(a,ea,s),e(a,Wt,s),e(a,na,s),e(a,Ft,s),e(a,ia,s),e(a,Kt,s),e(a,ma,s),e(a,Ut,s),e(a,I,s),r(I,Ya),r(Ya,Me),r(Ya,la),r(la,mt),Yt.m(li,mt),r(la,ke),r(la,lt),Bt.m(ri,lt),r(I,Ce),r(I,Ba),r(Ba,ze),r(Ba,ra),r(ra,rt),Xt.m(pi,rt),r(ra,$e),r(ra,pt),Nt.m(oi,pt),e(a,Vt,s),e(a,pa,s),e(a,Zt,s),e(a,u,s),r(u,H),Gt.m(hi,H),r(H,Jt),Qt.m(ci,H),r(H,as),r(u,Te),r(u,D),ts.m(gi,D),r(D,ss),es.m(di,D),r(D,ns),r(u,Pe),r(u,O),is.m(fi,O),r(O,ms),ls.m(ui,O),r(O,rs),r(u,Ie),r(u,Xa),r(u,He),r(u,R),ps.m(vi,R),r(R,os),hs.m(yi,R),r(R,cs),r(u,De),r(u,Na),e(a,gs,s),e(a,oa,s),e(a,ds,s),e(a,ha,s),r(ha,ot),fs.m(wi,ot),e(a,us,s),e(a,ca,s),e(a,vs,s),e(a,z,s),r(z,ht),ys.m(_i,ht),r(z,Oe),r(z,ct),ws.m(xi,ct),r(z,Re),r(z,gt),_s.m(bi,gt),e(a,xs,s),e(a,ga,s),e(a,bs,s),_(da,a,s),e(a,Ls,s),_(fa,a,s),e(a,Ms,s),e(a,ua,s),e(a,ks,s),e(a,va,s),e(a,Cs,s),_(ya,a,s),e(a,zs,s),e(a,wa,s),e(a,$s,s),e(a,_a,s),e(a,Ts,s),e(a,xa,s),e(a,Ps,s),e(a,ba,s),e(a,Is,s),e(a,E,s),r(E,Ee),Hs.m(Li,E),r(E,Ds),e(a,Os,s),e(a,La,s),e(a,Rs,s),_(Ma,a,s),e(a,Es,s),e(a,ka,s),e(a,qs,s),e(a,Ca,s),e(a,As,s),e(a,za,s),e(a,js,s),e(a,$a,s),e(a,Ss,s),e(a,$,s),r($,qe),Ws.m(Mi,$),r($,Fs),Ks.m(ki,$),r($,Us),e(a,Ys,s),e(a,Ta,s),e(a,Bs,s),_(Pa,a,s),e(a,Xs,s),e(a,Ia,s),e(a,Ns,s),e(a,Ha,s),e(a,Vs,s),e(a,Da,s),e(a,Zs,s),_(Oa,a,s),e(a,Gs,s),e(a,Ra,s),e(a,Js,s),e(a,q,s),r(q,dt),r(dt,g),r(g,Ea),r(g,Ae),r(g,Va),Qs.m(Ci,Va),r(g,je),r(g,Za),ae.m(zi,Za),r(g,Se),r(g,Ga),te.m($i,Ga),r(g,We),r(g,Ja),se.m(Ti,Ja),r(g,Fe),r(g,qa),r(g,Ke),r(g,Qa),ee.m(Pi,Qa),r(g,Ue),r(g,at),ne.m(Ii,at),r(q,Ye),r(q,tt),e(a,ie,s),_(Aa,a,s),e(a,me,s),e(a,T,s),r(T,Be),le.m(Hi,T),r(T,re),pe.m(Di,T),r(T,oe),e(a,he,s),e(a,ja,s),e(a,ce,s),e(a,Sa,s),e(a,ge,s),_(Wa,a,s),e(a,de,s),e(a,Fa,s),e(a,fe,s),_(Ka,a,s),e(a,ue,s),e(a,Ua,s),e(a,ve,s),e(a,ft,s),ye=!0},p:Ri,i(a){ye||(x(A.$$.fragment,a),x(S.$$.fragment,a),x(B.$$.fragment,a),x(ta.$$.fragment,a),x(da.$$.fragment,a),x(fa.$$.fragment,a),x(ya.$$.fragment,a),x(Ma.$$.fragment,a),x(Pa.$$.fragment,a),x(Oa.$$.fragment,a),x(Aa.$$.fragment,a),x(Wa.$$.fragment,a),x(Ka.$$.fragment,a),ye=!0)},o(a){b(A.$$.fragment,a),b(S.$$.fragment,a),b(B.$$.fragment,a),b(ta.$$.fragment,a),b(da.$$.fragment,a),b(fa.$$.fragment,a),b(ya.$$.fragment,a),b(Ma.$$.fragment,a),b(Pa.$$.fragment,a),b(Oa.$$.fragment,a),b(Aa.$$.fragment,a),b(Wa.$$.fragment,a),b(Ka.$$.fragment,a),ye=!1},d(a){a&&(t(_t),t(it),t(xt),t(bt),t(j),t(Lt),t(Mt),t(W),t(kt),t(F),t(Ct),t(K),t(zt),t(U),t($t),t(Y),t(Tt),t(Pt),t(X),t(It),t(N),t(Ht),t(V),t(Dt),t(Z),t(Ot),t(G),t(Rt),t(J),t(Et),t(Q),t(qt),t(aa),t(At),t(jt),t(sa),t(St),t(ea),t(Wt),t(na),t(Ft),t(ia),t(Kt),t(ma),t(Ut),t(I),t(Vt),t(pa),t(Zt),t(u),t(gs),t(oa),t(ds),t(ha),t(us),t(ca),t(vs),t(z),t(xs),t(ga),t(bs),t(Ls),t(Ms),t(ua),t(ks),t(va),t(Cs),t(zs),t(wa),t($s),t(_a),t(Ts),t(xa),t(Ps),t(ba),t(Is),t(E),t(Os),t(La),t(Rs),t(Es),t(ka),t(qs),t(Ca),t(As),t(za),t(js),t($a),t(Ss),t($),t(Ys),t(Ta),t(Bs),t(Xs),t(Ia),t(Ns),t(Ha),t(Vs),t(Da),t(Zs),t(Gs),t(Ra),t(Js),t(q),t(ie),t(me),t(T),t(he),t(ja),t(ce),t(Sa),t(ge),t(de),t(Fa),t(fe),t(ue),t(Ua),t(ve),t(ft)),t(P),L(A,a),L(S,a),L(B,a),L(ta,a),L(da,a),L(fa,a),L(ya,a),L(Ma,a),L(Pa,a),L(Oa,a),L(Aa,a),L(Wa,a),L(Ka,a)}}}const Wi='{"title":"Introduction","local":"introduction","sections":[{"title":"Problem Statement","local":"problem-statement","sections":[],"depth":2},{"title":"Solution","local":"solution","sections":[],"depth":2},{"title":"Simplified Solution","local":"simplified-solution","sections":[],"depth":2},{"title":"Demo","local":"demo","sections":[{"title":"Setup","local":"setup","sections":[],"depth":3},{"title":"Raw Left and Right Images","local":"raw-left-and-right-images","sections":[],"depth":3},{"title":"Rectified Left and Right Images","local":"rectified-left-and-right-images","sections":[],"depth":3},{"title":"Annotated Left and Right Rectified Images","local":"annotated-left-and-right-rectified-images","sections":[],"depth":3},{"title":"3D Coordinate Calculations","local":"3d-coordinate-calculations","sections":[],"depth":3},{"title":"Dimension Calculations and Accuracy","local":"dimension-calculations-and-accuracy","sections":[],"depth":3}],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2},{"title":"References","local":"references","sections":[],"depth":2}],"depth":1}';function Fi(Ve){return Ei(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Bi extends qi{constructor(P){super(),Ai(this,P,Fi,Si,Oi,{})}}export{Bi as component};
