import{S as Lr,i as Ir,s as Ur,e as a,k as d,w as _,t as s,M as Or,c as n,d as t,m as c,a as r,x as b,h as i,b as l,G as e,g as m,y as v,q as y,o as w,B as x,v as Sr,L as Dr}from"../../chunks/vendor-hf-doc-builder.js";import{T as jr}from"../../chunks/Tip-hf-doc-builder.js";import{D as U}from"../../chunks/Docstring-hf-doc-builder.js";import{C as Ar}from"../../chunks/CodeBlock-hf-doc-builder.js";import{I as lo}from"../../chunks/IconCopyLink-hf-doc-builder.js";import{E as Nr}from"../../chunks/ExampleCodeBlock-hf-doc-builder.js";function Cr(V){let p,k,u,f,M;return f=new Ar({props:{code:`import torch
import torch.nn as nn
from huggingface_hub import PyTorchModelHubMixin


class MyModel(nn.Module, PyTorchModelHubMixin):
    def __init__(self):
        super().__init__()
        self.param = nn.Parameter(torch.rand(3, 4))
        self.linear = nn.Linear(4, 5)

    def forward(self, x):
        return self.linear(x + self.param)
model = MyModel()

model.save_pretrained("my-awesome-model")

model.push_to_hub("my-awesome-model")

model = MyModel.from_pretrained("username/my-awesome-model")`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> PyTorchModelHubMixin


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModel</span>(nn.Module, PyTorchModelHubMixin):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
<span class="hljs-meta">... </span>        <span class="hljs-built_in">super</span>().__init__()
<span class="hljs-meta">... </span>        self.param = nn.Parameter(torch.rand(<span class="hljs-number">3</span>, <span class="hljs-number">4</span>))
<span class="hljs-meta">... </span>        self.linear = nn.Linear(<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> self.linear(x + self.param)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel()

<span class="hljs-comment"># Save model weights to local directory</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># Push model weights to the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># Download and initialize weights from the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel.from_pretrained(<span class="hljs-string">&quot;username/my-awesome-model&quot;</span>)`}}),{c(){p=a("p"),k=s("Example:"),u=d(),_(f.$$.fragment)},l(g){p=n(g,"P",{});var $=r(p);k=i($,"Example:"),$.forEach(t),u=c(g),b(f.$$.fragment,g)},m(g,$){m(g,p,$),e(p,k),m(g,u,$),v(f,g,$),M=!0},p:Dr,i(g){M||(y(f.$$.fragment,g),M=!0)},o(g){w(f.$$.fragment,g),M=!1},d(g){g&&t(p),g&&t(u),x(f,g)}}}function Fr(V){let p,k;return p=new Ar({props:{code:`import tensorflow as tf
from huggingface_hub import KerasModelHubMixin


class MyModel(tf.keras.Model, KerasModelHubMixin):
    def __init__(self, **kwargs):
        super().__init__()
        self.config = kwargs.pop("config", None)
        self.dummy_inputs = ...
        self.layer = ...

    def call(self, *args):
        return ...


# Initialize and compile the model as you normally would
model = MyModel()
model.compile(...)
# Build the graph by training it or passing dummy inputs
_ = model(model.dummy_inputs)
# Save model weights to local directory
model.save_pretrained("my-awesome-model")
# Push model weights to the Hub
model.push_to_hub("my-awesome-model")
# Download and initialize weights from the Hub
model = MyModel.from_pretrained("username/super-cool-model")`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> KerasModelHubMixin


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModel</span>(tf.keras.Model, KerasModelHubMixin):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, **kwargs</span>):
<span class="hljs-meta">... </span>        <span class="hljs-built_in">super</span>().__init__()
<span class="hljs-meta">... </span>        self.config = kwargs.pop(<span class="hljs-string">&quot;config&quot;</span>, <span class="hljs-literal">None</span>)
<span class="hljs-meta">... </span>        self.dummy_inputs = ...
<span class="hljs-meta">... </span>        self.layer = ...

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">call</span>(<span class="hljs-params">self, *args</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> ...


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize and compile the model as you normally would</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel()
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">compile</span>(...)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Build the graph by training it or passing dummy inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>_ = model(model.dummy_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Save model weights to local directory</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Push model weights to the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download and initialize weights from the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel.from_pretrained(<span class="hljs-string">&quot;username/super-cool-model&quot;</span>)`}}),{c(){_(p.$$.fragment)},l(u){b(p.$$.fragment,u)},m(u,f){v(p,u,f),k=!0},p:Dr,i(u){k||(y(p.$$.fragment,u),k=!0)},o(u){w(p.$$.fragment,u),k=!1},d(u){x(p,u)}}}function zr(V){let p,k,u,f,M;return{c(){p=a("p"),k=s("Passing "),u=a("code"),f=s("token=True"),M=s(` is required when you want to use a private
model.`)},l(g){p=n(g,"P",{});var $=r(p);k=i($,"Passing "),u=n($,"CODE",{});var O=r(u);f=i(O,"token=True"),O.forEach(t),M=i($,` is required when you want to use a private
model.`),$.forEach(t)},m(g,$){m(g,p,$),e(p,k),e(p,u),e(u,f),e(p,M)},d(g){g&&t(p)}}}function qr(V){let p,k,u,f,M,g,$,O,we;return{c(){p=a("p"),k=s("Raises the following error:"),u=d(),f=a("ul"),M=a("li"),g=a("a"),$=a("em"),O=s("ValueError"),we=s(`
if the user is not log on to the Hugging Face Hub.`),this.h()},l(E){p=n(E,"P",{});var T=r(p);k=i(T,"Raises the following error:"),T.forEach(t),u=c(E),f=n(E,"UL",{});var C=r(f);M=n(C,"LI",{});var ee=r(M);g=n(ee,"A",{href:!0,rel:!0});var R=r(g);$=n(R,"EM",{});var We=r($);O=i(We,"ValueError"),We.forEach(t),R.forEach(t),we=i(ee,`
if the user is not log on to the Hugging Face Hub.`),ee.forEach(t),C.forEach(t),this.h()},h(){l(g,"href","https://docs.python.org/3/library/exceptions.html#ValueError"),l(g,"rel","nofollow")},m(E,T){m(E,p,T),e(p,k),m(E,u,T),m(E,f,T),e(f,M),e(M,g),e(g,$),e($,O),e(M,we)},d(E){E&&t(p),E&&t(u),E&&t(f)}}}function Kr(V){let p,k,u,f,M,g,$,O,we,E,T,C,ee,R,We,co,$t,Yo,B,kt,ho,Mt,Ht,Ve,Et,Tt,Jo,oe,ie,po,xe,Pt,go,jt,Qo,H,$e,Nt,mo,Dt,At,j,Lt,uo,It,Ut,fo,Ot,St,Re,Ct,Ft,Be,zt,qt,Kt,le,ke,Wt,Me,Vt,Ge,Rt,Bt,Gt,S,He,Yt,_o,Jt,Qt,N,Xt,Ye,Zt,ea,Je,oa,ta,bo,aa,na,vo,ra,sa,ia,Ee,la,Qe,da,ca,ha,de,Te,pa,yo,ga,ma,G,Pe,ua,wo,fa,_a,D,ba,xo,va,ya,$o,wa,xa,ko,$a,ka,Xe,Ma,Ha,Ea,ce,je,Ta,Mo,Pa,Xo,te,he,Ho,Ne,ja,Eo,Na,Zo,F,De,Da,z,Aa,Ze,La,Ia,To,Ua,Oa,Po,Sa,Ca,Fa,pe,et,ae,ge,jo,Ae,za,No,qa,ot,q,Le,Ka,Ie,Wa,eo,Va,Ra,Ba,me,tt,K,Ue,Ga,Oe,Ya,Do,Ja,Qa,Xa,ue,at,W,Se,Za,Ao,en,on,A,tn,Lo,an,nn,Io,rn,sn,Uo,ln,dn,oo,cn,hn,nt,ne,Ce,pn,Oo,gn,rt,re,fe,So,Fe,mn,Co,un,st,se,ze,fn,Fo,_n,it,L,qe,bn,zo,vn,yn,I,wn,qo,xn,$n,Ko,kn,Mn,Wo,Hn,En,Vo,Tn,Pn,jn,_e,lt;return g=new lo({}),R=new lo({}),xe=new lo({}),$e=new U({props:{name:"class huggingface_hub.ModelHubMixin",anchor:"huggingface_hub.ModelHubMixin",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.13.1/src/huggingface_hub/hub_mixin.py#L25"}}),ke=new U({props:{name:"_save_pretrained",anchor:"huggingface_hub.ModelHubMixin._save_pretrained",parameters:[{name:"save_directory",val:": Path"}],parametersDescription:[{anchor:"huggingface_hub.ModelHubMixin._save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>Path</code>) &#x2014;
Path to directory in which the model weights and configuration will be saved.`,name:"save_directory"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.13.1/src/huggingface_hub/hub_mixin.py#L79"}}),He=new U({props:{name:"_from_pretrained",anchor:"huggingface_hub.ModelHubMixin._from_pretrained",parameters:[{name:"model_id",val:": str"},{name:"revision",val:": typing.Optional[str]"},{name:"cache_dir",val:": typing.Union[str, pathlib.Path, NoneType]"},{name:"force_download",val:": bool"},{name:"proxies",val:": typing.Optional[typing.Dict]"},{name:"resume_download",val:": bool"},{name:"local_files_only",val:": bool"},{name:"token",val:": typing.Union[str, bool, NoneType]"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.model_id",description:`<strong>model_id</strong> (<code>str</code>) &#x2014;
ID of the model to load from the Huggingface Hub (e.g. <code>bigscience/bloom</code>).`,name:"model_id"},{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Revision of the model on the Hub. Can be a branch name, a git tag or any commit id. Defaults to the
latest commit on <code>main</code> branch.`,name:"revision"},{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to force (re-)downloading the model weights and configuration files from the Hub, overriding
the existing cache.`,name:"force_download"},{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to delete incompletely received files. Will attempt to resume the download if such a file exists.`,name:"resume_download"},{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint (e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>).`,name:"proxies"},{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. By default, it will use the token
cached when running <code>huggingface-cli login</code>.`,name:"token"},{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code>, <code>Path</code>, <em>optional</em>) &#x2014;
Path to the folder where cached files are stored.`,name:"cache_dir"},{anchor:"huggingface_hub.ModelHubMixin._from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, avoid downloading the file and return the path to the local cached file if it exists.
model_kwargs &#x2014;
Additional keyword arguments passed along to the <a href="/docs/huggingface_hub/v0.13.1/en/package_reference/mixins#huggingface_hub.ModelHubMixin._from_pretrained">_from_pretrained()</a> method.`,name:"local_files_only"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.13.1/src/huggingface_hub/hub_mixin.py#L187"}}),Te=new U({props:{name:"from_pretrained",anchor:"huggingface_hub.ModelHubMixin.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, pathlib.Path]"},{name:"force_download",val:": bool = False"},{name:"resume_download",val:": bool = False"},{name:"proxies",val:": typing.Optional[typing.Dict] = None"},{name:"token",val:": typing.Union[str, bool, NoneType] = None"},{name:"cache_dir",val:": typing.Union[str, pathlib.Path, NoneType] = None"},{name:"local_files_only",val:": bool = False"},{name:"revision",val:": typing.Optional[str] = None"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code>, <code>Path</code>) &#x2014;<ul>
<li>Either the <code>model_id</code> (string) of a model hosted on the Hub, e.g. <code>bigscience/bloom</code>.</li>
<li>Or a path to a <code>directory</code> containing model weights saved using
<a href="https://huggingface.co/docs/transformers/v4.26.1/en/main_classes/model#transformers.PreTrainedModel.save_pretrained" rel="nofollow">save_pretrained</a>, e.g., <code>../path/to/my_model_directory/</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Revision of the model on the Hub. Can be a branch name, a git tag or any commit id.
Defaults to the latest commit on <code>main</code> branch.`,name:"revision"},{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to force (re-)downloading the model weights and configuration files from the Hub, overriding
the existing cache.`,name:"force_download"},{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to delete incompletely received files. Will attempt to resume the download if such a file exists.`,name:"resume_download"},{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on every request.`,name:"proxies"},{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. By default, it will use the token
cached when running <code>huggingface-cli login</code>.`,name:"token"},{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code>, <code>Path</code>, <em>optional</em>) &#x2014;
Path to the folder where cached files are stored.`,name:"cache_dir"},{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, avoid downloading the file and return the path to the local cached file if it exists.`,name:"local_files_only"},{anchor:"huggingface_hub.ModelHubMixin.from_pretrained.model_kwargs",description:`<strong>model_kwargs</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Additional kwargs to pass to the model during initialization.`,name:"model_kwargs"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.13.1/src/huggingface_hub/hub_mixin.py#L90"}}),Pe=new U({props:{name:"push_to_hub",anchor:"huggingface_hub.ModelHubMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"config",val:": typing.Optional[dict] = None"},{name:"commit_message",val:": str = 'Push model using huggingface_hub.'"},{name:"private",val:": bool = False"},{name:"api_endpoint",val:": typing.Optional[str] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"branch",val:": typing.Optional[str] = None"},{name:"create_pr",val:": typing.Optional[bool] = None"},{name:"allow_patterns",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"ignore_patterns",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"delete_patterns",val:": typing.Union[typing.List[str], str, NoneType] = None"}],parametersDescription:[{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
Repository name to which push.`,name:"repo_id"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.config",description:`<strong>config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Configuration object to be saved alongside the model weights.`,name:"config"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing.`,name:"commit_message"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the repository created should be private.`,name:"private"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.api_endpoint",description:`<strong>api_endpoint</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The API endpoint to use when pushing the model to the hub.`,name:"api_endpoint"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. By default, it will use the token
cached when running <code>huggingface-cli login</code>.`,name:"token"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.branch",description:`<strong>branch</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git branch on which to push the model. This defaults to <code>&quot;main&quot;</code>.`,name:"branch"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request from <code>branch</code> with that commit. Defaults to <code>False</code>.`,name:"create_pr"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.allow_patterns",description:`<strong>allow_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are pushed.`,name:"allow_patterns"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.ignore_patterns",description:`<strong>ignore_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not pushed.`,name:"ignore_patterns"},{anchor:"huggingface_hub.ModelHubMixin.push_to_hub.delete_patterns",description:`<strong>delete_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, remote files matching any of the patterns will be deleted from the repo.`,name:"delete_patterns"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.13.1/src/huggingface_hub/hub_mixin.py#L237",returnDescription:`
<p>The url of the commit of your model in the given repository.</p>
`}}),je=new U({props:{name:"save_pretrained",anchor:"huggingface_hub.ModelHubMixin.save_pretrained",parameters:[{name:"save_directory",val:": typing.Union[str, pathlib.Path]"},{name:"config",val:": typing.Optional[dict] = None"},{name:"repo_id",val:": typing.Optional[str] = None"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.ModelHubMixin.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>Path</code>) &#x2014;
Path to directory in which the model weights and configuration will be saved.`,name:"save_directory"},{anchor:"huggingface_hub.ModelHubMixin.save_pretrained.config",description:`<strong>config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Model configuration specified as a key/value dictionary.`,name:"config"},{anchor:"huggingface_hub.ModelHubMixin.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Huggingface Hub after saving it.`,name:"push_to_hub"},{anchor:"huggingface_hub.ModelHubMixin.save_pretrained.repo_id",description:`<strong>repo_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
ID of your repository on the Hub. Used only if <code>push_to_hub=True</code>. Will default to the folder name if
not provided.
kwargs &#x2014;
Additional key word arguments passed along to the <a href="/docs/huggingface_hub/v0.13.1/en/package_reference/mixins#huggingface_hub.ModelHubMixin._from_pretrained">_from_pretrained()</a> method.`,name:"repo_id"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.13.1/src/huggingface_hub/hub_mixin.py#L34"}}),Ne=new lo({}),De=new U({props:{name:"class huggingface_hub.PyTorchModelHubMixin",anchor:"huggingface_hub.PyTorchModelHubMixin",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.13.1/src/huggingface_hub/hub_mixin.py#L309"}}),pe=new Nr({props:{anchor:"huggingface_hub.PyTorchModelHubMixin.example",$$slots:{default:[Cr]},$$scope:{ctx:V}}}),Ae=new lo({}),Le=new U({props:{name:"class huggingface_hub.KerasModelHubMixin",anchor:"huggingface_hub.KerasModelHubMixin",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.13.1/src/huggingface_hub/keras_mixin.py#L398"}}),me=new Nr({props:{anchor:"huggingface_hub.KerasModelHubMixin.example",$$slots:{default:[Fr]},$$scope:{ctx:V}}}),Ue=new U({props:{name:"huggingface_hub.from_pretrained_keras",anchor:"huggingface_hub.from_pretrained_keras",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.from_pretrained_keras.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:<ul>
<li>A string, the <code>model id</code> of a pretrained model hosted inside a
model repo on huggingface.co. Valid model ids can be located
at the root-level, like <code>bert-base-uncased</code>, or namespaced
under a user or organization name, like
<code>dbmdz/bert-base-german-cased</code>.</li>
<li>You can add <code>revision</code> by appending <code>@</code> at the end of model_id
simply like this: <code>dbmdz/bert-base-german-cased@main</code> Revision
is the specific model version to use. It can be a branch name,
a tag name, or a commit id, since we use a git-based system
for storing models and other artifacts on huggingface.co, so
<code>revision</code> can be any identifier allowed by git.</li>
<li>A path to a <code>directory</code> containing model weights saved using
<a href="https://huggingface.co/docs/transformers/v4.26.1/en/main_classes/model#transformers.PreTrainedModel.save_pretrained" rel="nofollow">save_pretrained</a>, e.g.,
<code>./my_model_directory/</code>.</li>
<li><code>None</code> if you are both providing the configuration and state
dictionary (resp. with keyword arguments <code>config</code> and
<code>state_dict</code>).</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"huggingface_hub.from_pretrained_keras.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to force the (re-)download of the model weights and
configuration files, overriding the cached versions if they exist.`,name:"force_download"},{anchor:"huggingface_hub.from_pretrained_keras.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to delete incompletely received files. Will attempt to
resume the download if such a file exists.`,name:"resume_download"},{anchor:"huggingface_hub.from_pretrained_keras.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g.,
<code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The
proxies are used on each request.`,name:"proxies"},{anchor:"huggingface_hub.from_pretrained_keras.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If
<code>True</code>, will use the token generated when running <code>transformers-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"huggingface_hub.from_pretrained_keras.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model
configuration should be cached if the standard cache should not be
used.`,name:"cache_dir"},{anchor:"huggingface_hub.from_pretrained_keras.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only look at local files (i.e., do not try to download
the model).`,name:"local_files_only(bool,"},{anchor:"huggingface_hub.from_pretrained_keras.model_kwargs",description:`<strong>model_kwargs</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
model_kwargs will be passed to the model during initialization`,name:"model_kwargs"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.13.1/src/huggingface_hub/keras_mixin.py#L217"}}),ue=new jr({props:{$$slots:{default:[zr]},$$scope:{ctx:V}}}),Se=new U({props:{name:"huggingface_hub.push_to_hub_keras",anchor:"huggingface_hub.push_to_hub_keras",parameters:[{name:"model",val:""},{name:"repo_id",val:": str"},{name:"config",val:": typing.Optional[dict] = None"},{name:"commit_message",val:": str = 'Push Keras model using huggingface_hub.'"},{name:"private",val:": bool = False"},{name:"api_endpoint",val:": typing.Optional[str] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"branch",val:": typing.Optional[str] = None"},{name:"create_pr",val:": typing.Optional[bool] = None"},{name:"allow_patterns",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"ignore_patterns",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"delete_patterns",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"log_dir",val:": typing.Optional[str] = None"},{name:"include_optimizer",val:": bool = False"},{name:"tags",val:": typing.Union[list, str, NoneType] = None"},{name:"plot_model",val:": bool = True"},{name:"**model_save_kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.push_to_hub_keras.model",description:`<strong>model</strong> (<code>Keras.Model</code>) &#x2014;
The <a href="%60https://www.tensorflow.org/api_docs/python/tf/keras/Model%60">Keras model</a> you&#x2019;d like to push to the
Hub. The model must be compiled and built.`,name:"model"},{anchor:"huggingface_hub.push_to_hub_keras.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
Repository name to which push`,name:"repo_id"},{anchor:"huggingface_hub.push_to_hub_keras.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201C;Add Keras model&#x201D;) &#x2014;
Message to commit while pushing.`,name:"commit_message"},{anchor:"huggingface_hub.push_to_hub_keras.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the repository created should be private.`,name:"private"},{anchor:"huggingface_hub.push_to_hub_keras.api_endpoint",description:`<strong>api_endpoint</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The API endpoint to use when pushing the model to the hub.`,name:"api_endpoint"},{anchor:"huggingface_hub.push_to_hub_keras.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If
not set, will use the token set when logging in with
<code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"huggingface_hub.push_to_hub_keras.branch",description:`<strong>branch</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git branch on which to push the model. This defaults to
the default branch as specified in your repository, which
defaults to <code>&quot;main&quot;</code>.`,name:"branch"},{anchor:"huggingface_hub.push_to_hub_keras.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request from <code>branch</code> with that commit.
Defaults to <code>False</code>.`,name:"create_pr"},{anchor:"huggingface_hub.push_to_hub_keras.config",description:`<strong>config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Configuration object to be saved alongside the model weights.`,name:"config"},{anchor:"huggingface_hub.push_to_hub_keras.allow_patterns",description:`<strong>allow_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are pushed.`,name:"allow_patterns"},{anchor:"huggingface_hub.push_to_hub_keras.ignore_patterns",description:`<strong>ignore_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not pushed.`,name:"ignore_patterns"},{anchor:"huggingface_hub.push_to_hub_keras.delete_patterns",description:`<strong>delete_patterns</strong> (<code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
If provided, remote files matching any of the patterns will be deleted from the repo.`,name:"delete_patterns"},{anchor:"huggingface_hub.push_to_hub_keras.log_dir",description:`<strong>log_dir</strong> (<code>str</code>, <em>optional</em>) &#x2014;
TensorBoard logging directory to be pushed. The Hub automatically
hosts and displays a TensorBoard instance if log files are included
in the repository.`,name:"log_dir"},{anchor:"huggingface_hub.push_to_hub_keras.include_optimizer",description:`<strong>include_optimizer</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to include optimizer during serialization.`,name:"include_optimizer"},{anchor:"huggingface_hub.push_to_hub_keras.tags",description:`<strong>tags</strong> (Union[<code>list</code>, <code>str</code>], <em>optional</em>) &#x2014;
List of tags that are related to model or string of a single tag. See example tags
<a href="https://github.com/huggingface/hub-docs/blame/main/modelcard.md" rel="nofollow">here</a>.`,name:"tags"},{anchor:"huggingface_hub.push_to_hub_keras.plot_model",description:`<strong>plot_model</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Setting this to <code>True</code> will plot the model and put it in the model
card. Requires graphviz and pydot to be installed.`,name:"plot_model"},{anchor:"huggingface_hub.push_to_hub_keras.model_save_kwargs(dict,",description:`<strong>model_save_kwargs(<code>dict</code>,</strong> <em>optional</em>) &#x2014;
model_save_kwargs will be passed to
<a href="https://www.tensorflow.org/api_docs/python/tf/keras/models/save_model" rel="nofollow"><code>tf.keras.models.save_model()</code></a>.`,name:"model_save_kwargs(dict,"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.13.1/src/huggingface_hub/keras_mixin.py#L276",returnDescription:`
<p>The url of the commit of your model in the given repository.</p>
`}}),Ce=new U({props:{name:"huggingface_hub.save_pretrained_keras",anchor:"huggingface_hub.save_pretrained_keras",parameters:[{name:"model",val:""},{name:"save_directory",val:": typing.Union[str, pathlib.Path]"},{name:"config",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"include_optimizer",val:": bool = False"},{name:"plot_model",val:": bool = True"},{name:"tags",val:": typing.Union[list, str, NoneType] = None"},{name:"**model_save_kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.save_pretrained_keras.model",description:`<strong>model</strong> (<code>Keras.Model</code>) &#x2014;
The <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">Keras
model</a>
you&#x2019;d like to save. The model must be compiled and built.`,name:"model"},{anchor:"huggingface_hub.save_pretrained_keras.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>Path</code>) &#x2014;
Specify directory in which you want to save the Keras model.`,name:"save_directory"},{anchor:"huggingface_hub.save_pretrained_keras.config",description:`<strong>config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Configuration object to be saved alongside the model weights.`,name:"config"},{anchor:"huggingface_hub.save_pretrained_keras.include_optimizer(bool,",description:`<strong>include_optimizer(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to include optimizer in serialization.`,name:"include_optimizer(bool,"},{anchor:"huggingface_hub.save_pretrained_keras.plot_model",description:`<strong>plot_model</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Setting this to <code>True</code> will plot the model and put it in the model
card. Requires graphviz and pydot to be installed.`,name:"plot_model"},{anchor:"huggingface_hub.save_pretrained_keras.tags",description:`<strong>tags</strong> (Union[<code>str</code>,<code>list</code>], <em>optional</em>) &#x2014;
List of tags that are related to model or string of a single tag. See example tags
<a href="https://github.com/huggingface/hub-docs/blame/main/modelcard.md" rel="nofollow">here</a>.`,name:"tags"},{anchor:"huggingface_hub.save_pretrained_keras.model_save_kwargs(dict,",description:`<strong>model_save_kwargs(<code>dict</code>,</strong> <em>optional</em>) &#x2014;
model_save_kwargs will be passed to
<a href="https://www.tensorflow.org/api_docs/python/tf/keras/models/save_model" rel="nofollow"><code>tf.keras.models.save_model()</code></a>.`,name:"model_save_kwargs(dict,"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.13.1/src/huggingface_hub/keras_mixin.py#L132"}}),Fe=new lo({}),ze=new U({props:{name:"huggingface_hub.from_pretrained_fastai",anchor:"huggingface_hub.from_pretrained_fastai",parameters:[{name:"repo_id",val:": str"},{name:"revision",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.from_pretrained_fastai.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The location where the pickled fastai.Learner is. It can be either of the two:<ul>
<li>Hosted on the Hugging Face Hub. E.g.: &#x2018;espejelomar/fatai-pet-breeds-classification&#x2019; or &#x2018;distilgpt2&#x2019;.
You can add a <code>revision</code> by appending <code>@</code> at the end of <code>repo_id</code>. E.g.: <code>dbmdz/bert-base-german-cased@main</code>.
Revision is the specific model version to use. Since we use a git-based system for storing models and other
artifacts on the Hugging Face Hub, it can be a branch name, a tag name, or a commit id.</li>
<li>Hosted locally. <code>repo_id</code> would be a directory containing the pickle and a pyproject.toml
indicating the fastai and fastcore versions used to build the <code>fastai.Learner</code>. E.g.: <code>./my_model_directory/</code>.</li>
</ul>`,name:"repo_id"},{anchor:"huggingface_hub.from_pretrained_fastai.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Revision at which the repo&#x2019;s files are downloaded. See documentation of <code>snapshot_download</code>.`,name:"revision"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.13.1/src/huggingface_hub/fastai_utils.py#L298",returnDescription:`
<p>The <code>fastai.Learner</code> model in the <code>repo_id</code> repo.</p>
`}}),qe=new U({props:{name:"huggingface_hub.push_to_hub_fastai",anchor:"huggingface_hub.push_to_hub_fastai",parameters:[{name:"learner",val:""},{name:"repo_id",val:": str"},{name:"commit_message",val:": str = 'Push FastAI model using huggingface_hub.'"},{name:"private",val:": bool = False"},{name:"token",val:": typing.Optional[str] = None"},{name:"config",val:": typing.Optional[dict] = None"},{name:"branch",val:": typing.Optional[str] = None"},{name:"create_pr",val:": typing.Optional[bool] = None"},{name:"allow_patterns",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"ignore_patterns",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"delete_patterns",val:": typing.Union[typing.List[str], str, NoneType] = None"},{name:"api_endpoint",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.push_to_hub_fastai.learner",description:`<strong>learner</strong> (<em>Learner</em>) &#x2014;
The *fastai.Learner&#x2019; you&#x2019;d like to push to the Hub.`,name:"learner"},{anchor:"huggingface_hub.push_to_hub_fastai.repo_id",description:`<strong>repo_id</strong> (<em>str</em>) &#x2014;
The repository id for your model in Hub in the format of &#x201C;namespace/repo_name&#x201D;. The namespace can be your individual account or an organization to which you have write access (for example, &#x2018;stanfordnlp/stanza-de&#x2019;).`,name:"repo_id"},{anchor:"huggingface_hub.push_to_hub_fastai.commit_message",description:"<strong>commit_message</strong> (<em>str`, </em>optional*) &#x2014; Message to commit while pushing. Will default to <code>&quot;add model&quot;</code>.",name:"commit_message"},{anchor:"huggingface_hub.push_to_hub_fastai.private",description:`<strong>private</strong> (<em>bool</em>, <em>optional</em>, defaults to <em>False</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"huggingface_hub.push_to_hub_fastai.token",description:`<strong>token</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The Hugging Face account token to use as HTTP bearer authorization for remote files. If <code>None</code>, the token will be asked by a prompt.`,name:"token"},{anchor:"huggingface_hub.push_to_hub_fastai.config",description:`<strong>config</strong> (<em>dict</em>, <em>optional</em>) &#x2014;
Configuration object to be saved alongside the model weights.`,name:"config"},{anchor:"huggingface_hub.push_to_hub_fastai.branch",description:`<strong>branch</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The git branch on which to push the model. This defaults to
the default branch as specified in your repository, which
defaults to <em>&#x201C;main&#x201D;</em>.`,name:"branch"},{anchor:"huggingface_hub.push_to_hub_fastai.create_pr",description:`<strong>create_pr</strong> (<em>boolean</em>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request from <em>branch</em> with that commit.
Defaults to <em>False</em>.`,name:"create_pr"},{anchor:"huggingface_hub.push_to_hub_fastai.api_endpoint",description:`<strong>api_endpoint</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The API endpoint to use when pushing the model to the hub.`,name:"api_endpoint"},{anchor:"huggingface_hub.push_to_hub_fastai.allow_patterns",description:`<strong>allow_patterns</strong> (<em>List[str]</em> or <em>str</em>, <em>optional</em>) &#x2014;
If provided, only files matching at least one pattern are pushed.`,name:"allow_patterns"},{anchor:"huggingface_hub.push_to_hub_fastai.ignore_patterns",description:`<strong>ignore_patterns</strong> (<em>List[str]</em> or <em>str</em>, <em>optional</em>) &#x2014;
If provided, files matching any of the patterns are not pushed.`,name:"ignore_patterns"},{anchor:"huggingface_hub.push_to_hub_fastai.delete_patterns",description:`<strong>delete_patterns</strong> (<em>List[str]</em> or <em>str</em>, <em>optional</em>) &#x2014;
If provided, remote files matching any of the patterns will be deleted from the repo.`,name:"delete_patterns"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.13.1/src/huggingface_hub/fastai_utils.py#L343",returnDescription:`
<p>The url of the commit of your model in the given repository.</p>
`}}),_e=new jr({props:{$$slots:{default:[qr]},$$scope:{ctx:V}}}),{c(){p=a("meta"),k=d(),u=a("h1"),f=a("a"),M=a("span"),_(g.$$.fragment),$=d(),O=a("span"),we=s("Mixins & serialization methods"),E=d(),T=a("h2"),C=a("a"),ee=a("span"),_(R.$$.fragment),We=d(),co=a("span"),$t=s("Mixins"),Yo=d(),B=a("p"),kt=s("The "),ho=a("code"),Mt=s("huggingface_hub"),Ht=s(` library offers a range of mixins that can be used as a parent class for your objects, in order to
provide simple uploading and downloading functions. Check out our `),Ve=a("a"),Et=s("integration guide"),Tt=s(` to learn
how to integrate any ML framework with the Hub.`),Jo=d(),oe=a("h3"),ie=a("a"),po=a("span"),_(xe.$$.fragment),Pt=d(),go=a("span"),jt=s("Generic"),Qo=d(),H=a("div"),_($e.$$.fragment),Nt=d(),mo=a("p"),Dt=s("A generic mixin to integrate ANY machine learning framework with the Hub."),At=d(),j=a("p"),Lt=s(`To integrate your framework, your model class must inherit from this class. Custom logic for saving/loading models
have to be overwritten in  `),uo=a("code"),It=s("_from_pretrained"),Ut=s(" and "),fo=a("code"),Ot=s("_save_pretrained"),St=s(". "),Re=a("a"),Ct=s("PyTorchModelHubMixin"),Ft=s(` is a good example
of mixin integration with the Hub. Check out our `),Be=a("a"),zt=s("integration guide"),qt=s(" for more instructions."),Kt=d(),le=a("div"),_(ke.$$.fragment),Wt=d(),Me=a("p"),Vt=s(`Overwrite this method in subclass to define how to save your model.
Check out our `),Ge=a("a"),Rt=s("integration guide"),Bt=s(" for instructions."),Gt=d(),S=a("div"),_(He.$$.fragment),Yt=d(),_o=a("p"),Jt=s("Overwrite this method in subclass to define how to load your model from pretrained."),Qt=d(),N=a("p"),Xt=s("Use "),Ye=a("a"),Zt=s("hf_hub_download()"),ea=s(" or "),Je=a("a"),oa=s("snapshot_download()"),ta=s(` to download files from the Hub before loading them. Most
args taken as input can be directly passed to those 2 methods. If needed, you can add more arguments to this
method using \u201Cmodel_kwargs\u201D. For example `),bo=a("code"),aa=s("PyTorchModelHubMixin._from_pretrained()"),na=s(" takes as input a "),vo=a("code"),ra=s("map_location"),sa=s(`
parameter to set on which device the model should be loaded.`),ia=d(),Ee=a("p"),la=s("Check out our "),Qe=a("a"),da=s("integration guide"),ca=s(" for more instructions."),ha=d(),de=a("div"),_(Te.$$.fragment),pa=d(),yo=a("p"),ga=s("Download a model from the Huggingface Hub and instantiate it."),ma=d(),G=a("div"),_(Pe.$$.fragment),ua=d(),wo=a("p"),fa=s("Upload model checkpoint to the Hub."),_a=d(),D=a("p"),ba=s("Use "),xo=a("code"),va=s("allow_patterns"),ya=s(" and "),$o=a("code"),wa=s("ignore_patterns"),xa=s(` to precisely filter which files should be pushed to the hub. Use
`),ko=a("code"),$a=s("delete_patterns"),ka=s(" to delete existing remote files in the same commit. See "),Xe=a("a"),Ma=s("upload_folder()"),Ha=s(` reference for more
details.`),Ea=d(),ce=a("div"),_(je.$$.fragment),Ta=d(),Mo=a("p"),Pa=s("Save weights in local directory."),Xo=d(),te=a("h3"),he=a("a"),Ho=a("span"),_(Ne.$$.fragment),ja=d(),Eo=a("span"),Na=s("PyTorch"),Zo=d(),F=a("div"),_(De.$$.fragment),Da=d(),z=a("p"),Aa=s("Implementation of "),Ze=a("a"),La=s("ModelHubMixin"),Ia=s(` to provide model Hub upload/download capabilities to PyTorch models. The model
is set in evaluation mode by default using `),To=a("code"),Ua=s("model.eval()"),Oa=s(` (dropout modules are deactivated). To train the model,
you should first set it back in training mode with `),Po=a("code"),Sa=s("model.train()"),Ca=s("."),Fa=d(),_(pe.$$.fragment),et=d(),ae=a("h3"),ge=a("a"),jo=a("span"),_(Ae.$$.fragment),za=d(),No=a("span"),qa=s("Keras"),ot=d(),q=a("div"),_(Le.$$.fragment),Ka=d(),Ie=a("p"),Wa=s("Implementation of "),eo=a("a"),Va=s("ModelHubMixin"),Ra=s(` to provide model Hub upload/download
capabilities to Keras models.`),Ba=d(),_(me.$$.fragment),tt=d(),K=a("div"),_(Ue.$$.fragment),Ga=d(),Oe=a("p"),Ya=s(`Instantiate a pretrained Keras model from a pre-trained model from the Hub.
The model is expected to be in `),Do=a("code"),Ja=s("SavedModel"),Qa=s(" format."),Xa=d(),_(ue.$$.fragment),at=d(),W=a("div"),_(Se.$$.fragment),Za=d(),Ao=a("p"),en=s("Upload model checkpoint to the Hub."),on=d(),A=a("p"),tn=s("Use "),Lo=a("code"),an=s("allow_patterns"),nn=s(" and "),Io=a("code"),rn=s("ignore_patterns"),sn=s(` to precisely filter which files should be pushed to the hub. Use
`),Uo=a("code"),ln=s("delete_patterns"),dn=s(" to delete existing remote files in the same commit. See "),oo=a("a"),cn=s("upload_folder()"),hn=s(` reference for more
details.`),nt=d(),ne=a("div"),_(Ce.$$.fragment),pn=d(),Oo=a("p"),gn=s(`Saves a Keras model to save_directory in SavedModel format. Use this if
you\u2019re using the Functional or Sequential APIs.`),rt=d(),re=a("h3"),fe=a("a"),So=a("span"),_(Fe.$$.fragment),mn=d(),Co=a("span"),un=s("Fastai"),st=d(),se=a("div"),_(ze.$$.fragment),fn=d(),Fo=a("p"),_n=s("Load pretrained fastai model from the Hub or from a local directory."),it=d(),L=a("div"),_(qe.$$.fragment),bn=d(),zo=a("p"),vn=s("Upload learner checkpoint files to the Hub."),yn=d(),I=a("p"),wn=s("Use "),qo=a("em"),xn=s("allow_patterns"),$n=s(" and "),Ko=a("em"),kn=s("ignore_patterns"),Mn=s(` to precisely filter which files should be pushed to the hub. Use
`),Wo=a("em"),Hn=s("delete_patterns"),En=s(" to delete existing remote files in the same commit. See ["),Vo=a("em"),Tn=s("upload_folder"),Pn=s(`] reference for more
details.`),jn=d(),_(_e.$$.fragment),this.h()},l(o){const h=Or('[data-svelte="svelte-1phssyn"]',document.head);p=n(h,"META",{name:!0,content:!0}),h.forEach(t),k=c(o),u=n(o,"H1",{class:!0});var Ke=r(u);f=n(Ke,"A",{id:!0,class:!0,href:!0});var Ro=r(f);M=n(Ro,"SPAN",{});var Bo=r(M);b(g.$$.fragment,Bo),Bo.forEach(t),Ro.forEach(t),$=c(Ke),O=n(Ke,"SPAN",{});var Go=r(O);we=i(Go,"Mixins & serialization methods"),Go.forEach(t),Ke.forEach(t),E=c(o),T=n(o,"H2",{class:!0});var dt=r(T);C=n(dt,"A",{id:!0,class:!0,href:!0});var Nn=r(C);ee=n(Nn,"SPAN",{});var Dn=r(ee);b(R.$$.fragment,Dn),Dn.forEach(t),Nn.forEach(t),We=c(dt),co=n(dt,"SPAN",{});var An=r(co);$t=i(An,"Mixins"),An.forEach(t),dt.forEach(t),Yo=c(o),B=n(o,"P",{});var to=r(B);kt=i(to,"The "),ho=n(to,"CODE",{});var Ln=r(ho);Mt=i(Ln,"huggingface_hub"),Ln.forEach(t),Ht=i(to,` library offers a range of mixins that can be used as a parent class for your objects, in order to
provide simple uploading and downloading functions. Check out our `),Ve=n(to,"A",{href:!0});var In=r(Ve);Et=i(In,"integration guide"),In.forEach(t),Tt=i(to,` to learn
how to integrate any ML framework with the Hub.`),to.forEach(t),Jo=c(o),oe=n(o,"H3",{class:!0});var ct=r(oe);ie=n(ct,"A",{id:!0,class:!0,href:!0});var Un=r(ie);po=n(Un,"SPAN",{});var On=r(po);b(xe.$$.fragment,On),On.forEach(t),Un.forEach(t),Pt=c(ct),go=n(ct,"SPAN",{});var Sn=r(go);jt=i(Sn,"Generic"),Sn.forEach(t),ct.forEach(t),Qo=c(o),H=n(o,"DIV",{class:!0});var P=r(H);b($e.$$.fragment,P),Nt=c(P),mo=n(P,"P",{});var Cn=r(mo);Dt=i(Cn,"A generic mixin to integrate ANY machine learning framework with the Hub."),Cn.forEach(t),At=c(P),j=n(P,"P",{});var Y=r(j);Lt=i(Y,`To integrate your framework, your model class must inherit from this class. Custom logic for saving/loading models
have to be overwritten in  `),uo=n(Y,"CODE",{});var Fn=r(uo);It=i(Fn,"_from_pretrained"),Fn.forEach(t),Ut=i(Y," and "),fo=n(Y,"CODE",{});var zn=r(fo);Ot=i(zn,"_save_pretrained"),zn.forEach(t),St=i(Y,". "),Re=n(Y,"A",{href:!0});var qn=r(Re);Ct=i(qn,"PyTorchModelHubMixin"),qn.forEach(t),Ft=i(Y,` is a good example
of mixin integration with the Hub. Check out our `),Be=n(Y,"A",{href:!0});var Kn=r(Be);zt=i(Kn,"integration guide"),Kn.forEach(t),qt=i(Y," for more instructions."),Y.forEach(t),Kt=c(P),le=n(P,"DIV",{class:!0});var ht=r(le);b(ke.$$.fragment,ht),Wt=c(ht),Me=n(ht,"P",{});var pt=r(Me);Vt=i(pt,`Overwrite this method in subclass to define how to save your model.
Check out our `),Ge=n(pt,"A",{href:!0});var Wn=r(Ge);Rt=i(Wn,"integration guide"),Wn.forEach(t),Bt=i(pt," for instructions."),pt.forEach(t),ht.forEach(t),Gt=c(P),S=n(P,"DIV",{class:!0});var be=r(S);b(He.$$.fragment,be),Yt=c(be),_o=n(be,"P",{});var Vn=r(_o);Jt=i(Vn,"Overwrite this method in subclass to define how to load your model from pretrained."),Vn.forEach(t),Qt=c(be),N=n(be,"P",{});var J=r(N);Xt=i(J,"Use "),Ye=n(J,"A",{href:!0});var Rn=r(Ye);Zt=i(Rn,"hf_hub_download()"),Rn.forEach(t),ea=i(J," or "),Je=n(J,"A",{href:!0});var Bn=r(Je);oa=i(Bn,"snapshot_download()"),Bn.forEach(t),ta=i(J,` to download files from the Hub before loading them. Most
args taken as input can be directly passed to those 2 methods. If needed, you can add more arguments to this
method using \u201Cmodel_kwargs\u201D. For example `),bo=n(J,"CODE",{});var Gn=r(bo);aa=i(Gn,"PyTorchModelHubMixin._from_pretrained()"),Gn.forEach(t),na=i(J," takes as input a "),vo=n(J,"CODE",{});var Yn=r(vo);ra=i(Yn,"map_location"),Yn.forEach(t),sa=i(J,`
parameter to set on which device the model should be loaded.`),J.forEach(t),ia=c(be),Ee=n(be,"P",{});var gt=r(Ee);la=i(gt,"Check out our "),Qe=n(gt,"A",{href:!0});var Jn=r(Qe);da=i(Jn,"integration guide"),Jn.forEach(t),ca=i(gt," for more instructions."),gt.forEach(t),be.forEach(t),ha=c(P),de=n(P,"DIV",{class:!0});var mt=r(de);b(Te.$$.fragment,mt),pa=c(mt),yo=n(mt,"P",{});var Qn=r(yo);ga=i(Qn,"Download a model from the Huggingface Hub and instantiate it."),Qn.forEach(t),mt.forEach(t),ma=c(P),G=n(P,"DIV",{class:!0});var ao=r(G);b(Pe.$$.fragment,ao),ua=c(ao),wo=n(ao,"P",{});var Xn=r(wo);fa=i(Xn,"Upload model checkpoint to the Hub."),Xn.forEach(t),_a=c(ao),D=n(ao,"P",{});var Q=r(D);ba=i(Q,"Use "),xo=n(Q,"CODE",{});var Zn=r(xo);va=i(Zn,"allow_patterns"),Zn.forEach(t),ya=i(Q," and "),$o=n(Q,"CODE",{});var er=r($o);wa=i(er,"ignore_patterns"),er.forEach(t),xa=i(Q,` to precisely filter which files should be pushed to the hub. Use
`),ko=n(Q,"CODE",{});var or=r(ko);$a=i(or,"delete_patterns"),or.forEach(t),ka=i(Q," to delete existing remote files in the same commit. See "),Xe=n(Q,"A",{href:!0});var tr=r(Xe);Ma=i(tr,"upload_folder()"),tr.forEach(t),Ha=i(Q,` reference for more
details.`),Q.forEach(t),ao.forEach(t),Ea=c(P),ce=n(P,"DIV",{class:!0});var ut=r(ce);b(je.$$.fragment,ut),Ta=c(ut),Mo=n(ut,"P",{});var ar=r(Mo);Pa=i(ar,"Save weights in local directory."),ar.forEach(t),ut.forEach(t),P.forEach(t),Xo=c(o),te=n(o,"H3",{class:!0});var ft=r(te);he=n(ft,"A",{id:!0,class:!0,href:!0});var nr=r(he);Ho=n(nr,"SPAN",{});var rr=r(Ho);b(Ne.$$.fragment,rr),rr.forEach(t),nr.forEach(t),ja=c(ft),Eo=n(ft,"SPAN",{});var sr=r(Eo);Na=i(sr,"PyTorch"),sr.forEach(t),ft.forEach(t),Zo=c(o),F=n(o,"DIV",{class:!0});var no=r(F);b(De.$$.fragment,no),Da=c(no),z=n(no,"P",{});var ve=r(z);Aa=i(ve,"Implementation of "),Ze=n(ve,"A",{href:!0});var ir=r(Ze);La=i(ir,"ModelHubMixin"),ir.forEach(t),Ia=i(ve,` to provide model Hub upload/download capabilities to PyTorch models. The model
is set in evaluation mode by default using `),To=n(ve,"CODE",{});var lr=r(To);Ua=i(lr,"model.eval()"),lr.forEach(t),Oa=i(ve,` (dropout modules are deactivated). To train the model,
you should first set it back in training mode with `),Po=n(ve,"CODE",{});var dr=r(Po);Sa=i(dr,"model.train()"),dr.forEach(t),Ca=i(ve,"."),ve.forEach(t),Fa=c(no),b(pe.$$.fragment,no),no.forEach(t),et=c(o),ae=n(o,"H3",{class:!0});var _t=r(ae);ge=n(_t,"A",{id:!0,class:!0,href:!0});var cr=r(ge);jo=n(cr,"SPAN",{});var hr=r(jo);b(Ae.$$.fragment,hr),hr.forEach(t),cr.forEach(t),za=c(_t),No=n(_t,"SPAN",{});var pr=r(No);qa=i(pr,"Keras"),pr.forEach(t),_t.forEach(t),ot=c(o),q=n(o,"DIV",{class:!0});var ro=r(q);b(Le.$$.fragment,ro),Ka=c(ro),Ie=n(ro,"P",{});var bt=r(Ie);Wa=i(bt,"Implementation of "),eo=n(bt,"A",{href:!0});var gr=r(eo);Va=i(gr,"ModelHubMixin"),gr.forEach(t),Ra=i(bt,` to provide model Hub upload/download
capabilities to Keras models.`),bt.forEach(t),Ba=c(ro),b(me.$$.fragment,ro),ro.forEach(t),tt=c(o),K=n(o,"DIV",{class:!0});var so=r(K);b(Ue.$$.fragment,so),Ga=c(so),Oe=n(so,"P",{});var vt=r(Oe);Ya=i(vt,`Instantiate a pretrained Keras model from a pre-trained model from the Hub.
The model is expected to be in `),Do=n(vt,"CODE",{});var mr=r(Do);Ja=i(mr,"SavedModel"),mr.forEach(t),Qa=i(vt," format."),vt.forEach(t),Xa=c(so),b(ue.$$.fragment,so),so.forEach(t),at=c(o),W=n(o,"DIV",{class:!0});var io=r(W);b(Se.$$.fragment,io),Za=c(io),Ao=n(io,"P",{});var ur=r(Ao);en=i(ur,"Upload model checkpoint to the Hub."),ur.forEach(t),on=c(io),A=n(io,"P",{});var X=r(A);tn=i(X,"Use "),Lo=n(X,"CODE",{});var fr=r(Lo);an=i(fr,"allow_patterns"),fr.forEach(t),nn=i(X," and "),Io=n(X,"CODE",{});var _r=r(Io);rn=i(_r,"ignore_patterns"),_r.forEach(t),sn=i(X,` to precisely filter which files should be pushed to the hub. Use
`),Uo=n(X,"CODE",{});var br=r(Uo);ln=i(br,"delete_patterns"),br.forEach(t),dn=i(X," to delete existing remote files in the same commit. See "),oo=n(X,"A",{href:!0});var vr=r(oo);cn=i(vr,"upload_folder()"),vr.forEach(t),hn=i(X,` reference for more
details.`),X.forEach(t),io.forEach(t),nt=c(o),ne=n(o,"DIV",{class:!0});var yt=r(ne);b(Ce.$$.fragment,yt),pn=c(yt),Oo=n(yt,"P",{});var yr=r(Oo);gn=i(yr,`Saves a Keras model to save_directory in SavedModel format. Use this if
you\u2019re using the Functional or Sequential APIs.`),yr.forEach(t),yt.forEach(t),rt=c(o),re=n(o,"H3",{class:!0});var wt=r(re);fe=n(wt,"A",{id:!0,class:!0,href:!0});var wr=r(fe);So=n(wr,"SPAN",{});var xr=r(So);b(Fe.$$.fragment,xr),xr.forEach(t),wr.forEach(t),mn=c(wt),Co=n(wt,"SPAN",{});var $r=r(Co);un=i($r,"Fastai"),$r.forEach(t),wt.forEach(t),st=c(o),se=n(o,"DIV",{class:!0});var xt=r(se);b(ze.$$.fragment,xt),fn=c(xt),Fo=n(xt,"P",{});var kr=r(Fo);_n=i(kr,"Load pretrained fastai model from the Hub or from a local directory."),kr.forEach(t),xt.forEach(t),it=c(o),L=n(o,"DIV",{class:!0});var ye=r(L);b(qe.$$.fragment,ye),bn=c(ye),zo=n(ye,"P",{});var Mr=r(zo);vn=i(Mr,"Upload learner checkpoint files to the Hub."),Mr.forEach(t),yn=c(ye),I=n(ye,"P",{});var Z=r(I);wn=i(Z,"Use "),qo=n(Z,"EM",{});var Hr=r(qo);xn=i(Hr,"allow_patterns"),Hr.forEach(t),$n=i(Z," and "),Ko=n(Z,"EM",{});var Er=r(Ko);kn=i(Er,"ignore_patterns"),Er.forEach(t),Mn=i(Z,` to precisely filter which files should be pushed to the hub. Use
`),Wo=n(Z,"EM",{});var Tr=r(Wo);Hn=i(Tr,"delete_patterns"),Tr.forEach(t),En=i(Z," to delete existing remote files in the same commit. See ["),Vo=n(Z,"EM",{});var Pr=r(Vo);Tn=i(Pr,"upload_folder"),Pr.forEach(t),Pn=i(Z,`] reference for more
details.`),Z.forEach(t),jn=c(ye),b(_e.$$.fragment,ye),ye.forEach(t),this.h()},h(){l(p,"name","hf:doc:metadata"),l(p,"content",JSON.stringify(Wr)),l(f,"id","mixins-serialization-methods"),l(f,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(f,"href","#mixins-serialization-methods"),l(u,"class","relative group"),l(C,"id","mixins"),l(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(C,"href","#mixins"),l(T,"class","relative group"),l(Ve,"href","../guides/integrations"),l(ie,"id","huggingface_hub.ModelHubMixin"),l(ie,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(ie,"href","#huggingface_hub.ModelHubMixin"),l(oe,"class","relative group"),l(Re,"href","/docs/huggingface_hub/v0.13.1/en/package_reference/mixins#huggingface_hub.PyTorchModelHubMixin"),l(Be,"href","../guides/integrations"),l(Ge,"href","../guides/integrations"),l(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ye,"href","/docs/huggingface_hub/v0.13.1/en/package_reference/file_download#huggingface_hub.hf_hub_download"),l(Je,"href","/docs/huggingface_hub/v0.13.1/en/package_reference/file_download#huggingface_hub.snapshot_download"),l(Qe,"href","../guides/integrations"),l(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Xe,"href","/docs/huggingface_hub/v0.13.1/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder"),l(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(he,"id","huggingface_hub.PyTorchModelHubMixin"),l(he,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(he,"href","#huggingface_hub.PyTorchModelHubMixin"),l(te,"class","relative group"),l(Ze,"href","/docs/huggingface_hub/v0.13.1/en/package_reference/mixins#huggingface_hub.ModelHubMixin"),l(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ge,"id","huggingface_hub.KerasModelHubMixin"),l(ge,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(ge,"href","#huggingface_hub.KerasModelHubMixin"),l(ae,"class","relative group"),l(eo,"href","/docs/huggingface_hub/v0.13.1/en/package_reference/mixins#huggingface_hub.ModelHubMixin"),l(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(oo,"href","/docs/huggingface_hub/v0.13.1/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder"),l(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(fe,"id","huggingface_hub.from_pretrained_fastai"),l(fe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(fe,"href","#huggingface_hub.from_pretrained_fastai"),l(re,"class","relative group"),l(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(o,h){e(document.head,p),m(o,k,h),m(o,u,h),e(u,f),e(f,M),v(g,M,null),e(u,$),e(u,O),e(O,we),m(o,E,h),m(o,T,h),e(T,C),e(C,ee),v(R,ee,null),e(T,We),e(T,co),e(co,$t),m(o,Yo,h),m(o,B,h),e(B,kt),e(B,ho),e(ho,Mt),e(B,Ht),e(B,Ve),e(Ve,Et),e(B,Tt),m(o,Jo,h),m(o,oe,h),e(oe,ie),e(ie,po),v(xe,po,null),e(oe,Pt),e(oe,go),e(go,jt),m(o,Qo,h),m(o,H,h),v($e,H,null),e(H,Nt),e(H,mo),e(mo,Dt),e(H,At),e(H,j),e(j,Lt),e(j,uo),e(uo,It),e(j,Ut),e(j,fo),e(fo,Ot),e(j,St),e(j,Re),e(Re,Ct),e(j,Ft),e(j,Be),e(Be,zt),e(j,qt),e(H,Kt),e(H,le),v(ke,le,null),e(le,Wt),e(le,Me),e(Me,Vt),e(Me,Ge),e(Ge,Rt),e(Me,Bt),e(H,Gt),e(H,S),v(He,S,null),e(S,Yt),e(S,_o),e(_o,Jt),e(S,Qt),e(S,N),e(N,Xt),e(N,Ye),e(Ye,Zt),e(N,ea),e(N,Je),e(Je,oa),e(N,ta),e(N,bo),e(bo,aa),e(N,na),e(N,vo),e(vo,ra),e(N,sa),e(S,ia),e(S,Ee),e(Ee,la),e(Ee,Qe),e(Qe,da),e(Ee,ca),e(H,ha),e(H,de),v(Te,de,null),e(de,pa),e(de,yo),e(yo,ga),e(H,ma),e(H,G),v(Pe,G,null),e(G,ua),e(G,wo),e(wo,fa),e(G,_a),e(G,D),e(D,ba),e(D,xo),e(xo,va),e(D,ya),e(D,$o),e($o,wa),e(D,xa),e(D,ko),e(ko,$a),e(D,ka),e(D,Xe),e(Xe,Ma),e(D,Ha),e(H,Ea),e(H,ce),v(je,ce,null),e(ce,Ta),e(ce,Mo),e(Mo,Pa),m(o,Xo,h),m(o,te,h),e(te,he),e(he,Ho),v(Ne,Ho,null),e(te,ja),e(te,Eo),e(Eo,Na),m(o,Zo,h),m(o,F,h),v(De,F,null),e(F,Da),e(F,z),e(z,Aa),e(z,Ze),e(Ze,La),e(z,Ia),e(z,To),e(To,Ua),e(z,Oa),e(z,Po),e(Po,Sa),e(z,Ca),e(F,Fa),v(pe,F,null),m(o,et,h),m(o,ae,h),e(ae,ge),e(ge,jo),v(Ae,jo,null),e(ae,za),e(ae,No),e(No,qa),m(o,ot,h),m(o,q,h),v(Le,q,null),e(q,Ka),e(q,Ie),e(Ie,Wa),e(Ie,eo),e(eo,Va),e(Ie,Ra),e(q,Ba),v(me,q,null),m(o,tt,h),m(o,K,h),v(Ue,K,null),e(K,Ga),e(K,Oe),e(Oe,Ya),e(Oe,Do),e(Do,Ja),e(Oe,Qa),e(K,Xa),v(ue,K,null),m(o,at,h),m(o,W,h),v(Se,W,null),e(W,Za),e(W,Ao),e(Ao,en),e(W,on),e(W,A),e(A,tn),e(A,Lo),e(Lo,an),e(A,nn),e(A,Io),e(Io,rn),e(A,sn),e(A,Uo),e(Uo,ln),e(A,dn),e(A,oo),e(oo,cn),e(A,hn),m(o,nt,h),m(o,ne,h),v(Ce,ne,null),e(ne,pn),e(ne,Oo),e(Oo,gn),m(o,rt,h),m(o,re,h),e(re,fe),e(fe,So),v(Fe,So,null),e(re,mn),e(re,Co),e(Co,un),m(o,st,h),m(o,se,h),v(ze,se,null),e(se,fn),e(se,Fo),e(Fo,_n),m(o,it,h),m(o,L,h),v(qe,L,null),e(L,bn),e(L,zo),e(zo,vn),e(L,yn),e(L,I),e(I,wn),e(I,qo),e(qo,xn),e(I,$n),e(I,Ko),e(Ko,kn),e(I,Mn),e(I,Wo),e(Wo,Hn),e(I,En),e(I,Vo),e(Vo,Tn),e(I,Pn),e(L,jn),v(_e,L,null),lt=!0},p(o,[h]){const Ke={};h&2&&(Ke.$$scope={dirty:h,ctx:o}),pe.$set(Ke);const Ro={};h&2&&(Ro.$$scope={dirty:h,ctx:o}),me.$set(Ro);const Bo={};h&2&&(Bo.$$scope={dirty:h,ctx:o}),ue.$set(Bo);const Go={};h&2&&(Go.$$scope={dirty:h,ctx:o}),_e.$set(Go)},i(o){lt||(y(g.$$.fragment,o),y(R.$$.fragment,o),y(xe.$$.fragment,o),y($e.$$.fragment,o),y(ke.$$.fragment,o),y(He.$$.fragment,o),y(Te.$$.fragment,o),y(Pe.$$.fragment,o),y(je.$$.fragment,o),y(Ne.$$.fragment,o),y(De.$$.fragment,o),y(pe.$$.fragment,o),y(Ae.$$.fragment,o),y(Le.$$.fragment,o),y(me.$$.fragment,o),y(Ue.$$.fragment,o),y(ue.$$.fragment,o),y(Se.$$.fragment,o),y(Ce.$$.fragment,o),y(Fe.$$.fragment,o),y(ze.$$.fragment,o),y(qe.$$.fragment,o),y(_e.$$.fragment,o),lt=!0)},o(o){w(g.$$.fragment,o),w(R.$$.fragment,o),w(xe.$$.fragment,o),w($e.$$.fragment,o),w(ke.$$.fragment,o),w(He.$$.fragment,o),w(Te.$$.fragment,o),w(Pe.$$.fragment,o),w(je.$$.fragment,o),w(Ne.$$.fragment,o),w(De.$$.fragment,o),w(pe.$$.fragment,o),w(Ae.$$.fragment,o),w(Le.$$.fragment,o),w(me.$$.fragment,o),w(Ue.$$.fragment,o),w(ue.$$.fragment,o),w(Se.$$.fragment,o),w(Ce.$$.fragment,o),w(Fe.$$.fragment,o),w(ze.$$.fragment,o),w(qe.$$.fragment,o),w(_e.$$.fragment,o),lt=!1},d(o){t(p),o&&t(k),o&&t(u),x(g),o&&t(E),o&&t(T),x(R),o&&t(Yo),o&&t(B),o&&t(Jo),o&&t(oe),x(xe),o&&t(Qo),o&&t(H),x($e),x(ke),x(He),x(Te),x(Pe),x(je),o&&t(Xo),o&&t(te),x(Ne),o&&t(Zo),o&&t(F),x(De),x(pe),o&&t(et),o&&t(ae),x(Ae),o&&t(ot),o&&t(q),x(Le),x(me),o&&t(tt),o&&t(K),x(Ue),x(ue),o&&t(at),o&&t(W),x(Se),o&&t(nt),o&&t(ne),x(Ce),o&&t(rt),o&&t(re),x(Fe),o&&t(st),o&&t(se),x(ze),o&&t(it),o&&t(L),x(qe),x(_e)}}}const Wr={local:"mixins-serialization-methods",sections:[{local:"mixins",sections:[{local:"huggingface_hub.ModelHubMixin",title:"Generic"},{local:"huggingface_hub.PyTorchModelHubMixin",title:"PyTorch"},{local:"huggingface_hub.KerasModelHubMixin",title:"Keras"},{local:"huggingface_hub.from_pretrained_fastai",title:"Fastai"}],title:"Mixins"}],title:"Mixins & serialization methods"};function Vr(V){return Sr(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xr extends Lr{constructor(p){super();Ir(this,p,Vr,Kr,Ur,{})}}export{Xr as default,Wr as metadata};
