import{s as Kt,o as en,n as Ge}from"../chunks/scheduler.9bc65507.js";import{S as tn,i as nn,g as m,s as o,r as u,A as an,h as p,f as a,c as r,j as S,u as g,x as v,k,y as c,a as l,v as f,d as T,t as _,w as b}from"../chunks/index.707bf1b6.js";import{D as Z}from"../chunks/Docstring.17db21ae.js";import{C as Ne}from"../chunks/CodeBlock.54a9f38d.js";import{E as Ze}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as G}from"../chunks/Heading.342b1fa6.js";function sn(w){let s,M;return s=new Ne({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBhdGNoVFNUQ29uZmlnJTJDJTIwUGF0Y2hUU1RNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGFuJTIwUGF0Y2hUU1QlMjBjb25maWd1cmF0aW9uJTIwd2l0aCUyMDEyJTIwdGltZSUyMHN0ZXBzJTIwZm9yJTIwcHJlZGljdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBQYXRjaFRTVENvbmZpZyhwcmVkaWN0aW9uX2xlbmd0aCUzRDEyKSUwQSUwQSUyMyUyMFJhbmRvbWx5JTIwaW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBQYXRjaFRTVE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PatchTSTConfig, PatchTSTModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing an PatchTST configuration with 12 time steps for prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = PatchTSTConfig(prediction_length=<span class="hljs-number">12</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Randomly initializing a model (with random weights) from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PatchTSTModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){u(s.$$.fragment)},l(d){g(s.$$.fragment,d)},m(d,i){f(s,d,i),M=!0},p:Ge,i(d){M||(T(s.$$.fragment,d),M=!0)},o(d){_(s.$$.fragment,d),M=!1},d(d){b(s,d)}}}function on(w){let s,M="Examples:",d,i,h;return i=new Ne({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBhdGNoVFNUTW9kZWwlMEElMEFmaWxlJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZXR0aDEtaG91cmx5LWJhdGNoJTIyJTJDJTIwZmlsZW5hbWUlM0QlMjJ0cmFpbi1iYXRjaC5wdCUyMiUyQyUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMEEpJTBBYmF0Y2glMjAlM0QlMjB0b3JjaC5sb2FkKGZpbGUpJTBBJTBBbW9kZWwlMjAlM0QlMjBQYXRjaFRTVE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJuYW1jdGluJTJGcGF0Y2h0c3RfZXR0aDFfcHJldHJhaW4lMjIpJTBBJTBBJTIzJTIwZHVyaW5nJTIwdHJhaW5pbmclMkMlMjBvbmUlMjBwcm92aWRlcyUyMGJvdGglMjBwYXN0JTIwYW5kJTIwZnV0dXJlJTIwdmFsdWVzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCUwQSUyMCUyMCUyMCUyMHBhc3RfdmFsdWVzJTNEYmF0Y2glNUIlMjJwYXN0X3ZhbHVlcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGZ1dHVyZV92YWx1ZXMlM0RiYXRjaCU1QiUyMmZ1dHVyZV92YWx1ZXMlMjIlNUQlMkMlMEEpJTBBJTBBbGFzdF9oaWRkZW5fc3RhdGUlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PatchTSTModel

<span class="hljs-meta">&gt;&gt;&gt; </span>file = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;hf-internal-testing/etth1-hourly-batch&quot;</span>, filename=<span class="hljs-string">&quot;train-batch.pt&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>batch = torch.load(file)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PatchTSTModel.from_pretrained(<span class="hljs-string">&quot;namctin/patchtst_etth1_pretrain&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># during training, one provides both past and future values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(
<span class="hljs-meta">... </span>    past_values=batch[<span class="hljs-string">&quot;past_values&quot;</span>],
<span class="hljs-meta">... </span>    future_values=batch[<span class="hljs-string">&quot;future_values&quot;</span>],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state`,wrap:!1}}),{c(){s=m("p"),s.textContent=M,d=o(),u(i.$$.fragment)},l(t){s=p(t,"P",{"data-svelte-h":!0}),v(s)!=="svelte-kvfsh7"&&(s.textContent=M),d=r(t),g(i.$$.fragment,t)},m(t,y){l(t,s,y),l(t,d,y),f(i,t,y),h=!0},p:Ge,i(t){h||(T(i.$$.fragment,t),h=!0)},o(t){_(i.$$.fragment,t),h=!1},d(t){t&&(a(s),a(d)),b(i,t)}}}function rn(w){let s,M="Examples:",d,i,h;return i=new Ne({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBhdGNoVFNUQ29uZmlnJTJDJTIwUGF0Y2hUU1RGb3JQcmVkaWN0aW9uJTBBJTBBZmlsZSUyMCUzRCUyMGhmX2h1Yl9kb3dubG9hZCglMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmV0dGgxLWhvdXJseS1iYXRjaCUyMiUyQyUyMGZpbGVuYW1lJTNEJTIydHJhaW4tYmF0Y2gucHQlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyJTBBKSUwQWJhdGNoJTIwJTNEJTIwdG9yY2gubG9hZChmaWxlKSUwQSUwQSUyMyUyMFByZWRpY3Rpb24lMjB0YXNrJTIwd2l0aCUyMDclMjBpbnB1dCUyMGNoYW5uZWxzJTIwYW5kJTIwcHJlZGljdGlvbiUyMGxlbmd0aCUyMGlzJTIwOTYlMEFtb2RlbCUyMCUzRCUyMFBhdGNoVFNURm9yUHJlZGljdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIybmFtY3RpbiUyRnBhdGNodHN0X2V0dGgxX2ZvcmVjYXN0JTIyKSUwQSUwQSUyMyUyMGR1cmluZyUyMHRyYWluaW5nJTJDJTIwb25lJTIwcHJvdmlkZXMlMjBib3RoJTIwcGFzdCUyMGFuZCUyMGZ1dHVyZSUyMHZhbHVlcyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCglMEElMjAlMjAlMjAlMjBwYXN0X3ZhbHVlcyUzRGJhdGNoJTVCJTIycGFzdF92YWx1ZXMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBmdXR1cmVfdmFsdWVzJTNEYmF0Y2glNUIlMjJmdXR1cmVfdmFsdWVzJTIyJTVEJTJDJTBBKSUwQSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEFsb3NzLmJhY2t3YXJkKCklMEElMEElMjMlMjBkdXJpbmclMjBpbmZlcmVuY2UlMkMlMjBvbmUlMjBvbmx5JTIwcHJvdmlkZXMlMjBwYXN0JTIwdmFsdWVzJTJDJTIwdGhlJTIwbW9kZWwlMjBvdXRwdXRzJTIwZnV0dXJlJTIwdmFsdWVzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBhc3RfdmFsdWVzJTNEYmF0Y2glNUIlMjJwYXN0X3ZhbHVlcyUyMiU1RCklMEFwcmVkaWN0aW9uX291dHB1dHMlMjAlM0QlMjBvdXRwdXRzLnByZWRpY3Rpb25fb3V0cHV0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PatchTSTConfig, PatchTSTForPrediction

<span class="hljs-meta">&gt;&gt;&gt; </span>file = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;hf-internal-testing/etth1-hourly-batch&quot;</span>, filename=<span class="hljs-string">&quot;train-batch.pt&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>batch = torch.load(file)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prediction task with 7 input channels and prediction length is 96</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PatchTSTForPrediction.from_pretrained(<span class="hljs-string">&quot;namctin/patchtst_etth1_forecast&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># during training, one provides both past and future values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(
<span class="hljs-meta">... </span>    past_values=batch[<span class="hljs-string">&quot;past_values&quot;</span>],
<span class="hljs-meta">... </span>    future_values=batch[<span class="hljs-string">&quot;future_values&quot;</span>],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>loss.backward()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># during inference, one only provides past values, the model outputs future values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(past_values=batch[<span class="hljs-string">&quot;past_values&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>prediction_outputs = outputs.prediction_outputs`,wrap:!1}}),{c(){s=m("p"),s.textContent=M,d=o(),u(i.$$.fragment)},l(t){s=p(t,"P",{"data-svelte-h":!0}),v(s)!=="svelte-kvfsh7"&&(s.textContent=M),d=r(t),g(i.$$.fragment,t)},m(t,y){l(t,s,y),l(t,d,y),f(i,t,y),h=!0},p:Ge,i(t){h||(T(i.$$.fragment,t),h=!0)},o(t){_(i.$$.fragment,t),h=!1},d(t){t&&(a(s),a(d)),b(i,t)}}}function ln(w){let s,M="Examples:",d,i,h;return i=new Ne({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBhdGNoVFNUQ29uZmlnJTJDJTIwUGF0Y2hUU1RGb3JDbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMGNsYXNzaWZpY2F0aW9uJTIwdGFzayUyMHdpdGglMjB0d28lMjBpbnB1dCUyMGNoYW5uZWwyJTIwYW5kJTIwMyUyMGNsYXNzZXMlMEFjb25maWclMjAlM0QlMjBQYXRjaFRTVENvbmZpZyglMEElMjAlMjAlMjAlMjBudW1faW5wdXRfY2hhbm5lbHMlM0QyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RhcmdldHMlM0QzJTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dF9sZW5ndGglM0Q1MTIlMkMlMEElMjAlMjAlMjAlMjBwYXRjaF9sZW5ndGglM0QxMiUyQyUwQSUyMCUyMCUyMCUyMHN0cmlkZSUzRDEyJTJDJTBBJTIwJTIwJTIwJTIwdXNlX2Nsc190b2tlbiUzRFRydWUlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBQYXRjaFRTVEZvckNsYXNzaWZpY2F0aW9uKGNvbmZpZyUzRGNvbmZpZyklMEElMEElMjMlMjBkdXJpbmclMjBpbmZlcmVuY2UlMkMlMjBvbmUlMjBvbmx5JTIwcHJvdmlkZXMlMjBwYXN0JTIwdmFsdWVzJTBBcGFzdF92YWx1ZXMlMjAlM0QlMjB0b3JjaC5yYW5kbigyMCUyQyUyMDUxMiUyQyUyMDIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBhc3RfdmFsdWVzJTNEcGFzdF92YWx1ZXMpJTBBbGFiZWxzJTIwJTNEJTIwb3V0cHV0cy5wcmVkaWN0aW9uX2xvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PatchTSTConfig, PatchTSTForClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># classification task with two input channel2 and 3 classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PatchTSTConfig(
<span class="hljs-meta">... </span>    num_input_channels=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    num_targets=<span class="hljs-number">3</span>,
<span class="hljs-meta">... </span>    context_length=<span class="hljs-number">512</span>,
<span class="hljs-meta">... </span>    patch_length=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    stride=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    use_cls_token=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PatchTSTForClassification(config=config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># during inference, one only provides past values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_values = torch.randn(<span class="hljs-number">20</span>, <span class="hljs-number">512</span>, <span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(past_values=past_values)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = outputs.prediction_logits`,wrap:!1}}),{c(){s=m("p"),s.textContent=M,d=o(),u(i.$$.fragment)},l(t){s=p(t,"P",{"data-svelte-h":!0}),v(s)!=="svelte-kvfsh7"&&(s.textContent=M),d=r(t),g(i.$$.fragment,t)},m(t,y){l(t,s,y),l(t,d,y),f(i,t,y),h=!0},p:Ge,i(t){h||(T(i.$$.fragment,t),h=!0)},o(t){_(i.$$.fragment,t),h=!1},d(t){t&&(a(s),a(d)),b(i,t)}}}function cn(w){let s,M="Examples:",d,i,h;return i=new Ne({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBhdGNoVFNUQ29uZmlnJTJDJTIwUGF0Y2hUU1RGb3JQcmV0cmFpbmluZyUwQSUwQWZpbGUlMjAlM0QlMjBoZl9odWJfZG93bmxvYWQoJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZldHRoMS1ob3VybHktYmF0Y2glMjIlMkMlMjBmaWxlbmFtZSUzRCUyMnRyYWluLWJhdGNoLnB0JTIyJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUwQSklMEFiYXRjaCUyMCUzRCUyMHRvcmNoLmxvYWQoZmlsZSklMEElMEElMjMlMjBDb25maWclMjBmb3IlMjByYW5kb20lMjBtYXNrJTIwcHJldHJhaW5pbmclMEFjb25maWclMjAlM0QlMjBQYXRjaFRTVENvbmZpZyglMEElMjAlMjAlMjAlMjBudW1faW5wdXRfY2hhbm5lbHMlM0Q3JTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dF9sZW5ndGglM0Q1MTIlMkMlMEElMjAlMjAlMjAlMjBwYXRjaF9sZW5ndGglM0QxMiUyQyUwQSUyMCUyMCUyMCUyMHN0cmlkZSUzRDEyJTJDJTBBJTIwJTIwJTIwJTIwbWFza190eXBlJTNEJ3JhbmRvbSclMkMlMEElMjAlMjAlMjAlMjByYW5kb21fbWFza19yYXRpbyUzRDAuNCUyQyUwQSUyMCUyMCUyMCUyMHVzZV9jbHNfdG9rZW4lM0RUcnVlJTJDJTBBKSUwQSUyMyUyMENvbmZpZyUyMGZvciUyMGZvcmVjYXN0JTIwbWFzayUyMHByZXRyYWluaW5nJTBBY29uZmlnJTIwJTNEJTIwUGF0Y2hUU1RDb25maWcoJTBBJTIwJTIwJTIwJTIwbnVtX2lucHV0X2NoYW5uZWxzJTNENyUyQyUwQSUyMCUyMCUyMCUyMGNvbnRleHRfbGVuZ3RoJTNENTEyJTJDJTBBJTIwJTIwJTIwJTIwcGF0Y2hfbGVuZ3RoJTNEMTIlMkMlMEElMjAlMjAlMjAlMjBzdHJpZGUlM0QxMiUyQyUwQSUyMCUyMCUyMCUyMG1hc2tfdHlwZSUzRCdmb3JlY2FzdCclMkMlMEElMjAlMjAlMjAlMjBudW1fZm9yZWNhc3RfbWFza19wYXRjaGVzJTNENSUyQyUwQSUyMCUyMCUyMCUyMHVzZV9jbHNfdG9rZW4lM0RUcnVlJTJDJTBBKSUwQW1vZGVsJTIwJTNEJTIwUGF0Y2hUU1RGb3JQcmV0cmFpbmluZyhjb25maWcpJTBBJTBBJTIzJTIwZHVyaW5nJTIwdHJhaW5pbmclMkMlMjBvbmUlMjBwcm92aWRlcyUyMGJvdGglMjBwYXN0JTIwYW5kJTIwZnV0dXJlJTIwdmFsdWVzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBhc3RfdmFsdWVzJTNEYmF0Y2glNUIlMjJwYXN0X3ZhbHVlcyUyMiU1RCklMEElMEFsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBbG9zcy5iYWNrd2FyZCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PatchTSTConfig, PatchTSTForPretraining

<span class="hljs-meta">&gt;&gt;&gt; </span>file = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;hf-internal-testing/etth1-hourly-batch&quot;</span>, filename=<span class="hljs-string">&quot;train-batch.pt&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>batch = torch.load(file)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Config for random mask pretraining</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PatchTSTConfig(
<span class="hljs-meta">... </span>    num_input_channels=<span class="hljs-number">7</span>,
<span class="hljs-meta">... </span>    context_length=<span class="hljs-number">512</span>,
<span class="hljs-meta">... </span>    patch_length=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    stride=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    mask_type=<span class="hljs-string">&#x27;random&#x27;</span>,
<span class="hljs-meta">... </span>    random_mask_ratio=<span class="hljs-number">0.4</span>,
<span class="hljs-meta">... </span>    use_cls_token=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Config for forecast mask pretraining</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PatchTSTConfig(
<span class="hljs-meta">... </span>    num_input_channels=<span class="hljs-number">7</span>,
<span class="hljs-meta">... </span>    context_length=<span class="hljs-number">512</span>,
<span class="hljs-meta">... </span>    patch_length=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    stride=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    mask_type=<span class="hljs-string">&#x27;forecast&#x27;</span>,
<span class="hljs-meta">... </span>    num_forecast_mask_patches=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>    use_cls_token=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PatchTSTForPretraining(config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># during training, one provides both past and future values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(past_values=batch[<span class="hljs-string">&quot;past_values&quot;</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>loss.backward()`,wrap:!1}}),{c(){s=m("p"),s.textContent=M,d=o(),u(i.$$.fragment)},l(t){s=p(t,"P",{"data-svelte-h":!0}),v(s)!=="svelte-kvfsh7"&&(s.textContent=M),d=r(t),g(i.$$.fragment,t)},m(t,y){l(t,s,y),l(t,d,y),f(i,t,y),h=!0},p:Ge,i(t){h||(T(i.$$.fragment,t),h=!0)},o(t){_(i.$$.fragment,t),h=!1},d(t){t&&(a(s),a(d)),b(i,t)}}}function dn(w){let s,M="Examples:",d,i,h;return i=new Ne({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBhdGNoVFNUQ29uZmlnJTJDJTIwUGF0Y2hUU1RGb3JSZWdyZXNzaW9uJTBBJTBBJTIzJTIwUmVncmVzc2lvbiUyMHRhc2slMjB3aXRoJTIwNiUyMGlucHV0JTIwY2hhbm5lbHMlMjBhbmQlMjByZWdyZXNzJTIwMiUyMHRhcmdldHMlMEFtb2RlbCUyMCUzRCUyMFBhdGNoVFNURm9yUmVncmVzc2lvbi5mcm9tX3ByZXRyYWluZWQoJTIybmFtY3RpbiUyRnBhdGNodHN0X2V0dGgxX3JlZ3Jlc3Npb24lMjIpJTBBJTBBJTIzJTIwZHVyaW5nJTIwaW5mZXJlbmNlJTJDJTIwb25lJTIwb25seSUyMHByb3ZpZGVzJTIwcGFzdCUyMHZhbHVlcyUyQyUyMHRoZSUyMG1vZGVsJTIwb3V0cHV0cyUyMGZ1dHVyZSUyMHZhbHVlcyUwQXBhc3RfdmFsdWVzJTIwJTNEJTIwdG9yY2gucmFuZG4oMjAlMkMlMjA1MTIlMkMlMjA2KSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChwYXN0X3ZhbHVlcyUzRHBhc3RfdmFsdWVzKSUwQXJlZ3Jlc3Npb25fb3V0cHV0cyUyMCUzRCUyMG91dHB1dHMucmVncmVzc2lvbl9vdXRwdXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PatchTSTConfig, PatchTSTForRegression

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Regression task with 6 input channels and regress 2 targets</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PatchTSTForRegression.from_pretrained(<span class="hljs-string">&quot;namctin/patchtst_etth1_regression&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># during inference, one only provides past values, the model outputs future values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_values = torch.randn(<span class="hljs-number">20</span>, <span class="hljs-number">512</span>, <span class="hljs-number">6</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(past_values=past_values)
<span class="hljs-meta">&gt;&gt;&gt; </span>regression_outputs = outputs.regression_outputs`,wrap:!1}}),{c(){s=m("p"),s.textContent=M,d=o(),u(i.$$.fragment)},l(t){s=p(t,"P",{"data-svelte-h":!0}),v(s)!=="svelte-kvfsh7"&&(s.textContent=M),d=r(t),g(i.$$.fragment,t)},m(t,y){l(t,s,y),l(t,d,y),f(i,t,y),h=!0},p:Ge,i(t){h||(T(i.$$.fragment,t),h=!0)},o(t){_(i.$$.fragment,t),h=!1},d(t){t&&(a(s),a(d)),b(i,t)}}}function mn(w){let s,M,d,i,h,t,y,Re,A,Bt='The PatchTST model was proposed in <a href="https://arxiv.org/abs/2211.14730" rel="nofollow">A Time Series is Worth 64 Words: Long-term Forecasting with Transformers</a> by Yuqi Nie, Nam H. Nguyen, Phanwadee Sinthong and Jayant Kalagnanam.',Ve,O,Wt="At a high level the model vectorizes time series into patches of a given size and encodes the resulting sequence of vectors via a Transformer that then outputs the prediction length forecast via an appropriate head. The model is illustrated in the following figure:",He,K,Zt='<img src="https://github.com/namctin/transformers/assets/8100/150af169-29de-419a-8d98-eb78251c21fa" alt="model"/>',ze,ee,Gt="The abstract from the paper is the following:",Ye,te,Nt="<em>We propose an efficient design of Transformer-based models for multivariate time series forecasting and self-supervised representation learning. It is based on two key components: (i) segmentation of time series into subseries-level patches which are served as input tokens to Transformer; (ii) channel-independence where each channel contains a single univariate time series that shares the same embedding and Transformer weights across all the series. Patching design naturally has three-fold benefit: local semantic information is retained in the embedding; computation and memory usage of the attention maps are quadratically reduced given the same look-back window; and the model can attend longer history. Our channel-independent patch time series Transformer (PatchTST) can improve the long-term forecasting accuracy significantly when compared with that of SOTA Transformer-based models. We also apply our model to self-supervised pre-training tasks and attain excellent fine-tuning performance, which outperforms supervised training on large datasets. Transferring of masked pre-trained representation on one dataset to others also produces SOTA forecasting accuracy.</em>",Xe,ne,It='This model was contributed by <a href="https://huggingface.co/namctin" rel="nofollow">namctin</a>, <a href="https://huggingface.co/gsinthong" rel="nofollow">gsinthong</a>, <a href="https://huggingface.co/diepi" rel="nofollow">diepi</a>, <a href="https://huggingface.co/vijaye12" rel="nofollow">vijaye12</a>, <a href="https://huggingface.co/wmgifford" rel="nofollow">wmgifford</a>, and <a href="https://huggingface.co/kashif" rel="nofollow">kashif</a>. The original code can be found <a href="https://github.com/yuqinie98/PatchTST" rel="nofollow">here</a>.',Ee,ae,qe,se,Rt='The model can also be used for time series classification and time series regression. See the respective <a href="/docs/transformers/v4.36.1/en/model_doc/patchtst#transformers.PatchTSTForClassification">PatchTSTForClassification</a> and <a href="/docs/transformers/v4.36.1/en/model_doc/patchtst#transformers.PatchTSTForRegression">PatchTSTForRegression</a> classes.',Qe,oe,De,j,re,mt,je,Vt=`This is the configuration class to store the configuration of an <a href="/docs/transformers/v4.36.1/en/model_doc/patchtst#transformers.PatchTSTModel">PatchTSTModel</a>. It is used to instantiate an
PatchTST model according to the specified arguments, defining the model architecture.
<a href="https://huggingface.co/ibm/patchtst" rel="nofollow">ibm/patchtst</a> architecture.`,pt,$e,Ht=`Configuration objects inherit from <a href="/docs/transformers/v4.36.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.36.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,ht,N,Le,le,Ae,$,ie,ut,Je,zt=`The bare PatchTST Model outputting raw hidden-states without any specific head.
This model inherits from <a href="/docs/transformers/v4.36.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,gt,Ue,Yt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ft,I,ce,Tt,R,Oe,de,Ke,J,me,_t,Pe,Xt=`The PatchTST for prediction model.
This model inherits from <a href="/docs/transformers/v4.36.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,bt,Ce,Et=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,yt,V,pe,Mt,H,et,he,tt,U,ue,vt,Se,qt=`The PatchTST for classification model.
This model inherits from <a href="/docs/transformers/v4.36.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,wt,ke,Qt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,jt,z,ge,$t,Y,nt,fe,at,P,Te,Jt,xe,Dt=`The PatchTST for pretrain model.
This model inherits from <a href="/docs/transformers/v4.36.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ut,Fe,Lt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Pt,X,_e,Ct,E,st,be,ot,C,ye,St,Be,At=`The PatchTST for regression model.
This model inherits from <a href="/docs/transformers/v4.36.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,kt,We,Ot=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,xt,q,Me,Ft,Q,rt,Ie,lt;return h=new G({props:{title:"PatchTST",local:"patchtst",headingTag:"h1"}}),y=new G({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ae=new G({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),oe=new G({props:{title:"PatchTSTConfig",local:"transformers.PatchTSTConfig",headingTag:"h2"}}),re=new Z({props:{name:"class transformers.PatchTSTConfig",anchor:"transformers.PatchTSTConfig",parameters:[{name:"num_input_channels",val:": int = 1"},{name:"context_length",val:": int = 32"},{name:"distribution_output",val:": str = 'student_t'"},{name:"loss",val:": str = 'mse'"},{name:"patch_length",val:": int = 1"},{name:"patch_stride",val:": int = 1"},{name:"num_hidden_layers",val:": int = 3"},{name:"d_model",val:": int = 128"},{name:"num_attention_heads",val:": int = 4"},{name:"share_embedding",val:": bool = True"},{name:"channel_attention",val:": bool = False"},{name:"ffn_dim",val:": int = 512"},{name:"norm_type",val:": str = 'batchnorm'"},{name:"norm_eps",val:": float = 1e-05"},{name:"attention_dropout",val:": float = 0.0"},{name:"dropout",val:": float = 0.0"},{name:"positional_dropout",val:": float = 0.0"},{name:"path_dropout",val:": float = 0.0"},{name:"ff_dropout",val:": float = 0.0"},{name:"bias",val:": bool = True"},{name:"activation_function",val:": str = 'gelu'"},{name:"pre_norm",val:": bool = True"},{name:"positional_encoding_type",val:": str = 'sincos'"},{name:"use_cls_token",val:": bool = False"},{name:"init_std",val:": float = 0.02"},{name:"share_projection",val:": bool = True"},{name:"scaling",val:": typing.Union[str, bool, NoneType] = 'std'"},{name:"do_mask_input",val:": typing.Optional[bool] = None"},{name:"mask_type",val:": str = 'random'"},{name:"random_mask_ratio",val:": float = 0.5"},{name:"num_forecast_mask_patches",val:": typing.Union[typing.List[int], int, NoneType] = [2]"},{name:"channel_consistent_masking",val:": typing.Optional[bool] = False"},{name:"unmasked_channel_indices",val:": typing.Optional[typing.List[int]] = None"},{name:"mask_value",val:": int = 0"},{name:"pooling_type",val:": str = 'mean'"},{name:"head_dropout",val:": float = 0.0"},{name:"prediction_length",val:": int = 24"},{name:"num_targets",val:": int = 1"},{name:"output_range",val:": typing.Optional[typing.List] = None"},{name:"num_parallel_samples",val:": int = 100"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PatchTSTConfig.num_input_channels",description:`<strong>num_input_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The size of the target variable which by default is 1 for univariate targets. Would be &gt; 1 in case of
multivariate targets.`,name:"num_input_channels"},{anchor:"transformers.PatchTSTConfig.context_length",description:`<strong>context_length</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The context length of the input sequence.`,name:"context_length"},{anchor:"transformers.PatchTSTConfig.distribution_output",description:`<strong>distribution_output</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;student_t&quot;</code>) &#x2014;
The distribution emission head for the model when loss is &#x201C;nll&#x201D;. Could be either &#x201C;student_t&#x201D;, &#x201C;normal&#x201D; or
&#x201C;negative_binomial&#x201D;.`,name:"distribution_output"},{anchor:"transformers.PatchTSTConfig.loss",description:`<strong>loss</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;mse&quot;</code>) &#x2014;
The loss function for the model corresponding to the <code>distribution_output</code> head. For parametric
distributions it is the negative log likelihood (&#x201C;nll&#x201D;) and for point estimates it is the mean squared
error &#x201C;mse&#x201D;.`,name:"loss"},{anchor:"transformers.PatchTSTConfig.patch_length",description:`<strong>patch_length</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Define the patch length of the patchification process.`,name:"patch_length"},{anchor:"transformers.PatchTSTConfig.patch_stride",description:`<strong>patch_stride</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Define the stride of the patchification process.`,name:"patch_stride"},{anchor:"transformers.PatchTSTConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of hidden layers.`,name:"num_hidden_layers"},{anchor:"transformers.PatchTSTConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Dimensionality of the transformer layers.`,name:"d_model"},{anchor:"transformers.PatchTSTConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.PatchTSTConfig.share_embedding",description:`<strong>share_embedding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Sharing the input embedding across all channels.`,name:"share_embedding"},{anchor:"transformers.PatchTSTConfig.channel_attention",description:`<strong>channel_attention</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activate channel attention block in the Transformer to allow channels to attend each other.`,name:"channel_attention"},{anchor:"transformers.PatchTSTConfig.ffn_dim",description:`<strong>ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the Transformer encoder.`,name:"ffn_dim"},{anchor:"transformers.PatchTSTConfig.norm_type",description:`<strong>norm_type</strong> (<code>str</code> , <em>optional</em>, defaults to <code>&quot;batchnorm&quot;</code>) &#x2014;
Normalization at each Transformer layer. Can be <code>&quot;batchnorm&quot;</code> or <code>&quot;layernorm&quot;</code>.`,name:"norm_type"},{anchor:"transformers.PatchTSTConfig.norm_eps",description:`<strong>norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
A value added to the denominator for numerical stability of normalization.`,name:"norm_eps"},{anchor:"transformers.PatchTSTConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.PatchTSTConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the Transformer.`,name:"dropout"},{anchor:"transformers.PatchTSTConfig.positional_dropout",description:`<strong>positional_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability in the positional embedding layer.`,name:"positional_dropout"},{anchor:"transformers.PatchTSTConfig.path_dropout",description:`<strong>path_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout path in the residual block.`,name:"path_dropout"},{anchor:"transformers.PatchTSTConfig.ff_dropout",description:`<strong>ff_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability used between the two layers of the feed-forward networks.`,name:"ff_dropout"},{anchor:"transformers.PatchTSTConfig.bias",description:`<strong>bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add bias in the feed-forward networks.`,name:"bias"},{anchor:"transformers.PatchTSTConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (string) in the Transformer.<code>&quot;gelu&quot;</code> and <code>&quot;relu&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.PatchTSTConfig.pre_norm",description:`<strong>pre_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Normalization is applied before self-attention if pre_norm is set to <code>True</code>. Otherwise, normalization is
applied after residual block.`,name:"pre_norm"},{anchor:"transformers.PatchTSTConfig.positional_encoding_type",description:`<strong>positional_encoding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sincos&quot;</code>) &#x2014;
Positional encodings. Options <code>&quot;random&quot;</code> and <code>&quot;sincos&quot;</code> are supported.`,name:"positional_encoding_type"},{anchor:"transformers.PatchTSTConfig.use_cls_token",description:`<strong>use_cls_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether cls token is used.`,name:"use_cls_token"},{anchor:"transformers.PatchTSTConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated normal weight initialization distribution.`,name:"init_std"},{anchor:"transformers.PatchTSTConfig.share_projection",description:`<strong>share_projection</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Sharing the projection layer across different channels in the forecast head.`,name:"share_projection"},{anchor:"transformers.PatchTSTConfig.scaling",description:`<strong>scaling</strong> (<code>Union</code>, <em>optional</em>, defaults to <code>&quot;std&quot;</code>) &#x2014;
Whether to scale the input targets via &#x201C;mean&#x201D; scaler, &#x201C;std&#x201D; scaler or no scaler if <code>None</code>. If <code>True</code>, the
scaler is set to &#x201C;mean&#x201D;.`,name:"scaling"},{anchor:"transformers.PatchTSTConfig.do_mask_input",description:`<strong>do_mask_input</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Apply masking during the pretraining.`,name:"do_mask_input"},{anchor:"transformers.PatchTSTConfig.mask_type",description:`<strong>mask_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;random&quot;</code>) &#x2014;
Masking type. Only <code>&quot;random&quot;</code> and <code>&quot;forecast&quot;</code> are currently supported.`,name:"mask_type"},{anchor:"transformers.PatchTSTConfig.random_mask_ratio",description:`<strong>random_mask_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Masking ratio applied to mask the input data during random pretraining.`,name:"random_mask_ratio"},{anchor:"transformers.PatchTSTConfig.num_forecast_mask_patches",description:`<strong>num_forecast_mask_patches</strong> (<code>int</code> or <code>list</code>, <em>optional</em>, defaults to <code>[2]</code>) &#x2014;
Number of patches to be masked at the end of each batch sample. If it is an integer,
all the samples in the batch will have the same number of masked patches. If it is a list,
samples in the batch will be randomly masked by numbers defined in the list. This argument is only used
for forecast pretraining.`,name:"num_forecast_mask_patches"},{anchor:"transformers.PatchTSTConfig.channel_consistent_masking",description:`<strong>channel_consistent_masking</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If channel consistent masking is True, all the channels will have the same masking pattern.`,name:"channel_consistent_masking"},{anchor:"transformers.PatchTSTConfig.unmasked_channel_indices",description:`<strong>unmasked_channel_indices</strong> (<code>list</code>, <em>optional</em>) &#x2014;
Indices of channels that are not masked during pretraining. Values in the list are number between 1 and
<code>num_input_channels</code>`,name:"unmasked_channel_indices"},{anchor:"transformers.PatchTSTConfig.mask_value",description:`<strong>mask_value</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Values in the masked patches will be filled by <code>mask_value</code>.`,name:"mask_value"},{anchor:"transformers.PatchTSTConfig.pooling_type",description:`<strong>pooling_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;mean&quot;</code>) &#x2014;
Pooling of the embedding. <code>&quot;mean&quot;</code>, <code>&quot;max&quot;</code> and <code>None</code> are supported.`,name:"pooling_type"},{anchor:"transformers.PatchTSTConfig.head_dropout",description:`<strong>head_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for head.`,name:"head_dropout"},{anchor:"transformers.PatchTSTConfig.prediction_length",description:`<strong>prediction_length</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
The prediction horizon that the model will output.`,name:"prediction_length"},{anchor:"transformers.PatchTSTConfig.num_targets",description:`<strong>num_targets</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of targets for regression and classification tasks. For classification, it is the number of
classes.`,name:"num_targets"},{anchor:"transformers.PatchTSTConfig.output_range",description:`<strong>output_range</strong> (<code>list</code>, <em>optional</em>) &#x2014;
Output range for regression task. The range of output values can be set to enforce the model to produce
values within a range.`,name:"output_range"},{anchor:"transformers.PatchTSTConfig.num_parallel_samples",description:`<strong>num_parallel_samples</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of samples is generated in parallel for probabilistic prediction.`,name:"num_parallel_samples"}],source:"https://github.com/huggingface/transformers/blob/v4.36.1/src/transformers/models/patchtst/configuration_patchtst.py#L31"}}),N=new Ze({props:{anchor:"transformers.PatchTSTConfig.example",$$slots:{default:[sn]},$$scope:{ctx:w}}}),le=new G({props:{title:"PatchTSTModel",local:"transformers.PatchTSTModel",headingTag:"h2"}}),ie=new Z({props:{name:"class transformers.PatchTSTModel",anchor:"transformers.PatchTSTModel",parameters:[{name:"config",val:": PatchTSTConfig"}],parametersDescription:[{anchor:"transformers.PatchTSTModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.36.1/en/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.36.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.36.1/src/transformers/models/patchtst/modeling_patchtst.py#L1151"}}),ce=new Z({props:{name:"forward",anchor:"transformers.PatchTSTModel.forward",parameters:[{name:"past_values",val:": Tensor"},{name:"past_observed_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"future_values",val:": typing.Optional[torch.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PatchTSTModel.forward.past_values",description:`<strong>past_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, sequence_length, num_input_channels)</code>, <em>required</em>) &#x2014;
Input sequence to the model`,name:"past_values"},{anchor:"transformers.PatchTSTModel.forward.past_observed_mask",description:`<strong>past_observed_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length, num_input_channels)</code>, <em>optional</em>) &#x2014;
Boolean mask to indicate which <code>past_values</code> were observed and which were missing. Mask values selected
in <code>[0, 1]</code>:</p>
<ul>
<li>1 for values that are <strong>observed</strong>,</li>
<li>0 for values that are <strong>missing</strong> (i.e. NaNs that were replaced by zeros).</li>
</ul>`,name:"past_observed_mask"},{anchor:"transformers.PatchTSTModel.forward.future_values",description:`<strong>future_values</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, prediction_length, num_input_channels)</code>, <em>optional</em>) &#x2014;
Future target values associated with the <code>past_values</code>`,name:"future_values"},{anchor:"transformers.PatchTSTModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers`,name:"output_hidden_states"},{anchor:"transformers.PatchTSTModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the output attention of all layers`,name:"output_attentions"},{anchor:"transformers.PatchTSTModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>ModelOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.36.1/src/transformers/models/patchtst/modeling_patchtst.py#L1170",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PatchTSTModelOutput</code> or tuple of <code>torch.Tensor</code> (if <code>return_dict</code>=False or <code>config.return_dict</code>=False)</p>
`}}),R=new Ze({props:{anchor:"transformers.PatchTSTModel.forward.example",$$slots:{default:[on]},$$scope:{ctx:w}}}),de=new G({props:{title:"PatchTSTForPrediction",local:"transformers.PatchTSTForPrediction",headingTag:"h2"}}),me=new Z({props:{name:"class transformers.PatchTSTForPrediction",anchor:"transformers.PatchTSTForPrediction",parameters:[{name:"config",val:": PatchTSTConfig"}],parametersDescription:[{anchor:"transformers.PatchTSTForPrediction.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.36.1/en/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.36.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.36.1/src/transformers/models/patchtst/modeling_patchtst.py#L1642"}}),pe=new Z({props:{name:"forward",anchor:"transformers.PatchTSTForPrediction.forward",parameters:[{name:"past_values",val:": Tensor"},{name:"past_observed_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"future_values",val:": typing.Optional[torch.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PatchTSTForPrediction.forward.past_values",description:`<strong>past_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, sequence_length, num_input_channels)</code>, <em>required</em>) &#x2014;
Input sequence to the model`,name:"past_values"},{anchor:"transformers.PatchTSTForPrediction.forward.past_observed_mask",description:`<strong>past_observed_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length, num_input_channels)</code>, <em>optional</em>) &#x2014;
Boolean mask to indicate which <code>past_values</code> were observed and which were missing. Mask values selected
in <code>[0, 1]</code>:</p>
<ul>
<li>1 for values that are <strong>observed</strong>,</li>
<li>0 for values that are <strong>missing</strong> (i.e. NaNs that were replaced by zeros).</li>
</ul>`,name:"past_observed_mask"},{anchor:"transformers.PatchTSTForPrediction.forward.future_values",description:`<strong>future_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, forecast_len, num_input_channels)</code>, <em>optional</em>) &#x2014;
Future target values associated with the <code>past_values</code>`,name:"future_values"},{anchor:"transformers.PatchTSTForPrediction.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers`,name:"output_hidden_states"},{anchor:"transformers.PatchTSTForPrediction.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the output attention of all layers`,name:"output_attentions"},{anchor:"transformers.PatchTSTForPrediction.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>ModelOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.36.1/src/transformers/models/patchtst/modeling_patchtst.py#L1672",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PatchTSTForPredictionOutput</code> or tuple of <code>torch.Tensor</code> (if <code>return_dict</code>=False or
<code>config.return_dict</code>=False)</p>
`}}),H=new Ze({props:{anchor:"transformers.PatchTSTForPrediction.forward.example",$$slots:{default:[rn]},$$scope:{ctx:w}}}),he=new G({props:{title:"PatchTSTForClassification",local:"transformers.PatchTSTForClassification",headingTag:"h2"}}),ue=new Z({props:{name:"class transformers.PatchTSTForClassification",anchor:"transformers.PatchTSTForClassification",parameters:[{name:"config",val:": PatchTSTConfig"}],parametersDescription:[{anchor:"transformers.PatchTSTForClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.36.1/en/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.36.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.36.1/src/transformers/models/patchtst/modeling_patchtst.py#L1447"}}),ge=new Z({props:{name:"forward",anchor:"transformers.PatchTSTForClassification.forward",parameters:[{name:"past_values",val:": Tensor"},{name:"target_values",val:": Tensor = None"},{name:"past_observed_mask",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PatchTSTForClassification.forward.past_values",description:`<strong>past_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, sequence_length, num_input_channels)</code>, <em>required</em>) &#x2014;
Input sequence to the model`,name:"past_values"},{anchor:"transformers.PatchTSTForClassification.forward.target_values",description:`<strong>target_values</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Labels associates with the <code>past_values</code>`,name:"target_values"},{anchor:"transformers.PatchTSTForClassification.forward.past_observed_mask",description:`<strong>past_observed_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length, num_input_channels)</code>, <em>optional</em>) &#x2014;
Boolean mask to indicate which <code>past_values</code> were observed and which were missing. Mask values selected
in <code>[0, 1]</code>:</p>
<ul>
<li>1 for values that are <strong>observed</strong>,</li>
<li>0 for values that are <strong>missing</strong> (i.e. NaNs that were replaced by zeros).</li>
</ul>`,name:"past_observed_mask"},{anchor:"transformers.PatchTSTForClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers`,name:"output_hidden_states"},{anchor:"transformers.PatchTSTForClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the output attention of all layers`,name:"output_attentions"},{anchor:"transformers.PatchTSTForClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>ModelOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.36.1/src/transformers/models/patchtst/modeling_patchtst.py#L1462",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PatchTSTForClassificationOutput</code> or tuple of <code>torch.Tensor</code> (if <code>return_dict</code>=False or
<code>config.return_dict</code>=False)</p>
`}}),Y=new Ze({props:{anchor:"transformers.PatchTSTForClassification.forward.example",$$slots:{default:[ln]},$$scope:{ctx:w}}}),fe=new G({props:{title:"PatchTSTForPretraining",local:"transformers.PatchTSTForPretraining",headingTag:"h2"}}),Te=new Z({props:{name:"class transformers.PatchTSTForPretraining",anchor:"transformers.PatchTSTForPretraining",parameters:[{name:"config",val:": PatchTSTConfig"}],parametersDescription:[{anchor:"transformers.PatchTSTForPretraining.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.36.1/en/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.36.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.36.1/src/transformers/models/patchtst/modeling_patchtst.py#L1295"}}),_e=new Z({props:{name:"forward",anchor:"transformers.PatchTSTForPretraining.forward",parameters:[{name:"past_values",val:": Tensor"},{name:"past_observed_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PatchTSTForPretraining.forward.past_values",description:`<strong>past_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, sequence_length, num_input_channels)</code>, <em>required</em>) &#x2014;
Input sequence to the model`,name:"past_values"},{anchor:"transformers.PatchTSTForPretraining.forward.past_observed_mask",description:`<strong>past_observed_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length, num_input_channels)</code>, <em>optional</em>) &#x2014;
Boolean mask to indicate which <code>past_values</code> were observed and which were missing. Mask values selected
in <code>[0, 1]</code>:</p>
<ul>
<li>1 for values that are <strong>observed</strong>,</li>
<li>0 for values that are <strong>missing</strong> (i.e. NaNs that were replaced by zeros).</li>
</ul>`,name:"past_observed_mask"},{anchor:"transformers.PatchTSTForPretraining.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers`,name:"output_hidden_states"},{anchor:"transformers.PatchTSTForPretraining.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the output attention of all layers`,name:"output_attentions"},{anchor:"transformers.PatchTSTForPretraining.forward.return_dict",description:"<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014; Whether or not to return a <code>ModelOutput</code> instead of a plain tuple.",name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.36.1/src/transformers/models/patchtst/modeling_patchtst.py#L1306",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PatchTSTForPretrainingOutput</code> or tuple of <code>torch.Tensor</code> (if <code>return_dict</code>=False or
<code>config.return_dict</code>=False)</p>
`}}),E=new Ze({props:{anchor:"transformers.PatchTSTForPretraining.forward.example",$$slots:{default:[cn]},$$scope:{ctx:w}}}),be=new G({props:{title:"PatchTSTForRegression",local:"transformers.PatchTSTForRegression",headingTag:"h2"}}),ye=new Z({props:{name:"class transformers.PatchTSTForRegression",anchor:"transformers.PatchTSTForRegression",parameters:[{name:"config",val:": PatchTSTConfig"}],parametersDescription:[{anchor:"transformers.PatchTSTForRegression.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.36.1/en/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.36.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.36.1/src/transformers/models/patchtst/modeling_patchtst.py#L1888"}}),Me=new Z({props:{name:"forward",anchor:"transformers.PatchTSTForRegression.forward",parameters:[{name:"past_values",val:": Tensor"},{name:"target_values",val:": Tensor = None"},{name:"past_observed_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PatchTSTForRegression.forward.past_values",description:`<strong>past_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, sequence_length, num_input_channels)</code>, <em>required</em>) &#x2014;
Input sequence to the model`,name:"past_values"},{anchor:"transformers.PatchTSTForRegression.forward.target_values",description:`<strong>target_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, num_input_channels)</code>) &#x2014;
Target values associates with the <code>past_values</code>`,name:"target_values"},{anchor:"transformers.PatchTSTForRegression.forward.past_observed_mask",description:`<strong>past_observed_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length, num_input_channels)</code>, <em>optional</em>) &#x2014;
Boolean mask to indicate which <code>past_values</code> were observed and which were missing. Mask values selected
in <code>[0, 1]</code>:</p>
<ul>
<li>1 for values that are <strong>observed</strong>,</li>
<li>0 for values that are <strong>missing</strong> (i.e. NaNs that were replaced by zeros).</li>
</ul>`,name:"past_observed_mask"},{anchor:"transformers.PatchTSTForRegression.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers`,name:"output_hidden_states"},{anchor:"transformers.PatchTSTForRegression.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the output attention of all layers`,name:"output_attentions"},{anchor:"transformers.PatchTSTForRegression.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>ModelOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.36.1/src/transformers/models/patchtst/modeling_patchtst.py#L1915",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PatchTSTForRegressionOutput</code> or tuple of <code>torch.Tensor</code> (if <code>return_dict</code>=False or
<code>config.return_dict</code>=False)</p>
`}}),Q=new Ze({props:{anchor:"transformers.PatchTSTForRegression.forward.example",$$slots:{default:[dn]},$$scope:{ctx:w}}}),{c(){s=m("meta"),M=o(),d=m("p"),i=o(),u(h.$$.fragment),t=o(),u(y.$$.fragment),Re=o(),A=m("p"),A.innerHTML=Bt,Ve=o(),O=m("p"),O.textContent=Wt,He=o(),K=m("p"),K.innerHTML=Zt,ze=o(),ee=m("p"),ee.textContent=Gt,Ye=o(),te=m("p"),te.innerHTML=Nt,Xe=o(),ne=m("p"),ne.innerHTML=It,Ee=o(),u(ae.$$.fragment),qe=o(),se=m("p"),se.innerHTML=Rt,Qe=o(),u(oe.$$.fragment),De=o(),j=m("div"),u(re.$$.fragment),mt=o(),je=m("p"),je.innerHTML=Vt,pt=o(),$e=m("p"),$e.innerHTML=Ht,ht=o(),u(N.$$.fragment),Le=o(),u(le.$$.fragment),Ae=o(),$=m("div"),u(ie.$$.fragment),ut=o(),Je=m("p"),Je.innerHTML=zt,gt=o(),Ue=m("p"),Ue.innerHTML=Yt,ft=o(),I=m("div"),u(ce.$$.fragment),Tt=o(),u(R.$$.fragment),Oe=o(),u(de.$$.fragment),Ke=o(),J=m("div"),u(me.$$.fragment),_t=o(),Pe=m("p"),Pe.innerHTML=Xt,bt=o(),Ce=m("p"),Ce.innerHTML=Et,yt=o(),V=m("div"),u(pe.$$.fragment),Mt=o(),u(H.$$.fragment),et=o(),u(he.$$.fragment),tt=o(),U=m("div"),u(ue.$$.fragment),vt=o(),Se=m("p"),Se.innerHTML=qt,wt=o(),ke=m("p"),ke.innerHTML=Qt,jt=o(),z=m("div"),u(ge.$$.fragment),$t=o(),u(Y.$$.fragment),nt=o(),u(fe.$$.fragment),at=o(),P=m("div"),u(Te.$$.fragment),Jt=o(),xe=m("p"),xe.innerHTML=Dt,Ut=o(),Fe=m("p"),Fe.innerHTML=Lt,Pt=o(),X=m("div"),u(_e.$$.fragment),Ct=o(),u(E.$$.fragment),st=o(),u(be.$$.fragment),ot=o(),C=m("div"),u(ye.$$.fragment),St=o(),Be=m("p"),Be.innerHTML=At,kt=o(),We=m("p"),We.innerHTML=Ot,xt=o(),q=m("div"),u(Me.$$.fragment),Ft=o(),u(Q.$$.fragment),rt=o(),Ie=m("p"),this.h()},l(e){const n=an("svelte-u9bgzb",document.head);s=p(n,"META",{name:!0,content:!0}),n.forEach(a),M=r(e),d=p(e,"P",{}),S(d).forEach(a),i=r(e),g(h.$$.fragment,e),t=r(e),g(y.$$.fragment,e),Re=r(e),A=p(e,"P",{"data-svelte-h":!0}),v(A)!=="svelte-a4z81d"&&(A.innerHTML=Bt),Ve=r(e),O=p(e,"P",{"data-svelte-h":!0}),v(O)!=="svelte-11qe7tl"&&(O.textContent=Wt),He=r(e),K=p(e,"P",{"data-svelte-h":!0}),v(K)!=="svelte-cqhrix"&&(K.innerHTML=Zt),ze=r(e),ee=p(e,"P",{"data-svelte-h":!0}),v(ee)!=="svelte-vfdo9a"&&(ee.textContent=Gt),Ye=r(e),te=p(e,"P",{"data-svelte-h":!0}),v(te)!=="svelte-1lan0k1"&&(te.innerHTML=Nt),Xe=r(e),ne=p(e,"P",{"data-svelte-h":!0}),v(ne)!=="svelte-kbmat5"&&(ne.innerHTML=It),Ee=r(e),g(ae.$$.fragment,e),qe=r(e),se=p(e,"P",{"data-svelte-h":!0}),v(se)!=="svelte-vy7d4b"&&(se.innerHTML=Rt),Qe=r(e),g(oe.$$.fragment,e),De=r(e),j=p(e,"DIV",{class:!0});var x=S(j);g(re.$$.fragment,x),mt=r(x),je=p(x,"P",{"data-svelte-h":!0}),v(je)!=="svelte-pq4uss"&&(je.innerHTML=Vt),pt=r(x),$e=p(x,"P",{"data-svelte-h":!0}),v($e)!=="svelte-11rz932"&&($e.innerHTML=Ht),ht=r(x),g(N.$$.fragment,x),x.forEach(a),Le=r(e),g(le.$$.fragment,e),Ae=r(e),$=p(e,"DIV",{class:!0});var F=S($);g(ie.$$.fragment,F),ut=r(F),Je=p(F,"P",{"data-svelte-h":!0}),v(Je)!=="svelte-cyd05i"&&(Je.innerHTML=zt),gt=r(F),Ue=p(F,"P",{"data-svelte-h":!0}),v(Ue)!=="svelte-hswkmf"&&(Ue.innerHTML=Yt),ft=r(F),I=p(F,"DIV",{class:!0});var ve=S(I);g(ce.$$.fragment,ve),Tt=r(ve),g(R.$$.fragment,ve),ve.forEach(a),F.forEach(a),Oe=r(e),g(de.$$.fragment,e),Ke=r(e),J=p(e,"DIV",{class:!0});var B=S(J);g(me.$$.fragment,B),_t=r(B),Pe=p(B,"P",{"data-svelte-h":!0}),v(Pe)!=="svelte-1bpanb0"&&(Pe.innerHTML=Xt),bt=r(B),Ce=p(B,"P",{"data-svelte-h":!0}),v(Ce)!=="svelte-hswkmf"&&(Ce.innerHTML=Et),yt=r(B),V=p(B,"DIV",{class:!0});var we=S(V);g(pe.$$.fragment,we),Mt=r(we),g(H.$$.fragment,we),we.forEach(a),B.forEach(a),et=r(e),g(he.$$.fragment,e),tt=r(e),U=p(e,"DIV",{class:!0});var W=S(U);g(ue.$$.fragment,W),vt=r(W),Se=p(W,"P",{"data-svelte-h":!0}),v(Se)!=="svelte-zj90e9"&&(Se.innerHTML=qt),wt=r(W),ke=p(W,"P",{"data-svelte-h":!0}),v(ke)!=="svelte-hswkmf"&&(ke.innerHTML=Qt),jt=r(W),z=p(W,"DIV",{class:!0});var it=S(z);g(ge.$$.fragment,it),$t=r(it),g(Y.$$.fragment,it),it.forEach(a),W.forEach(a),nt=r(e),g(fe.$$.fragment,e),at=r(e),P=p(e,"DIV",{class:!0});var D=S(P);g(Te.$$.fragment,D),Jt=r(D),xe=p(D,"P",{"data-svelte-h":!0}),v(xe)!=="svelte-1y7i5g4"&&(xe.innerHTML=Dt),Ut=r(D),Fe=p(D,"P",{"data-svelte-h":!0}),v(Fe)!=="svelte-hswkmf"&&(Fe.innerHTML=Lt),Pt=r(D),X=p(D,"DIV",{class:!0});var ct=S(X);g(_e.$$.fragment,ct),Ct=r(ct),g(E.$$.fragment,ct),ct.forEach(a),D.forEach(a),st=r(e),g(be.$$.fragment,e),ot=r(e),C=p(e,"DIV",{class:!0});var L=S(C);g(ye.$$.fragment,L),St=r(L),Be=p(L,"P",{"data-svelte-h":!0}),v(Be)!=="svelte-1n2ehbs"&&(Be.innerHTML=At),kt=r(L),We=p(L,"P",{"data-svelte-h":!0}),v(We)!=="svelte-hswkmf"&&(We.innerHTML=Ot),xt=r(L),q=p(L,"DIV",{class:!0});var dt=S(q);g(Me.$$.fragment,dt),Ft=r(dt),g(Q.$$.fragment,dt),dt.forEach(a),L.forEach(a),rt=r(e),Ie=p(e,"P",{}),S(Ie).forEach(a),this.h()},h(){k(s,"name","hf:doc:metadata"),k(s,"content",pn),k(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){c(document.head,s),l(e,M,n),l(e,d,n),l(e,i,n),f(h,e,n),l(e,t,n),f(y,e,n),l(e,Re,n),l(e,A,n),l(e,Ve,n),l(e,O,n),l(e,He,n),l(e,K,n),l(e,ze,n),l(e,ee,n),l(e,Ye,n),l(e,te,n),l(e,Xe,n),l(e,ne,n),l(e,Ee,n),f(ae,e,n),l(e,qe,n),l(e,se,n),l(e,Qe,n),f(oe,e,n),l(e,De,n),l(e,j,n),f(re,j,null),c(j,mt),c(j,je),c(j,pt),c(j,$e),c(j,ht),f(N,j,null),l(e,Le,n),f(le,e,n),l(e,Ae,n),l(e,$,n),f(ie,$,null),c($,ut),c($,Je),c($,gt),c($,Ue),c($,ft),c($,I),f(ce,I,null),c(I,Tt),f(R,I,null),l(e,Oe,n),f(de,e,n),l(e,Ke,n),l(e,J,n),f(me,J,null),c(J,_t),c(J,Pe),c(J,bt),c(J,Ce),c(J,yt),c(J,V),f(pe,V,null),c(V,Mt),f(H,V,null),l(e,et,n),f(he,e,n),l(e,tt,n),l(e,U,n),f(ue,U,null),c(U,vt),c(U,Se),c(U,wt),c(U,ke),c(U,jt),c(U,z),f(ge,z,null),c(z,$t),f(Y,z,null),l(e,nt,n),f(fe,e,n),l(e,at,n),l(e,P,n),f(Te,P,null),c(P,Jt),c(P,xe),c(P,Ut),c(P,Fe),c(P,Pt),c(P,X),f(_e,X,null),c(X,Ct),f(E,X,null),l(e,st,n),f(be,e,n),l(e,ot,n),l(e,C,n),f(ye,C,null),c(C,St),c(C,Be),c(C,kt),c(C,We),c(C,xt),c(C,q),f(Me,q,null),c(q,Ft),f(Q,q,null),l(e,rt,n),l(e,Ie,n),lt=!0},p(e,[n]){const x={};n&2&&(x.$$scope={dirty:n,ctx:e}),N.$set(x);const F={};n&2&&(F.$$scope={dirty:n,ctx:e}),R.$set(F);const ve={};n&2&&(ve.$$scope={dirty:n,ctx:e}),H.$set(ve);const B={};n&2&&(B.$$scope={dirty:n,ctx:e}),Y.$set(B);const we={};n&2&&(we.$$scope={dirty:n,ctx:e}),E.$set(we);const W={};n&2&&(W.$$scope={dirty:n,ctx:e}),Q.$set(W)},i(e){lt||(T(h.$$.fragment,e),T(y.$$.fragment,e),T(ae.$$.fragment,e),T(oe.$$.fragment,e),T(re.$$.fragment,e),T(N.$$.fragment,e),T(le.$$.fragment,e),T(ie.$$.fragment,e),T(ce.$$.fragment,e),T(R.$$.fragment,e),T(de.$$.fragment,e),T(me.$$.fragment,e),T(pe.$$.fragment,e),T(H.$$.fragment,e),T(he.$$.fragment,e),T(ue.$$.fragment,e),T(ge.$$.fragment,e),T(Y.$$.fragment,e),T(fe.$$.fragment,e),T(Te.$$.fragment,e),T(_e.$$.fragment,e),T(E.$$.fragment,e),T(be.$$.fragment,e),T(ye.$$.fragment,e),T(Me.$$.fragment,e),T(Q.$$.fragment,e),lt=!0)},o(e){_(h.$$.fragment,e),_(y.$$.fragment,e),_(ae.$$.fragment,e),_(oe.$$.fragment,e),_(re.$$.fragment,e),_(N.$$.fragment,e),_(le.$$.fragment,e),_(ie.$$.fragment,e),_(ce.$$.fragment,e),_(R.$$.fragment,e),_(de.$$.fragment,e),_(me.$$.fragment,e),_(pe.$$.fragment,e),_(H.$$.fragment,e),_(he.$$.fragment,e),_(ue.$$.fragment,e),_(ge.$$.fragment,e),_(Y.$$.fragment,e),_(fe.$$.fragment,e),_(Te.$$.fragment,e),_(_e.$$.fragment,e),_(E.$$.fragment,e),_(be.$$.fragment,e),_(ye.$$.fragment,e),_(Me.$$.fragment,e),_(Q.$$.fragment,e),lt=!1},d(e){e&&(a(M),a(d),a(i),a(t),a(Re),a(A),a(Ve),a(O),a(He),a(K),a(ze),a(ee),a(Ye),a(te),a(Xe),a(ne),a(Ee),a(qe),a(se),a(Qe),a(De),a(j),a(Le),a(Ae),a($),a(Oe),a(Ke),a(J),a(et),a(tt),a(U),a(nt),a(at),a(P),a(st),a(ot),a(C),a(rt),a(Ie)),a(s),b(h,e),b(y,e),b(ae,e),b(oe,e),b(re),b(N),b(le,e),b(ie),b(ce),b(R),b(de,e),b(me),b(pe),b(H),b(he,e),b(ue),b(ge),b(Y),b(fe,e),b(Te),b(_e),b(E),b(be,e),b(ye),b(Me),b(Q)}}}const pn='{"title":"PatchTST","local":"patchtst","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"PatchTSTConfig","local":"transformers.PatchTSTConfig","sections":[],"depth":2},{"title":"PatchTSTModel","local":"transformers.PatchTSTModel","sections":[],"depth":2},{"title":"PatchTSTForPrediction","local":"transformers.PatchTSTForPrediction","sections":[],"depth":2},{"title":"PatchTSTForClassification","local":"transformers.PatchTSTForClassification","sections":[],"depth":2},{"title":"PatchTSTForPretraining","local":"transformers.PatchTSTForPretraining","sections":[],"depth":2},{"title":"PatchTSTForRegression","local":"transformers.PatchTSTForRegression","sections":[],"depth":2}],"depth":1}';function hn(w){return en(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yn extends tn{constructor(s){super(),nn(this,s,hn,mn,Kt,{})}}export{yn as component};
