import{s as Et,o as Qt,n as Te}from"../chunks/scheduler.182ea377.js";import{S as Nt,i as zt,g as u,s as r,r as h,A as Yt,h as d,f as l,c as m,j as pt,u as w,x as M,k as be,y as x,a as s,v as b,d as J,t as T,w as U}from"../chunks/index.abf12888.js";import{T as dt}from"../chunks/Tip.230e2334.js";import{C as $}from"../chunks/CodeBlock.57fe6e13.js";import{D as Ft}from"../chunks/DocNotebookDropdown.5fa27ace.js";import{H as Je}from"../chunks/Heading.16916d63.js";import{H as Xt,a as rt}from"../chunks/HfOption.fc88c804.js";function St(g){let i,c="By loading a community pipeline from the Hugging Face Hub, you are trusting that the code you are loading is safe. Make sure to inspect the code online before loading and running it automatically!";return{c(){i=u("p"),i.textContent=c},l(a){i=d(a,"P",{"data-svelte-h":!0}),M(i)!=="svelte-1d3q3fm"&&(i.textContent=c)},m(a,p){s(a,i,p)},p:Te,d(a){a&&l(i)}}}function Lt(g){let i,c='To load a Hugging Face Hub community pipeline, pass the repository id of the community pipeline to the <code>custom_pipeline</code> argument and the model repository where you’d like to load the pipeline weights and components from. For example, the example below loads a dummy pipeline from <a href="https://huggingface.co/hf-internal-testing/diffusers-dummy-pipeline/blob/main/pipeline.py" rel="nofollow">hf-internal-testing/diffusers-dummy-pipeline</a> and the pipeline weights and components from <a href="https://huggingface.co/google/ddpm-cifar10-32" rel="nofollow">google/ddpm-cifar10-32</a>:',a,p,o,n,y;return p=new dt({props:{warning:!0,$$slots:{default:[St]},$$scope:{ctx:g}}}),n=new $({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZ29vZ2xlJTJGZGRwbS1jaWZhcjEwLTMyJTIyJTJDJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1kdW1teS1waXBlbGluZSUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, custom_pipeline=<span class="hljs-string">&quot;hf-internal-testing/diffusers-dummy-pipeline&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),{c(){i=u("p"),i.innerHTML=c,a=r(),h(p.$$.fragment),o=r(),h(n.$$.fragment)},l(f){i=d(f,"P",{"data-svelte-h":!0}),M(i)!=="svelte-he2t9o"&&(i.innerHTML=c),a=m(f),w(p.$$.fragment,f),o=m(f),w(n.$$.fragment,f)},m(f,Z){s(f,i,Z),s(f,a,Z),b(p,f,Z),s(f,o,Z),b(n,f,Z),y=!0},p(f,Z){const R={};Z&2&&(R.$$scope={dirty:Z,ctx:f}),p.$set(R)},i(f){y||(J(p.$$.fragment,f),J(n.$$.fragment,f),y=!0)},o(f){T(p.$$.fragment,f),T(n.$$.fragment,f),y=!1},d(f){f&&(l(i),l(a),l(o)),U(p,f),U(n,f)}}}function Dt(g){let i,c='To load a GitHub community pipeline, pass the repository id of the community pipeline to the <code>custom_pipeline</code> argument and the model repository where you you’d like to load the pipeline weights and components from. You can also load model components directly. The example below loads the community <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#clip-guided-stable-diffusion" rel="nofollow">CLIP Guided Stable Diffusion</a> pipeline and the CLIP model components.',a,p,o;return p=new $({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBJbWFnZVByb2Nlc3NvciUyQyUyMENMSVBNb2RlbCUwQSUwQWNsaXBfbW9kZWxfaWQlMjAlM0QlMjAlMjJsYWlvbiUyRkNMSVAtVmlULUItMzItbGFpb24yQi1zMzRCLWI3OUslMjIlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMENMSVBJbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2xpcF9tb2RlbF9pZCklMEFjbGlwX21vZGVsJTIwJTNEJTIwQ0xJUE1vZGVsLmZyb21fcHJldHJhaW5lZChjbGlwX21vZGVsX2lkKSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyY2xpcF9ndWlkZWRfc3RhYmxlX2RpZmZ1c2lvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfbW9kZWwlM0RjbGlwX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZV9leHRyYWN0b3IlM0RmZWF0dXJlX2V4dHJhY3RvciUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPImageProcessor, CLIPModel

clip_model_id = <span class="hljs-string">&quot;laion/CLIP-ViT-B-32-laion2B-s34B-b79K&quot;</span>

feature_extractor = CLIPImageProcessor.from_pretrained(clip_model_id)
clip_model = CLIPModel.from_pretrained(clip_model_id)

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;clip_guided_stable_diffusion&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    use_safetensors=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),{c(){i=u("p"),i.innerHTML=c,a=r(),h(p.$$.fragment)},l(n){i=d(n,"P",{"data-svelte-h":!0}),M(i)!=="svelte-wu4rdv"&&(i.innerHTML=c),a=m(n),w(p.$$.fragment,n)},m(n,y){s(n,i,y),s(n,a,y),b(p,n,y),o=!0},p:Te,i(n){o||(J(p.$$.fragment,n),o=!0)},o(n){T(p.$$.fragment,n),o=!1},d(n){n&&(l(i),l(a)),U(p,n)}}}function qt(g){let i,c,a,p;return i=new rt({props:{id:"community",option:"Hub pipelines",$$slots:{default:[Lt]},$$scope:{ctx:g}}}),a=new rt({props:{id:"community",option:"GitHub pipelines",$$slots:{default:[Dt]},$$scope:{ctx:g}}}),{c(){h(i.$$.fragment),c=r(),h(a.$$.fragment)},l(o){w(i.$$.fragment,o),c=m(o),w(a.$$.fragment,o)},m(o,n){b(i,o,n),s(o,c,n),b(a,o,n),p=!0},p(o,n){const y={};n&2&&(y.$$scope={dirty:n,ctx:o}),i.$set(y);const f={};n&2&&(f.$$scope={dirty:n,ctx:o}),a.$set(f)},i(o){p||(J(i.$$.fragment,o),J(a.$$.fragment,o),p=!0)},o(o){T(i.$$.fragment,o),T(a.$$.fragment,o),p=!1},d(o){o&&l(c),U(i,o),U(a,o)}}}function Pt(g){let i,c="For example, to load from the main branch:",a,p,o;return p=new $({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fcGlwZWxpbmUlM0QlMjJjbGlwX2d1aWRlZF9zdGFibGVfZGlmZnVzaW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3JldmlzaW9uJTNEJTIybWFpbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfbW9kZWwlM0RjbGlwX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZV9leHRyYWN0b3IlM0RmZWF0dXJlX2V4dHJhY3RvciUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEp",highlighted:`pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;clip_guided_stable_diffusion&quot;</span>,
    custom_revision=<span class="hljs-string">&quot;main&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    use_safetensors=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),{c(){i=u("p"),i.textContent=c,a=r(),h(p.$$.fragment)},l(n){i=d(n,"P",{"data-svelte-h":!0}),M(i)!=="svelte-s49pqe"&&(i.textContent=c),a=m(n),w(p.$$.fragment,n)},m(n,y){s(n,i,y),s(n,a,y),b(p,n,y),o=!0},p:Te,i(n){o||(J(p.$$.fragment,n),o=!0)},o(n){T(p.$$.fragment,n),o=!1},d(n){n&&(l(i),l(a)),U(p,n)}}}function At(g){let i,c="For example, to load from a previous version of Diffusers like v0.25.0:",a,p,o;return p=new $({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fcGlwZWxpbmUlM0QlMjJjbGlwX2d1aWRlZF9zdGFibGVfZGlmZnVzaW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3JldmlzaW9uJTNEJTIydjAuMjUuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfbW9kZWwlM0RjbGlwX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZV9leHRyYWN0b3IlM0RmZWF0dXJlX2V4dHJhY3RvciUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEp",highlighted:`pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;clip_guided_stable_diffusion&quot;</span>,
    custom_revision=<span class="hljs-string">&quot;v0.25.0&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    use_safetensors=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),{c(){i=u("p"),i.textContent=c,a=r(),h(p.$$.fragment)},l(n){i=d(n,"P",{"data-svelte-h":!0}),M(i)!=="svelte-1npkm46"&&(i.textContent=c),a=m(n),w(p.$$.fragment,n)},m(n,y){s(n,i,y),s(n,a,y),b(p,n,y),o=!0},p:Te,i(n){o||(J(p.$$.fragment,n),o=!0)},o(n){T(p.$$.fragment,n),o=!1},d(n){n&&(l(i),l(a)),U(p,n)}}}function Kt(g){let i,c,a,p;return i=new rt({props:{id:"version",option:"main",$$slots:{default:[Pt]},$$scope:{ctx:g}}}),a=new rt({props:{id:"version",option:"older version",$$slots:{default:[At]},$$scope:{ctx:g}}}),{c(){h(i.$$.fragment),c=r(),h(a.$$.fragment)},l(o){w(i.$$.fragment,o),c=m(o),w(a.$$.fragment,o)},m(o,n){b(i,o,n),s(o,c,n),b(a,o,n),p=!0},p(o,n){const y={};n&2&&(y.$$scope={dirty:n,ctx:o}),i.$set(y);const f={};n&2&&(f.$$scope={dirty:n,ctx:o}),a.$set(f)},i(o){p||(J(i.$$.fragment,o),J(a.$$.fragment,o),p=!0)},o(o){T(i.$$.fragment,o),T(a.$$.fragment,o),p=!1},d(o){o&&l(c),U(i,o),U(a,o)}}}function Ot(g){let i,c='In steps 4 and 5, the custom <a href="https://github.com/showlab/Show-1/blob/main/showone/models/unet_3d_condition.py" rel="nofollow">UNet</a> and <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">pipeline</a> implementation must match the format shown in their files for this example to work.';return{c(){i=u("p"),i.innerHTML=c},l(a){i=d(a,"P",{"data-svelte-h":!0}),M(i)!=="svelte-ptu9pr"&&(i.innerHTML=c)},m(a,p){s(a,i,p)},p:Te,d(a){a&&l(i)}}}function el(g){let i,c='As an additional precaution with <code>trust_remote_code=True</code>, we strongly encourage you to pass a commit hash to the <code>revision</code> parameter in <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> to make sure the code hasn’t been updated with some malicious new lines of code (unless you fully trust the model owners).';return{c(){i=u("p"),i.innerHTML=c},l(a){i=d(a,"P",{"data-svelte-h":!0}),M(i)!=="svelte-1c30fnc"&&(i.innerHTML=c)},m(a,p){s(a,i,p)},p:Te,d(a){a&&l(i)}}}function tl(g){let i,c,a,p,o,n,y,f,Z,R,H,ft='Community pipelines are any <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class that are different from the original paper implementation (for example, the <a href="/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a> corresponds to the <a href="https://arxiv.org/abs/2302.05543" rel="nofollow">Text-to-Image Generation with ControlNet Conditioning</a> paper). They provide additional functionality or extend the original implementation of a pipeline.',ge,X,yt='There are many cool community pipelines like <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#marigold-depth-estimation" rel="nofollow">Marigold Depth Estimation</a> or <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#instantid-pipeline" rel="nofollow">InstantID</a>, and you can find all the official community pipelines <a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">here</a>.',Ze,E,Mt='There are two types of community pipelines, those stored on the Hugging Face Hub and those stored on Diffusers GitHub repository. Hub pipelines are completely customizable (scheduler, models, pipeline code, etc.) while Diffusers GitHub pipelines are only limited to custom pipeline code. Refer to this <a href="./contribute_pipeline#share-your-pipeline">table</a> for a more detailed comparison of Hub vs GitHub community pipelines.',$e,I,_e,Q,Ge,N,ht="Community pipelines can also be loaded from a local file if you pass a file path instead. The path to the passed directory must contain a pipeline.py file that contains the pipeline class.",je,z,Ie,Y,Ve,F,wt="By default, community pipelines are loaded from the latest stable version of Diffusers. To load a community pipeline from another version, use the <code>custom_revision</code> parameter.",ve,V,We,S,Ce,L,bt='Community pipelines can also be loaded with the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a> method which allows you to load and reuse multiple pipelines without any additional memory overhead (learn more in the <a href="./loading#reuse-a-pipeline">Reuse a pipeline</a> guide). The memory requirement is determined by the largest single pipeline loaded.',Be,D,Jt='For example, let’s load a community pipeline that supports <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#long-prompt-weighting-stable-diffusion" rel="nofollow">long prompts with weighting</a> from a Stable Diffusion pipeline.',ke,q,xe,v,Tt='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/from_pipe_lpw.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">Stable Diffusion with long prompt weighting</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/from_pipe_non_lpw.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">Stable Diffusion</figcaption></div>',Re,P,He,A,Ut="Community components allow users to build pipelines that may have customized components that are not a part of Diffusers. If your pipeline has custom components that Diffusers doesn’t already support, you need to provide their implementations as Python modules. These customized components could be a VAE, UNet, and scheduler. In most cases, the text encoder is imported from the Transformers library. The pipeline code itself can also be customized.",Xe,K,gt="This section shows how users should use community components to build a community pipeline.",Ee,O,Zt='You’ll use the <a href="https://huggingface.co/showlab/show-1-base" rel="nofollow">showlab/show-1-base</a> pipeline checkpoint as an example.',Qe,ee,$t="<li>Import and load the text encoder from Transformers:</li>",Ne,te,ze,W,_t="<li>Load a scheduler:</li>",Ye,le,Fe,C,Gt="<li>Load an image processor:</li>",Se,ie,Le,B,De,_,G,Me,jt='Now you’ll load a <a href="https://github.com/showlab/Show-1/blob/main/showone/models/unet_3d_condition.py" rel="nofollow">custom UNet</a>, which in this example, has already been implemented in <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">showone_unet_3d_condition.py</a> for your convenience. You’ll notice the <a href="/docs/diffusers/main/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a> class name is changed to <code>ShowOneUNet3DConditionModel</code> because <a href="/docs/diffusers/main/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a> already exists in Diffusers. Any components needed for the <code>ShowOneUNet3DConditionModel</code> class should be placed in showone_unet_3d_condition.py.',mt,he,It="Once this is done, you can initialize the UNet:",ct,se,ut,we,Vt='<p>Finally, you’ll load the custom pipeline code. For this example, it has already been created for you in <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/pipeline_t2v_base_pixel.py" rel="nofollow">pipeline_t2v_base_pixel.py</a>. This script contains a custom <code>TextToVideoIFPipeline</code> class for generating videos from text. Just like the custom UNet, any code needed for the custom pipeline to work should go in pipeline_t2v_base_pixel.py.</p>',qe,ne,vt="Once everything is in place, you can initialize the <code>TextToVideoIFPipeline</code> with the <code>ShowOneUNet3DConditionModel</code>:",Pe,oe,Ae,ae,Wt="Push the pipeline to the Hub to share with the community!",Ke,pe,Oe,re,Ct="After the pipeline is successfully pushed, you need to make a few changes:",et,me,Bt='<li>Change the <code>_class_name</code> attribute in <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/model_index.json#L2" rel="nofollow">model_index.json</a> to <code>&quot;pipeline_t2v_base_pixel&quot;</code> and <code>&quot;TextToVideoIFPipeline&quot;</code>.</li> <li>Upload <code>showone_unet_3d_condition.py</code> to the <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">unet</a> subfolder.</li> <li>Upload <code>pipeline_t2v_base_pixel.py</code> to the pipeline <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/tree/main" rel="nofollow">repository</a>.</li>',tt,ce,kt="To run inference, add the <code>trust_remote_code</code> argument while initializing the pipeline to handle all the “magic” behind the scenes.",lt,k,it,ue,st,de,xt='As an additional reference, take a look at the repository structure of <a href="https://huggingface.co/stabilityai/japanese-stable-diffusion-xl/" rel="nofollow">stabilityai/japanese-stable-diffusion-xl</a> which also uses the <code>trust_remote_code</code> feature.',nt,fe,ot,Ue,at;return o=new Je({props:{title:"Load community pipelines and components",local:"load-community-pipelines-and-components",headingTag:"h1"}}),y=new Ft({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/custom_pipeline_overview.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/custom_pipeline_overview.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/custom_pipeline_overview.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/custom_pipeline_overview.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/custom_pipeline_overview.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/custom_pipeline_overview.ipynb"}]}}),Z=new Je({props:{title:"Community pipelines",local:"community-pipelines",headingTag:"h2"}}),I=new Xt({props:{id:"community",options:["Hub pipelines","GitHub pipelines"],$$slots:{default:[qt]},$$scope:{ctx:g}}}),Q=new Je({props:{title:"Load from a local file",local:"load-from-a-local-file",headingTag:"h3"}}),z=new $({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fcGlwZWxpbmUlM0QlMjIuJTJGcGF0aCUyRnRvJTJGcGlwZWxpbmVfZGlyZWN0b3J5JTJGJTIyJTJDJTBBJTIwJTIwJTIwJTIwY2xpcF9tb2RlbCUzRGNsaXBfbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBmZWF0dXJlX2V4dHJhY3RvciUzRGZlYXR1cmVfZXh0cmFjdG9yJTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSk=",highlighted:`pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;./path/to/pipeline_directory/&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    use_safetensors=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),Y=new Je({props:{title:"Load from a specific version",local:"load-from-a-specific-version",headingTag:"h3"}}),V=new Xt({props:{id:"version",options:["main","older version"],$$slots:{default:[Kt]},$$scope:{ctx:g}}}),S=new Je({props:{title:"Load with from_pipe",local:"load-with-frompipe",headingTag:"h3"}}),q=new $({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlX3NkJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmVtaWxpYW5KUiUyRkN5YmVyUmVhbGlzdGljX1YzJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGVfc2QudG8oJTIyY3VkYSUyMiklMEElMjMlMjBsb2FkJTIwbG9uZyUyMHByb21wdCUyMHdlaWdodGluZyUyMHBpcGVsaW5lJTBBcGlwZV9scHclMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3BpcGUoJTBBJTIwJTIwJTIwJTIwcGlwZV9zZCUyQyUwQSUyMCUyMCUyMCUyMGN1c3RvbV9waXBlbGluZSUzRCUyMmxwd19zdGFibGVfZGlmZnVzaW9uJTIyJTJDJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNhdCUyQyUyMGhpZGluZyUyMGluJTIwdGhlJTIwbGVhdmVzJTJDJTIwKChyYWluKSklMkMlMjB6YXppZSUyMHJhaW55ZGF5JTJDJTIwYmVhdXRpZnVsJTIwZXllcyUyQyUyMG1hY3JvJTIwc2hvdCUyQyUyMGNvbG9yZnVsJTIwZGV0YWlscyUyQyUyMG5hdHVyYWwlMjBsaWdodGluZyUyQyUyMGFtYXppbmclMjBjb21wb3NpdGlvbiUyQyUyMHN1YnN1cmZhY2UlMjBzY2F0dGVyaW5nJTJDJTIwYW1hemluZyUyMHRleHR1cmVzJTJDJTIwZmlsbWljJTJDJTIwc29mdCUyMGxpZ2h0JTJDJTIwdWx0cmEtZGV0YWlsZWQlMjBleWVzJTJDJTIwaW50cmljYXRlJTIwZGV0YWlscyUyQyUyMGRldGFpbGVkJTIwdGV4dHVyZSUyQyUyMGxpZ2h0JTIwc291cmNlJTIwY29udHJhc3QlMkMlMjBkcmFtYXRpYyUyMHNoYWRvd3MlMkMlMjBjaW5lbWF0aWMlMjBsaWdodCUyQyUyMGRlcHRoJTIwb2YlMjBmaWVsZCUyQyUyMGZpbG0lMjBncmFpbiUyQyUyMG5vaXNlJTJDJTIwZGFyayUyMGJhY2tncm91bmQlMkMlMjBoeXBlcnJlYWxpc3RpYyUyMGRzbHIlMjBmaWxtJTIwc3RpbGwlMkMlMjBkaW0lMjB2b2x1bWV0cmljJTIwY2luZW1hdGljJTIwbGlnaHRpbmclMjIlMEFuZWdfcHJvbXB0JTIwJTNEJTIwJTIyKGRlZm9ybWVkJTIwaXJpcyUyQyUyMGRlZm9ybWVkJTIwcHVwaWxzJTJDJTIwc2VtaS1yZWFsaXN0aWMlMkMlMjBjZ2klMkMlMjAzZCUyQyUyMHJlbmRlciUyQyUyMHNrZXRjaCUyQyUyMGNhcnRvb24lMkMlMjBkcmF3aW5nJTJDJTIwYW5pbWUlMkMlMjBtdXRhdGVkJTIwaGFuZHMlMjBhbmQlMjBmaW5nZXJzJTNBMS40KSUyQyUyMChkZWZvcm1lZCUyQyUyMGRpc3RvcnRlZCUyQyUyMGRpc2ZpZ3VyZWQlM0ExLjMpJTJDJTIwcG9vcmx5JTIwZHJhd24lMkMlMjBiYWQlMjBhbmF0b215JTJDJTIwd3JvbmclMjBhbmF0b215JTJDJTIwZXh0cmElMjBsaW1iJTJDJTIwbWlzc2luZyUyMGxpbWIlMkMlMjBmbG9hdGluZyUyMGxpbWJzJTJDJTIwZGlzY29ubmVjdGVkJTIwbGltYnMlMkMlMjBtdXRhdGlvbiUyQyUyMG11dGF0ZWQlMkMlMjB1Z2x5JTJDJTIwZGlzZ3VzdGluZyUyQyUyMGFtcHV0YXRpb24lMjIlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgyMCklMEFvdXRfbHB3JTIwJTNEJTIwcGlwZV9scHcoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTIwJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnX3Byb21wdCUyQyUyMCUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENTEyJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENTEyJTJDJTBBJTIwJTIwJTIwJTIwbWF4X2VtYmVkZGluZ3NfbXVsdGlwbGVzJTNEMyUyQyUyMCUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMCkuaW1hZ2VzJTVCMCU1RCUwQW91dF9scHc=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipe_sd = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;emilianJR/CyberRealistic_V3&quot;</span>, torch_dtype=torch.float16)
pipe_sd.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-comment"># load long prompt weighting pipeline</span>
pipe_lpw = DiffusionPipeline.from_pipe(
    pipe_sd,
    custom_pipeline=<span class="hljs-string">&quot;lpw_stable_diffusion&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;cat, hiding in the leaves, ((rain)), zazie rainyday, beautiful eyes, macro shot, colorful details, natural lighting, amazing composition, subsurface scattering, amazing textures, filmic, soft light, ultra-detailed eyes, intricate details, detailed texture, light source contrast, dramatic shadows, cinematic light, depth of field, film grain, noise, dark background, hyperrealistic dslr film still, dim volumetric cinematic lighting&quot;</span>
neg_prompt = <span class="hljs-string">&quot;(deformed iris, deformed pupils, semi-realistic, cgi, 3d, render, sketch, cartoon, drawing, anime, mutated hands and fingers:1.4), (deformed, distorted, disfigured:1.3), poorly drawn, bad anatomy, wrong anatomy, extra limb, missing limb, floating limbs, disconnected limbs, mutation, mutated, ugly, disgusting, amputation&quot;</span>
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">20</span>)
out_lpw = pipe_lpw(
    prompt, 
    negative_prompt=neg_prompt, 
    width=<span class="hljs-number">512</span>,
    height=<span class="hljs-number">512</span>,
    max_embeddings_multiples=<span class="hljs-number">3</span>, 
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=generator,
    ).images[<span class="hljs-number">0</span>]
out_lpw`,wrap:!1}}),P=new Je({props:{title:"Community components",local:"community-components",headingTag:"h2"}}),te=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1VG9rZW5pemVyJTJDJTIwVDVFbmNvZGVyTW9kZWwlMEElMEFwaXBlX2lkJTIwJTNEJTIwJTIyc2hvd2xhYiUyRnNob3ctMS1iYXNlJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwVDVUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKHBpcGVfaWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0b2tlbml6ZXIlMjIpJTBBdGV4dF9lbmNvZGVyJTIwJTNEJTIwVDVFbmNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKHBpcGVfaWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXIlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5Tokenizer, T5EncoderModel

pipe_id = <span class="hljs-string">&quot;showlab/show-1-base&quot;</span>
tokenizer = T5Tokenizer.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;tokenizer&quot;</span>)
text_encoder = T5EncoderModel.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>)`,wrap:!1}}),le=new $({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQocGlwZV9pZCUyQyUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DPMSolverMultistepScheduler

scheduler = DPMSolverMultistepScheduler.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)`,wrap:!1}}),ie=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBGZWF0dXJlRXh0cmFjdG9yJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBDTElQRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQocGlwZV9pZCUyQyUyMHN1YmZvbGRlciUzRCUyMmZlYXR1cmVfZXh0cmFjdG9yJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPFeatureExtractor

feature_extractor = CLIPFeatureExtractor.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;feature_extractor&quot;</span>)`,wrap:!1}}),B=new dt({props:{warning:!0,$$slots:{default:[Ot]},$$scope:{ctx:g}}}),se=new $({props:{code:"ZnJvbSUyMHNob3dvbmVfdW5ldF8zZF9jb25kaXRpb24lMjBpbXBvcnQlMjBTaG93T25lVU5ldDNEQ29uZGl0aW9uTW9kZWwlMEElMEF1bmV0JTIwJTNEJTIwU2hvd09uZVVOZXQzRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZChwaXBlX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIydW5ldCUyMik=",highlighted:`<span class="hljs-keyword">from</span> showone_unet_3d_condition <span class="hljs-keyword">import</span> ShowOneUNet3DConditionModel

unet = ShowOneUNet3DConditionModel.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)`,wrap:!1}}),oe=new $({props:{code:"ZnJvbSUyMHBpcGVsaW5lX3Qydl9iYXNlX3BpeGVsJTIwaW1wb3J0JTIwVGV4dFRvVmlkZW9JRlBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMFRleHRUb1ZpZGVvSUZQaXBlbGluZSglMEElMjAlMjAlMjAlMjB1bmV0JTNEdW5ldCUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2RlciUzRHRleHRfZW5jb2RlciUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlciUzRHNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEZmVhdHVyZV9leHRyYWN0b3IlMEEpJTBBcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byhkZXZpY2UlM0QlMjJjdWRhJTIyKSUwQXBpcGVsaW5lLnRvcmNoX2R0eXBlJTIwJTNEJTIwdG9yY2guZmxvYXQxNg==",highlighted:`<span class="hljs-keyword">from</span> pipeline_t2v_base_pixel <span class="hljs-keyword">import</span> TextToVideoIFPipeline
<span class="hljs-keyword">import</span> torch

pipeline = TextToVideoIFPipeline(
    unet=unet,
    text_encoder=text_encoder,
    tokenizer=tokenizer,
    scheduler=scheduler,
    feature_extractor=feature_extractor
)
pipeline = pipeline.to(device=<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.torch_dtype = torch.float16`,wrap:!1}}),pe=new $({props:{code:"cGlwZWxpbmUucHVzaF90b19odWIoJTIyY3VzdG9tLXQydi1waXBlbGluZSUyMik=",highlighted:'pipeline.push_to_hub(<span class="hljs-string">&quot;custom-t2v-pipeline&quot;</span>)',wrap:!1}}),k=new dt({props:{warning:!0,$$slots:{default:[el]},$$scope:{ctx:g}}}),ue=new $({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIlM0NjaGFuZ2UtdXNlcm5hbWUlM0UlMkYlM0NjaGFuZ2UtaWQlM0UlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyaGVsbG8lMjIlMEElMEElMjMlMjBUZXh0JTIwZW1iZWRzJTBBcHJvbXB0X2VtYmVkcyUyQyUyMG5lZ2F0aXZlX2VtYmVkcyUyMCUzRCUyMHBpcGVsaW5lLmVuY29kZV9wcm9tcHQocHJvbXB0KSUwQSUwQSUyMyUyMEtleWZyYW1lcyUyMGdlbmVyYXRpb24lMjAoOHg2NHg0MCUyQyUyMDJmcHMpJTBBdmlkZW9fZnJhbWVzJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0X2VtYmVkcyUzRHByb21wdF9lbWJlZHMlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHRfZW1iZWRzJTNEbmVnYXRpdmVfZW1iZWRzJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2ZyYW1lcyUzRDglMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q0MCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENjQlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMiUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEOS4wJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0X3R5cGUlM0QlMjJwdCUyMiUwQSkuZnJhbWVz",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;&lt;change-username&gt;/&lt;change-id&gt;&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;hello&quot;</span>

<span class="hljs-comment"># Text embeds</span>
prompt_embeds, negative_embeds = pipeline.encode_prompt(prompt)

<span class="hljs-comment"># Keyframes generation (8x64x40, 2fps)</span>
video_frames = pipeline(
    prompt_embeds=prompt_embeds,
    negative_prompt_embeds=negative_embeds,
    num_frames=<span class="hljs-number">8</span>,
    height=<span class="hljs-number">40</span>,
    width=<span class="hljs-number">64</span>,
    num_inference_steps=<span class="hljs-number">2</span>,
    guidance_scale=<span class="hljs-number">9.0</span>,
    output_type=<span class="hljs-string">&quot;pt&quot;</span>
).frames`,wrap:!1}}),fe=new $({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRmphcGFuZXNlLXN0YWJsZS1kaWZmdXNpb24teGwlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEpJTBBcGlwZWxpbmUudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/japanese-stable-diffusion-xl&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>
)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),{c(){i=u("meta"),c=r(),a=u("p"),p=r(),h(o.$$.fragment),n=r(),h(y.$$.fragment),f=r(),h(Z.$$.fragment),R=r(),H=u("p"),H.innerHTML=ft,ge=r(),X=u("p"),X.innerHTML=yt,Ze=r(),E=u("p"),E.innerHTML=Mt,$e=r(),h(I.$$.fragment),_e=r(),h(Q.$$.fragment),Ge=r(),N=u("p"),N.textContent=ht,je=r(),h(z.$$.fragment),Ie=r(),h(Y.$$.fragment),Ve=r(),F=u("p"),F.innerHTML=wt,ve=r(),h(V.$$.fragment),We=r(),h(S.$$.fragment),Ce=r(),L=u("p"),L.innerHTML=bt,Be=r(),D=u("p"),D.innerHTML=Jt,ke=r(),h(q.$$.fragment),xe=r(),v=u("div"),v.innerHTML=Tt,Re=r(),h(P.$$.fragment),He=r(),A=u("p"),A.textContent=Ut,Xe=r(),K=u("p"),K.textContent=gt,Ee=r(),O=u("p"),O.innerHTML=Zt,Qe=r(),ee=u("ol"),ee.innerHTML=$t,Ne=r(),h(te.$$.fragment),ze=r(),W=u("ol"),W.innerHTML=_t,Ye=r(),h(le.$$.fragment),Fe=r(),C=u("ol"),C.innerHTML=Gt,Se=r(),h(ie.$$.fragment),Le=r(),h(B.$$.fragment),De=r(),_=u("ol"),G=u("li"),Me=u("p"),Me.innerHTML=jt,mt=r(),he=u("p"),he.textContent=It,ct=r(),h(se.$$.fragment),ut=r(),we=u("li"),we.innerHTML=Vt,qe=r(),ne=u("p"),ne.innerHTML=vt,Pe=r(),h(oe.$$.fragment),Ae=r(),ae=u("p"),ae.textContent=Wt,Ke=r(),h(pe.$$.fragment),Oe=r(),re=u("p"),re.textContent=Ct,et=r(),me=u("ol"),me.innerHTML=Bt,tt=r(),ce=u("p"),ce.innerHTML=kt,lt=r(),h(k.$$.fragment),it=r(),h(ue.$$.fragment),st=r(),de=u("p"),de.innerHTML=xt,nt=r(),h(fe.$$.fragment),ot=r(),Ue=u("p"),this.h()},l(e){const t=Yt("svelte-u9bgzb",document.head);i=d(t,"META",{name:!0,content:!0}),t.forEach(l),c=m(e),a=d(e,"P",{}),pt(a).forEach(l),p=m(e),w(o.$$.fragment,e),n=m(e),w(y.$$.fragment,e),f=m(e),w(Z.$$.fragment,e),R=m(e),H=d(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-rtgoii"&&(H.innerHTML=ft),ge=m(e),X=d(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-1um0op1"&&(X.innerHTML=yt),Ze=m(e),E=d(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1bcjewd"&&(E.innerHTML=Mt),$e=m(e),w(I.$$.fragment,e),_e=m(e),w(Q.$$.fragment,e),Ge=m(e),N=d(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-1ydiyl5"&&(N.textContent=ht),je=m(e),w(z.$$.fragment,e),Ie=m(e),w(Y.$$.fragment,e),Ve=m(e),F=d(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-17rlizh"&&(F.innerHTML=wt),ve=m(e),w(V.$$.fragment,e),We=m(e),w(S.$$.fragment,e),Ce=m(e),L=d(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-19exod8"&&(L.innerHTML=bt),Be=m(e),D=d(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-p2flxu"&&(D.innerHTML=Jt),ke=m(e),w(q.$$.fragment,e),xe=m(e),v=d(e,"DIV",{class:!0,"data-svelte-h":!0}),M(v)!=="svelte-108dts5"&&(v.innerHTML=Tt),Re=m(e),w(P.$$.fragment,e),He=m(e),A=d(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-1vh7uou"&&(A.textContent=Ut),Xe=m(e),K=d(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-phpvnj"&&(K.textContent=gt),Ee=m(e),O=d(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-10zn7oi"&&(O.innerHTML=Zt),Qe=m(e),ee=d(e,"OL",{"data-svelte-h":!0}),M(ee)!=="svelte-8ccbl9"&&(ee.innerHTML=$t),Ne=m(e),w(te.$$.fragment,e),ze=m(e),W=d(e,"OL",{start:!0,"data-svelte-h":!0}),M(W)!=="svelte-1rtkhjg"&&(W.innerHTML=_t),Ye=m(e),w(le.$$.fragment,e),Fe=m(e),C=d(e,"OL",{start:!0,"data-svelte-h":!0}),M(C)!=="svelte-o9t4x9"&&(C.innerHTML=Gt),Se=m(e),w(ie.$$.fragment,e),Le=m(e),w(B.$$.fragment,e),De=m(e),_=d(e,"OL",{start:!0});var ye=pt(_);G=d(ye,"LI",{});var j=pt(G);Me=d(j,"P",{"data-svelte-h":!0}),M(Me)!=="svelte-d8m38a"&&(Me.innerHTML=jt),mt=m(j),he=d(j,"P",{"data-svelte-h":!0}),M(he)!=="svelte-4yol19"&&(he.textContent=It),ct=m(j),w(se.$$.fragment,j),j.forEach(l),ut=m(ye),we=d(ye,"LI",{"data-svelte-h":!0}),M(we)!=="svelte-u0mc44"&&(we.innerHTML=Vt),ye.forEach(l),qe=m(e),ne=d(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-1jpprmd"&&(ne.innerHTML=vt),Pe=m(e),w(oe.$$.fragment,e),Ae=m(e),ae=d(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-14lz5yb"&&(ae.textContent=Wt),Ke=m(e),w(pe.$$.fragment,e),Oe=m(e),re=d(e,"P",{"data-svelte-h":!0}),M(re)!=="svelte-1gts2xf"&&(re.textContent=Ct),et=m(e),me=d(e,"OL",{"data-svelte-h":!0}),M(me)!=="svelte-1ymo6a8"&&(me.innerHTML=Bt),tt=m(e),ce=d(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-3cd5s4"&&(ce.innerHTML=kt),lt=m(e),w(k.$$.fragment,e),it=m(e),w(ue.$$.fragment,e),st=m(e),de=d(e,"P",{"data-svelte-h":!0}),M(de)!=="svelte-78djp3"&&(de.innerHTML=xt),nt=m(e),w(fe.$$.fragment,e),ot=m(e),Ue=d(e,"P",{}),pt(Ue).forEach(l),this.h()},h(){be(i,"name","hf:doc:metadata"),be(i,"content",ll),be(v,"class","flex gap-4"),be(W,"start","2"),be(C,"start","3"),be(_,"start","4")},m(e,t){x(document.head,i),s(e,c,t),s(e,a,t),s(e,p,t),b(o,e,t),s(e,n,t),b(y,e,t),s(e,f,t),b(Z,e,t),s(e,R,t),s(e,H,t),s(e,ge,t),s(e,X,t),s(e,Ze,t),s(e,E,t),s(e,$e,t),b(I,e,t),s(e,_e,t),b(Q,e,t),s(e,Ge,t),s(e,N,t),s(e,je,t),b(z,e,t),s(e,Ie,t),b(Y,e,t),s(e,Ve,t),s(e,F,t),s(e,ve,t),b(V,e,t),s(e,We,t),b(S,e,t),s(e,Ce,t),s(e,L,t),s(e,Be,t),s(e,D,t),s(e,ke,t),b(q,e,t),s(e,xe,t),s(e,v,t),s(e,Re,t),b(P,e,t),s(e,He,t),s(e,A,t),s(e,Xe,t),s(e,K,t),s(e,Ee,t),s(e,O,t),s(e,Qe,t),s(e,ee,t),s(e,Ne,t),b(te,e,t),s(e,ze,t),s(e,W,t),s(e,Ye,t),b(le,e,t),s(e,Fe,t),s(e,C,t),s(e,Se,t),b(ie,e,t),s(e,Le,t),b(B,e,t),s(e,De,t),s(e,_,t),x(_,G),x(G,Me),x(G,mt),x(G,he),x(G,ct),b(se,G,null),x(_,ut),x(_,we),s(e,qe,t),s(e,ne,t),s(e,Pe,t),b(oe,e,t),s(e,Ae,t),s(e,ae,t),s(e,Ke,t),b(pe,e,t),s(e,Oe,t),s(e,re,t),s(e,et,t),s(e,me,t),s(e,tt,t),s(e,ce,t),s(e,lt,t),b(k,e,t),s(e,it,t),b(ue,e,t),s(e,st,t),s(e,de,t),s(e,nt,t),b(fe,e,t),s(e,ot,t),s(e,Ue,t),at=!0},p(e,[t]){const ye={};t&2&&(ye.$$scope={dirty:t,ctx:e}),I.$set(ye);const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),V.$set(j);const Rt={};t&2&&(Rt.$$scope={dirty:t,ctx:e}),B.$set(Rt);const Ht={};t&2&&(Ht.$$scope={dirty:t,ctx:e}),k.$set(Ht)},i(e){at||(J(o.$$.fragment,e),J(y.$$.fragment,e),J(Z.$$.fragment,e),J(I.$$.fragment,e),J(Q.$$.fragment,e),J(z.$$.fragment,e),J(Y.$$.fragment,e),J(V.$$.fragment,e),J(S.$$.fragment,e),J(q.$$.fragment,e),J(P.$$.fragment,e),J(te.$$.fragment,e),J(le.$$.fragment,e),J(ie.$$.fragment,e),J(B.$$.fragment,e),J(se.$$.fragment,e),J(oe.$$.fragment,e),J(pe.$$.fragment,e),J(k.$$.fragment,e),J(ue.$$.fragment,e),J(fe.$$.fragment,e),at=!0)},o(e){T(o.$$.fragment,e),T(y.$$.fragment,e),T(Z.$$.fragment,e),T(I.$$.fragment,e),T(Q.$$.fragment,e),T(z.$$.fragment,e),T(Y.$$.fragment,e),T(V.$$.fragment,e),T(S.$$.fragment,e),T(q.$$.fragment,e),T(P.$$.fragment,e),T(te.$$.fragment,e),T(le.$$.fragment,e),T(ie.$$.fragment,e),T(B.$$.fragment,e),T(se.$$.fragment,e),T(oe.$$.fragment,e),T(pe.$$.fragment,e),T(k.$$.fragment,e),T(ue.$$.fragment,e),T(fe.$$.fragment,e),at=!1},d(e){e&&(l(c),l(a),l(p),l(n),l(f),l(R),l(H),l(ge),l(X),l(Ze),l(E),l($e),l(_e),l(Ge),l(N),l(je),l(Ie),l(Ve),l(F),l(ve),l(We),l(Ce),l(L),l(Be),l(D),l(ke),l(xe),l(v),l(Re),l(He),l(A),l(Xe),l(K),l(Ee),l(O),l(Qe),l(ee),l(Ne),l(ze),l(W),l(Ye),l(Fe),l(C),l(Se),l(Le),l(De),l(_),l(qe),l(ne),l(Pe),l(Ae),l(ae),l(Ke),l(Oe),l(re),l(et),l(me),l(tt),l(ce),l(lt),l(it),l(st),l(de),l(nt),l(ot),l(Ue)),l(i),U(o,e),U(y,e),U(Z,e),U(I,e),U(Q,e),U(z,e),U(Y,e),U(V,e),U(S,e),U(q,e),U(P,e),U(te,e),U(le,e),U(ie,e),U(B,e),U(se),U(oe,e),U(pe,e),U(k,e),U(ue,e),U(fe,e)}}}const ll='{"title":"Load community pipelines and components","local":"load-community-pipelines-and-components","sections":[{"title":"Community pipelines","local":"community-pipelines","sections":[{"title":"Load from a local file","local":"load-from-a-local-file","sections":[],"depth":3},{"title":"Load from a specific version","local":"load-from-a-specific-version","sections":[],"depth":3},{"title":"Load with from_pipe","local":"load-with-frompipe","sections":[],"depth":3}],"depth":2},{"title":"Community components","local":"community-components","sections":[],"depth":2}],"depth":1}';function il(g){return Qt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cl extends Nt{constructor(i){super(),zt(this,i,il,tl,Et,{})}}export{cl as component};
