import{s as ol,o as rl,n as x}from"../chunks/scheduler.182ea377.js";import{S as ml,i as dl,g as m,s as n,r as y,A as cl,h as d,f as a,c as i,j as pl,u as f,x as c,k as V,y as ul,a as l,v as g,d as h,t as Z,w as U}from"../chunks/index.abf12888.js";import{T as Ke}from"../chunks/Tip.230e2334.js";import{C as v}from"../chunks/CodeBlock.57fe6e13.js";import{H as $}from"../chunks/Heading.16916d63.js";import{H as Ml,a as fa}from"../chunks/HfOption.fc88c804.js";function yl(R){let p,w='Learn how to load an IP-Adapter in the <a href="../using-diffusers/loading_adapters#ip-adapter">Load adapters</a> guide, and make sure you check out the <a href="../using-diffusers/loading_adapters#ip-adapter-plus">IP-Adapter Plus</a> section which requires manually loading the image encoder.';return{c(){p=m("p"),p.innerHTML=w},l(o){p=d(o,"P",{"data-svelte-h":!0}),c(p)!=="svelte-1lc7m22"&&(p.innerHTML=w)},m(o,M){l(o,p,M)},p:x,d(o){o&&a(p)}}}function fl(R){let p,w='In the examples below, try adding <code>low_cpu_mem_usage=True</code> to the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method to speed up the loading time.';return{c(){p=m("p"),p.innerHTML=w},l(o){p=d(o,"P",{"data-svelte-h":!0}),c(p)!=="svelte-19gi0uq"&&(p.innerHTML=w)},m(o,M){l(o,p,M)},p:x,d(o){o&&a(p)}}}function gl(R){let p,w="Crafting the precise text prompt to generate the image you want can be difficult because it may not always capture what you’d like to express. Adding an image alongside the text prompt helps the model better understand what it should generate and can lead to more accurate results.",o,M,G='Load a Stable Diffusion XL (SDXL) model and insert an IP-Adapter into the model with the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method. Use the <code>subfolder</code> parameter to load the SDXL model weights.',_,J,I,r,T="Create a text prompt and load an image prompt before passing them to the pipeline to generate an image.",X,j,k,W,C='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_diner.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_diner_2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',u;return J=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJzZHhsX21vZGVscyUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTIyaXAtYWRhcHRlcl9zZHhsLmJpbiUyMiklMEFwaXBlbGluZS5zZXRfaXBfYWRhcHRlcl9zY2FsZSgwLjYp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)`,wrap:!1}}),j=new v({props:{code:"aW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlwX2FkYXB0ZXJfZGluZXIucG5nJTIyKSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYSUyMHBvbGFyJTIwYmVhciUyMHNpdHRpbmclMjBpbiUyMGElMjBjaGFpciUyMGRyaW5raW5nJTIwYSUyMG1pbGtzaGFrZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMmRlZm9ybWVkJTJDJTIwdWdseSUyQyUyMHdyb25nJTIwcHJvcG9ydGlvbiUyQyUyMGxvdyUyMHJlcyUyQyUyMGJhZCUyMGFuYXRvbXklMkMlMjB3b3JzdCUyMHF1YWxpdHklMkMlMjBsb3clMjBxdWFsaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RA==",highlighted:`image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_diner.png&quot;</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
images = pipeline(
    prompt=<span class="hljs-string">&quot;a polar bear sitting in a chair drinking a milkshake&quot;</span>,
    ip_adapter_image=image,
    negative_prompt=<span class="hljs-string">&quot;deformed, ugly, wrong proportion, low res, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">100</span>,
    generator=generator,
).images
images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){p=m("p"),p.textContent=w,o=n(),M=m("p"),M.innerHTML=G,_=n(),y(J.$$.fragment),I=n(),r=m("p"),r.textContent=T,X=n(),y(j.$$.fragment),k=n(),W=m("div"),W.innerHTML=C,this.h()},l(s){p=d(s,"P",{"data-svelte-h":!0}),c(p)!=="svelte-1kuilfu"&&(p.textContent=w),o=i(s),M=d(s,"P",{"data-svelte-h":!0}),c(M)!=="svelte-10sdaqe"&&(M.innerHTML=G),_=i(s),f(J.$$.fragment,s),I=i(s),r=d(s,"P",{"data-svelte-h":!0}),c(r)!=="svelte-yvbljp"&&(r.textContent=T),X=i(s),f(j.$$.fragment,s),k=i(s),W=d(s,"DIV",{class:!0,"data-svelte-h":!0}),c(W)!=="svelte-4jgjc0"&&(W.innerHTML=C),this.h()},h(){V(W,"class","flex flex-row gap-4")},m(s,b){l(s,p,b),l(s,o,b),l(s,M,b),l(s,_,b),g(J,s,b),l(s,I,b),l(s,r,b),l(s,X,b),g(j,s,b),l(s,k,b),l(s,W,b),u=!0},p:x,i(s){u||(h(J.$$.fragment,s),h(j.$$.fragment,s),u=!0)},o(s){Z(J.$$.fragment,s),Z(j.$$.fragment,s),u=!1},d(s){s&&(a(p),a(o),a(M),a(_),a(I),a(r),a(X),a(k),a(W)),U(J,s),U(j,s)}}}function hl(R){let p,w="IP-Adapter can also help with image-to-image by guiding the model to generate an image that resembles the original image and the image prompt.",o,M,G='Load a Stable Diffusion XL (SDXL) model and insert an IP-Adapter into the model with the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method. Use the <code>subfolder</code> parameter to load the SDXL model weights.',_,J,I,r,T="Pass the original image and the IP-Adapter image prompt to the pipeline to generate an image. Providing a text prompt to the pipeline is optional, but in this example, a text prompt is used to increase image quality.",X,j,k,W,C='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_3.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',u;return J=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5sb2FkX2lwX2FkYXB0ZXIoJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnNkeGxfbW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkeGwuYmluJTIyKSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKDAuNik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForImage2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)`,wrap:!1}}),j=new v({props:{code:"aW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlwX2FkYXB0ZXJfYmVhcl8xLnBuZyUyMiklMEFpcF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9iZWFyXzIucG5nJTIyKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDQpJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYmVzdCUyMHF1YWxpdHklMkMlMjBoaWdoJTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlJTNEaXBfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMEElMjAlMjAlMjAlMjBzdHJlbmd0aCUzRDAuNiUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RA==",highlighted:`image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png&quot;</span>)
ip_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_2.png&quot;</span>)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">4</span>)
images = pipeline(
    prompt=<span class="hljs-string">&quot;best quality, high quality&quot;</span>,
    image=image,
    ip_adapter_image=ip_image,
    generator=generator,
    strength=<span class="hljs-number">0.6</span>,
).images
images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){p=m("p"),p.textContent=w,o=n(),M=m("p"),M.innerHTML=G,_=n(),y(J.$$.fragment),I=n(),r=m("p"),r.textContent=T,X=n(),y(j.$$.fragment),k=n(),W=m("div"),W.innerHTML=C,this.h()},l(s){p=d(s,"P",{"data-svelte-h":!0}),c(p)!=="svelte-avn1rr"&&(p.textContent=w),o=i(s),M=d(s,"P",{"data-svelte-h":!0}),c(M)!=="svelte-10sdaqe"&&(M.innerHTML=G),_=i(s),f(J.$$.fragment,s),I=i(s),r=d(s,"P",{"data-svelte-h":!0}),c(r)!=="svelte-10sbd9g"&&(r.textContent=T),X=i(s),f(j.$$.fragment,s),k=i(s),W=d(s,"DIV",{class:!0,"data-svelte-h":!0}),c(W)!=="svelte-8bse9r"&&(W.innerHTML=C),this.h()},h(){V(W,"class","flex gap-4")},m(s,b){l(s,p,b),l(s,o,b),l(s,M,b),l(s,_,b),g(J,s,b),l(s,I,b),l(s,r,b),l(s,X,b),g(j,s,b),l(s,k,b),l(s,W,b),u=!0},p:x,i(s){u||(h(J.$$.fragment,s),h(j.$$.fragment,s),u=!0)},o(s){Z(J.$$.fragment,s),Z(j.$$.fragment,s),u=!1},d(s){s&&(a(p),a(o),a(M),a(_),a(I),a(r),a(X),a(k),a(W)),U(J,s),U(j,s)}}}function Zl(R){let p,w="IP-Adapter is also useful for inpainting because the image prompt allows you to be much more specific about what you’d like to generate.",o,M,G='Load a Stable Diffusion XL (SDXL) model and insert an IP-Adapter into the model with the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method. Use the <code>subfolder</code> parameter to load the SDXL model weights.',_,J,I,r,T="Pass a prompt, the original image, mask image, and the IP-Adapter image prompt to the pipeline to generate an image.",X,j,k,W,C='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_gummy.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_inpaint.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',u;return J=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmclMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMjJkaWZmdXNlcnMlMkZzdGFibGUtZGlmZnVzaW9uLXhsLTEuMC1pbnBhaW50aW5nLTAuMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5sb2FkX2lwX2FkYXB0ZXIoJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnNkeGxfbW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkeGwuYmluJTIyKSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKDAuNik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForInpainting.from_pretrained(<span class="hljs-string">&quot;diffusers/stable-diffusion-xl-1.0-inpainting-0.1&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)`,wrap:!1}}),j=new v({props:{code:"bWFza19pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9tYXNrLnBuZyUyMiklMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9iZWFyXzEucG5nJTIyKSUwQWlwX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpcF9hZGFwdGVyX2d1bW15LnBuZyUyMiklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCg0KSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBjdXRlJTIwZ3VtbXklMjBiZWFyJTIwd2F2aW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGlwX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwMCUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RA==",highlighted:`mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_mask.png&quot;</span>)
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png&quot;</span>)
ip_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_gummy.png&quot;</span>)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">4</span>)
images = pipeline(
    prompt=<span class="hljs-string">&quot;a cute gummy bear waving&quot;</span>,
    image=image,
    mask_image=mask_image,
    ip_adapter_image=ip_image,
    generator=generator,
    num_inference_steps=<span class="hljs-number">100</span>,
).images
images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){p=m("p"),p.textContent=w,o=n(),M=m("p"),M.innerHTML=G,_=n(),y(J.$$.fragment),I=n(),r=m("p"),r.textContent=T,X=n(),y(j.$$.fragment),k=n(),W=m("div"),W.innerHTML=C,this.h()},l(s){p=d(s,"P",{"data-svelte-h":!0}),c(p)!=="svelte-11wjoqr"&&(p.textContent=w),o=i(s),M=d(s,"P",{"data-svelte-h":!0}),c(M)!=="svelte-10sdaqe"&&(M.innerHTML=G),_=i(s),f(J.$$.fragment,s),I=i(s),r=d(s,"P",{"data-svelte-h":!0}),c(r)!=="svelte-1wfeic0"&&(r.textContent=T),X=i(s),f(j.$$.fragment,s),k=i(s),W=d(s,"DIV",{class:!0,"data-svelte-h":!0}),c(W)!=="svelte-5iola2"&&(W.innerHTML=C),this.h()},h(){V(W,"class","flex gap-4")},m(s,b){l(s,p,b),l(s,o,b),l(s,M,b),l(s,_,b),g(J,s,b),l(s,I,b),l(s,r,b),l(s,X,b),g(j,s,b),l(s,k,b),l(s,W,b),u=!0},p:x,i(s){u||(h(J.$$.fragment,s),h(j.$$.fragment,s),u=!0)},o(s){Z(J.$$.fragment,s),Z(j.$$.fragment,s),u=!1},d(s){s&&(a(p),a(o),a(M),a(_),a(I),a(r),a(X),a(k),a(W)),U(J,s),U(j,s)}}}function Ul(R){let p,w='If you’re planning on offloading the model to the CPU, make sure you run it after you’ve loaded the IP-Adapter. When you call <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> before loading the IP-Adapter, it offloads the image encoder module to the CPU and it’ll return an error when you try to run the pipeline.';return{c(){p=m("p"),p.innerHTML=w},l(o){p=d(o,"P",{"data-svelte-h":!0}),c(p)!=="svelte-pndhhh"&&(p.innerHTML=w)},m(o,M){l(o,p,M)},p:x,d(o){o&&a(p)}}}function Jl(R){let p,w='IP-Adapter can also help you generate videos that are more aligned with your text prompt. For example, let’s load <a href="../api/pipelines/animatediff">AnimateDiff</a> with its motion adapter and insert an IP-Adapter into the model with the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method.',o,M,G,_,J,I,r="Pass a prompt and an image prompt to the pipeline to generate a short video.",T,X,j,k,W='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_inpaint.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/gummy_bear.gif"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated video</figcaption></div>',C;return M=new Ke({props:{warning:!0,$$slots:{default:[Ul]},$$scope:{ctx:R}}}),_=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQW5pbWF0ZURpZmZQaXBlbGluZSUyQyUyMERESU1TY2hlZHVsZXIlMkMlMjBNb3Rpb25BZGFwdGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQWFkYXB0ZXIlMjAlM0QlMjBNb3Rpb25BZGFwdGVyLmZyb21fcHJldHJhaW5lZCglMjJndW95d3clMkZhbmltYXRlZGlmZi1tb3Rpb24tYWRhcHRlci12MS01LTIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZWxpbmUlMjAlM0QlMjBBbmltYXRlRGlmZlBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJlbWlsaWFuSlIlMkZlcGlDUmVhbGlzbSUyMiUyQyUyMG1vdGlvbl9hZGFwdGVyJTNEYWRhcHRlciUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFzY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJlbWlsaWFuSlIlMkZlcGlDUmVhbGlzbSUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfc2FtcGxlJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjB0aW1lc3RlcF9zcGFjaW5nJTNEJTIybGluc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjBiZXRhX3NjaGVkdWxlJTNEJTIybGluZWFyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3RlcHNfb2Zmc2V0JTNEMSUyQyUwQSklMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBzY2hlZHVsZXIlMEFwaXBlbGluZS5lbmFibGVfdmFlX3NsaWNpbmcoKSUwQSUwQXBpcGVsaW5lLmxvYWRfaXBfYWRhcHRlciglMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIybW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkMTUuYmluJTIyKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, DDIMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)
pipeline = AnimateDiffPipeline.from_pretrained(<span class="hljs-string">&quot;emilianJR/epiCRealism&quot;</span>, motion_adapter=adapter, torch_dtype=torch.float16)
scheduler = DDIMScheduler.from_pretrained(
    <span class="hljs-string">&quot;emilianJR/epiCRealism&quot;</span>,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>,
)
pipeline.scheduler = scheduler
pipeline.enable_vae_slicing()

pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),X=new v({props:{code:"aXBfYWRhcHRlcl9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9pbnBhaW50LnBuZyUyMiklMEElMEFvdXRwdXQlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJBJTIwY3V0ZSUyMGd1bW15JTIwYmVhciUyMHdhdmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMmJhZCUyMHF1YWxpdHklMkMlMjB3b3JzZSUyMHF1YWxpdHklMkMlMjBsb3clMjByZXNvbHV0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGlwX2FkYXB0ZXJfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBudW1fZnJhbWVzJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDcuNSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTJDJTBBKSUwQWZyYW1lcyUyMCUzRCUyMG91dHB1dC5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX2dpZihmcmFtZXMlMkMlMjAlMjJndW1teV9iZWFyLmdpZiUyMik=",highlighted:`ip_adapter_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_inpaint.png&quot;</span>)

output = pipeline(
    prompt=<span class="hljs-string">&quot;A cute gummy bear waving&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality, low resolution&quot;</span>,
    ip_adapter_image=ip_adapter_image,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;gummy_bear.gif&quot;</span>)`,wrap:!1}}),{c(){p=m("p"),p.innerHTML=w,o=n(),y(M.$$.fragment),G=n(),y(_.$$.fragment),J=n(),I=m("p"),I.textContent=r,T=n(),y(X.$$.fragment),j=n(),k=m("div"),k.innerHTML=W,this.h()},l(u){p=d(u,"P",{"data-svelte-h":!0}),c(p)!=="svelte-10zqvoq"&&(p.innerHTML=w),o=i(u),f(M.$$.fragment,u),G=i(u),f(_.$$.fragment,u),J=i(u),I=d(u,"P",{"data-svelte-h":!0}),c(I)!=="svelte-a6opnh"&&(I.textContent=r),T=i(u),f(X.$$.fragment,u),j=i(u),k=d(u,"DIV",{class:!0,"data-svelte-h":!0}),c(k)!=="svelte-ihoum9"&&(k.innerHTML=W),this.h()},h(){V(k,"class","flex flex-row gap-4")},m(u,s){l(u,p,s),l(u,o,s),g(M,u,s),l(u,G,s),g(_,u,s),l(u,J,s),l(u,I,s),l(u,T,s),g(X,u,s),l(u,j,s),l(u,k,s),C=!0},p(u,s){const b={};s&2&&(b.$$scope={dirty:s,ctx:u}),M.$set(b)},i(u){C||(h(M.$$.fragment,u),h(_.$$.fragment,u),h(X.$$.fragment,u),C=!0)},o(u){Z(M.$$.fragment,u),Z(_.$$.fragment,u),Z(X.$$.fragment,u),C=!1},d(u){u&&(a(p),a(o),a(G),a(J),a(I),a(T),a(j),a(k)),U(M,u),U(_,u),U(X,u)}}}function bl(R){let p,w,o,M,G,_,J,I;return p=new fa({props:{id:"tasks",option:"Text-to-image",$$slots:{default:[gl]},$$scope:{ctx:R}}}),o=new fa({props:{id:"tasks",option:"Image-to-image",$$slots:{default:[hl]},$$scope:{ctx:R}}}),G=new fa({props:{id:"tasks",option:"Inpainting",$$slots:{default:[Zl]},$$scope:{ctx:R}}}),J=new fa({props:{id:"tasks",option:"Video",$$slots:{default:[Jl]},$$scope:{ctx:R}}}),{c(){y(p.$$.fragment),w=n(),y(o.$$.fragment),M=n(),y(G.$$.fragment),_=n(),y(J.$$.fragment)},l(r){f(p.$$.fragment,r),w=i(r),f(o.$$.fragment,r),M=i(r),f(G.$$.fragment,r),_=i(r),f(J.$$.fragment,r)},m(r,T){g(p,r,T),l(r,w,T),g(o,r,T),l(r,M,T),g(G,r,T),l(r,_,T),g(J,r,T),I=!0},p(r,T){const X={};T&2&&(X.$$scope={dirty:T,ctx:r}),p.$set(X);const j={};T&2&&(j.$$scope={dirty:T,ctx:r}),o.$set(j);const k={};T&2&&(k.$$scope={dirty:T,ctx:r}),G.$set(k);const W={};T&2&&(W.$$scope={dirty:T,ctx:r}),J.$set(W)},i(r){I||(h(p.$$.fragment,r),h(o.$$.fragment,r),h(G.$$.fragment,r),h(J.$$.fragment,r),I=!0)},o(r){Z(p.$$.fragment,r),Z(o.$$.fragment,r),Z(G.$$.fragment,r),Z(J.$$.fragment,r),I=!1},d(r){r&&(a(w),a(M),a(_)),U(p,r),U(o,r),U(G,r),U(J,r)}}}function wl(R){let p,w="This parameter also gives you the flexibility to load embeddings from other sources. For example, ComfyUI image embeddings for IP-Adapters are compatible with Diffusers and should work ouf-of-the-box!";return{c(){p=m("p"),p.textContent=w},l(o){p=d(o,"P",{"data-svelte-h":!0}),c(p)!=="svelte-1rk1t7q"&&(p.textContent=w)},m(o,M){l(o,p,M)},p:x,d(o){o&&a(p)}}}function Tl(R){let p,w="If you’re using IP-Adapter with <code>ip_adapter_image_embedding</code> instead of <code>ip_adapter_image</code>’, you can set <code>load_ip_adapter(image_encoder_folder=None,...)</code> because you don’t need to load an encoder to generate the image embeddings.";return{c(){p=m("p"),p.innerHTML=w},l(o){p=d(o,"P",{"data-svelte-h":!0}),c(p)!=="svelte-h0lw9v"&&(p.innerHTML=w)},m(o,M){l(o,p,M)},p:x,d(o){o&&a(p)}}}function jl(R){let p,w='Read the <a href="../using-diffusers/loading_adapters#ip-adapter-plus">IP-Adapter Plus</a> section to learn why you need to manually load the image encoder.';return{c(){p=m("p"),p.innerHTML=w},l(o){p=d(o,"P",{"data-svelte-h":!0}),c(p)!=="svelte-apa7ha"&&(p.innerHTML=w)},m(o,M){l(o,p,M)},p:x,d(o){o&&a(p)}}}function Wl(R){let p,w,o,M,G,_,J,I='<a href="https://hf.co/papers/2308.06721" rel="nofollow">IP-Adapter</a> is an image prompt adapter that can be plugged into diffusion models to enable image prompting without any changes to the underlying model. Furthermore, this adapter can be reused with other models finetuned from the same base model and it can be combined with other adapters like <a href="../using-diffusers/controlnet">ControlNet</a>. The key idea behind IP-Adapter is the <em>decoupled cross-attention</em> mechanism which adds a separate cross-attention layer just for image features instead of using the same cross-attention layer for both text and image features. This allows the model to learn more image-specific features.',r,T,X,j,k="This guide will walk you through using IP-Adapter for various tasks and use cases.",W,C,u,s,b='Let’s take a look at how to use IP-Adapter’s image prompting capabilities with the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a> for tasks like text-to-image, image-to-image, and inpainting. We also encourage you to try out other pipelines such as Stable Diffusion, LCM-LoRA, ControlNet, T2I-Adapter, or AnimateDiff!',et,K,ga='In all the following examples, you’ll see the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.set_ip_adapter_scale">set_ip_adapter_scale()</a> method. This method controls the amount of text or image conditioning to apply to the model. A value of <code>1.0</code> means the model is only conditioned on the image prompt. Lowering this value encourages the model to produce more diverse images, but they may not be as aligned with the image prompt. Typically, a value of <code>0.5</code> achieves a good balance between the two prompt types and produces good results.',tt,B,at,Y,lt,O,st,ee,ha="There are a couple of IP-Adapter parameters that are useful to know about and can help you with your image generation tasks. These parameters can make your workflow more efficient or give you more control over image generation.",nt,te,it,ae,Za='IP-Adapter enabled pipelines provide the <code>ip_adapter_image_embeds</code> parameter to accept precomputed image embeddings. This is particularly useful in scenarios where you need to run the IP-Adapter pipeline multiple times because you have more than one image. For example, <a href="#multi-ip-adapter">multi IP-Adapter</a> is a specific use case where you provide multiple styling images to generate a specific image in a specific style. Loading and encoding multiple images each time you use the pipeline would be inefficient. Instead, you can precompute and save the image embeddings to disk (which can save a lot of space if you’re using high-quality images) and load them when you need them.',pt,F,ot,le,Ua="Call the <code>prepare_ip_adapter_image_embeds()</code> method to encode and generate the image embeddings. Then you can save them to disk with <code>torch.save</code>.",rt,H,mt,se,dt,ne,Ja="Now load the image embeddings by passing them to the <code>ip_adapter_image_embeds</code> parameter.",ct,ie,ut,pe,Mt,oe,ba="Binary masks specify which portion of the output image should be assigned to an IP-Adapter. This is useful for composing more than one IP-Adapter image. For each input IP-Adapter image, you must provide a binary mask an an IP-Adapter.",yt,re,wa="To start, preprocess the input IP-Adapter images with the <code>~image_processor.IPAdapterMaskProcessor.preprocess()</code> to generate their masks. For optimal results, provide the output height and width to <code>~image_processor.IPAdapterMaskProcessor.preprocess()</code>. This ensures masks with different aspect ratios are appropriately stretched. If the input masks already match the aspect ratio of the generated image, you don’t have to set the <code>height</code> and <code>width</code>.",ft,me,gt,N,Ta='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_mask1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">mask one</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_mask2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">mask two</figcaption></div>',ht,de,ja="When there is more than one input IP-Adapter image, load them as a list to ensure each image is assigned to a different IP-Adapter. Each of the input IP-Adapter images here correspond to the masks generated above.",Zt,ce,Ut,Q,Wa='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_girl1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image one</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_girl2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image two</figcaption></div>',Jt,ue,_a="Now pass the preprocessed masks to <code>cross_attention_kwargs</code> in the pipeline call.",bt,Me,wt,z,Ga='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_attention_mask_result_seed_0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter masking applied</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_no_attention_mask_result_seed_0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">no IP-Adapter masking applied</figcaption></div>',Tt,ye,jt,fe,Ia="IP-Adapter’s image prompting and compatibility with other adapters and models makes it a versatile tool for a variety of use cases. This section covers some of the more popular applications of IP-Adapter, and we can’t wait to see what you come up with!",Wt,ge,_t,he,Xa='Generating accurate faces is challenging because they are complex and nuanced. Diffusers supports two IP-Adapter checkpoints specifically trained to generate faces from the <a href="https://huggingface.co/h94/IP-Adapter" rel="nofollow">h94/IP-Adapter</a> repository:',Gt,Ze,ka='<li><a href="https://huggingface.co/h94/IP-Adapter/blob/main/models/ip-adapter-full-face_sd15.safetensors" rel="nofollow">ip-adapter-full-face_sd15.safetensors</a> is conditioned with images of cropped faces and removed backgrounds</li> <li><a href="https://huggingface.co/h94/IP-Adapter/blob/main/models/ip-adapter-plus-face_sd15.safetensors" rel="nofollow">ip-adapter-plus-face_sd15.safetensors</a> uses patch embeddings and is conditioned with images of cropped faces</li>',It,Ue,va='Additionally, Diffusers supports all IP-Adapter checkpoints trained with face embeddings extracted by <code>insightface</code> face models. Supported models are from the <a href="https://huggingface.co/h94/IP-Adapter-FaceID" rel="nofollow">h94/IP-Adapter-FaceID</a> repository.',Xt,Je,Ra='For face models, use the <a href="https://huggingface.co/h94/IP-Adapter" rel="nofollow">h94/IP-Adapter</a> checkpoint. It is also recommended to use <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a> or <a href="/docs/diffusers/main/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a> for face models.',kt,be,vt,S,Ca='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_einstein_base.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_einstein.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',Rt,we,Va="To use IP-Adapter FaceID models, first extract face embeddings with <code>insightface</code>. Then pass the list of tensors to the pipeline as <code>ip_adapter_image_embeds</code>.",Ct,Te,Vt,je,$a="Both IP-Adapter FaceID Plus and Plus v2 models require CLIP image embeddings. You can prepare face embeddings as shown previously, then you can extract and pass CLIP embeddings to the hidden image projection layers.",$t,We,xt,_e,Bt,Ge,xa="More than one IP-Adapter can be used at the same time to generate specific images in more diverse styles. For example, you can use IP-Adapter-Face to generate consistent faces and characters, and IP-Adapter Plus to generate those faces in a specific style.",Yt,A,Ft,Ie,Ba='Load the image encoder with <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPVisionModelWithProjection" rel="nofollow">CLIPVisionModelWithProjection</a>.',Ht,Xe,Nt,ke,Ya="Next, you’ll load a base model, scheduler, and the IP-Adapters. The IP-Adapters to use are passed as a list to the <code>weight_name</code> parameter:",Qt,ve,Fa='<li><a href="https://huggingface.co/h94/IP-Adapter#ip-adapter-for-sdxl-10" rel="nofollow">ip-adapter-plus_sdxl_vit-h</a> uses patch embeddings and a ViT-H image encoder</li> <li><a href="https://huggingface.co/h94/IP-Adapter#ip-adapter-for-sdxl-10" rel="nofollow">ip-adapter-plus-face_sdxl_vit-h</a> has the same architecture but it is conditioned with images of cropped faces</li>',zt,Re,St,Ce,Ha="Load an image prompt and a folder containing images of a certain style you want to use.",At,Ve,Et,E,Na='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/women_input.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image of face</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_style_grid.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter style images</figcaption></div>',qt,$e,Qa="Pass the image prompt and style images as a list to the <code>ip_adapter_image</code> parameter, and run the pipeline!",Lt,xe,Pt,q,za='    <img src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_multi_out.png"/>',Dt,Be,Kt,Ye,Sa='<a href="../using-diffusers/inference_with_lcm_lora">Latent Consistency Models (LCM)</a> are diffusion models that can generate images in as little as 4 steps compared to other diffusion models like SDXL that typically require way more steps. This is why image generation with an LCM feels “instantaneous”. IP-Adapters can be plugged into an LCM-LoRA model to instantly generate images with an image prompt.',Ot,Fe,Aa='The IP-Adapter weights need to be loaded first, then you can use <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> to load the LoRA style and weight you want to apply to your image.',ea,He,ta,Ne,Ea='Try using with a lower IP-Adapter scale to condition image generation more on the <a href="https://huggingface.co/sd-dreambooth-library/herge-style" rel="nofollow">herge_style</a> checkpoint, and remember to use the special token <code>herge_style</code> in your prompt to trigger and apply the style.',aa,Qe,la,L,qa='    <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_herge.png"/>',sa,ze,na,Se,La='To control image generation to an even greater degree, you can combine IP-Adapter with a model like <a href="../using-diffusers/controlnet">ControlNet</a>. A ControlNet is also an adapter that can be inserted into a diffusion model to allow for conditioning on an additional control image. The control image can be depth maps, edge maps, pose estimations, and more.',ia,Ae,Pa='Load a <a href="/docs/diffusers/main/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> checkpoint conditioned on depth maps, insert it into a diffusion model, and load the IP-Adapter.',pa,Ee,oa,qe,Da="Now load the IP-Adapter image and depth map.",ra,Le,ma,P,Ka='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/statue.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/depth.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">depth map</figcaption></div>',da,Pe,Oa="Pass the depth map and IP-Adapter image to the pipeline to generate an image.",ca,De,ua,D,el='    <img src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ipa-controlnet-out.png"/>',Ma,Oe,ya;return G=new $({props:{title:"IP-Adapter",local:"ip-adapter",headingTag:"h1"}}),T=new Ke({props:{warning:!1,$$slots:{default:[yl]},$$scope:{ctx:R}}}),C=new $({props:{title:"General tasks",local:"general-tasks",headingTag:"h2"}}),B=new Ke({props:{warning:!1,$$slots:{default:[fl]},$$scope:{ctx:R}}}),Y=new Ml({props:{id:"tasks",options:["Text-to-image","Image-to-image","Inpainting","Video"],$$slots:{default:[bl]},$$scope:{ctx:R}}}),O=new $({props:{title:"Configure parameters",local:"configure-parameters",headingTag:"h2"}}),te=new $({props:{title:"Image embeddings",local:"image-embeddings",headingTag:"h3"}}),F=new Ke({props:{warning:!1,$$slots:{default:[wl]},$$scope:{ctx:R}}}),H=new Ke({props:{warning:!1,$$slots:{default:[Tl]},$$scope:{ctx:R}}}),se=new v({props:{code:"aW1hZ2VfZW1iZWRzJTIwJTNEJTIwcGlwZWxpbmUucHJlcGFyZV9pcF9hZGFwdGVyX2ltYWdlX2VtYmVkcyglMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlX2VtYmVkcyUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2UlM0QlMjJjdWRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2ltYWdlc19wZXJfcHJvbXB0JTNEMSUyQyUwQSUyMCUyMCUyMCUyMGRvX2NsYXNzaWZpZXJfZnJlZV9ndWlkYW5jZSUzRFRydWUlMkMlMEEpJTBBJTBBdG9yY2guc2F2ZShpbWFnZV9lbWJlZHMlMkMlMjAlMjJpbWFnZV9lbWJlZHMuaXBhZHB0JTIyKQ==",highlighted:`image_embeds = pipeline.prepare_ip_adapter_image_embeds(
    ip_adapter_image=image,
    ip_adapter_image_embeds=<span class="hljs-literal">None</span>,
    device=<span class="hljs-string">&quot;cuda&quot;</span>,
    num_images_per_prompt=<span class="hljs-number">1</span>,
    do_classifier_free_guidance=<span class="hljs-literal">True</span>,
)

torch.save(image_embeds, <span class="hljs-string">&quot;image_embeds.ipadpt&quot;</span>)`,wrap:!1}}),ie=new v({props:{code:"aW1hZ2VfZW1iZWRzJTIwJTNEJTIwdG9yY2gubG9hZCglMjJpbWFnZV9lbWJlZHMuaXBhZHB0JTIyKSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBwb2xhciUyMGJlYXIlMjBzaXR0aW5nJTIwaW4lMjBhJTIwY2hhaXIlMjBkcmlua2luZyUyMGElMjBtaWxrc2hha2UlMjIlMkMlMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlX2VtYmVkcyUzRGltYWdlX2VtYmVkcyUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMmRlZm9ybWVkJTJDJTIwdWdseSUyQyUyMHdyb25nJTIwcHJvcG9ydGlvbiUyQyUyMGxvdyUyMHJlcyUyQyUyMGJhZCUyMGFuYXRvbXklMkMlMjB3b3JzdCUyMHF1YWxpdHklMkMlMjBsb3clMjBxdWFsaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2Vz",highlighted:`image_embeds = torch.load(<span class="hljs-string">&quot;image_embeds.ipadpt&quot;</span>)
images = pipeline(
    prompt=<span class="hljs-string">&quot;a polar bear sitting in a chair drinking a milkshake&quot;</span>,
    ip_adapter_image_embeds=image_embeds,
    negative_prompt=<span class="hljs-string">&quot;deformed, ugly, wrong proportion, low res, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">100</span>,
    generator=generator,
).images`,wrap:!1}}),pe=new $({props:{title:"IP-Adapter masking",local:"ip-adapter-masking",headingTag:"h3"}}),me=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5pbWFnZV9wcm9jZXNzb3IlMjBpbXBvcnQlMjBJUEFkYXB0ZXJNYXNrUHJvY2Vzc29yJTBBJTBBbWFzazElMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlwX21hc2tfbWFzazEucG5nJTIyKSUwQW1hc2syJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpcF9tYXNrX21hc2syLnBuZyUyMiklMEElMEFvdXRwdXRfaGVpZ2h0JTIwJTNEJTIwMTAyNCUwQW91dHB1dF93aWR0aCUyMCUzRCUyMDEwMjQlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBJUEFkYXB0ZXJNYXNrUHJvY2Vzc29yKCklMEFtYXNrcyUyMCUzRCUyMHByb2Nlc3Nvci5wcmVwcm9jZXNzKCU1Qm1hc2sxJTJDJTIwbWFzazIlNUQlMkMlMjBoZWlnaHQlM0RvdXRwdXRfaGVpZ2h0JTJDJTIwd2lkdGglM0RvdXRwdXRfd2lkdGgp",highlighted:`<span class="hljs-keyword">from</span> diffusers.image_processor <span class="hljs-keyword">import</span> IPAdapterMaskProcessor

mask1 = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_mask_mask1.png&quot;</span>)
mask2 = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_mask_mask2.png&quot;</span>)

output_height = <span class="hljs-number">1024</span>
output_width = <span class="hljs-number">1024</span>

processor = IPAdapterMaskProcessor()
masks = processor.preprocess([mask1, mask2], height=output_height, width=output_width)`,wrap:!1}}),ce=new v({props:{code:"ZmFjZV9pbWFnZTElMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlwX21hc2tfZ2lybDEucG5nJTIyKSUwQWZhY2VfaW1hZ2UyJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpcF9tYXNrX2dpcmwyLnBuZyUyMiklMEElMEFpcF9pbWFnZXMlMjAlM0QlMjAlNUIlNUJmYWNlX2ltYWdlMSU1RCUyQyUyMCU1QmZhY2VfaW1hZ2UyJTVEJTVE",highlighted:`face_image1 = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_mask_girl1.png&quot;</span>)
face_image2 = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_mask_girl2.png&quot;</span>)

ip_images = [[face_image1], [face_image2]]`,wrap:!1}}),Me=new v({props:{code:"cGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJzZHhsX21vZGVscyUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTVCJTIyaXAtYWRhcHRlci1wbHVzLWZhY2Vfc2R4bF92aXQtaC5zYWZldGVuc29ycyUyMiU1RCUyMColMjAyKSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKCU1QjAuNyU1RCUyMColMjAyKSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTBBbnVtX2ltYWdlcyUyMCUzRCUyMDElMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMjIlMjBnaXJscyUyMiUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpcF9pbWFnZXMlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjJtb25vY2hyb21lJTJDJTIwbG93cmVzJTJDJTIwYmFkJTIwYW5hdG9teSUyQyUyMHdvcnN0JTIwcXVhbGl0eSUyQyUyMGxvdyUyMHF1YWxpdHklMjIlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjAlMkMlMEElMjAlMjAlMjAlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0RudW1faW1hZ2VzJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBJTIwJTIwJTIwJTIwY3Jvc3NfYXR0ZW50aW9uX2t3YXJncyUzRCU3QiUyMmlwX2FkYXB0ZXJfbWFza3MlMjIlM0ElMjBtYXNrcyU3RCUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=[<span class="hljs-string">&quot;ip-adapter-plus-face_sdxl_vit-h.safetensors&quot;</span>] * <span class="hljs-number">2</span>)
pipeline.set_ip_adapter_scale([<span class="hljs-number">0.7</span>] * <span class="hljs-number">2</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
num_images = <span class="hljs-number">1</span>

image = pipeline(
    prompt=<span class="hljs-string">&quot;2 girls&quot;</span>,
    ip_adapter_image=ip_images,
    negative_prompt=<span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">20</span>,
    num_images_per_prompt=num_images,
    generator=generator,
    cross_attention_kwargs={<span class="hljs-string">&quot;ip_adapter_masks&quot;</span>: masks}
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ye=new $({props:{title:"Specific use cases",local:"specific-use-cases",headingTag:"h2"}}),ge=new $({props:{title:"Face model",local:"face-model",headingTag:"h3"}}),be=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBERElNU2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJtb2RlbHMlMjIlMkMlMjB3ZWlnaHRfbmFtZSUzRCUyMmlwLWFkYXB0ZXItZnVsbC1mYWNlX3NkMTUuYmluJTIyKSUwQSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKDAuNSklMEElMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9laW5zdGVpbl9iYXNlLnBuZyUyMiklMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgyNiklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMkElMjBwaG90byUyMG9mJTIwRWluc3RlaW4lMjBhcyUyMGElMjBjaGVmJTJDJTIwd2VhcmluZyUyMGFuJTIwYXByb24lMkMlMjBjb29raW5nJTIwaW4lMjBhJTIwRnJlbmNoJTIwcmVzdGF1cmFudCUyMiUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMmxvd3JlcyUyQyUyMGJhZCUyMGFuYXRvbXklMkMlMjB3b3JzdCUyMHF1YWxpdHklMkMlMjBsb3clMjBxdWFsaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, DDIMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter-full-face_sd15.bin&quot;</span>)

pipeline.set_ip_adapter_scale(<span class="hljs-number">0.5</span>)

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_einstein_base.png&quot;</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">26</span>)

image = pipeline(
    prompt=<span class="hljs-string">&quot;A photo of Einstein as a chef, wearing an apron, cooking in a French restaurant&quot;</span>,
    ip_adapter_image=image,
    negative_prompt=<span class="hljs-string">&quot;lowres, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">100</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Te=new v({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, DDIMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> insightface.app <span class="hljs-keyword">import</span> FaceAnalysis

pipeline = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter-FaceID&quot;</span>, subfolder=<span class="hljs-literal">None</span>, weight_name=<span class="hljs-string">&quot;ip-adapter-faceid_sd15.bin&quot;</span>, image_encoder_folder=<span class="hljs-literal">None</span>)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_mask_girl1.png&quot;</span>)

ref_images_embeds = []
app = FaceAnalysis(name=<span class="hljs-string">&quot;buffalo_l&quot;</span>, providers=[<span class="hljs-string">&#x27;CUDAExecutionProvider&#x27;</span>, <span class="hljs-string">&#x27;CPUExecutionProvider&#x27;</span>])
app.prepare(ctx_id=<span class="hljs-number">0</span>, det_size=(<span class="hljs-number">640</span>, <span class="hljs-number">640</span>))
image = cv2.cvtColor(np.asarray(image), cv2.COLOR_BGR2RGB)
faces = app.get(image)
image = torch.from_numpy(faces[<span class="hljs-number">0</span>].normed_embedding)
ref_images_embeds.append(image.unsqueeze(<span class="hljs-number">0</span>))
ref_images_embeds = torch.stack(ref_images_embeds, dim=<span class="hljs-number">0</span>).unsqueeze(<span class="hljs-number">0</span>)
neg_ref_images_embeds = torch.zeros_like(ref_images_embeds)
id_embeds = torch.cat([neg_ref_images_embeds, ref_images_embeds]).to(dtype=torch.float16, device=<span class="hljs-string">&quot;cuda&quot;</span>))

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">42</span>)

images = pipeline(
    prompt=<span class="hljs-string">&quot;A photo of a girl&quot;</span>,
    ip_adapter_image_embeds=[id_embeds], 
    negative_prompt=<span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>, 
    num_inference_steps=<span class="hljs-number">20</span>, num_images_per_prompt=<span class="hljs-number">1</span>,
    generator=generator
).images`,wrap:!1}}),We=new v({props:{code:"Y2xpcF9lbWJlZHMlMjAlM0QlMjBwaXBlbGluZS5wcmVwYXJlX2lwX2FkYXB0ZXJfaW1hZ2VfZW1iZWRzKCU1QmlwX2FkYXB0ZXJfaW1hZ2VzJTVEJTJDJTIwTm9uZSUyQyUyMHRvcmNoLmRldmljZSglMjJjdWRhJTIyKSUyQyUyMG51bV9pbWFnZXMlMkMlMjBUcnVlKSU1QjAlNUQlMEElMEFwaXBlbGluZS51bmV0LmVuY29kZXJfaGlkX3Byb2ouaW1hZ2VfcHJvamVjdGlvbl9sYXllcnMlNUIwJTVELmNsaXBfZW1iZWRzJTIwJTNEJTIwY2xpcF9lbWJlZHMudG8oZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGVsaW5lLnVuZXQuZW5jb2Rlcl9oaWRfcHJvai5pbWFnZV9wcm9qZWN0aW9uX2xheWVycyU1QjAlNUQuc2hvcnRjdXQlMjAlM0QlMjBGYWxzZSUyMCUyMyUyMFRydWUlMjBpZiUyMFBsdXMlMjB2Mg==",highlighted:`clip_embeds = pipeline.prepare_ip_adapter_image_embeds([ip_adapter_images], <span class="hljs-literal">None</span>, torch.device(<span class="hljs-string">&quot;cuda&quot;</span>), num_images, <span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]

pipeline.unet.encoder_hid_proj.image_projection_layers[<span class="hljs-number">0</span>].clip_embeds = clip_embeds.to(dtype=torch.float16)
pipeline.unet.encoder_hid_proj.image_projection_layers[<span class="hljs-number">0</span>].shortcut = <span class="hljs-literal">False</span> <span class="hljs-comment"># True if Plus v2</span>`,wrap:!1}}),_e=new $({props:{title:"Multi IP-Adapter",local:"multi-ip-adapter",headingTag:"h3"}}),A=new Ke({props:{warning:!1,$$slots:{default:[jl]},$$scope:{ctx:R}}}),Xe=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUyQyUyMERESU1TY2hlZHVsZXIlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQ0xJUFZpc2lvbk1vZGVsV2l0aFByb2plY3Rpb24lMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQWltYWdlX2VuY29kZXIlMjAlM0QlMjBDTElQVmlzaW9uTW9kZWxXaXRoUHJvamVjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMm1vZGVscyUyRmltYWdlX2VuY29kZXIlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, DDIMScheduler
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPVisionModelWithProjection
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

image_encoder = CLIPVisionModelWithProjection.from_pretrained(
    <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>,
    subfolder=<span class="hljs-string">&quot;models/image_encoder&quot;</span>,
    torch_dtype=torch.float16,
)`,wrap:!1}}),Re=new v({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBpbWFnZV9lbmNvZGVyJTNEaW1hZ2VfZW5jb2RlciUyQyUwQSklMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUwQSUyMCUyMCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMEElMjAlMjBzdWJmb2xkZXIlM0QlMjJzZHhsX21vZGVscyUyMiUyQyUwQSUyMCUyMHdlaWdodF9uYW1lJTNEJTVCJTIyaXAtYWRhcHRlci1wbHVzX3NkeGxfdml0LWguc2FmZXRlbnNvcnMlMjIlMkMlMjAlMjJpcC1hZGFwdGVyLXBsdXMtZmFjZV9zZHhsX3ZpdC1oLnNhZmV0ZW5zb3JzJTIyJTVEJTBBKSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKCU1QjAuNyUyQyUyMDAuMyU1RCklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.float16,
    image_encoder=image_encoder,
)
pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
pipeline.load_ip_adapter(
  <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>,
  subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>,
  weight_name=[<span class="hljs-string">&quot;ip-adapter-plus_sdxl_vit-h.safetensors&quot;</span>, <span class="hljs-string">&quot;ip-adapter-plus-face_sdxl_vit-h.safetensors&quot;</span>]
)
pipeline.set_ip_adapter_scale([<span class="hljs-number">0.7</span>, <span class="hljs-number">0.3</span>])
pipeline.enable_model_cpu_offload()`,wrap:!1}}),Ve=new v({props:{code:"ZmFjZV9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRndvbWVuX2lucHV0LnBuZyUyMiklMEFzdHlsZV9mb2xkZXIlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZZaVlpWHUlMkZ0ZXN0aW5nLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGc3R5bGVfemlnZ3klMjIlMEFzdHlsZV9pbWFnZXMlMjAlM0QlMjAlNUJsb2FkX2ltYWdlKGYlMjIlN0JzdHlsZV9mb2xkZXIlN0QlMkZpbWclN0JpJTdELnBuZyUyMiklMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgxMCklNUQ=",highlighted:`face_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/women_input.png&quot;</span>)
style_folder = <span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/style_ziggy&quot;</span>
style_images = [load_image(<span class="hljs-string">f&quot;<span class="hljs-subst">{style_folder}</span>/img<span class="hljs-subst">{i}</span>.png&quot;</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">10</span>)]`,wrap:!1}}),xe=new v({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMCklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMndvbmRlcndvbWFuJTIyJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRCU1QnN0eWxlX2ltYWdlcyUyQyUyMGZhY2VfaW1hZ2UlNUQlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjJtb25vY2hyb21lJTJDJTIwbG93cmVzJTJDJTIwYmFkJTIwYW5hdG9teSUyQyUyMHdvcnN0JTIwcXVhbGl0eSUyQyUyMGxvdyUyMHF1YWxpdHklMjIlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QxJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

image = pipeline(
    prompt=<span class="hljs-string">&quot;wonderwoman&quot;</span>,
    ip_adapter_image=[style_images, face_image],
    negative_prompt=<span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">50</span>, num_images_per_prompt=<span class="hljs-number">1</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Be=new $({props:{title:"Instant generation",local:"instant-generation",headingTag:"h3"}}),He=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTJDJTIwTENNU2NoZWR1bGVyJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc2QtZHJlYW1ib290aC1saWJyYXJ5JTJGaGVyZ2Utc3R5bGUlMjIlMEFsY21fbG9yYV9pZCUyMCUzRCUyMCUyMmxhdGVudC1jb25zaXN0ZW5jeSUyRmxjbS1sb3JhLXNkdjEtNSUyMiUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUwQXBpcGVsaW5lLmxvYWRfaXBfYWRhcHRlciglMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIybW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkMTUuYmluJTIyKSUwQXBpcGVsaW5lLmxvYWRfbG9yYV93ZWlnaHRzKGxjbV9sb3JhX2lkKSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMExDTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, LCMScheduler
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

model_id = <span class="hljs-string">&quot;sd-dreambooth-library/herge-style&quot;</span>
lcm_lora_id = <span class="hljs-string">&quot;latent-consistency/lcm-lora-sdv1-5&quot;</span>

pipeline = DiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16)

pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)
pipeline.load_lora_weights(lcm_lora_id)
pipeline.scheduler = LCMScheduler.from_config(pipeline.scheduler.config)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),Qe=new v({props:{code:"cGlwZWxpbmUuc2V0X2lwX2FkYXB0ZXJfc2NhbGUoMC40KSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmhlcmdlX3N0eWxlJTIwd29tYW4lMjBpbiUyMGFybW9yJTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBoaWdoJTIwcXVhbGl0eSUyMiUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTBBJTBBaXBfYWRhcHRlcl9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZ1c2VyLWltYWdlcy5naXRodWJ1c2VyY29udGVudC5jb20lMkYyNDczNDE0MiUyRjI2NjQ5Mjg3NS0yZDUwZDIyMy04NDc1LTQ0ZjAtYTdjNi0wOGI1MWNiNTM1NzIucG5nJTIyKSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGlwX2FkYXB0ZXJfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMSUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`pipeline.set_ip_adapter_scale(<span class="hljs-number">0.4</span>)

prompt = <span class="hljs-string">&quot;herge_style woman in armor, best quality, high quality&quot;</span>
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

ip_adapter_image = load_image(<span class="hljs-string">&quot;https://user-images.githubusercontent.com/24734142/266492875-2d50d223-8475-44f0-a7c6-08b51cb53572.png&quot;</span>)
image = pipeline(
    prompt=prompt,
    ip_adapter_image=ip_adapter_image,
    num_inference_steps=<span class="hljs-number">4</span>,
    guidance_scale=<span class="hljs-number">1</span>,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ze=new $({props:{title:"Structural control",local:"structural-control",headingTag:"h3"}}),Ee=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZSUyQyUyMENvbnRyb2xOZXRNb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFjb250cm9sbmV0X21vZGVsX3BhdGglMjAlM0QlMjAlMjJsbGx5YXN2aWVsJTJGY29udHJvbF92MTFmMXBfc2QxNV9kZXB0aCUyMiUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGNvbnRyb2xuZXRfbW9kZWxfcGF0aCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmxvYWRfaXBfYWRhcHRlciglMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIybW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkMTUuYmluJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

controlnet_model_path = <span class="hljs-string">&quot;lllyasviel/control_v11f1p_sd15_depth&quot;</span>
controlnet = ControlNetModel.from_pretrained(controlnet_model_path, torch_dtype=torch.float16)

pipeline = StableDiffusionControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)`,wrap:!1}}),Le=new v({props:{code:"aXBfYWRhcHRlcl9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnN0YXR1ZS5wbmclMjIpJTBBZGVwdGhfbWFwJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZZaVlpWHUlMkZ0ZXN0aW5nLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGVwdGgucG5nJTIyKQ==",highlighted:`ip_adapter_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/statue.png&quot;</span>)
depth_map = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/depth.png&quot;</span>)`,wrap:!1}}),De=new v({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMzMpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJiZXN0JTIwcXVhbGl0eSUyQyUyMGhpZ2glMjBxdWFsaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RkZXB0aF9tYXAlMkMlMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlJTNEaXBfYWRhcHRlcl9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMm1vbm9jaHJvbWUlMkMlMjBsb3dyZXMlMkMlMjBiYWQlMjBhbmF0b215JTJDJTIwd29yc3QlMjBxdWFsaXR5JTJDJTIwbG93JTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">33</span>)
image = pipeline(
    prompt=<span class="hljs-string">&quot;best quality, high quality&quot;</span>,
    image=depth_map,
    ip_adapter_image=ip_adapter_image,
    negative_prompt=<span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),{c(){p=m("meta"),w=n(),o=m("p"),M=n(),y(G.$$.fragment),_=n(),J=m("p"),J.innerHTML=I,r=n(),y(T.$$.fragment),X=n(),j=m("p"),j.textContent=k,W=n(),y(C.$$.fragment),u=n(),s=m("p"),s.innerHTML=b,et=n(),K=m("p"),K.innerHTML=ga,tt=n(),y(B.$$.fragment),at=n(),y(Y.$$.fragment),lt=n(),y(O.$$.fragment),st=n(),ee=m("p"),ee.textContent=ha,nt=n(),y(te.$$.fragment),it=n(),ae=m("p"),ae.innerHTML=Za,pt=n(),y(F.$$.fragment),ot=n(),le=m("p"),le.innerHTML=Ua,rt=n(),y(H.$$.fragment),mt=n(),y(se.$$.fragment),dt=n(),ne=m("p"),ne.innerHTML=Ja,ct=n(),y(ie.$$.fragment),ut=n(),y(pe.$$.fragment),Mt=n(),oe=m("p"),oe.textContent=ba,yt=n(),re=m("p"),re.innerHTML=wa,ft=n(),y(me.$$.fragment),gt=n(),N=m("div"),N.innerHTML=Ta,ht=n(),de=m("p"),de.textContent=ja,Zt=n(),y(ce.$$.fragment),Ut=n(),Q=m("div"),Q.innerHTML=Wa,Jt=n(),ue=m("p"),ue.innerHTML=_a,bt=n(),y(Me.$$.fragment),wt=n(),z=m("div"),z.innerHTML=Ga,Tt=n(),y(ye.$$.fragment),jt=n(),fe=m("p"),fe.textContent=Ia,Wt=n(),y(ge.$$.fragment),_t=n(),he=m("p"),he.innerHTML=Xa,Gt=n(),Ze=m("ul"),Ze.innerHTML=ka,It=n(),Ue=m("p"),Ue.innerHTML=va,Xt=n(),Je=m("p"),Je.innerHTML=Ra,kt=n(),y(be.$$.fragment),vt=n(),S=m("div"),S.innerHTML=Ca,Rt=n(),we=m("p"),we.innerHTML=Va,Ct=n(),y(Te.$$.fragment),Vt=n(),je=m("p"),je.textContent=$a,$t=n(),y(We.$$.fragment),xt=n(),y(_e.$$.fragment),Bt=n(),Ge=m("p"),Ge.textContent=xa,Yt=n(),y(A.$$.fragment),Ft=n(),Ie=m("p"),Ie.innerHTML=Ba,Ht=n(),y(Xe.$$.fragment),Nt=n(),ke=m("p"),ke.innerHTML=Ya,Qt=n(),ve=m("ul"),ve.innerHTML=Fa,zt=n(),y(Re.$$.fragment),St=n(),Ce=m("p"),Ce.textContent=Ha,At=n(),y(Ve.$$.fragment),Et=n(),E=m("div"),E.innerHTML=Na,qt=n(),$e=m("p"),$e.innerHTML=Qa,Lt=n(),y(xe.$$.fragment),Pt=n(),q=m("div"),q.innerHTML=za,Dt=n(),y(Be.$$.fragment),Kt=n(),Ye=m("p"),Ye.innerHTML=Sa,Ot=n(),Fe=m("p"),Fe.innerHTML=Aa,ea=n(),y(He.$$.fragment),ta=n(),Ne=m("p"),Ne.innerHTML=Ea,aa=n(),y(Qe.$$.fragment),la=n(),L=m("div"),L.innerHTML=qa,sa=n(),y(ze.$$.fragment),na=n(),Se=m("p"),Se.innerHTML=La,ia=n(),Ae=m("p"),Ae.innerHTML=Pa,pa=n(),y(Ee.$$.fragment),oa=n(),qe=m("p"),qe.textContent=Da,ra=n(),y(Le.$$.fragment),ma=n(),P=m("div"),P.innerHTML=Ka,da=n(),Pe=m("p"),Pe.textContent=Oa,ca=n(),y(De.$$.fragment),ua=n(),D=m("div"),D.innerHTML=el,Ma=n(),Oe=m("p"),this.h()},l(e){const t=cl("svelte-u9bgzb",document.head);p=d(t,"META",{name:!0,content:!0}),t.forEach(a),w=i(e),o=d(e,"P",{}),pl(o).forEach(a),M=i(e),f(G.$$.fragment,e),_=i(e),J=d(e,"P",{"data-svelte-h":!0}),c(J)!=="svelte-rd9njz"&&(J.innerHTML=I),r=i(e),f(T.$$.fragment,e),X=i(e),j=d(e,"P",{"data-svelte-h":!0}),c(j)!=="svelte-1211s0v"&&(j.textContent=k),W=i(e),f(C.$$.fragment,e),u=i(e),s=d(e,"P",{"data-svelte-h":!0}),c(s)!=="svelte-49swfq"&&(s.innerHTML=b),et=i(e),K=d(e,"P",{"data-svelte-h":!0}),c(K)!=="svelte-1pmqs0j"&&(K.innerHTML=ga),tt=i(e),f(B.$$.fragment,e),at=i(e),f(Y.$$.fragment,e),lt=i(e),f(O.$$.fragment,e),st=i(e),ee=d(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-1ytpuar"&&(ee.textContent=ha),nt=i(e),f(te.$$.fragment,e),it=i(e),ae=d(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-csxost"&&(ae.innerHTML=Za),pt=i(e),f(F.$$.fragment,e),ot=i(e),le=d(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-1h2tzec"&&(le.innerHTML=Ua),rt=i(e),f(H.$$.fragment,e),mt=i(e),f(se.$$.fragment,e),dt=i(e),ne=d(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-1nluq5y"&&(ne.innerHTML=Ja),ct=i(e),f(ie.$$.fragment,e),ut=i(e),f(pe.$$.fragment,e),Mt=i(e),oe=d(e,"P",{"data-svelte-h":!0}),c(oe)!=="svelte-18t8qca"&&(oe.textContent=ba),yt=i(e),re=d(e,"P",{"data-svelte-h":!0}),c(re)!=="svelte-ci17qi"&&(re.innerHTML=wa),ft=i(e),f(me.$$.fragment,e),gt=i(e),N=d(e,"DIV",{class:!0,"data-svelte-h":!0}),c(N)!=="svelte-eifaa"&&(N.innerHTML=Ta),ht=i(e),de=d(e,"P",{"data-svelte-h":!0}),c(de)!=="svelte-uxfn1w"&&(de.textContent=ja),Zt=i(e),f(ce.$$.fragment,e),Ut=i(e),Q=d(e,"DIV",{class:!0,"data-svelte-h":!0}),c(Q)!=="svelte-m35a5e"&&(Q.innerHTML=Wa),Jt=i(e),ue=d(e,"P",{"data-svelte-h":!0}),c(ue)!=="svelte-1oy5psd"&&(ue.innerHTML=_a),bt=i(e),f(Me.$$.fragment,e),wt=i(e),z=d(e,"DIV",{class:!0,"data-svelte-h":!0}),c(z)!=="svelte-1rjzzk0"&&(z.innerHTML=Ga),Tt=i(e),f(ye.$$.fragment,e),jt=i(e),fe=d(e,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-3uurtn"&&(fe.textContent=Ia),Wt=i(e),f(ge.$$.fragment,e),_t=i(e),he=d(e,"P",{"data-svelte-h":!0}),c(he)!=="svelte-1hojnjd"&&(he.innerHTML=Xa),Gt=i(e),Ze=d(e,"UL",{"data-svelte-h":!0}),c(Ze)!=="svelte-1a56pqx"&&(Ze.innerHTML=ka),It=i(e),Ue=d(e,"P",{"data-svelte-h":!0}),c(Ue)!=="svelte-1ylc0is"&&(Ue.innerHTML=va),Xt=i(e),Je=d(e,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-1dtaqqk"&&(Je.innerHTML=Ra),kt=i(e),f(be.$$.fragment,e),vt=i(e),S=d(e,"DIV",{class:!0,"data-svelte-h":!0}),c(S)!=="svelte-lbwedl"&&(S.innerHTML=Ca),Rt=i(e),we=d(e,"P",{"data-svelte-h":!0}),c(we)!=="svelte-10x245s"&&(we.innerHTML=Va),Ct=i(e),f(Te.$$.fragment,e),Vt=i(e),je=d(e,"P",{"data-svelte-h":!0}),c(je)!=="svelte-1mw36co"&&(je.textContent=$a),$t=i(e),f(We.$$.fragment,e),xt=i(e),f(_e.$$.fragment,e),Bt=i(e),Ge=d(e,"P",{"data-svelte-h":!0}),c(Ge)!=="svelte-1tk2m7v"&&(Ge.textContent=xa),Yt=i(e),f(A.$$.fragment,e),Ft=i(e),Ie=d(e,"P",{"data-svelte-h":!0}),c(Ie)!=="svelte-qgg0iy"&&(Ie.innerHTML=Ba),Ht=i(e),f(Xe.$$.fragment,e),Nt=i(e),ke=d(e,"P",{"data-svelte-h":!0}),c(ke)!=="svelte-1vw2kqb"&&(ke.innerHTML=Ya),Qt=i(e),ve=d(e,"UL",{"data-svelte-h":!0}),c(ve)!=="svelte-tpz2u9"&&(ve.innerHTML=Fa),zt=i(e),f(Re.$$.fragment,e),St=i(e),Ce=d(e,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-1p6lwr0"&&(Ce.textContent=Ha),At=i(e),f(Ve.$$.fragment,e),Et=i(e),E=d(e,"DIV",{class:!0,"data-svelte-h":!0}),c(E)!=="svelte-im3du6"&&(E.innerHTML=Na),qt=i(e),$e=d(e,"P",{"data-svelte-h":!0}),c($e)!=="svelte-1kkzavx"&&($e.innerHTML=Qa),Lt=i(e),f(xe.$$.fragment,e),Pt=i(e),q=d(e,"DIV",{class:!0,"data-svelte-h":!0}),c(q)!=="svelte-1t1eqqe"&&(q.innerHTML=za),Dt=i(e),f(Be.$$.fragment,e),Kt=i(e),Ye=d(e,"P",{"data-svelte-h":!0}),c(Ye)!=="svelte-1am74qu"&&(Ye.innerHTML=Sa),Ot=i(e),Fe=d(e,"P",{"data-svelte-h":!0}),c(Fe)!=="svelte-ntp5s3"&&(Fe.innerHTML=Aa),ea=i(e),f(He.$$.fragment,e),ta=i(e),Ne=d(e,"P",{"data-svelte-h":!0}),c(Ne)!=="svelte-13u2z8i"&&(Ne.innerHTML=Ea),aa=i(e),f(Qe.$$.fragment,e),la=i(e),L=d(e,"DIV",{class:!0,"data-svelte-h":!0}),c(L)!=="svelte-1cw2b12"&&(L.innerHTML=qa),sa=i(e),f(ze.$$.fragment,e),na=i(e),Se=d(e,"P",{"data-svelte-h":!0}),c(Se)!=="svelte-sz8jif"&&(Se.innerHTML=La),ia=i(e),Ae=d(e,"P",{"data-svelte-h":!0}),c(Ae)!=="svelte-837b2y"&&(Ae.innerHTML=Pa),pa=i(e),f(Ee.$$.fragment,e),oa=i(e),qe=d(e,"P",{"data-svelte-h":!0}),c(qe)!=="svelte-77tfin"&&(qe.textContent=Da),ra=i(e),f(Le.$$.fragment,e),ma=i(e),P=d(e,"DIV",{class:!0,"data-svelte-h":!0}),c(P)!=="svelte-mjuwpp"&&(P.innerHTML=Ka),da=i(e),Pe=d(e,"P",{"data-svelte-h":!0}),c(Pe)!=="svelte-12fzw16"&&(Pe.textContent=Oa),ca=i(e),f(De.$$.fragment,e),ua=i(e),D=d(e,"DIV",{class:!0,"data-svelte-h":!0}),c(D)!=="svelte-kc4794"&&(D.innerHTML=el),Ma=i(e),Oe=d(e,"P",{}),pl(Oe).forEach(a),this.h()},h(){V(p,"name","hf:doc:metadata"),V(p,"content",_l),V(N,"class","flex flex-row gap-4"),V(Q,"class","flex flex-row gap-4"),V(z,"class","flex flex-row gap-4"),V(S,"class","flex flex-row gap-4"),V(E,"class","flex flex-row gap-4"),V(q,"class","flex justify-center"),V(L,"class","flex justify-center"),V(P,"class","flex flex-row gap-4"),V(D,"class","flex justify-center")},m(e,t){ul(document.head,p),l(e,w,t),l(e,o,t),l(e,M,t),g(G,e,t),l(e,_,t),l(e,J,t),l(e,r,t),g(T,e,t),l(e,X,t),l(e,j,t),l(e,W,t),g(C,e,t),l(e,u,t),l(e,s,t),l(e,et,t),l(e,K,t),l(e,tt,t),g(B,e,t),l(e,at,t),g(Y,e,t),l(e,lt,t),g(O,e,t),l(e,st,t),l(e,ee,t),l(e,nt,t),g(te,e,t),l(e,it,t),l(e,ae,t),l(e,pt,t),g(F,e,t),l(e,ot,t),l(e,le,t),l(e,rt,t),g(H,e,t),l(e,mt,t),g(se,e,t),l(e,dt,t),l(e,ne,t),l(e,ct,t),g(ie,e,t),l(e,ut,t),g(pe,e,t),l(e,Mt,t),l(e,oe,t),l(e,yt,t),l(e,re,t),l(e,ft,t),g(me,e,t),l(e,gt,t),l(e,N,t),l(e,ht,t),l(e,de,t),l(e,Zt,t),g(ce,e,t),l(e,Ut,t),l(e,Q,t),l(e,Jt,t),l(e,ue,t),l(e,bt,t),g(Me,e,t),l(e,wt,t),l(e,z,t),l(e,Tt,t),g(ye,e,t),l(e,jt,t),l(e,fe,t),l(e,Wt,t),g(ge,e,t),l(e,_t,t),l(e,he,t),l(e,Gt,t),l(e,Ze,t),l(e,It,t),l(e,Ue,t),l(e,Xt,t),l(e,Je,t),l(e,kt,t),g(be,e,t),l(e,vt,t),l(e,S,t),l(e,Rt,t),l(e,we,t),l(e,Ct,t),g(Te,e,t),l(e,Vt,t),l(e,je,t),l(e,$t,t),g(We,e,t),l(e,xt,t),g(_e,e,t),l(e,Bt,t),l(e,Ge,t),l(e,Yt,t),g(A,e,t),l(e,Ft,t),l(e,Ie,t),l(e,Ht,t),g(Xe,e,t),l(e,Nt,t),l(e,ke,t),l(e,Qt,t),l(e,ve,t),l(e,zt,t),g(Re,e,t),l(e,St,t),l(e,Ce,t),l(e,At,t),g(Ve,e,t),l(e,Et,t),l(e,E,t),l(e,qt,t),l(e,$e,t),l(e,Lt,t),g(xe,e,t),l(e,Pt,t),l(e,q,t),l(e,Dt,t),g(Be,e,t),l(e,Kt,t),l(e,Ye,t),l(e,Ot,t),l(e,Fe,t),l(e,ea,t),g(He,e,t),l(e,ta,t),l(e,Ne,t),l(e,aa,t),g(Qe,e,t),l(e,la,t),l(e,L,t),l(e,sa,t),g(ze,e,t),l(e,na,t),l(e,Se,t),l(e,ia,t),l(e,Ae,t),l(e,pa,t),g(Ee,e,t),l(e,oa,t),l(e,qe,t),l(e,ra,t),g(Le,e,t),l(e,ma,t),l(e,P,t),l(e,da,t),l(e,Pe,t),l(e,ca,t),g(De,e,t),l(e,ua,t),l(e,D,t),l(e,Ma,t),l(e,Oe,t),ya=!0},p(e,[t]){const tl={};t&2&&(tl.$$scope={dirty:t,ctx:e}),T.$set(tl);const al={};t&2&&(al.$$scope={dirty:t,ctx:e}),B.$set(al);const ll={};t&2&&(ll.$$scope={dirty:t,ctx:e}),Y.$set(ll);const sl={};t&2&&(sl.$$scope={dirty:t,ctx:e}),F.$set(sl);const nl={};t&2&&(nl.$$scope={dirty:t,ctx:e}),H.$set(nl);const il={};t&2&&(il.$$scope={dirty:t,ctx:e}),A.$set(il)},i(e){ya||(h(G.$$.fragment,e),h(T.$$.fragment,e),h(C.$$.fragment,e),h(B.$$.fragment,e),h(Y.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),h(F.$$.fragment,e),h(H.$$.fragment,e),h(se.$$.fragment,e),h(ie.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),h(ce.$$.fragment,e),h(Me.$$.fragment,e),h(ye.$$.fragment,e),h(ge.$$.fragment,e),h(be.$$.fragment,e),h(Te.$$.fragment,e),h(We.$$.fragment,e),h(_e.$$.fragment,e),h(A.$$.fragment,e),h(Xe.$$.fragment,e),h(Re.$$.fragment,e),h(Ve.$$.fragment,e),h(xe.$$.fragment,e),h(Be.$$.fragment,e),h(He.$$.fragment,e),h(Qe.$$.fragment,e),h(ze.$$.fragment,e),h(Ee.$$.fragment,e),h(Le.$$.fragment,e),h(De.$$.fragment,e),ya=!0)},o(e){Z(G.$$.fragment,e),Z(T.$$.fragment,e),Z(C.$$.fragment,e),Z(B.$$.fragment,e),Z(Y.$$.fragment,e),Z(O.$$.fragment,e),Z(te.$$.fragment,e),Z(F.$$.fragment,e),Z(H.$$.fragment,e),Z(se.$$.fragment,e),Z(ie.$$.fragment,e),Z(pe.$$.fragment,e),Z(me.$$.fragment,e),Z(ce.$$.fragment,e),Z(Me.$$.fragment,e),Z(ye.$$.fragment,e),Z(ge.$$.fragment,e),Z(be.$$.fragment,e),Z(Te.$$.fragment,e),Z(We.$$.fragment,e),Z(_e.$$.fragment,e),Z(A.$$.fragment,e),Z(Xe.$$.fragment,e),Z(Re.$$.fragment,e),Z(Ve.$$.fragment,e),Z(xe.$$.fragment,e),Z(Be.$$.fragment,e),Z(He.$$.fragment,e),Z(Qe.$$.fragment,e),Z(ze.$$.fragment,e),Z(Ee.$$.fragment,e),Z(Le.$$.fragment,e),Z(De.$$.fragment,e),ya=!1},d(e){e&&(a(w),a(o),a(M),a(_),a(J),a(r),a(X),a(j),a(W),a(u),a(s),a(et),a(K),a(tt),a(at),a(lt),a(st),a(ee),a(nt),a(it),a(ae),a(pt),a(ot),a(le),a(rt),a(mt),a(dt),a(ne),a(ct),a(ut),a(Mt),a(oe),a(yt),a(re),a(ft),a(gt),a(N),a(ht),a(de),a(Zt),a(Ut),a(Q),a(Jt),a(ue),a(bt),a(wt),a(z),a(Tt),a(jt),a(fe),a(Wt),a(_t),a(he),a(Gt),a(Ze),a(It),a(Ue),a(Xt),a(Je),a(kt),a(vt),a(S),a(Rt),a(we),a(Ct),a(Vt),a(je),a($t),a(xt),a(Bt),a(Ge),a(Yt),a(Ft),a(Ie),a(Ht),a(Nt),a(ke),a(Qt),a(ve),a(zt),a(St),a(Ce),a(At),a(Et),a(E),a(qt),a($e),a(Lt),a(Pt),a(q),a(Dt),a(Kt),a(Ye),a(Ot),a(Fe),a(ea),a(ta),a(Ne),a(aa),a(la),a(L),a(sa),a(na),a(Se),a(ia),a(Ae),a(pa),a(oa),a(qe),a(ra),a(ma),a(P),a(da),a(Pe),a(ca),a(ua),a(D),a(Ma),a(Oe)),a(p),U(G,e),U(T,e),U(C,e),U(B,e),U(Y,e),U(O,e),U(te,e),U(F,e),U(H,e),U(se,e),U(ie,e),U(pe,e),U(me,e),U(ce,e),U(Me,e),U(ye,e),U(ge,e),U(be,e),U(Te,e),U(We,e),U(_e,e),U(A,e),U(Xe,e),U(Re,e),U(Ve,e),U(xe,e),U(Be,e),U(He,e),U(Qe,e),U(ze,e),U(Ee,e),U(Le,e),U(De,e)}}}const _l='{"title":"IP-Adapter","local":"ip-adapter","sections":[{"title":"General tasks","local":"general-tasks","sections":[],"depth":2},{"title":"Configure parameters","local":"configure-parameters","sections":[{"title":"Image embeddings","local":"image-embeddings","sections":[],"depth":3},{"title":"IP-Adapter masking","local":"ip-adapter-masking","sections":[],"depth":3}],"depth":2},{"title":"Specific use cases","local":"specific-use-cases","sections":[{"title":"Face model","local":"face-model","sections":[],"depth":3},{"title":"Multi IP-Adapter","local":"multi-ip-adapter","sections":[],"depth":3},{"title":"Instant generation","local":"instant-generation","sections":[],"depth":3},{"title":"Structural control","local":"structural-control","sections":[],"depth":3}],"depth":2}],"depth":1}';function Gl(R){return rl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vl extends ml{constructor(p){super(),dl(this,p,Gl,Wl,ol,{})}}export{Vl as component};
