import{s as za,o as Ha,n as Ba}from"../chunks/scheduler.9bc65507.js";import{S as Ea,i as Na,g as l,s as o,u,A as Aa,h as n,f as t,c as r,j as c,v as d,y as h,k as i,o as p,a,w as m,d as g,t as f,x as y}from"../chunks/index.78c82d43.js";import{T as qa}from"../chunks/Tip.87d55b76.js";import{I as b}from"../chunks/IconCopyLink.bedaa44d.js";import{C as F}from"../chunks/CodeBlock.48618ec2.js";import{D as Fa}from"../chunks/DocNotebookDropdown.40f7599b.js";function Sa(ut){let M,S='If you’re interested in basic LLM usage, our high-level <a href="pipeline_tutorial"><code>Pipeline</code></a> interface is a great starting point. However, LLMs often require advanced features like quantization and fine control of the token selection step, which is best done through <a href="/docs/transformers/v4.33.3/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>. Autoregressive generation with LLMs is also resource-intensive and should be executed on a GPU for adequate throughput.';return{c(){M=l("p"),M.innerHTML=S},l(v){M=n(v,"P",{"data-svelte-h":!0}),h(M)!=="svelte-103k7bb"&&(M.innerHTML=S)},m(v,Ee){a(v,M,Ee)},p:Ba,d(v){v&&t(M)}}}function Qa(ut){let M,S,v,Ee,w,G,et,Q,bs,Ne,Cs="Generation with LLMs",dt,Y,mt,P,Gs="LLMs, or Large Language Models, are the key component behind text generation. In a nutshell, they consist of large pretrained transformer models trained to predict the next word (or, more precisely, token) given some input text. Since they predict one token at a time, you need to do something more elaborate to generate new sentences other than just calling the model — you need to do autoregressive generation.",gt,K,Is='Autoregressive generation is the inference-time procedure of iteratively calling a model with its own generated outputs, given a few initial inputs. In 🤗 Transformers, this is handled by the <a href="/docs/transformers/v4.33.3/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method, which is available to all models with generative capabilities.',ft,D,Ws="This tutorial will show you how to:",yt,O,Vs="<li>Generate text with an LLM</li> <li>Avoid common pitfalls</li> <li>Next steps to help you get the most out of your LLM</li>",Mt,ee,Ls="Before you begin, make sure you have all the necessary libraries installed:",vt,te,bt,j,I,tt,se,ws,Ae,Xs="Generate text",wt,ae,Rs='A language model trained for <a href="tasks/language_modeling">causal language modeling</a> takes a sequence of text tokens as input and returns the probability distribution for the next token.',jt,W,zs='<video style="max-width: 90%; margin: auto;" autoplay="" loop="" muted="" playsinline="" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/assisted-generation/gif_1_1080p.mov"></video> <figcaption>&quot;Forward pass of an LLM&quot;</figcaption>',kt,le,Hs="A critical aspect of autoregressive generation with LLMs is how to select the next token from this probability distribution. Anything goes in this step as long as you end up with a token for the next iteration. This means it can be as simple as selecting the most likely token from the probability distribution or as complex as applying a dozen transformations before sampling from the resulting distribution.",Tt,V,Bs='<video style="max-width: 90%; margin: auto;" autoplay="" loop="" muted="" playsinline="" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/assisted-generation/gif_2_1080p.mov"></video> <figcaption>&quot;Autoregressive generation iteratively selects the next token from a probability distribution to generate text&quot;</figcaption>',_t,ne,Es="The process depicted above is repeated iteratively until some stopping condition is reached. Ideally, the stopping condition is dictated by the model, which should learn when to output an end-of-sequence (<code>EOS</code>) token. If this is not the case, generation stops when some predefined maximum length is reached.",Jt,oe,Ns='Properly setting up the token selection step and the stopping condition is essential to make your model behave as you’d expect on your task. That is why we have a <a href="/docs/transformers/v4.33.3/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> file associated with each model, which contains a good default generative parameterization and is loaded alongside your model.',xt,re,As="Let’s talk code!",Ut,L,Zt,ie,qs="First, you need to load the model.",$t,pe,Ct,he,Fs="You’ll notice two flags in the <code>from_pretrained</code> call:",Gt,ce,Ss='<li><code>device_map</code> ensures the model is moved to your GPU(s)</li> <li><code>load_in_4bit</code> applies <a href="main_classes/quantization">4-bit dynamic quantization</a> to massively reduce the resource requirements</li>',It,ue,Qs="There are other ways to initialize a model, but this is a good baseline to begin with an LLM.",Wt,de,Ys='Next, you need to preprocess your text input with a <a href="tokenizer_summary">tokenizer</a>.',Vt,me,Lt,ge,Ps='The <code>model_inputs</code> variable holds the tokenized text input, as well as the attention mask. While <a href="/docs/transformers/v4.33.3/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> does its best effort to infer the attention mask when it is not passed, we recommend passing it whenever possible for optimal results.',Xt,fe,Ks='Finally, call the <a href="/docs/transformers/v4.33.3/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method to returns the generated tokens, which should be converted to text before printing.',Rt,ye,zt,Me,Ds="And that’s it! In a few lines of code, you can harness the power of an LLM.",Ht,k,X,st,ve,js,qe,Os="Common pitfalls",Bt,be,ea='There are many <a href="generation_strategies">generation strategies</a>, and sometimes the default values may not be appropriate for your use case. If your outputs aren’t aligned with what you’re expecting, we’ve created a list of the most common pitfalls and how to avoid them.',Et,we,Nt,T,R,at,je,ks,Fe,ta="Generated output is too short/long",At,ke,sa='If not specified in the <a href="/docs/transformers/v4.33.3/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> file, <code>generate</code> returns up to 20 tokens by default. We highly recommend manually setting <code>max_new_tokens</code> in your <code>generate</code> call to control the maximum number of new tokens it can return. Keep in mind LLMs (more precisely, <a href="https://huggingface.co/learn/nlp-course/chapter1/6?fw=pt" rel="nofollow">decoder-only models</a>) also return the input prompt as part of the output.',qt,Te,Ft,_,z,lt,_e,Ts,Se,aa="Incorrect generation mode",St,Je,la='By default, and unless specified in the <a href="/docs/transformers/v4.33.3/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> file, <code>generate</code> selects the most likely token at each iteration (greedy decoding). Depending on your task, this may be undesirable; creative tasks like chatbots or writing an essay benefit from sampling. On the other hand, input-grounded tasks like audio transcription or translation benefit from greedy decoding. Enable sampling with <code>do_sample=True</code>, and you can learn more about this topic in this <a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">blog post</a>.',Qt,xe,Yt,J,H,nt,Ue,_s,Qe,na="Wrong padding side",Pt,Ze,oa='LLMs are <a href="https://huggingface.co/learn/nlp-course/chapter1/6?fw=pt" rel="nofollow">decoder-only</a> architectures, meaning they continue to iterate on your input prompt. If your inputs do not have the same length, they need to be padded. Since LLMs are not trained to continue from pad tokens, your input needs to be left-padded. Make sure you also don’t forget to pass the attention mask to generate!',Kt,$e,Dt,x,B,ot,Ce,Js,Ye,ra="Further resources",Ot,Ge,ia="While the autoregressive generation process is relatively straightforward, making the most out of your LLM can be a challenging endeavor because there are many moving parts. For your next steps to help you dive deeper into LLM usage and understanding:",es,U,E,rt,Ie,xs,Pe,pa="Advanced generate usage",ts,We,ha='<li><a href="generation_strategies">Guide</a> on how to control different generation methods, how to set up the generation configuration file, and how to stream the output;</li> <li>API reference on <a href="/docs/transformers/v4.33.3/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>, <a href="/docs/transformers/v4.33.3/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>, and <a href="internal/generation_utils">generate-related classes</a>.</li>',ss,Z,N,it,Ve,Us,Ke,ca="LLM leaderboards",as,Le,ua='<li><a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">Open LLM Leaderboard</a>, which focuses on the quality of the open-source models;</li> <li><a href="https://huggingface.co/spaces/optimum/llm-perf-leaderboard" rel="nofollow">Open LLM-Perf Leaderboard</a>, which focuses on LLM throughput.</li>',ls,$,A,pt,Xe,Zs,De,da="Latency and throughput",ns,Re,ma='<li><a href="main_classes/quantization">Guide</a> on dynamic quantization, which shows you how to drastically reduce your memory requirements.</li>',os,C,q,ht,ze,$s,Oe,ga="Related libraries",rs,He,fa='<li><a href="https://github.com/huggingface/text-generation-inference" rel="nofollow"><code>text-generation-inference</code></a>, a production-ready server for LLMs;</li> <li><a href="https://github.com/huggingface/optimum" rel="nofollow"><code>optimum</code></a>, an extension of 🤗 Transformers that optimizes for specific hardware devices.</li>',is,ct,ps;return Q=new b({}),Y=new Fa({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/llm_tutorial.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/llm_tutorial.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/llm_tutorial.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/llm_tutorial.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/llm_tutorial.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/llm_tutorial.ipynb"}]}}),te=new F({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGJpdHNhbmRieXRlcyUzRSUzRDAuMzkuMCUyMC1x",highlighted:"pip install transformers bitsandbytes&gt;=0.39.0 -q"}}),se=new b({}),L=new qa({props:{$$slots:{default:[Sa]},$$scope:{ctx:ut}}}),pe=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyb3BlbmxtLXJlc2VhcmNoJTJGb3Blbl9sbGFtYV83YiUyMiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;openlm-research/open_llama_7b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`}}),me=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVubG0tcmVzZWFyY2glMkZvcGVuX2xsYW1hXzdiJTIyKSUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJBJTIwbGlzdCUyMG9mJTIwY29sb3JzJTNBJTIwcmVkJTJDJTIwYmx1ZSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openlm-research/open_llama_7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;A list of colors: red, blue&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)`}}),ye=new F({props:{code:"Z2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A list of colors: red, blue, green, yellow, black, white, and brown&#x27;</span>`}}),ve=new b({}),we=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5sbS1yZXNlYXJjaCUyRm9wZW5fbGxhbWFfN2IlMjIpJTBBdG9rZW5pemVyLnBhZF90b2tlbiUyMCUzRCUyMHRva2VuaXplci5lb3NfdG9rZW4lMjAlMjAlMjMlMjBMbGFtYSUyMGhhcyUyMG5vJTIwcGFkJTIwdG9rZW4lMjBieSUyMGRlZmF1bHQlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJvcGVubG0tcmVzZWFyY2glMkZvcGVuX2xsYW1hXzdiJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openlm-research/open_llama_7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token = tokenizer.eos_token  <span class="hljs-comment"># Llama has no pad token by default</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;openlm-research/open_llama_7b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`}}),je=new b({}),Te=new F({props:{code:"bW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkElMjBzZXF1ZW5jZSUyMG9mJTIwbnVtYmVycyUzQSUyMDElMkMlMjAyJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBCeSUyMGRlZmF1bHQlMkMlMjB0aGUlMjBvdXRwdXQlMjB3aWxsJTIwY29udGFpbiUyMHVwJTIwdG8lMjAyMCUyMHRva2VucyUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwU2V0dGluZyUyMCU2MG1heF9uZXdfdG9rZW5zJTYwJTIwYWxsb3dzJTIweW91JTIwdG8lMjBjb250cm9sJTIwdGhlJTIwbWF4aW11bSUyMGxlbmd0aCUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNENTApJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;A sequence of numbers: 1, 2&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the output will contain up to 20 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A sequence of numbers: 1, 2, 3, 4, 5&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Setting \`max_new_tokens\` allows you to control the maximum length</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, max_new_tokens=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A sequence of numbers: 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,&#x27;</span>`}}),_e=new b({}),xe=new F({props:{code:"JTIzJTIwU2V0JTIwc2VlZCUyMG9yJTIwcmVwcm9kdWNpYmlsaXR5JTIwLS0lMjB5b3UlMjBkb24ndCUyMG5lZWQlMjB0aGlzJTIwdW5sZXNzJTIweW91JTIwd2FudCUyMGZ1bGwlMjByZXByb2R1Y2liaWxpdHklMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwc2V0X3NlZWQlMEFzZXRfc2VlZCgwKSUwQSUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJJJTIwYW0lMjBhJTIwY2F0LiUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTIzJTIwTExNJTIwJTJCJTIwZ3JlZWR5JTIwZGVjb2RpbmclMjAlM0QlMjByZXBldGl0aXZlJTJDJTIwYm9yaW5nJTIwb3V0cHV0JTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQlMEElMEElMjMlMjBXaXRoJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBiZWNvbWVzJTIwbW9yZSUyMGNyZWF0aXZlISUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Set seed or reproducibility -- you don&#x27;t need this unless you want full reproducibility</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;I am a cat.&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># LLM + greedy decoding = repetitive, boring output</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;I am a cat. I am a cat. I am a cat. I am a cat&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output becomes more creative!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;I am a cat.\\nI just need to be. I am always.\\nEvery time&#x27;</span>`}}),Ue=new b({}),$e=new F({props:{code:"JTIzJTIwVGhlJTIwdG9rZW5pemVyJTIwaW5pdGlhbGl6ZWQlMjBhYm92ZSUyMGhhcyUyMHJpZ2h0LXBhZGRpbmclMjBhY3RpdmUlMjBieSUyMGRlZmF1bHQlM0ElMjB0aGUlMjAxc3QlMjBzZXF1ZW5jZSUyQyUwQSUyMyUyMHdoaWNoJTIwaXMlMjBzaG9ydGVyJTJDJTIwaGFzJTIwcGFkZGluZyUyMG9uJTIwdGhlJTIwcmlnaHQlMjBzaWRlLiUyMEdlbmVyYXRpb24lMjBmYWlscy4lMEFtb2RlbF9pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwJTVCJTIyMSUyQyUyMDIlMkMlMjAzJTIyJTJDJTIwJTIyQSUyQyUyMEIlMkMlMjBDJTJDJTIwRCUyQyUyMEUlMjIlNUQlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpLnRvKCUyMmN1ZGElMjIpJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwV2l0aCUyMGxlZnQtcGFkZGluZyUyQyUyMGl0JTIwd29ya3MlMjBhcyUyMGV4cGVjdGVkISUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5sbS1yZXNlYXJjaCUyRm9wZW5fbGxhbWFfN2IlMjIlMkMlMjBwYWRkaW5nX3NpZGUlM0QlMjJsZWZ0JTIyKSUwQXRva2VuaXplci5wYWRfdG9rZW4lMjAlM0QlMjB0b2tlbml6ZXIuZW9zX3Rva2VuJTIwJTIwJTIzJTIwTGxhbWElMjBoYXMlMjBubyUyMHBhZCUyMHRva2VuJTIwYnklMjBkZWZhdWx0JTBBbW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCU1QiUyMjElMkMlMjAyJTJDJTIwMyUyMiUyQyUyMCUyMkElMkMlMjBCJTJDJTIwQyUyQyUyMEQlMkMlMjBFJTIyJTVEJTJDJTIwcGFkZGluZyUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTBBKS50byglMjJjdWRhJTIyKSUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># The tokenizer initialized above has right-padding active by default: the 1st sequence,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># which is shorter, has padding on the right side. Generation fails.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;1, 2, 3&quot;</span>, <span class="hljs-string">&quot;A, B, C, D, E&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With left-padding, it works as expected!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openlm-research/open_llama_7b&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token = tokenizer.eos_token  <span class="hljs-comment"># Llama has no pad token by default</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;1, 2, 3&quot;</span>, <span class="hljs-string">&quot;A, B, C, D, E&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;1, 2, 3, 4, 5, 6,&#x27;</span>`}}),Ce=new b({}),Ie=new b({}),Ve=new b({}),Xe=new b({}),ze=new b({}),{c(){M=l("meta"),S=o(),v=l("p"),Ee=o(),w=l("h1"),G=l("a"),et=l("span"),u(Q.$$.fragment),bs=o(),Ne=l("span"),Ne.textContent=Cs,dt=o(),u(Y.$$.fragment),mt=o(),P=l("p"),P.textContent=Gs,gt=o(),K=l("p"),K.innerHTML=Is,ft=o(),D=l("p"),D.textContent=Ws,yt=o(),O=l("ul"),O.innerHTML=Vs,Mt=o(),ee=l("p"),ee.textContent=Ls,vt=o(),u(te.$$.fragment),bt=o(),j=l("h2"),I=l("a"),tt=l("span"),u(se.$$.fragment),ws=o(),Ae=l("span"),Ae.textContent=Xs,wt=o(),ae=l("p"),ae.innerHTML=Rs,jt=o(),W=l("figure"),W.innerHTML=zs,kt=o(),le=l("p"),le.textContent=Hs,Tt=o(),V=l("figure"),V.innerHTML=Bs,_t=o(),ne=l("p"),ne.innerHTML=Es,Jt=o(),oe=l("p"),oe.innerHTML=Ns,xt=o(),re=l("p"),re.textContent=As,Ut=o(),u(L.$$.fragment),Zt=o(),ie=l("p"),ie.textContent=qs,$t=o(),u(pe.$$.fragment),Ct=o(),he=l("p"),he.innerHTML=Fs,Gt=o(),ce=l("ul"),ce.innerHTML=Ss,It=o(),ue=l("p"),ue.textContent=Qs,Wt=o(),de=l("p"),de.innerHTML=Ys,Vt=o(),u(me.$$.fragment),Lt=o(),ge=l("p"),ge.innerHTML=Ps,Xt=o(),fe=l("p"),fe.innerHTML=Ks,Rt=o(),u(ye.$$.fragment),zt=o(),Me=l("p"),Me.textContent=Ds,Ht=o(),k=l("h2"),X=l("a"),st=l("span"),u(ve.$$.fragment),js=o(),qe=l("span"),qe.textContent=Os,Bt=o(),be=l("p"),be.innerHTML=ea,Et=o(),u(we.$$.fragment),Nt=o(),T=l("h3"),R=l("a"),at=l("span"),u(je.$$.fragment),ks=o(),Fe=l("span"),Fe.textContent=ta,At=o(),ke=l("p"),ke.innerHTML=sa,qt=o(),u(Te.$$.fragment),Ft=o(),_=l("h3"),z=l("a"),lt=l("span"),u(_e.$$.fragment),Ts=o(),Se=l("span"),Se.textContent=aa,St=o(),Je=l("p"),Je.innerHTML=la,Qt=o(),u(xe.$$.fragment),Yt=o(),J=l("h3"),H=l("a"),nt=l("span"),u(Ue.$$.fragment),_s=o(),Qe=l("span"),Qe.textContent=na,Pt=o(),Ze=l("p"),Ze.innerHTML=oa,Kt=o(),u($e.$$.fragment),Dt=o(),x=l("h2"),B=l("a"),ot=l("span"),u(Ce.$$.fragment),Js=o(),Ye=l("span"),Ye.textContent=ra,Ot=o(),Ge=l("p"),Ge.textContent=ia,es=o(),U=l("h3"),E=l("a"),rt=l("span"),u(Ie.$$.fragment),xs=o(),Pe=l("span"),Pe.textContent=pa,ts=o(),We=l("ol"),We.innerHTML=ha,ss=o(),Z=l("h3"),N=l("a"),it=l("span"),u(Ve.$$.fragment),Us=o(),Ke=l("span"),Ke.textContent=ca,as=o(),Le=l("ol"),Le.innerHTML=ua,ls=o(),$=l("h3"),A=l("a"),pt=l("span"),u(Xe.$$.fragment),Zs=o(),De=l("span"),De.textContent=da,ns=o(),Re=l("ol"),Re.innerHTML=ma,os=o(),C=l("h3"),q=l("a"),ht=l("span"),u(ze.$$.fragment),$s=o(),Oe=l("span"),Oe.textContent=ga,rs=o(),He=l("ol"),He.innerHTML=fa,is=o(),ct=l("p"),this.h()},l(e){const s=Aa("svelte-1phssyn",document.head);M=n(s,"META",{name:!0,content:!0}),s.forEach(t),S=r(e),v=n(e,"P",{}),c(v).forEach(t),Ee=r(e),w=n(e,"H1",{class:!0});var Be=c(w);G=n(Be,"A",{id:!0,class:!0,href:!0});var ya=c(G);et=n(ya,"SPAN",{});var Ma=c(et);d(Q.$$.fragment,Ma),Ma.forEach(t),ya.forEach(t),bs=r(Be),Ne=n(Be,"SPAN",{"data-svelte-h":!0}),h(Ne)!=="svelte-10gj10b"&&(Ne.textContent=Cs),Be.forEach(t),dt=r(e),d(Y.$$.fragment,e),mt=r(e),P=n(e,"P",{"data-svelte-h":!0}),h(P)!=="svelte-tihwde"&&(P.textContent=Gs),gt=r(e),K=n(e,"P",{"data-svelte-h":!0}),h(K)!=="svelte-10yl2xg"&&(K.innerHTML=Is),ft=r(e),D=n(e,"P",{"data-svelte-h":!0}),h(D)!=="svelte-1g5tmp7"&&(D.textContent=Ws),yt=r(e),O=n(e,"UL",{"data-svelte-h":!0}),h(O)!=="svelte-jbjjoq"&&(O.innerHTML=Vs),Mt=r(e),ee=n(e,"P",{"data-svelte-h":!0}),h(ee)!=="svelte-1c9nexd"&&(ee.textContent=Ls),vt=r(e),d(te.$$.fragment,e),bt=r(e),j=n(e,"H2",{class:!0});var hs=c(j);I=n(hs,"A",{id:!0,class:!0,href:!0});var va=c(I);tt=n(va,"SPAN",{});var ba=c(tt);d(se.$$.fragment,ba),ba.forEach(t),va.forEach(t),ws=r(hs),Ae=n(hs,"SPAN",{"data-svelte-h":!0}),h(Ae)!=="svelte-1d6uffh"&&(Ae.textContent=Xs),hs.forEach(t),wt=r(e),ae=n(e,"P",{"data-svelte-h":!0}),h(ae)!=="svelte-e3t4o0"&&(ae.innerHTML=Rs),jt=r(e),W=n(e,"FIGURE",{class:!0,"data-svelte-h":!0}),h(W)!=="svelte-hjgddv"&&(W.innerHTML=zs),kt=r(e),le=n(e,"P",{"data-svelte-h":!0}),h(le)!=="svelte-1qja5m9"&&(le.textContent=Hs),Tt=r(e),V=n(e,"FIGURE",{class:!0,"data-svelte-h":!0}),h(V)!=="svelte-1uqc9hk"&&(V.innerHTML=Bs),_t=r(e),ne=n(e,"P",{"data-svelte-h":!0}),h(ne)!=="svelte-pprvht"&&(ne.innerHTML=Es),Jt=r(e),oe=n(e,"P",{"data-svelte-h":!0}),h(oe)!=="svelte-dns0os"&&(oe.innerHTML=Ns),xt=r(e),re=n(e,"P",{"data-svelte-h":!0}),h(re)!=="svelte-1wpt61n"&&(re.textContent=As),Ut=r(e),d(L.$$.fragment,e),Zt=r(e),ie=n(e,"P",{"data-svelte-h":!0}),h(ie)!=="svelte-17lmqvk"&&(ie.textContent=qs),$t=r(e),d(pe.$$.fragment,e),Ct=r(e),he=n(e,"P",{"data-svelte-h":!0}),h(he)!=="svelte-1ibsgq1"&&(he.innerHTML=Fs),Gt=r(e),ce=n(e,"UL",{"data-svelte-h":!0}),h(ce)!=="svelte-1ut1fuh"&&(ce.innerHTML=Ss),It=r(e),ue=n(e,"P",{"data-svelte-h":!0}),h(ue)!=="svelte-14llc8d"&&(ue.textContent=Qs),Wt=r(e),de=n(e,"P",{"data-svelte-h":!0}),h(de)!=="svelte-9uk3l0"&&(de.innerHTML=Ys),Vt=r(e),d(me.$$.fragment,e),Lt=r(e),ge=n(e,"P",{"data-svelte-h":!0}),h(ge)!=="svelte-1a6gi20"&&(ge.innerHTML=Ps),Xt=r(e),fe=n(e,"P",{"data-svelte-h":!0}),h(fe)!=="svelte-18ayxf1"&&(fe.innerHTML=Ks),Rt=r(e),d(ye.$$.fragment,e),zt=r(e),Me=n(e,"P",{"data-svelte-h":!0}),h(Me)!=="svelte-wj0v9f"&&(Me.textContent=Ds),Ht=r(e),k=n(e,"H2",{class:!0});var cs=c(k);X=n(cs,"A",{id:!0,class:!0,href:!0});var wa=c(X);st=n(wa,"SPAN",{});var ja=c(st);d(ve.$$.fragment,ja),ja.forEach(t),wa.forEach(t),js=r(cs),qe=n(cs,"SPAN",{"data-svelte-h":!0}),h(qe)!=="svelte-w1iz9d"&&(qe.textContent=Os),cs.forEach(t),Bt=r(e),be=n(e,"P",{"data-svelte-h":!0}),h(be)!=="svelte-1h0ongv"&&(be.innerHTML=ea),Et=r(e),d(we.$$.fragment,e),Nt=r(e),T=n(e,"H3",{class:!0});var us=c(T);R=n(us,"A",{id:!0,class:!0,href:!0});var ka=c(R);at=n(ka,"SPAN",{});var Ta=c(at);d(je.$$.fragment,Ta),Ta.forEach(t),ka.forEach(t),ks=r(us),Fe=n(us,"SPAN",{"data-svelte-h":!0}),h(Fe)!=="svelte-vpk62m"&&(Fe.textContent=ta),us.forEach(t),At=r(e),ke=n(e,"P",{"data-svelte-h":!0}),h(ke)!=="svelte-r0sqgf"&&(ke.innerHTML=sa),qt=r(e),d(Te.$$.fragment,e),Ft=r(e),_=n(e,"H3",{class:!0});var ds=c(_);z=n(ds,"A",{id:!0,class:!0,href:!0});var _a=c(z);lt=n(_a,"SPAN",{});var Ja=c(lt);d(_e.$$.fragment,Ja),Ja.forEach(t),_a.forEach(t),Ts=r(ds),Se=n(ds,"SPAN",{"data-svelte-h":!0}),h(Se)!=="svelte-1uk4mc1"&&(Se.textContent=aa),ds.forEach(t),St=r(e),Je=n(e,"P",{"data-svelte-h":!0}),h(Je)!=="svelte-17sq5ol"&&(Je.innerHTML=la),Qt=r(e),d(xe.$$.fragment,e),Yt=r(e),J=n(e,"H3",{class:!0});var ms=c(J);H=n(ms,"A",{id:!0,class:!0,href:!0});var xa=c(H);nt=n(xa,"SPAN",{});var Ua=c(nt);d(Ue.$$.fragment,Ua),Ua.forEach(t),xa.forEach(t),_s=r(ms),Qe=n(ms,"SPAN",{"data-svelte-h":!0}),h(Qe)!=="svelte-1fnbx9c"&&(Qe.textContent=na),ms.forEach(t),Pt=r(e),Ze=n(e,"P",{"data-svelte-h":!0}),h(Ze)!=="svelte-1n0cu3a"&&(Ze.innerHTML=oa),Kt=r(e),d($e.$$.fragment,e),Dt=r(e),x=n(e,"H2",{class:!0});var gs=c(x);B=n(gs,"A",{id:!0,class:!0,href:!0});var Za=c(B);ot=n(Za,"SPAN",{});var $a=c(ot);d(Ce.$$.fragment,$a),$a.forEach(t),Za.forEach(t),Js=r(gs),Ye=n(gs,"SPAN",{"data-svelte-h":!0}),h(Ye)!=="svelte-elmtyk"&&(Ye.textContent=ra),gs.forEach(t),Ot=r(e),Ge=n(e,"P",{"data-svelte-h":!0}),h(Ge)!=="svelte-1w0my5d"&&(Ge.textContent=ia),es=r(e),U=n(e,"H3",{class:!0});var fs=c(U);E=n(fs,"A",{id:!0,class:!0,href:!0});var Ca=c(E);rt=n(Ca,"SPAN",{});var Ga=c(rt);d(Ie.$$.fragment,Ga),Ga.forEach(t),Ca.forEach(t),xs=r(fs),Pe=n(fs,"SPAN",{"data-svelte-h":!0}),h(Pe)!=="svelte-165r4gp"&&(Pe.textContent=pa),fs.forEach(t),ts=r(e),We=n(e,"OL",{"data-svelte-h":!0}),h(We)!=="svelte-1xatbkm"&&(We.innerHTML=ha),ss=r(e),Z=n(e,"H3",{class:!0});var ys=c(Z);N=n(ys,"A",{id:!0,class:!0,href:!0});var Ia=c(N);it=n(Ia,"SPAN",{});var Wa=c(it);d(Ve.$$.fragment,Wa),Wa.forEach(t),Ia.forEach(t),Us=r(ys),Ke=n(ys,"SPAN",{"data-svelte-h":!0}),h(Ke)!=="svelte-17k83v2"&&(Ke.textContent=ca),ys.forEach(t),as=r(e),Le=n(e,"OL",{"data-svelte-h":!0}),h(Le)!=="svelte-x6edjm"&&(Le.innerHTML=ua),ls=r(e),$=n(e,"H3",{class:!0});var Ms=c($);A=n(Ms,"A",{id:!0,class:!0,href:!0});var Va=c(A);pt=n(Va,"SPAN",{});var La=c(pt);d(Xe.$$.fragment,La),La.forEach(t),Va.forEach(t),Zs=r(Ms),De=n(Ms,"SPAN",{"data-svelte-h":!0}),h(De)!=="svelte-1tblqg"&&(De.textContent=da),Ms.forEach(t),ns=r(e),Re=n(e,"OL",{"data-svelte-h":!0}),h(Re)!=="svelte-1i949qg"&&(Re.innerHTML=ma),os=r(e),C=n(e,"H3",{class:!0});var vs=c(C);q=n(vs,"A",{id:!0,class:!0,href:!0});var Xa=c(q);ht=n(Xa,"SPAN",{});var Ra=c(ht);d(ze.$$.fragment,Ra),Ra.forEach(t),Xa.forEach(t),$s=r(vs),Oe=n(vs,"SPAN",{"data-svelte-h":!0}),h(Oe)!=="svelte-1gqms33"&&(Oe.textContent=ga),vs.forEach(t),rs=r(e),He=n(e,"OL",{"data-svelte-h":!0}),h(He)!=="svelte-e8l3du"&&(He.innerHTML=fa),is=r(e),ct=n(e,"P",{}),c(ct).forEach(t),this.h()},h(){i(M,"name","hf:doc:metadata"),i(M,"content",JSON.stringify(Ya)),i(G,"id","generation-with-llms"),i(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(G,"href","#generation-with-llms"),i(w,"class","relative group"),i(I,"id","generate-text"),i(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(I,"href","#generate-text"),i(j,"class","relative group"),i(W,"class","image table text-center m-0 w-full"),i(V,"class","image table text-center m-0 w-full"),i(X,"id","common-pitfalls"),i(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(X,"href","#common-pitfalls"),i(k,"class","relative group"),i(R,"id","generated-output-is-too-shortlong"),i(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(R,"href","#generated-output-is-too-shortlong"),i(T,"class","relative group"),i(z,"id","incorrect-generation-mode"),i(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(z,"href","#incorrect-generation-mode"),i(_,"class","relative group"),i(H,"id","wrong-padding-side"),i(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(H,"href","#wrong-padding-side"),i(J,"class","relative group"),i(B,"id","further-resources"),i(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(B,"href","#further-resources"),i(x,"class","relative group"),i(E,"id","advanced-generate-usage"),i(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(E,"href","#advanced-generate-usage"),i(U,"class","relative group"),i(N,"id","llm-leaderboards"),i(N,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(N,"href","#llm-leaderboards"),i(Z,"class","relative group"),i(A,"id","latency-and-throughput"),i(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(A,"href","#latency-and-throughput"),i($,"class","relative group"),i(q,"id","related-libraries"),i(q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(q,"href","#related-libraries"),i(C,"class","relative group")},m(e,s){p(document.head,M),a(e,S,s),a(e,v,s),a(e,Ee,s),a(e,w,s),p(w,G),p(G,et),m(Q,et,null),p(w,bs),p(w,Ne),a(e,dt,s),m(Y,e,s),a(e,mt,s),a(e,P,s),a(e,gt,s),a(e,K,s),a(e,ft,s),a(e,D,s),a(e,yt,s),a(e,O,s),a(e,Mt,s),a(e,ee,s),a(e,vt,s),m(te,e,s),a(e,bt,s),a(e,j,s),p(j,I),p(I,tt),m(se,tt,null),p(j,ws),p(j,Ae),a(e,wt,s),a(e,ae,s),a(e,jt,s),a(e,W,s),a(e,kt,s),a(e,le,s),a(e,Tt,s),a(e,V,s),a(e,_t,s),a(e,ne,s),a(e,Jt,s),a(e,oe,s),a(e,xt,s),a(e,re,s),a(e,Ut,s),m(L,e,s),a(e,Zt,s),a(e,ie,s),a(e,$t,s),m(pe,e,s),a(e,Ct,s),a(e,he,s),a(e,Gt,s),a(e,ce,s),a(e,It,s),a(e,ue,s),a(e,Wt,s),a(e,de,s),a(e,Vt,s),m(me,e,s),a(e,Lt,s),a(e,ge,s),a(e,Xt,s),a(e,fe,s),a(e,Rt,s),m(ye,e,s),a(e,zt,s),a(e,Me,s),a(e,Ht,s),a(e,k,s),p(k,X),p(X,st),m(ve,st,null),p(k,js),p(k,qe),a(e,Bt,s),a(e,be,s),a(e,Et,s),m(we,e,s),a(e,Nt,s),a(e,T,s),p(T,R),p(R,at),m(je,at,null),p(T,ks),p(T,Fe),a(e,At,s),a(e,ke,s),a(e,qt,s),m(Te,e,s),a(e,Ft,s),a(e,_,s),p(_,z),p(z,lt),m(_e,lt,null),p(_,Ts),p(_,Se),a(e,St,s),a(e,Je,s),a(e,Qt,s),m(xe,e,s),a(e,Yt,s),a(e,J,s),p(J,H),p(H,nt),m(Ue,nt,null),p(J,_s),p(J,Qe),a(e,Pt,s),a(e,Ze,s),a(e,Kt,s),m($e,e,s),a(e,Dt,s),a(e,x,s),p(x,B),p(B,ot),m(Ce,ot,null),p(x,Js),p(x,Ye),a(e,Ot,s),a(e,Ge,s),a(e,es,s),a(e,U,s),p(U,E),p(E,rt),m(Ie,rt,null),p(U,xs),p(U,Pe),a(e,ts,s),a(e,We,s),a(e,ss,s),a(e,Z,s),p(Z,N),p(N,it),m(Ve,it,null),p(Z,Us),p(Z,Ke),a(e,as,s),a(e,Le,s),a(e,ls,s),a(e,$,s),p($,A),p(A,pt),m(Xe,pt,null),p($,Zs),p($,De),a(e,ns,s),a(e,Re,s),a(e,os,s),a(e,C,s),p(C,q),p(q,ht),m(ze,ht,null),p(C,$s),p(C,Oe),a(e,rs,s),a(e,He,s),a(e,is,s),a(e,ct,s),ps=!0},p(e,[s]){const Be={};s&2&&(Be.$$scope={dirty:s,ctx:e}),L.$set(Be)},i(e){ps||(g(Q.$$.fragment,e),g(Y.$$.fragment,e),g(te.$$.fragment,e),g(se.$$.fragment,e),g(L.$$.fragment,e),g(pe.$$.fragment,e),g(me.$$.fragment,e),g(ye.$$.fragment,e),g(ve.$$.fragment,e),g(we.$$.fragment,e),g(je.$$.fragment,e),g(Te.$$.fragment,e),g(_e.$$.fragment,e),g(xe.$$.fragment,e),g(Ue.$$.fragment,e),g($e.$$.fragment,e),g(Ce.$$.fragment,e),g(Ie.$$.fragment,e),g(Ve.$$.fragment,e),g(Xe.$$.fragment,e),g(ze.$$.fragment,e),ps=!0)},o(e){f(Q.$$.fragment,e),f(Y.$$.fragment,e),f(te.$$.fragment,e),f(se.$$.fragment,e),f(L.$$.fragment,e),f(pe.$$.fragment,e),f(me.$$.fragment,e),f(ye.$$.fragment,e),f(ve.$$.fragment,e),f(we.$$.fragment,e),f(je.$$.fragment,e),f(Te.$$.fragment,e),f(_e.$$.fragment,e),f(xe.$$.fragment,e),f(Ue.$$.fragment,e),f($e.$$.fragment,e),f(Ce.$$.fragment,e),f(Ie.$$.fragment,e),f(Ve.$$.fragment,e),f(Xe.$$.fragment,e),f(ze.$$.fragment,e),ps=!1},d(e){e&&(t(S),t(v),t(Ee),t(w),t(dt),t(mt),t(P),t(gt),t(K),t(ft),t(D),t(yt),t(O),t(Mt),t(ee),t(vt),t(bt),t(j),t(wt),t(ae),t(jt),t(W),t(kt),t(le),t(Tt),t(V),t(_t),t(ne),t(Jt),t(oe),t(xt),t(re),t(Ut),t(Zt),t(ie),t($t),t(Ct),t(he),t(Gt),t(ce),t(It),t(ue),t(Wt),t(de),t(Vt),t(Lt),t(ge),t(Xt),t(fe),t(Rt),t(zt),t(Me),t(Ht),t(k),t(Bt),t(be),t(Et),t(Nt),t(T),t(At),t(ke),t(qt),t(Ft),t(_),t(St),t(Je),t(Qt),t(Yt),t(J),t(Pt),t(Ze),t(Kt),t(Dt),t(x),t(Ot),t(Ge),t(es),t(U),t(ts),t(We),t(ss),t(Z),t(as),t(Le),t(ls),t($),t(ns),t(Re),t(os),t(C),t(rs),t(He),t(is),t(ct)),t(M),y(Q),y(Y,e),y(te,e),y(se),y(L,e),y(pe,e),y(me,e),y(ye,e),y(ve),y(we,e),y(je),y(Te,e),y(_e),y(xe,e),y(Ue),y($e,e),y(Ce),y(Ie),y(Ve),y(Xe),y(ze)}}}const Ya={local:"generation-with-llms",sections:[{local:"generate-text",title:"Generate text"},{local:"common-pitfalls",sections:[{local:"generated-output-is-too-shortlong",title:"Generated output is too short/long"},{local:"incorrect-generation-mode",title:"Incorrect generation mode"},{local:"wrong-padding-side",title:"Wrong padding side"}],title:"Common pitfalls"},{local:"further-resources",sections:[{local:"advanced-generate-usage",title:"Advanced generate usage"},{local:"llm-leaderboards",title:"LLM leaderboards"},{local:"latency-and-throughput",title:"Latency and throughput"},{local:"related-libraries",title:"Related libraries"}],title:"Further resources"}],title:"Generation with LLMs"};function Pa(ut){return Ha(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class al extends Ea{constructor(M){super(),Na(this,M,Pa,Qa,za,{})}}export{al as component};
