import{s as dn,o as cn,n as go}from"../chunks/scheduler.9bc65507.js";import{S as mn,i as pn,g as n,s as a,u as _,A as fn,h as s,f as t,c as r,j as u,v as g,y as d,k as m,o,a as i,w as k,d as b,t as v,x as y}from"../chunks/index.78c82d43.js";import{T as hn}from"../chunks/Tip.87d55b76.js";import{D as U}from"../chunks/Docstring.f3d04bd2.js";import{C as at}from"../chunks/CodeBlock.48618ec2.js";import{I as Pt}from"../chunks/IconCopyLink.bedaa44d.js";import{E as ln}from"../chunks/ExampleCodeBlock.872b014d.js";function un(R){let c,$="The <code>Llama2</code> family models, on which Code Llama is based, were trained using <code>bfloat16</code>, but the original inference uses <code>float16</code>. Let’s look at the different precisions:",h,T,C="<li><code>float32</code>: PyTorch convention on model initialization is to load models in <code>float32</code>, no matter with which <code>dtype</code> the model weights were stored. <code>transformers</code> also follows this convention for consistency with PyTorch. This will be picked by default. If you want the <code>AutoModel</code> API to cast the load the checkpoints with the storage weights type, you must specify <code>torch_dtype=&quot;auto&quot;</code>, e.g. <code>model = AutoModelForCausalLM.from_pretrained(&quot;path&quot;, torch_dtype = &quot;auto&quot;)</code>.</li> <li><code>bfloat16</code>: Code Llama was trained with this precision, so we recommend using it for further training or fine-tuning.</li> <li><code>float16</code>: We recommend running inference using this precision, as it’s usually faster than <code>bfloat16</code>, and evaluation metrics show no discernible degradation with respect to <code>bfloat16</code>. You can also run inference using <code>bfloat16</code>, and we recommend you check inference results with both <code>float16</code> and <code>bfloat16</code> after fine-tuning.</li>",p,L,I="As mentioned above, the <code>dtype</code> of the storage weights is mostly irrelevant unless you are using <code>torch_dtype=&quot;auto&quot;</code> when initializing a model using. The reason is that the model will first be downloaded (using the <code>dtype</code> of the checkpoints online) and then will be casted to the default <code>dtype</code> of <code>torch</code> (becomes <code>torch.float32</code>). If there is a specified <code>torch_dtype</code>, it will be used instead.";return{c(){c=n("p"),c.innerHTML=$,h=a(),T=n("ul"),T.innerHTML=C,p=a(),L=n("p"),L.innerHTML=I},l(M){c=s(M,"P",{"data-svelte-h":!0}),d(c)!=="svelte-8yf686"&&(c.innerHTML=$),h=r(M),T=s(M,"UL",{"data-svelte-h":!0}),d(T)!=="svelte-17c64tm"&&(T.innerHTML=C),p=r(M),L=s(M,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1bzil5i"&&(L.innerHTML=I)},m(M,q){i(M,c,q),i(M,h,q),i(M,T,q),i(M,p,q),i(M,L,q)},p:go,d(M){M&&(t(c),t(h),t(T),t(p),t(L))}}}function _n(R){let c,$="sequence pair mask has the following format:",h,T,C;return T=new at({props:{code:"MCUyMDAlMjAwJTIwMCUyMDAlMjAwJTIwMCUyMDAlMjAwJTIwMCUyMDAlMjAxJTIwMSUyMDElMjAxJTIwMSUyMDElMjAxJTIwMSUyMDElMEElN0MlMjBmaXJzdCUyMHNlcXVlbmNlJTIwJTIwJTIwJTIwJTdDJTIwc2Vjb25kJTIwc2VxdWVuY2UlMjAlN0M=",highlighted:`0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1 1
| first sequence    | second sequence |`}}),{c(){c=n("p"),c.textContent=$,h=a(),_(T.$$.fragment)},l(p){c=s(p,"P",{"data-svelte-h":!0}),d(c)!=="svelte-16klr56"&&(c.textContent=$),h=r(p),g(T.$$.fragment,p)},m(p,L){i(p,c,L),i(p,h,L),k(T,p,L),C=!0},p:go,i(p){C||(b(T.$$.fragment,p),C=!0)},o(p){v(T.$$.fragment,p),C=!1},d(p){p&&(t(c),t(h)),y(T,p)}}}function gn(R){let c,$;return c=new at({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENvZGVMbGFtYVRva2VuaXplckZhc3QlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBDb2RlTGxhbWFUb2tlbml6ZXJGYXN0LmZyb21fcHJldHJhaW5lZCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGxhbWEtdG9rZW5pemVyJTIyKSUwQXRva2VuaXplci5lbmNvZGUoJTIySGVsbG8lMjB0aGlzJTIwaXMlMjBhJTIwdGVzdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CodeLlamaTokenizerFast

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = CodeLlamaTokenizerFast.from_pretrained(<span class="hljs-string">&quot;hf-internal-testing/llama-tokenizer&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.encode(<span class="hljs-string">&quot;Hello this is a test&quot;</span>)
[<span class="hljs-number">1</span>, <span class="hljs-number">15043</span>, <span class="hljs-number">445</span>, <span class="hljs-number">338</span>, <span class="hljs-number">263</span>, <span class="hljs-number">1243</span>]`}}),{c(){_(c.$$.fragment)},l(h){g(c.$$.fragment,h)},m(h,T){k(c,h,T),$=!0},p:go,i(h){$||(b(c.$$.fragment,h),$=!0)},o(h){v(c.$$.fragment,h),$=!1},d(h){y(c,h)}}}function kn(R){let c,$,h,T,C,p,L,I,M,q,ko="CodeLlama",rt,P,N,Ke,O,At,ze,bo="Overview",lt,K,vo='The Code Llama model was proposed in <a href="https://ai.meta.com/research/publications/code-llama-open-foundation-models-for-code/" rel="nofollow">Code Llama: Open Foundation Models for Code</a> by Baptiste Rozière, Jonas Gehring, Fabian Gloeckle, Sten Sootla, Itai Gat, Xiaoqing Ellen Tan, Yossi Adi, Jingyu Liu, Tal Remez, Jérémy Rapin, Artyom Kozhevnikov, Ivan Evtimov, Joanna Bitton, Manish Bhatt, Cristian Canton Ferrer, Aaron Grattafiori, Wenhan Xiong, Alexandre Défossez, Jade Copet, Faisal Azhar, Hugo Touvron, Louis Martin, Nicolas Usunier, Thomas Scialom, Gabriel Synnaeve.',it,ee,yo="The abstract from the paper is the following:",dt,te,To="<em>We release Code Llama, a family of large language models for code based on Llama 2 providing state-of-the-art performance among open models, infilling capabilities, support for large input contexts, and zero-shot instruction following ability for programming tasks. We provide multiple flavors to cover a wide range of applications: foundation models (Code Llama), Python specializations (Code Llama - Python), and instruction-following models (Code Llama - Instruct) with 7B, 13B and 34B parameters each. All models are trained on sequences of 16k tokens and show improvements on inputs with up to 100k tokens. 7B and 13B Code Llama and Code Llama - Instruct variants support infilling based on surrounding content. Code Llama reaches state-of-the-art performance among open models on several code benchmarks, with scores of up to 53% and 55% on HumanEval and MBPP, respectively. Notably, Code Llama - Python 7B outperforms Llama 2 70B on HumanEval and MBPP, and all our models outperform every other publicly available model on MultiPL-E. We release Code Llama under a permissive license that allows for both research and commercial use.</em>",ct,oe,wo='Check out all Code Llama models <a href="https://huggingface.co/models?search=code_llama" rel="nofollow">here</a> and the officially released ones in the <a href="https://huggingface.co/codellama" rel="nofollow">codellama org</a>.',mt,S,pt,ne,xo="Tips:",ft,se,Co="<li>These models have the same architecture as the <code>Llama2</code> models</li> <li>The infilling task is supported out of the box. You should be using the <code>tokenizer.fill_token</code> where you want your input to be filled.</li> <li>The model conversion script is the same as for the <code>Llama2</code> family:</li>",ht,ae,Lo="Here is a sample usage",ut,re,_t,le,Mo=`Note that executing the script requires enough CPU RAM to host the whole model in float16 precision (even if the biggest versions
come in several checkpoints they each contain a part of each weight of the model, so we need to load them all in RAM).`,gt,ie,$o="<li>After conversion, the model and tokenizer can be loaded via:</li>",kt,de,bt,ce,zo="If you only want the infilled part:",vt,me,yt,pe,jo='Under the hood, the tokenizer <a href="https://huggingface.co/docs/transformers/main/model_doc/code_llama#transformers.CodeLlamaTokenizer.fill_token" rel="nofollow">automatically splits by <code>&lt;FILL_ME&gt;</code></a> to create a formatted input string that follows <a href="https://github.com/facebookresearch/codellama/blob/cb51c14ec761370ba2e2bc351374a79265d0465e/llama/generation.py#L402" rel="nofollow">the original training pattern</a>. This is more robust than preparing the pattern yourself: it avoids pitfalls, such as token glueing, that are very hard to debug.  To see how much CPU and GPU memory you need for this model or others, try <a href="https://huggingface.co/spaces/hf-accelerate/model-memory-usage" rel="nofollow">this calculator</a> which can help determine that value.',Tt,fe,qo='<li>The LLaMA tokenizer is a BPE model based on <a href="https://github.com/google/sentencepiece" rel="nofollow">sentencepiece</a>. One quirk of sentencepiece is that when decoding a sequence, if the first token is the start of the word (e.g. “Banana”), the tokenizer does not prepend the prefix space to the string.</li>',wt,he,Fo='This model was contributed by <a href="https://huggingface.co/ArthurZ" rel="nofollow">ArthurZucker</a>. The original code of the authors can be found <a href="https://github.com/facebookresearch/llama" rel="nofollow">here</a>.',xt,A,Z,et,ue,Ht,je,Uo="CodeLlamaTokenizer",Ct,x,_e,Rt,qe,Io=`Construct a CodeLlama tokenizer. Based on byte-level Byte-Pair-Encoding. The default padding token is unset as
there is no padding token in the original model.`,Nt,Fe,Eo=`The default configuration match that of
<a href="https://huggingface.co/codellama/CodeLlama-7b-Instruct-hf/blob/main/tokenizer_config.json" rel="nofollow">codellama/CodeLlama-7b-Instruct-hf</a>
which supports prompt infilling.`,St,Ue,ge,Zt,B,ke,Bt,Ie,Jo=`Retrieve sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> method.`,Dt,F,be,Gt,Ee,Po="Creates a mask from the two sequences passed to be used in a sequence-pair classification task. An ALBERT",Vt,D,Wt,Je,Ao="if token_ids_1 is None, only returns the first portion of the mask (0s).",Xt,G,ve,Yt,Pe,Ho="Save the vocabulary and special tokens file to a directory.",Lt,H,V,tt,ye,Qt,Ae,Ro="CodeLlamaTokenizerFast",Mt,f,Te,Ot,He,No="Construct a Llama tokenizer. Based on byte-level Byte-Pair-Encoding.",Kt,Re,So="This uses notably ByteFallback and no normalization.",eo,W,to,Ne,Zo=`If you want to change the <code>bos_token</code> or the <code>eos_token</code>, make sure to specify them when initializing the model, or
call <code>tokenizer.update_post_processor()</code> to make sure that the post-processing is correctly done (otherwise the
values of the first token and final token of an encoded sequence will not be correct). For more details, checkout
[post-processors] (<a href="https://huggingface.co/docs/tokenizers/api/post-processors" rel="nofollow">https://huggingface.co/docs/tokenizers/api/post-processors</a>) documentation.`,oo,Se,Bo=`This tokenizer inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods. The default configuration match that of
<a href="https://huggingface.co/codellama/CodeLlama-7b-Instruct-hf/blob/main/tokenizer_config.json" rel="nofollow">codellama/CodeLlama-7b-Instruct-hf</a>
which supports prompt infilling.`,no,z,we,so,Ze,Do=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. The special tokens depend on calling set_lang.`,ao,Be,Go="An NLLB sequence has the following format, where <code>X</code> represents the sequence:",ro,De,Vo="<li><code>input_ids</code> (for encoder) <code>X [eos, src_lang_code]</code></li> <li><code>decoder_input_ids</code>: (for decoder) <code>X [eos, tgt_lang_code]</code></li>",lo,Ge,Wo=`BOS is never used. Pairs of sequences are not the expected use case, but they will be handled without a
separator.`,io,X,xe,co,Ve,Xo=`Retrieves sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> or <code>encode_plus</code> methods.`,mo,E,Ce,po,We,Yo=`Create the token type IDs corresponding to the sequences passed. <a href="../glossary#token-type-ids">What are token type
IDs?</a>`,fo,Xe,Qo="Should be overridden in a subclass if the model has a special way of building those.",ho,Y,Le,uo,Ye,Oo="Updates the underlying post processor with the current <code>bos_token</code> and <code>eos_token</code>.",_o,Qe,Me,$t,ot,zt;return I=new Pt({}),O=new Pt({}),S=new hn({props:{warning:!0,$$slots:{default:[un]},$$scope:{ctx:R}}}),re=new at({props:{code:"cHl0aG9uJTIwc3JjJTJGdHJhbnNmb3JtZXJzJTJGbW9kZWxzJTJGbGxhbWElMkZjb252ZXJ0X2xsYW1hX3dlaWdodHNfdG9faGYucHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLWlucHV0X2RpciUyMCUyRnBhdGglMkZ0byUyRmRvd25sb2FkZWQlMkZsbGFtYSUyRndlaWdodHMlMjAtLW1vZGVsX3NpemUlMjA3QiUyMC0tb3V0cHV0X2RpciUyMCUyRm91dHB1dCUyRnBhdGg=",highlighted:`python src/transformers/models/llama/convert_llama_weights_to_hf.py \\
    --input_dir /path/to/downloaded/llama/weights --model_size 7B --output_dir /output/path`}}),de=new at({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hRm9yQ2F1c2FsTE0lMkMlMjBDb2RlTGxhbWFUb2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBDb2RlTGxhbWFUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmNvZGVsbGFtYSUyRkNvZGVMbGFtYS03Yi1oZiUyMiklMEFtb2RlbCUyMCUzRCUyMExsYW1hRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmNvZGVsbGFtYSUyRkNvZGVMbGFtYS03Yi1oZiUyMiklMEFQUk9NUFQlMjAlM0QlMjAnJydkZWYlMjByZW1vdmVfbm9uX2FzY2lpKHMlM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQWlucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplcihQUk9NUFQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSU1QiUyMmlucHV0X2lkcyUyMiU1RCUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dF9pZHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEyOCklMEElMEFmaWxsaW5nJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTVCJTNBJTJDJTIwaW5wdXRfaWRzLnNoYXBlJTVCMSU1RCUzQSU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlMjAlM0QlMjBUcnVlKSU1QjAlNUQlMEFwcmludChQUk9NUFQucmVwbGFjZSglMjIlM0NGSUxMX01FJTNFJTIyJTJDJTIwZmlsbGluZykpJTBBJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlamaForCausalLM, CodeLlamaTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = CodeLlamaTokenizer.from_pretrained(<span class="hljs-string">&quot;codellama/CodeLlama-7b-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlamaForCausalLM.from_pretrained(<span class="hljs-string">&quot;codellama/CodeLlama-7b-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>PROMPT = <span class="hljs-string">&#x27;&#x27;&#x27;def remove_non_ascii(s: str) -&gt; str:
    &quot;&quot;&quot; &lt;FILL_ME&gt;
    return result
&#x27;&#x27;&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(PROMPT, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(input_ids, max_new_tokens=<span class="hljs-number">128</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>filling = tokenizer.batch_decode(generated_ids[:, input_ids.shape[<span class="hljs-number">1</span>]:], skip_special_tokens = <span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(PROMPT.replace(<span class="hljs-string">&quot;&lt;FILL_ME&gt;&quot;</span>, filling))
<span class="hljs-keyword">def</span> <span class="hljs-title function_">remove_non_ascii</span>(<span class="hljs-params">s: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot; Remove non-ASCII characters from a string.

    Args:
        s: The string to remove non-ASCII characters from.

    Returns:
        The string with non-ASCII characters removed.
    &quot;&quot;&quot;</span>
    result = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">for</span> c <span class="hljs-keyword">in</span> s:
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">ord</span>(c) &lt; <span class="hljs-number">128</span>:
            result += c
    <span class="hljs-keyword">return</span> result`}}),me=new at({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFnZW5lcmF0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkNtb2RlbCUzRCUyMmNvZGVsbGFtYSUyRkNvZGVMbGFtYS03Yi1oZiUyMiUyQ3RvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyKSUwQWdlbmVyYXRvcignZGVmJTIwcmVtb3ZlX25vbl9hc2NpaShzJTNBJTIwc3RyKSUyMC0lM0UlMjBzdHIlM0ElNUNuJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTIwJTNDRklMTF9NRSUzRSU1Q24lMjAlMjAlMjAlMjByZXR1cm4lMjByZXN1bHQnJTJDJTIwbWF4X25ld190b2tlbnMlMjAlM0QlMjAxMjglMkMlMjByZXR1cm5fdHlwZSUyMCUzRCUyMDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>,model=<span class="hljs-string">&quot;codellama/CodeLlama-7b-hf&quot;</span>,torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generator(<span class="hljs-string">&#x27;def remove_non_ascii(s: str) -&gt; str:\\n    &quot;&quot;&quot; &lt;FILL_ME&gt;\\n    return result&#x27;</span>, max_new_tokens = <span class="hljs-number">128</span>, return_type = <span class="hljs-number">1</span>)`}}),ue=new Pt({}),_e=new U({props:{name:"class transformers.CodeLlamaTokenizer",anchor:"transformers.CodeLlamaTokenizer",parameters:[{name:"vocab_file",val:""},{name:"unk_token",val:" = '<unk>'"},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"prefix_token",val:" = '▁<PRE>'"},{name:"middle_token",val:" = '▁<MID>'"},{name:"suffix_token",val:" = '▁<SUF>'"},{name:"eot_token",val:" = '▁<EOT>'"},{name:"fill_token",val:" = '<FILL_ME>'"},{name:"suffix_first",val:" = False"},{name:"sp_model_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"add_bos_token",val:" = True"},{name:"add_eos_token",val:" = False"},{name:"clean_up_tokenization_spaces",val:" = False"},{name:"additional_special_tokens",val:" = None"},{name:"use_default_system_prompt",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.CodeLlamaTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.CodeLlamaTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.CodeLlamaTokenizer.prefix_token",description:`<strong>prefix_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;PRE&gt;&quot;</code>) &#x2014;
Prefix token used for infilling.`,name:"prefix_token"},{anchor:"transformers.CodeLlamaTokenizer.suffix_token",description:`<strong>suffix_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;SUF&gt;&quot;</code>) &#x2014;
Suffix token used for infilling.`,name:"suffix_token"},{anchor:"transformers.CodeLlamaTokenizer.middle_token",description:`<strong>middle_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;MID&gt;&quot;</code>) &#x2014;
Middle token used for infilling.`,name:"middle_token"},{anchor:"transformers.CodeLlamaTokenizer.eot_token",description:`<strong>eot_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;EOT&gt;&quot;</code>) &#x2014;
End of text token used for infilling.`,name:"eot_token"},{anchor:"transformers.CodeLlamaTokenizer.fill_token",description:`<strong>fill_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;FILL_ME&gt;&quot;</code>) &#x2014;
The token used to split the input between the prefix and suffix.`,name:"fill_token"},{anchor:"transformers.CodeLlamaTokenizer.suffix_first",description:`<strong>suffix_first</strong> (<code>bool</code>, <em>optional</em>, default to <code>False</code>) &#x2014;
Whether the input prompt and suffix should be formatted with the suffix first.`,name:"suffix_first"},{anchor:"transformers.CodeLlamaTokenizer.additional_special_tokens",description:`<strong>additional_special_tokens</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Additional special tokens used by the tokenizer.`,name:"additional_special_tokens"},{anchor:"transformers.CodeLlamaTokenizer.sp_model_kwargs",description:`<strong>sp_model_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Will be passed to the <code>SentencePieceProcessor.__init__()</code> method. The <a href="https://github.com/google/sentencepiece/tree/master/python" rel="nofollow">Python wrapper for
SentencePiece</a> can be used, among other things,
to set:</p>
<ul>
<li>
<p><code>enable_sampling</code>: Enable subword regularization.</p>
</li>
<li>
<p><code>nbest_size</code>: Sampling parameters for unigram. Invalid for BPE-Dropout.</p>
<ul>
<li><code>nbest_size = {0,1}</code>: No sampling is performed.</li>
<li><code>nbest_size &gt; 1</code>: samples from the nbest_size results.</li>
<li><code>nbest_size &lt; 0</code>: assuming that nbest_size is infinite and samples from the all hypothesis (lattice)
using forward-filtering-and-backward-sampling algorithm.</li>
</ul>
</li>
<li>
<p><code>alpha</code>: Smoothing parameter for unigram sampling, and dropout probability of merge operations for
BPE-dropout.</p>
</li>
</ul>`,name:"sp_model_kwargs"},{anchor:"transformers.CodeLlamaTokenizer.use_default_system_prompt",description:`<strong>use_default_system_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the default system prompt for Llama should be used.`,name:"use_default_system_prompt"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/code_llama/tokenization_code_llama.py#L62"}}),ge=new U({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.CodeLlamaTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:""},{name:"token_ids_1",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/code_llama/tokenization_code_llama.py#L361"}}),ke=new U({props:{name:"get_special_tokens_mask",anchor:"transformers.CodeLlamaTokenizer.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizer.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.CodeLlamaTokenizer.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"},{anchor:"transformers.CodeLlamaTokenizer.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/code_llama/tokenization_code_llama.py#L373",returnDescription:`
<p>A list of integers in the range [0, 1]: 1 for a special token, 0 for a sequence token.</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),be=new U({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.CodeLlamaTokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizer.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of ids.`,name:"token_ids_0"},{anchor:"transformers.CodeLlamaTokenizer.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/code_llama/tokenization_code_llama.py#L411",returnDescription:`
<p>List of <a href="../glossary#token-type-ids">token type IDs</a> according to the given sequence(s).</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),D=new ln({props:{anchor:"transformers.CodeLlamaTokenizer.create_token_type_ids_from_sequences.example",$$slots:{default:[_n]},$$scope:{ctx:R}}}),ve=new U({props:{name:"save_vocabulary",anchor:"transformers.CodeLlamaTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:""},{name:"filename_prefix",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizer.save_vocabulary.save_directory",description:`<strong>save_directory</strong> (<code>str</code>) &#x2014;
The directory in which to save the vocabulary.`,name:"save_directory"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/code_llama/tokenization_code_llama.py#L333",returnDescription:`
<p>Paths to the files saved.</p>
`,returnType:`
<p><code>Tuple(str)</code></p>
`}}),ye=new Pt({}),Te=new U({props:{name:"class transformers.CodeLlamaTokenizerFast",anchor:"transformers.CodeLlamaTokenizerFast",parameters:[{name:"vocab_file",val:" = None"},{name:"tokenizer_file",val:" = None"},{name:"clean_up_tokenization_spaces",val:" = False"},{name:"unk_token",val:" = '<unk>'"},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"prefix_token",val:" = '▁<PRE>'"},{name:"middle_token",val:" = '▁<MID>'"},{name:"suffix_token",val:" = '▁<SUF>'"},{name:"eot_token",val:" = '▁<EOT>'"},{name:"fill_token",val:" = '<FILL_ME>'"},{name:"additional_special_tokens",val:" = None"},{name:"add_bos_token",val:" = True"},{name:"add_eos_token",val:" = False"},{name:"use_default_system_prompt",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizerFast.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
<a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a> file (generally has a .model extension) that
contains the vocabulary necessary to instantiate a tokenizer.`,name:"vocab_file"},{anchor:"transformers.CodeLlamaTokenizerFast.tokenizer_file",description:`<strong>tokenizer_file</strong> (<code>str</code>) &#x2014;
<a href="https://github.com/huggingface/tokenizers" rel="nofollow">tokenizers</a> file (generally has a .json extension) that
contains everything needed to load the tokenizer.`,name:"tokenizer_file"},{anchor:"transformers.CodeLlamaTokenizerFast.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Wether to cleanup spaces after decoding, cleanup consists in removing potential artifacts like extra
spaces.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.CodeLlamaTokenizerFast.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.`,name:"bos_token"},{anchor:"transformers.CodeLlamaTokenizerFast.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.`,name:"eos_token"},{anchor:"transformers.CodeLlamaTokenizerFast.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.CodeLlamaTokenizerFast.prefix_token",description:`<strong>prefix_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;PRE&gt;&quot;</code>) &#x2014;
Prefix token used for infilling.`,name:"prefix_token"},{anchor:"transformers.CodeLlamaTokenizerFast.suffix_token",description:`<strong>suffix_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;SUF&gt;&quot;</code>) &#x2014;
Suffix token used for infilling.`,name:"suffix_token"},{anchor:"transformers.CodeLlamaTokenizerFast.middle_token",description:`<strong>middle_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;MID&gt;&quot;</code>) &#x2014;
Middle token used for infilling.`,name:"middle_token"},{anchor:"transformers.CodeLlamaTokenizerFast.eot_token",description:`<strong>eot_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&#x2581;&lt;EOT&gt;&quot;</code>) &#x2014;
End of text token used for infilling.`,name:"eot_token"},{anchor:"transformers.CodeLlamaTokenizerFast.fill_token",description:`<strong>fill_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;FILL_ME&gt;&quot;</code>) &#x2014;
The token used to split the input between the prefix and suffix.`,name:"fill_token"},{anchor:"transformers.CodeLlamaTokenizerFast.suffix_first",description:`<strong>suffix_first</strong> (<code>bool</code>, <em>optional</em>, default to <code>False</code>) &#x2014;
Whether the input prompt and suffix should be formatted with the suffix first.`,name:"suffix_first"},{anchor:"transformers.CodeLlamaTokenizerFast.additional_special_tokens",description:`<strong>additional_special_tokens</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Additional special tokens used by the tokenizer.`,name:"additional_special_tokens"},{anchor:"transformers.CodeLlamaTokenizerFast.use_default_system_prompt",description:`<strong>use_default_system_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the default system prompt for Llama should be used.`,name:"use_default_system_prompt"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/code_llama/tokenization_code_llama_fast.py#L55"}}),W=new ln({props:{anchor:"transformers.CodeLlamaTokenizerFast.example",$$slots:{default:[gn]},$$scope:{ctx:R}}}),we=new U({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.CodeLlamaTokenizerFast.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizerFast.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.CodeLlamaTokenizerFast.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/code_llama/tokenization_code_llama_fast.py#L336",returnDescription:`
<p>list of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),xe=new U({props:{name:"get_special_tokens_mask",anchor:"transformers.CodeLlamaTokenizerFast.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizerFast.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of ids of the first sequence.`,name:"token_ids_0"},{anchor:"transformers.CodeLlamaTokenizerFast.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
List of ids of the second sequence.`,name:"token_ids_1"},{anchor:"transformers.CodeLlamaTokenizerFast.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/tokenization_utils_base.py#L3566",returnDescription:`
<p>1 for a special token, 0 for a sequence token.</p>
`,returnType:`
<p>A list of integers in the range [0, 1]</p>
`}}),Ce=new U({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.CodeLlamaTokenizerFast.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.CodeLlamaTokenizerFast.create_token_type_ids_from_sequences.token_ids_0",description:"<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014; The first tokenized sequence.",name:"token_ids_0"},{anchor:"transformers.CodeLlamaTokenizerFast.create_token_type_ids_from_sequences.token_ids_1",description:"<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014; The second tokenized sequence.",name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/tokenization_utils_base.py#L3101",returnDescription:`
<p>The token type ids.</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),Le=new U({props:{name:"update_post_processor",anchor:"transformers.CodeLlamaTokenizerFast.update_post_processor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/code_llama/tokenization_code_llama_fast.py#L178"}}),Me=new U({props:{name:"save_vocabulary",anchor:"transformers.CodeLlamaTokenizerFast.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/code_llama/tokenization_code_llama_fast.py#L317"}}),{c(){c=n("meta"),$=a(),h=n("p"),T=a(),C=n("h1"),p=n("a"),L=n("span"),_(I.$$.fragment),M=a(),q=n("span"),q.textContent=ko,rt=a(),P=n("h2"),N=n("a"),Ke=n("span"),_(O.$$.fragment),At=a(),ze=n("span"),ze.textContent=bo,lt=a(),K=n("p"),K.innerHTML=vo,it=a(),ee=n("p"),ee.textContent=yo,dt=a(),te=n("p"),te.innerHTML=To,ct=a(),oe=n("p"),oe.innerHTML=wo,mt=a(),_(S.$$.fragment),pt=a(),ne=n("p"),ne.textContent=xo,ft=a(),se=n("ul"),se.innerHTML=Co,ht=a(),ae=n("p"),ae.textContent=Lo,ut=a(),_(re.$$.fragment),_t=a(),le=n("p"),le.textContent=Mo,gt=a(),ie=n("ul"),ie.innerHTML=$o,kt=a(),_(de.$$.fragment),bt=a(),ce=n("p"),ce.textContent=zo,vt=a(),_(me.$$.fragment),yt=a(),pe=n("p"),pe.innerHTML=jo,Tt=a(),fe=n("ul"),fe.innerHTML=qo,wt=a(),he=n("p"),he.innerHTML=Fo,xt=a(),A=n("h2"),Z=n("a"),et=n("span"),_(ue.$$.fragment),Ht=a(),je=n("span"),je.textContent=Uo,Ct=a(),x=n("div"),_(_e.$$.fragment),Rt=a(),qe=n("p"),qe.textContent=Io,Nt=a(),Fe=n("p"),Fe.innerHTML=Eo,St=a(),Ue=n("div"),_(ge.$$.fragment),Zt=a(),B=n("div"),_(ke.$$.fragment),Bt=a(),Ie=n("p"),Ie.innerHTML=Jo,Dt=a(),F=n("div"),_(be.$$.fragment),Gt=a(),Ee=n("p"),Ee.textContent=Po,Vt=a(),_(D.$$.fragment),Wt=a(),Je=n("p"),Je.textContent=Ao,Xt=a(),G=n("div"),_(ve.$$.fragment),Yt=a(),Pe=n("p"),Pe.textContent=Ho,Lt=a(),H=n("h2"),V=n("a"),tt=n("span"),_(ye.$$.fragment),Qt=a(),Ae=n("span"),Ae.textContent=Ro,Mt=a(),f=n("div"),_(Te.$$.fragment),Ot=a(),He=n("p"),He.textContent=No,Kt=a(),Re=n("p"),Re.textContent=So,eo=a(),_(W.$$.fragment),to=a(),Ne=n("p"),Ne.innerHTML=Zo,oo=a(),Se=n("p"),Se.innerHTML=Bo,no=a(),z=n("div"),_(we.$$.fragment),so=a(),Ze=n("p"),Ze.textContent=Do,ao=a(),Be=n("p"),Be.innerHTML=Go,ro=a(),De=n("ul"),De.innerHTML=Vo,lo=a(),Ge=n("p"),Ge.textContent=Wo,io=a(),X=n("div"),_(xe.$$.fragment),co=a(),Ve=n("p"),Ve.innerHTML=Xo,mo=a(),E=n("div"),_(Ce.$$.fragment),po=a(),We=n("p"),We.innerHTML=Yo,fo=a(),Xe=n("p"),Xe.textContent=Qo,ho=a(),Y=n("div"),_(Le.$$.fragment),uo=a(),Ye=n("p"),Ye.innerHTML=Oo,_o=a(),Qe=n("div"),_(Me.$$.fragment),$t=a(),ot=n("p"),this.h()},l(e){const l=fn("svelte-1phssyn",document.head);c=s(l,"META",{name:!0,content:!0}),l.forEach(t),$=r(e),h=s(e,"P",{}),u(h).forEach(t),T=r(e),C=s(e,"H1",{class:!0});var $e=u(C);p=s($e,"A",{id:!0,class:!0,href:!0});var nt=u(p);L=s(nt,"SPAN",{});var st=u(L);g(I.$$.fragment,st),st.forEach(t),nt.forEach(t),M=r($e),q=s($e,"SPAN",{"data-svelte-h":!0}),d(q)!=="svelte-1wz1vb5"&&(q.textContent=ko),$e.forEach(t),rt=r(e),P=s(e,"H2",{class:!0});var jt=u(P);N=s(jt,"A",{id:!0,class:!0,href:!0});var Ko=u(N);Ke=s(Ko,"SPAN",{});var en=u(Ke);g(O.$$.fragment,en),en.forEach(t),Ko.forEach(t),At=r(jt),ze=s(jt,"SPAN",{"data-svelte-h":!0}),d(ze)!=="svelte-1jsw1pg"&&(ze.textContent=bo),jt.forEach(t),lt=r(e),K=s(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-1s05gbs"&&(K.innerHTML=vo),it=r(e),ee=s(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-vfdo9a"&&(ee.textContent=yo),dt=r(e),te=s(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-mbr49z"&&(te.innerHTML=To),ct=r(e),oe=s(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-h8tmfu"&&(oe.innerHTML=wo),mt=r(e),g(S.$$.fragment,e),pt=r(e),ne=s(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-axv494"&&(ne.textContent=xo),ft=r(e),se=s(e,"UL",{"data-svelte-h":!0}),d(se)!=="svelte-1molplc"&&(se.innerHTML=Co),ht=r(e),ae=s(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-eidtfm"&&(ae.textContent=Lo),ut=r(e),g(re.$$.fragment,e),_t=r(e),le=s(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-1ovdf29"&&(le.textContent=Mo),gt=r(e),ie=s(e,"UL",{"data-svelte-h":!0}),d(ie)!=="svelte-yjbkch"&&(ie.innerHTML=$o),kt=r(e),g(de.$$.fragment,e),bt=r(e),ce=s(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-cm0lfz"&&(ce.textContent=zo),vt=r(e),g(me.$$.fragment,e),yt=r(e),pe=s(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-xefpq6"&&(pe.innerHTML=jo),Tt=r(e),fe=s(e,"UL",{"data-svelte-h":!0}),d(fe)!=="svelte-1xmggxn"&&(fe.innerHTML=qo),wt=r(e),he=s(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-z5ta87"&&(he.innerHTML=Fo),xt=r(e),A=s(e,"H2",{class:!0});var qt=u(A);Z=s(qt,"A",{id:!0,class:!0,href:!0});var tn=u(Z);et=s(tn,"SPAN",{});var on=u(et);g(ue.$$.fragment,on),on.forEach(t),tn.forEach(t),Ht=r(qt),je=s(qt,"SPAN",{"data-svelte-h":!0}),d(je)!=="svelte-1fvap6s"&&(je.textContent=Uo),qt.forEach(t),Ct=r(e),x=s(e,"DIV",{class:!0});var j=u(x);g(_e.$$.fragment,j),Rt=r(j),qe=s(j,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-1vmwvh5"&&(qe.textContent=Io),Nt=r(j),Fe=s(j,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-1thmlao"&&(Fe.innerHTML=Eo),St=r(j),Ue=s(j,"DIV",{class:!0});var nn=u(Ue);g(ge.$$.fragment,nn),nn.forEach(t),Zt=r(j),B=s(j,"DIV",{class:!0});var Ft=u(B);g(ke.$$.fragment,Ft),Bt=r(Ft),Ie=s(Ft,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-1f4f5kp"&&(Ie.innerHTML=Jo),Ft.forEach(t),Dt=r(j),F=s(j,"DIV",{class:!0});var Q=u(F);g(be.$$.fragment,Q),Gt=r(Q),Ee=s(Q,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-13bfd60"&&(Ee.textContent=Po),Vt=r(Q),g(D.$$.fragment,Q),Wt=r(Q),Je=s(Q,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-wtrslu"&&(Je.textContent=Ao),Q.forEach(t),Xt=r(j),G=s(j,"DIV",{class:!0});var Ut=u(G);g(ve.$$.fragment,Ut),Yt=r(Ut),Pe=s(Ut,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-1slb66l"&&(Pe.textContent=Ho),Ut.forEach(t),j.forEach(t),Lt=r(e),H=s(e,"H2",{class:!0});var It=u(H);V=s(It,"A",{id:!0,class:!0,href:!0});var sn=u(V);tt=s(sn,"SPAN",{});var an=u(tt);g(ye.$$.fragment,an),an.forEach(t),sn.forEach(t),Qt=r(It),Ae=s(It,"SPAN",{"data-svelte-h":!0}),d(Ae)!=="svelte-17l88z2"&&(Ae.textContent=Ro),It.forEach(t),Mt=r(e),f=s(e,"DIV",{class:!0});var w=u(f);g(Te.$$.fragment,w),Ot=r(w),He=s(w,"P",{"data-svelte-h":!0}),d(He)!=="svelte-15tdcz8"&&(He.textContent=No),Kt=r(w),Re=s(w,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-llhmpa"&&(Re.textContent=So),eo=r(w),g(W.$$.fragment,w),to=r(w),Ne=s(w,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-cnb6q1"&&(Ne.innerHTML=Zo),oo=r(w),Se=s(w,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-159s6zy"&&(Se.innerHTML=Bo),no=r(w),z=s(w,"DIV",{class:!0});var J=u(z);g(we.$$.fragment,J),so=r(J),Ze=s(J,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-1vll0v2"&&(Ze.textContent=Do),ao=r(J),Be=s(J,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-90np8u"&&(Be.innerHTML=Go),ro=r(J),De=s(J,"UL",{"data-svelte-h":!0}),d(De)!=="svelte-mlrsks"&&(De.innerHTML=Vo),lo=r(J),Ge=s(J,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-46aam0"&&(Ge.textContent=Wo),J.forEach(t),io=r(w),X=s(w,"DIV",{class:!0});var Et=u(X);g(xe.$$.fragment,Et),co=r(Et),Ve=s(Et,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-1wmjg8a"&&(Ve.innerHTML=Xo),Et.forEach(t),mo=r(w),E=s(w,"DIV",{class:!0});var Oe=u(E);g(Ce.$$.fragment,Oe),po=r(Oe),We=s(Oe,"P",{"data-svelte-h":!0}),d(We)!=="svelte-zj1vf1"&&(We.innerHTML=Yo),fo=r(Oe),Xe=s(Oe,"P",{"data-svelte-h":!0}),d(Xe)!=="svelte-9vptpw"&&(Xe.textContent=Qo),Oe.forEach(t),ho=r(w),Y=s(w,"DIV",{class:!0});var Jt=u(Y);g(Le.$$.fragment,Jt),uo=r(Jt),Ye=s(Jt,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-nfci2w"&&(Ye.innerHTML=Oo),Jt.forEach(t),_o=r(w),Qe=s(w,"DIV",{class:!0});var rn=u(Qe);g(Me.$$.fragment,rn),rn.forEach(t),w.forEach(t),$t=r(e),ot=s(e,"P",{}),u(ot).forEach(t),this.h()},h(){m(c,"name","hf:doc:metadata"),m(c,"content",JSON.stringify(bn)),m(p,"id","codellama"),m(p,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(p,"href","#codellama"),m(C,"class","relative group"),m(N,"id","overview"),m(N,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(N,"href","#overview"),m(P,"class","relative group"),m(Z,"id","transformers.CodeLlamaTokenizer"),m(Z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(Z,"href","#transformers.CodeLlamaTokenizer"),m(A,"class","relative group"),m(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(V,"id","transformers.CodeLlamaTokenizerFast"),m(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(V,"href","#transformers.CodeLlamaTokenizerFast"),m(H,"class","relative group"),m(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(f,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,l){o(document.head,c),i(e,$,l),i(e,h,l),i(e,T,l),i(e,C,l),o(C,p),o(p,L),k(I,L,null),o(C,M),o(C,q),i(e,rt,l),i(e,P,l),o(P,N),o(N,Ke),k(O,Ke,null),o(P,At),o(P,ze),i(e,lt,l),i(e,K,l),i(e,it,l),i(e,ee,l),i(e,dt,l),i(e,te,l),i(e,ct,l),i(e,oe,l),i(e,mt,l),k(S,e,l),i(e,pt,l),i(e,ne,l),i(e,ft,l),i(e,se,l),i(e,ht,l),i(e,ae,l),i(e,ut,l),k(re,e,l),i(e,_t,l),i(e,le,l),i(e,gt,l),i(e,ie,l),i(e,kt,l),k(de,e,l),i(e,bt,l),i(e,ce,l),i(e,vt,l),k(me,e,l),i(e,yt,l),i(e,pe,l),i(e,Tt,l),i(e,fe,l),i(e,wt,l),i(e,he,l),i(e,xt,l),i(e,A,l),o(A,Z),o(Z,et),k(ue,et,null),o(A,Ht),o(A,je),i(e,Ct,l),i(e,x,l),k(_e,x,null),o(x,Rt),o(x,qe),o(x,Nt),o(x,Fe),o(x,St),o(x,Ue),k(ge,Ue,null),o(x,Zt),o(x,B),k(ke,B,null),o(B,Bt),o(B,Ie),o(x,Dt),o(x,F),k(be,F,null),o(F,Gt),o(F,Ee),o(F,Vt),k(D,F,null),o(F,Wt),o(F,Je),o(x,Xt),o(x,G),k(ve,G,null),o(G,Yt),o(G,Pe),i(e,Lt,l),i(e,H,l),o(H,V),o(V,tt),k(ye,tt,null),o(H,Qt),o(H,Ae),i(e,Mt,l),i(e,f,l),k(Te,f,null),o(f,Ot),o(f,He),o(f,Kt),o(f,Re),o(f,eo),k(W,f,null),o(f,to),o(f,Ne),o(f,oo),o(f,Se),o(f,no),o(f,z),k(we,z,null),o(z,so),o(z,Ze),o(z,ao),o(z,Be),o(z,ro),o(z,De),o(z,lo),o(z,Ge),o(f,io),o(f,X),k(xe,X,null),o(X,co),o(X,Ve),o(f,mo),o(f,E),k(Ce,E,null),o(E,po),o(E,We),o(E,fo),o(E,Xe),o(f,ho),o(f,Y),k(Le,Y,null),o(Y,uo),o(Y,Ye),o(f,_o),o(f,Qe),k(Me,Qe,null),i(e,$t,l),i(e,ot,l),zt=!0},p(e,[l]){const $e={};l&2&&($e.$$scope={dirty:l,ctx:e}),S.$set($e);const nt={};l&2&&(nt.$$scope={dirty:l,ctx:e}),D.$set(nt);const st={};l&2&&(st.$$scope={dirty:l,ctx:e}),W.$set(st)},i(e){zt||(b(I.$$.fragment,e),b(O.$$.fragment,e),b(S.$$.fragment,e),b(re.$$.fragment,e),b(de.$$.fragment,e),b(me.$$.fragment,e),b(ue.$$.fragment,e),b(_e.$$.fragment,e),b(ge.$$.fragment,e),b(ke.$$.fragment,e),b(be.$$.fragment,e),b(D.$$.fragment,e),b(ve.$$.fragment,e),b(ye.$$.fragment,e),b(Te.$$.fragment,e),b(W.$$.fragment,e),b(we.$$.fragment,e),b(xe.$$.fragment,e),b(Ce.$$.fragment,e),b(Le.$$.fragment,e),b(Me.$$.fragment,e),zt=!0)},o(e){v(I.$$.fragment,e),v(O.$$.fragment,e),v(S.$$.fragment,e),v(re.$$.fragment,e),v(de.$$.fragment,e),v(me.$$.fragment,e),v(ue.$$.fragment,e),v(_e.$$.fragment,e),v(ge.$$.fragment,e),v(ke.$$.fragment,e),v(be.$$.fragment,e),v(D.$$.fragment,e),v(ve.$$.fragment,e),v(ye.$$.fragment,e),v(Te.$$.fragment,e),v(W.$$.fragment,e),v(we.$$.fragment,e),v(xe.$$.fragment,e),v(Ce.$$.fragment,e),v(Le.$$.fragment,e),v(Me.$$.fragment,e),zt=!1},d(e){e&&(t($),t(h),t(T),t(C),t(rt),t(P),t(lt),t(K),t(it),t(ee),t(dt),t(te),t(ct),t(oe),t(mt),t(pt),t(ne),t(ft),t(se),t(ht),t(ae),t(ut),t(_t),t(le),t(gt),t(ie),t(kt),t(bt),t(ce),t(vt),t(yt),t(pe),t(Tt),t(fe),t(wt),t(he),t(xt),t(A),t(Ct),t(x),t(Lt),t(H),t(Mt),t(f),t($t),t(ot)),t(c),y(I),y(O),y(S,e),y(re,e),y(de,e),y(me,e),y(ue),y(_e),y(ge),y(ke),y(be),y(D),y(ve),y(ye),y(Te),y(W),y(we),y(xe),y(Ce),y(Le),y(Me)}}}const bn={local:"codellama",sections:[{local:"overview",title:"Overview"},{local:"transformers.CodeLlamaTokenizer",title:"CodeLlamaTokenizer"},{local:"transformers.CodeLlamaTokenizerFast",title:"CodeLlamaTokenizerFast"}],title:"CodeLlama"};function vn(R){return cn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $n extends mn{constructor(c){super(),pn(this,c,vn,kn,dn,{})}}export{$n as component};
