import{s as Wt,o as Xt,n as Bs}from"../chunks/scheduler.36a0863c.js";import{S as zt,i as Et,g as o,s as a,u as d,A as xt,h as i,f as s,c as n,j as T,v as p,y as r,k as M,o as f,a as t,w as m,d as u,t as y,x as J}from"../chunks/index.d0f7a4c4.js";import{T as Ns}from"../chunks/Tip.4c7d7eb1.js";import{I as el}from"../chunks/IconCopyLink.bc5fad79.js";import{C as j}from"../chunks/CodeBlock.69433f87.js";function Gt(Z){let c,b="Si tu modelo es muy similar a un modelo dentro de la biblioteca, puedes reutilizar la misma configuración de ese modelo.";return{c(){c=o("p"),c.textContent=b},l(w){c=i(w,"P",{"data-svelte-h":!0}),r(c)!=="svelte-143ofzf"&&(c.textContent=b)},m(w,U){t(w,c,U)},p:Bs,d(w){w&&s(c)}}}function Vt(Z){let c,b="Esta <em>API</em> es experimental y puede tener algunos cambios leves en las próximas versiones.";return{c(){c=o("p"),c.innerHTML=b},l(w){c=i(w,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1qtj9q"&&(c.innerHTML=b)},m(w,U){t(w,c,U)},p:Bs,d(w){w&&s(c)}}}function Yt(Z){let c,b=`Si copias archivos del modelo desde la biblioteca, deberás reemplazar todas las importaciones relativas en la parte superior
del archivo para importarlos desde el paquete <code>transformers</code>.`;return{c(){c=o("p"),c.innerHTML=b},l(w){c=i(w,"P",{"data-svelte-h":!0}),r(c)!=="svelte-n79je1"&&(c.innerHTML=b)},m(w,U){t(w,c,U)},p:Bs,d(w){w&&s(c)}}}function Ht(Z){let c,b,w,U,h,A,ll,E,vs,Le,Rs="Compartir modelos personalizados",dl,x,Ws=`La biblioteca 🤗 Transformers está diseñada para ser fácilmente ampliable. Cada modelo está completamente codificado
sin abstracción en una subcarpeta determinada del repositorio, por lo que puedes copiar fácilmente un archivo del modelo
y ajustarlo según tus necesidades.`,pl,G,Xs=`Si estás escribiendo un modelo completamente nuevo, podría ser más fácil comenzar desde cero. En este tutorial, te mostraremos
cómo escribir un modelo personalizado y su configuración para que pueda usarse dentro de Transformers, y cómo puedes compartirlo
con la comunidad (con el código en el que se basa) para que cualquiera pueda usarlo, incluso si no está presente en la biblioteca
🤗 Transformers.`,Ml,V,zs='Ilustraremos todo esto con un modelo ResNet, envolviendo la clase ResNet de la <a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">biblioteca timm</a> en un <code>PreTrainedModel</code>.',ml,C,$,sl,Y,_s,Se,Es="Escribir una configuración personalizada",ul,H,xs=`Antes de adentrarnos en el modelo, primero escribamos su configuración. La configuración de un modelo es un objeto que
contendrá toda la información necesaria para construir el modelo. Como veremos en la siguiente sección, el modelo solo puede
tomar un <code>config</code> para ser inicializado, por lo que realmente necesitamos que ese objeto esté lo más completo posible.`,yl,Q,Gs=`En nuestro ejemplo, tomaremos un par de argumentos de la clase ResNet que tal vez queramos modificar. Las diferentes
configuraciones nos darán los diferentes tipos de ResNet que son posibles. Luego simplemente almacenamos esos argumentos
después de verificar la validez de algunos de ellos.`,Jl,q,fl,F,Vs="Las tres cosas importantes que debes recordar al escribir tu propia configuración son las siguientes:",wl,L,Ys="<li>tienes que heredar de <code>PretrainedConfig</code>,</li> <li>el <code>__init__</code> de tu <code>PretrainedConfig</code> debe aceptar cualquier <code>kwargs</code>,</li> <li>esos <code>kwargs</code> deben pasarse a la superclase <code>__init__</code>.</li>",Tl,S,Hs=`La herencia es para asegurarte de obtener toda la funcionalidad de la biblioteca 🤗 Transformers, mientras que las otras dos
restricciones provienen del hecho de que una <code>PretrainedConfig</code> tiene más campos que los que estás configurando. Al recargar una
<code>config</code> con el método <code>from_pretrained</code>, esos campos deben ser aceptados por tu <code>config</code> y luego enviados a la superclase.`,jl,P,Qs=`Definir un <code>model_type</code> para tu configuración (en este caso <code>model_type=&quot;resnet&quot;</code>) no es obligatorio, a menos que quieras
registrar tu modelo con las clases automáticas (ver la última sección).`,bl,D,qs=`Una vez hecho esto, puedes crear y guardar fácilmente tu configuración como lo harías con cualquier otra configuración de un
modelo de la biblioteca. Así es como podemos crear una configuración resnet50d y guardarla:`,Ul,K,hl,O,Fs=`Esto guardará un archivo llamado <code>config.json</code> dentro de la carpeta <code>custom-resnet</code>. Luego puedes volver a cargar tu configuración
con el método <code>from_pretrained</code>:`,Cl,ee,gl,le,Ls=`También puedes usar cualquier otro método de la clase <code>PretrainedConfig</code>, como <code>push_to_hub()</code>, para cargar
directamente tu configuración en el Hub.`,Il,g,k,tl,se,Zs,Pe,Ss="Escribir un modelo personalizado",vl,te,Ps=`Ahora que tenemos nuestra configuración de ResNet, podemos seguir escribiendo el modelo. En realidad escribiremos dos: una que
extrae las características ocultas de un grupo de imágenes (como <code>BertModel</code>) y una que es adecuada para clasificación de
imagenes (como <code>BertForSequenceClassification</code>).`,_l,ae,Ds=`Como mencionamos antes, solo escribiremos un envoltura (<em>wrapper</em>) libre del modelo para simplificar este ejemplo. Lo único que debemos
hacer antes de escribir esta clase es un mapeo entre los tipos de bloques y las clases de bloques reales. Luego se define el
modelo desde la configuración pasando todo a la clase <code>ResNet</code>:`,Zl,ne,Al,oe,Ks="Para el modelo que clasificará las imágenes, solo cambiamos el método de avance (es decir, el método <code>forward</code>):",$l,ie,kl,re,Os=`En ambos casos, observa cómo heredamos de <code>PreTrainedModel</code> y llamamos a la inicialización de la superclase con <code>config</code>
(un poco como cuando escribes <code>torch.nn.Module</code>). La línea que establece <code>config_class</code> no es obligatoria, a menos
que quieras registrar tu modelo con las clases automáticas (consulta la última sección).`,Nl,N,Bl,ce,et=`Puedes hacer que tu modelo devuelva lo que quieras, pero devolver un diccionario como lo hicimos para
<code>ResnetModelForImageClassification</code>, con el <code>loss</code> incluido cuando se pasan las etiquetas, hará que tu modelo se pueda
usar directamente dentro de la clase <code>Trainer</code>. Usar otro formato de salida está bien, siempre y cuando estés planeando usar
tu propio bucle de entrenamiento u otra biblioteca para el entrenamiento.`,Rl,de,lt="Ahora que tenemos nuestra clase, vamos a crear un modelo:",Wl,pe,Xl,Me,st=`Nuevamente, puedes usar cualquiera de los métodos de <code>PreTrainedModel</code>, como <code>save_pretrained()</code> o
<code>push_to_hub()</code>. Usaremos el segundo en la siguiente sección y veremos cómo pasar los pesos del modelo
con el código de nuestro modelo. Pero primero, carguemos algunos pesos previamente entrenados dentro de nuestro modelo.`,zl,me,tt=`En tu caso de uso, probablemente estarás entrenando tu modelo personalizado con tus propios datos. Para ir rápido en este
tutorial, usaremos la versión preentrenada de resnet50d. Dado que nuestro modelo es solo un envoltorio alrededor del resnet50d
original, será fácil transferir esos pesos:`,El,ue,xl,ye,at=`Ahora veamos cómo asegurarnos de que cuando hacemos <code>save_pretrained()</code> o <code>push_to_hub()</code>,
se guarda el código del modelo.`,Gl,I,B,al,Je,As,De,nt="Enviar el código al _Hub_",Vl,R,Yl,fe,ot=`Primero, asegúrate de que tu modelo esté completamente definido en un archivo <code>.py</code>. Puedes basarte en importaciones
relativas a otros archivos, siempre que todos los archivos estén en el mismo directorio (aún no admitimos submódulos
para esta característica). Para nuestro ejemplo, definiremos un archivo <code>modeling_resnet.py</code> y un archivo
<code>configuration_resnet.py</code> en una carpeta del directorio de trabajo actual llamado <code>resnet_model</code>. El archivo de configuración
contiene el código de <code>ResnetConfig</code> y el archivo del modelo contiene el código de <code>ResnetModel</code> y
<code>ResnetModelForImageClassification</code>.`,Hl,we,Ql,Te,it="El <code>__init__.py</code>  puede estar vacío, solo está ahí para que Python detecte que <code>resnet_model</code> se puede usar como un módulo.",ql,W,Fl,je,rt="Ten en cuenta que puedes reutilizar (o subclasificar) una configuración o modelo existente.",Ll,be,ct=`Para compartir tu modelo con la comunidad, sigue estos pasos: primero importa el modelo y la configuración de ResNet desde
los archivos recién creados:`,Sl,Ue,Pl,he,dt=`Luego, debes decirle a la biblioteca que deseas copiar el código de esos objetos cuando usas el método <code>save_pretrained</code>
y registrarlos correctamente con una determinada clase automática (especialmente para modelos), simplemente ejecuta:`,Dl,Ce,Kl,ge,pt=`Ten en cuenta que no es necesario especificar una clase automática para la configuración (solo hay una clase automática
para ellos, <code>AutoConfig</code>), pero es diferente para los modelos. Tu modelo personalizado podría ser adecuado para muchas
tareas diferentes, por lo que debes especificar cuál de las clases automáticas es la correcta para tu modelo.`,Ol,Ie,Mt="A continuación, vamos a crear la configuración y los modelos como lo hicimos antes:",es,ve,ls,_e,mt="Ahora, para enviar el modelo al Hub, asegúrate de haber iniciado sesión. Ejecuta en tu terminal:",ss,Ze,ts,Ae,ut="o desde un <em>notebook</em>:",as,$e,ns,ke,yt="Luego puedes ingresar a tu propio espacio (o una organización de la que seas miembro) de esta manera:",os,Ne,is,Be,Jt=`Además de los pesos del modelo y la configuración en formato json, esto también copió los archivos <code>.py</code> del modelo y la
configuración en la carpeta <code>custom-resnet50d</code> y subió el resultado al Hub. Puedes verificar el resultado en este
<a href="https://huggingface.co/sgugger/custom-resnet50d" rel="nofollow">repositorio de modelos</a>.`,rs,Re,ft='Consulta el tutorial sobre cómo <a href="model_sharing">compartir modelos</a> para obtener más información sobre el método para subir modelos al Hub.',cs,v,X,nl,We,$s,Ke,wt="Usar un modelo con código personalizado",ds,Xe,Tt=`Puedes usar cualquier configuración, modelo o <em>tokenizador</em> con archivos de código personalizado en tu repositorio con las
clases automáticas y el método <code>from_pretrained</code>. Todos los archivos y códigos cargados en el Hub se analizan en busca de
malware (consulta la documentación de <a href="https://huggingface.co/docs/hub/security#malware-scanning" rel="nofollow">seguridad del Hub</a> para
obtener más información), pero aún debes revisar el código del modelo y el autor para evitar la ejecución de código malicioso
en tu computadora. Configura <code>trust_remote_code=True</code> para usar un modelo con código personalizado:`,ps,ze,Ms,Ee,jt=`También se recomienda encarecidamente pasar un <em>hash</em> de confirmación como una “revisión” para asegurarte de que el autor
de los modelos no actualizó el código con algunas líneas nuevas maliciosas (a menos que confíes plenamente en los autores
de los modelos).`,ms,xe,us,Ge,bt=`Ten en cuenta que al navegar por el historial de confirmaciones del repositorio del modelo en Hub, hay un botón para copiar
fácilmente el hash de confirmación de cualquier <em>commit</em>.`,ys,_,z,ol,Ve,ks,Oe,Ut="Registrar un model con código personalizado a las clases automáticas",Js,Ye,ht=`Si estás escribiendo una biblioteca que amplía 🤗 Transformers, es posible que quieras ampliar las clases automáticas para
incluir tu propio modelo. Esto es diferente de enviar el código al Hub en el sentido de que los usuarios necesitarán importar
tu biblioteca para obtener los modelos personalizados (al contrario de descargar automáticamente el código del modelo desde Hub).`,fs,He,Ct=`Siempre que tu configuración tenga un atributo <code>model_type</code> que sea diferente de los tipos de modelos existentes, y que tus
clases modelo tengan los atributos <code>config_class</code> correctos, puedes agregarlos a las clases automáticas de la siguiente manera:`,ws,Qe,Ts,qe,gt=`Ten en cuenta que el primer argumento utilizado al registrar tu configuración personalizada en <code>AutoConfig</code> debe coincidir
con el <code>model_type</code> de tu configuración personalizada, y el primer argumento utilizado al registrar tus modelos personalizados
en cualquier clase del modelo automático debe coincidir con el <code>config_class</code> de esos modelos.`,js,il,bs;return E=new el({}),Y=new el({}),q=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PretrainedConfig
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetConfig</span>(<span class="hljs-title class_ inherited__">PretrainedConfig</span>):
    model_type = <span class="hljs-string">&quot;resnet&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>,
        layers: <span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>] = [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">6</span>, <span class="hljs-number">3</span>],
        num_classes: <span class="hljs-built_in">int</span> = <span class="hljs-number">1000</span>,
        input_channels: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>,
        cardinality: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span>,
        base_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_type: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;&quot;</span>,
        avg_down: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
        **kwargs,
    </span>):
        <span class="hljs-keyword">if</span> block_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;basic&quot;</span>, <span class="hljs-string">&quot;bottleneck&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`block_type\` must be &#x27;basic&#x27; or bottleneck&#x27;, got <span class="hljs-subst">{block_type}</span>.&quot;</span>)
        <span class="hljs-keyword">if</span> stem_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;deep&quot;</span>, <span class="hljs-string">&quot;deep-tiered&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`stem_type\` must be &#x27;&#x27;, &#x27;deep&#x27; or &#x27;deep-tiered&#x27;, got <span class="hljs-subst">{stem_type}</span>.&quot;</span>)

        self.block_type = block_type
        self.layers = layers
        self.num_classes = num_classes
        self.input_channels = input_channels
        self.cardinality = cardinality
        self.base_width = base_width
        self.stem_width = stem_width
        self.stem_type = stem_type
        self.avg_down = avg_down
        <span class="hljs-built_in">super</span>().__init__(**kwargs)`}}),K=new j({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d_config.save_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)`}}),ee=new j({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:'resnet50d_config = ResnetConfig.from_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)'}}),se=new el({}),ne=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRNb2RlbCUwQWZyb20lMjB0aW1tLm1vZGVscy5yZXNuZXQlMjBpbXBvcnQlMjBCYXNpY0Jsb2NrJTJDJTIwQm90dGxlbmVjayUyQyUyMFJlc05ldCUwQWZyb20lMjAuY29uZmlndXJhdGlvbl9yZXNuZXQlMjBpbXBvcnQlMjBSZXNuZXRDb25maWclMEElMEElMEFCTE9DS19NQVBQSU5HJTIwJTNEJTIwJTdCJTIyYmFzaWMlMjIlM0ElMjBCYXNpY0Jsb2NrJTJDJTIwJTIyYm90dGxlbmVjayUyMiUzQSUyMEJvdHRsZW5lY2slN0QlMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb25maWdfY2xhc3MlMjAlM0QlMjBSZXNuZXRDb25maWclMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX2xheWVyJTIwJTNEJTIwQkxPQ0tfTUFQUElORyU1QmNvbmZpZy5ibG9ja190eXBlJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbCUyMCUzRCUyMFJlc05ldCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbmZpZy5sYXllcnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fY2xhc3NlcyUzRGNvbmZpZy5udW1fY2xhc3NlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5zJTNEY29uZmlnLmlucHV0X2NoYW5uZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FyZGluYWxpdHklM0Rjb25maWcuY2FyZGluYWxpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXNlX3dpZHRoJTNEY29uZmlnLmJhc2Vfd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3dpZHRoJTNEY29uZmlnLnN0ZW1fd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3R5cGUlM0Rjb25maWcuc3RlbV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXZnX2Rvd24lM0Rjb25maWcuYXZnX2Rvd24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubW9kZWwuZm9yd2FyZF9mZWF0dXJlcyh0ZW5zb3Ip",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedModel
<span class="hljs-keyword">from</span> timm.models.resnet <span class="hljs-keyword">import</span> BasicBlock, Bottleneck, ResNet
<span class="hljs-keyword">from</span> .configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig


BLOCK_MAPPING = {<span class="hljs-string">&quot;basic&quot;</span>: BasicBlock, <span class="hljs-string">&quot;bottleneck&quot;</span>: Bottleneck}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor</span>):
        <span class="hljs-keyword">return</span> self.model.forward_features(tensor)`}}),ie=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihQcmVUcmFpbmVkTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnX2NsYXNzJTIwJTNEJTIwUmVzbmV0Q29uZmlnJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyMCUzRCUyMEJMT0NLX01BUFBJTkclNUJjb25maWcuYmxvY2tfdHlwZSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWwlMjAlM0QlMjBSZXNOZXQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfbGF5ZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcubGF5ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2NsYXNzZXMlM0Rjb25maWcubnVtX2NsYXNzZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbl9jaGFucyUzRGNvbmZpZy5pbnB1dF9jaGFubmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRpbmFsaXR5JTNEY29uZmlnLmNhcmRpbmFsaXR5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmFzZV93aWR0aCUzRGNvbmZpZy5iYXNlX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV93aWR0aCUzRGNvbmZpZy5zdGVtX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV90eXBlJTNEY29uZmlnLnN0ZW1fdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF2Z19kb3duJTNEY29uZmlnLmF2Z19kb3duJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHRlbnNvciUyQyUyMGxhYmVscyUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwc2VsZi5tb2RlbCh0ZW5zb3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsYWJlbHMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwdG9yY2gubm4uY3Jvc3NfZW50cm9weShsb2dpdHMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybG9zcyUyMiUzQSUyMGxvc3MlMkMlMjAlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0Q=",highlighted:`<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModelForImageClassification</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor, labels=<span class="hljs-literal">None</span></span>):
        logits = self.model(tensor)
        <span class="hljs-keyword">if</span> labels <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            loss = torch.nn.cross_entropy(logits, labels)
            <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;loss&quot;</span>: loss, <span class="hljs-string">&quot;logits&quot;</span>: logits}
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;logits&quot;</span>: logits}`}}),N=new Ns({props:{$$slots:{default:[Gt]},$$scope:{ctx:Z}}}),pe=new j({props:{code:"cmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcp",highlighted:"resnet50d = ResnetModelForImageClassification(resnet50d_config)"}}),ue=new j({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQXByZXRyYWluZWRfbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCglMjJyZXNuZXQ1MGQlMjIlMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFyZXNuZXQ1MGQubW9kZWwubG9hZF9zdGF0ZV9kaWN0KHByZXRyYWluZWRfbW9kZWwuc3RhdGVfZGljdCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`}}),Je=new el({}),R=new Ns({props:{warning:!0,$$slots:{default:[Vt]},$$scope:{ctx:Z}}}),we=new j({props:{code:"LiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHJlc25ldF9tb2RlbCUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMF9faW5pdF9fLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlndXJhdGlvbl9yZXNuZXQucHklMEElMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBtb2RlbGluZ19yZXNuZXQucHk=",highlighted:`.
└── resnet_model
    ├── __init__.<span class="hljs-keyword">py</span>
    ├── configuration_resnet.<span class="hljs-keyword">py</span>
    └── modeling_resnet.<span class="hljs-keyword">py</span>`}}),W=new Ns({props:{warning:!0,$$slots:{default:[Yt]},$$scope:{ctx:Z}}}),Ue=new j({props:{code:"ZnJvbSUyMHJlc25ldF9tb2RlbC5jb25maWd1cmF0aW9uX3Jlc25ldCUyMGltcG9ydCUyMFJlc25ldENvbmZpZyUwQWZyb20lMjByZXNuZXRfbW9kZWwubW9kZWxpbmdfcmVzbmV0JTIwaW1wb3J0JTIwUmVzbmV0TW9kZWwlMkMlMjBSZXNuZXRNb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24=",highlighted:`<span class="hljs-keyword">from</span> resnet_model.configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig
<span class="hljs-keyword">from</span> resnet_model.modeling_resnet <span class="hljs-keyword">import</span> ResnetModel, ResnetModelForImageClassification`}}),Ce=new j({props:{code:"UmVzbmV0Q29uZmlnLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCklMEFSZXNuZXRNb2RlbC5yZWdpc3Rlcl9mb3JfYXV0b19jbGFzcyglMjJBdXRvTW9kZWwlMjIpJTBBUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCUyMkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMjIp",highlighted:`ResnetConfig.register_for_auto_class()
ResnetModel.register_for_auto_class(<span class="hljs-string">&quot;AutoModel&quot;</span>)
ResnetModelForImageClassification.register_for_auto_class(<span class="hljs-string">&quot;AutoModelForImageClassification&quot;</span>)`}}),ve=new j({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcpJTBBJTBBcHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXJlc25ldDUwZC5tb2RlbC5sb2FkX3N0YXRlX2RpY3QocHJldHJhaW5lZF9tb2RlbC5zdGF0ZV9kaWN0KCkp",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d = ResnetModelForImageClassification(resnet50d_config)

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`}}),Ze=new j({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login"}}),$e=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`}}),Ne=new j({props:{code:"cmVzbmV0NTBkLnB1c2hfdG9faHViKCUyMmN1c3RvbS1yZXNuZXQ1MGQlMjIp",highlighted:'resnet50d.push_to_hub(<span class="hljs-string">&quot;custom-resnet50d&quot;</span>)'}}),We=new el({}),ze=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnNndWdnZXIlMkZjdXN0b20tcmVzbmV0NTBkJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`}}),xe=new j({props:{code:"Y29tbWl0X2hhc2glMjAlM0QlMjAlMjJlZDk0YTdjNjI0N2Q4YWVkY2U0NjQ3ZjAwZjIwZGU2ODc1YjViMjkyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzZ3VnZ2VyJTJGY3VzdG9tLXJlc25ldDUwZCUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUyQyUyMHJldmlzaW9uJTNEY29tbWl0X2hhc2glMEEp",highlighted:`commit_hash = <span class="hljs-string">&quot;ed94a7c6247d8aedce4647f00f20de6875b5b292&quot;</span>
model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, revision=commit_hash
)`}}),Ve=new el({}),Qe=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBQXV0b0NvbmZpZy5yZWdpc3RlciglMjJyZXNuZXQlMjIlMkMlMjBSZXNuZXRDb25maWcpJTBBQXV0b01vZGVsLnJlZ2lzdGVyKFJlc25ldENvbmZpZyUyQyUyMFJlc25ldE1vZGVsKSUwQUF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24ucmVnaXN0ZXIoUmVzbmV0Q29uZmlnJTJDJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel, AutoModelForImageClassification

AutoConfig.register(<span class="hljs-string">&quot;resnet&quot;</span>, ResnetConfig)
AutoModel.register(ResnetConfig, ResnetModel)
AutoModelForImageClassification.register(ResnetConfig, ResnetModelForImageClassification)`}}),{c(){c=o("meta"),b=a(),w=o("p"),U=a(),h=o("h1"),A=o("a"),ll=o("span"),d(E.$$.fragment),vs=a(),Le=o("span"),Le.textContent=Rs,dl=a(),x=o("p"),x.textContent=Ws,pl=a(),G=o("p"),G.textContent=Xs,Ml=a(),V=o("p"),V.innerHTML=zs,ml=a(),C=o("h2"),$=o("a"),sl=o("span"),d(Y.$$.fragment),_s=a(),Se=o("span"),Se.textContent=Es,ul=a(),H=o("p"),H.innerHTML=xs,yl=a(),Q=o("p"),Q.textContent=Gs,Jl=a(),d(q.$$.fragment),fl=a(),F=o("p"),F.textContent=Vs,wl=a(),L=o("ul"),L.innerHTML=Ys,Tl=a(),S=o("p"),S.innerHTML=Hs,jl=a(),P=o("p"),P.innerHTML=Qs,bl=a(),D=o("p"),D.textContent=qs,Ul=a(),d(K.$$.fragment),hl=a(),O=o("p"),O.innerHTML=Fs,Cl=a(),d(ee.$$.fragment),gl=a(),le=o("p"),le.innerHTML=Ls,Il=a(),g=o("h2"),k=o("a"),tl=o("span"),d(se.$$.fragment),Zs=a(),Pe=o("span"),Pe.textContent=Ss,vl=a(),te=o("p"),te.innerHTML=Ps,_l=a(),ae=o("p"),ae.innerHTML=Ds,Zl=a(),d(ne.$$.fragment),Al=a(),oe=o("p"),oe.innerHTML=Ks,$l=a(),d(ie.$$.fragment),kl=a(),re=o("p"),re.innerHTML=Os,Nl=a(),d(N.$$.fragment),Bl=a(),ce=o("p"),ce.innerHTML=et,Rl=a(),de=o("p"),de.textContent=lt,Wl=a(),d(pe.$$.fragment),Xl=a(),Me=o("p"),Me.innerHTML=st,zl=a(),me=o("p"),me.textContent=tt,El=a(),d(ue.$$.fragment),xl=a(),ye=o("p"),ye.innerHTML=at,Gl=a(),I=o("h2"),B=o("a"),al=o("span"),d(Je.$$.fragment),As=a(),De=o("span"),De.textContent=nt,Vl=a(),d(R.$$.fragment),Yl=a(),fe=o("p"),fe.innerHTML=ot,Hl=a(),d(we.$$.fragment),Ql=a(),Te=o("p"),Te.innerHTML=it,ql=a(),d(W.$$.fragment),Fl=a(),je=o("p"),je.textContent=rt,Ll=a(),be=o("p"),be.textContent=ct,Sl=a(),d(Ue.$$.fragment),Pl=a(),he=o("p"),he.innerHTML=dt,Dl=a(),d(Ce.$$.fragment),Kl=a(),ge=o("p"),ge.innerHTML=pt,Ol=a(),Ie=o("p"),Ie.textContent=Mt,es=a(),d(ve.$$.fragment),ls=a(),_e=o("p"),_e.textContent=mt,ss=a(),d(Ze.$$.fragment),ts=a(),Ae=o("p"),Ae.innerHTML=ut,as=a(),d($e.$$.fragment),ns=a(),ke=o("p"),ke.textContent=yt,os=a(),d(Ne.$$.fragment),is=a(),Be=o("p"),Be.innerHTML=Jt,rs=a(),Re=o("p"),Re.innerHTML=ft,cs=a(),v=o("h2"),X=o("a"),nl=o("span"),d(We.$$.fragment),$s=a(),Ke=o("span"),Ke.textContent=wt,ds=a(),Xe=o("p"),Xe.innerHTML=Tt,ps=a(),d(ze.$$.fragment),Ms=a(),Ee=o("p"),Ee.innerHTML=jt,ms=a(),d(xe.$$.fragment),us=a(),Ge=o("p"),Ge.innerHTML=bt,ys=a(),_=o("h2"),z=o("a"),ol=o("span"),d(Ve.$$.fragment),ks=a(),Oe=o("span"),Oe.textContent=Ut,Js=a(),Ye=o("p"),Ye.textContent=ht,fs=a(),He=o("p"),He.innerHTML=Ct,ws=a(),d(Qe.$$.fragment),Ts=a(),qe=o("p"),qe.innerHTML=gt,js=a(),il=o("p"),this.h()},l(e){const l=xt("svelte-1phssyn",document.head);c=i(l,"META",{name:!0,content:!0}),l.forEach(s),b=n(e),w=i(e,"P",{}),T(w).forEach(s),U=n(e),h=i(e,"H1",{class:!0});var Fe=T(h);A=i(Fe,"A",{id:!0,class:!0,href:!0});var rl=T(A);ll=i(rl,"SPAN",{});var cl=T(ll);p(E.$$.fragment,cl),cl.forEach(s),rl.forEach(s),vs=n(Fe),Le=i(Fe,"SPAN",{"data-svelte-h":!0}),r(Le)!=="svelte-1a7mwph"&&(Le.textContent=Rs),Fe.forEach(s),dl=n(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-tr5y5v"&&(x.textContent=Ws),pl=n(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-109xt20"&&(G.textContent=Xs),Ml=n(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-btynk6"&&(V.innerHTML=zs),ml=n(e),C=i(e,"H2",{class:!0});var Us=T(C);$=i(Us,"A",{id:!0,class:!0,href:!0});var It=T($);sl=i(It,"SPAN",{});var vt=T(sl);p(Y.$$.fragment,vt),vt.forEach(s),It.forEach(s),_s=n(Us),Se=i(Us,"SPAN",{"data-svelte-h":!0}),r(Se)!=="svelte-94tvs"&&(Se.textContent=Es),Us.forEach(s),ul=n(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-ogx8ma"&&(H.innerHTML=xs),yl=n(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-150l7rd"&&(Q.textContent=Gs),Jl=n(e),p(q.$$.fragment,e),fl=n(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-136d91e"&&(F.textContent=Vs),wl=n(e),L=i(e,"UL",{"data-svelte-h":!0}),r(L)!=="svelte-9z90ps"&&(L.innerHTML=Ys),Tl=n(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-ydah10"&&(S.innerHTML=Hs),jl=n(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-9ngg6t"&&(P.innerHTML=Qs),bl=n(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-aydane"&&(D.textContent=qs),Ul=n(e),p(K.$$.fragment,e),hl=n(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1m9vi80"&&(O.innerHTML=Fs),Cl=n(e),p(ee.$$.fragment,e),gl=n(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-13fhymr"&&(le.innerHTML=Ls),Il=n(e),g=i(e,"H2",{class:!0});var hs=T(g);k=i(hs,"A",{id:!0,class:!0,href:!0});var _t=T(k);tl=i(_t,"SPAN",{});var Zt=T(tl);p(se.$$.fragment,Zt),Zt.forEach(s),_t.forEach(s),Zs=n(hs),Pe=i(hs,"SPAN",{"data-svelte-h":!0}),r(Pe)!=="svelte-117vlgq"&&(Pe.textContent=Ss),hs.forEach(s),vl=n(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-paws7g"&&(te.innerHTML=Ps),_l=n(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1ibwyqf"&&(ae.innerHTML=Ds),Zl=n(e),p(ne.$$.fragment,e),Al=n(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-836jlz"&&(oe.innerHTML=Ks),$l=n(e),p(ie.$$.fragment,e),kl=n(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-14m6odt"&&(re.innerHTML=Os),Nl=n(e),p(N.$$.fragment,e),Bl=n(e),ce=i(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1azo3fe"&&(ce.innerHTML=et),Rl=n(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1shfqlo"&&(de.textContent=lt),Wl=n(e),p(pe.$$.fragment,e),Xl=n(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-2zdpdr"&&(Me.innerHTML=st),zl=n(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-yesi1m"&&(me.textContent=tt),El=n(e),p(ue.$$.fragment,e),xl=n(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-5f7hiy"&&(ye.innerHTML=at),Gl=n(e),I=i(e,"H2",{class:!0});var Cs=T(I);B=i(Cs,"A",{id:!0,class:!0,href:!0});var At=T(B);al=i(At,"SPAN",{});var $t=T(al);p(Je.$$.fragment,$t),$t.forEach(s),At.forEach(s),As=n(Cs),De=i(Cs,"SPAN",{"data-svelte-h":!0}),r(De)!=="svelte-1gdwwxk"&&(De.textContent=nt),Cs.forEach(s),Vl=n(e),p(R.$$.fragment,e),Yl=n(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-5u1ku0"&&(fe.innerHTML=ot),Hl=n(e),p(we.$$.fragment,e),Ql=n(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-6pddse"&&(Te.innerHTML=it),ql=n(e),p(W.$$.fragment,e),Fl=n(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-16nat6k"&&(je.textContent=rt),Ll=n(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1wbstm1"&&(be.textContent=ct),Sl=n(e),p(Ue.$$.fragment,e),Pl=n(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1w1g05r"&&(he.innerHTML=dt),Dl=n(e),p(Ce.$$.fragment,e),Kl=n(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1gdhq4n"&&(ge.innerHTML=pt),Ol=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1vs3f15"&&(Ie.textContent=Mt),es=n(e),p(ve.$$.fragment,e),ls=n(e),_e=i(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1alfdyw"&&(_e.textContent=mt),ss=n(e),p(Ze.$$.fragment,e),ts=n(e),Ae=i(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-vkjqtt"&&(Ae.innerHTML=ut),as=n(e),p($e.$$.fragment,e),ns=n(e),ke=i(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1n95bu8"&&(ke.textContent=yt),os=n(e),p(Ne.$$.fragment,e),is=n(e),Be=i(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-5clmj9"&&(Be.innerHTML=Jt),rs=n(e),Re=i(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-1cn7w99"&&(Re.innerHTML=ft),cs=n(e),v=i(e,"H2",{class:!0});var gs=T(v);X=i(gs,"A",{id:!0,class:!0,href:!0});var kt=T(X);nl=i(kt,"SPAN",{});var Nt=T(nl);p(We.$$.fragment,Nt),Nt.forEach(s),kt.forEach(s),$s=n(gs),Ke=i(gs,"SPAN",{"data-svelte-h":!0}),r(Ke)!=="svelte-8qi1df"&&(Ke.textContent=wt),gs.forEach(s),ds=n(e),Xe=i(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-z7pzfv"&&(Xe.innerHTML=Tt),ps=n(e),p(ze.$$.fragment,e),Ms=n(e),Ee=i(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-k6h5j4"&&(Ee.innerHTML=jt),ms=n(e),p(xe.$$.fragment,e),us=n(e),Ge=i(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-triido"&&(Ge.innerHTML=bt),ys=n(e),_=i(e,"H2",{class:!0});var Is=T(_);z=i(Is,"A",{id:!0,class:!0,href:!0});var Bt=T(z);ol=i(Bt,"SPAN",{});var Rt=T(ol);p(Ve.$$.fragment,Rt),Rt.forEach(s),Bt.forEach(s),ks=n(Is),Oe=i(Is,"SPAN",{"data-svelte-h":!0}),r(Oe)!=="svelte-qjqi23"&&(Oe.textContent=Ut),Is.forEach(s),Js=n(e),Ye=i(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1brns02"&&(Ye.textContent=ht),fs=n(e),He=i(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-qfsmdh"&&(He.innerHTML=Ct),ws=n(e),p(Qe.$$.fragment,e),Ts=n(e),qe=i(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-srgb3"&&(qe.innerHTML=gt),js=n(e),il=i(e,"P",{}),T(il).forEach(s),this.h()},h(){M(c,"name","hf:doc:metadata"),M(c,"content",JSON.stringify(Qt)),M(A,"id","compartir-modelos-personalizados"),M(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(A,"href","#compartir-modelos-personalizados"),M(h,"class","relative group"),M($,"id","escribir-una-configuracin-personalizada"),M($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M($,"href","#escribir-una-configuracin-personalizada"),M(C,"class","relative group"),M(k,"id","escribir-un-modelo-personalizado"),M(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(k,"href","#escribir-un-modelo-personalizado"),M(g,"class","relative group"),M(B,"id","enviar-el-cdigo-al-hub"),M(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(B,"href","#enviar-el-cdigo-al-hub"),M(I,"class","relative group"),M(X,"id","usar-un-modelo-con-cdigo-personalizado"),M(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(X,"href","#usar-un-modelo-con-cdigo-personalizado"),M(v,"class","relative group"),M(z,"id","registrar-un-model-con-cdigo-personalizado-a-las-clases-automticas"),M(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(z,"href","#registrar-un-model-con-cdigo-personalizado-a-las-clases-automticas"),M(_,"class","relative group")},m(e,l){f(document.head,c),t(e,b,l),t(e,w,l),t(e,U,l),t(e,h,l),f(h,A),f(A,ll),m(E,ll,null),f(h,vs),f(h,Le),t(e,dl,l),t(e,x,l),t(e,pl,l),t(e,G,l),t(e,Ml,l),t(e,V,l),t(e,ml,l),t(e,C,l),f(C,$),f($,sl),m(Y,sl,null),f(C,_s),f(C,Se),t(e,ul,l),t(e,H,l),t(e,yl,l),t(e,Q,l),t(e,Jl,l),m(q,e,l),t(e,fl,l),t(e,F,l),t(e,wl,l),t(e,L,l),t(e,Tl,l),t(e,S,l),t(e,jl,l),t(e,P,l),t(e,bl,l),t(e,D,l),t(e,Ul,l),m(K,e,l),t(e,hl,l),t(e,O,l),t(e,Cl,l),m(ee,e,l),t(e,gl,l),t(e,le,l),t(e,Il,l),t(e,g,l),f(g,k),f(k,tl),m(se,tl,null),f(g,Zs),f(g,Pe),t(e,vl,l),t(e,te,l),t(e,_l,l),t(e,ae,l),t(e,Zl,l),m(ne,e,l),t(e,Al,l),t(e,oe,l),t(e,$l,l),m(ie,e,l),t(e,kl,l),t(e,re,l),t(e,Nl,l),m(N,e,l),t(e,Bl,l),t(e,ce,l),t(e,Rl,l),t(e,de,l),t(e,Wl,l),m(pe,e,l),t(e,Xl,l),t(e,Me,l),t(e,zl,l),t(e,me,l),t(e,El,l),m(ue,e,l),t(e,xl,l),t(e,ye,l),t(e,Gl,l),t(e,I,l),f(I,B),f(B,al),m(Je,al,null),f(I,As),f(I,De),t(e,Vl,l),m(R,e,l),t(e,Yl,l),t(e,fe,l),t(e,Hl,l),m(we,e,l),t(e,Ql,l),t(e,Te,l),t(e,ql,l),m(W,e,l),t(e,Fl,l),t(e,je,l),t(e,Ll,l),t(e,be,l),t(e,Sl,l),m(Ue,e,l),t(e,Pl,l),t(e,he,l),t(e,Dl,l),m(Ce,e,l),t(e,Kl,l),t(e,ge,l),t(e,Ol,l),t(e,Ie,l),t(e,es,l),m(ve,e,l),t(e,ls,l),t(e,_e,l),t(e,ss,l),m(Ze,e,l),t(e,ts,l),t(e,Ae,l),t(e,as,l),m($e,e,l),t(e,ns,l),t(e,ke,l),t(e,os,l),m(Ne,e,l),t(e,is,l),t(e,Be,l),t(e,rs,l),t(e,Re,l),t(e,cs,l),t(e,v,l),f(v,X),f(X,nl),m(We,nl,null),f(v,$s),f(v,Ke),t(e,ds,l),t(e,Xe,l),t(e,ps,l),m(ze,e,l),t(e,Ms,l),t(e,Ee,l),t(e,ms,l),m(xe,e,l),t(e,us,l),t(e,Ge,l),t(e,ys,l),t(e,_,l),f(_,z),f(z,ol),m(Ve,ol,null),f(_,ks),f(_,Oe),t(e,Js,l),t(e,Ye,l),t(e,fs,l),t(e,He,l),t(e,ws,l),m(Qe,e,l),t(e,Ts,l),t(e,qe,l),t(e,js,l),t(e,il,l),bs=!0},p(e,[l]){const Fe={};l&2&&(Fe.$$scope={dirty:l,ctx:e}),N.$set(Fe);const rl={};l&2&&(rl.$$scope={dirty:l,ctx:e}),R.$set(rl);const cl={};l&2&&(cl.$$scope={dirty:l,ctx:e}),W.$set(cl)},i(e){bs||(u(E.$$.fragment,e),u(Y.$$.fragment,e),u(q.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(se.$$.fragment,e),u(ne.$$.fragment,e),u(ie.$$.fragment,e),u(N.$$.fragment,e),u(pe.$$.fragment,e),u(ue.$$.fragment,e),u(Je.$$.fragment,e),u(R.$$.fragment,e),u(we.$$.fragment,e),u(W.$$.fragment,e),u(Ue.$$.fragment,e),u(Ce.$$.fragment,e),u(ve.$$.fragment,e),u(Ze.$$.fragment,e),u($e.$$.fragment,e),u(Ne.$$.fragment,e),u(We.$$.fragment,e),u(ze.$$.fragment,e),u(xe.$$.fragment,e),u(Ve.$$.fragment,e),u(Qe.$$.fragment,e),bs=!0)},o(e){y(E.$$.fragment,e),y(Y.$$.fragment,e),y(q.$$.fragment,e),y(K.$$.fragment,e),y(ee.$$.fragment,e),y(se.$$.fragment,e),y(ne.$$.fragment,e),y(ie.$$.fragment,e),y(N.$$.fragment,e),y(pe.$$.fragment,e),y(ue.$$.fragment,e),y(Je.$$.fragment,e),y(R.$$.fragment,e),y(we.$$.fragment,e),y(W.$$.fragment,e),y(Ue.$$.fragment,e),y(Ce.$$.fragment,e),y(ve.$$.fragment,e),y(Ze.$$.fragment,e),y($e.$$.fragment,e),y(Ne.$$.fragment,e),y(We.$$.fragment,e),y(ze.$$.fragment,e),y(xe.$$.fragment,e),y(Ve.$$.fragment,e),y(Qe.$$.fragment,e),bs=!1},d(e){e&&(s(b),s(w),s(U),s(h),s(dl),s(x),s(pl),s(G),s(Ml),s(V),s(ml),s(C),s(ul),s(H),s(yl),s(Q),s(Jl),s(fl),s(F),s(wl),s(L),s(Tl),s(S),s(jl),s(P),s(bl),s(D),s(Ul),s(hl),s(O),s(Cl),s(gl),s(le),s(Il),s(g),s(vl),s(te),s(_l),s(ae),s(Zl),s(Al),s(oe),s($l),s(kl),s(re),s(Nl),s(Bl),s(ce),s(Rl),s(de),s(Wl),s(Xl),s(Me),s(zl),s(me),s(El),s(xl),s(ye),s(Gl),s(I),s(Vl),s(Yl),s(fe),s(Hl),s(Ql),s(Te),s(ql),s(Fl),s(je),s(Ll),s(be),s(Sl),s(Pl),s(he),s(Dl),s(Kl),s(ge),s(Ol),s(Ie),s(es),s(ls),s(_e),s(ss),s(ts),s(Ae),s(as),s(ns),s(ke),s(os),s(is),s(Be),s(rs),s(Re),s(cs),s(v),s(ds),s(Xe),s(ps),s(Ms),s(Ee),s(ms),s(us),s(Ge),s(ys),s(_),s(Js),s(Ye),s(fs),s(He),s(ws),s(Ts),s(qe),s(js),s(il)),s(c),J(E),J(Y),J(q,e),J(K,e),J(ee,e),J(se),J(ne,e),J(ie,e),J(N,e),J(pe,e),J(ue,e),J(Je),J(R,e),J(we,e),J(W,e),J(Ue,e),J(Ce,e),J(ve,e),J(Ze,e),J($e,e),J(Ne,e),J(We),J(ze,e),J(xe,e),J(Ve),J(Qe,e)}}}const Qt={local:"compartir-modelos-personalizados",sections:[{local:"escribir-una-configuracin-personalizada",title:"Escribir una configuración personalizada"},{local:"escribir-un-modelo-personalizado",title:"Escribir un modelo personalizado"},{local:"enviar-el-cdigo-al-hub",title:"Enviar el código al _Hub_"},{local:"usar-un-modelo-con-cdigo-personalizado",title:"Usar un modelo con código personalizado"},{local:"registrar-un-model-con-cdigo-personalizado-a-las-clases-automticas",title:"Registrar un model con código personalizado a las clases automáticas"}],title:"Compartir modelos personalizados"};function qt(Z){return Xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Kt extends zt{constructor(c){super(),Et(this,c,qt,Ht,Wt,{})}}export{Kt as component};
