import{s as Rs,o as Xs,n as Bl}from"../chunks/scheduler.889ebb13.js";import{S as xs,i as Gs,g as M,s as n,u as c,A as Es,h as i,f as l,c as a,j,v as r,y as o,k as y,o as T,a as s,w as d,d as m,t as J,x as w}from"../chunks/index.8980e686.js";import{T as Nl}from"../chunks/Tip.7191df11.js";import{I as et}from"../chunks/IconCopyLink.357761cd.js";import{C as f}from"../chunks/CodeBlock.25fc3430.js";function Ys(g){let p,U="라이브러리에 존재하는 모델과 굉장히 유사하다면, 모델을 생성할 때 구성을 참조해 재사용할 수 있습니다.";return{c(){p=M("p"),p.textContent=U},l(u){p=i(u,"P",{"data-svelte-h":!0}),o(p)!=="svelte-hf6zh1"&&(p.textContent=U)},m(u,h){s(u,p,h)},p:Bl,d(u){u&&l(p)}}}function Vs(g){let p,U="이 API는 실험적이며 다음 릴리스에서 약간의 변경 사항이 있을 수 있습니다.";return{c(){p=M("p"),p.textContent=U},l(u){p=i(u,"P",{"data-svelte-h":!0}),o(p)!=="svelte-11fial7"&&(p.textContent=U)},m(u,h){s(u,p,h)},p:Bl,d(u){u&&l(p)}}}function Qs(g){let p,U=`라이브러리에서 모델링 파일을 복사하는 경우,
모든 파일 상단에 있는 상대 경로 임포트(relative import) 부분을 <code>transformers</code> 패키지에서 임포트 하도록 변경해야 합니다.`;return{c(){p=M("p"),p.innerHTML=U},l(u){p=i(u,"P",{"data-svelte-h":!0}),o(p)!=="svelte-1igyulw"&&(p.innerHTML=U)},m(u,h){s(u,p,h)},p:Bl,d(u){u&&l(p)}}}function Hs(g){let p,U,u,h,C,A,tt,G,Zl,Le,Wl="사용자 정의 모델 공유하기",ct,E,Rl=`🤗 Transformers 라이브러리는 쉽게 확장할 수 있도록 설계되었습니다.
모든 모델은 추상화 없이 저장소의 지정된 하위 폴더에 완전히 코딩되어 있으므로, 손쉽게 모델링 파일을 복사하고 필요에 따라 조정할 수 있습니다.`,rt,Y,Xl=`완전히 새로운 모델을 만드는 경우에는 처음부터 시작하는 것이 더 쉬울 수 있습니다.
이 튜토리얼에서는 Transformers 내에서 사용할 수 있도록 사용자 정의 모델과 구성을 작성하는 방법과
🤗 Transformers 라이브러리에 없는 경우에도 누구나 사용할 수 있도록 (의존성과 함께) 커뮤니티에 공유하는 방법을 배울 수 있습니다.`,yt,V,xl='<a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">timm 라이브러리</a>의 ResNet 클래스를 <code>PreTrainedModel</code>로 래핑한 ResNet 모델을 예로 모든 것을 설명합니다.',dt,b,$,lt,Q,vl,qe,Gl="사용자 정의 구성 작성하기",mt,H,El=`모델에 들어가기 전에 먼저 구성을 작성해보도록 하겠습니다.
모델의 <code>configuration</code>은 모델을 만들기 위해 필요한 모든 중요한 것들을 포함하고 있는 객체입니다.
다음 섹션에서 볼 수 있듯이, 모델은 <code>config</code>를 사용해서만 초기화할 수 있기 때문에 완벽한 구성이 필요합니다.`,Jt,z,Yl=`아래 예시에서는 ResNet 클래스의 인수(argument)를 조정해보겠습니다.
다른 구성은 가능한 ResNet 중 다른 유형을 제공합니다.
그런 다음 몇 가지 유효성을 확인한 후 해당 인수를 저장합니다.`,wt,F,Tt,S,Vl="사용자 정의 <code>configuration</code>을 작성할 때 기억해야 할 세 가지 중요한 사항은 다음과 같습니다:",ut,L,Ql="<li><code>PretrainedConfig</code>을 상속해야 합니다.</li> <li><code>PretrainedConfig</code>의 <code>__init__</code>은 모든 kwargs를 허용해야 하고,</li> <li>이러한 <code>kwargs</code>는 상위 클래스 <code>__init__</code>에 전달되어야 합니다.</li>",jt,q,Hl=`상속은 🤗 Transformers 라이브러리에서 모든 기능을 가져오는 것입니다.
이러한 점으로부터 비롯되는 두 가지 제약 조건은 <code>PretrainedConfig</code>에 설정하는 것보다 더 많은 필드가 있습니다.
<code>from_pretrained</code> 메서드로 구성을 다시 로드할 때 해당 필드는 구성에서 수락한 후 상위 클래스로 보내야 합니다.`,ft,P,zl="모델을 auto 클래스에 등록하지 않는 한, <code>configuration</code>에서 <code>model_type</code>을 정의(여기서 <code>model_type=&quot;resnet&quot;</code>)하는 것은 필수 사항이 아닙니다 (마지막 섹션 참조).",Ut,D,Fl=`이렇게 하면 라이브러리의 다른 모델 구성과 마찬가지로 구성을 쉽게 만들고 저장할 수 있습니다.
다음은 resnet50d 구성을 생성하고 저장하는 방법입니다:`,ht,K,Ct,O,Sl=`이렇게 하면 <code>custom-resnet</code> 폴더 안에 <code>config.json</code>이라는 파일이 저장됩니다.
그런 다음 <code>from_pretrained</code> 메서드를 사용하여 구성을 다시 로드할 수 있습니다.`,bt,ee,It,te,Ll="구성을 Hub에 직접 업로드하기 위해 <code>PretrainedConfig</code> 클래스의 <code>push_to_hub()</code>와 같은 다른 메서드를 사용할 수 있습니다.",_t,I,k,st,le,gl,Pe,ql="사용자 정의 모델 작성하기",Zt,se,Pl=`이제 ResNet 구성이 있으므로 모델을 작성할 수 있습니다.
실제로는 두 개를 작성할 것입니다. 하나는 이미지 배치에서 hidden features를 추출하는 것(<code>BertModel</code>과 같이), 다른 하나는 이미지 분류에 적합한 것입니다(<code>BertForSequenceClassification</code>과 같이).`,vt,ne,Dl=`이전에 언급했듯이 이 예제에서는 단순하게 하기 위해 모델의 느슨한 래퍼(loose wrapper)만 작성할 것입니다.
이 클래스를 작성하기 전에 블록 유형과 실제 블록 클래스 간의 매핑 작업만 하면 됩니다.
그런 다음 <code>ResNet</code> 클래스로 전달되어 <code>configuration</code>을 통해 모델이 선언됩니다:`,gt,ae,At,Me,Kl="이미지 분류 모델을 만들기 위해서는 forward 메소드만 변경하면 됩니다:",$t,ie,kt,oe,Ol=`두 경우 모두 <code>PreTrainedModel</code>를 상속받고, <code>config</code>를 통해 상위 클래스 초기화를 호출하다는 점을 기억하세요 (일반적인 <code>torch.nn.Module</code>을 작성할 때와 비슷함).
모델을 auto 클래스에 등록하고 싶은 경우에는 <code>config_class</code>를 설정하는 부분이 필수입니다 (마지막 섹션 참조).`,Nt,N,Bt,pe,es=`원하는 것을 모델이 반환하도록 할 수 있지만, <code>ResnetModelForImageClassification</code>에서 했던 것 처럼
레이블을 통과시켰을 때 손실과 함께 사전 형태로 반환하는 것이 <code>Trainer</code> 클래스 내에서 직접 모델을 사용하기에 유용합니다.
자신만의 학습 루프 또는 다른 학습 라이브러리를 사용할 계획이라면 다른 출력 형식을 사용해도 좋습니다.`,Wt,ce,ts="이제 모델 클래스가 있으므로 하나 생성해 보겠습니다:",Rt,re,Xt,ye,ls=`다시 말하지만, <code>save_pretrained()</code>또는 <code>push_to_hub()</code>처럼 <code>PreTrainedModel</code>에 속하는 모든 메소드를 사용할 수 있습니다.
다음 섹션에서 두 번째 메소드를 사용해 모델 코드와 모델 가중치를 업로드하는 방법을 살펴보겠습니다.
먼저, 모델 내부에 사전 훈련된 가중치를 로드해 보겠습니다.`,xt,de,ss=`이 예제를 활용할 때는, 사용자 정의 모델을 자신만의 데이터로 학습시킬 것입니다.
이 튜토리얼에서는 빠르게 진행하기 위해 사전 훈련된 resnet50d를 사용하겠습니다.
아래 모델은 resnet50d의 래퍼이기 때문에, 가중치를 쉽게 로드할 수 있습니다.`,Gt,me,Et,Je,ns="이제 <code>save_pretrained()</code> 또는 <code>push_to_hub()</code>를 사용할 때 모델 코드가 저장되는지 확인해봅시다.",Yt,_,B,nt,we,Al,De,as="Hub로 코드 업로드하기",Vt,W,Qt,Te,Ms=`먼저 모델이 <code>.py</code> 파일에 완전히 정의되어 있는지 확인하세요.
모든 파일이 동일한 작업 경로에 있기 때문에 상대경로 임포트(relative import)에 의존할 수 있습니다 (transformers에서는 이 기능에 대한 하위 모듈을 지원하지 않습니다).
이 예시에서는 작업 경로 안의 <code>resnet_model</code>에서 <code>modeling_resnet.py</code> 파일과 <code>configuration_resnet.py</code> 파일을 정의합니다.
구성 파일에는 <code>ResnetConfig</code>에 대한 코드가 있고 모델링 파일에는 <code>ResnetModel</code> 및 <code>ResnetModelForImageClassification</code>에 대한 코드가 있습니다.`,Ht,ue,zt,je,is="Python이 <code>resnet_model</code>을 모듈로 사용할 수 있도록 감지하는 목적이기 때문에 <code>__init__.py</code>는 비어 있을 수 있습니다.",Ft,R,St,fe,os="기존 구성이나 모델을 재사용(또는 서브 클래스화)할 수 있습니다.",Lt,Ue,ps=`커뮤니티에 모델을 공유하기 위해서는 다음 단계를 따라야 합니다:
먼저, 새로 만든 파일에 ResNet 모델과 구성을 임포트합니다:`,qt,he,Pt,Ce,cs=`다음으로 <code>save_pretrained</code> 메소드를 사용해 해당 객체의 코드 파일을 복사하고,
복사한 파일을 Auto 클래스로 등록하고(모델인 경우) 실행합니다:`,Dt,be,Kt,Ie,rs=`<code>configuration</code>에 대한 auto 클래스를 지정할 필요는 없지만(<code>configuration</code> 관련 auto 클래스는 AutoConfig 클래스 하나만 있음), 모델의 경우에는 지정해야 합니다.
사용자 지정 모델은 다양한 작업에 적합할 수 있으므로, 모델에 맞는 auto 클래스를 지정해야 합니다.`,Ot,_e,ys="다음으로, 이전에 작업했던 것과 마찬가지로 구성과 모델을 작성합니다:",el,Ze,tl,ve,ds=`이제 모델을 Hub로 업로드하기 위해 로그인 상태인지 확인하세요.
터미널에서 다음 코드를 실행해 확인할 수 있습니다:`,ll,ge,sl,Ae,ms="주피터 노트북의 경우에는 다음과 같습니다:",nl,$e,al,ke,Js="그런 다음 이렇게 자신의 네임스페이스(또는 자신이 속한 조직)에 업로드할 수 있습니다:",Ml,Ne,il,Be,ws=`On top of the modeling weights and the configuration in json format, this also copied the modeling and
configuration <code>.py</code> files in the folder <code>custom-resnet50d</code> and uploaded the result to the Hub. You can check the result
in this <a href="https://huggingface.co/sgugger/custom-resnet50d" rel="nofollow">model repo</a>.
json 형식의 모델링 가중치와 구성 외에도 <code>custom-resnet50d</code> 폴더 안의 모델링과 구성 <code>.py</code> 파일을 복사하해 Hub에 업로드합니다.
<a href="https://huggingface.co/sgugger/custom-resnet50d" rel="nofollow">모델 저장소</a>에서 결과를 확인할 수 있습니다.`,ol,We,Ts='<a href="model_sharing">sharing tutorial</a> 문서의 <code>push_to_hub</code> 메소드에서 자세한 내용을 확인할 수 있습니다.',pl,Z,X,at,Re,$l,Ke,us="사용자 정의 코드로 모델 사용하기",cl,Xe,js=`auto 클래스와 <code>from_pretrained</code> 메소드를 사용하여 사용자 지정 코드 파일과 함께 모든 구성, 모델, 토크나이저를 사용할 수 있습니다.
Hub에 업로드된 모든 파일 및 코드는 멜웨어가 있는지 검사되지만 (자세한 내용은 <a href="https://huggingface.co/docs/hub/security#malware-scanning" rel="nofollow">Hub 보안</a> 설명 참조),
자신의 컴퓨터에서 모델 코드와 작성자가 악성 코드를 실행하지 않는지 확인해야 합니다.
사용자 정의 코드로 모델을 사용하려면 <code>trust_remote_code=True</code>로 설정하세요:`,rl,xe,yl,Ge,fs="모델 작성자가 악의적으로 코드를 업데이트하지 않았다는 점을 확인하기 위해, 커밋 해시(commit hash)를 <code>revision</code>으로 전달하는 것도 강력히 권장됩니다 (모델 작성자를 완전히 신뢰하지 않는 경우).",dl,Ee,ml,Ye,Us="Hub에서 모델 저장소의 커밋 기록을 찾아볼 때, 모든 커밋의 커밋 해시를 쉽게 복사할 수 있는 버튼이 있습니다.",Jl,v,x,Mt,Ve,kl,Oe,hs="사용자 정의 코드로 만든 모델을 auto 클래스로 등록하기",wl,Qe,Cs=`🤗 Transformers를 상속하는 라이브러리를 작성하는 경우 사용자 정의 모델을 auto 클래스에 추가할 수 있습니다.
사용자 정의 모델을 사용하기 위해 해당 라이브러리를 임포트해야 하기 때문에, 이는 Hub로 코드를 업로드하는 것과 다릅니다 (Hub에서 자동적으로 모델 코드를 다운로드 하는 것과 반대).`,Tl,He,bs=`구성에 기존 모델 유형과 다른 <code>model_type</code> 속성이 있고 모델 클래스에 올바른 <code>config_class</code> 속성이 있는 한,
다음과 같이 auto 클래스에 추가할 수 있습니다:`,ul,ze,jl,Fe,Is=`사용자 정의 구성을 <code>AutoConfig</code>에 등록할 때 사용되는 첫 번째 인수는 사용자 정의 구성의 <code>model_type</code>과 일치해야 합니다.
또한, 사용자 정의 모델을 auto 클래스에 등록할 때 사용되는 첫 번째 인수는 해당 모델의 <code>config_class</code>와 일치해야 합니다.`,fl,it,Ul;return G=new et({}),Q=new et({}),F=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PretrainedConfig
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetConfig</span>(<span class="hljs-title class_ inherited__">PretrainedConfig</span>):
    model_type = <span class="hljs-string">&quot;resnet&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>,
        layers: <span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>] = [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">6</span>, <span class="hljs-number">3</span>],
        num_classes: <span class="hljs-built_in">int</span> = <span class="hljs-number">1000</span>,
        input_channels: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>,
        cardinality: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span>,
        base_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_type: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;&quot;</span>,
        avg_down: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
        **kwargs,
    </span>):
        <span class="hljs-keyword">if</span> block_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;basic&quot;</span>, <span class="hljs-string">&quot;bottleneck&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`block_type\` must be &#x27;basic&#x27; or bottleneck&#x27;, got <span class="hljs-subst">{block_type}</span>.&quot;</span>)
        <span class="hljs-keyword">if</span> stem_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;deep&quot;</span>, <span class="hljs-string">&quot;deep-tiered&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`stem_type\` must be &#x27;&#x27;, &#x27;deep&#x27; or &#x27;deep-tiered&#x27;, got <span class="hljs-subst">{stem_type}</span>.&quot;</span>)

        self.block_type = block_type
        self.layers = layers
        self.num_classes = num_classes
        self.input_channels = input_channels
        self.cardinality = cardinality
        self.base_width = base_width
        self.stem_width = stem_width
        self.stem_type = stem_type
        self.avg_down = avg_down
        <span class="hljs-built_in">super</span>().__init__(**kwargs)`}}),K=new f({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d_config.save_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)`}}),ee=new f({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:'resnet50d_config = ResnetConfig.from_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)'}}),le=new et({}),ae=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRNb2RlbCUwQWZyb20lMjB0aW1tLm1vZGVscy5yZXNuZXQlMjBpbXBvcnQlMjBCYXNpY0Jsb2NrJTJDJTIwQm90dGxlbmVjayUyQyUyMFJlc05ldCUwQWZyb20lMjAuY29uZmlndXJhdGlvbl9yZXNuZXQlMjBpbXBvcnQlMjBSZXNuZXRDb25maWclMEElMEElMEFCTE9DS19NQVBQSU5HJTIwJTNEJTIwJTdCJTIyYmFzaWMlMjIlM0ElMjBCYXNpY0Jsb2NrJTJDJTIwJTIyYm90dGxlbmVjayUyMiUzQSUyMEJvdHRsZW5lY2slN0QlMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb25maWdfY2xhc3MlMjAlM0QlMjBSZXNuZXRDb25maWclMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX2xheWVyJTIwJTNEJTIwQkxPQ0tfTUFQUElORyU1QmNvbmZpZy5ibG9ja190eXBlJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbCUyMCUzRCUyMFJlc05ldCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbmZpZy5sYXllcnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fY2xhc3NlcyUzRGNvbmZpZy5udW1fY2xhc3NlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5zJTNEY29uZmlnLmlucHV0X2NoYW5uZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FyZGluYWxpdHklM0Rjb25maWcuY2FyZGluYWxpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXNlX3dpZHRoJTNEY29uZmlnLmJhc2Vfd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3dpZHRoJTNEY29uZmlnLnN0ZW1fd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3R5cGUlM0Rjb25maWcuc3RlbV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXZnX2Rvd24lM0Rjb25maWcuYXZnX2Rvd24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubW9kZWwuZm9yd2FyZF9mZWF0dXJlcyh0ZW5zb3Ip",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedModel
<span class="hljs-keyword">from</span> timm.models.resnet <span class="hljs-keyword">import</span> BasicBlock, Bottleneck, ResNet
<span class="hljs-keyword">from</span> .configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig


BLOCK_MAPPING = {<span class="hljs-string">&quot;basic&quot;</span>: BasicBlock, <span class="hljs-string">&quot;bottleneck&quot;</span>: Bottleneck}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor</span>):
        <span class="hljs-keyword">return</span> self.model.forward_features(tensor)`}}),ie=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihQcmVUcmFpbmVkTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnX2NsYXNzJTIwJTNEJTIwUmVzbmV0Q29uZmlnJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyMCUzRCUyMEJMT0NLX01BUFBJTkclNUJjb25maWcuYmxvY2tfdHlwZSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWwlMjAlM0QlMjBSZXNOZXQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfbGF5ZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcubGF5ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2NsYXNzZXMlM0Rjb25maWcubnVtX2NsYXNzZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbl9jaGFucyUzRGNvbmZpZy5pbnB1dF9jaGFubmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRpbmFsaXR5JTNEY29uZmlnLmNhcmRpbmFsaXR5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmFzZV93aWR0aCUzRGNvbmZpZy5iYXNlX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV93aWR0aCUzRGNvbmZpZy5zdGVtX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV90eXBlJTNEY29uZmlnLnN0ZW1fdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF2Z19kb3duJTNEY29uZmlnLmF2Z19kb3duJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHRlbnNvciUyQyUyMGxhYmVscyUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwc2VsZi5tb2RlbCh0ZW5zb3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsYWJlbHMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwdG9yY2gubm4uY3Jvc3NfZW50cm9weShsb2dpdHMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybG9zcyUyMiUzQSUyMGxvc3MlMkMlMjAlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0Q=",highlighted:`<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModelForImageClassification</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor, labels=<span class="hljs-literal">None</span></span>):
        logits = self.model(tensor)
        <span class="hljs-keyword">if</span> labels <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            loss = torch.nn.cross_entropy(logits, labels)
            <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;loss&quot;</span>: loss, <span class="hljs-string">&quot;logits&quot;</span>: logits}
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;logits&quot;</span>: logits}`}}),N=new Nl({props:{$$slots:{default:[Ys]},$$scope:{ctx:g}}}),re=new f({props:{code:"cmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcp",highlighted:"resnet50d = ResnetModelForImageClassification(resnet50d_config)"}}),me=new f({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQXByZXRyYWluZWRfbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCglMjJyZXNuZXQ1MGQlMjIlMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFyZXNuZXQ1MGQubW9kZWwubG9hZF9zdGF0ZV9kaWN0KHByZXRyYWluZWRfbW9kZWwuc3RhdGVfZGljdCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`}}),we=new et({}),W=new Nl({props:{warning:!0,$$slots:{default:[Vs]},$$scope:{ctx:g}}}),ue=new f({props:{code:"LiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHJlc25ldF9tb2RlbCUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMF9faW5pdF9fLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlndXJhdGlvbl9yZXNuZXQucHklMEElMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBtb2RlbGluZ19yZXNuZXQucHk=",highlighted:`.
└── resnet_model
    ├── __init__.<span class="hljs-keyword">py</span>
    ├── configuration_resnet.<span class="hljs-keyword">py</span>
    └── modeling_resnet.<span class="hljs-keyword">py</span>`}}),R=new Nl({props:{warning:!0,$$slots:{default:[Qs]},$$scope:{ctx:g}}}),he=new f({props:{code:"ZnJvbSUyMHJlc25ldF9tb2RlbC5jb25maWd1cmF0aW9uX3Jlc25ldCUyMGltcG9ydCUyMFJlc25ldENvbmZpZyUwQWZyb20lMjByZXNuZXRfbW9kZWwubW9kZWxpbmdfcmVzbmV0JTIwaW1wb3J0JTIwUmVzbmV0TW9kZWwlMkMlMjBSZXNuZXRNb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24=",highlighted:`<span class="hljs-keyword">from</span> resnet_model.configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig
<span class="hljs-keyword">from</span> resnet_model.modeling_resnet <span class="hljs-keyword">import</span> ResnetModel, ResnetModelForImageClassification`}}),be=new f({props:{code:"UmVzbmV0Q29uZmlnLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCklMEFSZXNuZXRNb2RlbC5yZWdpc3Rlcl9mb3JfYXV0b19jbGFzcyglMjJBdXRvTW9kZWwlMjIpJTBBUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCUyMkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMjIp",highlighted:`ResnetConfig.register_for_auto_class()
ResnetModel.register_for_auto_class(<span class="hljs-string">&quot;AutoModel&quot;</span>)
ResnetModelForImageClassification.register_for_auto_class(<span class="hljs-string">&quot;AutoModelForImageClassification&quot;</span>)`}}),Ze=new f({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcpJTBBJTBBcHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXJlc25ldDUwZC5tb2RlbC5sb2FkX3N0YXRlX2RpY3QocHJldHJhaW5lZF9tb2RlbC5zdGF0ZV9kaWN0KCkp",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d = ResnetModelForImageClassification(resnet50d_config)

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`}}),ge=new f({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login"}}),$e=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`}}),Ne=new f({props:{code:"cmVzbmV0NTBkLnB1c2hfdG9faHViKCUyMmN1c3RvbS1yZXNuZXQ1MGQlMjIp",highlighted:'resnet50d.push_to_hub(<span class="hljs-string">&quot;custom-resnet50d&quot;</span>)'}}),Re=new et({}),xe=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnNndWdnZXIlMkZjdXN0b20tcmVzbmV0NTBkJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`}}),Ee=new f({props:{code:"Y29tbWl0X2hhc2glMjAlM0QlMjAlMjJlZDk0YTdjNjI0N2Q4YWVkY2U0NjQ3ZjAwZjIwZGU2ODc1YjViMjkyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzZ3VnZ2VyJTJGY3VzdG9tLXJlc25ldDUwZCUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUyQyUyMHJldmlzaW9uJTNEY29tbWl0X2hhc2glMEEp",highlighted:`commit_hash = <span class="hljs-string">&quot;ed94a7c6247d8aedce4647f00f20de6875b5b292&quot;</span>
model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, revision=commit_hash
)`}}),Ve=new et({}),ze=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBQXV0b0NvbmZpZy5yZWdpc3RlciglMjJyZXNuZXQlMjIlMkMlMjBSZXNuZXRDb25maWcpJTBBQXV0b01vZGVsLnJlZ2lzdGVyKFJlc25ldENvbmZpZyUyQyUyMFJlc25ldE1vZGVsKSUwQUF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24ucmVnaXN0ZXIoUmVzbmV0Q29uZmlnJTJDJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel, AutoModelForImageClassification

AutoConfig.register(<span class="hljs-string">&quot;resnet&quot;</span>, ResnetConfig)
AutoModel.register(ResnetConfig, ResnetModel)
AutoModelForImageClassification.register(ResnetConfig, ResnetModelForImageClassification)`}}),{c(){p=M("meta"),U=n(),u=M("p"),h=n(),C=M("h1"),A=M("a"),tt=M("span"),c(G.$$.fragment),Zl=n(),Le=M("span"),Le.textContent=Wl,ct=n(),E=M("p"),E.textContent=Rl,rt=n(),Y=M("p"),Y.textContent=Xl,yt=n(),V=M("p"),V.innerHTML=xl,dt=n(),b=M("h2"),$=M("a"),lt=M("span"),c(Q.$$.fragment),vl=n(),qe=M("span"),qe.textContent=Gl,mt=n(),H=M("p"),H.innerHTML=El,Jt=n(),z=M("p"),z.textContent=Yl,wt=n(),c(F.$$.fragment),Tt=n(),S=M("p"),S.innerHTML=Vl,ut=n(),L=M("ul"),L.innerHTML=Ql,jt=n(),q=M("p"),q.innerHTML=Hl,ft=n(),P=M("p"),P.innerHTML=zl,Ut=n(),D=M("p"),D.textContent=Fl,ht=n(),c(K.$$.fragment),Ct=n(),O=M("p"),O.innerHTML=Sl,bt=n(),c(ee.$$.fragment),It=n(),te=M("p"),te.innerHTML=Ll,_t=n(),I=M("h2"),k=M("a"),st=M("span"),c(le.$$.fragment),gl=n(),Pe=M("span"),Pe.textContent=ql,Zt=n(),se=M("p"),se.innerHTML=Pl,vt=n(),ne=M("p"),ne.innerHTML=Dl,gt=n(),c(ae.$$.fragment),At=n(),Me=M("p"),Me.textContent=Kl,$t=n(),c(ie.$$.fragment),kt=n(),oe=M("p"),oe.innerHTML=Ol,Nt=n(),c(N.$$.fragment),Bt=n(),pe=M("p"),pe.innerHTML=es,Wt=n(),ce=M("p"),ce.textContent=ts,Rt=n(),c(re.$$.fragment),Xt=n(),ye=M("p"),ye.innerHTML=ls,xt=n(),de=M("p"),de.textContent=ss,Gt=n(),c(me.$$.fragment),Et=n(),Je=M("p"),Je.innerHTML=ns,Yt=n(),_=M("h2"),B=M("a"),nt=M("span"),c(we.$$.fragment),Al=n(),De=M("span"),De.textContent=as,Vt=n(),c(W.$$.fragment),Qt=n(),Te=M("p"),Te.innerHTML=Ms,Ht=n(),c(ue.$$.fragment),zt=n(),je=M("p"),je.innerHTML=is,Ft=n(),c(R.$$.fragment),St=n(),fe=M("p"),fe.textContent=os,Lt=n(),Ue=M("p"),Ue.textContent=ps,qt=n(),c(he.$$.fragment),Pt=n(),Ce=M("p"),Ce.innerHTML=cs,Dt=n(),c(be.$$.fragment),Kt=n(),Ie=M("p"),Ie.innerHTML=rs,Ot=n(),_e=M("p"),_e.textContent=ys,el=n(),c(Ze.$$.fragment),tl=n(),ve=M("p"),ve.textContent=ds,ll=n(),c(ge.$$.fragment),sl=n(),Ae=M("p"),Ae.textContent=ms,nl=n(),c($e.$$.fragment),al=n(),ke=M("p"),ke.textContent=Js,Ml=n(),c(Ne.$$.fragment),il=n(),Be=M("p"),Be.innerHTML=ws,ol=n(),We=M("p"),We.innerHTML=Ts,pl=n(),Z=M("h2"),X=M("a"),at=M("span"),c(Re.$$.fragment),$l=n(),Ke=M("span"),Ke.textContent=us,cl=n(),Xe=M("p"),Xe.innerHTML=js,rl=n(),c(xe.$$.fragment),yl=n(),Ge=M("p"),Ge.innerHTML=fs,dl=n(),c(Ee.$$.fragment),ml=n(),Ye=M("p"),Ye.textContent=Us,Jl=n(),v=M("h2"),x=M("a"),Mt=M("span"),c(Ve.$$.fragment),kl=n(),Oe=M("span"),Oe.textContent=hs,wl=n(),Qe=M("p"),Qe.textContent=Cs,Tl=n(),He=M("p"),He.innerHTML=bs,ul=n(),c(ze.$$.fragment),jl=n(),Fe=M("p"),Fe.innerHTML=Is,fl=n(),it=M("p"),this.h()},l(e){const t=Es("svelte-1phssyn",document.head);p=i(t,"META",{name:!0,content:!0}),t.forEach(l),U=a(e),u=i(e,"P",{}),j(u).forEach(l),h=a(e),C=i(e,"H1",{class:!0});var Se=j(C);A=i(Se,"A",{id:!0,class:!0,href:!0});var ot=j(A);tt=i(ot,"SPAN",{});var pt=j(tt);r(G.$$.fragment,pt),pt.forEach(l),ot.forEach(l),Zl=a(Se),Le=i(Se,"SPAN",{"data-svelte-h":!0}),o(Le)!=="svelte-sbleqg"&&(Le.textContent=Wl),Se.forEach(l),ct=a(e),E=i(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-al07n"&&(E.textContent=Rl),rt=a(e),Y=i(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1lxcxix"&&(Y.textContent=Xl),yt=a(e),V=i(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-119rg2w"&&(V.innerHTML=xl),dt=a(e),b=i(e,"H2",{class:!0});var hl=j(b);$=i(hl,"A",{id:!0,class:!0,href:!0});var _s=j($);lt=i(_s,"SPAN",{});var Zs=j(lt);r(Q.$$.fragment,Zs),Zs.forEach(l),_s.forEach(l),vl=a(hl),qe=i(hl,"SPAN",{"data-svelte-h":!0}),o(qe)!=="svelte-1dprsqe"&&(qe.textContent=Gl),hl.forEach(l),mt=a(e),H=i(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-la43mp"&&(H.innerHTML=El),Jt=a(e),z=i(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1qc22zw"&&(z.textContent=Yl),wt=a(e),r(F.$$.fragment,e),Tt=a(e),S=i(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-nxq6mo"&&(S.innerHTML=Vl),ut=a(e),L=i(e,"UL",{"data-svelte-h":!0}),o(L)!=="svelte-1tfxli8"&&(L.innerHTML=Ql),jt=a(e),q=i(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-x5ckqo"&&(q.innerHTML=Hl),ft=a(e),P=i(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1kaub1g"&&(P.innerHTML=zl),Ut=a(e),D=i(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-ovl0zx"&&(D.textContent=Fl),ht=a(e),r(K.$$.fragment,e),Ct=a(e),O=i(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-d1xscf"&&(O.innerHTML=Sl),bt=a(e),r(ee.$$.fragment,e),It=a(e),te=i(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-g1m52h"&&(te.innerHTML=Ll),_t=a(e),I=i(e,"H2",{class:!0});var Cl=j(I);k=i(Cl,"A",{id:!0,class:!0,href:!0});var vs=j(k);st=i(vs,"SPAN",{});var gs=j(st);r(le.$$.fragment,gs),gs.forEach(l),vs.forEach(l),gl=a(Cl),Pe=i(Cl,"SPAN",{"data-svelte-h":!0}),o(Pe)!=="svelte-rrb1t5"&&(Pe.textContent=ql),Cl.forEach(l),Zt=a(e),se=i(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-6nuh70"&&(se.innerHTML=Pl),vt=a(e),ne=i(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1ufn8h6"&&(ne.innerHTML=Dl),gt=a(e),r(ae.$$.fragment,e),At=a(e),Me=i(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-10szka3"&&(Me.textContent=Kl),$t=a(e),r(ie.$$.fragment,e),kt=a(e),oe=i(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-1g3ya33"&&(oe.innerHTML=Ol),Nt=a(e),r(N.$$.fragment,e),Bt=a(e),pe=i(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-1f99hcg"&&(pe.innerHTML=es),Wt=a(e),ce=i(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-68rs2x"&&(ce.textContent=ts),Rt=a(e),r(re.$$.fragment,e),Xt=a(e),ye=i(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-10d07s4"&&(ye.innerHTML=ls),xt=a(e),de=i(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-1319e67"&&(de.textContent=ss),Gt=a(e),r(me.$$.fragment,e),Et=a(e),Je=i(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-rtsgc0"&&(Je.innerHTML=ns),Yt=a(e),_=i(e,"H2",{class:!0});var bl=j(_);B=i(bl,"A",{id:!0,class:!0,href:!0});var As=j(B);nt=i(As,"SPAN",{});var $s=j(nt);r(we.$$.fragment,$s),$s.forEach(l),As.forEach(l),Al=a(bl),De=i(bl,"SPAN",{"data-svelte-h":!0}),o(De)!=="svelte-ge3v4r"&&(De.textContent=as),bl.forEach(l),Vt=a(e),r(W.$$.fragment,e),Qt=a(e),Te=i(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-q87di4"&&(Te.innerHTML=Ms),Ht=a(e),r(ue.$$.fragment,e),zt=a(e),je=i(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-fw3tvd"&&(je.innerHTML=is),Ft=a(e),r(R.$$.fragment,e),St=a(e),fe=i(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-19tqquy"&&(fe.textContent=os),Lt=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-1tgl3y3"&&(Ue.textContent=ps),qt=a(e),r(he.$$.fragment,e),Pt=a(e),Ce=i(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-85qz6h"&&(Ce.innerHTML=cs),Dt=a(e),r(be.$$.fragment,e),Kt=a(e),Ie=i(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-urqb2q"&&(Ie.innerHTML=rs),Ot=a(e),_e=i(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-th8o9z"&&(_e.textContent=ys),el=a(e),r(Ze.$$.fragment,e),tl=a(e),ve=i(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-1xhzef1"&&(ve.textContent=ds),ll=a(e),r(ge.$$.fragment,e),sl=a(e),Ae=i(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-4bt266"&&(Ae.textContent=ms),nl=a(e),r($e.$$.fragment,e),al=a(e),ke=i(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-xc5sk0"&&(ke.textContent=Js),Ml=a(e),r(Ne.$$.fragment,e),il=a(e),Be=i(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-dnw5aw"&&(Be.innerHTML=ws),ol=a(e),We=i(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-2rsbbb"&&(We.innerHTML=Ts),pl=a(e),Z=i(e,"H2",{class:!0});var Il=j(Z);X=i(Il,"A",{id:!0,class:!0,href:!0});var ks=j(X);at=i(ks,"SPAN",{});var Ns=j(at);r(Re.$$.fragment,Ns),Ns.forEach(l),ks.forEach(l),$l=a(Il),Ke=i(Il,"SPAN",{"data-svelte-h":!0}),o(Ke)!=="svelte-yszqfe"&&(Ke.textContent=us),Il.forEach(l),cl=a(e),Xe=i(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-1m1cooj"&&(Xe.innerHTML=js),rl=a(e),r(xe.$$.fragment,e),yl=a(e),Ge=i(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-18oh14g"&&(Ge.innerHTML=fs),dl=a(e),r(Ee.$$.fragment,e),ml=a(e),Ye=i(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-eerkzr"&&(Ye.textContent=Us),Jl=a(e),v=i(e,"H2",{class:!0});var _l=j(v);x=i(_l,"A",{id:!0,class:!0,href:!0});var Bs=j(x);Mt=i(Bs,"SPAN",{});var Ws=j(Mt);r(Ve.$$.fragment,Ws),Ws.forEach(l),Bs.forEach(l),kl=a(_l),Oe=i(_l,"SPAN",{"data-svelte-h":!0}),o(Oe)!=="svelte-juqmvo"&&(Oe.textContent=hs),_l.forEach(l),wl=a(e),Qe=i(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-1w0yfzt"&&(Qe.textContent=Cs),Tl=a(e),He=i(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-xh4cqs"&&(He.innerHTML=bs),ul=a(e),r(ze.$$.fragment,e),jl=a(e),Fe=i(e,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-9j79lz"&&(Fe.innerHTML=Is),fl=a(e),it=i(e,"P",{}),j(it).forEach(l),this.h()},h(){y(p,"name","hf:doc:metadata"),y(p,"content",JSON.stringify(zs)),y(A,"id","sharing-custom-models"),y(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(A,"href","#sharing-custom-models"),y(C,"class","relative group"),y($,"id","writing-a-custom-configuration"),y($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y($,"href","#writing-a-custom-configuration"),y(b,"class","relative group"),y(k,"id","writing-a-custom-model"),y(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(k,"href","#writing-a-custom-model"),y(I,"class","relative group"),y(B,"id","sending-the-code-to-the-hub"),y(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(B,"href","#sending-the-code-to-the-hub"),y(_,"class","relative group"),y(X,"id","using-a-model-with-custom-code"),y(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(X,"href","#using-a-model-with-custom-code"),y(Z,"class","relative group"),y(x,"id","registering-a-model-with-custom-code-to-the-auto-classes"),y(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(x,"href","#registering-a-model-with-custom-code-to-the-auto-classes"),y(v,"class","relative group")},m(e,t){T(document.head,p),s(e,U,t),s(e,u,t),s(e,h,t),s(e,C,t),T(C,A),T(A,tt),d(G,tt,null),T(C,Zl),T(C,Le),s(e,ct,t),s(e,E,t),s(e,rt,t),s(e,Y,t),s(e,yt,t),s(e,V,t),s(e,dt,t),s(e,b,t),T(b,$),T($,lt),d(Q,lt,null),T(b,vl),T(b,qe),s(e,mt,t),s(e,H,t),s(e,Jt,t),s(e,z,t),s(e,wt,t),d(F,e,t),s(e,Tt,t),s(e,S,t),s(e,ut,t),s(e,L,t),s(e,jt,t),s(e,q,t),s(e,ft,t),s(e,P,t),s(e,Ut,t),s(e,D,t),s(e,ht,t),d(K,e,t),s(e,Ct,t),s(e,O,t),s(e,bt,t),d(ee,e,t),s(e,It,t),s(e,te,t),s(e,_t,t),s(e,I,t),T(I,k),T(k,st),d(le,st,null),T(I,gl),T(I,Pe),s(e,Zt,t),s(e,se,t),s(e,vt,t),s(e,ne,t),s(e,gt,t),d(ae,e,t),s(e,At,t),s(e,Me,t),s(e,$t,t),d(ie,e,t),s(e,kt,t),s(e,oe,t),s(e,Nt,t),d(N,e,t),s(e,Bt,t),s(e,pe,t),s(e,Wt,t),s(e,ce,t),s(e,Rt,t),d(re,e,t),s(e,Xt,t),s(e,ye,t),s(e,xt,t),s(e,de,t),s(e,Gt,t),d(me,e,t),s(e,Et,t),s(e,Je,t),s(e,Yt,t),s(e,_,t),T(_,B),T(B,nt),d(we,nt,null),T(_,Al),T(_,De),s(e,Vt,t),d(W,e,t),s(e,Qt,t),s(e,Te,t),s(e,Ht,t),d(ue,e,t),s(e,zt,t),s(e,je,t),s(e,Ft,t),d(R,e,t),s(e,St,t),s(e,fe,t),s(e,Lt,t),s(e,Ue,t),s(e,qt,t),d(he,e,t),s(e,Pt,t),s(e,Ce,t),s(e,Dt,t),d(be,e,t),s(e,Kt,t),s(e,Ie,t),s(e,Ot,t),s(e,_e,t),s(e,el,t),d(Ze,e,t),s(e,tl,t),s(e,ve,t),s(e,ll,t),d(ge,e,t),s(e,sl,t),s(e,Ae,t),s(e,nl,t),d($e,e,t),s(e,al,t),s(e,ke,t),s(e,Ml,t),d(Ne,e,t),s(e,il,t),s(e,Be,t),s(e,ol,t),s(e,We,t),s(e,pl,t),s(e,Z,t),T(Z,X),T(X,at),d(Re,at,null),T(Z,$l),T(Z,Ke),s(e,cl,t),s(e,Xe,t),s(e,rl,t),d(xe,e,t),s(e,yl,t),s(e,Ge,t),s(e,dl,t),d(Ee,e,t),s(e,ml,t),s(e,Ye,t),s(e,Jl,t),s(e,v,t),T(v,x),T(x,Mt),d(Ve,Mt,null),T(v,kl),T(v,Oe),s(e,wl,t),s(e,Qe,t),s(e,Tl,t),s(e,He,t),s(e,ul,t),d(ze,e,t),s(e,jl,t),s(e,Fe,t),s(e,fl,t),s(e,it,t),Ul=!0},p(e,[t]){const Se={};t&2&&(Se.$$scope={dirty:t,ctx:e}),N.$set(Se);const ot={};t&2&&(ot.$$scope={dirty:t,ctx:e}),W.$set(ot);const pt={};t&2&&(pt.$$scope={dirty:t,ctx:e}),R.$set(pt)},i(e){Ul||(m(G.$$.fragment,e),m(Q.$$.fragment,e),m(F.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(ae.$$.fragment,e),m(ie.$$.fragment,e),m(N.$$.fragment,e),m(re.$$.fragment,e),m(me.$$.fragment,e),m(we.$$.fragment,e),m(W.$$.fragment,e),m(ue.$$.fragment,e),m(R.$$.fragment,e),m(he.$$.fragment,e),m(be.$$.fragment,e),m(Ze.$$.fragment,e),m(ge.$$.fragment,e),m($e.$$.fragment,e),m(Ne.$$.fragment,e),m(Re.$$.fragment,e),m(xe.$$.fragment,e),m(Ee.$$.fragment,e),m(Ve.$$.fragment,e),m(ze.$$.fragment,e),Ul=!0)},o(e){J(G.$$.fragment,e),J(Q.$$.fragment,e),J(F.$$.fragment,e),J(K.$$.fragment,e),J(ee.$$.fragment,e),J(le.$$.fragment,e),J(ae.$$.fragment,e),J(ie.$$.fragment,e),J(N.$$.fragment,e),J(re.$$.fragment,e),J(me.$$.fragment,e),J(we.$$.fragment,e),J(W.$$.fragment,e),J(ue.$$.fragment,e),J(R.$$.fragment,e),J(he.$$.fragment,e),J(be.$$.fragment,e),J(Ze.$$.fragment,e),J(ge.$$.fragment,e),J($e.$$.fragment,e),J(Ne.$$.fragment,e),J(Re.$$.fragment,e),J(xe.$$.fragment,e),J(Ee.$$.fragment,e),J(Ve.$$.fragment,e),J(ze.$$.fragment,e),Ul=!1},d(e){e&&(l(U),l(u),l(h),l(C),l(ct),l(E),l(rt),l(Y),l(yt),l(V),l(dt),l(b),l(mt),l(H),l(Jt),l(z),l(wt),l(Tt),l(S),l(ut),l(L),l(jt),l(q),l(ft),l(P),l(Ut),l(D),l(ht),l(Ct),l(O),l(bt),l(It),l(te),l(_t),l(I),l(Zt),l(se),l(vt),l(ne),l(gt),l(At),l(Me),l($t),l(kt),l(oe),l(Nt),l(Bt),l(pe),l(Wt),l(ce),l(Rt),l(Xt),l(ye),l(xt),l(de),l(Gt),l(Et),l(Je),l(Yt),l(_),l(Vt),l(Qt),l(Te),l(Ht),l(zt),l(je),l(Ft),l(St),l(fe),l(Lt),l(Ue),l(qt),l(Pt),l(Ce),l(Dt),l(Kt),l(Ie),l(Ot),l(_e),l(el),l(tl),l(ve),l(ll),l(sl),l(Ae),l(nl),l(al),l(ke),l(Ml),l(il),l(Be),l(ol),l(We),l(pl),l(Z),l(cl),l(Xe),l(rl),l(yl),l(Ge),l(dl),l(ml),l(Ye),l(Jl),l(v),l(wl),l(Qe),l(Tl),l(He),l(ul),l(jl),l(Fe),l(fl),l(it)),l(p),w(G),w(Q),w(F,e),w(K,e),w(ee,e),w(le),w(ae,e),w(ie,e),w(N,e),w(re,e),w(me,e),w(we),w(W,e),w(ue,e),w(R,e),w(he,e),w(be,e),w(Ze,e),w(ge,e),w($e,e),w(Ne,e),w(Re),w(xe,e),w(Ee,e),w(Ve),w(ze,e)}}}const zs={local:"sharing-custom-models",sections:[{local:"writing-a-custom-configuration",title:"사용자 정의 구성 작성하기"},{local:"writing-a-custom-model",title:"사용자 정의 모델 작성하기"},{local:"sending-the-code-to-the-hub",title:"Hub로 코드 업로드하기"},{local:"using-a-model-with-custom-code",title:"사용자 정의 코드로 모델 사용하기"},{local:"registering-a-model-with-custom-code-to-the-auto-classes",title:"사용자 정의 코드로 만든 모델을 auto 클래스로 등록하기"}],title:"사용자 정의 모델 공유하기"};function Fs(g){return Xs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ks extends xs{constructor(p){super(),Gs(this,p,Fs,Hs,Rs,{})}}export{Ks as component};
