import{s as Ta,o as xa,n as S}from"../chunks/scheduler.9bc65507.js";import{S as Aa,i as Ma,g as i,s as r,r as c,A as ka,h as m,f as o,c as n,j as T,u as g,x as v,k as x,y as t,a as d,v as f,d as u,t as h,w as $}from"../chunks/index.707bf1b6.js";import{T as Ln}from"../chunks/Tip.c2ecdbf4.js";import{D as A}from"../chunks/Docstring.17db21ae.js";import{C as Jt}from"../chunks/CodeBlock.54a9f38d.js";import{E as Lt}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H}from"../chunks/Heading.342b1fa6.js";function Ia(k){let l,w=`Transformers Agents は実験的な API であり、いつでも変更される可能性があります。エージェントから返される結果
API または基礎となるモデルは変更される傾向があるため、変更される可能性があります。`;return{c(){l=i("p"),l.textContent=w},l(_){l=m(_,"P",{"data-svelte-h":!0}),v(l)!=="svelte-1j35sfa"&&(l.textContent=w)},m(_,p){d(_,l,p)},p:S,d(_){_&&o(l)}}}function Ca(k){let l,w="Example:",_,p,b;return p=new Jt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEhmQWdlbnQlMEElMEFhZ2VudCUyMCUzRCUyMEhmQWdlbnQoJTIyaHR0cHMlM0ElMkYlMkZhcGktaW5mZXJlbmNlLmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJTJGYmlnY29kZSUyRnN0YXJjb2RlciUyMiklMEFhZ2VudC5ydW4oJTIySXMlMjB0aGUlMjBmb2xsb3dpbmclMjAlNjB0ZXh0JTYwJTIwKGluJTIwU3BhbmlzaCklMjBwb3NpdGl2ZSUyMG9yJTIwbmVnYXRpdmUlM0YlMjIlMkMlMjB0ZXh0JTNEJTIyJUMyJUExRXN0ZSUyMGVzJTIwdW4lMjBBUEklMjBtdXklMjBhZ3JhZGFibGUhJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HfAgent

agent = HfAgent(<span class="hljs-string">&quot;https://api-inference.huggingface.co/models/bigcode/starcoder&quot;</span>)
agent.run(<span class="hljs-string">&quot;Is the following \`text\` (in Spanish) positive or negative?&quot;</span>, text=<span class="hljs-string">&quot;¡Este es un API muy agradable!&quot;</span>)`,wrap:!1}}),{c(){l=i("p"),l.textContent=w,_=r(),c(p.$$.fragment)},l(a){l=m(a,"P",{"data-svelte-h":!0}),v(l)!=="svelte-11lpom8"&&(l.textContent=w),_=n(a),g(p.$$.fragment,a)},m(a,y){d(a,l,y),d(a,_,y),f(p,a,y),b=!0},p:S,i(a){b||(u(p.$$.fragment,a),b=!0)},o(a){h(p.$$.fragment,a),b=!1},d(a){a&&(o(l),o(_)),$(p,a)}}}function Ha(k){let l,w="Example:",_,p,b;return p=new Jt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTJDJTIwTG9jYWxBZ2VudCUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJiaWdjb2RlJTJGc3RhcmNvZGVyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQWFnZW50JTIwJTNEJTIwTG9jYWxBZ2VudChtb2RlbCUyQyUyMHRva2VuaXplciklMEFhZ2VudC5ydW4oJTIyRHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzLiUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, LocalAgent

checkpoint = <span class="hljs-string">&quot;bigcode/starcoder&quot;</span>
model = AutoModelForCausalLM.from_pretrained(checkpoint, device_map=<span class="hljs-string">&quot;auto&quot;</span>, torch_dtype=torch.bfloat16)
tokenizer = AutoTokenizer.from_pretrained(checkpoint)

agent = LocalAgent(model, tokenizer)
agent.run(<span class="hljs-string">&quot;Draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),{c(){l=i("p"),l.textContent=w,_=r(),c(p.$$.fragment)},l(a){l=m(a,"P",{"data-svelte-h":!0}),v(l)!=="svelte-11lpom8"&&(l.textContent=w),_=n(a),g(p.$$.fragment,a)},m(a,y){d(a,l,y),d(a,_,y),f(p,a,y),b=!0},p:S,i(a){b||(u(p.$$.fragment,a),b=!0)},o(a){h(p.$$.fragment,a),b=!1},d(a){a&&(o(l),o(_)),$(p,a)}}}function ja(k){let l,w="Example:",_,p,b;return p=new Jt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwTG9jYWxBZ2VudCUwQSUwQWFnZW50JTIwJTNEJTIwTG9jYWxBZ2VudC5mcm9tX3ByZXRyYWluZWQoJTIyYmlnY29kZSUyRnN0YXJjb2RlciUyMiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFhZ2VudC5ydW4oJTIyRHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzLiUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LocalAgent

agent = LocalAgent.from_pretrained(<span class="hljs-string">&quot;bigcode/starcoder&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, torch_dtype=torch.bfloat16)
agent.run(<span class="hljs-string">&quot;Draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),{c(){l=i("p"),l.textContent=w,_=r(),c(p.$$.fragment)},l(a){l=m(a,"P",{"data-svelte-h":!0}),v(l)!=="svelte-11lpom8"&&(l.textContent=w),_=n(a),g(p.$$.fragment,a)},m(a,y){d(a,l,y),d(a,_,y),f(p,a,y),b=!0},p:S,i(a){b||(u(p.$$.fragment,a),b=!0)},o(a){h(p.$$.fragment,a),b=!1},d(a){a&&(o(l),o(_)),$(p,a)}}}function La(k){let l,w=`The openAI models are used in generation mode, so even for the <code>chat()</code> API, it’s better to use models like
<code>&quot;text-davinci-003&quot;</code> over the chat-GPT variant. Proper support for chat-GPT models will come in a next version.`;return{c(){l=i("p"),l.innerHTML=w},l(_){l=m(_,"P",{"data-svelte-h":!0}),v(l)!=="svelte-3idp4e"&&(l.innerHTML=w)},m(_,p){d(_,l,p)},p:S,d(_){_&&o(l)}}}function Ja(k){let l,w="Example:",_,p,b;return p=new Jt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME9wZW5BaUFnZW50JTBBJTBBYWdlbnQlMjAlM0QlMjBPcGVuQWlBZ2VudChtb2RlbCUzRCUyMnRleHQtZGF2aW5jaS0wMDMlMjIlMkMlMjBhcGlfa2V5JTNEeHh4KSUwQWFnZW50LnJ1biglMjJJcyUyMHRoZSUyMGZvbGxvd2luZyUyMCU2MHRleHQlNjAlMjAoaW4lMjBTcGFuaXNoKSUyMHBvc2l0aXZlJTIwb3IlMjBuZWdhdGl2ZSUzRiUyMiUyQyUyMHRleHQlM0QlMjIlQzIlQTFFc3RlJTIwZXMlMjB1biUyMEFQSSUyMG11eSUyMGFncmFkYWJsZSElMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OpenAiAgent

agent = OpenAiAgent(model=<span class="hljs-string">&quot;text-davinci-003&quot;</span>, api_key=xxx)
agent.run(<span class="hljs-string">&quot;Is the following \`text\` (in Spanish) positive or negative?&quot;</span>, text=<span class="hljs-string">&quot;¡Este es un API muy agradable!&quot;</span>)`,wrap:!1}}),{c(){l=i("p"),l.textContent=w,_=r(),c(p.$$.fragment)},l(a){l=m(a,"P",{"data-svelte-h":!0}),v(l)!=="svelte-11lpom8"&&(l.textContent=w),_=n(a),g(p.$$.fragment,a)},m(a,y){d(a,l,y),d(a,_,y),f(p,a,y),b=!0},p:S,i(a){b||(u(p.$$.fragment,a),b=!0)},o(a){h(p.$$.fragment,a),b=!1},d(a){a&&(o(l),o(_)),$(p,a)}}}function Pa(k){let l,w=`The openAI models are used in generation mode, so even for the <code>chat()</code> API, it’s better to use models like
<code>&quot;text-davinci-003&quot;</code> over the chat-GPT variant. Proper support for chat-GPT models will come in a next version.`;return{c(){l=i("p"),l.innerHTML=w},l(_){l=m(_,"P",{"data-svelte-h":!0}),v(l)!=="svelte-3idp4e"&&(l.innerHTML=w)},m(_,p){d(_,l,p)},p:S,d(_){_&&o(l)}}}function Ua(k){let l,w="Example:",_,p,b;return p=new Jt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF6dXJlT3BlbkFpQWdlbnQlMEElMEFhZ2VudCUyMCUzRCUyMEF6dXJlQWlBZ2VudChkZXBsb3ltZW50X2lkJTNEJTIyRGF2aW5jaS0wMDMlMjIlMkMlMjBhcGlfa2V5JTNEeHh4JTJDJTIwcmVzb3VyY2VfbmFtZSUzRHl5eSklMEFhZ2VudC5ydW4oJTIySXMlMjB0aGUlMjBmb2xsb3dpbmclMjAlNjB0ZXh0JTYwJTIwKGluJTIwU3BhbmlzaCklMjBwb3NpdGl2ZSUyMG9yJTIwbmVnYXRpdmUlM0YlMjIlMkMlMjB0ZXh0JTNEJTIyJUMyJUExRXN0ZSUyMGVzJTIwdW4lMjBBUEklMjBtdXklMjBhZ3JhZGFibGUhJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AzureOpenAiAgent

agent = AzureAiAgent(deployment_id=<span class="hljs-string">&quot;Davinci-003&quot;</span>, api_key=xxx, resource_name=yyy)
agent.run(<span class="hljs-string">&quot;Is the following \`text\` (in Spanish) positive or negative?&quot;</span>, text=<span class="hljs-string">&quot;¡Este es un API muy agradable!&quot;</span>)`,wrap:!1}}),{c(){l=i("p"),l.textContent=w,_=r(),c(p.$$.fragment)},l(a){l=m(a,"P",{"data-svelte-h":!0}),v(l)!=="svelte-11lpom8"&&(l.textContent=w),_=n(a),g(p.$$.fragment,a)},m(a,y){d(a,l,y),d(a,_,y),f(p,a,y),b=!0},p:S,i(a){b||(u(p.$$.fragment,a),b=!0)},o(a){h(p.$$.fragment,a),b=!1},d(a){a&&(o(l),o(_)),$(p,a)}}}function qa(k){let l,w="Example:",_,p,b;return p=new Jt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEhmQWdlbnQlMEElMEFhZ2VudCUyMCUzRCUyMEhmQWdlbnQoJTIyaHR0cHMlM0ElMkYlMkZhcGktaW5mZXJlbmNlLmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJTJGYmlnY29kZSUyRnN0YXJjb2RlciUyMiklMEFhZ2VudC5jaGF0KCUyMkRyYXclMjBtZSUyMGElMjBwaWN0dXJlJTIwb2YlMjByaXZlcnMlMjBhbmQlMjBsYWtlcyUyMiklMEElMEFhZ2VudC5jaGF0KCUyMlRyYW5zZm9ybSUyMHRoZSUyMHBpY3R1cmUlMjBzbyUyMHRoYXQlMjB0aGVyZSUyMGlzJTIwYSUyMHJvY2slMjBpbiUyMHRoZXJlJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HfAgent

agent = HfAgent(<span class="hljs-string">&quot;https://api-inference.huggingface.co/models/bigcode/starcoder&quot;</span>)
agent.chat(<span class="hljs-string">&quot;Draw me a picture of rivers and lakes&quot;</span>)

agent.chat(<span class="hljs-string">&quot;Transform the picture so that there is a rock in there&quot;</span>)`,wrap:!1}}),{c(){l=i("p"),l.textContent=w,_=r(),c(p.$$.fragment)},l(a){l=m(a,"P",{"data-svelte-h":!0}),v(l)!=="svelte-11lpom8"&&(l.textContent=w),_=n(a),g(p.$$.fragment,a)},m(a,y){d(a,l,y),d(a,_,y),f(p,a,y),b=!0},p:S,i(a){b||(u(p.$$.fragment,a),b=!0)},o(a){h(p.$$.fragment,a),b=!1},d(a){a&&(o(l),o(_)),$(p,a)}}}function Ea(k){let l,w="Example:",_,p,b;return p=new Jt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEhmQWdlbnQlMEElMEFhZ2VudCUyMCUzRCUyMEhmQWdlbnQoJTIyaHR0cHMlM0ElMkYlMkZhcGktaW5mZXJlbmNlLmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJTJGYmlnY29kZSUyRnN0YXJjb2RlciUyMiklMEFhZ2VudC5ydW4oJTIyRHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HfAgent

agent = HfAgent(<span class="hljs-string">&quot;https://api-inference.huggingface.co/models/bigcode/starcoder&quot;</span>)
agent.run(<span class="hljs-string">&quot;Draw me a picture of rivers and lakes&quot;</span>)`,wrap:!1}}),{c(){l=i("p"),l.textContent=w,_=r(),c(p.$$.fragment)},l(a){l=m(a,"P",{"data-svelte-h":!0}),v(l)!=="svelte-11lpom8"&&(l.textContent=w),_=n(a),g(p.$$.fragment,a)},m(a,y){d(a,l,y),d(a,_,y),f(p,a,y),b=!0},p:S,i(a){b||(u(p.$$.fragment,a),b=!0)},o(a){h(p.$$.fragment,a),b=!1},d(a){a&&(o(l),o(_)),$(p,a)}}}function Za(k){let l,w,_,p,b,a,y,yo,He,Jn=`エージェントとツールの詳細については、<a href="../transformers_agents">入門ガイド</a> を必ずお読みください。このページ
基礎となるクラスの API ドキュメントが含まれています。`,wo,je,To,Le,Pn='私たちは 3 種類のエージェントを提供します。<a href="/docs/transformers/v4.35.0/ja/main_classes/agent#transformers.HfAgent">HfAgent</a> はオープンソース モデルの推論エンドポイントを使用し、<a href="/docs/transformers/v4.35.0/ja/main_classes/agent#transformers.LocalAgent">LocalAgent</a> は選択したモデルをローカルで使用し、<a href="/docs/transformers/v4.35.0/ja/main_classes/agent#transformers.OpenAiAgent">OpenAiAgent</a> は OpenAI クローズド モデルを使用します。',xo,Je,Ao,z,Pe,vr,Pt,Un="Agent that uses an inference endpoint to generate code.",br,re,Mo,Ue,ko,J,qe,yr,Ut,qn="Agent that uses a local model and tokenizer to generate code.",wr,ne,Tr,D,Ee,xr,qt,En="Convenience method to build a <code>LocalAgent</code> from a pretrained checkpoint.",Ar,ae,Io,Ze,Co,P,We,Mr,Et,Zn="Agent that uses the openai API to generate code.",kr,se,Ir,le,Ho,Re,jo,U,ze,Cr,Zt,Wn=`Agent that uses Azure OpenAI to generate code. See the <a href="https://learn.microsoft.com/en-us/azure/cognitive-services/openai/" rel="nofollow">official
documentation</a> to learn how to deploy an openAI
model on Azure`,Hr,ie,jr,me,Lo,Ge,Jo,j,Ve,Lr,Wt,Rn="Base class for all agents which contains the main API methods.",Jr,B,Ne,Pr,Rt,zn="Sends a new request to the agent in a chat. Will use the previous ones in its history.",Ur,de,qr,Y,De,Er,zt,Gn="Sends a request to the agent.",Zr,pe,Wr,ce,Be,Rr,Gt,Vn='Clears the history of prior calls to <a href="/docs/transformers/v4.35.0/ja/main_classes/agent#transformers.Agent.chat">chat()</a>.',Po,Ye,Uo,Fe,qo,Q,Se,zr,Vt,Nn="Main function to quickly load a tool, be it on the Hub or in the Transformers library.",Eo,Qe,Zo,M,Xe,Gr,Nt,Dn=`A base class for the functions used by the agent. Subclass this and implement the <code>__call__</code> method as well as the
following class attributes:`,Vr,Dt,Bn=`<li><strong>description</strong> (<code>str</code>) — A short description of what your tool does, the inputs it expects and the output(s) it
will return. For instance ‘This is a tool that downloads a file from a <code>url</code>. It takes the <code>url</code> as input, and
returns the text contained in the file’.</li> <li><strong>name</strong> (<code>str</code>) — A performative name that will be used for your tool in the prompt to the agent. For instance
<code>&quot;text-classifier&quot;</code> or <code>&quot;image_generator&quot;</code>.</li> <li><strong>inputs</strong> (<code>List[str]</code>) — The list of modalities expected for the inputs (in the same order as in the call).
Modalitiies should be <code>&quot;text&quot;</code>, <code>&quot;image&quot;</code> or <code>&quot;audio&quot;</code>. This is only used by <code>launch_gradio_demo</code> or to make a
nice space from your tool.</li> <li><strong>outputs</strong> (<code>List[str]</code>) — The list of modalities returned but the tool (in the same order as the return of the
call method). Modalitiies should be <code>&quot;text&quot;</code>, <code>&quot;image&quot;</code> or <code>&quot;audio&quot;</code>. This is only used by <code>launch_gradio_demo</code>
or to make a nice space from your tool.</li>`,Nr,Bt,Yn=`You can also override the method <a href="/docs/transformers/v4.35.0/ja/main_classes/agent#transformers.Tool.setup">setup()</a> if your tool as an expensive operation to perform before being
usable (such as loading a model). <a href="/docs/transformers/v4.35.0/ja/main_classes/agent#transformers.Tool.setup">setup()</a> will be called the first time you use your tool, but not at
instantiation.`,Dr,ge,Oe,Br,Yt,Fn='Creates a <a href="/docs/transformers/v4.35.0/ja/main_classes/agent#transformers.Tool">Tool</a> from a gradio tool.',Yr,fe,Ke,Fr,Ft,Sn="Loads a tool defined on the Hub.",Sr,ue,et,Qr,St,Qn="Upload the tool to the Hub.",Xr,R,tt,Or,Qt,Xn=`Saves the relevant code files for your tool so it can be pushed to the Hub. This will copy the code of your
tool in <code>output_dir</code> as well as autogenerate:`,Kr,Xt,On=`<li>a config file named <code>tool_config.json</code></li> <li>an <code>app.py</code> file so that your tool can be converted to a space</li> <li>a <code>requirements.txt</code> containing the names of the module used by your tool (as detected when inspecting its
code)</li>`,en,Ot,Kn="You should only use this method to save tools that are defined in a separate module (not <code>__main__</code>).",tn,he,ot,on,Kt,ea=`Overwrite this method here for any operation that is expensive and needs to be executed before you start using
your tool. Such as loading a big model.`,Wo,rt,Ro,I,nt,rn,eo,ta=`A <a href="/docs/transformers/v4.35.0/ja/main_classes/agent#transformers.Tool">Tool</a> tailored towards Transformer models. On top of the class attributes of the base class <a href="/docs/transformers/v4.35.0/ja/main_classes/agent#transformers.Tool">Tool</a>, you will
need to specify:`,nn,to,oa=`<li><strong>model_class</strong> (<code>type</code>) — The class to use to load the model in this tool.</li> <li><strong>default_checkpoint</strong> (<code>str</code>) — The default checkpoint that should be used when the user doesn’t specify one.</li> <li><strong>pre_processor_class</strong> (<code>type</code>, <em>optional</em>, defaults to <code>AutoProcessor</code>) — The class to use to load the
pre-processor</li> <li><strong>post_processor_class</strong> (<code>type</code>, <em>optional</em>, defaults to <code>AutoProcessor</code>) — The class to use to load the
post-processor (when different from the pre-processor).</li>`,an,$e,at,sn,oo,ra="Uses the <code>post_processor</code> to decode the model output.",ln,_e,st,mn,ro,na="Uses the <code>pre_processor</code> to prepare the inputs for the <code>model</code>.",dn,ve,lt,pn,no,aa="Sends the inputs through the <code>model</code>.",cn,be,it,gn,ao,sa="Instantiates the <code>pre_processor</code>, <code>model</code> and <code>post_processor</code> if necessary.",zo,mt,Go,q,dt,fn,so,la='A <a href="/docs/transformers/v4.35.0/ja/main_classes/agent#transformers.Tool">Tool</a> that will make requests to an inference endpoint.',un,ye,pt,hn,lo,ia=`You can override this method in your custom class of <a href="/docs/transformers/v4.35.0/ja/main_classes/agent#transformers.RemoteTool">RemoteTool</a> to apply some custom post-processing of the
outputs of the endpoint.`,$n,F,ct,_n,io,ma=`Prepare the inputs received for the HTTP client sending data to the endpoint. Positional arguments will be
matched with the signature of the <code>tool_class</code> if it was provided at instantation. Images will be encoded into
bytes.`,vn,mo,da='You can override this method in your custom class of <a href="/docs/transformers/v4.35.0/ja/main_classes/agent#transformers.RemoteTool">RemoteTool</a>.',Vo,gt,No,X,ft,bn,po,pa=`Launches a gradio demo for a tool. The corresponding tool class needs to properly implement the class attributes
<code>inputs</code> and <code>outputs</code>.`,Do,ut,Bo,ht,ca=`エージェントはツール間であらゆる種類のオブジェクトを処理できます。ツールは完全にマルチモーダルであるため、受け取りと返品が可能です
テキスト、画像、オーディオ、ビデオなどのタイプ。ツール間の互換性を高めるためだけでなく、
これらの戻り値を ipython (jupyter、colab、ipython ノートブックなど) で正しくレンダリングするには、ラッパー クラスを実装します。
このタイプの周り。`,Yo,$t,ga=`ラップされたオブジェクトは最初と同じように動作し続けるはずです。テキストオブジェクトは依然として文字列または画像として動作する必要があります
オブジェクトは依然として <code>PIL.Image</code> として動作するはずです。`,Fo,_t,fa="これらのタイプには、次の 3 つの特定の目的があります。",So,vt,ua=`<li>型に対して <code>to_raw</code> を呼び出すと、基になるオブジェクトが返されるはずです</li> <li>型に対して <code>to_string</code> を呼び出すと、オブジェクトを文字列として返す必要があります。<code>AgentText</code> の場合は文字列になる可能性があります。
ただし、他のインスタンスのオブジェクトのシリアル化されたバージョンのパスになります。</li> <li>ipython カーネルで表示すると、オブジェクトが正しく表示されるはずです</li>`,Qo,bt,Xo,O,yt,yn,co,ha="Text type returned by the agent. Behaves as a string.",Oo,wt,Ko,E,Tt,wn,go,$a="Image type returned by the agent. Behaves as a PIL.Image.",Tn,we,xt,xn,fo,_a="Returns the “raw” version of that object. In the case of an AgentImage, it is a PIL.Image.",An,Te,At,Mn,uo,va=`Returns the stringified version of that object. In the case of an AgentImage, it is a path to the serialized
version of the image.`,er,Mt,tr,Z,kt,kn,ho,ba="Audio type returned by the agent.",In,xe,It,Cn,$o,ya="Returns the “raw” version of that object. It is a <code>torch.Tensor</code> object.",Hn,Ae,Ct,jn,_o,wa=`Returns the stringified version of that object. In the case of an AgentAudio, it is a path to the serialized
version of the audio.`,or,bo,rr;return b=new H({props:{title:"エージェントとツール",local:"エージェントとツール",headingTag:"h1"}}),y=new Ln({props:{warning:!0,$$slots:{default:[Ia]},$$scope:{ctx:k}}}),je=new H({props:{title:"エージェント",local:"エージェント",headingTag:"h2"}}),Je=new H({props:{title:"HfAgent",local:"transformers.HfAgent",headingTag:"h3"}}),Pe=new A({props:{name:"class transformers.HfAgent",anchor:"transformers.HfAgent",parameters:[{name:"url_endpoint",val:""},{name:"token",val:" = None"},{name:"chat_prompt_template",val:" = None"},{name:"run_prompt_template",val:" = None"},{name:"additional_tools",val:" = None"}],parametersDescription:[{anchor:"transformers.HfAgent.url_endpoint",description:`<strong>url_endpoint</strong> (<code>str</code>) &#x2014;
The name of the url endpoint to use.`,name:"url_endpoint"},{anchor:"transformers.HfAgent.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If unset, will use the token generated when
running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.HfAgent.chat_prompt_template",description:`<strong>chat_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>chat</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>chat_prompt_template.txt</code> in this repo in this case.`,name:"chat_prompt_template"},{anchor:"transformers.HfAgent.run_prompt_template",description:`<strong>run_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>run</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>run_prompt_template.txt</code> in this repo in this case.`,name:"run_prompt_template"},{anchor:"transformers.HfAgent.additional_tools",description:`<strong>additional_tools</strong> (<a href="/docs/transformers/v4.35.0/ja/main_classes/agent#transformers.Tool">Tool</a>, list of tools or dictionary with tool values, <em>optional</em>) &#x2014;
Any additional tools to include on top of the default ones. If you pass along a tool with the same name as
one of the default tools, that default tool will be overridden.`,name:"additional_tools"}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/agents.py#L588"}}),re=new Lt({props:{anchor:"transformers.HfAgent.example",$$slots:{default:[Ca]},$$scope:{ctx:k}}}),Ue=new H({props:{title:"LocalAgent",local:"transformers.LocalAgent",headingTag:"h3"}}),qe=new A({props:{name:"class transformers.LocalAgent",anchor:"transformers.LocalAgent",parameters:[{name:"model",val:""},{name:"tokenizer",val:""},{name:"chat_prompt_template",val:" = None"},{name:"run_prompt_template",val:" = None"},{name:"additional_tools",val:" = None"}],parametersDescription:[{anchor:"transformers.LocalAgent.model",description:`<strong>model</strong> (<a href="/docs/transformers/v4.35.0/ja/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>) &#x2014;
The model to use for the agent.`,name:"model"},{anchor:"transformers.LocalAgent.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/v4.35.0/ja/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>) &#x2014;
The tokenizer to use for the agent.`,name:"tokenizer"},{anchor:"transformers.LocalAgent.chat_prompt_template",description:`<strong>chat_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>chat</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>chat_prompt_template.txt</code> in this repo in this case.`,name:"chat_prompt_template"},{anchor:"transformers.LocalAgent.run_prompt_template",description:`<strong>run_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>run</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>run_prompt_template.txt</code> in this repo in this case.`,name:"run_prompt_template"},{anchor:"transformers.LocalAgent.additional_tools",description:`<strong>additional_tools</strong> (<a href="/docs/transformers/v4.35.0/ja/main_classes/agent#transformers.Tool">Tool</a>, list of tools or dictionary with tool values, <em>optional</em>) &#x2014;
Any additional tools to include on top of the default ones. If you pass along a tool with the same name as
one of the default tools, that default tool will be overridden.`,name:"additional_tools"}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/agents.py#L659"}}),ne=new Lt({props:{anchor:"transformers.LocalAgent.example",$$slots:{default:[Ha]},$$scope:{ctx:k}}}),Ee=new A({props:{name:"from_pretrained",anchor:"transformers.LocalAgent.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LocalAgent.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
The name of a repo on the Hub or a local path to a folder containing both model and tokenizer.`,name:"pretrained_model_name_or_path"},{anchor:"transformers.LocalAgent.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Keyword arguments passed along to <a href="/docs/transformers/v4.35.0/ja/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/agents.py#L704"}}),ae=new Lt({props:{anchor:"transformers.LocalAgent.from_pretrained.example",$$slots:{default:[ja]},$$scope:{ctx:k}}}),Ze=new H({props:{title:"OpenAiAgent",local:"transformers.OpenAiAgent",headingTag:"h3"}}),We=new A({props:{name:"class transformers.OpenAiAgent",anchor:"transformers.OpenAiAgent",parameters:[{name:"model",val:" = 'text-davinci-003'"},{name:"api_key",val:" = None"},{name:"chat_prompt_template",val:" = None"},{name:"run_prompt_template",val:" = None"},{name:"additional_tools",val:" = None"}],parametersDescription:[{anchor:"transformers.OpenAiAgent.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;text-davinci-003&quot;</code>) &#x2014;
The name of the OpenAI model to use.`,name:"model"},{anchor:"transformers.OpenAiAgent.api_key",description:`<strong>api_key</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The API key to use. If unset, will look for the environment variable <code>&quot;OPENAI_API_KEY&quot;</code>.`,name:"api_key"},{anchor:"transformers.OpenAiAgent.chat_prompt_template",description:`<strong>chat_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>chat</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>chat_prompt_template.txt</code> in this repo in this case.`,name:"chat_prompt_template"},{anchor:"transformers.OpenAiAgent.run_prompt_template",description:`<strong>run_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>run</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>run_prompt_template.txt</code> in this repo in this case.`,name:"run_prompt_template"},{anchor:"transformers.OpenAiAgent.additional_tools",description:`<strong>additional_tools</strong> (<a href="/docs/transformers/v4.35.0/ja/main_classes/agent#transformers.Tool">Tool</a>, list of tools or dictionary with tool values, <em>optional</em>) &#x2014;
Any additional tools to include on top of the default ones. If you pass along a tool with the same name as
one of the default tools, that default tool will be overridden.`,name:"additional_tools"}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/agents.py#L364"}}),se=new Ln({props:{warning:!0,$$slots:{default:[La]},$$scope:{ctx:k}}}),le=new Lt({props:{anchor:"transformers.OpenAiAgent.example",$$slots:{default:[Ja]},$$scope:{ctx:k}}}),Re=new H({props:{title:"AzureOpenAiAgent",local:"transformers.AzureOpenAiAgent",headingTag:"h3"}}),ze=new A({props:{name:"class transformers.AzureOpenAiAgent",anchor:"transformers.AzureOpenAiAgent",parameters:[{name:"deployment_id",val:""},{name:"api_key",val:" = None"},{name:"resource_name",val:" = None"},{name:"api_version",val:" = '2022-12-01'"},{name:"is_chat_model",val:" = None"},{name:"chat_prompt_template",val:" = None"},{name:"run_prompt_template",val:" = None"},{name:"additional_tools",val:" = None"}],parametersDescription:[{anchor:"transformers.AzureOpenAiAgent.deployment_id",description:`<strong>deployment_id</strong> (<code>str</code>) &#x2014;
The name of the deployed Azure openAI model to use.`,name:"deployment_id"},{anchor:"transformers.AzureOpenAiAgent.api_key",description:`<strong>api_key</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The API key to use. If unset, will look for the environment variable <code>&quot;AZURE_OPENAI_API_KEY&quot;</code>.`,name:"api_key"},{anchor:"transformers.AzureOpenAiAgent.resource_name",description:`<strong>resource_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of your Azure OpenAI Resource. If unset, will look for the environment variable
<code>&quot;AZURE_OPENAI_RESOURCE_NAME&quot;</code>.`,name:"resource_name"},{anchor:"transformers.AzureOpenAiAgent.api_version",description:`<strong>api_version</strong> (<code>str</code>, <em>optional</em>, default to <code>&quot;2022-12-01&quot;</code>) &#x2014;
The API version to use for this agent.`,name:"api_version"},{anchor:"transformers.AzureOpenAiAgent.is_chat_mode",description:`<strong>is_chat_mode</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether you are using a completion model or a chat model (see note above, chat models won&#x2019;t be as
efficient). Will default to <code>gpt</code> being in the <code>deployment_id</code> or not.`,name:"is_chat_mode"},{anchor:"transformers.AzureOpenAiAgent.chat_prompt_template",description:`<strong>chat_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>chat</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>chat_prompt_template.txt</code> in this repo in this case.`,name:"chat_prompt_template"},{anchor:"transformers.AzureOpenAiAgent.run_prompt_template",description:`<strong>run_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>run</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>run_prompt_template.txt</code> in this repo in this case.`,name:"run_prompt_template"},{anchor:"transformers.AzureOpenAiAgent.additional_tools",description:`<strong>additional_tools</strong> (<a href="/docs/transformers/v4.35.0/ja/main_classes/agent#transformers.Tool">Tool</a>, list of tools or dictionary with tool values, <em>optional</em>) &#x2014;
Any additional tools to include on top of the default ones. If you pass along a tool with the same name as
one of the default tools, that default tool will be overridden.`,name:"additional_tools"}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/agents.py#L462"}}),ie=new Ln({props:{warning:!0,$$slots:{default:[Pa]},$$scope:{ctx:k}}}),me=new Lt({props:{anchor:"transformers.AzureOpenAiAgent.example",$$slots:{default:[Ua]},$$scope:{ctx:k}}}),Ge=new H({props:{title:"Agent",local:"transformers.Agent",headingTag:"h3"}}),Ve=new A({props:{name:"class transformers.Agent",anchor:"transformers.Agent",parameters:[{name:"chat_prompt_template",val:" = None"},{name:"run_prompt_template",val:" = None"},{name:"additional_tools",val:" = None"}],parametersDescription:[{anchor:"transformers.Agent.chat_prompt_template",description:`<strong>chat_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>chat</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>chat_prompt_template.txt</code> in this repo in this case.`,name:"chat_prompt_template"},{anchor:"transformers.Agent.run_prompt_template",description:`<strong>run_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>run</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>run_prompt_template.txt</code> in this repo in this case.`,name:"run_prompt_template"},{anchor:"transformers.Agent.additional_tools",description:`<strong>additional_tools</strong> (<a href="/docs/transformers/v4.35.0/ja/main_classes/agent#transformers.Tool">Tool</a>, list of tools or dictionary with tool values, <em>optional</em>) &#x2014;
Any additional tools to include on top of the default ones. If you pass along a tool with the same name as
one of the default tools, that default tool will be overridden.`,name:"additional_tools"}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/agents.py#L196"}}),Ne=new A({props:{name:"chat",anchor:"transformers.Agent.chat",parameters:[{name:"task",val:""},{name:"return_code",val:" = False"},{name:"remote",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Agent.chat.task",description:"<strong>task</strong> (<code>str</code>) &#x2014; The task to perform",name:"task"},{anchor:"transformers.Agent.chat.return_code",description:`<strong>return_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to just return code and not evaluate it.`,name:"return_code"},{anchor:"transformers.Agent.chat.remote",description:`<strong>remote</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use remote tools (inference endpoints) instead of local ones.`,name:"remote"},{anchor:"transformers.Agent.chat.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Any keyword argument to send to the agent when evaluating the code.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/agents.py#L268"}}),de=new Lt({props:{anchor:"transformers.Agent.chat.example",$$slots:{default:[qa]},$$scope:{ctx:k}}}),De=new A({props:{name:"run",anchor:"transformers.Agent.run",parameters:[{name:"task",val:""},{name:"return_code",val:" = False"},{name:"remote",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Agent.run.task",description:"<strong>task</strong> (<code>str</code>) &#x2014; The task to perform",name:"task"},{anchor:"transformers.Agent.run.return_code",description:`<strong>return_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to just return code and not evaluate it.`,name:"return_code"},{anchor:"transformers.Agent.run.remote",description:`<strong>remote</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use remote tools (inference endpoints) instead of local ones.`,name:"remote"},{anchor:"transformers.Agent.run.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Any keyword argument to send to the agent when evaluating the code.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/agents.py#L318"}}),pe=new Lt({props:{anchor:"transformers.Agent.run.example",$$slots:{default:[Ea]},$$scope:{ctx:k}}}),Be=new A({props:{name:"prepare_for_new_chat",anchor:"transformers.Agent.prepare_for_new_chat",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/agents.py#L310"}}),Ye=new H({props:{title:"Tools",local:"tools",headingTag:"h2"}}),Fe=new H({props:{title:"load_tool",local:"transformers.load_tool",headingTag:"h3"}}),Se=new A({props:{name:"transformers.load_tool",anchor:"transformers.load_tool",parameters:[{name:"task_or_repo_id",val:""},{name:"model_repo_id",val:" = None"},{name:"remote",val:" = False"},{name:"token",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.load_tool.task_or_repo_id",description:`<strong>task_or_repo_id</strong> (<code>str</code>) &#x2014;
The task for which to load the tool or a repo ID of a tool on the Hub. Tasks implemented in Transformers
are:</p>
<ul>
<li><code>&quot;document-question-answering&quot;</code></li>
<li><code>&quot;image-captioning&quot;</code></li>
<li><code>&quot;image-question-answering&quot;</code></li>
<li><code>&quot;image-segmentation&quot;</code></li>
<li><code>&quot;speech-to-text&quot;</code></li>
<li><code>&quot;summarization&quot;</code></li>
<li><code>&quot;text-classification&quot;</code></li>
<li><code>&quot;text-question-answering&quot;</code></li>
<li><code>&quot;text-to-speech&quot;</code></li>
<li><code>&quot;translation&quot;</code></li>
</ul>`,name:"task_or_repo_id"},{anchor:"transformers.load_tool.model_repo_id",description:`<strong>model_repo_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Use this argument to use a different model than the default one for the tool you selected.`,name:"model_repo_id"},{anchor:"transformers.load_tool.remote",description:`<strong>remote</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use your tool by downloading the model or (if it is available) with an inference endpoint.`,name:"remote"},{anchor:"transformers.load_tool.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to identify you on hf.co. If unset, will use the token generated when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.load_tool.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Additional keyword arguments that will be split in two: all arguments relevant to the Hub (such as
<code>cache_dir</code>, <code>revision</code>, <code>subfolder</code>) will be used when downloading the files for your tool, and the others
will be passed along to its init.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/base.py#L643"}}),Qe=new H({props:{title:"Tool",local:"transformers.Tool",headingTag:"h3"}}),Xe=new A({props:{name:"class transformers.Tool",anchor:"transformers.Tool",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/base.py#L81"}}),Oe=new A({props:{name:"from_gradio",anchor:"transformers.Tool.from_gradio",parameters:[{name:"gradio_tool",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/base.py#L330"}}),Ke=new A({props:{name:"from_hub",anchor:"transformers.Tool.from_hub",parameters:[{name:"repo_id",val:": str"},{name:"model_repo_id",val:": typing.Optional[str] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"remote",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Tool.from_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repo on the Hub where your tool is defined.`,name:"repo_id"},{anchor:"transformers.Tool.from_hub.model_repo_id",description:`<strong>model_repo_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If your tool uses a model and you want to use a different model than the default, you can pass a second
repo ID or an endpoint url to this argument.`,name:"model_repo_id"},{anchor:"transformers.Tool.from_hub.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to identify you on hf.co. If unset, will use the token generated when running
<code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.Tool.from_hub.remote",description:`<strong>remote</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use your tool by downloading the model or (if it is available) with an inference endpoint.`,name:"remote"},{anchor:"transformers.Tool.from_hub.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Additional keyword arguments that will be split in two: all arguments relevant to the Hub (such as
<code>cache_dir</code>, <code>revision</code>, <code>subfolder</code>) will be used when downloading the files for your tool, and the
others will be passed along to its init.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/base.py#L176"}}),et=new A({props:{name:"push_to_hub",anchor:"transformers.Tool.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"commit_message",val:": str = 'Upload tool'"},{name:"private",val:": typing.Optional[bool] = None"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"},{name:"create_pr",val:": bool = False"}],parametersDescription:[{anchor:"transformers.Tool.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your tool to. It should contain your organization name when
pushing to a given organization.`,name:"repo_id"},{anchor:"transformers.Tool.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;Upload tool&quot;</code>) &#x2014;
Message to commit while pushing.`,name:"commit_message"},{anchor:"transformers.Tool.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"transformers.Tool.push_to_hub.token",description:`<strong>token</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If unset, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.Tool.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/base.py#L286"}}),tt=new A({props:{name:"save",anchor:"transformers.Tool.save",parameters:[{name:"output_dir",val:""}],parametersDescription:[{anchor:"transformers.Tool.save.output_dir",description:"<strong>output_dir</strong> (<code>str</code>) &#x2014; The folder in which you want to save your tool.",name:"output_dir"}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/base.py#L122"}}),ot=new A({props:{name:"setup",anchor:"transformers.Tool.setup",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/base.py#L115"}}),rt=new H({props:{title:"PipelineTool",local:"transformers.PipelineTool",headingTag:"h3"}}),nt=new A({props:{name:"class transformers.PipelineTool",anchor:"transformers.PipelineTool",parameters:[{name:"model",val:" = None"},{name:"pre_processor",val:" = None"},{name:"post_processor",val:" = None"},{name:"device",val:" = None"},{name:"device_map",val:" = None"},{name:"model_kwargs",val:" = None"},{name:"token",val:" = None"},{name:"**hub_kwargs",val:""}],parametersDescription:[{anchor:"transformers.PipelineTool.model",description:`<strong>model</strong> (<code>str</code> or <a href="/docs/transformers/v4.35.0/ja/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>, <em>optional</em>) &#x2014;
The name of the checkpoint to use for the model, or the instantiated model. If unset, will default to the
value of the class attribute <code>default_checkpoint</code>.`,name:"model"},{anchor:"transformers.PipelineTool.pre_processor",description:`<strong>pre_processor</strong> (<code>str</code> or <code>Any</code>, <em>optional</em>) &#x2014;
The name of the checkpoint to use for the pre-processor, or the instantiated pre-processor (can be a
tokenizer, an image processor, a feature extractor or a processor). Will default to the value of <code>model</code> if
unset.`,name:"pre_processor"},{anchor:"transformers.PipelineTool.post_processor",description:`<strong>post_processor</strong> (<code>str</code> or <code>Any</code>, <em>optional</em>) &#x2014;
The name of the checkpoint to use for the post-processor, or the instantiated pre-processor (can be a
tokenizer, an image processor, a feature extractor or a processor). Will default to the <code>pre_processor</code> if
unset.`,name:"post_processor"},{anchor:"transformers.PipelineTool.device",description:`<strong>device</strong> (<code>int</code>, <code>str</code> or <code>torch.device</code>, <em>optional</em>) &#x2014;
The device on which to execute the model. Will default to any accelerator available (GPU, MPS etc&#x2026;), the
CPU otherwise.`,name:"device"},{anchor:"transformers.PipelineTool.device_map",description:`<strong>device_map</strong> (<code>str</code> or <code>dict</code>, <em>optional</em>) &#x2014;
If passed along, will be used to instantiate the model.`,name:"device_map"},{anchor:"transformers.PipelineTool.model_kwargs",description:`<strong>model_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Any keyword argument to send to the model instantiation.`,name:"model_kwargs"},{anchor:"transformers.PipelineTool.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If unset, will use the token generated when
running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.PipelineTool.hub_kwargs",description:`<strong>hub_kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Any additional keyword argument to send to the methods that will load the data from the Hub.`,name:"hub_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/base.py#L433"}}),at=new A({props:{name:"decode",anchor:"transformers.PipelineTool.decode",parameters:[{name:"outputs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/base.py#L552"}}),st=new A({props:{name:"encode",anchor:"transformers.PipelineTool.encode",parameters:[{name:"raw_inputs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/base.py#L539"}}),lt=new A({props:{name:"forward",anchor:"transformers.PipelineTool.forward",parameters:[{name:"inputs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/base.py#L545"}}),it=new A({props:{name:"setup",anchor:"transformers.PipelineTool.setup",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/base.py#L513"}}),mt=new H({props:{title:"RemoteTool",local:"transformers.RemoteTool",headingTag:"h3"}}),dt=new A({props:{name:"class transformers.RemoteTool",anchor:"transformers.RemoteTool",parameters:[{name:"endpoint_url",val:" = None"},{name:"token",val:" = None"},{name:"tool_class",val:" = None"}],parametersDescription:[{anchor:"transformers.RemoteTool.endpoint_url",description:`<strong>endpoint_url</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The url of the endpoint to use.`,name:"endpoint_url"},{anchor:"transformers.RemoteTool.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If unset, will use the token generated when
running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.RemoteTool.tool_class",description:`<strong>tool_class</strong> (<code>type</code>, <em>optional</em>) &#x2014;
The corresponding <code>tool_class</code> if this is a remote version of an existing tool. Will help determine when
the output should be converted to another type (like images).`,name:"tool_class"}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/base.py#L346"}}),pt=new A({props:{name:"extract_outputs",anchor:"transformers.RemoteTool.extract_outputs",parameters:[{name:"outputs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/base.py#L409"}}),ct=new A({props:{name:"prepare_inputs",anchor:"transformers.RemoteTool.prepare_inputs",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/base.py#L366"}}),gt=new H({props:{title:"launch_gradio_demo",local:"transformers.launch_gradio_demo",headingTag:"h3"}}),ft=new A({props:{name:"transformers.launch_gradio_demo",anchor:"transformers.launch_gradio_demo",parameters:[{name:"tool_class",val:": Tool"}],parametersDescription:[{anchor:"transformers.launch_gradio_demo.tool_class",description:"<strong>tool_class</strong> (<code>type</code>) &#x2014; The class of the tool for which to launch the demo.",name:"tool_class"}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/base.py#L573"}}),ut=new H({props:{title:"エージェントの種類",local:"エージェントの種類",headingTag:"h2"}}),bt=new H({props:{title:"AgentText",local:"transformers.tools.agent_types.AgentText",headingTag:"h3"}}),yt=new A({props:{name:"class transformers.tools.agent_types.AgentText",anchor:"transformers.tools.agent_types.AgentText",parameters:[{name:"value",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/agent_types.py#L71"}}),wt=new H({props:{title:"AgentImage",local:"transformers.tools.agent_types.AgentImage",headingTag:"h3"}}),Tt=new A({props:{name:"class transformers.tools.agent_types.AgentImage",anchor:"transformers.tools.agent_types.AgentImage",parameters:[{name:"value",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/agent_types.py#L83"}}),xt=new A({props:{name:"to_raw",anchor:"transformers.tools.agent_types.AgentImage.to_raw",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/agent_types.py#L115"}}),At=new A({props:{name:"to_string",anchor:"transformers.tools.agent_types.AgentImage.to_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/agent_types.py#L126"}}),Mt=new H({props:{title:"AgentAudio",local:"transformers.tools.agent_types.AgentAudio",headingTag:"h3"}}),kt=new A({props:{name:"class transformers.tools.agent_types.AgentAudio",anchor:"transformers.tools.agent_types.AgentAudio",parameters:[{name:"value",val:""},{name:"samplerate",val:" = 16000"}],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/agent_types.py#L155"}}),It=new A({props:{name:"to_raw",anchor:"transformers.tools.agent_types.AgentAudio.to_raw",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/agent_types.py#L186"}}),Ct=new A({props:{name:"to_string",anchor:"transformers.tools.agent_types.AgentAudio.to_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.35.0/src/transformers/tools/agent_types.py#L198"}}),{c(){l=i("meta"),w=r(),_=i("p"),p=r(),c(b.$$.fragment),a=r(),c(y.$$.fragment),yo=r(),He=i("p"),He.innerHTML=Jn,wo=r(),c(je.$$.fragment),To=r(),Le=i("p"),Le.innerHTML=Pn,xo=r(),c(Je.$$.fragment),Ao=r(),z=i("div"),c(Pe.$$.fragment),vr=r(),Pt=i("p"),Pt.textContent=Un,br=r(),c(re.$$.fragment),Mo=r(),c(Ue.$$.fragment),ko=r(),J=i("div"),c(qe.$$.fragment),yr=r(),Ut=i("p"),Ut.textContent=qn,wr=r(),c(ne.$$.fragment),Tr=r(),D=i("div"),c(Ee.$$.fragment),xr=r(),qt=i("p"),qt.innerHTML=En,Ar=r(),c(ae.$$.fragment),Io=r(),c(Ze.$$.fragment),Co=r(),P=i("div"),c(We.$$.fragment),Mr=r(),Et=i("p"),Et.textContent=Zn,kr=r(),c(se.$$.fragment),Ir=r(),c(le.$$.fragment),Ho=r(),c(Re.$$.fragment),jo=r(),U=i("div"),c(ze.$$.fragment),Cr=r(),Zt=i("p"),Zt.innerHTML=Wn,Hr=r(),c(ie.$$.fragment),jr=r(),c(me.$$.fragment),Lo=r(),c(Ge.$$.fragment),Jo=r(),j=i("div"),c(Ve.$$.fragment),Lr=r(),Wt=i("p"),Wt.textContent=Rn,Jr=r(),B=i("div"),c(Ne.$$.fragment),Pr=r(),Rt=i("p"),Rt.textContent=zn,Ur=r(),c(de.$$.fragment),qr=r(),Y=i("div"),c(De.$$.fragment),Er=r(),zt=i("p"),zt.textContent=Gn,Zr=r(),c(pe.$$.fragment),Wr=r(),ce=i("div"),c(Be.$$.fragment),Rr=r(),Gt=i("p"),Gt.innerHTML=Vn,Po=r(),c(Ye.$$.fragment),Uo=r(),c(Fe.$$.fragment),qo=r(),Q=i("div"),c(Se.$$.fragment),zr=r(),Vt=i("p"),Vt.textContent=Nn,Eo=r(),c(Qe.$$.fragment),Zo=r(),M=i("div"),c(Xe.$$.fragment),Gr=r(),Nt=i("p"),Nt.innerHTML=Dn,Vr=r(),Dt=i("ul"),Dt.innerHTML=Bn,Nr=r(),Bt=i("p"),Bt.innerHTML=Yn,Dr=r(),ge=i("div"),c(Oe.$$.fragment),Br=r(),Yt=i("p"),Yt.innerHTML=Fn,Yr=r(),fe=i("div"),c(Ke.$$.fragment),Fr=r(),Ft=i("p"),Ft.textContent=Sn,Sr=r(),ue=i("div"),c(et.$$.fragment),Qr=r(),St=i("p"),St.textContent=Qn,Xr=r(),R=i("div"),c(tt.$$.fragment),Or=r(),Qt=i("p"),Qt.innerHTML=Xn,Kr=r(),Xt=i("ul"),Xt.innerHTML=On,en=r(),Ot=i("p"),Ot.innerHTML=Kn,tn=r(),he=i("div"),c(ot.$$.fragment),on=r(),Kt=i("p"),Kt.textContent=ea,Wo=r(),c(rt.$$.fragment),Ro=r(),I=i("div"),c(nt.$$.fragment),rn=r(),eo=i("p"),eo.innerHTML=ta,nn=r(),to=i("ul"),to.innerHTML=oa,an=r(),$e=i("div"),c(at.$$.fragment),sn=r(),oo=i("p"),oo.innerHTML=ra,ln=r(),_e=i("div"),c(st.$$.fragment),mn=r(),ro=i("p"),ro.innerHTML=na,dn=r(),ve=i("div"),c(lt.$$.fragment),pn=r(),no=i("p"),no.innerHTML=aa,cn=r(),be=i("div"),c(it.$$.fragment),gn=r(),ao=i("p"),ao.innerHTML=sa,zo=r(),c(mt.$$.fragment),Go=r(),q=i("div"),c(dt.$$.fragment),fn=r(),so=i("p"),so.innerHTML=la,un=r(),ye=i("div"),c(pt.$$.fragment),hn=r(),lo=i("p"),lo.innerHTML=ia,$n=r(),F=i("div"),c(ct.$$.fragment),_n=r(),io=i("p"),io.innerHTML=ma,vn=r(),mo=i("p"),mo.innerHTML=da,Vo=r(),c(gt.$$.fragment),No=r(),X=i("div"),c(ft.$$.fragment),bn=r(),po=i("p"),po.innerHTML=pa,Do=r(),c(ut.$$.fragment),Bo=r(),ht=i("p"),ht.textContent=ca,Yo=r(),$t=i("p"),$t.innerHTML=ga,Fo=r(),_t=i("p"),_t.textContent=fa,So=r(),vt=i("ul"),vt.innerHTML=ua,Qo=r(),c(bt.$$.fragment),Xo=r(),O=i("div"),c(yt.$$.fragment),yn=r(),co=i("p"),co.textContent=ha,Oo=r(),c(wt.$$.fragment),Ko=r(),E=i("div"),c(Tt.$$.fragment),wn=r(),go=i("p"),go.textContent=$a,Tn=r(),we=i("div"),c(xt.$$.fragment),xn=r(),fo=i("p"),fo.textContent=_a,An=r(),Te=i("div"),c(At.$$.fragment),Mn=r(),uo=i("p"),uo.textContent=va,er=r(),c(Mt.$$.fragment),tr=r(),Z=i("div"),c(kt.$$.fragment),kn=r(),ho=i("p"),ho.textContent=ba,In=r(),xe=i("div"),c(It.$$.fragment),Cn=r(),$o=i("p"),$o.innerHTML=ya,Hn=r(),Ae=i("div"),c(Ct.$$.fragment),jn=r(),_o=i("p"),_o.textContent=wa,or=r(),bo=i("p"),this.h()},l(e){const s=ka("svelte-u9bgzb",document.head);l=m(s,"META",{name:!0,content:!0}),s.forEach(o),w=n(e),_=m(e,"P",{}),T(_).forEach(o),p=n(e),g(b.$$.fragment,e),a=n(e),g(y.$$.fragment,e),yo=n(e),He=m(e,"P",{"data-svelte-h":!0}),v(He)!=="svelte-s8k95"&&(He.innerHTML=Jn),wo=n(e),g(je.$$.fragment,e),To=n(e),Le=m(e,"P",{"data-svelte-h":!0}),v(Le)!=="svelte-2hh3w4"&&(Le.innerHTML=Pn),xo=n(e),g(Je.$$.fragment,e),Ao=n(e),z=m(e,"DIV",{class:!0});var K=T(z);g(Pe.$$.fragment,K),vr=n(K),Pt=m(K,"P",{"data-svelte-h":!0}),v(Pt)!=="svelte-1uej11q"&&(Pt.textContent=Un),br=n(K),g(re.$$.fragment,K),K.forEach(o),Mo=n(e),g(Ue.$$.fragment,e),ko=n(e),J=m(e,"DIV",{class:!0});var G=T(J);g(qe.$$.fragment,G),yr=n(G),Ut=m(G,"P",{"data-svelte-h":!0}),v(Ut)!=="svelte-1q3iegi"&&(Ut.textContent=qn),wr=n(G),g(ne.$$.fragment,G),Tr=n(G),D=m(G,"DIV",{class:!0});var ee=T(D);g(Ee.$$.fragment,ee),xr=n(ee),qt=m(ee,"P",{"data-svelte-h":!0}),v(qt)!=="svelte-1qh3hl2"&&(qt.innerHTML=En),Ar=n(ee),g(ae.$$.fragment,ee),ee.forEach(o),G.forEach(o),Io=n(e),g(Ze.$$.fragment,e),Co=n(e),P=m(e,"DIV",{class:!0});var V=T(P);g(We.$$.fragment,V),Mr=n(V),Et=m(V,"P",{"data-svelte-h":!0}),v(Et)!=="svelte-182hy5g"&&(Et.textContent=Zn),kr=n(V),g(se.$$.fragment,V),Ir=n(V),g(le.$$.fragment,V),V.forEach(o),Ho=n(e),g(Re.$$.fragment,e),jo=n(e),U=m(e,"DIV",{class:!0});var N=T(U);g(ze.$$.fragment,N),Cr=n(N),Zt=m(N,"P",{"data-svelte-h":!0}),v(Zt)!=="svelte-1eoncpw"&&(Zt.innerHTML=Wn),Hr=n(N),g(ie.$$.fragment,N),jr=n(N),g(me.$$.fragment,N),N.forEach(o),Lo=n(e),g(Ge.$$.fragment,e),Jo=n(e),j=m(e,"DIV",{class:!0});var W=T(j);g(Ve.$$.fragment,W),Lr=n(W),Wt=m(W,"P",{"data-svelte-h":!0}),v(Wt)!=="svelte-1phtukb"&&(Wt.textContent=Rn),Jr=n(W),B=m(W,"DIV",{class:!0});var te=T(B);g(Ne.$$.fragment,te),Pr=n(te),Rt=m(te,"P",{"data-svelte-h":!0}),v(Rt)!=="svelte-1s1qxmr"&&(Rt.textContent=zn),Ur=n(te),g(de.$$.fragment,te),te.forEach(o),qr=n(W),Y=m(W,"DIV",{class:!0});var oe=T(Y);g(De.$$.fragment,oe),Er=n(oe),zt=m(oe,"P",{"data-svelte-h":!0}),v(zt)!=="svelte-1685qxi"&&(zt.textContent=Gn),Zr=n(oe),g(pe.$$.fragment,oe),oe.forEach(o),Wr=n(W),ce=m(W,"DIV",{class:!0});var Ht=T(ce);g(Be.$$.fragment,Ht),Rr=n(Ht),Gt=m(Ht,"P",{"data-svelte-h":!0}),v(Gt)!=="svelte-7houdj"&&(Gt.innerHTML=Vn),Ht.forEach(o),W.forEach(o),Po=n(e),g(Ye.$$.fragment,e),Uo=n(e),g(Fe.$$.fragment,e),qo=n(e),Q=m(e,"DIV",{class:!0});var jt=T(Q);g(Se.$$.fragment,jt),zr=n(jt),Vt=m(jt,"P",{"data-svelte-h":!0}),v(Vt)!=="svelte-16uh3p8"&&(Vt.textContent=Nn),jt.forEach(o),Eo=n(e),g(Qe.$$.fragment,e),Zo=n(e),M=m(e,"DIV",{class:!0});var C=T(M);g(Xe.$$.fragment,C),Gr=n(C),Nt=m(C,"P",{"data-svelte-h":!0}),v(Nt)!=="svelte-cca4c5"&&(Nt.innerHTML=Dn),Vr=n(C),Dt=m(C,"UL",{"data-svelte-h":!0}),v(Dt)!=="svelte-1lb1si5"&&(Dt.innerHTML=Bn),Nr=n(C),Bt=m(C,"P",{"data-svelte-h":!0}),v(Bt)!=="svelte-1w1iblg"&&(Bt.innerHTML=Yn),Dr=n(C),ge=m(C,"DIV",{class:!0});var nr=T(ge);g(Oe.$$.fragment,nr),Br=n(nr),Yt=m(nr,"P",{"data-svelte-h":!0}),v(Yt)!=="svelte-ohqp8q"&&(Yt.innerHTML=Fn),nr.forEach(o),Yr=n(C),fe=m(C,"DIV",{class:!0});var ar=T(fe);g(Ke.$$.fragment,ar),Fr=n(ar),Ft=m(ar,"P",{"data-svelte-h":!0}),v(Ft)!=="svelte-yy7b2c"&&(Ft.textContent=Sn),ar.forEach(o),Sr=n(C),ue=m(C,"DIV",{class:!0});var sr=T(ue);g(et.$$.fragment,sr),Qr=n(sr),St=m(sr,"P",{"data-svelte-h":!0}),v(St)!=="svelte-1u3gku9"&&(St.textContent=Qn),sr.forEach(o),Xr=n(C),R=m(C,"DIV",{class:!0});var Me=T(R);g(tt.$$.fragment,Me),Or=n(Me),Qt=m(Me,"P",{"data-svelte-h":!0}),v(Qt)!=="svelte-19evuwa"&&(Qt.innerHTML=Xn),Kr=n(Me),Xt=m(Me,"UL",{"data-svelte-h":!0}),v(Xt)!=="svelte-15of9ze"&&(Xt.innerHTML=On),en=n(Me),Ot=m(Me,"P",{"data-svelte-h":!0}),v(Ot)!=="svelte-msa4ge"&&(Ot.innerHTML=Kn),Me.forEach(o),tn=n(C),he=m(C,"DIV",{class:!0});var lr=T(he);g(ot.$$.fragment,lr),on=n(lr),Kt=m(lr,"P",{"data-svelte-h":!0}),v(Kt)!=="svelte-63kthh"&&(Kt.textContent=ea),lr.forEach(o),C.forEach(o),Wo=n(e),g(rt.$$.fragment,e),Ro=n(e),I=m(e,"DIV",{class:!0});var L=T(I);g(nt.$$.fragment,L),rn=n(L),eo=m(L,"P",{"data-svelte-h":!0}),v(eo)!=="svelte-qrgokh"&&(eo.innerHTML=ta),nn=n(L),to=m(L,"UL",{"data-svelte-h":!0}),v(to)!=="svelte-1ccblfi"&&(to.innerHTML=oa),an=n(L),$e=m(L,"DIV",{class:!0});var ir=T($e);g(at.$$.fragment,ir),sn=n(ir),oo=m(ir,"P",{"data-svelte-h":!0}),v(oo)!=="svelte-zkjq4t"&&(oo.innerHTML=ra),ir.forEach(o),ln=n(L),_e=m(L,"DIV",{class:!0});var mr=T(_e);g(st.$$.fragment,mr),mn=n(mr),ro=m(mr,"P",{"data-svelte-h":!0}),v(ro)!=="svelte-1vxzk80"&&(ro.innerHTML=na),mr.forEach(o),dn=n(L),ve=m(L,"DIV",{class:!0});var dr=T(ve);g(lt.$$.fragment,dr),pn=n(dr),no=m(dr,"P",{"data-svelte-h":!0}),v(no)!=="svelte-1qgsi13"&&(no.innerHTML=aa),dr.forEach(o),cn=n(L),be=m(L,"DIV",{class:!0});var pr=T(be);g(it.$$.fragment,pr),gn=n(pr),ao=m(pr,"P",{"data-svelte-h":!0}),v(ao)!=="svelte-1ojxz66"&&(ao.innerHTML=sa),pr.forEach(o),L.forEach(o),zo=n(e),g(mt.$$.fragment,e),Go=n(e),q=m(e,"DIV",{class:!0});var ke=T(q);g(dt.$$.fragment,ke),fn=n(ke),so=m(ke,"P",{"data-svelte-h":!0}),v(so)!=="svelte-v4s3un"&&(so.innerHTML=la),un=n(ke),ye=m(ke,"DIV",{class:!0});var cr=T(ye);g(pt.$$.fragment,cr),hn=n(cr),lo=m(cr,"P",{"data-svelte-h":!0}),v(lo)!=="svelte-1o9w05m"&&(lo.innerHTML=ia),cr.forEach(o),$n=n(ke),F=m(ke,"DIV",{class:!0});var vo=T(F);g(ct.$$.fragment,vo),_n=n(vo),io=m(vo,"P",{"data-svelte-h":!0}),v(io)!=="svelte-14yhe1"&&(io.innerHTML=ma),vn=n(vo),mo=m(vo,"P",{"data-svelte-h":!0}),v(mo)!=="svelte-et8yvv"&&(mo.innerHTML=da),vo.forEach(o),ke.forEach(o),Vo=n(e),g(gt.$$.fragment,e),No=n(e),X=m(e,"DIV",{class:!0});var gr=T(X);g(ft.$$.fragment,gr),bn=n(gr),po=m(gr,"P",{"data-svelte-h":!0}),v(po)!=="svelte-78dinl"&&(po.innerHTML=pa),gr.forEach(o),Do=n(e),g(ut.$$.fragment,e),Bo=n(e),ht=m(e,"P",{"data-svelte-h":!0}),v(ht)!=="svelte-14vr92g"&&(ht.textContent=ca),Yo=n(e),$t=m(e,"P",{"data-svelte-h":!0}),v($t)!=="svelte-1ozzq59"&&($t.innerHTML=ga),Fo=n(e),_t=m(e,"P",{"data-svelte-h":!0}),v(_t)!=="svelte-1ffo2vr"&&(_t.textContent=fa),So=n(e),vt=m(e,"UL",{"data-svelte-h":!0}),v(vt)!=="svelte-wzs2d2"&&(vt.innerHTML=ua),Qo=n(e),g(bt.$$.fragment,e),Xo=n(e),O=m(e,"DIV",{class:!0});var fr=T(O);g(yt.$$.fragment,fr),yn=n(fr),co=m(fr,"P",{"data-svelte-h":!0}),v(co)!=="svelte-57fhj7"&&(co.textContent=ha),fr.forEach(o),Oo=n(e),g(wt.$$.fragment,e),Ko=n(e),E=m(e,"DIV",{class:!0});var Ie=T(E);g(Tt.$$.fragment,Ie),wn=n(Ie),go=m(Ie,"P",{"data-svelte-h":!0}),v(go)!=="svelte-1hsb0qs"&&(go.textContent=$a),Tn=n(Ie),we=m(Ie,"DIV",{class:!0});var ur=T(we);g(xt.$$.fragment,ur),xn=n(ur),fo=m(ur,"P",{"data-svelte-h":!0}),v(fo)!=="svelte-ybie7i"&&(fo.textContent=_a),ur.forEach(o),An=n(Ie),Te=m(Ie,"DIV",{class:!0});var hr=T(Te);g(At.$$.fragment,hr),Mn=n(hr),uo=m(hr,"P",{"data-svelte-h":!0}),v(uo)!=="svelte-chc6sp"&&(uo.textContent=va),hr.forEach(o),Ie.forEach(o),er=n(e),g(Mt.$$.fragment,e),tr=n(e),Z=m(e,"DIV",{class:!0});var Ce=T(Z);g(kt.$$.fragment,Ce),kn=n(Ce),ho=m(Ce,"P",{"data-svelte-h":!0}),v(ho)!=="svelte-ckiqb6"&&(ho.textContent=ba),In=n(Ce),xe=m(Ce,"DIV",{class:!0});var $r=T(xe);g(It.$$.fragment,$r),Cn=n($r),$o=m($r,"P",{"data-svelte-h":!0}),v($o)!=="svelte-10rnn1x"&&($o.innerHTML=ya),$r.forEach(o),Hn=n(Ce),Ae=m(Ce,"DIV",{class:!0});var _r=T(Ae);g(Ct.$$.fragment,_r),jn=n(_r),_o=m(_r,"P",{"data-svelte-h":!0}),v(_o)!=="svelte-1xu9o93"&&(_o.textContent=wa),_r.forEach(o),Ce.forEach(o),or=n(e),bo=m(e,"P",{}),T(bo).forEach(o),this.h()},h(){x(l,"name","hf:doc:metadata"),x(l,"content",Wa),x(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){t(document.head,l),d(e,w,s),d(e,_,s),d(e,p,s),f(b,e,s),d(e,a,s),f(y,e,s),d(e,yo,s),d(e,He,s),d(e,wo,s),f(je,e,s),d(e,To,s),d(e,Le,s),d(e,xo,s),f(Je,e,s),d(e,Ao,s),d(e,z,s),f(Pe,z,null),t(z,vr),t(z,Pt),t(z,br),f(re,z,null),d(e,Mo,s),f(Ue,e,s),d(e,ko,s),d(e,J,s),f(qe,J,null),t(J,yr),t(J,Ut),t(J,wr),f(ne,J,null),t(J,Tr),t(J,D),f(Ee,D,null),t(D,xr),t(D,qt),t(D,Ar),f(ae,D,null),d(e,Io,s),f(Ze,e,s),d(e,Co,s),d(e,P,s),f(We,P,null),t(P,Mr),t(P,Et),t(P,kr),f(se,P,null),t(P,Ir),f(le,P,null),d(e,Ho,s),f(Re,e,s),d(e,jo,s),d(e,U,s),f(ze,U,null),t(U,Cr),t(U,Zt),t(U,Hr),f(ie,U,null),t(U,jr),f(me,U,null),d(e,Lo,s),f(Ge,e,s),d(e,Jo,s),d(e,j,s),f(Ve,j,null),t(j,Lr),t(j,Wt),t(j,Jr),t(j,B),f(Ne,B,null),t(B,Pr),t(B,Rt),t(B,Ur),f(de,B,null),t(j,qr),t(j,Y),f(De,Y,null),t(Y,Er),t(Y,zt),t(Y,Zr),f(pe,Y,null),t(j,Wr),t(j,ce),f(Be,ce,null),t(ce,Rr),t(ce,Gt),d(e,Po,s),f(Ye,e,s),d(e,Uo,s),f(Fe,e,s),d(e,qo,s),d(e,Q,s),f(Se,Q,null),t(Q,zr),t(Q,Vt),d(e,Eo,s),f(Qe,e,s),d(e,Zo,s),d(e,M,s),f(Xe,M,null),t(M,Gr),t(M,Nt),t(M,Vr),t(M,Dt),t(M,Nr),t(M,Bt),t(M,Dr),t(M,ge),f(Oe,ge,null),t(ge,Br),t(ge,Yt),t(M,Yr),t(M,fe),f(Ke,fe,null),t(fe,Fr),t(fe,Ft),t(M,Sr),t(M,ue),f(et,ue,null),t(ue,Qr),t(ue,St),t(M,Xr),t(M,R),f(tt,R,null),t(R,Or),t(R,Qt),t(R,Kr),t(R,Xt),t(R,en),t(R,Ot),t(M,tn),t(M,he),f(ot,he,null),t(he,on),t(he,Kt),d(e,Wo,s),f(rt,e,s),d(e,Ro,s),d(e,I,s),f(nt,I,null),t(I,rn),t(I,eo),t(I,nn),t(I,to),t(I,an),t(I,$e),f(at,$e,null),t($e,sn),t($e,oo),t(I,ln),t(I,_e),f(st,_e,null),t(_e,mn),t(_e,ro),t(I,dn),t(I,ve),f(lt,ve,null),t(ve,pn),t(ve,no),t(I,cn),t(I,be),f(it,be,null),t(be,gn),t(be,ao),d(e,zo,s),f(mt,e,s),d(e,Go,s),d(e,q,s),f(dt,q,null),t(q,fn),t(q,so),t(q,un),t(q,ye),f(pt,ye,null),t(ye,hn),t(ye,lo),t(q,$n),t(q,F),f(ct,F,null),t(F,_n),t(F,io),t(F,vn),t(F,mo),d(e,Vo,s),f(gt,e,s),d(e,No,s),d(e,X,s),f(ft,X,null),t(X,bn),t(X,po),d(e,Do,s),f(ut,e,s),d(e,Bo,s),d(e,ht,s),d(e,Yo,s),d(e,$t,s),d(e,Fo,s),d(e,_t,s),d(e,So,s),d(e,vt,s),d(e,Qo,s),f(bt,e,s),d(e,Xo,s),d(e,O,s),f(yt,O,null),t(O,yn),t(O,co),d(e,Oo,s),f(wt,e,s),d(e,Ko,s),d(e,E,s),f(Tt,E,null),t(E,wn),t(E,go),t(E,Tn),t(E,we),f(xt,we,null),t(we,xn),t(we,fo),t(E,An),t(E,Te),f(At,Te,null),t(Te,Mn),t(Te,uo),d(e,er,s),f(Mt,e,s),d(e,tr,s),d(e,Z,s),f(kt,Z,null),t(Z,kn),t(Z,ho),t(Z,In),t(Z,xe),f(It,xe,null),t(xe,Cn),t(xe,$o),t(Z,Hn),t(Z,Ae),f(Ct,Ae,null),t(Ae,jn),t(Ae,_o),d(e,or,s),d(e,bo,s),rr=!0},p(e,[s]){const K={};s&2&&(K.$$scope={dirty:s,ctx:e}),y.$set(K);const G={};s&2&&(G.$$scope={dirty:s,ctx:e}),re.$set(G);const ee={};s&2&&(ee.$$scope={dirty:s,ctx:e}),ne.$set(ee);const V={};s&2&&(V.$$scope={dirty:s,ctx:e}),ae.$set(V);const N={};s&2&&(N.$$scope={dirty:s,ctx:e}),se.$set(N);const W={};s&2&&(W.$$scope={dirty:s,ctx:e}),le.$set(W);const te={};s&2&&(te.$$scope={dirty:s,ctx:e}),ie.$set(te);const oe={};s&2&&(oe.$$scope={dirty:s,ctx:e}),me.$set(oe);const Ht={};s&2&&(Ht.$$scope={dirty:s,ctx:e}),de.$set(Ht);const jt={};s&2&&(jt.$$scope={dirty:s,ctx:e}),pe.$set(jt)},i(e){rr||(u(b.$$.fragment,e),u(y.$$.fragment,e),u(je.$$.fragment,e),u(Je.$$.fragment,e),u(Pe.$$.fragment,e),u(re.$$.fragment,e),u(Ue.$$.fragment,e),u(qe.$$.fragment,e),u(ne.$$.fragment,e),u(Ee.$$.fragment,e),u(ae.$$.fragment,e),u(Ze.$$.fragment,e),u(We.$$.fragment,e),u(se.$$.fragment,e),u(le.$$.fragment,e),u(Re.$$.fragment,e),u(ze.$$.fragment,e),u(ie.$$.fragment,e),u(me.$$.fragment,e),u(Ge.$$.fragment,e),u(Ve.$$.fragment,e),u(Ne.$$.fragment,e),u(de.$$.fragment,e),u(De.$$.fragment,e),u(pe.$$.fragment,e),u(Be.$$.fragment,e),u(Ye.$$.fragment,e),u(Fe.$$.fragment,e),u(Se.$$.fragment,e),u(Qe.$$.fragment,e),u(Xe.$$.fragment,e),u(Oe.$$.fragment,e),u(Ke.$$.fragment,e),u(et.$$.fragment,e),u(tt.$$.fragment,e),u(ot.$$.fragment,e),u(rt.$$.fragment,e),u(nt.$$.fragment,e),u(at.$$.fragment,e),u(st.$$.fragment,e),u(lt.$$.fragment,e),u(it.$$.fragment,e),u(mt.$$.fragment,e),u(dt.$$.fragment,e),u(pt.$$.fragment,e),u(ct.$$.fragment,e),u(gt.$$.fragment,e),u(ft.$$.fragment,e),u(ut.$$.fragment,e),u(bt.$$.fragment,e),u(yt.$$.fragment,e),u(wt.$$.fragment,e),u(Tt.$$.fragment,e),u(xt.$$.fragment,e),u(At.$$.fragment,e),u(Mt.$$.fragment,e),u(kt.$$.fragment,e),u(It.$$.fragment,e),u(Ct.$$.fragment,e),rr=!0)},o(e){h(b.$$.fragment,e),h(y.$$.fragment,e),h(je.$$.fragment,e),h(Je.$$.fragment,e),h(Pe.$$.fragment,e),h(re.$$.fragment,e),h(Ue.$$.fragment,e),h(qe.$$.fragment,e),h(ne.$$.fragment,e),h(Ee.$$.fragment,e),h(ae.$$.fragment,e),h(Ze.$$.fragment,e),h(We.$$.fragment,e),h(se.$$.fragment,e),h(le.$$.fragment,e),h(Re.$$.fragment,e),h(ze.$$.fragment,e),h(ie.$$.fragment,e),h(me.$$.fragment,e),h(Ge.$$.fragment,e),h(Ve.$$.fragment,e),h(Ne.$$.fragment,e),h(de.$$.fragment,e),h(De.$$.fragment,e),h(pe.$$.fragment,e),h(Be.$$.fragment,e),h(Ye.$$.fragment,e),h(Fe.$$.fragment,e),h(Se.$$.fragment,e),h(Qe.$$.fragment,e),h(Xe.$$.fragment,e),h(Oe.$$.fragment,e),h(Ke.$$.fragment,e),h(et.$$.fragment,e),h(tt.$$.fragment,e),h(ot.$$.fragment,e),h(rt.$$.fragment,e),h(nt.$$.fragment,e),h(at.$$.fragment,e),h(st.$$.fragment,e),h(lt.$$.fragment,e),h(it.$$.fragment,e),h(mt.$$.fragment,e),h(dt.$$.fragment,e),h(pt.$$.fragment,e),h(ct.$$.fragment,e),h(gt.$$.fragment,e),h(ft.$$.fragment,e),h(ut.$$.fragment,e),h(bt.$$.fragment,e),h(yt.$$.fragment,e),h(wt.$$.fragment,e),h(Tt.$$.fragment,e),h(xt.$$.fragment,e),h(At.$$.fragment,e),h(Mt.$$.fragment,e),h(kt.$$.fragment,e),h(It.$$.fragment,e),h(Ct.$$.fragment,e),rr=!1},d(e){e&&(o(w),o(_),o(p),o(a),o(yo),o(He),o(wo),o(To),o(Le),o(xo),o(Ao),o(z),o(Mo),o(ko),o(J),o(Io),o(Co),o(P),o(Ho),o(jo),o(U),o(Lo),o(Jo),o(j),o(Po),o(Uo),o(qo),o(Q),o(Eo),o(Zo),o(M),o(Wo),o(Ro),o(I),o(zo),o(Go),o(q),o(Vo),o(No),o(X),o(Do),o(Bo),o(ht),o(Yo),o($t),o(Fo),o(_t),o(So),o(vt),o(Qo),o(Xo),o(O),o(Oo),o(Ko),o(E),o(er),o(tr),o(Z),o(or),o(bo)),o(l),$(b,e),$(y,e),$(je,e),$(Je,e),$(Pe),$(re),$(Ue,e),$(qe),$(ne),$(Ee),$(ae),$(Ze,e),$(We),$(se),$(le),$(Re,e),$(ze),$(ie),$(me),$(Ge,e),$(Ve),$(Ne),$(de),$(De),$(pe),$(Be),$(Ye,e),$(Fe,e),$(Se),$(Qe,e),$(Xe),$(Oe),$(Ke),$(et),$(tt),$(ot),$(rt,e),$(nt),$(at),$(st),$(lt),$(it),$(mt,e),$(dt),$(pt),$(ct),$(gt,e),$(ft),$(ut,e),$(bt,e),$(yt),$(wt,e),$(Tt),$(xt),$(At),$(Mt,e),$(kt),$(It),$(Ct)}}}const Wa='{"title":"エージェントとツール","local":"エージェントとツール","sections":[{"title":"エージェント","local":"エージェント","sections":[{"title":"HfAgent","local":"transformers.HfAgent","sections":[],"depth":3},{"title":"LocalAgent","local":"transformers.LocalAgent","sections":[],"depth":3},{"title":"OpenAiAgent","local":"transformers.OpenAiAgent","sections":[],"depth":3},{"title":"AzureOpenAiAgent","local":"transformers.AzureOpenAiAgent","sections":[],"depth":3},{"title":"Agent","local":"transformers.Agent","sections":[],"depth":3}],"depth":2},{"title":"Tools","local":"tools","sections":[{"title":"load_tool","local":"transformers.load_tool","sections":[],"depth":3},{"title":"Tool","local":"transformers.Tool","sections":[],"depth":3},{"title":"PipelineTool","local":"transformers.PipelineTool","sections":[],"depth":3},{"title":"RemoteTool","local":"transformers.RemoteTool","sections":[],"depth":3},{"title":"launch_gradio_demo","local":"transformers.launch_gradio_demo","sections":[],"depth":3}],"depth":2},{"title":"エージェントの種類","local":"エージェントの種類","sections":[{"title":"AgentText","local":"transformers.tools.agent_types.AgentText","sections":[],"depth":3},{"title":"AgentImage","local":"transformers.tools.agent_types.AgentImage","sections":[],"depth":3},{"title":"AgentAudio","local":"transformers.tools.agent_types.AgentAudio","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ra(k){return xa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fa extends Aa{constructor(l){super(),Ma(this,l,Ra,Za,Ta,{})}}export{Fa as component};
