import{s as Gp,o as Hp,n as Kl}from"../chunks/scheduler.25b97de1.js";import{S as jp,i as Ip,g as s,s as n,r as d,A as Jp,h as o,f as l,c as a,j as Dp,u as c,x as r,k as U,y as kp,a as i,v,d as w,t as y,w as P}from"../chunks/index.d9030fc9.js";import{T as _s}from"../chunks/Tip.baa67368.js";import{C as b}from"../chunks/CodeBlock.e6cd0d95.js";import{H as C,E as Sp}from"../chunks/EditOnGithub.91d95064.js";import{H as Ep,a as Ds}from"../chunks/HfOption.1e589c90.js";function Vp(T){let p,g=`While the main concepts discussed in this guide are likely applicable across frameworks, here we focus on
PyTorch-based implementations.`;return{c(){p=s("p"),p.textContent=g},l(f){p=o(f,"P",{"data-svelte-h":!0}),r(p)!=="svelte-11nx342"&&(p.textContent=g)},m(f,u){i(f,p,u)},p:Kl,d(f){f&&l(p)}}}function Ap(T){let p,g=`This mechanism is similar to an efficient group backpacking strategy: person A carries the tent, person B carries the stove,
and person C carries the axe. Each night they all share what they have with others and get from others what they don’t have,
and in the morning they pack up their allocated type of gear and continue on their way. This is what ZeRO DP/Sharded DDP is.
Compare this strategy to the simple one where each person has to carry their own tent, stove and axe (similar to
DataParallel (DP and DDP) in PyTorch), which would be far more inefficient.`;return{c(){p=s("p"),p.textContent=g},l(f){p=o(f,"P",{"data-svelte-h":!0}),r(p)!=="svelte-15youi0"&&(p.textContent=g)},m(f,u){i(f,p,u)},p:Kl,d(f){f&&l(p)}}}function Rp(T){let p,g="Use the <code>--nproc_per_node</code> to select how many GPUs to use.",f,u,M;return u=new b({props:{code:"dG9yY2hydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTNEMiUyMCUyMHRyYWluZXItcHJvZ3JhbS5weSUyMC4uLg==",highlighted:"torchrun --nproc_per_node=2  trainer-program.py ...",wrap:!1}}),{c(){p=s("p"),p.innerHTML=g,f=n(),d(u.$$.fragment)},l(m){p=o(m,"P",{"data-svelte-h":!0}),r(p)!=="svelte-ghitll"&&(p.innerHTML=g),f=a(m),c(u.$$.fragment,m)},m(m,h){i(m,p,h),i(m,f,h),v(u,m,h),M=!0},p:Kl,i(m){M||(w(u.$$.fragment,m),M=!0)},o(m){y(u.$$.fragment,m),M=!1},d(m){m&&(l(p),l(f)),P(u,m)}}}function Np(T){let p,g="Use <code>--num_processes</code> to select how many GPUs to use.",f,u,M;return u=new b({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tbnVtX3Byb2Nlc3NlcyUyMDIlMjB0cmFpbmVyLXByb2dyYW0ucHklMjAuLi4=",highlighted:"accelerate launch --num_processes 2 trainer-program.py ...",wrap:!1}}),{c(){p=s("p"),p.innerHTML=g,f=n(),d(u.$$.fragment)},l(m){p=o(m,"P",{"data-svelte-h":!0}),r(p)!=="svelte-15fv5d7"&&(p.innerHTML=g),f=a(m),c(u.$$.fragment,m)},m(m,h){i(m,p,h),i(m,f,h),v(u,m,h),M=!0},p:Kl,i(m){M||(w(u.$$.fragment,m),M=!0)},o(m){y(u.$$.fragment,m),M=!1},d(m){m&&(l(p),l(f)),P(u,m)}}}function zp(T){let p,g="Use <code>--num_gpus</code> to select how many GPUs to use.",f,u,M;return u=new b({props:{code:"ZGVlcHNwZWVkJTIwLS1udW1fZ3B1cyUyMDIlMjB0cmFpbmVyLXByb2dyYW0ucHklMjAuLi4=",highlighted:"deepspeed --num_gpus 2 trainer-program.py ...",wrap:!1}}),{c(){p=s("p"),p.innerHTML=g,f=n(),d(u.$$.fragment)},l(m){p=o(m,"P",{"data-svelte-h":!0}),r(p)!=="svelte-14evfjd"&&(p.innerHTML=g),f=a(m),c(u.$$.fragment,m)},m(m,h){i(m,p,h),i(m,f,h),v(u,m,h),M=!0},p:Kl,i(m){M||(w(u.$$.fragment,m),M=!0)},o(m){y(u.$$.fragment,m),M=!1},d(m){m&&(l(p),l(f)),P(u,m)}}}function Bp(T){let p,g,f,u,M,m;return p=new Ds({props:{id:"select-gpu",option:"torchrun",$$slots:{default:[Rp]},$$scope:{ctx:T}}}),f=new Ds({props:{id:"select-gpu",option:"Accelerate",$$slots:{default:[Np]},$$scope:{ctx:T}}}),M=new Ds({props:{id:"select-gpu",option:"DeepSpeed",$$slots:{default:[zp]},$$scope:{ctx:T}}}),{c(){d(p.$$.fragment),g=n(),d(f.$$.fragment),u=n(),d(M.$$.fragment)},l(h){c(p.$$.fragment,h),g=a(h),c(f.$$.fragment,h),u=a(h),c(M.$$.fragment,h)},m(h,x){v(p,h,x),i(h,g,x),v(f,h,x),i(h,u,x),v(M,h,x),m=!0},p(h,x){const z={};x&2&&(z.$$scope={dirty:x,ctx:h}),p.$set(z);const $={};x&2&&($.$$scope={dirty:x,ctx:h}),f.$set($);const ei={};x&2&&(ei.$$scope={dirty:x,ctx:h}),M.$set(ei)},i(h){m||(w(p.$$.fragment,h),w(f.$$.fragment,h),w(M.$$.fragment,h),m=!0)},o(h){y(p.$$.fragment,h),y(f.$$.fragment,h),y(M.$$.fragment,h),m=!1},d(h){h&&(l(g),l(u)),P(p,h),P(f,h),P(M,h)}}}function Qp(T){let p,g="As with any environment variable, they can be exported instead of being added to the command line. However, this is not recommended because it can be confusing if you forget how the environment variable was setup and you end up using the wrong GPUs. Instead, it is common practice to set the environment variable for a specific training run on the same command line.";return{c(){p=s("p"),p.textContent=g},l(f){p=o(f,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1ky103q"&&(p.textContent=g)},m(f,u){i(f,p,u)},p:Kl,d(f){f&&l(p)}}}function Wp(T){let p,g,f,u,M,m,h,x=`If training a model on a single GPU is too slow or if the model’s weights do not fit in a single GPU’s memory, transitioning
to a multi-GPU setup may be a viable option. Prior to making this transition, thoroughly explore all the strategies covered
in the <a href="perf_train_gpu_one">Methods and tools for efficient training on a single GPU</a> as they are universally applicable
to model training on any number of GPUs. Once you have employed those strategies and found them insufficient for your
case on a single GPU, consider moving to multiple GPUs.`,z,$,ei=`Transitioning from a single GPU to multiple GPUs requires the introduction of some form of parallelism, as the workload
must be distributed across the resources. Multiple techniques can be employed to achieve parallelism, such as data
parallelism, tensor parallelism, and pipeline parallelism. It’s important to note that there isn’t a one-size-fits-all
solution, and the optimal settings depend on the specific hardware configuration you are using.`,li,B,Gs=`This guide offers an in-depth overview of individual types of parallelism, as well as guidance on ways to combine<br/>
techniques and choosing an appropriate approach. For step-by-step tutorials on distributed training, please refer to
the <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">🤗 Accelerate documentation</a>.`,ii,L,ni,Q,Hs=`Before diving deeper into the specifics of each technique, let’s go over the rough decision process when training
large models on a large infrastructure.`,ai,W,si,F,js=`Begin by estimating how much vRAM is required to train your model. For models hosted on the 🤗 Hub, use our
<a href="https://huggingface.co/spaces/hf-accelerate/model-memory-usage" rel="nofollow">Model Memory Calculator</a>, which gives you
accurate calculations within a few percent margin.`,oi,Z,Is="<strong>Parallelization strategy for a single Node / multi-GPU setup</strong>",ri,O,Js=`When training a model on a single node with multiple GPUs, your choice of parallelization strategy can significantly
impact performance. Here’s a breakdown of your options:`,pi,X,ks="<strong>Case 1: Your model fits onto a single GPU</strong>",mi,Y,Ss="If your model can comfortably fit onto a single GPU, you have two primary options:",hi,q,Es='<li>DDP - Distributed DataParallel</li> <li><a href="https://arxiv.org/abs/1910.02054" rel="nofollow">Zero Redundancy Optimizer (ZeRO)</a> - depending on the situation and configuration used, this method may or may not be faster, however, it’s worth experimenting with it.</li>',fi,K,Vs="<strong>Case 2: Your model doesn’t fit onto a single GPU:</strong>",ui,ee,As="If your model is too large for a single GPU, you have several alternatives to consider:",di,te,Rs='<li>PipelineParallel (PP)</li> <li><a href="https://arxiv.org/abs/1910.02054" rel="nofollow">ZeRO</a></li> <li><a href="#tensor-parallelism">TensorParallel</a> (TP)</li>',ci,le,Ns=`With very fast inter-node connectivity (e.g., NVLINK or NVSwitch) all three strategies (PP, ZeRO, TP) should result in
similar performance. However, without these, PP will be faster than TP or ZeRO. The degree of TP may also
make a difference. It’s best to experiment with your specific setup to determine the most suitable strategy.`,vi,ie,zs="TP is almost always used within a single node. That is TP size <= GPUs per node.",wi,ne,Bs="<strong>Case 3: Largest layer of your model does not fit onto a single GPU</strong>",yi,ae,Qs='<li>If you are not using ZeRO, you have to use TensorParallel (TP), because PipelineParallel (PP) alone won’t be sufficient to accommodate the large layer.</li> <li>If you are using ZeRO, additionally adopt techniques from the <a href="perf_train_gpu_one">Methods and tools for efficient training on a single GPU</a>.</li>',Pi,se,Ws="<strong>Parallelization strategy for a multi-Node / multi-GPU setup</strong>",Mi,oe,Fs="<li><p>When you have fast inter-node connectivity (e.g., NVLINK or NVSwitch) consider using one of these options:</p> <ol><li>ZeRO - as it requires close to no modifications to the model</li> <li>A combination of PipelineParallel(PP) with TensorParallel(TP) and DataParallel(DP) - this approach will result in fewer communications, but requires significant changes to the model</li></ol></li> <li><p>When you have slow inter-node connectivity and still low on GPU memory:</p> <ol><li>Employ a combination of DataParallel(DP) with PipelineParallel(PP), TensorParallel(TP), and ZeRO.</li></ol></li>",gi,re,Zs="In the following sections of this guide we dig deeper into how these different parallelism methods work.",Ti,pe,xi,me,Os=`Even with only 2 GPUs, you can readily leverage the accelerated training capabilities offered by PyTorch’s built-in features,
such as <code>DataParallel</code> (DP) and <code>DistributedDataParallel</code> (DDP). Note that
<a href="https://pytorch.org/docs/master/generated/torch.nn.DataParallel.html" rel="nofollow">PyTorch documentation</a> recommends to prefer
<code>DistributedDataParallel</code> (DDP) over <code>DataParallel</code> (DP) for multi-GPU training as it works for all models.
Let’s take a look at how these two methods work and what makes them different.`,bi,he,Ci,fe,Xs="To understand the key differences in inter-GPU communication overhead between the two methods, let’s review the processes per batch:",Ui,ue,Ys='<a href="https://pytorch.org/docs/master/notes/ddp.html" rel="nofollow">DDP</a>:',$i,de,qs="<li>At the start time the main process replicates the model once from GPU 0 to the rest of GPUs</li> <li>Then for each batch:<ol><li>Each GPU directly consumes its mini-batch of data.</li> <li>During <code>backward</code>, once the local gradients are ready, they are averaged across all processes.</li></ol></li>",Li,ce,Ks='<a href="https://pytorch.org/docs/master/generated/torch.nn.DataParallel.html" rel="nofollow">DP</a>:',_i,ve,eo="For each batch:",Di,we,to="<li>GPU 0 reads the batch of data and then sends a mini-batch to each GPU.</li> <li>The up-to-date model is replicated from GPU 0 to each GPU.</li> <li><code>forward</code> is executed, and output from each GPU is sent to GPU 0 to compute the loss.</li> <li>The loss is distributed from GPU 0 to all GPUs, and <code>backward</code> is run.</li> <li>Gradients from each GPU are sent to GPU 0 and averaged.</li>",Gi,ye,lo="Key differences include:",Hi,Pe,io=`<li>DDP performs only a single communication per batch - sending gradients, while DP performs five different data exchanges per batch.
DDP copies data using <a href="https://pytorch.org/docs/master/distributed.html" rel="nofollow">torch.distributed</a>, while DP copies data within
the process via Python threads (which introduces limitations associated with GIL). As a result, <strong><code>DistributedDataParallel</code> (DDP) is generally faster than <code>DataParallel</code> (DP)</strong> unless you have slow GPU card inter-connectivity.</li> <li>Under DP, GPU 0 performs significantly more work than other GPUs, resulting in GPU under-utilization.</li> <li>DDP supports distributed training across multiple machines, whereas DP does not.</li>`,ji,Me,no=`This is not an exhaustive list of differences between DP and DDP, however, other nuances are out of scope of this guide.
You can get a deeper understanding of these methods by reading this <a href="https://www.telesens.co/2019/04/04/distributed-data-parallel-training-using-pytorch-on-aws/" rel="nofollow">article</a>.`,Ii,ge,ao=`Let’s illustrate the differences between DP and DDP with an experiment. We’ll benchmark the differences between DP and
DDP with an added context of NVLink presence:`,Ji,Te,so="<li>Hardware: 2x TITAN RTX 24GB each + NVlink with 2 NVLinks (<code>NV2</code> in <code>nvidia-smi topo -m</code>).</li> <li>Software: <code>pytorch-1.8-to-be</code> + <code>cuda-11.0</code> / <code>transformers==4.3.0.dev0</code>.</li>",ki,xe,oo="To disable the NVLink feature on one of the benchmarks, we use <code>NCCL_P2P_DISABLE=1</code>.",Si,be,ro="Here is the benchmarking code and outputs:",Ei,Ce,po="<strong>DP</strong>",Vi,Ue,Ai,$e,mo="<strong>DDP w/ NVlink</strong>",Ri,Le,Ni,_e,ho="<strong>DDP w/o NVlink</strong>",zi,De,Bi,Ge,fo="Here are the same benchmarking results gathered in a table for convenience:",Qi,He,uo='<thead><tr><th align="left">Type</th> <th>NVlink</th> <th align="right">Time</th></tr></thead> <tbody><tr><td align="left">2:DP</td> <td>Y</td> <td align="right">110s</td></tr> <tr><td align="left">2:DDP</td> <td>Y</td> <td align="right">101s</td></tr> <tr><td align="left">2:DDP</td> <td>N</td> <td align="right">131s</td></tr></tbody>',Wi,je,co=`As you can see, in this case DP is ~10% slower than DDP with NVlink, but ~15% faster than DDP without NVlink.
The real difference will depend on how much data each GPU needs to sync with the others - the more there is to sync,
the more a slow link will impede the overall runtime.`,Fi,Ie,Zi,Je,vo='ZeRO-powered data parallelism (ZeRO-DP) is illustrated in the following diagram from this <a href="https://www.microsoft.com/en-us/research/blog/zero-deepspeed-new-system-optimizations-enable-training-models-with-over-100-billion-parameters/" rel="nofollow">blog post</a>.',Oi,_,wo='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-zero.png" alt="DeepSpeed-Image-1"/>',Xi,ke,yo=`While it may appear complex, it is a very similar concept to <code>DataParallel</code> (DP). The difference is that instead of
replicating the full model parameters, gradients and optimizer states, each GPU stores only a slice of it. Then, at
run-time when the full layer parameters are needed just for the given layer, all GPUs synchronize to give each other
parts that they miss.`,Yi,Se,Po=`To illustrate this idea, consider a simple model with 3 layers (La, Lb, and Lc), where each layer has 3 parameters.
Layer La, for example, has weights a0, a1 and a2:`,qi,Ee,Ki,Ve,Mo="If we have 3 GPUs, ZeRO-DP splits the model onto 3 GPUs like so:",en,Ae,tn,Re,go=`In a way, this is the same horizontal slicing as tensor parallelism, as opposed to Vertical
slicing, where one puts whole layer-groups on different GPUs. Now let’s see how this works:`,ln,Ne,To="Each of these GPUs will get the usual mini-batch as it works in DP:",nn,ze,an,Be,xo="The inputs are passed without modifications as if they would be processed by the original model.",sn,Qe,bo="First, the inputs get to the layer <code>La</code>. What happens at this point?",on,We,Co=`On GPU0: the x0 mini-batch requires the a0, a1, a2 parameters to do its forward path through the layer, but the GPU0 has only a0.
It will get a1 from GPU1 and a2 from GPU2, bringing all the pieces of the model together.`,rn,Fe,Uo=`In parallel, GPU1 gets another mini-batch - x1. GPU1 has the a1 parameter, but needs a0 and a2, so it gets those from GPU0 and GPU2.
Same happens to GPU2 that gets the mini-batch x2. It gets a0 and a1 from GPU0 and GPU1.`,pn,Ze,$o=`This way each of the 3 GPUs gets the full tensors reconstructed and makes a forward pass with its own mini-batch.
As soon as the calculation is done, the data that is no longer needed gets dropped - it’s only used during the calculation.
The reconstruction is done efficiently via a pre-fetch.`,mn,Oe,Lo="Then the whole process is repeated for layer Lb, then Lc forward-wise, and then backward Lc -> Lb -> La.",hn,D,fn,Xe,_o=`While reading the literature on this topic you may encounter the following synonyms: Sharded, Partitioned.
If you pay close attention the way ZeRO partitions the model’s weights - it looks very similar to tensor parallelism
which will be discussed later. This is because it partitions/shards each layer’s weights, unlike vertical model parallelism
which is discussed next.`,un,Ye,Do="Implementations:",dn,qe,Go='<li><a href="https://www.deepspeed.ai/tutorials/zero/" rel="nofollow">DeepSpeed</a> ZeRO-DP stages 1+2+3</li> <li><a href="https://huggingface.co/docs/accelerate/en/usage_guides/deepspeed" rel="nofollow"><code>Accelerate</code> integration</a></li> <li><a href="main_classes/trainer#trainer-integrations"><code>transformers</code> integration</a></li>',cn,Ke,vn,et,Ho=`To explain Pipeline parallelism, we’ll first look into Naive Model Parallelism (MP), also known as Vertical MP. This approach
involves distributing groups of model layers across multiple GPUs by assigning specific layers to specific GPUs with <code>.to()</code>.
As data flows through these layers, it is moved to the same GPU as the layer, while the other layers remain untouched.`,wn,tt,jo=`We refer to this Model parallelism as “Vertical” because of how models are typically visualized. For example, the
following diagram shows an 8-layer model split vertically into two slices, placing layers 0-3 onto
GPU0 and 4-7 to GPU1:`,yn,lt,Pn,it,Io=`In this example, when data moves from layer 0 to 3, it’s no different from regular forward pass. However, passing data
from layer 3 to 4 requires moving it from GPU0 to GPU1, introducing a communication overhead. If the participating
GPUs are on the same compute node (e.g. same physical machine) this copying is fast, but if the GPUs are distributed
across different compute nodes (e.g. multiple machines), the communication overhead could be substantially greater.`,Mn,nt,Jo=`Following that, layers 4 to 7 work as they would in the original model. Upon completion of the 7th layer, there is often
a need to send the data back to layer 0 where the labels are (or alternatively send the labels to the last layer). Now the loss can be
computed and the optimizer can do its work.`,gn,at,ko="Naive Model Parallelism comes several shortcomings:",Tn,st,So="<li><strong>All but one GPU are idle at any given moment</strong>: if 4 GPUs are used, it’s nearly identical to quadrupling the amount of memory of a single GPU, and ignoring the rest of the hardware.</li> <li><strong>Overhead in data transfer between devices</strong>:  E.g. 4x 6GB cards will be able to accommodate the same size as 1x 24GB card using naive MP, but a single 24GB card will complete the training faster, because it doesn’t have the data copying overhead. But, say, if you have 40GB cards and need to fit a 45GB model you can with 4x 40GB cards (but barely because of the gradient and optimizer states)</li> <li><strong>Copying shared embeddings</strong>: Shared embeddings may need to get copied back and forth between GPUs.</li>",xn,ot,Eo=`Now that you are familiar with how the naive approach to model parallelism works and its shortcomings, let’s look at Pipeline Parallelism (PP).
PP is almost identical to a naive MP, but it solves the GPU idling problem by chunking the incoming batch into micro-batches
and artificially creating a pipeline, which allows different GPUs to concurrently participate in the computation process.`,bn,rt,Vo=`The following illustration from the <a href="https://ai.googleblog.com/2019/03/introducing-gpipe-open-source-library.html" rel="nofollow">GPipe paper</a>
shows the naive MP on the top, and PP on the bottom:`,Cn,G,Ao='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-gpipe-bubble.png" alt="MP vs PP"/>',Un,pt,Ro=`At the bottom of the diagram, you can observe that the Pipeline Parallelism (PP) approach minimizes the number of idle
GPU zones, referred to as ‘bubbles’. Both parts of the diagram show a parallelism level of degree 4, meaning that 4 GPUs
are involved in the pipeline. You can see that there’s a forward path of 4 pipe stages (F0, F1, F2 and F3) followed by
a backward path in reverse order (B3, B2, B1, and B0).`,$n,mt,No=`PP introduces a new hyperparameter to tune - <code>chunks</code>, which determines how many data chunks are sent in a sequence
through the same pipe stage. For example, in the bottom diagram you can see <code>chunks=4</code>. GPU0 performs the same
forward path on chunk 0, 1, 2 and 3 (F0,0, F0,1, F0,2, F0,3) and then it waits for other GPUs to do complete their work.
Only when the other GPUs begin to complete their work, GPU0 starts to work again doing the backward path for chunks
3, 2, 1 and 0 (B0,3, B0,2, B0,1, B0,0).`,Ln,ht,zo=`Note that this is the same concept as gradient accumulation steps. PyTorch uses <code>chunks</code>, while DeepSpeed refers
to the same hyperparameter as gradient accumulation steps.`,_n,ft,Bo=`Because of the chunks, PP introduces the notion of micro-batches (MBS). DP splits the global data batch size into
mini-batches, so if you have a DP degree of 4, a global batch size of 1024 gets split up into 4 mini-batches of
256 each (1024/4). And if the number of <code>chunks</code> (or GAS) is 32 we end up with a micro-batch size of 8 (256/32). Each
Pipeline stage works with a single micro-batch at a time. To calculate the global batch size of the DP + PP setup,
use the formula: <code>mbs * chunks * dp_degree</code> (<code>8 * 32 * 4 = 1024</code>).
With <code>chunks=1</code> you end up with the naive MP, which is inefficient. With a large <code>chunks</code> value you end up with
tiny micro-batch sizes which is also inefficient. For this reason, we encourage to experiment with the <code>chunks</code> value to
find the one that leads to the most efficient GPUs utilization.`,Dn,ut,Qo=`You may notice a bubble of “dead” time on the diagram that can’t be parallelized because the last <code>forward</code> stage
has to wait for <code>backward</code> to complete the pipeline. The purpose of finding the best value for <code>chunks</code> is to enable a high
concurrent GPU utilization across all participating GPUs which translates to minimizing the size of the bubble.`,Gn,dt,Wo="Pipeline API solutions have been implemented in:",Hn,ct,Fo="<li>PyTorch</li> <li>DeepSpeed</li> <li>Megatron-LM</li>",jn,vt,Zo="These come with some shortcomings:",In,wt,Oo='<li>They have to modify the model quite heavily, because Pipeline requires one to rewrite the normal flow of modules into a <code>nn.Sequential</code> sequence of the same, which may require changes to the design of the model.</li> <li>Currently the Pipeline API is very restricted. If you had a bunch of Python variables being passed in the very first stage of the Pipeline, you will have to find a way around it. Currently, the pipeline interface requires either a single Tensor or a tuple of Tensors as the only input and output. These tensors must have a batch size as the very first dimension, since pipeline is going to chunk the mini batch into micro-batches. Possible improvements are being discussed here <a href="https://github.com/pytorch/pytorch/pull/50693" rel="nofollow">https://github.com/pytorch/pytorch/pull/50693</a></li> <li>Conditional control flow at the level of pipe stages is not possible - e.g., Encoder-Decoder models like T5 require special workarounds to handle a conditional encoder stage.</li> <li>They have to arrange each layer so that the output of one layer becomes an input to the other layer.</li>',Jn,yt,Xo="More recent solutions include:",kn,Pt,Yo="<li>Varuna</li> <li>Sagemaker</li>",Sn,Mt,qo=`We have not experimented with Varuna and SageMaker but their papers report that they have overcome the list of problems
mentioned above and that they require smaller changes to the user’s model.`,En,gt,Ko="Implementations:",Vn,Tt,er='<li><a href="https://pytorch.org/docs/stable/pipeline.html" rel="nofollow">PyTorch</a> (initial support in pytorch-1.8, and progressively getting improved in 1.9 and more so in 1.10). Some <a href="https://github.com/pytorch/pytorch/blob/master/benchmarks/distributed/pipeline/pipe.py" rel="nofollow">examples</a></li> <li><a href="https://www.deepspeed.ai/tutorials/pipeline/" rel="nofollow">DeepSpeed</a></li> <li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a> has an internal implementation - no API.</li> <li><a href="https://github.com/microsoft/varuna" rel="nofollow">Varuna</a></li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a> - this is a proprietary solution that can only be used on AWS.</li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a> - this is implemented based on the Hugging Face Transformers.</li>',An,xt,tr=`🤗 Transformers status: as of this writing none of the models supports full-PP. GPT2 and T5 models have naive MP support.
The main obstacle is being unable to convert the models to <code>nn.Sequential</code> and have all the inputs to be Tensors. This
is because currently the models include many features that make the conversion very complicated, and will need to be removed to accomplish that.`,Rn,bt,lr='DeepSpeed and Megatron-LM integrations are available in <a href="https://huggingface.co/docs/accelerate/main/en/usage_guides/deepspeed" rel="nofollow">🤗 Accelerate</a>',Nn,Ct,ir="Other approaches:",zn,Ut,nr='DeepSpeed, Varuna and SageMaker use the concept of an <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-parallel-core-features.html" rel="nofollow">Interleaved Pipeline</a>',Bn,H,ar='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-sagemaker-interleaved-pipeline.png" alt="Interleaved pipeline execution"/>',Qn,$t,sr=`Here the bubble (idle time) is further minimized by prioritizing backward passes. Varuna further attempts to improve the
schedule by using simulations to discover the most efficient scheduling.`,Wn,Lt,or="OSLO has pipeline parallelism implementation based on the Transformers without <code>nn.Sequential</code> conversion.",Fn,_t,Zn,Dt,rr=`In Tensor Parallelism, each GPU processes a slice of a tensor and only aggregates the full tensor for operations requiring it.
To describe this method, this section of the guide relies on the concepts and diagrams from the <a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a>
paper: <a href="https://arxiv.org/abs/2104.04473" rel="nofollow">Efficient Large-Scale Language Model Training on GPU Clusters</a>.`,On,Gt,pr=`The main building block of any transformer is a fully connected <code>nn.Linear</code> followed by a nonlinear activation <code>GeLU</code>.
The dot dot-product part of it, following the Megatron’s paper notation, can be written as <code>Y = GeLU(XA)</code>, where <code>X</code> is
an input vector, <code>Y</code> is the output vector, and <code>A</code> is the weight matrix.`,Xn,Ht,mr="If we look at the computation in matrix form, you can see how the matrix multiplication can be split between multiple GPUs:",Yn,j,hr='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-parallel_gemm.png" alt="Parallel GEMM"/>',qn,jt,fr=`If we split the weight matrix <code>A</code> column-wise across <code>N</code> GPUs and perform matrix multiplications <code>XA_1</code> through <code>XA_n</code> in parallel,
then we will end up with <code>N</code> output vectors <code>Y_1, Y_2, ..., Y_n</code> which can be fed into <code>GeLU</code> independently:`,Kn,I,ur='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-independent-gelu.png" alt="Independent GeLU"/>',ea,It,dr=`Using this principle, we can update a multi-layer perceptron of arbitrary depth, without the need for any synchronization
between GPUs until the very end, where we need to reconstruct the output vector from shards. The Megatron-LM paper authors
provide a helpful illustration for that:`,ta,J,cr='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-parallel_shard_processing.png" alt="Parallel shard processing"/>',la,Jt,vr=`Parallelizing the multi-headed attention layers is even simpler, since they are already inherently parallel, due to having
multiple independent heads!`,ia,k,wr='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-parallel_self_attention.png" alt="Parallel self-attention"/>',na,kt,yr=`Special considerations: TP requires very fast network, and therefore it’s not advisable to do TP across more than one node.
Practically, if a node has 4 GPUs, the highest TP degree is therefore 4. If you need a TP degree of 8, you need to use
nodes that have at least 8 GPUs.`,aa,St,Pr=`This section is based on the original much more <a href="https://github.com/huggingface/transformers/issues/10321#issuecomment-783543530" rel="nofollow">detailed TP overview</a>.
by <a href="https://github.com/anton-l" rel="nofollow">@anton-l</a>.`,sa,Et,Mr="Alternative names:",oa,Vt,gr='<li>DeepSpeed calls it <a href="https://www.deepspeed.ai/training/#model-parallelism" rel="nofollow">tensor slicing</a></li>',ra,At,Tr="Implementations:",pa,Rt,xr='<li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a> has an internal implementation, as it’s very model-specific</li> <li><a href="https://github.com/tunib-ai/parallelformers" rel="nofollow">parallelformers</a> (only inference at the moment)</li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a> - this is a proprietary solution that can only be used on AWS.</li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a> has the tensor parallelism implementation based on the Transformers.</li>',ma,Nt,br="SageMaker combines TP with DP for a more efficient processing.",ha,zt,Cr="🤗 Transformers status:",fa,Bt,Ur='<li>core: not yet implemented in the core</li> <li>but if you want inference <a href="https://github.com/tunib-ai/parallelformers" rel="nofollow">parallelformers</a> provides this support for most of our models. So until this is implemented in the core you can use theirs. And hopefully training mode will be supported too.</li> <li>Deepspeed-Inference also supports our BERT, GPT-2, and GPT-Neo models in their super-fast CUDA-kernel-based inference mode, see more <a href="https://www.deepspeed.ai/tutorials/inference-tutorial/" rel="nofollow">here</a></li>',ua,Qt,$r='🤗 Accelerate integrates with <a href="https://huggingface.co/docs/accelerate/v0.23.0/en/usage_guides/megatron_lm" rel="nofollow">TP from Megatron-LM</a>.',da,Wt,ca,Ft,Lr=`The following diagram from the DeepSpeed <a href="https://www.deepspeed.ai/tutorials/pipeline/" rel="nofollow">pipeline tutorial</a> demonstrates
how one can combine DP with PP.`,va,S,_r='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-zero-dp-pp.png" alt="DP + PP-2d"/>',wa,Zt,Dr=`Here it’s important to see how DP rank 0 doesn’t see GPU2 and DP rank 1 doesn’t see GPU3. To DP there is just GPUs 0
and 1 where it feeds data as if there were just 2 GPUs. GPU0 “secretly” offloads some of its load to GPU2 using PP.
And GPU1 does the same by enlisting GPU3 to its aid.`,ya,Ot,Gr="Since each dimension requires at least 2 GPUs, here you’d need at least 4 GPUs.",Pa,Xt,Hr="Implementations:",Ma,Yt,jr='<li><a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a></li> <li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a></li> <li><a href="https://github.com/microsoft/varuna" rel="nofollow">Varuna</a></li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a></li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a></li>',ga,qt,Ir="🤗 Transformers status: not yet implemented",Ta,Kt,xa,el,Jr="To get an even more efficient training a 3D parallelism is used where PP is combined with TP and DP. This can be seen in the following diagram.",ba,E,kr='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-deepspeed-3d.png" alt="dp-pp-tp-3d"/>',Ca,tl,Sr='This diagram is from a blog post <a href="https://www.microsoft.com/en-us/research/blog/deepspeed-extreme-scale-model-training-for-everyone/" rel="nofollow">3D parallelism: Scaling to trillion-parameter models</a>, which is a good read as well.',Ua,ll,Er="Since each dimension requires at least 2 GPUs, here you’d need at least 8 GPUs.",$a,il,Vr="Implementations:",La,nl,Ar='<li><a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a> - DeepSpeed also includes an even more efficient DP, which they call ZeRO-DP.</li> <li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a></li> <li><a href="https://github.com/microsoft/varuna" rel="nofollow">Varuna</a></li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a></li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a></li>',_a,al,Rr="🤗 Transformers status: not yet implemented, since we have no PP and TP.",Da,sl,Ga,ol,Nr=`One of the main features of DeepSpeed is ZeRO, which is a super-scalable extension of DP. It has already been
discussed in <a href="#zero-data-parallelism">ZeRO Data Parallelism</a>. Normally it’s a standalone feature that doesn’t require PP or TP.
But it can be combined with PP and TP.`,Ha,rl,zr="When ZeRO-DP is combined with PP (and optionally TP) it typically enables only ZeRO stage 1 (optimizer sharding).",ja,pl,Br=`While it’s theoretically possible to use ZeRO stage 2 (gradient sharding) with Pipeline Parallelism, it will have negative
performance impacts. There would need to be an additional reduce-scatter collective for every micro-batch to aggregate
the gradients before sharding, which adds a potentially significant communication overhead. By nature of Pipeline Parallelism,
small micro-batches are used and instead the focus is on trying to balance arithmetic intensity (micro-batch size) with
minimizing the Pipeline bubble (number of micro-batches). Therefore those communication costs are going to impact the performance.`,Ia,ml,Qr=`In addition, there are already fewer layers than normal due to PP and so the memory savings won’t be huge. PP already
reduces gradient size by <code>1/PP</code>, and so gradient sharding savings on top of that are less significant than pure DP.`,Ja,hl,Wr="ZeRO stage 3 is not a good choice either for the same reason - more inter-node communications required.",ka,fl,Fr="And since we have ZeRO, the other benefit is ZeRO-Offload. Since this is stage 1 optimizer states can be offloaded to CPU.",Sa,ul,Zr="Implementations:",Ea,dl,Or='<li><a href="https://github.com/microsoft/Megatron-DeepSpeed" rel="nofollow">Megatron-DeepSpeed</a> and <a href="https://github.com/bigscience-workshop/Megatron-DeepSpeed" rel="nofollow">Megatron-Deepspeed from BigScience</a>, which is the fork of the former repo.</li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a></li>',Va,cl,Xr="Important papers:",Aa,vl,Yr='<li><a href="https://arxiv.org/abs/2201.11990" rel="nofollow">Using DeepSpeed and Megatron to Train Megatron-Turing NLG 530B, A Large-Scale Generative Language Model</a></li>',Ra,wl,qr="🤗 Transformers status: not yet implemented, since we have no PP and TP.",Na,yl,za,Pl,Kr='<a href="https://github.com/flexflow/FlexFlow" rel="nofollow">FlexFlow</a> also solves the parallelization problem in a slightly different approach.',Ba,Ml,ep='Paper: <a href="https://arxiv.org/abs/1807.05358" rel="nofollow">“Beyond Data and Model Parallelism for Deep Neural Networks” by Zhihao Jia, Matei Zaharia, Alex Aiken</a>',Qa,gl,tp="It performs a sort of 4D Parallelism over Sample-Operator-Attribute-Parameter.",Wa,Tl,lp="<li>Sample = Data Parallelism (sample-wise parallel)</li> <li>Operator = Parallelize a single operation into several sub-operations</li> <li>Attribute = Data Parallelism (length-wise parallel)</li> <li>Parameter = Model Parallelism (regardless of dimension - horizontal or vertical)</li>",Fa,xl,ip="Examples:",Za,bl,np="<li>Sample</li>",Oa,Cl,ap="Let’s take 10 batches of sequence length 512. If we parallelize them by sample dimension into 2 devices, we get 10 x 512 which becomes be 5 x 2 x 512.",Xa,Ul,sp="<li>Operator</li>",Ya,$l,op=`If we perform layer normalization, we compute std first and mean second, and then we can normalize data.
Operator parallelism allows computing std and mean in parallel. So if we parallelize them by operator dimension into 2
devices (cuda:0, cuda:1), first we copy input data into both devices, and cuda:0 computes std, cuda:1 computes mean at the same time.`,qa,Ll,rp="<li>Attribute</li>",Ka,_l,pp="We have 10 batches of 512 length. If we parallelize them by attribute dimension into 2 devices, 10 x 512 will be 10 x 2 x 256.",es,Dl,mp="<li>Parameter</li>",ts,Gl,hp="It is similar with tensor model parallelism or naive layer-wise model parallelism.",ls,V,fp='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-flexflow.jpeg" alt="flex-flow-soap"/>',is,Hl,up=`The significance of this framework is that it takes resources like (1) GPU/TPU/CPU vs. (2) RAM/DRAM vs. (3)
fast-intra-connect/slow-inter-connect and it automatically optimizes all these algorithmically deciding which
parallelisation to use where.`,ns,jl,dp=`One very important aspect is that FlexFlow is designed for optimizing DNN parallelizations for models with static and
fixed workloads, since models with dynamic behavior may prefer different parallelization strategies across iterations.`,as,Il,cp=`So the promise is very attractive - it runs a 30min simulation on the cluster of choice and it comes up with the best
strategy to utilise this specific environment. If you add/remove/replace any parts it’ll run and re-optimize the plan
for that. And then you can train. A different setup will have its own custom optimization.`,ss,Jl,vp=`🤗 Transformers status: Transformers models are FX-trace-able via <a href="https://github.com/huggingface/transformers/blob/master/src/transformers/utils/fx.py" rel="nofollow">transformers.utils.fx</a>,
which is a prerequisite for FlexFlow, however, changes are required on the FlexFlow side to make it work with Transformers models.`,os,kl,rs,Sl,wp='When training on multiple GPUs, you can specify the number of GPUs to use and in what order. This can be useful for instance when you have GPUs with different computing power and want to use the faster GPU first. The selection process works for both <a href="https://pytorch.org/docs/stable/generated/torch.nn.parallel.DistributedDataParallel.html" rel="nofollow">DistributedDataParallel</a> and <a href="https://pytorch.org/docs/stable/generated/torch.nn.DataParallel.html" rel="nofollow">DataParallel</a> to use only a subset of the available GPUs, and you don’t need Accelerate or the <a href="./main_classes/deepspeed">DeepSpeed integration</a>.',ps,El,ms,Vl,yp="For example, if you have 4 GPUs and you only want to use the first 2:",hs,A,fs,Al,us,Rl,Pp="Now, to select which GPUs to use and their order, you’ll use the <code>CUDA_VISIBLE_DEVICES</code> environment variable. It is easiest to set the environment variable in a <code>~/bashrc</code> or another startup config file. <code>CUDA_VISIBLE_DEVICES</code> is used to map which GPUs are used. For example, if you have 4 GPUs (0, 1, 2, 3) and you only want to run GPUs 0 and 2:",ds,Nl,cs,zl,Mp="Only the 2 physical GPUs (0 and 2) are “visible” to PyTorch and these are mapped to <code>cuda:0</code> and <code>cuda:1</code> respectively. You can also reverse the order of the GPUs to use 2 first. Now, the mapping is <code>cuda:1</code> for GPU 0 and <code>cuda:0</code> for GPU 2.",vs,Bl,ws,Ql,gp="You can also set the <code>CUDA_VISIBLE_DEVICES</code> environment variable to an empty value to create an environment without GPUs.",ys,Wl,Ps,R,Ms,Fl,Tp="<code>CUDA_DEVICE_ORDER</code> is an alternative environment variable you can use to control how the GPUs are ordered. You can either order them by:",gs,Zl,xp='<li>PCIe bus ID’s that matches the order of <a href="https://developer.nvidia.com/nvidia-system-management-interface" rel="nofollow"><code>nvidia-smi</code></a> and <a href="https://rocm.docs.amd.com/projects/rocm_smi_lib/en/latest/.doxygen/docBin/html/index.html" rel="nofollow"><code>rocm-smi</code></a> for NVIDIA and AMD GPUs respectively</li>',Ts,Ol,xs,N,bp="<li>GPU compute ability</li>",bs,Xl,Cs,Yl,Cp="The <code>CUDA_DEVICE_ORDER</code> is especially useful if your training setup consists of an older and newer GPU, where the older GPU appears first, but you cannot physically swap the cards to make the newer GPU appear first. In this case, set <code>CUDA_DEVICE_ORDER=FASTEST_FIRST</code> to always use the newer and faster GPU first (<code>nvidia-smi</code> or <code>rocm-smi</code> still reports the GPUs in their PCIe order). Or you could also set <code>export CUDA_VISIBLE_DEVICES=1,0</code>.",Us,ql,$s,ti,Ls;return M=new C({props:{title:"Efficient Training on Multiple GPUs",local:"efficient-training-on-multiple-gpus",headingTag:"h1"}}),L=new _s({props:{$$slots:{default:[Vp]},$$scope:{ctx:T}}}),W=new C({props:{title:"Scalability strategy",local:"scalability-strategy",headingTag:"h2"}}),pe=new C({props:{title:"Data Parallelism",local:"data-parallelism",headingTag:"h2"}}),he=new C({props:{title:"DataParallel vs DistributedDataParallel",local:"dataparallel-vs-distributeddataparallel",headingTag:"h3"}}),Ue=new b({props:{code:"cm0lMjAtciUyMCUyRnRtcCUyRnRlc3QtY2xtJTNCJTIwQ1VEQV9WSVNJQkxFX0RFVklDRVMlM0QwJTJDMSUyMCU1QyUwQXB5dGhvbiUyMGV4YW1wbGVzJTJGcHl0b3JjaCUyRmxhbmd1YWdlLW1vZGVsaW5nJTJGcnVuX2NsbS5weSUyMCU1QyUwQS0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjAtLWRhdGFzZXRfbmFtZSUyMHdpa2l0ZXh0JTIwLS1kYXRhc2V0X2NvbmZpZ19uYW1lJTIwd2lraXRleHQtMi1yYXctdjElMjAlNUMlMEEtLWRvX3RyYWluJTIwLS1vdXRwdXRfZGlyJTIwJTJGdG1wJTJGdGVzdC1jbG0lMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDQlMjAtLW1heF9zdGVwcyUyMDIwMCUwQSUwQSU3Qid0cmFpbl9ydW50aW1lJyUzQSUyMDExMC41OTQ4JTJDJTIwJ3RyYWluX3NhbXBsZXNfcGVyX3NlY29uZCclM0ElMjAxLjgwOCUyQyUyMCdlcG9jaCclM0ElMjAwLjY5JTdE",highlighted:`<span class="hljs-built_in">rm</span> -r /tmp/test-clm; CUDA_VISIBLE_DEVICES=0,1 \\
python examples/pytorch/language-modeling/run_clm.py \\
--model_name_or_path openai-community/gpt2 --dataset_name wikitext --dataset_config_name wikitext-2-raw-v1 \\
--do_train --output_dir /tmp/test-clm --per_device_train_batch_size 4 --max_steps 200

{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: 110.5948, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: 1.808, <span class="hljs-string">&#x27;epoch&#x27;</span>: 0.69}`,wrap:!1}}),Le=new b({props:{code:"cm0lMjAtciUyMCUyRnRtcCUyRnRlc3QtY2xtJTNCJTIwQ1VEQV9WSVNJQkxFX0RFVklDRVMlM0QwJTJDMSUyMCU1QyUwQXRvcmNocnVuJTIwLS1ucHJvY19wZXJfbm9kZSUyMDIlMjBleGFtcGxlcyUyRnB5dG9yY2glMkZsYW5ndWFnZS1tb2RlbGluZyUyRnJ1bl9jbG0ucHklMjAlNUMlMEEtLW1vZGVsX25hbWVfb3JfcGF0aCUyMG9wZW5haS1jb21tdW5pdHklMkZncHQyJTIwLS1kYXRhc2V0X25hbWUlMjB3aWtpdGV4dCUyMC0tZGF0YXNldF9jb25maWdfbmFtZSUyMHdpa2l0ZXh0LTItcmF3LXYxJTIwJTVDJTBBLS1kb190cmFpbiUyMC0tb3V0cHV0X2RpciUyMCUyRnRtcCUyRnRlc3QtY2xtJTIwLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjA0JTIwLS1tYXhfc3RlcHMlMjAyMDAlMEElMEElN0IndHJhaW5fcnVudGltZSclM0ElMjAxMDEuOTAwMyUyQyUyMCd0cmFpbl9zYW1wbGVzX3Blcl9zZWNvbmQnJTNBJTIwMS45NjMlMkMlMjAnZXBvY2gnJTNBJTIwMC42OSU3RA==",highlighted:`<span class="hljs-built_in">rm</span> -r /tmp/test-clm; CUDA_VISIBLE_DEVICES=0,1 \\
torchrun --nproc_per_node 2 examples/pytorch/language-modeling/run_clm.py \\
--model_name_or_path openai-community/gpt2 --dataset_name wikitext --dataset_config_name wikitext-2-raw-v1 \\
--do_train --output_dir /tmp/test-clm --per_device_train_batch_size 4 --max_steps 200

{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: 101.9003, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: 1.963, <span class="hljs-string">&#x27;epoch&#x27;</span>: 0.69}`,wrap:!1}}),De=new b({props:{code:"cm0lMjAtciUyMCUyRnRtcCUyRnRlc3QtY2xtJTNCJTIwTkNDTF9QMlBfRElTQUJMRSUzRDElMjBDVURBX1ZJU0lCTEVfREVWSUNFUyUzRDAlMkMxJTIwJTVDJTBBdG9yY2hydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTIwMiUyMGV4YW1wbGVzJTJGcHl0b3JjaCUyRmxhbmd1YWdlLW1vZGVsaW5nJTJGcnVuX2NsbS5weSUyMCU1QyUwQS0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjAtLWRhdGFzZXRfbmFtZSUyMHdpa2l0ZXh0JTIwLS1kYXRhc2V0X2NvbmZpZ19uYW1lJTIwd2lraXRleHQtMi1yYXctdjElMjAlNUMlMEEtLWRvX3RyYWluJTIwLS1vdXRwdXRfZGlyJTIwJTJGdG1wJTJGdGVzdC1jbG0lMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDQlMjAtLW1heF9zdGVwcyUyMDIwMCUwQSUwQSU3Qid0cmFpbl9ydW50aW1lJyUzQSUyMDEzMS40MzY3JTJDJTIwJ3RyYWluX3NhbXBsZXNfcGVyX3NlY29uZCclM0ElMjAxLjUyMiUyQyUyMCdlcG9jaCclM0ElMjAwLjY5JTdE",highlighted:`<span class="hljs-built_in">rm</span> -r /tmp/test-clm; NCCL_P2P_DISABLE=1 CUDA_VISIBLE_DEVICES=0,1 \\
torchrun --nproc_per_node 2 examples/pytorch/language-modeling/run_clm.py \\
--model_name_or_path openai-community/gpt2 --dataset_name wikitext --dataset_config_name wikitext-2-raw-v1 \\
--do_train --output_dir /tmp/test-clm --per_device_train_batch_size 4 --max_steps 200

{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: 131.4367, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: 1.522, <span class="hljs-string">&#x27;epoch&#x27;</span>: 0.69}`,wrap:!1}}),Ie=new C({props:{title:"ZeRO Data Parallelism",local:"zero-data-parallelism",headingTag:"h2"}}),Ee=new b({props:{code:"TGElMjAlN0MlMjBMYiUyMCU3QyUyMExjJTBBLS0tJTdDLS0tLSU3Qy0tLSUwQWEwJTIwJTdDJTIwYjAlMjAlN0MlMjBjMCUwQWExJTIwJTdDJTIwYjElMjAlN0MlMjBjMSUwQWEyJTIwJTdDJTIwYjIlMjAlN0MlMjBjMg==",highlighted:`La |<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a0 </span>|<span class="hljs-string"> b0 </span>|<span class="hljs-string"> c0
a1 </span>|<span class="hljs-string"> b1 </span>|<span class="hljs-string"> c1
a2 </span>|<span class="hljs-string"> b2 </span>|<span class="hljs-string"> c2</span>`,wrap:!1}}),Ae=new b({props:{code:"R1BVMCUzQSUwQUxhJTIwJTdDJTIwTGIlMjAlN0MlMjBMYyUwQS0tLSU3Qy0tLS0lN0MtLS0lMEFhMCUyMCU3QyUyMGIwJTIwJTdDJTIwYzAlMEElMEFHUFUxJTNBJTBBTGElMjAlN0MlMjBMYiUyMCU3QyUyMExjJTBBLS0tJTdDLS0tLSU3Qy0tLSUwQWExJTIwJTdDJTIwYjElMjAlN0MlMjBjMSUwQSUwQUdQVTIlM0ElMEFMYSUyMCU3QyUyMExiJTIwJTdDJTIwTGMlMEEtLS0lN0MtLS0tJTdDLS0tJTBBYTIlMjAlN0MlMjBiMiUyMCU3QyUyMGMy",highlighted:`GPU0:
La |<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a0 </span>|<span class="hljs-string"> b0 </span>|<span class="hljs-string"> c0

GPU1:
La </span>|<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a1 </span>|<span class="hljs-string"> b1 </span>|<span class="hljs-string"> c1

GPU2:
La </span>|<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a2 </span>|<span class="hljs-string"> b2 </span>|<span class="hljs-string"> c2</span>`,wrap:!1}}),ze=new b({props:{code:"eDAlMjAlM0QlM0UlMjBHUFUwJTBBeDElMjAlM0QlM0UlMjBHUFUxJTBBeDIlMjAlM0QlM0UlMjBHUFUy",highlighted:`<span class="hljs-attribute">x0</span> <span class="hljs-operator">=</span>&gt; GPU0
<span class="hljs-attribute">x1</span> <span class="hljs-operator">=</span>&gt; GPU1
<span class="hljs-attribute">x2</span> <span class="hljs-operator">=</span>&gt; GPU2`,wrap:!1}}),D=new _s({props:{$$slots:{default:[Ap]},$$scope:{ctx:T}}}),Ke=new C({props:{title:"From Naive Model Parallelism to Pipeline Parallelism",local:"from-naive-model-parallelism-to-pipeline-parallelism",headingTag:"h2"}}),lt=new b({props:{code:"JTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTBBJTdDJTIwTGF5ZXIlMjAlN0MlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMEElN0MlMjAlMjAlMjAwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTBBJTdDJTIwJTIwJTIwMSUyMCUyMCUyMCU3QyUyMEdQVTAlMjAlN0MlMEElN0MlMjAlMjAlMjAyJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTBBJTdDJTIwJTIwJTIwMyUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQSUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUwQSU3QyUyMExheWVyJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTBBJTdDJTIwJTIwJTIwNCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQSU3QyUyMCUyMCUyMDUlMjAlMjAlMjAlN0MlMjBHUFUxJTIwJTdDJTBBJTdDJTIwJTIwJTIwNiUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQSU3QyUyMCUyMCUyMDclMjAlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMEElM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0Q=",highlighted:`================
|<span class="hljs-string"> Layer </span>|<span class="hljs-string">      </span>|
|<span class="hljs-string">   0   </span>|<span class="hljs-string">      </span>|
|<span class="hljs-string">   1   </span>|<span class="hljs-string"> GPU0 </span>|
|<span class="hljs-string">   2   </span>|<span class="hljs-string">      </span>|
|<span class="hljs-string">   3   </span>|<span class="hljs-string">      </span>|
================
|<span class="hljs-string"> Layer </span>|<span class="hljs-string">      </span>|
|<span class="hljs-string">   4   </span>|<span class="hljs-string">      </span>|
|<span class="hljs-string">   5   </span>|<span class="hljs-string"> GPU1 </span>|
|<span class="hljs-string">   6   </span>|<span class="hljs-string">      </span>|
|<span class="hljs-string">   7   </span>|<span class="hljs-string">      </span>|
================`,wrap:!1}}),_t=new C({props:{title:"Tensor Parallelism",local:"tensor-parallelism",headingTag:"h2"}}),Wt=new C({props:{title:"Data Parallelism + Pipeline Parallelism",local:"data-parallelism--pipeline-parallelism",headingTag:"h2"}}),Kt=new C({props:{title:"Data Parallelism + Pipeline Parallelism + Tensor Parallelism",local:"data-parallelism--pipeline-parallelism--tensor-parallelism",headingTag:"h2"}}),sl=new C({props:{title:"ZeRO Data Parallelism + Pipeline Parallelism + Tensor Parallelism",local:"zero-data-parallelism--pipeline-parallelism--tensor-parallelism",headingTag:"h2"}}),yl=new C({props:{title:"FlexFlow",local:"flexflow",headingTag:"h2"}}),kl=new C({props:{title:"GPU selection",local:"gpu-selection",headingTag:"h2"}}),El=new C({props:{title:"Number of GPUs",local:"number-of-gpus",headingTag:"h3"}}),A=new Ep({props:{id:"select-gpu",options:["torchrun","Accelerate","DeepSpeed"],$$slots:{default:[Bp]},$$scope:{ctx:T}}}),Al=new C({props:{title:"Order of GPUs",local:"order-of-gpus",headingTag:"h3"}}),Nl=new b({props:{code:"Q1VEQV9WSVNJQkxFX0RFVklDRVMlM0QwJTJDMiUyMHRvcmNocnVuJTIwdHJhaW5lci1wcm9ncmFtLnB5JTIwLi4u",highlighted:"CUDA_VISIBLE_DEVICES=0,2 torchrun trainer-program.py ...",wrap:!1}}),Bl=new b({props:{code:"Q1VEQV9WSVNJQkxFX0RFVklDRVMlM0QyJTJDMCUyMHRvcmNocnVuJTIwdHJhaW5lci1wcm9ncmFtLnB5JTIwLi4u",highlighted:"CUDA_VISIBLE_DEVICES=2,0 torchrun trainer-program.py ...",wrap:!1}}),Wl=new b({props:{code:"Q1VEQV9WSVNJQkxFX0RFVklDRVMlM0QlMjBweXRob24lMjB0cmFpbmVyLXByb2dyYW0ucHklMjAuLi4=",highlighted:"CUDA_VISIBLE_DEVICES= python trainer-program.py ...",wrap:!1}}),R=new _s({props:{warning:!0,$$slots:{default:[Qp]},$$scope:{ctx:T}}}),Ol=new b({props:{code:"ZXhwb3J0JTIwQ1VEQV9ERVZJQ0VfT1JERVIlM0RQQ0lfQlVTX0lE",highlighted:'<span class="hljs-built_in">export</span> CUDA_DEVICE_ORDER=PCI_BUS_ID',wrap:!1}}),Xl=new b({props:{code:"ZXhwb3J0JTIwQ1VEQV9ERVZJQ0VfT1JERVIlM0RGQVNURVNUX0ZJUlNU",highlighted:'<span class="hljs-built_in">export</span> CUDA_DEVICE_ORDER=FASTEST_FIRST',wrap:!1}}),ql=new Sp({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/perf_train_gpu_many.md"}}),{c(){p=s("meta"),g=n(),f=s("p"),u=n(),d(M.$$.fragment),m=n(),h=s("p"),h.innerHTML=x,z=n(),$=s("p"),$.textContent=ei,li=n(),B=s("p"),B.innerHTML=Gs,ii=n(),d(L.$$.fragment),ni=n(),Q=s("p"),Q.textContent=Hs,ai=n(),d(W.$$.fragment),si=n(),F=s("p"),F.innerHTML=js,oi=n(),Z=s("p"),Z.innerHTML=Is,ri=n(),O=s("p"),O.textContent=Js,pi=n(),X=s("p"),X.innerHTML=ks,mi=n(),Y=s("p"),Y.textContent=Ss,hi=n(),q=s("ol"),q.innerHTML=Es,fi=n(),K=s("p"),K.innerHTML=Vs,ui=n(),ee=s("p"),ee.textContent=As,di=n(),te=s("ol"),te.innerHTML=Rs,ci=n(),le=s("p"),le.textContent=Ns,vi=n(),ie=s("p"),ie.textContent=zs,wi=n(),ne=s("p"),ne.innerHTML=Bs,yi=n(),ae=s("ol"),ae.innerHTML=Qs,Pi=n(),se=s("p"),se.innerHTML=Ws,Mi=n(),oe=s("ul"),oe.innerHTML=Fs,gi=n(),re=s("p"),re.textContent=Zs,Ti=n(),d(pe.$$.fragment),xi=n(),me=s("p"),me.innerHTML=Os,bi=n(),d(he.$$.fragment),Ci=n(),fe=s("p"),fe.textContent=Xs,Ui=n(),ue=s("p"),ue.innerHTML=Ys,$i=n(),de=s("ul"),de.innerHTML=qs,Li=n(),ce=s("p"),ce.innerHTML=Ks,_i=n(),ve=s("p"),ve.textContent=eo,Di=n(),we=s("ol"),we.innerHTML=to,Gi=n(),ye=s("p"),ye.textContent=lo,Hi=n(),Pe=s("ol"),Pe.innerHTML=io,ji=n(),Me=s("p"),Me.innerHTML=no,Ii=n(),ge=s("p"),ge.textContent=ao,Ji=n(),Te=s("ul"),Te.innerHTML=so,ki=n(),xe=s("p"),xe.innerHTML=oo,Si=n(),be=s("p"),be.textContent=ro,Ei=n(),Ce=s("p"),Ce.innerHTML=po,Vi=n(),d(Ue.$$.fragment),Ai=n(),$e=s("p"),$e.innerHTML=mo,Ri=n(),d(Le.$$.fragment),Ni=n(),_e=s("p"),_e.innerHTML=ho,zi=n(),d(De.$$.fragment),Bi=n(),Ge=s("p"),Ge.textContent=fo,Qi=n(),He=s("table"),He.innerHTML=uo,Wi=n(),je=s("p"),je.textContent=co,Fi=n(),d(Ie.$$.fragment),Zi=n(),Je=s("p"),Je.innerHTML=vo,Oi=n(),_=s("div"),_.innerHTML=wo,Xi=n(),ke=s("p"),ke.innerHTML=yo,Yi=n(),Se=s("p"),Se.textContent=Po,qi=n(),d(Ee.$$.fragment),Ki=n(),Ve=s("p"),Ve.textContent=Mo,en=n(),d(Ae.$$.fragment),tn=n(),Re=s("p"),Re.textContent=go,ln=n(),Ne=s("p"),Ne.textContent=To,nn=n(),d(ze.$$.fragment),an=n(),Be=s("p"),Be.textContent=xo,sn=n(),Qe=s("p"),Qe.innerHTML=bo,on=n(),We=s("p"),We.textContent=Co,rn=n(),Fe=s("p"),Fe.textContent=Uo,pn=n(),Ze=s("p"),Ze.textContent=$o,mn=n(),Oe=s("p"),Oe.textContent=Lo,hn=n(),d(D.$$.fragment),fn=n(),Xe=s("p"),Xe.textContent=_o,un=n(),Ye=s("p"),Ye.textContent=Do,dn=n(),qe=s("ul"),qe.innerHTML=Go,cn=n(),d(Ke.$$.fragment),vn=n(),et=s("p"),et.innerHTML=Ho,wn=n(),tt=s("p"),tt.textContent=jo,yn=n(),d(lt.$$.fragment),Pn=n(),it=s("p"),it.textContent=Io,Mn=n(),nt=s("p"),nt.textContent=Jo,gn=n(),at=s("p"),at.textContent=ko,Tn=n(),st=s("ul"),st.innerHTML=So,xn=n(),ot=s("p"),ot.textContent=Eo,bn=n(),rt=s("p"),rt.innerHTML=Vo,Cn=n(),G=s("div"),G.innerHTML=Ao,Un=n(),pt=s("p"),pt.textContent=Ro,$n=n(),mt=s("p"),mt.innerHTML=No,Ln=n(),ht=s("p"),ht.innerHTML=zo,_n=n(),ft=s("p"),ft.innerHTML=Bo,Dn=n(),ut=s("p"),ut.innerHTML=Qo,Gn=n(),dt=s("p"),dt.textContent=Wo,Hn=n(),ct=s("ul"),ct.innerHTML=Fo,jn=n(),vt=s("p"),vt.textContent=Zo,In=n(),wt=s("ul"),wt.innerHTML=Oo,Jn=n(),yt=s("p"),yt.textContent=Xo,kn=n(),Pt=s("ul"),Pt.innerHTML=Yo,Sn=n(),Mt=s("p"),Mt.textContent=qo,En=n(),gt=s("p"),gt.textContent=Ko,Vn=n(),Tt=s("ul"),Tt.innerHTML=er,An=n(),xt=s("p"),xt.innerHTML=tr,Rn=n(),bt=s("p"),bt.innerHTML=lr,Nn=n(),Ct=s("p"),Ct.textContent=ir,zn=n(),Ut=s("p"),Ut.innerHTML=nr,Bn=n(),H=s("div"),H.innerHTML=ar,Qn=n(),$t=s("p"),$t.textContent=sr,Wn=n(),Lt=s("p"),Lt.innerHTML=or,Fn=n(),d(_t.$$.fragment),Zn=n(),Dt=s("p"),Dt.innerHTML=rr,On=n(),Gt=s("p"),Gt.innerHTML=pr,Xn=n(),Ht=s("p"),Ht.textContent=mr,Yn=n(),j=s("div"),j.innerHTML=hr,qn=n(),jt=s("p"),jt.innerHTML=fr,Kn=n(),I=s("div"),I.innerHTML=ur,ea=n(),It=s("p"),It.textContent=dr,ta=n(),J=s("div"),J.innerHTML=cr,la=n(),Jt=s("p"),Jt.textContent=vr,ia=n(),k=s("div"),k.innerHTML=wr,na=n(),kt=s("p"),kt.textContent=yr,aa=n(),St=s("p"),St.innerHTML=Pr,sa=n(),Et=s("p"),Et.textContent=Mr,oa=n(),Vt=s("ul"),Vt.innerHTML=gr,ra=n(),At=s("p"),At.textContent=Tr,pa=n(),Rt=s("ul"),Rt.innerHTML=xr,ma=n(),Nt=s("p"),Nt.textContent=br,ha=n(),zt=s("p"),zt.textContent=Cr,fa=n(),Bt=s("ul"),Bt.innerHTML=Ur,ua=n(),Qt=s("p"),Qt.innerHTML=$r,da=n(),d(Wt.$$.fragment),ca=n(),Ft=s("p"),Ft.innerHTML=Lr,va=n(),S=s("div"),S.innerHTML=_r,wa=n(),Zt=s("p"),Zt.textContent=Dr,ya=n(),Ot=s("p"),Ot.textContent=Gr,Pa=n(),Xt=s("p"),Xt.textContent=Hr,Ma=n(),Yt=s("ul"),Yt.innerHTML=jr,ga=n(),qt=s("p"),qt.textContent=Ir,Ta=n(),d(Kt.$$.fragment),xa=n(),el=s("p"),el.textContent=Jr,ba=n(),E=s("div"),E.innerHTML=kr,Ca=n(),tl=s("p"),tl.innerHTML=Sr,Ua=n(),ll=s("p"),ll.textContent=Er,$a=n(),il=s("p"),il.textContent=Vr,La=n(),nl=s("ul"),nl.innerHTML=Ar,_a=n(),al=s("p"),al.textContent=Rr,Da=n(),d(sl.$$.fragment),Ga=n(),ol=s("p"),ol.innerHTML=Nr,Ha=n(),rl=s("p"),rl.textContent=zr,ja=n(),pl=s("p"),pl.textContent=Br,Ia=n(),ml=s("p"),ml.innerHTML=Qr,Ja=n(),hl=s("p"),hl.textContent=Wr,ka=n(),fl=s("p"),fl.textContent=Fr,Sa=n(),ul=s("p"),ul.textContent=Zr,Ea=n(),dl=s("ul"),dl.innerHTML=Or,Va=n(),cl=s("p"),cl.textContent=Xr,Aa=n(),vl=s("ul"),vl.innerHTML=Yr,Ra=n(),wl=s("p"),wl.textContent=qr,Na=n(),d(yl.$$.fragment),za=n(),Pl=s("p"),Pl.innerHTML=Kr,Ba=n(),Ml=s("p"),Ml.innerHTML=ep,Qa=n(),gl=s("p"),gl.textContent=tp,Wa=n(),Tl=s("ol"),Tl.innerHTML=lp,Fa=n(),xl=s("p"),xl.textContent=ip,Za=n(),bl=s("ul"),bl.innerHTML=np,Oa=n(),Cl=s("p"),Cl.textContent=ap,Xa=n(),Ul=s("ul"),Ul.innerHTML=sp,Ya=n(),$l=s("p"),$l.textContent=op,qa=n(),Ll=s("ul"),Ll.innerHTML=rp,Ka=n(),_l=s("p"),_l.textContent=pp,es=n(),Dl=s("ul"),Dl.innerHTML=mp,ts=n(),Gl=s("p"),Gl.textContent=hp,ls=n(),V=s("div"),V.innerHTML=fp,is=n(),Hl=s("p"),Hl.textContent=up,ns=n(),jl=s("p"),jl.textContent=dp,as=n(),Il=s("p"),Il.textContent=cp,ss=n(),Jl=s("p"),Jl.innerHTML=vp,os=n(),d(kl.$$.fragment),rs=n(),Sl=s("p"),Sl.innerHTML=wp,ps=n(),d(El.$$.fragment),ms=n(),Vl=s("p"),Vl.textContent=yp,hs=n(),d(A.$$.fragment),fs=n(),d(Al.$$.fragment),us=n(),Rl=s("p"),Rl.innerHTML=Pp,ds=n(),d(Nl.$$.fragment),cs=n(),zl=s("p"),zl.innerHTML=Mp,vs=n(),d(Bl.$$.fragment),ws=n(),Ql=s("p"),Ql.innerHTML=gp,ys=n(),d(Wl.$$.fragment),Ps=n(),d(R.$$.fragment),Ms=n(),Fl=s("p"),Fl.innerHTML=Tp,gs=n(),Zl=s("ol"),Zl.innerHTML=xp,Ts=n(),d(Ol.$$.fragment),xs=n(),N=s("ol"),N.innerHTML=bp,bs=n(),d(Xl.$$.fragment),Cs=n(),Yl=s("p"),Yl.innerHTML=Cp,Us=n(),d(ql.$$.fragment),$s=n(),ti=s("p"),this.h()},l(e){const t=Jp("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(l),g=a(e),f=o(e,"P",{}),Dp(f).forEach(l),u=a(e),c(M.$$.fragment,e),m=a(e),h=o(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-pmpw5m"&&(h.innerHTML=x),z=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-6u57b2"&&($.textContent=ei),li=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1fmi0j5"&&(B.innerHTML=Gs),ii=a(e),c(L.$$.fragment,e),ni=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-k4erla"&&(Q.textContent=Hs),ai=a(e),c(W.$$.fragment,e),si=a(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-vl1lph"&&(F.innerHTML=js),oi=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-exgbxp"&&(Z.innerHTML=Is),ri=a(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1ld98nk"&&(O.textContent=Js),pi=a(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-owu077"&&(X.innerHTML=ks),mi=a(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-108eswe"&&(Y.textContent=Ss),hi=a(e),q=o(e,"OL",{"data-svelte-h":!0}),r(q)!=="svelte-128zo09"&&(q.innerHTML=Es),fi=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1pjlj4x"&&(K.innerHTML=Vs),ui=a(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1vvmjdr"&&(ee.textContent=As),di=a(e),te=o(e,"OL",{"data-svelte-h":!0}),r(te)!=="svelte-1xj19ps"&&(te.innerHTML=Rs),ci=a(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-g99shh"&&(le.textContent=Ns),vi=a(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-bg5rkn"&&(ie.textContent=zs),wi=a(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1vlifqo"&&(ne.innerHTML=Bs),yi=a(e),ae=o(e,"OL",{"data-svelte-h":!0}),r(ae)!=="svelte-12kjlqq"&&(ae.innerHTML=Qs),Pi=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-ym8ubp"&&(se.innerHTML=Ws),Mi=a(e),oe=o(e,"UL",{"data-svelte-h":!0}),r(oe)!=="svelte-1dtz42n"&&(oe.innerHTML=Fs),gi=a(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-4bia72"&&(re.textContent=Zs),Ti=a(e),c(pe.$$.fragment,e),xi=a(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1017dvy"&&(me.innerHTML=Os),bi=a(e),c(he.$$.fragment,e),Ci=a(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1j6eoys"&&(fe.textContent=Xs),Ui=a(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1v8b0bi"&&(ue.innerHTML=Ys),$i=a(e),de=o(e,"UL",{"data-svelte-h":!0}),r(de)!=="svelte-ibjm0a"&&(de.innerHTML=qs),Li=a(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-2za96j"&&(ce.innerHTML=Ks),_i=a(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1e3g0sm"&&(ve.textContent=eo),Di=a(e),we=o(e,"OL",{"data-svelte-h":!0}),r(we)!=="svelte-n1bojj"&&(we.innerHTML=to),Gi=a(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1yk5hqh"&&(ye.textContent=lo),Hi=a(e),Pe=o(e,"OL",{"data-svelte-h":!0}),r(Pe)!=="svelte-1glndlp"&&(Pe.innerHTML=io),ji=a(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-tn8imq"&&(Me.innerHTML=no),Ii=a(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-196u8fm"&&(ge.textContent=ao),Ji=a(e),Te=o(e,"UL",{"data-svelte-h":!0}),r(Te)!=="svelte-1p9lena"&&(Te.innerHTML=so),ki=a(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-lyxecx"&&(xe.innerHTML=oo),Si=a(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1ccu14e"&&(be.textContent=ro),Ei=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1cuy4x"&&(Ce.innerHTML=po),Vi=a(e),c(Ue.$$.fragment,e),Ai=a(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-ady25n"&&($e.innerHTML=mo),Ri=a(e),c(Le.$$.fragment,e),Ni=a(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1bcmt3e"&&(_e.innerHTML=ho),zi=a(e),c(De.$$.fragment,e),Bi=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-ammqnu"&&(Ge.textContent=fo),Qi=a(e),He=o(e,"TABLE",{"data-svelte-h":!0}),r(He)!=="svelte-1glyygb"&&(He.innerHTML=uo),Wi=a(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-3h79hx"&&(je.textContent=co),Fi=a(e),c(Ie.$$.fragment,e),Zi=a(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-rus1tj"&&(Je.innerHTML=vo),Oi=a(e),_=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(_)!=="svelte-l6ikqh"&&(_.innerHTML=wo),Xi=a(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1n0hd1i"&&(ke.innerHTML=yo),Yi=a(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-yml45c"&&(Se.textContent=Po),qi=a(e),c(Ee.$$.fragment,e),Ki=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-ycp41i"&&(Ve.textContent=Mo),en=a(e),c(Ae.$$.fragment,e),tn=a(e),Re=o(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-vhaef9"&&(Re.textContent=go),ln=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-v79p4j"&&(Ne.textContent=To),nn=a(e),c(ze.$$.fragment,e),an=a(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1x8bz4m"&&(Be.textContent=xo),sn=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-9s70m2"&&(Qe.innerHTML=bo),on=a(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-18avb09"&&(We.textContent=Co),rn=a(e),Fe=o(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-ptnnl0"&&(Fe.textContent=Uo),pn=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1e42x7e"&&(Ze.textContent=$o),mn=a(e),Oe=o(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-1qw37a5"&&(Oe.textContent=Lo),hn=a(e),c(D.$$.fragment,e),fn=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-3x8lv3"&&(Xe.textContent=_o),un=a(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1b2mzqh"&&(Ye.textContent=Do),dn=a(e),qe=o(e,"UL",{"data-svelte-h":!0}),r(qe)!=="svelte-a0zshu"&&(qe.innerHTML=Go),cn=a(e),c(Ke.$$.fragment,e),vn=a(e),et=o(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-byke96"&&(et.innerHTML=Ho),wn=a(e),tt=o(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-kfubqe"&&(tt.textContent=jo),yn=a(e),c(lt.$$.fragment,e),Pn=a(e),it=o(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-vd21sy"&&(it.textContent=Io),Mn=a(e),nt=o(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-vjztmh"&&(nt.textContent=Jo),gn=a(e),at=o(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1l6dgyv"&&(at.textContent=ko),Tn=a(e),st=o(e,"UL",{"data-svelte-h":!0}),r(st)!=="svelte-19omdeq"&&(st.innerHTML=So),xn=a(e),ot=o(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-1yzyde0"&&(ot.textContent=Eo),bn=a(e),rt=o(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-1lu2bt6"&&(rt.innerHTML=Vo),Cn=a(e),G=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(G)!=="svelte-1zwet4"&&(G.innerHTML=Ao),Un=a(e),pt=o(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-10mywh3"&&(pt.textContent=Ro),$n=a(e),mt=o(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-qcenct"&&(mt.innerHTML=No),Ln=a(e),ht=o(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-q4rot4"&&(ht.innerHTML=zo),_n=a(e),ft=o(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-1qpt7zo"&&(ft.innerHTML=Bo),Dn=a(e),ut=o(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-1g0sf3v"&&(ut.innerHTML=Qo),Gn=a(e),dt=o(e,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-18mmroz"&&(dt.textContent=Wo),Hn=a(e),ct=o(e,"UL",{"data-svelte-h":!0}),r(ct)!=="svelte-1m54oo0"&&(ct.innerHTML=Fo),jn=a(e),vt=o(e,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-3pifdn"&&(vt.textContent=Zo),In=a(e),wt=o(e,"UL",{"data-svelte-h":!0}),r(wt)!=="svelte-p13wwf"&&(wt.innerHTML=Oo),Jn=a(e),yt=o(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-5h607a"&&(yt.textContent=Xo),kn=a(e),Pt=o(e,"UL",{"data-svelte-h":!0}),r(Pt)!=="svelte-n2xihd"&&(Pt.innerHTML=Yo),Sn=a(e),Mt=o(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-1xvp26s"&&(Mt.textContent=qo),En=a(e),gt=o(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-1b2mzqh"&&(gt.textContent=Ko),Vn=a(e),Tt=o(e,"UL",{"data-svelte-h":!0}),r(Tt)!=="svelte-1kewxhh"&&(Tt.innerHTML=er),An=a(e),xt=o(e,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-zuoye1"&&(xt.innerHTML=tr),Rn=a(e),bt=o(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-1nopw2u"&&(bt.innerHTML=lr),Nn=a(e),Ct=o(e,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-1djad0c"&&(Ct.textContent=ir),zn=a(e),Ut=o(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-vnarcr"&&(Ut.innerHTML=nr),Bn=a(e),H=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(H)!=="svelte-xyuwxq"&&(H.innerHTML=ar),Qn=a(e),$t=o(e,"P",{"data-svelte-h":!0}),r($t)!=="svelte-19x9s0e"&&($t.textContent=sr),Wn=a(e),Lt=o(e,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-1q9n35q"&&(Lt.innerHTML=or),Fn=a(e),c(_t.$$.fragment,e),Zn=a(e),Dt=o(e,"P",{"data-svelte-h":!0}),r(Dt)!=="svelte-1fj06i7"&&(Dt.innerHTML=rr),On=a(e),Gt=o(e,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-1ktbklq"&&(Gt.innerHTML=pr),Xn=a(e),Ht=o(e,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-250ai3"&&(Ht.textContent=mr),Yn=a(e),j=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-1ugxk60"&&(j.innerHTML=hr),qn=a(e),jt=o(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-s73n1q"&&(jt.innerHTML=fr),Kn=a(e),I=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(I)!=="svelte-gpv8h8"&&(I.innerHTML=ur),ea=a(e),It=o(e,"P",{"data-svelte-h":!0}),r(It)!=="svelte-1lnmjiw"&&(It.textContent=dr),ta=a(e),J=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-yslb0f"&&(J.innerHTML=cr),la=a(e),Jt=o(e,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-8jgntx"&&(Jt.textContent=vr),ia=a(e),k=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(k)!=="svelte-b5xtwy"&&(k.innerHTML=wr),na=a(e),kt=o(e,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-kplhah"&&(kt.textContent=yr),aa=a(e),St=o(e,"P",{"data-svelte-h":!0}),r(St)!=="svelte-hmoxa9"&&(St.innerHTML=Pr),sa=a(e),Et=o(e,"P",{"data-svelte-h":!0}),r(Et)!=="svelte-1ma7lah"&&(Et.textContent=Mr),oa=a(e),Vt=o(e,"UL",{"data-svelte-h":!0}),r(Vt)!=="svelte-p60tn3"&&(Vt.innerHTML=gr),ra=a(e),At=o(e,"P",{"data-svelte-h":!0}),r(At)!=="svelte-1b2mzqh"&&(At.textContent=Tr),pa=a(e),Rt=o(e,"UL",{"data-svelte-h":!0}),r(Rt)!=="svelte-sudg8s"&&(Rt.innerHTML=xr),ma=a(e),Nt=o(e,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-xqarbt"&&(Nt.textContent=br),ha=a(e),zt=o(e,"P",{"data-svelte-h":!0}),r(zt)!=="svelte-1g6ovc1"&&(zt.textContent=Cr),fa=a(e),Bt=o(e,"UL",{"data-svelte-h":!0}),r(Bt)!=="svelte-13k8bts"&&(Bt.innerHTML=Ur),ua=a(e),Qt=o(e,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-f1rs41"&&(Qt.innerHTML=$r),da=a(e),c(Wt.$$.fragment,e),ca=a(e),Ft=o(e,"P",{"data-svelte-h":!0}),r(Ft)!=="svelte-1oq9xy9"&&(Ft.innerHTML=Lr),va=a(e),S=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(S)!=="svelte-jbayi"&&(S.innerHTML=_r),wa=a(e),Zt=o(e,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-1xg3nfy"&&(Zt.textContent=Dr),ya=a(e),Ot=o(e,"P",{"data-svelte-h":!0}),r(Ot)!=="svelte-4rkar7"&&(Ot.textContent=Gr),Pa=a(e),Xt=o(e,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-1b2mzqh"&&(Xt.textContent=Hr),Ma=a(e),Yt=o(e,"UL",{"data-svelte-h":!0}),r(Yt)!=="svelte-1ry6c7"&&(Yt.innerHTML=jr),ga=a(e),qt=o(e,"P",{"data-svelte-h":!0}),r(qt)!=="svelte-9dc2gy"&&(qt.textContent=Ir),Ta=a(e),c(Kt.$$.fragment,e),xa=a(e),el=o(e,"P",{"data-svelte-h":!0}),r(el)!=="svelte-fz9fyw"&&(el.textContent=Jr),ba=a(e),E=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(E)!=="svelte-4i6t8z"&&(E.innerHTML=kr),Ca=a(e),tl=o(e,"P",{"data-svelte-h":!0}),r(tl)!=="svelte-18bvwlv"&&(tl.innerHTML=Sr),Ua=a(e),ll=o(e,"P",{"data-svelte-h":!0}),r(ll)!=="svelte-1hp29wn"&&(ll.textContent=Er),$a=a(e),il=o(e,"P",{"data-svelte-h":!0}),r(il)!=="svelte-1b2mzqh"&&(il.textContent=Vr),La=a(e),nl=o(e,"UL",{"data-svelte-h":!0}),r(nl)!=="svelte-3ic0jq"&&(nl.innerHTML=Ar),_a=a(e),al=o(e,"P",{"data-svelte-h":!0}),r(al)!=="svelte-r6xwz8"&&(al.textContent=Rr),Da=a(e),c(sl.$$.fragment,e),Ga=a(e),ol=o(e,"P",{"data-svelte-h":!0}),r(ol)!=="svelte-7uwyc9"&&(ol.innerHTML=Nr),Ha=a(e),rl=o(e,"P",{"data-svelte-h":!0}),r(rl)!=="svelte-172u2n6"&&(rl.textContent=zr),ja=a(e),pl=o(e,"P",{"data-svelte-h":!0}),r(pl)!=="svelte-mgnvai"&&(pl.textContent=Br),Ia=a(e),ml=o(e,"P",{"data-svelte-h":!0}),r(ml)!=="svelte-bdt2fr"&&(ml.innerHTML=Qr),Ja=a(e),hl=o(e,"P",{"data-svelte-h":!0}),r(hl)!=="svelte-q3kikv"&&(hl.textContent=Wr),ka=a(e),fl=o(e,"P",{"data-svelte-h":!0}),r(fl)!=="svelte-s2rtor"&&(fl.textContent=Fr),Sa=a(e),ul=o(e,"P",{"data-svelte-h":!0}),r(ul)!=="svelte-1b2mzqh"&&(ul.textContent=Zr),Ea=a(e),dl=o(e,"UL",{"data-svelte-h":!0}),r(dl)!=="svelte-o5zp0z"&&(dl.innerHTML=Or),Va=a(e),cl=o(e,"P",{"data-svelte-h":!0}),r(cl)!=="svelte-1grbiex"&&(cl.textContent=Xr),Aa=a(e),vl=o(e,"UL",{"data-svelte-h":!0}),r(vl)!=="svelte-1oyel1u"&&(vl.innerHTML=Yr),Ra=a(e),wl=o(e,"P",{"data-svelte-h":!0}),r(wl)!=="svelte-r6xwz8"&&(wl.textContent=qr),Na=a(e),c(yl.$$.fragment,e),za=a(e),Pl=o(e,"P",{"data-svelte-h":!0}),r(Pl)!=="svelte-121cfuq"&&(Pl.innerHTML=Kr),Ba=a(e),Ml=o(e,"P",{"data-svelte-h":!0}),r(Ml)!=="svelte-dou7hg"&&(Ml.innerHTML=ep),Qa=a(e),gl=o(e,"P",{"data-svelte-h":!0}),r(gl)!=="svelte-oa098n"&&(gl.textContent=tp),Wa=a(e),Tl=o(e,"OL",{"data-svelte-h":!0}),r(Tl)!=="svelte-6cxs64"&&(Tl.innerHTML=lp),Fa=a(e),xl=o(e,"P",{"data-svelte-h":!0}),r(xl)!=="svelte-kvfsh7"&&(xl.textContent=ip),Za=a(e),bl=o(e,"UL",{"data-svelte-h":!0}),r(bl)!=="svelte-1734ihx"&&(bl.innerHTML=np),Oa=a(e),Cl=o(e,"P",{"data-svelte-h":!0}),r(Cl)!=="svelte-jsce61"&&(Cl.textContent=ap),Xa=a(e),Ul=o(e,"UL",{"data-svelte-h":!0}),r(Ul)!=="svelte-ilmkvr"&&(Ul.innerHTML=sp),Ya=a(e),$l=o(e,"P",{"data-svelte-h":!0}),r($l)!=="svelte-w2gbdo"&&($l.textContent=op),qa=a(e),Ll=o(e,"UL",{"data-svelte-h":!0}),r(Ll)!=="svelte-dyjda9"&&(Ll.innerHTML=rp),Ka=a(e),_l=o(e,"P",{"data-svelte-h":!0}),r(_l)!=="svelte-1qwl5bi"&&(_l.textContent=pp),es=a(e),Dl=o(e,"UL",{"data-svelte-h":!0}),r(Dl)!=="svelte-bzftse"&&(Dl.innerHTML=mp),ts=a(e),Gl=o(e,"P",{"data-svelte-h":!0}),r(Gl)!=="svelte-pn1yl1"&&(Gl.textContent=hp),ls=a(e),V=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(V)!=="svelte-1jywqo8"&&(V.innerHTML=fp),is=a(e),Hl=o(e,"P",{"data-svelte-h":!0}),r(Hl)!=="svelte-11n85y7"&&(Hl.textContent=up),ns=a(e),jl=o(e,"P",{"data-svelte-h":!0}),r(jl)!=="svelte-13bz10s"&&(jl.textContent=dp),as=a(e),Il=o(e,"P",{"data-svelte-h":!0}),r(Il)!=="svelte-iohzxv"&&(Il.textContent=cp),ss=a(e),Jl=o(e,"P",{"data-svelte-h":!0}),r(Jl)!=="svelte-so3ryv"&&(Jl.innerHTML=vp),os=a(e),c(kl.$$.fragment,e),rs=a(e),Sl=o(e,"P",{"data-svelte-h":!0}),r(Sl)!=="svelte-18jn5v3"&&(Sl.innerHTML=wp),ps=a(e),c(El.$$.fragment,e),ms=a(e),Vl=o(e,"P",{"data-svelte-h":!0}),r(Vl)!=="svelte-1tfztmr"&&(Vl.textContent=yp),hs=a(e),c(A.$$.fragment,e),fs=a(e),c(Al.$$.fragment,e),us=a(e),Rl=o(e,"P",{"data-svelte-h":!0}),r(Rl)!=="svelte-1gq2rbv"&&(Rl.innerHTML=Pp),ds=a(e),c(Nl.$$.fragment,e),cs=a(e),zl=o(e,"P",{"data-svelte-h":!0}),r(zl)!=="svelte-1jed3my"&&(zl.innerHTML=Mp),vs=a(e),c(Bl.$$.fragment,e),ws=a(e),Ql=o(e,"P",{"data-svelte-h":!0}),r(Ql)!=="svelte-waga1j"&&(Ql.innerHTML=gp),ys=a(e),c(Wl.$$.fragment,e),Ps=a(e),c(R.$$.fragment,e),Ms=a(e),Fl=o(e,"P",{"data-svelte-h":!0}),r(Fl)!=="svelte-qvyxrz"&&(Fl.innerHTML=Tp),gs=a(e),Zl=o(e,"OL",{"data-svelte-h":!0}),r(Zl)!=="svelte-dqc5mg"&&(Zl.innerHTML=xp),Ts=a(e),c(Ol.$$.fragment,e),xs=a(e),N=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(N)!=="svelte-7l4syx"&&(N.innerHTML=bp),bs=a(e),c(Xl.$$.fragment,e),Cs=a(e),Yl=o(e,"P",{"data-svelte-h":!0}),r(Yl)!=="svelte-xdw23d"&&(Yl.innerHTML=Cp),Us=a(e),c(ql.$$.fragment,e),$s=a(e),ti=o(e,"P",{}),Dp(ti).forEach(l),this.h()},h(){U(p,"name","hf:doc:metadata"),U(p,"content",Fp),U(_,"class","flex justify-center"),U(G,"class","flex justify-center"),U(H,"class","flex justify-center"),U(j,"class","flex justify-center"),U(I,"class","flex justify-center"),U(J,"class","flex justify-center"),U(k,"class","flex justify-center"),U(S,"class","flex justify-center"),U(E,"class","flex justify-center"),U(V,"class","flex justify-center"),U(N,"start","2")},m(e,t){kp(document.head,p),i(e,g,t),i(e,f,t),i(e,u,t),v(M,e,t),i(e,m,t),i(e,h,t),i(e,z,t),i(e,$,t),i(e,li,t),i(e,B,t),i(e,ii,t),v(L,e,t),i(e,ni,t),i(e,Q,t),i(e,ai,t),v(W,e,t),i(e,si,t),i(e,F,t),i(e,oi,t),i(e,Z,t),i(e,ri,t),i(e,O,t),i(e,pi,t),i(e,X,t),i(e,mi,t),i(e,Y,t),i(e,hi,t),i(e,q,t),i(e,fi,t),i(e,K,t),i(e,ui,t),i(e,ee,t),i(e,di,t),i(e,te,t),i(e,ci,t),i(e,le,t),i(e,vi,t),i(e,ie,t),i(e,wi,t),i(e,ne,t),i(e,yi,t),i(e,ae,t),i(e,Pi,t),i(e,se,t),i(e,Mi,t),i(e,oe,t),i(e,gi,t),i(e,re,t),i(e,Ti,t),v(pe,e,t),i(e,xi,t),i(e,me,t),i(e,bi,t),v(he,e,t),i(e,Ci,t),i(e,fe,t),i(e,Ui,t),i(e,ue,t),i(e,$i,t),i(e,de,t),i(e,Li,t),i(e,ce,t),i(e,_i,t),i(e,ve,t),i(e,Di,t),i(e,we,t),i(e,Gi,t),i(e,ye,t),i(e,Hi,t),i(e,Pe,t),i(e,ji,t),i(e,Me,t),i(e,Ii,t),i(e,ge,t),i(e,Ji,t),i(e,Te,t),i(e,ki,t),i(e,xe,t),i(e,Si,t),i(e,be,t),i(e,Ei,t),i(e,Ce,t),i(e,Vi,t),v(Ue,e,t),i(e,Ai,t),i(e,$e,t),i(e,Ri,t),v(Le,e,t),i(e,Ni,t),i(e,_e,t),i(e,zi,t),v(De,e,t),i(e,Bi,t),i(e,Ge,t),i(e,Qi,t),i(e,He,t),i(e,Wi,t),i(e,je,t),i(e,Fi,t),v(Ie,e,t),i(e,Zi,t),i(e,Je,t),i(e,Oi,t),i(e,_,t),i(e,Xi,t),i(e,ke,t),i(e,Yi,t),i(e,Se,t),i(e,qi,t),v(Ee,e,t),i(e,Ki,t),i(e,Ve,t),i(e,en,t),v(Ae,e,t),i(e,tn,t),i(e,Re,t),i(e,ln,t),i(e,Ne,t),i(e,nn,t),v(ze,e,t),i(e,an,t),i(e,Be,t),i(e,sn,t),i(e,Qe,t),i(e,on,t),i(e,We,t),i(e,rn,t),i(e,Fe,t),i(e,pn,t),i(e,Ze,t),i(e,mn,t),i(e,Oe,t),i(e,hn,t),v(D,e,t),i(e,fn,t),i(e,Xe,t),i(e,un,t),i(e,Ye,t),i(e,dn,t),i(e,qe,t),i(e,cn,t),v(Ke,e,t),i(e,vn,t),i(e,et,t),i(e,wn,t),i(e,tt,t),i(e,yn,t),v(lt,e,t),i(e,Pn,t),i(e,it,t),i(e,Mn,t),i(e,nt,t),i(e,gn,t),i(e,at,t),i(e,Tn,t),i(e,st,t),i(e,xn,t),i(e,ot,t),i(e,bn,t),i(e,rt,t),i(e,Cn,t),i(e,G,t),i(e,Un,t),i(e,pt,t),i(e,$n,t),i(e,mt,t),i(e,Ln,t),i(e,ht,t),i(e,_n,t),i(e,ft,t),i(e,Dn,t),i(e,ut,t),i(e,Gn,t),i(e,dt,t),i(e,Hn,t),i(e,ct,t),i(e,jn,t),i(e,vt,t),i(e,In,t),i(e,wt,t),i(e,Jn,t),i(e,yt,t),i(e,kn,t),i(e,Pt,t),i(e,Sn,t),i(e,Mt,t),i(e,En,t),i(e,gt,t),i(e,Vn,t),i(e,Tt,t),i(e,An,t),i(e,xt,t),i(e,Rn,t),i(e,bt,t),i(e,Nn,t),i(e,Ct,t),i(e,zn,t),i(e,Ut,t),i(e,Bn,t),i(e,H,t),i(e,Qn,t),i(e,$t,t),i(e,Wn,t),i(e,Lt,t),i(e,Fn,t),v(_t,e,t),i(e,Zn,t),i(e,Dt,t),i(e,On,t),i(e,Gt,t),i(e,Xn,t),i(e,Ht,t),i(e,Yn,t),i(e,j,t),i(e,qn,t),i(e,jt,t),i(e,Kn,t),i(e,I,t),i(e,ea,t),i(e,It,t),i(e,ta,t),i(e,J,t),i(e,la,t),i(e,Jt,t),i(e,ia,t),i(e,k,t),i(e,na,t),i(e,kt,t),i(e,aa,t),i(e,St,t),i(e,sa,t),i(e,Et,t),i(e,oa,t),i(e,Vt,t),i(e,ra,t),i(e,At,t),i(e,pa,t),i(e,Rt,t),i(e,ma,t),i(e,Nt,t),i(e,ha,t),i(e,zt,t),i(e,fa,t),i(e,Bt,t),i(e,ua,t),i(e,Qt,t),i(e,da,t),v(Wt,e,t),i(e,ca,t),i(e,Ft,t),i(e,va,t),i(e,S,t),i(e,wa,t),i(e,Zt,t),i(e,ya,t),i(e,Ot,t),i(e,Pa,t),i(e,Xt,t),i(e,Ma,t),i(e,Yt,t),i(e,ga,t),i(e,qt,t),i(e,Ta,t),v(Kt,e,t),i(e,xa,t),i(e,el,t),i(e,ba,t),i(e,E,t),i(e,Ca,t),i(e,tl,t),i(e,Ua,t),i(e,ll,t),i(e,$a,t),i(e,il,t),i(e,La,t),i(e,nl,t),i(e,_a,t),i(e,al,t),i(e,Da,t),v(sl,e,t),i(e,Ga,t),i(e,ol,t),i(e,Ha,t),i(e,rl,t),i(e,ja,t),i(e,pl,t),i(e,Ia,t),i(e,ml,t),i(e,Ja,t),i(e,hl,t),i(e,ka,t),i(e,fl,t),i(e,Sa,t),i(e,ul,t),i(e,Ea,t),i(e,dl,t),i(e,Va,t),i(e,cl,t),i(e,Aa,t),i(e,vl,t),i(e,Ra,t),i(e,wl,t),i(e,Na,t),v(yl,e,t),i(e,za,t),i(e,Pl,t),i(e,Ba,t),i(e,Ml,t),i(e,Qa,t),i(e,gl,t),i(e,Wa,t),i(e,Tl,t),i(e,Fa,t),i(e,xl,t),i(e,Za,t),i(e,bl,t),i(e,Oa,t),i(e,Cl,t),i(e,Xa,t),i(e,Ul,t),i(e,Ya,t),i(e,$l,t),i(e,qa,t),i(e,Ll,t),i(e,Ka,t),i(e,_l,t),i(e,es,t),i(e,Dl,t),i(e,ts,t),i(e,Gl,t),i(e,ls,t),i(e,V,t),i(e,is,t),i(e,Hl,t),i(e,ns,t),i(e,jl,t),i(e,as,t),i(e,Il,t),i(e,ss,t),i(e,Jl,t),i(e,os,t),v(kl,e,t),i(e,rs,t),i(e,Sl,t),i(e,ps,t),v(El,e,t),i(e,ms,t),i(e,Vl,t),i(e,hs,t),v(A,e,t),i(e,fs,t),v(Al,e,t),i(e,us,t),i(e,Rl,t),i(e,ds,t),v(Nl,e,t),i(e,cs,t),i(e,zl,t),i(e,vs,t),v(Bl,e,t),i(e,ws,t),i(e,Ql,t),i(e,ys,t),v(Wl,e,t),i(e,Ps,t),v(R,e,t),i(e,Ms,t),i(e,Fl,t),i(e,gs,t),i(e,Zl,t),i(e,Ts,t),v(Ol,e,t),i(e,xs,t),i(e,N,t),i(e,bs,t),v(Xl,e,t),i(e,Cs,t),i(e,Yl,t),i(e,Us,t),v(ql,e,t),i(e,$s,t),i(e,ti,t),Ls=!0},p(e,[t]){const Up={};t&2&&(Up.$$scope={dirty:t,ctx:e}),L.$set(Up);const $p={};t&2&&($p.$$scope={dirty:t,ctx:e}),D.$set($p);const Lp={};t&2&&(Lp.$$scope={dirty:t,ctx:e}),A.$set(Lp);const _p={};t&2&&(_p.$$scope={dirty:t,ctx:e}),R.$set(_p)},i(e){Ls||(w(M.$$.fragment,e),w(L.$$.fragment,e),w(W.$$.fragment,e),w(pe.$$.fragment,e),w(he.$$.fragment,e),w(Ue.$$.fragment,e),w(Le.$$.fragment,e),w(De.$$.fragment,e),w(Ie.$$.fragment,e),w(Ee.$$.fragment,e),w(Ae.$$.fragment,e),w(ze.$$.fragment,e),w(D.$$.fragment,e),w(Ke.$$.fragment,e),w(lt.$$.fragment,e),w(_t.$$.fragment,e),w(Wt.$$.fragment,e),w(Kt.$$.fragment,e),w(sl.$$.fragment,e),w(yl.$$.fragment,e),w(kl.$$.fragment,e),w(El.$$.fragment,e),w(A.$$.fragment,e),w(Al.$$.fragment,e),w(Nl.$$.fragment,e),w(Bl.$$.fragment,e),w(Wl.$$.fragment,e),w(R.$$.fragment,e),w(Ol.$$.fragment,e),w(Xl.$$.fragment,e),w(ql.$$.fragment,e),Ls=!0)},o(e){y(M.$$.fragment,e),y(L.$$.fragment,e),y(W.$$.fragment,e),y(pe.$$.fragment,e),y(he.$$.fragment,e),y(Ue.$$.fragment,e),y(Le.$$.fragment,e),y(De.$$.fragment,e),y(Ie.$$.fragment,e),y(Ee.$$.fragment,e),y(Ae.$$.fragment,e),y(ze.$$.fragment,e),y(D.$$.fragment,e),y(Ke.$$.fragment,e),y(lt.$$.fragment,e),y(_t.$$.fragment,e),y(Wt.$$.fragment,e),y(Kt.$$.fragment,e),y(sl.$$.fragment,e),y(yl.$$.fragment,e),y(kl.$$.fragment,e),y(El.$$.fragment,e),y(A.$$.fragment,e),y(Al.$$.fragment,e),y(Nl.$$.fragment,e),y(Bl.$$.fragment,e),y(Wl.$$.fragment,e),y(R.$$.fragment,e),y(Ol.$$.fragment,e),y(Xl.$$.fragment,e),y(ql.$$.fragment,e),Ls=!1},d(e){e&&(l(g),l(f),l(u),l(m),l(h),l(z),l($),l(li),l(B),l(ii),l(ni),l(Q),l(ai),l(si),l(F),l(oi),l(Z),l(ri),l(O),l(pi),l(X),l(mi),l(Y),l(hi),l(q),l(fi),l(K),l(ui),l(ee),l(di),l(te),l(ci),l(le),l(vi),l(ie),l(wi),l(ne),l(yi),l(ae),l(Pi),l(se),l(Mi),l(oe),l(gi),l(re),l(Ti),l(xi),l(me),l(bi),l(Ci),l(fe),l(Ui),l(ue),l($i),l(de),l(Li),l(ce),l(_i),l(ve),l(Di),l(we),l(Gi),l(ye),l(Hi),l(Pe),l(ji),l(Me),l(Ii),l(ge),l(Ji),l(Te),l(ki),l(xe),l(Si),l(be),l(Ei),l(Ce),l(Vi),l(Ai),l($e),l(Ri),l(Ni),l(_e),l(zi),l(Bi),l(Ge),l(Qi),l(He),l(Wi),l(je),l(Fi),l(Zi),l(Je),l(Oi),l(_),l(Xi),l(ke),l(Yi),l(Se),l(qi),l(Ki),l(Ve),l(en),l(tn),l(Re),l(ln),l(Ne),l(nn),l(an),l(Be),l(sn),l(Qe),l(on),l(We),l(rn),l(Fe),l(pn),l(Ze),l(mn),l(Oe),l(hn),l(fn),l(Xe),l(un),l(Ye),l(dn),l(qe),l(cn),l(vn),l(et),l(wn),l(tt),l(yn),l(Pn),l(it),l(Mn),l(nt),l(gn),l(at),l(Tn),l(st),l(xn),l(ot),l(bn),l(rt),l(Cn),l(G),l(Un),l(pt),l($n),l(mt),l(Ln),l(ht),l(_n),l(ft),l(Dn),l(ut),l(Gn),l(dt),l(Hn),l(ct),l(jn),l(vt),l(In),l(wt),l(Jn),l(yt),l(kn),l(Pt),l(Sn),l(Mt),l(En),l(gt),l(Vn),l(Tt),l(An),l(xt),l(Rn),l(bt),l(Nn),l(Ct),l(zn),l(Ut),l(Bn),l(H),l(Qn),l($t),l(Wn),l(Lt),l(Fn),l(Zn),l(Dt),l(On),l(Gt),l(Xn),l(Ht),l(Yn),l(j),l(qn),l(jt),l(Kn),l(I),l(ea),l(It),l(ta),l(J),l(la),l(Jt),l(ia),l(k),l(na),l(kt),l(aa),l(St),l(sa),l(Et),l(oa),l(Vt),l(ra),l(At),l(pa),l(Rt),l(ma),l(Nt),l(ha),l(zt),l(fa),l(Bt),l(ua),l(Qt),l(da),l(ca),l(Ft),l(va),l(S),l(wa),l(Zt),l(ya),l(Ot),l(Pa),l(Xt),l(Ma),l(Yt),l(ga),l(qt),l(Ta),l(xa),l(el),l(ba),l(E),l(Ca),l(tl),l(Ua),l(ll),l($a),l(il),l(La),l(nl),l(_a),l(al),l(Da),l(Ga),l(ol),l(Ha),l(rl),l(ja),l(pl),l(Ia),l(ml),l(Ja),l(hl),l(ka),l(fl),l(Sa),l(ul),l(Ea),l(dl),l(Va),l(cl),l(Aa),l(vl),l(Ra),l(wl),l(Na),l(za),l(Pl),l(Ba),l(Ml),l(Qa),l(gl),l(Wa),l(Tl),l(Fa),l(xl),l(Za),l(bl),l(Oa),l(Cl),l(Xa),l(Ul),l(Ya),l($l),l(qa),l(Ll),l(Ka),l(_l),l(es),l(Dl),l(ts),l(Gl),l(ls),l(V),l(is),l(Hl),l(ns),l(jl),l(as),l(Il),l(ss),l(Jl),l(os),l(rs),l(Sl),l(ps),l(ms),l(Vl),l(hs),l(fs),l(us),l(Rl),l(ds),l(cs),l(zl),l(vs),l(ws),l(Ql),l(ys),l(Ps),l(Ms),l(Fl),l(gs),l(Zl),l(Ts),l(xs),l(N),l(bs),l(Cs),l(Yl),l(Us),l($s),l(ti)),l(p),P(M,e),P(L,e),P(W,e),P(pe,e),P(he,e),P(Ue,e),P(Le,e),P(De,e),P(Ie,e),P(Ee,e),P(Ae,e),P(ze,e),P(D,e),P(Ke,e),P(lt,e),P(_t,e),P(Wt,e),P(Kt,e),P(sl,e),P(yl,e),P(kl,e),P(El,e),P(A,e),P(Al,e),P(Nl,e),P(Bl,e),P(Wl,e),P(R,e),P(Ol,e),P(Xl,e),P(ql,e)}}}const Fp='{"title":"Efficient Training on Multiple GPUs","local":"efficient-training-on-multiple-gpus","sections":[{"title":"Scalability strategy","local":"scalability-strategy","sections":[],"depth":2},{"title":"Data Parallelism","local":"data-parallelism","sections":[{"title":"DataParallel vs DistributedDataParallel","local":"dataparallel-vs-distributeddataparallel","sections":[],"depth":3}],"depth":2},{"title":"ZeRO Data Parallelism","local":"zero-data-parallelism","sections":[],"depth":2},{"title":"From Naive Model Parallelism to Pipeline Parallelism","local":"from-naive-model-parallelism-to-pipeline-parallelism","sections":[],"depth":2},{"title":"Tensor Parallelism","local":"tensor-parallelism","sections":[],"depth":2},{"title":"Data Parallelism + Pipeline Parallelism","local":"data-parallelism--pipeline-parallelism","sections":[],"depth":2},{"title":"Data Parallelism + Pipeline Parallelism + Tensor Parallelism","local":"data-parallelism--pipeline-parallelism--tensor-parallelism","sections":[],"depth":2},{"title":"ZeRO Data Parallelism + Pipeline Parallelism + Tensor Parallelism","local":"zero-data-parallelism--pipeline-parallelism--tensor-parallelism","sections":[],"depth":2},{"title":"FlexFlow","local":"flexflow","sections":[],"depth":2},{"title":"GPU selection","local":"gpu-selection","sections":[{"title":"Number of GPUs","local":"number-of-gpus","sections":[],"depth":3},{"title":"Order of GPUs","local":"order-of-gpus","sections":[],"depth":3}],"depth":2}],"depth":1}';function Zp(T){return Hp(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class tm extends jp{constructor(p){super(),Ip(this,p,Zp,Wp,Gp,{})}}export{tm as component};
