import{s as jt,o as vt,n as Tt}from"../chunks/scheduler.c57aa7ef.js";import{S as Zt,i as Ct,g as d,s as o,r as k,A as Ut,h as i,f as a,c as l,j as O,u as B,x as f,k as tt,y as m,a as s,v as R,d as x,t as F,w as $}from"../chunks/index.394f8801.js";import{D as bt}from"../chunks/Docstring.46378b0f.js";import{C as yt}from"../chunks/CodeBlock.5228ed01.js";import{E as Jt}from"../chunks/ExampleCodeBlock.0b82ce53.js";import{H as kt,E as Bt}from"../chunks/EditOnGithub.157fddbf.js";function Rt(A){let p,y="Example:",g,w,u;return w=new yt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMFBlZnRNb2RlbCUwQWZyb20lMjBwZWZ0LnV0aWxzLmhvdHN3YXAlMjBpbXBvcnQlMjBob3Rzd2FwX2FkYXB0ZXIlMEElMEFtb2RlbF9pZCUyMCUzRCUyMC4uLiUwQWlucHV0cyUyMCUzRCUyMC4uLiUwQWRldmljZSUyMCUzRCUyMC4uLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKS50byhkZXZpY2UpJTBBJTBBJTIzJTIwbG9hZCUyMGxvcmElMjAwJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKG1vZGVsJTJDJTIwJTIycGF0aC1hZGFwdGVyLTAlMjIpJTBBbW9kZWwlMjAlM0QlMjB0b3JjaC5jb21waWxlKG1vZGVsKSUyMCUyMCUyMyUyMG9wdGlvbmFsbHklMjBjb21waWxlJTIwdGhlJTIwbW9kZWwlMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dF9hZGFwdGVyXzAlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTBBJTIzJTIwcmVwbGFjZSUyMHRoZSUyMCUyMmRlZmF1bHQlMjIlMjBsb3JhJTIwYWRhcHRlciUyMHdpdGglMjB0aGUlMjBuZXclMjBvbmUlMEFob3Rzd2FwX2FkYXB0ZXIobW9kZWwlMkMlMjAlMjJwYXRoLWFkYXB0ZXItMSUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmRlZmF1bHQlMjIlMkMlMjB0b3JjaF9kZXZpY2UlM0RkZXZpY2UpJTBBd2l0aCUyMHRvcmNoLmluZmVyZW5jZV9tb2RlKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRfYWRhcHRlcl8xJTIwJTNEJTIwbW9kZWwoaW5wdXRzKS5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> peft.utils.hotswap <span class="hljs-keyword">import</span> hotswap_adapter

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = ...
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = ...
<span class="hljs-meta">&gt;&gt;&gt; </span>device = ...
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(model_id).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load lora 0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PeftModel.from_pretrained(model, <span class="hljs-string">&quot;path-adapter-0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = torch.<span class="hljs-built_in">compile</span>(model)  <span class="hljs-comment"># optionally compile the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    output_adapter_0 = model(inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># replace the &quot;default&quot; lora adapter with the new one</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hotswap_adapter(model, <span class="hljs-string">&quot;path-adapter-1&quot;</span>, adapter_name=<span class="hljs-string">&quot;default&quot;</span>, torch_device=device)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    output_adapter_1 = model(inputs).logits`,wrap:!1}}),{c(){p=d("p"),p.textContent=y,g=o(),k(w.$$.fragment)},l(n){p=i(n,"P",{"data-svelte-h":!0}),f(p)!=="svelte-11lpom8"&&(p.textContent=y),g=l(n),B(w.$$.fragment,n)},m(n,M){s(n,p,M),s(n,g,M),R(w,n,M),u=!0},p:Tt,i(n){u||(x(w.$$.fragment,n),u=!0)},o(n){F(w.$$.fragment,n),u=!1},d(n){n&&(a(p),a(g)),$(w,n)}}}function xt(A){let p,y,g,w,u,n,M,dt="The idea of hotswapping an adapter is the following: We can already load multiple adapters, e.g. two LoRAs, at the same time. But sometimes, we want to load one LoRA and then replace its weights in-place with the LoRA weights of another adapter. This is now possible the <code>hotswap_adapter</code> function.",Q,j,it="In general, this should be faster than deleting one adapter and loading the adapter in its place, which would be the how to achieve the same final outcome without hotswapping. Another advantage of hotswapping is that it prevents re-compilation in case the PEFT model is already compiled using <code>torch.compile</code>. This can save quite a lot of time.",z,v,S,T,mt="Hotswapping works with transformers models and diffusers models. However, there are some caveats:",P,Z,ct="<li>It only works for the same PEFT method, so no swapping LoRA and LoHa, for example.</li> <li>Right now, only LoRA is properly supported.</li> <li>The adapters must be compatible (e.g. same LoRA alpha, same target modules).</li> <li>If you use <code>torch.compile</code> and want to avoid recompilation, the LoRA rank must be the same.</li>",Y,r,C,et,G,ht="Substitute old adapter data with new adapter data, keeping the rest the same.",at,W,wt="As of now, only LoRA is supported.",st,X,ut=`This function is useful when you want to replace the loaded adapter with a new adapter. The adapter name will
remain the same, but the weights and other parameters will be swapped out.`,ot,I,ft=`If the adapters are incomptabile, e.g. targeting different layers or having different alpha values, an error will
be raised.`,lt,_,q,h,U,nt,E,Mt="Swap out the adapter weights from the model with the weights from state_dict.",pt,V,gt="As of now, only LoRA is supported.",rt,H,_t=`This is a low-level function that assumes that the adapters have been checked for compatibility and that the
state_dict has been correctly mapped to work with PEFT. For a high level function that performs this work for you,
use <code>hotswap_adapter</code> instead.`,N,J,K,L,D;return u=new kt({props:{title:"Hotswapping adapters",local:"peft.utils.hotswap.hotswap_adapter",headingTag:"h1"}}),v=new yt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMFBlZnRNb2RlbCUwQWZyb20lMjBwZWZ0LnV0aWxzLmhvdHN3YXAlMjBpbXBvcnQlMjBob3Rzd2FwX2FkYXB0ZXIlMEElMEFtb2RlbF9pZCUyMCUzRCUyMC4uLiUwQWlucHV0cyUyMCUzRCUyMC4uLiUwQWRldmljZSUyMCUzRCUyMC4uLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKS50byhkZXZpY2UpJTBBJTBBJTIzJTIwbG9hZCUyMGxvcmElMjAwJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKG1vZGVsJTJDJTIwJTNDcGF0aC1hZGFwdGVyLTAlM0UpJTBBbW9kZWwlMjAlM0QlMjB0b3JjaC5jb21waWxlKG1vZGVsKSUyMCUyMCUyMyUyMG9wdGlvbmFsbHklMjBjb21waWxlJTIwdGhlJTIwbW9kZWwlMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dF9hZGFwdGVyXzAlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTBBJTIzJTIwcmVwbGFjZSUyMHRoZSUyMCUyMmRlZmF1bHQlMjIlMjBsb3JhJTIwYWRhcHRlciUyMHdpdGglMjB0aGUlMjBuZXclMjBvbmUlMEFob3Rzd2FwX2FkYXB0ZXIobW9kZWwlMkMlMjAlM0NwYXRoLWFkYXB0ZXItMSUzRSUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmRlZmF1bHQlMjIlMkMlMjB0b3JjaF9kZXZpY2UlM0RkZXZpY2UpJTBBd2l0aCUyMHRvcmNoLmluZmVyZW5jZV9tb2RlKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRfYWRhcHRlcl8xJTIwJTNEJTIwbW9kZWwoaW5wdXRzKS5sb2dpdHM=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel
<span class="hljs-keyword">from</span> peft.utils.hotswap <span class="hljs-keyword">import</span> hotswap_adapter

model_id = ...
inputs = ...
device = ...
model = AutoModelForCausalLM.from_pretrained(model_id).to(device)

<span class="hljs-comment"># load lora 0</span>
model = PeftModel.from_pretrained(model, &lt;path-adapter-<span class="hljs-number">0</span>&gt;)
model = torch.<span class="hljs-built_in">compile</span>(model)  <span class="hljs-comment"># optionally compile the model</span>
<span class="hljs-keyword">with</span> torch.inference_mode():
    output_adapter_0 = model(inputs)

<span class="hljs-comment"># replace the &quot;default&quot; lora adapter with the new one</span>
hotswap_adapter(model, &lt;path-adapter-<span class="hljs-number">1</span>&gt;, adapter_name=<span class="hljs-string">&quot;default&quot;</span>, torch_device=device)
<span class="hljs-keyword">with</span> torch.inference_mode():
    output_adapter_1 = model(inputs).logits`,wrap:!1}}),C=new bt({props:{name:"peft.utils.hotswap.hotswap_adapter",anchor:"peft.utils.hotswap.hotswap_adapter",parameters:[{name:"model",val:""},{name:"model_name_or_path",val:""},{name:"adapter_name",val:""},{name:"torch_device",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"peft.utils.hotswap.hotswap_adapter.model",description:`<strong>model</strong> (<a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">~PeftModel</a>) &#x2014;
The PEFT model with the loaded adapter.`,name:"model"},{anchor:"peft.utils.hotswap.hotswap_adapter.model_name_or_path",description:`<strong>model_name_or_path</strong> (<code>str</code>) &#x2014;
The name or path of the model to load the new adapter from.`,name:"model_name_or_path"},{anchor:"peft.utils.hotswap.hotswap_adapter.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>) &#x2014;
The name of the adapter to swap, e.g. <code>&quot;default&quot;</code>. The name will stay the same after swapping.`,name:"adapter_name"},{anchor:"peft.utils.hotswap.hotswap_adapter.torch_device",description:`<strong>torch_device</strong> &#x2014; (<code>str</code>, <em>optional</em>, defaults to None):
The device to load the new adapter onto.`,name:"torch_device"},{anchor:"peft.utils.hotswap.hotswap_adapter.*kwargs",description:`*<strong>*kwargs</strong> (<code>optional</code>) &#x2014;
Additional keyword arguments used for loading the config and weights.`,name:"*kwargs"}],source:"https://github.com/huggingface/peft/blob/main/src/peft/utils/hotswap.py#L139"}}),_=new Jt({props:{anchor:"peft.utils.hotswap.hotswap_adapter.example",$$slots:{default:[Rt]},$$scope:{ctx:A}}}),U=new bt({props:{name:"peft.utils.hotswap.hotswap_adapter_from_state_dict",anchor:"peft.utils.hotswap.hotswap_adapter_from_state_dict",parameters:[{name:"model",val:""},{name:"state_dict",val:""},{name:"adapter_name",val:""},{name:"parameter_prefix",val:" = 'lora_'"}],parametersDescription:[{anchor:"peft.utils.hotswap.hotswap_adapter_from_state_dict.model",description:`<strong>model</strong> (<code>nn.Module</code>) &#x2014;
The model with the loaded adapter.`,name:"model"},{anchor:"peft.utils.hotswap.hotswap_adapter_from_state_dict.state_dict",description:`<strong>state_dict</strong> (<code>dict[str, torch.Tensor]</code>) &#x2014;
The state dict of the new adapter, which needs to be compatible (targeting same modules etc.).`,name:"state_dict"},{anchor:"peft.utils.hotswap.hotswap_adapter_from_state_dict.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>) &#x2014;
The name of the adapter that should be hot-swapped, e.g. <code>&quot;default&quot;</code>. The name will remain the same after
swapping.`,name:"adapter_name"},{anchor:"peft.utils.hotswap.hotswap_adapter_from_state_dict.parameter_prefix",description:`<strong>parameter_prefix</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;lora_&quot;</code>) &#x2014;
The prefix used to identify the adapter&#x2019;s keys in the state dict. For LoRA, this would be <code>&quot;lora_&quot;</code> (the
default).`,name:"parameter_prefix"}],source:"https://github.com/huggingface/peft/blob/main/src/peft/utils/hotswap.py#L33",raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>RuntimeError</code> —
If the old and the new adapter are not compatible, a RuntimeError is raised.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>RuntimeError</code></p>
`}}),J=new Bt({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/package_reference/hotswap.md"}}),{c(){p=d("meta"),y=o(),g=d("p"),w=o(),k(u.$$.fragment),n=o(),M=d("p"),M.innerHTML=dt,Q=o(),j=d("p"),j.innerHTML=it,z=o(),k(v.$$.fragment),S=o(),T=d("p"),T.textContent=mt,P=o(),Z=d("ul"),Z.innerHTML=ct,Y=o(),r=d("div"),k(C.$$.fragment),et=o(),G=d("p"),G.textContent=ht,at=o(),W=d("p"),W.textContent=wt,st=o(),X=d("p"),X.textContent=ut,ot=o(),I=d("p"),I.textContent=ft,lt=o(),k(_.$$.fragment),q=o(),h=d("div"),k(U.$$.fragment),nt=o(),E=d("p"),E.textContent=Mt,pt=o(),V=d("p"),V.textContent=gt,rt=o(),H=d("p"),H.innerHTML=_t,N=o(),k(J.$$.fragment),K=o(),L=d("p"),this.h()},l(t){const e=Ut("svelte-u9bgzb",document.head);p=i(e,"META",{name:!0,content:!0}),e.forEach(a),y=l(t),g=i(t,"P",{}),O(g).forEach(a),w=l(t),B(u.$$.fragment,t),n=l(t),M=i(t,"P",{"data-svelte-h":!0}),f(M)!=="svelte-1r4koev"&&(M.innerHTML=dt),Q=l(t),j=i(t,"P",{"data-svelte-h":!0}),f(j)!=="svelte-2f3tnn"&&(j.innerHTML=it),z=l(t),B(v.$$.fragment,t),S=l(t),T=i(t,"P",{"data-svelte-h":!0}),f(T)!=="svelte-1904uk3"&&(T.textContent=mt),P=l(t),Z=i(t,"UL",{"data-svelte-h":!0}),f(Z)!=="svelte-jiynsg"&&(Z.innerHTML=ct),Y=l(t),r=i(t,"DIV",{class:!0});var c=O(r);B(C.$$.fragment,c),et=l(c),G=i(c,"P",{"data-svelte-h":!0}),f(G)!=="svelte-9ihruw"&&(G.textContent=ht),at=l(c),W=i(c,"P",{"data-svelte-h":!0}),f(W)!=="svelte-10f33xj"&&(W.textContent=wt),st=l(c),X=i(c,"P",{"data-svelte-h":!0}),f(X)!=="svelte-rl33pg"&&(X.textContent=ut),ot=l(c),I=i(c,"P",{"data-svelte-h":!0}),f(I)!=="svelte-1e6bpeq"&&(I.textContent=ft),lt=l(c),B(_.$$.fragment,c),c.forEach(a),q=l(t),h=i(t,"DIV",{class:!0});var b=O(h);B(U.$$.fragment,b),nt=l(b),E=i(b,"P",{"data-svelte-h":!0}),f(E)!=="svelte-1sueth6"&&(E.textContent=Mt),pt=l(b),V=i(b,"P",{"data-svelte-h":!0}),f(V)!=="svelte-10f33xj"&&(V.textContent=gt),rt=l(b),H=i(b,"P",{"data-svelte-h":!0}),f(H)!=="svelte-1dqtnq6"&&(H.innerHTML=_t),b.forEach(a),N=l(t),B(J.$$.fragment,t),K=l(t),L=i(t,"P",{}),O(L).forEach(a),this.h()},h(){tt(p,"name","hf:doc:metadata"),tt(p,"content",Ft),tt(r,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),tt(h,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,e){m(document.head,p),s(t,y,e),s(t,g,e),s(t,w,e),R(u,t,e),s(t,n,e),s(t,M,e),s(t,Q,e),s(t,j,e),s(t,z,e),R(v,t,e),s(t,S,e),s(t,T,e),s(t,P,e),s(t,Z,e),s(t,Y,e),s(t,r,e),R(C,r,null),m(r,et),m(r,G),m(r,at),m(r,W),m(r,st),m(r,X),m(r,ot),m(r,I),m(r,lt),R(_,r,null),s(t,q,e),s(t,h,e),R(U,h,null),m(h,nt),m(h,E),m(h,pt),m(h,V),m(h,rt),m(h,H),s(t,N,e),R(J,t,e),s(t,K,e),s(t,L,e),D=!0},p(t,[e]){const c={};e&2&&(c.$$scope={dirty:e,ctx:t}),_.$set(c)},i(t){D||(x(u.$$.fragment,t),x(v.$$.fragment,t),x(C.$$.fragment,t),x(_.$$.fragment,t),x(U.$$.fragment,t),x(J.$$.fragment,t),D=!0)},o(t){F(u.$$.fragment,t),F(v.$$.fragment,t),F(C.$$.fragment,t),F(_.$$.fragment,t),F(U.$$.fragment,t),F(J.$$.fragment,t),D=!1},d(t){t&&(a(y),a(g),a(w),a(n),a(M),a(Q),a(j),a(z),a(S),a(T),a(P),a(Z),a(Y),a(r),a(q),a(h),a(N),a(K),a(L)),a(p),$(u,t),$(v,t),$(C),$(_),$(U),$(J,t)}}}const Ft='{"title":"Hotswapping adapters","local":"peft.utils.hotswap.hotswap_adapter","sections":[],"depth":1}';function $t(A){return vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ht extends Zt{constructor(p){super(),Ct(this,p,$t,xt,jt,{})}}export{Ht as component};
