import{s as wl,f as ye,n as yl,o as bl}from"../chunks/scheduler.37c15a92.js";import{S as vl,i as Tl,g as a,s,r as c,A as Ul,h as i,f as l,c as o,j as fl,u as h,x as r,k as p,y as jl,a as n,v as d,d as m,t as u,w as M}from"../chunks/index.7cb9c9b8.js";import{C as Gt}from"../chunks/CodeBlock.a6d3f852.js";import{H as f}from"../chunks/Heading.d3928e2a.js";function Jl(xt){let g,Te,be,Ue,w,je,y,_t='<a href="https://github.com/edbeeching/godot_rl_agents" rel="nofollow">Godot RL Agents</a> is an Open Source package that allows video game creators, AI researchers, and hobbyists the opportunity <strong>to learn complex behaviors for their Non Player Characters or agents</strong>.',Je,b,Ct="The library provides:",Ge,v,Zt='<li>An interface between games created in the <a href="https://godotengine.org/" rel="nofollow">Godot Engine</a> and Machine Learning algorithms running in Python</li> <li>Wrappers for four well known rl frameworks: <a href="https://stable-baselines3.readthedocs.io/en/master/" rel="nofollow">StableBaselines3</a>, <a href="https://docs.cleanrl.dev/" rel="nofollow">CleanRL</a>, <a href="https://www.samplefactory.dev/" rel="nofollow">Sample Factory</a> and <a href="https://docs.ray.io/en/latest/rllib-algorithms.html" rel="nofollow">Ray RLLib</a></li> <li>Support for memory-based agents with LSTM or attention based interfaces</li> <li>Support for <em>2D and 3D games</em></li> <li>A suite of <em>AI sensors</em> to augment your agent’s capacity to observe the game world</li> <li>Godot and Godot RL Agents are <strong>completely free and open source under a very permissive MIT license</strong>. No strings attached, no royalties, nothing.</li>',xe,T,It='You can find out more about Godot RL agents on their <a href="https://github.com/edbeeching/godot_rl_agents" rel="nofollow">GitHub page</a> or their AAAI-2022 Workshop <a href="https://arxiv.org/abs/2112.03636" rel="nofollow">paper</a>. The library’s creator, <a href="https://edbeeching.github.io/" rel="nofollow">Ed Beeching</a>, is a Research Scientist here at Hugging Face.',_e,U,St="Installation of the library is simple: <code>pip install godot-rl</code>",Ce,j,Ze,J,kt="In this section, you will <strong>learn how to create a custom environment in the Godot Game Engine</strong> and then implement an AI controller that learns to play with Deep Reinforcement Learning.",Ie,G,Bt="The example game we create today is simple, <strong>but shows off many of the features of the Godot Engine and the Godot RL Agents library</strong>. You can then dive into the examples for more complex environments and behaviors.",Se,x,Rt="The environment we will be building today is called Ring Pong, the game of pong but the pitch is a ring and the paddle moves around the ring. The <strong>objective is to keep the ball bouncing inside the ring</strong>.",ke,_,Lt,Be,C,Re,Z,Wt='The <a href="https://godotengine.org/" rel="nofollow">Godot game engine</a> is an open source tool for the <strong>creation of video games, tools and user interfaces</strong>.',Le,I,Et="Godot Engine is a feature-packed, cross-platform game engine designed to create 2D and 3D games from a unified interface. It provides a comprehensive set of common tools, so users <strong>can focus on making games without having to reinvent the wheel</strong>. Games can be exported in one click to a number of platforms, including the major desktop platforms (Linux, macOS, Windows) as well as mobile (Android, iOS) and web-based (HTML5) platforms.",We,S,Xt='While we will guide you through the steps to implement your agent, you may wish to learn more about the Godot Game Engine. Their <a href="https://docs.godotengine.org/en/latest/index.html" rel="nofollow">documentation</a> is thorough, and there are many tutorials on YouTube we would also recommend <a href="https://www.gdquest.com/" rel="nofollow">GDQuest</a>, <a href="https://kidscancode.org/godot_recipes/4.x/" rel="nofollow">KidsCanCode</a> and <a href="https://www.youtube.com/channel/UCczi7Aq_dTKrQPF5ZV5J3gg" rel="nofollow">Bramwell</a> as sources of information.',Ee,k,$t="In order to create games in Godot, <strong>you must first download the editor</strong>. Godot RL Agents supports the latest version of Godot, Godot 4.0.",Xe,B,At="Which can be downloaded at the following links:",$e,R,Ht='<li><a href="https://downloads.tuxfamily.org/godotengine/4.0.1/Godot_v4.0.1-stable_win64.exe.zip" rel="nofollow">Windows</a></li> <li><a href="https://downloads.tuxfamily.org/godotengine/4.0.1/Godot_v4.0.1-stable_macos.universal.zip" rel="nofollow">Mac</a></li> <li><a href="https://downloads.tuxfamily.org/godotengine/4.0.1/Godot_v4.0.1-stable_linux.x86_64.zip" rel="nofollow">Linux</a></li>',Ae,L,He,W,Qt="We provide two versions of the codebase:",Qe,E,zt='<li><a href="https://drive.google.com/file/d/1C7xd3TibJHlxFEJPBgBLpksgxrFZ3D8e/view?usp=share_link" rel="nofollow">A starter project, to download and follow along for this tutorial</a></li> <li><a href="https://drive.google.com/file/d/1k-b2Bu7uIA6poApbouX4c3sq98xqogpZ/view?usp=share_link" rel="nofollow">A final version of the project, for comparison and debugging.</a></li>',ze,X,Nt="To load the project, in the Godot Project Manager click <strong>Import</strong>, navigate to where the files are located and load the <strong>project.godot</strong> file.",Ne,$,Yt="If you press F5 or play in the editor, you should be able to play the game in human mode. There are several instances of the game running, this is because we want to speed up training our AI agent with many parallel environments.",Ye,A,Fe,H,Ft="The Godot RL Agents plugin can be installed from the Github repo or with the Godot Asset Lib in the editor.",qe,Q,qt="First click on the AssetLib and search for “rl”",Ve,z,Vt,De,N,Dt='Then click on Godot RL Agents, click Download and unselect the LICIENSE and <a href="http://README.md" rel="nofollow">README.md</a> files. Then click install.',Pe,Y,Pt,Oe,F,Ot="The Godot RL Agents plugin is now downloaded to your machine your machine. Now click on Project → Project settings and enable the addon:",Ke,q,Kt,et,V,tt,D,el="We now want to add an AI controller to our game. Open the player.tscn scene, on the left you should see a hierarchy of nodes that looks like this:",lt,P,tl,nt,O,ll="Right click the <strong>Player</strong> node and click <strong>Add Child Node.</strong> There are many nodes listed here, search for AIController3D and create it.",st,K,nl,ot,ee,sl="The AI Controller Node should have been added to the scene tree, next to it is a scroll. Click on it to open the script that is attached to the AIController. The Godot game engine uses a scripting language called GDScript, which is syntactically similar to python. The script contains methods that need to be implemented in order to get our AI controller working.",at,te,it,le,ol="In order to implement these methods, we will need to create a class that inherits from AIController3D. This is easy to do in Godot, and is called “extending” a class.",rt,ne,al="Right click the AIController3D Node and click “Extend Script” and call the new script <code>controller.gd</code>. You should now have an almost empty script file that looks like this:",pt,se,ct,oe,il="We will now implement the 4 missing methods, delete this code, and replace it with the following:",ht,ae,dt,ie,rl="We have now defined the agent’s observation, which is the position and velocity of the ball in its local cooridinate space. We have also defined the action space of the agent, which is a single contuninous value ranging from -1 to +1.",mt,re,pl="The next step is to update the Player’s script to use the actions from the AIController, edit the Player’s script by clicking on the scroll next to the player node, update the code in <code>Player.gd</code> to the following the following:",ut,pe,Mt,ce,cl="We now need to synchronize between the game running in Godot and the neural network being trained in Python. Godot RL agents provides a node that does just that. Open the train.tscn scene, right click on the root node, and click “Add child node”. Then, search for “sync” and add a Godot RL Agents Sync node. This node handles the communication between Python and Godot over TCP.",gt,he,hl="You can run training live in the the editor, by first launching the python training with <code>gdrl</code>",ft,de,dl="In this simple example, a reasonable policy is learned in several minutes. You may wish to speed up training, click on the Sync node in the train scene and you will see there is a “Speed Up” property exposed in the editor:",wt,me,ml,yt,ue,ul="Try setting this property up to 8 to speed up training. This can be a great benefit on more complex environments, like the multi-player FPS we will learn about in the next chapter.",bt,Me,vt,ge,Ml='We have only scratched the surface of what can be achieved with Godot RL Agents, the library includes custom sensors and cameras to enrich the information available to the agent. Take a look at the <a href="https://github.com/edbeeching/godot_rl_agents_examples" rel="nofollow">examples</a> to find out more!',Tt,fe,Ut,we,gl='This section was written by <a href="https://twitter.com/edwardbeeching">Edward Beeching</a>',jt,ve,Jt;return w=new f({props:{title:"Godot RL Agents",local:"godot-rl-agents",headingTag:"h1"}}),j=new f({props:{title:"Create a custom RL environment with Godot RL Agents",local:"create-a-custom-rl-environment-with-godot-rl-agents",headingTag:"h2"}}),C=new f({props:{title:"Installing the Godot Game Engine",local:"installing-the-godot-game-engine",headingTag:"h3"}}),L=new f({props:{title:"Loading the starter project",local:"loading-the-starter-project",headingTag:"h3"}}),A=new f({props:{title:"Installing the Godot RL Agents plugin",local:"installing-the-godot-rl-agents-plugin",headingTag:"h3"}}),V=new f({props:{title:"Adding the AI controller",local:"adding-the-ai-controller",headingTag:"h3"}}),te=new Gt({props:{code:"JTIzLS0lMjBNZXRob2RzJTIwdGhhdCUyMG5lZWQlMjBpbXBsZW1lbnRpbmclMjB1c2luZyUyMHRoZSUyMCUyMmV4dGVuZCUyMHNjcmlwdCUyMiUyMG9wdGlvbiUyMGluJTIwR29kb3QlMjAtLSUyMyUwQWZ1bmMlMjBnZXRfb2JzKCklMjAtJTNFJTIwRGljdGlvbmFyeSUzQSUwQSUwOWFzc2VydChmYWxzZSUyQyUyMCUyMnRoZSUyMGdldF9vYnMlMjBtZXRob2QlMjBpcyUyMG5vdCUyMGltcGxlbWVudGVkJTIwd2hlbiUyMGV4dGVuZGluZyUyMGZyb20lMjBhaV9jb250cm9sbGVyJTIyKSUwQSUwOXJldHVybiUyMCU3QiUyMm9icyUyMiUzQSU1QiU1RCU3RCUwQSUwQWZ1bmMlMjBnZXRfcmV3YXJkKCklMjAtJTNFJTIwZmxvYXQlM0ElMEElMDlhc3NlcnQoZmFsc2UlMkMlMjAlMjJ0aGUlMjBnZXRfcmV3YXJkJTIwbWV0aG9kJTIwaXMlMjBub3QlMjBpbXBsZW1lbnRlZCUyMHdoZW4lMjBleHRlbmRpbmclMjBmcm9tJTIwYWlfY29udHJvbGxlciUyMiklMEElMDlyZXR1cm4lMjAwLjAlMEElMEFmdW5jJTIwZ2V0X2FjdGlvbl9zcGFjZSgpJTIwLSUzRSUyMERpY3Rpb25hcnklM0ElMEElMDlhc3NlcnQoZmFsc2UlMkMlMjAlMjJ0aGUlMjBnZXQlMjBnZXRfYWN0aW9uX3NwYWNlJTIwbWV0aG9kJTIwaXMlMjBub3QlMjBpbXBsZW1lbnRlZCUyMHdoZW4lMjBleHRlbmRpbmclMjBmcm9tJTIwYWlfY29udHJvbGxlciUyMiklMEElMDlyZXR1cm4lMjAlN0IlMEElMDklMDklMjJleGFtcGxlX2FjdGlvbnNfY29udGlub3VzJTIyJTIwJTNBJTIwJTdCJTBBJTA5JTA5JTA5JTIyc2l6ZSUyMiUzQSUyMDIlMkMlMEElMDklMDklMDklMjJhY3Rpb25fdHlwZSUyMiUzQSUyMCUyMmNvbnRpbnVvdXMlMjIlMEElMDklMDklN0QlMkMlMEElMDklMDklMjJleGFtcGxlX2FjdGlvbnNfZGlzY3JldGUlMjIlMjAlM0ElMjAlN0IlMEElMDklMDklMDklMjJzaXplJTIyJTNBJTIwMiUyQyUwQSUwOSUwOSUwOSUyMmFjdGlvbl90eXBlJTIyJTNBJTIwJTIyZGlzY3JldGUlMjIlMEElMDklMDklN0QlMkMlMEElMDklMDklN0QlMEElMEFmdW5jJTIwc2V0X2FjdGlvbihhY3Rpb24pJTIwLSUzRSUyMHZvaWQlM0ElMEElMDlhc3NlcnQoZmFsc2UlMkMlMjAlMjJ0aGUlMjBnZXQlMjBzZXRfYWN0aW9uJTIwbWV0aG9kJTIwaXMlMjBub3QlMjBpbXBsZW1lbnRlZCUyMHdoZW4lMjBleHRlbmRpbmclMjBmcm9tJTIwYWlfY29udHJvbGxlciUyMiklMEElMjMlMjAtLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLSUyMw==",highlighted:`<span class="hljs-comment">#-- Methods that need implementing using the &quot;extend script&quot; option in Godot --#</span>
func get_obs() -&gt; Dictionary:
	<span class="hljs-keyword">assert</span>(false, <span class="hljs-string">&quot;the get_obs method is not implemented when extending from ai_controller&quot;</span>)
	<span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;obs&quot;</span>:[]}

func get_reward() -&gt; <span class="hljs-built_in">float</span>:
	<span class="hljs-keyword">assert</span>(false, <span class="hljs-string">&quot;the get_reward method is not implemented when extending from ai_controller&quot;</span>)
	<span class="hljs-keyword">return</span> <span class="hljs-number">0.0</span>

func get_action_space() -&gt; Dictionary:
	<span class="hljs-keyword">assert</span>(false, <span class="hljs-string">&quot;the get get_action_space method is not implemented when extending from ai_controller&quot;</span>)
	<span class="hljs-keyword">return</span> {
		<span class="hljs-string">&quot;example_actions_continous&quot;</span> : {
			<span class="hljs-string">&quot;size&quot;</span>: <span class="hljs-number">2</span>,
			<span class="hljs-string">&quot;action_type&quot;</span>: <span class="hljs-string">&quot;continuous&quot;</span>
		},
		<span class="hljs-string">&quot;example_actions_discrete&quot;</span> : {
			<span class="hljs-string">&quot;size&quot;</span>: <span class="hljs-number">2</span>,
			<span class="hljs-string">&quot;action_type&quot;</span>: <span class="hljs-string">&quot;discrete&quot;</span>
		},
		}

func set_action(action) -&gt; void:
	<span class="hljs-keyword">assert</span>(false, <span class="hljs-string">&quot;the get set_action method is not implemented when extending from ai_controller&quot;</span>)
<span class="hljs-comment"># -----------------------------------------------------------------------------#</span>`,wrap:!1}}),se=new Gt({props:{code:"ZXh0ZW5kcyUyMEFJQ29udHJvbGxlcjNEJTBBJTBBJTIzJTIwQ2FsbGVkJTIwd2hlbiUyMHRoZSUyMG5vZGUlMjBlbnRlcnMlMjB0aGUlMjBzY2VuZSUyMHRyZWUlMjBmb3IlMjB0aGUlMjBmaXJzdCUyMHRpbWUuJTBBZnVuYyUyMF9yZWFkeSgpJTNBJTBBJTA5cGFzcyUyMCUyMyUyMFJlcGxhY2UlMjB3aXRoJTIwZnVuY3Rpb24lMjBib2R5LiUwQSUwQSUyMyUyMENhbGxlZCUyMGV2ZXJ5JTIwZnJhbWUuJTIwJ2RlbHRhJyUyMGlzJTIwdGhlJTIwZWxhcHNlZCUyMHRpbWUlMjBzaW5jZSUyMHRoZSUyMHByZXZpb3VzJTIwZnJhbWUuJTBBZnVuYyUyMF9wcm9jZXNzKGRlbHRhKSUzQSUwQSUwOXBhc3M=",highlighted:`extends AIController3D

<span class="hljs-comment"># Called when the node enters the scene tree for the first time.</span>
func _ready():
	<span class="hljs-keyword">pass</span> <span class="hljs-comment"># Replace with function body.</span>

<span class="hljs-comment"># Called every frame. &#x27;delta&#x27; is the elapsed time since the previous frame.</span>
func _process(delta):
	<span class="hljs-keyword">pass</span>`,wrap:!1}}),ae=new Gt({props:{code:"ZXh0ZW5kcyUyMEFJQ29udHJvbGxlcjNEJTBBJTBBJTIzJTIwU3RvcmVzJTIwdGhlJTIwYWN0aW9uJTIwc2FtcGxlZCUyMGZvciUyMHRoZSUyMGFnZW50J3MlMjBwb2xpY3klMkMlMjBydW5uaW5nJTIwaW4lMjBweXRob24lMEF2YXIlMjBtb3ZlX2FjdGlvbiUyMCUzQSUyMGZsb2F0JTIwJTNEJTIwMC4wJTBBJTBBZnVuYyUyMGdldF9vYnMoKSUyMC0lM0UlMjBEaWN0aW9uYXJ5JTNBJTBBJTA5JTIzJTIwZ2V0JTIwdGhlJTIwYmFsbHMlMjBwb3NpdGlvbiUyMGFuZCUyMHZlbG9jaXR5JTIwaW4lMjB0aGUlMjBwYWRkbGUncyUyMGZyYW1lJTIwb2YlMjByZWZlcmVuY2UlMEElMDl2YXIlMjBiYWxsX3BvcyUyMCUzRCUyMHRvX2xvY2FsKF9wbGF5ZXIuYmFsbC5nbG9iYWxfcG9zaXRpb24pJTBBJTA5dmFyJTIwYmFsbF92ZWwlMjAlM0QlMjB0b19sb2NhbChfcGxheWVyLmJhbGwubGluZWFyX3ZlbG9jaXR5KSUwQSUwOXZhciUyMG9icyUyMCUzRCUyMCU1QmJhbGxfcG9zLnglMkMlMjBiYWxsX3Bvcy56JTJDJTIwYmFsbF92ZWwueCUyRjEwLjAlMkMlMjBiYWxsX3ZlbC56JTJGMTAuMCU1RCUwQSUwQSUwOXJldHVybiUyMCU3QiUyMm9icyUyMiUzQW9icyU3RCUwQSUwQWZ1bmMlMjBnZXRfcmV3YXJkKCklMjAtJTNFJTIwZmxvYXQlM0ElMEElMDlyZXR1cm4lMjByZXdhcmQlMEElMEFmdW5jJTIwZ2V0X2FjdGlvbl9zcGFjZSgpJTIwLSUzRSUyMERpY3Rpb25hcnklM0ElMEElMDlyZXR1cm4lMjAlN0IlMEElMDklMDklMjJtb3ZlX2FjdGlvbiUyMiUyMCUzQSUyMCU3QiUwQSUwOSUwOSUwOSUyMnNpemUlMjIlM0ElMjAxJTJDJTBBJTA5JTA5JTA5JTIyYWN0aW9uX3R5cGUlMjIlM0ElMjAlMjJjb250aW51b3VzJTIyJTBBJTA5JTA5JTdEJTJDJTBBJTA5JTA5JTdEJTBBJTBBZnVuYyUyMHNldF9hY3Rpb24oYWN0aW9uKSUyMC0lM0UlMjB2b2lkJTNBJTBBJTA5bW92ZV9hY3Rpb24lMjAlM0QlMjBjbGFtcChhY3Rpb24lNUIlMjJtb3ZlX2FjdGlvbiUyMiU1RCU1QjAlNUQlMkMlMjAtMS4wJTJDJTIwMS4wKQ==",highlighted:`extends AIController3D

<span class="hljs-comment"># Stores the action sampled for the agent&#x27;s policy, running in python</span>
var move_action : <span class="hljs-built_in">float</span> = <span class="hljs-number">0.0</span>

func get_obs() -&gt; Dictionary:
	<span class="hljs-comment"># get the balls position and velocity in the paddle&#x27;s frame of reference</span>
	var ball_pos = to_local(_player.ball.global_position)
	var ball_vel = to_local(_player.ball.linear_velocity)
	var obs = [ball_pos.x, ball_pos.z, ball_vel.x/<span class="hljs-number">10.0</span>, ball_vel.z/<span class="hljs-number">10.0</span>]

	<span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;obs&quot;</span>:obs}

func get_reward() -&gt; <span class="hljs-built_in">float</span>:
	<span class="hljs-keyword">return</span> reward

func get_action_space() -&gt; Dictionary:
	<span class="hljs-keyword">return</span> {
		<span class="hljs-string">&quot;move_action&quot;</span> : {
			<span class="hljs-string">&quot;size&quot;</span>: <span class="hljs-number">1</span>,
			<span class="hljs-string">&quot;action_type&quot;</span>: <span class="hljs-string">&quot;continuous&quot;</span>
		},
		}

func set_action(action) -&gt; void:
	move_action = clamp(action[<span class="hljs-string">&quot;move_action&quot;</span>][<span class="hljs-number">0</span>], -<span class="hljs-number">1.0</span>, <span class="hljs-number">1.0</span>)`,wrap:!1}}),pe=new Gt({props:{code:"ZXh0ZW5kcyUyME5vZGUzRCUwQSUwQSU0MGV4cG9ydCUyMHZhciUyMHJvdGF0aW9uX3NwZWVkJTIwJTNEJTIwMy4wJTBBJTQwb25yZWFkeSUyMHZhciUyMGJhbGwlMjAlM0QlMjBnZXRfbm9kZSglMjIuLiUyRkJhbGwlMjIpJTBBJTQwb25yZWFkeSUyMHZhciUyMGFpX2NvbnRyb2xsZXIlMjAlM0QlMjAlMjRBSUNvbnRyb2xsZXIzRCUwQSUwQWZ1bmMlMjBfcmVhZHkoKSUzQSUwQSUwOWFpX2NvbnRyb2xsZXIuaW5pdChzZWxmKSUwQSUwQWZ1bmMlMjBnYW1lX292ZXIoKSUzQSUwQSUwOWFpX2NvbnRyb2xsZXIuZG9uZSUyMCUzRCUyMHRydWUlMEElMDlhaV9jb250cm9sbGVyLm5lZWRzX3Jlc2V0JTIwJTNEJTIwdHJ1ZSUwQSUwQWZ1bmMlMjBfcGh5c2ljc19wcm9jZXNzKGRlbHRhKSUzQSUwQSUwOWlmJTIwYWlfY29udHJvbGxlci5uZWVkc19yZXNldCUzQSUwQSUwOSUwOWFpX2NvbnRyb2xsZXIucmVzZXQoKSUwQSUwOSUwOWJhbGwucmVzZXQoKSUwQSUwOSUwOXJldHVybiUwQSUwQSUwOXZhciUyMG1vdmVtZW50JTIwJTNBJTIwZmxvYXQlMEElMDlpZiUyMGFpX2NvbnRyb2xsZXIuaGV1cmlzdGljJTIwJTNEJTNEJTIwJTIyaHVtYW4lMjIlM0ElMEElMDklMDltb3ZlbWVudCUyMCUzRCUyMElucHV0LmdldF9heGlzKCUyMnJvdGF0ZV9hbnRpY2xvY2t3aXNlJTIyJTJDJTIwJTIycm90YXRlX2Nsb2Nrd2lzZSUyMiklMEElMDllbHNlJTNBJTBBJTA5JTA5bW92ZW1lbnQlMjAlM0QlMjBhaV9jb250cm9sbGVyLm1vdmVfYWN0aW9uJTBBJTA5cm90YXRlX3kobW92ZW1lbnQqZGVsdGEqcm90YXRpb25fc3BlZWQpJTBBJTBBZnVuYyUyMF9vbl9hcmVhXzNkX2JvZHlfZW50ZXJlZChib2R5KSUzQSUwQSUwOWFpX2NvbnRyb2xsZXIucmV3YXJkJTIwJTJCJTNEJTIwMS4w",highlighted:`extends Node3D

<span class="hljs-meta">@export var rotation_speed = <span class="hljs-number">3.0</span></span>
<span class="hljs-meta">@onready var ball = get_node(<span class="hljs-params"><span class="hljs-string">&quot;../Ball&quot;</span></span>)</span>
<span class="hljs-meta">@onready var ai_controller = $AIController3D</span>

func _ready():
	ai_controller.init(self)

func game_over():
	ai_controller.done = true
	ai_controller.needs_reset = true

func _physics_process(delta):
	<span class="hljs-keyword">if</span> ai_controller.needs_reset:
		ai_controller.reset()
		ball.reset()
		<span class="hljs-keyword">return</span>

	var movement : <span class="hljs-built_in">float</span>
	<span class="hljs-keyword">if</span> ai_controller.heuristic == <span class="hljs-string">&quot;human&quot;</span>:
		movement = Input.get_axis(<span class="hljs-string">&quot;rotate_anticlockwise&quot;</span>, <span class="hljs-string">&quot;rotate_clockwise&quot;</span>)
	<span class="hljs-keyword">else</span>:
		movement = ai_controller.move_action
	rotate_y(movement*delta*rotation_speed)

func _on_area_3d_body_entered(body):
	ai_controller.reward += <span class="hljs-number">1.0</span>`,wrap:!1}}),Me=new f({props:{title:"There’s more!",local:"theres-more",headingTag:"h3"}}),fe=new f({props:{title:"Author",local:"author",headingTag:"h2"}}),{c(){g=a("meta"),Te=s(),be=a("p"),Ue=s(),c(w.$$.fragment),je=s(),y=a("p"),y.innerHTML=_t,Je=s(),b=a("p"),b.textContent=Ct,Ge=s(),v=a("ul"),v.innerHTML=Zt,xe=s(),T=a("p"),T.innerHTML=It,_e=s(),U=a("p"),U.innerHTML=St,Ce=s(),c(j.$$.fragment),Ze=s(),J=a("p"),J.innerHTML=kt,Ie=s(),G=a("p"),G.innerHTML=Bt,Se=s(),x=a("p"),x.innerHTML=Rt,ke=s(),_=a("img"),Be=s(),c(C.$$.fragment),Re=s(),Z=a("p"),Z.innerHTML=Wt,Le=s(),I=a("p"),I.innerHTML=Et,We=s(),S=a("p"),S.innerHTML=Xt,Ee=s(),k=a("p"),k.innerHTML=$t,Xe=s(),B=a("p"),B.textContent=At,$e=s(),R=a("ul"),R.innerHTML=Ht,Ae=s(),c(L.$$.fragment),He=s(),W=a("p"),W.textContent=Qt,Qe=s(),E=a("ul"),E.innerHTML=zt,ze=s(),X=a("p"),X.innerHTML=Nt,Ne=s(),$=a("p"),$.textContent=Yt,Ye=s(),c(A.$$.fragment),Fe=s(),H=a("p"),H.textContent=Ft,qe=s(),Q=a("p"),Q.textContent=qt,Ve=s(),z=a("img"),De=s(),N=a("p"),N.innerHTML=Dt,Pe=s(),Y=a("img"),Oe=s(),F=a("p"),F.textContent=Ot,Ke=s(),q=a("img"),et=s(),c(V.$$.fragment),tt=s(),D=a("p"),D.textContent=el,lt=s(),P=a("img"),nt=s(),O=a("p"),O.innerHTML=ll,st=s(),K=a("img"),ot=s(),ee=a("p"),ee.textContent=sl,at=s(),c(te.$$.fragment),it=s(),le=a("p"),le.textContent=ol,rt=s(),ne=a("p"),ne.innerHTML=al,pt=s(),c(se.$$.fragment),ct=s(),oe=a("p"),oe.textContent=il,ht=s(),c(ae.$$.fragment),dt=s(),ie=a("p"),ie.textContent=rl,mt=s(),re=a("p"),re.innerHTML=pl,ut=s(),c(pe.$$.fragment),Mt=s(),ce=a("p"),ce.textContent=cl,gt=s(),he=a("p"),he.innerHTML=hl,ft=s(),de=a("p"),de.textContent=dl,wt=s(),me=a("img"),yt=s(),ue=a("p"),ue.textContent=ul,bt=s(),c(Me.$$.fragment),vt=s(),ge=a("p"),ge.innerHTML=Ml,Tt=s(),c(fe.$$.fragment),Ut=s(),we=a("p"),we.innerHTML=gl,jt=s(),ve=a("p"),this.h()},l(e){const t=Ul("svelte-u9bgzb",document.head);g=i(t,"META",{name:!0,content:!0}),t.forEach(l),Te=o(e),be=i(e,"P",{}),fl(be).forEach(l),Ue=o(e),h(w.$$.fragment,e),je=o(e),y=i(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-2p47v5"&&(y.innerHTML=_t),Je=o(e),b=i(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1py9j1o"&&(b.textContent=Ct),Ge=o(e),v=i(e,"UL",{"data-svelte-h":!0}),r(v)!=="svelte-fbxqzk"&&(v.innerHTML=Zt),xe=o(e),T=i(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-f5k4w1"&&(T.innerHTML=It),_e=o(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1tilrrq"&&(U.innerHTML=St),Ce=o(e),h(j.$$.fragment,e),Ze=o(e),J=i(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-j43km5"&&(J.innerHTML=kt),Ie=o(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1bia7ve"&&(G.innerHTML=Bt),Se=o(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-18kdqtx"&&(x.innerHTML=Rt),ke=o(e),_=i(e,"IMG",{src:!0,alt:!0}),Be=o(e),h(C.$$.fragment,e),Re=o(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-12z31zk"&&(Z.innerHTML=Wt),Le=o(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-15j420f"&&(I.innerHTML=Et),We=o(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-11gpv3q"&&(S.innerHTML=Xt),Ee=o(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-sbxy1m"&&(k.innerHTML=$t),Xe=o(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1qow1fz"&&(B.textContent=At),$e=o(e),R=i(e,"UL",{"data-svelte-h":!0}),r(R)!=="svelte-113hcwa"&&(R.innerHTML=Ht),Ae=o(e),h(L.$$.fragment,e),He=o(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-4xjw3c"&&(W.textContent=Qt),Qe=o(e),E=i(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-14f47bb"&&(E.innerHTML=zt),ze=o(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-n5pdey"&&(X.innerHTML=Nt),Ne=o(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-82774z"&&($.textContent=Yt),Ye=o(e),h(A.$$.fragment,e),Fe=o(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1czivbr"&&(H.textContent=Ft),qe=o(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1mue8hu"&&(Q.textContent=qt),Ve=o(e),z=i(e,"IMG",{src:!0,alt:!0}),De=o(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-lujuq9"&&(N.innerHTML=Dt),Pe=o(e),Y=i(e,"IMG",{src:!0,alt:!0}),Oe=o(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-15nk9bg"&&(F.textContent=Ot),Ke=o(e),q=i(e,"IMG",{src:!0,alt:!0}),et=o(e),h(V.$$.fragment,e),tt=o(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1k1rgr4"&&(D.textContent=el),lt=o(e),P=i(e,"IMG",{src:!0,alt:!0}),nt=o(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-wi5wbl"&&(O.innerHTML=ll),st=o(e),K=i(e,"IMG",{src:!0,alt:!0}),ot=o(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-g41mxc"&&(ee.textContent=sl),at=o(e),h(te.$$.fragment,e),it=o(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1nxuc10"&&(le.textContent=ol),rt=o(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-10r5ldp"&&(ne.innerHTML=al),pt=o(e),h(se.$$.fragment,e),ct=o(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1bzu5xq"&&(oe.textContent=il),ht=o(e),h(ae.$$.fragment,e),dt=o(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-mym9fn"&&(ie.textContent=rl),mt=o(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-wxjevn"&&(re.innerHTML=pl),ut=o(e),h(pe.$$.fragment,e),Mt=o(e),ce=i(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-vvgyl6"&&(ce.textContent=cl),gt=o(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-cbe1vr"&&(he.innerHTML=hl),ft=o(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1wvpaln"&&(de.textContent=dl),wt=o(e),me=i(e,"IMG",{src:!0,alt:!0}),yt=o(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1da9kc0"&&(ue.textContent=ul),bt=o(e),h(Me.$$.fragment,e),vt=o(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-w6yf05"&&(ge.innerHTML=Ml),Tt=o(e),h(fe.$$.fragment,e),Ut=o(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-11016ov"&&(we.innerHTML=gl),jt=o(e),ve=i(e,"P",{}),fl(ve).forEach(l),this.h()},h(){p(g,"name","hf:doc:metadata"),p(g,"content",Gl),ye(_.src,Lt="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/ringpong.gif")||p(_,"src",Lt),p(_,"alt","Ring Pong"),ye(z.src,Vt="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/godot1.png")||p(z,"src",Vt),p(z,"alt","Godot"),ye(Y.src,Pt="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/godot2.png")||p(Y,"src",Pt),p(Y,"alt","Godot"),ye(q.src,Kt="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/godot3.png")||p(q,"src",Kt),p(q,"alt","Godot"),ye(P.src,tl="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/godot4.png")||p(P,"src",tl),p(P,"alt","Godot"),ye(K.src,nl="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/godot5.png")||p(K,"src",nl),p(K,"alt","Godot"),ye(me.src,ml="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/godot6.png")||p(me,"src",ml),p(me,"alt","Godot")},m(e,t){jl(document.head,g),n(e,Te,t),n(e,be,t),n(e,Ue,t),d(w,e,t),n(e,je,t),n(e,y,t),n(e,Je,t),n(e,b,t),n(e,Ge,t),n(e,v,t),n(e,xe,t),n(e,T,t),n(e,_e,t),n(e,U,t),n(e,Ce,t),d(j,e,t),n(e,Ze,t),n(e,J,t),n(e,Ie,t),n(e,G,t),n(e,Se,t),n(e,x,t),n(e,ke,t),n(e,_,t),n(e,Be,t),d(C,e,t),n(e,Re,t),n(e,Z,t),n(e,Le,t),n(e,I,t),n(e,We,t),n(e,S,t),n(e,Ee,t),n(e,k,t),n(e,Xe,t),n(e,B,t),n(e,$e,t),n(e,R,t),n(e,Ae,t),d(L,e,t),n(e,He,t),n(e,W,t),n(e,Qe,t),n(e,E,t),n(e,ze,t),n(e,X,t),n(e,Ne,t),n(e,$,t),n(e,Ye,t),d(A,e,t),n(e,Fe,t),n(e,H,t),n(e,qe,t),n(e,Q,t),n(e,Ve,t),n(e,z,t),n(e,De,t),n(e,N,t),n(e,Pe,t),n(e,Y,t),n(e,Oe,t),n(e,F,t),n(e,Ke,t),n(e,q,t),n(e,et,t),d(V,e,t),n(e,tt,t),n(e,D,t),n(e,lt,t),n(e,P,t),n(e,nt,t),n(e,O,t),n(e,st,t),n(e,K,t),n(e,ot,t),n(e,ee,t),n(e,at,t),d(te,e,t),n(e,it,t),n(e,le,t),n(e,rt,t),n(e,ne,t),n(e,pt,t),d(se,e,t),n(e,ct,t),n(e,oe,t),n(e,ht,t),d(ae,e,t),n(e,dt,t),n(e,ie,t),n(e,mt,t),n(e,re,t),n(e,ut,t),d(pe,e,t),n(e,Mt,t),n(e,ce,t),n(e,gt,t),n(e,he,t),n(e,ft,t),n(e,de,t),n(e,wt,t),n(e,me,t),n(e,yt,t),n(e,ue,t),n(e,bt,t),d(Me,e,t),n(e,vt,t),n(e,ge,t),n(e,Tt,t),d(fe,e,t),n(e,Ut,t),n(e,we,t),n(e,jt,t),n(e,ve,t),Jt=!0},p:yl,i(e){Jt||(m(w.$$.fragment,e),m(j.$$.fragment,e),m(C.$$.fragment,e),m(L.$$.fragment,e),m(A.$$.fragment,e),m(V.$$.fragment,e),m(te.$$.fragment,e),m(se.$$.fragment,e),m(ae.$$.fragment,e),m(pe.$$.fragment,e),m(Me.$$.fragment,e),m(fe.$$.fragment,e),Jt=!0)},o(e){u(w.$$.fragment,e),u(j.$$.fragment,e),u(C.$$.fragment,e),u(L.$$.fragment,e),u(A.$$.fragment,e),u(V.$$.fragment,e),u(te.$$.fragment,e),u(se.$$.fragment,e),u(ae.$$.fragment,e),u(pe.$$.fragment,e),u(Me.$$.fragment,e),u(fe.$$.fragment,e),Jt=!1},d(e){e&&(l(Te),l(be),l(Ue),l(je),l(y),l(Je),l(b),l(Ge),l(v),l(xe),l(T),l(_e),l(U),l(Ce),l(Ze),l(J),l(Ie),l(G),l(Se),l(x),l(ke),l(_),l(Be),l(Re),l(Z),l(Le),l(I),l(We),l(S),l(Ee),l(k),l(Xe),l(B),l($e),l(R),l(Ae),l(He),l(W),l(Qe),l(E),l(ze),l(X),l(Ne),l($),l(Ye),l(Fe),l(H),l(qe),l(Q),l(Ve),l(z),l(De),l(N),l(Pe),l(Y),l(Oe),l(F),l(Ke),l(q),l(et),l(tt),l(D),l(lt),l(P),l(nt),l(O),l(st),l(K),l(ot),l(ee),l(at),l(it),l(le),l(rt),l(ne),l(pt),l(ct),l(oe),l(ht),l(dt),l(ie),l(mt),l(re),l(ut),l(Mt),l(ce),l(gt),l(he),l(ft),l(de),l(wt),l(me),l(yt),l(ue),l(bt),l(vt),l(ge),l(Tt),l(Ut),l(we),l(jt),l(ve)),l(g),M(w,e),M(j,e),M(C,e),M(L,e),M(A,e),M(V,e),M(te,e),M(se,e),M(ae,e),M(pe,e),M(Me,e),M(fe,e)}}}const Gl='{"title":"Godot RL Agents","local":"godot-rl-agents","sections":[{"title":"Create a custom RL environment with Godot RL Agents","local":"create-a-custom-rl-environment-with-godot-rl-agents","sections":[{"title":"Installing the Godot Game Engine","local":"installing-the-godot-game-engine","sections":[],"depth":3},{"title":"Loading the starter project","local":"loading-the-starter-project","sections":[],"depth":3},{"title":"Installing the Godot RL Agents plugin","local":"installing-the-godot-rl-agents-plugin","sections":[],"depth":3},{"title":"Adding the AI controller","local":"adding-the-ai-controller","sections":[],"depth":3},{"title":"There’s more!","local":"theres-more","sections":[],"depth":3}],"depth":2},{"title":"Author","local":"author","sections":[],"depth":2}],"depth":1}';function xl(xt){return bl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Sl extends vl{constructor(g){super(),Tl(this,g,xl,Jl,wl,{})}}export{Sl as component};
